local fn = _gn(0xB51194800B257161)
--- Create a camera with the specified cam name/type, You can use `SET_CAM_` natives to manipulate the camera.
-- Camera names found in the b617d scripts:
-- ```
-- "DEFAULT_ANIMATED_CAMERA"
-- "DEFAULT_SCRIPTED_CAMERA"
-- "DEFAULT_SCRIPTED_FLY_CAMERA"
-- "DEFAULT_SPLINE_CAMERA"
-- ```
-- @param camName Is the type of the camera, is always setted to `DEFAULT_SCRIPTED_CAMERA` in Rockstar scripts and in Fivem Forum Posts
-- @param posX The x position of the camera (you can also send a vector3 instead of the bulk coordinates)
-- @param posY The y position of the camera (you can also send a vector3 instead of the bulk coordinates)
-- @param posZ The z position of the camera (you can also send a vector3 instead of the bulk coordinates)
-- @param rotX The x rotation of the camera
-- @param rotY The y rotation of the camera
-- @param rotZ The z rotation of the camera
-- @param fov The Field Of View of the camera, is the observable world that is seen
-- @return A camera handle.
function Global.CreateCamWithParams(camName, posX, posY, posZ, rotX, rotY, rotZ, fov, active, rotationOrder)
	return _in2(fn, _ts(camName), posX, posY, posZ, rotX, rotY, rotZ, fov, active, rotationOrder, _ri)
end
