local fn = _gn(0xbd6357d)
--- Adjusts the offset of the specified wheel relative to the wheel's axle center.
-- Needs to be called every frame in order to function properly, as GTA will reset the offset otherwise.
-- This function can be especially useful to set the track width of a vehicle, for example:
-- ```
-- function SetVehicleFrontTrackWidth(vehicle, width)
-- SetVehicleWheelXOffset(vehicle, 0, -width/2)
-- SetVehicleWheelXOffset(vehicle, 1, width/2)
-- end
-- ```
function Global.SetVehicleWheelXOffset(vehicle, wheelIndex, offset)
	return _in2(fn, vehicle, wheelIndex, offset)
end
