local fn = _gn(0x63C6CCA8E68AE8C8)
--- Train models must be [requested](#\_0x963D27A58DF860AC) before use. See trains.xml (located in `Grand Theft Auto V\update\update.rpf\common\data\levels\gta5\trains.xml`) for freight and metro variations.
-- Model names to request can be found by searching `model_name` in the file.
-- The `Lua` usage example provided down below has been provided in such way so users can test each and every train variation.
-- ### Newly added parameters (seen in 2372 build)
-- ```
-- NativeDB Added Parameter 6: BOOL isNetwork
-- NativeDB Added Parameter 7: BOOL netMissionEntity
-- ```
-- *   **isNetwork**: Whether to create a network object for the train. If false, the train exists only locally.
-- *   **netMissionEntity**: Whether to register the train as pinned to the script host in the R\* network model.
-- ### Train Models:
-- *   freight
-- ### Carriage Models:
-- *   freightcar
-- *   freightcar2 (Added v2372)
-- *   freightcont1
-- *   freightcont2
-- *   freightgrain
-- *   metrotrain
-- *   tankercar
-- ### Some train variations (default from trains.xml as of build 2372)
-- *   17. Very long train and freight variation.
-- *   18. Freight train only.
-- *   25. Double metro train (with both models flipped opposite to each other). This used to be `24` before the 2372 build.
-- @param variation The variation id, these can range from 0 to 25 as of build 2372.
-- @param x Spawn coordinate X component.
-- @param y Spawn coordinate Y component.
-- @param z Spawn coordinate Z component.
-- @param direction The direction in which the train will go (true or false)
-- @return A script handle (fwScriptGuid index) for the train, or 0 if the train failed to be created.
function Global.CreateMissionTrain(variation, x, y, z, direction)
	return _in2(fn, variation, x, y, z, direction, _ri)
end
