local fn = _gn(0xB51194800B257161)
--- Create a camera with the specified cam name/type, You can use `SET_CAM_` natives to manipulate the camera.
-- Take a look at [CREATE_CAM](#\_0xC3981DCE61D9E13F) if you would like to see the available camera names.
-- @param camName A string representing the camera type, the game will convert the string into a joaat hash upon native execution.
-- @param posX The x position of the camera (you can also send a vector3 instead of the bulk coordinates)
-- @param posY The y position of the camera (you can also send a vector3 instead of the bulk coordinates)
-- @param posZ The z position of the camera (you can also send a vector3 instead of the bulk coordinates)
-- @param rotX The x rotation of the camera
-- @param rotY The y rotation of the camera
-- @param rotZ The z rotation of the camera
-- @param fov The Field Of View of the camera, is the observable world that is seen
-- @param active Set to true if you wish to make this new camera the active camera.
-- @param rotationOrder The order of rotation, see [`GET_ENTITY_ROTATION`](#\_0xAFBD61CC738D9EB9)
-- @return A camera handle.
function Global.CreateCamWithParams(camName, posX, posY, posZ, rotX, rotY, rotZ, fov, active, rotationOrder)
	return _in2(fn, _ts(camName), posX, posY, posZ, rotX, rotY, rotZ, fov, active, rotationOrder, _ri)
end
