local fn = _gn(0xF8C397922FC03F41)
--- Returns the convertible state of the specified vehicle.
-- ```cpp
-- enum RoofState
-- {
-- ROOFSTATE_UP = 0,
-- ROOFSTATE_LOWERING = 1,
-- ROOFSTATE_DOWN = 2,
-- ROOFSTATE_RAISING = 3
-- };
-- ```
-- @param vehicle Vehicle to get the state of
-- @return *   0 when closed/up, the vehicle is not a convertible or the vehicle is null/not provided
-- 		*   1 when closing
-- 		*   2 when open/down
-- 		*   3 when opening
-- 		*   6 unknown/unverified -- possibly stopped but not full open
function Global.GetConvertibleRoofState(vehicle)
	return _in2(fn, vehicle, _ri)
end
