local fn = _gn(0x7EE9F5D83DD4F90E)
--- Asynchronously starts a line-of-sight (raycast) world probe shape test.
-- ```cpp
-- enum TraceFlags
-- {
-- None = 0,
-- IntersectWorld = 1,
-- IntersectVehicles = 2,
-- IntersectPedsSimpleCollision = 4,
-- IntersectPeds = 8,
-- IntersectObjects = 16,
-- IntersectWater = 32,
-- Unknown = 128,
-- IntersectFoliage = 256,
-- IntersectEverything = 4294967295
-- }
-- ```
-- NOTE: Raycasts that intersect with mission_entites (flag = 2) has limited range and will not register for far away entites. The range seems to be about 30 metres.
-- Use the handle with [GET_SHAPE_TEST_RESULT](#\_0x3D87450E15D98694) or [GET_SHAPE_TEST_RESULT_INCLUDING_MATERIAL](#\_0x65287525D951F6BE) until it returns 0 or 2.
-- @param x1 Starting X coordinate.
-- @param y1 Starting Y coordinate.
-- @param z1 Starting Z coordinate.
-- @param x2 Ending X coordinate.
-- @param y2 Ending Y coordinate.
-- @param z2 Ending Z coordinate.
-- @param flags Flags.
-- @param entity An entity to ignore, or 0.
-- @param p8 A bit mask with bits 1, 2, 4, or 7 relating to collider types. 4 and 7 are usually used.
-- @return A shape test handle.
function Global.N_0x7ee9f5d83dd4f90e(x1, y1, z1, x2, y2, z2, flags, entity, p8)
	return _in2(fn, x1, y1, z1, x2, y2, z2, flags, entity, p8, _ri)
end
