local fn = _gn(0xDC0F817884CDD856)
--- Enables or disables the specified 'dispatch service' type. 'Dispatch services' are used for spawning AI response peds/vehicles for events such as a fire in the street (type 3 - DT_FireDepartment), or gunfire in a gang area (type 11 - DT_Gangs).
-- List of dispatch services:
-- ```cpp
-- enum DispatchType
-- {
-- DT_Invalid = 0,
-- DT_PoliceAutomobile,
-- DT_PoliceHelicopter,
-- DT_FireDepartment,
-- DT_SwatAutomobile,
-- DT_AmbulanceDepartment,
-- DT_PoliceRiders,
-- DT_PoliceVehicleRequest,
-- DT_PoliceRoadBlock,
-- DT_PoliceAutomobileWaitPulledOver,
-- DT_PoliceAutomobileWaitCruising,
-- DT_Gangs,
-- DT_SwatHelicopter,
-- DT_PoliceBoat,
-- DT_ArmyVehicle,
-- DT_BikerBackup = 15
-- };
-- ```
-- Note that 'dispatch service' has nothing to do with the police scanner (audio), to toggle that, use [SET_AUDIO_FLAG](#\_0xB9EFD5C25018725A) with `'PoliceScannerDisabled'`.
-- @param dispatchService The ID of the dispatch service to toggle.
-- @param toggle True to enable the dispatch service, false to disable the dispatch service.
function Global.N_0xdc0f817884cdd856(dispatchService, toggle)
	return _in2(fn, dispatchService, toggle)
end
