local fn = _gn(0xeb2edca2)
--- Draws a gizmo. This function supports SDK infrastructure and is not intended to be used directly from your code.
-- This should be used from JavaScript or another language supporting mutable buffers like ArrayBuffer.
-- Matrix layout is as follows:
-- *   Element \[0], \[1] and \[2] should represent the right vector.
-- *   Element \[4], \[5] and \[6] should represent the forward vector.
-- *   Element \[8], \[9] and \[10] should represent the up vector.
-- *   Element \[12], \[13] and \[14] should represent X, Y and Z translation coordinates.
-- *   All other elements should be \[0, 0, 0, 1].
-- @param matrixPtr A mutable pointer to a 64-byte buffer of floating-point values, representing an XMFLOAT4X4 in layout.
-- @param id A unique identifier of what the gizmo is affecting.
-- @return Whether or not the matrix was modified.
function Global.DrawGizmo(matrixPtr, id)
	return _in2(fn, matrixPtr, _ts(id), _r)
end
