local fn = _gn(0x1CCD9A37359072CF)
--- Sets some extra options for a notification. It adds an image (or icon type) and sets a notification title (sender) and subtitle (subject).
-- Texture dictionary and texture name parameters are usually the same exact value.
-- Example result:
-- ![](https://i.imgur.com/LviutDl.png)
-- Old description with list of possible icons and texture names:
-- ```
-- List of picNames: pastebin.com/XdpJVbHz
-- flash is a bool for fading in.
-- iconTypes:
-- 1 : Chat Box
-- 2 : Email
-- 3 : Add Friend Request
-- 4 : Nothing
-- 5 : Nothing
-- 6 : Nothing
-- 7 : Right Jumping Arrow
-- 8 : RP Icon
-- 9 : $ Icon
-- "sender" is the very top header. This can be any old string.
-- "subject" is the header under the sender.
-- ```
-- @param textureDict The texture dictionary for the icon.
-- @param textureName The texture name for the icon.
-- @param flash Flash, doesn't seem to work no matter what.
-- @param iconType The icon type, see the list in the description below.
-- @param sender The notification title.
-- @param subject The notification subtitle.
-- @return The notification handle.
function Global.SetNotificationMessage(textureDict, textureName, flash, iconType, sender, subject)
	return _in2(fn, _ts(textureDict), _ts(textureName), flash, iconType, _ts(sender), _ts(subject), _ri)
end
