local fn = _gn(0xF1B760881820C952)
--- Returns the distance between two three-dimensional points, optionally ignoring the Z values.
-- If useZ is false, only the 2D plane (X-Y) will be considered for calculating the distance.
-- Consider using this faster native instead: SYSTEM::VDIST - DVIST always takes in consideration the 3D coordinates.
-- @param x1 The X coordinate of the first point.
-- @param y1 The Y coordinate of the first point.
-- @param z1 The Z coordinate of the first point.
-- @param x2 The X coordinate of the second point.
-- @param y2 The Y coordinate of the second point.
-- @param z2 The Z coordinate of the second point.
-- @param useZ Whether or not to use the Z coordinate.
-- @return The distance between the passed points in units.
function Global.GetDistanceBetweenCoords(x1, y1, z1, x2, y2, z2, useZ)
	return _in2(fn, x1, y1, z1, x2, y2, z2, useZ, _rf)
end
