local fn = _gn(0x239A3351AC1DA385)
--- Teleports an entity to specified coordinates directly, with options to maintain certain behaviors post-teleportation.
-- **Note**:
-- *   This native allows precise placement of entities without the usual adjustments for collision or interaction with the environment that may occur with other teleportation natives.
-- *   The `keepTasks` and `keepIK` parameters are specifically useful for maintaining the current state of a ped, ensuring actions or animations are not abruptly stopped due to the teleportation.
-- *   Setting `doWarp` to `false` is useful when simulating continuous movement or when the entity should interact with its immediate surroundings upon arrival.
-- @param entity The entity to reposition.
-- @param x X coordinate for the new position.
-- @param y Y coordinate for the new position.
-- @param z Z coordinate for the new position.
-- @param keepTasks If `true`, the tasks currently assigned to the ped are not removed upon teleportation. Applies only to peds.
-- @param keepIK If `true`, the Inverse Kinematics (IK) on the ped are not reset upon teleportation. Applies only to peds.
-- @param doWarp If `false`, the entity will maintain continuous motion and will not clear contacts nor create space for itself upon teleportation.
function Global.SetEntityCoordsNoOffset(entity, x, y, z, keepTasks, keepIK, doWarp)
	return _in2(fn, entity, x, y, z, keepTasks, keepIK, doWarp)
end
