local fn = _gn(0x45F35C0EDC33B03B)
--- Adds a map entity to a network synchronized scene. This native function is utilized only once as of game build 2944 within the casino_slots script.
-- Please note that it's only possible to add a single map entity to synchronised scenes.
-- It's advisable to initially locate the object and retrieve its actual coordinates using [`GET_CLOSEST_OBJECT_OF_TYPE`](#\_0xE143FA2249364369).
-- ```
-- NativeDB Introduced: v1734
-- ```
-- @param netScene Net scene ID returned by [`NETWORK_CREATE_SYNCHRONISED_SCENE`](#\_0x7CD6BC4C2BBDD526)
-- @param modelHash Model hash of the object the script should look for.
-- @param x Object X coord.
-- @param y Object Y coord.
-- @param z Object Z coord.
-- @param animDict Anim dictionary to play on this object.
-- @param animName Anim name to play on this object.
-- @param blendInSpeed Float representing how quickly the animation should be blended into. Default is `8.0`.
-- @param blendOutSpeed Float representing how quickly the animation should be blended out of. Default is `-8.0`
-- @param flags See [`NETWORK_ADD_PED_TO_SYNCHRONISED_SCENE`](#\_0x742A637471BCECD9).
function Global.NetworkAddMapEntityToSynchronisedScene(netScene, modelHash, x, y, z, animDict, animName, blendInSpeed, blendOutSpeed, flags)
	return _in2(fn, netScene, _ch(modelHash), x, y, z, _ts(animDict), _ts(animName), blendInSpeed, blendOutSpeed, flags)
end
