local fn = _gn(0x9E82F0F362881B29)
--- Determines the highest ground Z-coordinate directly below a specified 3D coordinate, excluding any objects at that point. Optionally, water can be considered as ground when determining the highest point.
-- ```
-- NativeDB Added Parameter 6: BOOL ignoreDistToWaterLevelCheck - If set to true, the distance to the water level will be ignored when checking for water as ground.
-- ```
-- ```
-- NativeDB Introduced: v505
-- ```
-- @param x X-coordinate of the point to check.
-- @param y Y-coordinate of the point to check.
-- @param z Z-coordinate of the point to check.
-- @param groundZ A pointer to a float where the ground Z-coordinate will be stored if found.
-- @param waterAsGround If set to `true`, water will be included in the check, and its height will be returned if it is higher than the ground level.
-- @return Returns `true` if ground (or water, if specified) is found below the given coordinates, otherwise `false`.
function Global.GetGroundZFor_3dCoord_2(x, y, z, waterAsGround)
	return _in2(fn, x, y, z, _f, waterAsGround, _r)
end
