local fn = _gn(0xAFBD61CC738D9EB9)
--- ```
-- rotationOrder refers to the order yaw pitch roll is applied; value ranges from 0 to 5 and is usually *2* in scripts.
-- What you use for rotationOrder when getting must be the same as rotationOrder when setting the rotation.
-- What it returns is the yaw on the z part of the vector, which makes sense considering R* considers z as vertical. Here's a picture for those of you who don't understand pitch, yaw, and roll:
-- www.allstar.fiu.edu/aero/images/pic5-1.gif
-- ```
-- ### Rotation Orders
-- *   **0**: ZYX - Rotate around the z-axis, then the y-axis and finally the x-axis.
-- *   **1**: YZX - Rotate around the y-axis, then the z-axis and finally the x-axis.
-- *   **2**: ZXY - Rotate around the z-axis, then the x-axis and finally the y-axis.
-- *   **3**: XZY - Rotate around the x-axis, then the z-axis and finally the y-axis.
-- *   **4**: YXZ - Rotate around the y-axis, then the x-axis and finally the z-axis.
-- *   **5**: XYZ - Rotate around the x-axis, then the y-axis and finally the z-axis.
-- @param entity The entity to get the rotation for.
-- @param rotationOrder The order yaw, pitch and roll is applied. Usually 2.
-- @return A vector where the Z coordinate is the yaw.
function Global.GetEntityRotation(entity, rotationOrder)
	return _in2(fn, entity, rotationOrder, _rv)
end
