local fn = _gn(0x15D3A79D4E44B913)
--- Sometimes a path may not be able to be found. This could happen because there simply isn't any way to get there, or maybe a bunch of dynamic objects have blocked the way,
-- or maybe the destination is too far away. In this case the ped will simply stand still.
-- To identify when this has happened, you can use GET_NAVMESH_ROUTE_RESULT. This will help you find situations where peds cannot get to their target.
-- ```cpp
-- enum eNavScriptFlags {
-- ENAV_DEFAULT = 0, // Default flag
-- ENAV_NO_STOPPING = 1, // Will ensure the ped continues to move whilst waiting for the path to be found, and will not slow down at the end of their route.
-- ENAV_ADV_SLIDE_TO_COORD_AND_ACHIEVE_HEADING_AT_END = 2, // Performs a slide-to-coord at the end of the task. This requires that the accompanying NAVDATA structure has the 'SlideToCoordHeading' member set correctly.
-- ENAV_GO_FAR_AS_POSSIBLE_IF_TARGET_NAVMESH_NOT_LOADED = 4, // If the navmesh is not loaded in under the target position, then this will cause the ped to get as close as is possible on whatever navmesh is loaded. The navmesh must still be loaded at the path start.
-- ENAV_ALLOW_SWIMMING_UNDERWATER = 8, // Will allow navigation underwater - by default this is not allowed.
-- ENAV_KEEP_TO_PAVEMENTS = 16, // Will only allow navigation on pavements. If the path starts or ends off the pavement, the command will fail. Likewise if no pavement-only route can be found even although the start and end are on pavement.
-- ENAV_NEVER_ENTER_WATER = 32, // Prevents the path from entering water at all.
-- ENAV_DONT_AVOID_OBJECTS = 64, // Disables object-avoidance for this path. The ped may still make minor steering adjustments to avoid objects, but will not pathfind around them.
-- ENAV_ADVANCED_USE_MAX_SLOPE_NAVIGABLE = 128, // Specifies that the navmesh route will only be able to traverse up slopes which are under the angle specified, in the MaxSlopeNavigable member of the accompanying NAVDATA structure.
-- ENAV_STOP_EXACTLY = 512, // Unused.
-- ENAV_ACCURATE_WALKRUN_START = 1024, // The entity will look ahead in its path for a longer distance to make the walk/run start go more in the right direction.
-- ENAV_DONT_AVOID_PEDS = 2048, // Disables ped-avoidance for this path while we move.
-- ENAV_DONT_ADJUST_TARGET_POSITION = 4096, // If target pos is inside the boundingbox of an object it will otherwise be pushed out.
-- ENAV_SUPPRESS_EXACT_STOP = 8192, // Turns off the default behaviour, which is to stop exactly at the target position. Occasionally this can cause footsliding/skating problems.
-- ENAV_ADVANCED_USE_CLAMP_MAX_SEARCH_DISTANCE = 16384, // Prevents the path-search from finding paths outside of this search distance. This can be used to prevent peds from finding long undesired routes.
-- ENAV_PULL_FROM_EDGE_EXTRA = 32768 // Pulls out the paths from edges at corners for a longer distance, to prevent peds walking into stuff.
-- };
-- ```
-- @param ped Ped Index.
-- @param x X Position Coordinate.
-- @param y Y Position Coordinate.
-- @param z Z Position Coordinate
-- @param moveBlendRatio Ratio for ped movement (0 to 3.0 in the following order: still, walk, run and sprint)
-- @param time INT value in milliseconds.
-- @param radius distance from the final coordinates that the pedestrian should be to consider itself at the target.
-- @param flags Navigation Flags for the ped (see `eNavScriptFlags`).
-- @param finalHeading Peds heading when finished.
function Global.TaskFollowNavMeshToCoord(ped, x, y, z, moveBlendRatio, time, radius, flags, finalHeading)
	return _in2(fn, ped, x, y, z, moveBlendRatio, time, radius, flags, finalHeading)
end
