local fn = _gn(0xFCD5C8E06E502F5A)
--- Creates a navmesh blocking object, vehicles will avoid driving through this area.
-- Only 32 blocking objects may exist at a given time and must be manually managed. See [`REMOVE_NAVMESH_BLOCKING_OBJECT`](#\_0x46399A7895957C0E) and [`onResourceStop`](https://docs.fivem.net/docs/scripting-reference/events/list/onResourceStop/)
-- ```
-- enum eBlockingObjectFlags {
-- BLOCKING_OBJECT_DEFAULT = 0,      // Default Flag
-- BLOCKING_OBJECT_WANDERPATH = 1,   // Blocking object will block wander paths
-- BLOCKING_OBJECT_SHORTESTPATH = 2, // Blocking object will block (regular) shortest-paths
-- BLOCKING_OBJECT_FLEEPATH = 4,     // Blocking object will block flee paths
-- BLOCKING_OBJECT_ALLPATHS = 7,     // Blocking object will block all paths
-- }
-- ```
-- @param x The x coordinate to create the block on.
-- @param y The y coordinate.
-- @param z The z coordinate.
-- @param width The width of the block.
-- @param length The length of the block.
-- @param height The height of the block.
-- @param heading The heading of object in degrees.
-- @param bPermanent A boolean indicating if the blocking object is permanent (`true`/`false`).
-- @param flags Flag for the blocking object, refer to `eBlockingObjectFlags`.
function Global.AddNavmeshBlockingObject(x, y, z, width, length, height, heading, bPermanent, flags)
	return _in2(fn, x, y, z, width, length, height, heading, bPermanent, flags, _ri)
end
