local fn = _gn(0xEA23C49EAA83ACFB)
--- Revives our local player who was previously dead.
-- **Note:** Call this once you resurrect the player (this does not need to be called every frame).
-- ```cpp
-- enum ePlayerSpawnLocation {
-- SPAWN_LOCATION_AUTOMATIC = 0, // system will decide
-- SPAWN_LOCATION_NEAR_DEATH,
-- SPAWN_LOCATION_NEAR_TEAM_MATES,
-- SPAWN_LOCATION_MISSION_AREA, // script defined area
-- SPAWN_LOCATION_NEAR_OTHER_PLAYERS,
-- SPAWN_LOCATION_NEAR_CURRENT_POSITION,
-- SPAWN_LOCATION_AT_CURRENT_POSITION,
-- SPAWN_LOCATION_NET_TEST_BED,
-- SPAWN_LOCATION_CUSTOM_SPAWN_POINTS,
-- SPAWN_LOCATION_OUTSIDE_SIMEON_GARAGE,
-- SPAWN_LOCATION_NEAR_SPECIFIC_COORDS,
-- SPAWN_LOCATION_AT_SPECIFIC_COORDS,
-- SPAWN_LOCATION_AT_AIRPORT_ARRIVALS,
-- SPAWN_LOCATION_AT_SPECIFIC_COORDS_IF_POSSIBLE,
-- SPAWN_LOCATION_IN_SPECIFIC_ANGLED_AREA,
-- SPAWN_LOCATION_NEAREST_RESPAWN_POINT,
-- SPAWN_LOCATION_AT_SPECIFIC_COORDS_RACE_CORONA,
-- SPAWN_LOCATION_INSIDE_GARAGE,
-- SPAWN_LOCATION_INSIDE_PROPERTY,
-- SPAWN_LOCATION_INSIDE_PROPERTY_OR_GARAGE,
-- SPAWN_LOCATION_NEAR_DEATH_IMPROMPTU,
-- SPAWN_LOCATION_NEAR_CURRENT_POSITION_SPREAD_OUT,
-- SPAWN_LOCATION_NEAREST_RESPAWN_POINT_TO_SPECIFIC_COORDS,
-- SPAWN_LOCATION_NEAREST_HOSPITAL,
-- SPAWN_LOCATION_NEAREST_POLICE_STATION,
-- SPAWN_LOCATION_NEAREST_HOTEL_TO_SPECIFIC_COORDS,
-- SPAWN_LOCATION_MISSION_AREA_NEAR_CURRENT_POSITION,
-- SPAWN_LOCATION_PRIVATE_YACHT,
-- SPAWN_LOCATION_PRIVATE_YACHT_APARTMENT,
-- SPAWN_LOCATION_PRIVATE_FRIEND_YACHT,
-- SPAWN_LOCATION_PRIVATE_YACHT_NEAR_SHORE,
-- SPAWN_LOCATION_NEAR_GANG_BOSS,
-- SPAWN_LOCATION_NEAR_SPECIFIC_COORDS_WITH_GANG,
-- SPAWN_LOCATION_GANG_DM,
-- SPAWN_LOCATION_GANG_BOSS_PRIVATE_YACHT,
-- SPAWN_LOCATION_OFFICE,
-- SPAWN_LOCATION_CLUBHOUSE,
-- SPAWN_LOCATION_NEAR_CURRENT_POSITION_AS_POSSIBLE,
-- SPAWN_LOCATION_NEAR_CURRENT_PERCEIVED_POSITION,
-- SPAWN_LOCATION_IE_WAREHOUSE,
-- SPAWN_LOCATION_BUNKER,
-- SPAWN_LOCATION_HANGAR,
-- SPAWN_LOCATION_DEFUNCT_BASE,
-- SPAWN_LOCATION_NIGHTCLUB,
-- SPAWN_LOCATION_ARENA_GARAGE,
-- SPAWN_LOCATION_CASINO,
-- SPAWN_LOCATION_CASINO_APARTMENT,
-- SPAWN_LOCATION_CASINO_OUTSIDE,
-- SPAWN_LOCATION_ARCADE,
-- SPAWN_LOCATION_CASINO_NIGHTCLUB,
-- SPAWN_LOCATION_SUBMARINE,
-- SPAWN_LOCATION_HEIST_ISLAND_NEAR_DEATH,
-- SPAWN_LOCATION_HEIST_ISLAND_BEACH_PARTY,
-- SPAWN_LOCATION_LAND_NEAR_SUBMARINE,
-- SPAWN_LOCATION_CAR_MEET,
-- SPAWN_LOCATION_AUTO_SHOP,
-- SPAWN_LOCATION_FIXER_HQ,
-- SPAWN_LOCATION_SITTING_SMOKING,
-- SPAWN_LOCATION_DRUNK_WAKE_UP_MUSIC_STUDIO,
-- SPAWN_LOCATION_MUSIC_STUDIO,
-- TOTAL_SPAWN_LOCATIONS
-- };
-- ```
-- ```cpp
-- enum eSpawnReason {
-- SPAWN_REASON_DEATH = 0,
-- SPAWN_REASON_TRANSITION,
-- SPAWN_REASON_MANUAL,
-- SPAWN_REASON_RESTORE_CHARACTER,
-- SPAWN_REASON_IN_VEHICLE
-- };
-- ```
-- ### Added parameters
-- *   **bUnpauseRenderPhases**: This boolean parameter will unpause the render phases when set to `true`.
-- *   **iSpawnLocation**: This integer parameter sets the player's spawn location metric for telemetry. See `ePlayerSpawnLocation` enum.
-- *   **iSpawnReason**: This integer parameter sets the player's spawn reason metric for telemetry. See `eSpawnReason` enum.
-- @param nInvincibilityTime This is the length of time in milliseconds that the player will be invincible for after resurrection.
-- @param bLeaveDeadPed Leaves the dead ped behind when resurrecting.
function Global.NetworkResurrectLocalPlayer(x, y, z, heading, nInvincibilityTime, bLeaveDeadPed)
	return _in2(fn, x, y, z, heading, nInvincibilityTime, bLeaveDeadPed)
end
