local fn = _gn(0xB13C14F66A00D047)
--- Adjusts the field of view (FOV) for a specified camera, allowing for a wider or narrower perspective of the game world. The field of view is measured in degrees and affects how much of the game world is visible at any given moment through the camera.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param cam The camera whose FOV is being set.
-- @param fieldOfView The new FOV value, in degrees. Valid range is from `1.0f` (minimum FOV, for a very narrow view) to `130.0f` (maximum FOV, for a very wide view).
function Global.SetCamFov(cam, fieldOfView)
	return _in2(fn, cam, fieldOfView)
end
