local fn = _gn(0xF56DFB7B61BE7276)
--- Determines whether a line segment intersects a plane and, if so, returns the parameter value at which this intersection occurs.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param x1 The X-coordinate of the first point of the line segment.
-- @param y1 The Y-coordinate of the first point of the line segment.
-- @param z1 The Z-coordinate of the first point of the line segment. Together, `x1`, `y1`, and `z1` define the starting point of the line segment.
-- @param x2 The X-coordinate of the second point of the line segment.
-- @param y2 The Y-coordinate of the second point of the line segment.
-- @param z2 The Z-coordinate of the second point of the line segment. Together, `x2`, `y2`, and `z2` define the ending point of the line segment.
-- @param planeX The X-coordinate of a point on the plane. This, along with `planeY` and `planeZ`, specifies a point that lies on the plane's surface.
-- @param planeY The Y-coordinate of a point on the plane.
-- @param planeZ The Z-coordinate of a point on the plane.
-- @param planeNormalX The X-component of the plane's normal vector. The normal vector is perpendicular to the plane's surface and defines its orientation.
-- @param planeNormalY The Y-component of the plane's normal vector.
-- @param planeNormalZ The Z-component of the plane's normal vector. Together, `planeNormalX`, `planeNormalY`, and `planeNormalZ` fully describe the plane's orientation in 3D space.
-- @param intersectionParameter A pointer to a float. This parameter is used to return the value of `t` at which the line segment intersects the plane. The value of `t` is a scalar multiplier that can be used to calculate the exact intersection point on the line segment. If the line does not intersect the plane, the value of `t` is not meaningful.
-- @return Returns `true` if the line segment intersects the plane, in which case the `intersectionParameter` will contain the intersection point's parameter value. Returns `false` if there is no intersection, making the `intersectionParameter` value irrelevant.
function Global.GetLinePlaneIntersection(x1, y1, z1, x2, y2, z2, planeX, planeY, planeZ, planeNormalX, planeNormalY, planeNormalZ, intersectionParameter)
	return _in2(fn, x1, y1, z1, x2, y2, z2, planeX, planeY, planeZ, planeNormalX, planeNormalY, planeNormalZ, _fi(intersectionParameter) --[[ may be optional ]], _r)
end
