local fn = _gn(0x26E13D440E7F6064)
--- Prevents a vehicle from exploding upon sustaining body damage from physical collisions. This can be used to increase the durability of vehicles in high-impact scenarios, such as races or combat situations, by preventing them from being destroyed due to collision-induced body damage.
-- For helicopters, you might want to check [`SET_DISABLE_HELI_EXPLODE_FROM_BODY_DAMAGE`](#\_0xEDBC8405B3895CC9) instead.
-- ```
-- NativeDB Introduced: v1290
-- ```
-- @param vehicle The vehicle to apply this setting to.
-- @param disableExplode `true` to disable explosion from body damage on collision; `false` to allow explosions as normal.
function Global.SetDisableExplodeFromBodyDamageOnCollision(vehicle, disableExplode)
	return _in2(fn, vehicle, disableExplode)
end
