const _i = Citizen.pointerValueInt();
const _f = Citizen.pointerValueFloat();
const _v = Citizen.pointerValueVector();
const _r = Citizen.returnResultAnyway();
const _ri = Citizen.resultAsInteger();
const _rf = Citizen.resultAsFloat();
const _rl = Citizen.resultAsLong();
const _s = Citizen.resultAsString();
const _rv = Citizen.resultAsVector();
const _ro = Citizen.resultAsObject();
const _in = Citizen.invokeNativeByHash;
const _ii = Citizen.pointerValueIntInitialized;
const _fi = Citizen.pointerValueFloatInitialized;
function _ch(hash) {
	if (typeof hash === 'string') {
		return window.GetHashKey(hash);
	}

	return hash;
}

function _ts(num) {
	if (num === 0 || num === null || num === undefined || num === false) { // workaround for users calling string parameters with '0', also nil being translated
		return null;
	}
	if (ArrayBuffer.isView(num) || num instanceof ArrayBuffer) { // these are handled as strings internally
		return num;
	}
	return num.toString();
}
function _fv(flt) {
	return flt + 0.0000001;
}

function _mfr(fn) {
	return Citizen.makeRefFunction(fn);
}

const _ENV = null;

/**
 * Aborts the current message in the text chat.
 */
window.AbortTextChat = function () {
	return _in(0x1ac8f4ad, 0x40e22127);
};

window.Absf = function (value) {
	return _in(0x73d57cff, 0xdd12c355, _fv(value), _r, _rf);
};

window.Absi = function (value) {
	return _in(0xf0d31ad1, 0x91a74f87, value, _r, _ri);
};

/**
 * Returns arccos value of p0.
 */
window.Acos = function (p0) {
	return _in(0x1d08b970, 0x013c34b6, _fv(p0), _r, _rf);
};

window.ActivateDamageTrackerOnNetworkId = function (netID, p1) {
	return _in(0xd45b1ffc, 0xcd52ff19, netID, p1);
};

/**
 * Does stuff like this:
 * gyazo.com/7fcb78ea3520e3dbc5b2c0c0f3712617
 * Example:
 * int GetHash = GET_HASH_KEY("fe_menu_version_corona_lobby");
 * ACTIVATE_FRONTEND_MENU(GetHash, 0, -1);
 * BOOL p1 is a toggle to define the game in pause.
 * int p2 is unknown but -1 always works, not sure why though.
 * [30/03/2017] ins1de :
 * the int p2 is actually a component variable. When the pause menu is visible, it opens the tab related to it.
 * Example : Function.Call(Hash.ACTIVATE_FRONTEND_MENU,-1171018317, 0, 42);
 * Result : Opens the "Online" tab without pausing the menu, with -1 it opens the map.
 */
window.ActivateFrontendMenu = function (menuhash, Toggle_Pause, component) {
	return _in(0xef01d36b, 0x9c9d0c7b, _ch(menuhash), Toggle_Pause, component);
};

/**
 * seems to be frequently used with the NETWORK::NET_TO_x natives, particularly with vehicles. It is often the only ROPE:: native in a script.
 */
window.ActivatePhysics = function (entity) {
	return _in(0x710311ad, 0xf0e20730, entity);
};

/**
 * Show Rockstar Editor Menu
 * by I'm Not MentaL
 * ----------
 * "new_editor" menu
 */
window.ActivateRockstarEditor = function () {
	return _in(0x49da8145, 0x672b2725);
};
window.N_0x49da8145672b2725 = window.ActivateRockstarEditor;

window.AddAmmoToPed = function (ped, weaponHash, ammo) {
	return _in(0x78f0424c, 0x34306220, ped, _ch(weaponHash), ammo);
};

/**
 * Same as SET_PED_ARMOUR, but ADDS 'amount' to the armor the Ped already has.
 */
window.AddArmourToPed = function (ped, amount) {
	return _in(0x5ba652a0, 0xcd14df2f, ped, amount);
};

/**
 * Adds a rectangular blip for the specified coordinates/area.
 * It is recommended to use [SET_BLIP_ROTATION](#_0xF87683CDF73C3F6E) and [SET_BLIP_COLOUR](#_0x03D7FB09E75D6B7E) to make the blip not rotate along with the camera.
 * By default, the blip will show as a _regular_ blip with the specified color/sprite if it is outside of the minimap view.
 * Example image:
 * ![minimap](https://w.wew.wtf/pdcjig.png)
 * ![big map](https://w.wew.wtf/zgcjcm.png)
 * (Native name is _likely_ to actually be ADD_BLIP_FOR_AREA, but due to the usual reasons this can't be confirmed)
 * @param x The X coordinate of the center of the blip.
 * @param y The Y coordinate of the center of the blip.
 * @param z The Z coordinate of the center of the blip.
 * @param width The width of the blip.
 * @param height The height of the blip.
 * @return A handle to the blip.
 */
window.AddBlipForArea = function (x, y, z, width, height) {
	return _in(0xce5d0e5e, 0x315db238, _fv(x), _fv(y), _fv(z), _fv(width), _fv(height), _r, _ri);
};
window.N_0xce5d0e5e315db238 = window.AddBlipForArea;

/**
 * Creates a blip for the specified coordinates. You can use `SET_BLIP_` natives to change the blip.
 * @param x The X coordinate to create the blip on.
 * @param y The Y coordinate.
 * @param z The Z coordinate.
 * @return A blip handle.
 */
window.AddBlipForCoord = function (x, y, z) {
	return _in(0x5a039bb0, 0xbca604b6, _fv(x), _fv(y), _fv(z), _r, _ri);
};

/**
 * Returns red ( default ) blip attached to entity.
 * Example:
 * Blip blip; //Put this outside your case or option
 * blip = UI::ADD_BLIP_FOR_ENTITY(YourPedOrBodyguardName);
 * UI::SET_BLIP_AS_FRIENDLY(blip, true);
 */
window.AddBlipForEntity = function (entity) {
	return _in(0x5cde92c7, 0x02a8fce7, entity, _r, _ri);
};

window.AddBlipForPickup = function (pickup) {
	return _in(0xbe339365, 0xc863bd36, pickup, _r, _ri);
};

window.AddBlipForRadius = function (posX, posY, posZ, radius) {
	return _in(0x46818d79, 0xb1f7499a, _fv(posX), _fv(posY), _fv(posZ), _fv(radius), _r, _ri);
};

/**
 * I filled p1-p6 (the floats) as they are as other natives with 6 floats in a row are similar and I see no other method. So if a test from anyone proves them wrong please correct.
 * p7 (length) determines the length of the spline, affects camera path and duration of transition between previous node and this one
 * p8 big values ~100 will slow down the camera movement before reaching this node
 * p9 != 0 seems to override the rotation/pitch (bool?)
 */
window.AddCamSplineNode = function (camera, x, y, z, xRot, yRot, zRot, length, p8, transitionType) {
	return _in(0x8609c75e, 0xc438fb3b, camera, _fv(x), _fv(y), _fv(z), _fv(xRot), _fv(yRot), _fv(zRot), length, p8, transitionType);
};

/**
 * Now has 15 parameters, previous declaration:
 * BOOL _0x428BDCB9DA58DA53(Any p0, Any p1, Any p2, float p3, float p4, float p5, float p6, float p7, float p8, float p9, float p10, float p11, float p12, Any p13)
 * boneIndex is always chassis_dummy in the scripts. The x/y/z params are location relative to the chassis bone. They are usually rotations and measurements. Haven't reversed which are what yet.
 * Scale is how big the decal will be.
 * p13 is always 0.
 * For alpha, 200 seems to match what the game is doing, I think. I don't have access to the new scripts to see what this parameter is, but based on guessing this seems (kind of) accurate.
 */
window.AddClanDecalToVehicle = function (vehicle, ped, boneIndex, x1, x2, x3, y1, y2, y3, z1, z2, z3, scale, p13, alpha) {
	return _in(0x428bdcb9, 0xda58da53, vehicle, ped, boneIndex, _fv(x1), _fv(x2), _fv(x3), _fv(y1), _fv(y2), _fv(y3), _fv(z1), _fv(z2), _fv(z3), _fv(scale), p13, alpha, _r);
};

window.AddCoverBlockingArea = function (playerX, playerY, playerZ, radiusX, radiusY, radiusZ, p6, p7, p8, p9) {
	return _in(0x45c59709, 0x7dd7cb81, _fv(playerX), _fv(playerY), _fv(playerZ), _fv(radiusX), _fv(radiusY), _fv(radiusZ), p6, p7, p8, p9);
};

window.AddCoverPoint = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0xd5c12a75, 0xc7b9497f, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, p5, p6, p7, _r, _ri);
};

window.AddCurrentRise = function (xLow, yLow, xHigh, yHigh, height) {
	return _in(0xfdbf4cdb, 0xc07e1706, _fv(xLow), _fv(yLow), _fv(xHigh), _fv(yHigh), _fv(height), _r, _ri);
};
window.N_0xfdbf4cdbc07e1706 = window.AddCurrentRise;

/**
 * decal types:
 * public enum DecalTypes
 * {
 * splatters_blood = 1010,
 * splatters_blood_dir = 1015,
 * splatters_blood_mist = 1017,
 * splatters_mud = 1020,
 * splatters_paint = 1030,
 * splatters_water = 1040,
 * splatters_water_hydrant = 1050,
 * splatters_blood2 = 1110,
 * weapImpact_metal = 4010,
 * weapImpact_concrete = 4020,
 * weapImpact_mattress = 4030,
 * weapImpact_mud = 4032,
 * weapImpact_wood = 4050,
 * weapImpact_sand = 4053,
 * weapImpact_cardboard = 4040,
 * weapImpact_melee_glass = 4100,
 * weapImpact_glass_blood = 4102,
 * weapImpact_glass_blood2 = 4104,
 * weapImpact_shotgun_paper = 4200,
 * weapImpact_shotgun_mattress,
 * weapImpact_shotgun_metal,
 * weapImpact_shotgun_wood,
 * weapImpact_shotgun_dirt,
 * weapImpact_shotgun_tvscreen,
 * weapImpact_shotgun_tvscreen2,
 * weapImpact_shotgun_tvscreen3,
 * weapImpact_melee_concrete = 4310,
 * weapImpact_melee_wood = 4312,
 * weapImpact_melee_metal = 4314,
 * burn1 = 4421,
 * burn2,
 * burn3,
 * burn4,
 * burn5,
 * bang_concrete_bang = 5000,
 * bang_concrete_bang2,
 * bang_bullet_bang,
 * bang_bullet_bang2 = 5004,
 * bang_glass = 5031,
 * bang_glass2,
 * solidPool_water = 9000,
 * solidPool_blood,
 * solidPool_oil,
 * solidPool_petrol,
 * solidPool_mud,
 * porousPool_water,
 * porousPool_blood,
 * porousPool_oil,
 * porousPool_petrol,
 * porousPool_mud,
 * porousPool_water_ped_drip,
 * liquidTrail_water = 9050
 * }
 */
window.AddDecal = function (decalType, posX, posY, posZ, p4, p5, p6, p7, p8, p9, width, height, rCoef, gCoef, bCoef, opacity, timeout, p17, p18, p19) {
	return _in(0xb302244a, 0x1839bdad, decalType, _fv(posX), _fv(posY), _fv(posZ), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), _fv(p9), _fv(width), _fv(height), _fv(rCoef), _fv(gCoef), _fv(bCoef), _fv(opacity), _fv(timeout), p17, p18, p19, _r, _ri);
};

/**
 * REQUEST_STREAMED_TEXTURE_DICT("MPOnMissMarkers", false);
 * *uParam0.f_809 = add_decal(9120, vParam1, vVar4, vVar7, 2f, 2f, to_float(iVar0) / 255f, to_float(iVar1) / 255f, to_float(iVar2) / 255f, 1f, -1f, 1, 0, 0);
 * _0x8A35C742130C6080(9120, "MPOnMissMarkers", "Capture_The_Flag_Base_Icon");
 */
window.AddDecalToMarker = function (decalType, textureDict, textureName) {
	return _in(0x8a35c742, 0x130c6080, decalType, _ts(textureDict), _ts(textureName));
};
window.N_0x8a35c742130c6080 = window.AddDecalToMarker;

window.AddDoorToSystem = function (doorHash, modelHash, x, y, z, p5, p6, p7) {
	return _in(0x6f8838d0, 0x3d1dc226, _ch(doorHash), _ch(modelHash), _fv(x), _fv(y), _fv(z), p5, p6, p7);
};

/**
 * Example:
 * GRAPHICS::ADD_ENTITY_ICON(a_0, "MP_Arrow");
 * I tried this and nothing happened...
 */
window.AddEntityIcon = function (entity, icon) {
	return _in(0x9cd43eee, 0x12bf4dd0, entity, _ts(icon), _r, _ri);
};

/**
 * BOOL isAudible = If explosion makes a sound.
 * BOOL isInvisible = If the explosion is invisible or not.
 * this native is missing a new argument: noDamage
 * nodamage = false: damage || nodamage = true: no damage
 * enum ExplosionTypes
 * {
 * EXPLOSION_GRENADE,
 * EXPLOSION_GRENADELAUNCHER,
 * EXPLOSION_STICKYBOMB,
 * EXPLOSION_MOLOTOV,
 * EXPLOSION_ROCKET,
 * EXPLOSION_TANKSHELL,
 * EXPLOSION_HI_OCTANE,
 * EXPLOSION_CAR,
 * EXPLOSION_PLANE,
 * EXPLOSION_PETROL_PUMP,
 * EXPLOSION_BIKE,
 * EXPLOSION_DIR_STEAM,
 * EXPLOSION_DIR_FLAME,
 * EXPLOSION_DIR_WATER_HYDRANT,
 * EXPLOSION_DIR_GAS_CANISTER,
 * EXPLOSION_BOAT,
 * EXPLOSION_SHIP_DESTROY,
 * EXPLOSION_TRUCK,
 * EXPLOSION_BULLET,
 * EXPLOSION_SMOKEGRENADELAUNCHER,
 * EXPLOSION_SMOKEGRENADE,
 * EXPLOSION_BZGAS,
 * EXPLOSION_FLARE,
 * EXPLOSION_GAS_CANISTER,
 * EXPLOSION_EXTINGUISHER,
 * EXPLOSION_PROGRAMMABLEAR,
 * EXPLOSION_TRAIN,
 * EXPLOSION_BARREL,
 * EXPLOSION_PROPANE,
 * EXPLOSION_BLIMP,
 * EXPLOSION_DIR_FLAME_EXPLODE,
 * EXPLOSION_TANKER,
 * EXPLOSION_PLANE_ROCKET,
 * EXPLOSION_VEHICLE_BULLET,
 * EXPLOSION_GAS_TANK,
 * EXPLOSION_BIRD_CRAP
 * };
 */
window.AddExplosion = function (x, y, z, explosionType, damageScale, isAudible, isInvisible, cameraShake) {
	return _in(0xe3ad2bdb, 0xaee269ac, _fv(x), _fv(y), _fv(z), explosionType, _fv(damageScale), isAudible, isInvisible, _fv(cameraShake));
};

window.AddExplosionWithUserVfx = function (x, y, z, explosionType, explosionFx, damageScale, isAudible, isInvisible, cameraShake) {
	return _in(0x36dd3fe5, 0x8b5e5212, _fv(x), _fv(y), _fv(z), explosionType, _ch(explosionFx), _fv(damageScale), isAudible, isInvisible, _fv(cameraShake));
};
window.AddSpecfxExplosion = window.AddExplosionWithUserVfx;

/**
 * Returns the index of the newly created hospital spawn point.
 * p3 might be radius?
 */
window.AddHospitalRestart = function (x, y, z, p3, p4) {
	return _in(0x1f464ef9, 0x88465a81, _fv(x), _fv(y), _fv(z), _fv(p3), p4, _r, _ri);
};

/**
 * NOTE: ones that are -1, 0 - 35 are determined by a function where it gets a TextLabel from a global then runs,
 * _GET_TEXT_SUBSTRING and depending on what the result is it goes in check order of 0 - 9 then A - Z then z (lowercase). So it will then return 0 - 35 or -1 if it's 'z'. The func to handle that ^^ is func_67 in dialog_handler.c atleast in TU27 Xbox360 scripts.
 * p0 is -1, 0
 * p1 is a char or string (whatever you wanna call it)
 * p2 is Global 10597 + i * 6. 'i' is a while(i < 70) loop
 * p3 is again -1, 0 - 35
 * p4 is again -1, 0 - 35
 * p5 is either 0 or 1 (bool ?)
 * p6 is either 0 or 1 (The func to determine this is bool)
 * p7 is either 0 or 1 (The func to determine this is bool)
 * p8 is either 0 or 1 (The func to determine this is bool)
 * p9 is 0 - 3 (Determined by func_60 in dialogue_handler.c)
 * p10 is either 0 or 1 (The func to determine this is bool)
 * p11 is either 0 or 1 (The func to determine this is bool)
 * p12 is unknown as in TU27 X360 scripts it only goes to p11.
 */
window.AddLineToConversation = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12) {
	return _in(0xc5ef9634, 0x05593646, p0, _ts(p1), _ts(p2), p3, p4, p5, p6, p7, p8, p9, p10, p11, p12);
};

/**
 * Loads a minimap overlay from a GFx file in the current resource.
 * @param name The path to a `.gfx` file in the current resource. It has to be specified as a `file`.
 * @return A minimap overlay ID.
 */
window.AddMinimapOverlay = function (name) {
	return _in(0x00000000, 0x4afd2499, _ts(name), _r, _ri);
};

window.AddNavmeshBlockingObject = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0xfcd5c8e0, 0x6e502f5a, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, p8, _r, _ri);
};

window.AddNavmeshRequiredRegion = function (x, y, radius) {
	return _in(0x387ead7e, 0xe42f6685, _fv(x), _fv(y), _fv(radius));
};

/**
 * hash collision?
 */
window.AddNextMessageToPreviousBriefs = function (p0) {
	return _in(0x60296af4, 0xba14abc5, p0);
};

/**
 * enum ExplosionTypes
 * {
 * EXPLOSION_GRENADE,
 * EXPLOSION_GRENADELAUNCHER,
 * EXPLOSION_STICKYBOMB,
 * EXPLOSION_MOLOTOV,
 * EXPLOSION_ROCKET,
 * EXPLOSION_TANKSHELL,
 * EXPLOSION_HI_OCTANE,
 * EXPLOSION_CAR,
 * EXPLOSION_PLANE,
 * EXPLOSION_PETROL_PUMP,
 * EXPLOSION_BIKE,
 * EXPLOSION_DIR_STEAM,
 * EXPLOSION_DIR_FLAME,
 * EXPLOSION_DIR_WATER_HYDRANT,
 * EXPLOSION_DIR_GAS_CANISTER,
 * EXPLOSION_BOAT,
 * EXPLOSION_SHIP_DESTROY,
 * EXPLOSION_TRUCK,
 * EXPLOSION_BULLET,
 * EXPLOSION_SMOKEGRENADELAUNCHER,
 * EXPLOSION_SMOKEGRENADE,
 * EXPLOSION_BZGAS,
 * EXPLOSION_FLARE,
 * EXPLOSION_GAS_CANISTER,
 * EXPLOSION_EXTINGUISHER,
 * EXPLOSION_PROGRAMMABLEAR,
 * EXPLOSION_TRAIN,
 * EXPLOSION_BARREL,
 * EXPLOSION_PROPANE,
 * EXPLOSION_BLIMP,
 * EXPLOSION_DIR_FLAME_EXPLODE,
 * EXPLOSION_TANKER,
 * EXPLOSION_PLANE_ROCKET,
 * EXPLOSION_VEHICLE_BULLET,
 * EXPLOSION_GAS_TANK,
 * EXPLOSION_BIRD_CRAP
 * };
 * BOOL isAudible = If explosion makes a sound.
 * BOOL isInvisible = If the explosion is invisible or not.
 */
window.AddOwnedExplosion = function (ped, x, y, z, explosionType, damageScale, isAudible, isInvisible, cameraShake) {
	return _in(0x172aa1b6, 0x24fa1013, ped, _fv(x), _fv(y), _fv(z), explosionType, _fv(damageScale), isAudible, isInvisible, _fv(cameraShake));
};

window.AddPatrolRouteLink = function (p0, p1) {
	return _in(0x23083260, 0xdec3a551, p0, p1);
};

/**
 * Example:
 * AI::ADD_PATROL_ROUTE_NODE(2, "WORLD_HUMAN_GUARD_STAND", -193.4915, -2378.864990234375, 10.9719, -193.4915, -2378.864990234375, 10.9719, 3000);
 * p0 is between 0 and 4 in the scripts.
 * p1 is "WORLD_HUMAN_GUARD_STAND" or "StandGuard".
 * p2, p3 and p4 is only one parameter sometimes in the scripts. Most likely a Vector3 hence p2, p3 and p4 are coordinates.
 * Examples:
 * AI::ADD_PATROL_ROUTE_NODE(1, "WORLD_HUMAN_GUARD_STAND", l_739[7 -- [[3]] ], 0.0, 0.0, 0.0, 0);
 * AI::ADD_PATROL_ROUTE_NODE(1, "WORLD_HUMAN_GUARD_STAND", l_B0[17 -- [[44]] ]._f3, l_B0[17 -- [[44]] ]._f3, 2000);
 * p5, p6 and p7 are for example set to: 1599.0406494140625, 2713.392578125, 44.4309.
 * p8 is an int, often random set to for example: GAMEPLAY::GET_RANDOM_INT_IN_RANGE(5000, 10000).
 */
window.AddPatrolRouteNode = function (p0, p1, x1, y1, z1, x2, y2, z2, p8) {
	return _in(0x8edf9501, 0x67586b7c, p0, _ts(p1), _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), p8);
};

/**
 * 4 calls in the b617d scripts. The only one with p0 and p2 in clear text:
 * AUDIO::ADD_PED_TO_CONVERSATION(5, l_AF, "DINAPOLI");
 * =================================================
 * One of the 2 calls in dialogue_handler.c p0 is in a while-loop, and so is determined to also possibly be 0 - 15.
 * Based on it asking if does_entity_exist for the global I have determined that p1 is, in fact, the ped, but could be wrong.
 */
window.AddPedToConversation = function (p0, ped, p2) {
	return _in(0x95d9f4bc, 0x443956e7, p0, ped, _ts(p2));
};

window.AddPetrolDecal = function (x, y, z, groundLvl, width, transparency) {
	return _in(0x4f5212c7, 0xad880df8, _fv(x), _fv(y), _fv(z), _fv(groundLvl), _fv(width), _fv(transparency), _r, _ri);
};

window.AddPickupToInteriorRoomByName = function (pickup, roomName) {
	return _in(0x3f6167f3, 0x51168730, pickup, _ts(roomName));
};

window.AddPoliceRestart = function (p0, p1, p2, p3, p4) {
	return _in(0x45273676, 0x5b31fc4b, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, _r, _ri);
};

/**
 * Can't select void. This function returns nothing. The hash of the created relationship group is output in the second parameter.
 */
window.AddRelationshipGroup = function (name, groupHash) {
	return _in(0xf372bc22, 0xfcb88606, _ts(name), _ii(groupHash) /* may be optional */, _r, _ri);
};

/**
 * Experimental natives, please do not use in a live environment.
 */
window.AddReplaceTexture = function (origTxd, origTxn, newTxd, newTxn) {
	return _in(0x00000000, 0xa66f8f75, _ts(origTxd), _ts(origTxn), _ts(newTxd), _ts(newTxn));
};

/**
 * Creates a rope at the specific position, that extends in the specified direction when not attached to any entities.
 * __
 * Add_Rope(pos.x,pos.y,pos.z,0.0,0.0,0.0,20.0,4,20.0,1.0,0.0,false,false,false,5.0,false,NULL)
 * When attached, Position<vector> does not matter
 * When attached, Angle<vector> does not matter
 * Rope Type:
 * 4 and bellow is a thick rope
 * 5 and up are small metal wires
 * 0 crashes the game
 * Max_length - Rope is forced to this length, generally best to keep this the same as your rope length.
 * Rigid - If max length is zero, and this is set to false the rope will become rigid (it will force a specific distance, what ever length is, between the objects).
 * breakable - Whether or not shooting the rope will break it.
 * unkPtr - unknown ptr, always 0 in orig scripts
 * __
 * Lengths can be calculated like so:
 * float distance = abs(x1 - x2) + abs(y1 - y2) + abs(z1 - z2); // Rope length
 * NOTES:
 * Rope does NOT interact with anything you attach it to, in some cases it make interact with the world AFTER it breaks (seems to occur if you set the type to -1).
 * Rope will sometimes contract and fall to the ground like you'd expect it to, but since it doesn't interact with the world the effect is just jaring.
 */
window.AddRope = function (x, y, z, rotX, rotY, rotZ, length, ropeType, maxLength, minLength, p10, p11, p12, rigid, p14, breakWhenShot, unkPtr) {
	return _in(0xe832d760, 0x399eb220, _fv(x), _fv(y), _fv(z), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(length), ropeType, _fv(maxLength), _fv(minLength), _fv(p10), p11, p12, rigid, _fv(p14), breakWhenShot, _ii(unkPtr) /* may be optional */, _r, _ri);
};

window.AddScenarioBlockingArea = function (x1, y1, z1, x2, y2, z2, p6, p7, p8, p9) {
	return _in(0x1b5c85c6, 0x12e5256e, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), p6, p7, p8, p9, _r, _ri);
};

/**
 * BRAIN::ADD_SCRIPT_TO_RANDOM_PED("pb_prostitute", ${s_f_y_hooker_01}, 100, 0);
 * -----
 * Hardcoded to not work in Multiplayer.
 * ------
 * Which I'm sure can easily be bypassed by nop'ing the branch preventing it from working if you are in multiplayer lol. Which would still be pointless since you don't need this to make peds do what you wish.
 */
window.AddScriptToRandomPed = function (name, model, p2, p3) {
	return _in(0x4ee53674, 0x68a65ccc, _ts(name), _ch(model), _fv(p2), _fv(p3));
};

/**
 * duration is float here
 * Event types- camx.me/gtav/tasks/shockingevents.txt
 */
window.AddShockingEventAtPosition = function (type, x, y, z, duration) {
	return _in(0xd9f84554, 0x09b525e9, type, _fv(x), _fv(y), _fv(z), _fv(duration), _r, _ri);
};

/**
 * duration is float here
 * Event types - camx.me/gtav/tasks/shockingevents.txt
 */
window.AddShockingEventForEntity = function (type, entity, duration) {
	return _in(0x7fd8f3be, 0x76f89422, type, entity, _fv(duration), _r, _ri);
};

/**
 * This is used to add a speedzone on a position.
 * Example usage C#:
 * uint speedZone = Function.Call<uint>((Hash) 0x2CE544C68FB812A0, Game.PlayerPed.Position.X, Game.PlayerPed.Position.Y, Game.PlayerPed.Position.Z, 100.0f, 0.0f, false);
 * (Thanks to alexguirre for his help!)
 * ==========================================
 * What is the point in adding a speed zone? Does it just generally affect the speed NPCs will drive? I can imagine running this on every section of the interstate setting it to 3 MPH rip.
 */
window.AddSpeedZoneForCoord = function (x, y, z, radius, speed, p5) {
	return _in(0x2ce544c6, 0x8fb812a0, _fv(x), _fv(y), _fv(z), _fv(radius), _fv(speed), p5, _r, _ri);
};
window.N_0x2ce544c68fb812a0 = window.AddSpeedZoneForCoord;

/**
 * See description of [`ADD_STUNT_JUMP_ANGLED`](#_0xBBE5D803A5360CBF) for detailed info. The only difference really is this one does not have the radius (or angle, not sure) floats parameters for entry and landing zones.
 * @param x1 Jump entry left far bottom corner coordinate X.
 * @param y1 Jump entry left far bottom corner coordinate Y.
 * @param z1 Jump entry left far bottom corner coordinate Z.
 * @param x2 Jump entry right near top corner coordinate X.
 * @param y2 Jump entry right near top corner coordinate Y.
 * @param z2 Jump entry right near top corner coordinate Z.
 * @param x3 Landing zone end coordinate X.
 * @param y3 Landing zone end coordinate Y.
 * @param z3 Landing zone end coordinate Z.
 * @param x4 Landing zone start coordinate X.
 * @param y4 Landing zone start coordinate Y.
 * @param z4 Landing zone start coordinate Z.
 * @param camX Stuntcam (cinematic) coordinate x.
 * @param camY Stuntcam (cinematic) coordinate y.
 * @param camZ Stuntcam (cinematic) coordinate z.
 * @param unk1 Unknown, always 150.
 * @param unk2 Unknown, always 0.
 * @param unk3 Unknown, always 0.
 * @return The ID of the stunt jump that was added.
 */
window.AddStuntJump = function (x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, camX, camY, camZ, unk1, unk2, unk3) {
	return _in(0x1a992da2, 0x97a4630c, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(x3), _fv(y3), _fv(z3), _fv(x4), _fv(y4), _fv(z4), _fv(camX), _fv(camY), _fv(camZ), unk1, unk2, unk3, _r, _ri);
};

/**
 * Creates a new stunt jump.
 * The radius1 and radius2 might actually not be a radius at all, but that's what it seems to me testing them in-game. But they may be 'angle' floats instead, considering this native is named ADD_STUNT_JUMP\_**ANGLED**.
 * Info about the specific 'parameter sections':
 * **x1, y1, z1, x2, y2, z2 and radius1:**
 * First coordinates are for the jump entry area, and the radius that will be checked around that area. So if you're not exactly within the coordinates, but you are within the outter radius limit then it will still register as entering the stunt jump. Note as mentioned above, the radius is just a guess, I'm not really sure about it's exact purpose.
 * **x3, y3, z3, x4, y4, z4 and radius2:**
 * Next part is the landing area, again starting with the left bottom (nearest to the stunt jump entry zone) coordinate, and the second one being the top right furthest away part of the landing area. Followed by another (most likely) radius float, this is usually slightly larger than the entry zone 'radius' float value, just because you have quite a lot of places where you can land (I'm guessing).
 * **camX, camY and camZ:**
 * The final coordinate in this native is the Camera position. Rotation and zoom/FOV is managed by the game itself, you just need to provide the camera location.
 * **unk1, unk2 and unk3:**
 * Not sure what these are for, but they're always `150, 0, 0` in decompiled scripts.
 * Visualized example in-game:
 * ![](https://d.fivem.dev/2019-03-15_18-24_c7802_846.png)
 * Here is a list of almost all of the stunt jumps from GTA V (taken from decompiled scripts): <https://pastebin.com/EW1jBPkY>
 * @param x1 Entry zone bottom left corner x.
 * @param y1 Entry zone bottom left corner y.
 * @param z1 Entry zone bottom left corner z.
 * @param x2 Entry zone top right corner x.
 * @param y2 Entry zone top right corner y.
 * @param z2 Entry zone top right corner z.
 * @param radius1 Probably a "feather" radius for entry zone, you need to enter the jump within the min/max coordinates, or within this radius of those two coordinates.
 * @param x3 Landing zone start corner coordinate x.
 * @param y3 Landing zone start corner coordinate y.
 * @param z3 Landing zone start corner coordinate z.
 * @param x4 Landing zone end corner coordinate x.
 * @param y4 Landing zone end corner coordinate y.
 * @param z4 Landing zone end corner coordinate z.
 * @param radius2 Probably a "feather" radius for landing zone, you need to land within the min/max coordinates, or within this radius of those two coordinates.
 * @param camX Stunt (cinematic) camera x position.
 * @param camY Stunt (cinematic) camera y position.
 * @param camZ Stunt (cinematic) camera z position.
 * @param unk1 always 150
 * @param unk2 always 0
 * @param unk3 always 0
 * @return The ID of the stuntjump that was created.
 */
window.AddStuntJumpAngled = function (x1, y1, z1, x2, y2, z2, radius1, x3, y3, z3, x4, y4, z4, radius2, camX, camY, camZ, unk1, unk2, unk3) {
	return _in(0xbbe5d803, 0xa5360cbf, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(radius1), _fv(x3), _fv(y3), _fv(z3), _fv(x4), _fv(y4), _fv(z4), _fv(radius2), _fv(camX), _fv(camY), _fv(camZ), unk1, unk2, unk3, _r, _ri);
};

/**
 * p1 was always -1.
 * used for phone applications; scaleform
 */
window.AddTextComponentAppTitle = function (p0, p1) {
	return _in(0x761b7745, 0x4205a61d, _ts(p0), p1);
};
window.N_0x761b77454205a61d = window.AddTextComponentAppTitle;

window.AddTextComponentFloat = function (value, decimalPlaces) {
	return _in(0xe7dcb5b8, 0x74bcd96e, _fv(value), decimalPlaces);
};

window.AddTextComponentFormattedInteger = function (value, commaSeparated) {
	return _in(0x0e4c749f, 0xf9de9cc4, value, commaSeparated);
};
window.N_0x0e4c749ff9de9cc4 = window.AddTextComponentFormattedInteger;

window.AddTextComponentInteger = function (value) {
	return _in(0x03b504cf, 0x259931bc, value);
};

/**
 * This native (along with 0x6C188BE134E074AA and 0x94CF4AC034C9C986) do not actually filter anything. They simply add the provided text (as of 944)
 * did you even check the disassembly?
 * > Do you even lift bro? The PLAYER_NAME and WEBSITE natives are the correct names, it doesn't matter if they're filtered or not. Blame R* for that matter. Hashes don't lie, and it's extremely unlikely the validated names are collisions (what are the odds??)
 */
window.AddTextComponentScaleform = function (p0) {
	return _in(0x5f685208, 0x88e69014, _ts(p0));
};
window.AddTextComponentString3 = window.AddTextComponentScaleform;

window.AddTextComponentSubstringBlipName = function (blip) {
	return _in(0x80ead8e2, 0xe1d5d52e, blip);
};
window.N_0x80ead8e2e1d5d52e = window.AddTextComponentSubstringBlipName;

/**
 * Adds an arbitrary string as a text component placeholder, replacing `~a~` in the current text command's text label.
 * See the documentation on text formatting for more information.
 * @param text A string to add of up to 99 characters. This can contain additional `~` formatting directives.
 */
window.AddTextComponentSubstringPlayerName = function (text) {
	return _in(0x6c188be1, 0x34e074aa, _ts(text));
};
window.AddTextComponentString = window.AddTextComponentSubstringPlayerName;

window.AddTextComponentSubstringTextLabel = function (labelName) {
	return _in(0xc63cd5d2, 0x920acbe7, _ts(labelName));
};
window.AddTextComponentItemString = window.AddTextComponentSubstringTextLabel;

/**
 * It adds the localized text of the specified GXT entry name. Eg. if the argument is GET_HASH_KEY("ES_HELP"), adds "Continue". Just uses a text labels hash key
 */
window.AddTextComponentSubstringTextLabelHashKey = function (gxtEntryHash) {
	return _in(0x17299b63, 0xc7683a2b, _ch(gxtEntryHash));
};
window.N_0x17299b63c7683a2b = window.AddTextComponentSubstringTextLabelHashKey;

/**
 * Adds a timer (e.g. "00:00:00:000"). The appearance of the timer depends on the flags, which needs more research.
 */
window.AddTextComponentSubstringTime = function (timestamp, flags) {
	return _in(0x1115f16b, 0x8ab9e8bf, timestamp, flags);
};

/**
 * This native (along with 0x5F68520888E69014 and 0x6C188BE134E074AA) do not actually filter anything. They simply add the provided text (as of 944)
 */
window.AddTextComponentSubstringWebsite = function (website) {
	return _in(0x94cf4ac0, 0x34c9c986, _ts(website));
};
window.AddTextComponentString2 = window.AddTextComponentSubstringWebsite;

window.AddTextEntry = function (entryKey, entryText) {
	return _in(0x00000000, 0x32ca01c3, _ts(entryKey), _ts(entryText));
};

window.AddTextEntryByHash = function (entryKey, entryText) {
	return _in(0x00000000, 0x289da860, _ch(entryKey), _ts(entryText));
};

window.AddToClockTime = function (hours, minutes, seconds) {
	return _in(0xd716f30d, 0x8c8980e2, hours, minutes, seconds);
};

window.AddToItemset = function (p0, p1) {
	return _in(0xe3945201, 0xf14637dd, p0, p1, _r);
};

/**
 * Hash collision!
 * _IS_MP_GAMER_TAG_ACTIVE_2
 */
window.AddTrevorRandomModifier = function (gamerTagId) {
	return _in(0x595b5178, 0xe412e199, gamerTagId, _r);
};

window.AddVehicleStuckCheckWithWarp = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x2fa99230, 0x62dd396c, p0, _fv(p1), p2, p3, p4, p5, p6);
};

/**
 * x, y, z: offset in world coords from some entity.
 */
window.AddVehicleSubtaskAttackCoord = function (ped, x, y, z) {
	return _in(0x5cf0d8f9, 0xbba0dd75, ped, _fv(x), _fv(y), _fv(z));
};

window.AddVehicleSubtaskAttackPed = function (ped, ped2) {
	return _in(0x85f462ba, 0xdc7da47f, ped, ped2);
};

window.AddVehicleUpsidedownCheck = function (vehicle) {
	return _in(0xb72e26d8, 0x1006005b, vehicle);
};

window.AdvanceClockTimeTo = function (hour, minute, second) {
	return _in(0xc8ca9670, 0xb9d83b3b, hour, minute, second);
};

/**
 * Seems to animate the gameplay camera zoom.
 * Eg. _ANIMATE_GAMEPLAY_CAM_ZOOM(1f, 1000f);
 * will animate the camera zooming in from 1000 meters away.
 * Game scripts use it like this:
 * // Setting this to 1 prevents V key from changing zoom
 * PLAYER::SET_PLAYER_FORCED_ZOOM(PLAYER::PLAYER_ID(), 1);
 * // These restrict how far you can move cam up/down left/right
 * CAM::_CLAMP_GAMEPLAY_CAM_YAW(-20f, 50f);
 * CAM::_CLAMP_GAMEPLAY_CAM_PITCH(-60f, 0f);
 * CAM::_ANIMATE_GAMEPLAY_CAM_ZOOM(1f, 1f);
 */
window.AnimateGameplayCamZoom = function (p0, distance) {
	return _in(0xdf2e1f77, 0x42402e81, _fv(p0), _fv(distance));
};

/**
 * Example from michael2 script.
 * CAM::ANIMATED_SHAKE_CAM(l_5069, "shake_cam_all@", "light", "", 1f);
 */
window.AnimatedShakeCam = function (cam, p1, p2, p3, amplitude) {
	return _in(0xa2746eea, 0xe3e577cd, cam, _ts(p1), _ts(p2), _ts(p3), _fv(amplitude));
};

window.AnyPassengersRappeling = function (vehicle) {
	return _in(0x291e373d, 0x483e7ee7, vehicle, _r);
};
window.N_0x291e373d483e7ee7 = window.AnyPassengersRappeling;

window.AppClearBlock = function () {
	return _in(0x5fe1df33, 0x42db7dba);
};

window.AppCloseApp = function () {
	return _in(0xe41c65e0, 0x7a5f05fc);
};

window.AppCloseBlock = function () {
	return _in(0xe8e3fcf7, 0x2eac0ef8);
};

window.AppDataValid = function () {
	return _in(0x846aa8e7, 0xd55ee5b6, _r, _ri);
};

window.AppDeleteAppData = function (appName) {
	return _in(0x44151aea, 0x95c8a003, _ts(appName), _r);
};

window.AppGetDeletedFileStatus = function () {
	return _in(0xc9853a2b, 0xe3ded1a6, _r, _ri);
};

window.AppGetFloat = function (property) {
	return _in(0x1514fb24, 0xc02c2322, _ts(property), _r, _rf);
};

window.AppGetInt = function (property) {
	return _in(0xd3a58a12, 0xc77d9d4b, property);
};

window.AppGetString = function (property) {
	return _in(0x749b0239, 0x50d2311c, _ts(property), _r, _s);
};

window.AppHasLinkedSocialClubAccount = function () {
	return _in(0x71eee697, 0x45088da0, _r);
};

window.AppHasSyncedData = function (appName) {
	return _in(0xca52279a, 0x7271517f, _ts(appName), _r);
};

window.AppSaveData = function () {
	return _in(0x95c5d356, 0xcda6e85f);
};

/**
 * Called in the gamescripts like:
 * APP::APP_SET_APP("car");
 * APP::APP_SET_APP("dog");
 */
window.AppSetApp = function (appName) {
	return _in(0xcfd0406a, 0xdaf90d2b, _ts(appName));
};

window.AppSetBlock = function (blockName) {
	return _in(0x262ab456, 0xa3d21f93, _ts(blockName));
};

window.AppSetFloat = function (property, value) {
	return _in(0x25d7687c, 0x68e0daa4, _ts(property), _fv(value));
};

window.AppSetInt = function (property, value) {
	return _in(0x607e8e3d, 0x3e4f9611, _ts(property), value);
};

window.AppSetString = function (property, value) {
	return _in(0x3ff2fcec, 0x4b7721b4, _ts(property), _ts(value));
};

/**
 * damages a ped with the given amount
 * ----
 * armorFirst means it will damage/lower the armor first before damaging the player.
 * setting damageAmount to a negative amount will cause the player or the armor (depending on armorFirst) to be healed by damageAmount instead.
 */
window.ApplyDamageToPed = function (ped, damageAmount, armorFirst) {
	return _in(0x697157ce, 0xd63f18d4, ped, damageAmount, armorFirst);
};

/**
 * Documented here:
 * gtaforums.com/topic/885669-precisely-define-object-physics/
 * gtaforums.com/topic/887362-apply-forces-and-momentums-to-entityobject/
 * forceFlags:
 * First bit (lowest): Strong force flag, factor 100
 * Second bit: Unkown flag
 * Third bit: Momentum flag=1 (vector (x,y,z) is a momentum, more research needed)
 * If higher bits are unequal 0 the function doesn't applay any forces at all.
 * (As integer possible values are 0-7)
 * 0: weak force
 * 1: strong force
 * 2: same as 0 (2nd bit?)
 * 3: same as 1
 * 4: weak momentum
 * 5: strong momentum
 * 6: same as 4
 * 7: same as 5
 * isDirectionRel: vector defined in local (body-fixed) coordinate frame
 * isForceRel: if true the force gets multiplied with the objects mass (this is why it was known as highForce) and different objects will have the same acceleration.
 */
window.ApplyForceToEntity = function (entity, forceFlags, x, y, z, offX, offY, offZ, boneIndex, isDirectionRel, ignoreUpVec, isForceRel, p12, p13) {
	return _in(0xc5f68be9, 0x613e2d18, entity, forceFlags, _fv(x), _fv(y), _fv(z), _fv(offX), _fv(offY), _fv(offZ), boneIndex, isDirectionRel, ignoreUpVec, isForceRel, p12, p13);
};

window.ApplyForceToEntityCenterOfMass = function (entity, forceType, x, y, z, p5, isDirectionRel, isForceRel, p8) {
	return _in(0x18ff00fc, 0x7eff559e, entity, forceType, _fv(x), _fv(y), _fv(z), p5, isDirectionRel, isForceRel, p8);
};

window.ApplyImpulseToCloth = function (posX, posY, posZ, vecX, vecY, vecZ, impulse) {
	return _in(0xe37f7218, 0x24571784, _fv(posX), _fv(posY), _fv(posZ), _fv(vecX), _fv(vecY), _fv(vecZ), _fv(impulse));
};

/**
 * Found one occurence in re_crashrescue.c4
 * PED::APPLY_PED_BLOOD(l_4B, 3, 0.0, 0.0, 0.0, "wound_sheet");
 */
window.ApplyPedBlood = function (ped, boneIndex, xRot, yRot, zRot, woundType) {
	return _in(0x83f7e01c, 0x7b769a26, ped, boneIndex, _fv(xRot), _fv(yRot), _fv(zRot), _ts(woundType));
};

window.ApplyPedBloodByZone = function (ped, p1, p2, p3, p4) {
	return _in(0x3311e47b, 0x91edcbbc, ped, p1, _fv(p2), _fv(p3), _ii(p4) /* may be optional */);
};
window.N_0x3311e47b91edcbbc = window.ApplyPedBloodByZone;

window.ApplyPedBloodDamageByZone = function (ped, p1, p2, p3, p4) {
	return _in(0x816f6981, 0xc60bf53b, ped, p1, _fv(p2), _fv(p3), p4);
};
window.N_0x816f6981c60bf53b = window.ApplyPedBloodDamageByZone;

window.ApplyPedBloodSpecific = function (ped, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0xef0d582c, 0xbf2d9b0f, ped, p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, _fv(p7), _ii(p8) /* may be optional */);
};
window.N_0xef0d582cbf2d9b0f = window.ApplyPedBloodSpecific;

/**
 * APPLY_PED_DAMAGE_DECAL(ped, 1, 0.5f, 0.513f, 0f, 1f, unk, 0, 0, "blushing");
 */
window.ApplyPedDamageDecal = function (ped, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0x397c38aa, 0x7b4a5f83, ped, p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, p8, _ts(p9));
};

/**
 * Damage Packs:
 * "SCR_TrevorTreeBang"
 * "HOSPITAL_0"
 * "HOSPITAL_1"
 * "HOSPITAL_2"
 * "HOSPITAL_3"
 * "HOSPITAL_4"
 * "HOSPITAL_5"
 * "HOSPITAL_6"
 * "HOSPITAL_7"
 * "HOSPITAL_8"
 * "HOSPITAL_9"
 * "SCR_Dumpster"
 * "BigHitByVehicle"
 * "SCR_Finale_Michael_Face"
 * "SCR_Franklin_finb"
 * "SCR_Finale_Michael"
 * "SCR_Franklin_finb2"
 * "Explosion_Med"
 * "SCR_Torture"
 * "SCR_TracySplash"
 * "Skin_Melee_0"
 * Additional damage packs:
 * gist.github.com/alexguirre/f3f47f75ddcf617f416f3c8a55ae2227
 */
window.ApplyPedDamagePack = function (ped, damagePack, damage, mult) {
	return _in(0x46df9187, 0x88cb093f, ped, _ts(damagePack), _fv(damage), _fv(mult));
};

window.AreAllNavmeshRegionsLoaded = function () {
	return _in(0x8415d95b, 0x194a3aea, _r);
};

/**
 * Appears to return false if any window is broken.
 */
window.AreAllVehicleWindowsIntact = function (vehicle) {
	return _in(0x11d862a3, 0xe977a9ef, vehicle, _r);
};
window.AreAllVehicleWindowsIntact = window.AreAllVehicleWindowsIntact;

/**
 * Returns false if every seat is occupied.
 */
window.AreAnyVehicleSeatsFree = function (vehicle) {
	return _in(0x2d34fc3b, 0xc4adb780, vehicle, _r);
};
window.IsAnyVehicleSeatEmpty = window.AreAnyVehicleSeatsFree;

/**
 * Returns true when the bomb bay doors of this plane are open. False if they're closed.
 * @param aircraft The vehicle to check the bomb bay doors on.
 * @return A bool indicating the state of the doors (true = open, false = closed).
 */
window.AreBombBayDoorsOpen = function (aircraft) {
	return _in(0xd0917a42, 0x3314bba8, aircraft, _r);
};
window.N_0xd0917a423314bba8 = window.AreBombBayDoorsOpen;
window.GetAreBombBayDoorsOpen = window.AreBombBayDoorsOpen;

/**
 * Returns true if the coords are colliding with the outdoors, and false if they collide with an interior.
 */
window.AreCoordsCollidingWithExterior = function (x, y, z) {
	return _in(0xeea5ac2e, 0xda7c33e8, _fv(x), _fv(y), _fv(z), _r);
};
window.N_0xeea5ac2eda7c33e8 = window.AreCoordsCollidingWithExterior;

window.ArePlayerFlashingStarsAboutToDrop = function (player) {
	return _in(0xafaf8604, 0x3e5874e9, player, _r);
};

window.ArePlayerStarsGreyedOut = function (player) {
	return _in(0x0a6eb355, 0xee14a2db, player, _r);
};

/**
 * Found this in the decompiled scripts, I'd do more research before changing the name --
 * if (!ENTITY::IS_ENTITY_DEAD(l_1911)) {
 * if (!VEHICLE::_755D6D5267CBBD7E(l_1911)) {
 * sub_1ba80("TRAFFICKING AIR: FAILING - PROPELLERS ARE DAMAGED");
 * l_12CE = 9;
 * }
 * }
 */
window.ArePropellersUndamaged = function (vehicle) {
	return _in(0x755d6d52, 0x67cbbd7e, vehicle, _r);
};
window.N_0x755d6d5267cbbd7e = window.ArePropellersUndamaged;

/**
 * is this like strcmp??
 */
window.AreStringsEqual = function (string1, string2) {
	return _in(0x0c515fab, 0x3ff9ea92, _ts(string1), _ts(string2), _r);
};

/**
 * ADD_A_MARKER_OVER_VEHICLE was a hash collision!!!
 * Can be used for planes only!
 */
window.AreVehicleWingsIntact = function (vehicle) {
	return _in(0x5991a014, 0x34ce9677, vehicle, _r);
};
window.N_0x5991a01434ce9677 = window.AreVehicleWingsIntact;
window.AddAMarkerOverVehicle = window.AreVehicleWingsIntact;

window.ArrayValueAddBoolean = function (value) {
	return _in(0xf8b0f5a4, 0x3e928c76, _i, value);
};

window.ArrayValueAddFloat = function (value) {
	return _in(0x57a995fd, 0x75d37f56, _i, _fv(value));
};

window.ArrayValueAddInteger = function (value) {
	return _in(0xcabdb751, 0xd86fe93b, _i, value);
};

window.ArrayValueAddObject = function (arrayData) {
	return _in(0x6889498b, 0x3e19c797, _ii(arrayData) /* may be optional */, _r, _ri);
};

window.ArrayValueAddString = function (value) {
	return _in(0x2f0661c1, 0x55aeeeaa, _i, _ts(value));
};

window.ArrayValueAddVector3 = function (valueX, valueY, valueZ) {
	return _in(0x407f8d03, 0x4f70f0c2, _i, _fv(valueX), _fv(valueY), _fv(valueZ));
};

window.ArrayValueGetBoolean = function (arrayIndex) {
	return _in(0x50c1b287, 0x4e50c114, _i, arrayIndex, _r);
};

window.ArrayValueGetFloat = function (arrayIndex) {
	return _in(0xc0c527b5, 0x25d7cfb5, _i, arrayIndex, _r, _rf);
};

window.ArrayValueGetInteger = function (arrayIndex) {
	return _in(0x3e5ae194, 0x25cd74be, _i, arrayIndex, _r, _ri);
};

window.ArrayValueGetObject = function (arrayIndex) {
	return _in(0x8b5fadcc, 0x4e3a145f, _i, arrayIndex, _r, _ri);
};

window.ArrayValueGetSize = function (arrayData) {
	return _in(0x065db281, 0x590cea2d, _ii(arrayData) /* may be optional */, _r, _ri);
};

window.ArrayValueGetString = function (arrayIndex) {
	return _in(0xd3f2ffeb, 0x8d836f52, _i, arrayIndex, _r, _s);
};

/**
 * Types:
 * 1 = Boolean
 * 2 = Integer
 * 3 = Float
 * 4 = String
 * 5 = Vector3
 * 6 = Object
 * 7 = Array
 */
window.ArrayValueGetType = function (arrayIndex) {
	return _in(0x3a0014ad, 0xb172a3c5, _i, arrayIndex, _r, _ri);
};

window.ArrayValueGetVector3 = function (arrayIndex) {
	return _in(0x8d2064e5, 0xb64a628a, _i, arrayIndex, _r, _rv);
};

/**
 * Returns arcsin value of p0.
 */
window.Asin = function (p0) {
	return _in(0xc843060b, 0x5765dce7, _fv(p0), _r, _rf);
};

window.AssistedMovementCloseRoute = function () {
	return _in(0xaebf081f, 0xfc0a0e5e);
};

window.AssistedMovementFlushRoute = function () {
	return _in(0x8621390f, 0x0cdcfe1f);
};

window.AssistedMovementIsRouteLoaded = function (route) {
	return _in(0x60f9a439, 0x3a21f741, _ts(route), _r);
};

window.AssistedMovementOverrideLoadDistanceThisFrame = function (dist) {
	return _in(0x13945951, 0xe16ef912, _fv(dist));
};

window.AssistedMovementRemoveRoute = function (route) {
	return _in(0x35485364, 0x85dd792b, _ts(route));
};

/**
 * Routes: "1_FIBStairs", "2_FIBStairs", "3_FIBStairs", "4_FIBStairs", "5_FIBStairs", "5_TowardsFire", "6a_FIBStairs", "7_FIBStairs", "8_FIBStairs", "Aprtmnt_1", "AssAfterLift", "ATM_1", "coroner2", "coroner_stairs", "f5_jimmy1", "fame1", "family5b", "family5c", "Family5d", "family5d", "FIB_Glass1", "FIB_Glass2", "FIB_Glass3", "finaBroute1A", "finalb1st", "finalB1sta", "finalbround", "finalbroute2", "Hairdresser1", "jan_foyet_ft_door", "Jo_3", "Lemar1", "Lemar2", "mansion_1", "Mansion_1", "pols_1", "pols_2", "pols_3", "pols_4", "pols_5", "pols_6", "pols_7", "pols_8", "Pro_S1", "Pro_S1a", "Pro_S2", "Towards_case", "trev_steps", "tunrs1", "tunrs2", "tunrs3", "Wave01457s"
 */
window.AssistedMovementRequestRoute = function (route) {
	return _in(0x81726896, 0x8605947a, _ts(route));
};

window.AssistedMovementSetRouteProperties = function (route, props) {
	return _in(0xd5002d78, 0xb7162e1b, _ts(route), props);
};

/**
 * Returns arctan value of p0.
 */
window.Atan = function (p0) {
	return _in(0xa9d1795c, 0xd5043663, _fv(p0), _r, _rf);
};

window.Atan2 = function (p0, p1) {
	return _in(0x8927cbf9, 0xd22261a4, _fv(p0), _fv(p1), _r, _rf);
};

/**
 * Last param determines if its relative to the Entity
 */
window.AttachCamToEntity = function (cam, entity, xOffset, yOffset, zOffset, isRelative) {
	return _in(0xfedb7d26, 0x9e8c60e3, cam, entity, _fv(xOffset), _fv(yOffset), _fv(zOffset), isRelative);
};

window.AttachCamToPedBone = function (cam, ped, boneIndex, x, y, z, heading) {
	return _in(0x61a3dba1, 0x4ab7f411, cam, ped, boneIndex, _fv(x), _fv(y), _fv(z), heading);
};

/**
 * This native works with vehicles only.
 * Bone indexes are usually given by this native [GET_ENTITY_BONE_INDEX_BY_NAME](#_0xFB71170B7E76ACBA).
 * @param cam The camera handle.
 * @param vehicle The vehicle handle.
 * @param relativeRotation Whether or not the camera rotation will relative the vehicle rotation.
 * @param rotX The X rotation.
 * @param rotY The Y rotation.
 * @param rotZ The Z rotation.
 * @param offX The X offset direction.
 * @param offY The Y offset direction.
 * @param offZ The Z offset direction.
 * @param fixedDirection Whether or not the camera direction will relative to the vehicle direction.
 */
window.AttachCamToVehicleBone = function (cam, vehicle, boneIndex, relativeRotation, rotX, rotY, rotZ, offX, offY, offZ, fixedDirection) {
	return _in(0x8db3f12a, 0x02caef72, cam, vehicle, boneIndex, relativeRotation, _fv(rotX), _fv(rotY), _fv(rotZ), _fv(offX), _fv(offY), _fv(offZ), fixedDirection);
};
window.N_0x8db3f12a02caef72 = window.AttachCamToVehicleBone;

/**
 * Attaches entity 1 to entity 2.
 */
window.AttachEntitiesToRope = function (rope, ent1, ent2, ent1_x, ent1_y, ent1_z, ent2_x, ent2_y, ent2_z, length, p10, p11, boneName1, boneName2) {
	return _in(0x3d95ec8b, 0x6d940ac3, rope, ent1, ent2, _fv(ent1_x), _fv(ent1_y), _fv(ent1_z), _fv(ent2_x), _fv(ent2_y), _fv(ent2_z), _fv(length), p10, p11, _ts(boneName1), _ts(boneName2));
};

/**
 * Attaches entity1 to bone (boneIndex) of entity2.
 * boneIndex - this is different to boneID, use GET_PED_BONE_INDEX to get the index from the ID. use the index for attaching to specific bones. entity1 will be attached to entity2's centre if bone index given doesn't correspond to bone indexes for that entity type.
 * useSoftPinning - when 2 entities with collision collide and form into a ball they will break the attachment of the entity that they were attached to. Or when an entity is attached far away and then the resets.
 * collision - controls collision between the two entities (FALSE disables collision).
 * isPed - pitch doesnt work when false and roll will only work on negative numbers (only peds)
 * vertexIndex - position of vertex
 * fixedRot - if false it ignores entity vector
 */
window.AttachEntityToEntity = function (entity1, entity2, boneIndex, xPos, yPos, zPos, xRot, yRot, zRot, p9, useSoftPinning, collision, isPed, vertexIndex, fixedRot) {
	return _in(0x6b9bbd38, 0xab0796df, entity1, entity2, boneIndex, _fv(xPos), _fv(yPos), _fv(zPos), _fv(xRot), _fv(yRot), _fv(zRot), p9, useSoftPinning, collision, isPed, vertexIndex, fixedRot);
};

/**
 * breakForce is the amount of force required to break the bond.
 * fixedRot - if false it ignores entity vector
 * p15 - is 1 or 0 in scripts - unknoun what it does
 * collision - controls collision between the two entities (FALSE disables collision).
 * teleport - do not teleport entity to be attached to the position of the bone Index of the target entity (if 1, entity will not be teleported to target bone)
 * p18 - is always 2 in scripts.
 * -------------------------
 * teleport is not exactly "doNotTeleport". What it actually does is the following:
 * if true, entities will be attached as if loosely tethered, up to the maximum offset position specified. Almost as if attached by an invisible rope.
 * if false, entities will be attached in a fixed position as specified in the offset position.
 * When p15 = true, it seems to force teleport to false.
 * It also lets the Rotation params actually work.
 */
window.AttachEntityToEntityPhysically = function (entity1, entity2, boneIndex1, boneIndex2, xPos1, yPos1, zPos1, xPos2, yPos2, zPos2, xRot, yRot, zRot, breakForce, fixedRot, p15, collision, teleport, p18) {
	return _in(0xc3675780, 0xc92f90f9, entity1, entity2, boneIndex1, boneIndex2, _fv(xPos1), _fv(yPos1), _fv(zPos1), _fv(xPos2), _fv(yPos2), _fv(zPos2), _fv(xRot), _fv(yRot), _fv(zRot), _fv(breakForce), fixedRot, p15, collision, teleport, p18);
};

window.AttachPortablePickupToPed = function (ped, p1) {
	return _in(0x8dc39368, 0xbdd57755, ped, p1);
};

/**
 * The position supplied can be anywhere, and the entity should anchor relative to that point from it's origin.
 */
window.AttachRopeToEntity = function (rope, entity, x, y, z, p5) {
	return _in(0x4b490a68, 0x32559a65, rope, entity, _fv(x), _fv(y), _fv(z), p5);
};

window.AttachSynchronizedSceneToEntity = function (sceneID, entity, boneIndex) {
	return _in(0x272e4723, 0xb56a3b96, sceneID, entity, boneIndex);
};

/**
 * Might be more appropriate in AUDIO?
 */
window.AttachTvAudioToEntity = function (entity) {
	return _in(0x845bad77, 0xcc770633, entity);
};

window.AttachVehicleToCargobob = function (vehicle, cargobob, p2, x, y, z) {
	return _in(0x4127f1d8, 0x4e347769, vehicle, cargobob, p2, _fv(x), _fv(y), _fv(z));
};

/**
 * HookOffset defines where the hook is attached. leave at 0 for default attachment.
 * When using the tow truck online, this is not used (set a breakpoint and never called during tow truck attachment)
 */
window.AttachVehicleToTowTruck = function (towTruck, vehicle, rear, hookOffsetX, hookOffsetY, hookOffsetZ) {
	return _in(0x29a16f8d, 0x621c4508, towTruck, vehicle, rear, _fv(hookOffsetX), _fv(hookOffsetY), _fv(hookOffsetZ));
};

window.AttachVehicleToTrailer = function (vehicle, trailer, radius) {
	return _in(0x3c7d42d5, 0x8f770b54, vehicle, trailer, _fv(radius));
};

window.AudioIsScriptedMusicPlaying = function () {
	return _in(0x845ffc3a, 0x4feefa3e, _r, _ri);
};

window.BadSportPlayerLeftDetected = function (event, amountReceived) {
	return _in(0xec5e3af5, 0x289dca81, _i, event, amountReceived, _r);
};
window.N_0xec5e3af5289dca81 = window.BadSportPlayerLeftDetected;

/**
 * MulleDK19: Starts a new enumeration of the current threads.
 * Call this first, then _GET_ID_OF_NEXT_THREAD_IN_ENUMERATION (0x30B4FA1C82DD4B9F)
 * see _GET_ID_OF_NEXT_THREAD_IN_ENUMERATION (0x30B4FA1C82DD4B9F) for an example
 */
window.BeginEnumeratingThreads = function () {
	return _in(0xdadfada5, 0xa20143a8);
};
window.N_0xdadfada5a20143a8 = window.BeginEnumeratingThreads;

window.BeginReplayStats = function (p0, p1) {
	return _in(0xe0e50024, 0x6ff73d66, p0, p1);
};

/**
 * Push a function from the Scaleform onto the stack
 */
window.BeginScaleformMovieMethod = function (scaleform, functionName) {
	return _in(0xf6e48914, 0xc7a8694e, scaleform, _ts(functionName), _r);
};
window.PushScaleformMovieFunction = window.BeginScaleformMovieMethod;

/**
 * Pushes a function from the Hud component Scaleform onto the stack. Same behavior as GRAPHICS::_PUSH_SCALEFORM_MOVIE_FUNCTION, just a hud component id instead of a Scaleform.
 * Known components:
 * 19
 * 20
 * This native requires more research - all information can be found inside of 'hud.gfx'. Using a decompiler, the different components are located under "scripts\__Packages\com\rockstargames\gtav\hud\hudComponents" and "scripts\__Packages\com\rockstargames\gtav\Multiplayer".
 */
window.BeginScaleformMovieMethodHudComponent = function (hudComponent, functionName) {
	return _in(0x98c494fd, 0x5bdfbfd5, hudComponent, _ts(functionName), _r);
};
window.PushScaleformMovieFunctionFromHudComponent = window.BeginScaleformMovieMethodHudComponent;

/**
 * Starts frontend (pause menu) scaleform movie methods.
 * This can be used when you want to make custom frontend menus, and customize things like images or text in the menus etc.
 * Use [`BEGIN_SCALEFORM_MOVIE_METHOD_ON_FRONTEND_HEADER`](#_0xB9449845F73F5E9C) for header scaleform functions.
 * @param functionName The function name of the scaleform to call.
 */
window.BeginScaleformMovieMethodOnFrontend = function (functionName) {
	return _in(0xab58c27c, 0x2e6123c6, _ts(functionName), _r);
};
window.N_0xab58c27c2e6123c6 = window.BeginScaleformMovieMethodOnFrontend;
window.PushScaleformMovieFunctionN = window.BeginScaleformMovieMethodOnFrontend;
window.BeginScaleformMovieMethodN = window.BeginScaleformMovieMethodOnFrontend;

/**
 * Starts frontend (pause menu) scaleform movie methods for header options.
 * Use [`BEGIN_SCALEFORM_MOVIE_METHOD_ON_FRONTEND`](#_0xAB58C27C2E6123C6) to customize the content inside the frontend menus.
 * @param functionName Scaleform function name.
 */
window.BeginScaleformMovieMethodOnFrontendHeader = function (functionName) {
	return _in(0xb9449845, 0xf73f5e9c, _ts(functionName), _r);
};
window.N_0xb9449845f73f5e9c = window.BeginScaleformMovieMethodOnFrontendHeader;
window.BeginScaleformMovieMethodV = window.BeginScaleformMovieMethodOnFrontendHeader;

window.BeginSrl = function () {
	return _in(0x9baddc94, 0xef83b823);
};

/**
 * Initializes the text entry for the the text next to a loading prompt. All natives for for building UI texts can be used here
 * BEGIN_TEXT_COMMAND_PRINT
 * e.g
 * void StartLoadingMessage(char *text, int spinnerType = 3)
 * {
 * _SET_LOADING_PROMPT_TEXT_ENTRY("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * _SHOW_LOADING_PROMPT(spinnerType);
 * }
 *  -- [[OR]] 
 * void ShowLoadingMessage(char *text, int spinnerType = 3, int timeMs = 10000)
 * {
 * _SET_LOADING_PROMPT_TEXT_ENTRY("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * _SHOW_LOADING_PROMPT(spinnerType);
 * WAIT(timeMs);
 * _REMOVE_LOADING_PROMPT();
 * }
 * These are some localized strings used in the loading spinner.
 * "PM_WAIT"                   = Please Wait
 * "CELEB_WPLYRS"              = Waiting For Players.
 * "CELL_SPINNER2"             = Scanning storage.
 * "ERROR_CHECKYACHTNAME" = Registering your yacht's name. Please wait.
 * "ERROR_CHECKPROFANITY"   = Checking your text for profanity. Please wait.
 * "FM_COR_AUTOD"                        = Just spinner no text
 * "FM_IHELP_WAT2"                        = Waiting for other players
 * "FM_JIP_WAITO"                            = Game options are being set
 * "FMMC_DOWNLOAD"                    = Downloading
 * "FMMC_PLYLOAD"                         = Loading
 * "FMMC_STARTTRAN"                    = Launching session
 * "HUD_QUITTING"                           =  Quiting session
 * "KILL_STRIP_IDM"                         = Waiting for to accept
 * "MP_SPINLOADING"                      = Loading
 */
window.BeginTextCommandBusyString = function (string) {
	return _in(0xaba17d7c, 0xe615adbf, _ts(string));
};
window.N_0xaba17d7ce615adbf = window.BeginTextCommandBusyString;
window.SetLoadingPromptTextEntry = window.BeginTextCommandBusyString;

/**
 * clears a print text command with this text
 */
window.BeginTextCommandClearPrint = function (text) {
	return _in(0xe124fa80, 0xa759019c, _ts(text));
};
window.N_0xe124fa80a759019c = window.BeginTextCommandClearPrint;

/**
 * Used to be known as _SET_TEXT_COMPONENT_FORMAT
 */
window.BeginTextCommandDisplayHelp = function (inputType) {
	return _in(0x8509b634, 0xfbe7da11, _ts(inputType));
};
window.SetTextComponentFormat = window.BeginTextCommandDisplayHelp;

/**
 * The following were found in the decompiled script files:
 * STRING, TWOSTRINGS, NUMBER, PERCENTAGE, FO_TWO_NUM, ESMINDOLLA, ESDOLLA, MTPHPER_XPNO, AHD_DIST, CMOD_STAT_0, CMOD_STAT_1, CMOD_STAT_2, CMOD_STAT_3, DFLT_MNU_OPT, F3A_TRAFDEST, ES_HELP_SOC3
 * ESDOLLA
 * ESMINDOLLA - cash (negative)
 * Used to be known as _SET_TEXT_ENTRY
 */
window.BeginTextCommandDisplayText = function (text) {
	return _in(0x25fbb336, 0xdf1804cb, _ts(text));
};
window.SetTextEntry = window.BeginTextCommandDisplayText;

/**
 * nothin doin.
 * BOOL Message(char* text)
 * {
 * BEGIN_TEXT_COMMAND_IS_MESSAGE_DISPLAYED("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * return END_TEXT_COMMAND_IS_MESSAGE_DISPLAYED();
 * }
 */
window.BeginTextCommandIsMessageDisplayed = function (text) {
	return _in(0x853648fd, 0x1063a213, _ts(text));
};
window.N_0x853648fd1063a213 = window.BeginTextCommandIsMessageDisplayed;

/**
 * BOOL IsContextActive(char *ctx)
 * {
 * BEGIN_TEXT_COMMAND_IS_THIS_HELP_MESSAGE_BEING_DISPLAYED(ctx);
 * return END_TEXT_COMMAND_IS_THIS_HELP_MESSAGE_BEING_DISPLAYED(0);
 * }
 */
window.BeginTextCommandIsThisHelpMessageBeingDisplayed = function (labelName) {
	return _in(0x0a24da3a, 0x41b718f5, _ts(labelName));
};
window.N_0x0a24da3a41b718f5 = window.BeginTextCommandIsThisHelpMessageBeingDisplayed;

/**
 * get's line count
 * int GetLineCount(char *text, float x, float y)
 * {
 * _BEGIN_TEXT_COMMAND_LINE_COUNT("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * return _END_TEXT_COMMAND_GET_LINE_COUNT(x, y);
 * }
 */
window.BeginTextCommandLineCount = function (entry) {
	return _in(0x521fb041, 0xd93dd0e4, _ts(entry));
};
window.SetTextGxtEntry = window.BeginTextCommandLineCount;

/**
 * nothin doin.
 * void message()
 * {
 * _BEGIN_TEXT_COMMAND_OBJECTIVE("AHT_RTIT");
 * _END_TEXT_COMMAND_OBJECTIVE(0);
 * }
 */
window.BeginTextCommandObjective = function (p0) {
	return _in(0x23d69e04, 0x65570028, _ts(p0));
};
window.N_0x23d69e0465570028 = window.BeginTextCommandObjective;

/**
 * Used to be known as _SET_TEXT_ENTRY_2
 * void ShowSubtitle(char *text)
 * {
 * BEGIN_TEXT_COMMAND_PRINT("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * END_TEXT_COMMAND_PRINT(2000, 1);
 * }
 */
window.BeginTextCommandPrint = function (GxtEntry) {
	return _in(0xb87a37ee, 0xb7faa67d, _ts(GxtEntry));
};
window.SetTextEntry_2 = window.BeginTextCommandPrint;

/**
 * Previously called _BEGIN_TEXT_COMPONENT
 * Called prior to adding a text component to the UI. After doing so, GRAPHICS::END_TEXT_COMMAND_SCALEFORM_STRING is called.
 * Examples:
 * GRAPHICS::BEGIN_TEXT_COMMAND_SCALEFORM_STRING("NUMBER");
 * UI::ADD_TEXT_COMPONENT_INTEGER(GAMEPLAY::ABSI(a_1));
 * GRAPHICS::END_TEXT_COMMAND_SCALEFORM_STRING();
 * GRAPHICS::BEGIN_TEXT_COMMAND_SCALEFORM_STRING("STRING");
 * UI::_ADD_TEXT_COMPONENT_STRING(a_2);
 * GRAPHICS::END_TEXT_COMMAND_SCALEFORM_STRING();
 * GRAPHICS::BEGIN_TEXT_COMMAND_SCALEFORM_STRING("STRTNM2");
 * UI::_0x17299B63C7683A2B(v_3);
 * UI::_0x17299B63C7683A2B(v_4);
 * GRAPHICS::END_TEXT_COMMAND_SCALEFORM_STRING();
 * GRAPHICS::BEGIN_TEXT_COMMAND_SCALEFORM_STRING("STRTNM1");
 * UI::_0x17299B63C7683A2B(v_3);
 * GRAPHICS::END_TEXT_COMMAND_SCALEFORM_STRING();
 */
window.BeginTextCommandScaleformString = function (componentType) {
	return _in(0x80338406, 0xf3475e55, _ts(componentType));
};
window.BeginTextComponent = window.BeginTextCommandScaleformString;

/**
 * Starts a text command to change the name of a blip displayed in the pause menu.
 * This should be paired with [`END_TEXT_COMMAND_SET_BLIP_NAME`](#_0xBC38B49BCB83BC9B), once adding all required text components.
 * @param textLabel The text label to set.
 */
window.BeginTextCommandSetBlipName = function (textLabel) {
	return _in(0xf9113a30, 0xde5c6670, _ts(textLabel));
};

/**
 * void message(char *text)
 * {
 * _BEGIN_TEXT_COMMAND_TIMER("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * _END_TEXT_COMMAND_TIMER(0);
 * }
 */
window.BeginTextCommandTimer = function (p0) {
	return _in(0x8f9ee568, 0x7f8eeccd, _ts(p0));
};
window.N_0x8f9ee5687f8eeccd = window.BeginTextCommandTimer;

/**
 * Example:
 * _BEGIN_TEXT_COMMAND_WIDTH("NUMBER");
 * ADD_TEXT_COMPONENT_FLOAT(69.420f, 2);
 * float width = _END_TEXT_COMMAND_GET_WIDTH(true);
 */
window.BeginTextCommandWidth = function (text) {
	return _in(0x54ce8ac9, 0x8e120cab, _ts(text));
};
window.SetTextEntryForWidth = window.BeginTextCommandWidth;

/**
 * Plays the siren sound of a vehicle which is otherwise activated when fastly double-pressing the horn key.
 * Only works on vehicles with a police siren.
 */
window.BlipSiren = function (vehicle) {
	return _in(0x1b9025bd, 0xa76822b6, vehicle);
};

window.BlockDecisionMakerEvent = function (name, type) {
	return _in(0xe42fcdfd, 0x0e4196f7, _ch(name), type);
};

/**
 * calling this each frame, it stops the player from receiving a weapon via the weapon wheel.
 */
window.BlockWeaponWheelThisFrame = function () {
	return _in(0x0afc4af5, 0x10774b47);
};
window.N_0x0afc4af510774b47 = window.BlockWeaponWheelThisFrame;

window.BreakEntityGlass = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10) {
	return _in(0x2e648d16, 0xf6e308f3, p0, _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), p9, p10);
};

/**
 * Calculates the travel distance between a set of points.
 * Doesn't seem to correlate with distance on gps sometimes.
 */
window.CalculateTravelDistanceBetweenPoints = function (x1, y1, z1, x2, y2, z2) {
	return _in(0xadd95c70, 0x05c4a197, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _r, _rf);
};

/**
 * This is similar to the PushScaleformMovieFunction natives, except it calls in the `TIMELINE` of a minimap overlay.
 * @param miniMap The minimap overlay ID.
 * @param fnName A function in the overlay's TIMELINE.
 */
window.CallMinimapScaleformFunction = function (miniMap, fnName) {
	return _in(0x00000000, 0x4c89c0ed, miniMap, _ts(fnName), _r);
};

/**
 * Calls the Scaleform function and passes the parameters as floats.
 * The number of parameters passed to the function varies, so the end of the parameter list is represented by -1.0.
 */
window.CallScaleformMovieFunctionFloatParams = function (scaleform, functionName, param1, param2, param3, param4, param5) {
	return _in(0xd0837058, 0xae2e4bee, scaleform, _ts(functionName), _fv(param1), _fv(param2), _fv(param3), _fv(param4), _fv(param5));
};

/**
 * Calls the Scaleform function and passes both float and string parameters (in their respective order).
 * The number of parameters passed to the function varies, so the end of the float parameters is represented by -1.0, and the end of the string parameters is represented by 0 (NULL).
 * NOTE: The order of parameters in the function prototype is important! All float parameters must come first, followed by the string parameters.
 * Examples:
 * // function MY_FUNCTION(floatParam1, floatParam2, stringParam)
 * GRAPHICS::_CALL_SCALEFORM_MOVIE_FUNCTION_MIXED_PARAMS(scaleform, "MY_FUNCTION", 10.0, 20.0, -1.0, -1.0, -1.0, "String param", 0, 0, 0, 0);
 * // function MY_FUNCTION_2(floatParam, stringParam1, stringParam2)
 * GRAPHICS::_CALL_SCALEFORM_MOVIE_FUNCTION_MIXED_PARAMS(scaleform, "MY_FUNCTION_2", 10.0, -1.0, -1.0, -1.0, -1.0, "String param #1", "String param #2", 0, 0, 0);
 */
window.CallScaleformMovieFunctionMixedParams = function (scaleform, functionName, floatParam1, floatParam2, floatParam3, floatParam4, floatParam5, stringParam1, stringParam2, stringParam3, stringParam4, stringParam5) {
	return _in(0xef662d8d, 0x57e290b1, scaleform, _ts(functionName), _fv(floatParam1), _fv(floatParam2), _fv(floatParam3), _fv(floatParam4), _fv(floatParam5), _ts(stringParam1), _ts(stringParam2), _ts(stringParam3), _ts(stringParam4), _ts(stringParam5));
};

/**
 * Calls the Scaleform function and passes the parameters as strings.
 * The number of parameters passed to the function varies, so the end of the parameter list is represented by 0 (NULL).
 */
window.CallScaleformMovieFunctionStringParams = function (scaleform, functionName, param1, param2, param3, param4, param5) {
	return _in(0x51bc1ed3, 0xcc44e8f7, scaleform, _ts(functionName), _ts(param1), _ts(param2), _ts(param3), _ts(param4), _ts(param5));
};

/**
 * Calls the Scaleform function.
 */
window.CallScaleformMovieMethod = function (scaleform, method) {
	return _in(0xfbd96d87, 0xac96d533, scaleform, _ts(method));
};
window.CallScaleformMovieFunctionVoid = window.CallScaleformMovieMethod;

window.CanCreateRandomBikeRider = function () {
	return _in(0xeaceeda8, 0x1751915c, _r);
};

window.CanCreateRandomCops = function () {
	return _in(0x5ee2caff, 0x7f17770d, _r);
};

window.CanCreateRandomDriver = function () {
	return _in(0xb8eb95e5, 0xb4e56978, _r);
};

window.CanCreateRandomPed = function (unk) {
	return _in(0x3e8349c0, 0x8e4b82e4, unk, _r);
};

window.CanKnockPedOffVehicle = function (ped) {
	return _in(0x51ac07a4, 0x4d4f5b8a, ped, _r);
};

window.CanPedHearPlayer = function (player, ped) {
	return _in(0xf297383a, 0xa91dca29, player, ped, _r);
};

window.CanPedInCombatSeeTarget = function (ped, target) {
	return _in(0xead42de3, 0x610d0721, ped, target, _r);
};

/**
 * Prevents the ped from going limp.
 * [Example: Can prevent peds from falling when standing on moving vehicles.]
 */
window.CanPedRagdoll = function (ped) {
	return _in(0x128f79ed, 0xcece4fd5, ped, _r);
};

/**
 * Returns true if ped1 can see ped2 in their line of vision
 */
window.CanPedSeePed = function (ped1, ped2) {
	return _in(0x6cd5a433, 0x374d4cfb, ped1, ped2, _r);
};
window.N_0x6cd5a433374d4cfb = window.CanPedSeePed;

/**
 * Checks if the ped can play the speech or has the speech file, last parameter is usually 0
 */
window.CanPedSpeak = function (ped, speechName, unk) {
	return _in(0x49b99bf3, 0xfda89a7a, ped, _ts(speechName), unk, _r);
};
window.N_0x49b99bf3fda89a7a = window.CanPedSpeak;

/**
 * This one is weird and seems to return a TRUE state regardless of whether the phone is visible on screen or tucked away.
 * I can confirm the above. This function is hard-coded to always return 1.
 */
window.CanPhoneBeSeenOnScreen = function () {
	return _in(0xc4e28138, 0x98c97a4b, _r);
};

/**
 * if(_CAN_PLAY_ONLINE() == 0) means the player is banned(Social Club or Rockstar)
 */
window.CanPlayOnline = function () {
	return _in(0x5f91d5d0, 0xb36aa310, _r);
};
window.IsPlayerBanned = window.CanPlayOnline;

window.CanPlayerStartMission = function (player) {
	return _in(0xde7465a2, 0x7d403c06, player, _r);
};

/**
 * if (CAN_REGISTER_MISSION_ENTITIES(20, 20, 20, 10))
 * {
 * }
 */
window.CanRegisterMissionEntities = function (ped_amt, vehicle_amt, object_amt, pickup_amt) {
	return _in(0x69778e75, 0x64bade6d, ped_amt, vehicle_amt, object_amt, pickup_amt, _r);
};

window.CanRegisterMissionObjects = function (amount) {
	return _in(0x800dd472, 0x1a8b008b, amount, _r);
};

window.CanRegisterMissionPeds = function (amount) {
	return _in(0xbcbf4fef, 0x9fa5d781, amount, _r);
};

window.CanRegisterMissionPickups = function (p0) {
	return _in(0x0a49d1cb, 0x6e34af72, p0, _r);
};

window.CanRegisterMissionVehicles = function (amount) {
	return _in(0x7277f1f2, 0xe085ee74, amount, _r);
};

/**
 * modelHash (p1) was always 0 in R* scripts
 */
window.CanSetEnterStateForRegisteredEntity = function (cutsceneEntName, modelHash) {
	return _in(0x645d0b45, 0x8d8e17b5, _ts(cutsceneEntName), _ch(modelHash), _r);
};

window.CanSetExitStateForCamera = function (p0) {
	return _in(0xb2cbcd09, 0x30dfb420, p0, _r);
};

window.CanSetExitStateForRegisteredEntity = function (cutsceneEntName, modelHash) {
	return _in(0x4c6a6451, 0xc79e4662, _ts(cutsceneEntName), _ch(modelHash), _r);
};

window.CanShuffleSeat = function (vehicle, p1) {
	return _in(0x30785d90, 0xc956bf35, vehicle, p1, _r);
};

/**
 * this returns if you can use the weapon while using a parachute
 */
window.CanUseWeaponOnParachute = function (weaponHash) {
	return _in(0xbc7be5ab, 0xc0879f74, _ch(weaponHash), _r);
};

window.CanVehicleParachuteBeActivated = function (vehicle) {
	return _in(0xa916396d, 0xf4154ee3, vehicle, _r);
};

/**
 * Cancels the currently executing event.
 */
window.CancelEvent = function () {
	return _in(0x00000000, 0xfa29d35d);
};

/**
 * All music event names found in the b617d scripts: pastebin.com/GnYt0R3P
 */
window.CancelMusicEvent = function (eventName) {
	return _in(0x5b17a902, 0x91133da5, _ts(eventName), _r);
};

window.CancelStuntJump = function () {
	return _in(0xe6b7b0ac, 0xd4e4b75e);
};

/**
 * Does something similar to INTERIOR::DISABLE_INTERIOR
 */
window.CapInterior = function (interiorID, toggle) {
	return _in(0xd9175f94, 0x1610db54, interiorID, toggle);
};

/**
 * I'm guessing this rounds a float value up to the next whole number, and FLOOR rounds it down
 */
window.Ceil = function (value) {
	return _in(0x11e019c8, 0xf43acc8a, _fv(value), _r, _ri);
};

window.CellCamActivate = function (p0, p1) {
	return _in(0xfde8f069, 0xc542d126, p0, p1);
};

/**
 * hash collision???
 */
window.CellCamIsCharVisibleNoFaceCheck = function (entity) {
	return _in(0x439e9bc9, 0x5b7e7fbe, entity, _r);
};

/**
 * When calling this, the current frame will have the players "arrow icon" be focused on the dead center of the radar.
 */
window.CenterPlayerOnRadarThisFrame = function () {
	return _in(0x6d14bfdc, 0x33b34f55);
};

/**
 * b2 and/or b3 maybe got something to do with keeping values from the last ped. Both of them set to 1 works great. <br/><br/>Examples from the decompiled scripts:<br/><br/>PLAYER::CHANGE_PLAYER_PED(PLAYER::PLAYER_ID(), l_5C0[4 -- [[14]] ], 0, 1);<br/>PLAYER::CHANGE_PLAYER_PED(PLAYER::PLAYER_ID(), a_0[a_0._f7 -- [[1]] ], a_2, 0);<br/><br/><br/>===========================================================<br/>The only way I ever got this to work in GTA Online once is by setting both to 0, 0. However, when you switch from your online character to whomever, your character will start walking away 'as if you left the game.' If from there you attempt to call this native once more to switch back to you online ped. You will freeze or if you try changing to another ped. I've tried all posibilities so far.<br/>1, 1 (Freeze), 0, 0(Works Once), 1, 0 & 0, 1 (Freeze). Note of course trying to call this on another online player will crash. Anyone have any idea if implementing a blr within the xex itself on a possible check if it would prevent this freezing?<br/>===========================================================
 */
window.ChangePlayerPed = function (Player, ped, b2, b3) {
	return _in(0x048189fa, 0xc643deee, Player, ped, b2, b3);
};

/**
 * minimum: Degrees between -90f and 90f.
 * maximum: Degrees between -90f and 90f.
 * Clamps the gameplay camera's current pitch.
 * Eg. _CLAMP_GAMEPLAY_CAM_PITCH(0.0f, 0.0f) will set the vertical angle directly behind the player.
 */
window.ClampGameplayCamPitch = function (minimum, maximum) {
	return _in(0xa516c198, 0xb7dca1e1, _fv(minimum), _fv(maximum), _r, _ri);
};

/**
 * minimum: Degrees between -180f and 180f.
 * maximum: Degrees between -180f and 180f.
 * Clamps the gameplay camera's current yaw.
 * Eg. _CLAMP_GAMEPLAY_CAM_YAW(0.0f, 0.0f) will set the horizontal angle directly behind the player.
 */
window.ClampGameplayCamYaw = function (minimum, maximum) {
	return _in(0x8f993d26, 0xe0ca5e8e, _fv(minimum), _fv(maximum), _r, _ri);
};

window.CleanItemset = function (p0) {
	return _in(0x41bc0d72, 0x2fc04221, p0);
};

window.ClearAdditionalText = function (p0, p1) {
	return _in(0x2a179df1, 0x7ccf04cd, p0, p1);
};

/**
 * Removes broken glass particles.
 */
window.ClearAllBrokenGlass = function () {
	return _in(0xb32209ef, 0xfdc04913);
};

window.ClearAllHelpMessages = function () {
	return _in(0x6178f68a, 0x87a4d3a0);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.ClearAllPedProps = function (ped) {
	return _in(0xcd8a7537, 0xa9b52f06, ped);
};

window.ClearAmbientZoneListState = function (p1) {
	return _in(0x120c48c6, 0x14909fa4, _i, p1);
};

/**
 * This function also has a p2, unknown. Signature AUDIO::CLEAR_AMBIENT_ZONE_STATE(char* zoneName, bool p1, Any p2);
 * Still needs more research.
 * Here are the names I've found: pastebin.com/AfA0Qjyv
 * New Ambient Zone List (Combind with old): pastebin.com/h8BsKgUD -DasChaos
 */
window.ClearAmbientZoneState = function (zoneName, p1) {
	return _in(0x218dd44a, 0xaac964ff, _ts(zoneName), p1);
};

window.ClearAngledAreaOfVehicles = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11) {
	return _in(0x11db3500, 0xf042a8aa, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, p8, p9, p10, p11);
};

/**
 * Example: CLEAR_AREA(0, 0, 0, 30, true, false, false, false);
 */
window.ClearArea = function (X, Y, Z, radius, p4, ignoreCopCars, ignoreObjects, p7) {
	return _in(0xa56f01f3, 0x765b93a0, _fv(X), _fv(Y), _fv(Z), _fv(radius), p4, ignoreCopCars, ignoreObjects, p7);
};

window.ClearAreaOfCops = function (x, y, z, radius, flags) {
	return _in(0x04f8fc8f, 0xcf58f88d, _fv(x), _fv(y), _fv(z), _fv(radius), flags);
};

/**
 * GAMEPLAY::_0x957838AAF91BD12D(x, y, z, radius, false, false, false, false); seem to make all objects go away, peds, vehicles etc. All booleans set to true doesn't seem to change anything.
 */
window.ClearAreaOfEverything = function (x, y, z, radius, p4, p5, p6, p7) {
	return _in(0x957838aa, 0xf91bd12d, _fv(x), _fv(y), _fv(z), _fv(radius), p4, p5, p6, p7);
};
window.N_0x957838aaf91bd12d = window.ClearAreaOfEverything;

/**
 * I looked through the PC scripts that this site provides you with a link to find. It shows the last param mainly uses, (0, 2, 6, 16, and 17) so I am going to assume it is a type of flag.
 */
window.ClearAreaOfObjects = function (x, y, z, radius, flags) {
	return _in(0xdd9b9b38, 0x5aac7f5b, _fv(x), _fv(y), _fv(z), _fv(radius), flags);
};

/**
 * Example: 		CLEAR_AREA_OF_PEDS(0, 0, 0, 10000, 1);
 */
window.ClearAreaOfPeds = function (x, y, z, radius, flags) {
	return _in(0xbe31fd6c, 0xe464ac59, _fv(x), _fv(y), _fv(z), _fv(radius), flags);
};

window.ClearAreaOfProjectiles = function (x, y, z, radius, isNetworkGame) {
	return _in(0x0a1cb909, 0x4635d1a6, _fv(x), _fv(y), _fv(z), _fv(radius), isNetworkGame);
};

/**
 * Example: 		CLEAR_AREA_OF_VEHICLES(0, 0, 0, 10000, false, false, false, false, false);
 */
window.ClearAreaOfVehicles = function (x, y, z, radius, p4, p5, p6, p7, p8) {
	return _in(0x01c7b9b3, 0x8428aeb6, _fv(x), _fv(y), _fv(z), _fv(radius), p4, p5, p6, p7, p8);
};

/**
 * This sets bit [offset] of [address] to off.
 * Example:
 * GAMEPLAY::CLEAR_BIT(&bitAddress, 1);
 * To check if this bit has been enabled:
 * GAMEPLAY::IS_BIT_SET(bitAddress, 1); // will return 0 afterwards
 */
window.ClearBit = function (offset) {
	return _in(0xe80492a9, 0xac099a93, _i, offset);
};

window.ClearBrief = function () {
	return _in(0x9d292f73, 0xadbd9313);
};

window.ClearCloudHat = function () {
	return _in(0x957e790e, 0xa1727b64);
};

window.ClearDecisionMakerEventResponse = function (name, type) {
	return _in(0x4fc9381a, 0x7aee8968, _ch(name), type);
};

/**
 * Resets the screen's draw-origin which was changed by the function GRAPHICS::SET_DRAW_ORIGIN(...) back to x=0,y=0.
 * See GRAPHICS::SET_DRAW_ORIGIN(...) for further information.
 */
window.ClearDrawOrigin = function () {
	return _in(0xff0b610f, 0x6be0d7af);
};

window.ClearDrivebyTaskUnderneathDrivingTask = function (ped) {
	return _in(0xc35b5cdb, 0x2824cf69, ped);
};

window.ClearEntityLastDamageEntity = function (entity) {
	return _in(0xa72cd9ca, 0x74a5ecba, entity, _r, _ri);
};

window.ClearEntityLastWeaponDamage = function (entity) {
	return _in(0xac678e40, 0xbe7c74d2, entity);
};

/**
 * Clears the secondary timecycle modifier usually set with [`SetExtraTimecycleModifier`](#_0X3B2FD68DB5F8331C)
 */
window.ClearExtraTimecycleModifier = function () {
	return _in(0x92ccc17a, 0x7a2285da);
};
window.N_0x92ccc17a7a2285da = window.ClearExtraTimecycleModifier;

window.ClearFacialIdleAnimOverride = function (ped) {
	return _in(0x726256cc, 0x1eeb182f, ped);
};

/**
 * p0 looks like int in script
 */
window.ClearFloatingHelp = function (p0, p1) {
	return _in(0x50085246, 0xabd3fefa, p0, p1);
};

window.ClearFocus = function () {
	return _in(0x31b73d1e, 0xa9f01da2);
};

/**
 * Clears the GPS flags. Only the script that originally called SET_GPS_FLAGS can clear them.
 * Doesn't seem like the flags are actually read by the game at all.
 */
window.ClearGpsFlags = function () {
	return _in(0x21986729, 0xd6a3a830);
};

window.ClearGpsPlayerWaypoint = function () {
	return _in(0xff4fb7c8, 0xcdfa3da7);
};

window.ClearGpsRaceTrack = function () {
	return _in(0x7aa5b4ce, 0x533c858b);
};

window.ClearHdArea = function () {
	return _in(0xce58b1cf, 0xb9290813);
};

window.ClearHelp = function (toggle) {
	return _in(0x8dfced7a, 0x656f8802, toggle);
};

/**
 * _CLEAR_NOTIFICATIONS_POS(0.5f);
 */
window.ClearNotificationsPos = function (pos) {
	return _in(0x55598d21, 0x339cb998, _fv(pos));
};
window.N_0x55598d21339cb998 = window.ClearNotificationsPos;

window.ClearOverrideWeather = function () {
	return _in(0x338d2e34, 0x77711050);
};

window.ClearPedAlternateMovementAnim = function (ped, stance, p2) {
	return _in(0xd8d19675, 0xed5fbdce, ped, stance, _fv(p2));
};

window.ClearPedAlternateWalkAnim = function (ped, p1) {
	return _in(0x8844bbfc, 0xe30aa9e9, ped, _fv(p1));
};

window.ClearPedBloodDamage = function (ped) {
	return _in(0x8fe22675, 0xa5a45817, ped);
};

/**
 * Somehow related to changing ped's clothes.
 */
window.ClearPedBloodDamageByZone = function (ped, p1) {
	return _in(0x56e3b78c, 0x5408d9f4, ped, p1);
};
window.N_0x56e3b78c5408d9f4 = window.ClearPedBloodDamageByZone;

/**
 * p1: from 0 to 5 in the b617d scripts.
 * p2: "blushing" and "ALL" found in the b617d scripts.
 */
window.ClearPedDamageDecalByZone = function (ped, p1, p2) {
	return _in(0x523c79ae, 0xefcc4a2a, ped, p1, _ts(p2));
};
window.N_0x523c79aeefcc4a2a = window.ClearPedDamageDecalByZone;

window.ClearPedDecorations = function (ped) {
	return _in(0x0e5173c1, 0x63976e38, ped);
};

window.ClearPedDriveByClipsetOverride = function (ped) {
	return _in(0x4afe3690, 0xd7e0b5ac, ped);
};

window.ClearPedFacialDecorations = function (ped) {
	return _in(0xe3b27e70, 0xceab9f0c, ped);
};
window.N_0xe3b27e70ceab9f0c = window.ClearPedFacialDecorations;

window.ClearPedInPauseMenu = function () {
	return _in(0x5e62be5d, 0xc58e9e06);
};

window.ClearPedLastDamageBone = function (ped) {
	return _in(0x8ef6b7ac, 0x68e2f01b, ped);
};

window.ClearPedLastWeaponDamage = function (ped) {
	return _in(0x0e98f88a, 0x24c5f4b8, ped);
};

window.ClearPedNonCreationArea = function () {
	return _in(0x2e052080, 0x86ba0651);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.ClearPedProp = function (ped, propId) {
	return _in(0x0943e5b8, 0xe078e76e, ped, propId);
};

/**
 * Removes the scubagear (for mp male: component id: 8, drawableId: 123, textureId: any) from peds. Does not play the 'remove scuba gear' animation, but instantly removes it.
 * @param ped The ped to remove the scuba gear from.
 */
window.ClearPedScubaGearVariation = function (ped) {
	return _in(0xb50eb4cc, 0xb29704ac, ped);
};
window.N_0xb50eb4ccb29704ac = window.ClearPedScubaGearVariation;
window.RemovePedScubaGearNow = window.ClearPedScubaGearVariation;

window.ClearPedSecondaryTask = function (ped) {
	return _in(0x176cecf6, 0xf920d707, ped);
};

window.ClearPedTasks = function (ped) {
	return _in(0xe1ef3c12, 0x16aff2cd, ped);
};

/**
 * Immediately stops the pedestrian from whatever it's doing. They stop fighting, animations, etc. they forget what they were doing.
 */
window.ClearPedTasksImmediately = function (ped) {
	return _in(0xaaa34f8a, 0x7cb32098, ped);
};

/**
 * It clears the wetness of the selected Ped/Player. Clothes have to be wet to notice the difference.
 */
window.ClearPedWetness = function (ped) {
	return _in(0x9c720776, 0xdaa43e7e, ped);
};

window.ClearPlayerHasDamagedAtLeastOneNonAnimalPed = function (player) {
	return _in(0x4aacb962, 0x03d11a31, player);
};

window.ClearPlayerHasDamagedAtLeastOnePed = function (player) {
	return _in(0xf0b67a4d, 0xe6ab5f98, player);
};

window.ClearPlayerParachuteModelOverride = function (player) {
	return _in(0x8753997e, 0xb5f6ee3f, player);
};

window.ClearPlayerParachutePackModelOverride = function (player) {
	return _in(0x10c54e43, 0x89c12b42, player);
};

window.ClearPlayerParachuteVariationOverride = function (player) {
	return _in(0x0f4cc924, 0xcf8c7b21, player);
};

/**
 * This executes at the same as speed as PLAYER::SET_PLAYER_WANTED_LEVEL(player, 0, false);
 * PLAYER::GET_PLAYER_WANTED_LEVEL(player); executes in less than half the time. Which means that it's worth first checking if the wanted level needs to be cleared before clearing. However, this is mostly about good code practice and can important in other situations. The difference in time in this example is negligible.
 */
window.ClearPlayerWantedLevel = function (player) {
	return _in(0xb3025405, 0x97885499, player);
};

/**
 * Only used once in the decompiled scripts. Seems to be related to scripted vehicle generators.
 * Modified example from "am_imp_exp.c4", line 6418:
 *  -- [[ popSchedules[0] = ZONE::GET_ZONE_POPSCHEDULE(ZONE::GET_ZONE_AT_COORDS(891.3, 807.9, 188.1));
 * etc.
 * ]] 
 * STREAMING::SET_MODEL_AS_NO_LONGER_NEEDED(vehicleHash);
 * ZONE::CLEAR_POPSCHEDULE_OVERRIDE_VEHICLE_MODEL(popSchedules[index]);
 */
window.ClearPopscheduleOverrideVehicleModel = function (scheduleId) {
	return _in(0x5c0de367, 0xaa0d911c, scheduleId);
};

window.ClearPrints = function () {
	return _in(0xcc33fa79, 0x1322b9d9);
};

/**
 * Clears the relationship between two groups. This should be called twice (once for each group).
 * Relationship types:
 * 0 = Companion
 * 1 = Respect
 * 2 = Like
 * 3 = Neutral
 * 4 = Dislike
 * 5 = Hate
 * 255 = Pedestrians
 * (Credits: Inco)
 * Example:
 * PED::CLEAR_RELATIONSHIP_BETWEEN_GROUPS(2, l_1017, 0xA49E591C);
 * PED::CLEAR_RELATIONSHIP_BETWEEN_GROUPS(2, 0xA49E591C, l_1017);
 */
window.ClearRelationshipBetweenGroups = function (relationship, group1, group2) {
	return _in(0x5e29243f, 0xb56fc6d4, relationship, _ch(group1), _ch(group2));
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.ClearReminderMessage = function () {
	return _in(0xb57d8dd6, 0x45cfa2cf);
};
window.N_0xb57d8dd645cfa2cf = window.ClearReminderMessage;

window.ClearReplayStats = function () {
	return _in(0x1b1ab132, 0xa16fda55);
};

window.ClearRoomForEntity = function (entity) {
	return _in(0xb365fc0c, 0x4e27ffa7, entity);
};

window.ClearSequenceTask = function (taskSequence) {
	return _in(0x3841422e, 0x9c488d8c, _ii(taskSequence) /* may be optional */, _r, _ri);
};

window.ClearSmallPrints = function () {
	return _in(0x2cea2839, 0x313c09ac);
};

/**
 * p0: found arguments in the b617d scripts: pastebin.com/X5akCN7z
 */
window.ClearThisPrint = function (p0) {
	return _in(0xcf708001, 0xe1e536dd, _ts(p0));
};

window.ClearTimecycleModifier = function () {
	return _in(0x0f07e774, 0x5a236711);
};

window.ClearVehicleCustomPrimaryColour = function (vehicle) {
	return _in(0x55e1d275, 0x8f34e437, vehicle, _r, _ri);
};

window.ClearVehicleCustomSecondaryColour = function (vehicle) {
	return _in(0x5ffbdeec, 0x3e8e2009, vehicle, _r, _ri);
};

window.ClearWeatherTypePersist = function () {
	return _in(0xccc39339, 0xbef76cf5);
};

/**
 * thisScriptCheck - can be destroyed if it belongs to the calling script.
 * Example of Cloning Your Player:
 * CLONE_PED(PLAYER_PED_ID(), GET_ENTITY_HEADING(PLAYER_PED_ID()), 0, 1);
 */
window.ClonePed = function (ped, heading, isNetwork, thisScriptCheck) {
	return _in(0xef29a163, 0x37facadb, ped, _fv(heading), isNetwork, thisScriptCheck, _r, _ri);
};

/**
 * What exactly is the difference? What does this exactly do by chance?
 * ^ Copies ped's components and props to targetPed.
 * ---------------------------------------------------------------------------------
 * | Internally has a 3rd param (bool) which is set to true by default |
 */
window.ClonePedToTarget = function (ped, targetPed) {
	return _in(0xe952d643, 0x1689ad9a, ped, targetPed);
};
window.AssignPlayerToPed = window.ClonePedToTarget;

window.CloseBombBayDoors = function (vehicle) {
	return _in(0x35560417, 0x42a0dc74, vehicle);
};
window.N_0x3556041742a0dc74 = window.CloseBombBayDoors;

window.ClosePatrolRoute = function () {
	return _in(0xb043eca8, 0x01b8cbc1);
};

window.CloseSequenceTask = function (taskSequence) {
	return _in(0x39e72bc9, 0x9e6360cb, taskSequence, _r, _ri);
};

/**
 * Commits the backing pixels to the specified runtime texture.
 * @param tex The runtime texture handle.
 */
window.CommitRuntimeTexture = function (tex) {
	return _in(0x00000000, 0x19d81f4e, tex);
};

/**
 * Compares two strings up to a specified number of characters.
 * Parameters:
 * str1 - String to be compared.
 * str2 - String to be compared.
 * matchCase - Comparison will be case-sensitive.
 * maxLength - Maximum number of characters to compare. A value of -1 indicates an infinite length.
 * Returns:
 * A value indicating the relationship between the strings:
 * <0 - The first non-matching character in 'str1' is less than the one in 'str2'. (e.g. 'A' < 'B', so result = -1)
 * 0 - The contents of both strings are equal.
 * >0 - The first non-matching character in 'str1' is less than the one in 'str2'. (e.g. 'B' > 'A', so result = 1)
 * Examples:
 * GAMEPLAY::COMPARE_STRINGS("STRING", "string", false, -1); // 0; equal
 * GAMEPLAY::COMPARE_STRINGS("TESTING", "test", false, 4); // 0; equal
 * GAMEPLAY::COMPARE_STRINGS("R2D2", "R2xx", false, 2); // 0; equal
 * GAMEPLAY::COMPARE_STRINGS("foo", "bar", false, -1); // 4; 'f' > 'b'
 * GAMEPLAY::COMPARE_STRINGS("A", "A", true, 1); // 0; equal
 * When comparing case-sensitive strings, lower-case characters are greater than upper-case characters:
 * GAMEPLAY::COMPARE_STRINGS("A", "a", true, 1); // -1; 'A' < 'a'
 * GAMEPLAY::COMPARE_STRINGS("a", "A", true, 1); // 1; 'a' > 'A'
 */
window.CompareStrings = function (str1, str2, matchCase, maxLength) {
	return _in(0x1e34710e, 0xcd4ab0eb, _ts(str1), _ts(str2), matchCase, maxLength, _r, _ri);
};

/**
 * Works for vehicles with a retractable landing gear
 * landing gear states:
 * 0: Deployed
 * 1: Closing
 * 2: Opening
 * 3: Retracted
 */
window.ControlLandingGear = function (vehicle, state) {
	return _in(0xcfc8be9a, 0x5e1fe575, vehicle, state);
};
window.SetVehicleLandingGear = window.ControlLandingGear;

/**
 * Forces the ped to use the mounted weapon.
 * Returns false if task is not possible.
 */
window.ControlMountedWeapon = function (ped) {
	return _in(0xdcfe4206, 0x8fe0135a, ped, _r);
};

window.Cos = function (value) {
	return _in(0xd0ffb162, 0xf40a139c, _fv(value), _r, _rf);
};

/**
 * Used for doing money drop
 * Pickup hashes: pastebin.com/8EuSv2r1
 */
window.CreateAmbientPickup = function (pickupHash, posX, posY, posZ, p4, value, modelHash, returnHandle, p8) {
	return _in(0x673966a0, 0xc0fd7171, _ch(pickupHash), _fv(posX), _fv(posY), _fv(posZ), p4, value, _ch(modelHash), returnHandle, p8, _r, _ri);
};

/**
 * "DEFAULT_SCRIPTED_CAMERA"
 * "DEFAULT_ANIMATED_CAMERA"
 * "DEFAULT_SPLINE_CAMERA"
 * "DEFAULT_SCRIPTED_FLY_CAMERA"
 * "TIMED_SPLINE_CAMERA"
 */
window.CreateCam = function (Gippo, p1) {
	return _in(0xc3981dce, 0x61d9e13f, _ts(Gippo), p1, _r, _ri);
};

/**
 * camName is always set to "DEFAULT_SCRIPTED_CAMERA" in Rockstar's scripts.
 * ------------
 * Camera names found in the b617d scripts:
 * "DEFAULT_ANIMATED_CAMERA"
 * "DEFAULT_SCRIPTED_CAMERA"
 * "DEFAULT_SCRIPTED_FLY_CAMERA"
 * "DEFAULT_SPLINE_CAMERA"
 * ------------
 * Side Note: It seems p8 is basically to represent what would be the bool p1 within CREATE_CAM native. As well as the p9 since it's always 2 in scripts seems to represent what would be the last param within SET_CAM_ROT native which normally would be 2.
 */
window.CreateCamWithParams = function (camName, posX, posY, posZ, rotX, rotY, rotZ, fov, p8, p9) {
	return _in(0xb5119480, 0x0b257161, _ts(camName), _fv(posX), _fv(posY), _fv(posZ), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(fov), p8, p9, _r, _ri);
};

window.CreateCamera = function (camHash, p1) {
	return _in(0x5e3cf89c, 0x6bcca67d, _ch(camHash), p1, _r, _ri);
};

/**
 * CAM::_GET_GAMEPLAY_CAM_COORDS can be used instead of posX,Y,Z
 * CAM::_GET_GAMEPLAY_CAM_ROT can be used instead of rotX,Y,Z
 * CAM::_80EC114669DAEFF4() can be used instead of p7 (Possible p7 is FOV parameter. )
 * p8 ???
 * p9 uses 2 by default
 */
window.CreateCameraWithParams = function (camHash, posX, posY, posZ, rotX, rotY, rotZ, fov, p8, p9) {
	return _in(0x6abfa3e1, 0x6460f22d, _ch(camHash), _fv(posX), _fv(posY), _fv(posZ), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(fov), p8, p9, _r, _ri);
};

/**
 * Creates a checkpoint. Returns the handle of the checkpoint.
 * 20/03/17 : Attention, checkpoints are already handled by the game itself, so you must not loop it like markers.
 * Parameters:
 * * type - The type of checkpoint to create. See below for a list of checkpoint types.
 * * pos1 - The position of the checkpoint.
 * * pos2 - The position of the next checkpoint to point to.
 * * radius - The radius of the checkpoint.
 * * color - The color of the checkpoint.
 * * reserved - Special parameter, see below for details. Usually set to 0 in the scripts.
 * Checkpoint types:
 * 0-4---------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 5-9---------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 10-14-------Ring: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 15-19-------1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 20-24-------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 25-29-------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 30-34-------Cylinder: 1 arrow, 2 arrow, 3 arrows, CycleArrow, Checker
 * 35-38-------Ring: Airplane Up, Left, Right, UpsideDown
 * 39----------?
 * 40----------Ring: just a ring
 * 41----------?
 * 42-44-------Cylinder w/ number (uses 'reserved' parameter)
 * 45-47-------Cylinder no arrow or number
 * If using type 42-44, reserved sets number / number and shape to display
 * 0-99------------Just numbers (0-99)
 * 100-109-----------------Arrow (0-9)
 * 110-119------------Two arrows (0-9)
 * 120-129----------Three arrows (0-9)
 * 130-139----------------Circle (0-9)
 * 140-149------------CycleArrow (0-9)
 * 150-159----------------Circle (0-9)
 * 160-169----Circle  w/ pointer (0-9)
 * 170-179-------Perforated ring (0-9)
 * 180-189----------------Sphere (0-9)
 */
window.CreateCheckpoint = function (type, posX1, posY1, posZ1, posX2, posY2, posZ2, radius, red, green, blue, alpha, reserved) {
	return _in(0x0134f083, 0x5ab6bfcb, type, _fv(posX1), _fv(posY1), _fv(posZ1), _fv(posX2), _fv(posY2), _fv(posZ2), _fv(radius), red, green, blue, alpha, reserved, _r, _ri);
};

window.CreateCinematicShot = function (p0, p1, p2, entity) {
	return _in(0x741b0129, 0xd4560f31, p0, p1, p2, entity);
};

/**
 * Creates a DUI browser. This can be used to draw on a runtime texture using CREATE_RUNTIME_TEXTURE_FROM_DUI_HANDLE.
 * @param url The initial URL to load in the browser.
 * @param width The width of the backing surface.
 * @param height The height of the backing surface.
 * @return A DUI object.
 */
window.CreateDui = function (url, width, height) {
	return _in(0x00000000, 0x23eaf899, _ts(url), width, height, _r, _rl);
};

window.CreateForcedObject = function (x, y, z, p3, modelHash, p5) {
	return _in(0x150e808b, 0x375a385a, _fv(x), _fv(y), _fv(z), p3, _ch(modelHash), p5);
};

/**
 * Creates a new ped group.
 * Groups can contain up to 8 peds.
 * The parameter is unused.
 * Returns a handle to the created group, or 0 if a group couldn't be created.
 */
window.CreateGroup = function (unused) {
	return _in(0x90370ebe, 0x0fee1a3d, unused, _r, _ri);
};

/**
 * enum IncidentTypes
 * {
 * FireDepartment = 3,
 * Paramedics = 5,
 * Police = 7,
 * PedsInCavalcades = 11,
 * Merryweather = 14
 * };
 * As for the 'police' incident, it will call police cars to you, but unlike PedsInCavalcades & Merryweather they won't start shooting at you unless you shoot first or shoot at them. The top 2 however seem to cancel theirselves if there is noone dead around you or a fire. I only figured them out as I found out the 3rd param is definately the amountOfPeople and they called incident 3 in scripts with 4 people (which the firetruck has) and incident 5 with 2 people (which the ambulence has). The 4 param I cant say is radius, but for the pedsInCavalcades and Merryweather R* uses 0.0f and for the top 3 (Emergency Services) they use 3.0f.
 * Side Note: It seems calling the pedsInCavalcades or Merryweather then removing it seems to break you from calling the EmergencyEvents and I also believe pedsInCavalcades. (The V cavalcades of course not IV).
 * Side Note 2: I say it breaks as if you call this proper,
 * if(CREATE_INCIDENT) etc it will return false if you do as I said above.
 * =====================================================
 */
window.CreateIncident = function (incidentType, x, y, z, p5, radius, outIncidentID) {
	return _in(0x3f892caf, 0x67444ae7, incidentType, _fv(x), _fv(y), _fv(z), p5, _fv(radius), _ii(outIncidentID) /* may be optional */, _r);
};

/**
 * p0 could be type (valueused in scripts: 14, 7, 5, 3, 11)
 * p1 is a return from get_player_ped() in am_gang_call.c, but player_ped_id() in other (non am) scripts.
 * p3 is usually 0f or 3f
 * =====================================================
 * enum IncidentTypes
 * {
 * FireDepartment = 3,
 * Paramedics = 5,
 * Police = 7,
 * PedsInCavalcades = 11,
 * Merryweather = 14
 * };
 * As for the 'police' incident, it will call police cars to you, but unlike PedsInCavalcades & Merryweather they won't start shooting at you unless you shoot first or shoot at them. The top 2 however seem to cancel theirselves if there is noone dead around you or a fire. I only figured them out as I found out the 3rd param is definately the amountOfPeople and they called incident 3 in scripts with 4 people (which the firetruck has) and incident 5 with 2 people (which the ambulence has). The 4 param I cant say is radius, but for the pedsInCavalcades and Merryweather R* uses 0.0f and for the top 3 (Emergency Services) they use 3.0f.
 * Side Note: It seems calling the pedsInCavalcades or Merryweather then removing it seems to break you from calling the EmergencyEvents and I also believe pedsInCavalcades. (The V cavalcades of course not IV).
 * Side Note 2: I say it breaks as if you call this proper,
 * if(CREATE_INCIDENT) etc it will return false if you do as I said above.
 * =====================================================
 */
window.CreateIncidentWithEntity = function (incidentType, ped, amountOfPeople, radius, outIncidentID) {
	return _in(0x05983472, 0xf0494e60, incidentType, ped, amountOfPeople, _fv(radius), _ii(outIncidentID) /* may be optional */, _r);
};

window.CreateItemset = function (distri) {
	return _in(0x35ad299f, 0x50d91b24, distri, _r, _ri);
};

/**
 * creates single lightning+thunder at random position
 */
window.CreateLightningThunder = function () {
	return _in(0xf6062e08, 0x9251c898);
};

/**
 * Train models HAVE TO be loaded (requested) before you use this.
 * For variation 15 - request:
 * freight
 * freightcar
 * freightgrain
 * freightcont1
 * freightcont2
 * freighttrailer
 */
window.CreateMissionTrain = function (variation, x, y, z, direction) {
	return _in(0x63c6cca8, 0xe68ae8c8, variation, _fv(x), _fv(y), _fv(z), direction, _r, _ri);
};

/**
 * Creates a mobile phone of the specified type.
 * Possible phone types:
 * 0 - Default phone / Michael's phone
 * 1 - Trevor's phone
 * 2 - Franklin's phone
 * 4 - Prologue phone
 * These values represent bit flags, so a value of '3' would toggle Trevor and Franklin's phones together, causing unexpected behavior and most likely crash the game.
 */
window.CreateMobilePhone = function (p3) {
	return _in(0xa4e8e696, 0xc532fbc7, p3);
};

/**
 * p5 = sets as true in scripts
 * Same as the comment for CREATE_MODEL_SWAP unless for some reason p5 affects it this only works with objects as well.
 * Network players do not see changes done with this.
 */
window.CreateModelHide = function (x, y, z, radius, model, p5) {
	return _in(0x8a97bca3, 0x0a0ce478, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(model), p5);
};

window.CreateModelHideExcludingScriptObjects = function (x, y, z, radius, model, p5) {
	return _in(0x3a52ae58, 0x8830bf7f, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(model), p5);
};

/**
 * Only works with objects!
 * Network players do not see changes done with this.
 */
window.CreateModelSwap = function (x, y, z, radius, originalModel, newModel, p6) {
	return _in(0x92c47782, 0xfda8b2a3, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(originalModel), _ch(newModel), p6);
};

/**
 * Spawns one or more money pickups.
 * x: The X-component of the world position to spawn the money pickups at.
 * y: The Y-component of the world position to spawn the money pickups at.
 * z: The Z-component of the world position to spawn the money pickups at.
 * value: The combined value of the pickups (in dollars).
 * amount: The number of pickups to spawn.
 * model: The model to use, or 0 for default money model.
 * Example:
 * CREATE_MONEY_PICKUPS(x, y, z, 1000, 3, 0x684a97ae);
 * Spawns 3 spray cans that'll collectively give $1000 when picked up. (Three spray cans, each giving $334, $334, $332 = $1000).
 * ==============================================
 * Max is 2000 in MP. So if you put the amount to 20, but the value to $400,000 eg. They will only be able to pickup 20 - $2,000 bags. So, $40,000
 */
window.CreateMoneyPickups = function (x, y, z, value, amount, model) {
	return _in(0x0589b5e7, 0x91ce9b2b, _fv(x), _fv(y), _fv(z), value, amount, _ch(model));
};

/**
 * p0 was the return of NET_TO_PED in fm_mission_controler.
 * p4 was always "".
 * returns headDisplayId
 */
window.CreateMpGamerTag = function (ped, username, pointedClanTag, isRockstarClan, clanTag, p5) {
	return _in(0xbfefe332, 0x1a3f5015, ped, _ts(username), pointedClanTag, isRockstarClan, _ts(clanTag), p5, _r, _ri);
};
window.N_0xbfefe3321a3f5015 = window.CreateMpGamerTag;

window.CreateNewScriptedConversation = function () {
	return _in(0xd2c91a0b, 0x572aae56);
};

/**
 * Creates a new NaturalMotion message.
 * startImmediately: If set to true, the character will perform the message the moment it receives it by GIVE_PED_NM_MESSAGE. If false, the Ped will get the message but won't perform it yet. While it's a boolean value, if negative, the message will not be initialized.
 * messageId: The ID of the NaturalMotion message.
 * If a message already exists, this function does nothing. A message exists until the point it has been successfully dispatched by GIVE_PED_NM_MESSAGE.
 */
window.CreateNmMessage = function (startImmediately, messageId) {
	return _in(0x418ef2a1, 0xbce56685, startImmediately, messageId);
};

/**
 * thisScriptCheck - can be destroyed if it belongs to the calling script.
 * p5 - last parameter does not mean object handle is returned
 * maybe a quick view in disassembly will tell us what is actually does
 * ----------
 * prop_tt_screenstatic (0xE2E039BC) is handled different. Not sure how yet but it I know it is.
 */
window.CreateObject = function (modelHash, x, y, z, isNetwork, thisScriptCheck, dynamic) {
	return _in(0x509d5878, 0xeb39e842, modelHash, _fv(x), _fv(y), _fv(z), isNetwork, thisScriptCheck, dynamic, _r, _ri);
};

/**
 * thisScriptCheck - can be destroyed if it belongs to the calling script.
 * p5 - does not mean object handle is returned
 * maybe a quick view in disassembly will tell us what is actually does
 * ----------
 * prop_tt_screenstatic (0xE2E039BC) is handled different. Not sure how yet but it I know it is.
 */
window.CreateObjectNoOffset = function (modelHash, x, y, z, isNetwork, thisScriptCheck, dynamic) {
	return _in(0x9a294b21, 0x38abb884, _ch(modelHash), _fv(x), _fv(y), _fv(z), isNetwork, thisScriptCheck, dynamic, _r, _ri);
};

window.CreatePatrolRoute = function () {
	return _in(0xaf8a443c, 0xcc8018dc);
};

/**
 * thisScriptCheck - can be destroyed if it belongs to the calling script.
 * p7 - last parameter does not mean ped handle is returned
 * maybe a quick view in disassembly will tell us what is actually does
 * *Heading*: 0.0
 * *Heading* is the Z axis spawn rotation of the ped 0->5th parameter.
 * Ped Types:
 * enum PedTypes
 * {
 * PED_TYPE_PLAYER_0,// michael
 * PED_TYPE_PLAYER_1,// franklin
 * PED_TYPE_NETWORK_PLAYER,	// mp character
 * PED_TYPE_PLAYER_2,// trevor
 * PED_TYPE_CIVMALE,
 * PED_TYPE_CIVFEMALE,
 * PED_TYPE_COP,
 * PED_TYPE_GANG_ALBANIAN,
 * PED_TYPE_GANG_BIKER_1,
 * PED_TYPE_GANG_BIKER_2,
 * PED_TYPE_GANG_ITALIAN,
 * PED_TYPE_GANG_RUSSIAN,
 * PED_TYPE_GANG_RUSSIAN_2,
 * PED_TYPE_GANG_IRISH,
 * PED_TYPE_GANG_JAMAICAN,
 * PED_TYPE_GANG_AFRICAN_AMERICAN,
 * PED_TYPE_GANG_KOREAN,
 * PED_TYPE_GANG_CHINESE_JAPANESE,
 * PED_TYPE_GANG_PUERTO_RICAN,
 * PED_TYPE_DEALER,
 * PED_TYPE_MEDIC,
 * PED_TYPE_FIREMAN,
 * PED_TYPE_CRIMINAL,
 * PED_TYPE_BUM,
 * PED_TYPE_PROSTITUTE,
 * PED_TYPE_SPECIAL,
 * PED_TYPE_MISSION,
 * PED_TYPE_SWAT,
 * PED_TYPE_ANIMAL,
 * PED_TYPE_ARMY
 * };
 */
window.CreatePed = function (pedType, modelHash, x, y, z, heading, isNetwork, thisScriptCheck) {
	return _in(0xd49f9b09, 0x55c367de, pedType, _ch(modelHash), _fv(x), _fv(y), _fv(z), _fv(heading), isNetwork, thisScriptCheck, _r, _ri);
};

/**
 * thisScriptCheck - can be destroyed if it belongs to the calling script.
 * p5 - last parameter does not mean ped handle is returned
 * maybe a quick view in disassembly will tell us what is actually does
 * Ped Types:
 * enum ePedType
 * {
 * PED_TYPE_PLAYER_0 = 0,
 * PED_TYPE_PLAYER_1 = 1,
 * PED_TYPE_PLAYER_2 = 3,
 * PED_TYPE_CIVMALE = 4,
 * PED_TYPE_CIVFEMALE = 5,
 * PED_TYPE_COP = 6,
 * PED_TYPE_UNKNOWN_7 = 7,
 * PED_TYPE_UNKNOWN_12 = 12, // gang member?
 * PED_TYPE_UNKNOWN_19 = 19,
 * PED_TYPE_MEDIC = 20,
 * PED_TYPE_FIREMAN = 21,
 * PED_TYPE_UNKNOWN_22 = 22,
 * PED_TYPE_UNKNOWN_25 = 25,
 * PED_TYPE_UNKNOWN_26 = 26,
 * PED_TYPE_SWAT = 27,
 * PED_TYPE_ANIMAL = 28,
 * PED_TYPE_ARMY = 29
 * };
 */
window.CreatePedInsideVehicle = function (vehicle, pedType, modelHash, seat, isNetwork, thisScriptCheck) {
	return _in(0x7dd95987, 0x4c1fd534, vehicle, pedType, _ch(modelHash), seat, isNetwork, thisScriptCheck, _r, _ri);
};

/**
 * Drops the Hook/Magnet on a cargobob
 * state
 * enum eCargobobHook
 * {
 * CARGOBOB_HOOK = 0,
 * CARGOBOB_MAGNET = 1,
 * };
 */
window.CreatePickUpRopeForCargobob = function (cargobob, state) {
	return _in(0x7beb0c7a, 0x235f6f3b, cargobob, state);
};
window.EnableCargobobHook = window.CreatePickUpRopeForCargobob;

/**
 * Pickup hashes: pastebin.com/8EuSv2r1
 */
window.CreatePickup = function (pickupHash, posX, posY, posZ, p4, value, p6, modelHash) {
	return _in(0xfba08c50, 0x3dd5fa58, _ch(pickupHash), _fv(posX), _fv(posY), _fv(posZ), p4, value, p6, _ch(modelHash), _r, _ri);
};

/**
 * Pickup hashes: pastebin.com/8EuSv2r1
 * flags:
 * 8 (1 << 3): place on ground
 * 512 (1 << 9): spin around
 */
window.CreatePickupRotate = function (pickupHash, posX, posY, posZ, rotX, rotY, rotZ, flag, amount, p9, p10, modelHash) {
	return _in(0x89180472, 0x7e0a98b7, _ch(pickupHash), _fv(posX), _fv(posY), _fv(posZ), _fv(rotX), _fv(rotY), _fv(rotZ), flag, amount, p9, p10, _ch(modelHash), _r, _ri);
};

/**
 * Pickup hashes: pastebin.com/8EuSv2r1
 */
window.CreatePortablePickup = function (pickupHash, x, y, z, placeOnGround, modelHash) {
	return _in(0x2eaf1fdb, 0x2fb55698, _ch(pickupHash), _fv(x), _fv(y), _fv(z), placeOnGround, _ch(modelHash), _r, _ri);
};

window.CreatePortablePickup_2 = function (pickupHash, x, y, z, placeOnGround, modelHash) {
	return _in(0x125494b9, 0x8a21aaf7, _ch(pickupHash), _fv(x), _fv(y), _fv(z), placeOnGround, _ch(modelHash), _r, _ri);
};
window.N_0x125494b98a21aaf7 = window.CreatePortablePickup_2;

/**
 * vb.net
 * Dim ped_handle As Integer
 * With Game.Player.Character
 * Dim pos As Vector3 = .Position + .ForwardVector * 3
 * ped_handle = Native.Function.Call(Of Integer)(Hash.CREATE_RANDOM_PED, pos.X, pos.Y, pos.Z)
 * End With
 * Creates a Ped at the specified location, returns the Ped Handle.
 * Ped will not act until SET_PED_AS_NO_LONGER_NEEDED is called.
 */
window.CreateRandomPed = function (posX, posY, posZ) {
	return _in(0xb4ac7d0c, 0xf06bfe8f, _fv(posX), _fv(posY), _fv(posZ), _r, _ri);
};

window.CreateRandomPedAsDriver = function (vehicle, returnHandle) {
	return _in(0x9b62392b, 0x474f44a0, vehicle, returnHandle, _r, _ri);
};

/**
 * Creates a blank runtime texture.
 * @param txd A handle to the runtime TXD to create the runtime texture in.
 * @param txn The name for the texture in the runtime texture dictionary.
 * @param width The width of the new texture.
 * @param height The height of the new texture.
 * @return A runtime texture handle.
 */
window.CreateRuntimeTexture = function (txd, txn, width, height) {
	return _in(0x00000000, 0xfec3766d, txd, _ts(txn), width, height, _r, _rl);
};

/**
 * Creates a runtime texture from a DUI handle.
 * @param txd A handle to the runtime TXD to create the runtime texture in.
 * @param txn The name for the texture in the runtime texture dictionary.
 * @param duiHandle The DUI handle returned from GET_DUI_HANDLE.
 * @return The runtime texture handle.
 */
window.CreateRuntimeTextureFromDuiHandle = function (txd, txn, duiHandle) {
	return _in(0x00000000, 0xb135472b, txd, txn, _ts(duiHandle), _r, _rl);
};

/**
 * Creates a runtime texture from the specified file in the current resource.
 * @param txd A handle to the runtime TXD to create the runtime texture in.
 * @param txn The name for the texture in the runtime texture dictionary.
 * @param fileName The file name of an image to load. This should preferably be a PNG, and has to be specified as a `file` in the resource manifest.
 * @return A runtime texture handle.
 */
window.CreateRuntimeTextureFromImage = function (txd, txn, fileName) {
	return _in(0x00000000, 0x786d8bc3, txd, _ts(txn), _ts(fileName), _r, _rl);
};

/**
 * Creates a runtime texture dictionary with the specified name.
 * Example:
 * ```lua
 * local txd = CreateRuntimeTxd('meow')
 * ```
 * @param name The name for the runtime TXD.
 * @return A handle to the runtime TXD.
 */
window.CreateRuntimeTxd = function (name) {
	return _in(0x00000000, 0x1f3ac778, _ts(name), _r, _rl);
};

/**
 * Creates a script vehicle generator at the given coordinates. Most parameters after the model hash are unknown.
 * Parameters:
 * a/w/s - Generator position
 * heading - Generator heading
 * p4 - Unknown (always 5.0)
 * p5 - Unknown (always 3.0)
 * modelHash - Vehicle model hash
 * p7/8/9/10 - Unknown (always -1)
 * p11 - Unknown (usually TRUE, only one instance of FALSE)
 * p12/13 - Unknown (always FALSE)
 * p14 - Unknown (usally FALSE, only two instances of TRUE)
 * p15 - Unknown (always TRUE)
 * p16 - Unknown (always -1)
 * Vector3 coords = GET_ENTITY_COORDS(PLAYER_PED_ID(), 0);	CREATE_SCRIPT_VEHICLE_GENERATOR(coords.x, coords.y, coords.z, 1.0f, 5.0f, 3.0f, GET_HASH_KEY("adder"), -1. -1, -1, -1, -1, true, false, false, false, true, -1);
 */
window.CreateScriptVehicleGenerator = function (x, y, z, heading, p4, p5, modelHash, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16) {
	return _in(0x9def8831, 0x14668116, _fv(x), _fv(y), _fv(z), _fv(heading), _fv(p4), _fv(p5), _ch(modelHash), p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, _r, _ri);
};

/**
 * p6 always 2 (but it doesnt seem to matter...)
 * roll and pitch 0
 * yaw to Ped.rotation
 */
window.CreateSynchronizedScene = function (x, y, z, roll, pitch, yaw, p6) {
	return _in(0x8c18e0f9, 0x080add73, _fv(x), _fv(y), _fv(z), _fv(roll), _fv(pitch), _fv(yaw), p6, _r, _ri);
};

window.CreateSynchronizedScene_2 = function (x, y, z, radius, object) {
	return _in(0x62ec273d, 0x00187dca, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(object), _r, _ri);
};
window.N_0x62ec273d00187dca = window.CreateSynchronizedScene_2;

/**
 * Creates a tracked point, useful for checking the visibility of a 3D point on screen.
 */
window.CreateTrackedPoint = function () {
	return _in(0xe2c9439e, 0xd45dea60, _r, _ri);
};

/**
 * thisScriptCheck - can be destroyed if it belongs to the calling script.
 */
window.CreateVehicle = function (modelHash, x, y, z, heading, isNetwork, thisScriptCheck) {
	return _in(0xaf35d0d2, 0x583051b0, _ch(modelHash), _fv(x), _fv(y), _fv(z), _fv(heading), isNetwork, thisScriptCheck, _r, _ri);
};

/**
 * Now has 8 params.
 */
window.CreateWeaponObject = function (weaponHash, ammoCount, x, y, z, showWorldModel, heading, p7) {
	return _in(0x9541d3cf, 0x0d398f36, _ch(weaponHash), ammoCount, _fv(x), _fv(y), _fv(z), showWorldModel, _fv(heading), p7, _r, _ri);
};

/**
 * some camera effect that is used in the drunk-cheat, and turned off (by setting it to 0.0) along with the shaking effects once the drunk cheat is disabled.
 */
window.CustomMenuCoordinates = function (p0) {
	return _in(0x487a82c6, 0x50eb7799, _fv(p0));
};
window.N_0x487a82c650eb7799 = window.CustomMenuCoordinates;

window.DatafileCreate = function () {
	return _in(0xd27058a1, 0xca2b13ee);
};

window.DatafileDelete = function () {
	return _in(0x9ab9c1cf, 0xc8862dfb);
};

window.DatafileGetFileDict = function () {
	return _in(0x906b778c, 0xa1dc72b6, _r, _s);
};
window.N_0x906b778ca1dc72b6 = window.DatafileGetFileDict;

/**
 * Example:
 * if (!DATAFILE::_BEDB96A7584AA8CF())
 * {
 * if (!g_109E3)
 * {
 * if (((sub_d4f() == 2) == 0) && (!NETWORK::NETWORK_IS_GAME_IN_PROGRESS()))
 * {
 * if (NETWORK::NETWORK_IS_CLOUD_AVAILABLE())
 * {
 * g_17A8B = 0;
 * }
 * if (!g_D52C)
 * {
 * sub_730();
 * }
 * }
 * }
 * }
 */
window.DatafileIsSavePending = function () {
	return _in(0xbedb96a7, 0x584aa8cf, _r);
};
window.N_0xbedb96a7584aa8cf = window.DatafileIsSavePending;

/**
 * Returns whether or not the specified property is set for the entity.
 */
window.DecorExistOn = function (entity, propertyName) {
	return _in(0x05661b80, 0xa8c9165f, entity, _ts(propertyName), _r);
};

window.DecorGetBool = function (entity, propertyName) {
	return _in(0xdace6716, 0x63f2f5db, entity, _ts(propertyName), _r);
};

/**
 * Console Hash: 0x8DE5382F
 * The native name is correct but the db automatically prefixes "_" to unknown natives when changed.
 */
window.DecorGetFloat = function (entity, propertyName) {
	return _in(0x6524a2f1, 0x14706f43, entity, _ts(propertyName), _r, _rf);
};

window.DecorGetInt = function (entity, propertyName) {
	return _in(0xa06c969b, 0x02a97298, entity, _ts(propertyName), _r, _ri);
};

/**
 * Is property of that type.
 * enum eDecorType
 * {
 * DECOR_TYPE_FLOAT = 1,
 * DECOR_TYPE_BOOL,
 * DECOR_TYPE_INT,
 * DECOR_TYPE_UNK,
 * DECOR_TYPE_TIME
 * };
 */
window.DecorIsRegisteredAsType = function (propertyName, type) {
	return _in(0x4f14f9f8, 0x70d6fbc8, _ts(propertyName), type, _r);
};

/**
 * Found this in standard_global_init.c4 line 1898
 * void sub_523a() {
 * DECORATOR::DECOR_REGISTER("Player_Vehicle", 3);
 * DECORATOR::DECOR_REGISTER("PV_Slot", 3);
 * DECORATOR::DECOR_REGISTER("Previous_Owner", 3);
 * DECORATOR::DECOR_REGISTER("Sprayed_Vehicle_Decorator", 2);
 * DECORATOR::DECOR_REGISTER("Sprayed_Vehicle_Timer_Dec", 5);
 * DECORATOR::DECOR_REGISTER("Vehicle_Reward", 3);
 * DECORATOR::DECOR_REGISTER("Vehicle_Reward_Teams", 3);
 * DECORATOR::DECOR_REGISTER("Skill_Blocker", 2);
 * DECORATOR::DECOR_REGISTER("TargetPlayerForTeam", 3);
 * DECORATOR::DECOR_REGISTER("XP_Blocker", 2);
 * DECORATOR::DECOR_REGISTER("CrowdControlSetUp", 3);
 * DECORATOR::DECOR_REGISTER("Bought_Drugs", 2);
 * DECORATOR::DECOR_REGISTER("HeroinInPossession", 1);
 * DECORATOR::DECOR_REGISTER("CokeInPossession", 1);
 * DECORATOR::DECOR_REGISTER("WeedInPossession", 1);
 * DECORATOR::DECOR_REGISTER("MethInPossession", 1);
 * DECORATOR::DECOR_REGISTER("bombdec", 3);
 * DECORATOR::DECOR_REGISTER("bombdec1", 3);
 * DECORATOR::DECOR_REGISTER("bombowner", 3);
 * DECORATOR::DECOR_REGISTER("noPlateScan", 2);
 * DECORATOR::DECOR_REGISTER("prisonBreakBoss", 2);
 * DECORATOR::DECOR_REGISTER("cashondeadbody", 3);
 * DECORATOR::DECOR_REGISTER("MissionType", 3);
 * DECORATOR::DECOR_REGISTER("MatchId", 3);
 * DECORATOR::DECOR_REGISTER("TeamId", 3);
 * DECORATOR::DECOR_REGISTER("Not_Allow_As_Saved_Veh", 3);
 * DECORATOR::DECOR_REGISTER("Veh_Modded_By_Player", 3);
 * DECORATOR::DECOR_REGISTER("MPBitset", 3);
 * DECORATOR::DECOR_REGISTER("MC_EntityID", 3);
 * DECORATOR::DECOR_REGISTER("MC_ChasePedID", 3);
 * DECORATOR::DECOR_REGISTER("MC_Team0_VehDeliveredRules", 3);
 * DECORATOR::DECOR_REGISTER("MC_Team1_VehDeliveredRules", 3);
 * DECORATOR::DECOR_REGISTER("MC_Team2_VehDeliveredRules", 3);
 * DECORATOR::DECOR_REGISTER("MC_Team3_VehDeliveredRules", 3);
 * DECORATOR::DECOR_REGISTER("AttributeDamage", 3);
 * DECORATOR::DECOR_REGISTER("GangBackup", 3);
 * DECORATOR::DECOR_REGISTER("CreatedByPegasus", 2);
 * DECORATOR::DECOR_REGISTER("BeforeCorona_0", 2);
 * }
 * -----------------------------------------------------------------------
 * Defines type of property for property name.
 * enum eDecorType
 * {
 * DECOR_TYPE_FLOAT = 1,
 * DECOR_TYPE_BOOL,
 * DECOR_TYPE_INT,
 * DECOR_TYPE_UNK,
 * DECOR_TYPE_TIME
 * };
 */
window.DecorRegister = function (propertyName, type) {
	return _in(0x9fd90732, 0xf56403ce, _ts(propertyName), type);
};

/**
 * Called after all decorator type initializations.
 */
window.DecorRegisterLock = function () {
	return _in(0xa9d14eea, 0x259f9248);
};

window.DecorRemove = function (entity, propertyName) {
	return _in(0x00ee9f29, 0x7c738720, entity, _ts(propertyName), _r);
};

/**
 * This function sets metadata of type bool to specified entity.
 */
window.DecorSetBool = function (entity, propertyName, value) {
	return _in(0x6b1e8e2e, 0xd1335b71, entity, _ts(propertyName), value, _r);
};

/**
 * Console Hash: 0xBC7BD5CB
 * The native name is correct but the db automatically prefixes "_" to unknown natives when changed.
 */
window.DecorSetFloat = function (entity, propertyName, value) {
	return _in(0x211ab1dd, 0x8d0f363a, entity, _ts(propertyName), _fv(value), _r);
};

/**
 * Sets property to int.
 */
window.DecorSetInt = function (entity, propertyName, value) {
	return _in(0x0ce3aa5e, 0x1ca19e10, entity, _ts(propertyName), value, _r);
};

window.DecorSetTime = function (entity, propertyName, timestamp) {
	return _in(0x95aed7b8, 0xe39ecaa4, entity, _ts(propertyName), timestamp, _r);
};

window.DeleteAllTrains = function () {
	return _in(0x736a7185, 0x77f39c7d);
};

window.DeleteCheckpoint = function (checkpoint) {
	return _in(0xf5ed37f5, 0x4cd4d52e, checkpoint);
};

window.DeleteChildRope = function (rope) {
	return _in(0xaa5d6b18, 0x88e4db20, rope, _r, _ri);
};

/**
 * Deletes the specified entity, then sets the handle pointed to by the pointer to NULL.
 */
window.DeleteEntity = function (entity) {
	return _in(0xae3cbe5b, 0xf394c9c9, _ii(entity) /* may be optional */);
};

window.DeleteFunctionReference = function (referenceIdentity) {
	return _in(0x00000000, 0x1e86f206, _ts(referenceIdentity));
};

/**
 * Delete an incident with a given id.
 * =======================================================
 * Correction, I have change this to int, instead of int*
 * as it doesn't use a pointer to the createdIncident.
 * If you try it you will crash (or) freeze.
 * =======================================================
 */
window.DeleteIncident = function (incidentId) {
	return _in(0x556c1aa2, 0x70d5a207, incidentId);
};

window.DeleteMissionTrain = function (train) {
	return _in(0x5b76b14a, 0xe875c795, _ii(train) /* may be optional */);
};

/**
 * Deletes the specified object, then sets the handle pointed to by the pointer to NULL.
 * meme.
 */
window.DeleteObject = function (object) {
	return _in(0x539e0ae3, 0xe6634b9f, _ii(object) /* may be optional */);
};

/**
 * From the b617d scripts:
 * AI::DELETE_PATROL_ROUTE("miss_merc0");
 * AI::DELETE_PATROL_ROUTE("miss_merc1");
 * AI::DELETE_PATROL_ROUTE("miss_merc2");
 * AI::DELETE_PATROL_ROUTE("miss_dock");
 */
window.DeletePatrolRoute = function (patrolRoute) {
	return _in(0x7767dd9d, 0x65e91319, _ts(patrolRoute));
};

/**
 * Deletes the specified ped, then sets the handle pointed to by the pointer to NULL.
 */
window.DeletePed = function (ped) {
	return _in(0x9614299d, 0xcb53e54b, _ii(ped) /* may be optional */);
};

window.DeleteResourceKvp = function (key) {
	return _in(0x00000000, 0x7389b5df, _ts(key));
};

window.DeleteRope = function (rope) {
	return _in(0x52b48292, 0x81364649, _ii(rope) /* may be optional */);
};

window.DeleteScriptVehicleGenerator = function (vehicleGenerator) {
	return _in(0x22102c9a, 0xbfcf125d, vehicleGenerator);
};

window.DeleteStuntJump = function (p0) {
	return _in(0xdc518000, 0xe39dae1f, p0);
};

/**
 * Deletes a vehicle.
 * The vehicle must be a mission entity to delete, so call this before deleting: SET_ENTITY_AS_MISSION_ENTITY(vehicle, true, true);
 * eg how to use:
 * SET_ENTITY_AS_MISSION_ENTITY(vehicle, true, true);
 * DELETE_VEHICLE(&vehicle);
 * Deletes the specified vehicle, then sets the handle pointed to by the pointer to NULL.
 */
window.DeleteVehicle = function (vehicle) {
	return _in(0xea386986, 0xe786a54f, _ii(vehicle) /* may be optional */);
};

/**
 * BOOL param indicates whether the cam should be destroyed if it belongs to the calling script.
 */
window.DestroyAllCams = function (thisScriptCheck) {
	return _in(0x8e5fb156, 0x63f79120, thisScriptCheck);
};

/**
 * BOOL param indicates whether the cam should be destroyed if it belongs to the calling script.
 */
window.DestroyCam = function (cam, thisScriptCheck) {
	return _in(0x865908c8, 0x1a2c22e9, cam, thisScriptCheck);
};

/**
 * Destroys a DUI browser.
 * @param duiObject The DUI browser handle.
 */
window.DestroyDui = function (duiObject) {
	return _in(0x00000000, 0xa085cb10, duiObject);
};

window.DestroyItemset = function (p0) {
	return _in(0xde18220b, 0x1c183eda, p0);
};

/**
 * Destroys the currently active mobile phone.
 */
window.DestroyMobilePhone = function () {
	return _in(0x3bc861df, 0x703e5097);
};

/**
 * Hash collision
 */
window.DestroyPlayerInPauseMenu = function () {
	return _in(0x5b74ea8c, 0xfd5e3e7e, _r, _ri);
};

window.DestroyTrackedPoint = function (point) {
	return _in(0xb25dc90b, 0xad56ca42, point);
};

window.DetachCam = function (cam) {
	return _in(0xa2fabbe8, 0x7f4bad82, cam);
};

/**
 * p1 and p2 have no effect
 * maybe a quick disassembly will tell us what they do
 * the statement below seems to be false. when I tried it with 2 vehicles:
 * if p2 is set to true, the both entities won't collide with the other until the distance between them is above 4 meters.
 */
window.DetachEntity = function (entity, p1, collision) {
	return _in(0x961ac54b, 0xf0613f5d, entity, p1, collision);
};

window.DetachPortablePickupFromPed = function (ped) {
	return _in(0xcf463d1e, 0x9a0aecb1, ped);
};

window.DetachRopeFromEntity = function (rope, entity) {
	return _in(0xbcf30269, 0x12a8647d, rope, entity);
};

window.DetachSynchronizedScene = function (sceneID) {
	return _in(0x6d38f1f0, 0x4cbb37ea, sceneID);
};

window.DetachVehicleFromAnyCargobob = function (vehicle) {
	return _in(0xadf7be45, 0x0512c12f, vehicle, _r);
};

window.DetachVehicleFromAnyTowTruck = function (vehicle) {
	return _in(0xd0e9ce05, 0xa1e68cd8, vehicle, _r);
};

window.DetachVehicleFromCargobob = function (vehicle, cargobob) {
	return _in(0x0e21d3df, 0x1051399d, vehicle, cargobob);
};

/**
 * First two parameters swapped. Scripts verify that towTruck is the first parameter, not the second.
 */
window.DetachVehicleFromTowTruck = function (towTruck, vehicle) {
	return _in(0xc2db6b67, 0x08350ed8, towTruck, vehicle);
};

/**
 * Public Sub detatchTrailer(vh1 As Vehicle)
 * Native.Function.Call(Hash.DETACH_VEHICLE_FROM_TRAILER, vh1)
 * End Sub
 */
window.DetachVehicleFromTrailer = function (vehicle) {
	return _in(0x90532edf, 0x0d2bdd86, vehicle);
};

/**
 * Detaches the vehicle's windscreen.
 * For further information, see : gtaforums.com/topic/859570-glass/#entry1068894566
 */
window.DetachVehicleWindscreen = function (vehicle) {
	return _in(0x6d645d59, 0xfb5f5ad3, vehicle);
};

window.DisableAimCamThisUpdate = function () {
	return _in(0x1a31fe00, 0x49e542f6);
};
window.N_0x1a31fe0049e542f6 = window.DisableAimCamThisUpdate;

window.DisableAllControlActions = function (inputGroup) {
	return _in(0x5f4b6931, 0x816e599b, inputGroup);
};

window.DisableAutomaticRespawn = function (disableRespawn) {
	return _in(0x2c2b3493, 0xfbf51c71, disableRespawn);
};

/**
 * Hash collision!!!
 * Returns a blip handle.
 */
window.DisableBlipNameForVar = function () {
	return _in(0x5c90988e, 0x7c8e1af4, _r, _ri);
};

/**
 * control values and meaning: github.com/crosire/scripthookvdotnet/blob/dev_v3/source/scripting/Controls.cs
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 * Control values from the decompiled scripts: 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
 * 28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,53,5
 * 4,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,
 * 79,80,81,82,85,86,87,88,89,90,91,92,93,95,96,97,98,99,100,101,102,103,105,
 * 107,108,109,110,111,112,113,114,115,116,117,118,119,123,126,129,130,131,132,
 * 133,134,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,
 * 153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,171,172
 * ,177,187,188,189,190,195,196,199,200,201,202,203,205,207,208,209,211,212,213, 217,219,220,221,225,226,230,234,235,236,237,238,239,240,241,242,243,244,257,
 * 261,262,263,264,265,270,271,272,273,274,278,279,280,281,282,283,284,285,286,
 * 287,288,289,337.
 * Example: CONTROLS::DISABLE_CONTROL_ACTION(2, 19, true) disables the switching UI from appearing both when using a keyboard and Xbox 360 controller. Needs to be executed each frame.
 * Control group 1 and 0 gives the same results as 2. Same results for all players.
 */
window.DisableControlAction = function (inputGroup, control, disable) {
	return _in(0xfe99b66d, 0x079cf6bc, inputGroup, control, disable);
};

/**
 * Disables first person camera for the current frame.
 * Found in decompiled scripts:
 * GRAPHICS::DRAW_DEBUG_TEXT_2D("Disabling First Person Cam", 0.5, 0.8, 0.0, 0, 0, 255, 255);
 * CAM::_DE2EF5DA284CC8DF();
 */
window.DisableFirstPersonCamThisFrame = function () {
	return _in(0xde2ef5da, 0x284cc8df);
};

window.DisableFrontendThisFrame = function () {
	return _in(0x6d3465a7, 0x3092f0e6);
};

/**
 * The game by default has 5 hospital respawn points. Disabling them all will cause the player to respawn at the last position they were.
 * Doesn't work....
 */
window.DisableHospitalRestart = function (hospitalIndex, toggle) {
	return _in(0xc8535819, 0xc450eba8, hospitalIndex, toggle);
};

window.DisableInputGroup = function (inputGroup) {
	return _in(0x7f472403, 0x5fdca1dd, inputGroup);
};
window.N_0x7f4724035fdca1dd = window.DisableInputGroup;

/**
 * Example:
 * This removes the interior from the strip club and when trying to walk inside the player just falls:
 * INTERIOR::DISABLE_INTERIOR(118018, true);
 */
window.DisableInterior = function (interiorID, toggle) {
	return _in(0x61709414, 0x19d7d8ec, interiorID, toggle);
};

window.DisableInteriorProp = function (interiorID, propName) {
	return _in(0x420bd372, 0x89eee162, interiorID, _ts(propName));
};
window.N_0x420bd37289eee162 = window.DisableInteriorProp;

window.DisableNavmeshInArea = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x4c8872d8, 0xcdbe1b8b, p0, p1, p2, p3, p4, p5, p6);
};

window.DisablePedPainAudio = function (ped, toggle) {
	return _in(0xa9a41c1e, 0x940fb0e8, ped, toggle);
};

/**
 * Disables the phone up-button, oddly enough.
 * i.e.: When the phone is out, and this method is called with false as it's parameter, the phone will not be able to scroll up. However, when you use the down arrow key, it's functionality still, works on the phone.
 * When the phone is not out, and this method is called with false as it's parameter, you will not be able to bring up the phone. Although the up arrow key still works for whatever functionality it's used for, just not for the phone.
 * This can be used for creating menu's when trying to disable the phone from being used.
 * You do not have to call the function again with false as a parameter, as soon as the function stops being called, the phone will again be usable.
 */
window.DisablePhoneThisFrame = function (toggle) {
	return _in(0x015c49a9, 0x3e3e086e, toggle);
};
window.N_0x015c49a93e3e086e = window.DisablePhoneThisFrame;

/**
 * hash collision??? - Don't think so. It fits alphabetically and it used with a plane in the scripts
 * Ailerons are responsible for the rolling motion of a plane.
 */
window.DisablePlaneAileron = function (vehicle, p1, p2) {
	return _in(0x23428fc5, 0x3c60919c, vehicle, p1, p2);
};

/**
 * Inhibits the player from using any method of combat including melee and firearms.
 * NOTE: Only disables the firing for one frame
 */
window.DisablePlayerFiring = function (player, toggle) {
	return _in(0x5e6cc076, 0x46bbeab8, player, toggle);
};

window.DisablePlayerVehicleRewards = function (player) {
	return _in(0xc142be3b, 0xb9ce125f, player);
};

window.DisablePoliceReports = function () {
	return _in(0xb4f90faf, 0x7670b16f);
};
window.N_0xb4f90faf7670b16f = window.DisablePoliceReports;

/**
 * Disables the spawn point at the police house on the specified index.
 * policeIndex: The police house index.
 * toggle: true to enable the spawn point, false to disable.
 */
window.DisablePoliceRestart = function (policeIndex, toggle) {
	return _in(0x23285ded, 0x6ebd7ea3, policeIndex, toggle);
};

/**
 * confirmed working
 */
window.DisableRadarThisFrame = function () {
	return _in(0x5fbae526, 0x203990c9);
};

window.DisableScriptBrainSet = function (brainSet) {
	return _in(0x14d8518e, 0x9760f08f, brainSet);
};

window.DisableStuntJumpSet = function (p0) {
	return _in(0xa5272ebe, 0xdd4747f6, p0);
};

window.DisableVehicleDistantlights = function (toggle) {
	return _in(0xc9f98ac1, 0x884e73a2, toggle);
};

window.DisableVehicleFirstPersonCamThisFrame = function () {
	return _in(0xadff1b2a, 0x555f5fba);
};

/**
 * if set to true, prevents vehicle sirens from having sound, leaving only the lights.
 * HASH COLLISION !!! Please change to _SET_DISABLE_VEHICLE_SIREN_SOUND
 * -----
 * SET_VEHICLE_HAS_*
 */
window.DisableVehicleImpactExplosionActivation = function (vehicle, toggle) {
	return _in(0xd8050e0e, 0xb60cf274, vehicle, toggle);
};

window.DisableVehicleNeonLights = function (vehicle, disable) {
	return _in(0x83f81357, 0x0ff519de, vehicle, disable);
};
window.N_0x83f813570ff519de = window.DisableVehicleNeonLights;

/**
 * how does this work?
 */
window.DisableVehicleWeapon = function (disabled, weaponHash, vehicle, owner) {
	return _in(0xf4fc6a6f, 0x67d8d856, disabled, _ch(weaponHash), vehicle, owner);
};

window.DisplayAmmoThisFrame = function (display) {
	return _in(0xa5e78ba2, 0xb1331c55, display);
};

window.DisplayAreaName = function (toggle) {
	return _in(0x276b6ce3, 0x69c33678, toggle);
};

/**
 * "DISPLAY_CASH(false);" makes the cash amount render on the screen when appropriate
 * "DISPLAY_CASH(true);" disables cash amount rendering
 */
window.DisplayCash = function (toggle) {
	return _in(0x96dec8d5, 0x430208b7, toggle);
};

/**
 * Toggles to render distant vehicles. They may not be vehicles but images to look like vehicles.
 */
window.DisplayDistantVehicles = function (toggle) {
	return _in(0xf796359a, 0x959df65d, toggle);
};
window.N_0xf796359a959df65d = window.DisplayDistantVehicles;

/**
 * The messages are localized strings.
 * Examples:
 * "No_bus_money"
 * "Enter_bus"
 * "Tour_help"
 * "LETTERS_HELP2"
 * "Dummy"
 * **The bool appears to always be false (if it even is a bool, as it's represented by a zero)**
 * --------
 * p1 doesn't seem to make a difference, regardless of the state it's in.
 * picture of where on the screen this is displayed?
 */
window.DisplayHelpTextThisFrame = function (message, p1) {
	return _in(0x960c9ff8, 0xf616e41c, _ts(message), p1);
};

/**
 * If Hud should be displayed
 */
window.DisplayHud = function (toggle) {
	return _in(0xa6294919, 0xe56ff02a, toggle);
};

/**
 * Shows a hud element for reporting jobs
 */
window.DisplayJobReport = function () {
	return _in(0x523a590c, 0x1a3cc0d3);
};
window.N_0x523a590c1a3cc0d3 = window.DisplayJobReport;

/**
 * note, p0 is set to 6 for PC platform in at least 1 script, or to `unk::_get_ui_language_id() == 0` otherwise.
 * NOTE: windowTitle uses text labels, and an invalid value will display nothing.
 * Dr. Underscore: `UNK::_GET_UI_LANGUAGE_ID()` is now `UNK::_GET_CURRENT_LANGUAGE_ID()`
 * www.gtaforums.com/topic/788343-vrel-script-hook-v/?p=1067380474
 * windowTitle's
 * -----------------
 * CELL_EMAIL_BOD	=	"Enter your Eyefind message"
 * CELL_EMAIL_BODE	=	"Message too long. Try again"
 * CELL_EMAIL_BODF	=	"Forbidden message. Try again"
 * CELL_EMAIL_SOD	=	"Enter your Eyefind subject"
 * CELL_EMAIL_SODE	=	"Subject too long. Try again"
 * CELL_EMAIL_SODF	=	"Forbidden text. Try again"
 * CELL_EMASH_BOD	=	"Enter your Eyefind message"
 * CELL_EMASH_BODE	=	"Message too long. Try again"
 * CELL_EMASH_BODF	=	"Forbidden message. Try again"
 * CELL_EMASH_SOD	=	"Enter your Eyefind subject"
 * CELL_EMASH_SODE	=	"Subject too long. Try again"
 * CELL_EMASH_SODF	=	"Forbidden Text. Try again"
 * FMMC_KEY_TIP10	=	"Enter Synopsis"
 * FMMC_KEY_TIP12	=	"Enter Custom Team Name"
 * FMMC_KEY_TIP12F	=	"Forbidden Text. Try again"
 * FMMC_KEY_TIP12N	=	"Custom Team Name"
 * FMMC_KEY_TIP8	=	"Enter Message"
 * FMMC_KEY_TIP8F	=	"Forbidden Text. Try again"
 * FMMC_KEY_TIP8FS	=	"Invalid Message. Try again"
 * FMMC_KEY_TIP8S	=	"Enter Message"
 * FMMC_KEY_TIP9	=	"Enter Outfit Name"
 * FMMC_KEY_TIP9F	=	"Invalid Outfit Name. Try again"
 * FMMC_KEY_TIP9N	=	"Outfit Name"
 * PM_NAME_CHALL	=	"Enter Challenge Name"
 */
window.DisplayOnscreenKeyboard = function (p0, windowTitle, p2, defaultText, defaultConcat1, defaultConcat2, defaultConcat3, maxInputLength) {
	return _in(0x00dc833f, 0x2568dbf6, p0, _ts(windowTitle), _ts(p2), _ts(defaultText), _ts(defaultConcat1), _ts(defaultConcat2), _ts(defaultConcat3), maxInputLength);
};

/**
 * only documented to be continued...
 */
window.DisplayOnscreenKeyboard_2 = function (p0, windowTitle, defaultText, defaultConcat1, defaultConcat2, defaultConcat3, defaultConcat4, defaultConcat5, defaultConcat6, defaultConcat7, maxInputLength) {
	return _in(0xca78cfa0, 0x366592fe, p0, _ts(windowTitle), _i, _ts(defaultText), _ts(defaultConcat1), _ts(defaultConcat2), _ts(defaultConcat3), _ts(defaultConcat4), _ts(defaultConcat5), _ts(defaultConcat6), _ts(defaultConcat7), maxInputLength);
};
window.N_0xca78cfa0366592fe = window.DisplayOnscreenKeyboard_2;

/**
 * If Minimap / Radar should be displayed.
 */
window.DisplayRadar = function (Toggle) {
	return _in(0xa0ebb943, 0xc300e693, Toggle, _r, _ri);
};

/**
 * Displays the crosshair for this frame.
 */
window.DisplaySniperScopeThisFrame = function () {
	return _in(0x73115226, 0xf4814e62);
};

/**
 * Purpose of the BOOL currently unknown.
 * Both, true and false, work
 */
window.DisplaySystemSigninUi = function (unk) {
	return _in(0x94dd7888, 0xc10a979e, unk);
};

window.DisposeSynchronizedScene = function (scene) {
	return _in(0xcd9cc7e2, 0x00a52a6f, scene);
};
window.N_0xcd9cc7e200a52a6f = window.DisposeSynchronizedScene;

window.DoAutoSave = function () {
	return _in(0x50eeaad8, 0x6232ee55);
};

/**
 * Fades the screen in.
 * duration: The time the fade should take, in milliseconds.
 */
window.DoScreenFadeIn = function (duration) {
	return _in(0xd4e8e249, 0x55024033, duration);
};

/**
 * Fades the screen out.
 * duration: The time the fade should take, in milliseconds.
 */
window.DoScreenFadeOut = function (duration) {
	return _in(0x891b5b39, 0xac6302af, duration);
};

window.DoesAnimDictExist = function (animDict) {
	return _in(0x2da49c3b, 0x79856961, _ts(animDict), _r);
};

window.DoesBlipExist = function (blip) {
	return _in(0xa6db27d1, 0x9ecbb7da, blip, _r);
};

/**
 * Returns whether or not the passed camera handle exists.
 */
window.DoesCamExist = function (cam) {
	return _in(0xa7a93217, 0x0592b50e, cam, _r);
};

/**
 * Returns true only when the hook is active, will return false if the magnet is active
 */
window.DoesCargobobHavePickUpRope = function (cargobob) {
	return _in(0x1821d91a, 0xd4b56108, cargobob, _r);
};
window.IsCargobobHookActive = window.DoesCargobobHavePickUpRope;

/**
 * Returns true only when the magnet is active, will return false if the hook is active
 * console hash 0x4778CA0A
 */
window.DoesCargobobHavePickupMagnet = function (cargobob) {
	return _in(0x6e08bf5b, 0x3722bac9, cargobob, _r);
};
window.IsCargobobMagnetActive = window.DoesCargobobHavePickupMagnet;

window.DoesCutsceneEntityExist = function (cutsceneEntName, modelHash) {
	return _in(0x499ef20c, 0x5db25c59, _ts(cutsceneEntName), _ch(modelHash), _r);
};

/**
 * Returns true if a destructible object with this handle exists, false otherwise.
 */
window.DoesDesObjectExist = function (handle) {
	return _in(0x52af537a, 0x0c5b8aad, handle, _r);
};
window.N_0x52af537a0c5b8aad = window.DoesDesObjectExist;

/**
 * Example:
 * if (OBJECT::_DOES_DOOR_EXIST(doorHash))
 * {
 * OBJECT::REMOVE_DOOR_FROM_SYSTEM(doorHash);
 * }
 */
window.DoesDoorExist = function (doorHash) {
	return _in(0xc153c43e, 0xa202c8c1, _ch(doorHash), _r);
};
window.N_0xc153c43ea202c8c1 = window.DoesDoorExist;

window.DoesEntityBelongToThisScript = function (entity, p2) {
	return _in(0xdde6df5a, 0xe89981d2, entity, p2, _r);
};

window.DoesEntityExist = function (entity) {
	return _in(0x7239b21a, 0x38f536ba, entity, _r);
};

window.DoesEntityHaveDrawable = function (entity) {
	return _in(0x060d6e96, 0xf8b8e48d, entity, _r);
};

window.DoesEntityHavePhysics = function (entity) {
	return _in(0xda95ea33, 0x17cc5064, entity, _r);
};

/**
 * Checks via CVehicleModelInfo
 */
window.DoesExtraExist = function (vehicle, extraId) {
	return _in(0x1262d557, 0x92428154, vehicle, extraId, _r);
};

window.DoesGroupExist = function (groupId) {
	return _in(0x7c6b0c22, 0xf9f40bbe, groupId, _r);
};

window.DoesNavmeshBlockingObjectExist = function (p0) {
	return _in(0x0eaeb0db, 0x4b132399, p0, _r);
};
window.N_0x0eaeb0db4b132399 = window.DoesNavmeshBlockingObjectExist;

/**
 * p5 is usually 0.
 */
window.DoesObjectOfTypeExistAtCoords = function (x, y, z, radius, hash, p5) {
	return _in(0xbfa48e2f, 0xf417213f, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(hash), p5, _r);
};

window.DoesParticleFxLoopedExist = function (ptfxHandle) {
	return _in(0x74afef0d, 0x2e1e409b, ptfxHandle, _r);
};

/**
 * Returns whether the ped's blip is controlled by the game.
 * It's the default blip you can see on enemies during freeroam in singleplayer (the one that fades out quickly).
 */
window.DoesPedHaveAiBlip = function (ped) {
	return _in(0x15b8ecf8, 0x44ee67ed, ped, _r);
};

window.DoesPickupExist = function (pickup) {
	return _in(0xafc1ca75, 0xad4074d1, pickup, _r);
};

window.DoesPickupObjectExist = function (pickupObject) {
	return _in(0xd9efb6db, 0xf7daaea3, pickupObject, _r);
};

/**
 * Ptr is correct
 */
window.DoesRopeExist = function (rope) {
	return _in(0xfd5448be, 0x3111ed96, _ii(rope) /* may be optional */, _r);
};

window.DoesScenarioExistInArea = function (x, y, z, radius, b) {
	return _in(0x5a59271f, 0xfadd33c1, _fv(x), _fv(y), _fv(z), _fv(radius), b, _r);
};

/**
 * Occurrences in the b617d scripts:
 * "ARMY_GUARD",
 * "ARMY_HELI",
 * "Cinema_Downtown",
 * "Cinema_Morningwood",
 * "Cinema_Textile",
 * "City_Banks",
 * "Countryside_Banks",
 * "DEALERSHIP",
 * "GRAPESEED_PLANES",
 * "KORTZ_SECURITY",
 * "LOST_BIKERS",
 * "LSA_Planes",
 * "LSA_Planes",
 * "MP_POLICE",
 * "Observatory_Bikers",
 * "POLICE_POUND1",
 * "POLICE_POUND2",
 * "POLICE_POUND3",
 * "POLICE_POUND4",
 * "POLICE_POUND5"
 * "QUARRY",
 * "SANDY_PLANES",
 * "SCRAP_SECURITY",
 * "SEW_MACHINE",
 * "SOLOMON_GATE",
 * "Triathlon_1_Start",
 * "Triathlon_2_Start",
 * "Triathlon_3_Start"
 * Sometimes used with IS_SCENARIO_GROUP_ENABLED:
 * if (AI::DOES_SCENARIO_GROUP_EXIST("Observatory_Bikers") && (!AI::IS_SCENARIO_GROUP_ENABLED("Observatory_Bikers"))) {
 * else if (AI::IS_SCENARIO_GROUP_ENABLED("BLIMP")) {
 */
window.DoesScenarioGroupExist = function (scenarioGroup) {
	return _in(0xf9034c13, 0x6c9e00d3, _ts(scenarioGroup), _r);
};

window.DoesScenarioOfTypeExistInArea = function (p0, p1, p2, p4, p5) {
	return _in(0x0a9d0c2a, 0x3bbc86c1, _fv(p0), _fv(p1), _fv(p2), _i, _fv(p4), p5, _r);
};

/**
 * For a full list, see here: pastebin.com/yLNWicUi
 */
window.DoesScriptExist = function (scriptName) {
	return _in(0xfc04745f, 0xbe67c19a, _ts(scriptName), _r);
};

window.DoesScriptVehicleGeneratorExist = function (v) {
	return _in(0xf6086bc8, 0x36400876, v, _r);
};

/**
 * formerly _IS_STREAMED_SCRIPT_RUNNING
 * Jenkins hash: 0x19EAE282
 */
window.DoesScriptWithNameHashExist = function (scriptHash) {
	return _in(0xf86aa3c5, 0x6ba31381, _ch(scriptHash), _r);
};
window.N_0xf86aa3c56ba31381 = window.DoesScriptWithNameHashExist;

/**
 * Checks if there is a cover point at position
 */
window.DoesScriptedCoverPointExistAtCoords = function (x, y, z) {
	return _in(0xa98b8e3c, 0x088e5a31, _fv(x), _fv(y), _fv(z), _r);
};

window.DoesTextBlockExist = function (gxt) {
	return _in(0x1c7302e7, 0x25259789, _ts(gxt), _r);
};

/**
 * Checks if the passed gxt name exists in the game files.
 */
window.DoesTextLabelExist = function (gxt) {
	return _in(0xac09ca97, 0x3c564252, _ts(gxt), _r);
};

window.DoesVehicleExistWithDecorator = function (decorator) {
	return _in(0x956b409b, 0x984d9bf7, _ts(decorator), _r);
};

/**
 * This function is called before ADD_CLAN_DECAL_TO_VEHICLE to see if it needs to run. IDK if it's for clan decal or not, but the 2nd parameter might be decal index? It's always passed 0. Not sure what this function really does. But it does return 0 if the clan tag is not on, and 1 if it is.
 */
window.DoesVehicleHaveDecal = function (vehicle, p1) {
	return _in(0x060d935d, 0x3981a275, vehicle, p1, _r);
};
window.HasVehicleGotDecal = window.DoesVehicleHaveDecal;

window.DoesVehicleHaveDoor = function (vehicle, doorIndex) {
	return _in(0x645f4b6e, 0x8499f632, vehicle, doorIndex, _r);
};

window.DoesVehicleHaveRoof = function (vehicle) {
	return _in(0x8ac862b0, 0xb32c5b80, vehicle, _r);
};

/**
 * Maximum amount of vehicles with vehicle stuck check appears to be 16.
 */
window.DoesVehicleHaveStuckVehicleCheck = function (vehicle) {
	return _in(0x57e4c39d, 0xe5ee8470, vehicle, _r);
};

window.DoesVehicleHaveWeapons = function (vehicle) {
	return _in(0x25ecb9f8, 0x017d98e0, vehicle, _r);
};

window.DoesWeaponTakeWeaponComponent = function (weaponHash, componentHash) {
	return _in(0x5cee3df5, 0x69cecab0, _ch(weaponHash), _ch(componentHash), _r);
};

/**
 * OBJECT::_9B12F9A24FABEDB0(${prop_gate_prison_01}, 1845.0, 2605.0, 45.0, 0, 0.0, 50.0, 0);  //door unlocked
 * OBJECT::_9B12F9A24FABEDB0(${prop_gate_prison_01}, 1845.0, 2605.0, 45.0, 1, 0.0, 50.0, 0);  //door locked
 * locked simply tells the game whether or not the door is locked.
 * x,y,z RotMult are multipliers that specify how fast the door/gate will rotate in degrees per second.
 */
window.DoorControl = function (doorHash, x, y, z, locked, xRotMult, yRotMult, zRotMult) {
	return _in(0x9b12f9a2, 0x4fabedb0, _ch(doorHash), _fv(x), _fv(y), _fv(z), locked, _fv(xRotMult), _fv(yRotMult), _fv(zRotMult));
};

/**
 * Downloads prod.cloud.rockstargames.com/titles/gta5/<platform>/check.json
 */
window.DownloadCheck = function () {
	return _in(0x4f18196c, 0x8d38768d);
};
window.N_0x4f18196c8d38768d = window.DownloadCheck;

/**
 * x,y,z = start pos
 * x2,y2,z2 = end pos
 * Draw's a 3D Box between the two x,y,z coords.
 * --------------
 * Keep in mind that the edges of the box do only align to the worlds base-vectors. Therefore something like rotation cannot be applied. That means this function is pretty much useless, unless you want a static unicolor box somewhere.
 * I recommend using a predefined function to call this.
 * [VB.NET]
 * Public Sub DrawBox(a As Vector3, b As Vector3, col As Color)
 * [Function].Call(Hash.DRAW_BOX,a.X, a.Y, a.Z,b.X, b.Y, b.Z,col.R, col.G, col.B, col.A)
 * End Sub
 * [C#]
 * public void DrawBox(Vector3 a, Vector3 b, Color col)
 * {
 * Function.Call(Hash.DRAW_BOX,a.X, a.Y, a.Z,b.X, b.Y, b.Z,col.R, col.G, col.B, col.A);
 * }
 */
window.DrawBox = function (x1, y1, z1, x2, y2, z2, red, green, blue, alpha) {
	return _in(0xd3a9971c, 0xadac7252, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), red, green, blue, alpha);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugBox = function (x1, y1, z1, x2, y2, z2, red, green, blue, alpha) {
	return _in(0x083a2ca4, 0xf2e573bd, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), red, green, blue, alpha);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugCross = function (x, y, z, size, red, green, blue, alpha) {
	return _in(0x73b11896, 0x23049839, _fv(x), _fv(y), _fv(z), _fv(size), red, green, blue, alpha);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugLine = function (x1, y1, z1, x2, y2, z2, red, green, blue, alpha) {
	return _in(0x7fdfade6, 0x76aa3cb0, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), red, green, blue, alpha);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugLineWithTwoColours = function (x1, y1, z1, x2, y2, z2, r1, g1, b1, r2, g2, b2, alpha1, alpha2) {
	return _in(0xd8b9a8ac, 0x5608ff94, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), r1, g1, b1, r2, g2, b2, alpha1, alpha2);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugSphere = function (x, y, z, radius, red, green, blue, alpha) {
	return _in(0xaad68e1a, 0xb39da632, _fv(x), _fv(y), _fv(z), _fv(radius), red, green, blue, alpha);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugText = function (text, x, y, z, red, green, blue, alpha) {
	return _in(0x3903e216, 0x620488e8, _ts(text), _fv(x), _fv(y), _fv(z), red, green, blue, alpha);
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.DrawDebugText_2d = function (text, x, y, z, red, green, blue, alpha) {
	return _in(0xa3bb2e95, 0x55c05a8f, _ts(text), _fv(x), _fv(y), _fv(z), red, green, blue, alpha);
};

/**
 * instructionalKey enum list:
 * ```
 * Buttons = {
 * Empty = 0,
 * Select = 1, -- (RETURN)
 * Ok = 2, -- (RETURN)
 * Yes = 4, -- (RETURN)
 * Back = 8, -- (ESC)
 * Cancel = 16, -- (ESC)
 * No = 32, -- (ESC)
 * RetrySpace = 64, -- (SPACE)
 * Restart = 128, -- (SPACE)
 * Skip = 256, -- (SPACE)
 * Quit = 512, -- (ESC)
 * Adjust = 1024, -- (ARROWS)
 * SpaceKey = 2048, -- (SPACE)
 * Share = 4096, -- (SPACE)
 * SignIn = 8192, -- (SPACE)
 * Continue = 16384, -- (RETURN)
 * AdjustLeftRight = 32768, -- (SCROLL L/R)
 * AdjustUpDown = 65536, -- (SCROLL U/D)
 * Overwrite = 131072, -- (SPACE)
 * SocialClubSignup = 262144, -- (RETURN)
 * Confirm = 524288, -- (RETURN)
 * Queue = 1048576, -- (RETURN)
 * RetryReturn = 2097152, -- (RETURN)
 * BackEsc = 4194304, -- (ESC)
 * SocialClub = 8388608, -- (RETURN)
 * Spectate = 16777216, -- (SPACE)
 * OkEsc = 33554432, -- (ESC)
 * CancelTransfer = 67108864, -- (ESC)
 * LoadingSpinner = 134217728,
 * NoReturnToGTA = 268435456, -- (ESC)
 * CancelEsc = 536870912, -- (ESC)
 * }
 * Alt = {
 * Empty = 0,
 * No = 1, -- (SPACE)
 * Host = 2, -- (ESC)
 * SearchForJob = 4, -- (RETURN)
 * ReturnKey = 8, -- (TURN)
 * Freemode = 16, -- (ESC)
 * }
 * ```
 * **Result of the example code:** <https://i.imgur.com/TvmNF4k.png>
 * @param labelTitle Label of the alert's title.
 * @param labelMsg Label of the alert's message.
 * @param p2 This is an enum, check the description for a list.
 * @param p3 This is an enum, check the description for a list.
 * @param labelMsg2 Label of another message line
 * @param p5 usually 0
 * @param p6 usually -1
 * @param p7 usually 0
 * @param p8 unknown label
 * @param p9 unknown label
 * @param background Set to anything other than 0 or false (even any string) and it will draw a background. Setting it to 0 or false will draw no background.
 * @param p11 unknown value default false, it shows an error code at the bottom left
 */
window.DrawFrontendAlert = function (labelTitle, labelMsg, p2, p3, labelMsg2, p5, p6, p7, p8, p9, background, p11) {
	return _in(0x15803fec, 0x3b9a872b, _ts(labelTitle), _ts(labelMsg), p2, p3, _ts(labelMsg2), p5, p6, p7, _ts(p8), _ts(p9), background, p11, _r, _ri);
};
window.N_0x15803fec3b9a872b = window.DrawFrontendAlert;

/**
 * Similar to [\_DRAW_SPRITE](#_0xE7FFAE5EBF23D890), but seems to be some kind of "interactive" sprite, at least used by render targets.
 * These seem to be the only dicts ever requested by this native:
 * ```
 * prop_screen_biker_laptop
 * Prop_Screen_GR_Disruption
 * Prop_Screen_TaleOfUs
 * prop_screen_nightclub
 * Prop_Screen_IE_Adhawk
 * prop_screen_sm_free_trade_shipping
 * prop_screen_hacker_truck
 * MPDesktop
 * Prop_Screen_Nightclub
 * And a few others
 * ```
 * @param textureDict Name of texture dictionary to load texture from
 * @param textureName Name of texture to load from texture dictionary
 * @param screenX Screen X
 * @param screenY Screen Y
 * @param width Scale X
 * @param height Scale Y
 * @param heading Texture rotation in degrees (default = 0.0) positive is clockwise, measured in degrees
 * @param red Color
 * @param green Color
 * @param blue Color
 * @param alpha Opacity level
 */
window.DrawInteractiveSprite = function (textureDict, textureName, screenX, screenY, width, height, heading, red, green, blue, alpha) {
	return _in(0x2bc54a81, 0x88768488, _ts(textureDict), _ts(textureName), _fv(screenX), _fv(screenY), _fv(width), _fv(height), _fv(heading), red, green, blue, alpha);
};
window.N_0x2bc54a8188768488 = window.DrawInteractiveSprite;

window.DrawLightWithRange = function (posX, posY, posZ, colorR, colorG, colorB, range, intensity) {
	return _in(0xf2a1b277, 0x1a01dbd4, _fv(posX), _fv(posY), _fv(posZ), colorR, colorG, colorB, _fv(range), _fv(intensity));
};

window.DrawLightWithRangeAndShadow = function (x, y, z, r, g, b, range, intensity, shadow) {
	return _in(0xf49e9a97, 0x16a04595, _fv(x), _fv(y), _fv(z), r, g, b, _fv(range), _fv(intensity), _fv(shadow));
};
window.DrawLightWithRangeWithShadow = window.DrawLightWithRangeAndShadow;

/**
 * Draws a depth-tested line from one point to another.
 * ----------------
 * x1, y1, z1 : Coordinates for the first point
 * x2, y2, z2 : Coordinates for the second point
 * r, g, b, alpha : Color with RGBA-Values
 * I recommend using a predefined function to call this.
 * [VB.NET]
 * Public Sub DrawLine(from As Vector3, [to] As Vector3, col As Color)
 * [Function].Call(Hash.DRAW_LINE, from.X, from.Y, from.Z, [to].X, [to].Y, [to].Z, col.R, col.G, col.B, col.A)
 * End Sub
 * [C#]
 * public void DrawLine(Vector3 from, Vector3 to, Color col)
 * {
 * Function.Call(Hash.DRAW_LINE, from.X, from.Y, from.Z, to.X, to.Y, to.Z, col.R, col.G, col.B, col.A);
 * }
 */
window.DrawLine = function (x1, y1, z1, x2, y2, z2, red, green, blue, alpha) {
	return _in(0x6b725607, 0x4ae34680, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), red, green, blue, alpha);
};

/**
 * Draws a marker with the specified appearance at the target location. This has to be called every frame, e.g. in a `Wait(0)` loop.
 * There's a [list of markers](https://docs.fivem.net/game-references/markers/) on the FiveM documentation site.
 * @param type The marker type to draw.
 * @param posX The X coordinate to draw the marker at.
 * @param posY The Y coordinate to draw the marker at.
 * @param posZ The Z coordinate to draw the marker at.
 * @param dirX The X component of the direction vector for the marker, or 0.0 to use rotX/Y/Z.
 * @param dirY The Y component of the direction vector for the marker, or 0.0 to use rotX/Y/Z.
 * @param dirZ The Z component of the direction vector for the marker, or 0.0 to use rotX/Y/Z.
 * @param rotX The X rotation for the marker. Only used if the direction vector is 0.0.
 * @param rotY The Y rotation for the marker. Only used if the direction vector is 0.0.
 * @param rotZ The Z rotation for the marker. Only used if the direction vector is 0.0.
 * @param scaleX The scale for the marker on the X axis.
 * @param scaleY The scale for the marker on the Y axis.
 * @param scaleZ The scale for the marker on the Z axis.
 * @param red The red component of the marker color, on a scale from 0-255.
 * @param green The green component of the marker color, on a scale from 0-255.
 * @param blue The blue component of the marker color, on a scale from 0-255.
 * @param alpha The alpha component of the marker color, on a scale from 0-255.
 * @param bobUpAndDown Whether or not the marker should slowly animate up/down.
 * @param faceCamera Whether the marker should be a 'billboard', as in, should constantly face the camera.
 * @param p19 Typically set to `2`. Does not seem to matter directly.
 * @param rotate Rotations only apply to the heading.
 * @param textureDict A texture dictionary to draw the marker with, or NULL. Example: 'GolfPutting'
 * @param textureName A texture name in `textureDict` to draw the marker with, or NULL. Example: 'PuttingMarker'
 * @param drawOnEnts Whether or not the marker should draw on intersecting entities.
 */
window.DrawMarker = function (type, posX, posY, posZ, dirX, dirY, dirZ, rotX, rotY, rotZ, scaleX, scaleY, scaleZ, red, green, blue, alpha, bobUpAndDown, faceCamera, p19, rotate, textureDict, textureName, drawOnEnts) {
	return _in(0x28477ec2, 0x3d892089, type, _fv(posX), _fv(posY), _fv(posZ), _fv(dirX), _fv(dirY), _fv(dirZ), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(scaleX), _fv(scaleY), _fv(scaleZ), red, green, blue, alpha, bobUpAndDown, faceCamera, p19, rotate, _ts(textureDict), _ts(textureName), drawOnEnts);
};

/**
 * Draws a notification above the map and returns the notifications handle
 * Color syntax:
 * ~r~ = Red
 * ~b~ = Blue
 * ~g~ = Green
 * ~y~ = Yellow
 * ~p~ = Purple
 * ~o~ = Orange
 * ~c~ = Grey
 * ~m~ = Darker Grey
 * ~u~ = Black
 * ~n~ = New Line
 * ~s~ = Default White
 * ~w~ = White
 * ~h~ = Bold Text
 * ~nrt~ = ???
 * Special characters:
 * ¦ = Rockstar Verified Icon (U+00A6:Broken Bar - Alt+0166)
 * ÷ = Rockstar Icon (U+00F7:Division Sign - Alt+0247)
 * ∑ = Rockstar Icon 2 (U+2211:N-Ary Summation)
 * Example C#:
 * Function.Call(Hash._ADD_TEXT_COMPONENT_STRING3, "Now I need you to bring the ~b~vehicle~w~ back to me!");
 * ----
 * showInBrief==true: the notification will appear in the "Brief/Info" -> "Notifications" tab in the pause menu.
 * showInBrief==false: the notification will NOT appear in the pause menu.
 */
window.DrawNotification = function (blink, showInBrief) {
	return _in(0x2ed7843f, 0x8f801023, blink, showInBrief, _r, _ri);
};

/**
 * This function and the one below it are for after you receive an invite, not sending it.
 * p0 = 1 or 0
 * nothin doin.
 * int invite(Player player)
 * {
 * int iVar2, iVar3;
 * networkHandleMgr handle;
 * NETWORK_HANDLE_FROM_PLAYER(player, &handle.netHandle, 13);
 * networkClanMgr clan;
 * char *playerName = GET_PLAYER_NAME(player);
 * _SET_NOTIFICATION_TEXT_ENTRY("STRING");
 * _SET_NOTIFACTION_COLOR_NEXT(0);
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(playerName);
 * if (NETWORK_CLAN_PLAYER_GET_DESC(&clan, 35, &handle.netHandle))
 * {
 * iVar2 = 0;
 * if (ARE_STRINGS_EQUAL(clan.unk22, "Leader") && clan.unk30 == 0)
 * {
 * iVar2 = 1;
 * }
 * if (clan.unk21 > 0)
 * {
 * iVar3 = 0;
 * }
 * else
 * {
 * iVar3 = 1;
 * }
 * BOOL unused = _0x54E79E9C(&clan.clanHandle, 35);
 * return _DRAW_NOTIFICATION_APARTMENT_INVITE(iVar3, 0  -- [[unused]] , &clan.unk17, clan.unk30, iVar2, 0, clan.clanHandle, 0, 0, 0);
 * }
 * }
 */
window.DrawNotificationApartmentInvite = function (p0, p1, p3, isLeader, unk0, clanDesc, R, G, B) {
	return _in(0x97c9e4e7, 0x024a8f2c, p0, p1, _i, p3, isLeader, unk0, clanDesc, R, G, B, _r, _ri);
};
window.N_0x97c9e4e7024a8f2c = window.DrawNotificationApartmentInvite;
window.NotificationSendApartmentInvite = window.DrawNotificationApartmentInvite;

/**
 * Shows an "award" notification above the minimap, lua example result:
 * ![](https://i.imgur.com/e2DNaKX.png)
 * Old description:
 * ```
 * Example:
 * UI::_SET_NOTIFICATION_TEXT_ENTRY("HUNT");
 * UI::_0xAA295B6F28BD587D("Hunting", "Hunting_Gold_128", 0, 109, "HUD_MED_UNLKED");
 * ```
 * @param textureDict The texture dictionary name for the icon on the left.
 * @param textureName The texture name for the icon on the left.
 * @param rpBonus The gained "RP" amount that will be displayed on the right side of the notification.
 * @param colorOverlay Hudcolor overlay that gets applied on top of the notification, fucks up text/image visibility in most cases if set to something other than 0.
 * @param titleLabel The label that will be displayed at the top of the notification (title).
 * @return The notification handle.
 */
window.DrawNotificationAward = function (textureDict, textureName, rpBonus, colorOverlay, titleLabel) {
	return _in(0xaa295b6f, 0x28bd587d, _ts(textureDict), _ts(textureName), rpBonus, colorOverlay, _ts(titleLabel), _r, _ri);
};
window.N_0xaa295b6f28bd587d = window.DrawNotificationAward;
window.DrawNotificationIcon = window.DrawNotificationAward;

/**
 * p0 = 1 or 0
 * crashes my game...
 * this is for sending invites to network players - jobs/apartment/ect...
 * return notification handle
 * int invite(Player player)
 * {
 * networkHandleMgr netHandle;
 * networkClanMgr clan;
 * char *playerName = GET_PLAYER_NAME(player);
 * _SET_NOTIFICATION_TEXT_ENTRY("STRING");
 * _SET_NOTIFACTION_COLOR_NEXT(1);
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(playerName);
 * NETWORK_HANDLE_FROM_PLAYER(player, &netHandle.netHandle, 13);
 * if (NETWORK_CLAN_PLAYER_IS_ACTIVE(&netHandle.netHandle))
 * {
 * NETWORK_CLAN_PLAYER_GET_DESC(&clan.clanHandle, 35, &netHandle.netHandle);
 * _DRAW_NOTIFICATION_CLAN_INVITE(0, _0x54E79E9C(&clan.clanHandle, 35), &clan.unk17, clan.isLeader, 0, 0, clan.clanHandle, playerName, 0, 0, 0);
 * }
 * }
 */
window.DrawNotificationClanInvite = function (p0, p1, p3, isLeader, unk0, clanDesc, playerName, R, G, B) {
	return _in(0x137bc355, 0x89e34e1e, p0, p1, _i, p3, isLeader, unk0, clanDesc, _ts(playerName), R, G, B, _r, _ri);
};
window.N_0x137bc35589e34e1e = window.DrawNotificationClanInvite;
window.NotificationSendClanInvite = window.DrawNotificationClanInvite;

/**
 * returns a notification handle, prints out a notification like below:
 * type range: 0
 * if you set type to 1, button accepts "~INPUT_SOMETHING~"
 * example:
 * UI::_0xDD6CB2CCE7C2735C(1, "~INPUT_TALK~", "Who you trynna get crazy with, ese? Don't you know I'm LOCO?!");
 * - imgur.com/UPy0Ial
 * Examples from the scripts:
 * l_D1[1 -- [[1]] ]=UI::_DD6CB2CCE7C2735C(1,"~INPUT_REPLAY_START_STOP_RECORDING~","");
 * l_D1[2 -- [[1]] ]=UI::_DD6CB2CCE7C2735C(1,"~INPUT_SAVE_REPLAY_CLIP~","");
 * l_D1[1 -- [[1]] ]=UI::_DD6CB2CCE7C2735C(1,"~INPUT_REPLAY_START_STOP_RECORDING~","");
 * l_D1[2 -- [[1]] ]=UI::_DD6CB2CCE7C2735C(1,"~INPUT_REPLAY_START_STOP_RECORDING_SECONDARY~","");
 */
window.DrawNotificationWithButton = function (type, button, text) {
	return _in(0xdd6cb2cc, 0xe7c2735c, type, _ts(button), _ts(text), _r, _ri);
};
window.N_0xdd6cb2cce7c2735c = window.DrawNotificationWithButton;

/**
 * returns a notification handle, prints out a notification like below:
 * type range: 0
 * if you set type to 1, image goes from 0 - 39 - Xbox you can add text to
 * example:
 * UI::_0xD202B92CBF1D816F(1, 20, "Who you trynna get crazy with, ese? Don't you know I'm LOCO?!");
 */
window.DrawNotificationWithIcon = function (type, image, text) {
	return _in(0xd202b92c, 0xbf1d816f, type, image, _ts(text), _r, _ri);
};
window.N_0xd202b92cbf1d816f = window.DrawNotificationWithIcon;

window.DrawNotification_2 = function (blink, p1) {
	return _in(0x44fa0397, 0x5424a0ee, blink, p1, _r, _ri);
};

window.DrawNotification_3 = function (blink, p1) {
	return _in(0x378e809b, 0xf61ec840, blink, p1, _r, _ri);
};

window.DrawNotification_4 = function (blink, p1) {
	return _in(0xf020c969, 0x15705b3a, blink, p1, _r, _ri);
};

/**
 * x/y/z - Location of a vertex (in world coords), presumably.
 * ----------------
 * x1, y1, z1     : Coordinates for the first point
 * x2, y2, z2     : Coordinates for the second point
 * x3, y3, z3     : Coordinates for the third point
 * r, g, b, alpha : Color with RGBA-Values
 * Keep in mind that only one side of the drawn triangle is visible: It's the side, in which the vector-product of the vectors heads to: (b-a)x(c-a) Or (b-a)x(c-b).
 * But be aware: The function seems to work somehow differently. I have trouble having them drawn in rotated orientation. Try it yourself and if you somehow succeed, please edit this and post your solution.
 * I recommend using a predefined function to call this.
 * [VB.NET]
 * Public Sub DrawPoly(a As Vector3, b As Vector3, c As Vector3, col As Color)
 * [Function].Call(Hash.DRAW_POLY, a.X, a.Y, a.Z, b.X, b.Y, b.Z, c.X, c.Y, c.Z, col.R, col.G, col.B, col.A)
 * End Sub
 * [C#]
 * public void DrawPoly(Vector3 a, Vector3 b, Vector3 c, Color col)
 * {
 * Function.Call(Hash.DRAW_POLY, a.X, a.Y, a.Z, b.X, b.Y, b.Z, c.X, c.Y, c.Z, col.R, col.G, col.B, col.A);
 * }
 * BTW: Intersecting triangles are not supported: They overlap in the order they were called.
 */
window.DrawPoly = function (x1, y1, z1, x2, y2, z2, x3, y3, z3, red, green, blue, alpha) {
	return _in(0xac267160, 0x48436851, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(x3), _fv(y3), _fv(z3), red, green, blue, alpha);
};

/**
 * Draws a rectangle on the screen.
 * -x: The relative X point of the center of the rectangle. (0.0-1.0, 0.0 is the left edge of the screen, 1.0 is the right edge of the screen)
 * -y: The relative Y point of the center of the rectangle. (0.0-1.0, 0.0 is the top edge of the screen, 1.0 is the bottom edge of the screen)
 * -width: The relative width of the rectangle. (0.0-1.0, 1.0 means the whole screen width)
 * -height: The relative height of the rectangle. (0.0-1.0, 1.0 means the whole screen height)
 * -R: Red part of the color. (0-255)
 * -G: Green part of the color. (0-255)
 * -B: Blue part of the color. (0-255)
 * -A: Alpha part of the color. (0-255, 0 means totally transparent, 255 means totally opaque)
 * The total number of rectangles to be drawn in one frame is apparently limited to 399.
 */
window.DrawRect = function (x, y, width, height, r, g, b, a) {
	return _in(0x3a618a21, 0x7e5154f0, _fv(x), _fv(y), _fv(width), _fv(height), r, g, b, a);
};

/**
 * GTA V Scaleforms Decompiled
 * pastebin.com/mmNdjX2k
 */
window.DrawScaleformMovie = function (scaleformHandle, x, y, width, height, red, green, blue, alpha, unk) {
	return _in(0x54972ada, 0xf0294a93, scaleformHandle, _fv(x), _fv(y), _fv(width), _fv(height), red, green, blue, alpha, unk);
};

/**
 * unk is not used so no need
 */
window.DrawScaleformMovieFullscreen = function (scaleform, red, green, blue, alpha, unk) {
	return _in(0x0df60692, 0x9c105be1, scaleform, red, green, blue, alpha, unk);
};

window.DrawScaleformMovieFullscreenMasked = function (scaleform1, scaleform2, red, green, blue, alpha) {
	return _in(0xcf537fde, 0x4fbd4ce5, scaleform1, scaleform2, red, green, blue, alpha);
};

/**
 * sharpness goes from 0.0 to 1.0
 */
window.DrawScaleformMovie_3d = function (scaleform, posX, posY, posZ, rotX, rotY, rotZ, p7, sharpness, p9, scaleX, scaleY, scaleZ, p13) {
	return _in(0x87d51d72, 0x255d4e78, scaleform, _fv(posX), _fv(posY), _fv(posZ), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(p7), _fv(sharpness), _fv(p9), _fv(scaleX), _fv(scaleY), _fv(scaleZ), p13);
};
window.N_0x87d51d72255d4e78 = window.DrawScaleformMovie_3d;

/**
 * what the heck does this one do differently from the one above?
 */
window.DrawScaleformMovie_3dNonAdditive = function (scaleform, posX, posY, posZ, rotX, rotY, rotZ, p7, p8, p9, scaleX, scaleY, scaleZ, p13) {
	return _in(0x1ce592fd, 0xc749d6f5, scaleform, _fv(posX), _fv(posY), _fv(posZ), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(p7), _fv(p8), _fv(p9), _fv(scaleX), _fv(scaleY), _fv(scaleZ), p13);
};
window.N_0x1ce592fdc749d6f5 = window.DrawScaleformMovie_3dNonAdditive;

/**
 * It's called after 0xD3A10FC7FD8D98CD and 0xF1CEA8A4198D8E9A
 * p0 was always "CELEBRATION_WINNER"
 */
window.DrawShowroom = function (p0, ped, p2, posX, posY, posZ) {
	return _in(0x98c4fe6e, 0xc34154ca, _ts(p0), ped, p2, _fv(posX), _fv(posY), _fv(posZ), _r);
};
window.N_0x98c4fe6ec34154ca = window.DrawShowroom;

/**
 * Parameters:
 * * pos - coordinate where the spotlight is located
 * * dir - the direction vector the spotlight should aim at from its current position
 * * r,g,b - color of the spotlight
 * * distance - the maximum distance the light can reach
 * * brightness - the brightness of the light
 * * roundness - "smoothness" of the circle edge
 * * radius - the radius size of the spotlight
 * * falloff - the falloff size of the light's edge (example: www.i.imgur.com/DemAWeO.jpg)
 * Example in C# (spotlight aims at the closest vehicle):
 * Vector3 myPos = Game.Player.Character.Position;
 * Vehicle nearest = World.GetClosestVehicle(myPos , 1000f);
 * Vector3 destinationCoords = nearest.Position;
 * Vector3 dirVector = destinationCoords - myPos;
 * dirVector.Normalize();
 * Function.Call(Hash.DRAW_SPOT_LIGHT, pos.X, pos.Y, pos.Z, dirVector.X, dirVector.Y, dirVector.Z, 255, 255, 255, 100.0f, 1f, 0.0f, 13.0f, 1f);
 */
window.DrawSpotLight = function (posX, posY, posZ, dirX, dirY, dirZ, colorR, colorG, colorB, distance, brightness, hardness, radius, falloff) {
	return _in(0xd0f64b26, 0x5c8c8b33, _fv(posX), _fv(posY), _fv(posZ), _fv(dirX), _fv(dirY), _fv(dirZ), colorR, colorG, colorB, _fv(distance), _fv(brightness), _fv(hardness), _fv(radius), _fv(falloff));
};

/**
 * shadowId: each call to this native in the same tick should have a different value passed to this parameter, if two or more calls have the same values, only the first one will render its shadow properly
 */
window.DrawSpotLightWithShadow = function (posX, posY, posZ, dirX, dirY, dirZ, colorR, colorG, colorB, distance, brightness, roundness, radius, falloff, shadowId) {
	return _in(0x5bca583a, 0x583194db, _fv(posX), _fv(posY), _fv(posZ), _fv(dirX), _fv(dirY), _fv(dirZ), colorR, colorG, colorB, _fv(distance), _fv(brightness), _fv(roundness), _fv(radius), _fv(falloff), shadowId);
};

/**
 * Draws a 2D sprite on the screen.
 * Parameters:
 * textureDict - Name of texture dictionary to load texture from (e.g. "CommonMenu", "MPWeaponsCommon", etc.)
 * textureName - Name of texture to load from texture dictionary (e.g. "last_team_standing_icon", "tennis_icon", etc.)
 * screenX/Y - Screen offset (0.5 = center)
 * scaleX/Y - Texture scaling. Negative values can be used to flip the texture on that axis. (0.5 = half)
 * heading - Texture rotation in degrees (default = 0.0) positive is clockwise, measured in degrees
 * red,green,blue - Sprite color (default = 255/255/255)
 * alpha - opacity level
 */
window.DrawSprite = function (textureDict, textureName, screenX, screenY, width, height, heading, red, green, blue, alpha) {
	return _in(0xe7ffae5e, 0xbf23d890, _ts(textureDict), _ts(textureName), _fv(screenX), _fv(screenY), _fv(width), _fv(height), _fv(heading), red, green, blue, alpha);
};

/**
 * All calls to this native are preceded by calls to GRAPHICS::_0x61BB1D9B3A95D802 and GRAPHICS::_0xC6372ECD45D73BCD, respectively.
 * "act_cinema.ysc", line 1483:
 * UI::SET_HUD_COMPONENT_POSITION(15, 0.0, -0.0375);
 * UI::SET_TEXT_RENDER_ID(l_AE);
 * GRAPHICS::_0x61BB1D9B3A95D802(4);
 * GRAPHICS::_0xC6372ECD45D73BCD(1);
 * if (GRAPHICS::_0x0AD973CA1E077B60(${movie_arthouse})) {
 * GRAPHICS::DRAW_TV_CHANNEL(0.5, 0.5, 0.7375, 1.0, 0.0, 255, 255, 255, 255);
 * } else {
 * GRAPHICS::DRAW_TV_CHANNEL(0.5, 0.5, 1.0, 1.0, 0.0, 255, 255, 255, 255);
 * }
 * "am_mp_property_int.ysc", line 102545:
 * if (ENTITY::DOES_ENTITY_EXIST(a_2._f3)) {
 * if (UI::IS_NAMED_RENDERTARGET_LINKED(ENTITY::GET_ENTITY_MODEL(a_2._f3))) {
 * UI::SET_TEXT_RENDER_ID(a_2._f1);
 * GRAPHICS::_0x61BB1D9B3A95D802(4);
 * GRAPHICS::_0xC6372ECD45D73BCD(1);
 * GRAPHICS::DRAW_TV_CHANNEL(0.5, 0.5, 1.0, 1.0, 0.0, 255, 255, 255, 255);
 * if (GRAPHICS::GET_TV_CHANNEL() == -1) {
 * sub_a8fa5(a_2, 1);
 * } else {
 * sub_a8fa5(a_2, 1);
 * GRAPHICS::ATTACH_TV_AUDIO_TO_ENTITY(a_2._f3);
 * }
 * UI::SET_TEXT_RENDER_ID(UI::GET_DEFAULT_SCRIPT_RENDERTARGET_RENDER_ID());
 * }
 * }
 */
window.DrawTvChannel = function (xPos, yPos, xScale, yScale, rotation, red, green, blue, alpha) {
	return _in(0xfddc2b4e, 0xd3c69df0, _fv(xPos), _fv(yPos), _fv(xScale), _fv(yScale), _fv(rotation), red, green, blue, alpha);
};

window.DuplicateFunctionReference = function (referenceIdentity) {
	return _in(0x00000000, 0xf4e2079d, _ts(referenceIdentity), _r, _s);
};

/**
 * ADD_E* (most likely ADD_ENTITY_*)
 * All found occurrences in b678d:
 * pastebin.com/ceu67jz8
 * Still not sure on the functionality of this native but it has something to do with dynamic mixer groups defined in dynamix.dat15
 */
window.DynamicMixerRelatedFn = function (p0, p1, p2) {
	return _in(0x153973ab, 0x99fe8980, p0, _ts(p1), _fv(p2));
};
window.N_0x153973ab99fe8980 = window.DynamicMixerRelatedFn;

window.EjectJb700Roof = function (vehicle, x, y, z) {
	return _in(0xe38cb9d7, 0xd39fdbcc, vehicle, _fv(x), _fv(y), _fv(z));
};
window.N_0xe38cb9d7d39fdbcc = window.EjectJb700Roof;

window.EnableAlienBloodVfx = function (Toggle) {
	return _in(0x9dce1f0f, 0x78260875, Toggle);
};
window.N_0x9dce1f0f78260875 = window.EnableAlienBloodVfx;

window.EnableAllControlActions = function (inputGroup) {
	return _in(0xa5ffe9b0, 0x5f199de7, inputGroup);
};

/**
 * Creates cartoon effect when Michel smokes the weed
 */
window.EnableClownBloodVfx = function (toggle) {
	return _in(0xd8214905, 0x79791273, toggle);
};
window.SetCameraEndtime = window.EnableClownBloodVfx;

/**
 * control values and meaning: github.com/crosire/scripthookvdotnet/blob/dev_v3/source/scripting/Control.cs
 * and
 * wiki.fivem.net/wiki/Controls
 * 0, 1 and 2 used in the scripts.
 * Control values from the decompiled scripts:
 * 0,1,2,3,4,5,6,8,9,10,11,14,15,16,17,19,21,22,24,25,26,30,31,32,33,34,35,36,
 * 37,44,46,47,59,60,65,68,69,70,71,72,73,74,75,76,79,80,81,82,86,95,98,99,100
 * ,101,114,140,141,143,172,173,174,175,176,177,178,179,180,181,187,188,189,19
 * 0,195,196,197,198,199,201,202,203,204,205,206,207,208,209,210,217,218,219,2
 * 20,221,225,228,229,230,231,234,235,236,237,238,239,240,241,242,245,246,257,
 * 261,262,263,264,286,287,288,289,337,338,339,340,341,342,343
 * INPUTGROUP_MOVE
 * INPUTGROUP_LOOK
 * INPUTGROUP_WHEEL
 * INPUTGROUP_CELLPHONE_NAVIGATE
 * INPUTGROUP_CELLPHONE_NAVIGATE_UD
 * INPUTGROUP_CELLPHONE_NAVIGATE_LR
 * INPUTGROUP_FRONTEND_DPAD_ALL
 * INPUTGROUP_FRONTEND_DPAD_UD
 * INPUTGROUP_FRONTEND_DPAD_LR
 * INPUTGROUP_FRONTEND_LSTICK_ALL
 * INPUTGROUP_FRONTEND_RSTICK_ALL
 * INPUTGROUP_FRONTEND_GENERIC_UD
 * INPUTGROUP_FRONTEND_GENERIC_LR
 * INPUTGROUP_FRONTEND_GENERIC_ALL
 * INPUTGROUP_FRONTEND_BUMPERS
 * INPUTGROUP_FRONTEND_TRIGGERS
 * INPUTGROUP_FRONTEND_STICKS
 * INPUTGROUP_SCRIPT_DPAD_ALL
 * INPUTGROUP_SCRIPT_DPAD_UD
 * INPUTGROUP_SCRIPT_DPAD_LR
 * INPUTGROUP_SCRIPT_LSTICK_ALL
 * INPUTGROUP_SCRIPT_RSTICK_ALL
 * INPUTGROUP_SCRIPT_BUMPERS
 * INPUTGROUP_SCRIPT_TRIGGERS
 * INPUTGROUP_WEAPON_WHEEL_CYCLE
 * INPUTGROUP_FLY
 * INPUTGROUP_SUB
 * INPUTGROUP_VEH_MOVE_ALL
 * INPUTGROUP_CURSOR
 * INPUTGROUP_CURSOR_SCROLL
 * INPUTGROUP_SNIPER_ZOOM_SECONDARY
 * INPUTGROUP_VEH_HYDRAULICS_CONTROL
 * Took those in IDA Pro.Not sure in which order they go
 */
window.EnableControlAction = function (inputGroup, control, enable) {
	return _in(0x35122025, 0x5d64c155, inputGroup, control, enable);
};

/**
 * Shows the crosshair even if it wouldn't show normally. Only works for one frame, so make sure to call it repeatedly.
 */
window.EnableCrosshairThisFrame = function () {
	return _in(0xea7f0ad7, 0xe9ba676f);
};

/**
 * Please change back to _0x4895BDEA16E7C080 (hash collision)
 */
window.EnableDeathbloodSeethrough = function (p0) {
	return _in(0x4895bdea, 0x16e7c080, p0);
};

/**
 * Directly from R*:
 * enum eDispatchType : UINT16
 * {
 * DT_PoliceAutomobile = 1,
 * DT_PoliceHelicopter = 2,
 * DT_FireDepartment = 3,
 * DT_SwatAutomobile = 4,
 * DT_AmbulanceDepartment = 5,
 * DT_PoliceRiders = 6,
 * DT_PoliceVehicleRequest = 7,
 * DT_PoliceRoadBlock = 8,
 * DT_PoliceAutomobileWaitPulledOver = 9,
 * DT_PoliceAutomobileWaitCruising = 10,
 * DT_Gangs = 11,
 * DT_SwatHelicopter = 12,
 * DT_PoliceBoat = 13,
 * DT_ArmyVehicle = 14,
 * DT_BikerBackup = 15
 * };
 * By making toggle false it disables the dispatch.
 * curious if this is what they used when you toggled on and off cops in a GTA IV freemode you hosted. Sad they got rid of the option to make a private session without cops.
 * Also on x360 seems with or without neverWanted on, setting these to all false in SP of course doesn't seem to work. I would understand getting stars, but cops are still dispatched and combat you.
 */
window.EnableDispatchService = function (dispatchService, toggle) {
	return _in(0xdc0f8178, 0x84cdd856, dispatchService, toggle);
};
window.N_0xdc0f817884cdd856 = window.EnableDispatchService;

/**
 * More info: http://gtaforums.com/topic/836367-adding-props-to-interiors/
 */
window.EnableInteriorProp = function (interiorID, propName) {
	return _in(0x55e86af2, 0x712b36a1, interiorID, _ts(propName));
};
window.N_0x55e86af2712b36a1 = window.EnableInteriorProp;

/**
 * Enables laser sight on any weapon.
 * It doesn't work. Neither on tick nor OnKeyDown
 */
window.EnableLaserSightRendering = function (toggle) {
	return _in(0xc8b46d77, 0x27d864aa, toggle);
};

window.EnableMovieSubtitles = function (toggle) {
	return _in(0x873fa65c, 0x778ad970, toggle);
};

/**
 * #4
 */
window.EnableScriptBrainSet = function (brainSet) {
	return _in(0x67aa4d73, 0xf0cfa86b, brainSet);
};

window.EnableSpecialAbility = function (player, toggle) {
	return _in(0x181ec197, 0xdaefe121, player, toggle);
};

window.EnableStuntJumpSet = function (p0) {
	return _in(0xe369a578, 0x3b866016, p0);
};

/**
 * Makes the ped jump around like they're in a tennis match
 */
window.EnableTennisMode = function (ped, toggle, p2) {
	return _in(0x28a04b41, 0x1933f8a6, ped, toggle, p2);
};

window.EndFindKvp = function (handle) {
	return _in(0x00000000, 0xb3210203, handle);
};

window.EndFindObject = function (findHandle) {
	return _in(0x00000000, 0xdeda4e50, findHandle);
};

window.EndFindPed = function (findHandle) {
	return _in(0x00000000, 0x9615c2ad, findHandle);
};

window.EndFindPickup = function (findHandle) {
	return _in(0x00000000, 0x3c407d53, findHandle);
};

window.EndFindVehicle = function (findHandle) {
	return _in(0x00000000, 0x9227415a, findHandle);
};

window.EndReplayStats = function () {
	return _in(0xa23e821f, 0xbdf8a5f2);
};

/**
 * Pops and calls the Scaleform function on the stack
 */
window.EndScaleformMovieMethod = function () {
	return _in(0xc6796a8f, 0xfa375e53);
};
window.PopScaleformMovieFunctionVoid = window.EndScaleformMovieMethod;

/**
 * Pops and calls the Scaleform movie on the stack. Returns data from the function (not sure if this is a string).
 */
window.EndScaleformMovieMethodReturn = function () {
	return _in(0xc50aa39a, 0x577af886, _r, _ri);
};
window.PopScaleformMovieFunction = window.EndScaleformMovieMethodReturn;

/**
 * Clear the current srl and stop rendering the area selected by PrefetchSrl and started with BeginSrl.
 */
window.EndSrl = function () {
	return _in(0x0a41540e, 0x63c9ee17);
};

/**
 * This does NOT get called per frame. Call it once to show, then use UI::_REMOVE_LOADING_PROMPT to remove it
 * Changes the the above native's (UI::_SET_LOADING_PROMPT_TEXT_ENTRY) spinning circle type.
 * Types:
 * enum LoadingPromptTypes
 * {
 * LOADING_PROMPT_LEFT,
 * LOADING_PROMPT_LEFT_2,
 * LOADING_PROMPT_LEFT_3,
 * SAVE_PROMPT_LEFT,
 * LOADING_PROMPT_RIGHT,
 * };
 */
window.EndTextCommandBusyString = function (busySpinnerType) {
	return _in(0xbd12f822, 0x8410d9b4, busySpinnerType);
};
window.N_0xbd12f8228410d9b4 = window.EndTextCommandBusyString;
window.ShowLoadingPrompt = window.EndTextCommandBusyString;

window.EndTextCommandClearPrint = function () {
	return _in(0xfcc75460, 0xaba29378);
};
window.N_0xfcc75460aba29378 = window.EndTextCommandClearPrint;

/**
 * -----------
 * p3 (duration in MS) was previously mentioned as "shape", but with some more testing it seems that it's more likely to be a duration in MS. (Tested this when not calling it every tick, but instead only once and let it display for the specified duration).
 * -1 seems to be default delay (around 3 seconds), 5000 (ms) seems to be the max. Anything > 5000 will still result in 5 seconds of display time.
 * Old p3 (shape) description: "shape goes from -1 to 50 (may be more)."
 * --------------
 * p0 is always 0.
 * Example:
 * void FloatingHelpText(char* text)
 * {
 * BEGIN_TEXT_COMMAND_DISPLAY_HELP("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * END_TEXT_COMMAND_DISPLAY_HELP (0, 0, 1, -1);
 * }
 * Image:
 * - imgbin.org/images/26209.jpg
 * more inputs/icons:
 * - pastebin.com/nqNYWMSB
 * Used to be known as _DISPLAY_HELP_TEXT_FROM_STRING_LABEL
 */
window.EndTextCommandDisplayHelp = function (p0, loop, beep, duration) {
	return _in(0x238ffe5c, 0x7b0498a6, p0, loop, beep, duration);
};
window.DisplayHelpTextFromStringLabel = window.EndTextCommandDisplayHelp;

/**
 * After applying the properties to the text (See UI::SET_TEXT_), this will draw the text in the applied position. Also 0.0f < x, y < 1.0f, percentage of the axis.
 * Used to be known as _DRAW_TEXT
 */
window.EndTextCommandDisplayText = function (x, y) {
	return _in(0xcd015e5b, 0xb0d96a57, _fv(x), _fv(y));
};
window.DrawText = window.EndTextCommandDisplayText;

/**
 * Used with _BEGIN_TEXT_COMMAND_WIDTH.
 * In scripts, p0 is false when used in combination with "ESMINDOLLA" or "ESDOLLA", otherwise it's true.
 * Returns from range 0 to 1.
 */
window.EndTextCommandGetWidth = function (p0) {
	return _in(0x85f061da, 0x64ed2f67, p0, _r, _rf);
};
window.GetTextScreenWidth = window.EndTextCommandGetWidth;

window.EndTextCommandIsMessageDisplayed = function () {
	return _in(0x8a9ba1ab, 0x3e237613, _r);
};
window.N_0x8a9ba1ab3e237613 = window.EndTextCommandIsMessageDisplayed;

window.EndTextCommandIsThisHelpMessageBeingDisplayed = function (p0) {
	return _in(0x10bddbfc, 0x529428dd, p0, _r);
};
window.N_0x10bddbfc529428dd = window.EndTextCommandIsThisHelpMessageBeingDisplayed;

/**
 * p0 is always false in scripts.
 */
window.EndTextCommandObjective = function (p0) {
	return _in(0xcfdbdf5a, 0xe59ba0f4, p0);
};
window.N_0xcfdbdf5ae59ba0f4 = window.EndTextCommandObjective;

/**
 * Draws the subtitle at middle center of the screen.
 * int duration = time in milliseconds to show text on screen before disappearing
 * drawImmediately = If true, the text will be drawn immediately, if false, the text will be drawn after the previous subtitle has finished
 * Used to be known as _DRAW_SUBTITLE_TIMED
 */
window.EndTextCommandPrint = function (duration, drawImmediately) {
	return _in(0x9d77056a, 0x530643f6, duration, drawImmediately);
};
window.DrawSubtitleTimed = window.EndTextCommandPrint;

/**
 * Previously called _END_TEXT_COMPONENT
 */
window.EndTextCommandScaleformString = function () {
	return _in(0x362e2d3f, 0xe93a9959);
};
window.EndTextComponent = window.EndTextCommandScaleformString;

window.EndTextCommandScaleformString_2 = function () {
	return _in(0xae4e8157, 0xd9ecf087);
};
window.N_0xae4e8157d9ecf087 = window.EndTextCommandScaleformString_2;

/**
 * Finalizes a text command started with [`BEGIN_TEXT_COMMAND_SET_BLIP_NAME`](#_0xF9113A30DE5C6670), setting the name
 * of the specified blip.
 * @param blip The blip to change the name for.
 */
window.EndTextCommandSetBlipName = function (blip) {
	return _in(0xbc38b49b, 0xcb83bc9b, blip);
};

window.EndTextCommandTimer = function (p0) {
	return _in(0xa8691197, 0x9638106f, p0);
};
window.N_0xa86911979638106f = window.EndTextCommandTimer;

/**
 * Only found twice in decompiled scripts. Something to do with an entity/object?
 * On a side note, it's very interesting how the hash for this native is "DEADC0DE" - this is usually used as padding for initializing a buffer of some sort. I wonder if this native is actually "dead"?
 * "carmod_shop.ysc", line 9520:
 * if (ENTITY::DOES_ENTITY_EXIST(l_324._f6)) {
 * GRAPHICS::_0xDEADC0DEDEADC0DE(l_324._f6);
 * }
 * "fm_mission_controller.ysc", line 189641:
 * if (GAMEPLAY::IS_BIT_SET(g_1870E1._f7B64[a_0 -- [[104]] ]._f25, 28)) {
 * GRAPHICS::_0xDEADC0DEDEADC0DE(NETWORK::NET_TO_OBJ(l_4064._f26A._f87[a_0 -- [[1]] ]));
 * if (!GAMEPLAY::IS_BIT_SET(g_1870E1._f7B64[a_0 -- [[104]] ]._f25, 31)) {
 * if (!ENTITY::IS_ENTITY_DEAD(v_7)) {
 * AUDIO::PLAY_SOUND_FROM_ENTITY(-1, "EMP_Vehicle_Hum", v_7, "DLC_HEIST_BIOLAB_DELIVER_EMP_SOUNDS", 0, 0);
 * GAMEPLAY::SET_BIT(&g_1870E1._f7B64[a_0 -- [[104]] ]._f25, 31);
 * }
 * }
 * }
 * Console Hash: 0xC12AC47A
 * ----------
 * It's most likely named UPDATE_* (like UPDATE_ENTITY_SHIT_OR_SOMETHING).
 */
window.EntityDescriptionText = function (entity) {
	return _in(0xdeadc0de, 0xdeadc0de, entity);
};
window.N_0xdeadc0dedeadc0de = window.EntityDescriptionText;

window.ExecuteCommand = function (commandString) {
	return _in(0x00000000, 0x561c060b, _ts(commandString));
};

/**
 * Will change world AABB so that given point will be inside of the world limits.
 * Example:
 * You want world limits to be -9000<X<10000 -11000<Y<12000 and leave Z limits as is.
 * You should call this function two times:
 * _EXPAND_WORLD_LIMITS(-9000.0,-11000.0,30.0)
 * _EXPAND_WORLD_LIMITS(10000.0,12000.0,30.0)
 * Appears only 3 times in the scripts, more specifically in michael1.ysc
 * Console hash: 0x64ddb07d
 * -
 * This can be used to prevent dying if you are "out of the world"
 */
window.ExpandWorldLimits = function (x, y, z) {
	return _in(0x5006d96c, 0x995a5827, _fv(x), _fv(y), _fv(z));
};
window.N_0x5006d96c995a5827 = window.ExpandWorldLimits;

/**
 * This native is not implemented.
 */
window.ExperimentalLoadCloneCreate = function (data, objectId, tree) {
	return _in(0x00000000, 0xd2cb95a3, _ts(data), objectId, _ts(tree), _r, _ri);
};

/**
 * This native is not implemented.
 */
window.ExperimentalLoadCloneSync = function (entity, data) {
	return _in(0x00000000, 0x6bc189ac, entity, _ts(data));
};

/**
 * This native is not implemented.
 */
window.ExperimentalSaveCloneCreate = function (entity) {
	return _in(0x00000000, 0x9d65cad2, entity, _r, _s);
};

/**
 * This native is not implemented.
 */
window.ExperimentalSaveCloneSync = function (entity) {
	return _in(0x00000000, 0x38d19210, entity, _r, _s);
};

/**
 * Forces the ped to fall back and kills it.
 * It doesn't really explode the ped's head but it kills the ped
 */
window.ExplodePedHead = function (ped, weaponHash) {
	return _in(0x2d05ced3, 0xa38d0f3a, ped, _ch(weaponHash));
};

/**
 * WEAPON::EXPLODE_PROJECTILES(PLAYER::PLAYER_PED_ID(), func_221(0x00000003), 0x00000001);
 */
window.ExplodeProjectiles = function (ped, weaponHash, p2) {
	return _in(0xfc4bd125, 0xde7611e4, ped, _ch(weaponHash), p2);
};

/**
 * Explodes a selected vehicle.
 * Vehicle vehicle = Vehicle you want to explode.
 * BOOL isAudible = If explosion makes a sound.
 * BOOL isInvisible = If the explosion is invisible or not.
 * First BOOL does not give any visual explosion, the vehicle just falls apart completely but slowly and starts to burn.
 */
window.ExplodeVehicle = function (vehicle, isAudible, isInvisible) {
	return _in(0xba71116a, 0xdf5b514c, vehicle, isAudible, isInvisible);
};

window.ExplodeVehicleInCutscene = function (vehicle, p1) {
	return _in(0x786a4eb6, 0x7b01bf0b, vehicle, p1);
};

window.FacebookDoUnkCheck = function () {
	return _in(0xa75e2b67, 0x33da5142, _r);
};
window.N_0xa75e2b6733da5142 = window.FacebookDoUnkCheck;

window.FacebookIsAvailable = function () {
	return _in(0x43865688, 0xae10f0d7, _r);
};
window.N_0x43865688ae10f0d7 = window.FacebookIsAvailable;

window.FacebookIsSendingData = function () {
	return _in(0x62b9fec9, 0xa11f10ef, _r);
};
window.N_0x62b9fec9a11f10ef = window.FacebookIsSendingData;

/**
 * GTA Online character creation
 */
window.FacebookSetCreateCharacterComplete = function () {
	return _in(0xdc484731, 0x42545431, _r);
};
window.N_0xdc48473142545431 = window.FacebookSetCreateCharacterComplete;

window.FacebookSetHeistComplete = function (heistName, cashEarned, xpEarned) {
	return _in(0x098ab65b, 0x9ed9a9ec, _ts(heistName), cashEarned, xpEarned, _r);
};
window.N_0x098ab65b9ed9a9ec = window.FacebookSetHeistComplete;

/**
 * milestoneId:
 * 0 = "percentcomplete"
 * 1 = "storycomplete"
 * 2 = "vehicles"
 * 3 = "properties"
 * 4 = "psych"
 * 5 = "mapreveal"
 * 6 = "prologue"
 */
window.FacebookSetMilestoneComplete = function (milestoneId) {
	return _in(0x0ae1f165, 0x3b554ab9, milestoneId, _r);
};
window.N_0x0ae1f1653b554ab9 = window.FacebookSetMilestoneComplete;

/**
 * Fades nearby decals within the range specified
 */
window.FadeDecalsInRange = function (p0, p1, p2, p3, p4) {
	return _in(0xd77edadb, 0x0420e6e0, p0, p1, p2, p3, p4);
};

/**
 * Hardcoded to not work in SP.
 */
window.FadeOutLocalPlayer = function (p0) {
	return _in(0x416dbd4c, 0xd6ed8dd2, p0);
};

window.FilloutPmPlayerList = function (p1, p2) {
	return _in(0xcbbd7c49, 0x91b64809, _i, p1, p2, _r);
};

window.FilloutPmPlayerListWithNames = function (p2, p3) {
	return _in(0x716b6db9, 0xd1886106, _i, _i, p2, p3, _r);
};

/**
 * In the script "player_scene_t_bbfight.c4":
 * "if (ENTITY::FIND_ANIM_EVENT_PHASE(&l_16E, &l_19F[v_4 -- [[16]] ], v_9, &v_A, &v_B))"
 * -- &l_16E (p0) is requested as an anim dictionary earlier in the script.
 * -- &l_19F[v_4 -- [[16]] ] (p1) is used in other natives in the script as the "animation" param.
 * -- v_9 (p2) is instantiated as "victim_fall"; I'm guessing that's another anim
 * --v_A and v_B (p3 & p4) are both set as -1.0, but v_A is used immediately after this native for:
 * "if (v_A < ENTITY::GET_ENTITY_ANIM_CURRENT_TIME(...))"
 * Both v_A and v_B are seemingly used to contain both Vector3's and floats, so I can't say what either really is other than that they are both output parameters. p4 looks more like a *Vector3 though
 * -alphazolam
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.FindAnimEventPhase = function (animDictionary, animName, p2) {
	return _in(0x07f1be2b, 0xccaa27a7, _ts(animDictionary), _ts(animName), _ts(p2), _i, _i, _r);
};

window.FindFirstObject = function (outEntity) {
	return _in(0x00000000, 0xfaa6cb5d, _ii(outEntity) /* may be optional */, _r, _ri);
};

window.FindFirstPed = function (outEntity) {
	return _in(0x00000000, 0xfb012961, _ii(outEntity) /* may be optional */, _r, _ri);
};

window.FindFirstPickup = function (outEntity) {
	return _in(0x00000000, 0x3ff9d340, _ii(outEntity) /* may be optional */, _r, _ri);
};

window.FindFirstVehicle = function (outEntity) {
	return _in(0x00000000, 0x15e55694, _ii(outEntity) /* may be optional */, _r, _ri);
};

window.FindKvp = function (handle) {
	return _in(0x00000000, 0xbd7bebc5, handle, _r, _s);
};

window.FindNextObject = function (findHandle, outEntity) {
	return _in(0x00000000, 0x4e129dbf, findHandle, _ii(outEntity) /* may be optional */, _r);
};

window.FindNextPed = function (findHandle, outEntity) {
	return _in(0x00000000, 0xab09b548, findHandle, _ii(outEntity) /* may be optional */, _r);
};

window.FindNextPickup = function (findHandle, outEntity) {
	return _in(0x00000000, 0x4107ef0f, findHandle, _ii(outEntity) /* may be optional */, _r);
};

window.FindNextVehicle = function (findHandle, outEntity) {
	return _in(0x00000000, 0x8839120d, findHandle, _ii(outEntity) /* may be optional */, _r);
};

window.FindRadioStationIndex = function (station) {
	return _in(0x8d674897, 0x93ff428b, station, _r, _ri);
};

/**
 * Finds a position ahead of the player by predicting the players next actions.
 * The positions match path finding node positions.
 * When roads diverge, the position may rapidly change between two or more positions. This is due to the engine not being certain of which path the player will take.
 * =======================================================
 * I may sort this with alter research, but if someone
 * already knows please tell what the difference in
 * X2, Y2, Z2 is. I doubt it's rotation. Is it like
 * checkpoints where X1, Y1, Z1 is your/a position and
 * X2, Y2, Z2 is a given position ahead of that position?
 * =======================================================
 */
window.FindSpawnPointInDirection = function (x1, y1, z1, x2, y2, z2, distance, spawnPoint) {
	return _in(0x6874e219, 0x0b0c1972, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(distance), _v, _r);
};

window.FixVehicleWindow = function (vehicle, index) {
	return _in(0x772282eb, 0xeb95e682, vehicle, index, _r, _ri);
};

/**
 * If set to true ability bar will flash
 */
window.FlashAbilityBar = function (toggle) {
	return _in(0x02cfba0c, 0x9e9275ce, toggle);
};

/**
 * adds a short flash to the Radar/Minimap
 * Usage: UI.FLASH_MINIMAP_DISPLAY
 */
window.FlashMinimapDisplay = function () {
	return _in(0xf2dd778c, 0x22b15bda);
};

window.FlashWantedDisplay = function (p0) {
	return _in(0xa18afb39, 0x081b6a1f, p0, _r, _ri);
};

window.Floor = function (value) {
	return _in(0xf34ee736, 0xcf047844, _fv(value), _r, _ri);
};

/**
 * if value is set to true, and ambient siren sound will be played.
 * -------------------------------------------------------------------------
 * Appears to enable/disable an audio flag.
 */
window.ForceAmbientSiren = function (value) {
	return _in(0x552369f5, 0x49563ad5, value);
};
window.N_0x552369f549563ad5 = window.ForceAmbientSiren;

/**
 * used with 1,2,8,64,128 in the scripts
 */
window.ForceCleanup = function (cleanupFlags) {
	return _in(0xbc8983f3, 0x8f78ed51, cleanupFlags);
};

/**
 * PLAYER::FORCE_CLEANUP_FOR_ALL_THREADS_WITH_THIS_NAME("pb_prostitute", 1); // Found in decompilation
 */
window.ForceCleanupForAllThreadsWithThisName = function (name, cleanupFlags) {
	return _in(0x4c68dddd, 0xf0097317, _ts(name), cleanupFlags);
};

window.ForceCleanupForThreadWithThisId = function (id, cleanupFlags) {
	return _in(0xf745b376, 0x30df176b, id, cleanupFlags);
};

/**
 * Based on carmod_shop script decompile this takes a vehicle parameter. It is called when repair is done on initial enter.
 */
window.ForceEntityAiAndAnimationUpdate = function (entity) {
	return _in(0x40fdedb7, 0x2f8293b2, entity);
};

/**
 * Some motionstate hashes are
 * 0xec17e58 (standing idle), 0xbac0f10b (nothing?), 0x3f67c6af (aiming with pistol 2-h), 0x422d7a25 (stealth), 0xbd8817db, 0x916e828c
 * and those for the strings
 * "motionstate_idle", "motionstate_walk", "motionstate_run", "motionstate_actionmode_idle", and "motionstate_actionmode_walk".
 * Regarding p2, p3 and p4: Most common is 0, 0, 0); followed by 0, 1, 0); and 1, 1, 0); in the scripts. p4 is very rarely something other than 0.
 * [31/03/2017] ins1de :
 * enum MotionState
 * {
 * StopRunning = -530524,
 * StopWalking = -668482597,
 * Idle = 247561816, // 1, 1, 0
 * Idl2 = -1871534317,
 * SkyDive =-1161760501, // 0, 1, 0
 * Stealth = 1110276645,
 * Sprint = -1115154469,
 * Swim = -1855028596,
 * Unknown1 = 1063765679,
 * Unknown2 = -633298724,
 * }
 */
window.ForcePedMotionState = function (ped, motionStateHash, p2, p3, p4) {
	return _in(0xf28965d0, 0x4f570dca, ped, _ch(motionStateHash), p2, p3, p4, _r);
};

window.ForcePedToOpenParachute = function (ped) {
	return _in(0x16e42e80, 0x0b472221, ped);
};

/**
 * Forces the particular room in an interior to load incase not teleporting into the portal.
 */
window.ForceRoomForEntity = function (entity, interiorID, roomHashKey) {
	return _in(0x52923c47, 0x10dd9907, entity, interiorID, _ch(roomHashKey));
};

/**
 * Exits the game and downloads a fresh social club update on next restart.
 */
window.ForceSocialClubUpdate = function () {
	return _in(0xeb6891f0, 0x3362fb12);
};

/**
 * This native sets the audio of the specified vehicle to audioName (p1).
 * Use the audioNameHash found in vehicles.meta
 * Example:
 * _FORCE_VEHICLE_ENGINE_SOUND(veh, "ADDER");
 * The selected vehicle will now have the audio of the Adder.
 * FORCE_VEHICLE_???
 */
window.ForceVehicleEngineAudio = function (vehicle, audioName) {
	return _in(0x4f0c4139, 0x26060b38, vehicle, _ts(audioName));
};
window.N_0x4f0c413926060b38 = window.ForceVehicleEngineAudio;
window.SetVehicleAudio = window.ForceVehicleEngineAudio;

window.FormatFocusHeading = function (x, y, z, rad, p4, p5) {
	return _in(0x219c7b8d, 0x53e429fd, _fv(x), _fv(y), _fv(z), _fv(rad), p4, p5, _r, _ri);
};
window.N_0x219c7b8d53e429fd = window.FormatFocusHeading;

/**
 * No, this should be called SET_ENTITY_KINEMATIC. It does more than just "freeze" it's position.
 * ^Rockstar Devs named it like that, Now cry about it.
 */
window.FreezeEntityPosition = function (entity, toggle) {
	return _in(0x428ca6db, 0xd1094446, entity, toggle);
};

window.FreezePedCameraRotation = function (ped) {
	return _in(0xff287323, 0xb0e2c69a, ped);
};
window.N_0xff287323b0e2c69a = window.FreezePedCameraRotation;

window.FreezeRadioStation = function (radioStation) {
	return _in(0x344f393b, 0x027e38c3, _ts(radioStation));
};

/**
 * Usage example:
 * Public Function GenerateDirectionsToCoord(Pos As Vector3) As Tuple(Of String, Single, Single)
 * Dim f4, f5, f6 As New OutputArgument()
 * Native.Function.Call(Hash.GENERATE_DIRECTIONS_TO_COORD, Pos.X, Pos.Y, Pos.Z, True, f4, f5, f6)
 * Dim direction As String = f4.GetResult(Of Single)()
 * Return New Tuple(Of String, Single, Single)(direction.Substring(0, 1), f5.GetResult(Of Single)(), f6.GetResult(Of Single)())
 * End Function
 * p3 I use 1
 * direction:
 * 0 = You Have Arrived
 * 1 = Recalculating Route, Please make a u-turn where safe
 * 2 = Please Proceed the Highlighted Route
 * 3 = In (distToNxJunction) Turn Left
 * 4 = In (distToNxJunction) Turn Right
 * 5 = In (distToNxJunction) Go Straight
 * 6 = In (distToNxJunction) Keep Left
 * 7 = In (distToNxJunction) Keep Right
 * 8 = In (distToNxJunction) Join the freeway
 * 9 = In (distToNxJunction) Exit Freeway
 * return value set to 0 always
 */
window.GenerateDirectionsToCoord = function (x, y, z, p3) {
	return _in(0xf90125f1, 0xf79ecdf8, _fv(x), _fv(y), _fv(z), p3, _i, _f, _f, _r, _ri);
};

/**
 * p0 = int (?)
 * Dr. Underscore (1/6/18):
 * This gets the progression of an achievement. Returns 0 if the achievement cannot be progressed.
 */
window.GetAchievementProgression = function (achId) {
	return _in(0x1c186837, 0xd0619335, achId, _r, _ri);
};
window.N_0x1c186837d0619335 = window.GetAchievementProgression;

/**
 * Returns current screen resolution.
 */
window.GetActiveScreenResolution = function () {
	return _in(0x873c9f31, 0x04101dd3, _i, _i);
};
window.GetScreenActiveResolution = window.GetActiveScreenResolution;

window.GetActiveVehicleMissionType = function (veh) {
	return _in(0x534aeba6, 0xe5ed4cab, veh, _r, _ri);
};

/**
 * native only found once in appinternet.c4
 * same thing as this but does not need websiteID
 * Any _0xE3B05614DCE1D014(Any p0) // 0xE3B05614DCE1D014 0xD217EE7E
 * returns current websitePageID
 */
window.GetActiveWebsiteId = function () {
	return _in(0x01a358d9, 0x128b7a86, _r, _ri);
};
window.N_0x01a358d9128b7a86 = window.GetActiveWebsiteId;

/**
 * Returns the current AI BLIP for the specified ped
 */
window.GetAiBlip = function (ped) {
	return _in(0x56176892, 0x826a4fe8, ped, _r, _ri);
};
window.N_0x56176892826a4fe8 = window.GetAiBlip;

/**
 * Gets the amount of bombs that this vehicle has. As far as I know, this does _not_ impact vehicle weapons or the ammo of those weapons in any way, it is just a way to keep track of the amount of bombs in a specific plane.
 * In decompiled scripts this is used to check if the vehicle has enough bombs before a bomb can be dropped (bombs are dropped by using [`_SHOOT_SINGLE_BULLET_BETWEEN_COORDS_WITH_EXTRA_PARAMS`](#_0xBFE5756E7407064A)).
 * Use [`_SET_AIRCRAFT_BOMB_COUNT`](#_0xF4B2ED59DEB5D774) to set the amount of bombs on that vehicle.
 * @param aircraft The vehicle to get the amount of bombs from.
 * @return An int indicating the amount of bombs remaining on that plane.
 */
window.GetAircraftBombCount = function (aircraft) {
	return _in(0xea12bd13, 0x0d7569a1, aircraft, _r, _ri);
};
window.N_0xea12bd130d7569a1 = window.GetAircraftBombCount;

/**
 * Similar to [`_GET_AIRCRAFT_BOMB_COUNT`](#_0xEA12BD130D7569A1), this gets the amount of countermeasures that are present on this vehicle.
 * Use [`_SET_AIRCRAFT_COUNTERMEASURE_COUNT`](#_0x9BDA23BF666F0855) to set the current amount.
 * @param aircraft The vehicle to get the amount of countermeasures from.
 * @return An int indicating the amount of countermeasures remaining on that plane.
 */
window.GetAircraftCountermeasureCount = function (aircraft) {
	return _in(0xf846aa63, 0xdf56b804, aircraft, _r, _ri);
};
window.N_0xf846aa63df56b804 = window.GetAircraftCountermeasureCount;

window.GetAllVehicles = function (vehArray) {
	return _in(0x9b8e1bf0, 0x4b51f2e8, _ii(vehArray) /* may be optional */, _r, _ri);
};

window.GetAllocatedStackSize = function () {
	return _in(0x8b3ca62b, 0x1ef19b62, _r, _ri);
};

window.GetAmmoInClip = function (ped, weaponHash, ammo) {
	return _in(0x2e120224, 0x8937775c, ped, _ch(weaponHash), _ii(ammo) /* may be optional */, _r);
};

/**
 * WEAPON::GET_AMMO_IN_PED_WEAPON(PLAYER::PLAYER_PED_ID(), a_0)
 * From decompiled scripts
 * Returns total ammo in weapon
 * GTALua Example :
 * natives.WEAPON.GET_AMMO_IN_PED_WEAPON(plyPed, WeaponHash)
 */
window.GetAmmoInPedWeapon = function (ped, weaponhash) {
	return _in(0x015a5221, 0x36d7f951, ped, _ch(weaponhash), _r, _ri);
};

/**
 * Returns the degree of angle between (x1, y1) and (x2, y2) lines in 2D coordinate system.
 */
window.GetAngleBetween_2dVectors = function (x1, y1, x2, y2) {
	return _in(0x186fc4be, 0x848e1c92, _fv(x1), _fv(y1), _fv(x2), _fv(y2), _r, _rf);
};

/**
 * Console Hash: 0x8B5E3E3D = GET_ANIM_DURATION
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.GetAnimDuration = function (animDict, animName) {
	return _in(0xfeddf04d, 0x62b8d790, _ts(animDict), _ts(animName), _r, _rf);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.GetAnimInitialOffsetPosition = function (animDict, animName, x, y, z, xRot, yRot, zRot, p8, p9) {
	return _in(0xbe22b26d, 0xd764c040, _ts(animDict), _ts(animName), _fv(x), _fv(y), _fv(z), _fv(xRot), _fv(yRot), _fv(zRot), _fv(p8), p9, _r, _rv);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.GetAnimInitialOffsetRotation = function (animDict, animName, x, y, z, xRot, yRot, zRot, p8, p9) {
	return _in(0x4b805e60, 0x46ee9e47, _ts(animDict), _ts(animName), _fv(x), _fv(y), _fv(z), _fv(xRot), _fv(yRot), _fv(zRot), _fv(p8), p9, _r, _rv);
};

window.GetAspectRatio = function (b) {
	return _in(0xf1307ef6, 0x24a80d87, b, _r, _rf);
};
window.GetScreenAspectRatio = window.GetAspectRatio;

window.GetAudibleMusicTrackTextId = function () {
	return _in(0x50b196fc, 0x9ed6545b, _r, _ri);
};

window.GetBenchmarkTime = function () {
	return _in(0xe599a503, 0xb3837e1b, _r, _rf);
};
window.N_0xe599a503b3837e1b = window.GetBenchmarkTime;

/**
 * p1 is always 0 in the scripts.
 */
window.GetBestPedWeapon = function (ped, p1) {
	return _in(0x8483e98e, 0x8b888ae2, ped, p1, _r, _ri);
};

window.GetBitsInRange = function (_var, rangeStart, rangeEnd) {
	return _in(0x53158863, 0xfcc0893a, _var, rangeStart, rangeEnd, _r, _ri);
};

window.GetBlipAlpha = function (blip) {
	return _in(0x970f608f, 0x0ee6c885, blip, _r, _ri);
};

window.GetBlipColour = function (blip) {
	return _in(0xdf729e8d, 0x20cf7327, blip, _r, _ri);
};

window.GetBlipCoords = function (blip) {
	return _in(0x586afe3f, 0xf72d996e, blip, _r, _rv);
};

/**
 * Returns the Blip handle of given Entity.
 */
window.GetBlipFromEntity = function (entity) {
	return _in(0xbc8dbdca, 0x2436f7e8, entity, _r, _ri);
};

window.GetBlipHudColour = function (blip) {
	return _in(0x729b5f1e, 0xfbc0aaee, blip, _r, _ri);
};

window.GetBlipInfoIdCoord = function (blip) {
	return _in(0xfa7c7f0a, 0xadf25d09, blip, _r, _rv);
};

window.GetBlipInfoIdDisplay = function (blip) {
	return _in(0x1e314167, 0xf701dc3b, blip, _r, _ri);
};

window.GetBlipInfoIdEntityIndex = function (blip) {
	return _in(0x4ba4e255, 0x3afedc2c, blip, _r, _ri);
};

window.GetBlipInfoIdIterator = function () {
	return _in(0x186e5d25, 0x2fa50e7d, _r, _ri);
};

/**
 * This function is hard-coded to always return 0.
 */
window.GetBlipInfoIdPickupIndex = function (blip) {
	return _in(0x9b6786e4, 0xc03dd382, blip, _r, _ri);
};

/**
 * Returns a value based on what the blip is attached to
 * 1
 * 2
 * 3
 * 4
 * 5
 * 6
 * 7
 */
window.GetBlipInfoIdType = function (blip) {
	return _in(0xbe9b0959, 0xffd0779b, blip, _r, _ri);
};

/**
 * Blips Images + IDs:
 * gtaxscripting.blogspot.com/2016/05/gta-v-blips-id-and-image.html
 */
window.GetBlipSprite = function (blip) {
	return _in(0x1fc87746, 0x4a04fc4f, blip, _r, _ri);
};

/**
 * Console Hash: 0xE97A4F5E
 */
window.GetBoatAnchor = function (vehicle) {
	return _in(0x26c10ecb, 0xda5d043b, vehicle, _r);
};

window.GetCamAnimCurrentPhase = function (cam) {
	return _in(0xa10b2db4, 0x9e92a6b0, cam, _r, _rf);
};

window.GetCamCoord = function (cam) {
	return _in(0xbac038f7, 0x459ae5ae, cam, _r, _rv);
};

window.GetCamFarClip = function (cam) {
	return _in(0xb60a9cfe, 0xb21ca6aa, cam, _r, _rf);
};

window.GetCamFarDof = function (cam) {
	return _in(0x255f8daf, 0xd540d397, cam, _r, _rf);
};

window.GetCamFov = function (cam) {
	return _in(0xc3330a45, 0xcccdb26a, cam, _r, _rf);
};

/**
 * Returns the world matrix of the specified camera. To turn this into a view matrix, calculate the inverse.
 */
window.GetCamMatrix = function (camera) {
	return _in(0x00000000, 0x8f57a89d, camera, _v, _v, _v, _v);
};

window.GetCamNearClip = function (cam) {
	return _in(0xc520a34d, 0xafbf24b1, cam, _r, _rf);
};

/**
 * The last parameter, as in other "ROT" methods, is usually 2.
 */
window.GetCamRot = function (cam, rotationOrder) {
	return _in(0x7d304c1c, 0x955e3e12, cam, rotationOrder, _r, _rv);
};

/**
 * I named the beginning from Any to BOOL as this native is used in an if statement as well.
 * Big surprise it returns an int.
 */
window.GetCamSplineNodeIndex = function (cam) {
	return _in(0xb22b17df, 0x858716a6, cam, _r, _ri);
};

/**
 * I'm pretty sure the parameter is the camera as usual, but I am not certain so I'm going to leave it as is.
 */
window.GetCamSplineNodePhase = function (cam) {
	return _in(0xd9d0e694, 0xc8282c96, cam, _r, _rf);
};

/**
 * Can use this with SET_CAM_SPLINE_PHASE to set the float it this native returns.
 * (returns 1.0f when no nodes has been added, reached end of non existing spline)
 */
window.GetCamSplinePhase = function (cam) {
	return _in(0xb5349e36, 0xc546509a, cam, _r, _rf);
};

/**
 * Gets the position of the cargobob hook, in world coords.
 */
window.GetCargobobHookPosition = function (cargobob) {
	return _in(0xcbdb9b92, 0x3cacc92d, cargobob, _r, _rv);
};
window.N_0xcbdb9b923cacc92d = window.GetCargobobHookPosition;

window.GetCauseOfMostRecentForceCleanup = function () {
	return _in(0x9a41cf46, 0x74a12272, _r, _ri);
};

window.GetCgoffset = function (rope) {
	return _in(0x8214a4b5, 0xa7a33612, rope, _r, _rv);
};

window.GetClipSetForScriptedGunTask = function (p0) {
	return _in(0x3a8cadc7, 0xd37aacc5, p0, _r, _s);
};

window.GetClockDayOfMonth = function () {
	return _in(0x3d10bc92, 0xa4db1d35, _r, _ri);
};

/**
 * Gets the current day of the week.
 * 0: Sunday
 * 1: Monday
 * 2: Tuesday
 * 3: Wednesday
 * 4: Thursday
 * 5: Friday
 * 6: Saturday
 */
window.GetClockDayOfWeek = function () {
	return _in(0xd972e4bd, 0x7aeb235f, _r, _ri);
};

/**
 * Gets the current ingame hour, expressed without zeros. (09:34 will be represented as 9)
 */
window.GetClockHours = function () {
	return _in(0x25223ca6, 0xb4d20b7f, _r, _ri);
};

/**
 * Gets the current ingame clock minute.
 */
window.GetClockMinutes = function () {
	return _in(0x13d2b8ad, 0xd79640f2, _r, _ri);
};

window.GetClockMonth = function () {
	return _in(0xbbc72712, 0xe80257a1, _r, _ri);
};

/**
 * Gets the current ingame clock second. Note that ingame clock seconds change really fast since a day in GTA is only 48 minutes in real life.
 */
window.GetClockSeconds = function () {
	return _in(0x494e97c2, 0xef27c470, _r, _ri);
};

window.GetClockYear = function () {
	return _in(0x961777e6, 0x4bdaf717, _r, _ri);
};

/**
 * Returns TRUE if it found something. FALSE if not.
 */
window.GetClosestFirePos = function (x, y, z) {
	return _in(0x352a9f6b, 0xcf90081f, _v, _fv(x), _fv(y), _fv(z), _r);
};

/**
 * Get the closest vehicle node to a given position, unknown1 = 3.0, unknown2 = 0
 */
window.GetClosestMajorVehicleNode = function (x, y, z, unknown1, unknown2) {
	return _in(0x2eabe3b0, 0x6f58c1be, _fv(x), _fv(y), _fv(z), _v, _fv(unknown1), unknown2, _r);
};

/**
 * Has 8 params in the latest patches.
 * isMission - if true doesn't return mission objects
 */
window.GetClosestObjectOfType = function (x, y, z, radius, modelHash, isMission, p6, p7) {
	return _in(0xe143fa22, 0x49364369, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(modelHash), isMission, p6, p7, _r, _ri);
};

/**
 * Gets the closest ped in a radius.
 * Ped Types:
 * Any ped = -1
 * Player = 1
 * Male = 4
 * Female = 5
 * Cop = 6
 * Human = 26
 * SWAT = 27
 * Animal = 28
 * Army = 29
 * ------------------
 * P4 P5 P7 P8
 * 1  0  x  x  = return nearest walking Ped
 * 1  x  0  x  = return nearest walking Ped
 * x  1  1  x  = return Ped you are using
 * 0  0  x  x  = no effect
 * 0  x  0  x  = no effect
 * x = can be 1 or 0. Does not have any obvious changes.
 * This function does not return ped who is:
 * 1. Standing still
 * 2. Driving
 * 3. Fleeing
 * 4. Attacking
 * This function only work if the ped is:
 * 1. walking normally.
 * 2. waiting to cross a road.
 * Note: PED::GET_PED_NEARBY_PEDS works for more peds.
 */
window.GetClosestPed = function (x, y, z, radius, p4, p5, p7, p8, pedType) {
	return _in(0xc33ab876, 0xa77f8164, _fv(x), _fv(y), _fv(z), _fv(radius), p4, p5, _i, p7, p8, pedType, _r);
};

/**
 * p1 seems to be always 1.0f in the scripts
 */
window.GetClosestRoad = function (x, y, z, p3, p4, p10) {
	return _in(0x132f52bb, 0xa570fe92, _fv(x), _fv(y), _fv(z), _fv(p3), p4, _v, _v, _i, _i, _f, p10, _r, _ri);
};

/**
 * Example usage
 * VEHICLE::GET_CLOSEST_VEHICLE(x, y, z, radius, hash, unknown leave at 70)
 * x, y, z: Position to get closest vehicle to.
 * radius: Max radius to get a vehicle.
 * modelHash: Limit to vehicles with this model. 0 for any.
 * flags: The bitwise flags altering the function's behaviour.
 * Does not return police cars or helicopters.
 * It seems to return police cars for me, does not seem to return helicopters, planes or boats for some reason
 * Only returns non police cars and motorbikes with the flag set to 70 and modelHash to 0. ModelHash seems to always be 0 when not a modelHash in the scripts, as stated above.
 * These flags were found in the b617d scripts: 0,2,4,6,7,23,127,260,2146,2175,12294,16384,16386,20503,32768,67590,67711,98309,100359.
 * Converted to binary, each bit probably represents a flag as explained regarding another native here: gtaforums.com/topic/822314-guide-driving-styles
 * Conversion of found flags to binary: pastebin.com/kghNFkRi
 * At exactly 16384 which is 0100000000000000 in binary and 4000 in hexadecimal only planes are returned.
 * It's probably more convenient to use worldGetAllVehicles(int *arr, int arrSize) and check the shortest distance yourself and sort if you want by checking the vehicle type with for example VEHICLE::IS_THIS_MODEL_A_BOAT
 * -------------------------------------------------------------------------
 * Conclusion: This native is not worth trying to use. Use something like this instead: pastebin.com/xiFdXa7h
 */
window.GetClosestVehicle = function (x, y, z, radius, modelHash, flags) {
	return _in(0xf73eb622, 0xc4f1689b, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(modelHash), flags, _r, _ri);
};

/**
 * FYI: When falling through the map (or however you got under it) you will respawn when your player ped's height is <= -200.0 meters (I think you all know this) and when in a vehicle you will actually respawn at the closest vehicle node.
 * ----------
 * Vector3 nodePos;
 * GET_CLOSEST_VEHICLE_NODE(x,y,z,&nodePos,...)
 * p4 is either 0, 1 or 8. 1 means any path/road. 0 means node in the middle of the closest main (asphalt) road.
 * p5, p6 are always the same:
 * 0x40400000 (3.0), 0
 * p5 can also be 100.0 and p6 can be 2.5:
 * PATHFIND::GET_CLOSEST_VEHICLE_NODE(a_0, &v_5, v_9, 100.0, 2.5)
 * Known node types: simple path/asphalt road, only asphalt road, water, under the map at always the same coords.
 * The node types follows a pattern. For example, every fourth node is of the type water i.e. 3, 7, 11, 15, 19, 23, 27, 31, 35, 39... 239. Could not see any difference between nodes within certain types.
 * Starting at 2, every fourth node is under the map, always same coords.
 * Same with only asphalt road (0, 4, 8, etc) and simple path/asphalt road (1, 5, 9, etc).
 * gtaforums.com/topic/843561-pathfind-node-types
 */
window.GetClosestVehicleNode = function (x, y, z, nodeType, p5, p6) {
	return _in(0x240a1869, 0x0ae96513, _fv(x), _fv(y), _fv(z), _v, nodeType, _fv(p5), _fv(p6), _r);
};

/**
 * p5, p6 and p7 seems to be about the same as p4, p5 and p6 for GET_CLOSEST_VEHICLE_NODE. p6 and/or p7 has something to do with finding a node on the same path/road and same direction(at least for this native, something to do with the heading maybe). Edit this when you find out more.
 * p5 is either 1 or 12. 1 means any path/road. 12, 8, 0 means node in the middle of the closest main (asphalt) road.
 * p6 is always 3.0
 * p7 is always 0.
 * Known node types: simple path/asphalt road, only asphalt road, water, under the map at always the same coords.
 * The node types follows a pattern. For example, every fourth node is of the type water i.e. 3, 7, 11, 15, 19, 23, 27, 31, 35, 39... 239. Could not see any difference between nodes within certain types.
 * Starting at 2, every fourth node is under the map, always same coords.
 * Same with only asphalt road (0, 4, 8, etc) and simple path/asphalt road (1, 5, 9, etc).
 * gtaforums.com/topic/843561-pathfind-node-types
 * Example of usage, moving vehicle to closest path/road:
 * Vector3 coords = ENTITY::GET_ENTITY_COORDS(playerVeh, true);
 * Vector3 closestVehicleNodeCoords;
 * float roadHeading;
 * PATHFIND::GET_CLOSEST_VEHICLE_NODE_WITH_HEADING(coords.x, coords.y, coords.z, &closestVehicleNodeCoords, &roadHeading, 1, 3, 0);
 * ENTITY::SET_ENTITY_HEADING(playerVeh, roadHeading);
 * ENTITY::SET_ENTITY_COORDS(playerVeh, closestVehicleNodeCoords.x, closestVehicleNodeCoords.y, closestVehicleNodeCoords.z, 1, 0, 0, 1);
 * VEHICLE::SET_VEHICLE_ON_GROUND_PROPERLY(playerVeh);
 * ------------------------------------------------------------------
 * C# Example (ins1de) : pastebin.com/fxtMWAHD
 */
window.GetClosestVehicleNodeWithHeading = function (x, y, z, nodeType, p6, p7) {
	return _in(0xff071fb7, 0x98b803b0, _fv(x), _fv(y), _fv(z), _v, _f, nodeType, _fv(p6), p7, _r);
};

window.GetCloudHatOpacity = function () {
	return _in(0x20ac25e7, 0x81ae4a84, _r, _rf);
};
window.N_0x20ac25e781ae4a84 = window.GetCloudHatOpacity;

/**
 * Returns POSIX timestamp.
 * Renamed from `_GET_POSIX_TIME` to `GET_CLOUD_TIME_AS_INT` because of conflicting native names ([`0xDA488F299A5B164E`](#_0xDA488F299A5B164E))
 * @return An int representing the cloud time.
 */
window.GetCloudTimeAsInt = function () {
	return _in(0x9a73240b, 0x49945c76, _r, _ri);
};
window.N_0x9a73240b49945c76 = window.GetCloudTimeAsInt;

window.GetCollisionNormalOfLastHitForEntity = function (entity) {
	return _in(0xe465d4ab, 0x7ca6ae72, entity, _r, _rv);
};

/**
 * p0: Ped Handle
 * p1: int i | 0 <= i <= 27
 * p1 probably refers to the attributes configured in combatbehavior.meta. There are 13. Example:
 * <BlindFireChance value="0.1"/>
 * <WeaponShootRateModifier value="1.0"/>
 * <TimeBetweenBurstsInCover value="1.25"/>
 * <BurstDurationInCover value="2.0"/>
 * <TimeBetweenPeeks value="10.0"/>
 * <WeaponAccuracy value="0.18"/>
 * <FightProficiency value="0.8"/>
 * <StrafeWhenMovingChance value="1.0"/>
 * <WalkWhenStrafingChance value="0.0"/>
 * <AttackWindowDistanceForCover value="55.0"/>
 * <TimeToInvalidateInjuredTarget value="9.0"/>
 * <TriggerChargeTime_Near value="4.0"/>
 * <TriggerChargeTime_Far value="10.0"/>
 * -------------Confirmed by editing combatbehavior.meta:
 * p1:
 * 0=BlindFireChance
 * 1=BurstDurationInCover
 * 3=TimeBetweenBurstsInCover
 * 4=TimeBetweenPeeks
 * 5=StrafeWhenMovingChance
 * 8=WalkWhenStrafingChance
 * 11=AttackWindowDistanceForCover
 * 12=TimeToInvalidateInjuredTarget
 * 16=OptimalCoverDistance
 */
window.GetCombatFloat = function (ped, p1) {
	return _in(0x52dff8a1, 0x0508090a, ped, p1, _r, _rf);
};

window.GetContentCategory = function (p0) {
	return _in(0xa7bab11e, 0x7c9c6c5a, p0, _r, _ri);
};
window.N_0xa7bab11e7c9c6c5a = window.GetContentCategory;

window.GetContentDescriptionHash = function (p0) {
	return _in(0x7cf04487, 0x87b23758, p0, _r, _ri);
};
window.N_0x7cf0448787b23758 = window.GetContentDescriptionHash;

window.GetContentFileVersion = function (p0, p1) {
	return _in(0x37025b27, 0xd9b658b1, p0, p1, _r, _ri);
};
window.N_0x37025b27d9b658b1 = window.GetContentFileVersion;

/**
 * Return the mission id of a job.
 */
window.GetContentId = function (p0) {
	return _in(0x55aa95f4, 0x81d694d2, p0, _r, _s);
};
window.N_0x55aa95f481d694d2 = window.GetContentId;

/**
 * formerly called _GET_CONTROL_ACTION_NAME incorrectly
 * p2 appears to always be true.
 * p2 is unused variable in function.
 * EG:
 * GET_CONTROL_INSTRUCTIONAL_BUTTON (2, 201, 1)  -- [[INPUT_FRONTEND_ACCEPT (e.g. Enter button)]] 
 * GET_CONTROL_INSTRUCTIONAL_BUTTON (2, 202, 1)  -- [[INPUT_FRONTEND_CANCEL (e.g. ESC button)]] 
 * GET_CONTROL_INSTRUCTIONAL_BUTTON (2, 51, 1)  -- [[INPUT_CONTEXT (e.g. E button)]] 
 * gtaforums.com/topic/819070-c-draw-instructional-buttons-scaleform-movie/#entry1068197378
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.GetControlInstructionalButton = function (inputGroup, control, p2) {
	return _in(0x0499d7b0, 0x9fc9b407, inputGroup, control, p2, _r, _s);
};
window.N_0x0499d7b09fc9b407 = window.GetControlInstructionalButton;

/**
 * Returns the value of CONTROLS::GET_CONTROL_VALUE Normalized (ie a real number value between -1 and 1)
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.GetControlNormal = function (inputGroup, control) {
	return _in(0xec3c9b8d, 0x5327b563, inputGroup, control, _r, _rf);
};

/**
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.GetControlValue = function (inputGroup, control) {
	return _in(0xd95e79e8, 0x686d2c27, inputGroup, control, _r, _ri);
};

window.GetConvar = function (varName, default_) {
	return _in(0x00000000, 0x6ccd2564, _ts(varName), _ts(default_), _r, _s);
};

window.GetConvarInt = function (varName, default_) {
	return _in(0x00000000, 0x935c0ab2, _ts(varName), default_, _r, _ri);
};

/**
 * 0 -> up
 * 1 -> lowering down
 * 2 -> down
 * 3 -> raising up
 * enum RoofState
 * {
 * ROOFSTATE_UP = 0;
 * ROOFSTATE_LOWERING,
 * ROOFSTATE_DOWN,
 * ROOFSTATE_RAISING
 * };
 */
window.GetConvertibleRoofState = function (vehicle) {
	return _in(0xf8c39792, 0x2fc03f41, vehicle, _r, _ri);
};

/**
 * if (UI::_2309595AD6145265() == ${fe_menu_version_empty_no_background})
 * Seems to get the current frontend menu
 */
window.GetCurrentFrontendMenu = function () {
	return _in(0x2309595a, 0xd6145265, _r, _ri);
};
window.N_0x2309595ad6145265 = window.GetCurrentFrontendMenu;

/**
 * Gets the aggressiveness factor of the ocean waves.
 */
window.GetCurrentIntensity = function () {
	return _in(0x2b2a2cc8, 0x6778b619, _r, _rf);
};
window.N_0x2b2a2cc86778b619 = window.GetCurrentIntensity;
window.GetWavesIntensity = window.GetCurrentIntensity;

/**
 * american = 0
 * french = 1
 * german = 2
 * italian =3
 * spanish = 4
 * portuguese = 5
 * polish = 6
 * russian = 7
 * korean = 8
 * chinese = 9
 * japanese = 10
 * mexican = 11
 */
window.GetCurrentLanguageId = function () {
	return _in(0x2bdd44cc, 0x428a7eae, _r, _ri);
};
window.GetUiLanguageId = window.GetCurrentLanguageId;

/**
 * Returns the handle for the notification currently displayed on the screen.
 */
window.GetCurrentNotification = function () {
	return _in(0x82352748, 0x437638ca, _r, _ri);
};
window.N_0x82352748437638ca = window.GetCurrentNotification;

/**
 * Example in VB
 * Public Shared Function GetVehicleCurrentWeapon(Ped As Ped) As Integer
 * Dim arg As New OutputArgument()
 * Native.Function.Call(Hash.GET_CURRENT_PED_VEHICLE_WEAPON, Ped, arg)
 * Return arg.GetResult(Of Integer)()
 * End Function
 * Usage:
 * If GetVehicleCurrentWeapon(Game.Player.Character) = -821520672 Then ...Do something
 * Note: -821520672 = VEHICLE_WEAPON_PLANE_ROCKET
 */
window.GetCurrentPedVehicleWeapon = function (ped, weaponHash) {
	return _in(0x1017582b, 0xcd3832dc, ped, _ii(weaponHash) /* may be optional */, _r);
};

/**
 * The return value seems to indicate returns true if the hash of the weapon object weapon equals the weapon hash.
 * p2 seems to be 1 most of the time.
 * p2 is not implemented
 * disassembly said that?
 * ------
 * yes on disassembly p2 it seems not implemented i just have:
 * bool __fastcall sub_7FF6C56CE684(__int64 a1, _DWORD *a2)
 * Found At: 7ff6c56ce684
 */
window.GetCurrentPedWeapon = function (ped, p2) {
	return _in(0x3a87e44b, 0xb9a01d54, ped, _i, p2, _r);
};

window.GetCurrentPedWeaponEntityIndex = function (ped) {
	return _in(0x3b390a93, 0x9af0b5fc, ped, _r, _ri);
};

window.GetCurrentPlaybackForVehicle = function (p0) {
	return _in(0x42bc05c2, 0x7a946054, p0, _r, _ri);
};

/**
 * Returns the name of the currently executing resource.
 * @return The name of the resource.
 */
window.GetCurrentResourceName = function () {
	return _in(0x00000000, 0xe5e9ebbb, _r, _s);
};

window.GetCurrentScriptedConversationLine = function () {
	return _in(0x480357ee, 0x890c295a, _r, _ri);
};

/**
 * Returns the peer address of the remote game server that the user is currently connected to.
 * @return The peer address of the game server (e.g. `127.0.0.1:30120`), or NULL if not available.
 */
window.GetCurrentServerEndpoint = function () {
	return _in(0x00000000, 0xea11bfba, _r, _s);
};

window.GetCurrentWebsiteId = function () {
	return _in(0x97d47996, 0xfc48cbad, _r, _ri);
};

window.GetCutsceneSectionPlaying = function () {
	return _in(0x49010a6a, 0x396553d8, _r, _ri);
};

window.GetCutsceneTime = function () {
	return _in(0xe625beab, 0xbaffdab9, _r, _ri);
};

window.GetCutsceneTotalDuration = function () {
	return _in(0xee53b14a, 0x19e480d4, _r, _ri);
};

/**
 * Takes the specified time and writes it to the structure specified in the second argument.
 * struct date_time
 * {
 * alignas(8) int year;
 * alignas(8) int month;
 * alignas(8) int day;
 * alignas(8) int hour;
 * alignas(8) int minute;
 * alignas(8) int second;
 * };
 */
window.GetDateAndTimeFromUnixEpoch = function (unixEpoch, timeStructure) {
	return _in(0xac97af97, 0xfa68e5d5, unixEpoch, _ii(timeStructure) /* may be optional */);
};

window.GetDeadPedPickupCoords = function (ped, p1, p2) {
	return _in(0xcd5003b0, 0x97200f36, ped, _fv(p1), _fv(p2), _r, _rv);
};

window.GetDecalWashLevel = function (decal) {
	return _in(0x323f6476, 0x79a09103, decal, _r, _rf);
};

/**
 * This function is hard-coded to always return 1.
 */
window.GetDefaultScriptRendertargetRenderId = function () {
	return _in(0x52f0982d, 0x7fd156b6, _r, _ri);
};

/**
 * Gets a destructible object's handle
 * Example:
 * OBJECT::_B48FCED898292E52(-809.9619750976562, 170.919, 75.7406997680664, 3.0, "des_tvsmash");
 * All found arguments for p4 starts with "des_" like "DES_FIB_Floor" and "des_shipsink".
 */
window.GetDesObject = function (x, y, z, rotation, name) {
	return _in(0xb48fced8, 0x98292e52, _fv(x), _fv(y), _fv(z), _fv(rotation), _ts(name), _r, _ri);
};
window.N_0xb48fced898292e52 = window.GetDesObject;

window.GetDesObjectAnimProgress = function (desObjectHandle) {
	return _in(0x260ee4fd, 0xbdf4db01, desObjectHandle, _r, _rf);
};
window.N_0x260ee4fdbdf4db01 = window.GetDesObjectAnimProgress;

/**
 * Get a destrictible object's state.
 * Substract 1 to get the real state.
 * See _SET_DES_OBJECT_STATE to see the different states
 * For example, if the object just spawned (state 2), the native will return 3.
 */
window.GetDesObjectState = function (handle) {
	return _in(0x899ba936, 0x634a322e, handle, _r, _ri);
};
window.N_0x899ba936634a322e = window.GetDesObjectState;

/**
 * control - c# works with (int)GTA.Control.CursorY / (int)GTA.Control.CursorX and returns the mouse movement (additive).
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.GetDisabledControlNormal = function (inputGroup, control) {
	return _in(0x11e65974, 0xa982637c, inputGroup, control, _r, _rf);
};

/**
 * Returns model name of vehicle in all caps. Needs to be displayed through localizing text natives to get proper display name.
 * -----------------------------------------------------------------------------------------------------------------------------------------
 * While often the case, this does not simply return the model name of the vehicle (which could be hashed to return the model hash). Variations of the same vehicle may also use the same display name.
 * -----------------------------------------------------------------------------------------------------------------------------------------
 * Returns "CARNOTFOUND" if the hash doesn't match a vehicle hash.
 * Using UI::_GET_LABEL_TEXT, you can get the localized name.
 * For a full list, see here: pastebin.com/wvpyS4kS (pastebin.com/dA3TbkZw)
 */
window.GetDisplayNameFromVehicleModel = function (modelHash) {
	return _in(0xb215aac3, 0x2d25d019, _ch(modelHash), _r, _s);
};

/**
 * Returns the distance between two three-dimensional points, optionally ignoring the Z values.
 * You'll most likely want to use your language's native vector functionality instead.
 * @param x1 The X coordinate of the first point.
 * @param y1 The Y coordinate of the first point.
 * @param z1 The Z coordinate of the first point.
 * @param x2 The X coordinate of the second point.
 * @param y2 The Y coordinate of the second point.
 * @param z2 The Z coordinate of the second point.
 * @param useZ Whether or not to use the Z coordinate.
 * @return The distance between the passed points in units.
 */
window.GetDistanceBetweenCoords = function (x1, y1, z1, x2, y2, z2, useZ) {
	return _in(0xf1b76088, 0x1820c952, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), useZ, _r, _rf);
};

/**
 * dlcVehicleIndex takes a number from 0 - GET_NUM_DLC_VEHICLES() - 1.
 * outData is a struct of 3 8-byte items.
 * The Second item in the struct *(Hash *)(outData + 1) is the vehicle hash.
 */
window.GetDlcVehicleData = function (dlcVehicleIndex, outData) {
	return _in(0x33468edc, 0x08e371f6, dlcVehicleIndex, _ii(outData) /* may be optional */, _r);
};

window.GetDlcVehicleFlags = function (dlcVehicleIndex) {
	return _in(0x5549ee11, 0xfa22fcf2, dlcVehicleIndex, _r, _ri);
};

/**
 * dlcVehicleIndex is 0 to GET_NUM_DLC_VEHICLS()
 */
window.GetDlcVehicleModel = function (dlcVehicleIndex) {
	return _in(0xecc01b7c, 0x5763333c, dlcVehicleIndex, _r, _ri);
};

/**
 * p0 seems to be the weapon index
 * p1 seems to be the weapon component index
 * struct DlcComponentData{
 * int attachBone;
 * int padding1;
 * int bActiveByDefault;
 * int padding2;
 * int unk;
 * int padding3;
 * int componentHash;
 * int padding4;
 * int unk2;
 * int padding5;
 * int componentCost;
 * int padding6;
 * char nameLabel[64];
 * char descLabel[64];
 * };
 */
window.GetDlcWeaponComponentData = function (dlcWeaponIndex, dlcWeapCompIndex, ComponentDataPtr) {
	return _in(0x6cf598a2, 0x957c2bf8, dlcWeaponIndex, dlcWeapCompIndex, _ii(ComponentDataPtr) /* may be optional */, _r);
};

/**
 * dlcWeaponIndex takes a number from 0 - GET_NUM_DLC_WEAPONS() - 1.
 * struct DlcWeaponData
 * {
 * int emptyCheck; //use DLC1::_IS_DLC_DATA_EMPTY on this
 * int padding1;
 * int weaponHash;
 * int padding2;
 * int unk;
 * int padding3;
 * int weaponCost;
 * int padding4;
 * int ammoCost;
 * int padding5;
 * int ammoType;
 * int padding6;
 * int defaultClipSize;
 * int padding7;
 * char nameLabel[64];
 * char descLabel[64];
 * char desc2Label[64]; // usually "the" + name
 * char upperCaseNameLabel[64];
 * };
 */
window.GetDlcWeaponData = function (dlcWeaponIndex, outData) {
	return _in(0x79923cd2, 0x1bece14e, dlcWeaponIndex, _ii(outData) /* may be optional */, _r);
};

/**
 * Returns the NUI window handle for a specified DUI browser object.
 * @param duiObject The DUI browser handle.
 * @return The NUI window handle, for use in e.g. CREATE_RUNTIME_TEXTURE_FROM_DUI_HANDLE.
 */
window.GetDuiHandle = function (duiObject) {
	return _in(0x00000000, 0x1655d41d, duiObject, _r, _s);
};

window.GetEntityAlpha = function (entity) {
	return _in(0x5a47b3b5, 0xe63e94c6, entity, _r, _ri);
};

/**
 * Returns a float value representing animation's current playtime with respect to its total playtime. This value increasing in a range from [0 to 1] and wrap back to 0 when it reach 1.
 * Example:
 * 0.000000 - mark the starting of animation.
 * 0.500000 - mark the midpoint of the animation.
 * 1.000000 - mark the end of animation.
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.GetEntityAnimCurrentTime = function (entity, animDict, animName) {
	return _in(0x346d8150, 0x0d088f42, entity, _ts(animDict), _ts(animName), _r, _rf);
};

/**
 * Returns a float value representing animation's total playtime in milliseconds.
 * Example:
 * GET_ENTITY_ANIM_TOTAL_TIME(PLAYER_ID(),"amb@world_human_yoga@female@base","base_b")
 * return 20800.000000
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.GetEntityAnimTotalTime = function (entity, animDict, animName) {
	return _in(0x50bd2730, 0xb191e360, entity, _ts(animDict), _ts(animName), _r, _rf);
};

window.GetEntityAttachedTo = function (entity) {
	return _in(0x48c2bed9, 0x180fe123, entity, _r, _ri);
};

window.GetEntityAttachedToTowTruck = function (towTruck) {
	return _in(0xefea18dc, 0xf10f8f75, towTruck, _r, _ri);
};

/**
 * Returns the index of the bone. If the bone was not found, -1 will be returned.
 * list:
 * pastebin.com/D7JMnX1g
 * BoneNames:
 * chassis,
 * windscreen,
 * seat_pside_r,
 * seat_dside_r,
 * bodyshell,
 * suspension_lm,
 * suspension_lr,
 * platelight,
 * attach_female,
 * attach_male,
 * bonnet,
 * boot,
 * chassis_dummy,	//Center of the dummy
 * chassis_Control,	//Not found yet
 * door_dside_f,	//Door left, front
 * door_dside_r,	//Door left, back
 * door_pside_f,	//Door right, front
 * door_pside_r,	//Door right, back
 * Gun_GripR,
 * windscreen_f,
 * platelight,	//Position where the light above the numberplate is located
 * VFX_Emitter,
 * window_lf,	//Window left, front
 * window_lr,	//Window left, back
 * window_rf,	//Window right, front
 * window_rr,	//Window right, back
 * engine,	//Position of the engine
 * gun_ammo,
 * ROPE_ATTATCH,	//Not misspelled. In script "finale_heist2b.c4".
 * wheel_lf,	//Wheel left, front
 * wheel_lr,	//Wheel left, back
 * wheel_rf,	//Wheel right, front
 * wheel_rr,	//Wheel right, back
 * exhaust,	//Exhaust. shows only the position of the stock-exhaust
 * overheat,	//A position on the engine(not exactly sure, how to name it)
 * misc_e,	//Not a car-bone.
 * seat_dside_f,	//Driver-seat
 * seat_pside_f,	//Seat next to driver
 * Gun_Nuzzle,
 * seat_r
 * I doubt that the function is case-sensitive, since I found a "Chassis" and a "chassis". - Just tested: Definitely not case-sensitive.
 */
window.GetEntityBoneIndexByName = function (entity, boneName) {
	return _in(0xfb71170b, 0x7e76acba, entity, _ts(boneName), _r, _ri);
};

/**
 * console hash: 0xE8C0C629
 */
window.GetEntityCollisonDisabled = function (entity) {
	return _in(0xccf1e97b, 0xefdae480, entity, _r);
};
window.N_0xccf1e97befdae480 = window.GetEntityCollisonDisabled;

/**
 * Gets the current coordinates for a specified entity.
 * @param entity The entity to get the coordinates from.
 * @param alive Unused by the game, potentially used by debug builds of GTA in order to assert whether or not an entity was alive.
 * @return The current entity coordinates.
 */
window.GetEntityCoords = function (entity, alive) {
	return _in(0x3fef770d, 0x40960d5a, entity, alive, _r, _rv);
};

/**
 * Gets the entity's forward vector.
 */
window.GetEntityForwardVector = function (entity) {
	return _in(0x0a794a5a, 0x57f8df91, entity, _r, _rv);
};

/**
 * Gets the X-component of the entity's forward vector.
 */
window.GetEntityForwardX = function (entity) {
	return _in(0x8bb4ef42, 0x14e0e6d5, entity, _r, _rf);
};

/**
 * Gets the Y-component of the entity's forward vector.
 */
window.GetEntityForwardY = function (entity) {
	return _in(0x866a4a5f, 0xae349510, entity, _r, _rf);
};

/**
 * Returns the heading of the entity in degrees. Also know as the "Yaw" of an entity.
 */
window.GetEntityHeading = function (entity) {
	return _in(0xe83d4f9b, 0xa2a38914, entity, _r, _rf);
};

/**
 * Returns an integer value of entity's current health.
 * Example of range for ped:
 * - Player [0 to 200]
 * - Ped [100 to 200]
 * - Vehicle [0 to 1000]
 * - Object [0 to 1000]
 * Health is actually a float value but this native casts it to int.
 * In order to get the actual value, do:
 * float health = *(float *)(entityAddress + 0x280);
 */
window.GetEntityHealth = function (entity) {
	return _in(0xeef059fa, 0xd016d209, entity, _r, _ri);
};

window.GetEntityHeight = function (entity, X, Y, Z, atTop, inWorldCoords) {
	return _in(0x5a504562, 0x485944dd, entity, _fv(X), _fv(Y), _fv(Z), atTop, inWorldCoords, _r, _rf);
};

/**
 * Return height (z-dimension) above ground.
 * Example: The pilot in a titan plane is 1.844176 above ground.
 * How can i convert it to meters?
 * Everything seems to be in meters, probably this too.
 */
window.GetEntityHeightAboveGround = function (entity) {
	return _in(0x1dd55701, 0x034110e5, entity, _r, _rf);
};

window.GetEntityIndexOfCutsceneEntity = function (cutsceneEntName, modelHash) {
	return _in(0x0a2e9fdb, 0x9a8c62f6, _ts(cutsceneEntName), _ch(modelHash), _r, _ri);
};

window.GetEntityIndexOfRegisteredEntity = function (cutsceneEntName, modelHash) {
	return _in(0xc0741a26, 0x499654cd, _ts(cutsceneEntName), _ch(modelHash), _r, _ri);
};

/**
 * Returns the LOD distance of an entity.
 */
window.GetEntityLodDist = function (entity) {
	return _in(0x4159c276, 0x2b5791d6, entity, _r, _ri);
};

window.GetEntityMatrix = function (entity) {
	return _in(0xecb2fc72, 0x35a7d137, entity, _v, _v, _v, _v);
};

/**
 * Return an integer value of entity's maximum health.
 * Example:
 * - Player = 200
 */
window.GetEntityMaxHealth = function (entity) {
	return _in(0x15d75760, 0x6d170c3c, entity, _r, _ri);
};

/**
 * Returns the model hash from the entity
 * Sometimes throws an exception, idk what causes it though.
 */
window.GetEntityModel = function (entity) {
	return _in(0x9f47b058, 0x362c84b5, entity, _r, _ri);
};

/**
 * Gets the heading of the entity physics in degrees, which tends to be more accurate than just "GET_ENTITY_HEADING". This can be clearly seen while, for example, ragdolling a ped/player.
 * NOTE: The name and description of this native are based on independent research. If you find this native to be more suitable under a different name and/or described differently, please feel free to do so.
 */
window.GetEntityPhysicsHeading = function (entity) {
	return _in(0x846bf629, 0x1198a71e, entity, _r, _rf);
};
window.N_0x846bf6291198a71e = window.GetEntityPhysicsHeading;

window.GetEntityPitch = function (entity) {
	return _in(0xd45dc289, 0x3621e1fe, entity, _r, _rf);
};

/**
 * Returns TRUE if it found an entity in your crosshair within range of your weapon. Assigns the handle of the target to the *entity that you pass it.
 * Returns false if no entity found.
 */
window.GetEntityPlayerIsFreeAimingAt = function (player, entity) {
	return _in(0x2975c866, 0xe6713290, player, _ii(entity) /* may be optional */, _r);
};

/**
 * Gets an entity's population type.
 * **Valid population types:**
 * ```cpp
 * enum ePopulationType
 * {
 * POPTYPE_UNKNOWN = 0,
 * POPTYPE_RANDOM_PERMANENT,
 * POPTYPE_RANDOM_PARKED,
 * POPTYPE_RANDOM_PATROL,
 * POPTYPE_RANDOM_SCENARIO,
 * POPTYPE_RANDOM_AMBIENT,
 * POPTYPE_PERMANENT,
 * POPTYPE_MISSION,
 * POPTYPE_REPLAY,
 * POPTYPE_CACHE,
 * POPTYPE_TOOL
 * };
 * ```
 * @param entity The entity to obtain the population type from.
 * @return A population type, from the enumeration above.
 */
window.GetEntityPopulationType = function (entity) {
	return _in(0xf6f5161f, 0x4534edff, entity, _r, _ri);
};

/**
 * w is the correct parameter name!
 */
window.GetEntityQuaternion = function (entity) {
	return _in(0x7b3703d2, 0xd32dfa18, entity, _f, _f, _f, _f);
};

/**
 * Displays the current ROLL axis of the entity [-180.0000/180.0000+]
 * (Sideways Roll) such as a vehicle tipped on its side
 */
window.GetEntityRoll = function (entity) {
	return _in(0x831e0242, 0x595560df, entity, _r, _rf);
};

/**
 * rotationOrder refers to the order yaw pitch roll is applied
 * value ranges from 0 to 5. What you use for rotationOrder when getting must be the same as rotationOrder when setting the rotation.
 * Unsure what value corresponds to what rotation order, more testing will be needed for that.
 * ------
 * rotationOrder is usually 2 in scripts
 * ------
 * ENTITY::GET_ENTITY_ROTATION(Any p0, false or true);
 * if false than return from -180 to 180
 * if true than return from -90 to 90
 * ---
 * As said above, the value of p1 affects the outcome. R* uses 1 and 2 instead of 0 and 1, so I marked it as an int.
 * What it returns is the yaw on the z part of the vector, which makes sense considering R* considers z as vertical. Here's a picture for those of you who don't understand pitch, yaw, and roll:
 * www.allstar.fiu.edu/aero/images/pic5-1.gif
 * I don't know why it returns a Vec3, but sometimes the values x and y go negative, yet they're always zero. Just use GET_ENTITY_PITCH and GET_ENTITY_ROLL for pitch and roll.
 */
window.GetEntityRotation = function (entity, rotationOrder) {
	return _in(0xafbd61cc, 0x738d9eb9, entity, rotationOrder, _r, _rv);
};

/**
 * ANGULAR_VELOCITY*
 */
window.GetEntityRotationVelocity = function (entity) {
	return _in(0x213b9104, 0x5d09b983, entity, _r, _rv);
};

/**
 * All ambient entities in-world seem to have the same value for the second argument (Any *script), depending on when the scripthook was activated/re-activated. I've seen numbers from ~5 to almost 70 when the value was translated with to_string. The function return value seems to always be 0.
 */
window.GetEntityScript = function (entity, script) {
	return _in(0xa6e9c38d, 0xb51d7748, entity, _ii(script) /* may be optional */, _r, _s);
};

/**
 * result is in meters per second
 * ------------------------------------------------------------
 * So would the conversion to mph and km/h, be along the lines of this.
 * float speed = GET_ENTITY_SPEED(veh);
 * float kmh = (speed * 3.6);
 * float mph = (speed * 2.236936);
 */
window.GetEntitySpeed = function (entity) {
	return _in(0xd5037ba8, 0x2e12416f, entity, _r, _rf);
};

/**
 * Relative can be used for getting speed relative to the frame of the vehicle, to determine for example, if you are going in reverse (-y speed) or not (+y speed).
 */
window.GetEntitySpeedVector = function (entity, relative) {
	return _in(0x9a8d700a, 0x51cb7b0d, entity, relative, _r, _rv);
};

/**
 * Get how much of the entity is submerged.  1.0f is whole entity.
 */
window.GetEntitySubmergedLevel = function (entity) {
	return _in(0xe81afc1b, 0xc4cc41ce, entity, _r, _rf);
};

/**
 * Returns:
 * 0 = no entity
 * 1 = ped
 * 2 = vehicle
 * 3 = object
 * This is weird, because in memory atleast on xbox360 it stores it from testing with a variety of (ped, vehicle, and objects).
 * 03
 * 04
 * 05
 * The above is more then likely true for the native's return, but if you were to skip using the native it's a bit weird it returns different results.
 */
window.GetEntityType = function (entity) {
	return _in(0x8acd3660, 0x38d14505, entity, _r, _ri);
};

window.GetEntityUprightValue = function (entity) {
	return _in(0x95eed5a6, 0x94951f9f, entity, _r, _rf);
};

/**
 * the unit is m/s along each axis
 * GET_ENTITY_VELOCITY(aEntity) is the same as GET_ENTITY_SPEED_VECTOR(aEntity,false)
 */
window.GetEntityVelocity = function (entity) {
	return _in(0x4805d2b1, 0xd8cf94a9, entity, _r, _rv);
};

window.GetEntryPositionOfDoor = function (vehicle, doorIndex) {
	return _in(0xc0572928, 0xc0abfda3, vehicle, doorIndex, _r, _rv);
};

/**
 * eventGroup: 0 = CEventGroupScriptAI, 1 = CEventGroupScriptNetwork
 */
window.GetEventAtIndex = function (eventGroup, eventIndex) {
	return _in(0xd8f66a3a, 0x60c62153, eventGroup, eventIndex, _r, _ri);
};

/**
 * eventGroup: 0 = CEventGroupScriptAI, 1 = CEventGroupScriptNetwork
 */
window.GetEventData = function (eventGroup, eventIndex, argStructSize) {
	return _in(0x2902843f, 0xcd2b2d79, eventGroup, eventIndex, _i, argStructSize, _r);
};

/**
 * eventGroup: 0 = CEventGroupScriptAI, 1 = CEventGroupScriptNetwork
 */
window.GetEventExists = function (eventGroup, eventIndex) {
	return _in(0x936e6168, 0xa9bcedb5, eventGroup, eventIndex, _r);
};

/**
 * See [`GetTimecycleModifierIndex`](#_0xFDF3D97C674AFB66) for use, works the same just for the secondary timecycle modifier.
 * @return An integer representing the Timecycle modifier
 */
window.GetExtraTimecycleModifierIndex = function () {
	return _in(0xbb0527ec, 0x6341496d, _r, _ri);
};

window.GetFakeWantedLevel = function () {
	return _in(0x4c9296cb, 0xcd1b971e, _r, _ri);
};
window.N_0x4c9296cbcd1b971e = window.GetFakeWantedLevel;

/**
 * 8 = waypoint
 */
window.GetFirstBlipInfoId = function (blipSprite) {
	return _in(0x1bede233, 0xe6cd2a1f, blipSprite, _r, _ri);
};

/**
 * Type equals 0 for male non-dlc, 1 for female non-dlc, 2 for male dlc, and 3 for female dlc.
 * Used when calling SET_PED_HEAD_BLEND_DATA.
 */
window.GetFirstParentIdForPedType = function (type) {
	return _in(0x68d353ab, 0x88b97e0c, type, _r, _ri);
};

/**
 * Returns
 * 0 - Third Person Close
 * 1 - Third Person Mid
 * 2 - Third Person Far
 * 4 - First Person
 */
window.GetFollowPedCamViewMode = function () {
	return _in(0x8d4d4623, 0x0b2c353a, _r, _ri);
};

window.GetFollowPedCamZoomLevel = function () {
	return _in(0x33e6c8ef, 0xd0cd93e9, _r, _ri);
};

/**
 * Returns the type of camera:
 * 0 - Third Person Close
 * 1 - Third Person Mid
 * 2 - Third Person Far
 * 4 - First Person
 */
window.GetFollowVehicleCamViewMode = function () {
	return _in(0xa4ff579a, 0xc0e3aaae, _r, _ri);
};

window.GetFollowVehicleCamZoomLevel = function () {
	return _in(0xee82280a, 0xb767b690, _r, _ri);
};

window.GetForcedComponent = function (componentHash, componentId) {
	return _in(0x6c93ed8c, 0x2f74859b, _ch(componentHash), componentId, _i, _i, _i);
};

window.GetFrameCount = function () {
	return _in(0xfc8202ef, 0xc642e6f2, _r, _ri);
};

window.GetFrameTime = function () {
	return _in(0x15c40837, 0x039ffaf7, _r, _rf);
};

window.GetFreeStackSlotsCount = function (threadId) {
	return _in(0xfead16fc, 0x8f9dfc0f, threadId, _r, _ri);
};

window.GetGameTimer = function () {
	return _in(0x9cd27b00, 0x45628463, _r, _ri);
};

window.GetGameplayCamCoord = function () {
	return _in(0x14d6f567, 0x8d8f1b37, _r, _rv);
};

window.GetGameplayCamCoords = function () {
	return _in(0xa200eb1e, 0xe790f448, _r, _rv);
};

/**
 * Gets the gameplay camera's far clipping plane.
 */
window.GetGameplayCamFarClip = function () {
	return _in(0xdfc8cbc6, 0x06fdb0fc, _r, _rf);
};
window.N_0xdfc8cbc606fdb0fc = window.GetGameplayCamFarClip;

/**
 * Gets the gameplay camera's far depth of field distance.
 */
window.GetGameplayCamFarDof = function () {
	return _in(0x9780f32b, 0xcaf72431, _r, _rf);
};
window.N_0x9780f32bcaf72431 = window.GetGameplayCamFarDof;

window.GetGameplayCamFov = function () {
	return _in(0x65019750, 0xa0324133, _r, _rf);
};

/**
 * Gets the gameplay camera's near depth of field distance.
 */
window.GetGameplayCamNearDof = function () {
	return _in(0xa03502fc, 0x581f7d9b, _r, _rf);
};
window.N_0xa03502fc581f7d9b = window.GetGameplayCamNearDof;

window.GetGameplayCamRelativeHeading = function () {
	return _in(0x74360764, 0x8add4587, _r, _rf);
};

window.GetGameplayCamRelativePitch = function () {
	return _in(0x3a6867b4, 0x845beda2, _r, _rf);
};

/**
 * p0 dosen't seem to change much, I tried it with 0, 1, 2:
 * 0-Pitch(X): -70.000092
 * 0-Roll(Y): -0.000001
 * 0-Yaw(Z): -43.886459
 * 1-Pitch(X): -70.000092
 * 1-Roll(Y): -0.000001
 * 1-Yaw(Z): -43.886463
 * 2-Pitch(X): -70.000092
 * 2-Roll(Y): -0.000002
 * 2-Yaw(Z): -43.886467
 */
window.GetGameplayCamRot = function (rotationOrder) {
	return _in(0x837765a2, 0x5378f0bb, rotationOrder, _r, _rv);
};

/**
 * p0 seems to consistently be 2 across scripts
 * Function is called faily often by CAM::CREATE_CAM_WITH_PARAMS
 */
window.GetGameplayCamRot_2 = function (rotationOrder) {
	return _in(0x5b4e4c81, 0x7fcc2dfb, rotationOrder, _r, _rv);
};

window.GetGameplayCamZoom = function () {
	return _in(0x7ec52cc4, 0x0597d170, _r, _rf);
};

/**
 * it returns a reference to an empty string, the same empty string that's used by 1687 internal gta functions.   if it was used in a script (and i cannot find an instance of it being used), it would be as the source for a StringCopy or somesuch.
 */
window.GetGlobalCharBuffer = function () {
	return _in(0x24da7d76, 0x67fd7b09, _r, _s);
};
window.N_0x24da7d7667fd7b09 = window.GetGlobalCharBuffer;

/**
 * only documented to be continued...
 */
window.GetGroundZCoordWithOffsets = function (x, y, z) {
	return _in(0x8bdc7bfc, 0x57a81e76, _fv(x), _fv(y), _fv(z), _f, _v, _r);
};
window.N_0x8bdc7bfc57a81e76 = window.GetGroundZCoordWithOffsets;

/**
 * Gets the ground elevation at the specified position. Note that if the specified position is below ground level, the function will output zero!
 * x: Position on the X-axis to get ground elevation at.
 * y: Position on the Y-axis to get ground elevation at.
 * z: Position on the Z-axis to get ground elevation at.
 * groundZ: The ground elevation at the specified position.
 * unk: Nearly always 0, very rarely 1 in the scripts.
 */
window.GetGroundZFor_3dCoord = function (x, y, z, unk) {
	return _in(0xc906a7da, 0xb05c8d2b, _fv(x), _fv(y), _fv(z), _f, unk, _r);
};

/**
 * p1 may be a BOOL representing whether or not the group even exists
 */
window.GetGroupSize = function (groupID) {
	return _in(0x8de69fe3, 0x5ca09a45, groupID, _i, _i);
};

/**
 * Input: Haircolor index, value between 0 and 63 (inclusive).
 * Output: RGB values for the haircolor specified in the input.
 * This is used with the hair color swatches scaleform.
 * Use [`_0x013E5CFC38CD5387`](#_0x013E5CFC38CD5387) to get the makeup colors.
 * @param hairColorIndex The hair color index. Value between 0-63 (inclusive).
 * @param outR Output red value.
 * @param outG Output green value.
 * @param outB Output blue value.
 */
window.GetHairRgbColor = function (hairColorIndex) {
	return _in(0x4852fc38, 0x6e2e1bb5, hairColorIndex, _i, _i, _i);
};
window.N_0x4852fc386e2e1bb5 = window.GetHairRgbColor;

window.GetHasLowerableWheels = function (vehicle) {
	return _in(0xdca174a4, 0x2133f08c, vehicle, _r);
};

/**
 * Gets the (case-insensitive, lower-cased) hash value for the passed string. This uses the 'Jenkins one-at-a-time' hashing
 * algorithm.
 * @param string The string to hash.
 * @return The hash of `string`.
 */
window.GetHashKey = function (string) {
	return _in(0xd24d37cc, 0x275948cc, _ts(string), _r, _ri);
};

window.GetHashNameForComponent = function (entity, componentId, drawableVariant, textureVariant) {
	return _in(0x0368b3a8, 0x38070348, entity, componentId, drawableVariant, textureVariant, _r, _ri);
};

window.GetHashNameForProp = function (entity, componentId, propIndex, propTextureIndex) {
	return _in(0x5d616027, 0x5caec8dd, entity, componentId, propIndex, propTextureIndex, _r, _ri);
};

/**
 * Returns a hash representing which part of the map the given coords are located.
 * Possible return values:
 * (Hash of) city -> -289320599
 * (Hash of) countryside -> 2072609373
 * C# Example :
 * Ped player = Game.Player.Character;
 * Hash h = Function.Call<Hash>(Hash.GET_HASH_OF_MAP_AREA_AT_COORDS, player.Position.X, player.Position.Y, player.Position.Z);
 */
window.GetHashOfMapAreaAtCoords = function (x, y, z) {
	return _in(0x7ee64d51, 0xe8498728, _fv(x), _fv(y), _fv(z), _r, _ri);
};

window.GetHashOfThisScriptName = function () {
	return _in(0x8a1c8b17, 0x38ffe87e, _r, _ri);
};
window.GetThisScriptHash = window.GetHashOfThisScriptName;

/**
 * dx = x1
 * dy = y1
 */
window.GetHeadingFromVector_2d = function (dx, dy) {
	return _in(0x2ffb6b22, 0x4f4b2926, _fv(dx), _fv(dy), _r, _rf);
};

/**
 * Max 1000.
 * At -100 both helicopter rotors will stall.
 */
window.GetHeliEngineHealth = function (vehicle) {
	return _in(0xac51915d, 0x27e4a5f7, vehicle, _r, _rf);
};

/**
 * Max 1000.
 * At 0 the main rotor will stall.
 */
window.GetHeliMainRotorHealth = function (vehicle) {
	return _in(0xe4cb7541, 0xf413d2c5, vehicle, _r, _rf);
};

/**
 * Max 1000.
 * At 0 the tail rotor will stall.
 */
window.GetHeliTailRotorHealth = function (vehicle) {
	return _in(0xae8ce82a, 0x4219ac8c, vehicle, _r, _rf);
};

/**
 * HUD colors and their values: pastebin.com/d9aHPbXN
 */
window.GetHudColour = function (hudColorIndex) {
	return _in(0x7c9c91ab, 0x74a0360f, hudColorIndex, _i, _i, _i, _i);
};

window.GetHudComponentPosition = function (id) {
	return _in(0x223ca69a, 0x8c4417fd, id, _r, _rv);
};

/**
 * MulleDK19: Gets the ID of the next active thread.
 * First call _BEGIN_ENUMERATE_THREADS (0xDADFADA5A20143A8).
 * Any subsequent call to this function will then return the ID of the next active thread.
 * If the function returns 0, the end of the enumeration has been reached.
 * -----------------------------------------------------------------------
 * Here's an example:
 * std::vector<int> vecCurrentThreads;
 * void update_current_threads_list()
 * {
 * vecCurrentThreads.clear();
 * _BEGIN_ENUMERATING_THREADS();
 * int id = _GET_ID_OF_NEXT_THREAD_IN_ENUMERATION();
 * while (id != 0)
 * {
 * id = _GET_ID_OF_NEXT_THREAD_IN_ENUMERATION();
 * vecCurrentThreads.push_back(id);
 * }
 * }
 */
window.GetIdOfNextThreadInEnumeration = function () {
	return _in(0x30b4fa1c, 0x82dd4b9f, _r, _ri);
};
window.N_0x30b4fa1c82dd4b9f = window.GetIdOfNextThreadInEnumeration;

window.GetIdOfThisThread = function () {
	return _in(0xc30338e8, 0x088e2e21, _r, _ri);
};

/**
 * x1, y1, z1 -- Coords of your ped model
 * x2, y2, z2 -- Coords of the ped you want to switch to
 */
window.GetIdealPlayerSwitchType = function (x1, y1, z1, x2, y2, z2) {
	return _in(0xb5d7b26b, 0x45720e05, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _r, _ri);
};

window.GetIndexOfCurrentLevel = function () {
	return _in(0xcbad6729, 0xf7b1f4fc, _r, _ri);
};

window.GetIndexedItemInItemset = function (p0, p1) {
	return _in(0x7a197e25, 0x21ee2bab, p0, p1, _r, _ri);
};

window.GetInstanceId = function () {
	return _in(0x00000000, 0x9f1c4383, _r, _ri);
};

/**
 * Returns interior ID from specified coordinates. If coordinates are outside, then it returns 0.
 * Example for VB.NET
 * Dim interiorID As Integer = Native.Function.Call(Of Integer)(Hash.GET_INTERIOR_AT_COORDS, X, Y, Z)
 */
window.GetInteriorAtCoords = function (x, y, z) {
	return _in(0xb0f7f866, 0x3821d9c3, _fv(x), _fv(y), _fv(z), _r, _ri);
};

/**
 * Returns the interior ID representing the requested interior at that location (if found?). The supplied interior string is not the same as the one used to load the interior.
 * Use: INTERIOR::UNPIN_INTERIOR(INTERIOR::GET_INTERIOR_AT_COORDS_WITH_TYPE(x, y, z, interior))
 * Interior types include: "V_Michael", "V_Franklins", "V_Franklinshouse", etc.. you can find them in the scripts.
 * Not a very useful native as you could just use GET_INTERIOR_AT_COORDS instead and get the same result, without even having to specify the interior type.
 */
window.GetInteriorAtCoordsWithType = function (x, y, z, interiorType) {
	return _in(0x05b7a89b, 0xd78797fc, _fv(x), _fv(y), _fv(z), _ts(interiorType), _r, _ri);
};
window.N_0x05b7a89bd78797fc = window.GetInteriorAtCoordsWithType;

window.GetInteriorFromCollision = function (x, y, z) {
	return _in(0xec4cf9fc, 0xb29a4424, _fv(x), _fv(y), _fv(z), _r, _ri);
};

/**
 * Returns the handle of the interior that the entity is in. Returns 0 if outside.
 */
window.GetInteriorFromEntity = function (entity) {
	return _in(0x2107ba50, 0x4071a6bb, entity, _r, _ri);
};

/**
 * Returns the group ID of the specified interior. For example, regular interiors have group 0, subway interiors have group 1. There are a few other groups too.
 */
window.GetInteriorGroupId = function (interiorID) {
	return _in(0xe4a84abf, 0x135ef91a, interiorID, _r, _ri);
};

/**
 * false = Any resolution < 1280x720
 * true = Any resolution >= 1280x720
 */
window.GetIsHidef = function () {
	return _in(0x84ed3119, 0x1cc5d2c9, _r);
};

/**
 * From the driver's perspective, is the left headlight broken.
 */
window.GetIsLeftVehicleHeadlightDamaged = function (vehicle) {
	return _in(0x5ef77c9a, 0xdd3b11a3, vehicle, _r);
};
window.IsHeadlightLBroken = window.GetIsLeftVehicleHeadlightDamaged;

window.GetIsLoadingScreenActive = function () {
	return _in(0x10d0a8f2, 0x59e93ec9, _r);
};

/**
 * Hash collision
 */
window.GetIsMultiplayerBrief = function (p0) {
	return _in(0xe3433ead, 0xaaf7ee40, p0);
};

/**
 * gadgetHash - was always 0xFBAB5776 ("GADGET_PARACHUTE").
 */
window.GetIsPedGadgetEquipped = function (ped, gadgetHash) {
	return _in(0xf7313320, 0x72f5156c, ped, _ch(gadgetHash), _r);
};

/**
 * Dr. Underscore (1/6/18):
 * Works exactly like IS_PROJECTILE_TYPE_IN_AREA, but it puts the position of the projectile in the vector.
 * p8 is probably ownedByPlayer, but not known for sure. (see IS_PROJECTILE_IN_AREA for info)
 * Unsure of the hash name, could someone confirm this?
 */
window.GetIsProjectileTypeInArea = function (x1, y1, z1, x2, y2, z2, projHash, ownedByPlayer) {
	return _in(0x8d7a43ec, 0x6a5fea45, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _ch(projHash), _v, ownedByPlayer, _r);
};
window.N_0x8d7a43ec6a5fea45 = window.GetIsProjectileTypeInArea;

/**
 * From the driver's perspective, is the right headlight broken.
 */
window.GetIsRightVehicleHeadlightDamaged = function (vehicle) {
	return _in(0xa7ecb733, 0x55eb2f20, vehicle, _r);
};
window.IsHeadlightRBroken = window.GetIsRightVehicleHeadlightDamaged;

/**
 * p0 = VEHICLE_NODE_ID
 * Returns true when the node is Offroad. Alleys, some dirt roads, and carparks return true.
 * Normal roads where plenty of Peds spawn will return false
 */
window.GetIsSlowRoadFlag = function (nodeID) {
	return _in(0x4f5070aa, 0x58f69279, nodeID, _r);
};
window.N_0x4f5070aa58f69279 = window.GetIsSlowRoadFlag;

/**
 * from docks_heistb.c4:
 * AI::GET_IS_TASK_ACTIVE(PLAYER::PLAYER_PED_ID(), 2))
 * Known Tasks: pastebin.com/2gFqJ3Px
 */
window.GetIsTaskActive = function (ped, taskNumber) {
	return _in(0xb0760331, 0xc7aa4155, ped, taskNumber, _r);
};

/**
 * Returns true when in a vehicle, false whilst entering/exiting.
 */
window.GetIsVehicleEngineRunning = function (vehicle) {
	return _in(0xae31e7df, 0x9b5b132e, vehicle, _r);
};
window.IsVehicleEngineOn = window.GetIsVehicleEngineRunning;

window.GetIsVehiclePrimaryColourCustom = function (vehicle) {
	return _in(0xf095c040, 0x5307b21b, vehicle, _r);
};

/**
 * Check if Vehicle Secondary is avaliable for customize
 */
window.GetIsVehicleSecondaryColourCustom = function (vehicle) {
	return _in(0x910a32e7, 0xaad2656c, vehicle, _r);
};

/**
 * For a full list, see here: pastebin.com/Tp0XpBMN
 */
window.GetIsWaypointRecordingLoaded = function (name) {
	return _in(0xcb4e8be8, 0xa0063c5d, _ts(name), _r);
};

/**
 * Setting Aspect Ratio Manually in game will return:
 * false - for Narrow format Aspect Ratios (3:2, 4:3, 5:4, etc. )
 * true - for Wide format Aspect Ratios (5:3, 16:9, 16:10, etc. )
 * Setting Aspect Ratio to "Auto" in game will return "false" or "true" based on the actual set Resolution Ratio.
 */
window.GetIsWidescreen = function () {
	return _in(0x30cf4bda, 0x4fcb1905, _r);
};

window.GetItemsetSize = function (x) {
	return _in(0xd9127e83, 0xabf7c631, x, _r, _ri);
};

window.GetJackTarget = function (ped) {
	return _in(0x5486a79d, 0x9fbd342d, ped, _r, _ri);
};

/**
 * Seems to do the exact same as INTERIOR::GET_ROOM_KEY_FROM_ENTITY
 */
window.GetKeyForEntityInRoom = function (entity) {
	return _in(0x399685db, 0x942336bc, entity, _r, _ri);
};

/**
 * Gets a string literal from a label name.
 */
window.GetLabelText = function (labelName) {
	return _in(0x7b5280eb, 0xa9840c72, _ts(labelName), _r, _s);
};

/**
 * ```
 * Landing gear states:
 * 0: Deployed
 * 1: Closing (Retracting)
 * 3: Opening (Deploying)
 * 4: Retracted
 * ```
 * Landing gear state 2 is never used.
 * @param vehicle The vehicle to check.
 * @return The current state of the vehicles landing gear.
 */
window.GetLandingGearState = function (vehicle) {
	return _in(0x9b0f3dca, 0x3db0f4cd, vehicle, _r, _ri);
};
window.GetVehicleLandingGear = window.GetLandingGearState;

/**
 * Not exactly sure on this one, but here's a snippet of code:
 * if (PED::IS_PED_IN_ANY_VEHICLE(PLAYER::PLAYER_PED_ID(), 0)) {
 * v_2 = PED::GET_VEHICLE_PED_IS_IN(PLAYER::PLAYER_PED_ID(), 0);
 * } else {
 * v_2 = VEHICLE::_B2D06FAEDE65B577();
 * }
 */
window.GetLastDrivenVehicle = function () {
	return _in(0xb2d06fae, 0xde65b577, _r, _ri);
};
window.N_0xb2d06faede65b577 = window.GetLastDrivenVehicle;

window.GetLastMaterialHitByEntity = function (entity) {
	return _in(0x5c3d0a93, 0x5f535c4c, entity, _r, _ri);
};

window.GetLastPedInVehicleSeat = function (vehicle, seatIndex) {
	return _in(0x83f969aa, 0x1ee2a664, vehicle, seatIndex, _r, _ri);
};

/**
 * Returns the length of the string passed (much like strlen).
 */
window.GetLengthOfLiteralString = function (string) {
	return _in(0xf030907c, 0xcbb8a9fd, _ts(string), _r, _ri);
};

/**
 * gets the length of a null terminated string, without checking unicode encodings
 */
window.GetLengthOfString = function (STRING) {
	return _in(0x43e41111, 0x89e54f0e, _ts(STRING), _r, _ri);
};
window.N_0x43e4111189e54f0e = window.GetLengthOfString;

/**
 * Returns the string length of the string from the gxt string .
 */
window.GetLengthOfStringWithThisTextLabel = function (gxt) {
	return _in(0x801bd273, 0xd3a23f74, _ts(gxt), _r, _ri);
};

/**
 * Second Param = LiveryIndex
 * example
 * int count = VEHICLE::GET_VEHICLE_LIVERY_COUNT(veh);
 * for (int i = 0; i < count; i++)
 * {
 * char* LiveryName = VEHICLE::GET_LIVERY_NAME(veh, i);
 * }
 * this example will work fine to fetch all names
 * for example for Sanchez we get
 * SANC_LV1
 * SANC_LV2
 * SANC_LV3
 * SANC_LV4
 * SANC_LV5
 * Use _GET_LABEL_TEXT, to get the localized livery name.
 * -----------
 * NOTE: You may need to set the vehicle's modKit to 0 by using this function: SET_VEHICLE_MOD_KIT() before getting the name, otherwise this native may return NULL.
 * dev-c.com/nativedb/func/info/1f2aa07f00b3217a
 */
window.GetLiveryName = function (vehicle, liveryIndex) {
	return _in(0xb4c7a938, 0x37c91a1f, vehicle, liveryIndex, _r, _s);
};

window.GetLocalPlayerAimState = function () {
	return _in(0xbb41afbb, 0xbc0a0287, _r, _ri);
};

/**
 * Gets local system time as year, month, day, hour, minute and second.
 * Example usage:
 * int year;
 * int month;
 * int day;
 * int hour;
 * int minute;
 * int second;
 * or use std::tm struct
 * TIME::GET_LOCAL_TIME(&year, &month, &day, &hour, &minute, &second);
 */
window.GetLocalTime = function () {
	return _in(0x50c7a990, 0x57a69748, _i, _i, _i, _i, _i, _i);
};

window.GetLockonRangeOfCurrentPedWeapon = function (ped) {
	return _in(0x840f03e9, 0x041e2c9c, ped, _r, _rf);
};
window.N_0x840f03e9041e2c9c = window.GetLockonRangeOfCurrentPedWeapon;

window.GetMainPlayerBlipId = function () {
	return _in(0xdcd4ec3f, 0x419d02fa, _r, _ri);
};

/**
 * Input: Makeup color index, value between 0 and 63 (inclusive).
 * Output: RGB values for the makeup color specified in the input.
 * This is used with the makeup color swatches scaleform.
 * Use [`_0x4852FC386E2E1BB5`](#_0x4852FC386E2E1BB5) to get the hair colors.
 * @param makeupColorIndex The hair color index. Value between 0-63 (inclusive).
 * @param outR Output red value.
 * @param outG Output green value.
 * @param outB Output blue value.
 */
window.GetMakeupRgbColor = function (makeupColorIndex) {
	return _in(0x013e5cfc, 0x38cd5387, makeupColorIndex, _i, _i, _i);
};
window.N_0x013e5cfc38cd5387 = window.GetMakeupRgbColor;

window.GetMaxAmmo = function (ped, weaponHash, ammo) {
	return _in(0xdc16122c, 0x7a20c933, ped, _ch(weaponHash), _ii(ammo) /* may be optional */, _r);
};

/**
 * p2 is mostly 1 in the scripts.
 */
window.GetMaxAmmoInClip = function (ped, weaponHash, p2) {
	return _in(0xa38dcffc, 0xea8962fa, ped, _ch(weaponHash), p2, _r, _ri);
};

window.GetMaxRangeOfCurrentPedWeapon = function (ped) {
	return _in(0x814c9d19, 0xdfd69679, ped, _r, _rf);
};

/**
 * Gets the maximum wanted level the player can get.
 * Ranges from 0 to 5.
 */
window.GetMaxWantedLevel = function () {
	return _in(0x462e0db9, 0xb137dc5f, _r, _ri);
};

/**
 * This function is hard-coded to always return 0.
 * Limit is 96, see _GET_MAXIMUM_NUMBER_OF_PHOTOS_2 (0xDC54A7AF8B3A14EF).
 */
window.GetMaximumNumberOfPhotos = function () {
	return _in(0x34d23450, 0xf028b0bf, _r, _ri);
};

/**
 * This is the "actual" GET_MAXIMUM_NUMBER_OF_PHOTOS native. Always returns 96.
 */
window.GetMaximumNumberOfPhotos_2 = function () {
	return _in(0xdc54a7af, 0x8b3a14ef, _r, _ri);
};
window.N_0xdc54a7af8b3a14ef = window.GetMaximumNumberOfPhotos_2;

window.GetMeleeTargetForPed = function (ped) {
	return _in(0x18a3e9ee, 0x1297fd39, ped, _r, _ri);
};

window.GetMillisecondsPerGameMinute = function () {
	return _in(0x2f8b4d1c, 0x595b11db, _r, _ri);
};

window.GetMissionFlag = function () {
	return _in(0xa33cdccd, 0xa663159e, _r);
};

window.GetMobilePhonePosition = function (position) {
	return _in(0x584fdfda, 0x48805b86, _v);
};

window.GetMobilePhoneRenderId = function (renderId) {
	return _in(0xb4a53e05, 0xf68b6fa1, _ii(renderId) /* may be optional */);
};

window.GetMobilePhoneRotation = function (p1) {
	return _in(0x1cefb61f, 0x193070ae, _v, p1);
};

/**
 * Returns the name for the type of vehicle mod(Armour, engine etc)
 * -----------
 * for some reason this native seems unreliable: sometimes returns NULL, and when retval != NULL the string can be empty
 */
window.GetModSlotName = function (vehicle, modType) {
	return _in(0x51f0feb9, 0xf6ae98c0, vehicle, modType, _r, _s);
};

/**
 * Returns the text label of a mod type for a given vehicle
 * Use _GET_LABEL_TEXT to get the part name in the game's language
 */
window.GetModTextLabel = function (vehicle, modType, modValue) {
	return _in(0x8935624f, 0x8c5592cc, vehicle, modType, modValue, _r, _s);
};

/**
 * Gets the dimensions of a model.
 * Calculate (maximum - minimum) to get the size, in which case, Y will be how long the model is.
 * Vector3 GetDimensions(Hash model)
 * {
 * Vector3 right, left;
 * GET_MODEL_DIMENSIONS(model, &right, &left);
 * return Vector3::Subtract(left, right);
 * }
 * Example from the scripts: GAMEPLAY::GET_MODEL_DIMENSIONS(ENTITY::GET_ENTITY_MODEL(PLAYER::PLAYER_PED_ID()), &v_1A, &v_17);
 */
window.GetModelDimensions = function (modelHash) {
	return _in(0x03e8d3d5, 0xf549087a, _ch(modelHash), _v, _v);
};

/**
 * Function just returns 0
 * void __fastcall ped__get_mount(NativeContext *a1)
 * {
 * NativeContext *v1; // rbx@1
 * v1 = a1;
 * GetAddressOfPedFromScriptHandle(a1->Args->Arg1);
 * v1->Returns->Item1= 0;
 * }
 */
window.GetMount = function (ped) {
	return _in(0xe7e11b8d, 0xcbed1058, ped, _r, _ri);
};

window.GetMusicPlaytime = function () {
	return _in(0xe7a0d23d, 0xc414507b, _r, _ri);
};

/**
 * The reversed code looks like this (Sasuke78200)
 * //
 * char g_szScriptName[64];
 * char* _0xBE7ACD89(int a_iThreadID)
 * {
 * scrThread* l_pThread;
 * // Get the script thread
 * l_pThread = GetThreadByID(a_iThreadID);
 * if(l_pThread == 0 || l_pThread->m_iThreadState == 2)
 * {
 * strncpy(g_szScriptName, "", 64);
 * }
 * else
 * {
 * strncpy(g_szScriptName, l_pThread->m_szScriptName, 64);
 * }
 * return g_szScriptName;
 * }
 */
window.GetNameOfThread = function (threadId) {
	return _in(0x05a42ba9, 0xfc8da96b, threadId, _r, _s);
};
window.GetThreadName = window.GetNameOfThread;

/**
 * AIRP = Los Santos International Airport
 * ALAMO = Alamo Sea
 * ALTA = Alta
 * ARMYB = Fort Zancudo
 * BANHAMC = Banham Canyon Dr
 * BANNING = Banning
 * BEACH = Vespucci Beach
 * BHAMCA = Banham Canyon
 * BRADP = Braddock Pass
 * BRADT = Braddock Tunnel
 * BURTON = Burton
 * CALAFB = Calafia Bridge
 * CANNY = Raton Canyon
 * CCREAK = Cassidy Creek
 * CHAMH = Chamberlain Hills
 * CHIL = Vinewood Hills
 * CHU = Chumash
 * CMSW = Chiliad Mountain State Wilderness
 * CYPRE = Cypress Flats
 * DAVIS = Davis
 * DELBE = Del Perro Beach
 * DELPE = Del Perro
 * DELSOL = La Puerta
 * DESRT = Grand Senora Desert
 * DOWNT = Downtown
 * DTVINE = Downtown Vinewood
 * EAST_V = East Vinewood
 * EBURO = El Burro Heights
 * ELGORL = El Gordo Lighthouse
 * ELYSIAN = Elysian Island
 * GALFISH = Galilee
 * GOLF = GWC and Golfing Society
 * GRAPES = Grapeseed
 * GREATC = Great Chaparral
 * HARMO = Harmony
 * HAWICK = Hawick
 * HORS = Vinewood Racetrack
 * HUMLAB = Humane Labs and Research
 * JAIL = Bolingbroke Penitentiary
 * KOREAT = Little Seoul
 * LACT = Land Act Reservoir
 * LAGO = Lago Zancudo
 * LDAM = Land Act Dam
 * LEGSQU = Legion Square
 * LMESA = La Mesa
 * LOSPUER = La Puerta
 * MIRR = Mirror Park
 * MORN = Morningwood
 * MOVIE = Richards Majestic
 * MTCHIL = Mount Chiliad
 * MTGORDO = Mount Gordo
 * MTJOSE = Mount Josiah
 * MURRI = Murrieta Heights
 * NCHU = North Chumash
 * NOOSE = N.O.O.S.E
 * OCEANA = Pacific Ocean
 * PALCOV = Paleto Cove
 * PALETO = Paleto Bay
 * PALFOR = Paleto Forest
 * PALHIGH = Palomino Highlands
 * PALMPOW = Palmer-Taylor Power Station
 * PBLUFF = Pacific Bluffs
 * PBOX = Pillbox Hill
 * PROCOB = Procopio Beach
 * RANCHO = Rancho
 * RGLEN = Richman Glen
 * RICHM = Richman
 * ROCKF = Rockford Hills
 * RTRAK = Redwood Lights Track
 * SANAND = San Andreas
 * SANCHIA = San Chianski Mountain Range
 * SANDY = Sandy Shores
 * SKID = Mission Row
 * SLAB = Stab City
 * STAD = Maze Bank Arena
 * STRAW = Strawberry
 * TATAMO = Tataviam Mountains
 * TERMINA = Terminal
 * TEXTI = Textile City
 * TONGVAH = Tongva Hills
 * TONGVAV = Tongva Valley
 * VCANA = Vespucci Canals
 * VESP = Vespucci
 * VINE = Vinewood
 * WINDF = Ron Alternates Wind Farm
 * WVINE = West Vinewood
 * ZANCUDO = Zancudo River
 * ZP_ORT = Port of South Los Santos
 * ZQ_UAR = Davis Quartz
 */
window.GetNameOfZone = function (x, y, z) {
	return _in(0xcd90657d, 0x4c30e1ca, _fv(x), _fv(y), _fv(z), _r, _s);
};

window.GetNamedRendertargetRenderId = function (p0) {
	return _in(0x1a6478b6, 0x1c6bdc3b, _ts(p0), _r, _ri);
};

/**
 * Looks like the last parameter returns true if the path has been calculated, while the first returns the remaining distance to the end of the path.
 * Return value of native is the same as GET_NAVMESH_ROUTE_RESULT
 * Looks like the native returns an int for the path's state:
 * 1 - ???
 * 2
 * 3 - Finished Generating
 */
window.GetNavmeshRouteDistanceRemaining = function (ped) {
	return _in(0xc6f5c0bc, 0xdc74d62d, ped, _f, _i /* actually bool */, _r, _ri);
};

/**
 * See GET_NAVMESH_ROUTE_DISTANCE_REMAINING for more details.
 */
window.GetNavmeshRouteResult = function (ped) {
	return _in(0x632e831f, 0x382a0fa8, ped, _r, _ri);
};

window.GetNearestPlayerToEntity = function (entity) {
	return _in(0x7196842c, 0xb375cdb3, entity, _r, _ri);
};

window.GetNearestPlayerToEntityOnTeam = function (entity, team) {
	return _in(0x4dc9a62f, 0x844d9337, entity, team, _r, _ri);
};

/**
 * Could this be used alongside either,
 * SET_NETWORK_ID_EXISTS_ON_ALL_MACHINES or _SET_NETWORK_ID_SYNC_TO_PLAYER to make it so other players can hear the sound while online? It'd be a bit troll-fun to be able to play the Zancudo UFO creepy sounds globally.
 */
window.GetNetworkIdFromSoundId = function (soundId) {
	return _in(0x2de3f0a1, 0x34ffbc0d, soundId, _r, _ri);
};

window.GetNetworkTime = function () {
	return _in(0x7a5487fe, 0x9faa6b48, _r, _ri);
};

window.GetNextBlipInfoId = function (blipSprite) {
	return _in(0x14f96aa5, 0x0d6fbea7, blipSprite, _r, _ri);
};

/**
 * Returns weather name hash
 */
window.GetNextWeatherTypeHashName = function () {
	return _in(0x711327cd, 0x09c8f162, _r, _ri);
};
window.GetNextWeatherType = window.GetNextWeatherTypeHashName;

/**
 * Needs more research. Gets the stat name of a masked bool?
 * p4 - Usually "_NGPSTAT_BOOL" or "_NGTATPSTAT_BOOL". There may be more that I missed.
 */
window.GetNgstatBoolHash = function (index, spStat, charStat, character, section) {
	return _in(0xba52ff53, 0x8ed2bc71, index, spStat, charStat, character, _ts(section), _r, _ri);
};
window.N_0xba52ff538ed2bc71 = window.GetNgstatBoolHash;

/**
 * Needs more research. Gets the stat name of a masked int?
 * p4 - Usually one of the following (there may be more that I missed):
 * -----> "_APAPSTAT_INT"
 * -----> "_LRPSTAT_INT"
 * -----> "_NGPSTAT_INT"
 * -----> "_MP_APAPSTAT_INT"
 * -----> "_MP_LRPSTAT_INT"
 */
window.GetNgstatIntHash = function (index, spStat, charStat, character, section) {
	return _in(0x2b4cdca6, 0xf07ff3da, index, spStat, charStat, character, _ts(section), _r, _ri);
};
window.N_0x2b4cdca6f07ff3da = window.GetNgstatIntHash;

window.GetNoLoadingScreen = function () {
	return _in(0x18c1270e, 0xa7f199bc, _r);
};

window.GetNthClosestVehicleNode = function (x, y, z, nthClosest, unknown1, unknown2, unknown3) {
	return _in(0xe50e5241, 0x6ccf948b, _fv(x), _fv(y), _fv(z), nthClosest, _v, unknown1, unknown2, unknown3, _r);
};

/**
 * See gtaforums.com/topic/843561-pathfind-node-types for node type info. 0 = paved road only, 1 = any road, 3 = water
 * p10 always equal 0x40400000
 * p11 always equal 0
 */
window.GetNthClosestVehicleNodeFavourDirection = function (x, y, z, desiredX, desiredY, desiredZ, nthClosest, nodetype, p10, p11) {
	return _in(0x45905be8, 0x654ae067, _fv(x), _fv(y), _fv(z), _fv(desiredX), _fv(desiredY), _fv(desiredZ), nthClosest, _v, _f, nodetype, p10, p11, _r);
};

/**
 * Returns the id.
 */
window.GetNthClosestVehicleNodeId = function (x, y, z, nth, nodetype, p5, p6) {
	return _in(0x22d7275a, 0x79fe8215, _fv(x), _fv(y), _fv(z), nth, nodetype, _fv(p5), _fv(p6), _r, _ri);
};

window.GetNthClosestVehicleNodeIdWithHeading = function (x, y, z, nthClosest, outHeading, p6, p7, p8) {
	return _in(0x6448050e, 0x9c2a7207, _fv(x), _fv(y), _fv(z), nthClosest, _v, _fv(outHeading), p6, _fv(p7), _fv(p8), _r, _ri);
};

/**
 * Get the nth closest vehicle node and its heading. (unknown2 = 9, unknown3 = 3.0, unknown4 = 2.5)
 */
window.GetNthClosestVehicleNodeWithHeading = function (x, y, z, nthClosest, unknown2, unknown3, unknown4) {
	return _in(0x80ca6a8b, 0x6c094cc4, _fv(x), _fv(y), _fv(z), nthClosest, _v, _f, _i, unknown2, _fv(unknown3), _fv(unknown4), _r);
};

window.GetNuiCursorPosition = function () {
	return _in(0x00000000, 0xbdba226f, _i, _i);
};

/**
 * only documented to be continued...
 */
window.GetNumDecorations = function (character) {
	return _in(0x278f76c3, 0xb0a8f109, character, _r, _ri);
};
window.N_0x278f76c3b0a8f109 = window.GetNumDecorations;

window.GetNumDlcVehicles = function () {
	return _in(0xa7a866d2, 0x1cd2329b, _r, _ri);
};

/**
 * Allowed Values from 0 - DLC1::GET_NUM_DLC_WEAPONS()
 */
window.GetNumDlcWeaponComponents = function (dlcWeaponIndex) {
	return _in(0x40542535, 0x8a7d61fe, dlcWeaponIndex, _r, _ri);
};

/**
 * Gets the total number of DLC weapons.
 */
window.GetNumDlcWeapons = function () {
	return _in(0xee47635f, 0x352da367, _r, _ri);
};

/**
 * Returns number of possible values of the componentId argument of GET_FORCED_COMPONENT.
 */
window.GetNumForcedComponents = function (componentHash) {
	return _in(0xc6b9db42, 0xc04dd8c3, _ch(componentHash), _r, _ri);
};

/**
 * Used for freemode (online) characters.
 */
window.GetNumHairColors = function () {
	return _in(0xe5c0cf87, 0x2c2ad150, _r, _ri);
};

/**
 * Used with freemode (online) characters.
 */
window.GetNumHeadOverlayValues = function (overlayID) {
	return _in(0xcf1ce768, 0xbb43480e, overlayID, _r, _ri);
};

window.GetNumMakeupColors = function () {
	return _in(0xd1f7ca15, 0x35d22818, _r, _ri);
};
window.N_0xd1f7ca1535d22818 = window.GetNumMakeupColors;

window.GetNumMembershipDesc = function () {
	return _in(0x1f471b79, 0xacc90bef, _r, _ri);
};
window.N_0x1f471b79acc90bef = window.GetNumMembershipDesc;

window.GetNumModColors = function (p0, p1) {
	return _in(0xa551be18, 0xc11a476d, p0, p1, _r, _ri);
};

window.GetNumModKits = function (vehicle) {
	return _in(0x33f2e3fe, 0x70eaae1d, vehicle, _r, _ri);
};

/**
 * Type equals 0 for male non-dlc, 1 for female non-dlc, 2 for male dlc, and 3 for female dlc.
 */
window.GetNumParentPedsOfType = function (type) {
	return _in(0x5ef37013, 0xa6539c9d, type, _r, _ri);
};

/**
 * character is 0 for Michael, 1 for Franklin, 2 for Trevor, 3 for freemode male, and 4 for freemode female.
 * componentId is between 0 and 11 and corresponds to the usual component slots.
 * p1 could be the outfit number; unsure.
 * p2 is usually -1; unknown function.
 * p3 appears to be a boolean flag; unknown function.
 * p4 is usually -1; unknown function.
 */
window.GetNumPropsFromOutfit = function (character, p1, p2, p3, p4, componentId) {
	return _in(0x9bdf5981, 0x8b1e38c1, character, p1, p2, p3, p4, componentId, _r, _ri);
};

/**
 * p0 appears to be for MP
 */
window.GetNumReservedMissionObjects = function (p0) {
	return _in(0xaa81b5f1, 0x0bc43ac2, p0, _r, _ri);
};

/**
 * p0 appears to be for MP
 */
window.GetNumReservedMissionPeds = function (p0) {
	return _in(0x1f13d5ae, 0x5cb17e17, p0, _r, _ri);
};

/**
 * p0 appears to be for MP
 */
window.GetNumReservedMissionVehicles = function (p0) {
	return _in(0xcf3a9659, 0x06452031, p0, _r, _ri);
};

/**
 * Gets the amount of metadata values with the specified key existing in the specified resource's manifest.
 * See also: [Resource manifest](https://docs.fivem.net/resources/manifest/)
 * @param resourceName The resource name.
 * @param metadataKey The key to look up in the resource manifest.
 */
window.GetNumResourceMetadata = function (resourceName, metadataKey) {
	return _in(0x00000000, 0x0776e864, _ts(resourceName), _ts(metadataKey), _r, _ri);
};

window.GetNumResources = function () {
	return _in(0x00000000, 0x0863f27b, _r, _ri);
};

/**
 * Returns how many possible mods a vehicle has for a given mod type
 */
window.GetNumVehicleMods = function (vehicle, modType) {
	return _in(0xe38e9162, 0xa2500646, vehicle, modType, _r, _ri);
};

window.GetNumVehicleWindowTints = function () {
	return _in(0x9d122400, 0x4b3a6707, _r, _ri);
};

window.GetNumberOfActiveBlips = function () {
	return _in(0x9a3ff3de, 0x163034e8, _r, _ri);
};

window.GetNumberOfDispatchedUnitsForPlayer = function (dispatchService) {
	return _in(0xeb4a0c2d, 0x56441717, dispatchService, _r, _ri);
};
window.N_0xeb4a0c2d56441717 = window.GetNumberOfDispatchedUnitsForPlayer;

/**
 * eventGroup: 0 = CEventGroupScriptAI, 1 = CEventGroupScriptNetwork
 */
window.GetNumberOfEvents = function (eventGroup) {
	return _in(0x5f92a689, 0xa06620aa, eventGroup, _r, _ri);
};

window.GetNumberOfFiresInRange = function (x, y, z, radius) {
	return _in(0x50cad495, 0xa460b305, _fv(x), _fv(y), _fv(z), _fv(radius), _r, _ri);
};

/**
 * Gets the number of instances of the specified script is currently running.
 * Actually returns numInstances - 1.
 * if (scriptPtr)
 * v3 = GetNumberOfInstancesOfScript(scriptPtr) - 1;
 * return v3;
 */
window.GetNumberOfInstancesOfScriptWithNameHash = function (scriptHash) {
	return _in(0x2c83a9da, 0x6bffc4f9, _ch(scriptHash), _r, _ri);
};
window.GetNumberOfInstancesOfStreamedScript = window.GetNumberOfInstancesOfScriptWithNameHash;

window.GetNumberOfPassengerVoiceVariations = function (p0) {
	return _in(0x66e49bf5, 0x5b4b1874, p0, _r, _ri);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetNumberOfPedDrawableVariations = function (ped, componentId) {
	return _in(0x27561561, 0x732a7842, ped, componentId, _r, _ri);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetNumberOfPedPropDrawableVariations = function (ped, propId) {
	return _in(0x5faf9754, 0xe789fb47, ped, propId, _r, _ri);
};

/**
 * Need to check behavior when drawableId = -1
 * - Doofy.Ass
 * Why this function doesn't work and return nill value?
 * GET_NUMBER_OF_PED_PROP_TEXTURE_VARIATIONS(PLAYER.PLAYER_PED_ID(), 0, 5)
 * tick: scripts/addins/menu_execute.lua:51: attempt to call field 'GET_NUMBER_OF_PED_PROP_TEXTURE_VARIATIONS' (a nil value)
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetNumberOfPedPropTextureVariations = function (ped, propId, drawableId) {
	return _in(0xa6e7f1ce, 0xb523e171, ped, propId, drawableId, _r, _ri);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetNumberOfPedTextureVariations = function (ped, componentId, drawableId) {
	return _in(0x8f7156a3, 0x142a6bad, ped, componentId, drawableId, _r, _ri);
};

window.GetNumberOfPhotos = function () {
	return _in(0x473151eb, 0xc762c6da, _r, _ri);
};
window.N_0x473151ebc762c6da = window.GetNumberOfPhotos;

window.GetNumberOfPlayers = function () {
	return _in(0x407c7f91, 0xddb46c16, _r, _ri);
};

window.GetNumberOfStreamingRequests = function () {
	return _in(0x40600572, 0x71cebc89, _r, _ri);
};

/**
 * Actually number of color combinations
 */
window.GetNumberOfVehicleColours = function (vehicle) {
	return _in(0x3b963160, 0xcd65d41e, vehicle, _r, _ri);
};

window.GetNumberOfVehicleDoors = function (vehicle) {
	return _in(0x92922a60, 0x7497b14d, vehicle, _r, _ri);
};

/**
 * Returns the number of *types* of licence plates, enumerated below in SET_VEHICLE_NUMBER_PLATE_TEXT_INDEX.
 */
window.GetNumberOfVehicleNumberPlates = function () {
	return _in(0x4c4d6b26, 0x44f458cb, _r, _ri);
};

window.GetObjectFragmentDamageHealth = function (p0, p1) {
	return _in(0xb6fbfd07, 0x9b8d0596, p0, p1, _r, _rf);
};

/**
 * Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
 */
window.GetObjectIndexFromEntityIndex = function (entity) {
	return _in(0xd7e3b973, 0x5c0f89d6, entity, _r, _ri);
};

window.GetObjectOffsetFromCoords = function (xPos, yPos, zPos, heading, xOffset, yOffset, zOffset) {
	return _in(0x163e252d, 0xe035a133, _fv(xPos), _fv(yPos), _fv(zPos), _fv(heading), _fv(xOffset), _fv(yOffset), _fv(zOffset), _r, _rv);
};

/**
 * Converts world coords (posX - Z) to coords relative to the entity
 * Example:
 * posX = 50
 * posY = 1000
 * posZ = 60
 * Entity's coords are: x=30, y=1000, z=60.
 * All three returned coords will then be in range of [-20,20] depending on rotation of the entity.
 */
window.GetOffsetFromEntityGivenWorldCoords = function (entity, posX, posY, posZ) {
	return _in(0x2274bc1c, 0x4885e333, entity, _fv(posX), _fv(posY), _fv(posZ), _r, _rv);
};

/**
 * Offset values are relative to the entity.
 * x = left/right
 * y = forward/backward
 * z = up/down
 */
window.GetOffsetFromEntityInWorldCoords = function (entity, offsetX, offsetY, offsetZ) {
	return _in(0x1899f328, 0xb0e12848, entity, _fv(offsetX), _fv(offsetY), _fv(offsetZ), _r, _rv);
};

window.GetOffsetFromInteriorInWorldCoords = function (interiorID, x, y, z) {
	return _in(0x9e3b3e6d, 0x66f6e22f, interiorID, _fv(x), _fv(y), _fv(z), _r, _rv);
};

/**
 * Online version is defined here: update\update.rpf\common\data\version.txt
 * Example:
 * [ONLINE_VERSION_NUMBER]
 * 1.33
 * _GET_ONLINE_VERSION() will return "1.33"
 * Belongs in NETWORK
 */
window.GetOnlineVersion = function () {
	return _in(0xfca9373e, 0xf340ac0a, _r, _s);
};
window.GetGameVersion = window.GetOnlineVersion;

/**
 * Returns NULL unless UPDATE_ONSCREEN_KEYBOARD() returns 1 in the same tick.
 */
window.GetOnscreenKeyboardResult = function () {
	return _in(0x8362b09b, 0x91893647, _r, _s);
};

/**
 * Returns:
 * 5
 * 10
 * 15
 * 20
 * 25
 * 30
 * 35
 */
window.GetPauseMenuState = function () {
	return _in(0x272acd84, 0x970869c5, _r, _ri);
};

window.GetPedAccuracy = function (ped) {
	return _in(0x37f4ad56, 0xecbc0cd6, ped, _r, _ri);
};

/**
 * Returns the ped's alertness (0-3).
 * Values :
 * 0 : Neutral
 * 1 : Heard something (gun shot, hit, etc)
 * 2 : Knows (the origin of the event)
 * 3 : Fully alerted (is facing the event?)
 * If the Ped does not exist, returns -1.
 */
window.GetPedAlertness = function (ped) {
	return _in(0xf6aa1185, 0x30443fd2, ped, _r, _ri);
};

window.GetPedAmmoByType = function (ped, ammoType) {
	return _in(0x39d22031, 0x557946c1, ped, ammoType, _r, _ri);
};

/**
 * Returns an ammo type hash, which is defined in AmmoInfo.
 */
window.GetPedAmmoTypeFromWeapon = function (ped, weaponHash) {
	return _in(0x7fead38b, 0x326b9f74, ped, _ch(weaponHash), _r, _ri);
};
window.GetPedAmmoType = window.GetPedAmmoTypeFromWeapon;

window.GetPedAmmoTypeFromWeapon_2 = function (ped, weaponHash) {
	return _in(0xf489b44d, 0xd5af4bd9, ped, _ch(weaponHash), _r, _ri);
};

window.GetPedArmour = function (ped) {
	return _in(0x9483af82, 0x1605b1d8, ped, _r, _ri);
};

window.GetPedAsGroupLeader = function (groupID) {
	return _in(0x5cce68db, 0xd5fe93ec, groupID, _r, _ri);
};

/**
 * from fm_mission_controller.c4 (variable names changed for clarity):
 * int groupID = PLAYER::GET_PLAYER_GROUP(PLAYER::PLAYER_ID());
 * PED::GET_GROUP_SIZE(group, &unused, &groupSize);
 * if (groupSize >= 1) {
 * . . . . for (int memberNumber = 0; memberNumber < groupSize; memberNumber++) {
 * . . . . . . . . Ped ped1 = PED::GET_PED_AS_GROUP_MEMBER(groupID, memberNumber);
 * . . . . . . . . //and so on
 */
window.GetPedAsGroupMember = function (groupID, memberNumber) {
	return _in(0x51455483, 0xcf23ed97, groupID, memberNumber, _r, _ri);
};

/**
 * Gets the position of the specified bone of the specified ped.
 * ped: The ped to get the position of a bone from.
 * boneId: The ID of the bone to get the position from. This is NOT the index.
 * offsetX: The X-component of the offset to add to the position relative to the bone's rotation.
 * offsetY: The Y-component of the offset to add to the position relative to the bone's rotation.
 * offsetZ: The Z-component of the offset to add to the position relative to the bone's rotation.
 */
window.GetPedBoneCoords = function (ped, boneId, offsetX, offsetY, offsetZ) {
	return _in(0x17c07fc6, 0x40e86b4e, ped, boneId, _fv(offsetX), _fv(offsetY), _fv(offsetZ), _r, _rv);
};

/**
 * Bone ID enum: pastebin.com/3pz17QGd
 */
window.GetPedBoneIndex = function (ped, boneId) {
	return _in(0x3f428d08, 0xbe5aae31, ped, boneId, _r, _ri);
};

/**
 * Returns the hash of the weapon/model/object that killed the ped.
 */
window.GetPedCauseOfDeath = function (ped) {
	return _in(0x16ffe42a, 0xb2d2dc59, ped, _r, _ri);
};

window.GetPedCombatMovement = function (ped) {
	return _in(0xdea92412, 0xfcaeb3f5, ped, _r, _ri);
};

window.GetPedCombatRange = function (ped) {
	return _in(0xf9d9f7f2, 0xdb8e2fa0, ped, _r, _ri);
};

/**
 * p2 is always 1 in the scripts.
 * if (GET_PED_CONFIG_FLAG(ped, 78, 1))
 * = returns true if ped is aiming/shooting a gun
 */
window.GetPedConfigFlag = function (ped, flagId, p2) {
	return _in(0x7ee53118, 0xc892b513, ped, flagId, p2, _r);
};

window.GetPedDecorationsState = function (ped) {
	return _in(0x71eab450, 0xd86954a1, ped, _r, _ri);
};
window.N_0x71eab450d86954a1 = window.GetPedDecorationsState;

window.GetPedDefensiveAreaPosition = function (ped, p1) {
	return _in(0x3c06b878, 0x6dd94cd1, ped, p1, _r, _rv);
};

window.GetPedDesiredMoveBlendRatio = function (ped) {
	return _in(0x8517d4a6, 0xca8513ed, ped, _r, _rf);
};

/**
 * Ids
 * 1
 * 2
 * 3
 * 4
 * 5
 * 6
 * 7 - ------
 * 8 - Accessories 1
 * 9 - Accessories 2
 * 10
 * 11 - Auxiliary parts for torso
 */
window.GetPedDrawableVariation = function (ped, componentId) {
	return _in(0x67f3780d, 0xd425d4fc, ped, componentId, _r, _ri);
};

window.GetPedEnveffScale = function (ped) {
	return _in(0x9c14d303, 0x95a51a3c, ped, _r, _rf);
};

/**
 * Gets the offset the specified ped has moved since the previous tick.
 * If worldSpace is false, the returned offset is relative to the ped. That is, if the ped has moved 1 meter right and 5 meters forward, it'll return 1,5,0.
 * If worldSpace is true, the returned offset is relative to the world. That is, if the ped has moved 1 meter on the X axis and 5 meters on the Y axis, it'll return 1,5,0.
 */
window.GetPedExtractedDisplacement = function (ped, worldSpace) {
	return _in(0xe0af4140, 0x1adf87e3, ped, worldSpace, _r, _rv);
};

/**
 * A getter for [\_SET_PED_EYE_COLOR](#_0x50B56988B170AFDF). Returns -1 if fails to get.
 * @param ped The target ped
 * @return Returns ped's eye colour, or -1 if fails to get.
 */
window.GetPedEyeColor = function (ped) {
	return _in(0x00000000, 0xa47b860f, ped, _r, _ri);
};

/**
 * A getter for [\_SET_PED_FACE_FEATURE](#_0x71A5C1DBA060049E). Returns 0.0 if fails to get.
 * @param ped The target ped
 * @param index Face feature index
 * @return Returns ped's face feature value, or 0.0 if fails to get.
 */
window.GetPedFaceFeature = function (ped, index) {
	return _in(0x00000000, 0xba352add, ped, index, _r, _rf);
};

/**
 * hash collision???
 */
window.GetPedFloodInvincibility = function (ped, p1) {
	return _in(0x2bc338a7, 0xb21f4608, ped, p1);
};

/**
 * Returns the group id of which the specified ped is a member of.
 */
window.GetPedGroupIndex = function (ped) {
	return _in(0xf162e133, 0xb4e7a675, ped, _r, _ri);
};

/**
 * A getter for [\_SET_PED_HAIR_COLOR](#_0x4CFFC65454C93A49). Returns -1 if fails to get.
 * @param ped The target ped
 * @return Returns ped's primary hair colour.
 */
window.GetPedHairColor = function (ped) {
	return _in(0x00000000, 0xa3ea2893, ped, _r, _ri);
};

/**
 * A getter for [\_SET_PED_HAIR_COLOR](#_0x4CFFC65454C93A49). Returns -1 if fails to get.
 * @param ped The target ped
 * @return Returns ped's secondary hair colour.
 */
window.GetPedHairHighlightColor = function (ped) {
	return _in(0x00000000, 0x4b087305, ped, _r, _ri);
};

/**
 * The pointer is to a padded struct that matches the arguments to SET_PED_HEAD_BLEND_DATA(...). There are 4 bytes of padding after each field.
 * (Edit) Console Hash: 0x44E1680C
 * pass this struct in the second parameter
 * typedef struct
 * {
 * int shapeFirst, shapeSecond, shapeThird;
 * int skinFirst, skinSecond, skinThird;
 * float shapeMix, skinMix, thirdMix;
 * } headBlendData;
 */
window.GetPedHeadBlendData = function (ped, headBlendData) {
	return _in(0x2746bd9d, 0x88c5c5d0, ped, _ii(headBlendData) /* may be optional */, _r);
};

/**
 * A getter for [SET_PED_HEAD_OVERLAY](#_0x48F44967FA05CC1E) and [\_SET_PED_HEAD_OVERLAY_COLOR](#_0x497BF74A7B9CB952) natives.
 * @param ped The target ped
 * @param index Overlay index
 * @param overlayValue Overlay value pointer
 * @param colourType Colour type pointer
 * @param firstColour First colour pointer
 * @param secondColour Second colour pointer
 * @param overlayOpacity Opacity pointer
 * @return Returns ped's head overlay data.
 */
window.GetPedHeadOverlayData = function (ped, index) {
	return _in(0x00000000, 0xc46ee605, ped, index, _i, _i, _i, _i, _f, _r);
};

/**
 * Likely a char, if that overlay is not set, e.i. "None" option, returns 255;
 */
window.GetPedHeadOverlayValue = function (ped, overlayID) {
	return _in(0xa60ef3b6, 0x461a4d43, ped, overlayID, _r, _ri);
};

/**
 * Use [`SetPedIlluminatedClothingGlowIntensity`](#_0x4E90D746056E273D) to set the illuminated clothing glow intensity for a specific ped.
 * @param ped The ped to get the glow intensity from.
 * @return A float between 0.0 and 1.0 representing the current illuminated clothing glow intensity.
 */
window.GetPedIlluminatedClothingGlowIntensity = function (ped) {
	return _in(0x1461b28a, 0x06717d68, ped, _r, _rf);
};
window.N_0x1461b28a06717d68 = window.GetPedIlluminatedClothingGlowIntensity;

/**
 * -1 (driver) <= index < GET_VEHICLE_MAX_NUMBER_OF_PASSENGERS(vehicle)
 */
window.GetPedInVehicleSeat = function (vehicle, index) {
	return _in(0xbb40dd22, 0x70b65366, vehicle, index, _r, _ri);
};

/**
 * Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
 */
window.GetPedIndexFromEntityIndex = function (entity) {
	return _in(0x04a2a40c, 0x73395041, entity, _r, _ri);
};

/**
 * Returns a handle to the first entity within the a circle spawned inside the 2 points from a radius. It could return a ped or an entity, but the scripts expect a ped, but still check if it's a ped.
 */
window.GetPedInsideExplosionArea = function (explosionType, x1, y1, z1, x2, y2, z2, radius) {
	return _in(0x14ba4ba1, 0x37af6cec, explosionType, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(radius), _r, _ri);
};

/**
 * Pretty sure outBone is an int.
 */
window.GetPedLastDamageBone = function (ped, outBone) {
	return _in(0xd75960f6, 0xbd9ea49c, ped, _ii(outBone) /* may be optional */, _r);
};

/**
 * Pass ped. Pass address of Vector3.
 * The coord will be put into the Vector3.
 * The return will determine whether there was a coord found or not.
 */
window.GetPedLastWeaponImpactCoord = function (ped, coords) {
	return _in(0x6c4d0409, 0xba1a2bc2, ped, _v, _r);
};

window.GetPedMaxHealth = function (ped) {
	return _in(0x4700a416, 0xe8324ef3, ped, _r, _ri);
};

window.GetPedMoney = function (ped) {
	return _in(0x3f69145b, 0xba87bae7, ped, _r, _ri);
};

/**
 * sizeAndPeds - is a pointer to an array. The array is filled with peds found nearby the ped supplied to the first argument.
 * ignore - ped type to ignore
 * Return value is the number of peds found and added to the array passed.
 * -----------------------------------
 * To make this work in most menu bases at least in C++ do it like so,
 * Formatted Example: pastebin.com/D8an9wwp
 * -----------------------------------
 * Example: gtaforums.com/topic/789788-function-args-to-pedget-ped-nearby-peds/?p=1067386687
 * Here's the right way to do it (console and pc):
 * pastebin.com/SsFej963
 */
window.GetPedNearbyPeds = function (ped, ignore) {
	return _in(0x23f8f5fc, 0x7e8c4a6b, ped, _i, ignore, _r, _ri);
};

/**
 * Returns size of array, passed into the second variable.
 * See below for usage information.
 * This function actually requires a struct, where the first value is the maximum number of elements to return.  Here is a sample of how I was able to get it to work correctly, without yet knowing the struct format.
 * //Setup the array
 * const int numElements = 10;
 * const int arrSize = numElements * 2 + 2;
 * Any veh[arrSize];
 * //0 index is the size of the array
 * veh[0] = numElements;
 * int count = PED::GET_PED_NEARBY_VEHICLES(PLAYER::PLAYER_PED_ID(), veh);
 * if (veh != NULL)
 * {
 * //Simple loop to go through results
 * for (int i = 0; i < count; i++)
 * {
 * int offsettedID = i * 2 + 2;
 * //Make sure it exists
 * if (veh[offsettedID] != NULL && ENTITY::DOES_ENTITY_EXIST(veh[offsettedID]))
 * {
 * //Do something
 * }
 * }
 * }
 * Here's the right way to do it (console and pc):
 * pastebin.com/SsFej963
 */
window.GetPedNearbyVehicles = function (ped, sizeAndVehs) {
	return _in(0xcff869cb, 0xfa210d82, ped, _ii(sizeAndVehs) /* may be optional */, _r, _ri);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetPedPaletteVariation = function (ped, componentId) {
	return _in(0xe3dd5f2a, 0x84b42281, ped, componentId, _r, _ri);
};

/**
 * -1: no landing
 * 0: landing on both feet
 * 1: stumbling
 * 2: rolling
 * 3: ragdoll
 */
window.GetPedParachuteLandingType = function (ped) {
	return _in(0x8b9f1fc6, 0xae8166c0, ped, _r, _ri);
};

/**
 * Returns:
 * -1: Normal
 * 0: Wearing parachute on back
 * 1: Parachute opening
 * 2: Parachute open
 * 3: Falling to doom (e.g. after exiting parachute)
 * Normal means no parachute?
 */
window.GetPedParachuteState = function (ped) {
	return _in(0x79cfd982, 0x7cc979b6, ped, _r, _ri);
};

window.GetPedParachuteTintIndex = function (ped, outTintIndex) {
	return _in(0xeaf5f7e5, 0xae7c6c9d, ped, _ii(outTintIndex) /* may be optional */);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetPedPropIndex = function (ped, componentId) {
	return _in(0x898cc20e, 0xa75bacd8, ped, componentId, _r, _ri);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetPedPropTextureIndex = function (ped, componentId) {
	return _in(0xe131a286, 0x26f81ab2, ped, componentId, _r, _ri);
};

window.GetPedRagdollBoneIndex = function (ped, bone) {
	return _in(0x2057ef81, 0x3397a772, ped, bone, _r, _ri);
};

window.GetPedRelationshipGroupDefaultHash = function (ped) {
	return _in(0x42fdd0f0, 0x17b1e38e, ped, _r, _ri);
};

window.GetPedRelationshipGroupHash = function (ped) {
	return _in(0x7dbdd048, 0x62d95f04, ped, _r, _ri);
};

window.GetPedResetFlag = function (ped, flagId) {
	return _in(0xaf9e59b1, 0xb1fbf2a0, ped, flagId, _r);
};

/**
 * Returns the Entity (Ped, Vehicle, or ?Object?) that killed the 'ped'
 * Is best to check if the Ped is dead before asking for its killer.
 */
window.GetPedSourceOfDeath = function (ped) {
	return _in(0x93c8b64d, 0xeb84728c, ped, _r, _ri);
};
window.GetPedKiller = window.GetPedSourceOfDeath;

/**
 * Returns whether the entity is in stealth mode
 */
window.GetPedStealthMovement = function (ped) {
	return _in(0x7c2ac9ca, 0x66575fbf, ped, _r);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.GetPedTextureVariation = function (ped, componentId) {
	return _in(0x04a355e0, 0x41e004e6, ped, componentId, _r, _ri);
};

/**
 * Ped Types: (ordered by return priority)
 * Michael = 0
 * Franklin = 1
 * Trevor = 2
 * Army = 29
 * Animal = 28
 * SWAT = 27
 * LSFD = 21
 * Paramedic = 20
 * Cop = 6
 * Male = 4
 * Female = 5
 * Human = 26
 * Note/Exception
 * hc_gunman : 4 // Mix male and female
 * hc_hacker : 4 // Mix male and female
 * mp_f_misty_01 : 4 // Female character
 * s_f_y_ranger_01 : 5 // Ranger
 * s_m_y_ranger_01 : 4 // Ranger
 * s_m_y_uscg_01 : 6 // US Coast Guard
 */
window.GetPedType = function (ped) {
	return _in(0xff059e1e, 0x4c01e63c, ped, _r, _ri);
};

/**
 * Quick disassembly and test seems to indicate that this native gets the Ped currently using the specified door.
 */
window.GetPedUsingVehicleDoor = function (vehicle, doorIndex) {
	return _in(0x218297bf, 0x0cfd853b, vehicle, doorIndex, _r, _ri);
};
window.N_0x218297bf0cfd853b = window.GetPedUsingVehicleDoor;

window.GetPedWaypointDistance = function (p0) {
	return _in(0xe6a877c6, 0x4caf1bc5, p0, _r, _rf);
};

/**
 * Returns the progress percent to current waypoint.
 */
window.GetPedWaypointProgress = function (ped) {
	return _in(0x2720aaa7, 0x5001e094, ped, _r, _ri);
};

window.GetPedWeaponTintIndex = function (ped, weaponHash) {
	return _in(0x2b9eedc0, 0x7bd06b9f, ped, _ch(weaponHash), _r, _ri);
};

window.GetPedWeapontypeInSlot = function (ped, weaponSlot) {
	return _in(0xeffed78e, 0x9011134d, ped, _ch(weaponSlot), _r, _ri);
};

/**
 * gtaforums.com/topic/885580-ped-headshotmugshot-txd/
 */
window.GetPedheadshotTxdString = function (handle) {
	return _in(0xdb4eacd4, 0xad0a5d6b, handle, _r, _s);
};

window.GetPedsJacker = function (ped) {
	return _in(0x9b128dc3, 0x6c1e04cf, ped, _r, _ri);
};

window.GetPhoneGestureAnimCurrentTime = function (ped) {
	return _in(0x47619abe, 0x8b268c60, ped, _r, _rf);
};

window.GetPhoneGestureAnimTotalTime = function (ped) {
	return _in(0x1ee0f68a, 0x7c25dec6, ped, _r, _rf);
};

window.GetPickupCoords = function (pickup) {
	return _in(0x225b8b35, 0xc88029b3, pickup, _r, _rv);
};

/**
 * returns pickup hash.
 */
window.GetPickupHash = function (pickupHash) {
	return _in(0x5eaad83f, 0x8cfb4575, pickupHash, _r, _ri);
};
window.N_0x5eaad83f8cfb4575 = window.GetPickupHash;

window.GetPickupObject = function (pickup) {
	return _in(0x5099bc55, 0x630b25ae, pickup, _r, _ri);
};
window.N_0x5099bc55630b25ae = window.GetPickupObject;

window.GetPlayerAdvancedModifierPrivileges = function (p0) {
	return _in(0xcd67ad04, 0x1a394c9c, p0, _r, _s);
};
window.N_0xcd67ad041a394c9c = window.GetPlayerAdvancedModifierPrivileges;
window.GetContentUserId = window.GetPlayerAdvancedModifierPrivileges;

window.GetPlayerCurrentStealthNoise = function (player) {
	return _in(0x2f395d61, 0xf3a1f877, player, _r, _rf);
};

window.GetPlayerFromServerId = function (serverId) {
	return _in(0x00000000, 0x344ea166, serverId, _r, _ri);
};

/**
 * Returns the group ID the player is member of.
 */
window.GetPlayerGroup = function (player) {
	return _in(0x0d127585, 0xf77030af, player, _r, _ri);
};

window.GetPlayerHasReserveParachute = function (player) {
	return _in(0x5ddfe2ff, 0x727f3ca3, player, _r);
};

/**
 * Called 5 times in the scripts. All occurrences found in b617d, sorted alphabetically and identical lines removed:
 * AUDIO::GET_PLAYER_HEADSET_SOUND_ALTERNATE("INOUT", 0.0);
 * AUDIO::GET_PLAYER_HEADSET_SOUND_ALTERNATE("INOUT", 1.0);
 */
window.GetPlayerHeadsetSoundAlternate = function (p0, p1) {
	return _in(0xbcc29f93, 0x5ed07688, _ts(p0), _fv(p1));
};

/**
 * Returns the same as PLAYER_ID and NETWORK_PLAYER_ID_TO_INT
 */
window.GetPlayerIndex = function () {
	return _in(0xa5edc40e, 0xf369b48d, _r, _ri);
};

/**
 * Returns the Player's Invincible status.
 * This function will always return false if 0x733A643B5B0C53C1 is used to set the invincibility status. To always get the correct result, use this:
 * bool IsPlayerInvincible(Player player)
 * {
 * auto addr = getScriptHandleBaseAddress(GET_PLAYER_PED(player));
 * if (addr)
 * {
 * DWORD flag = *(DWORD *)(addr + 0x188);
 * return ((flag & (1 << 8)) != 0) || ((flag & (1 << 9)) != 0);
 * }
 * return false;
 * }
 * ============================================================
 * This has bothered me for too long, whoever may come across this, where did anyone ever come up with this made up hash? 0x733A643B5B0C53C1 I've looked all over old hash list, and this nativedb I can not find that PC hash anywhere. What native name is it now or was it?
 */
window.GetPlayerInvincible = function (player) {
	return _in(0xb721981b, 0x2b939e07, player, _r);
};

window.GetPlayerMaxArmour = function (player) {
	return _in(0x92659b4c, 0xe1863cb3, player, _r, _ri);
};

/**
 * Returns the players name
 */
window.GetPlayerName = function (player) {
	return _in(0x6d0de6a7, 0xb5da71f8, player, _r, _s);
};

window.GetPlayerParachutePackTintIndex = function (player, tintIndex) {
	return _in(0x6e9c742f, 0x340ce5a2, player, _ii(tintIndex) /* may be optional */);
};

window.GetPlayerParachuteSmokeTrailColor = function (player) {
	return _in(0xef56dbab, 0xd3cd4887, player, _i, _i, _i);
};

/**
 * Tints:
 * None = -1,
 * Rainbow = 0,
 * Red = 1,
 * SeasideStripes = 2,
 * WidowMaker = 3,
 * Patriot = 4,
 * Blue = 5,
 * Black = 6,
 * Hornet = 7,
 * AirFocce = 8,
 * Desert = 9,
 * Shadow = 10,
 * HighAltitude = 11,
 * Airbone = 12,
 * Sunrise = 13,
 */
window.GetPlayerParachuteTintIndex = function (player, tintIndex) {
	return _in(0x75d3f7a1, 0xb0d9b145, player, _ii(tintIndex) /* may be optional */);
};

/**
 * Gets the ped for a specified player index.
 * @param playerId The player index, or -1 to get the local player ped.
 * @return The specified player's ped, or 0 if invalid.
 */
window.GetPlayerPed = function (playerId) {
	return _in(0x43a66c31, 0xc68491c0, playerId, _r, _ri);
};

window.GetPlayerPedIsFollowing = function (ped) {
	return _in(0x6a3975de, 0xa89f9a17, ped, _r, _ri);
};

/**
 * Does the same like PLAYER::GET_PLAYER_PED<br/>
 */
window.GetPlayerPedScriptIndex = function (Player) {
	return _in(0x50fac3a3, 0xe030a6e1, Player, _r, _ri);
};

window.GetPlayerRadioStationGenre = function () {
	return _in(0xa571991a, 0x7fe6cceb, _r, _ri);
};

/**
 * Returns 255 (radio off index) if the function fails.
 */
window.GetPlayerRadioStationIndex = function () {
	return _in(0xe8af77c4, 0xc06adc93, _r, _ri);
};

/**
 * Returns active radio station name
 */
window.GetPlayerRadioStationName = function () {
	return _in(0xf6d733c3, 0x2076ad03, _r, _s);
};

/**
 * Tints:
 * None = -1,
 * Rainbow = 0,
 * Red = 1,
 * SeasideStripes = 2,
 * WidowMaker = 3,
 * Patriot = 4,
 * Blue = 5,
 * Black = 6,
 * Hornet = 7,
 * AirFocce = 8,
 * Desert = 9,
 * Shadow = 10,
 * HighAltitude = 11,
 * Airbone = 12,
 * Sunrise = 13,
 */
window.GetPlayerReserveParachuteTintIndex = function (player, index) {
	return _in(0xd5a016bc, 0x3c09cf40, player, _ii(index) /* may be optional */);
};

/**
 * Returns RGB color of the player
 */
window.GetPlayerRgbColour = function (Player) {
	return _in(0xe902ef95, 0x1dce178f, Player, _i, _i, _i);
};

window.GetPlayerServerId = function (player) {
	return _in(0x00000000, 0x4d97bcc7, player, _r, _ri);
};

window.GetPlayerShortSwitchState = function () {
	return _in(0x20f898a5, 0xd9782800, _r, _ri);
};

window.GetPlayerSprintStaminaRemaining = function (player) {
	return _in(0x3f9f16f8, 0xe65a7ed7, player, _r, _rf);
};

window.GetPlayerSprintTimeRemaining = function (player) {
	return _in(0x1885bc9b, 0x108b4c99, player, _r, _rf);
};

window.GetPlayerSwitchState = function () {
	return _in(0x47055530, 0x0d10b2a5, _r, _ri);
};

window.GetPlayerSwitchType = function () {
	return _in(0xb3c94a90, 0xd9fc9e62, _r, _ri);
};

/**
 * Assigns the handle of locked-on melee target to *entity that you pass it.
 * Returns false if no entity found.
 */
window.GetPlayerTargetEntity = function (player, entity) {
	return _in(0x13ede1a5, 0xdbf797c9, player, _ii(entity) /* may be optional */, _r);
};

/**
 * Gets the player's team.
 * Does nothing in singleplayer.
 */
window.GetPlayerTeam = function (player) {
	return _in(0x37039302, 0xf4e0a008, player, _r, _ri);
};

window.GetPlayerUnderwaterTimeRemaining = function (player) {
	return _in(0xa1fcf8e6, 0xaf40b731, player, _r, _rf);
};

window.GetPlayerWantedCentrePosition = function (player) {
	return _in(0x0c92ba89, 0xf1af26f8, player, _r, _rv);
};

window.GetPlayerWantedLevel = function (player) {
	return _in(0xe28e5478, 0x8ce8f12d, player, _r, _ri);
};

/**
 * Alternative: GET_VEHICLE_PED_IS_IN(PLAYER_PED_ID(), 1);
 */
window.GetPlayersLastVehicle = function () {
	return _in(0xb6997a7e, 0xb3f5c8c0, _r, _ri);
};

window.GetPositionInRecording = function (p0) {
	return _in(0x2dacd605, 0xfc681475, p0, _r, _rf);
};

/**
 * p1 is some kind of tolerance
 */
window.GetPositionOfVehicleRecordingAtTime = function (p0, p1, p2) {
	return _in(0xd242728a, 0xa6f0fba2, p0, _fv(p1), _ts(p2), _r, _rv);
};

/**
 * Gets system time as year, month, day, hour, minute and second.
 * Example usage:
 * int year;
 * int month;
 * int day;
 * int hour;
 * int minute;
 * int second;
 * TIME::GET_POSIX_TIME(&year, &month, &day, &hour, &minute, &second);
 */
window.GetPosixTime = function () {
	return _in(0xda488f29, 0x9a5b164e, _i, _i, _i, _i, _i, _i);
};

/**
 * Returns current weather name hash
 */
window.GetPrevWeatherTypeHashName = function () {
	return _in(0x564b884a, 0x05ec45a3, _r, _ri);
};
window.GetPrevWeatherType = window.GetPrevWeatherTypeHashName;

/**
 * gtaforums.com/topic/799843-stats-profile-settings/
 */
window.GetProfileSetting = function (profileSetting) {
	return _in(0xc488ff23, 0x56ea7791, profileSetting, _r, _ri);
};

/**
 * only documented to be continued...
 * Dr. Underscore (1/6/18):
 * Exactly like _GET_PROJECTILE_NEAR_PED_COORDS (_0xDFB4138EEFED7B81), but it gives us the Entity that was found aswell.
 * p6 is (most likely) ownedByPlayer. (see IS_PROJECTILE_IN_AREA for info)
 */
window.GetProjectileNearPed = function (ped, projHash, radius, ownedByPlayer) {
	return _in(0x82fde6a5, 0x7ee4ee44, ped, _ch(projHash), _fv(radius), _v, _i, ownedByPlayer, _r);
};
window.N_0x82fde6a57ee4ee44 = window.GetProjectileNearPed;

/**
 * From a quick disassembly I can say that this has something to do with weapons.
 * Added params according to what I could see in IDA.
 * Dr. Underscore (1/6/18):
 * Returns if any projectiles of projHash type are in a radius around this ped. If true, projPos is filled with the position of that entity.
 * This native was only ever used with projectiles, but may not be limited to.
 * p4 isn't an Entity*, it's actually a Vector3*, which outputs the position of the found entity.
 * p5 is (most likely) ownedByPlayer. (see IS_PROJECTILE_IN_AREA for info)
 */
window.GetProjectileNearPedCoords = function (ped, projHash, radius, ownedByPlayer) {
	return _in(0xdfb4138e, 0xefed7b81, ped, _ch(projHash), _fv(radius), _v, ownedByPlayer, _r);
};
window.N_0xdfb4138eefed7b81 = window.GetProjectileNearPedCoords;

/**
 * outfit = a structure passing though it - see GET_SHOP_PED_QUERY_OUTFIT
 * slot - outfit slot
 * item - hold 3 ints in a struct, you can use Vector3 structure
 * GET_SHOP_PED_???
 */
window.GetPropFromOutfit = function (outfit, slot, item) {
	return _in(0x19f2a026, 0xedf0013f, outfit, slot, _ii(item) /* may be optional */, _r);
};

window.GetPstatBoolHash = function (index, spStat, charStat, character) {
	return _in(0x80c75307, 0xb1c42837, index, spStat, charStat, character, _r, _ri);
};
window.N_0x80c75307b1c42837 = window.GetPstatBoolHash;

window.GetPstatIntHash = function (index, spStat, charStat, character) {
	return _in(0x61e111e3, 0x23419e07, index, spStat, charStat, character, _r, _ri);
};
window.N_0x61e111e323419e07 = window.GetPstatIntHash;

/**
 * Returns String with radio station name.
 */
window.GetRadioStationName = function (radioStation) {
	return _in(0xb28eca15, 0x046ca8b9, radioStation, _r, _s);
};

window.GetRainLevel = function () {
	return _in(0x96695e36, 0x8ad855f3, _r, _ri);
};

window.GetRandomEventFlag = function () {
	return _in(0xd2d57f1d, 0x764117b1, _r, _ri);
};

window.GetRandomFloatInRange = function (startRange, endRange) {
	return _in(0x313ce587, 0x9ceb6fcd, _fv(startRange), _fv(endRange), _r, _rf);
};

/**
 * Another extremely useful native.
 * You can use it simply like:
 * if (GAMEPLAY::GET_RANDOM_INT_IN_RANGE(0, 2))
 */
window.GetRandomIntInRange = function (startRange, endRange) {
	return _in(0xd53343aa, 0x4fb7dd28, startRange, endRange, _r, _ri);
};

/**
 * Gets a random ped in the x/y/zRadius near the x/y/z coordinates passed.
 * Ped Types:
 * Any = -1
 * Player = 1
 * Male = 4
 * Female = 5
 * Cop = 6
 * Human = 26
 * SWAT = 27
 * Animal = 28
 * Army = 29
 */
window.GetRandomPedAtCoord = function (x, y, z, xRadius, yRadius, zRadius, pedType) {
	return _in(0x876046a8, 0xe3a4b71c, _fv(x), _fv(y), _fv(z), _fv(xRadius), _fv(yRadius), _fv(zRadius), pedType, _r, _ri);
};

window.GetRandomVehicleBackBumperInSphere = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xb50807ea, 0xbe20a8dc, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, p5, p6, _r, _ri);
};

window.GetRandomVehicleFrontBumperInSphere = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xc5574e0a, 0xeb86ba68, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, p5, p6, _r, _ri);
};

/**
 * Gets a random vehicle in a sphere at the specified position, of the specified radius.
 * x: The X-component of the position of the sphere.
 * y: The Y-component of the position of the sphere.
 * z: The Z-component of the position of the sphere.
 * radius: The radius of the sphere. Max is 9999.9004.
 * modelHash: The vehicle model to limit the selection to. Pass 0 for any model.
 * flags: The bitwise flags that modifies the behaviour of this function.
 */
window.GetRandomVehicleInSphere = function (x, y, z, radius, modelHash, flags) {
	return _in(0x386f6ce5, 0xbaf6091c, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(modelHash), flags, _r, _ri);
};

/**
 * Not present in the retail version! It's just a nullsub.
 * p0 always true (except in one case)
 * p1 a random vehicle hash loaded in memory
 * p2 0 if success, -1 if failed
 */
window.GetRandomVehicleModelInMemory = function (p0) {
	return _in(0x055bf0ac, 0x0c34f4fd, p0, _i, _i);
};

window.GetRandomVehicleNode = function (x, y, z, radius, p4, p5, p6) {
	return _in(0x93e0db84, 0x40b73a7d, _fv(x), _fv(y), _fv(z), _fv(radius), p4, p5, p6, _v, _i, _r);
};

/**
 * Returns all commands that are registered in the command system.
 * The data returned adheres to the following layout:
 * ```
 * [
 * {
 * "name": "cmdlist"
 * },
 * {
 * "name": "command1"
 * }
 * ]
 * ```
 * @return An object containing registered commands.
 */
window.GetRegisteredCommands = function () {
	return window.msgpack_unpack(_in(0x00000000, 0xd4bef069, _r, _ro));
};

/**
 * Gets the relationship between two groups. This should be called twice (once for each group).
 * Relationship types:
 * 0 = Companion
 * 1 = Respect
 * 2 = Like
 * 3 = Neutral
 * 4 = Dislike
 * 5 = Hate
 * 255 = Pedestrians
 * Example:
 * PED::GET_RELATIONSHIP_BETWEEN_GROUPS(l_1017, 0xA49E591C);
 * PED::GET_RELATIONSHIP_BETWEEN_GROUPS(0xA49E591C, l_1017);
 */
window.GetRelationshipBetweenGroups = function (group1, group2) {
	return _in(0x9e6b7006, 0x1662ae5c, _ch(group1), _ch(group2), _r, _ri);
};

/**
 * Gets the relationship between two peds. This should be called twice (once for each ped).
 * Relationship types:
 * 0 = Companion
 * 1 = Respect
 * 2 = Like
 * 3 = Neutral
 * 4 = Dislike
 * 5 = Hate
 * 255 = Pedestrians
 * (Credits: Inco)
 * Example:
 * PED::GET_RELATIONSHIP_BETWEEN_PEDS(2, l_1017, 0xA49E591C);
 * PED::GET_RELATIONSHIP_BETWEEN_PEDS(2, 0xA49E591C, l_1017);
 */
window.GetRelationshipBetweenPeds = function (ped1, ped2) {
	return _in(0xeba5ad3a, 0x0eaf7121, ped1, ped2, _r, _ri);
};

window.GetRenderingCam = function () {
	return _in(0x5234f9f1, 0x0919eaba, _r, _ri);
};

window.GetResourceByFindIndex = function (findIndex) {
	return _in(0x00000000, 0x387246b7, findIndex, _r, _s);
};

window.GetResourceKvpFloat = function (key) {
	return _in(0x00000000, 0x35bdceea, _ts(key), _r, _rf);
};

window.GetResourceKvpInt = function (key) {
	return _in(0x00000000, 0x557b586a, _ts(key), _r, _ri);
};

window.GetResourceKvpString = function (key) {
	return _in(0x00000000, 0x5240da5a, _ts(key), _r, _s);
};

/**
 * Gets the metadata value at a specified key/index from a resource's manifest.
 * See also: [Resource manifest](https://docs.fivem.net/resources/manifest/)
 * @param resourceName The resource name.
 * @param metadataKey The key in the resource manifest.
 * @param index The value index, in a range from [0..GET_NUM_RESOURCE_METDATA-1].
 */
window.GetResourceMetadata = function (resourceName, metadataKey, index) {
	return _in(0x00000000, 0x964bab1d, _ts(resourceName), _ts(metadataKey), index, _r, _s);
};

/**
 * Returns the current state of the specified resource.
 * @param resourceName The name of the resource.
 * @return The resource state. One of `"missing", "started", "starting", "stopped", "stopping", "uninitialized" or "unknown"`.
 */
window.GetResourceState = function (resourceName) {
	return _in(0x00000000, 0x4039b485, _ts(resourceName), _r, _s);
};

/**
 * Gets the room hash key from the room that the specified entity is in. Each room in every interior has a unique key. Returns 0 if the entity is outside.
 */
window.GetRoomKeyFromEntity = function (entity) {
	return _in(0x47c2a06d, 0x4f5f424b, entity, _r, _ri);
};

/**
 * Returns the room hash key from the current gameplay cam.
 */
window.GetRoomKeyFromGameplayCam = function () {
	return _in(0xa6575914, 0xd2a0b450, _r, _ri);
};
window.N_0xa6575914d2a0b450 = window.GetRoomKeyFromGameplayCam;

/**
 * Return the root content id of a job.
 */
window.GetRootContentId = function (p0) {
	return _in(0xc0173d6b, 0xff4e0348, p0, _r, _s);
};
window.N_0xc0173d6bff4e0348 = window.GetRootContentId;

window.GetRopeLastVertexCoord = function (rope) {
	return _in(0x21bb0fbd, 0x3e217c2d, rope, _r, _ri);
};

/**
 * Get a rope's length.  Can be modified with ROPE_FORCE_LENGTH
 */
window.GetRopeLength = function (rope) {
	return _in(0x73040398, 0xdff9a4a6, rope, _r, _rf);
};

window.GetRopeVertexCoord = function (rope, vertex) {
	return _in(0xea61ca8e, 0x80f09e4d, rope, vertex, _r, _rv);
};

window.GetRopeVertexCount = function (rope) {
	return _in(0x3655f544, 0xcd30f0b5, rope, _r, _ri);
};

window.GetRotationOfVehicleRecordingAtTime = function (p0, p1, p2) {
	return _in(0x2058206f, 0xbe79a8ad, p0, _fv(p1), _ii(p2) /* may be optional */, _r, _ri);
};

/**
 * Gets the height of the specified runtime texture.
 * @param tex A handle to the runtime texture.
 * @return The height in pixels.
 */
window.GetRuntimeTextureHeight = function (tex) {
	return _in(0x00000000, 0x3574aace, tex, _r, _ri);
};

/**
 * Gets the row pitch of the specified runtime texture, for use when creating data for `SET_RUNTIME_TEXTURE_ARGB_DATA`.
 * @param tex A handle to the runtime texture.
 * @return The row pitch in bytes.
 */
window.GetRuntimeTexturePitch = function (tex) {
	return _in(0x00000000, 0xca0a085f, tex, _r, _ri);
};

/**
 * Gets the width of the specified runtime texture.
 * @param tex A handle to the runtime texture.
 * @return The width in pixels.
 */
window.GetRuntimeTextureWidth = function (tex) {
	return _in(0x00000000, 0xc9f55558, tex, _r, _ri);
};

/**
 * When onGround == true outPosition is a position located on the nearest pavement.
 * When a safe coord could not be found the result of a function is false and outPosition == Vector3.Zero.
 * In the scripts these flags are used: 0, 14, 12, 16, 20, 21, 28. 0 is most commonly used, then 16.
 * 16 works for me, 0 crashed the script.
 */
window.GetSafeCoordForPed = function (x, y, z, onGround, flags) {
	return _in(0xb61c8e87, 0x8a4199ca, _fv(x), _fv(y), _fv(z), onGround, _v, flags, _r);
};

window.GetSafePickupCoords = function (x, y, z, p3, p4) {
	return _in(0x6e16bc25, 0x03ff1ff0, _fv(x), _fv(y), _fv(z), p3, p4, _r, _rv);
};

/**
 * Gets the scale of safe zone. if the safe zone size scale is max, it will return 1.0.
 */
window.GetSafeZoneSize = function () {
	return _in(0xbaf107b6, 0xbb2c97f0, _r, _rf);
};

/**
 * Seems to take data that is returned from "_POP_SCALEFORM_MOVIE_FUNCTION" and checks to see if it's not null/empty.
 * "agency_heist3b.ysc", line 71836:
 * if (CONTROLS::IS_CONTROL_JUST_PRESSED(2, 201) || CONTROLS::IS_CONTROL_JUST_PRESSED(2, 237)) {
 * GRAPHICS::_PUSH_SCALEFORM_MOVIE_FUNCTION(l_46, "SET_INPUT_EVENT_SELECT");
 * l_45 = GRAPHICS::_POP_SCALEFORM_MOVIE_FUNCTION();
 * }
 * if (GRAPHICS::_0x768FF8961BA904D6(l_45)) {
 * v_13 = GRAPHICS::_0x2DE7EFA66B906036(l_45);
 * if (v_13 == 6) {
 * sub_73269(a_0);
 * }
 * }
 */
window.GetScaleformMovieFunctionReturnBool = function (method_return) {
	return _in(0x768ff896, 0x1ba904d6, method_return, _r);
};
window.N_0x768ff8961ba904d6 = window.GetScaleformMovieFunctionReturnBool;

/**
 * Needs a bit more research, but it seems to return an int.
 * Testing with the scaleform "HACKING_PC" it seems to return an int depending on the clicked App/Program ID
 * "agency_heist3b.ysc", line 71836:
 * if (CONTROLS::IS_CONTROL_JUST_PRESSED(2, 201) || CONTROLS::IS_CONTROL_JUST_PRESSED(2, 237)) {
 * GRAPHICS::_PUSH_SCALEFORM_MOVIE_FUNCTION(l_46, "SET_INPUT_EVENT_SELECT");
 * l_45 = GRAPHICS::_POP_SCALEFORM_MOVIE_FUNCTION();
 * }
 * if (GRAPHICS::_0x768FF8961BA904D6(l_45)) {
 * v_13 = GRAPHICS::_0x2DE7EFA66B906036(l_45);
 * if (v_13 == 6) {
 * sub_73269(a_0);
 * }
 * }
 */
window.GetScaleformMovieFunctionReturnInt = function (method_return) {
	return _in(0x2de7efa6, 0x6b906036, method_return, _r, _ri);
};
window.N_0x2de7efa66b906036 = window.GetScaleformMovieFunctionReturnInt;

/**
 * This returns the name of the scaleform movie.
 */
window.GetScaleformMovieFunctionReturnString = function (method_return) {
	return _in(0xe1e25882, 0x9a885245, method_return, _r, _s);
};
window.SittingTv = window.GetScaleformMovieFunctionReturnString;

/**
 * Convert a world coordinate into its relative screen coordinate.  (WorldToScreen)
 * Returns a boolean; whether or not the operation was successful. It will return false if the coordinates given are not visible to the rendering camera.
 * For .NET users...
 * VB:
 * Public Shared Function World3DToScreen2d(pos as vector3) As Vector2
 * Dim x2dp, y2dp As New Native.OutputArgument
 * Native.Function.Call(Of Boolean)(Native.Hash.GET_SCREEN_COORD_FROM_WORLD_COORD , pos.x, pos.y, pos.z, x2dp, y2dp)
 * Return New Vector2(x2dp.GetResult(Of Single), y2dp.GetResult(Of Single))
 * End Function
 * C#:
 * Vector2 World3DToScreen2d(Vector3 pos)
 * {
 * var x2dp = new OutputArgument();
 * var y2dp = new OutputArgument();
 * Function.Call<bool>(Hash.GET_SCREEN_COORD_FROM_WORLD_COORD , pos.X, pos.Y, pos.Z, x2dp, y2dp);
 * return new Vector2(x2dp.GetResult<float>(), y2dp.GetResult<float>());
 * }
 * //USE VERY SMALL VALUES FOR THE SCALE OF RECTS/TEXT because it is dramatically larger on screen than in 3D, e.g '0.05' small.
 * Used to be called _WORLD3D_TO_SCREEN2D
 * I thought we lost you from the scene forever. It does seem however that calling SET_DRAW_ORIGIN then your natives, then ending it. Seems to work better for certain things such as keeping boxes around people for a predator missile e.g.
 */
window.GetScreenCoordFromWorldCoord = function (worldX, worldY, worldZ) {
	return _in(0x34e82f05, 0xdf2974f5, _fv(worldX), _fv(worldY), _fv(worldZ), _f, _f, _r);
};
window.World3dToScreen2d = window.GetScreenCoordFromWorldCoord;

/**
 * Returns whether the specified screen effect is active.
 * See the effects list in _START_SCREEN_EFFECT
 * Example and list of screen FX: www.pastebin.com/dafBAjs0
 */
window.GetScreenEffectIsActive = function (effectName) {
	return _in(0x36ad3e69, 0x0da5aceb, _ts(effectName), _r);
};

/**
 * int screenresx,screenresy;
 * GET_SCREEN_RESOLUTION(&screenresx,&screenresy);
 * Hardcoded to always return 1280 x 720
 */
window.GetScreenResolution = function () {
	return _in(0x888d57e4, 0x07e63624, _i, _i);
};

/**
 * Calculates the effective X/Y fractions when applying the values set by `SET_SCRIPT_GFX_ALIGN` and
 * `SET_SCRIPT_GFX_ALIGN_PARAMS`.
 * @param x The input X coordinate.
 * @param y The input Y coordinate.
 * @param calculatedX A pointer to the calculated X value.
 * @param calculatedY A pointer to the calculated Y value.
 */
window.GetScriptGfxPosition = function (x, y) {
	return _in(0x6dd8f5aa, 0x635eb4b2, _fv(x), _fv(y), _f, _f);
};
window.N_0x6dd8f5aa635eb4b2 = window.GetScriptGfxPosition;

/**
 * Gets the status of a script-assigned task. The hash does not seem to match the actual native name, but is assigned hardcoded from the executable during task creation.
 * Statuses are specific to tasks, in addition '7' means the specified task is not assigned to the ped.
 * A few hashes found in the executable (although not a complete list) can be found at pastebin.com/R9iK6M9W as it was too long for this wiki.
 */
window.GetScriptTaskStatus = function (targetPed, taskHash) {
	return _in(0x77f1beb8, 0x863288d5, targetPed, _ch(taskHash), _r, _ri);
};

window.GetScriptedCoverPointCoords = function (coverpoint) {
	return _in(0x594a1028, 0xfc2a3e85, coverpoint, _r, _rv);
};

window.GetSeatPedIsTryingToEnter = function (ped) {
	return _in(0x6f4c85ac, 0xd641bcd2, ped, _r, _ri);
};

/**
 * Returns the hash of the weapon.
 * var num7 = WEAPON::GET_SELECTED_PED_WEAPON(num4);
 * sub_27D3(num7);
 * switch (num7)
 * {
 * case 0x24B17070:
 * Also see WEAPON::GET_CURRENT_PED_WEAPON. Difference?
 * -------------------------------------------------------------------------
 * The difference is that GET_SELECTED_PED_WEAPON simply returns the ped's current weapon hash but GET_CURRENT_PED_WEAPON also checks the weapon object and returns true if the hash of the weapon object equals the weapon hash
 */
window.GetSelectedPedWeapon = function (ped) {
	return _in(0x0a6db496, 0x5674d243, ped, _r, _ri);
};

/**
 * returned values:
 * 0 to 7 = task that's currently in progress, 0 meaning the first one.
 */
window.GetSequenceProgress = function (ped) {
	return _in(0x00a9010c, 0xfe1e3533, ped, _r, _ri);
};

/**
 * Parameters:
 * rayHandle - Ray Handle from a casted ray, as returned by CAST_RAY_POINT_TO_POINT
 * hit - Where to store whether or not it hit anything. False is when the ray reached its destination.
 * endCoords - Where to store the world-coords of where the ray was stopped (by hitting its desired max range or by colliding with an entity/the map)
 * surfaceNormal - Where to store the surface-normal coords (NOT relative to the game world) of where the entity was hit by the ray
 * entityHit - Where to store the handle of the entity hit by the ray
 * Returns:
 * Result? Some type of enum.
 * NOTE: To get the offset-coords of where the ray hit relative to the entity that it hit (which is NOT the same as surfaceNormal), you can use these two natives:
 * Vector3 offset = ENTITY::GET_OFFSET_FROM_ENTITY_GIVEN_WORLD_COORDS(entityHit, endCoords.x, endCoords.y, endCoords.z);
 * Vector3 entitySpotCoords = ENTITY::GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(entityHit, offset.x, offset.y, offset.z);
 * Use ENTITY::GET_ENTITY_TYPE(entityHit) to quickly distinguish what type of entity you hit (ped/vehicle/object - 1/2/3)
 */
window.GetShapeTestResult = function (rayHandle) {
	return _in(0x3d87450e, 0x15d98694, rayHandle, _i /* actually bool */, _v, _v, _i, _r, _ri);
};
window.GetRaycastResult = window.GetShapeTestResult;

/**
 * behaves exactly the same way as GET_SHAPE_TEST_RESULT except it has one extra parameter (_materialHash).
 * Quick disassembly seems to indicate that the unknown is a hash. EDIT: Seems to be the hash of the hit material or surface type.
 * found a materialFX.dat list of them but not sure if it has to do with this native yet.
 * materials (full list): pastebin.com/gyHjsYBK
 */
window.GetShapeTestResultEx = function (rayHandle) {
	return _in(0x65287525, 0xd951f6be, rayHandle, _i /* actually bool */, _v, _v, _i, _i, _r, _ri);
};
window.N_0x65287525d951f6be = window.GetShapeTestResultEx;

window.GetShopPedComponent = function (p0, p1) {
	return _in(0x74c0e2a5, 0x7ec66760, _ch(p0), _ii(p1) /* may be optional */);
};

window.GetShopPedOutfit = function (p0, p1) {
	return _in(0xb7952076, 0xe444979d, p0, _ii(p1) /* may be optional */);
};

window.GetShopPedOutfitLocate = function (p0) {
	return _in(0x073ca26b, 0x079f956e, p0, _r, _ri);
};
window.N_0x073ca26b079f956e = window.GetShopPedOutfitLocate;

window.GetShopPedQueryComponent = function (componentId, outComponent) {
	return _in(0x249e310b, 0x2d920699, componentId, _ii(outComponent) /* may be optional */);
};

/**
 * struct Outfit_s
 * {
 * int mask, torso, pants, parachute, shoes, misc1, tops1, armour, crew, tops2, hat, glasses, earpiece;
 * int maskTexture, torsoTexture, pantsTexture, parachuteTexture, shoesTexture, misc1Texture, tops1Texture,
 * armourTexture, crewTexture, tops2Texture, hatTexture, glassesTexture, earpieceTexture;
 * };
 */
window.GetShopPedQueryOutfit = function (p0, outfit) {
	return _in(0x6d793f03, 0xa631fe56, p0, _ii(outfit) /* may be optional */);
};

window.GetShopPedQueryProp = function (p0, p1) {
	return _in(0xde44a009, 0x99b2837d, p0, _ii(p1) /* may be optional */);
};

window.GetSnowLevel = function () {
	return _in(0xc5868a96, 0x6e5be3ae, _r, _ri);
};

window.GetSoundId = function () {
	return _in(0x430386fe, 0x9bf80b45, _r, _ri);
};

window.GetSoundIdFromNetworkId = function (netId) {
	return _in(0x75262fd1, 0x2d0a1c84, netId, _r, _ri);
};
window.N_0x75262fd12d0a1c84 = window.GetSoundIdFromNetworkId;

/**
 * locked is 0 if no door is found
 * locked is 0 if door is unlocked
 * locked is 1 if door is found and unlocked.
 * -------------
 * the locked bool is either 0(unlocked)(false) or 1(locked)(true)
 */
window.GetStateOfClosestDoorOfType = function (type, x, y, z) {
	return _in(0xedc1a5b8, 0x4aef33ff, _ch(type), _fv(x), _fv(y), _fv(z), _i /* actually bool */, _f);
};

window.GetStreamPlayTime = function () {
	return _in(0x4e72bbdb, 0xca58a3db, _r, _ri);
};

/**
 * Determines the name of the street which is the closest to the given coordinates.
 * x,y,z - the coordinates of the street
 * streetName - returns a hash to the name of the street the coords are on
 * crossingRoad - if the coordinates are on an intersection, a hash to the name of the crossing road
 * Note: the names are returned as hashes, the strings can be returned using the function UI::GET_STREET_NAME_FROM_HASH_KEY.
 */
window.GetStreetNameAtCoord = function (x, y, z) {
	return _in(0x2eb41072, 0xb4c1e4c0, _fv(x), _fv(y), _fv(z), _i, _i);
};

/**
 * This functions converts the hash of a street name into a readable string.
 * For how to get the hashes, see PATHFIND::GET_STREET_NAME_AT_COORD.
 */
window.GetStreetNameFromHashKey = function (hash) {
	return _in(0xd0ef8a95, 0x9b8a4cb9, _ch(hash), _r, _s);
};

/**
 * p0 = VEHICLE_NODE_ID
 * Returns false for nodes that aren't used for GPS routes.
 * Example:
 * Nodes in Fort Zancudo and LSIA are false
 */
window.GetSupportsGpsRouteFlag = function (nodeID) {
	return _in(0xa2ae5c47, 0x8b96e3b6, nodeID, _r);
};
window.N_0xa2ae5c478b96e3b6 = window.GetSupportsGpsRouteFlag;

window.GetSynchronizedScenePhase = function (sceneID) {
	return _in(0xe4a310b1, 0xd7fa73cc, sceneID, _r, _rf);
};

window.GetSynchronizedSceneRate = function (sceneID) {
	return _in(0xd80932d5, 0x77274d40, sceneID, _r, _rf);
};

/**
 * Character types:
 * ```
 * 0 = Michael,
 * 1 = Franklin,
 * 2 = Trevor,
 * 3 = MPMale,
 * 4 = MPFemale
 * ```
 * ```csharp
 * enum TattooZoneData
 * {
 * ZONE_TORSO = 0,
 * ZONE_HEAD = 1,
 * ZONE_LEFT_ARM = 2,
 * ZONE_RIGHT_ARM = 3,
 * ZONE_LEFT_LEG = 4,
 * ZONE_RIGHT_LEG = 5,
 * ZONE_UNKNOWN = 6,
 * ZONE_NONE = 7,
 * };
 * struct outComponent
 * {
 * // these vars are suffixed with 4 bytes of padding each.
 * uint unk;
 * int unk2;
 * uint tattooCollectionHash;
 * uint tattooNameHash;
 * int unk3;
 * TattooZoneData zoneId;
 * uint unk4;
 * uint unk5;
 * // maybe more, not sure exactly, decompiled scripts are very vague around this part.
 * }
 * ```
 * @param characterType Character types 0 = Michael, 1 = Franklin, 2 = Trevor, 3 = MPMale, 4 = MPFemale.
 * @param decorationIndex Tattoo index, value between 0 and GetNumDecorations(characterType).
 * @param outComponent The referenced struct.
 * @return A bool indicating that the tattoo data could be fetched(?)
 */
window.GetTattooCollectionData = function (characterType, decorationIndex, outComponent) {
	return _in(0xff563818, 0x74f82086, characterType, decorationIndex, _ii(outComponent) /* may be optional */, _r);
};
window.N_0xff56381874f82086 = window.GetTattooCollectionData;

/**
 * Returns the zoneID for the overlay if it is a member of collection.
 * enum TattooZoneData
 * {
 * ZONE_TORSO = 0,
 * ZONE_HEAD = 1,
 * ZONE_LEFT_ARM = 2,
 * ZONE_RIGHT_ARM = 3,
 * ZONE_LEFT_LEG = 4,
 * ZONE_RIGHT_LEG = 5,
 * ZONE_UNKNOWN = 6,
 * ZONE_NONE = 7,
 * };
 */
window.GetTattooZone = function (collection, overlay) {
	return _in(0x9fd452bf, 0xbe7a7a8b, _ch(collection), _ch(overlay), _r, _ri);
};

/**
 * This get's the height of the FONT and not the total text. You need to get the number of lines your text uses, and get the height of a newline (I'm using a smaller value) to get the total text height.
 */
window.GetTextScaleHeight = function (size, font) {
	return _in(0xdb88a374, 0x83346780, _fv(size), font, _r, _rf);
};
window.N_0xdb88a37483346780 = window.GetTextScaleHeight;

/**
 * Determines how many lines the text string will use when drawn on screen.
 * Must use _BEGIN_TEXT_COMMAND_LINE_COUNT for setting up
 */
window.GetTextScreenLineCount = function (x, y) {
	return _in(0x9040dfb0, 0x9be75706, _fv(x), _fv(y), _r, _ri);
};
window.N_0x9040dfb09be75706 = window.GetTextScreenLineCount;
window.EndTextCommandGetLineCount = window.GetTextScreenLineCount;

/**
 * Returns a substring of a specified length starting at a specified position.
 * Example:
 * // Get "STRING" text from "MY_STRING"
 * subStr = UI::_GET_TEXT_SUBSTRING("MY_STRING", 3, 6);
 */
window.GetTextSubstring = function (text, position, length) {
	return _in(0x169bd938, 0x2084c8c0, _ts(text), position, length, _r, _s);
};

/**
 * Returns a substring of a specified length starting at a specified position. The result is guaranteed not to exceed the specified max length.
 * NOTE: The 'maxLength' parameter might actually be the size of the buffer that is returned. More research is needed. -CL69
 * Example:
 * // Condensed example of how Rockstar uses this function
 * strLen = UI::GET_LENGTH_OF_LITERAL_STRING(GAMEPLAY::GET_ONSCREEN_KEYBOARD_RESULT());
 * subStr = UI::_GET_TEXT_SUBSTRING_SAFE(GAMEPLAY::GET_ONSCREEN_KEYBOARD_RESULT(), 0, strLen, 63);
 * --
 * "fm_race_creator.ysc", line 85115:
 * // parameters modified for clarity
 * BOOL sub_8e5aa(char *text, int length) {
 * for (i = 0; i <= (length - 2); i += 1) {
 * if (!GAMEPLAY::ARE_STRINGS_EQUAL(UI::_GET_TEXT_SUBSTRING_SAFE(text, i, i + 1, 1), " ")) {
 * return FALSE;
 * }
 * }
 * return TRUE;
 * }
 */
window.GetTextSubstringSafe = function (text, position, length, maxLength) {
	return _in(0xb2798643, 0x312205c5, _ts(text), position, length, maxLength, _r, _s);
};

/**
 * Returns a substring that is between two specified positions. The length of the string will be calculated using (endPosition - startPosition).
 * Example:
 * // Get "STRING" text from "MY_STRING"
 * subStr = UI::_GET_TEXT_SUBSTRING_SLICE("MY_STRING", 3, 9);
 * // Overflows are possibly replaced with underscores (needs verification)
 * subStr = UI::_GET_TEXT_SUBSTRING_SLICE("MY_STRING", 3, 10); // "STRING_"?
 */
window.GetTextSubstringSlice = function (text, startPosition, endPosition) {
	return _in(0xce94aeba, 0x5d82908a, _ts(text), startPosition, endPosition, _r, _s);
};

/**
 * Returns the texture resolution of the passed texture dict+name.
 * Note: Most texture resolutions are doubled compared to the console version of the game.
 */
window.GetTextureResolution = function (textureDict, textureName) {
	return _in(0x35736ee6, 0x5bd00c11, _ts(textureDict), _ts(textureName), _r, _rv);
};

window.GetThisScriptName = function () {
	return _in(0x442e0a7e, 0xde4a738a, _r, _s);
};

/**
 * Previously named, '_FORMAT_TIME' for people who can't find it's uses in decompiled scripts.
 */
window.GetTimeAsString = function (time) {
	return _in(0x9e23b177, 0x7a927dad, time, _r, _s);
};
window.FormatTime = window.GetTimeAsString;

/**
 * Subtracts the second argument from the first.
 */
window.GetTimeDifference = function (timeA, timeB) {
	return _in(0xa2c6fc03, 0x1d46fff0, timeA, timeB, _r, _ri);
};

/**
 * Adds the first argument to the second.
 */
window.GetTimeOffset = function (timeA, timeB) {
	return _in(0x017008cc, 0xdad48503, timeA, timeB, _r, _ri);
};

window.GetTimePositionInRecording = function (p0) {
	return _in(0x5746f3a7, 0xab7fe544, p0, _r, _rf);
};

/**
 * Returns the time since the character was arrested in (ms) milliseconds.
 * example
 * var time = Function.call<int>(Hash.GET_TIME_SINCE_LAST_ARREST();
 * UI.DrawSubtitle(time.ToString());
 * if player has not been arrested, the int returned will be -1.
 */
window.GetTimeSinceLastArrest = function () {
	return _in(0x5063f92f, 0x07c2a316, _r, _ri);
};

/**
 * Returns the time since the character died in (ms) milliseconds.
 * example
 * var time = Function.call<int>(Hash.GET_TIME_SINCE_LAST_DEATH();
 * UI.DrawSubtitle(time.ToString());
 * if player has not died, the int returned will be -1.
 */
window.GetTimeSinceLastDeath = function () {
	return _in(0xc7034807, 0x558ddfca, _r, _ri);
};

window.GetTimeSincePlayerDroveAgainstTraffic = function (player) {
	return _in(0xdb89591e, 0x290d9182, player, _r, _ri);
};

window.GetTimeSincePlayerDroveOnPavement = function (player) {
	return _in(0xd559d2be, 0x9e37853b, player, _r, _ri);
};

window.GetTimeSincePlayerHitPed = function (player) {
	return _in(0xe36a2532, 0x2dc35f42, player, _r, _ri);
};

window.GetTimeSincePlayerHitVehicle = function (player) {
	return _in(0x5d35ecf3, 0xa81a0ee0, player, _r, _ri);
};

/**
 * Only use for this in the PC scripts is:
 * if (GRAPHICS::GET_TIMECYCLE_MODIFIER_INDEX() != -1)
 * For a full list, see here: pastebin.com/cnk7FTF2
 * can someone update this pastebin???
 */
window.GetTimecycleModifierIndex = function () {
	return _in(0xfdf3d97c, 0x674afb66, _r, _ri);
};

window.GetTotalDurationOfVehicleRecording = function (p0, p1) {
	return _in(0x0e48d1c2, 0x62390950, p0, p1, _r, _ri);
};

window.GetTotalDurationOfVehicleRecordingId = function (p0) {
	return _in(0x102d1254, 0x11a7b6e6, p0, _r, _rf);
};

window.GetTotalScInboxIds = function () {
	return _in(0x03a93ff1, 0xa2ca0864, _r, _ri);
};
window.N_0x03a93ff1a2ca0864 = window.GetTotalScInboxIds;

/**
 * Corrected p1. it's basically the 'carriage/trailer number'. So if the train has 3 trailers you'd call the native once with a var or 3 times with 1, 2, 3.
 */
window.GetTrainCarriage = function (train, trailerNumber) {
	return _in(0x08aafd08, 0x14722bc3, train, trailerNumber, _r, _ri);
};

/**
 * Return the content modifier id (the tunables context if you want) of a specific content.
 * It takes the content hash (which is the mission id hash), and return the content modifier id, used as the tunables context.
 * The mission id can be found on the Social club, for example, 'socialclub.rockstargames.com/games/gtav/jobs/job/A8M6Bz8MLEC5xngvDCzGwA'
 * 'A8M6Bz8MLEC5xngvDCzGwA' is the mission id, so the game hash this and use it as the parameter for this native.
 */
window.GetTunablesContentModifierId = function (contentHash) {
	return _in(0x187382f8, 0xa3e0a6c3, _ch(contentHash), _r, _ri);
};
window.N_0x187382f8a3e0a6c3 = window.GetTunablesContentModifierId;

window.GetTupstatBoolHash = function (index, spStat, charStat, character) {
	return _in(0xc4bb08ee, 0x7907471e, index, spStat, charStat, character, _r, _ri);
};
window.N_0xc4bb08ee7907471e = window.GetTupstatBoolHash;

window.GetTupstatIntHash = function (index, spStat, charStat, character) {
	return _in(0xd16c2ad6, 0xb8e32854, index, spStat, charStat, character, _r, _ri);
};
window.N_0xd16c2ad6b8e32854 = window.GetTupstatIntHash;

window.GetTvChannel = function () {
	return _in(0xfc1e275a, 0x90d39995, _r, _ri);
};

window.GetTvVolume = function () {
	return _in(0x2170813d, 0x3dd8661b, _r, _rf);
};

/**
 * Returns the user's defined langauge as ID
 * english: 12
 * french = 7
 * german = 22
 * italian = 21
 * japanese = 9
 * korean = 17
 * portuguese = 16
 * spanish = 10
 * russian = 25
 */
window.GetUserLanguageId = function () {
	return _in(0xa8ae43ae, 0xc1a61314, _r, _ri);
};

/**
 * console hash: 0xC589CD7D = GET_UTC_TIME
 * gets current UTC time
 */
window.GetUtcTime = function () {
	return _in(0x8117e09a, 0x19eef4d3, _i, _i, _i, _i, _i, _i);
};
window.GetLocalTime = window.GetUtcTime;

window.GetVariantComponent = function (componentHash, componentId) {
	return _in(0x6e11f282, 0xf11863b6, _ch(componentHash), componentId, _i, _i, _i);
};

/**
 * static - max acceleration
 */
window.GetVehicleAcceleration = function (vehicle) {
	return _in(0x5dd35c8d, 0x074e57ae, vehicle, _r, _rf);
};

window.GetVehicleAlarmTimeLeft = function (vehicle) {
	return _in(0x00000000, 0xc62aac98, vehicle, _r, _ri);
};

/**
 * Returns attached vehicle (Vehicle in parameter must be cargobob)
 */
window.GetVehicleAttachedToCargobob = function (cargobob) {
	return _in(0x873b82d4, 0x2ac2b9e5, cargobob, _r, _ri);
};

/**
 * Get the vehicle attached to the object/entity? May also just convert it to a vehicle, but I'm not sure.
 */
window.GetVehicleAttachedToEntity = function (object) {
	return _in(0x375e7fc4, 0x4f21c8ab, object, _r, _ri);
};
window.N_0x375e7fc44f21c8ab = window.GetVehicleAttachedToEntity;

/**
 * Seems related to vehicle health, like the one in IV.
 * Max 1000, min 0.
 * Vehicle does not necessarily explode or become undrivable at 0.
 */
window.GetVehicleBodyHealth = function (vehicle) {
	return _in(0xf271147e, 0xb7b40f12, vehicle, _r, _rf);
};

/**
 * 0 min 100 max
 * starts at 100
 * Seams to have health zones
 * Front of vehicle when damaged goes from 100-50 and stops at 50.
 * Rear can be damaged from 100-0
 * Only tested with two cars.
 * any idea how this differs from the first one?
 * --
 * May return the vehicle health on a scale of 0.0 - 100.0 (needs to be confirmed)
 * example:
 * v_F = ENTITY::GET_ENTITY_MODEL(v_3);
 * if (((v_F == ${tanker}) || (v_F == ${armytanker})) || (v_F == ${tanker2})) {
 * if (VEHICLE::_GET_VEHICLE_BODY_HEALTH_2(v_3) <= 1.0) {
 * NETWORK::NETWORK_EXPLODE_VEHICLE(v_3, 1, 1, -1);
 * }
 * }
 */
window.GetVehicleBodyHealth_2 = function (vehicle) {
	return _in(0xb8ef6120, 0x7c2393a9, vehicle, _r, _rf);
};

/**
 * iVar3 = get_vehicle_cause_of_destruction(uLocal_248[iVar2]);
 * if (iVar3 == joaat("weapon_stickybomb"))
 * {
 * func_171(726);
 * iLocal_260 = 1;
 * }
 */
window.GetVehicleCauseOfDestruction = function (vehicle) {
	return _in(0xe495d1ef, 0x4c91fd20, vehicle, _r, _ri);
};

/**
 * Returns an int
 * Vehicle Classes:
 * 0: Compacts
 * 1: Sedans
 * 2: SUVs
 * 3: Coupes
 * 4: Muscle
 * 5: Sports Classics
 * 6: Sports
 * 7: Super
 * 8: Motorcycles
 * 9: Off-road
 * 10: Industrial
 * 11: Utility
 * 12: Vans
 * 13: Cycles
 * 14: Boats
 * 15: Helicopters
 * 16: Planes
 * 17: Service
 * 18: Emergency
 * 19: Military
 * 20: Commercial
 * 21: Trains
 * char buffer[128];
 * std::sprintf(buffer, "VEH_CLASS_%i", VEHICLE::GET_VEHICLE_CLASS(vehicle));
 * char* className = UI::_GET_LABEL_TEXT(buffer);
 */
window.GetVehicleClass = function (vehicle) {
	return _in(0x29439776, 0xaaa00a62, vehicle, _r, _ri);
};

/**
 * For a full enum, see here : pastebin.com/i2GGAjY0
 * char buffer[128];
 * std::sprintf(buffer, "VEH_CLASS_%i", VEHICLE::GET_VEHICLE_CLASS_FROM_NAME (hash));
 * char* className = UI::_GET_LABEL_TEXT(buffer);
 */
window.GetVehicleClassFromName = function (modelHash) {
	return _in(0xdedf1c8b, 0xd47c2200, _ch(modelHash), _r, _ri);
};

window.GetVehicleClassMaxAcceleration = function (vehicleClass) {
	return _in(0x2f83e7e4, 0x5d9ea7ae, vehicleClass, _r, _rf);
};

window.GetVehicleClassMaxAgility = function (vehicleClass) {
	return _in(0x4f930ad0, 0x22d6de3b, vehicleClass, _r, _rf);
};

window.GetVehicleClassMaxBraking = function (vehicleClass) {
	return _in(0x4bf54c16, 0xec8fec03, vehicleClass, _r, _rf);
};

/**
 * GET_VEHICLE_CLASS_MAX_*
 */
window.GetVehicleClassMaxSpeed = function (vehicleClass) {
	return _in(0x00c09f24, 0x6abedd82, vehicleClass, _r, _rf);
};
window.N_0x00c09f246abedd82 = window.GetVehicleClassMaxSpeed;

window.GetVehicleClassMaxTraction = function (vehicleClass) {
	return _in(0xdbc86d85, 0xc5059461, vehicleClass, _r, _rf);
};

window.GetVehicleClutch = function (vehicle) {
	return _in(0x00000000, 0x1dad4583, vehicle, _r, _rf);
};

/**
 * What's this for? Primary and Secondary RGB have their own natives and this one doesn't seem specific.
 */
window.GetVehicleColor = function (vehicle) {
	return _in(0xf3cc740d, 0x36221548, vehicle, _i, _i, _i);
};

window.GetVehicleColourCombination = function (vehicle) {
	return _in(0x6a842d19, 0x7f845d56, vehicle, _r, _ri);
};

window.GetVehicleColours = function (vehicle) {
	return _in(0xa19435f1, 0x93e081ac, vehicle, _i, _i);
};

window.GetVehicleCurrentAcceleration = function (vehicle) {
	return _in(0x00000000, 0x7f72adf3, vehicle, _r, _rf);
};

window.GetVehicleCurrentGear = function (vehicle) {
	return _in(0x00000000, 0xb4f4e566, vehicle, _r, _ri);
};

window.GetVehicleCurrentRpm = function (vehicle) {
	return _in(0x00000000, 0xe7b12b54, vehicle, _r, _rf);
};

window.GetVehicleCustomPrimaryColour = function (vehicle) {
	return _in(0xb64cf2cc, 0xa9d95f52, vehicle, _i, _i, _i);
};

window.GetVehicleCustomSecondaryColour = function (vehicle) {
	return _in(0x8389cd56, 0xca8072dc, vehicle, _i, _i, _i);
};

window.GetVehicleDashboardColour = function (vehicle, color) {
	return _in(0xb7635e80, 0xa5c31bff, vehicle, _ii(color) /* may be optional */);
};

window.GetVehicleDashboardSpeed = function (vehicle) {
	return _in(0x00000000, 0x9aad420e, vehicle, _r, _rf);
};

/**
 * Returns hash of default vehicle horn
 * Hash is stored in audVehicleAudioEntity
 */
window.GetVehicleDefaultHorn = function (vehicle) {
	return _in(0x02165d55, 0x000219ac, vehicle, _r, _ri);
};

/**
 * The only example I can find of this function in the scripts, is this:
 * struct _s = VEHICLE::GET_VEHICLE_DEFORMATION_AT_POS(rPtr((A_0) + 4), 1.21f, 6.15f, 0.3f);
 * -----------------------------------------------------------------------------------------------------------------------------------------
 * PC scripts:
 * v_5 -- [[{3}]]  = VEHICLE::GET_VEHICLE_DEFORMATION_AT_POS(a_0._f1, 1.21, 6.15, 0.3);
 */
window.GetVehicleDeformationAtPos = function (vehicle, offsetX, offsetY, offsetZ) {
	return _in(0x4ec6cfbc, 0x7b2e9536, vehicle, _fv(offsetX), _fv(offsetY), _fv(offsetZ), _r, _rv);
};

/**
 * Dirt level 0..15
 */
window.GetVehicleDirtLevel = function (vehicle) {
	return _in(0x8f17bc8b, 0xa08da62b, vehicle, _r, _rf);
};

/**
 * example in vb:
 * Public Shared Function Get_Vehicle_Door_Angle(Vehicle As Vehicle, Door As VehicleDoor) As Single
 * Return Native.Function.Call(Of Single)(Hash.GET_VEHICLE_DOOR_ANGLE_RATIO, Vehicle.Handle, Door)
 * End Function
 * I'm Not MentaL
 */
window.GetVehicleDoorAngleRatio = function (vehicle, door) {
	return _in(0xfe3f9c29, 0xf7b32bd5, vehicle, door, _r, _rf);
};

/**
 * 2 seems to disable getting vehicle in modshop
 */
window.GetVehicleDoorLockStatus = function (vehicle) {
	return _in(0x25bc98a5, 0x9c2ea962, vehicle, _r, _ri);
};

window.GetVehicleDoorsLockedForPlayer = function (vehicle, player) {
	return _in(0xf6af6cb3, 0x41349015, vehicle, player, _r);
};

/**
 * Returns 1000.0 if the function is unable to get the address of the specified vehicle or if it's not a vehicle.
 * Minimum: -4000
 * Maximum: 1000
 * -4000: Engine is destroyed
 * 0 and below: Engine catches fire and health rapidly declines
 * 300: Engine is smoking and losing functionality
 * 1000: Engine is perfect
 */
window.GetVehicleEngineHealth = function (vehicle) {
	return _in(0xc45d23ba, 0xf168aab8, vehicle, _r, _rf);
};

window.GetVehicleEngineTemperature = function (vehicle) {
	return _in(0x00000000, 0xf4f495cb, vehicle, _r, _rf);
};

/**
 * formerly known as _GET_VEHICLE_PAINT_FADE
 * The result is a value from 0-1, where 0 is fresh paint.
 * -----------------------------------------------------------------------
 * The actual value isn't stored as a float but as an unsigned char (BYTE).
 */
window.GetVehicleEnveffScale = function (vehicle) {
	return _in(0xa82819ca, 0xc9c4c403, vehicle, _r, _rf);
};
window.GetVehiclePaintFade = window.GetVehicleEnveffScale;

window.GetVehicleExtraColours = function (vehicle) {
	return _in(0x3bc42459, 0x33a166f7, vehicle, _i, _i);
};

window.GetVehicleFuelLevel = function (vehicle) {
	return _in(0x00000000, 0x5f739bb8, vehicle, _r, _rf);
};

window.GetVehicleGravityAmount = function (vehicle) {
	return _in(0x00000000, 0xb48a1292, vehicle, _r, _rf);
};

window.GetVehicleHandbrake = function (vehicle) {
	return _in(0x00000000, 0x483b013c, vehicle, _r);
};

/**
 * Returns the effective handling data of a vehicle as a floating-point value.
 * Example: `local fSteeringLock = GetVehicleHandlingFloat(vehicle, 'CHandlingData', 'fSteeringLock')`
 * @param vehicle The vehicle to obtain data for.
 * @param class_ The handling class to get. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to get. These match the keys in `handling.meta`.
 * @return A floating-point value.
 */
window.GetVehicleHandlingFloat = function (vehicle, class_, fieldName) {
	return _in(0x00000000, 0x642fc12f, vehicle, _ts(class_), _ts(fieldName), _r, _rf);
};

/**
 * Returns the effective handling data of a vehicle as an integer value.
 * Example: `local modelFlags = GetVehicleHandlingInt(vehicle, 'CHandlingData', 'strModelFlags')`
 * @param vehicle The vehicle to obtain data for.
 * @param class_ The handling class to get. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to get. These match the keys in `handling.meta`.
 * @return An integer.
 */
window.GetVehicleHandlingInt = function (vehicle, class_, fieldName) {
	return _in(0x00000000, 0x27396c75, vehicle, _ts(class_), _ts(fieldName), _r, _ri);
};

/**
 * Returns the effective handling data of a vehicle as a vector value.
 * Example: `local inertiaMultiplier = GetVehicleHandlingVector(vehicle, 'CHandlingData', 'vecInertiaMultiplier')`
 * @param vehicle The vehicle to obtain data for.
 * @param class_ The handling class to get. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to get. These match the keys in `handling.meta`.
 * @return An integer.
 */
window.GetVehicleHandlingVector = function (vehicle, class_, fieldName) {
	return _in(0x00000000, 0xfb341304, vehicle, _ts(class_), _ts(fieldName), _r, _rv);
};

/**
 * Returns the headlight color index from the vehicle. Value between 0, 12.
 * Use [\_SET_VEHICLE_HEADLIGHTS_COLOUR](#_0xE41033B25D003A07) to set the headlights color for the vehicle.
 * Must enable xenon headlights before it'll take affect.
 * List of colors and ids:
 * ```
 * enum headlightColors {
 * Default = -1,
 * White = 0,
 * Blue = 1,
 * Electric_Blue = 2,
 * Mint_Green = 3,
 * Lime_Green = 4,
 * Yellow = 5,
 * Golden_Shower = 6,
 * Orange = 7,
 * Red = 8,
 * Pony_Pink = 9,
 * Hot_Pink = 10,
 * Purple = 11,
 * Blacklight = 12
 * }
 * ```
 * @param vehicle The vehicle to get the headlight color from.
 * @return Returns an int, value between 0-12 or 255 if no color is set.
 */
window.GetVehicleHeadlightsColour = function (vehicle) {
	return _in(0x3dff319a, 0x831e0cdb, vehicle, _r, _ri);
};
window.N_0x3dff319a831e0cdb = window.GetVehicleHeadlightsColour;

window.GetVehicleHighGear = function (vehicle) {
	return _in(0x00000000, 0xf1d1d689, vehicle, _r, _ri);
};

/**
 * Seems to get the hash of the vehicle's currently installed horn?
 */
window.GetVehicleHornHash = function (vehicle) {
	return _in(0xacb5dcca, 0x1ec76840, vehicle, _r, _ri);
};
window.N_0xacb5dcca1ec76840 = window.GetVehicleHornHash;

/**
 * A float indicating the percentage of the hover mode. 1.0 = in VTOL mode, 0.0 = in normal flying mode.
 * @param aircraft The vehicle to check the hover mode on.
 * @return A float indicating the percentage of the hover mode. 1.0 = in VTOL mode, 0.0 = in normal flying mode.
 */
window.GetVehicleHoverModePercentage = function (aircraft) {
	return _in(0xda62027c, 0x8bdb326e, aircraft, _r, _rf);
};
window.N_0xda62027c8bdb326e = window.GetVehicleHoverModePercentage;
window.GetPlaneHoverModePercentage = window.GetVehicleHoverModePercentage;

/**
 * Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
 */
window.GetVehicleIndexFromEntityIndex = function (entity) {
	return _in(0x4b53f929, 0x32adfac0, entity, _r, _ri);
};

/**
 * Gets the vehicle indicator light state. 0 = off, 1 = left, 2 = right, 3 = both
 * @return An integer.
 */
window.GetVehicleIndicatorLights = function (vehicle) {
	return _in(0x00000000, 0x83070354, vehicle, _r, _ri);
};

window.GetVehicleInteriorColour = function (vehicle, color) {
	return _in(0x7d1464d4, 0x72d32136, vehicle, _ii(color) /* may be optional */);
};

window.GetVehicleLayoutHash = function (vehicle) {
	return _in(0x28d37d4f, 0x71ac5c58, vehicle, _r, _ri);
};

window.GetVehicleLightsState = function (vehicle) {
	return _in(0xb91b4c20, 0x085bd12f, vehicle, _i /* actually bool */, _i /* actually bool */, _r);
};

/**
 * -1 = no livery
 */
window.GetVehicleLivery = function (trailers2) {
	return _in(0x2bb92305, 0x90da5e8a, trailers2, _r, _ri);
};

/**
 * Returns -1 if the vehicle has no livery
 */
window.GetVehicleLiveryCount = function (vehicle) {
	return _in(0x87b63e25, 0xa529d526, vehicle, _r, _ri);
};

window.GetVehicleMaxBraking = function (vehicle) {
	return _in(0xad7e85fc, 0x227197c4, vehicle, _r, _rf);
};

window.GetVehicleMaxNumberOfPassengers = function (vehicle) {
	return _in(0xa7c4f2c6, 0xe744a550, vehicle, _r, _ri);
};

window.GetVehicleMaxSpeed = function (vehicle) {
	return _in(0x53af99ba, 0xa671ca47, vehicle, _r, _rf);
};
window.N_0x53af99baa671ca47 = window.GetVehicleMaxSpeed;

window.GetVehicleMaxTraction = function (vehicle) {
	return _in(0xa132fb53, 0x70554db0, vehicle, _r, _rf);
};

/**
 * In b944, there are 50 (0 - 49) mod types.
 * Returns -1 if the vehicle mod is stock
 */
window.GetVehicleMod = function (vehicle, modType) {
	return _in(0x77296029, 0x8da26fdb, vehicle, modType, _r, _ri);
};

/**
 * p3 seems to be the pearlescent highlight color.
 * Seems redondant with void GET_VEHICLE_EXTRA_COLOURS(Vehicle vehicle, int *pearlescentColor, int *wheelColor)
 */
window.GetVehicleModColor_1 = function (vehicle) {
	return _in(0xe8d65ca7, 0x00c9a693, vehicle, _i, _i, _i);
};

/**
 * returns a string which is the codename of the vehicle's currently selected primary color
 * p1 is always 0
 */
window.GetVehicleModColor_1Name = function (vehicle, p1) {
	return _in(0xb45085b7, 0x21efd38c, vehicle, p1, _r, _s);
};
window.N_0xb45085b721efd38c = window.GetVehicleModColor_1Name;

window.GetVehicleModColor_2 = function (vehicle) {
	return _in(0x81592be4, 0xe3878728, vehicle, _i, _i);
};

/**
 * returns a string which is the codename of the vehicle's currently selected secondary color
 */
window.GetVehicleModColor_2Name = function (vehicle) {
	return _in(0x4967a516, 0xed23a5a1, vehicle, _r, _s);
};
window.N_0x4967a516ed23a5a1 = window.GetVehicleModColor_2Name;

/**
 * Can be used for IS_DLC_VEHICLE_MOD and _0xC098810437312FFF
 */
window.GetVehicleModData = function (vehicle, modType, modIndex) {
	return _in(0x4593cf82, 0xaa179706, vehicle, modType, modIndex, _r, _ri);
};
window.N_0x4593cf82aa179706 = window.GetVehicleModData;

window.GetVehicleModKit = function (vehicle) {
	return _in(0x6325d1a0, 0x44ae510d, vehicle, _r, _ri);
};

window.GetVehicleModKitType = function (vehicle) {
	return _in(0xfc058f51, 0x21e54c32, vehicle, _r, _ri);
};

window.GetVehicleModModifierValue = function (vehicle, modType, modIndex) {
	return _in(0x90a38e98, 0x38e0a8c1, vehicle, modType, modIndex, _r, _rf);
};

/**
 * Returns true if the wheels are custom wheels
 */
window.GetVehicleModVariation = function (vehicle, modType) {
	return _in(0xb3924ecd, 0x70e095dc, vehicle, modType, _r);
};

/**
 * Returns the acceleration of the specified model.
 * For a full list, see here: pastebin.com/GaN6vT4R
 */
window.GetVehicleModelAcceleration = function (modelHash) {
	return _in(0x8c044c5c, 0x84505b6a, _ch(modelHash), _r, _rf);
};

/**
 * GET_VEHICLE_MODEL_*
 * 9.8 * thrust if air vehicle, else 0.38 + drive force?
 * For a full list, see here: pastebin.com/bJQeDqNd
 */
window.GetVehicleModelDownForce = function (modelHash) {
	return _in(0x53409b51, 0x63d5b846, _ch(modelHash), _r, _rf);
};
window.N_0x53409b5163d5b846 = window.GetVehicleModelDownForce;

/**
 * GET_VEHICLE_MODEL_MAX_*
 * max braking if air vehicle, else max braking + 0.1
 * -------------------
 * For a full list, see here: pastebin.com/Cb9L1Cn0
 */
window.GetVehicleModelHandBrake = function (modelHash) {
	return _in(0xbfba3ba7, 0x9cff7ebf, _ch(modelHash), _r, _rf);
};
window.N_0xbfba3ba79cff7ebf = window.GetVehicleModelHandBrake;

/**
 * Returns max braking of the specified vehicle model.
 * For a full list, see here: pastebin.com/3N8DVbpG
 */
window.GetVehicleModelMaxBraking = function (modelHash) {
	return _in(0xdc53fd41, 0xb4ed944c, _ch(modelHash), _r, _rf);
};

/**
 * GET_VEHICLE_MODEL_*
 * Function pertains only to aviation vehicles.
 * For a full list, see here: pastebin.com/JwuGNp2K
 */
window.GetVehicleModelMaxKnots = function (modelHash) {
	return _in(0xc6ad107d, 0xdc9054cc, _ch(modelHash), _r, _rf);
};
window.N_0xc6ad107ddc9054cc = window.GetVehicleModelMaxKnots;

/**
 * Returns max speed (without mods) of the specified vehicle model in m/s.
 * For a full list, see here: pastebin.com/AUuHHK06
 * GET_VEHICLE_MODEL_*
 */
window.GetVehicleModelMaxSpeed = function (modelHash) {
	return _in(0xf417c250, 0x2fffed43, _ch(modelHash), _r, _rf);
};

/**
 * Returns max traction of the specified vehicle model.
 * For a full list, see here: pastebin.com/ERnntVjK
 */
window.GetVehicleModelMaxTraction = function (modelHash) {
	return _in(0x539de94d, 0x44fdfd0d, _ch(modelHash), _r, _rf);
};

/**
 * GET_VEHICLE_MODEL_*
 * called if the vehicle is a boat -- returns vecMoveResistanceX?
 * For a full list, see here: pastebin.com/Pyb2RhZ9
 */
window.GetVehicleModelMoveResistance = function (modelHash) {
	return _in(0x5aa3f878, 0xa178c4fc, _ch(modelHash), _r, _rf);
};
window.N_0x5aa3f878a178c4fc = window.GetVehicleModelMoveResistance;

/**
 * Returns max number of passengers (including the driver) for the specified vehicle model.
 * For a full list, see here: pastebin.com/MdETCS1j
 */
window.GetVehicleModelNumberOfSeats = function (modelHash) {
	return _in(0x2ad93716, 0xf184eda4, _ch(modelHash), _r, _ri);
};
window.GetVehicleModelMaxNumberOfPassengers = window.GetVehicleModelNumberOfSeats;

/**
 * Gets the color of the neon lights of the specified vehicle.
 * See _SET_VEHICLE_NEON_LIGHTS_COLOUR (0x8E0A582209A62695) for more information
 */
window.GetVehicleNeonLightsColour = function (vehicle) {
	return _in(0x7619eee8, 0xc886757f, vehicle, _i, _i, _i);
};

window.GetVehicleNextGear = function (vehicle) {
	return _in(0x00000000, 0xddb298ae, vehicle, _r, _ri);
};

/**
 * Calling this with an invalid node id, will crash the game.
 * Note that IS_VEHICLE_NODE_ID_VALID simply checks if nodeId is not zero. It does not actually ensure that the id is valid.
 * Eg. IS_VEHICLE_NODE_ID_VALID(1) will return true, but will crash when calling GET_VEHICLE_NODE_POSITION().
 * sfink: This native returns a pointer to a packed Vector3 struct in the RAX register, as do the following natives:
 * AI::WAYPOINT_RECORDING_GET_COORD
 * ENTITY::GET_ENTITY_MATRIX
 * FIRE::GET_CLOSEST_FIRE_POS
 * GAMEPLAY::FIND_SPAWN_POINT_IN_DIRECTION
 * GAMEPLAY::GET_MODEL_DIMENSIONS
 * GAMEPLAY::OVERRIDE_SAVE_HOUSE
 * GAMEPLAY::_0x82FDE6A57EE4EE44
 * GAMEPLAY::_0x8BDC7BFC57A81E76
 * GAMEPLAY::_0x8D7A43EC6A5FEA45
 * GAMEPLAY::_0xA4A0065E39C9F25C
 * GAMEPLAY::_0xDFB4138EEFED7B81
 * MOBILE::GET_MOBILE_PHONE_POSITION
 * MOBILE::GET_MOBILE_PHONE_ROTATION
 * NETWORK::NETWORK_GET_RESPAWN_RESULT
 * OBJECT::_0x163F8B586BC95F2A
 * PATHFIND::GET_CLOSEST_MAJOR_VEHICLE_NODE
 * PATHFIND::GET_CLOSEST_ROAD
 * PATHFIND::GET_CLOSEST_VEHICLE_NODE
 * PATHFIND::GET_CLOSEST_VEHICLE_NODE_WITH_HEADING
 * PATHFIND::GET_NTH_CLOSEST_VEHICLE_NODE
 * PATHFIND::GET_NTH_CLOSEST_VEHICLE_NODE_FAVOUR_DIRECTION
 * PATHFIND::GET_NTH_CLOSEST_VEHICLE_NODE_WITH_HEADING
 * PATHFIND::GET_RANDOM_VEHICLE_NODE
 * PATHFIND::GET_SAFE_COORD_FOR_PED
 * PATHFIND::GET_VEHICLE_NODE_POSITION
 * PATHFIND::_0x16F46FB18C8009E4
 * VEHICLE::_0xA4822F1CF23F4810
 * VEHICLE::_0xDF7E3EEB29642C38
 * WATER::TEST_PROBE_AGAINST_ALL_WATER
 * WATER::TEST_PROBE_AGAINST_WATER
 * WEAPON::GET_PED_LAST_WEAPON_IMPACT_COORD
 * WORLDPROBE::_0xFF6BE494C7987F34
 * WORLDPROBE::_GET_RAYCAST_RESULT
 */
window.GetVehicleNodePosition = function (nodeId, outPosition) {
	return _in(0x703123e5, 0xe7d429c2, nodeId, _v);
};

/**
 * MulleDK19: Gets the density and flags of the closest node to the specified position.
 * Density is a value between 0 and 15, indicating how busy the road is.
 * Flags is a bit field.
 */
window.GetVehicleNodeProperties = function (x, y, z) {
	return _in(0x0568566a, 0xcbb5dedc, _fv(x), _fv(y), _fv(z), _i, _i, _r);
};

/**
 * Gets the number of passengers, NOT including the driver. Use IS_VEHICLE_SEAT_FREE(Vehicle, -1) to also check for the driver
 */
window.GetVehicleNumberOfPassengers = function (vehicle) {
	return _in(0x24cb2137, 0x731ffe89, vehicle, _r, _ri);
};

window.GetVehicleNumberOfWheels = function (vehicle) {
	return _in(0x00000000, 0xedf4b0fc, vehicle, _r, _ri);
};

/**
 * Returns the license plate text from a vehicle.  8 chars maximum.
 */
window.GetVehicleNumberPlateText = function (vehicle) {
	return _in(0x7ce1ccb9, 0xb293020e, vehicle, _r, _s);
};

/**
 * Returns the PlateType of a vehicle
 * Blue_on_White_1 = 3,
 * Blue_on_White_2 = 0,
 * Blue_on_White_3 = 4,
 * Yellow_on_Blue = 2,
 * Yellow_on_Black = 1,
 * North_Yankton = 5,
 */
window.GetVehicleNumberPlateTextIndex = function (elegy) {
	return _in(0xf11bc2dd, 0x9a3e7195, elegy, _r, _ri);
};

window.GetVehicleOilLevel = function (vehicle) {
	return _in(0x00000000, 0xfc7f8ef4, vehicle, _r, _rf);
};

/**
 * The resulting entity can be a Vehicle or Ped.
 * The native is stored between GET_VEHICLE_LIVERY_COUNT and GET_VEHICLE_MAX_BRAKING so the actual name is either GET_VEHICLE_L* or GET_VEHICLE_M*
 * =========================
 * on a side note watching changes in memory this will only store your ped's entityPoolAddress if it's your personal vehicle. So seems to be related to personal vehicles or atleast a specific decor of it maybe.
 */
window.GetVehicleOwner = function (vehicle, entity) {
	return _in(0x8f5ebab1, 0xf260cfce, vehicle, _ii(entity) /* may be optional */, _r);
};

/**
 * Gets the vehicle the specified Ped is/was in depending on bool value.
 * @param ped The target ped
 * @param lastVehicle False = CurrentVehicle, True = LastVehicle
 * @return The vehicle id. Returns 0 if the ped is/was not in a vehicle.
 */
window.GetVehiclePedIsIn = function (ped, lastVehicle) {
	return _in(0x9a9112a0, 0xfe9a4713, ped, lastVehicle, _r, _ri);
};

/**
 * Should be renamed GET_CAR_PED_IS_TRYING_TO_ENTER...
 * Because this works only for cars, not for helis, planes,motorcycles or bicycles...
 * From Calderon
 * This is what R* named it, deal with it.
 */
window.GetVehiclePedIsTryingToEnter = function (ped) {
	return _in(0x814fa8be, 0x5449445d, ped, _r, _ri);
};

/**
 * Gets ID of vehicle player using. It means it can get ID at any interaction with vehicle. Enter\exit for example. And that means it is faster than GET_VEHICLE_PED_IS_IN but less safe.
 */
window.GetVehiclePedIsUsing = function (ped) {
	return _in(0x6094ad01, 0x1a2ea87d, ped, _r, _ri);
};

/**
 * 1000 is max health
 * Begins leaking gas at around 650 health
 */
window.GetVehiclePetrolTankHealth = function (vehicle) {
	return _in(0x7d5dabe8, 0x88d2d074, vehicle, _r, _rf);
};

window.GetVehiclePlateType = function (vehicle) {
	return _in(0x9ccc9525, 0xbf2408e0, vehicle, _r, _ri);
};

window.GetVehicleRecordingId = function (p0, p1) {
	return _in(0x21543c61, 0x2379db3c, p0, _ts(p1), _r, _ri);
};

/**
 * Returns index of the current vehicle's rooftop livery.
 * A getter for [\_SET_VEHICLE_ROOF_LIVERY](#_0xA6D3A8750DC73270).
 * @param vehicle The vehicle handle.
 * @return An index of the current vehicle's rooftop livery.
 */
window.GetVehicleRoofLivery = function (vehicle) {
	return _in(0x60190048, 0xc0764a26, vehicle, _r, _ri);
};
window.N_0x60190048c0764a26 = window.GetVehicleRoofLivery;

/**
 * Returns a number of available rooftop liveries, or -1 if vehicle has no rooftop liveries available.
 * @param vehicle The vehicle handle.
 * @return A number of available rooftop liveries for vehicle.
 */
window.GetVehicleRoofLiveryCount = function (vehicle) {
	return _in(0x5ecb4026, 0x9053c0d4, vehicle, _r, _ri);
};
window.N_0x5ecb40269053c0d4 = window.GetVehicleRoofLiveryCount;

window.GetVehicleSteeringAngle = function (vehicle) {
	return _in(0x00000000, 0x1382fcea, vehicle, _r, _rf);
};

window.GetVehicleSteeringScale = function (vehicle) {
	return _in(0x00000000, 0x954465de, vehicle, _r, _rf);
};

/**
 * Gets the height of the vehicle's suspension.
 * The higher the value the lower the suspension. Each 0.002 corresponds with one more level lowered.
 * 0.000 is the stock suspension.
 * 0.008 is Ultra Suspension.
 */
window.GetVehicleSuspensionHeight = function (vehicle) {
	return _in(0x53952fd2, 0xbaa19f17, vehicle, _r, _rf);
};

/**
 * Gets the trailer of a vehicle and puts it into the trailer parameter.
 */
window.GetVehicleTrailerVehicle = function (vehicle, trailer) {
	return _in(0x1cdd6bad, 0xc297830d, vehicle, _ii(trailer) /* may be optional */, _r);
};

window.GetVehicleTurboPressure = function (vehicle) {
	return _in(0x00000000, 0xe02b51d7, vehicle, _r, _rf);
};

window.GetVehicleTyreSmokeColor = function (vehicle) {
	return _in(0xb635392a, 0x4938b3c3, vehicle, _i, _i, _i);
};

window.GetVehicleTyresCanBurst = function (vehicle) {
	return _in(0x678b9bb8, 0xc3f58feb, vehicle, _r);
};

window.GetVehicleWaypointProgress = function (vehicle) {
	return _in(0x9824cff8, 0xfc66e159, vehicle, _r, _ri);
};

window.GetVehicleWaypointTargetPoint = function (p0) {
	return _in(0x416b62ac, 0x8b9e5bbd, p0, _r, _ri);
};

window.GetVehicleWheelHealth = function (vehicle, wheelIndex) {
	return _in(0x00000000, 0x54a677f5, vehicle, wheelIndex, _r, _rf);
};

/**
 * Gets speed of a wheel at the tyre.
 * Max number of wheels can be retrieved with the native GET_VEHICLE_NUMBER_OF_WHEELS.
 * @return An integer.
 */
window.GetVehicleWheelSpeed = function (vehicle, wheelIndex) {
	return _in(0x00000000, 0x149c9da0, vehicle, wheelIndex, _r, _rf);
};

/**
 * Returns an int
 * Wheel Types:
 * 0: Sport
 * 1: Muscle
 * 2: Lowrider
 * 3: SUV
 * 4: Offroad
 * 5: Tuner
 * 6: Bike Wheels
 * 7: High End
 * Tested in Los Santos Customs
 */
window.GetVehicleWheelType = function (vehicle) {
	return _in(0xb3ed1bfb, 0x4be636dc, vehicle, _r, _ri);
};

/**
 * Returns the offset of the specified wheel relative to the wheel's axle center.
 */
window.GetVehicleWheelXOffset = function (vehicle, wheelIndex) {
	return _in(0x00000000, 0xcc90cbca, vehicle, wheelIndex, _r, _rf);
};

window.GetVehicleWheelYRotation = function (vehicle, wheelIndex) {
	return _in(0x00000000, 0x2ea4affe, vehicle, wheelIndex, _r, _rf);
};
window.GetVehicleWheelXrot = window.GetVehicleWheelYRotation;

/**
 * List of known states:
 * ```
 * 1: Not wheeling.
 * 65: Vehicle is ready to do wheelie (burnouting).
 * 129: Vehicle is doing wheelie.
 * ```
 * @param vehicle Vehicle
 * @return Vehicle's current wheelie state.
 */
window.GetVehicleWheelieState = function (vehicle) {
	return _in(0x00000000, 0x137260d1, vehicle, _r, _ri);
};

window.GetVehicleWindowTint = function (vehicle) {
	return _in(0x0ee21293, 0xdad47c95, vehicle, _r, _ri);
};

/**
 * Remnant from GTA IV. Does nothing in GTA V.
 */
window.GetWantedLevelRadius = function (player) {
	return _in(0x085deb49, 0x3be80812, player, _r, _ri);
};

/**
 * Drft
 */
window.GetWantedLevelThreshold = function (wantedLevel) {
	return _in(0xfdd179ea, 0xf45b556c, wantedLevel, _r, _ri);
};

/**
 * This function set height to the value of z-axis of the water surface.
 * This function works with sea and lake. However it does not work with shallow rivers (e.g. raton canyon will return -100000.0f)
 * note: seems to return true when you are in water
 */
window.GetWaterHeight = function (x, y, z, height) {
	return _in(0xf6829842, 0xc06ae524, _fv(x), _fv(y), _fv(z), _fi(height) /* may be optional */, _r);
};

window.GetWaterHeightNoWaves = function (x, y, z, height) {
	return _in(0x8ee6b53c, 0xe13a9794, _fv(x), _fv(y), _fv(z), _fi(height) /* may be optional */, _r);
};

window.GetWaypointDistanceAlongRoute = function (p0, p1) {
	return _in(0xa5b76905, 0x8763e497, _ts(p0), p1, _r, _rf);
};

/**
 * // Returns the size of the default weapon component clip.
 * Use it like this:
 * char cClipSize[32];
 * Hash cur;
 * if (WEAPON::GET_CURRENT_PED_WEAPON(playerPed, &cur, 1))
 * {
 * if (WEAPON::IS_WEAPON_VALID(cur))
 * {
 * int iClipSize = WEAPON::GET_WEAPON_CLIP_SIZE(cur);
 * sprintf_s(cClipSize, "ClipSize: %.d", iClipSize);
 * vDrawString(cClipSize, 0.5f, 0.5f);
 * }
 * }
 */
window.GetWeaponClipSize = function (weaponHash) {
	return _in(0x583be370, 0xb1ec6eb4, _ch(weaponHash), _r, _ri);
};

window.GetWeaponComponentHudStats = function (componentHash, outData) {
	return _in(0xb3caf387, 0xae12e9f8, _ch(componentHash), _ii(outData) /* may be optional */, _r);
};

window.GetWeaponComponentTypeModel = function (componentHash) {
	return _in(0x0db57b41, 0xec1db083, _ch(componentHash), _r, _ri);
};

/**
 * This native does not return damages of weapons from the melee and explosive group.
 * @param p1 0 in the decompiled scripts.
 * @return Damages of the weapon.
 */
window.GetWeaponDamage = function (weaponHash, p1) {
	return _in(0x3133b907, 0xd8b32053, _ch(weaponHash), p1, _r, _rf);
};
window.N_0x3133b907d8b32053 = window.GetWeaponDamage;

/**
 * 0=unknown (or incorrect weaponHash)
 * 1= no damage (flare,snowball, petrolcan)
 * 2=melee
 * 3=bullet
 * 4=force ragdoll fall
 * 5=explosive (RPG, Railgun, grenade)
 * 6=fire(molotov)
 * 8=fall(WEAPON_HELI_CRASH)
 * 10=electric
 * 11=barbed wire
 * 12=extinguisher
 * 13=gas
 * 14=water cannon(WEAPON_HIT_BY_WATER_CANNON)
 */
window.GetWeaponDamageType = function (weaponHash) {
	return _in(0x3be0bb12, 0xd25fb305, _ch(weaponHash), _r, _ri);
};

/**
 * returns the weapon hash of pickup
 */
window.GetWeaponHashFromPickup = function (pickupHash) {
	return _in(0x08f96ca6, 0xc551ad51, pickupHash, _r, _ri);
};
window.N_0x08f96ca6c551ad51 = window.GetWeaponHashFromPickup;

/**
 * // members should be aligned to 8 bytes by default but it's best to use alignas here, just to be sure
 * struct WeaponHudStatsData
 * {
 * alignas(8) uint8_t hudDamage; // 0x0000
 * alignas(8) uint8_t hudSpeed; // 0x0008
 * alignas(8) uint8_t hudCapacity; // 0x0010
 * alignas(8) uint8_t hudAccuracy; // 0x0018
 * alignas(8) uint8_t hudRange; // 0x0020
 * };
 * Usage:
 * WeaponHudStatsData data;
 * if (GET_WEAPON_HUD_STATS(weaponHash, (Any*)&data))
 * {
 * // uint8_t damagePercentage = data.hudDamage etc...
 * }
 */
window.GetWeaponHudStats = function (weaponHash, outData) {
	return _in(0xd92c739e, 0xe34c9eba, _ch(weaponHash), _ii(outData) /* may be optional */, _r);
};

/**
 * Drops the current weapon and returns the object
 * Unknown behavior when unarmed.
 */
window.GetWeaponObjectFromPed = function (ped, p1) {
	return _in(0xcae1dc9a, 0x0e22a16d, ped, p1, _r, _ri);
};

window.GetWeaponObjectTintIndex = function (weapon) {
	return _in(0xcd183314, 0xf7cd2e57, weapon, _r, _ri);
};

window.GetWeaponTintCount = function (weaponHash) {
	return _in(0x5dcf6c5c, 0xab2e9bf7, _ch(weaponHash), _r, _ri);
};

window.GetWeapontypeGroup = function (weaponHash) {
	return _in(0xc3287ee3, 0x050fb74c, _ch(weaponHash), _r, _ri);
};

/**
 * Returns the model of any weapon.
 * Can also take an ammo hash?
 * sub_6663a(&l_115B, WEAPON::GET_WEAPONTYPE_MODEL(${ammo_rpg}));
 */
window.GetWeapontypeModel = function (weaponHash) {
	return _in(0xf46cdc33, 0x180fda94, _ch(weaponHash), _r, _ri);
};

window.GetWeapontypeSlot = function (weaponHash) {
	return _in(0x4215460b, 0x9b8b7fa0, _ch(weaponHash), _r, _ri);
};

/**
 * changed any --> hash
 * progress_or_time --> percentWeather2, is not time but percent of the 2nd weather (0-1).
 * weatherType1 is same as GAMEPLAY::GET_PREV_WEATHER_TYPE_HASH_NAME()
 * and weatherType 2 GAMEPLAY::GET_NEXT_WEATHER_TYPE_HASH_NAME()
 * -QuantFC
 */
window.GetWeatherTypeTransition = function () {
	return _in(0xf3bbe884, 0xa14bb413, _i, _i, _f);
};

window.GetWindDirection = function () {
	return _in(0x1f400fef, 0x721170da, _r, _rv);
};

window.GetWindSpeed = function () {
	return _in(0xa8cf1cc0, 0xafcd3f12, _r, _rf);
};

/**
 * Returns the coordinates of an entity-bone.
 */
window.GetWorldPositionOfEntityBone = function (entity, boneIndex) {
	return _in(0x44a8fcb8, 0xed227738, entity, boneIndex, _r, _rv);
};

window.GetZoneAtCoords = function (x, y, z) {
	return _in(0x27040c25, 0xde6cb2f4, _fv(x), _fv(y), _fv(z), _r, _ri);
};

/**
 * 'zoneName' corresponds to an entry in 'popzone.ipl'.
 * AIRP = Los Santos International Airport
 * ALAMO = Alamo Sea
 * ALTA = Alta
 * ARMYB = Fort Zancudo
 * BANHAMC = Banham Canyon Dr
 * BANNING = Banning
 * BEACH = Vespucci Beach
 * BHAMCA = Banham Canyon
 * BRADP = Braddock Pass
 * BRADT = Braddock Tunnel
 * BURTON = Burton
 * CALAFB = Calafia Bridge
 * CANNY = Raton Canyon
 * CCREAK = Cassidy Creek
 * CHAMH = Chamberlain Hills
 * CHIL = Vinewood Hills
 * CHU = Chumash
 * CMSW = Chiliad Mountain State Wilderness
 * CYPRE = Cypress Flats
 * DAVIS = Davis
 * DELBE = Del Perro Beach
 * DELPE = Del Perro
 * DELSOL = La Puerta
 * DESRT = Grand Senora Desert
 * DOWNT = Downtown
 * DTVINE = Downtown Vinewood
 * EAST_V = East Vinewood
 * EBURO = El Burro Heights
 * ELGORL = El Gordo Lighthouse
 * ELYSIAN = Elysian Island
 * GALFISH = Galilee
 * GOLF = GWC and Golfing Society
 * GRAPES = Grapeseed
 * GREATC = Great Chaparral
 * HARMO = Harmony
 * HAWICK = Hawick
 * HORS = Vinewood Racetrack
 * HUMLAB = Humane Labs and Research
 * JAIL = Bolingbroke Penitentiary
 * KOREAT = Little Seoul
 * LACT = Land Act Reservoir
 * LAGO = Lago Zancudo
 * LDAM = Land Act Dam
 * LEGSQU = Legion Square
 * LMESA = La Mesa
 * LOSPUER = La Puerta
 * MIRR = Mirror Park
 * MORN = Morningwood
 * MOVIE = Richards Majestic
 * MTCHIL = Mount Chiliad
 * MTGORDO = Mount Gordo
 * MTJOSE = Mount Josiah
 * MURRI = Murrieta Heights
 * NCHU = North Chumash
 * NOOSE = N.O.O.S.E
 * OCEANA = Pacific Ocean
 * PALCOV = Paleto Cove
 * PALETO = Paleto Bay
 * PALFOR = Paleto Forest
 * PALHIGH = Palomino Highlands
 * PALMPOW = Palmer-Taylor Power Station
 * PBLUFF = Pacific Bluffs
 * PBOX = Pillbox Hill
 * PROCOB = Procopio Beach
 * RANCHO = Rancho
 * RGLEN = Richman Glen
 * RICHM = Richman
 * ROCKF = Rockford Hills
 * RTRAK = Redwood Lights Track
 * SANAND = San Andreas
 * SANCHIA = San Chianski Mountain Range
 * SANDY = Sandy Shores
 * SKID = Mission Row
 * SLAB = Stab City
 * STAD = Maze Bank Arena
 * STRAW = Strawberry
 * TATAMO = Tataviam Mountains
 * TERMINA = Terminal
 * TEXTI = Textile City
 * TONGVAH = Tongva Hills
 * TONGVAV = Tongva Valley
 * VCANA = Vespucci Canals
 * VESP = Vespucci
 * VINE = Vinewood
 * WINDF = Ron Alternates Wind Farm
 * WVINE = West Vinewood
 * ZANCUDO = Zancudo River
 * ZP_ORT = Port of South Los Santos
 * ZQ_UAR = Davis Quartz
 */
window.GetZoneFromNameId = function (zoneName) {
	return _in(0x98cd1d29, 0x34b76cc1, _ts(zoneName), _r, _ri);
};

window.GetZonePopschedule = function (zoneId) {
	return _in(0x4334bc40, 0xaa0cb4bb, zoneId, _r, _ri);
};

/**
 * cellphone range 1- 5 used for signal bar in iFruit phone
 */
window.GetZoneScumminess = function (zoneId) {
	return _in(0x5f7b268d, 0x15ba0739, zoneId, _r, _ri);
};

/**
 * World to relative screen coords
 * this world to screen will keep the text on screen. it will keep it in the screen pos. good for a deer hunting mod
 * Was named _GET_SCREEN_COORD_FROM_WORLD_COORD, but this conflicts with 0x34E82F05DF2974F5
 * As that hash actually matches GET_SCREEN_COORD_FROM_WORLD_COORD that one supercedes and this one was renamed
 * to _GET_2D_COORD_FROM_3D_COORD
 */
window.Get_2dCoordFrom_3dCoord = function (worldX, worldY, worldZ) {
	return _in(0xf9904d11, 0xf1acbec3, _fv(worldX), _fv(worldY), _fv(worldZ), _f, _f, _r);
};
window.N_0xf9904d11f1acbec3 = window.Get_2dCoordFrom_3dCoord;

/**
 * Achievements from 0-57
 * more achievements came with update 1.29 (freemode events update), I'd say that they now go to 60, but I'll need to check.
 */
window.GiveAchievementToPlayer = function (achId) {
	return _in(0xbec7076d, 0x64130195, achId, _r, _ri);
};

/**
 * Gives a weapon to PED with a delay, example:
 * WEAPON::GIVE_DELAYED_WEAPON_TO_PED(PED::PLAYER_PED_ID(), GAMEPLAY::GET_HASH_KEY("WEAPON_PISTOL"), 1000, false)
 * ----------------------------------------------------------------------------------------------------------------------------------------
 * Translation table:
 * pastebin.com/a39K8Nz8
 */
window.GiveDelayedWeaponToPed = function (ped, weaponHash, ammoCount, equipNow) {
	return _in(0xb282dc6e, 0xbd803c75, ped, _ch(weaponHash), ammoCount, equipNow);
};

/**
 * PoliceMotorcycleHelmet	1024
 * RegularMotorcycleHelmet	4096
 * FiremanHelmet	16384
 * PilotHeadset	32768
 * PilotHelmet	65536
 * --
 * p2 is generally 4096 or 16384 in the scripts. p1 varies between 1 and 0.
 */
window.GivePedHelmet = function (ped, cannotRemove, helmetFlag, textureIndex) {
	return _in(0x54c7c4a9, 0x4367717e, ped, cannotRemove, helmetFlag, textureIndex);
};

/**
 * Sends the message that was created by a call to CREATE_NM_MESSAGE to the specified Ped.
 * If a message hasn't been created already, this function does nothing.
 * If the Ped is not ragdolled with Euphoria enabled, this function does nothing.
 * The following call can be used to ragdoll the Ped with Euphoria enabled: SET_PED_TO_RAGDOLL(ped, 4000, 5000, 1, 1, 1, 0);
 * Call order:
 * SET_PED_TO_RAGDOLL
 * CREATE_NM_MESSAGE
 * GIVE_PED_NM_MESSAGE
 * Multiple messages can be chained. Eg. to make the ped stagger and swing his arms around, the following calls can be made:
 * SET_PED_TO_RAGDOLL(ped, 4000, 5000, 1, 1, 1, 0);
 * CREATE_NM_MESSAGE(true, 0); // stopAllBehaviours - Stop all other behaviours, in case the Ped is already doing some Euphoria stuff.
 * GIVE_PED_NM_MESSAGE(ped); // Dispatch message to Ped.
 * CREATE_NM_MESSAGE(true, 1151); // staggerFall - Attempt to walk while falling.
 * GIVE_PED_NM_MESSAGE(ped); // Dispatch message to Ped.
 * CREATE_NM_MESSAGE(true, 372); // armsWindmill - Swing arms around.
 * GIVE_PED_NM_MESSAGE(ped); // Dispatch message to Ped.
 */
window.GivePedNmMessage = function (ped) {
	return _in(0xb158dfcc, 0xc56e5c5b, ped);
};

/**
 * p1 is either 1 or 2 in the PC scripts.
 */
window.GivePedToPauseMenu = function (ped, p1) {
	return _in(0xac0bfbdc, 0x3be00e14, ped, p1);
};

window.GivePlayerRagdollControl = function (player, toggle) {
	return _in(0x3c49c870, 0xe66f0a28, player, toggle);
};

window.GiveWeaponComponentToPed = function (ped, weaponHash, componentHash) {
	return _in(0xd966d51a, 0xa5b28bb9, ped, _ch(weaponHash), _ch(componentHash));
};

/**
 * addonHash:
 * (use WEAPON::GET_WEAPON_COMPONENT_TYPE_MODEL() to get hash value)
 * ^ Wrong.
 * AddonHash is NOT a model hash, it's the weapon component hash.
 * ${component_at_ar_flsh}, ${component_at_ar_supp}, ${component_at_pi_flsh}, ${component_at_scope_large}, ${component_at_ar_supp_02}
 */
window.GiveWeaponComponentToWeaponObject = function (weaponObject, addonHash) {
	return _in(0x33e17943, 0x6c0b31db, weaponObject, _ch(addonHash));
};

window.GiveWeaponObjectToPed = function (weaponObject, ped) {
	return _in(0xb1fa6137, 0x1af7c4b7, weaponObject, ped);
};

/**
 * isHidden - ????
 * All weapon names (add to the list if something is missing), use GAMEPLAY::GET_HASH_KEY((char *)weaponNames[i]) to get get the hash:
 * static LPCSTR weaponNames[] = {
 * "WEAPON_KNIFE", "WEAPON_NIGHTSTICK", "WEAPON_HAMMER", "WEAPON_BAT", "WEAPON_GOLFCLUB",
 * "WEAPON_CROWBAR", "WEAPON_PISTOL", "WEAPON_COMBATPISTOL", "WEAPON_APPISTOL", "WEAPON_PISTOL50",
 * "WEAPON_MICROSMG", "WEAPON_SMG", "WEAPON_ASSAULTSMG", "WEAPON_ASSAULTRIFLE",
 * "WEAPON_CARBINERIFLE", "WEAPON_ADVANCEDRIFLE", "WEAPON_MG", "WEAPON_COMBATMG", "WEAPON_PUMPSHOTGUN",
 * "WEAPON_SAWNOFFSHOTGUN", "WEAPON_ASSAULTSHOTGUN", "WEAPON_BULLPUPSHOTGUN", "WEAPON_STUNGUN", "WEAPON_SNIPERRIFLE",
 * "WEAPON_HEAVYSNIPER", "WEAPON_GRENADELAUNCHER", "WEAPON_GRENADELAUNCHER_SMOKE", "WEAPON_RPG", "WEAPON_MINIGUN",
 * "WEAPON_GRENADE", "WEAPON_STICKYBOMB", "WEAPON_SMOKEGRENADE", "WEAPON_BZGAS", "WEAPON_MOLOTOV",
 * "WEAPON_FIREEXTINGUISHER", "WEAPON_PETROLCAN", "WEAPON_FLARE", "WEAPON_SNSPISTOL", "WEAPON_SPECIALCARBINE",
 * "WEAPON_HEAVYPISTOL", "WEAPON_BULLPUPRIFLE", "WEAPON_HOMINGLAUNCHER", "WEAPON_PROXMINE", "WEAPON_SNOWBALL",
 * "WEAPON_VINTAGEPISTOL", "WEAPON_DAGGER", "WEAPON_FIREWORK", "WEAPON_MUSKET", "WEAPON_MARKSMANRIFLE",
 * "WEAPON_HEAVYSHOTGUN", "WEAPON_GUSENBERG", "WEAPON_HATCHET", "WEAPON_RAILGUN", "WEAPON_COMBATPDW",
 * "WEAPON_KNUCKLE", "WEAPON_MARKSMANPISTOL", "WEAPON_FLASHLIGHT", "WEAPON_MACHETE", "WEAPON_MACHINEPISTOL",
 * "WEAPON_SWITCHBLADE", "WEAPON_REVOLVER", "WEAPON_COMPACTRIFLE", "WEAPON_DBSHOTGUN", "WEAPON_FLAREGUN",
 * "WEAPON_AUTOSHOTGUN", "WEAPON_BATTLEAXE", "WEAPON_COMPACTLAUNCHER", "WEAPON_MINISMG", "WEAPON_PIPEBOMB",
 * "WEAPON_POOLCUE", "WEAPON_SWEEPER", "WEAPON_WRENCH"
 * };
 * ----------------------------------------------------------------------------------------------------------------------------------------
 * Translation table:
 * pastebin.com/a39K8Nz8
 */
window.GiveWeaponToPed = function (ped, weaponHash, ammoCount, isHidden, equipNow) {
	return _in(0xbf0fd6e5, 0x6c964fcb, ped, _ch(weaponHash), ammoCount, isHidden, equipNow);
};

window.HasAchievementBeenPassed = function (achievement) {
	return _in(0x867365e1, 0x11a3b6eb, achievement, _r);
};

window.HasActionModeAssetLoaded = function (asset) {
	return _in(0xe4b5f4bf, 0x2cb24e65, _ts(asset), _r);
};

window.HasAdditionalTextLoaded = function (slot) {
	return _in(0x02245fe4, 0xbed318b8, slot, _r);
};

window.HasAnimDictLoaded = function (animDict) {
	return _in(0xd031a916, 0x2d01088c, _ts(animDict), _r);
};

/**
 * if (ENTITY::HAS_ANIM_EVENT_FIRED(PLAYER::PLAYER_PED_ID(), GAMEPLAY::GET_HASH_KEY("CreateObject")))
 */
window.HasAnimEventFired = function (entity, actionHash) {
	return _in(0xeaf4cd9e, 0xa3e7e922, entity, _ch(actionHash), _r);
};

/**
 * Gets whether the specified animation set has finished loading. An animation set provides movement animations for a ped. See SET_PED_MOVEMENT_CLIPSET.
 * Animation set and clip set are synonymous.
 */
window.HasAnimSetLoaded = function (animSet) {
	return _in(0xc4ea073d, 0x86fb29b0, _ts(animSet), _r);
};

/**
 * Console Hash
 */
window.HasBgScriptBeenDownloaded = function () {
	return _in(0x8132c0eb, 0x8b2b3293, _r);
};
window.N_0x8132c0eb8b2b3293 = window.HasBgScriptBeenDownloaded;

/**
 * p3 - possibly radius?
 */
window.HasBulletImpactedInArea = function (x, y, z, p3, p4, p5) {
	return _in(0x9870acfb, 0x89a90995, _fv(x), _fv(y), _fv(z), _fv(p3), p4, p5, _r);
};

window.HasBulletImpactedInBox = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0xdc8c5d7c, 0xfeab8394, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, p7, _r);
};

/**
 * This native appears on the cheat_controller script and tracks a combination of buttons, which may be used to toggle cheats in-game. Credits to ThreeSocks for the info. The hash contains the combination, while the "amount" represents the amount of buttons used in a combination. The following page can be used to make a button combination: gta5offset.com/ts/hash/
 * INT_SCORES_SCORTED was a hash collision
 */
window.HasButtonCombinationJustBeenEntered = function (hash, amount) {
	return _in(0x071e2a83, 0x9de82d90, _ch(hash), amount, _r);
};
window.N_0x071e2a839de82d90 = window.HasButtonCombinationJustBeenEntered;

/**
 * Get inputted "Cheat code", for example:
 * while (TRUE)
 * {
 * if (GAMEPLAY::_557E43C447E700A8(${fugitive}))
 * {
 * // Do something.
 * }
 * SYSTEM::WAIT(0);
 * }
 * Calling this will also set the last saved string hash to zero.
 */
window.HasCheatStringJustBeenEntered = function (hash) {
	return _in(0x557e43c4, 0x47e700a8, _ch(hash), _r);
};
window.N_0x557e43c447e700a8 = window.HasCheatStringJustBeenEntered;

/**
 * Alias for HAS_ANIM_SET_LOADED.
 */
window.HasClipSetLoaded = function (clipSet) {
	return _in(0x318234f4, 0xf3738af3, _ts(clipSet), _r);
};

window.HasClosestObjectOfTypeBeenBroken = function (p0, p1, p2, p3, modelHash, p5) {
	return _in(0x761b0e69, 0xac4d007e, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _ch(modelHash), p5, _r);
};

window.HasCollisionForModelLoaded = function (model) {
	return _in(0x22cca434, 0xe368f03a, _ch(model), _r);
};

window.HasCollisionLoadedAroundEntity = function (entity) {
	return _in(0xe9676f61, 0xbc0b3321, entity, _r);
};

window.HasCutsceneFinished = function () {
	return _in(0x7c0a8930, 0x88881d57, _r);
};

window.HasCutsceneLoaded = function () {
	return _in(0xc59f528e, 0x9ab9f339, _r);
};

/**
 * P3 is always 3 as far as i cant tell
 * Animations List : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.HasEntityAnimFinished = function (entity, animDict, animName, p3) {
	return _in(0x20b71166, 0x2962b472, entity, _ts(animDict), _ts(animName), p3, _r);
};

window.HasEntityBeenDamagedByAnyObject = function (entity) {
	return _in(0x95eb9964, 0xff5c5c65, entity, _r);
};

window.HasEntityBeenDamagedByAnyPed = function (entity) {
	return _in(0x605f5a14, 0x0f202491, entity, _r);
};

window.HasEntityBeenDamagedByAnyVehicle = function (entity) {
	return _in(0xdfd5033f, 0xdba0a9c8, entity, _r);
};

/**
 * Entity 1 = Victim
 * Entity 2 = Attacker
 * p2 seems to always be 1
 */
window.HasEntityBeenDamagedByEntity = function (entity1, entity2, p2) {
	return _in(0xc86d67d5, 0x2a707cf8, entity1, entity2, p2, _r);
};

/**
 * It determines what weapons caused damage:
 * If youu want to define only a specific weapon, second parameter=weapon hash code, third parameter=0
 * If you want to define any melee weapon, second parameter=0, third parameter=1.
 * If you want to identify any weapon (firearms, melee, rockets, etc.), second parameter=0, third parameter=2.
 */
window.HasEntityBeenDamagedByWeapon = function (entity, weaponHash, weaponType) {
	return _in(0x131d4013, 0x34815e94, entity, _ch(weaponHash), weaponType, _r);
};

/**
 * traceType is always 17 in the scripts.
 * There is other codes used for traceType:
 * 19 - in jewelry_prep1a
 * 126 - in am_hunt_the_beast
 * 256 & 287 - in fm_mission_controller
 */
window.HasEntityClearLosToEntity = function (entity1, entity2, traceType) {
	return _in(0xfcdff7b7, 0x2d23a1ac, entity1, entity2, traceType, _r);
};

/**
 * Has the entity1 got a clear line of sight to the other entity2 from the direction entity1 is facing.
 * This is one of the most CPU demanding BOOL natives in the game; avoid calling this in things like nested for-loops
 */
window.HasEntityClearLosToEntityInFront = function (entity1, entity2) {
	return _in(0x0267d00a, 0xf114f17a, entity1, entity2, _r);
};

/**
 * Called on tick.
 * Tested with vehicles, returns true whenever the vehicle is touching any entity.
 * Note: for vehicles, the wheels can touch the ground and it will still return false, but if the body of the vehicle touches the ground, it will return true.
 */
window.HasEntityCollidedWithAnything = function (entity) {
	return _in(0x8bad02f0, 0x368d9e14, entity, _r);
};

window.HasForceCleanupOccurred = function (cleanupFlags) {
	return _in(0xc968670b, 0xface42d9, cleanupFlags, _r);
};

/**
 * Check to see if hud component Scaleform has loaded?
 */
window.HasHudScaleformLoaded = function (hudComponent) {
	return _in(0xdf6e5987, 0xd2b4d140, hudComponent, _r);
};

/**
 * Returns whether or not the specific minimap overlay has loaded.
 * @param id A minimap overlay ID.
 * @return A boolean indicating load status.
 */
window.HasMinimapOverlayLoaded = function (id) {
	return _in(0x00000000, 0xf7535f32, id, _r);
};

/**
 * Checks if the specified model has loaded into memory.
 */
window.HasModelLoaded = function (model) {
	return _in(0x98a4eb5d, 0x89a0c952, _ch(model), _r);
};

window.HasMpGamerTag = function () {
	return _in(0x6e0eb3eb, 0x47c8d7aa, _r);
};
window.N_0x6e0eb3eb47c8d7aa = window.HasMpGamerTag;

window.HasMpGamerTag_2 = function (gamerTagId) {
	return _in(0xeb709a36, 0x958abe0d, gamerTagId, _r);
};
window.N_0xeb709a36958abe0d = window.HasMpGamerTag_2;

/**
 * assetName = For example "core"
 */
window.HasNamedPtfxAssetLoaded = function (assetName) {
	return _in(0x8702416e, 0x512ec454, _ts(assetName), _r);
};

/**
 * Pretty sure it's the real name (not 100% sure so I added the _ prefix); can someone else confirm it?
 * Only values used in the scripts are:
 * "heist_mp"
 * "heistmap_mp"
 * "instructional_buttons"
 * "heist_pre"
 */
window.HasNamedScaleformMovieLoaded = function (scaleformName) {
	return _in(0x0c1c5d75, 0x6fb5f337, _ts(scaleformName), _r);
};
window.N_0x0c1c5d756fb5f337 = window.HasNamedScaleformMovieLoaded;

window.HasNetworkTimeStarted = function () {
	return _in(0x46718ace, 0xedeafc84, _r);
};
window.N_0x46718aceedeafc84 = window.HasNetworkTimeStarted;

window.HasObjectBeenBroken = function (object) {
	return _in(0x8abfb70c, 0x49cc43e2, object, _r);
};

/**
 * It determines what weapons caused damage:
 * If you want to define only a specific weapon, second parameter=weapon hash code, third parameter=0
 * If you want to define any melee weapon, second parameter=0, third parameter=1.
 * If you want to identify any weapon (firearms, melee, rockets, etc.), second parameter=0, third parameter=2.
 */
window.HasPedBeenDamagedByWeapon = function (ped, weaponHash, weaponType) {
	return _in(0x2d343d22, 0x19cd027a, ped, _ch(weaponHash), weaponType, _r);
};

/**
 * p2 should be FALSE, otherwise it seems to always return FALSE
 * Bool does not check if the weapon is current equipped, unfortunately.
 */
window.HasPedGotWeapon = function (ped, weaponHash, p2) {
	return _in(0x8decb02f, 0x88f428bc, ped, _ch(weaponHash), p2, _r);
};

window.HasPedGotWeaponComponent = function (ped, weaponHash, componentHash) {
	return _in(0xc5932124, 0x75fae340, ped, _ch(weaponHash), _ch(componentHash), _r);
};

window.HasPedHeadBlendFinished = function (ped) {
	return _in(0x654cd0a8, 0x25161131, ped, _r);
};

window.HasPedReceivedEvent = function (ped, p1) {
	return _in(0x8507bcb7, 0x10fa6dc0, ped, p1, _r);
};

window.HasPickupBeenCollected = function (pickup) {
	return _in(0x80ec48e6, 0x679313f9, pickup, _r);
};

window.HasPlayerBeenSpottedInStolenVehicle = function (player) {
	return _in(0xd705740b, 0xb0a1cf4c, player, _r);
};

window.HasPlayerDamagedAtLeastOneNonAnimalPed = function (player) {
	return _in(0xe4b90f36, 0x7bd81752, player, _r);
};

window.HasPlayerDamagedAtLeastOnePed = function (player) {
	return _in(0x20ce80b0, 0xc2bf4acc, player, _r);
};

/**
 * Gets the player's info and calls a function that checks the player's ped position.
 * Here's the decompiled function that checks the position: pastebin.com/ZdHG2E7n
 */
window.HasPlayerLeftTheWorld = function (player) {
	return _in(0xd55ddfb4, 0x7991a294, player, _r);
};

window.HasPlayerTeleportFinished = function (player) {
	return _in(0xe23d5873, 0xc2394c61, player, _r);
};
window.N_0xe23d5873c2394c61 = window.HasPlayerTeleportFinished;

window.HasPreloadModsFinished = function (p0) {
	return _in(0x06f43e51, 0x75eb6d96, p0, _r);
};

window.HasPtfxAssetLoaded = function () {
	return _in(0xca7d9b86, 0xeca7481b, _r);
};

window.HasScaleformContainerMovieLoadedIntoParent = function (scaleformHandle) {
	return _in(0x8217150e, 0x1217ebfd, scaleformHandle, _r);
};

window.HasScaleformMovieLoaded = function (scaleformHandle) {
	return _in(0x85f01b8d, 0x5b90570e, scaleformHandle, _r);
};

/**
 * Returns if a script has been loaded into the game. Used to see if a script was loaded after requesting.
 * For a full list, see here: pastebin.com/yLNWicUi
 */
window.HasScriptLoaded = function (scriptName) {
	return _in(0xe6cc9f3b, 0xa0fb9ef1, _ts(scriptName), _r);
};

window.HasScriptWithNameHashLoaded = function (scriptHash) {
	return _in(0x5f0f0c78, 0x3eb16c04, _ch(scriptHash), _r);
};
window.HasStreamedScriptLoaded = window.HasScriptWithNameHashLoaded;

window.HasSoundFinished = function (soundId) {
	return _in(0xfcbdce71, 0x4a7c88e5, soundId, _r);
};

window.HasStealthModeAssetLoaded = function (asset) {
	return _in(0xe977fc5b, 0x08af3441, _ts(asset), _r);
};

window.HasStreamedTextureDictLoaded = function (textureDict) {
	return _in(0x0145f696, 0xaaaad2e4, _ts(textureDict), _r);
};

/**
 * Checks if the specified gxt has loaded into the passed slot.
 */
window.HasThisAdditionalTextLoaded = function (gxt, slot) {
	return _in(0xadbf060e, 0x2b30c5bc, _ts(gxt), slot, _r);
};

window.HasThisCutsceneLoaded = function (cutsceneName) {
	return _in(0x228d3d94, 0xf8a11c3c, _ts(cutsceneName), _r);
};

/**
 * Console Hash
 */
window.HasTunablesBeenDownloaded = function () {
	return _in(0x0467c11e, 0xd88b7d28, _r);
};
window.N_0x0467c11ed88b7d28 = window.HasTunablesBeenDownloaded;

window.HasVehicleAssetLoaded = function (vehicleAsset) {
	return _in(0x1bbe0523, 0xb8db9a21, vehicleAsset, _r);
};

/**
 * Third Parameter = unsure, but pretty sure it is weapon hash
 * --> get_hash_key("weapon_stickybomb")
 * Fourth Parameter = unsure, almost always -1
 */
window.HasVehicleGotProjectileAttached = function (driver, vehicle, weaponHash, p3) {
	return _in(0x717c8481, 0x234e3b88, driver, vehicle, _ch(weaponHash), p3, _r);
};

window.HasVehicleJumpingAbility = function (vehicle) {
	return _in(0x9078c0c5, 0xef8c19e9, vehicle, _r);
};

window.HasVehicleParachute = function (vehicle) {
	return _in(0xbc9cff38, 0x1338cb4f, vehicle, _r);
};

window.HasVehicleRecordingBeenLoaded = function (p0, p1) {
	return _in(0x300d614a, 0x4c785fc4, p0, _ii(p1) /* may be optional */, _r);
};

window.HasVehicleRocketBoost = function (vehicle) {
	return _in(0x36d782f6, 0x8b309bda, vehicle, _r);
};

window.HasWeaponAssetLoaded = function (weaponHash) {
	return _in(0x36e35327, 0x1f0e90ee, _ch(weaponHash), _r);
};

window.HasWeaponGotWeaponComponent = function (weapon, addonHash) {
	return _in(0x76a18844, 0xe743bf91, weapon, _ch(addonHash), _r);
};

window.HideHelpTextThisFrame = function () {
	return _in(0xd46923fc, 0x481ca285);
};

/**
 * I think this works, but seems to prohibit switching to other weapons (or accessing the weapon wheel)
 */
window.HideHudAndRadarThisFrame = function () {
	return _in(0x719ff505, 0xf097fd20);
};

window.HideHudComponentThisFrame = function (id) {
	return _in(0x6806c51a, 0xd12b83b8, id);
};

window.HideLoadingOnFadeThisFrame = function () {
	return _in(0x4b0311d3, 0xcdc4648f);
};

/**
 * This is the native that is used to hide the exterior of GTA Online apartment buildings when you are inside an apartment.
 * More info: http://gtaforums.com/topic/836301-hiding-gta-online-apartment-exteriors/
 */
window.HideMapObjectThisFrame = function (mapObjectHash) {
	return _in(0xa97f257d, 0x0151a6ab, _ch(mapObjectHash));
};
window.N_0xa97f257d0151a6ab = window.HideMapObjectThisFrame;

window.HideNumberOnBlip = function (blip) {
	return _in(0x532cff63, 0x7ef80148, blip);
};

window.HidePedBloodDamageByZone = function (ped, p1, p2) {
	return _in(0x62ab7931, 0x44de75dc, ped, p1, p2);
};
window.N_0x62ab793144de75dc = window.HidePedBloodDamageByZone;

/**
 * Hides the players weapon during a cutscene.
 */
window.HidePedWeaponForScriptedCutscene = function (ped, toggle) {
	return _in(0x6f6981d2, 0x253c208f, ped, toggle);
};

window.HideScriptedHudComponentThisFrame = function (id) {
	return _in(0xe374c498, 0xd8badc14, id);
};

/**
 * Hash collision
 * If used with a Ped that has an AI blip as the first argument:
 * - if p1 is true, a view cone is displayed with the AI blip
 */
window.HideSpecialAbilityLockonOperation = function (p0, p1) {
	return _in(0x3eed80df, 0xf7325caa, p0, p1);
};

/**
 * draws circular marker at pos
 * -1 = none
 * 0 = red
 * 1 = green
 * 2 = blue
 * 3 = green larger
 * 4 = nothing
 * 5 = green small
 */
window.HighlightPlacementCoords = function (x, y, z, colorIndex) {
	return _in(0x3430676b, 0x11cdf21d, _fv(x), _fv(y), _fv(z), colorIndex);
};
window.N_0x3430676b11cdf21d = window.HighlightPlacementCoords;

window.HintAmbientAudioBank = function (p0, p1) {
	return _in(0x8f8c0e37, 0x0ae62f5c, p0, p1, _r, _ri);
};

window.HintScriptAudioBank = function (p0, p1) {
	return _in(0xfb380a29, 0x641ec31a, p0, p1, _r, _ri);
};

window.IgnoreNextRestart = function (toggle) {
	return _in(0x21ffb63d, 0x8c615361, toggle);
};

window.InitShopPedComponent = function (outComponent) {
	return _in(0x1e8c308f, 0xd312c036, _ii(outComponent) /* may be optional */);
};

window.InitShopPedProp = function (outProp) {
	return _in(0xeb0a2b75, 0x8f7b850f, _ii(outProp) /* may be optional */);
};

/**
 * Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
 * --------------------------------------------------------
 * if (NETWORK::NETWORK_IS_PARTICIPANT_ACTIVE(PLAYER::INT_TO_PARTICIPANTINDEX(i)))
 */
window.IntToParticipantindex = function (value) {
	return _in(0x9ec66038, 0x12c24710, value, _r, _ri);
};

/**
 * Simply returns whatever is passed to it (Regardless of whether the handle is valid or not).
 */
window.IntToPlayerindex = function (value) {
	return _in(0x41bd2a6b, 0x006af756, value, _r, _ri);
};

window.InterruptConversation = function (p0) {
	return _in(0xa018a12e, 0x5c5c2fa6, p0, _i, _i);
};

window.InvokeFunctionReference = function (referenceIdentity, argsSerialized, argsLength, retvalLength) {
	return _in(0x00000000, 0xe3551879, _ts(referenceIdentity), _ts(argsSerialized), argsLength, _ii(retvalLength) /* may be optional */, _r, _s);
};

window.IsAceAllowed = function (object) {
	return _in(0x00000000, 0x7ebb9929, _ts(object), _r);
};

/**
 * if "flag" is true, the AI blip will always be displayed for the specified ped, if it has an AI blip
 * If "flag" is false, the AI blip will only be displayed when the player is in combat with the specified ped, if it has an AI blip
 */
window.IsAiBlipAlwaysShown = function (ped, flag) {
	return _in(0x0c4bbf62, 0x5ca98c4e, ped, flag);
};
window.N_0x0c4bbf625ca98c4e = window.IsAiBlipAlwaysShown;

window.IsAimCamActive = function () {
	return _in(0x68edda28, 0xa5976d07, _r);
};

/**
 * Example:
 * bool playing = AUDIO::IS_ALARM_PLAYING("PORT_OF_LS_HEIST_FORT_ZANCUDO_ALARMS");
 */
window.IsAlarmPlaying = function (alarmName) {
	return _in(0x226435cb, 0x96ccfc8c, _ts(alarmName), _r);
};

/**
 * Common in the scripts:
 * AUDIO::IS_AMBIENT_SPEECH_DISABLED(PLAYER::PLAYER_PED_ID());
 */
window.IsAmbientSpeechDisabled = function (ped) {
	return _in(0x932c2d09, 0x6a2c3fff, ped, _r);
};

window.IsAmbientSpeechPlaying = function (p0) {
	return _in(0x9072c8b4, 0x9907bfad, p0, _r);
};

window.IsAmbientZoneEnabled = function (ambientZone) {
	return _in(0x01e2817a, 0x479a7f9b, _ts(ambientZone), _r);
};

window.IsAnEntity = function (handle) {
	return _in(0x731ec8a9, 0x16bd11a1, handle, _r);
};

window.IsAnyObjectNearPoint = function (x, y, z, range, p4) {
	return _in(0x397dc58f, 0xf00298d1, _fv(x), _fv(y), _fv(z), _fv(range), p4, _r);
};

window.IsAnyPedNearPoint = function (x, y, z, radius) {
	return _in(0x08396149, 0x8679dc9f, _fv(x), _fv(y), _fv(z), _fv(radius), _r);
};

window.IsAnyPedShootingInArea = function (x1, y1, z1, x2, y2, z2, p6, p7) {
	return _in(0xa0d3d71e, 0xa1086c55, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), p6, p7, _r);
};

window.IsAnySpeechPlaying = function (ped) {
	return _in(0x72907235, 0x5fa39ec9, ped, _r);
};

window.IsAnyVehicleNearPoint = function (x, y, z, radius) {
	return _in(0x61e1dd61, 0x25a3eee6, _fv(x), _fv(y), _fv(z), _fv(radius), _r);
};

window.IsAreaOccupied = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12) {
	return _in(0xa61b4df5, 0x33dcb56e, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, p7, p8, p9, p10, p11, p12, _r);
};

window.IsAudioSceneActive = function (scene) {
	return _in(0xb65b6055, 0x6e2a9225, _ts(scene), _r);
};

/**
 * if (GAMEPLAY::IS_AUSSIE_VERSION()) {
 * sub_127a9(&l_31, 1024); // l_31 |= 1024
 * l_129 = 3;
 * sub_129d2("AUSSIE VERSION IS TRUE!?!?!"); // DEBUG
 * }
 * Used to block some of the prostitute stuff due to laws in Australia.
 */
window.IsAussieVersion = function () {
	return _in(0x9f1935ca, 0x1f724008, _r);
};

window.IsAutoSaveInProgress = function () {
	return _in(0x69240733, 0x738c19a0, _r);
};

window.IsBigVehicle = function (vehicle) {
	return _in(0x9f243d39, 0x19f442fe, vehicle, _r);
};

/**
 * <!-- Native implemented by Disquse. 0xFFF65C63 -->
 * Returns true if the minimap is currently expanded. False if it's the normal minimap state.
 * Use [`IsBigmapFull`](#_0x66EE14B2) to check if the full map is currently revealed on the minimap.
 * @return A bool indicating if the minimap is currently expanded or normal state.
 */
window.IsBigmapActive = function () {
	return _in(0x00000000, 0xfff65c63, _r);
};

/**
 * <!-- Native implemented by Disquse. 0x66EE14B2 -->
 * Returns true if the full map is currently revealed on the minimap.
 * Use [`IsBigmapActive`](#_0xFFF65C63) to check if the minimap is currently expanded or in it's normal state.
 * @return Returns true if the full map is currently revealed on the minimap.
 */
window.IsBigmapFull = function () {
	return _in(0x00000000, 0x66ee14b2, _r);
};

/**
 * Returns bit's boolean state from [offset] of [address].
 * Example:
 * GAMEPLAY::IS_BIT_SET(bitAddress, 1);
 * To enable and disable bits, see:
 * GAMEPLAY::SET_BIT(&bitAddress, 1);   // enable
 * GAMEPLAY::CLEAR_BIT(&bitAddress, 1); // disable
 */
window.IsBitSet = function (address, offset) {
	return _in(0xa921aa82, 0x0c25702f, address, offset, _r);
};

window.IsBlipFlashing = function (blip) {
	return _in(0xa5e41fd8, 0x3ad6cef0, blip, _r);
};

window.IsBlipOnMinimap = function (blip) {
	return _in(0xe41ca530, 0x51197a27, blip, _r);
};

window.IsBlipShortRange = function (blip) {
	return _in(0xda5f8727, 0xeb75b926, blip, _r);
};

window.IsBulletInAngledArea = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0x1a8b5f3c, 0x01e2b477, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, _r);
};

window.IsBulletInArea = function (p0, p1, p2, p3, p4) {
	return _in(0x3f202399, 0x9ad51c1f, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, _r);
};

window.IsBulletInBox = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xde0f6d74, 0x50d37351, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, _r);
};

/**
 * Returns whether or not the passed camera handle is active.
 */
window.IsCamActive = function (cam) {
	return _in(0xdfb2b516, 0x207d3534, cam, _r);
};

window.IsCamInterpolating = function (cam) {
	return _in(0x036f97c9, 0x08c2b52c, cam, _r);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.IsCamPlayingAnim = function (cam, animName, animDictionary) {
	return _in(0xc90621d8, 0xa0ceecf2, cam, _ts(animName), _ts(animDictionary), _r);
};

window.IsCamRendering = function (cam) {
	return _in(0x02ec0af5, 0xc5a49b7a, cam, _r);
};

window.IsCamShaking = function (cam) {
	return _in(0x6b24bfe8, 0x3a2be47b, cam, _r);
};

window.IsCamSplinePaused = function (p0) {
	return _in(0x0290f35c, 0x0ad97864, p0, _r);
};

window.IsCinematicCamRendering = function () {
	return _in(0xb15162cb, 0x5826e9e8, _r);
};

window.IsCinematicCamShaking = function () {
	return _in(0xbbc08f6b, 0x4cb8ff0a, _r);
};

window.IsCinematicShotActive = function (p0) {
	return _in(0xcc9f3371, 0xa7c28bc9, p0, _r);
};

/**
 * Control Groups:
 * enum InputGroups
 * {
 * INPUTGROUP_MOVE = 0,
 * INPUTGROUP_LOOK = 1,
 * INPUTGROUP_WHEEL = 2,
 * INPUTGROUP_CELLPHONE_NAVIGATE = 3,
 * INPUTGROUP_CELLPHONE_NAVIGATE_UD = 4,
 * INPUTGROUP_CELLPHONE_NAVIGATE_LR = 5,
 * INPUTGROUP_FRONTEND_DPAD_ALL = 6,
 * INPUTGROUP_FRONTEND_DPAD_UD = 7,
 * INPUTGROUP_FRONTEND_DPAD_LR = 8,
 * INPUTGROUP_FRONTEND_LSTICK_ALL = 9,
 * INPUTGROUP_FRONTEND_RSTICK_ALL = 10,
 * INPUTGROUP_FRONTEND_GENERIC_UD = 11,
 * INPUTGROUP_FRONTEND_GENERIC_LR = 12,
 * INPUTGROUP_FRONTEND_GENERIC_ALL = 13,
 * INPUTGROUP_FRONTEND_BUMPERS = 14,
 * INPUTGROUP_FRONTEND_TRIGGERS = 15,
 * INPUTGROUP_FRONTEND_STICKS = 16,
 * INPUTGROUP_SCRIPT_DPAD_ALL = 17,
 * INPUTGROUP_SCRIPT_DPAD_UD = 18,
 * INPUTGROUP_SCRIPT_DPAD_LR = 19,
 * INPUTGROUP_SCRIPT_LSTICK_ALL = 20,
 * INPUTGROUP_SCRIPT_RSTICK_ALL = 21,
 * INPUTGROUP_SCRIPT_BUMPERS = 22,
 * INPUTGROUP_SCRIPT_TRIGGERS = 23,
 * INPUTGROUP_WEAPON_WHEEL_CYCLE = 24,
 * INPUTGROUP_FLY = 25,
 * INPUTGROUP_SUB = 26,
 * INPUTGROUP_VEH_MOVE_ALL = 27,
 * INPUTGROUP_CURSOR = 28,
 * INPUTGROUP_CURSOR_SCROLL = 29,
 * INPUTGROUP_SNIPER_ZOOM_SECONDARY = 30,
 * INPUTGROUP_VEH_HYDRAULICS_CONTROL = 31,
 * MAX_INPUTGROUPS = 32,
 * INPUTGROUP_INVALID = 33
 * };
 * 0, 1 and 2 used in the scripts.
 */
window.IsControlEnabled = function (inputGroup, control) {
	return _in(0x1cea6bfd, 0xf248e5d9, inputGroup, control, _r);
};

/**
 * Returns whether a [control](https://docs.fivem.net/game-references/controls/) was newly pressed since the last check.
 * @param inputGroup The control system instance to use. Usually set to 0.
 * @param control The control ID to check.
 * @return True if the control was pressed.
 */
window.IsControlJustPressed = function (inputGroup, control) {
	return _in(0x58041710, 0x1ddb492f, inputGroup, control, _r);
};

/**
 * Returns whether a [control](https://docs.fivem.net/game-references/controls/) was newly released since the last check.
 * @param inputGroup The control system instance to use. Usually set to 0.
 * @param control The control ID to check.
 * @return True if the control was recently released.
 */
window.IsControlJustReleased = function (inputGroup, control) {
	return _in(0x50f94025, 0x9d3841e6, inputGroup, control, _r);
};

/**
 * Returns whether a [control](https://docs.fivem.net/game-references/controls/) is currently pressed.
 * @param inputGroup The control system instance to use. Usually set to 0.
 * @param control The control ID to check.
 * @return True if the control was pressed.
 */
window.IsControlPressed = function (inputGroup, control) {
	return _in(0xf3a21bcd, 0x95725a4a, inputGroup, control, _r);
};

/**
 * Returns whether a [control](https://docs.fivem.net/game-references/controls/) is currently _not_ pressed.
 * @param inputGroup The control system instance to use. Usually set to 0.
 * @param control The control ID to check.
 * @return True if the control is not pressed.
 */
window.IsControlReleased = function (inputGroup, control) {
	return _in(0x648ee3e7, 0xf38877dd, inputGroup, control, _r);
};

window.IsConversationPedDead = function (ped) {
	return _in(0xe0a0aec2, 0x14b1faba, ped, _r);
};

/**
 * xyz - relative to the world origin.
 */
window.IsCopPedInArea_3d = function (x1, y1, z1, x2, y2, z2) {
	return _in(0x16ec4839, 0x969f9f5e, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _r);
};

/**
 * Usage:
 * public bool isCopInRange(Vector3 Location, float Range)
 * {
 * return Function.Call<bool>(Hash.IS_COP_PED_IN_AREA_3D, Location.X - Range, Location.Y - Range, Location.Z - Range, Location.X + Range, Location.Y + Range, Location.Z + Range);
 * }
 */
window.IsCopVehicleInArea_3d = function (x1, x2, y1, y2, z1, z2) {
	return _in(0x7eef65d5, 0xf153e26a, _fv(x1), _fv(x2), _fv(y1), _fv(y2), _fv(z1), _fv(z2), _r);
};

window.IsCutsceneActive = function () {
	return _in(0x991251af, 0xc3981f84, _r);
};

window.IsCutscenePlaying = function () {
	return _in(0xd3c2e180, 0xa40f031e, _r);
};

window.IsDamageTrackerActiveOnNetworkId = function (netID) {
	return _in(0x6e192e33, 0xad436366, netID, _r);
};

window.IsDecalAlive = function (decal) {
	return _in(0xc694d749, 0x49cafd0c, decal, _r);
};

/**
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.IsDisabledControlJustPressed = function (inputGroup, control) {
	return _in(0x91aef906, 0xbca88877, inputGroup, control, _r);
};

/**
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.IsDisabledControlJustReleased = function (inputGroup, control) {
	return _in(0x305c8dcd, 0x79da8b0f, inputGroup, control, _r);
};

/**
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.IsDisabledControlPressed = function (inputGroup, control) {
	return _in(0xe2587f8c, 0xbbd87b1d, inputGroup, control, _r);
};

window.IsDlcDataEmpty = function (dlcData) {
	return _in(0xd4d7b033, 0xc3aa243c, _ii(dlcData) /* may be optional */, _r);
};
window.IsOutfitEmpty = window.IsDlcDataEmpty;

/**
 * Example:
 * DLC2::IS_DLC_PRESENT($\mpbusiness2\);
 * ($ = gethashkey)
 * bruteforce these:
 * 0xB119F6D
 * 0x96F02EE6
 */
window.IsDlcPresent = function (dlcHash) {
	return _in(0x812595a0, 0x644ce1de, _ch(dlcHash), _r);
};

/**
 * Use _GET_VEHICLE_MOD_DATA for modData
 */
window.IsDlcVehicleMod = function (modData) {
	return _in(0x0564b9ff, 0x9631b82c, modData, _r);
};
window.N_0x0564b9ff9631b82c = window.IsDlcVehicleMod;

window.IsDoorClosed = function (door) {
	return _in(0xc531ee8a, 0x1145a149, _ch(door), _r);
};

window.IsDrivebyTaskUnderneathDrivingTask = function (ped) {
	return _in(0x8785e6e4, 0x0c7a8818, ped, _r);
};

/**
 * Returns whether or not a browser is created for a specified DUI browser object.
 * @param duiObject The DUI browser handle.
 * @return A boolean indicating TRUE if the browser is created.
 */
window.IsDuiAvailable = function (duiObject) {
	return _in(0x00000000, 0x7aac3b4c, duiObject, _r);
};

/**
 * Gets whether or not this is the CitizenFX server.
 * @return A boolean value.
 */
window.IsDuplicityVersion = function () {
	return _in(0x00000000, 0xcf24c52e, _r);
};

/**
 * XBOX ONE
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.IsDurangoVersion = function () {
	return _in(0x4d982adb, 0x1978442d, _r);
};

window.IsEntityAMissionEntity = function (entity) {
	return _in(0x0a7b2709, 0x12999b3c, entity, _r);
};

window.IsEntityAPed = function (entity) {
	return _in(0x524ac5ec, 0xea15343e, entity, _r);
};

window.IsEntityAVehicle = function (entity) {
	return _in(0x6ac7003f, 0xa6e5575e, entity, _r);
};

window.IsEntityAnObject = function (entity) {
	return _in(0x8d68c8fd, 0x0faca94e, entity, _r);
};

/**
 * Checks if entity is within x/y/zSize distance of x/y/z.
 * Last three are unknown ints, almost always p7 = 0, p8 = 1, p9 = 0
 */
window.IsEntityAtCoord = function (entity, xPos, yPos, zPos, xSize, ySize, zSize, p7, p8, p9) {
	return _in(0x20b60995, 0x556d004f, entity, _fv(xPos), _fv(yPos), _fv(zPos), _fv(xSize), _fv(ySize), _fv(zSize), p7, p8, p9, _r);
};

/**
 * Checks if entity1 is within the box defined by x/y/zSize of entity2.
 * Last three parameters are almost alwasy p5 = 0, p6 = 1, p7 = 0
 */
window.IsEntityAtEntity = function (entity1, entity2, xSize, ySize, zSize, p5, p6, p7) {
	return _in(0x751b70c3, 0xd034e187, entity1, entity2, _fv(xSize), _fv(ySize), _fv(zSize), p5, p6, p7, _r);
};

window.IsEntityAttached = function (entity) {
	return _in(0xb346476e, 0xf1a64897, entity, _r);
};

window.IsEntityAttachedToAnyObject = function (entity) {
	return _in(0xcf511840, 0xceede0cc, entity, _r);
};

window.IsEntityAttachedToAnyPed = function (entity) {
	return _in(0xb1632e9a, 0x5f988d11, entity, _r);
};

window.IsEntityAttachedToAnyVehicle = function (entity) {
	return _in(0x26aa915a, 0xd89bfb4b, entity, _r);
};

window.IsEntityAttachedToEntity = function (from, to) {
	return _in(0xefbe7189, 0x8a993728, from, to, _r);
};

window.IsEntityDead = function (entity) {
	return _in(0x5f9532f3, 0xb5cc2551, entity, _r);
};

window.IsEntityFocus = function (entity) {
	return _in(0x2ddff3fb, 0x9075d747, entity, _r);
};

window.IsEntityInAir = function (entity) {
	return _in(0x886e37ec, 0x497200b6, entity, _r);
};

/**
 * Creates a spherical cone at origin that extends to surface with the angle specified. Then returns true if the entity is inside the spherical cone
 * Angle is measured in degrees.
 * These values are constant, most likely bogus:
 * p8 = 0, p9 = 1, p10 = 0
 * This method can also take two float<3> instead of 6 floats.
 */
window.IsEntityInAngledArea = function (entity, originX, originY, originZ, edgeX, edgeY, edgeZ, angle, p8, p9, p10) {
	return _in(0x51210ced, 0x3da1c78a, entity, _fv(originX), _fv(originY), _fv(originZ), _fv(edgeX), _fv(edgeY), _fv(edgeZ), _fv(angle), p8, p9, p10, _r);
};

window.IsEntityInArea = function (entity, x1, y1, z1, x2, y2, z2, p7, p8, p9) {
	return _in(0x54736aa4, 0x0e271165, entity, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), p7, p8, p9, _r);
};

window.IsEntityInWater = function (entity) {
	return _in(0xcfb0a0d8, 0xedd145a3, entity, _r);
};

window.IsEntityInZone = function (entity, zone) {
	return _in(0xb6463cf6, 0xaf527071, entity, _ts(zone), _r);
};

window.IsEntityOccluded = function (entity) {
	return _in(0xe31c2c72, 0xb8692b64, entity, _r);
};

window.IsEntityOnFire = function (entity) {
	return _in(0x28d3fed7, 0x190d3a0b, entity, _r);
};

/**
 * Returns true if the entity is in between the minimum and maximum values for the 2d screen coords.
 * This means that it will return true even if the entity is behind a wall for example, as long as you're looking at their location.
 * Chipping
 */
window.IsEntityOnScreen = function (entity) {
	return _in(0xe659e47a, 0xf827484b, entity, _r);
};

/**
 * See also PED::IS_SCRIPTED_SCENARIO_PED_USING_CONDITIONAL_ANIM 0x6EC47A344923E1ED 0x3C30B447
 * Taken from ENTITY::IS_ENTITY_PLAYING_ANIM(PLAYER::PLAYER_PED_ID(), "creatures@shark@move", "attack_player", 3)
 * p4 is always 3 in the scripts.
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 * taskFlag:
 * 2 - Check synchronized scene
 */
window.IsEntityPlayingAnim = function (entity, animDict, animName, taskFlag) {
	return _in(0x1f0b7922, 0x8e461ec9, entity, _ts(animDict), _ts(animName), taskFlag, _r);
};

/**
 * A static ped will not react to natives like "APPLY_FORCE_TO_ENTITY" or "SET_ENTITY_VELOCITY" and oftentimes will not react to task-natives like "AI::TASK_COMBAT_PED". The only way I know of to make one of these peds react is to ragdoll them (or sometimes to use CLEAR_PED_TASKS_IMMEDIATELY(). Static peds include almost all far-away peds, beach-combers, peds in certain scenarios, peds crossing a crosswalk, peds walking to get back into their cars, and others. If anyone knows how to make a ped non-static without ragdolling them, please edit this with the solution.
 * ^ Attach a phCollider to the ped.
 */
window.IsEntityStatic = function (entity) {
	return _in(0x1218e688, 0x6d3d8327, entity, _r);
};

window.IsEntityTouchingEntity = function (entity, targetEntity) {
	return _in(0x17ffc1b2, 0xba35a494, entity, targetEntity, _r);
};

window.IsEntityTouchingModel = function (entity, modelHash) {
	return _in(0x0f423237, 0x98a58c8c, entity, _ch(modelHash), _r);
};

/**
 * // add this to your CSS to view code with formatting intact.
 * // pre + hr + p { white-space: pre; } // -
 * bool isEntityUpright(Entity e, float angle) {
 * bool bIsUpright; // bl@1
 * CDynamicEntity* pEntity; // rdi@1
 * bIsUpright = 0;
 * pEntity = getEntityAddressIfPhysical(e);
 * if (pEntity) {
 * bIsUpright = 0;
 * if (pEntity->Matrix.up.z >= cosf(angle * 0.017453292)) // radians(angle)
 * bIsUpright = 1;
 * }
 * return bIsUpright;
 * }
 */
window.IsEntityUpright = function (entity, angle) {
	return _in(0x5333f526, 0xf6ab19aa, entity, _fv(angle), _r);
};

window.IsEntityUpsidedown = function (entity) {
	return _in(0x1dbd5882, 0x0fa61d71, entity, _r);
};

window.IsEntityVisible = function (entity) {
	return _in(0x47d6f43d, 0x77935c75, entity, _r);
};

window.IsEntityVisibleToScript = function (entity) {
	return _in(0xd796cb5b, 0xa8f20e32, entity, _r);
};

window.IsEntityWaitingForWorldCollision = function (entity) {
	return _in(0xd05bff0c, 0x0a12c68f, entity, _r);
};

window.IsExplosionInAngledArea = function (explosionType, x1, y1, z1, x2, y2, z2, angle) {
	return _in(0xa079a6c5, 0x1525dc4b, explosionType, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(angle), _r);
};

window.IsExplosionInArea = function (explosionType, x1, y1, z1, x2, y2, z2) {
	return _in(0x2e2eba0e, 0xe7ced0e0, explosionType, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _r);
};

window.IsExplosionInSphere = function (explosionType, x, y, z, radius) {
	return _in(0xab0f8168, 0x85b0e483, explosionType, _fv(x), _fv(y), _fv(z), _fv(radius), _r);
};

window.IsFirstPersonAimCamActive = function () {
	return _in(0x5e346d93, 0x4122613f, _r);
};

window.IsFollowPedCamActive = function () {
	return _in(0xc6d3d268, 0x10c8e0f9, _r);
};

window.IsFollowVehicleCamActive = function () {
	return _in(0xcbbde6d3, 0x35d6d496, _r);
};

/**
 * This function is hard-coded to always return 0.
 */
window.IsFrontendFading = function () {
	return _in(0x7ea2b6af, 0x97eca6ed, _r);
};

/**
 * Hardcoded to return 1
 */
window.IsGameInControlOfMusic = function () {
	return _in(0x6d28dc16, 0x71e334fd, _r);
};

window.IsGameplayCamLookingBehind = function () {
	return _in(0x70fda869, 0xf3317ea9, _r);
};

/**
 * Examples when this function will return 0 are:
 * - During busted screen.
 * - When player is coming out from a hospital.
 * - When player is coming out from a police station.
 */
window.IsGameplayCamRendering = function () {
	return _in(0x39b5d1b1, 0x0383f0c8, _r);
};

window.IsGameplayCamShaking = function () {
	return _in(0x016c0906, 0x30df1f89, _r);
};

window.IsGameplayHintActive = function () {
	return _in(0xe520ff1a, 0xd2785b40, _r);
};

window.IsGarageEmpty = function (garage, p1, p2) {
	return _in(0x90e47239, 0xea1980b8, garage, p1, p2, _r);
};

window.IsHeliPartBroken = function (vehicle, p1, p2, p3) {
	return _in(0xbc74b4be, 0x25eb6c8a, vehicle, p1, p2, p3, _r);
};

window.IsHelpMessageBeingDisplayed = function () {
	return _in(0x4d79439a, 0x6b55ac67, _r);
};

window.IsHelpMessageFadingOut = function () {
	return _in(0x327edeee, 0xac55c369, _r);
};

/**
 * Doesn't appear to work, use IS_HELP_MESSAGE_BEING_DISPLAYED instead
 */
window.IsHelpMessageOnScreen = function () {
	return _in(0xdad37f45, 0x428801ae, _r);
};

/**
 * Checks whether the horn of a vehicle is currently played.
 */
window.IsHornActive = function (vehicle) {
	return _in(0x9d6bfc12, 0xb05c6121, vehicle, _r);
};

/**
 * Full list of components below
 * HUD = 0;
 * HUD_WANTED_STARS = 1;
 * HUD_WEAPON_ICON = 2;
 * HUD_CASH = 3;
 * HUD_MP_CASH = 4;
 * HUD_MP_MESSAGE = 5;
 * HUD_VEHICLE_NAME = 6;
 * HUD_AREA_NAME = 7;
 * HUD_VEHICLE_CLASS = 8;
 * HUD_STREET_NAME = 9;
 * HUD_HELP_TEXT = 10;
 * HUD_FLOATING_HELP_TEXT_1 = 11;
 * HUD_FLOATING_HELP_TEXT_2 = 12;
 * HUD_CASH_CHANGE = 13;
 * HUD_RETICLE = 14;
 * HUD_SUBTITLE_TEXT = 15;
 * HUD_RADIO_STATIONS = 16;
 * HUD_SAVING_GAME = 17;
 * HUD_GAME_STREAM = 18;
 * HUD_WEAPON_WHEEL = 19;
 * HUD_WEAPON_WHEEL_STATS = 20;
 * MAX_HUD_COMPONENTS = 21;
 * MAX_HUD_WEAPONS = 22;
 * MAX_SCRIPTED_HUD_COMPONENTS = 141;
 */
window.IsHudComponentActive = function (id) {
	return _in(0xbc4c9ea5, 0x391ecc0d, id, _r);
};

window.IsHudHidden = function () {
	return _in(0xa86478c6, 0x958735c5, _r);
};

window.IsHudPreferenceSwitchedOn = function () {
	return _in(0x1930dfa7, 0x31813ec4, _r);
};

window.IsInItemset = function (p0, p1) {
	return _in(0x2d0fc594, 0xd1e9c107, p0, p1, _r);
};

/**
 * Only occurrence was false, in maintransition.
 */
window.IsInLoadingScreen = function (p0) {
	return _in(0xfc309e94, 0x546fcdb5, p0);
};
window.N_0xfc309e94546fcdb5 = window.IsInLoadingScreen;

window.IsInVehicleCamDisabled = function () {
	return _in(0x4f32c0d5, 0xa90a9b40, _r);
};
window.N_0x4f32c0d5a90a9b40 = window.IsInVehicleCamDisabled;

/**
 * =======================================================
 * Correction, I have change this to int, instead of int*
 * as it doesn't use a pointer to the createdIncident.
 * If you try it you will crash (or) freeze.
 * =======================================================
 */
window.IsIncidentValid = function (incidentId) {
	return _in(0xc8bc6461, 0xe629beaa, incidentId, _r);
};

/**
 * Seems to return true if the input is currently disabled. "_GET_LAST_INPUT_METHOD" didn't seem very accurate, but I've left the original description below.
 * --
 * index usually 2
 * returns true if the last input method was made with mouse + keyboard, false if it was made with a gamepad
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.IsInputDisabled = function (inputGroup) {
	return _in(0xa571d467, 0x27e2b718, inputGroup, _r);
};
window.GetLastInputMethod = window.IsInputDisabled;

/**
 * I may be wrong with this one, but from the looks of the scripts, it sets keyboard related stuff as soon as this returns true.
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.IsInputJustDisabled = function (inputGroup) {
	return _in(0x13337b38, 0xdb572509, inputGroup, _r);
};
window.N_0x13337b38db572509 = window.IsInputJustDisabled;

window.IsInteriorCapped = function (interiorID) {
	return _in(0x92bac8ac, 0xf88cec26, interiorID, _r);
};

window.IsInteriorDisabled = function (interiorID) {
	return _in(0xbc5115a5, 0xa939dd15, interiorID, _r);
};

window.IsInteriorPropEnabled = function (interiorID, propName) {
	return _in(0x35f7dd45, 0xe8c0a16d, interiorID, _ts(propName), _r);
};
window.N_0x35f7dd45e8c0a16d = window.IsInteriorPropEnabled;

window.IsInteriorReady = function (interiorID) {
	return _in(0x6726bdcc, 0xc1932f0e, interiorID, _r);
};

/**
 * Returns a bool if interior rendering is disabled, if yes, all "normal" rendered interiors are invisible
 */
window.IsInteriorRenderingDisabled = function () {
	return _in(0x95ab8b5c, 0x992c7b58, _r);
};

window.IsInteriorScene = function () {
	return _in(0xbc72b5d7, 0xa1cbd54d, _r);
};

/**
 * List of all IPLs: pastebin.com/iNGLY32D
 */
window.IsIplActive = function (iplName) {
	return _in(0x88a741e4, 0x4a2b3495, _ts(iplName), _r);
};

window.IsItemsetValid = function (p0) {
	return _in(0xb1b1ea59, 0x6344dfab, p0, _r);
};

window.IsLoadingPromptBeingDisplayed = function () {
	return _in(0xd422fcc5, 0xf239a915, _r);
};
window.N_0xd422fcc5f239a915 = window.IsLoadingPromptBeingDisplayed;

window.IsLookInverted = function () {
	return _in(0x77b61253, 0x1280010d, _r);
};

window.IsMemoryCardInUse = function () {
	return _in(0x8a75ce29, 0x56274add, _r);
};

window.IsMessageBeingDisplayed = function () {
	return _in(0x7984c03a, 0xa5cc2f41, _r);
};

window.IsMinigameInProgress = function () {
	return _in(0x2b4a15e4, 0x4de0f478, _r);
};

window.IsMinimapAreaRevealed = function (x, y, radius) {
	return _in(0x6e31b911, 0x45873922, _fv(x), _fv(y), _fv(radius), _r);
};
window.N_0x6e31b91145873922 = window.IsMinimapAreaRevealed;

window.IsMissionCompletePlaying = function () {
	return _in(0x19a30c23, 0xf5827f8a, _r);
};

window.IsMissionCreatorBlip = function (blip) {
	return _in(0x26f49bf3, 0x381d933d, blip, _r);
};

window.IsMobilePhoneCallOngoing = function () {
	return _in(0x7497d2ce, 0x2c30d24c, _r);
};

window.IsMobilePhoneRadioActive = function () {
	return _in(0xb35ce999, 0xe8ef317e, _r);
};

window.IsModelAPed = function (modelHash) {
	return _in(0x75816577, 0xfea6dad5, _ch(modelHash), _r);
};

/**
 * Returns whether the specified model represents a vehicle.
 */
window.IsModelAVehicle = function (model) {
	return _in(0x19aac8f0, 0x7bfec53e, _ch(model), _r);
};

/**
 * Check if model is in cdimage(rpf)
 */
window.IsModelInCdimage = function (model) {
	return _in(0x35b9e080, 0x3292b641, _ch(model), _r);
};

/**
 * Returns whether the specified model exists in the game.
 */
window.IsModelValid = function (model) {
	return _in(0xc0296a2e, 0xdf545e92, _ch(model), _r);
};

window.IsMountedWeaponTaskUnderneathDrivingTask = function (ped) {
	return _in(0xa320ef04, 0x6186fa3b, ped, _r);
};

window.IsMoveBlendRatioRunning = function (ped) {
	return _in(0xd4d8636c, 0x0199a939, ped, _r);
};

window.IsMoveBlendRatioSprinting = function (ped) {
	return _in(0x24a2ad74, 0xfa9814e2, ped, _r);
};

window.IsMoveBlendRatioStill = function (ped) {
	return _in(0x349ce7b5, 0x6dafd95c, ped, _r);
};

window.IsMoveBlendRatioWalking = function (ped) {
	return _in(0xf133bbbe, 0x91e1691f, ped, _r);
};

window.IsMpGamerTagActive = function (gamerTagId) {
	return _in(0x4e929e7a, 0x5796fd26, gamerTagId, _r);
};
window.N_0x4e929e7a5796fd26 = window.IsMpGamerTagActive;

window.IsNamedRendertargetLinked = function (hash) {
	return _in(0x11375053, 0x8fa31298, _ch(hash), _r);
};

window.IsNamedRendertargetRegistered = function (p0) {
	return _in(0x78dcdc15, 0xc9f116b4, _ts(p0), _r);
};

/**
 * Returns whether navmesh for the region is loaded. The region is a rectangular prism defined by it's top left deepest corner to it's bottom right shallowest corner.
 * If you can re-word this so it makes more sense, please do. I'm horrible with words sometimes...
 */
window.IsNavmeshLoadedInArea = function (x1, y1, z1, x2, y2, z2) {
	return _in(0xf813c7e6, 0x3f9062a5, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _r);
};

window.IsNetworkLoadingScene = function () {
	return _in(0x41ca5a33, 0x160ea4ab, _r);
};

/**
 * hash collision.
 * Definitely a hash collision, has something do to with your local player, not a vehicle
 */
window.IsNetworkVehicleBeenDamagedByAnyObject = function (x, y, z) {
	return _in(0xdbd20566, 0x52689917, _fv(x), _fv(y), _fv(z), _r);
};

window.IsNewLoadSceneActive = function () {
	return _in(0xa41a05b6, 0xcb741b85, _r);
};

window.IsNewLoadSceneLoaded = function () {
	return _in(0x01b8247a, 0x7a8b9ad1, _r);
};

window.IsNextWeatherType = function (weatherType) {
	return _in(0x2faa3a30, 0xbec0f25d, _ts(weatherType), _r);
};

/**
 * Gets whether or not NIGHTVISION is Active.
 * Note:  When nightvision is actually active, this native will return TRUE!
 */
window.IsNightvisionActive = function () {
	return _in(0x2202a3f4, 0x2c8e5f79, _r);
};
window.IsNightvisionInactive = window.IsNightvisionActive;

window.IsObjectNearPoint = function (objectHash, x, y, z, range) {
	return _in(0x8c90fe4b, 0x381ba60a, _ch(objectHash), _fv(x), _fv(y), _fv(z), _fv(range), _r);
};

window.IsObjectVisible = function (object) {
	return _in(0x8b32ace6, 0x326a7546, object, _r);
};

window.IsObjectWithinBrainActivationRange = function (object) {
	return _in(0xccba1542, 0x09823057, object, _r);
};

/**
 * PS4
 * MulleDK19: This function is hard-coded to always return 0.
 * Force67: I patched return result and got this : i.imgur.com/hUn7zSj.jpg
 * translate please?
 */
window.IsOrbisVersion = function () {
	return _in(0xa72bc0b6, 0x75b1519e, _r);
};

window.IsParticleFxDelayedBlink = function () {
	return _in(0x5ccabffc, 0xa31dde33, _r, _rf);
};

window.IsPauseMenuActive = function () {
	return _in(0xb0034a22, 0x3497ffcb, _r);
};

window.IsPauseMenuRestarting = function () {
	return _in(0x1c491717, 0x107431c7, _r);
};

/**
 * MulleDK19: This function is hard-coded to always return 1.
 */
window.IsPcVersion = function () {
	return _in(0x48af3644, 0x4b965238, _r);
};

/**
 * Returns true if the given ped has a valid pointer to CPlayerInfo in its CPed class. That's it.
 */
window.IsPedAPlayer = function (ped) {
	return _in(0x12534c34, 0x8c6cb68b, ped, _r);
};

window.IsPedActiveInScenario = function (ped) {
	return _in(0xaa135f94, 0x82c82cc3, ped, _r);
};

window.IsPedAimingFromCover = function (ped) {
	return _in(0x3998b127, 0x6a3300e5, ped, _r);
};

/**
 * p1 is anywhere from 4 to 7 in the scripts. Might be a weapon wheel group?
 * ^It's kinda like that.
 * 7 returns true if you are equipped with any weapon except your fists.
 * 6 returns true if you are equipped with any weapon except melee weapons.
 * 5 returns true if you are equipped with any weapon except the Explosives weapon group.
 * 4 returns true if you are equipped with any weapon except Explosives weapon group AND melee weapons.
 * 3 returns true if you are equipped with either Explosives or Melee weapons (the exact opposite of 4).
 * 2 returns true only if you are equipped with any weapon from the Explosives weapon group.
 * 1 returns true only if you are equipped with any Melee weapon.
 * 0 never returns true.
 * Note: When I say "Explosives weapon group", it does not include the Jerry can and Fire Extinguisher.
 */
window.IsPedArmed = function (ped, p1) {
	return _in(0x475768a9, 0x75d5ad17, ped, p1, _r);
};

/**
 * This function is hard-coded to always return 0.
 */
window.IsPedBeingArrested = function (ped) {
	return _in(0x90a09f3a, 0x45fed688, ped, _r);
};

window.IsPedBeingJacked = function (ped) {
	return _in(0x9a497fe2, 0xdf198913, ped, _r);
};

window.IsPedBeingStealthKilled = function (ped) {
	return _in(0x863b23ef, 0xde9c5df2, ped, _r);
};

/**
 * p1 is always 0
 */
window.IsPedBeingStunned = function (ped, p1) {
	return _in(0x4fbacce3, 0xb4138ee8, ped, p1, _r);
};

window.IsPedBlushColorValid = function (colorID) {
	return _in(0x604e8101, 0x89ee3a59, colorID, _r);
};
window.N_0x604e810189ee3a59 = window.IsPedBlushColorValid;

window.IsPedClimbing = function (ped) {
	return _in(0x53e8cb4f, 0x48bfe623, ped, _r);
};

/**
 * Checks if the component variation is valid, this works great for randomizing components using loops.
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.IsPedComponentVariationValid = function (ped, componentId, drawableId, textureId) {
	return _in(0xe825f6b6, 0xcea7671d, ped, componentId, drawableId, textureId, _r);
};

/**
 * l
 */
window.IsPedCuffed = function (ped) {
	return _in(0x74e559b3, 0xbc910685, ped, _r);
};

/**
 * This native returns a true or false value.
 * Ped ped = The ped whose weapon you want to check.
 */
window.IsPedCurrentWeaponSilenced = function (ped) {
	return _in(0x65f0c5ae, 0x05943ec7, ped, _r);
};

/**
 * Seems to consistently return true if the ped is dead.
 * p1 is always passed 1 in the scripts.
 * I suggest to remove "OR_DYING" part, because it does not detect dying phase.
 * That's what the devs call it, cry about it.
 * lol
 * that's a good meme right there.
 */
window.IsPedDeadOrDying = function (ped, p1) {
	return _in(0x3317dedb, 0x88c95038, ped, p1, _r);
};

window.IsPedDiving = function (ped) {
	return _in(0x5527b824, 0x6fef9b11, ped, _r);
};

window.IsPedDoingDriveby = function (ped) {
	return _in(0xb2c086cc, 0x1bf8f2bf, ped, _r);
};

window.IsPedDucking = function (ped) {
	return _in(0xd125ae74, 0x8725c6bc, ped, _r);
};

/**
 * Presumably returns the Entity that the Ped is currently diving out of the way of.
 * var num3;
 * if (PED::IS_PED_EVASIVE_DIVING(A_0, &num3) != 0)
 * if (ENTITY::IS_ENTITY_A_VEHICLE(num3) != 0)
 */
window.IsPedEvasiveDiving = function (ped, evadingEntity) {
	return _in(0x414641c2, 0x6e105898, ped, _ii(evadingEntity) /* may be optional */, _r);
};

/**
 * angle is ped's view cone
 */
window.IsPedFacingPed = function (ped, otherPed, angle) {
	return _in(0xd71649db, 0x0a545aa3, ped, otherPed, _fv(angle), _r);
};

window.IsPedFalling = function (ped) {
	return _in(0xfb92a102, 0xf1c4dfa3, ped, _r);
};

/**
 * Gets a value indicating whether this ped's health is below its fatally injured threshold. The default threshold is 100.
 * If the handle is invalid, the function returns true.
 */
window.IsPedFatallyInjured = function (ped) {
	return _in(0xd8394507, 0x56ed5a80, ped, _r);
};

window.IsPedFleeing = function (ped) {
	return _in(0xbbcce00b, 0x381f8482, ped, _r);
};

window.IsPedGettingIntoAVehicle = function (ped) {
	return _in(0xbb062b2b, 0x5722478e, ped, _r);
};

window.IsPedGettingUp = function (ped) {
	return _in(0x2a74e1d5, 0xf2f00eec, ped, _r);
};

window.IsPedGoingIntoCover = function (ped) {
	return _in(0x9f65dbc5, 0x37e59ad5, ped, _r);
};

window.IsPedGroupMember = function (ped, groupId) {
	return _in(0x9bb01e38, 0x34671191, ped, groupId, _r);
};

window.IsPedHairColorValid = function (colorID) {
	return _in(0xe0d36e5d, 0x9e99cc21, colorID, _r);
};
window.N_0xe0d36e5d9e99cc21 = window.IsPedHairColorValid;

window.IsPedHangingOnToVehicle = function (ped) {
	return _in(0x1c86d8ae, 0xf8254b78, ped, _r);
};

window.IsPedHeadtrackingEntity = function (ped, entity) {
	return _in(0x813a0a7c, 0x9d2e831f, ped, entity, _r);
};

window.IsPedHeadtrackingPed = function (ped1, ped2) {
	return _in(0x5cd3cb88, 0xa7f8850d, ped1, ped2, _r);
};

/**
 * Returns true/false if the ped is/isn't humanoid.
 */
window.IsPedHuman = function (ped) {
	return _in(0xb980061d, 0xa992779d, ped, _r);
};

/**
 * Returns whether the specified ped is hurt.
 */
window.IsPedHurt = function (ped) {
	return _in(0x5983bb44, 0x9d7fdb12, ped, _r);
};

window.IsPedInAnyBoat = function (ped) {
	return _in(0x2e0e1c2b, 0x4f6cb339, ped, _r);
};

window.IsPedInAnyHeli = function (ped) {
	return _in(0x298b91ae, 0x825e5705, ped, _r);
};

window.IsPedInAnyPlane = function (ped) {
	return _in(0x5fff4cfc, 0x74d8fb80, ped, _r);
};

window.IsPedInAnyPoliceVehicle = function (ped) {
	return _in(0x0bd04e29, 0x640c9c12, ped, _r);
};

window.IsPedInAnySub = function (ped) {
	return _in(0xfbfc01cc, 0xfb35d99e, ped, _r);
};

window.IsPedInAnyTaxi = function (ped) {
	return _in(0x6e575d6a, 0x898ab852, ped, _r);
};

window.IsPedInAnyTrain = function (ped) {
	return _in(0x6f972c1a, 0xb75a1ed0, ped, _r);
};

/**
 * Returns whether the specified ped is in any vehicle. If `atGetIn` is set to true, also returns true if the ped is
 * currently in the process of entering a vehicle (a specific stage check for `CTaskEnterVehicle`).
 * @param ped The ped to check.
 * @param atGetIn `true` to also consider attempting to enter a vehicle.
 * @return Whether or not the ped is currently involved in any vehicle.
 */
window.IsPedInAnyVehicle = function (ped, atGetIn) {
	return _in(0x997abd67, 0x1d25ca0b, ped, atGetIn, _r);
};

/**
 * Checks to see if ped and target are in combat with eachother. Only goes one-way: if target is engaged in combat with ped but ped has not yet reacted, the function will return false until ped starts fighting back.
 * p1 is usually 0 in the scripts because it gets the ped id during the task sequence. For instance: PED::IS_PED_IN_COMBAT(l_42E[4 -- [[14]] ], PLAYER::PLAYER_PED_ID()) // armenian2.ct4: 43794
 */
window.IsPedInCombat = function (ped, target) {
	return _in(0x4859f1fc, 0x66a6278e, ped, target, _r);
};

/**
 * p1 is nearly always 0 in the scripts.
 */
window.IsPedInCover = function (ped, exceptUseWeapon) {
	return _in(0x60dfd069, 0x1a170b88, ped, exceptUseWeapon, _r);
};

window.IsPedInCoverFacingLeft = function (ped) {
	return _in(0x845333b3, 0x150583ab, ped, _r);
};

window.IsPedInCurrentConversation = function (ped) {
	return _in(0x049e937f, 0x18f4020c, ped, _r);
};

window.IsPedInFlyingVehicle = function (ped) {
	return _in(0x91348735, 0x37fa419c, ped, _r);
};

window.IsPedInGroup = function (ped) {
	return _in(0x5891cac5, 0xd4acff74, ped, _r);
};

/**
 * Notes: The function only returns true while the ped is:
 * A.) Swinging a random melee attack (including pistol-whipping)
 * B.) Reacting to being hit by a melee attack (including pistol-whipping)
 * C.) Is locked-on to an enemy (arms up, strafing/skipping in the default fighting-stance, ready to dodge+counter).
 * You don't have to be holding the melee-targetting button to be in this stance; you stay in it by default for a few seconds after swinging at someone. If you do a sprinting punch, it returns true for the duration of the punch animation and then returns false again, even if you've punched and made-angry many peds
 */
window.IsPedInMeleeCombat = function (ped) {
	return _in(0x4e209b2c, 0x1ead5159, ped, _r);
};

window.IsPedInModel = function (ped, modelHash) {
	return _in(0x796d90ef, 0xb19aa332, ped, _ch(modelHash), _r);
};

window.IsPedInParachuteFreeFall = function (ped) {
	return _in(0x7dce8bda, 0x0f1c1200, ped, _r);
};

/**
 * Gets a value indicating whether the specified ped is in the specified vehicle.
 * If 'atGetIn' is false, the function will not return true until the ped is sitting in the vehicle and is about to close the door. If it's true, the function returns true the moment the ped starts to get onto the seat (after opening the door). Eg. if false, and the ped is getting into a submersible, the function will not return true until the ped has descended down into the submersible and gotten into the seat, while if it's true, it'll return true the moment the hatch has been opened and the ped is about to descend into the submersible.
 */
window.IsPedInVehicle = function (ped, vehicle, atGetIn) {
	return _in(0xa3ee4a07, 0x279bb9db, ped, vehicle, atGetIn, _r);
};

/**
 * returns true is the ped is on the ground whining like a little female dog from a gunshot wound
 */
window.IsPedInWrithe = function (ped) {
	return _in(0xdeb6d521, 0x26e7d640, ped, _r);
};

/**
 * Gets a value indicating whether this ped's health is below its injured threshold.
 * The default threshold is 100.
 */
window.IsPedInjured = function (ped) {
	return _in(0x84a2dd9a, 0xc37c35c1, ped, _r);
};

window.IsPedJacking = function (ped) {
	return _in(0x4ae4ff91, 0x1dfb61da, ped, _r);
};

window.IsPedJumping = function (ped) {
	return _in(0xcedabc59, 0x00a0bf97, ped, _r);
};

window.IsPedJumpingOutOfVehicle = function (ped) {
	return _in(0x433ddffe, 0x2044b636, ped, _r);
};

window.IsPedLipstickColorValid = function (colorID) {
	return _in(0x0525a2c2, 0x562f3cd4, colorID, _r);
};
window.N_0x0525a2c2562f3cd4 = window.IsPedLipstickColorValid;

/**
 * Returns true/false if the ped is/isn't male.
 */
window.IsPedMale = function (ped) {
	return _in(0x6d9f5faa, 0x7488ba46, ped, _r);
};

window.IsPedModel = function (ped, modelHash) {
	return _in(0xc9d55b1a, 0x358a5bf7, ped, _ch(modelHash), _r);
};

window.IsPedOnAnyBike = function (ped) {
	return _in(0x94495889, 0xe22c6479, ped, _r);
};

window.IsPedOnFoot = function (ped) {
	return _in(0x01fee67d, 0xb37f59b2, ped, _r);
};

/**
 * Same function call as PED::GET_MOUNT, aka just returns 0
 */
window.IsPedOnMount = function (ped) {
	return _in(0x460bc76a, 0x0e10655e, ped, _r);
};

window.IsPedOnSpecificVehicle = function (ped, vehicle) {
	return _in(0xec5f66e4, 0x59af3bb2, ped, vehicle, _r);
};

/**
 * Gets a value indicating whether the specified ped is on top of any vehicle.
 * Return 1 when ped is on vehicle.
 * Return 0 when ped is not on a vehicle.
 */
window.IsPedOnVehicle = function (ped) {
	return _in(0x67722aeb, 0x798e5fab, ped, _r);
};

window.IsPedPerformingStealthKill = function (ped) {
	return _in(0xfd4ccdbc, 0xc59941b7, ped, _r);
};

window.IsPedPlantingBomb = function (ped) {
	return _in(0xc70b5fae, 0x151982d8, ped, _r);
};

window.IsPedProne = function (ped) {
	return _in(0xd6a86331, 0xa537a7b9, ped, _r);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.IsPedPropValid = function (ped, componentId, drawableId, TextureId) {
	return _in(0x2b16a3bf, 0xf1fbce49, ped, componentId, drawableId, TextureId, _r);
};
window.N_0x2b16a3bff1fbce49 = window.IsPedPropValid;

/**
 * If the ped handle passed through the parenthesis is in a ragdoll state this will return true.
 */
window.IsPedRagdoll = function (ped) {
	return _in(0x47e4e977, 0x581c5b55, ped, _r);
};

/**
 * Returns whether the specified ped is reloading.
 */
window.IsPedReloading = function (ped) {
	return _in(0x24b100c6, 0x8c645951, ped, _r);
};

window.IsPedRespondingToEvent = function (ped, event) {
	return _in(0x625b774d, 0x75c87068, ped, event, _r);
};

window.IsPedRingtonePlaying = function (ped) {
	return _in(0x1e8e5e20, 0x937e3137, ped, _r);
};

window.IsPedRunning = function (ped) {
	return _in(0xc5286ffc, 0x176f28a2, ped, _r);
};

window.IsPedRunningArrestTask = function (ped) {
	return _in(0x3dc52677, 0x769b4ae0, ped, _r);
};

window.IsPedRunningMobilePhoneTask = function (ped) {
	return _in(0x2afe52f7, 0x82f25775, ped, _r);
};

window.IsPedRunningRagdollTask = function (ped) {
	return _in(0xe3b6097c, 0xc25aa69e, ped, _r);
};

/**
 * Returns whether the specified ped is shooting.
 */
window.IsPedShooting = function (ped) {
	return _in(0x34616828, 0xcd07f1a1, ped, _r);
};

window.IsPedShootingInArea = function (ped, x1, y1, z1, x2, y2, z2, p7, p8) {
	return _in(0x7e9dfe24, 0xac1e58ef, ped, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), p7, p8, _r);
};

/**
 * Detect if ped is in any vehicle
 * [True/False]
 */
window.IsPedSittingInAnyVehicle = function (ped) {
	return _in(0x826aa586, 0xedb9fef8, ped, _r);
};

/**
 * Detect if ped is sitting in the specified vehicle
 * [True/False]
 */
window.IsPedSittingInVehicle = function (ped, vehicle) {
	return _in(0xa808aa1d, 0x79230fc2, ped, vehicle, _r);
};

window.IsPedSprinting = function (ped) {
	return _in(0x57e457cd, 0x2c0fc168, ped, _r);
};

/**
 * Console Hash: 0xDD5D08A7
 */
window.IsPedStandingInCover = function (ped) {
	return _in(0x6a03bf94, 0x3d767c93, ped, _r);
};
window.N_0x6a03bf943d767c93 = window.IsPedStandingInCover;

window.IsPedStill = function (ped) {
	return _in(0xac29253e, 0xef8f0180, ped, _r);
};

/**
 * Returns true if the ped doesn't do any movement. If the ped is being pushed forwards by using APPLY_FORCE_TO_ENTITY for example, the function returns false.
 */
window.IsPedStopped = function (ped) {
	return _in(0x530944f6, 0xf4b8a214, ped, _r);
};

/**
 * What's strafing?
 */
window.IsPedStrafing = function (ped) {
	return _in(0xe45b7f22, 0x2de47e09, ped, _r);
};

window.IsPedSwimming = function (ped) {
	return _in(0x9de32763, 0x1295b4c2, ped, _r);
};

window.IsPedSwimmingUnderWater = function (ped) {
	return _in(0xc024869a, 0x53992f34, ped, _r);
};

window.IsPedTracked = function (ped) {
	return _in(0x4c5e1f08, 0x7cd10bb7, ped, _r);
};

window.IsPedTryingToEnterALockedVehicle = function (ped) {
	return _in(0x44d28d5d, 0xdfe5f68c, ped, _r);
};

window.IsPedUsingActionMode = function (ped) {
	return _in(0x00e73468, 0xd085f745, ped, _r);
};

window.IsPedUsingAnyScenario = function (ped) {
	return _in(0x57ab4a30, 0x80f85143, ped, _r);
};

window.IsPedUsingScenario = function (ped, scenario) {
	return _in(0x1bf09473, 0x6dd62c2e, ped, _ts(scenario), _r);
};

/**
 * Definition of vaulting?
 */
window.IsPedVaulting = function (ped) {
	return _in(0x117c70d1, 0xf5730b5e, ped, _r);
};

window.IsPedWalking = function (ped) {
	return _in(0xde4c184b, 0x2b9b071a, ped, _r);
};

window.IsPedWeaponComponentActive = function (ped, weaponHash, componentHash) {
	return _in(0x0d78de05, 0x72d3969e, ped, _ch(weaponHash), _ch(componentHash), _r);
};

/**
 * Probably checks whether the ped has finished reloading or not and if the current weapon is not being switched to another.
 */
window.IsPedWeaponReadyToShoot = function (ped) {
	return _in(0xb80ca294, 0xf2f26749, ped, _r);
};

/**
 * Returns true if the ped passed through the parenthesis is wearing a helmet.
 */
window.IsPedWearingHelmet = function (ped) {
	return _in(0xf33bdfe1, 0x9b309b19, ped, _r);
};

/**
 * gtaforums.com/topic/885580-ped-headshotmugshot-txd/
 */
window.IsPedheadshotReady = function (handle) {
	return _in(0x70852288, 0x42b13a67, handle, _r);
};

/**
 * gtaforums.com/topic/885580-ped-headshotmugshot-txd/
 */
window.IsPedheadshotValid = function (handle) {
	return _in(0xa0a9668f, 0x158129a2, handle, _r);
};

/**
 * Pickup hashes: pastebin.com/8EuSv2r1
 */
window.IsPickupWithinRadius = function (pickupHash, x, y, z, radius) {
	return _in(0xf9c36251, 0xf6e48e33, _ch(pickupHash), _fv(x), _fv(y), _fv(z), _fv(radius), _r);
};

window.IsPlaybackGoingOnForVehicle = function (p0) {
	return _in(0x1c8a4c2c, 0x19e68eec, p0, _r);
};

window.IsPlaybackUsingAiGoingOnForVehicle = function (p0) {
	return _in(0xaea8fd59, 0x1fad4106, p0, _r);
};

/**
 * Return true while player is being arrested / busted.
 * If atArresting is set to 1, this function will return 1 when player is being arrested (while player is putting his hand up, but still have control)
 * If atArresting is set to 0, this function will return 1 only when the busted screen is shown.
 */
window.IsPlayerBeingArrested = function (player, atArresting) {
	return _in(0x388a47c5, 0x1abdac8e, player, atArresting, _r);
};

/**
 * Returns true when the player is not able to control the cam i.e. when running a benchmark test, switching the player or viewing a cutscene.
 * Note: I am not 100% sure if the native actually checks if the cam control is disabled but it seems promising.
 */
window.IsPlayerCamControlDisabled = function () {
	return _in(0x7c814d2f, 0xb49f40c0, _r);
};
window.N_0x7c814d2fb49f40c0 = window.IsPlayerCamControlDisabled;

/**
 * Returns TRUE if the player ('s ped) is climbing at the moment.
 */
window.IsPlayerClimbing = function (player) {
	return _in(0x95e8f73d, 0xc65efb9c, player, _r);
};

/**
 * Can the player control himself, used to disable controls for player for things like a cutscene.
 * ---
 * You can't disable controls with this, use SET_PLAYER_CONTROL(...) for this.
 */
window.IsPlayerControlOn = function (player) {
	return _in(0x49c32d60, 0x007afa47, player, _r);
};

window.IsPlayerDead = function (player) {
	return _in(0x424d4687, 0xfa1e5652, player, _r);
};

/**
 * Gets a value indicating whether the specified player is currently aiming freely.
 */
window.IsPlayerFreeAiming = function (player) {
	return _in(0x2e397fd2, 0xecd37c87, player, _r);
};

/**
 * Gets a value indicating whether the specified player is currently aiming freely at the specified entity.
 */
window.IsPlayerFreeAimingAtEntity = function (player, entity) {
	return _in(0x3c06b5c8, 0x39b38f7b, player, entity, _r);
};

window.IsPlayerFreeForAmbientTask = function (player) {
	return _in(0xdccfd3f1, 0x06c36ab4, player, _r);
};

window.IsPlayerInCutscene = function (player) {
	return _in(0xe73092f4, 0x157cd126, player, _r);
};

/**
 * this function is hard-coded to always return 0.
 */
window.IsPlayerLoggingInNp = function () {
	return _in(0x74556e14, 0x20867eca, _r);
};

/**
 * Returns TRUE if the game is in online mode and FALSE if in offline mode.
 * This is an alias for NETWORK_IS_SIGNED_ONLINE.
 */
window.IsPlayerOnline = function () {
	return _in(0xf25d331d, 0xc2627bbc, _r);
};

/**
 * Checks whether the specified player has a Ped, the Ped is not dead, is not injured and is not arrested.
 */
window.IsPlayerPlaying = function (player) {
	return _in(0x5e9564d8, 0x246b909a, player, _r);
};

window.IsPlayerPressingHorn = function (player) {
	return _in(0xfa1e2bf8, 0xb10598f9, player, _r);
};

window.IsPlayerReadyForCutscene = function (player) {
	return _in(0x908cbecc, 0x2caa3690, player, _r);
};

/**
 * Returns true if the player is riding a train.
 */
window.IsPlayerRidingTrain = function (player) {
	return _in(0x4ec12697, 0x209f2196, player, _r);
};

window.IsPlayerScriptControlOn = function (player) {
	return _in(0x8a876a65, 0x283dd7d7, player, _r);
};

/**
 * Returns true if the player is currently switching, false otherwise.
 * (When the camera is in the sky moving from Trevor to Franklin for example)
 */
window.IsPlayerSwitchInProgress = function () {
	return _in(0xd9d2cfff, 0x49fab35f, _r);
};
window.N_0xd9d2cfff49fab35f = window.IsPlayerSwitchInProgress;

window.IsPlayerTargettingAnything = function (player) {
	return _in(0x78cfe518, 0x96b6b8a4, player, _r);
};

window.IsPlayerTargettingEntity = function (player, entity) {
	return _in(0x7912f7fc, 0x4f6264b6, player, entity, _r);
};

window.IsPlayerTeleportActive = function () {
	return _in(0x02b15662, 0xd7f8886f, _r);
};

window.IsPlayerVehicleRadioEnabled = function () {
	return _in(0x5f43d83f, 0xd6738741, _r);
};
window.N_0x5f43d83fd6738741 = window.IsPlayerVehicleRadioEnabled;

window.IsPlayerWantedLevelGreater = function (player, wantedLevel) {
	return _in(0x238db2a2, 0xc23ee9ef, player, wantedLevel, _r);
};

window.IsPlayingPhoneGestureAnim = function (ped) {
	return _in(0xb8ebb1e9, 0xd3588c10, ped, _r);
};

window.IsPointInAngledArea = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11) {
	return _in(0x2a70bae8, 0x883e4c81, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), _fv(p9), p10, p11, _r);
};

window.IsPointObscuredByAMissionEntity = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xe54e209c, 0x35ffa18d, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, _r);
};

/**
 * Gets a value indicating whether the specified position is on a road.
 * The vehicle parameter is not implemented (ignored).
 */
window.IsPointOnRoad = function (x, y, z, vehicle) {
	return _in(0x125bf4ab, 0xfc536b09, _fv(x), _fv(y), _fv(z), vehicle, _r);
};

window.IsPositionOccupied = function (x, y, z, range, p4, p5, p6, p7, p8, p9, p10) {
	return _in(0xadcde75e, 0x1c60f32d, _fv(x), _fv(y), _fv(z), _fv(range), p4, p5, p6, p7, p8, p9, p10, _r);
};

window.IsPrevWeatherType = function (weatherType) {
	return _in(0x44f28f86, 0x433b10a9, _ts(weatherType), _r);
};

window.IsPrincipalAceAllowed = function (principal, object) {
	return _in(0x00000000, 0x37cf52ce, _ts(principal), _ts(object), _r);
};

/**
 * Determines whether there is a projectile within the specified coordinates. The coordinates form a rectangle.
 * ownedByPlayer = only projectiles fired by the player will be detected.
 */
window.IsProjectileInArea = function (x1, y1, z1, x2, y2, z2, ownedByPlayer) {
	return _in(0x5270a8fb, 0xc098c3f8, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), ownedByPlayer, _r);
};

window.IsProjectileTypeInAngledArea = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0xf0bc1240, 0x1061dea0, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, p8, _r);
};

/**
 * Determines whether there is a projectile of a specific type within the specified coordinates. The coordinates form a rectangle.
 * Note: This native hasn't been tested yet.
 */
window.IsProjectileTypeInArea = function (x1, y1, z1, x2, y2, z2, type, p7) {
	return _in(0x2e0dc353, 0x342c4a6d, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), type, p7, _r);
};

/**
 * Dr. Underscore (1/6/18):
 * Checks if the projectile is in the radius around that point.
 * p6 is (most likely) ownedByPlayer. (see IS_PROJECTILE_IN_AREA for info)
 */
window.IsProjectileTypeInRadius = function (x, y, z, projHash, radius, ownedByPlayer) {
	return _in(0x34318593, 0x248c8fb2, _fv(x), _fv(y), _fv(z), _ch(projHash), _fv(radius), ownedByPlayer, _r);
};
window.N_0x34318593248c8fb2 = window.IsProjectileTypeInRadius;

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.IsPs3Version = function () {
	return _in(0xcca1072c, 0x29d096c2, _r);
};

window.IsRadarEnabled = function () {
	return _in(0xaf754f20, 0xeb5cd51a, _r);
};
window.N_0xaf754f20eb5cd51a = window.IsRadarEnabled;

window.IsRadarHidden = function () {
	return _in(0x157f93b0, 0x36700462, _r);
};

window.IsRadarPreferenceSwitchedOn = function () {
	return _in(0x9eb6522e, 0xa68f22fe, _r);
};

window.IsRadioRetuning = function () {
	return _in(0xa151a739, 0x4a214e65, _r);
};

/**
 * Checks if you're recording, returns TRUE when you start recording (F1) or turn on action replay (F2)
 * mov al, cs:g_bIsRecordingGameplay // byte_141DD0CD0 in b944
 * retn
 */
window.IsRecording = function () {
	return _in(0x1897ca71, 0x995a90b4, _r);
};

/**
 * if(NETWORK::_IS_ROCKSTAR_BANNED() == 0) means the player is rockstar banned
 */
window.IsRockstarBanned = function () {
	return _in(0x8020a738, 0x47e0ca7d, _r);
};

window.IsScInboxValid = function (p0) {
	return _in(0x93028f1d, 0xb42bfd08, p0, _r);
};
window.N_0x93028f1db42bfd08 = window.IsScInboxValid;

/**
 * Occurrences in the b617d scripts:
 * "ARMY_GUARD",
 * "ARMY_HELI",
 * "BLIMP",
 * "Cinema_Downtown",
 * "Cinema_Morningwood",
 * "Cinema_Textile",
 * "City_Banks",
 * "Countryside_Banks",
 * "DEALERSHIP",
 * "KORTZ_SECURITY",
 * "LSA_Planes",
 * "MP_POLICE",
 * "Observatory_Bikers",
 * "POLICE_POUND1",
 * "POLICE_POUND2",
 * "POLICE_POUND3",
 * "POLICE_POUND4",
 * "POLICE_POUND5",
 * "Rampage1",
 * "SANDY_PLANES",
 * "SCRAP_SECURITY",
 * "SEW_MACHINE",
 * "SOLOMON_GATE"
 * Sometimes used with DOES_SCENARIO_GROUP_EXIST:
 * if (AI::DOES_SCENARIO_GROUP_EXIST("Observatory_Bikers") &&   (!AI::IS_SCENARIO_GROUP_ENABLED("Observatory_Bikers"))) {
 * else if (AI::IS_SCENARIO_GROUP_ENABLED("BLIMP")) {
 */
window.IsScenarioGroupEnabled = function (scenarioGroup) {
	return _in(0x367a09de, 0xd4e05b99, _ts(scenarioGroup), _r);
};

window.IsScenarioOccupied = function (p0, p1, p2, p3, p4) {
	return _in(0x788756d7, 0x3ac2e07c, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, _r);
};

/**
 * Occurrences in the b617d scripts:
 * "PROP_HUMAN_SEAT_CHAIR",
 * "WORLD_HUMAN_DRINKING",
 * "WORLD_HUMAN_HANG_OUT_STREET",
 * "WORLD_HUMAN_SMOKING",
 * "WORLD_MOUNTAIN_LION_WANDER",
 * "WORLD_HUMAN_DRINKING"
 * Sometimes used together with GAMEPLAY::IS_STRING_NULL_OR_EMPTY in the scripts.
 * scenarioType could be the same as scenarioName, used in for example AI::TASK_START_SCENARIO_AT_POSITION.
 */
window.IsScenarioTypeEnabled = function (scenarioType) {
	return _in(0x3a815db3, 0xea088722, _ts(scenarioType), _r);
};

window.IsScreenFadedIn = function () {
	return _in(0x5a859503, 0xb0c08678, _r);
};

window.IsScreenFadedOut = function () {
	return _in(0xb16fce9d, 0xdc7ba182, _r);
};

window.IsScreenFadingIn = function () {
	return _in(0x5c544bc6, 0xc57ac575, _r);
};

window.IsScreenFadingOut = function () {
	return _in(0x797ac7cb, 0x535ba28f, _r);
};

/**
 * In drunk_controller.c4, sub_309
 * if (CAM::_C912AF078AF19212()) {
 * CAM::_1C9D7949FA533490(0);
 * }
 * What does "IS_SCRIPT_GLOBAL_SHAKING" mean..? :/ Is this a hash collision?
 */
window.IsScriptGlobalShaking = function () {
	return _in(0xc912af07, 0x8af19212, _r);
};
window.N_0xc912af078af19212 = window.IsScriptGlobalShaking;

window.IsScriptedConversationLoaded = function () {
	return _in(0xdf0d54be, 0x7a776737, _r);
};

window.IsScriptedConversationOngoing = function () {
	return _in(0x16754c55, 0x6d2ede3d, _r);
};

window.IsScriptedHudComponentActive = function (id) {
	return _in(0xdd100eb1, 0x7a94ff65, id, _r);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.IsScriptedScenarioPedUsingConditionalAnim = function (ped, animDict, anim) {
	return _in(0x6ec47a34, 0x4923e1ed, ped, _ts(animDict), _ts(anim), _r);
};

window.IsScriptedSpeechPlaying = function (p0) {
	return _in(0xcc9aa18d, 0xcc7084f4, p0, _r);
};

/**
 * Returns whether or not SEETHROUGH is active.
 */
window.IsSeethroughActive = function () {
	return _in(0x44b80aba, 0xb9d80bd3, _r);
};

/**
 * Some events that i found, not sure about them, but seems to have logic based on my tests:
 * '82 - dead body
 * '86
 * '87
 * '88 - shooting, fire extinguisher in use
 * '89
 * '93 - ped using horn
 * '95 - ped receiving melee attack
 * '102 - living ped receiving shot
 * '104 - player thrown grenade, tear gas, smoke grenade, jerry can dropping gasoline
 * '105 - melee attack against veh
 * '106 - player running
 * '108 - vehicle theft
 * '112 - melee attack
 * '113 - veh rollover ped
 * '114 - dead ped receiving shot
 * '116 - aiming at ped
 * '121
 * Here is full dump of shocking event types from the exe camx.me/gtav/tasks/shockingevents.txt
 */
window.IsShockingEventInSphere = function (type, x, y, z, radius) {
	return _in(0x1374abb7, 0xc15bab92, type, _fv(x), _fv(y), _fv(z), _fv(radius), _r);
};

/**
 * Determines whether there is a sniper bullet within the specified coordinates. The coordinates form a rectangle.
 */
window.IsSniperBulletInArea = function (x1, y1, z1, x2, y2, z2) {
	return _in(0xfefcf11b, 0x01287125, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _r);
};

/**
 * This function is hard-coded to always return 0.
 */
window.IsSniperInverted = function () {
	return _in(0x61a23b7e, 0xda9bda24, _r);
};

window.IsSocialClubActive = function () {
	return _in(0xc406be34, 0x3fc4b9af, _r);
};
window.N_0xc406be343fc4b9af = window.IsSocialClubActive;

/**
 * if(_IS_SOCIALCLUB_BANNED() == 0) means the player is social club banned
 */
window.IsSocialclubBanned = function () {
	return _in(0xa0ad7e2a, 0xf5349f61, _r);
};

window.IsSpecialAbilityActive = function (player) {
	return _in(0x3e5f7fc8, 0x5d854e15, player, _r);
};

window.IsSpecialAbilityEnabled = function (player) {
	return _in(0xb1d200fe, 0x26aef3cb, player, _r);
};

window.IsSpecialAbilityMeterFull = function (player) {
	return _in(0x05a1fe50, 0x4b7f2587, player, _r);
};

window.IsSpecialAbilityUnlocked = function (playerModel) {
	return _in(0xc6017f6a, 0x6cdfa694, _ch(playerModel), _r);
};

window.IsSphereVisible = function (x, y, z, radius) {
	return _in(0xe33d59da, 0x70b58fdf, _fv(x), _fv(y), _fv(z), _fv(radius), _r);
};

window.IsSphereVisibleToAnotherMachine = function (p0, p1, p2, p3) {
	return _in(0xd82cf8e6, 0x4c8729d8, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _r);
};

window.IsSphereVisibleToPlayer = function (p0, p1, p2, p3, p4) {
	return _in(0xdc3a3102, 0x19e5da62, p0, _fv(p1), _fv(p2), _fv(p3), _fv(p4), _r);
};

/**
 * Returns true when the srl from BeginSrl is loaded.
 * @return -   A boolean once BeginSrl srl is loaded.
 */
window.IsSrlLoaded = function () {
	return _in(0xd0263801, 0xa4c5b0bb, _r);
};

window.IsStreamPlaying = function () {
	return _in(0xd11fa52e, 0xb849d978, _r);
};

window.IsStreamingAdditionalText = function (p0) {
	return _in(0x8b6817b7, 0x1b85ebf0, p0, _r);
};

/**
 * **Experimental**: This native may be altered or removed in future versions of CitizenFX without warning.
 * Returns whether an asynchronous streaming file registration completed.
 * @param registerAs The file name to check, for example `asset.ydr`.
 * @return Whether or not the streaming file has been registered.
 */
window.IsStreamingFileReady = function (registerAs) {
	return _in(0x00000000, 0xa194934d, _ts(registerAs), _r);
};

window.IsStringNull = function (string) {
	return _in(0xf22b6c47, 0xc6eab066, _ts(string), _r);
};

window.IsStringNullOrEmpty = function (string) {
	return _in(0xca042b69, 0x57743895, _ts(string), _r);
};

window.IsStuntJumpInProgress = function () {
	return _in(0x7a3f1970, 0x0a4d0525, _r);
};

window.IsStuntJumpMessageShowing = function () {
	return _in(0x2272b0a1, 0x343129f4, _r);
};
window.N_0x2272b0a1343129f4 = window.IsStuntJumpMessageShowing;

window.IsSubtitlePreferenceSwitchedOn = function () {
	return _in(0xad6daca4, 0xba53e0a4, _r);
};

window.IsSynchronizedSceneLooped = function (sceneID) {
	return _in(0x62522002, 0xe0c391ba, sceneID, _r);
};

/**
 * Returns true if a synchronized scene is running
 */
window.IsSynchronizedSceneRunning = function (sceneId) {
	return _in(0x25d39b93, 0x5a038a26, sceneId, _r);
};

window.IsSystemUiBeingDisplayed = function () {
	return _in(0x5d511e38, 0x67c87139, _r);
};

window.IsTaxiLightOn = function (vehicle) {
	return _in(0x7504c0f1, 0x13ab50fc, vehicle, _r);
};

/**
 * Return whether tennis mode is active or not.
 */
window.IsTennisMode = function (ped) {
	return _in(0x5d5479d1, 0x15290c3f, ped, _r);
};

/**
 * Returns whether or not the text chat (MULTIPLAYER_CHAT Scaleform component) is active.
 */
window.IsTextChatActive = function () {
	return _in(0xb118af58, 0xb5f332a1, _r);
};

window.IsThisAMinigameScript = function () {
	return _in(0x7b30f65d, 0x7b710098, _r);
};

window.IsThisModelABicycle = function (model) {
	return _in(0xbf94dd42, 0xf63bded2, _ch(model), _r);
};

/**
 * Returns true if the model is motorcycle or bycicle.
 */
window.IsThisModelABike = function (model) {
	return _in(0xb50c0b0c, 0xedc6ce84, _ch(model), _r);
};

window.IsThisModelABoat = function (model) {
	return _in(0x45a91879, 0x28f4b9e3, _ch(model), _r);
};

/**
 * To check if the model is an amphibious car, see gtaforums.com/topic/717612-v-scriptnative-documentation-and-research/page-33#entry1069317363 (for build 944 and above only!)
 */
window.IsThisModelACar = function (model) {
	return _in(0x7f6db52e, 0xefc96df8, _ch(model), _r);
};

window.IsThisModelAHeli = function (model) {
	return _in(0xdce43347, 0x88af94ea, _ch(model), _r);
};

/**
 * Checks if model is a boat, then checks for FLAG_IS_JETSKI.
 * @whoever named this _IS_THIS_MODEL_AN_EMERGENCY_BOAT: please do some tests before naming natives, thanks.
 */
window.IsThisModelAJetski = function (model) {
	return _in(0x95370974, 0x12cf75fe, _ch(model), _r);
};
window.IsThisModelASubmersible = window.IsThisModelAJetski;
window.IsThisModelAnEmergencyBoat = window.IsThisModelAJetski;

window.IsThisModelAPlane = function (model) {
	return _in(0xa0948ab4, 0x2d7ba0de, _ch(model), _r);
};

window.IsThisModelAQuadbike = function (model) {
	return _in(0x39dac362, 0xee65fa28, _ch(model), _r);
};

window.IsThisModelATrain = function (model) {
	return _in(0xab935175, 0xb22e822b, _ch(model), _r);
};

window.IsThisModelAnAmphibiousCar = function (model) {
	return _in(0x633f6f44, 0xa537ebb6, _ch(model), _r);
};

window.IsThreadActive = function (threadId) {
	return _in(0x46e9ae36, 0xd8fa6417, threadId, _r);
};

/**
 * Returns true if the two times are equal; otherwise returns false.
 */
window.IsTimeEqualTo = function (timeA, timeB) {
	return _in(0xf5bc9585, 0x7bd6d512, timeA, timeB, _r);
};
window.AreIntegersEqual = window.IsTimeEqualTo;

/**
 * Subtracts the second argument from the first, then returns whether the result is negative.
 */
window.IsTimeLessThan = function (timeA, timeB) {
	return _in(0xcb2cf514, 0x8012c8d0, timeA, timeB, _r);
};
window.SubtractBFromAAndCheckIfNegative = window.IsTimeLessThan;

/**
 * Subtracts the first argument from the second, then returns whether the result is negative.
 */
window.IsTimeMoreThan = function (timeA, timeB) {
	return _in(0xde350f86, 0x51e4346c, timeA, timeB, _r);
};
window.SubtractAFromBAndCheckIfNegative = window.IsTimeMoreThan;

window.IsToggleModOn = function (vehicle, modType) {
	return _in(0x84b233a8, 0xc8fc8ae7, vehicle, modType, _r);
};

/**
 * returns whether or not a ped is visible within your FOV, not this check auto's to false after a certain distance.
 * Target needs to be tracked.. won't work otherwise.
 */
window.IsTrackedPedVisible = function (ped) {
	return _in(0x91c8e617, 0xf64188ac, ped, _r);
};

window.IsTrackedPointVisible = function (point) {
	return _in(0xc45ccdaa, 0xc9221ca8, point, _r);
};

window.IsUiLoadingMultiplayer = function () {
	return _in(0xc6dc8232, 0x53fbb366, _r);
};
window.N_0xc6dc823253fbb366 = window.IsUiLoadingMultiplayer;

/**
 * Return if interior is valid.
 */
window.IsValidInterior = function (interiorID) {
	return _in(0x26b0e73d, 0x7eaaf4d3, interiorID, _r);
};

/**
 * p1 is false almost always.
 * However, in launcher_carwash/carwash1/carwash2 scripts, p1 is true and is accompanied by DOES_VEHICLE_HAVE_ROOF
 */
window.IsVehicleAConvertible = function (vehicle, p1) {
	return _in(0x52f357a3, 0x0698bcce, vehicle, p1, _r);
};

window.IsVehicleAlarmActivated = function (vehicle) {
	return _in(0x4319e335, 0xb71fff34, vehicle, _r);
};

window.IsVehicleAlarmSet = function (vehicle) {
	return _in(0x00000000, 0xdc921211, vehicle, _r);
};

window.IsVehicleAttachedToCargobob = function (cargobob, vehicleAttached) {
	return _in(0xd40148f2, 0x2e81a1d9, cargobob, vehicleAttached, _r);
};

/**
 * Scripts verify that towTruck is the first parameter, not the second.
 */
window.IsVehicleAttachedToTowTruck = function (towTruck, vehicle) {
	return _in(0x146df9ec, 0x4c4b9fd4, towTruck, vehicle, _r);
};

/**
 * Public Function isVehicleAttachedToTrailer(vh As Vehicle) As Boolean
 * Return Native.Function.Call(Of Boolean)(Hash.IS_VEHICLE_ATTACHED_TO_TRAILER, vh)
 * End Function
 */
window.IsVehicleAttachedToTrailer = function (vehicle) {
	return _in(0xe7cf3c4f, 0x9f489f0c, vehicle, _r);
};

window.IsVehicleBumperBrokenOff = function (vehicle, front) {
	return _in(0x468056a6, 0xbb6f3846, vehicle, front, _r);
};

/**
 * Appears to return true if the vehicle has any damage, including cosmetically.
 */
window.IsVehicleDamaged = function (vehicle) {
	return _in(0xbcdc5017, 0xd3ce1e9e, vehicle, _r);
};

/**
 * doorID starts at 0, not seeming to skip any numbers. Four door vehicles intuitively range from 0 to 3.
 */
window.IsVehicleDoorDamaged = function (veh, doorID) {
	return _in(0xb8e181e5, 0x59464527, veh, doorID, _r);
};

/**
 * doorIndex:
 * 0 = Front Left Door
 * 1 = Front Right Door
 * 2 = Back Left Door
 * 3 = Back Right Door
 * 4 = Hood
 * 5 = Trunk
 * 6 = Trunk2
 * @param vehicle The vehicle to check.
 * @param doorIndex The index of the door to check.
 * @return A bool indiciating if the specified door is fully open on the specified vehicle.
 */
window.IsVehicleDoorFullyOpen = function (vehicle, doorIndex) {
	return _in(0x3e933cff, 0x7b111c22, vehicle, doorIndex, _r);
};

/**
 * p1 is always 0 in the scripts.
 * p1 = check if vehicle is on fire
 */
window.IsVehicleDriveable = function (vehicle, isOnFireCheck) {
	return _in(0x4c241e39, 0xb23df959, vehicle, isOnFireCheck, _r);
};

/**
 * Only ever used once in decompiled scripts: **am_pi_menu**:
 * Returns true if the engine is on fire, or if the vehicle engine health is &lt; 0 and it **has been** on fire.
 * It sometimes doesn't return true when the vehicle engine has been on fire, and has since been fixed. I'm not really sure what the exact conditions are.
 * This usually returns true even if there are no visible flames yet (engine health > 0). However if you monitor engine health you'll see that it starts decreasing as soon as this returns true.
 * ```
 * if (((ENTITY::DOES_ENTITY_EXIST(Global_1281959) && !ENTITY::IS_ENTITY_DEAD(Global_1281959, 0)) && func_1545(Global_1281959)) && !func_205(PLAYER::PLAYER_ID()))
 * {
 * if (VEHICLE::GET_VEHICLE_ENGINE_HEALTH(Global_1281959) > 0f && VEHICLE::GET_IS_VEHICLE_ENGINE_RUNNING(Global_1281959))
 * {
 * bVar0 = true;
 * }
 * else
 * {
 * bVar0 = false;
 * }
 * if (VEHICLE::_0xEC69ADF931AAE0C3(Global_1281959)) // _IS_VEHICLE_ENGINE_ON_FIRE
 * {
 * bVar0 = false;
 * }
 * }
 * ```
 * @param vehicle The vehicle to check.
 * @return Returns true when the engine of your vehicle is on fire. Returns false if it's not on fire.
 */
window.IsVehicleEngineOnFire = function (vehicle) {
	return _in(0xec69adf9, 0x31aae0c3, vehicle, _r);
};
window.N_0xec69adf931aae0c3 = window.IsVehicleEngineOnFire;

window.IsVehicleEngineStarting = function (vehicle) {
	return _in(0x00000000, 0xbb340d04, vehicle, _r);
};

window.IsVehicleExtraTurnedOn = function (vehicle, extraId) {
	return _in(0xd2e6822d, 0xbfd6c8bd, vehicle, extraId, _r);
};

window.IsVehicleHighDetail = function (vehicle) {
	return _in(0x1f25887f, 0x3c104278, vehicle, _r);
};

/**
 * Returns whether the specified vehicle is currently in a burnout.
 * vb.net
 * Public Function isVehicleInBurnout(vh As Vehicle) As Boolean
 * Return Native.Function.Call(Of Boolean)(Hash.IS_VEHICLE_IN_BURNOUT, vh)
 * End Function
 */
window.IsVehicleInBurnout = function (vehicle) {
	return _in(0x1297a88e, 0x081430eb, vehicle, _r);
};

/**
 * garageName example "Michael - Beverly Hills"
 * For a full list, see here: pastebin.com/73VfwsmS
 */
window.IsVehicleInGarageArea = function (garageName, vehicle) {
	return _in(0xcee4490c, 0xd57bb3c2, _ts(garageName), vehicle, _r);
};

window.IsVehicleInteriorLightOn = function (vehicle) {
	return _in(0x00000000, 0xa411f72c, vehicle, _r);
};

/**
 * Returns whether or not the vehicle has a CVehicleStreamRequestGfx that's trying to load mods.
 * True if it isn't loading mods, false if it is.
 */
window.IsVehicleModLoadDone = function (vehicle) {
	return _in(0x9a83f5f9, 0x963775ef, vehicle, _r);
};
window.N_0x9a83f5f9963775ef = window.IsVehicleModLoadDone;

window.IsVehicleModel = function (vehicle, model) {
	return _in(0x423e8de3, 0x7d934d89, vehicle, _ch(model), _r);
};

window.IsVehicleNeedsToBeHotwired = function (vehicle) {
	return _in(0x00000000, 0xf9933bf4, vehicle, _r);
};

/**
 * indices:
 * 0 = Left
 * 1 = Right
 * 2 = Front
 * 3 = Back
 */
window.IsVehicleNeonLightEnabled = function (vehicle, index) {
	return _in(0x8c4b9255, 0x3e4766a5, vehicle, index, _r);
};

/**
 * Returns true if the id is non zero.
 */
window.IsVehicleNodeIdValid = function (vehicleNodeId) {
	return _in(0x1eaf30fc, 0xfbf5af74, vehicleNodeId, _r);
};

/**
 * Public Function isVehicleOnAllWheels(vh As Vehicle) As Boolean
 * Return Native.Function.Call(Of Boolean)(Hash.IS_VEHICLE_ON_ALL_WHEELS, vh)
 * End Function
 */
window.IsVehicleOnAllWheels = function (vehicle) {
	return _in(0xb104cd1b, 0xabf302e2, vehicle, _r);
};

window.IsVehiclePreviouslyOwnedByPlayer = function (vehicle) {
	return _in(0x00000000, 0xf849ed67, vehicle, _r);
};

window.IsVehicleRadioLoud = function (vehicle) {
	return _in(0x032a1166, 0x63a4d5ac, vehicle, _r);
};

window.IsVehicleRocketBoostActive = function (vehicle) {
	return _in(0x3d34e80e, 0xed4ae3be, vehicle, _r);
};

/**
 * Possibly: Returns whether the searchlight (found on police vehicles) is toggled on.
 */
window.IsVehicleSearchlightOn = function (vehicle) {
	return _in(0xc0f97fce, 0x55094987, vehicle, _r);
};

/**
 * Has an additional BOOL parameter since version [???].
 * Check if a vehicle seat is free.
 * -1 being the driver seat.
 * Use GET_VEHICLE_MAX_NUMBER_OF_PASSENGERS(vehicle) - 1 for last seat index.
 */
window.IsVehicleSeatFree = function (vehicle, seatIndex) {
	return _in(0x22ac59a8, 0x70e6a669, vehicle, seatIndex, _r);
};

/**
 * Checks for FLAG_NO_RESPRAY
 */
window.IsVehicleShopResprayAllowed = function (vehicle) {
	return _in(0x8d474c8f, 0xaeff6cde, vehicle, _r);
};
window.N_0x8d474c8faeff6cde = window.IsVehicleShopResprayAllowed;

window.IsVehicleSirenOn = function (vehicle) {
	return _in(0x4c9bf537, 0xbe2634b2, vehicle, _r);
};

window.IsVehicleSirenSoundOn = function (vehicle) {
	return _in(0xb5cc40fb, 0xcb586380, vehicle, _r);
};
window.N_0xb5cc40fbcb586380 = window.IsVehicleSirenSoundOn;

window.IsVehicleStolen = function (vehicle) {
	return _in(0x4af9bd80, 0xeebeb453, vehicle, _r);
};

/**
 * MulleDK19: Returns true if the vehicle's speed is equal to, or less than 0.02 meters per second, or 0.05 meters per second, if the vehicle's handbrake is engaged.
 */
window.IsVehicleStopped = function (vehicle) {
	return _in(0x5721b434, 0xad84d57a, vehicle, _r);
};

/**
 * is this for red lights only?  more testing required.
 */
window.IsVehicleStoppedAtTrafficLights = function (vehicle) {
	return _in(0x2959f696, 0xae390a99, vehicle, _r);
};

window.IsVehicleStuckOnRoof = function (vehicle) {
	return _in(0xb497f06b, 0x288dcfdf, vehicle, _r);
};

/**
 * p1 can be anywhere from 0 to 3 in the scripts. p2 is generally somewhere in the 1000 to 10000 range.
 */
window.IsVehicleStuckTimerUp = function (vehicle, p1, p2) {
	return _in(0x679be1da, 0xf71da874, vehicle, p1, p2, _r);
};

/**
 * wheelID used for 4 wheelers seem to be (0, 1, 4, 5)
 * completely - is to check if tire completely gone from rim.
 * '0 = wheel_lf / bike, plane or jet front
 * '1 = wheel_rf
 * '2 = wheel_lm / in 6 wheels trailer, plane or jet is first one on left
 * '3 = wheel_rm / in 6 wheels trailer, plane or jet is first one on right
 * '4 = wheel_lr / bike rear / in 6 wheels trailer, plane or jet is last one on left
 * '5 = wheel_rr / in 6 wheels trailer, plane or jet is last one on right
 * '45 = 6 wheels trailer mid wheel left
 * '47 = 6 wheels trailer mid wheel right
 */
window.IsVehicleTyreBurst = function (vehicle, wheelID, completely) {
	return _in(0xba291848, 0xa0815ca9, vehicle, wheelID, completely, _r);
};

/**
 * must be called after TRACK_VEHICLE_VISIBILITY
 * it's not instant so probabilly must pass an 'update' to see correct result.
 */
window.IsVehicleVisible = function (vehicle) {
	return _in(0xaa0a52d2, 0x4fb98293, vehicle, _r);
};

window.IsVehicleWanted = function (vehicle) {
	return _in(0x00000000, 0x0a7daf7c, vehicle, _r);
};

window.IsVehicleWindowIntact = function (vehicle, windowIndex) {
	return _in(0x46e571a0, 0xe20d01f1, vehicle, windowIndex, _r);
};

window.IsWarningMessageActive = function () {
	return _in(0xe18b138f, 0xabc53103, _r);
};
window.IsMedicalDisabled = window.IsWarningMessageActive;

window.IsWaypointActive = function () {
	return _in(0x1dd1f58f, 0x493f1da5, _r);
};

window.IsWaypointPlaybackGoingOnForPed = function (p0) {
	return _in(0xe03b3f2d, 0x3dc59b64, p0, _r);
};

window.IsWaypointPlaybackGoingOnForVehicle = function (p0) {
	return _in(0xf5134943, 0xea29868c, p0, _r);
};

window.IsWeaponValid = function (weaponHash) {
	return _in(0x937c7116, 0x5cf334b3, _ch(weaponHash), _r);
};

/**
 * Gets whether the world point the calling script is registered to is within desired range of the player.
 */
window.IsWorldPointWithinBrainActivationRange = function () {
	return _in(0xc5042cc6, 0xf5e3d450, _r);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.IsXbox360Version = function () {
	return _in(0xf6201b4d, 0xaf662a9d, _r);
};

/**
 * When I called this with what the script was doing, which was -190f for yaw pitch and roll, all my car did was jitter a little. I also tried 0 and 190f. I altered the p1 variable between TRUE and FALSE and didn't see a difference.
 * This might have something to do with the physbox of the vehicle, but I'm not sure.
 */
window.JitterVehicle = function (vehicle, p1, yaw, pitch, roll) {
	return _in(0xc59872a5, 0x134879c7, vehicle, p1, _fv(yaw), _fv(pitch), _fv(roll));
};

/**
 * hash collision
 */
window.KeyHudColour = function (p0, p1) {
	return _in(0x1a5cd775, 0x2dd28cd3, p0, p1);
};

/**
 * List of component/props ID
 * gtaxscripting.blogspot.com/2016/04/gta-v-peds-component-and-props.html
 */
window.KnockOffPedProp = function (ped, p1, p2, p3, p4) {
	return _in(0x6fd7816a, 0x36615f48, ped, p1, p2, p3, p4);
};

window.KnockPedOffVehicle = function (ped) {
	return _in(0x45bbcba7, 0x7c29a841, ped);
};

window.Leaderboards2ReadByHandle = function () {
	return _in(0xc30713a3, 0x83bfbf0e, _i, _i, _r);
};

window.Leaderboards2ReadByRadius = function (p1) {
	return _in(0x5ce587fb, 0x5a42c8c4, _i, p1, _i, _r);
};

window.Leaderboards2ReadByRank = function (p1, p2) {
	return _in(0xba2c7db0, 0xc129449a, _i, p1, p2, _r);
};

window.Leaderboards2ReadByRow = function (p2, p4, p6) {
	return _in(0xa9cdb1e3, 0xf0a49883, _i, _i, p2, _i, p4, _i, p6, _r);
};

window.Leaderboards2ReadByScoreFloat = function (p1, p2) {
	return _in(0xe662c8b7, 0x59d08f3c, _i, _fv(p1), p2, _r);
};

window.Leaderboards2ReadByScoreInt = function (p1, p2) {
	return _in(0x7eec7e4f, 0x6984a16a, _i, p1, p2, _r);
};

window.Leaderboards2ReadFriendsByRow = function (p2, p3, p4, p5) {
	return _in(0x918b1016, 0x66f9cb83, _i, _i, p2, p3, p4, p5, _r);
};

window.Leaderboards2WriteData = function (p0) {
	return _in(0xae220654, 0x5888ae49, _ii(p0) /* may be optional */, _r);
};

window.LeaderboardsCacheDataRow = function (p0) {
	return _in(0xb9bb18e2, 0xc40142ed, _ii(p0) /* may be optional */, _r);
};

window.LeaderboardsClearCacheData = function () {
	return _in(0xd4b02a6b, 0x476e1fdc);
};

window.LeaderboardsDeaths = function (statName, value) {
	return _in(0x428eaf89, 0xe24f6c36, _ch(statName), _fv(value));
};
window.N_0x428eaf89e24f6c36 = window.LeaderboardsDeaths;

window.LeaderboardsGetCacheDataRow = function (p0, p1, p2) {
	return _in(0x9120e8db, 0xa3d69273, p0, p1, _ii(p2) /* may be optional */, _r);
};

window.LeaderboardsGetCacheExists = function (p0) {
	return _in(0x9c51349b, 0xe6cdfe2c, p0, _r);
};

window.LeaderboardsGetCacheTime = function (p0) {
	return _in(0xf04c1c27, 0xda35f6c8, p0, _r, _ri);
};

window.LeaderboardsGetColumnId = function (p0, p1, p2) {
	return _in(0xc4b5467a, 0x1886ea7e, p0, p1, p2, _r, _ri);
};

window.LeaderboardsGetColumnType = function (p0, p1, p2) {
	return _in(0xbf4fef46, 0xdb7894d3, p0, p1, p2, _r, _ri);
};

window.LeaderboardsGetNumberOfColumns = function (p0, p1) {
	return _in(0x117b4515, 0x6d7eff2e, p0, p1, _r, _ri);
};

window.LeaderboardsReadClear = function (p0, p1, p2) {
	return _in(0x7cce5c73, 0x7a665701, p0, p1, p2, _r, _ri);
};

window.LeaderboardsReadClearAll = function () {
	return _in(0xa34cb6e6, 0xf0df4a0b, _r, _ri);
};

window.LeaderboardsReadPending = function (p0, p1, p2) {
	return _in(0xac392c84, 0x83342ac2, p0, p1, p2, _r);
};

window.LeaderboardsReadSuccessful = function (p0, p1, p2) {
	return _in(0x2fb19228, 0x983e832c, p0, p1, p2, _r);
};

window.LinkNamedRendertarget = function (hash) {
	return _in(0xf6c09e27, 0x6aeb3f2d, _ch(hash));
};

/**
 * 1
 */
window.LoadAllObjectsNow = function () {
	return _in(0xbd6e8463, 0x2dd4cb3f);
};

/**
 * Loads all path nodes.
 * If keepInMemory is true, all path nodes will be loaded and be kept in memory; otherwise, all path nodes will be loaded, but unloaded as the game sees fit.
 * - MulleDK19.
 * August 29, 2017: This native has been removed in v1180.
 */
window.LoadAllPathNodes = function (keepInMemory) {
	return _in(0x80e4a6ed, 0xdb0be8d9, keepInMemory, _r);
};

/**
 * Load interior
 */
window.LoadInterior = function (interiorID) {
	return _in(0x2ca429c0, 0x29ccf247, interiorID);
};
window.N_0x2ca429c029ccf247 = window.LoadInterior;

/**
 * Loads "common:/data/missioncreatordata" data and sets some values.
 */
window.LoadMissionCreatorData = function () {
	return _in(0xb5a4db34, 0xfe89b88a);
};
window.N_0xb5a4db34fe89b88a = window.LoadMissionCreatorData;

window.LoadMovieMeshSet = function (movieMeshSetName) {
	return _in(0xb6606445, 0x2270e8f1, _ts(movieMeshSetName), _r, _ri);
};

/**
 * This loads the GTA:O dlc map parts (high end garages, apartments).
 * Works in singleplayer.
 * In order to use GTA:O heist IPL's you have to call this native with the following params: _9BAE5AD2508DF078(1);
 * console hash: 0xC65586A9
 */
window.LoadMpDlcMaps = function () {
	return _in(0x0888c350, 0x2dbbeef5);
};

/**
 * Reads the contents of a text file in a specified resource.
 * If executed on the client, this file has to be included in `files` in the resource manifest.
 * Example: `local data = LoadResourceFile("devtools", "data.json")`
 * @param resourceName The resource name.
 * @param fileName The file in the resource.
 * @return The file contents
 */
window.LoadResourceFile = function (resourceName, fileName) {
	return _in(0x00000000, 0x76a9ee1f, _ts(resourceName), _ts(fileName), _r, _s);
};

/**
 * Rope presets can be found in the gamefiles. One example is "ropeFamily3", it is NOT a hash but rather a string.
 */
window.LoadRopeData = function (rope, rope_preset) {
	return _in(0xcbb203c0, 0x4d1abd27, rope, _ts(rope_preset), _r, _ri);
};

window.LoadScene = function (x, y, z) {
	return _in(0x4448eb75, 0xb4904bdb, _fv(x), _fv(y), _fv(z));
};

/**
 * Example:
 * AUDIO::LOAD_STREAM("CAR_STEAL_1_PASSBY", "CAR_STEAL_1_SOUNDSET");
 * All found occurrences in the b678d decompiled scripts: pastebin.com/3rma6w5w
 * Stream names often ends with "_MASTER", "_SMALL" or "_STREAM". Also "_IN", "_OUT" and numbers.
 * soundSet is often set to 0 in the scripts. These are common to end the soundSets: "_SOUNDS", "_SOUNDSET" and numbers.
 */
window.LoadStream = function (streamName, soundSet) {
	return _in(0x1f1f9571, 0x54ec51df, _ts(streamName), _ts(soundSet), _r);
};

/**
 * Example:
 * AUDIO::LOAD_STREAM_WITH_START_OFFSET("STASH_TOXIN_STREAM", 2400, "FBI_05_SOUNDS");
 * Only called a few times in the scripts.
 */
window.LoadStreamWithStartOffset = function (streamName, startOffset, soundSet) {
	return _in(0x59c16b79, 0xf53b3712, _ts(streamName), startOffset, _ts(soundSet), _r);
};

window.LoadTvChannel = function (tvChannel) {
	return _in(0x0ad973ca, 0x1e077b60, _ch(tvChannel), _r);
};
window.N_0x0ad973ca1e077b60 = window.LoadTvChannel;

/**
 * Loads specified video sequence into the TV Channel
 * TV_Channel ranges from 0-2
 * VideoSequence can be any of the following:
 * "PL_STD_CNT" CNT Standard Channel
 * "PL_STD_WZL" Weazel Standard Channel
 * "PL_LO_CNT"
 * "PL_LO_WZL"
 * "PL_SP_WORKOUT"
 * "PL_SP_INV" - Jay Norris Assassination Mission Fail
 * "PL_SP_INV_EXP" - Jay Norris Assassination Mission Success
 * "PL_LO_RS" - Righteous Slaughter Ad
 * "PL_LO_RS_CUTSCENE" - Righteous Slaughter Cut-scene
 * "PL_SP_PLSH1_INTRO"
 * "PL_LES1_FAME_OR_SHAME"
 * "PL_STD_WZL_FOS_EP2"
 * "PL_MP_WEAZEL" - Weazel Logo on loop
 * "PL_MP_CCTV" - Generic CCTV loop
 * Restart
 * 0=video sequence continues as normal
 * 1=sequence restarts from beginning every time that channel is selected
 */
window.LoadTvChannelSequence = function (TV_Channel, VideoSequence, Restart) {
	return _in(0xf7b38b83, 0x05f1fe8b, TV_Channel, _ts(VideoSequence), Restart);
};
window.N_0xf7b38b8305f1fe8b = window.LoadTvChannelSequence;

/**
 * Loads a User-Generated Content (UGC) file. These files can be found in "[GTA5]\data\ugc" and "[GTA5]\common\patch\ugc". They seem to follow a naming convention, most likely of "[name]_[part].ugc". See example below for usage.
 * Returns whether or not the file was successfully loaded.
 * Example:
 * DATAFILE::_LOAD_UGC_FILE("RockstarPlaylists") // loads "rockstarplaylists_00.ugc"
 */
window.LoadUgcFile = function (filename) {
	return _in(0xc5238c01, 0x1af405e4, _ts(filename), _r);
};

/**
 * Locks the minimap to the specified angle in integer degrees.
 * angle: The angle in whole degrees. If less than 0 or greater than 360, unlocks the angle.
 */
window.LockMinimapAngle = function (angle) {
	return _in(0x299faebb, 0x108ae05b, angle);
};

/**
 * Locks the minimap to the specified world position.
 */
window.LockMinimapPosition = function (x, y) {
	return _in(0x1279e861, 0xa329e73f, _fv(x), _fv(y));
};

/**
 * Not present in retail version of the game, actual definiton seems to be
 * _LOG_DEBUG_INFO(char* category, char* debugText);
 */
window.LogDebugInfo = function (p0) {
	return _in(0x2162c446, 0xdfdf38fd, _ts(p0));
};
window.N_0x2162c446dfdf38fd = window.LogDebugInfo;

window.LowerConvertibleRoof = function (vehicle, instantlyLower) {
	return _in(0xded51f70, 0x3d0fa83d, vehicle, instantlyLower);
};

window.MakePedReload = function (ped) {
	return _in(0x20ae33f3, 0xac9c0033, ped, _r);
};

/**
 * is this like setting is as no longer needed?
 */
window.MarkObjectForDeletion = function (object) {
	return _in(0xadbe4809, 0xf19f927a, object);
};

window.MaxRadioStationIndex = function () {
	return _in(0xf1620ecb, 0x50e01de7, _r, _ri);
};

/**
 * Sets the water height for a given position and radius.
 */
window.ModifyWater = function (x, y, radius, height) {
	return _in(0xc443fd75, 0x7c3ba637, _fv(x), _fv(y), _fv(radius), _fv(height));
};

/**
 * For move the finger of player, the value of int goes 1 at 5.
 */
window.MoveFinger = function (direction) {
	return _in(0x95c9e72f, 0x3d7dec9b, direction);
};

window.MoveVehicleDecals = function (p0, p1) {
	return _in(0x84c8d7c2, 0xd30d3280, p0, p1);
};

/**
 * 2 matches in 1 script
 * Used in multiplayer scripts?
 */
window.N_0x0032a6dba562c518 = function () {
	return _in(0x0032a6db, 0xa562c518);
};

window.N_0x0035bb914316f1e3 = function (p0, p1, p2, p3) {
	return _in(0x0035bb91, 0x4316f1e3, p0, p1, p2, p3);
};

/**
 * if ((NETWORK::_597F8DBA9B206FC7() > 0) && DATAFILE::_01095C95CD46B624(0)) {
 * v_10 = DATAFILE::_GET_ROOT_OBJECT();
 * v_11 = DATAFILE::_OBJECT_VALUE_GET_INTEGER(v_10, "pt");
 * sub_20202(2, v_11);
 * a_0 += 1;
 * } else {
 * a_0 += 1;
 * }
 */
window.N_0x01095c95cd46b624 = function (p0) {
	return _in(0x01095c95, 0xcd46b624, p0, _r);
};

window.N_0x011883f41211432a = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x011883f4, 0x1211432a, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0x0150b6ff25a9e2e5 = function () {
	return _in(0x0150b6ff, 0x25a9e2e5);
};

window.N_0x015b03ee1c43e6ec = function (p0) {
	return _in(0x015b03ee, 0x1c43e6ec, p0);
};

window.N_0x01708e8dd3ff8c65 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x01708e8d, 0xd3ff8c65, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _r, _ri);
};

window.N_0x017568a8182d98a6 = function (p0) {
	return _in(0x017568a8, 0x182d98a6, p0, _r, _ri);
};

window.N_0x01abce5e7cbda196 = function () {
	return _in(0x01abce5e, 0x7cbda196, _r, _ri);
};

window.N_0x01bb4d577d38bd9e = function (p0, p1) {
	return _in(0x01bb4d57, 0x7d38bd9e, p0, _fv(p1));
};

window.N_0x0218ba067d249dea = function () {
	return _in(0x0218ba06, 0x7d249dea);
};

/**
 * some camera effect that is (also) used in the drunk-cheat, and turned off (by setting it to 0.0) along with the shaking effects once the drunk cheat is disabled. Possibly a cinematic or script-cam version of _0x487A82C650EB7799
 */
window.N_0x0225778816fdc28c = function (p0) {
	return _in(0x02257788, 0x16fdc28c, _fv(p0));
};

window.N_0x02369d5c8a51fdcf = function (p0) {
	return _in(0x02369d5c, 0x8a51fdcf, p0);
};

window.N_0x02398b627547189c = function (p0, p1) {
	return _in(0x02398b62, 0x7547189c, p0, p1);
};

window.N_0x024a60deb0ea69f0 = function (p0, player, p2, p3) {
	return _in(0x024a60de, 0xb0ea69f0, p0, player, _fv(p2), p3, _r);
};

window.N_0x02a8bec6fd9af660 = function (p1) {
	return _in(0x02a8bec6, 0xfd9af660, _i, p1, _r);
};

window.N_0x02ac28f3a01fa04a = function (p0) {
	return _in(0x02ac28f3, 0xa01fa04a, _fv(p0), _r, _ri);
};

window.N_0x02ada21ea2f6918f = function () {
	return _in(0x02ada21e, 0xa2f6918f, _r, _ri);
};

/**
 * Found in the scripts:
 * GAMEPLAY::_02DEAAC8F8EA7FE7("");
 */
window.N_0x02deaac8f8ea7fe7 = function (p0) {
	return _in(0x02deaac8, 0xf8ea7fe7, _ts(p0));
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x02e93c796abd3a97 = function (p0) {
	return _in(0x02e93c79, 0x6abd3a97, p0);
};

/**
 * 2 calls in the b617d scripts. This line is called 2 times:
 * AUDIO::_031ACB6ABA18C729("RADIO_16_SILVERLAKE", "MIRRORPARK_LOCKED");
 * Note: Another name for RADIO_16_SILVERLAKE is RADIO MIRROR PARK
 */
window.N_0x031acb6aba18c729 = function (radioStation, p1) {
	return _in(0x031acb6a, 0xba18c729, _ts(radioStation), _ts(p1));
};

window.N_0x03300b57fcac6ddb = function (p0) {
	return _in(0x03300b57, 0xfcac6ddb, p0);
};

window.N_0x0378c08504160d0d = function (p0) {
	return _in(0x0378c085, 0x04160d0d, p0, _r);
};

window.N_0x0379daf89ba09aa5 = function (p0, p1) {
	return _in(0x0379daf8, 0x9ba09aa5, p0, p1);
};

window.N_0x0395cb47b022e62c = function (p0) {
	return _in(0x0395cb47, 0xb022e62c, _ii(p0) /* may be optional */, _r);
};

window.N_0x03c27e13b42a0e82 = function (doorHash, p1, p2, p3) {
	return _in(0x03c27e13, 0xb42a0e82, _ch(doorHash), _fv(p1), p2, p3);
};

window.N_0x03c2eebb04b3fb72 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x03c2eebb, 0x04b3fb72, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0x03ea03af85a85cb7 = function (ped, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0x03ea03af, 0x85a85cb7, ped, p1, p2, p3, p4, p5, p6, p7, p8, _r);
};

window.N_0x03f1a106bda7dd3e = function () {
	return _in(0x03f1a106, 0xbda7dd3e);
};

window.N_0x03fc694ae06c5a20 = function () {
	return _in(0x03fc694a, 0xe06c5a20);
};

window.N_0x0419b167ee128f33 = function (p0, p1) {
	return _in(0x0419b167, 0xee128f33, p0, p1, _r, _ri);
};

window.N_0x041c7f2a6c9894e6 = function (p0, p1, p2) {
	return _in(0x041c7f2a, 0x6c9894e6, p0, p1, p2, _r, _ri);
};

/**
 * Found in the b617d scripts, duplicates removed:
 * AUDIO::_044DBAD7A7FA2BE5("V_CARSHOWROOM_PS_WINDOW_UNBROKEN", "V_CARSHOWROOM_PS_WINDOW_BROKEN");
 * AUDIO::_044DBAD7A7FA2BE5("V_CIA_PS_WINDOW_UNBROKEN", "V_CIA_PS_WINDOW_BROKEN");
 * AUDIO::_044DBAD7A7FA2BE5("V_DLC_HEIST_APARTMENT_DOOR_CLOSED", "V_DLC_HEIST_APARTMENT_DOOR_OPEN");
 * AUDIO::_044DBAD7A7FA2BE5("V_FINALEBANK_PS_VAULT_INTACT", "V_FINALEBANK_PS_VAULT_BLOWN");
 * AUDIO::_044DBAD7A7FA2BE5("V_MICHAEL_PS_BATHROOM_WITH_WINDOW", "V_MICHAEL_PS_BATHROOM_WITHOUT_WINDOW");
 */
window.N_0x044dbad7a7fa2be5 = function (p0, p1) {
	return _in(0x044dbad7, 0xa7fa2be5, _ts(p0), _ts(p1));
};

window.N_0x04655f9d075d0ae5 = function (p0) {
	return _in(0x04655f9d, 0x075d0ae5, p0);
};

window.N_0x047cbed6f6f8b63c = function () {
	return _in(0x047cbed6, 0xf6f8b63c);
};

window.N_0x04918a41bc9b8157 = function (p0, p1, p2) {
	return _in(0x04918a41, 0xbc9b8157, p0, p1, p2, _r, _ri);
};

window.N_0x04d90ba8207ada2d = function (p0) {
	return _in(0x04d90ba8, 0x207ada2d, p0);
};

/**
 * p0 was always 0xAE2602A3.
 */
window.N_0x052991e59076e4e4 = function (p0, p1) {
	return _in(0x052991e5, 0x9076e4e4, _ch(p0), _ii(p1) /* may be optional */, _r);
};

window.N_0x0581730ab9380412 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x0581730a, 0xb9380412, p0, p1, p2, p3, p4, p5);
};

window.N_0x0596843b34b95ce5 = function (p0, p1) {
	return _in(0x0596843b, 0x34b95ce5, p0, p1);
};

window.N_0x05f04155a226fbbf = function (p0, p1, p2, p3) {
	return _in(0x05f04155, 0xa226fbbf, p0, p1, p2, p3);
};

window.N_0x06087579e7aa85a9 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x06087579, 0xe7aa85a9, p0, p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5), _r);
};

window.N_0x061cb768363d6424 = function (p0, p1) {
	return _in(0x061cb768, 0x363d6424, p0, p1);
};

window.N_0x0626a247d2405330 = function () {
	return _in(0x0626a247, 0xd2405330, _r, _ri);
};

window.N_0x062d5ead4da2fa6a = function () {
	return _in(0x062d5ead, 0x4da2fa6a);
};

window.N_0x063ae2b2cc273588 = function (p0, p1) {
	return _in(0x063ae2b2, 0xcc273588, p0, p1);
};

window.N_0x06462a961e94b67c = function () {
	return _in(0x06462a96, 0x1e94b67c);
};

window.N_0x06582aff74894c75 = function (vehicle, p1) {
	return _in(0x06582aff, 0x74894c75, vehicle, p1);
};

window.N_0x065d03a9d6b2c6b5 = function (p0, p1) {
	return _in(0x065d03a9, 0xd6b2c6b5, p0, p1);
};

window.N_0x06a320535f5f0248 = function (p0) {
	return _in(0x06a32053, 0x5f5f0248, p0);
};

window.N_0x06a3524161c502ba = function (p0) {
	return _in(0x06a35241, 0x61c502ba, _ii(p0) /* may be optional */);
};

window.N_0x06c0023bed16dd6b = function (p0, p1) {
	return _in(0x06c0023b, 0xed16dd6b, p0, p1);
};

window.N_0x06eaf70ae066441e = function (p0) {
	return _in(0x06eaf70a, 0xe066441e, p0);
};

window.N_0x06ee9048fd080382 = function (p0) {
	return _in(0x06ee9048, 0xfd080382, p0);
};

window.N_0x06f761ea47c1d3ed = function (p0) {
	return _in(0x06f761ea, 0x47c1d3ed, p0);
};

window.N_0x075f1d57402c93ba = function () {
	return _in(0x075f1d57, 0x402c93ba, _r, _ri);
};

window.N_0x07c313f94746702c = function (p0) {
	return _in(0x07c313f9, 0x4746702c, p0, _r, _ri);
};

window.N_0x07c61676e5bb52cd = function (p0) {
	return _in(0x07c61676, 0xe5bb52cd, p0, _r, _ri);
};

window.N_0x07dbd622d9533857 = function (p0) {
	return _in(0x07dbd622, 0xd9533857, p0, _r, _ri);
};

window.N_0x07dd29d5e22763f1 = function (p0) {
	return _in(0x07dd29d5, 0xe22763f1, _ii(p0) /* may be optional */, _r);
};

window.N_0x07eab372c8841d99 = function (p0, p1, p2) {
	return _in(0x07eab372, 0xc8841d99, p0, p1, p2, _r, _ri);
};

window.N_0x07fb139b592fa687 = function (p0, p1, p2, p3) {
	return _in(0x07fb139b, 0x592fa687, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _r);
};

window.N_0x0811381ef5062fec = function (p0) {
	return _in(0x0811381e, 0xf5062fec, p0);
};

window.N_0x08a1b82b91900682 = function (p0, p1, p2) {
	return _in(0x08a1b82b, 0x91900682, p0, p1, p2);
};

window.N_0x08b0ca7a6ab3ac32 = function (p0, p1, p2) {
	return _in(0x08b0ca7a, 0x6ab3ac32, p0, p1, p2);
};

window.N_0x0923dbf87dff735e = function (x, y, z) {
	return _in(0x0923dbf8, 0x7dff735e, _fv(x), _fv(y), _fv(z));
};

window.N_0x098760c7461724cd = function () {
	return _in(0x098760c7, 0x461724cd);
};

window.N_0x09c0403ed9a751c2 = function (p0) {
	return _in(0x09c0403e, 0xd9a751c2, p0, _r);
};

window.N_0x0a123435a26c36cd = function () {
	return _in(0x0a123435, 0xa26c36cd);
};

window.N_0x0a436b8643716d14 = function () {
	return _in(0x0a436b86, 0x43716d14);
};

window.N_0x0a46af8a78dc5e0a = function () {
	return _in(0x0a46af8a, 0x78dc5e0a);
};

window.N_0x0a50d2604e05cb94 = function (p0, p1, p2, p3, p4) {
	return _in(0x0a50d260, 0x4e05cb94, p0, p1, p2, p3, p4);
};

window.N_0x0a60017f841a54f2 = function (p0, p1, p2, p3) {
	return _in(0x0a60017f, 0x841a54f2, p0, p1, p2, p3);
};

window.N_0x0a6a279f3aa4fd70 = function (vehicle, p1) {
	return _in(0x0a6a279f, 0x3aa4fd70, vehicle, p1);
};

window.N_0x0a6d923dffc9bd89 = function () {
	return _in(0x0a6d923d, 0xffc9bd89, _r, _ri);
};

window.N_0x0a9c7f36e5d7b683 = function (p0) {
	return _in(0x0a9c7f36, 0xe5d7b683, p0);
};

window.N_0x0a9f2a468b328e74 = function (p0, p1, p2, p3) {
	return _in(0x0a9f2a46, 0x8b328e74, p0, p1, p2, p3);
};

window.N_0x0aa27680a0bd43fa = function () {
	return _in(0x0aa27680, 0xa0bd43fa);
};

window.N_0x0abc54de641dc0fc = function (p0) {
	return _in(0x0abc54de, 0x641dc0fc, _ii(p0) /* may be optional */, _r, _ri);
};

window.N_0x0abf535877897560 = function (p0) {
	return _in(0x0abf5358, 0x77897560, p0, _r, _ri);
};

window.N_0x0ad9710cee2f590f = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x0ad9710c, 0xee2f590f, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, _r, _ri);
};

window.N_0x0ad9e8f87ff7c16f = function (p0, p1) {
	return _in(0x0ad9e8f8, 0x7ff7c16f, p0, p1);
};

window.N_0x0ae73d8df3a762b2 = function (p0) {
	return _in(0x0ae73d8d, 0xf3a762b2, p0);
};

window.N_0x0afce529f69b21ff = function () {
	return _in(0x0afce529, 0xf69b21ff, _r, _ri);
};

window.N_0x0b203b4afde53a4f = function (p2) {
	return _in(0x0b203b4a, 0xfde53a4f, _i, _i, p2, _r, _ri);
};

window.N_0x0b3e35ac043707d9 = function (p0, p1) {
	return _in(0x0b3e35ac, 0x043707d9, p0, p1);
};

window.N_0x0b40ed49d7d6ff84 = function () {
	return _in(0x0b40ed49, 0xd7d6ff84);
};

window.N_0x0b565b0aae56a0e8 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x0b565b0a, 0xae56a0e8, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0x0b568201dd99f0eb = function (p0) {
	return _in(0x0b568201, 0xdd99f0eb, p0);
};

window.N_0x0b8b7f74bf061c6d = function () {
	return _in(0x0b8b7f74, 0xbf061c6d, _r, _ri);
};

window.N_0x0b919e1fb47cc4e0 = function (p0) {
	return _in(0x0b919e1f, 0xb47cc4e0, _fv(p0));
};

window.N_0x0bc3144deb678666 = function (modelHash) {
	return _in(0x0bc3144d, 0xeb678666, _ch(modelHash), _r);
};

window.N_0x0bca1d2c47b0d269 = function (p0, p1, p2) {
	return _in(0x0bca1d2c, 0x47b0d269, p0, p1, _fv(p2));
};

window.N_0x0be4be946463f917 = function (p0) {
	return _in(0x0be4be94, 0x6463f917, p0, _r, _ri);
};

window.N_0x0bf3b3bd47d79c08 = function (hash, p1) {
	return _in(0x0bf3b3bd, 0x47d79c08, _ch(hash), p1);
};

/**
 * Dr. Underscore (1/6/18):
 * Seems to return a value 0-2.
 */
window.N_0x0c0c4e81e1ac60a0 = function () {
	return _in(0x0c0c4e81, 0xe1ac60a0, _r, _ri);
};

window.N_0x0c112765300c7e1e = function (p0) {
	return _in(0x0c112765, 0x300c7e1e, p0, _r, _ri);
};

window.N_0x0c15b0e443b2349d = function () {
	return _in(0x0c15b0e4, 0x43b2349d, _r, _ri);
};

window.N_0x0c1f7d49c39d2289 = function () {
	return _in(0x0c1f7d49, 0xc39d2289, _r, _ri);
};

window.N_0x0c5a80a9e096d529 = function (p0, p2, p3, p4, p5) {
	return _in(0x0c5a80a9, 0xe096d529, p0, _i, p2, p3, p4, p5, _r);
};

window.N_0x0c82d21a77c22d49 = function (p0, p1, p2, p3) {
	return _in(0x0c82d21a, 0x77c22d49, p0, p1, p2, p3);
};

window.N_0x0c8fac83902a62df = function (p0) {
	return _in(0x0c8fac83, 0x902a62df, p0);
};

/**
 * x360 Hash: 0x4AF0ADF5
 */
window.N_0x0c978fda19692c2c = function (p0, p1) {
	return _in(0x0c978fda, 0x19692c2c, p0, p1);
};

window.N_0x0cb1be0633c024a8 = function (p0, p1, p2, p3) {
	return _in(0x0cb1be06, 0x33c024a8, p0, p1, p2, p3);
};

window.N_0x0cd9ab83489430ea = function (p0) {
	return _in(0x0cd9ab83, 0x489430ea, p0, _r, _ri);
};

window.N_0x0cdda42f9e360ca6 = function (vehicle, p1) {
	return _in(0x0cdda42f, 0x9e360ca6, vehicle, p1);
};

window.N_0x0cf54f20de43879c = function (p0) {
	return _in(0x0cf54f20, 0xde43879c, p0);
};

window.N_0x0cf97f497fe7d048 = function (p0) {
	return _in(0x0cf97f49, 0x7fe7d048, p0);
};

window.N_0x0d01d20616fc73fb = function (p0, p1) {
	return _in(0x0d01d206, 0x16fc73fb, p0, p1);
};

window.N_0x0d30eb83668e63c5 = function (p0, p1, p2, p3) {
	return _in(0x0d30eb83, 0x668e63c5, p0, p1, p2, p3);
};

window.N_0x0d5f65a8f4ebdab5 = function (p0, p1) {
	return _in(0x0d5f65a8, 0xf4ebdab5, p0, p1);
};

/**
 * Dr. Underscore (1/6/18):
 * Seems to return a value 0-2.
 */
window.N_0x0d6ca79eeebd8ca3 = function () {
	return _in(0x0d6ca79e, 0xeebd8ca3, _r, _ri);
};

window.N_0x0d77a82dc2d0da59 = function () {
	return _in(0x0d77a82d, 0xc2d0da59, _i, _i);
};

window.N_0x0dbd5d7e3c5bec3b = function () {
	return _in(0x0dbd5d7e, 0x3c5bec3b, _r, _ri);
};

window.N_0x0e4299c549f0d1f1 = function (p0) {
	return _in(0x0e4299c5, 0x49f0d1f1, p0);
};

window.N_0x0e4f77f7b9d74d84 = function (p0) {
	return _in(0x0e4f77f7, 0xb9d74d84, p0);
};

window.N_0x0eacdf8487d5155a = function (p0) {
	return _in(0x0eacdf84, 0x87d5155a, p0);
};

window.N_0x0ede326d47cd0f3e = function (ped, player) {
	return _in(0x0ede326d, 0x47cd0f3e, ped, player, _r);
};

window.N_0x0f3b4d4e43177236 = function (p0, p1) {
	return _in(0x0f3b4d4e, 0x43177236, p0, p1);
};

window.N_0x0f62619393661d6e = function (p0, p1, p2) {
	return _in(0x0f626193, 0x93661d6e, p0, p1, p2);
};

window.N_0x0f70731baccfbb96 = function () {
	return _in(0x0f70731b, 0xaccfbb96, _r);
};

window.N_0x0f73393bac7e6730 = function () {
	return _in(0x0f73393b, 0xac7e6730, _i, _i, _r);
};

window.N_0x0fb82563989cf4fb = function (p0, p1, p2, p3) {
	return _in(0x0fb82563, 0x989cf4fb, p0, p1, p2, p3);
};

/**
 * SET_PLAYERS_*
 */
window.N_0x0fde9dbfc0a6bc65 = function (p0) {
	return _in(0x0fde9dbf, 0xc0a6bc65, _ii(p0) /* may be optional */);
};

window.N_0x0fe8e1fcd2b86b33 = function (p0, p1, p2, p3) {
	return _in(0x0fe8e1fc, 0xd2b86b33, p0, p1, p2, p3);
};

/**
 * p0 is always false in scripts.
 */
window.N_0x0ff2862b61a58af9 = function (p0) {
	return _in(0x0ff2862b, 0x61a58af9, p0);
};

window.N_0x10655fab9915623d = function (p0, p1) {
	return _in(0x10655fab, 0x9915623d, p0, p1);
};

window.N_0x1072f115dab0717e = function (p0, p1) {
	return _in(0x1072f115, 0xdab0717e, p0, p1);
};

window.N_0x1086127b3a63505e = function (p0, p1, p2) {
	return _in(0x1086127b, 0x3a63505e, p0, p1, p2);
};

window.N_0x1087bc8ec540daeb = function (p0, p1) {
	return _in(0x1087bc8e, 0xc540daeb, p0, p1);
};

window.N_0x108be26959a9d9bb = function (p0) {
	return _in(0x108be269, 0x59a9d9bb, p0);
};

window.N_0x1093408b4b9d1146 = function (p0, p1) {
	return _in(0x1093408b, 0x4b9d1146, p0, _fv(p1));
};

/**
 * Not sure what this function does, but it's related to the audio of the local player's vehicle (Considering the surrounding natives, it's probably radio related).
 */
window.N_0x109697e2ffbac8a1 = function () {
	return _in(0x109697e2, 0xffbac8a1, _r);
};

window.N_0x10bd227a753b0d84 = function () {
	return _in(0x10bd227a, 0x753b0d84, _r, _ri);
};

/**
 * In agency_heist3b.c4, its like this 90% of the time:
 * PED::_110F526AB784111F(ped, 0.099);
 * PED::SET_PED_ENVEFF_SCALE(ped, 1.0);
 * PED::_D69411AA0CEBF9E9(ped, 87, 81, 68);
 * PED::SET_ENABLE_PED_ENVEFF_SCALE(ped, 1);
 * and its like this 10% of the time:
 * PED::_110F526AB784111F(ped, 0.2);
 * PED::SET_PED_ENVEFF_SCALE(ped, 0.65);
 * PED::_D69411AA0CEBF9E9(ped, 74, 69, 60);
 * PED::SET_ENABLE_PED_ENVEFF_SCALE(ped, 1);
 */
window.N_0x110f526ab784111f = function (ped, p1) {
	return _in(0x110f526a, 0xb784111f, ped, _fv(p1));
};

window.N_0x1121bfa1a1a522a8 = function () {
	return _in(0x1121bfa1, 0xa1a522a8, _r, _ri);
};

window.N_0x112209ce0290c03a = function (p0, p1, p2, p3) {
	return _in(0x112209ce, 0x0290c03a, p0, p1, p2, p3);
};

window.N_0x113e6e3e50e286b0 = function (p0) {
	return _in(0x113e6e3e, 0x50e286b0, p0);
};

window.N_0x1153fa02a659051c = function () {
	return _in(0x1153fa02, 0xa659051c);
};

window.N_0x11579d940949c49e = function (p0) {
	return _in(0x11579d94, 0x0949c49e, p0);
};

window.N_0x116fb94dc4b79f17 = function (p0) {
	return _in(0x116fb94d, 0xc4b79f17, _ts(p0));
};

window.N_0x1171a97a3d3981b6 = function (p2, p3) {
	return _in(0x1171a97a, 0x3d3981b6, _i, _i, p2, p3, _r);
};

/**
 * SET_TEXT_??? - Used in golf and golf_mp
 */
window.N_0x1185a8087587322c = function (p0) {
	return _in(0x1185a808, 0x7587322c, p0);
};

/**
 * Found in the scripts:
 * GAMEPLAY::_11B56FBBF7224868("CONTRAILS");
 */
window.N_0x11b56fbbf7224868 = function (p0) {
	return _in(0x11b56fbb, 0xf7224868, _ts(p0));
};

/**
 * console hash: 0x883DAB2D
 */
window.N_0x11d1e53a726891fe = function (object) {
	return _in(0x11d1e53a, 0x726891fe, object, _r);
};

window.N_0x11fa5d3479c7dd47 = function (p0) {
	return _in(0x11fa5d34, 0x79c7dd47, p0);
};

window.N_0x11ff1c80276097ed = function (p0, p1, p2) {
	return _in(0x11ff1c80, 0x276097ed, _ts(p0), p1, p2);
};

window.N_0x1201e8a3290a3b98 = function (p0, p1) {
	return _in(0x1201e8a3, 0x290a3b98, p0, p1);
};

window.N_0x120364de2845daf8 = function (p1) {
	return _in(0x120364de, 0x2845daf8, _i, p1, _r, _ri);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x1216e0bfa72cc703 = function (p0, p1) {
	return _in(0x1216e0bf, 0xa72cc703, p0, p1);
};

window.N_0x121fb4dddc2d5291 = function (p0, p1, p2, p3) {
	return _in(0x121fb4dd, 0xdc2d5291, p0, p1, p2, _fv(p3));
};

/**
 * p0 is usually 0. sometimes 2. Not sure what this does.
 */
window.N_0x12561fcbb62d5b9c = function (p0) {
	return _in(0x12561fcb, 0xb62d5b9c, p0);
};

window.N_0x1280804f7cfd2d6c = function (p0) {
	return _in(0x1280804f, 0x7cfd2d6c, p0);
};

window.N_0x129466ed55140f8d = function (ped, toggle) {
	return _in(0x129466ed, 0x55140f8d, ped, toggle);
};

/**
 * Only used in the golf and golf_mp script
 */
window.N_0x12995f2e53ffa601 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11) {
	return _in(0x12995f2e, 0x53ffa601, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11);
};

window.N_0x12b6281b6c6706c0 = function (p0) {
	return _in(0x12b6281b, 0x6c6706c0, p0, _r, _ri);
};

window.N_0x12d148d26538d0f9 = function (p0, p1, p2, p3) {
	return _in(0x12d148d2, 0x6538d0f9, p0, p1, p2, p3);
};

/**
 * Hardcoded to only work in multiplayer.
 */
window.N_0x12ded8ca53d47ea5 = function (p0) {
	return _in(0x12ded8ca, 0x53d47ea5, _fv(p0));
};

window.N_0x1312ddd8385aee4e = function (p0, p1) {
	return _in(0x1312ddd8, 0x385aee4e, p0, p1);
};

window.N_0x1327e2fe9746baee = function (p0) {
	return _in(0x1327e2fe, 0x9746baee, p0, _r);
};

window.N_0x13518ff1c6b28938 = function (p0) {
	return _in(0x13518ff1, 0xc6b28938, p0, _r);
};

/**
 * Returns some kind of banned state
 */
window.N_0x1353f87e89946207 = function () {
	return _in(0x1353f87e, 0x89946207, _r);
};

window.N_0x135f9b7b7add2185 = function (p0) {
	return _in(0x135f9b7b, 0x7add2185, _ii(p0) /* may be optional */, _r);
};

window.N_0x1398582b7f72b3ed = function (p0) {
	return _in(0x1398582b, 0x7f72b3ed, p0);
};

window.N_0x13b350b8ad0eee10 = function () {
	return _in(0x13b350b8, 0xad0eee10);
};

window.N_0x13c4b962653a5280 = function () {
	return _in(0x13c4b962, 0x653a5280, _r, _ri);
};

window.N_0x13f1fcb111b820b0 = function (p0) {
	return _in(0x13f1fcb1, 0x11b820b0, p0);
};

window.N_0x140e6a44870a11ce = function () {
	return _in(0x140e6a44, 0x870a11ce);
};

window.N_0x144da052257ae7d8 = function (p0) {
	return _in(0x144da052, 0x257ae7d8, p0);
};

window.N_0x14590ddbedb1ec85 = function (ped) {
	return _in(0x14590ddb, 0xedb1ec85, ped, _r);
};

/**
 * Enables frontend (works in custom frontends, not sure about regular pause menu) navigation keys on keyboard if they were disabled using the native below.
 * To disable the keys, use [`0xEC9264727EEC0F28`](#_0xEC9264727EEC0F28).
 */
window.N_0x14621bb1df14e2b2 = function () {
	return _in(0x14621bb1, 0xdf14e2b2);
};

window.N_0x14832bf2aba53fc5 = function () {
	return _in(0x14832bf2, 0xaba53fc5, _r, _ri);
};

window.N_0x148b08c2d2acb884 = function (p0, p1, p2) {
	return _in(0x148b08c2, 0xd2acb884, p0, p1, p2);
};

window.N_0x14922ed3e38761f0 = function () {
	return _in(0x14922ed3, 0xe38761f0, _r, _ri);
};

window.N_0x149aee66f0cb3a99 = function (p0, p1) {
	return _in(0x149aee66, 0xf0cb3a99, _fv(p0), _fv(p1));
};

window.N_0x14c9fdcc41f81f63 = function (p0) {
	return _in(0x14c9fdcc, 0x41f81f63, p0);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x14d29bb12d47f68c = function (p0, p1, p2, p3, p4) {
	return _in(0x14d29bb1, 0x2d47f68c, p0, p1, p2, p3, p4);
};

window.N_0x14e0b2d1ad1044e0 = function () {
	return _in(0x14e0b2d1, 0xad1044e0, _i, _i, _i, _i);
};

window.N_0x14eda9ee27bd1626 = function (p0) {
	return _in(0x14eda9ee, 0x27bd1626, p0);
};

window.N_0x14fc5833464340a8 = function () {
	return _in(0x14fc5833, 0x464340a8);
};

window.N_0x152d90e4c1b4738a = function () {
	return _in(0x152d90e4, 0xc1b4738a, _i, _i, _r);
};

window.N_0x158ec424f35ec469 = function (p0, p1, contentType) {
	return _in(0x158ec424, 0xf35ec469, _ts(p0), p1, _ts(contentType), _r);
};

window.N_0x159b7318403a1cd8 = function (p0) {
	return _in(0x159b7318, 0x403a1cd8, p0);
};

window.N_0x15cfa549788d35ef = function () {
	return _in(0x15cfa549, 0x788d35ef);
};

window.N_0x15e33297c3e8dc60 = function (p0) {
	return _in(0x15e33297, 0xc3e8dc60, p0);
};

window.N_0x15e69e2802c24b8d = function (p0) {
	return _in(0x15e69e28, 0x02c24b8d, _fv(p0));
};

window.N_0x15f944730c832252 = function (p0, p1) {
	return _in(0x15f94473, 0x0c832252, p0, p1);
};

window.N_0x15ff52b809db2353 = function (p0) {
	return _in(0x15ff52b8, 0x09db2353, p0, _r);
};

window.N_0x1600fd8cf72ebc12 = function (p0) {
	return _in(0x1600fd8c, 0xf72ebc12, _fv(p0));
};

window.N_0x160aa1b32f6139b8 = function (doorHash) {
	return _in(0x160aa1b3, 0x2f6139b8, _ch(doorHash), _r, _ri);
};

window.N_0x1612c45f9e3e0d44 = function () {
	return _in(0x1612c45f, 0x9e3e0d44);
};

window.N_0x162c23ca83ed0a62 = function (p0) {
	return _in(0x162c23ca, 0x83ed0a62, p0, _r);
};

/**
 * gets some camera far clip
 */
window.N_0x162f9d995753dc19 = function () {
	return _in(0x162f9d99, 0x5753dc19, _r, _rf);
};

window.N_0x1632be0ac1e62876 = function (p0, p1) {
	return _in(0x1632be0a, 0xc1e62876, p0, p1);
};

window.N_0x1636d7fc127b10d2 = function (p0) {
	return _in(0x1636d7fc, 0x127b10d2, p0);
};

/**
 * only documented params
 * dont know what this does.... To Be Continued...
 */
window.N_0x163f8b586bc95f2a = function (coords, radius, modelHash, x, y, z, p7) {
	return _in(0x163f8b58, 0x6bc95f2a, coords, _fv(radius), _ch(modelHash), _fv(x), _fv(y), _fv(z), _v, p7, _r, _ri);
};

window.N_0x164c5ff663790845 = function (p0) {
	return _in(0x164c5ff6, 0x63790845, p0);
};

/**
 * 3 calls in the b617d scripts, removed duplicate.
 * AUDIO::_1654F24A88A8E3FE("RADIO_16_SILVERLAKE");
 * AUDIO::_1654F24A88A8E3FE("RADIO_01_CLASS_ROCK");
 */
window.N_0x1654f24a88a8e3fe = function (radioStation) {
	return _in(0x1654f24a, 0x88a8e3fe, _ts(radioStation));
};

/**
 * Dr. Underscore (1/6/18):
 * Seems to return a value 0-2.
 */
window.N_0x1670f8d05056f257 = function (p0) {
	return _in(0x1670f8d0, 0x5056f257, p0, _r, _ri);
};

window.N_0x16a304e6cb2bfab9 = function (r, g, b, a) {
	return _in(0x16a304e6, 0xcb2bfab9, r, g, b, a);
};

/**
 * only documented to be continued...
 */
window.N_0x16b5e274bde402f8 = function (vehicle, trailer, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11) {
	return _in(0x16b5e274, 0xbde402f8, vehicle, trailer, _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), _fv(p9), _fv(p10), _fv(p11));
};

window.N_0x16da8172459434aa = function () {
	return _in(0x16da8172, 0x459434aa, _r, _ri);
};

window.N_0x16f46fb18c8009e4 = function (p0, p1, p2, p3, p4) {
	return _in(0x16f46fb1, 0x8c8009e4, p0, p1, p2, p3, p4, _r, _ri);
};

window.N_0x170910093218c8b9 = function (p0) {
	return _in(0x17091009, 0x3218c8b9, _ii(p0) /* may be optional */, _r);
};

/**
 * Related to displaying cash on the HUD
 * Always called before UI::_SET_SINGLEPLAYER_HUD_CASH in decompiled scripts
 */
window.N_0x170f541e1cadd1de = function (p0) {
	return _in(0x170f541e, 0x1cadd1de, p0);
};

window.N_0x171bafb3c60389f4 = function (p0) {
	return _in(0x171bafb3, 0xc60389f4, p0, _r, _ri);
};

window.N_0x171df6a0c07fb3dc = function (p0, p1) {
	return _in(0x171df6a0, 0xc07fb3dc, p0, p1, _r, _ri);
};

window.N_0x17330ebf2f2124a8 = function () {
	return _in(0x17330ebf, 0x2f2124a8);
};

window.N_0x17440aa15d1d3739 = function () {
	return _in(0x17440aa1, 0x5d1d3739);
};

window.N_0x1761dc5d8471cbaa = function (p0, player, p2) {
	return _in(0x1761dc5d, 0x8471cbaa, p0, player, p2, _r);
};

window.N_0x17ad8c9706bdd88a = function (p0) {
	return _in(0x17ad8c97, 0x06bdd88a, p0);
};

window.N_0x17df68d720aa77f8 = function (p0) {
	return _in(0x17df68d7, 0x20aa77f8, p0, _r);
};

window.N_0x17e0198b3882c2cb = function () {
	return _in(0x17e0198b, 0x3882c2cb);
};

window.N_0x17f7471eaca78290 = function (p0) {
	return _in(0x17f7471e, 0xaca78290, p0);
};

window.N_0x17fca7199a530203 = function () {
	return _in(0x17fca719, 0x9a530203, _r, _ri);
};

window.N_0x182f266c2d9e2beb = function (vehicle, p1) {
	return _in(0x182f266c, 0x2d9e2beb, vehicle, _fv(p1));
};

window.N_0x1888694923ef4591 = function () {
	return _in(0x18886949, 0x23ef4591);
};

window.N_0x18eb48cfc41f2ea0 = function (p0, p1) {
	return _in(0x18eb48cf, 0xc41f2ea0, p0, _fv(p1));
};

window.N_0x190428512b240692 = function (p0, p1, p2, p3, p4) {
	return _in(0x19042851, 0x2b240692, p0, p1, p2, p3, p4);
};

window.N_0x192547247864dfdd = function (vehicle, p1) {
	return _in(0x19254724, 0x7864dfdd, vehicle, p1);
};

window.N_0x1950dae9848a4739 = function (p0, p1, p2) {
	return _in(0x1950dae9, 0x848a4739, p0, p1, p2, _r, _ri);
};

window.N_0x19853b5b17d77bca = function (p0, p1) {
	return _in(0x19853b5b, 0x17d77bca, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x1989c6e6f67e76a8 = function () {
	return _in(0x1989c6e6, 0xf67e76a8, _i, _i, _i, _r);
};

/**
 * RELEASE_???
 * I say RELEASE_???, as in IDA this native calls the same function as
 * -'RELEASE_MISSION_AUDIO_BANK()'.
 * -'RELEASE_AMBIENT_AUDIO_BANK()'.
 * -'RELEASE_SCRIPT_AUDIO_BANK()'.
 * However 'RELEASE_NAMED_SCRIPT_AUDIO_BANK' does not use the same function. So may be, 'RELEASE_???_AUDIO_BANK()'? Doubt it.
 */
window.N_0x19af7ed9b9d23058 = function () {
	return _in(0x19af7ed9, 0xb9d23058);
};

window.N_0x19bfed045c647c49 = function (p0) {
	return _in(0x19bfed04, 0x5c647c49, p0, _r);
};

/**
 * Seems to return the current type of view
 * example: // checks if you're currently in first person
 * if ((CAM::_EE778F8C7E1142E2(CAM::_19CAFA3C87F7C2FF()) == 4) && (!__463_$28ED382849B17AFC())) {
 * UI::_FDEC055AB549E328();
 * UI::_SET_NOTIFICATION_TEXT_ENTRY("REC_FEED_WAR");
 * l_CE[0 -- [[1]] ] = UI::_DRAW_NOTIFICATION(0, 1);
 * }
 */
window.N_0x19cafa3c87f7c2ff = function () {
	return _in(0x19cafa3c, 0x87f7c2ff, _r, _ri);
};

window.N_0x19d1b791cb3670fe = function (p0, p1) {
	return _in(0x19d1b791, 0xcb3670fe, p0, p1);
};

window.N_0x19e50eb6e33e1d28 = function (p0) {
	return _in(0x19e50eb6, 0xe33e1d28, p0);
};

/**
 * SET_ENTITY_*
 */
window.N_0x1a092bb0c3808b96 = function (entity, p1) {
	return _in(0x1a092bb0, 0xc3808b96, entity, p1);
};

/**
 * Only appears in lamar1 script.
 */
window.N_0x1a330d297aac6bc1 = function (ped, p1) {
	return _in(0x1a330d29, 0x7aac6bc1, ped, p1);
};

window.N_0x1a78ad3d8240536f = function (vehicle, p1) {
	return _in(0x1a78ad3d, 0x8240536f, vehicle, p1);
};

window.N_0x1a7ce7cd3e653485 = function (p0) {
	return _in(0x1a7ce7cd, 0x3e653485, p0);
};

window.N_0x1a8e2c8b9cf4549c = function () {
	return _in(0x1a8e2c8b, 0x9cf4549c, _i, _i);
};

window.N_0x1a8ea222f9c67dbb = function (p0) {
	return _in(0x1a8ea222, 0xf9c67dbb, p0, _r, _ri);
};

window.N_0x1aa8a837d2169d94 = function (vehicle, p1) {
	return _in(0x1aa8a837, 0xd2169d94, vehicle, p1);
};

window.N_0x1accfba3d8dab2ee = function (p0, p1) {
	return _in(0x1accfba3, 0xd8dab2ee, p0, p1, _r, _ri);
};

/**
 * unk_0xCEA55F4C(uVar3, "AM_ROLLERCOASTER", -1))
 * Probably has to do with seeing if they are riding the roller coaster or ferris wheel
 * NETWORK_IS_PLAYER_???
 */
window.N_0x1ad5b71586b94820 = function (p0, p2) {
	return _in(0x1ad5b715, 0x86b94820, p0, _i, p2, _r);
};

window.N_0x1b0b4aeed5b9b41c = function (p0) {
	return _in(0x1b0b4aee, 0xd5b9b41c, _fv(p0));
};

window.N_0x1b212b26dd3c04df = function (p0, p1) {
	return _in(0x1b212b26, 0xdd3c04df, p0, p1);
};

window.N_0x1b2366c3f2a5c8df = function () {
	return _in(0x1b2366c3, 0xf2a5c8df, _r, _ri);
};

window.N_0x1b7abe26cbcbf8c7 = function (p0, p1, p2) {
	return _in(0x1b7abe26, 0xcbcbf8c7, p0, p1, p2);
};

/**
 * Console Hash: 0x76A9FEB6
 */
window.N_0x1b857666604b1a74 = function (p0) {
	return _in(0x1b857666, 0x604b1a74, p0);
};

window.N_0x1bb299305c3e8c13 = function (p0, p1, p2, p3) {
	return _in(0x1bb29930, 0x5c3e8c13, p0, p1, p2, p3);
};

window.N_0x1bbac99c0bc53656 = function (p0, p1) {
	return _in(0x1bbac99c, 0x0bc53656, p0, p1);
};

/**
 * Dr. Underscore (1/6/18):
 * Only one instance across all scripts. (maintransition)
 * May not be a bool, it could be one of these 0-2 values that are returned just about 500 god damn times.
 */
window.N_0x1bbc135a4d25edde = function (p0) {
	return _in(0x1bbc135a, 0x4d25edde, p0);
};

window.N_0x1c073274e065c6d2 = function (p0, p1) {
	return _in(0x1c073274, 0xe065c6d2, p0, p1);
};

window.N_0x1c1b69fae509ba97 = function (p0, p1) {
	return _in(0x1c1b69fa, 0xe509ba97, p0, p1);
};

/**
 * NETWORK_CAN_R??? or NETWORK_CAN_S???
 */
window.N_0x1c2473301b1c66ba = function () {
	return _in(0x1c247330, 0x1b1c66ba, _r, _ri);
};

/**
 * This native is used along with these two natives: [`0xa356990e161c9e65`](https://runtime.fivem.net/doc/reference.html#_0xA356990E161C9E65) and [`0x5ce62918f8d703c7`](https://runtime.fivem.net/doc/reference.html#_0x5CE62918F8D703C7).
 * This native configures the location, size, rotation, normal height, and the difference ratio between min, normal and max.
 * All those natives combined they will output something like this: <https://i.imgur.com/TC6cku6.png>
 * @param x Grid center x coord.
 * @param y Grid center y coord.
 * @param z Grid center z coord.
 * @param p3 Not sure, but seems to be the amount of lines top/bottom there are in the grid. -1.0 works best.
 * @param rotation Grid rotation (keep between 0.0 and 1.0).
 * @param p5 Offset top/bottom (? not sure about this one, seems weird).
 * @param width Grid width (usually 15.0).
 * @param height Grid height (usually 15.0).
 * @param p8 Not sure, but seems to be the amount of lines left/right there are in the grid. -1.0 works best.
 * @param scale Zoom / scale (higher values = smaller (more) squares) (lower values = bigger (less) squares).
 * @param glowIntensity glow intensity / opacity (40.0 is fine for daylight, 15.0 is fine for night time).
 * @param normalHeight The z coord for 'normal' height (white grid lines level).
 * @param heightDiff This is the height difference/margin used for line color changes. 0.2 works fine (normalHeight + 0.2 = yellow, normalHeight - 0.2 = red).
 */
window.N_0x1c4fc5752bcd8e48 = function (x, y, z, p3, rotation, p5, width, height, p8, scale, glowIntensity, normalHeight, heightDiff) {
	return _in(0x1c4fc575, 0x2bcd8e48, _fv(x), _fv(y), _fv(z), _fv(p3), _fv(rotation), _fv(p5), _fv(width), _fv(height), _fv(p8), _fv(scale), _fv(glowIntensity), _fv(normalHeight), _fv(heightDiff));
};

window.N_0x1cae5d2e3f9a07f0 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x1cae5d2e, 0x3f9a07f0, p0, p1, p2, p3, p4, p5);
};

window.N_0x1cba05ae7bd7ee05 = function (p0) {
	return _in(0x1cba05ae, 0x7bd7ee05, _fv(p0));
};

window.N_0x1d4446a62d35b0d0 = function (p0, p1) {
	return _in(0x1d4446a6, 0x2d35b0d0, p0, p1, _r, _ri);
};

window.N_0x1d4dc17c38feaff0 = function () {
	return _in(0x1d4dc17c, 0x38feaff0, _r, _ri);
};

window.N_0x1d610eb0fea716d9 = function (p0) {
	return _in(0x1d610eb0, 0xfea716d9, p0, _r);
};

/**
 * Related to Hao races.
 */
window.N_0x1d97d1e3a70a649f = function (vehicle, p1) {
	return _in(0x1d97d1e3, 0xa70a649f, vehicle, p1);
};

window.N_0x1da0da9cb3f0c8bf = function (p0) {
	return _in(0x1da0da9c, 0xb3f0c8bf, p0, _r, _ri);
};

window.N_0x1dd2139a9a20dce8 = function () {
	return _in(0x1dd2139a, 0x9a20dce8, _r);
};

window.N_0x1dda078d12879eee = function (p0, p1, p2) {
	return _in(0x1dda078d, 0x12879eee, p0, p1, p2);
};

window.N_0x1de0f5f50d723caa = function () {
	return _in(0x1de0f5f5, 0x0d723caa, _i, _i, _i, _r);
};

window.N_0x1e3f1b1b891a2aaa = function (p0, p1) {
	return _in(0x1e3f1b1b, 0x891a2aaa, p0, p1);
};

window.N_0x1e45b34adebee48e = function () {
	return _in(0x1e45b34a, 0xdebee48e);
};

window.N_0x1e77fa7a62ee6c4c = function (p0) {
	return _in(0x1e77fa7a, 0x62ee6c4c, p0, _r, _ri);
};

window.N_0x1e9057a74fd73e23 = function () {
	return _in(0x1e9057a7, 0x4fd73e23);
};

/**
 * Console Hash: 0xDF6D5D54
 * Name was _GET_PED_TIME_OF_DEATH
 * -----------------------------------------------------------------
 * There is no way this is the correct name. The only time this is called it's compared with the game timer and I used this to test something and noticed when I was killed by no matter what it was my 'Time Of Death' via this native was always 0, but my friends was some random big number like so, 147591.
 * Retreives [CPed + 15CC] (as of 944)
 */
window.N_0x1e98817b311ae98a = function (ped) {
	return _in(0x1e98817b, 0x311ae98a, ped, _r, _ri);
};
window.GetPedTimeOfDeath = window.N_0x1e98817b311ae98a;

window.N_0x1eac5f91bcbc5073 = function (p0) {
	return _in(0x1eac5f91, 0xbcbc5073, p0);
};

/**
 * Unsure about the use of this native but here's an example:
 * void sub_8709() {
 * GAMEPLAY::_1EAE0A6E978894A2(0, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(1, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(2, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(3, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(4, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(5, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(6, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(7, 1);
 * GAMEPLAY::_1EAE0A6E978894A2(8, 1);
 * }
 * So it appears that p0 ranges from 0 to 8.
 * ENABLE_DISPATCH_SERVICE, seems to have a similar layout.
 */
window.N_0x1eae0a6e978894a2 = function (p0, p1) {
	return _in(0x1eae0a6e, 0x978894a2, p0, p1);
};

window.N_0x1eae6dd17b7a5efa = function (p0) {
	return _in(0x1eae6dd1, 0x7b7a5efa, p0);
};

window.N_0x1ee7d8df4425f053 = function (p0) {
	return _in(0x1ee7d8df, 0x4425f053, p0);
};

window.N_0x1f1e9682483697c7 = function (p0, p1) {
	return _in(0x1f1e9682, 0x483697c7, p0, p1, _r);
};

window.N_0x1f2300cb7fa7b7f6 = function () {
	return _in(0x1f2300cb, 0x7fa7b7f6, _r, _ri);
};

window.N_0x1f2e4e06dea8992b = function (p0, p1) {
	return _in(0x1f2e4e06, 0xdea8992b, p0, p1);
};

window.N_0x1f34b0626c594380 = function (p0, p1) {
	return _in(0x1f34b062, 0x6c594380, p0, p1);
};

window.N_0x1f351cf1c6475734 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0x1f351cf1, 0xc6475734, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
};

window.N_0x1f3f018bc3afa77c = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0x1f3f018b, 0xc3afa77c, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, p8, _r, _ri);
};

window.N_0x1f8e00fb18239600 = function (p0) {
	return _in(0x1f8e00fb, 0x18239600, p0);
};

window.N_0x1f9fb66f3a3842d2 = function (vehicle, p1) {
	return _in(0x1f9fb66f, 0x3a3842d2, vehicle, p1);
};

window.N_0x1fc289a0c3ff470f = function (p0) {
	return _in(0x1fc289a0, 0xc3ff470f, p0, _r, _ri);
};

window.N_0x1ff6bf9a63e5757f = function () {
	return _in(0x1ff6bf9a, 0x63e5757f);
};

window.N_0x2016c603d6b8987c = function (p0, p1) {
	return _in(0x2016c603, 0xd6b8987c, p0, p1);
};

window.N_0x203b381133817079 = function (p0) {
	return _in(0x203b3811, 0x33817079, p0);
};

window.N_0x206bc5dc9d1ac70a = function (vehicle, p1) {
	return _in(0x206bc5dc, 0x9d1ac70a, vehicle, p1);
};

window.N_0x20746f7b1032a3c7 = function (p0, p1, p2, p3) {
	return _in(0x20746f7b, 0x1032a3c7, p0, p1, p2, p3);
};

/**
 * -This function appears to be deprecated/ unused. Tracing the call internally leads to a _nullsub -
 * first one seems to be a string of a mission name, second one seems to be a bool/toggle
 * p1 was always 0.
 */
window.N_0x208784099002bc30 = function (missionNameLabel, p1) {
	return _in(0x20878409, 0x9002bc30, _ts(missionNameLabel), p1);
};

window.N_0x20c6c7e4eb082a7f = function (p0) {
	return _in(0x20c6c7e4, 0xeb082a7f, p0);
};

window.N_0x20fe7fdfeead38c0 = function () {
	return _in(0x20fe7fdf, 0xeead38c0);
};

window.N_0x2107a3773771186d = function () {
	return _in(0x2107a377, 0x3771186d, _r, _ri);
};

window.N_0x21115bcd6e44656a = function (p0, p1) {
	return _in(0x21115bcd, 0x6e44656a, p0, p1);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x211c4ef450086857 = function () {
	return _in(0x211c4ef4, 0x50086857);
};

window.N_0x213aeb2b90cba7ac = function (p0, p1, p2) {
	return _in(0x213aeb2b, 0x90cba7ac, p0, p1, p2);
};

/**
 * example
 * if (UI::IS_HELP_MESSAGE_BEING_DISPLAYED()&&(!UI::_214CD562A939246A())) {
 * return 0;
 * }
 */
window.N_0x214cd562a939246a = function () {
	return _in(0x214cd562, 0xa939246a, _r);
};

/**
 * Only called once inside main_persitant with the parameters, 0
 */
window.N_0x21973bbf8d17edfa = function (p0, p1) {
	return _in(0x21973bbf, 0x8d17edfa, p0, p1);
};

window.N_0x21c235bc64831e5a = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0x21c235bc, 0x64831e5a, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), p9, _r, _rv);
};

window.N_0x21d04d7bc538c146 = function (p0) {
	return _in(0x21d04d7b, 0xc538c146, p0, _r);
};

/**
 * From b617 scripts:
 * CAM::_21E253A7F8DA5DFB("DINGHY");
 * CAM::_21E253A7F8DA5DFB("ISSI2");
 * CAM::_21E253A7F8DA5DFB("SPEEDO");
 */
window.N_0x21e253a7f8da5dfb = function (vehicleName) {
	return _in(0x21e253a7, 0xf8da5dfb, _ts(vehicleName));
};

/**
 * SET_TV_???
 */
window.N_0x2201c576facaebe8 = function (p0, p1, p2) {
	return _in(0x2201c576, 0xfacaebe8, p0, _ts(p1), p2);
};

/**
 * Function.Call(Hash._0x2208438012482A1A, ped, 0, 0);
 * This makes the ped have faster animations
 */
window.N_0x2208438012482a1a = function (ped, p1, p2) {
	return _in(0x22084380, 0x12482a1a, ped, p1, p2);
};

window.N_0x225798743970412b = function (p0) {
	return _in(0x22579874, 0x3970412b, _ii(p0) /* may be optional */, _r);
};

/**
 * Probably the opposite of  0x80E4A6EDDB0BE8D9 / LOAD_ALL_PATH_NODES
 */
window.N_0x228e5c6ad4d74bfd = function (p0) {
	return _in(0x228e5c6a, 0xd4d74bfd, p0);
};

window.N_0x22a249a53034450a = function (p0) {
	return _in(0x22a249a5, 0x3034450a, p0);
};

window.N_0x22da66936e0fff37 = function (p0) {
	return _in(0x22da6693, 0x6e0fff37, p0, _r);
};

/**
 * Probably GET_VEHICLE_SOMETHING
 * @return Returns a BOOL
 */
window.N_0x22fecb546c276a30 = function (vehicle) {
	return _in(0x22fecb54, 0x6c276a30, vehicle, _r);
};

window.N_0x2302c0264ea58d31 = function () {
	return _in(0x2302c026, 0x4ea58d31);
};

window.N_0x2311dd7159f00582 = function (vehicle, p1) {
	return _in(0x2311dd71, 0x59f00582, vehicle, p1);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x23227df0b2115469 = function () {
	return _in(0x23227df0, 0xb2115469);
};

window.N_0x23789e777d14ce44 = function () {
	return _in(0x23789e77, 0x7d14ce44, _r, _ri);
};

window.N_0x237d5336a9a54108 = function (p0) {
	return _in(0x237d5336, 0xa9a54108, p0, _r);
};

window.N_0x2382ab11450ae7ba = function (p0, p1) {
	return _in(0x2382ab11, 0x450ae7ba, p0, p1);
};

window.N_0x23b59d8912f94246 = function () {
	return _in(0x23b59d89, 0x12f94246);
};

/**
 * Dr. Underscore (1/6/18):
 * Found only in all creator scripts. (fm_capture_creator, fm_deathmatch_creator, fm_lts_creator, fm_mission_controller, fm_race_creator)
 * Used in-between DRAW_* calls (DRAW_POLY specifically).
 */
window.N_0x23ba6b0c2ad7b0d3 = function (toggle) {
	return _in(0x23ba6b0c, 0x2ad7b0d3, toggle);
};

window.N_0x23f09eadc01449d6 = function (p0) {
	return _in(0x23f09ead, 0xc01449d6, p0, _r);
};

/**
 * ------------------------
 * | Belongs in DLC2 |
 * ------------------------
 * Console Hash: 0x0AF83036
 * Only used once in scripts, in maintransition.
 * maintransition.c4, line ~82432:
 * if (PED::_7350823473013C02(PLAYER::PLAYER_PED_ID()) && (DECORATOR::_241FCA5B1AA14F75() == 0)) {
 * g_2542A5 = a_1; // 'g_2542A5' used in 'building_controller.ysc' for IPL stuff?
 * return 1;
 * }
 * Likely used solely for the players ped. The function it's in seems to only be used for initialization/quitting. Called among natives to discard scaleforms, disable frontend, fading in/out, etc. Neighboring strings to some calls include "HUD_JOINING", "HUD_QUITTING".
 */
window.N_0x241fca5b1aa14f75 = function () {
	return _in(0x241fca5b, 0x1aa14f75, _r);
};

/**
 * p0 is int or bool
 */
window.N_0x2432784aca090da4 = function (p0) {
	return _in(0x2432784a, 0xca090da4, p0, _r);
};

window.N_0x24409fc4c55cb22d = function (p0) {
	return _in(0x24409fc4, 0xc55cb22d, p0, _r, _ri);
};

window.N_0x2467a2d807d37ca3 = function (p0) {
	return _in(0x2467a2d8, 0x07d37ca3, p0, _r, _ri);
};

window.N_0x2472622ce1f2d45f = function (p0, p1, p2) {
	return _in(0x2472622c, 0xe1f2d45f, p0, p1, p2);
};

window.N_0x247acbc4abbc9d1c = function (p0) {
	return _in(0x247acbc4, 0xabbc9d1c, p0);
};

window.N_0x2485d34e50a22e84 = function (p0, p1, p2) {
	return _in(0x2485d34e, 0x50a22e84, _fv(p0), _fv(p1), _fv(p2));
};

window.N_0x24a49beaf468dc90 = function (p0, p2, p3, p4) {
	return _in(0x24a49bea, 0xf468dc90, p0, _i, p2, p3, p4, _r);
};

window.N_0x24e4e51fc16305f9 = function () {
	return _in(0x24e4e51f, 0xc16305f9, _r, _ri);
};

window.N_0x25361a96e0f7e419 = function (p0, p1, p2, p3) {
	return _in(0x25361a96, 0xe0f7e419, p0, p1, p2, p3, _r, _ri);
};

window.N_0x25367de49d64cf16 = function (vehicle, p1) {
	return _in(0x25367de4, 0x9d64cf16, vehicle, p1);
};

window.N_0x25615540d894b814 = function (p0, p1) {
	return _in(0x25615540, 0xd894b814, p0, p1);
};

window.N_0x2587a48bc88dfadf = function (p0) {
	return _in(0x2587a48b, 0xc88dfadf, p0);
};

window.N_0x259ba6d4e6f808f1 = function (p0) {
	return _in(0x259ba6d4, 0xe6f808f1, p0);
};

window.N_0x25b99872d588a101 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x25b99872, 0xd588a101, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _r, _ri);
};

window.N_0x25d990f8e0e3f13c = function () {
	return _in(0x25d990f8, 0xe0e3f13c);
};

window.N_0x25f87b30c382fca7 = function () {
	return _in(0x25f87b30, 0xc382fca7);
};

window.N_0x25fc3e33a31ad0c9 = function (p0) {
	return _in(0x25fc3e33, 0xa31ad0c9, p0);
};

window.N_0x2605663bd4f23b5d = function (p0) {
	return _in(0x2605663b, 0xd4f23b5d, p0);
};

window.N_0x261e97ad7bcf3d40 = function (p0) {
	return _in(0x261e97ad, 0x7bcf3d40, p0);
};

window.N_0x2632482fd6b9ab87 = function () {
	return _in(0x2632482f, 0xd6b9ab87);
};

window.N_0x265559da40b3f327 = function (p0) {
	return _in(0x265559da, 0x40b3f327, p0);
};

window.N_0x265635150fb0d82e = function () {
	return _in(0x26563515, 0x0fb0d82e);
};

window.N_0x267c78c60e806b9a = function (p0, p1) {
	return _in(0x267c78c6, 0x0e806b9a, p0, p1);
};

window.N_0x26903d9cd1175f2c = function (p0, p1) {
	return _in(0x26903d9c, 0xd1175f2c, p0, p1, _r, _ri);
};

window.N_0x26af0e8e30bd2a2c = function (ped) {
	return _in(0x26af0e8e, 0x30bd2a2c, ped, _r);
};

/**
 * STATS::0x343B27E2(0);
 * STATS::0x343B27E2(1);
 * STATS::0x343B27E2(2);
 * STATS::0x343B27E2(3);
 * STATS::0x343B27E2(4);
 * STATS::0x343B27E2(5);
 * STATS::0x343B27E2(6);
 * STATS::0x343B27E2(7);
 * Identical in ingamehud & maintransition.
 */
window.N_0x26d7399b9587fe89 = function (p0) {
	return _in(0x26d7399b, 0x9587fe89, p0);
};

window.N_0x26d99d5a82fd18e8 = function (p0) {
	return _in(0x26d99d5a, 0x82fd18e8, p0);
};

/**
 * spook.
 * This function calls a function that gets another player stat, although implementation wasn't finished so it can only get your own stat.
 * Stat value it calls: 0xFC58E972
 */
window.N_0x26f07dd83a5f7f98 = function () {
	return _in(0x26f07dd8, 0x3a5f7f98, _r, _ri);
};

window.N_0x2708fc083123f9ff = function () {
	return _in(0x2708fc08, 0x3123f9ff);
};

window.N_0x271017b9ba825366 = function (p0, p1) {
	return _in(0x271017b9, 0xba825366, p0, p1);
};

window.N_0x271401846bd26e92 = function (p0, p1) {
	return _in(0x27140184, 0x6bd26e92, p0, p1);
};

window.N_0x271c9d3aca5d6409 = function (rope) {
	return _in(0x271c9d3a, 0xca5d6409, rope, _r);
};

window.N_0x2735233a786b1bef = function (ped, p1) {
	return _in(0x2735233a, 0x786b1bef, ped, _fv(p1));
};

window.N_0x274a1519dfc1094f = function (p1) {
	return _in(0x274a1519, 0xdfc1094f, _i, p1, _i, _r);
};

window.N_0x2790f4b17d098e26 = function (p0) {
	return _in(0x2790f4b1, 0x7d098e26, p0);
};

window.N_0x279d50de5652d935 = function (p0, p1) {
	return _in(0x279d50de, 0x5652d935, p0, p1);
};

window.N_0x27aa1c973cacfe63 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0x27aa1c97, 0x3cacfe63, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
};

/**
 * IS_VEHICLE_BUMPER_HANGING_OFF
 * Not sure what the actual name is but this checks if the bumper of a vehicle is hanging off. It will return true if it is hanging, false if it falls off and false if it is not hanging off.
 */
window.N_0x27b926779deb502d = function (vehicle, frontBumper) {
	return _in(0x27b92677, 0x9deb502d, vehicle, frontBumper, _r);
};

window.N_0x27cb772218215325 = function () {
	return _in(0x27cb7722, 0x18215325);
};

window.N_0x27cfb1b1e078cb2d = function () {
	return _in(0x27cfb1b1, 0xe078cb2d);
};

window.N_0x27e32866e9a5c416 = function (p0) {
	return _in(0x27e32866, 0xe9a5c416, _fv(p0));
};

window.N_0x27feb5254759cde3 = function (textureDict, p1) {
	return _in(0x27feb525, 0x4759cde3, _ts(textureDict), p1, _r);
};

window.N_0x2801d0012266df07 = function (p0) {
	return _in(0x2801d001, 0x2266df07, p0);
};

window.N_0x280c7e3ac7f56e90 = function (p0) {
	return _in(0x280c7e3a, 0xc7f56e90, p0, _i, _i, _i);
};

window.N_0x282b6739644f4347 = function (p0) {
	return _in(0x282b6739, 0x644f4347, p0);
};

window.N_0x283b6062a2c01e9b = function () {
	return _in(0x283b6062, 0xa2c01e9b);
};

window.N_0x287f1f75d2803595 = function (p0, p1) {
	return _in(0x287f1f75, 0xd2803595, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x288df530c92dad6f = function (p0, p1) {
	return _in(0x288df530, 0xc92dad6f, p0, _fv(p1));
};

window.N_0x28b18377eb6e25f6 = function (p0, p1) {
	return _in(0x28b18377, 0xeb6e25f6, p0, p1);
};

window.N_0x28ecb8ac2f607db2 = function (p0, p1, p2, p3, p4) {
	return _in(0x28ecb8ac, 0x2f607db2, p0, p1, p2, p3, p4);
};

window.N_0x2916a928514c9827 = function () {
	return _in(0x2916a928, 0x514c9827);
};

window.N_0x29280002282f1928 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23) {
	return _in(0x29280002, 0x282f1928, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23);
};

window.N_0x293220da1b46cebc = function (p0, p1, p2) {
	return _in(0x293220da, 0x1b46cebc, _fv(p0), _fv(p1), p2);
};

window.N_0x299ef3c576773506 = function () {
	return _in(0x299ef3c5, 0x76773506, _r, _ri);
};

window.N_0x29c24bfbed8ab8fb = function (p0, p1) {
	return _in(0x29c24bfb, 0xed8ab8fb, _fv(p0), _fv(p1), _r, _rf);
};

window.N_0x2a2173e46daecd12 = function (p0, p1) {
	return _in(0x2a2173e4, 0x6daecd12, p0, p1);
};

window.N_0x2a25adc48f87841f = function () {
	return _in(0x2a25adc4, 0x8f87841f, _r, _ri);
};

window.N_0x2a2a52824db96700 = function (p0) {
	return _in(0x2a2a5282, 0x4db96700, _ii(p0) /* may be optional */);
};

window.N_0x2a56c06ebef2b0d9 = function (cutsceneEntName, ped, modelHash) {
	return _in(0x2a56c06e, 0xbef2b0d9, _ts(cutsceneEntName), ped, _ch(modelHash));
};

window.N_0x2a5e0621dd815a9a = function (p0, p1, p2, p3) {
	return _in(0x2a5e0621, 0xdd815a9a, p0, p1, p2, p3);
};

window.N_0x2a7776c709904ab0 = function (p0) {
	return _in(0x2a7776c7, 0x09904ab0, p0, _r, _ri);
};

window.N_0x2a86a0475b6a1434 = function (p0, p1) {
	return _in(0x2a86a047, 0x5b6a1434, p0, p1);
};

/**
 * 2 matches across 2 scripts. Only showed in appcamera & appmedia. Both were 0.
 * Dr. Underscore (1/6/18):
 * I've found a reference in maintransition with 1, plus in appcamera and appmedia.
 * Takes and returns a bool.
 */
window.N_0x2a893980e96b659a = function (p0) {
	return _in(0x2a893980, 0xe96b659a, p0, _r);
};

/**
 * VEHICLE::_2A8F319B392E7B3F(vehicle, 0.5);
 */
window.N_0x2a8f319b392e7b3f = function (vehicle, p1) {
	return _in(0x2a8f319b, 0x392e7b3f, vehicle, _fv(p1));
};

/**
 * if (ENTITY::DOES_ENTITY_EXIST(l_228)) {
 * CAM::_2AED6301F67007D5(l_228);
 */
window.N_0x2aed6301f67007d5 = function (entity) {
	return _in(0x2aed6301, 0xf67007d5, entity);
};

window.N_0x2afc2d19b50797f2 = function (p0, p1, p2, p3) {
	return _in(0x2afc2d19, 0xb50797f2, p0, p1, p2, p3);
};

window.N_0x2b1c623823db0d9d = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x2b1c6238, 0x23db0d9d, p0, p1, p2, p3, p4, p5, p6, _r, _ri);
};

window.N_0x2b40a97646381508 = function (p0) {
	return _in(0x2b40a976, 0x46381508, p0);
};

window.N_0x2b51edbefc301339 = function (p0, p1) {
	return _in(0x2b51edbe, 0xfc301339, p0, _ts(p1), _r);
};

window.N_0x2b5aa717a181fb4c = function (p0, p1) {
	return _in(0x2b5aa717, 0xa181fb4c, p0, p1);
};

window.N_0x2b5e102e4a42f2bf = function () {
	return _in(0x2b5e102e, 0x4a42f2bf, _r, _ri);
};

window.N_0x2b626a0150e4d449 = function () {
	return _in(0x2b626a01, 0x50e4d449, _r, _ri);
};

window.N_0x2b6747faa9db9d6b = function (vehicle, p1) {
	return _in(0x2b6747fa, 0xa9db9d6b, vehicle, p1, _r, _ri);
};

window.N_0x2b694afcf64e6994 = function (ped, p1) {
	return _in(0x2b694afc, 0xf64e6994, ped, p1);
};

window.N_0x2b69f5074c894811 = function (p0, p1, p2, p3) {
	return _in(0x2b69f507, 0x4c894811, p0, p1, p2, p3);
};

window.N_0x2b949a1e6aec8f6a = function () {
	return _in(0x2b949a1e, 0x6aec8f6a, _r, _ri);
};

window.N_0x2be4bc731d039d5a = function (p0, p1) {
	return _in(0x2be4bc73, 0x1d039d5a, p0, p1);
};

window.N_0x2bf66d2e7414f686 = function () {
	return _in(0x2bf66d2e, 0x7414f686, _r, _ri);
};

/**
 * Seems to always return 0 from what I can tell. I've tried a lot of different blip related natives and it always seems to return 0.
 * Decompiled scripts always pass a blip handle as p0.
 * ```
 * // freemode.c
 * if (HUD::DOES_BLIP_EXIST(Global_2415594[iParam0]))
 * {
 * if (HUD::_0x2C173AE2BDB9385E(Global_2415594[iParam0]) != 0)
 * {
 * return 1;
 * }
 * }
 * ```
 * @param blip The blip to check.
 * @return Seems to always return 0 from what I can tell. I've tried a lot of different blip related natives and it always seems to return 0.
 */
window.N_0x2c173ae2bdb9385e = function (blip) {
	return _in(0x2c173ae2, 0xbdb9385e, blip, _r, _ri);
};

window.N_0x2c1d8b3b19e517cc = function (p0, p1) {
	return _in(0x2c1d8b3b, 0x19e517cc, p0, p1, _r, _ri);
};

/**
 * SET_ENTITY_*
 */
window.N_0x2c2e3dc128f44309 = function (entity, p1) {
	return _in(0x2c2e3dc1, 0x28f44309, entity, p1);
};

window.N_0x2c42340f916c5930 = function (p0) {
	return _in(0x2c42340f, 0x916c5930, p0, _r, _ri);
};

window.N_0x2c4a1590abf43e8b = function (vehicle, p1) {
	return _in(0x2c4a1590, 0xabf43e8b, vehicle, p1);
};

window.N_0x2c8cbfe1ea5fc631 = function (p0) {
	return _in(0x2c8cbfe1, 0xea5fc631, p0, _r, _ri);
};

window.N_0x2c96cdb04fca358e = function (p0) {
	return _in(0x2c96cdb0, 0x4fca358e, _fv(p0));
};

window.N_0x2c9f302398e13141 = function (p0, p1) {
	return _in(0x2c9f3023, 0x98e13141, p0, p1);
};

window.N_0x2cc848a861d01493 = function () {
	return _in(0x2cc848a8, 0x61d01493, _r, _ri);
};

window.N_0x2cd90358f67d0aa8 = function (p0) {
	return _in(0x2cd90358, 0xf67d0aa8, p0);
};

window.N_0x2ce9d95e4051aecd = function (p0) {
	return _in(0x2ce9d95e, 0x4051aecd, p0);
};

window.N_0x2d4259f1feb81da9 = function (p0, p1, p2, p3) {
	return _in(0x2d4259f1, 0xfeb81da9, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _r, _ri);
};

window.N_0x2d5dc831176d0114 = function (p0) {
	return _in(0x2d5dc831, 0x176d0114, p0, _r);
};

window.N_0x2da41ed6e1fcd7a5 = function (p0, p1) {
	return _in(0x2da41ed6, 0xe1fcd7a5, p0, p1, _r, _ri);
};

window.N_0x2de6c5e2e996f178 = function (p0) {
	return _in(0x2de6c5e2, 0xe996f178, p0);
};

window.N_0x2df9038c90ad5264 = function (p0, p1, p2, p3, p4, interiorFlags, scale, duration) {
	return _in(0x2df9038c, 0x90ad5264, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), interiorFlags, _fv(scale), duration);
};

window.N_0x2dfc81c9b9608549 = function (p0, p1) {
	return _in(0x2dfc81c9, 0xb9608549, p0, p1, _r, _ri);
};

window.N_0x2e0bf682cc778d49 = function (p0) {
	return _in(0x2e0bf682, 0xcc778d49, p0, _r);
};

window.N_0x2e22fefa0100275e = function () {
	return _in(0x2e22fefa, 0x0100275e, _r, _ri);
};

window.N_0x2e4c123d1c8a710e = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x2e4c123d, 0x1c8a710e, p0, p1, p2, p3, p4, p5, p6, _r, _ri);
};

window.N_0x2e65248609523599 = function (p0, p1, p2) {
	return _in(0x2e652486, 0x09523599, p0, p1, p2);
};

window.N_0x2e89990ddff670c3 = function (p0, p1) {
	return _in(0x2e89990d, 0xdff670c3, p0, p1, _r, _ri);
};

window.N_0x2eac52b4019e2782 = function () {
	return _in(0x2eac52b4, 0x019e2782, _r, _ri);
};

window.N_0x2ed61456317b8178 = function () {
	return _in(0x2ed61456, 0x317b8178);
};

/**
 * Appears to return whether the player is using the pause menu store. Can't be sure though.
 */
window.N_0x2f057596f2bd0061 = function () {
	return _in(0x2f057596, 0xf2bd0061, _r, _ri);
};

window.N_0x2f074c904d85129e = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x2f074c90, 0x4d85129e, p0, p1, p2, p3, p4, p5, p6);
};

/**
 * only documented. to be continued...
 */
window.N_0x2f09f7976c512404 = function (xCoord, yCoord, zCoord, p3) {
	return _in(0x2f09f797, 0x6c512404, _fv(xCoord), _fv(yCoord), _fv(zCoord), _fv(p3), _r);
};

window.N_0x2f137b508de238f2 = function (p0) {
	return _in(0x2f137b50, 0x8de238f2, p0);
};

window.N_0x2f3c3d9f50681de4 = function (p0, p1) {
	return _in(0x2f3c3d9f, 0x50681de4, p0, p1);
};

window.N_0x2f41a3bae005e5fa = function (p0, p1) {
	return _in(0x2f41a3ba, 0xe005e5fa, p0, p1);
};

/**
 * Used with radios:
 * void sub_cf383(auto _a0) {
 * if ((a_0)==1) {
 * if (GAMEPLAY::IS_BIT_SET((g_240005._f1), 3)) {
 * PLAYER::_2F7CEB6520288061(0);
 * AUDIO::SET_AUDIO_FLAG("AllowRadioDuringSwitch", 0);
 * AUDIO::SET_MOBILE_PHONE_RADIO_STATE(0);
 * AUDIO::SET_AUDIO_FLAG("MobileRadioInGame", 0);
 * }
 * sub_cf3f6(1);
 * } else {
 * if (GAMEPLAY::IS_BIT_SET((g_240005._f1), 3)) {
 * PLAYER::_2F7CEB6520288061(1);
 * AUDIO::SET_AUDIO_FLAG("AllowRadioDuringSwitch", 1);
 * AUDIO::SET_MOBILE_PHONE_RADIO_STATE(1);
 * AUDIO::SET_AUDIO_FLAG("MobileRadioInGame", 1);
 * }
 * sub_cf3f6(0);
 * }
 * }
 * SET_PLAYER_S*
 */
window.N_0x2f7ceb6520288061 = function (p0) {
	return _in(0x2f7ceb65, 0x20288061, p0);
};

window.N_0x2f7f2b26dd3f18ee = function (p0, p1) {
	return _in(0x2f7f2b26, 0xdd3f18ee, _fv(p0), _fv(p1));
};

window.N_0x2fa2494b47fdd009 = function (p0, p1) {
	return _in(0x2fa2494b, 0x47fdd009, p0, p1);
};

window.N_0x2fab6614ce22e196 = function (p0, p1, p2, p3) {
	return _in(0x2fab6614, 0xce22e196, p0, p1, p2, p3);
};

/**
 * NETWORK_IS_IN_???
 */
window.N_0x2fc5650b0271cb57 = function () {
	return _in(0x2fc5650b, 0x0271cb57, _r, _ri);
};

window.N_0x3001bef2feca3680 = function () {
	return _in(0x3001bef2, 0xfeca3680, _r);
};

window.N_0x302c91ab2d477f7e = function () {
	return _in(0x302c91ab, 0x2d477f7e);
};

window.N_0x3044240d2e0fa842 = function () {
	return _in(0x3044240d, 0x2e0fa842, _r);
};

window.N_0x3054f114121c21ea = function (p0) {
	return _in(0x3054f114, 0x121c21ea, p0, _r);
};

window.N_0x308f96458b7087cc = function (p1, p2, p3, p5) {
	return _in(0x308f9645, 0x8b7087cc, _i, p1, p2, p3, _i, p5, _r, _ri);
};

window.N_0x30a6614c1f7799b8 = function (p0, p1, p2) {
	return _in(0x30a6614c, 0x1f7799b8, p0, _fv(p1), p2);
};

window.N_0x30ed88d5e0c56a37 = function (p0) {
	return _in(0x30ed88d5, 0xe0c56a37, p0, _r);
};

window.N_0x30fd873ece50e9f6 = function (p0, p1, p2, p3, p4) {
	return _in(0x30fd873e, 0xce50e9f6, p0, p1, p2, p3, p4);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x31125fd509d9043f = function (p0) {
	return _in(0x31125fd5, 0x09d9043f, _ii(p0) /* may be optional */);
};

window.N_0x311438a071dd9b1a = function (p0, p1, p2) {
	return _in(0x311438a0, 0x71dd9b1a, p0, p1, p2);
};

window.N_0x3117d84efa60f77b = function (p0) {
	return _in(0x3117d84e, 0xfa60f77b, _fv(p0));
};

/**
 * p8 seems to always be false.
 */
window.N_0x312342e1a4874f3f = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0x312342e1, 0xa4874f3f, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), p8);
};

window.N_0x31727907b2c43c55 = function (p0) {
	return _in(0x31727907, 0xb2c43c55, _fv(p0));
};

/**
 * From the decompiled scripts, called 61 times:
 * UI::_317EBA71D7543F52(&v_13, &v_13, &v_3, &v_3);
 */
window.N_0x317eba71d7543f52 = function () {
	return _in(0x317eba71, 0xd7543f52, _i, _i, _i, _i);
};

window.N_0x318516e02de3ece2 = function (p0) {
	return _in(0x318516e0, 0x2de3ece2, _fv(p0));
};

window.N_0x3195f8dd0d531052 = function (p0, p1) {
	return _in(0x3195f8dd, 0x0d531052, p0, p1, _i, _i, _r);
};

window.N_0x31e90b8873a4cd3b = function (p0, p1) {
	return _in(0x31e90b88, 0x73a4cd3b, p0, p1);
};

window.N_0x31f924b53eaddf65 = function (p0) {
	return _in(0x31f924b5, 0x3eaddf65, p0);
};

window.N_0x3270f67eed31fbc1 = function (p0) {
	return _in(0x3270f67e, 0xed31fbc1, p0, _i, _i, _r);
};

window.N_0x32888337579a5970 = function () {
	return _in(0x32888337, 0x579a5970);
};

window.N_0x32c7a7e8c43a1f80 = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0x32c7a7e8, 0xc43a1f80, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, p7, _r, _ri);
};

window.N_0x32cac93c9de73d32 = function () {
	return _in(0x32cac93c, 0x9de73d32, _r, _ri);
};

window.N_0x32caedf24a583345 = function (p0) {
	return _in(0x32caedf2, 0x4a583345, p0);
};

window.N_0x32dd916f3f7c9672 = function (p0) {
	return _in(0x32dd916f, 0x3f7c9672, p0, _r, _ri);
};

window.N_0x32ebd154cb6b8b99 = function (p0, p1, p2) {
	return _in(0x32ebd154, 0xcb6b8b99, p0, p1, p2);
};

window.N_0x32f34ff7f617643b = function (p0, p1) {
	return _in(0x32f34ff7, 0xf617643b, p0, p1);
};

window.N_0x33506883545ac0df = function (vehicle, p1) {
	return _in(0x33506883, 0x545ac0df, vehicle, p1);
};

/**
 * calculates two distances
 */
window.N_0x336511a34f2e5185 = function (left, right) {
	return _in(0x336511a3, 0x4f2e5185, _fv(left), _fv(right), _r, _rf);
};

window.N_0x336b3d200ab007cb = function (p0, p1, p2, p3, p4) {
	return _in(0x336b3d20, 0x0ab007cb, p0, _fv(p1), _fv(p2), _fv(p3), _fv(p4), _r, _ri);
};

window.N_0x33981d6804e62f49 = function (p0, p1, p2, p3) {
	return _in(0x33981d68, 0x04e62f49, p0, p1, p2, p3);
};

window.N_0x33d47e85b476abcd = function (p0) {
	return _in(0x33d47e85, 0xb476abcd, _i /* actually bool */, _r);
};

window.N_0x33d72899e24c3365 = function (p0, p1) {
	return _in(0x33d72899, 0xe24c3365, p0, p1, _r, _ri);
};

window.N_0x33de49edf4dde77a = function (p0) {
	return _in(0x33de49ed, 0xf4dde77a, p0, _r, _rv);
};

window.N_0x33e3c6c6f2f0b506 = function (p0, p1, p2, p3) {
	return _in(0x33e3c6c6, 0xf2f0b506, p0, _fv(p1), _fv(p2), _fv(p3));
};

window.N_0x33ee12743ccd6343 = function (p0, p1, p2) {
	return _in(0x33ee1274, 0x3ccd6343, p0, p1, p2, _r, _ri);
};

/**
 * 6,000+ calls from scripts, all with either 0 or 1 for p2, that's a boolean in my book
 * ---
 * ^ The last one is the componentId
 * iVar8 = dlc1::get_hash_name_for_component(iParam0, 8, ped::get_ped_drawable_variation(iParam0, 8), ped::get_ped_texture_variation(iParam0, 8));
 * if (dlc1::_0x341DE7ED1D2A1BFD(iVar8, 240476421, 8))
 */
window.N_0x341de7ed1d2a1bfd = function (componentHash, drawableSlotHash, componentId) {
	return _in(0x341de7ed, 0x1d2a1bfd, _ch(componentHash), _ch(drawableSlotHash), componentId, _r);
};

window.N_0x3441cad2f2231923 = function (vehicle, p1) {
	return _in(0x3441cad2, 0xf2231923, vehicle, p1);
};

window.N_0x346ef3ecaaab149e = function () {
	return _in(0x346ef3ec, 0xaaab149e);
};

window.N_0x34770b9ce0e03b91 = function (p0, p1) {
	return _in(0x34770b9c, 0xe0e03b91, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x350aa5ebc03d3bd2 = function () {
	return _in(0x350aa5eb, 0xc03d3bd2, _r, _ri);
};

window.N_0x352e2b5cf420bf3b = function (p0, p1) {
	return _in(0x352e2b5c, 0xf420bf3b, p0, p1);
};

window.N_0x357b152ef96c30b6 = function () {
	return _in(0x357b152e, 0xf96c30b6, _r, _ri);
};

window.N_0x3599d741c9ac6310 = function (p0, p1, p2, p3) {
	return _in(0x3599d741, 0xc9ac6310, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _r, _rf);
};

window.N_0x359af31a4b52f5ed = function () {
	return _in(0x359af31a, 0x4b52f5ed, _r, _ri);
};

window.N_0x35a1b3e1d1315cfa = function (p0, p1) {
	return _in(0x35a1b3e1, 0xd1315cfa, p0, p1, _r);
};

window.N_0x35bb21de06784373 = function (p0, p1) {
	return _in(0x35bb21de, 0x06784373, p0, p1);
};

window.N_0x35e0654f4bad7971 = function (p0) {
	return _in(0x35e0654f, 0x4bad7971, p0);
};

window.N_0x35edd5b2e3ff01c0 = function () {
	return _in(0x35edd5b2, 0xe3ff01c0);
};

window.N_0x35f0b98a8387274d = function () {
	return _in(0x35f0b98a, 0x8387274d, _r, _ri);
};

window.N_0x35fb78dc42b7bd21 = function () {
	return _in(0x35fb78dc, 0x42b7bd21, _r, _ri);
};

window.N_0x36391f397731595d = function (p0) {
	return _in(0x36391f39, 0x7731595d, p0, _r, _ri);
};

/**
 * Returns a float value related to slipstream.
 */
window.N_0x36492c2f0d134c56 = function (p0) {
	return _in(0x36492c2f, 0x0d134c56, p0, _r, _ri);
};

window.N_0x365e877c61d6988b = function (p0, p1, p2, p3) {
	return _in(0x365e877c, 0x61d6988b, p0, p1, p2, p3);
};

window.N_0x3669f1b198dcaa4f = function () {
	return _in(0x3669f1b1, 0x98dcaa4f);
};

window.N_0x367ef5e2f439b4c6 = function (p0) {
	return _in(0x367ef5e2, 0xf439b4c6, p0);
};

/**
 * GET_TIME_SINCE_???
 */
window.N_0x36b77bb84687c318 = function (ped, p1) {
	return _in(0x36b77bb8, 0x4687c318, ped, p1, _r, _ri);
};

window.N_0x36c1451a88a09630 = function () {
	return _in(0x36c1451a, 0x88a09630, _i, _i);
};

/**
 * when player character is used plays remove scuba gear animation
 */
window.N_0x36c6984c3ed0c911 = function (p0) {
	return _in(0x36c6984c, 0x3ed0c911, p0);
};

window.N_0x36ccb9be67b970fd = function (p0, p1) {
	return _in(0x36ccb9be, 0x67b970fd, p0, p1);
};

window.N_0x36f1b38855f2a8df = function (player) {
	return _in(0x36f1b388, 0x55f2a8df, player);
};

window.N_0x36f32de87082343e = function (p0, p1) {
	return _in(0x36f32de8, 0x7082343e, p0, p1);
};

window.N_0x36f6626459d91457 = function (p0) {
	return _in(0x36f66264, 0x59d91457, _fv(p0));
};

window.N_0x372ef6699146a1e4 = function (p0, entity, p2, p3) {
	return _in(0x372ef669, 0x9146a1e4, p0, entity, _fv(p2), p3, _r);
};

window.N_0x374706271354cb18 = function (vehicle, p1, p2) {
	return _in(0x37470627, 0x1354cb18, vehicle, p1, _fv(p2));
};

window.N_0x375a706a5c2fd084 = function (p0) {
	return _in(0x375a706a, 0x5c2fd084, p0);
};

window.N_0x3795688a307e1eb6 = function (p0) {
	return _in(0x3795688a, 0x307e1eb6, p0, _r, _ri);
};

/**
 * NETWORK_IS_TRANSITION_???
 */
window.N_0x37a4494483b9f5c9 = function () {
	return _in(0x37a44944, 0x83b9f5c9, _r, _ri);
};

/**
 * I've had this return the player's ped handle sometimes, but also other random entities.
 * Whatever p0 is, it's at least not synced to other players.
 * At least not all the time, some p0 values actually output the same entity, (different handle of course, but same entity).
 * But another p0 value may return an entity for player x, but not for player y (it'll just return -1 even if the entity exists on both clients).
 * @param p0 unknown.
 * @return Returns an entity handle or -1, value changes based on p0's value.
 */
window.N_0x37d5f739fd494675 = function (p0) {
	return _in(0x37d5f739, 0xfd494675, p0, _r, _ri);
};

window.N_0x37deb0aa183fb6d8 = function () {
	return _in(0x37deb0aa, 0x183fb6d8);
};

window.N_0x38491439b6ba7f7d = function (p0, p1) {
	return _in(0x38491439, 0xb6ba7f7d, p0, p1, _r, _rf);
};

window.N_0x3855fb5eb2c5e8b2 = function (p0) {
	return _in(0x3855fb5e, 0xb2c5e8b2, p0, _r, _ri);
};

/**
 * Sets profile setting 934
 */
window.N_0x38baaa5dd4c9d19f = function (value) {
	return _in(0x38baaa5d, 0xd4c9d19f, value);
};

/**
 * Returns true if an unk value is greater than 0.0f
 */
window.N_0x38d28da81e4e9bf9 = function (player) {
	return _in(0x38d28da8, 0x1e4e9bf9, player, _r);
};

window.N_0x393bd2275ceb7793 = function () {
	return _in(0x393bd227, 0x5ceb7793, _r, _ri);
};

window.N_0x394cd08e31313c28 = function () {
	return _in(0x394cd08e, 0x31313c28);
};

window.N_0x397baa01068baa96 = function () {
	return _in(0x397baa01, 0x068baa96, _r, _ri);
};

window.N_0x39917e1b4cb0f911 = function (p0) {
	return _in(0x39917e1b, 0x4cb0f911, p0);
};

window.N_0x39a5fb7eaf150840 = function (p0, p1) {
	return _in(0x39a5fb7e, 0xaf150840, p0, p1);
};

/**
 * from extreme3.c4
 * PED::_39D55A620FCB6A3A(PLAYER::PLAYER_PED_ID(), 8, PED::GET_PED_DRAWABLE_VARIATION(PLAYER::PLAYER_PED_ID(), 8), PED::GET_PED_TEXTURE_VARIATION(PLAYER::PLAYER_PED_ID(), 8));
 * p1 is probably componentId
 */
window.N_0x39d55a620fcb6a3a = function (ped, slot, drawableId, textureId) {
	return _in(0x39d55a62, 0x0fcb6a3a, ped, slot, drawableId, textureId, _r, _ri);
};

window.N_0x3a17a27d75c74887 = function () {
	return _in(0x3a17a27d, 0x75c74887, _r, _ri);
};

window.N_0x3a3d5568af297cd5 = function (p0) {
	return _in(0x3a3d5568, 0xaf297cd5, p0, _r);
};

window.N_0x3a48ab4445d499be = function () {
	return _in(0x3a48ab44, 0x45d499be, _r, _ri);
};

window.N_0x3a8b55fda4c8ddef = function (p0, p1, p2) {
	return _in(0x3a8b55fd, 0xa4c8ddef, p0, p1, p2, _r, _ri);
};

window.N_0x3b39236746714134 = function (p0) {
	return _in(0x3b392367, 0x46714134, p0, _r, _ri);
};

window.N_0x3b458ddb57038f08 = function (p0, p1, p2) {
	return _in(0x3b458ddb, 0x57038f08, p0, p1, p2);
};

window.N_0x3bab9a4e4f2ff5c7 = function () {
	return _in(0x3bab9a4e, 0x4f2ff5c7, _r, _ri);
};

window.N_0x3bbbd13e5041a79e = function () {
	return _in(0x3bbbd13e, 0x5041a79e, _r, _ri);
};

window.N_0x3c4487461e9b0dcb = function () {
	return _in(0x3c448746, 0x1e9b0dcb, _r, _ri);
};

window.N_0x3c5c1e2c2ff814b1 = function (p0) {
	return _in(0x3c5c1e2c, 0x2ff814b1, p0);
};

window.N_0x3c67506996001f5e = function () {
	return _in(0x3c675069, 0x96001f5e, _r, _ri);
};

window.N_0x3c891a251567dfce = function (p0) {
	return _in(0x3c891a25, 0x1567dfce, _ii(p0) /* may be optional */, _r, _ri);
};

window.N_0x3d120012440e6683 = function () {
	return _in(0x3d120012, 0x440e6683, _r, _ri);
};

window.N_0x3d3d15af7bcaaf83 = function (p0, p1, p2) {
	return _in(0x3d3d15af, 0x7bcaaf83, p0, p1, p2);
};

window.N_0x3d3d8b3be5a83d35 = function () {
	return _in(0x3d3d8b3b, 0xe5a83d35, _r, _ri);
};

/**
 * Used in carsteal3 script with p0 = "Carsteal4_spycar".
 */
window.N_0x3d42b92563939375 = function (p0) {
	return _in(0x3d42b925, 0x63939375, _ts(p0), _r);
};

window.N_0x3d9acb1eb139e702 = function () {
	return _in(0x3d9acb1e, 0xb139e702, _r, _ri);
};

window.N_0x3dbf2df0aeb7d289 = function (p0) {
	return _in(0x3dbf2df0, 0xaeb7d289, p0, _r);
};

window.N_0x3dda37128dd1aca8 = function (p0) {
	return _in(0x3dda3712, 0x8dd1aca8, p0);
};

window.N_0x3de3aa516fb126a4 = function (p0) {
	return _in(0x3de3aa51, 0x6fb126a4, p0);
};

window.N_0x3de51e9c80b116cf = function (p0) {
	return _in(0x3de51e9c, 0x80b116cf, p0, _r, _ri);
};

/**
 * 1 match in 1 script. cellphone_controller.
 * p0 is -1 in scripts.
 * Dr. Underscore (1/6/18):
 * I have two uses in two scripts; and it's called with -1 in maintransition, not cellphone_controller. Are you using x360 scripts, or an older version of PC scripts?
 * Also returns bool.
 */
window.N_0x3dec726c25a11bac = function (p0) {
	return _in(0x3dec726c, 0x25a11bac, p0, _r);
};

window.N_0x3e38e28a1d80ddf6 = function (ped) {
	return _in(0x3e38e28a, 0x1d80ddf6, ped, _r);
};

window.N_0x3e4adaff1830f146 = function () {
	return _in(0x3e4adaff, 0x1830f146, _r, _ri);
};

window.N_0x3e802f11fbe27674 = function (p0) {
	return _in(0x3e802f11, 0xfbe27674, p0, _r);
};

window.N_0x3e9679c1dfcf422c = function (p0, p1) {
	return _in(0x3e9679c1, 0xdfcf422c, p0, p1);
};

window.N_0x3ebeac6c3f81f6bd = function (p0) {
	return _in(0x3ebeac6c, 0x3f81f6bd, p0);
};

/**
 * p0 was always 2 in R* scripts.
 * Called before calling DISPLAY_ONSCREEN_KEYBOARD if the input needs to be saved.
 */
window.N_0x3ed1438c1f5c6612 = function (p0) {
	return _in(0x3ed1438c, 0x1f5c6612, p0);
};

window.N_0x3ed2b83ab2e82799 = function (p0, p1) {
	return _in(0x3ed2b83a, 0xb2e82799, p0, p1);
};

window.N_0x3f0cf9cb7e589b88 = function () {
	return _in(0x3f0cf9cb, 0x7e589b88, _r, _ri);
};

window.N_0x3f52e880aaf6c8ca = function (p0) {
	return _in(0x3f52e880, 0xaaf6c8ca, p0);
};

window.N_0x3f5cc444dcaaa8f2 = function (p0, p1, p2) {
	return _in(0x3f5cc444, 0xdcaaa8f2, p0, p1, p2);
};

window.N_0x3f7325574e41b44d = function (p0, p1, p2, p3) {
	return _in(0x3f732557, 0x4e41b44d, p0, p1, p2, p3);
};

window.N_0x3f9990bf5f22759c = function (p0) {
	return _in(0x3f9990bf, 0x5f22759c, _ii(p0) /* may be optional */, _r);
};

window.N_0x3fa36981311fa4ff = function (netId, state) {
	return _in(0x3fa36981, 0x311fa4ff, netId, state);
};

window.N_0x4008edf7d6e48175 = function (p0) {
	return _in(0x4008edf7, 0xd6e48175, p0);
};

window.N_0x402f9ed62087e898 = function () {
	return _in(0x402f9ed6, 0x2087e898);
};

window.N_0x405591ec8fd9096d = function (p0) {
	return _in(0x405591ec, 0x8fd9096d, _fv(p0));
};

window.N_0x4056ea1105f5abd7 = function (p0, p1) {
	return _in(0x4056ea11, 0x05f5abd7, p0, p1);
};

/**
 * Usage: INTERIOR::_0x405DC2AEF6AF95B9(INTERIOR::GET_KEY_FOR_ENTITY_IN_ROOM(PLAYER::PLAYER_PED_ID()));
 */
window.N_0x405dc2aef6af95b9 = function (roomHashKey) {
	return _in(0x405dc2ae, 0xf6af95b9, _ch(roomHashKey));
};

/**
 * Console Hash: 0x9F82917F
 */
window.N_0x407091cf6037118e = function (netID) {
	return _in(0x407091cf, 0x6037118e, netID);
};

window.N_0x40763ea7b9b783e7 = function (p0, p1, p2) {
	return _in(0x40763ea7, 0xb9b783e7, p0, p1, p2, _r, _ri);
};

window.N_0x40aefd1a244741f2 = function (p0) {
	return _in(0x40aefd1a, 0x244741f2, p0);
};

window.N_0x40f7e66472df3e5c = function (p0, p1) {
	return _in(0x40f7e664, 0x72df3e5c, p0, p1, _r, _ri);
};

window.N_0x4128464231e3ca0b = function (p0, p1, p2, p3) {
	return _in(0x41284642, 0x31e3ca0b, p0, p1, p2, p3);
};

window.N_0x41290b40fa63e6da = function (p0) {
	return _in(0x41290b40, 0xfa63e6da, p0);
};

window.N_0x412f1364fa066cfb = function (p0) {
	return _in(0x412f1364, 0xfa066cfb, p0, _r, _ri);
};

window.N_0x41350b4fc28e3941 = function (p0) {
	return _in(0x41350b4f, 0xc28e3941, p0);
};

window.N_0x4167efe0527d706e = function () {
	return _in(0x4167efe0, 0x527d706e, _r);
};

window.N_0x418dc16fae452c1c = function (p0) {
	return _in(0x418dc16f, 0xae452c1c, p0, _r);
};

window.N_0x419594e137637120 = function (p0, p1, p2) {
	return _in(0x419594e1, 0x37637120, p0, p1, p2);
};

window.N_0x419615486bbf1956 = function (p0) {
	return _in(0x41961548, 0x6bbf1956, p0);
};

window.N_0x41faa8fb2ece8720 = function (p0) {
	return _in(0x41faa8fb, 0x2ece8720, p0);
};

window.N_0x422d396f80a96547 = function () {
	return _in(0x422d396f, 0x80a96547, _r);
};

window.N_0x422f32cc7e56abad = function (p0) {
	return _in(0x422f32cc, 0x7e56abad, p0, _r);
};

window.N_0x4237e822315d8ba9 = function () {
	return _in(0x4237e822, 0x315d8ba9, _r);
};

window.N_0x425aecf167663f48 = function (ped, p1) {
	return _in(0x425aecf1, 0x67663f48, ped, p1);
};

window.N_0x42613035157e4208 = function (p0) {
	return _in(0x42613035, 0x157e4208, p0);
};

window.N_0x4282e08174868be3 = function () {
	return _in(0x4282e081, 0x74868be3, _r, _ri);
};

window.N_0x428ad3e26c8d9eb0 = function (p0, p1, p2, p3, p4) {
	return _in(0x428ad3e2, 0x6c8d9eb0, p0, p1, p2, p3, p4);
};

/**
 * if (!ENTITY::DOES_ENTITY_BELONG_TO_THIS_SCRIPT(g_10A5A._f8B[a_0 -- [[1]] ], 1)) {
 * sub_20af7("No longer needed: Vehicle owned by other script");
 * if ((((a_0 == 24) && (!sub_3a04(g_10A5A._f8B[a_0 -- [[1]] ]))) && (!sub_39c9(g_10A5A._f8B[a_0 -- [[1]] ]))) && (ENTITY::GET_ENTITY_MODEL(g_10A5A._f8B[a_0 -- [[1]] ]) != ${monster})) {
 * VEHICLE::_428BACCDF5E26EAD(g_10A5A._f8B[a_0 -- [[1]] ], 1);
 * }
 * g_10A5A._f8B[a_0 -- [[1]] ] = 0;
 * g_10A5A[a_0 -- [[1]] ] = 1;
 * sub_20ada(a_0);
 * return ;
 * }
 */
window.N_0x428baccdf5e26ead = function (vehicle, p1) {
	return _in(0x428baccd, 0xf5e26ead, vehicle, p1);
};

/**
 * LOD related
 */
window.N_0x42a4beb35d372407 = function (p0) {
	return _in(0x42a4beb3, 0x5d372407, p0, _r, _ri);
};

window.N_0x42b65deef2edf2a1 = function (p0) {
	return _in(0x42b65dee, 0xf2edf2a1, p0);
};

window.N_0x4348bfda56023a2f = function (p0, p1) {
	return _in(0x4348bfda, 0x56023a2f, p0, p1, _r, _ri);
};

window.N_0x437138b6a830166a = function () {
	return _in(0x437138b6, 0xa830166a);
};

window.N_0x438822c279b73b93 = function (p0) {
	return _in(0x438822c2, 0x79b73b93, p0);
};

window.N_0x43d1680c6d19a8e9 = function () {
	return _in(0x43d1680c, 0x6d19a8e9);
};

window.N_0x43fa0dfc5df87815 = function (vehicle, p1) {
	return _in(0x43fa0dfc, 0x5df87815, vehicle, p1);
};

window.N_0x4419966c9936071a = function (p0) {
	return _in(0x4419966c, 0x9936071a, p0);
};

/**
 * sfink: related to: NETWORK_BAIL
 * NETWORK_BAIL_TRANSITION
 * NETWORK_JOIN_GROUP_ACTIVITY
 * NETWORK_JOIN_TRANSITION
 * NETWORK_LAUNCH_TRANSITION
 * NETWORK_SESSION_HOST
 * NETWORK_SESSION_HOST_CLOSED
 * NETWORK_SESSION_HOST_FRIENDS_ONLY
 * NETWORK_SESSION_HOST_SINGLE_PLAYER
 * NETWORK_SESSION_VOICE_LEAVE
 */
window.N_0x444c4525ece0a4b9 = function () {
	return _in(0x444c4525, 0xece0a4b9);
};

window.N_0x44621483ff966526 = function (p0, p1) {
	return _in(0x44621483, 0xff966526, p0, p1);
};

window.N_0x44919cc079bb60bf = function (p0) {
	return _in(0x44919cc0, 0x79bb60bf, p0);
};

window.N_0x44a0bdc559b35f6e = function () {
	return _in(0x44a0bdc5, 0x59b35f6e, _r, _ri);
};

window.N_0x44aca259d67651db = function (p1) {
	return _in(0x44aca259, 0xd67651db, _i, p1);
};

window.N_0x44b37cdcae765aae = function (p0, p1) {
	return _in(0x44b37cdc, 0xae765aae, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x44cd1f493db2a0a6 = function (p0, p1, p2) {
	return _in(0x44cd1f49, 0x3db2a0a6, p0, p1, p2);
};

window.N_0x44f1012b69313374 = function (p0, p1, p2, p3) {
	return _in(0x44f1012b, 0x69313374, p0, p1, p2, p3);
};

/**
 * yoga.ysc
 * if (PED::IS_PED_WEARING_HELMET(iParam0) && PED::_0x451294E859ECC018(iParam0) != -1)
 * {
 * *uParam2 = PED::_0x451294E859ECC018(iParam0);
 * *uParam3 = PED::_0x9D728C1E12BF5518(iParam0);
 * }
 */
window.N_0x451294e859ecc018 = function (p0) {
	return _in(0x451294e8, 0x59ecc018, p0, _r);
};

window.N_0x451d05012ccec234 = function (p0) {
	return _in(0x451d0501, 0x2ccec234, p0, _r, _ri);
};

window.N_0x459fd2c8d0ab78bc = function () {
	return _in(0x459fd2c8, 0xd0ab78bc, _r, _ri);
};

window.N_0x45a561a9421ab6ad = function (p0, p1) {
	return _in(0x45a561a9, 0x421ab6ad, p0, p1, _r, _ri);
};

window.N_0x45a83257ed02d9bc = function () {
	return _in(0x45a83257, 0xed02d9bc);
};

window.N_0x45e816772e93a9db = function () {
	return _in(0x45e81677, 0x2e93a9db, _r, _ri);
};

window.N_0x46326e13da4e0546 = function (p0) {
	return _in(0x46326e13, 0xda4e0546, _ii(p0) /* may be optional */);
};

/**
 * NOTE: 'p2' might be some kind of array.
 */
window.N_0x4645de9980999e93 = function (p0, p1, p2, p3, type) {
	return _in(0x4645de99, 0x80999e93, _ts(p0), _ts(p1), _ts(p2), _ts(p3), _ts(type), _r);
};

window.N_0x46494a2475701343 = function (p0, p1, p2, p3, modelHash, p5) {
	return _in(0x46494a24, 0x75701343, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _ch(modelHash), p5, _r);
};

window.N_0x4668d80430d6c299 = function (ped) {
	return _in(0x4668d804, 0x30d6c299, ped);
};

/**
 * This has been found in use in the decompiled files.
 */
window.N_0x4669b3ed80f24b4e = function (player) {
	return _in(0x4669b3ed, 0x80f24b4e, player, _r, _ri);
};

window.N_0x466da42c89865553 = function (p0) {
	return _in(0x466da42c, 0x89865553, _fv(p0));
};

window.N_0x4683149ed1dde7a1 = function (p0) {
	return _in(0x4683149e, 0xd1dde7a1, _ts(p0), _r);
};

window.N_0x469f2ecdec046337 = function (p0) {
	return _in(0x469f2ecd, 0xec046337, p0);
};

/**
 * Checks if the specified unknown flag is set in the ped's model.
 * The engine itself seems to exclusively check for flags 1 and 4 (Might be inlined code of the check that checks for other flags).
 * Game scripts exclusively check for flags 1 and 4.
 */
window.N_0x46b05bcae43856b0 = function (ped, flag) {
	return _in(0x46b05bca, 0xe43856b0, ped, flag, _r);
};

window.N_0x46d1a61a21f566fc = function (p0) {
	return _in(0x46d1a61a, 0x21f566fc, _fv(p0));
};

window.N_0x46f3add1e2d5baf2 = function (p0, p1) {
	return _in(0x46f3add1, 0xe2d5baf2, p0, p1);
};

window.N_0x46f8696933a63c9b = function (p0, p1) {
	return _in(0x46f86969, 0x33a63c9b, p0, p1, _r, _rv);
};

window.N_0x472397322e92a856 = function () {
	return _in(0x47239732, 0x2e92a856);
};

window.N_0x472841a026d26d8b = function () {
	return _in(0x472841a0, 0x26d26d8b, _r, _ri);
};

window.N_0x4737980e8a283806 = function (p0, p1) {
	return _in(0x4737980e, 0x8a283806, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x4750fc27570311ec = function () {
	return _in(0x4750fc27, 0x570311ec, _r, _ri);
};

window.N_0x4757f00bc6323cfe = function (p0, p1) {
	return _in(0x4757f00b, 0xc6323cfe, p0, p1);
};

window.N_0x4759cc730f947c81 = function () {
	return _in(0x4759cc73, 0x0f947c81);
};

window.N_0x47b32f5611e6e483 = function (p0) {
	return _in(0x47b32f56, 0x11e6e483, p0);
};

window.N_0x47b595d60664cffa = function (p0, p1) {
	return _in(0x47b595d6, 0x0664cffa, p0, p1);
};

window.N_0x4811bbac21c5fcd5 = function (p0) {
	return _in(0x4811bbac, 0x21c5fcd5, p0);
};

window.N_0x483aca1176ca93f1 = function () {
	return _in(0x483aca11, 0x76ca93f1);
};

window.N_0x48608c3464f58ab4 = function (p0, p1, p2) {
	return _in(0x48608c34, 0x64f58ab4, p0, p1, p2);
};

window.N_0x48621c9fca3ebd28 = function (p0) {
	return _in(0x48621c9f, 0xca3ebd28, p0);
};

/**
 * Dr. Underscore (1/6/18):
 * Possibly some unknown structures.
 */
window.N_0x4862437a486f91b0 = function (p0, p3) {
	return _in(0x4862437a, 0x486f91b0, _ts(p0), _i, _i, p3, _r);
};

window.N_0x487912fd248efddf = function (p0, p1) {
	return _in(0x487912fd, 0x248efddf, p0, _fv(p1), _r);
};

window.N_0x4879e4fe39074cdf = function () {
	return _in(0x4879e4fe, 0x39074cdf, _r, _ri);
};

window.N_0x488043841bbe156f = function () {
	return _in(0x48804384, 0x1bbe156f);
};

window.N_0x48adc8a773564670 = function () {
	return _in(0x48adc8a7, 0x73564670);
};

window.N_0x48c633e94a8142a7 = function (p0) {
	return _in(0x48c633e9, 0x4a8142a7, p0, _r, _ri);
};

/**
 * Only found 3 times in decompiled scripts. Not a whole lot to go off of.
 * GAMEPLAY::_48F069265A0E4BEC(a_0, "Movie_Name_For_This_Player");
 * GAMEPLAY::_48F069265A0E4BEC(&a_0._fB, "Ringtone_For_This_Player");
 * GAMEPLAY::_48F069265A0E4BEC(&a_0._f1EC4._f12[v_A -- [[6]] ], &v_13); // where v_13 is "MPATMLOGSCRS0" thru "MPATMLOGSCRS15"
 */
window.N_0x48f069265a0e4bec = function (name) {
	return _in(0x48f06926, 0x5a0e4bec, _i, _ts(name));
};

window.N_0x490861b88f4fd846 = function (p0) {
	return _in(0x490861b8, 0x8f4fd846, p0);
};

window.N_0x49482f9fcd825aaa = function (entity) {
	return _in(0x49482f9f, 0xcd825aaa, entity);
};

window.N_0x497420e022796b3f = function () {
	return _in(0x497420e0, 0x22796b3f, _r, _ri);
};

window.N_0x49e50bdb8ba4dab2 = function (ped, p1) {
	return _in(0x49e50bdb, 0x8ba4dab2, ped, p1);
};

window.N_0x4a0c7c9bb10abb36 = function (p0) {
	return _in(0x4a0c7c9b, 0xb10abb36, p0);
};

window.N_0x4a2d4e8bf4265b0f = function (p0) {
	return _in(0x4a2d4e8b, 0xf4265b0f, p0, _r);
};

window.N_0x4a39db43e47cf3aa = function (p0) {
	return _in(0x4a39db43, 0xe47cf3aa, p0);
};

window.N_0x4a7d6e727f941747 = function (p0) {
	return _in(0x4a7d6e72, 0x7f941747, _ii(p0) /* may be optional */, _r, _ri);
};

/**
 * example:
 * if (!((v_7)==UI::_4A9923385BDB9DAD())) {
 * UI::SET_BLIP_SPRITE((v_6), (v_7));
 * }
 * This function is hard-coded to always return 1.
 */
window.N_0x4a9923385bdb9dad = function () {
	return _in(0x4a992338, 0x5bdb9dad, _r);
};

window.N_0x4ad490ae1536933b = function (p0, p1) {
	return _in(0x4ad490ae, 0x1536933b, p0, p1, _r, _ri);
};

window.N_0x4af92acd3141d96c = function () {
	return _in(0x4af92acd, 0x3141d96c);
};

window.N_0x4b5b620c9b59ed34 = function (p0, p1) {
	return _in(0x4b5b620c, 0x9b59ed34, p0, p1);
};

window.N_0x4b5cfc83122df602 = function () {
	return _in(0x4b5cfc83, 0x122df602);
};

window.N_0x4ba166079d658ed4 = function (p0, p1) {
	return _in(0x4ba16607, 0x9d658ed4, p0, p1);
};

/**
 * Seems to call GET_PAUSED_MAP_STREAMING_REQUEST lol wtf
 * seg001:000000000158C324 sub_158C324:                            # DATA XREF: OPD:stru_1C29978o
 * seg001:000000000158C324
 * seg001:000000000158C324 .set arg_10,  0x10
 * seg001:000000000158C324
 * seg001:000000000158C324                 mflr      r0
 * seg001:000000000158C328                 bl        sub_1803774
 * seg001:000000000158C32C                 stdu      r1, -0x80(r1)
 * seg001:000000000158C330                 std       r0, 0x80+arg_10(r1)
 * seg001:000000000158C334                 mr        r31, r3
 * seg001:000000000158C338                 lwz       r3, 8(r31)
 * seg001:000000000158C33C                 addic     r4, r3, 4
 * seg001:000000000158C340                 addic     r5, r3, 0x10
 * seg001:000000000158C344                 addic     r7, r3, 0x20
 * seg001:000000000158C348                 lwz       r6, 0(r3)
 * seg001:000000000158C34C                 lfs       f1, 0x1C(r3)
 * seg001:000000000158C350                 lwz       r8, 0x2C(r3)
 * seg001:000000000158C354                 extsw     r3, r6
 * seg001:000000000158C358                 extsw     r8, r8
 * seg001:000000000158C35C                 bl        GET_PAUSED_MAP_STREAMING_REQUEST
 * seg001:000000000158C360                 lwz       r4, 0(r31)
 * seg001:000000000158C364                 stw       r3, 0(r4)
 * seg001:000000000158C368                 addi      r1, r1, 0x80
 * seg001:000000000158C36C                 b         loc_18037D8
 * sorta makes sense though since the one above this native and GET_PAUSED_MAP_STREAMING_REQUEST are used together often in scripts
 */
window.N_0x4ba92a18502bca61 = function (player, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, flags) {
	return _in(0x4ba92a18, 0x502bca61, player, _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), _fv(p9), _fv(p10), flags, _r);
};

window.N_0x4bc2854478f3a749 = function (doorHash) {
	return _in(0x4bc28544, 0x78f3a749, _ch(doorHash), _r, _ri);
};

/**
 * Only used once in the entire game scripts, probably useless. Always returns 0.
 */
window.N_0x4c2330e61d3deb56 = function (interiorID) {
	return _in(0x4c2330e6, 0x1d3deb56, interiorID, _r, _ri);
};

window.N_0x4c2a9fdc22377075 = function () {
	return _in(0x4c2a9fdc, 0x22377075);
};

window.N_0x4c61b39930d045da = function (p0) {
	return _in(0x4c61b399, 0x30d045da, p0, _r);
};

window.N_0x4c61c75bee8184c2 = function (p0, p1, p2) {
	return _in(0x4c61c75b, 0xee8184c2, _ts(p0), p1, p2);
};

window.N_0x4c815eb175086f84 = function (p0, p1) {
	return _in(0x4c815eb1, 0x75086f84, p0, p1, _r, _ri);
};

window.N_0x4c89fe2bdeb3f169 = function () {
	return _in(0x4c89fe2b, 0xdeb3f169, _r, _ri);
};

/**
 * This function is hard-coded to always return 1.
 */
window.N_0x4cebc1ed31e8925e = function (cutsceneName) {
	return _in(0x4cebc1ed, 0x31e8925e, _ts(cutsceneName), _r);
};

window.N_0x4d02279c83be69fe = function () {
	return _in(0x4d02279c, 0x83be69fe, _r, _ri);
};

window.N_0x4d1cb8dc40208a17 = function (p0, p1) {
	return _in(0x4d1cb8dc, 0x40208a17, p0, p1, _r, _ri);
};

window.N_0x4d89d607cb3dd1d2 = function (object, toggle) {
	return _in(0x4d89d607, 0xcb3dd1d2, object, toggle);
};

/**
 * Something like flush_all_scripts
 * Most of time comes after NETWORK_END_TUTORIAL_SESSION() or before TERMINATE_THIS_THREAD()
 */
window.N_0x4d953df78ebf8158 = function () {
	return _in(0x4d953df7, 0x8ebf8158);
};

window.N_0x4d9d109f63fee1d4 = function (p0, p1) {
	return _in(0x4d9d109f, 0x63fee1d4, p0, p1);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x4dcdf92bf64236cd = function (p0, p1) {
	return _in(0x4dcdf92b, 0xf64236cd, _ts(p0), _ts(p1));
};

window.N_0x4df7cfff471a7fb1 = function (p0) {
	return _in(0x4df7cfff, 0x471a7fb1, p0, _r);
};

window.N_0x4dfdd9eb705f8140 = function (p0) {
	return _in(0x4dfdd9eb, 0x705f8140, _i /* actually bool */, _r);
};

window.N_0x4e20d2a627011e8e = function (p0, p1) {
	return _in(0x4e20d2a6, 0x27011e8e, p0, p1, _r, _ri);
};

window.N_0x4e3cd0ef8a489541 = function () {
	return _in(0x4e3cd0ef, 0x8a489541, _r, _ri);
};

/**
 * Examples:
 * AUDIO::_4E404A9361F75BB2("RADIO_01_CLASS_ROCK", "END_CREDITS_KILL_MICHAEL", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_01_CLASS_ROCK", "END_CREDITS_KILL_MICHAEL", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_01_CLASS_ROCK", "END_CREDITS_KILL_TREVOR", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_01_CLASS_ROCK", "END_CREDITS_SAVE_MICHAEL_TREVOR", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_01_CLASS_ROCK", "OFF_ROAD_RADIO_ROCK_LIST", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_06_COUNTRY", "MAGDEMO2_RADIO_DINGHY", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_16_SILVERLAKE", "SEA_RACE_RADIO_PLAYLIST", 1);
 * AUDIO::_4E404A9361F75BB2("RADIO_01_CLASS_ROCK", "OFF_ROAD_RADIO_ROCK_LIST", 1);
 */
window.N_0x4e404a9361f75bb2 = function (radioStation, p1, p2) {
	return _in(0x4e404a93, 0x61f75bb2, _ts(radioStation), _ts(p1), p2);
};

window.N_0x4e417c547182c84d = function (p0) {
	return _in(0x4e417c54, 0x7182c84d, p0, _r, _ri);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x4e52e752c76e7e7a = function (p0) {
	return _in(0x4e52e752, 0xc76e7e7a, p0);
};

window.N_0x4e548c0d7ae39ff9 = function (p0, p1) {
	return _in(0x4e548c0d, 0x7ae39ff9, p0, p1, _r, _ri);
};

window.N_0x4e74e62e0a97e901 = function (vehicle, p1) {
	return _in(0x4e74e62e, 0x0a97e901, vehicle, p1);
};

/**
 * The "disabled" variant of _0x5B84D09CEC5209C5.
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.N_0x4f8a26a890fd62fb = function (inputGroup, control) {
	return _in(0x4f8a26a8, 0x90fd62fb, inputGroup, control, _r, _rf);
};

window.N_0x4fef53183c3c6414 = function () {
	return _in(0x4fef5318, 0x3c3c6414, _r, _ri);
};

/**
 * console hash: 0x004926A3
 */
window.N_0x500873a45724c863 = function (vehicle, p1) {
	return _in(0x500873a4, 0x5724c863, vehicle, p1);
};

window.N_0x5009dfd741329729 = function (p0, p1) {
	return _in(0x5009dfd7, 0x41329729, _ts(p0), p1);
};

window.N_0x501478855a6074ce = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x50147885, 0x5a6074ce, p0, p1, p2, p3, p4, p5);
};

window.N_0x503f5920162365b2 = function (p0, p1, p2, p3) {
	return _in(0x503f5920, 0x162365b2, p0, _fv(p1), _fv(p2), _fv(p3));
};

window.N_0x50634e348c8d44ef = function (p0) {
	return _in(0x50634e34, 0x8c8d44ef, p0, _r, _ri);
};

window.N_0x5068f488ddb54dd8 = function () {
	return _in(0x5068f488, 0xddb54dd8, _r, _ri);
};

window.N_0x50c375537449f369 = function (p0) {
	return _in(0x50c37553, 0x7449f369, p0);
};

window.N_0x50f457823ce6eb5f = function (p0, p1, p2, p3) {
	return _in(0x50f45782, 0x3ce6eb5f, p0, p1, p2, p3, _r, _ri);
};

window.N_0x511f1a683387c7e2 = function (p0) {
	return _in(0x511f1a68, 0x3387c7e2, p0, _r, _ri);
};

window.N_0x516fc96eb88eefe5 = function (p0) {
	return _in(0x516fc96e, 0xb88eefe5, p0);
};

window.N_0x5182a339a3474510 = function (p0, p1, p2) {
	return _in(0x5182a339, 0xa3474510, p0, p1, p2);
};

window.N_0x51bb2d88d31a914b = function (vehicle, p1) {
	return _in(0x51bb2d88, 0xd31a914b, vehicle, p1);
};

window.N_0x51db102f4a3ba5e0 = function (p0) {
	return _in(0x51db102f, 0x4a3ba5e0, p0);
};

window.N_0x51f1a8e48c3d2f6d = function (p0, p1, p2) {
	return _in(0x51f1a8e4, 0x8c3d2f6d, p0, p1, p2, _r);
};

window.N_0x524ff0aeff9c3973 = function (p0) {
	return _in(0x524ff0ae, 0xff9c3973, p0);
};

window.N_0x52818819057f2b40 = function (p0) {
	return _in(0x52818819, 0x057f2b40, p0, _r);
};

window.N_0x52d59ab61ddc05dd = function (ped, p1) {
	return _in(0x52d59ab6, 0x1ddc05dd, ped, p1);
};

window.N_0x5324a0e3e4ce3570 = function (p0, p1) {
	return _in(0x5324a0e3, 0xe4ce3570, p0, p1, _i, _i, _r);
};

window.N_0x5335be58c083e74e = function (p0) {
	return _in(0x5335be58, 0xc083e74e, p0);
};

window.N_0x53afd64c6758f2f9 = function () {
	return _in(0x53afd64c, 0x6758f2f9, _r, _ri);
};

window.N_0x53c10c8bd774f2c9 = function () {
	return _in(0x53c10c8b, 0xd774f2c9, _r, _ri);
};

window.N_0x53cae13e9b426993 = function (p0) {
	return _in(0x53cae13e, 0x9b426993, p0);
};

window.N_0x53f4892d18ec90a4 = function (p0) {
	return _in(0x53f4892d, 0x18ec90a4, _fv(p0));
};

window.N_0x5407b7288d0478b7 = function (p0) {
	return _in(0x5407b728, 0x8d0478b7, p0, _r, _ri);
};

window.N_0x54318c915d27e4ce = function (p0, p1) {
	return _in(0x54318c91, 0x5d27e4ce, p0, p1);
};

window.N_0x544810ed9db6bbe6 = function () {
	return _in(0x544810ed, 0x9db6bbe6, _r, _ri);
};

window.N_0x544996c0081abdeb = function (p0, p1) {
	return _in(0x544996c0, 0x081abdeb, p0, p1);
};

window.N_0x547237aa71ab44de = function (p0) {
	return _in(0x547237aa, 0x71ab44de, p0);
};

window.N_0x54b0f614960f4a5f = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x54b0f614, 0x960f4a5f, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _r, _ri);
};

window.N_0x54e22ea2c1956a8d = function (p0) {
	return _in(0x54e22ea2, 0xc1956a8d, _fv(p0));
};

/**
 * From the scripts:
 * GAMEPLAY::_54F157E0336A3822(sub_aa49(a_0), "ForcedStopDirection", v_E);
 */
window.N_0x54f157e0336a3822 = function (p0, p1, p2) {
	return _in(0x54f157e0, 0x336a3822, p0, _ts(p1), _fv(p2));
};

/**
 * DISABLE_*
 * p0 seems to be Player or int
 * Dr. Underscore (1/6/18):
 * p0 is Player.
 * Called after/near _DISABLE_FIRST_PERSON_CAMERA_THIS_FRAME quite often, but not always.
 * Also called near DISABLE_CONTROL_ACTION.
 */
window.N_0x5501b7a5cdb79d37 = function (p0) {
	return _in(0x5501b7a5, 0xcdb79d37, p0);
};

window.N_0x551df99658db6ee8 = function (p0, p1, p2) {
	return _in(0x551df996, 0x58db6ee8, _fv(p0), _fv(p1), _fv(p2), _r, _ri);
};

/**
 * Sets profile setting 935
 */
window.N_0x55384438fc55ad8e = function (value) {
	return _in(0x55384438, 0xfc55ad8e, value);
};

window.N_0x5539c3ebf104a53a = function (p0) {
	return _in(0x5539c3eb, 0xf104a53a, p0);
};

window.N_0x55a1e095db052fa5 = function (p0, p1) {
	return _in(0x55a1e095, 0xdb052fa5, p0, p1);
};

window.N_0x55a8becaf28a4eb7 = function () {
	return _in(0x55a8beca, 0xf28a4eb7, _r, _ri);
};

/**
 * Order of player1 and player2 are not interchangable, it was called for both orders.
 */
window.N_0x55fcc0c390620314 = function (player1, player2, toggle) {
	return _in(0x55fcc0c3, 0x90620314, player1, player2, toggle);
};

/**
 * GET_PLAYER_*
 * Seems to do something with network (?)
 * PLAYER::_56105E599CAB0EFA(NETWORK::NETWORK_GET_PLAYER_INDEX_FROM_PED(ped))
 */
window.N_0x56105e599cab0efa = function (p0) {
	return _in(0x56105e59, 0x9cab0efa, _ii(p0) /* may be optional */, _r, _ri);
};

window.N_0x5615e0c5eb2bc6e2 = function (p0, p1) {
	return _in(0x5615e0c5, 0xeb2bc6e2, p0, p1);
};

window.N_0x5626d9d6810730d5 = function () {
	return _in(0x5626d9d6, 0x810730d5, _r, _ri);
};

window.N_0x563b65a643ed072e = function (p0, p1, p2) {
	return _in(0x563b65a6, 0x43ed072e, p0, p1, p2, _r, _ri);
};

window.N_0x567384dfa67029e6 = function () {
	return _in(0x567384df, 0xa67029e6, _r, _ri);
};

window.N_0x5688585e6d563cd8 = function (p0) {
	return _in(0x5688585e, 0x6d563cd8, p0);
};

window.N_0x56b94c6d7127dfba = function (p0, p1, p2) {
	return _in(0x56b94c6d, 0x7127dfba, p0, _fv(p1), p2);
};

window.N_0x56c8b608cfd49854 = function () {
	return _in(0x56c8b608, 0xcfd49854);
};

/**
 * console hash = 0x30F43FE3
 */
window.N_0x56eb5e94318d3fb6 = function (vehicle, p1) {
	return _in(0x56eb5e94, 0x318d3fb6, vehicle, p1);
};

/**
 * Jenkins hash: 0x772DA539
 * p0 looks like Player or int (found in "am_pi_menu")
 * Dr. Underscore (1/6/18):
 * It isn't Player, it is an int.
 * Only two references anywhere, both in am_pi_menu.
 * One uses globals, the other one uses a helper function that is passing in the outValue of "STATS::STAT_GET_INT"; I have no clue what is being passed in for the stat hash.
 */
window.N_0x5702b917b99db1cd = function (p0) {
	return _in(0x5702b917, 0xb99db1cd, p0);
};

window.N_0x570389d1c3de3c6b = function (p0) {
	return _in(0x570389d1, 0xc3de3c6b, p0);
};

/**
 * consoel hash 0xAEB29F98
 */
window.N_0x571feb383f629926 = function (cargobob, p1) {
	return _in(0x571feb38, 0x3f629926, cargobob, p1);
};

window.N_0x576594e8d64375e2 = function (p0, p1) {
	return _in(0x576594e8, 0xd64375e2, p0, p1);
};

window.N_0x577599cced639ca2 = function (p0) {
	return _in(0x577599cc, 0xed639ca2, p0);
};

window.N_0x57d760d55f54e071 = function (p0) {
	return _in(0x57d760d5, 0x5f54e071, p0);
};

window.N_0x583049884a2eee3c = function () {
	return _in(0x58304988, 0x4a2eee3c);
};

window.N_0x583df8e3d4afbd98 = function () {
	return _in(0x583df8e3, 0xd4afbd98, _r, _ri);
};

window.N_0x5845066d8a1ea7f7 = function (vehicle, x, y, z, p4) {
	return _in(0x5845066d, 0x8a1ea7f7, vehicle, _fv(x), _fv(y), _fv(z), p4);
};

window.N_0x584770794d758c18 = function (p0, p1) {
	return _in(0x58477079, 0x4d758c18, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x585847c5e4e11709 = function (p0, p1, p2) {
	return _in(0x585847c5, 0xe4e11709, p0, p1, p2, _r, _ri);
};

window.N_0x5873c14a52d74236 = function (p0) {
	return _in(0x5873c14a, 0x52d74236, p0, _r, _ri);
};

window.N_0x589f80b325cc82c5 = function (p0, p1, p2, p3, p4) {
	return _in(0x589f80b3, 0x25cc82c5, _fv(p0), _fv(p1), _fv(p2), p3, _ii(p4) /* may be optional */, _r);
};

window.N_0x58a39be597ce99cd = function () {
	return _in(0x58a39be5, 0x97ce99cd);
};

/**
 * LEADERBOARDS_GET_CACHE_???
 */
window.N_0x58a651cd201d89ad = function (p0) {
	return _in(0x58a651cd, 0x201d89ad, p0, _r, _ri);
};

window.N_0x58bb377bec7cd5f4 = function (p0, p1) {
	return _in(0x58bb377b, 0xec7cd5f4, p0, p1);
};

/**
 * Has a 3rd param (int) since patch [???].
 */
window.N_0x58c21165f6545892 = function (p0, p1) {
	return _in(0x58c21165, 0xf6545892, _ts(p0), _ts(p1));
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x58cc181719256197 = function (p0, p1, p2) {
	return _in(0x58cc1817, 0x19256197, p0, p1, p2, _r, _ri);
};

window.N_0x59328eb08c5ceb2b = function () {
	return _in(0x59328eb0, 0x8c5ceb2b, _r, _ri);
};

window.N_0x593570c289a77688 = function () {
	return _in(0x593570c2, 0x89a77688, _r, _ri);
};

window.N_0x593feae1f73392d4 = function () {
	return _in(0x593feae1, 0xf73392d4, _r, _ri);
};

window.N_0x59424bd75174c9b1 = function () {
	return _in(0x59424bd7, 0x5174c9b1);
};

window.N_0x595f028698072dd9 = function (p0, p1, p2) {
	return _in(0x595f0286, 0x98072dd9, p0, p1, p2, _r);
};

window.N_0x597f8dba9b206fc7 = function () {
	return _in(0x597f8dba, 0x9b206fc7, _r, _ri);
};

/**
 * Same behavior as GET_LOCAL_PLAYER_AIM_STATE but only used on the PC version.
 */
window.N_0x59b9a7af4c95133c = function () {
	return _in(0x59b9a7af, 0x4c95133c, _r, _ri);
};

window.N_0x59d421683d31835a = function (p0) {
	return _in(0x59d42168, 0x3d31835a, p0);
};

/**
 * may be 0x6CDAA7D2
 * sfink: related to: NETWORK_BAIL
 * NETWORK_BAIL_TRANSITION
 * NETWORK_JOIN_GROUP_ACTIVITY
 * NETWORK_JOIN_TRANSITION
 * NETWORK_LAUNCH_TRANSITION
 * NETWORK_SESSION_HOST
 * NETWORK_SESSION_HOST_CLOSED
 * NETWORK_SESSION_HOST_FRIENDS_ONLY
 * NETWORK_SESSION_HOST_SINGLE_PLAYER
 * NETWORK_SESSION_VOICE_LEAVE
 */
window.N_0x59df79317f85a7e0 = function () {
	return _in(0x59df7931, 0x7f85a7e0, _r, _ri);
};

window.N_0x59e7b488451f4d3a = function (p0, p1) {
	return _in(0x59e7b488, 0x451f4d3a, p0, _fv(p1));
};

window.N_0x5a0a3d1a186a5508 = function () {
	return _in(0x5a0a3d1a, 0x186a5508, _r, _ri);
};

window.N_0x5a34cd9c3c5bec44 = function (p0) {
	return _in(0x5a34cd9c, 0x3c5bec44, p0, _r);
};

window.N_0x5a43c76f7fc7ba5f = function () {
	return _in(0x5a43c76f, 0x7fc7ba5f);
};

window.N_0x5a556b229a169402 = function () {
	return _in(0x5a556b22, 0x9a169402, _r);
};

/**
 * NETWORK_IS_TRANSITION_???
 */
window.N_0x5a6aa44ff8e931e6 = function () {
	return _in(0x5a6aa44f, 0xf8e931e6, _r);
};

/**
 * One of the first things it does is get the players ped.
 * Then it calls a function that is used in some tasks and ped based functions.
 */
window.N_0x5a6ffa2433e2f14c = function (player, p1, p2, p3, p4, p5, p6, p7, flags) {
	return _in(0x5a6ffa24, 0x33e2f14c, player, _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), flags, _r);
};

window.N_0x5a7f62fda59759bd = function () {
	return _in(0x5a7f62fd, 0xa59759bd);
};

window.N_0x5aa3befa29f03ad4 = function () {
	return _in(0x5aa3befa, 0x29f03ad4, _r, _ri);
};

window.N_0x5aab586ffec0fd96 = function (p0) {
	return _in(0x5aab586f, 0xfec0fd96, p0);
};

/**
 * Disables some other rendering (internal)
 */
window.N_0x5ad3932daeb1e5d3 = function () {
	return _in(0x5ad3932d, 0xaeb1e5d3);
};

window.N_0x5ae17c6b0134b7f1 = function () {
	return _in(0x5ae17c6b, 0x0134b7f1, _r, _ri);
};

/**
 * Dr. Underscore (1/6/18):
 * Seems to return a value 0-2.
 */
window.N_0x5b0316762afd4a64 = function () {
	return _in(0x5b031676, 0x2afd4a64, _r, _ri);
};

window.N_0x5b1f2e327b6b6fe1 = function () {
	return _in(0x5b1f2e32, 0x7b6b6fe1, _r, _ri);
};

window.N_0x5b48a06dd0e792a5 = function () {
	return _in(0x5b48a06d, 0xd0e792a5, _r, _ri);
};

window.N_0x5b50abb1fe3746f4 = function () {
	return _in(0x5b50abb1, 0xfe3746f4, _r, _ri);
};

window.N_0x5b6010b3cbc29095 = function (p0, p1) {
	return _in(0x5b6010b3, 0xcbc29095, p0, p1);
};

window.N_0x5b73c77d9eb66e24 = function (p0) {
	return _in(0x5b73c77d, 0x9eb66e24, p0);
};

/**
 * Seems to return values between -1 and 1 for controls like gas and steering.
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.N_0x5b84d09cec5209c5 = function (inputGroup, control) {
	return _in(0x5b84d09c, 0xec5209c5, inputGroup, control, _r, _rf);
};

window.N_0x5b8ed3db018927b1 = function (p0) {
	return _in(0x5b8ed3db, 0x018927b1, p0);
};

window.N_0x5b91b229243351a8 = function (p0, p1) {
	return _in(0x5b91b229, 0x243351a8, p0, p1);
};

window.N_0x5b9853296731e88d = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x5b985329, 0x6731e88d, p0, p1, p2, p3, p4, p5);
};

window.N_0x5ba68a0840d546ac = function (p0, p1) {
	return _in(0x5ba68a08, 0x40d546ac, p0, p1, _r, _ri);
};

window.N_0x5bcde0f640c773d2 = function (p0, p1, p2, p3) {
	return _in(0x5bcde0f6, 0x40c773d2, p0, p1, p2, p3);
};

window.N_0x5bd5f255321c4aaf = function (p0) {
	return _in(0x5bd5f255, 0x321c4aaf, p0, _r, _ri);
};

window.N_0x5bff36d6ed83e0ae = function () {
	return _in(0x5bff36d6, 0xed83e0ae, _r, _rv);
};

/**
 * Only called once in the scripts.
 * Related to weapon objects.
 */
window.N_0x5c3b791d580e0bc2 = function (entity, p1) {
	return _in(0x5c3b791d, 0x580e0bc2, entity, _fv(p1));
};

window.N_0x5c41e6babc9e2112 = function (p0) {
	return _in(0x5c41e6ba, 0xbc9e2112, p0);
};

window.N_0x5c48a1d6e3b33179 = function (p0) {
	return _in(0x5c48a1d6, 0xe3b33179, p0, _r);
};

window.N_0x5c48b75732c8456c = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x5c48b757, 0x32c8456c, p0, p1, p2, p3, p4, p5);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x5c497525f803486b = function () {
	return _in(0x5c497525, 0xf803486b);
};

window.N_0x5c4ebffa98bdb41c = function (p0) {
	return _in(0x5c4ebffa, 0x98bdb41c, p0, _r, _ri);
};

window.N_0x5c707a667df8b9fa = function (p0, p1) {
	return _in(0x5c707a66, 0x7df8b9fa, p0, p1);
};

window.N_0x5cae833b0ee0c500 = function (p0) {
	return _in(0x5cae833b, 0x0ee0c500, p0, _r);
};

/**
 * This native is used along with these two natives: [`0xa356990e161c9e65`](https://runtime.fivem.net/doc/reference.html#_0xA356990E161C9E65) and [`0x1c4fc5752bcd8e48`](https://runtime.fivem.net/doc/reference.html#_0x1C4FC5752BCD8E48).
 * This native sets the colors for the golf putting grid. the 'min...' values are for the lower areas that the grid covers, the 'max...' values are for the higher areas that the grid covers, all remaining values are for the 'normal' ground height.
 * All those natives combined they will output something like this: <https://i.imgur.com/TC6cku6.png>
 * Old description:
 * Only called in golf and golf_mp
 * parameters used are
 * GRAPHICS::\_0x5CE62918F8D703C7(255, 0, 0, 64, 255, 255, 255, 5, 255, 255, 0, 64);
 * @param lowR red value for the lower level
 * @param lowG green value for the lower level
 * @param lowB blue value for the lower level
 * @param lowAlpha alpha value for the lower level
 * @param R red value for the normal level
 * @param G green value for the normal level
 * @param B blue value for the normal level
 * @param Alpha alpha value for the normal level
 * @param highR red value for the upper level
 * @param highG green value for the upper level
 * @param highB blue value for the upper level
 * @param highAlpha alpha value for the upper level
 */
window.N_0x5ce62918f8d703c7 = function (lowR, lowG, lowB, lowAlpha, R, G, B, Alpha, highR, highG, highB, highAlpha) {
	return _in(0x5ce62918, 0xf8d703c7, lowR, lowG, lowB, lowAlpha, R, G, B, Alpha, highR, highG, highB, highAlpha);
};

window.N_0x5d10b3795f3fc886 = function () {
	return _in(0x5d10b379, 0x5f3fc886, _r);
};

window.N_0x5d2bfaab8d956e0e = function () {
	return _in(0x5d2bfaab, 0x8d956e0e);
};

window.N_0x5d517b27cf6ecd04 = function (p0) {
	return _in(0x5d517b27, 0xcf6ecd04, p0);
};

window.N_0x5d5caff661ddf6fc = function (p0, p1) {
	return _in(0x5d5caff6, 0x61ddf6fc, p0, _ii(p1) /* may be optional */);
};

window.N_0x5d7b620dae436138 = function (p0) {
	return _in(0x5d7b620d, 0xae436138, _fv(p0));
};

window.N_0x5d97630a8a0ef123 = function (p0, p1, p2) {
	return _in(0x5d97630a, 0x8a0ef123, p0, p1, p2);
};

/**
 * longest time being ilde?
 */
window.N_0x5da3a8de8cb6226f = function (time) {
	return _in(0x5da3a8de, 0x8cb6226f, time);
};

window.N_0x5da825a85d0ea6e6 = function (p0, p1, p2) {
	return _in(0x5da825a8, 0x5d0ea6e6, p0, p1, p2);
};

window.N_0x5db8010ee71fdef2 = function (vehicle) {
	return _in(0x5db8010e, 0xe71fdef2, vehicle, _r);
};

window.N_0x5dbf05db5926d089 = function (p0) {
	return _in(0x5dbf05db, 0x5926d089, p0);
};

window.N_0x5dc40a8869c22141 = function (p0, p1) {
	return _in(0x5dc40a88, 0x69c22141, p0, p1);
};

/**
 * NETWORK_IS_TRANSITION_???
 */
window.N_0x5dc577201723960a = function () {
	return _in(0x5dc57720, 0x1723960a, _r);
};

window.N_0x5debd9c4dc995692 = function () {
	return _in(0x5debd9c4, 0xdc995692);
};

window.N_0x5e0165278f6339ee = function (p0) {
	return _in(0x5e016527, 0x8f6339ee, p0, _r, _ri);
};

window.N_0x5e203da2ba15d436 = function (p0) {
	return _in(0x5e203da2, 0xba15d436, p0, _r, _ri);
};

window.N_0x5e24341a7f92a74b = function () {
	return _in(0x5e24341a, 0x7f92a74b, _r, _ri);
};

window.N_0x5e3aa4ca2b6fb0ee = function (p0) {
	return _in(0x5e3aa4ca, 0x2b6fb0ee, p0);
};

window.N_0x5e569ec46ec21cae = function (vehicle, toggle) {
	return _in(0x5e569ec4, 0x6ec21cae, vehicle, toggle);
};

window.N_0x5e657ef1099edd65 = function (p0) {
	return _in(0x5e657ef1, 0x099edd65, p0, _r);
};

window.N_0x5e9daf5a20f15908 = function (p0) {
	return _in(0x5e9daf5a, 0x20f15908, _fv(p0));
};

window.N_0x5ea784d197556507 = function () {
	return _in(0x5ea784d1, 0x97556507, _r, _ri);
};

/**
 * example from completionpercentage_controller.ysc.c4
 * if (STATS::_5EAD2BF6484852E4()) {
 * GAMEPLAY::SET_BIT(g_17b95._f20df._ff10, 15);
 * STATS::_11FF1C80276097ED(0xe9ec4dd1, 200, 0);
 * }
 */
window.N_0x5ead2bf6484852e4 = function () {
	return _in(0x5ead2bf6, 0x484852e4, _r);
};

window.N_0x5ecd378ee64450ab = function (p0) {
	return _in(0x5ecd378e, 0xe64450ab, p0);
};

window.N_0x5edef0cf8c1dab3c = function () {
	return _in(0x5edef0cf, 0x8c1dab3c, _r);
};

window.N_0x5ee5632f47ae9695 = function (p0, p1) {
	return _in(0x5ee5632f, 0x47ae9695, p0, p1);
};

window.N_0x5f0f3f56635809ef = function (p0) {
	return _in(0x5f0f3f56, 0x635809ef, _fv(p0));
};

/**
 * SET_PLAYERS_*
 */
window.N_0x5f2013f8bc24ee69 = function (p0) {
	return _in(0x5f2013f8, 0xbc24ee69, p0);
};

window.N_0x5f35f6732c3fbba0 = function (p0) {
	return _in(0x5f35f673, 0x2c3fbba0, p0, _r, _rf);
};

window.N_0x5f456788b05faeac = function (p0, p1, p2) {
	return _in(0x5f456788, 0xb05faeac, p0, p1, p2);
};

window.N_0x5fbd7095fe7ae57f = function (p0, p1) {
	return _in(0x5fbd7095, 0xfe7ae57f, p0, _fi(p1) /* may be optional */, _r);
};

/**
 * Appears once in "re_dealgonewrong"
 */
window.N_0x5fc472c501ccadb3 = function (player) {
	return _in(0x5fc472c5, 0x01ccadb3, player, _r);
};

window.N_0x5ff2c33b13a02a11 = function (p0) {
	return _in(0x5ff2c33b, 0x13a02a11, p0);
};

window.N_0x600048c60d5c2c51 = function (p0) {
	return _in(0x600048c6, 0x0d5c2c51, p0);
};

window.N_0x600f8cb31c7aab6e = function (p0) {
	return _in(0x600f8cb3, 0x1c7aab6e, p0);
};

window.N_0x606e4d3e3cccf3eb = function () {
	return _in(0x606e4d3e, 0x3cccf3eb, _r, _ri);
};

/**
 * Console Hash: 0x37C388DB
 */
window.N_0x6070104b699b2ef4 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x6070104b, 0x699b2ef4, p0, p1, p2, p3, p4, p5, p6, _r, _ri);
};

window.N_0x60734cc207c9833c = function (p0) {
	return _in(0x60734cc2, 0x07c9833c, p0);
};

window.N_0x609278246a29ca34 = function (p0, p1, p2) {
	return _in(0x60927824, 0x6a29ca34, p0, p1, p2);
};

/**
 * Something with Social Club or online.
 */
window.N_0x60e892ba4f5bdca4 = function () {
	return _in(0x60e892ba, 0x4f5bdca4);
};

window.N_0x60edd13eb3ac1ff3 = function () {
	return _in(0x60edd13e, 0xb3ac1ff3, _r, _ri);
};

window.N_0x60eedc12af66e846 = function (p0) {
	return _in(0x60eedc12, 0xaf66e846, p0);
};

window.N_0x613f125ba3bd2eb9 = function () {
	return _in(0x613f125b, 0xa3bd2eb9, _r, _ri);
};

/**
 * Unknown. Called after creating a checkpoint (type: 51) in the creators.
 */
window.N_0x615d3925e87a3b26 = function (checkpoint) {
	return _in(0x615d3925, 0xe87a3b26, checkpoint);
};

/**
 * From the scripts:
 * OBJECT::_616093EC6B139DD9(PLAYER::PLAYER_ID(), ${pickup_portable_package}, 0);
 * OBJECT::_616093EC6B139DD9(PLAYER::PLAYER_ID(), ${pickup_portable_package}, 0);
 * OBJECT::_616093EC6B139DD9(PLAYER::PLAYER_ID(), ${pickup_portable_package}, 1);
 * OBJECT::_616093EC6B139DD9(PLAYER::PLAYER_ID(), ${pickup_portable_package}, 0);
 * OBJECT::_616093EC6B139DD9(PLAYER::PLAYER_ID(), ${pickup_armour_standard}, 0);
 * OBJECT::_616093EC6B139DD9(PLAYER::PLAYER_ID(), ${pickup_armour_standard}, 1);
 * SET_PLAYER_P*
 */
window.N_0x616093ec6b139dd9 = function (player, pickupHash, p2) {
	return _in(0x616093ec, 0x6b139dd9, player, _ch(pickupHash), p2);
};

window.N_0x61631f5df50d1c34 = function (p0) {
	return _in(0x61631f5d, 0xf50d1c34, p0);
};

window.N_0x61767f73eaceed21 = function (ped) {
	return _in(0x61767f73, 0xeaceed21, ped, _r);
};

window.N_0x617f49c2668e6155 = function () {
	return _in(0x617f49c2, 0x668e6155, _r, _ri);
};

window.N_0x61a885d3f7cfee9a = function () {
	return _in(0x61a885d3, 0xf7cfee9a);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x61f95e5bb3e0a8c6 = function (p0) {
	return _in(0x61f95e5b, 0xb3e0a8c6, p0);
};

window.N_0x6216b116083a7cb4 = function (p0) {
	return _in(0x6216b116, 0x083a7cb4, _fv(p0));
};

/**
 * Used only once (am_mp_property_int)
 * ped was PLAYER_PED_ID()
 */
window.N_0x621c6e4729388e41 = function (ped) {
	return _in(0x621c6e47, 0x29388e41, ped, _r);
};

window.N_0x62374889a4d59f72 = function () {
	return _in(0x62374889, 0xa4d59f72);
};

window.N_0x62454a641b41f3c5 = function (p0) {
	return _in(0x62454a64, 0x1b41f3c5, p0);
};

window.N_0x629526aba383bcaa = function () {
	return _in(0x629526ab, 0xa383bcaa);
};

window.N_0x62a0296c1bb1ceb3 = function () {
	return _in(0x62a0296c, 0x1bb1ceb3, _r, _ri);
};

window.N_0x62ca17b74c435651 = function (vehicle) {
	return _in(0x62ca17b7, 0x4c435651, vehicle, _r);
};

window.N_0x62e849b7eb28e770 = function (p0) {
	return _in(0x62e849b7, 0xeb28e770, p0);
};

window.N_0x62ecfcfdee7885d6 = function () {
	return _in(0x62ecfcfd, 0xee7885d6);
};

window.N_0x631dc5dff4b110e3 = function (p0) {
	return _in(0x631dc5df, 0xf4b110e3, p0, _r);
};

window.N_0x632b2940c67f4ea9 = function (scaleformHandle) {
	return _in(0x632b2940, 0xc67f4ea9, scaleformHandle, _i, _i, _i, _r);
};

window.N_0x634148744f385576 = function (vehicle) {
	return _in(0x63414874, 0x4f385576, vehicle, _r);
};

window.N_0x638a3a81733086db = function () {
	return _in(0x638a3a81, 0x733086db, _r, _ri);
};

window.N_0x639431e895b9aa57 = function (ped, vehicle, p2, p3, p4) {
	return _in(0x639431e8, 0x95b9aa57, ped, vehicle, p2, p3, p4, _r);
};

window.N_0x63b406d7884bfa95 = function () {
	return _in(0x63b406d7, 0x884bfa95, _r, _ri);
};

window.N_0x63eb2b972a218cac = function () {
	return _in(0x63eb2b97, 0x2a218cac);
};

window.N_0x641f272b52e2f0f8 = function (p0, p1) {
	return _in(0x641f272b, 0x52e2f0f8, p0, p1);
};

window.N_0x643ed62d5ea3bebd = function () {
	return _in(0x643ed62d, 0x5ea3bebd);
};

window.N_0x644546ec5287471b = function () {
	return _in(0x644546ec, 0x5287471b, _r);
};

window.N_0x6483c25849031c4f = function (p0, p1, p2, p3) {
	return _in(0x6483c258, 0x49031c4f, p0, p1, p2, _ii(p3) /* may be optional */);
};

window.N_0x648e7a5434af7969 = function (p0, p2, type) {
	return _in(0x648e7a54, 0x34af7969, _ts(p0), _i, p2, _i, _i, _i, _ts(type), _r);
};

window.N_0x6493cf69859b116a = function () {
	return _in(0x6493cf69, 0x859b116a);
};

window.N_0x649c97d52332341a = function (p0) {
	return _in(0x649c97d5, 0x2332341a, p0);
};

window.N_0x64d779659bc37b19 = function (p0) {
	return _in(0x64d77965, 0x9bc37b19, p0, _r, _rv);
};

/**
 * this is lightly associated with the 2 above meaning it accesses a variable that them 2 access also
 */
window.N_0x64f62afb081e260d = function () {
	return _in(0x64f62afb, 0x081e260d);
};

window.N_0x6501129c9e0ffa05 = function (p0, p1) {
	return _in(0x6501129c, 0x9e0ffa05, p0, p1);
};

window.N_0x6512765e3be78c50 = function () {
	return _in(0x6512765e, 0x3be78c50, _r, _ri);
};

window.N_0x651d3228960d08af = function (p0, p1) {
	return _in(0x651d3228, 0x960d08af, p0, p1);
};

/**
 * possibly called:
 * ADD_DOOR_EXPERIMENTAL_MATRIX
 */
window.N_0x65499865fca6e5ec = function (doorHash) {
	return _in(0x65499865, 0xfca6e5ec, _ch(doorHash), _r, _rf);
};

window.N_0x6551b1f7f6cd46ea = function (p0) {
	return _in(0x6551b1f7, 0xf6cd46ea, p0);
};

window.N_0x6558ac7c17bfef58 = function (p0) {
	return _in(0x6558ac7c, 0x17bfef58, p0, _r, _ri);
};

window.N_0x658500ae6d723a7e = function (p0) {
	return _in(0x658500ae, 0x6d723a7e, p0);
};

/**
 * Something related to clearing the ped because always used with CLEAR_PED_WETNESS, CLEAR_PED_BLOOD_DAMAGE and RESET_PED_VISIBLE_DAMAGE.
 */
window.N_0x6585d955a68452a5 = function (ped) {
	return _in(0x6585d955, 0xa68452a5, ped, _r, _ri);
};

window.N_0x659cf2ef7f550c4f = function () {
	return _in(0x659cf2ef, 0x7f550c4f, _r, _ri);
};

window.N_0x65b080555ea48149 = function (p0) {
	return _in(0x65b08055, 0x5ea48149, p0);
};

window.N_0x65d2ebb47e1cec21 = function (p0) {
	return _in(0x65d2ebb4, 0x7e1cec21, p0);
};

window.N_0x65e7e78842e74cdb = function (p0) {
	return _in(0x65e7e788, 0x42e74cdb, p0, _r, _ri);
};

/**
 * IS_PLAYER_*
 */
window.N_0x65faee425de637b0 = function (p0) {
	return _in(0x65faee42, 0x5de637b0, p0, _r);
};

window.N_0x661b5c8654add825 = function (p0, p1) {
	return _in(0x661b5c86, 0x54add825, p0, p1);
};

window.N_0x662635855957c411 = function (p0) {
	return _in(0x66263585, 0x5957c411, p0, _r, _ri);
};

/**
 * Something related to vehicle lean? (References CVehicleLeanHelper)
 */
window.N_0x6636c535f6cc2725 = function (vehicle) {
	return _in(0x6636c535, 0xf6cc2725, vehicle, _r, _rf);
};

window.N_0x6647c5f6f5792496 = function (ped, p1) {
	return _in(0x6647c5f6, 0xf5792496, ped, p1);
};

/**
 * Normally returns true. Returns false briefly whilst getting into a plane. This is probably a check to see if the ped model and all its components/drawables are properly loaded yet.
 */
window.N_0x66680a92700f43df = function (p0) {
	return _in(0x66680a92, 0x700f43df, p0, _r);
};

window.N_0x668fd40bcba5de48 = function (p0, p1, p2, p3, p4) {
	return _in(0x668fd40b, 0xcba5de48, p0, p1, p2, p3, p4, _r, _ri);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x66972397e0757e7a = function (p0, p1, p2) {
	return _in(0x66972397, 0xe0757e7a, p0, p1, p2);
};

window.N_0x66979acf5102fd2f = function (cargobob, p1) {
	return _in(0x66979acf, 0x5102fd2f, cargobob, _fv(p1));
};

window.N_0x66a49d021870fe88 = function () {
	return _in(0x66a49d02, 0x1870fe88);
};

window.N_0x66b59cffd78467af = function () {
	return _in(0x66b59cff, 0xd78467af, _r, _ri);
};

window.N_0x66e3aaface2d1eb8 = function (p0, p1, p2) {
	return _in(0x66e3aafa, 0xce2d1eb8, p0, p1, p2);
};

window.N_0x66e7cb63c97b7d20 = function () {
	return _in(0x66e7cb63, 0xc97b7d20, _r, _ri);
};

window.N_0x66f010a4b031a331 = function (p0) {
	return _in(0x66f010a4, 0xb031a331, _ii(p0) /* may be optional */);
};

window.N_0x673ed815d6e323b7 = function (p0, p1, p2, p3, p4) {
	return _in(0x673ed815, 0xd6e323b7, p0, p1, p2, p3, p4, _r);
};

window.N_0x675721c9f644d161 = function () {
	return _in(0x675721c9, 0xf644d161);
};

window.N_0x675d19c6067cae08 = function (p0, p1, p2, p3) {
	return _in(0x675d19c6, 0x067cae08, p0, p1, p2, p3);
};

window.N_0x678bb03c1a3bd51e = function (p0, p1, p2) {
	return _in(0x678bb03c, 0x1a3bd51e, p0, p1, p2, _i, _i, _r);
};

window.N_0x678f86d8fc040bdb = function (p0) {
	return _in(0x678f86d8, 0xfc040bdb, p0);
};

window.N_0x67a5589628e0cff6 = function () {
	return _in(0x67a55896, 0x28e0cff6, _r);
};

window.N_0x67eedea1b9bafd94 = function () {
	return _in(0x67eedea1, 0xb9bafd94);
};

window.N_0x67f6413d3220e18d = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0x67f6413d, 0x3220e18d, p0, p1, p2, p3, p4, p5, p6, p7, p8, _r, _ri);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x67fc09bc554a75e5 = function () {
	return _in(0x67fc09bc, 0x554a75e5, _r, _ri);
};

window.N_0x68103e2247887242 = function () {
	return _in(0x68103e22, 0x47887242);
};

/**
 * example:
 * if (GAMEPLAY::_684A41975F077262()) {
 * (a_0) = GAMEPLAY::_ABB2FA71C83A1B72();
 * } else {
 * (a_0) = -1;
 * }
 */
window.N_0x684a41975f077262 = function () {
	return _in(0x684a4197, 0x5f077262, _r);
};

window.N_0x6856ec3d35c81ea4 = function () {
	return _in(0x6856ec3d, 0x35c81ea4, _r, _ri);
};

window.N_0x685d5561680d088b = function (vehicle, p1) {
	return _in(0x685d5561, 0x680d088b, vehicle, _fv(p1));
};

window.N_0x68772db2b2526f9f = function (ped, x, y, z, range) {
	return _in(0x68772db2, 0xb2526f9f, ped, _fv(x), _fv(y), _fv(z), _fv(range), _r);
};

window.N_0x687c0b594907d2e8 = function (ped) {
	return _in(0x687c0b59, 0x4907d2e8, ped);
};

window.N_0x68f8be6af5cdf8a6 = function (p0, p1) {
	return _in(0x68f8be6a, 0xf5cdf8a6, p0, p1);
};

/**
 * p0 seems to be Ped
 * Dr. Underscore (1/6/18):
 * Has to do something with vehicles and teams. (same teams don't jack each other out of vehicles?)
 */
window.N_0x690a61a6d13583f6 = function (p0) {
	return _in(0x690a61a6, 0xd13583f6, p0, _r);
};

window.N_0x692d58df40657e8c = function (p0, p1, p2, p4, p5) {
	return _in(0x692d58df, 0x40657e8c, p0, p1, p2, _i, p4, p5, _r);
};

window.N_0x692d808c34a82143 = function (p0, p1, type) {
	return _in(0x692d808c, 0x34a82143, _ts(p0), _fv(p1), _ts(type), _r);
};

window.N_0x693478acbd7f18e7 = function () {
	return _in(0x693478ac, 0xbd7f18e7);
};

/**
 * what does it do?
 */
window.N_0x694e00132f2823ed = function (entity, p1) {
	return _in(0x694e0013, 0x2f2823ed, entity, p1);
};

window.N_0x697f508861875b42 = function (p0, p1, p2) {
	return _in(0x697f5088, 0x61875b42, p0, p1, p2, _r, _ri);
};

window.N_0x699e4a5c8c893a18 = function (p0, p1, p2) {
	return _in(0x699e4a5c, 0x8c893a18, p0, _ts(p1), _ii(p2) /* may be optional */, _r);
};

window.N_0x69ef772b192614c1 = function (p0, p1, p2, p3) {
	return _in(0x69ef772b, 0x192614c1, p0, p1, p2, p3);
};

window.N_0x69fe6dc87bd2a5e9 = function (p0) {
	return _in(0x69fe6dc8, 0x7bd2a5e9, p0);
};

window.N_0x6a12d88881435dca = function () {
	return _in(0x6a12d888, 0x81435dca);
};

window.N_0x6a1738b4323fe2d9 = function (p0) {
	return _in(0x6a1738b4, 0x323fe2d9, p0);
};

window.N_0x6a51f78772175a51 = function (p0) {
	return _in(0x6a51f787, 0x72175a51, p0);
};

/**
 * Called in freemode related scripts but not freemode itself.
 */
window.N_0x6a5d89d7769a40d8 = function (p0) {
	return _in(0x6a5d89d7, 0x769a40d8, p0);
};

window.N_0x6a60e43998228229 = function (p0) {
	return _in(0x6a60e439, 0x98228229, p0);
};

window.N_0x6a98c2ecf57fa5d4 = function (vehicle, entity) {
	return _in(0x6a98c2ec, 0xf57fa5d4, vehicle, entity);
};

window.N_0x6adaabd3068c5235 = function () {
	return _in(0x6adaabd3, 0x068c5235, _r, _ri);
};

/**
 * I put the argument as 'playerName' as when it's called in freemode.c TU27 X360 scripts. It's given a var that has GET_PLAYER_NAME stored in it via StringCopy.
 */
window.N_0x6afd2cd753feef83 = function (playerName) {
	return _in(0x6afd2cd7, 0x53feef83, _ts(playerName), _r);
};

window.N_0x6b0e6172c9a4d902 = function (p0) {
	return _in(0x6b0e6172, 0xc9a4d902, p0);
};

window.N_0x6b1de27ee78e6a19 = function (p0) {
	return _in(0x6b1de27e, 0xe78e6a19, p0);
};

window.N_0x6bc0acd0673acebe = function (p0, p1, p2) {
	return _in(0x6bc0acd0, 0x673acebe, p0, p1, p2);
};

window.N_0x6bc97f4f4bb3c04b = function (p0, p1) {
	return _in(0x6bc97f4f, 0x4bb3c04b, p0, p1);
};

window.N_0x6bccf9948492fd85 = function (p0, p1, p2, p3, p4) {
	return _in(0x6bccf994, 0x8492fd85, p0, p1, p2, p3, p4);
};

window.N_0x6bfb12ce158e3dd4 = function (p0) {
	return _in(0x6bfb12ce, 0x158e3dd4, p0, _r);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x6bff5f84102df80a = function (p0) {
	return _in(0x6bff5f84, 0x102df80a, p0);
};

window.N_0x6c34f1208b8923fd = function (p0) {
	return _in(0x6c34f120, 0x8b8923fd, p0, _r, _ri);
};

window.N_0x6cc86e78358d5119 = function () {
	return _in(0x6cc86e78, 0x358d5119);
};

window.N_0x6cd79468a1e595c6 = function (inputGroup) {
	return _in(0x6cd79468, 0xa1e595c6, inputGroup, _r);
};

window.N_0x6cdd58146a436083 = function (p0) {
	return _in(0x6cdd5814, 0x6a436083, p0);
};

window.N_0x6ce177d014502e8a = function (p0) {
	return _in(0x6ce177d0, 0x14502e8a, p0);
};

window.N_0x6ce50e47f5543d0c = function () {
	return _in(0x6ce50e47, 0xf5543d0c);
};

window.N_0x6d4cb481fac835e8 = function (p0, p1, p3) {
	return _in(0x6d4cb481, 0xfac835e8, p0, p1, _i, p3, _r);
};

/**
 * Possible values:
 * act_cinema
 * am_mp_carwash_launch
 * am_mp_carwash_control
 * am_mp_property_ext
 * chop
 * fairgroundHub
 * launcher_BasejumpHeli
 * launcher_BasejumpPack
 * launcher_CarWash
 * launcher_golf
 * launcher_Hunting_Ambient
 * launcher_MrsPhilips
 * launcher_OffroadRacing
 * launcher_pilotschool
 * launcher_Racing
 * launcher_rampage
 * launcher_rampage
 * launcher_range
 * launcher_stunts
 * launcher_stunts
 * launcher_tennis
 * launcher_Tonya
 * launcher_Triathlon
 * launcher_Yoga
 * ob_mp_bed_low
 * ob_mp_bed_med
 */
window.N_0x6d6840cee8845831 = function (action) {
	return _in(0x6d6840ce, 0xe8845831, _ts(action));
};

window.N_0x6d6af961b72728ae = function (vehicle) {
	return _in(0x6d6af961, 0xb72728ae, vehicle);
};

/**
 * Console Hash: 0x60E29B78
 */
window.N_0x6d8eac07506291fb = function (cargobob, p1) {
	return _in(0x6d8eac07, 0x506291fb, cargobob, _fv(p1));
};

window.N_0x6d955f6a9e0295b1 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x6d955f6a, 0x9e0295b1, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0x6ddbf9dffc4ac080 = function (p0) {
	return _in(0x6ddbf9df, 0xfc4ac080, p0);
};

window.N_0x6dee77aff8c21bd1 = function () {
	return _in(0x6dee77af, 0xf8c21bd1, _i, _i, _r);
};

window.N_0x6e04f06094c87047 = function () {
	return _in(0x6e04f060, 0x94c87047, _r, _ri);
};

window.N_0x6e0a5253375c4584 = function () {
	return _in(0x6e0a5253, 0x375c4584, _r, _ri);
};

window.N_0x6e4361ff3e8cd7ca = function (p0) {
	return _in(0x6e4361ff, 0x3e8cd7ca, p0, _r, _ri);
};

/**
 * Looks like a cousin of above function _6D6840CEE8845831 as it was found among them. Must be similar
 * Here are possible values of argument -
 * "ob_tv"
 * "launcher_Darts"
 */
window.N_0x6e91b04e08773030 = function (action) {
	return _in(0x6e91b04e, 0x08773030, _ts(action));
};

window.N_0x6eaaefc76acc311f = function (p0) {
	return _in(0x6eaaefc7, 0x6acc311f, p0, _r, _ri);
};

/**
 * sfink: sets bit in vehicle's structure, used by maintransition, fm_mission_controller, mission_race and a couple of other scripts. see dissassembly:
 * CVehicle *__fastcall sub_140CDAA10(signed int a1, char a2)
 * {
 * CVehicle *result; // rax@1
 * result = EntityAsCVehicle(a1);
 * if ( result )
 * {
 * result->field_886 &= 0xEFu;
 * result->field_886 |= 16 * (a2 & 1);
 * }
 * return result;
 * }
 */
window.N_0x6ebfb22d646ffc18 = function (vehicle, p1) {
	return _in(0x6ebfb22d, 0x646ffc18, vehicle, p1);
};

window.N_0x6ef54ab721dc6242 = function () {
	return _in(0x6ef54ab7, 0x21dc6242);
};

window.N_0x6f1554b0cc2089fa = function (p0) {
	return _in(0x6f1554b0, 0xcc2089fa, p0);
};

window.N_0x6f2135b6129620c1 = function (p0) {
	return _in(0x6f2135b6, 0x129620c1, p0);
};

window.N_0x6f259f82d873b8b8 = function () {
	return _in(0x6f259f82, 0xd873b8b8, _r, _ri);
};

window.N_0x6f361b8889a792a3 = function () {
	return _in(0x6f361b88, 0x89a792a3);
};

window.N_0x6f44cbf56d79fac0 = function (p0, p1) {
	return _in(0x6f44cbf5, 0x6d79fac0, p0, p1, _r, _ri);
};

window.N_0x6f697a66ce78674e = function (team, toggle) {
	return _in(0x6f697a66, 0xce78674e, team, toggle);
};

window.N_0x6f72cd94f7b5b68c = function () {
	return _in(0x6f72cd94, 0xf7b5b68c, _r, _ri);
};

/**
 * Seems to have the same functionality as REGISTER_TEXT_LABEL_TO_SAVE?
 * GAMEPLAY::_6F7794F28C6B2535(&a_0._f1, "tlPlateText");
 * GAMEPLAY::_6F7794F28C6B2535(&a_0._f1C, "tlPlateText_pending");
 * GAMEPLAY::_6F7794F28C6B2535(&a_0._f10B, "tlCarAppPlateText");
 * "tl" prefix sounds like "Text Label"
 */
window.N_0x6f7794f28c6b2535 = function (name) {
	return _in(0x6f7794f2, 0x8c6b2535, _i, _ts(name));
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x6fb7bb3607d27fa2 = function () {
	return _in(0x6fb7bb36, 0x07d27fa2, _r, _ri);
};

/**
 * This function is hard-coded to always return 1. Крч какая-то хуйня.
 */
window.N_0x6fcf8ddea146c45b = function (p0) {
	return _in(0x6fcf8dde, 0xa146c45b, p0);
};

window.N_0x6fd97159fe3c971a = function (p0, p1, p2, p3) {
	return _in(0x6fd97159, 0xfe3c971a, p0, p1, p2, p3);
};

window.N_0x6fddad856e36988a = function (p0, p1) {
	return _in(0x6fddad85, 0x6e36988a, p0, p1);
};

/**
 * - if (GAMEPLAY::_6FDDF453C0C756EC() || GAMEPLAY::IS_PC_VERSION()) {
 */
window.N_0x6fddf453c0c756ec = function () {
	return _in(0x6fddf453, 0xc0c756ec, _r);
};

window.N_0x700569dba175a77c = function (p0) {
	return _in(0x700569db, 0xa175a77c, p0, _r, _ri);
};

window.N_0x701fda1e82076ba4 = function () {
	return _in(0x701fda1e, 0x82076ba4);
};

window.N_0x702bc4d605522539 = function (p0) {
	return _in(0x702bc4d6, 0x05522539, p0);
};

window.N_0x7033eefd9b28088e = function (p0) {
	return _in(0x7033eefd, 0x9b28088e, p0);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x703cc7f60cbb2b57 = function (p0) {
	return _in(0x703cc7f6, 0x0cbb2b57, p0);
};

window.N_0x703f12425eca8bf5 = function (p0) {
	return _in(0x703f1242, 0x5eca8bf5, p0, _r, _ri);
};

window.N_0x705a276ebff3133d = function () {
	return _in(0x705a276e, 0xbff3133d, _r);
};

window.N_0x705a844002b39dc0 = function () {
	return _in(0x705a8440, 0x02b39dc0, _r, _ri);
};

window.N_0x70894bd0915c5bca = function (p0) {
	return _in(0x70894bd0, 0x915c5bca, _fv(p0), _r, _ri);
};

window.N_0x708bdd8cd795b043 = function () {
	return _in(0x708bdd8c, 0xd795b043);
};

window.N_0x70b8ec8fc108a634 = function (p0, p1) {
	return _in(0x70b8ec8f, 0xc108a634, p0, p1);
};

window.N_0x70ea8da57840f9be = function (p0) {
	return _in(0x70ea8da5, 0x7840f9be, p0, _r);
};

window.N_0x711794453cfd692b = function (p0, p1) {
	return _in(0x71179445, 0x3cfd692b, p0, p1);
};

window.N_0x71302ec70689052a = function (p0) {
	return _in(0x71302ec7, 0x0689052a, p0, _r, _ri);
};

/**
 * Used in am_mp_property_ext and am_mp_property_int
 */
window.N_0x715135f4b82ac90d = function (entity) {
	return _in(0x715135f4, 0xb82ac90d, entity);
};

/**
 * If the function fails, returns "Unknown".
 * Could be task (sequence) name. Needs more research.
 */
window.N_0x717e4d1f2048376d = function (ped) {
	return _in(0x717e4d1f, 0x2048376d, ped, _r, _s);
};

window.N_0x71862b1d855f32e1 = function (p1, p2, p3) {
	return _in(0x71862b1d, 0x855f32e1, _i, p1, p2, p3);
};

window.N_0x71b008056e5692d6 = function () {
	return _in(0x71b00805, 0x6e5692d6);
};

/**
 * It's 100% an IS_CUTSCENE_* native.
 */
window.N_0x71b74d2ae19338d0 = function (p0) {
	return _in(0x71b74d2a, 0xe19338d0, p0, _r);
};

window.N_0x71dc455f5cd1c2b1 = function (p0) {
	return _in(0x71dc455f, 0x5cd1c2b1, p0, _r, _ri);
};

window.N_0x71e7b2e657449aad = function () {
	return _in(0x71e7b2e6, 0x57449aad, _r, _ri);
};

window.N_0x722f5d28b61c5ea8 = function (p0) {
	return _in(0x722f5d28, 0xb61c5ea8, p0, _r, _ri);
};

window.N_0x723c1ce13fbfdb67 = function (p0, p1) {
	return _in(0x723c1ce1, 0x3fbfdb67, p0, p1);
};

window.N_0x7241ccb7d020db69 = function (p0, p1) {
	return _in(0x7241ccb7, 0xd020db69, p0, p1);
};

/**
 * Probably a bool, returns true if the specified network id is controlled by someone else.
 * If you have control over the entity corresponding to the netId then this will return false (0);
 * @param netId The network id for an object or entity.
 * @return Probably a bool, returns 1 if you don't have control over the netId entity.
 */
window.N_0x7242f8b741ce1086 = function (netId) {
	return _in(0x7242f8b7, 0x41ce1086, netId, _r, _ri);
};

/**
 * Last named native above this one is `TRACK_VEHICLE_VISIBILITY` and first named native below is `UNCUFF_PED`.
 * Unknown what it does, couldn't find good examples in the decompiled scripts.
 * @param p0 :
 * @param p1 :
 * @param p2 :
 */
window.N_0x725012a415dba050 = function (p0, p2) {
	return _in(0x725012a4, 0x15dba050, p0, _i, p2, _r, _ri);
};

window.N_0x728c4cc7920cd102 = function (p0) {
	return _in(0x728c4cc7, 0x920cd102, p0, _r, _ri);
};

window.N_0x72beccf4b829522e = function (p0, p1) {
	return _in(0x72beccf4, 0xb829522e, p0, p1);
};

/**
 * Appears to be a HIDE_* native.
 */
window.N_0x72c1056d678bb7d8 = function (weaponHash) {
	return _in(0x72c1056d, 0x678bb7d8, _ch(weaponHash));
};

window.N_0x72d0706cd6ccdb58 = function () {
	return _in(0x72d0706c, 0xd6ccdb58);
};

window.N_0x72d918c99bcacc54 = function (p0) {
	return _in(0x72d918c9, 0x9bcacc54, p0, _r);
};

window.N_0x72dd432f3cdfc0ee = function (posX, posY, posZ, radius, p4) {
	return _in(0x72dd432f, 0x3cdfc0ee, _fv(posX), _fv(posY), _fv(posZ), _fv(radius), p4);
};

window.N_0x72de52178c291cb5 = function () {
	return _in(0x72de5217, 0x8c291cb5, _r, _ri);
};

window.N_0x72eb7ba9b69bf6ab = function () {
	return _in(0x72eb7ba9, 0xb69bf6ab, _r);
};

window.N_0x73001e34f85137f8 = function (p0) {
	return _in(0x73001e34, 0xf85137f8, p0);
};

/**
 * NETWORK_CAN_R??? or NETWORK_CAN_S???
 */
window.N_0x7303e27cc6532080 = function (p0, p1, p2, p3, p5) {
	return _in(0x7303e27c, 0xc6532080, p0, p1, p2, p3, _i, p5, _r);
};

/**
 * AUDIO::_733ADF241531E5C2("inTunnel", 1.0);
 * AUDIO::_733ADF241531E5C2("inTunnel", 0.0);
 * I do not know as of yet what this does, but this was found in the scripts.
 */
window.N_0x733adf241531e5c2 = function (name, p1) {
	return _in(0x733adf24, 0x1531e5c2, _ts(name), _fv(p1));
};

window.N_0x733c87d4ce22bea2 = function (p0) {
	return _in(0x733c87d4, 0xce22bea2, p0);
};

window.N_0x7350823473013c02 = function (ped) {
	return _in(0x73508234, 0x73013c02, ped, _r);
};

window.N_0x73561d4425a021a2 = function (p0, p1) {
	return _in(0x73561d44, 0x25a021a2, p0, p1);
};

window.N_0x736d7aa1b750856b = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24, p25, p26, p27, p28, p29, p30, p31) {
	return _in(0x736d7aa1, 0xb750856b, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24, p25, p26, p27, p28, p29, p30, p31);
};

window.N_0x737e398138550fff = function (p0, p1) {
	return _in(0x737e3981, 0x38550fff, p0, p1);
};

window.N_0x741a3d8380319a81 = function () {
	return _in(0x741a3d83, 0x80319a81);
};

window.N_0x742b58f723233ed9 = function (p0) {
	return _in(0x742b58f7, 0x23233ed9, p0, _r, _ri);
};

/**
 * NETWORK_IS_*
 */
window.N_0x74698374c45701d2 = function () {
	return _in(0x74698374, 0xc45701d2, _r, _ri);
};

window.N_0x74a0fd0688f1ee45 = function (p0) {
	return _in(0x74a0fd06, 0x88f1ee45, p0, _r, _ri);
};

window.N_0x74bd83ea840f6bc9 = function () {
	return _in(0x74bd83ea, 0x840f6bc9, _r);
};

window.N_0x74c180030fde4b69 = function (p0) {
	return _in(0x74c18003, 0x0fde4b69, p0);
};

window.N_0x74de2e8739086740 = function () {
	return _in(0x74de2e87, 0x39086740);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x74fb3e29e6d10fa9 = function () {
	return _in(0x74fb3e29, 0xe6d10fa9, _r, _ri);
};

/**
 * bufferSize is 35 in the scripts.
 */
window.N_0x7543bb439f63792b = function (bufferSize) {
	return _in(0x7543bb43, 0x9f63792b, _i, bufferSize, _r);
};

window.N_0x756ae6e962168a04 = function (p0, p1) {
	return _in(0x756ae6e9, 0x62168a04, p0, p1);
};

window.N_0x75773e11ba459e90 = function (p0, p1) {
	return _in(0x75773e11, 0xba459e90, p0, p1);
};

window.N_0x758a5c1b3b1e1990 = function (p0) {
	return _in(0x758a5c1b, 0x3b1e1990, p0);
};

window.N_0x759299c5bb31d2a9 = function (p0, p1) {
	return _in(0x759299c5, 0xbb31d2a9, p0, p1, _r, _ri);
};

window.N_0x759650634f07b6b4 = function (p0) {
	return _in(0x75965063, 0x4f07b6b4, p0, _r);
};

window.N_0x75a16c3da34f1245 = function (blip, p1) {
	return _in(0x75a16c3d, 0xa34f1245, blip, p1);
};

window.N_0x75ba1cb3b7d40caf = function (ped, p1) {
	return _in(0x75ba1cb3, 0xb7d40caf, ped, p1);
};

window.N_0x75d3691713c3b05a = function () {
	return _in(0x75d36917, 0x13c3b05a);
};

window.N_0x762db2d380b48d04 = function (p0) {
	return _in(0x762db2d3, 0x80b48d04, p0);
};

window.N_0x7669f9e39dc17063 = function () {
	return _in(0x7669f9e3, 0x9dc17063);
};

window.N_0x7679cc1bcebe3d4c = function (p0, p1, p2) {
	return _in(0x7679cc1b, 0xcebe3d4c, p0, _fv(p1), _fv(p2));
};

window.N_0x769951e2455e2eb5 = function () {
	return _in(0x769951e2, 0x455e2eb5, _r, _ri);
};

window.N_0x76bba2cee66d47e9 = function (p0) {
	return _in(0x76bba2ce, 0xe66d47e9, p0, _r, _ri);
};

window.N_0x76bf03fadbf154f5 = function () {
	return _in(0x76bf03fa, 0xdbf154f5, _r, _ri);
};

window.N_0x76d26a22750e849e = function (p0) {
	return _in(0x76d26a22, 0x750e849e, p0);
};

/**
 * 6 calls in the b617d scripts, removed identical lines:
 * AUDIO::_774BD811F656A122("RADIO_01_CLASS_ROCK", 1);
 * AUDIO::_774BD811F656A122(AUDIO::GET_RADIO_STATION_NAME(10), 0);
 * AUDIO::_774BD811F656A122(AUDIO::GET_RADIO_STATION_NAME(10), 1);
 */
window.N_0x774bd811f656a122 = function (radioStation, p1) {
	return _in(0x774bd811, 0xf656a122, _ts(radioStation), p1);
};

window.N_0x77758139ec9b66c7 = function (p0) {
	return _in(0x77758139, 0xec9b66c7, p0);
};

window.N_0x7792424aa0eac32e = function () {
	return _in(0x7792424a, 0xa0eac32e);
};

window.N_0x77f16b447824da6c = function (p0) {
	return _in(0x77f16b44, 0x7824da6c, p0);
};

window.N_0x77faddcbe3499df7 = function (p0) {
	return _in(0x77faddcb, 0xe3499df7, p0);
};

/**
 * MulleDK19: This function is hard-coded to always return 1.
 */
window.N_0x7808619f31ff22db = function () {
	return _in(0x7808619f, 0x31ff22db, _r, _ri);
};

/**
 * p1: "MP_FEMALE_ACTION" found multiple times in the b617d scripts.
 * Console Hash: 0x83BAE814
 */
window.N_0x781de8fa214e87d2 = function (ped, p1) {
	return _in(0x781de8fa, 0x214e87d2, ped, _ts(p1));
};

window.N_0x78321bea235fd8cd = function (p0, p1) {
	return _in(0x78321bea, 0x235fd8cd, p0, p1, _r);
};

/**
 * Normally returns true. Returns false briefly whilst putting on a helmet after getting onto a motorbike. Not sure what that's about.
 */
window.N_0x784002a632822099 = function (ped) {
	return _in(0x784002a6, 0x32822099, ped, _r);
};

window.N_0x784ba7e0eceb4178 = function (p0, x, y, z) {
	return _in(0x784ba7e0, 0xeceb4178, p0, _fv(x), _fv(y), _fv(z));
};

window.N_0x78857fc65cadb909 = function (p0) {
	return _in(0x78857fc6, 0x5cadb909, p0);
};

window.N_0x788e7fd431bd67f1 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x788e7fd4, 0x31bd67f1, p0, p1, p2, p3, p4, p5);
};

window.N_0x78c0d93253149435 = function () {
	return _in(0x78c0d932, 0x53149435, _r, _ri);
};

window.N_0x78c4e9961db3eb5b = function (p0, p1) {
	return _in(0x78c4e996, 0x1db3eb5b, p0, p1);
};

window.N_0x78ceee41f49f421f = function (p0, p1) {
	return _in(0x78ceee41, 0xf49f421f, p0, p1);
};

/**
 * Related to cutscene entities. Unsure about the use.
 */
window.N_0x78e8e3a640178255 = function (entity) {
	return _in(0x78e8e3a6, 0x40178255, entity);
};

window.N_0x792271ab35c356a4 = function (p0, p1) {
	return _in(0x792271ab, 0x35c356a4, p0, p1);
};

window.N_0x793ff272d5b365f4 = function () {
	return _in(0x793ff272, 0xd5b365f4, _r, _ri);
};

window.N_0x796a877e459b99ea = function (p0, p1, p2, p3) {
	return _in(0x796a877e, 0x459b99ea, p0, _fv(p1), _fv(p2), _fv(p3));
};

/**
 * Draws the sphere typically seen in the GTA:O freemode event, Penned In. Example: [Image](https://images.illusivetea.me/6654p9.png)
 * @param x X co-ordinate of the sphere
 * @param y Y co-ordinate of the sphere
 * @param z Z co-ordinate of the sphere
 * @param radius Size of the sphere
 * @param r Color
 * @param g Color
 * @param b Color
 * @param opacity Opacity from `0.0`-`1.0`
 */
window.N_0x799017f9e3b10112 = function (x, y, z, radius, r, g, b, opacity) {
	return _in(0x799017f9, 0xe3b10112, _fv(x), _fv(y), _fv(z), _fv(radius), r, g, b, _fv(opacity));
};

window.N_0x79ab33f0fbfac40c = function (p0) {
	return _in(0x79ab33f0, 0xfbfac40c, p0);
};

window.N_0x79df7e806202ce01 = function (p0, p1) {
	return _in(0x79df7e80, 0x6202ce01, p0, p1);
};

window.N_0x7a42b2e236e71415 = function () {
	return _in(0x7a42b2e2, 0x36e71415);
};

window.N_0x7ac24eab6d74118d = function (p0) {
	return _in(0x7ac24eab, 0x6d74118d, p0, _r);
};

window.N_0x7ac752103856fb20 = function (p0) {
	return _in(0x7ac75210, 0x3856fb20, p0);
};

window.N_0x7ae0589093a2e088 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x7ae05890, 0x93a2e088, p0, p1, p2, p3, p4, p5, _r, _ri);
};

window.N_0x7b18da61f6bae9d5 = function (p0) {
	return _in(0x7b18da61, 0xf6bae9d5, p0);
};

window.N_0x7b21e0bb01e8224a = function (p0) {
	return _in(0x7b21e0bb, 0x01e8224a, p0);
};

window.N_0x7b226c785a52a0a9 = function () {
	return _in(0x7b226c78, 0x5a52a0a9, _r, _ri);
};

window.N_0x7b8a361c1813fbef = function () {
	return _in(0x7b8a361c, 0x1813fbef);
};

window.N_0x7bbe7ff626a591fe = function (p0) {
	return _in(0x7bbe7ff6, 0x26a591fe, p0);
};

window.N_0x7bf1a54ae67ac070 = function (p0, p1, p2) {
	return _in(0x7bf1a54a, 0xe67ac070, p0, p1, p2);
};

window.N_0x7c0043fdff6436bc = function (x) {
	return _in(0x7c0043fd, 0xff6436bc, x);
};

window.N_0x7c06330bfdda182e = function (p0) {
	return _in(0x7c06330b, 0xfdda182e, p0);
};

window.N_0x7c226d5346d4d10a = function (p0) {
	return _in(0x7c226d53, 0x46d4d10a, p0);
};

/**
 * Used for cash gifts
 * Console Hash
 */
window.N_0x7c4fccd2e4deb394 = function () {
	return _in(0x7c4fccd2, 0xe4deb394, _r);
};

window.N_0x7c9c0b1eeb1f9072 = function (p0) {
	return _in(0x7c9c0b1e, 0xeb1f9072, _fv(p0));
};

window.N_0x7cd934010e115c2c = function (ped) {
	return _in(0x7cd93401, 0x0e115c2c, ped);
};

/**
 * From the scripts:
 * AUDIO::_7CDC8C3B89F661B3(PLAYER::PLAYER_PED_ID(), GAMEPLAY::GET_HASH_KEY("PAIGE_PVG"));
 * AUDIO::_7CDC8C3B89F661B3(PLAYER::PLAYER_PED_ID(), GAMEPLAY::GET_HASH_KEY("TALINA_PVG"));
 * AUDIO::_7CDC8C3B89F661B3(PLAYER::PLAYER_PED_ID(), GAMEPLAY::GET_HASH_KEY("FEMALE_LOST_BLACK_PVG"));
 * AUDIO::_7CDC8C3B89F661B3(PLAYER::PLAYER_PED_ID(), GAMEPLAY::GET_HASH_KEY("FEMALE_LOST_WHITE_PVG"));
 */
window.N_0x7cdc8c3b89f661b3 = function (playerPed, p1) {
	return _in(0x7cdc8c3b, 0x89f661b3, playerPed, _ch(p1));
};

window.N_0x7d36291161859389 = function (p0) {
	return _in(0x7d362911, 0x61859389, p0);
};

window.N_0x7d395ea61622e116 = function (p0) {
	return _in(0x7d395ea6, 0x1622e116, p0);
};

window.N_0x7d41e9d2d17c5b2d = function (p0) {
	return _in(0x7d41e9d2, 0xd17c5b2d, p0, _r, _ri);
};

/**
 * what does this native do?
 * Here's some pseudocode of the internal setter function:
 * __int64 __fastcall sub_140CD86B4(signed int vehicle, char a2, char a3)
 * {
 * char v3; // di@1
 * char v4; // bl@1
 * __int64 result; // rax@1
 * __int16 v6; // cx@3
 * v3 = a3;
 * v4 = a2;
 * result = GetVehicleAddress(vehicle);
 * if ( result )
 * {
 * if ( v3 || (v6 = *(_WORD *)(result + 0xDA), (v6 & 0xFu) - 6 <= 1) )
 * {
 * *(_BYTE *)(result + 0x89B) &= 0xDFu;
 * *(_BYTE *)(result + 0x89B) |= 32 * (v4 & 1);
 * }
 * }
 * return result;
 * }
 * Now it's time for you to find out :P
 */
window.N_0x7d6f9a3ef26136a0 = function (vehicle, p1, p2) {
	return _in(0x7d6f9a3e, 0xf26136a0, vehicle, p1, p2);
};

/**
 * i found this function just like VEHICLE::TRACK_VEHICLE_VISIBILITY
 * example:
 * PED::_0x7D7A2E43E74E2EB8(ped);// TRACK_PED_VISIBILITY
 * if (PED::IS_TRACKED_PED_VISIBLE(ped))
 * {
 * }
 */
window.N_0x7d7a2e43e74e2eb8 = function (p0) {
	return _in(0x7d7a2e43, 0xe74e2eb8, p0);
};

window.N_0x7d8ba05688ad64c7 = function (p0) {
	return _in(0x7d8ba056, 0x88ad64c7, p0);
};

window.N_0x7db18ca8cad5b098 = function () {
	return _in(0x7db18ca8, 0xcad5b098, _r, _ri);
};

window.N_0x7db53b37a2f211a0 = function () {
	return _in(0x7db53b37, 0xa2f211a0, _r, _ri);
};

window.N_0x7e07c78925d5fd96 = function (p0) {
	return _in(0x7e07c789, 0x25d5fd96, p0, _r, _ri);
};

window.N_0x7e17be53e1aaabaf = function () {
	return _in(0x7e17be53, 0xe1aaabaf, _i, _i, _i);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 * ```
 * Something to do with phone cameras.
 * startup.c4:
 * void sub_2a3d() {
 * UNK2::_7E2BD3EF6C205F09("No_Filter", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam1", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam2", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam3", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam4", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam5", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam6", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam7", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam9", 1);
 * UNK2::_7E2BD3EF6C205F09("phone_cam12", 0);
 * }
 * ```
 */
window.N_0x7e2bd3ef6c205f09 = function (p0, p1) {
	return _in(0x7e2bd3ef, 0x6c205f09, _ts(p0), p1);
};

window.N_0x7e6946f68a38b74f = function (p0) {
	return _in(0x7e6946f6, 0x8a38b74f, p0, _r);
};

window.N_0x7ec3c679d0e7e46b = function (p0, p1, p2, p3) {
	return _in(0x7ec3c679, 0xd0e7e46b, p0, p1, p2, p3);
};

window.N_0x7ec6f9a478a6a512 = function () {
	return _in(0x7ec6f9a4, 0x78a6a512);
};

/**
 * _PLAYSTATS_ROB_ARMOURD_TRUCK
 */
window.N_0x7eec2a316c250073 = function (p0, p1, p2) {
	return _in(0x7eec2a31, 0x6c250073, p0, p1, p2);
};

window.N_0x7ef7649b64d7ff10 = function (p0) {
	return _in(0x7ef7649b, 0x64d7ff10, p0, _r, _ri);
};

window.N_0x7f2c4cdf2e82df4c = function (p0) {
	return _in(0x7f2c4cdf, 0x2e82df4c, p0, _r);
};

window.N_0x7f2f4f13ac5257ef = function (p0) {
	return _in(0x7f2f4f13, 0xac5257ef, p0, _r);
};

window.N_0x7f8f6405f4777af6 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0x7f8f6405, 0xf4777af6, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), p9, _r, _rf);
};

window.N_0x7f96f23fa9b73327 = function (modelHash) {
	return _in(0x7f96f23f, 0xa9b73327, _ch(modelHash));
};

window.N_0x7fa5d82b8f58ec06 = function () {
	return _in(0x7fa5d82b, 0x8f58ec06, _r);
};

window.N_0x7fcc39c46c3c03bd = function (p0) {
	return _in(0x7fcc39c4, 0x6c3c03bd, p0, _r);
};

window.N_0x7fd2990af016795e = function (p2, p3, p4) {
	return _in(0x7fd2990a, 0xf016795e, _i, _i, p2, p3, p4, _r, _ri);
};

window.N_0x80054d7fcc70eec6 = function (p0) {
	return _in(0x80054d7f, 0xcc70eec6, p0);
};

window.N_0x801879a9b4f4b2fb = function () {
	return _in(0x801879a9, 0xb4f4b2fb, _r, _ri);
};

window.N_0x806058bbdc136e06 = function () {
	return _in(0x806058bb, 0xdc136e06);
};

window.N_0x8098c8d6597aae18 = function (p0) {
	return _in(0x8098c8d6, 0x597aae18, p0, _r, _ri);
};

/**
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.N_0x80c2fd58d720c801 = function (inputGroup, control, p2) {
	return _in(0x80c2fd58, 0xd720c801, inputGroup, control, p2, _r, _s);
};

window.N_0x80e3357fdef45c21 = function (vehicle, toggle) {
	return _in(0x80e3357f, 0xdef45c21, vehicle, toggle);
};

/**
 * gets some camera fov
 */
window.N_0x80ec114669daeff4 = function () {
	return _in(0x80ec1146, 0x69daeff4, _r, _rf);
};

window.N_0x80fe4f3ab4e1b62a = function () {
	return _in(0x80fe4f3a, 0xb4e1b62a);
};

window.N_0x8147fff6a718e1ad = function (p0) {
	return _in(0x8147fff6, 0xa718e1ad, p0, _r, _ri);
};

window.N_0x814af7dcaacc597b = function (p0) {
	return _in(0x814af7dc, 0xaacc597b, p0);
};

window.N_0x815f18ad865f057f = function (p0) {
	return _in(0x815f18ad, 0x865f057f, p0, _r, _ri);
};

/**
 * UI::_817B86108EB94E51(1, &g_189F36._f10CD1[0 -- [[16]] ], &g_189F36._f10CD1[1 -- [[16]] ], &g_189F36._f10CD1[2 -- [[16]] ], &g_189F36._f10CD1[3 -- [[16]] ], &g_189F36._f10CD1[4 -- [[16]] ], &g_189F36._f10CD1[5 -- [[16]] ], &g_189F36._f10CD1[6 -- [[16]] ], &g_189F36._f10CD1[7 -- [[16]] ]);
 */
window.N_0x817b86108eb94e51 = function (p0) {
	return _in(0x817b8610, 0x8eb94e51, p0, _i, _i, _i, _i, _i, _i, _i, _i);
};

window.N_0x8181ce2f25cb9bb7 = function (p0, p1) {
	return _in(0x8181ce2f, 0x25cb9bb7, p0, p1, _r, _ri);
};

window.N_0x81aa517fbba05d39 = function (p0) {
	return _in(0x81aa517f, 0xbba05d39, p0, _r, _ri);
};

window.N_0x81cbae94390f9f89 = function () {
	return _in(0x81cbae94, 0x390f9f89);
};

window.N_0x820e9892a77e97cd = function (p0, p1) {
	return _in(0x820e9892, 0xa77e97cd, p0, p1);
};

window.N_0x821418c727fcacd7 = function (p0) {
	return _in(0x821418c7, 0x27fcacd7, p0);
};

window.N_0x821fdc827d6f4090 = function (p0) {
	return _in(0x821fdc82, 0x7d6f4090, p0);
};

/**
 * "GET_OBJ_ENTITY" seems highly unlikely.
 */
window.N_0x82377b65e943f72d = function (p0) {
	return _in(0x82377b65, 0xe943f72d, p0, _r);
};

/**
 * Only found 2 times in decompiled scripts. Not a whole lot to go off of.
 * GAMEPLAY::_8269816F6CFD40F8(&a_0._f1F5A._f6[0 -- [[8]] ], "TEMPSTAT_LABEL"); // gets saved in a struct called "g_SaveData_STRING_ScriptSaves"
 * GAMEPLAY::_8269816F6CFD40F8(&a_0._f4B4[v_1A -- [[8]] ], &v_5); // where v_5 is "Name0" thru "Name9", gets saved in a struct called "OUTFIT_Name"
 */
window.N_0x8269816f6cfd40f8 = function (name) {
	return _in(0x8269816f, 0x6cfd40f8, _i, _ts(name));
};

window.N_0x826d1ee4d1cafc78 = function (p0, p1) {
	return _in(0x826d1ee4, 0xd1cafc78, p0, p1);
};

/**
 * HUD_COLOUR_CONTROLLER_CHOP = 174;
 * UI::GET_HUD_COLOUR(174, &v_6, &v_7, &v_8, &v_9);
 * CONTROLS::_8290252FFF36ACB5(0, v_6, v_7, v_8);
 */
window.N_0x8290252fff36acb5 = function (p0, red, green, blue) {
	return _in(0x8290252f, 0xff36acb5, p0, red, green, blue);
};

window.N_0x82a2b386716608f1 = function () {
	return _in(0x82a2b386, 0x716608f1, _r, _ri);
};

window.N_0x82acc484ffa3b05f = function (p0) {
	return _in(0x82acc484, 0xffa3b05f, p0, _r, _ri);
};

window.N_0x82cedc33687e1f50 = function (p0) {
	return _in(0x82cedc33, 0x687e1f50, p0);
};

window.N_0x82ebb79e258fa2b7 = function (entity, interiorID) {
	return _in(0x82ebb79e, 0x258fa2b7, entity, interiorID);
};

window.N_0x83660b734994124d = function (p0, p1, p2) {
	return _in(0x83660b73, 0x4994124d, p0, p1, p2, _r, _ri);
};

window.N_0x838da0936a24ed4d = function (p0, p1) {
	return _in(0x838da093, 0x6a24ed4d, p0, p1);
};

window.N_0x83a169eabcdb10a2 = function (p0, p1) {
	return _in(0x83a169ea, 0xbcdb10a2, p0, p1);
};

window.N_0x83b8201ed82a9a2d = function (p0, p1, p2, p3) {
	return _in(0x83b8201e, 0xd82a9a2d, p0, p1, p2, _fv(p3));
};

/**
 * Saves a JSON file? It might even be saving it to the Rockstar Cloud, but I have no way of verifying this
 * "shrinkletter.c4", line ~378:
 * DATAFILE::DATAFILE_CREATE();
 * v_5 = DATAFILE::_GET_ROOT_OBJECT();
 * DATAFILE::_OBJECT_VALUE_ADD_INTEGER(v_5, "in", a_2);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "st", &a_2._f1);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "mp", &a_2._f2);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "ms", &a_2._f3);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "sc", &a_2._f5);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "pr", &a_2._f6);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "fa", &a_2._f7);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "sm", &a_2._f8);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "kp", &a_2._f9);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "sv", &a_2._fA);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "yo", &a_2._fB);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "fi", &a_2._fC);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "rc", &a_2._fD);
 * DATAFILE::_OBJECT_VALUE_ADD_STRING(v_5, "co", &a_2._fE);
 * DATAFILE::_OBJECT_VALUE_ADD_INTEGER(v_5, "su", a_2._fF);
 * DATAFILE::_83BCCE3224735F05("gta5/psych/index.json"); // saves the file?
 */
window.N_0x83bcce3224735f05 = function (filename) {
	return _in(0x83bcce32, 0x24735f05, _ts(filename), _r);
};

window.N_0x83f28ce49fbbffba = function (p0, p1, p2) {
	return _in(0x83f28ce4, 0x9fbbffba, p0, p1, p2, _r);
};

window.N_0x83fe8d7229593017 = function () {
	return _in(0x83fe8d72, 0x29593017);
};

/**
 * sfink: from scripts:
 * func_720(socialclub::_0x8416FE4E4629D7D7("bIgnoreCheaterOverride"));
 * func_719(socialclub::_0x8416FE4E4629D7D7("bIgnoreBadSportOverride"));
 */
window.N_0x8416fe4e4629d7d7 = function (p0) {
	return _in(0x8416fe4e, 0x4629d7d7, _ts(p0), _r);
};

window.N_0x84698ab38d0c6636 = function (hash) {
	return _in(0x84698ab3, 0x8d0c6636, _ch(hash), _r);
};

window.N_0x848b66100ee33b05 = function (p0) {
	return _in(0x848b6610, 0x0ee33b05, p0);
};

window.N_0x84a810b375e69c0e = function () {
	return _in(0x84a810b3, 0x75e69c0e, _r, _ri);
};

window.N_0x84c0116d012e8fc2 = function (p0) {
	return _in(0x84c0116d, 0x012e8fc2, p0);
};

window.N_0x84de3b5fb3e666f0 = function (p0) {
	return _in(0x84de3b5f, 0xb3e666f0, _ii(p0) /* may be optional */, _r);
};

window.N_0x84dfc579c2fc214c = function (p0) {
	return _in(0x84dfc579, 0xc2fc214c, p0);
};

window.N_0x84ea99c62cb3ef0c = function (p0, p1, p2) {
	return _in(0x84ea99c6, 0x2cb3ef0c, p0, p1, p2);
};

window.N_0x851cd923176eba7c = function () {
	return _in(0x851cd923, 0x176eba7c);
};

window.N_0x8533cafde1f0f336 = function (p0) {
	return _in(0x8533cafd, 0xe1f0f336, p0, _r, _ri);
};

window.N_0x85535acf97fc0969 = function (p0) {
	return _in(0x85535acf, 0x97fc0969, p0, _r, _ri);
};

window.N_0x855bc38818f6f684 = function () {
	return _in(0x855bc388, 0x18f6f684, _r);
};

window.N_0x8586789730b10caf = function (p0, p1, p2, p3) {
	return _in(0x85867897, 0x30b10caf, p0, p1, p2, p3);
};

window.N_0x858ec9fd25de04aa = function (p0, p1) {
	return _in(0x858ec9fd, 0x25de04aa, p0, p1);
};

window.N_0x85a0ef54a500882c = function (p0) {
	return _in(0x85a0ef54, 0xa500882c, _ii(p0) /* may be optional */, _r);
};

window.N_0x85b6c850546fdde2 = function (p0, p1, p2, p3, p4) {
	return _in(0x85b6c850, 0x546fdde2, p0, p1, p2, p3, p4, _r);
};

window.N_0x85f6c9aba1de2bcf = function () {
	return _in(0x85f6c9ab, 0xa1de2bcf, _r, _ri);
};

window.N_0x867458251d47ccb2 = function (p0, p1) {
	return _in(0x86745825, 0x1d47ccb2, p0, p1);
};

window.N_0x869daacbbe9fa006 = function () {
	return _in(0x869daacb, 0xbe9fa006, _r, _ri);
};

window.N_0x86b4b6212cb8b627 = function (p0, p1) {
	return _in(0x86b4b621, 0x2cb8b627, p0, p1);
};

window.N_0x86e0660e4f5c956d = function () {
	return _in(0x86e0660e, 0x4f5c956d);
};

window.N_0x870b8b7a766615c8 = function (p0, p1, p2) {
	return _in(0x870b8b7a, 0x766615c8, p0, p1, p2);
};

window.N_0x876928dddfccc9cd = function () {
	return _in(0x876928dd, 0xdfccc9cd, _r, _ri);
};

window.N_0x878c75c09fbdb942 = function () {
	return _in(0x878c75c0, 0x9fbdb942, _r, _ri);
};

window.N_0x87ddeb611b329a9c = function (p0) {
	return _in(0x87ddeb61, 0x1b329a9c, p0);
};

window.N_0x87e0052f08bd64e6 = function (p0, p1) {
	return _in(0x87e0052f, 0x08bd64e6, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x87e5c46c187fe0ae = function (p0, p1) {
	return _in(0x87e5c46c, 0x187fe0ae, p0, p1, _r, _ri);
};

window.N_0x8806cebfabd3ce05 = function (p0) {
	return _in(0x8806cebf, 0xabd3ce05, p0, _r);
};

window.N_0x88087ee1f28024ae = function (p0) {
	return _in(0x88087ee1, 0xf28024ae, p0);
};

window.N_0x8817605c2ba76200 = function () {
	return _in(0x8817605c, 0x2ba76200);
};

window.N_0x883d79c4071e18b3 = function () {
	return _in(0x883d79c4, 0x071e18b3, _r, _ri);
};

window.N_0x88578f6ec36b4a3a = function (p0, p1) {
	return _in(0x88578f6e, 0xc36b4a3a, p0, p1, _r, _ri);
};

window.N_0x886913bbeaca68c1 = function (p0) {
	return _in(0x886913bb, 0xeaca68c1, _ii(p0) /* may be optional */, _r, _ri);
};

window.N_0x8881c98a31117998 = function (p0) {
	return _in(0x8881c98a, 0x31117998, p0);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x88b588b41ff7868e = function () {
	return _in(0x88b588b4, 0x1ff7868e, _r, _ri);
};

window.N_0x88bc673ca9e0ae99 = function (vehicle, p1) {
	return _in(0x88bc673c, 0xa9e0ae99, vehicle, p1);
};

/**
 * SET_PED_PATH_*
 * Could be the move speed on the path. Needs testing.
 * Default is 1.0 and maximum is 10.0
 */
window.N_0x88e32db8c1a4aa4b = function (ped, p1) {
	return _in(0x88e32db8, 0xc1a4aa4b, ped, _fv(p1));
};

/**
 * SET_LOCAL_PLAYER_*
 */
window.N_0x88eaec617cd26926 = function (p0, p1) {
	return _in(0x88eaec61, 0x7cd26926, _ch(p0), p1);
};

/**
 * Something to do with time, used in context:
 * NETWORK::GET_TIME_DIFFERENCE(NETWORK::_89023FBBF9200E9F(), ... )
 * sfink: returns the same value as NETWORK::GET_NETWORK_TIME in freemode.
 */
window.N_0x89023fbbf9200e9f = function () {
	return _in(0x89023fbb, 0xf9200e9f, _r, _ri);
};

window.N_0x89215ec747df244a = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0x89215ec7, 0x47df244a, _fv(p0), p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, p8, _r, _ri);
};

window.N_0x892b6ab8f33606f5 = function (p0, p1) {
	return _in(0x892b6ab8, 0xf33606f5, p0, p1);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x8951eb9c6906d3c8 = function () {
	return _in(0x8951eb9c, 0x6906d3c8);
};

window.N_0x897433d292b44130 = function () {
	return _in(0x897433d2, 0x92b44130, _i, _i, _r);
};

window.N_0x8989cbd7b4e82534 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x8989cbd7, 0xb4e82534, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0x89d630cf5ea96d23 = function (vehicle, entity) {
	return _in(0x89d630cf, 0x5ea96d23, vehicle, entity, _r);
};

window.N_0x8a24b067d175a7bd = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x8a24b067, 0xd175a7bd, p0, p1, p2, p3, p4, p5, _r, _ri);
};

/**
 * One call found in the b617d scripts:
 * AUDIO::_8A694D7A68F8DC38(NETWORK::NET_TO_PED(l_3989._f26F[0 -- [[1]] ]), "CONV_INTERRUPT_QUIT_IT", "LESTER");
 */
window.N_0x8a694d7a68f8dc38 = function (p0, p1, p2) {
	return _in(0x8a694d7a, 0x68f8dc38, p0, _ts(p1), _ts(p2));
};

window.N_0x8a800daccc0da55d = function () {
	return _in(0x8a800dac, 0xcc0da55d);
};

window.N_0x8aa464d4e0f6accd = function () {
	return _in(0x8aa464d4, 0xe0f6accd, _r, _ri);
};

window.N_0x8aa9180de2fedd45 = function (vehicle, p1) {
	return _in(0x8aa9180d, 0xe2fedd45, vehicle, p1);
};

window.N_0x8abe8608576d9ce3 = function (p0, p1, p2, p3) {
	return _in(0x8abe8608, 0x576d9ce3, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _r, _rf);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x8b0c2964ba471961 = function () {
	return _in(0x8b0c2964, 0xba471961, _r, _ri);
};

window.N_0x8b4ffc790ca131ef = function (p0, p1, p2, p3) {
	return _in(0x8b4ffc79, 0x0ca131ef, p0, p1, p2, p3, _r, _ri);
};

window.N_0x8b9cdbd6c566c38c = function () {
	return _in(0x8b9cdbd6, 0xc566c38c, _r, _ri);
};

window.N_0x8bbacbf51da047a8 = function (p0) {
	return _in(0x8bbacbf5, 0x1da047a8, p0);
};

window.N_0x8bc515bae4aaf8ff = function (p0) {
	return _in(0x8bc515ba, 0xe4aaf8ff, p0, _r, _ri);
};

window.N_0x8bd6c6dea20e82c6 = function (p0) {
	return _in(0x8bd6c6de, 0xa20e82c6, p0, _r, _ri);
};

window.N_0x8bf907833be275de = function (p0, p1) {
	return _in(0x8bf90783, 0x3be275de, _fv(p0), _fv(p1));
};

window.N_0x8bfceb5ea1b161b6 = function () {
	return _in(0x8bfceb5e, 0xa1b161b6, _r, _ri);
};

window.N_0x8c33220c8d78ca0d = function (p0, p1) {
	return _in(0x8c33220c, 0x8d78ca0d, p0, p1);
};

window.N_0x8c4f3bf23b6237db = function (ped, p1, p2) {
	return _in(0x8c4f3bf2, 0x3b6237db, ped, p1, p2, _r, _ri);
};

window.N_0x8c8d2739ba44af0f = function (p0) {
	return _in(0x8c8d2739, 0xba44af0f, p0, _r);
};

window.N_0x8c9d11605e59d955 = function (p0) {
	return _in(0x8c9d1160, 0x5e59d955, p0);
};

window.N_0x8caab2bd3ea58bd4 = function (p0) {
	return _in(0x8caab2bd, 0x3ea58bd4, p0);
};

window.N_0x8cc469ab4d349b7c = function (p0, p1, p2) {
	return _in(0x8cc469ab, 0x4d349b7c, p0, _ts(p1), _ii(p2) /* may be optional */, _r);
};

/**
 * console hash: 0x19EC0001
 */
window.N_0x8cde909a0370bb3a = function (p0) {
	return _in(0x8cde909a, 0x0370bb3a, p0);
};

window.N_0x8d30f648014a92b5 = function () {
	return _in(0x8d30f648, 0x014a92b5, _r);
};

/**
 * GAMEPLAY::_8D74E26F54B4E5C3("");
 */
window.N_0x8d74e26f54b4e5c3 = function (p0) {
	return _in(0x8d74e26f, 0x54b4e5c3, _ts(p0));
};

window.N_0x8d768602adef2245 = function (p0, p1) {
	return _in(0x8d768602, 0xadef2245, p0, p1);
};

window.N_0x8d8adb562f09a245 = function (p0) {
	return _in(0x8d8adb56, 0x2f09a245, p0);
};

/**
 * Example of usage:
 * v_2 = SCRIPT::_30B4FA1C82DD4B9F(); // int _GET_ID_OF_NEXT_SCRIPT_IN_ENUMERATION()
 * CUTSCENE::_8D9DF6ECA8768583(v_2);
 */
window.N_0x8d9df6eca8768583 = function (p0) {
	return _in(0x8d9df6ec, 0xa8768583, p0);
};

window.N_0x8e243837643d9583 = function (p0, p1, p2, p3) {
	return _in(0x8e243837, 0x643d9583, p0, p1, p2, p3);
};

window.N_0x8e2a065abdae6994 = function () {
	return _in(0x8e2a065a, 0xbdae6994);
};

window.N_0x8ea86df356801c7d = function (p0, p1) {
	return _in(0x8ea86df3, 0x56801c7d, p0, p1);
};

window.N_0x8ec74ceb042e7cff = function (p0) {
	return _in(0x8ec74ceb, 0x042e7cff, p0);
};

window.N_0x8ef5573a1f801a5c = function (p0) {
	return _in(0x8ef5573a, 0x1f801a5c, p0, _i, _i, _r);
};

/**
 * Example, only occurrence in the scripts:
 * UI::_8EFCCF6EC66D85E4(&v_23, &v_13, &v_13, 1, v_34);
 */
window.N_0x8efccf6ec66d85e4 = function (p3, p4) {
	return _in(0x8efccf6e, 0xc66d85e4, _i, _i, _i, p3, p4, _r, _ri);
};

window.N_0x8f08017f9d7c47bd = function (p0, p2) {
	return _in(0x8f08017f, 0x9d7c47bd, p0, _i, p2, _r);
};

window.N_0x8f5d1ad832aeb06c = function (p0) {
	return _in(0x8f5d1ad8, 0x32aeb06c, p0, _r, _ri);
};

window.N_0x8f5ea1c01d65a100 = function (p0) {
	return _in(0x8f5ea1c0, 0x1d65a100, p0, _r);
};

/**
 * No observed effect.
 */
window.N_0x8f719973e1445ba2 = function (vehicle, p1) {
	return _in(0x8f719973, 0xe1445ba2, vehicle, p1);
};

window.N_0x8fa9c42fc5d7c64b = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x8fa9c42f, 0xc5d7c64b, p0, p1, _fv(p2), _fv(p3), _fv(p4), p5);
};

/**
 * Appears only in fm_mission_controller and used only 3 times.
 * ped was always PLAYER_PED_ID()
 * p1 was always true
 * p2 was always true
 */
window.N_0x8fd89a6240813fd0 = function (ped, p1, p2) {
	return _in(0x8fd89a62, 0x40813fd0, ped, p1, p2);
};

/**
 * SET_GPS_???
 */
window.N_0x900086f371220b6f = function (p0, p1, p2) {
	return _in(0x900086f3, 0x71220b6f, p0, p1, p2);
};

window.N_0x9007a2f21dc108d4 = function (p0, p1) {
	return _in(0x9007a2f2, 0x1dc108d4, p0, _fv(p1));
};

window.N_0x9049fe339d5f6f6f = function () {
	return _in(0x9049fe33, 0x9d5f6f6f, _r, _ri);
};

window.N_0x90a6526cf0381030 = function (p0, p2, p3) {
	return _in(0x90a6526c, 0xf0381030, p0, _i, p2, p3, _r);
};

/**
 * Dr. Underscore (1/6/18):
 * Seems to return a value 0-2.
 */
window.N_0x90a78ecaa4e78453 = function () {
	return _in(0x90a78eca, 0xa4e78453, _r, _ri);
};

window.N_0x90d0622866e80445 = function (p0, p1) {
	return _in(0x90d06228, 0x66e80445, p0, _ts(p1));
};

/**
 * return bool according to scripts
 */
window.N_0x9135584d09a3437e = function () {
	return _in(0x9135584d, 0x09a3437e, _r, _ri);
};

window.N_0x918c7b2d2ff3928b = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x918c7b2d, 0x2ff3928b, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _r, _ri);
};

window.N_0x919b3c98ed8292f9 = function (p0) {
	return _in(0x919b3c98, 0xed8292f9, p0, _r);
};

window.N_0x91a0bd635321f145 = function (vehicle, p1) {
	return _in(0x91a0bd63, 0x5321f145, vehicle, p1);
};

/**
 * bool?
 * am_crate_drop.c
 * <...>
 * if (network::_network_are_ros_available())
 * {
 * if (network::_0x91B87C55093DE351())
 * <..>
 */
window.N_0x91b87c55093de351 = function () {
	return _in(0x91b87c55, 0x093de351, _r, _ri);
};

window.N_0x91d6dd290888cbab = function () {
	return _in(0x91d6dd29, 0x0888cbab, _r);
};

/**
 * Both coordinates are from objects in the decompiled scripts.
 * Native related to [\_0xECDC202B25E5CF48](#_0xECDC202B25E5CF48) p1 value. The only weapon hash used in the decompiled scripts is weapon_air_defence_gun. These two natives are used by the yacht script, decompiled scripts suggest it and the weapon hash used (valkyrie's rockets) are also used by yachts.
 * @param p0 X coordinate
 * @param p1 Y coordinate
 * @param p2 Z coordinate
 * @param p3 Unknown float 150.0 is used in freemode script.
 * @param p4 X coordinate
 * @param p5 Y coordinate
 * @param p6 Z coordinate
 * @param weaponHash weapon_air_defence_gun and 0 are used in the decompiled scripts.
 * @return Seems to be some sort of handle, result is += 1 any time this native is called.
 */
window.N_0x91ef34584710be99 = function (p0, p1, p2, p3, p4, p5, p6, weaponHash) {
	return _in(0x91ef3458, 0x4710be99, _fv(p0), _fv(p1), _fv(p2), p3, _fv(p4), _fv(p5), _fv(p6), _ch(weaponHash), _r, _ri);
};

window.N_0x91ef6ee6419e5b97 = function (p0) {
	return _in(0x91ef6ee6, 0x419e5b97, p0);
};

window.N_0x920d853f3e17f1da = function (interiorID, roomHashKey) {
	return _in(0x920d853f, 0x3e17f1da, interiorID, _ch(roomHashKey));
};

window.N_0x921ce12c489c4c41 = function (PlayerID) {
	return _in(0x921ce12c, 0x489c4c41, PlayerID, _r);
};

window.N_0x9237e334f6e43156 = function (p0) {
	return _in(0x9237e334, 0xf6e43156, p0, _r, _ri);
};

window.N_0x9245e81072704b8a = function (p0) {
	return _in(0x9245e810, 0x72704b8a, p0);
};

window.N_0x9251b6abf2d0a5b4 = function (p0, p1) {
	return _in(0x9251b6ab, 0xf2d0a5b4, p0, p1);
};

window.N_0x92523b76657a517d = function (p0, p1) {
	return _in(0x92523b76, 0x657a517d, p0, _fv(p1), _r, _ri);
};

/**
 * I can 100% confirm this is some kind of START_* native.
 * Next character in the name is either C, D or E.
 * Used only once in the scripts (benchmark.ysc).
 */
window.N_0x92790862e36c2ada = function () {
	return _in(0x92790862, 0xe36c2ada);
};

window.N_0x928dbfb892638ef3 = function () {
	return _in(0x928dbfb8, 0x92638ef3);
};

window.N_0x92aefb5f6e294023 = function (object, p1, p2) {
	return _in(0x92aefb5f, 0x6e294023, object, p1, p2);
};

window.N_0x92c360b5f15d2302 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x92c360b5, 0xf15d2302, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0x92da6e70ef249bd1 = function (p0, p1) {
	return _in(0x92da6e70, 0xef249bd1, _ts(p0), _ii(p1) /* may be optional */, _r);
};

/**
 * Unknown.
 * Seems to return either 0, 1, or -1.
 */
window.N_0x930de22f07b1cce3 = function (p0) {
	return _in(0x930de22f, 0x07b1cce3, p0, _r, _ri);
};

window.N_0x930f504203f561c9 = function (p0) {
	return _in(0x930f5042, 0x03f561c9, p0);
};

window.N_0x933bbeeb8c61b5f4 = function () {
	return _in(0x933bbeeb, 0x8c61b5f4, _r, _ri);
};

window.N_0x941e5306bcd7c2c7 = function () {
	return _in(0x941e5306, 0xbcd7c2c7, _r, _ri);
};

window.N_0x94538037ee44f5cf = function (p0) {
	return _in(0x94538037, 0xee44f5cf, p0);
};

window.N_0x9465e683b12d3f6b = function () {
	return _in(0x9465e683, 0xb12d3f6b);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0x9489659372a81585 = function () {
	return _in(0x94896593, 0x72a81585, _r, _ri);
};

window.N_0x949f397a288b28b3 = function (p0) {
	return _in(0x949f397a, 0x288b28b3, _fv(p0));
};

/**
 * NETWORK_IS_*
 */
window.N_0x94a8394d150b013a = function () {
	return _in(0x94a8394d, 0x150b013a, _r, _ri);
};

/**
 * Needs more research. Possibly used to calculate the "mask" when calling "STAT_SET_MASKED_INT"?
 */
window.N_0x94f12abf9c79e339 = function (p0) {
	return _in(0x94f12abf, 0x9c79e339, p0, _r, _ri);
};

window.N_0x952f06beecd775cc = function (p0, p1, p2, p3) {
	return _in(0x952f06be, 0xecd775cc, p0, p1, p2, p3);
};

window.N_0x95a7dabddbb78ae7 = function () {
	return _in(0x95a7dabd, 0xdbb78ae7, _i, _i);
};

/**
 * in the decompiled scripts, seems to be always called on the vehicle right after being attached to a trailer.
 */
window.N_0x95cf53b3d687f9fa = function (vehicle) {
	return _in(0x95cf53b3, 0xd687f9fa, vehicle);
};

window.N_0x95cf81bd06ee1887 = function () {
	return _in(0x95cf81bd, 0x06ee1887);
};

window.N_0x95eb5e34f821babe = function (p0, p1, p2) {
	return _in(0x95eb5e34, 0xf821babe, p0, p1, p2, _r, _ri);
};

window.N_0x9614b71f8adb982b = function () {
	return _in(0x9614b71f, 0x8adb982b, _r, _ri);
};

window.N_0x9641588dab93b4b5 = function (p0) {
	return _in(0x9641588d, 0xab93b4b5, p0);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x966dd84fb6a46017 = function () {
	return _in(0x966dd84f, 0xb6a46017);
};

window.N_0x967278682cb6967a = function (p0, p1, p2, p3) {
	return _in(0x96727868, 0x2cb6967a, p0, p1, p2, p3);
};

window.N_0x9689123e3f213aa5 = function () {
	return _in(0x9689123e, 0x3f213aa5, _r);
};

window.N_0x96e6d5150dbf1c09 = function (p0, p1, p2) {
	return _in(0x96e6d515, 0x0dbf1c09, p0, p1, p2);
};

window.N_0x96ee0eba0163df80 = function (p0, p1) {
	return _in(0x96ee0eba, 0x0163df80, p0, p1);
};

/**
 * SET_VEHICLE_DOORS_LOCKED_FOR_*
 */
window.N_0x9737a37136f07e75 = function (vehicle, toggle) {
	return _in(0x9737a371, 0x36f07e75, vehicle, toggle);
};

window.N_0x973d76aa760a6cb6 = function (p0) {
	return _in(0x973d76aa, 0x760a6cb6, p0);
};

window.N_0x975d66a0bc17064c = function (p0) {
	return _in(0x975d66a0, 0xbc17064c, p0);
};

window.N_0x9777734dad16992f = function () {
	return _in(0x9777734d, 0xad16992f, _r, _ri);
};

window.N_0x977ca98939e82e4b = function (p0, p1) {
	return _in(0x977ca989, 0x39e82e4b, p0, p1);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0x97e7e2c04245115b = function (p0) {
	return _in(0x97e7e2c0, 0x4245115b, p0);
};

window.N_0x98215325a695e78a = function (p0) {
	return _in(0x98215325, 0xa695e78a, p0);
};

window.N_0x98c3cf913d895111 = function (p0, p1) {
	return _in(0x98c3cf91, 0x3d895111, p0, p1, _r, _ri);
};

window.N_0x98e2bc1ca26287c3 = function () {
	return _in(0x98e2bc1c, 0xa26287c3);
};

window.N_0x98edf76a7271e4f2 = function () {
	return _in(0x98edf76a, 0x7271e4f2);
};

window.N_0x99093f60746708ca = function (p0) {
	return _in(0x99093f60, 0x746708ca, p0, _r, _ri);
};

window.N_0x9911f4a24485f653 = function (p0) {
	return _in(0x9911f4a2, 0x4485f653, p0);
};

window.N_0x993cbe59d350d225 = function (p0) {
	return _in(0x993cbe59, 0xd350d225, p0, _r);
};

window.N_0x996dd1e1e02f1008 = function () {
	return _in(0x996dd1e1, 0xe02f1008, _r, _ri);
};

window.N_0x998e18ceb44487fc = function (p0, p1, p2, p3) {
	return _in(0x998e18ce, 0xb44487fc, p0, p1, p2, p3);
};

window.N_0x99ac7f0d8b9c893d = function (p0) {
	return _in(0x99ac7f0d, 0x8b9c893d, _fv(p0));
};

window.N_0x99ad4cccb128cbc9 = function (vehicle) {
	return _in(0x99ad4ccc, 0xb128cbc9, vehicle);
};

window.N_0x99cad8e7afdb60fa = function (vehicle, p1, p2) {
	return _in(0x99cad8e7, 0xafdb60fa, vehicle, _fv(p1), _fv(p2));
};

window.N_0x9a53ded9921de990 = function (p0, p1) {
	return _in(0x9a53ded9, 0x921de990, p0, p1);
};

window.N_0x9a62ec95ae10e011 = function () {
	return _in(0x9a62ec95, 0xae10e011, _r, _ri);
};

/**
 * Example gotten from chinese2.c4
 * VEHICLE::_9A75585FB2E54FAD(2004.4471435546875, 3076.806640625, 46.60689926147461, 10.0);
 */
window.N_0x9a75585fb2e54fad = function (p0, p1, p2, p3) {
	return _in(0x9a75585f, 0xb2e54fad, _fv(p0), _fv(p1), _fv(p2), _fv(p3));
};

window.N_0x9a77dfd295e29b09 = function (p0, p1) {
	return _in(0x9a77dfd2, 0x95e29b09, p0, p1);
};

/**
 * RELEASE_???
 * I say RELEASE_???, as in IDA this native calls the same function as
 * -'RELEASE_MISSION_AUDIO_BANK()'.
 * -'RELEASE_AMBIENT_AUDIO_BANK()'.
 * -'RELEASE_SCRIPT_AUDIO_BANK()'.
 * However 'RELEASE_NAMED_SCRIPT_AUDIO_BANK' does not use the same function. So may be, 'RELEASE_???_AUDIO_BANK()'? Doubt it.
 * Console Hash: 0xE67446E9
 */
window.N_0x9ac92eed5e4793ab = function () {
	return _in(0x9ac92eed, 0x5e4793ab);
};

window.N_0x9b079e5221d984d3 = function (p0) {
	return _in(0x9b079e52, 0x21d984d3, p0);
};

window.N_0x9b2bd3773123ea2f = function (type, toggle) {
	return _in(0x9b2bd377, 0x3123ea2f, type, toggle);
};

window.N_0x9b4bd21d69b1e609 = function () {
	return _in(0x9b4bd21d, 0x69b1e609);
};

window.N_0x9b6e70c5ceef4eeb = function (p0) {
	return _in(0x9b6e70c5, 0xceef4eeb, p0, _r, _ri);
};

window.N_0x9ba001cb45cbf627 = function (doorHash, heading, p2, p3) {
	return _in(0x9ba001cb, 0x45cbf627, _ch(doorHash), _fv(heading), p2, p3);
};

/**
 * Console Hash: 0x50CDB295
 */
window.N_0x9bddc73cc6a115d4 = function (vehicle, p1, p2) {
	return _in(0x9bddc73c, 0xc6a115d4, vehicle, p1, p2);
};

window.N_0x9becd4b9fef3f8a6 = function (vehicle, p1) {
	return _in(0x9becd4b9, 0xfef3f8a6, vehicle, p1);
};

/**
 * Gets some kind of data related to missions like the online player created races n stuff
 */
window.N_0x9bf438815f5d96ea = function (p0, p1, p3, p4, p5) {
	return _in(0x9bf43881, 0x5f5d96ea, p0, p1, _i, p3, p4, p5, _r);
};

window.N_0x9c16459b2324b2cf = function (p0, p1) {
	return _in(0x9c16459b, 0x2324b2cf, p0, p1);
};

window.N_0x9c6a6c19b6c0c496 = function (p0, p1) {
	return _in(0x9c6a6c19, 0xb6c0c496, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0x9cb0bfa7a9342c3d = function (p0, p1) {
	return _in(0x9cb0bfa7, 0xa9342c3d, p0, p1, _r);
};

/**
 * Only appeared in Golf & Golf_mp. Parameters were all ptrs
 */
window.N_0x9cfdd90b2b844bf7 = function (p0, p1, p2, p3, p4) {
	return _in(0x9cfdd90b, 0x2b844bf7, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4));
};

window.N_0x9d30687c57baa0bb = function (p0) {
	return _in(0x9d30687c, 0x57baa0bb, p0);
};

window.N_0x9d3af56e94c9ae98 = function (p0, p1) {
	return _in(0x9d3af56e, 0x94c9ae98, p0, _fv(p1));
};

window.N_0x9d728c1e12bf5518 = function (p0) {
	return _in(0x9d728c1e, 0x12bf5518, p0, _r, _ri);
};

window.N_0x9d75795b9dc6ebbf = function (p0) {
	return _in(0x9d75795b, 0x9dc6ebbf, p0);
};

window.N_0x9d7afcbf21c51712 = function (p0) {
	return _in(0x9d7afcbf, 0x21c51712, p0);
};

window.N_0x9d8d44adbba61ef2 = function (p0) {
	return _in(0x9d8d44ad, 0xbba61ef2, p0);
};

window.N_0x9da58cdbf6bdbc08 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10) {
	return _in(0x9da58cdb, 0xf6bdbc08, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, _r, _ri);
};

/**
 * Found in the b617d scripts:
 * PED::_9DBA107B4937F809(v_7, "trevor_heist_cover_2h");
 */
window.N_0x9dba107b4937f809 = function (p0, p1) {
	return _in(0x9dba107b, 0x4937f809, p0, _ts(p1));
};

window.N_0x9e30e91fb03a2caf = function () {
	return _in(0x9e30e91f, 0xb03a2caf, _i, _i, _r);
};

window.N_0x9e4cfff989258472 = function () {
	return _in(0x9e4cfff9, 0x89258472);
};

/**
 * Only found 4 times in Rockstar scripts.
 * Clearly has something to do with Cutscenes.
 */
window.N_0x9e6542f0ce8e70a3 = function (toggle) {
	return _in(0x9e6542f0, 0xce8e70a3, toggle);
};

/**
 * UI::0x7AD67C95("Gallery");
 * UI::0x7AD67C95("Missions");
 * UI::0x7AD67C95("General");
 * UI::0x7AD67C95("Playlists");
 */
window.N_0x9e778248d6685fe0 = function (p0) {
	return _in(0x9e778248, 0xd6685fe0, _ts(p0));
};

window.N_0x9e82f0f362881b29 = function (p0, p1, p2, p3, p4) {
	return _in(0x9e82f0f3, 0x62881b29, p0, p1, p2, p3, p4, _r, _ri);
};

window.N_0x9ebd751e5787baf2 = function (p0) {
	return _in(0x9ebd751e, 0x5787baf2, p0);
};

window.N_0x9ec8858184cd253a = function () {
	return _in(0x9ec88581, 0x84cd253a, _r, _ri);
};

/**
 * Disconnects you from the session, and starts loading single player, however you still remain connected to the server (only if you're the host, if you're not then you also (most likely) get disconnected from the server) and other players will not be able to join until you exit the game.
 * If you're already in SP then it'll re-load singleplayer.
 * You might need to DoScreenFadeIn and ShutdownLoadingScreen otherwise you probably won't end up loading into SP at all.
 * Somewhat related note: opening the pause menu after loading into this 'singleplayer' mode crashes the game.
 * @return always seems to be 1
 */
window.N_0x9eca15adfe141431 = function () {
	return _in(0x9eca15ad, 0xfe141431, _r, _ri);
};

window.N_0x9edd76e87d5d51ba = function (player) {
	return _in(0x9edd76e8, 0x7d5d51ba, player);
};

window.N_0x9f3f689b814f2599 = function (vehicle, p1) {
	return _in(0x9f3f689b, 0x814f2599, vehicle, p1);
};

window.N_0x9f5e6bb6b34540da = function (p0) {
	return _in(0x9f5e6bb6, 0xb34540da, _fv(p0));
};

window.N_0x9f6e2821885caee2 = function (p0, p1, p2) {
	return _in(0x9f6e2821, 0x885caee2, p0, p1, p2, _i, _i, _r);
};

window.N_0x9fe5633880ecd8ed = function (p0, p1, p2, p3) {
	return _in(0x9fe56338, 0x80ecd8ed, p0, p1, p2, p3);
};

window.N_0x9fedf86898f100e9 = function () {
	return _in(0x9fedf868, 0x98f100e9, _r, _ri);
};

window.N_0xa01bc64dd4bfbbac = function (vehicle, p1) {
	return _in(0xa01bc64d, 0xd4bfbbac, vehicle, p1, _r, _ri);
};

window.N_0xa049a5be0f04f2f8 = function () {
	return _in(0xa049a5be, 0x0f04f2f8, _r);
};

window.N_0xa071e0ed98f91286 = function (p0, p1) {
	return _in(0xa071e0ed, 0x98f91286, p0, p1);
};

window.N_0xa08fe5e49bdc39dd = function (p0, p1, p2) {
	return _in(0xa08fe5e4, 0x9bdc39dd, p0, _fv(p1), p2);
};

window.N_0xa097ab275061fb21 = function () {
	return _in(0xa097ab27, 0x5061fb21, _r, _ri);
};

window.N_0xa09f896ce912481f = function (p0) {
	return _in(0xa09f896c, 0xe912481f, p0, _r, _ri);
};

window.N_0xa0cefcea390aab9b = function (p0) {
	return _in(0xa0cefcea, 0x390aab9b, p0);
};

window.N_0xa0d3e4f7aafb7e78 = function (p0, p1) {
	return _in(0xa0d3e4f7, 0xaafb7e78, p0, p1, _r, _ri);
};

window.N_0xa0f8a7517a273c05 = function (p0, p1, p2, p3, p4) {
	return _in(0xa0f8a751, 0x7a273c05, p0, p1, p2, p3, p4, _r, _ri);
};

window.N_0xa0f93d5465b3094d = function (p0) {
	return _in(0xa0f93d54, 0x65b3094d, _ii(p0) /* may be optional */, _r);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0xa0fa4ec6a05da44e = function () {
	return _in(0xa0fa4ec6, 0xa05da44e, _r, _ri);
};

window.N_0xa0fe76168a189ddb = function () {
	return _in(0xa0fe7616, 0x8a189ddb, _r, _ri);
};

window.N_0xa12d3a5a3753cc23 = function () {
	return _in(0xa12d3a5a, 0x3753cc23, _r, _ri);
};

window.N_0xa134777ff7f33331 = function (p0, p1) {
	return _in(0xa134777f, 0xf7f33331, p0, _ii(p1) /* may be optional */, _r);
};

window.N_0xa13c11e1b5c06bfc = function () {
	return _in(0xa13c11e1, 0xb5c06bfc);
};

window.N_0xa13e93403f26c812 = function (p0) {
	return _in(0xa13e9340, 0x3f26c812, p0, _r, _ri);
};

window.N_0xa17784fca9548d15 = function (p0, p1, p2) {
	return _in(0xa17784fc, 0xa9548d15, p0, p1, p2);
};

window.N_0xa17bad153b51547e = function (cargobob, p1) {
	return _in(0xa17bad15, 0x3b51547e, cargobob, _fv(p1));
};

window.N_0xa1a9fc1c76a6730d = function (p0) {
	return _in(0xa1a9fc1c, 0x76a6730d, p0, _r, _ri);
};

window.N_0xa1c996c2a744262e = function (p0) {
	return _in(0xa1c996c2, 0xa744262e, _ii(p0) /* may be optional */, _r);
};

window.N_0xa1dd82f3ccf9a01e = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xa1dd82f3, 0xccf9a01e, p0, p1, p2, p3, p4, p5);
};

window.N_0xa1e5e0204a6fcc70 = function () {
	return _in(0xa1e5e020, 0x4a6fcc70);
};

/**
 * MulleDK19: This function is hard-coded to always return 1.
 */
window.N_0xa213b11dff526300 = function () {
	return _in(0xa213b11d, 0xff526300, _r, _ri);
};

window.N_0xa21c118553bbdf02 = function (ped) {
	return _in(0xa21c1185, 0x53bbdf02, ped);
};

window.N_0xa238192f33110615 = function () {
	return _in(0xa238192f, 0x33110615, _i, _i, _i, _r);
};

window.N_0xa247f9ef01d8082e = function (p0) {
	return _in(0xa247f9ef, 0x01d8082e, p0);
};

window.N_0xa2767257a320fc82 = function (p0, p1) {
	return _in(0xa2767257, 0xa320fc82, p0, p1);
};

window.N_0xa277800a9eae340e = function () {
	return _in(0xa277800a, 0x9eae340e, _r, _ri);
};

window.N_0xa2a707979fe754dc = function (p0, p1) {
	return _in(0xa2a70797, 0x9fe754dc, p0, p1);
};

window.N_0xa2c1f5e92afe49ed = function () {
	return _in(0xa2c1f5e9, 0x2afe49ed);
};

window.N_0xa2c9ac24b4061285 = function (p0, p1) {
	return _in(0xa2c9ac24, 0xb4061285, p0, p1, _r, _ri);
};

/**
 * Needs more research. If the "phone_cam12" filter is applied, this function is called with "TRUE"; otherwise, "FALSE".
 * Example (XBOX 360):
 * // check current filter selection
 * if (GAMEPLAY::ARE_STRINGS_EQUAL(getElem(g_2471024, &l_17, 4), "phone_cam12") != 0)
 * {
 * MOBILE::_0xC273BB4D(0); // FALSE
 * }
 * else
 * {
 * MOBILE::_0xC273BB4D(1); // TRUE
 * }
 */
window.N_0xa2ccbe62cd4c91a4 = function (toggle) {
	return _in(0xa2ccbe62, 0xcd4c91a4, _ii(toggle) /* may be optional */);
};

window.N_0xa2e9c1ab8a92e8cd = function (p0) {
	return _in(0xa2e9c1ab, 0x8a92e8cd, p0);
};

window.N_0xa2f952104fc6dd4b = function (p0) {
	return _in(0xa2f95210, 0x4fc6dd4b, p0, _r);
};

window.N_0xa306f470d1660581 = function () {
	return _in(0xa306f470, 0xd1660581, _r, _ri);
};

window.N_0xa31fd15197b192bd = function () {
	return _in(0xa31fd151, 0x97b192bd, _r, _ri);
};

/**
 * This native enables/disables the gold putting grid display (<https://i.imgur.com/TC6cku6.png>).
 * This requires these two natives to be called as well to configure the grid: [`0x1c4fc5752bcd8e48`](https://runtime.fivem.net/doc/reference.html#_0x1C4FC5752BCD8E48) and [`0x5ce62918f8d703c7`](https://runtime.fivem.net/doc/reference.html#_0x5CE62918F8D703C7).
 * @param toggle Enables or disables the golf putting grid display.
 */
window.N_0xa356990e161c9e65 = function (toggle) {
	return _in(0xa356990e, 0x161c9e65, toggle);
};

window.N_0xa3a9299c4f2adb98 = function (p0) {
	return _in(0xa3a9299c, 0x4f2adb98, p0);
};

window.N_0xa3c53804bdb68ed2 = function (p0, p1) {
	return _in(0xa3c53804, 0xbdb68ed2, p0, p1);
};

/**
 * Only called once in the scripts:
 * if (sub_1abd() && (!PED::_A3F3564A5B3646C0(l_8C))) {
 * if (sub_52e3("RESNA_CELLR", 0)) {
 * PED::SET_PED_CAN_PLAY_GESTURE_ANIMS(l_8C, 1);
 * PED::SET_PED_CAN_PLAY_AMBIENT_ANIMS(l_8C, 1);
 * PED::SET_PED_CAN_PLAY_VISEME_ANIMS(l_8C, 1, 0);
 * l_184 += 1;
 * }
 * }
 */
window.N_0xa3f3564a5b3646c0 = function (ped) {
	return _in(0xa3f3564a, 0x5b3646c0, ped, _r);
};

window.N_0xa40cc53df8e50837 = function (p0, args, argCount, bit) {
	return _in(0xa40cc53d, 0xf8e50837, p0, args, argCount, bit);
};

window.N_0xa41bcd7213805aac = function (p0) {
	return _in(0xa41bcd72, 0x13805aac, p0);
};

window.N_0xa44ff770dfbc5dae = function () {
	return _in(0xa44ff770, 0xdfbc5dae);
};

window.N_0xa4664972a9b8f8ba = function (p0) {
	return _in(0xa4664972, 0xa9b8f8ba, p0, _r, _ri);
};

window.N_0xa46b73faa3460ae1 = function (p0) {
	return _in(0xa46b73fa, 0xa3460ae1, p0);
};

window.N_0xa4819f5e23e2ffad = function () {
	return _in(0xa4819f5e, 0x23e2ffad, _r, _ri);
};

window.N_0xa4822f1cf23f4810 = function (p1, p3, p4, p5, p6, p7, p8) {
	return _in(0xa4822f1c, 0xf23f4810, _v, p1, _v, p3, p4, p5, p6, p7, p8, _r);
};

window.N_0xa48931185f0536fe = function () {
	return _in(0xa4893118, 0x5f0536fe, _r, _ri);
};

window.N_0xa4a0065e39c9f25c = function (p0, p1, p2, p3) {
	return _in(0xa4a0065e, 0x39c9f25c, p0, p1, p2, p3, _r, _ri);
};

window.N_0xa4dede28b1814289 = function () {
	return _in(0xa4dede28, 0xb1814289);
};

window.N_0xa51b086b0b2c0f7a = function (p0, p1, p2, p3) {
	return _in(0xa51b086b, 0x0b2c0f7a, p0, p1, p2, p3);
};

window.N_0xa51c4b86b71652ae = function (p0) {
	return _in(0xa51c4b86, 0xb71652ae, p0);
};

window.N_0xa52d5247a4227e14 = function (p0) {
	return _in(0xa52d5247, 0xa4227e14, p0);
};

window.N_0xa5342d390cda41d6 = function (p0, p1) {
	return _in(0xa5342d39, 0x0cda41d6, p0, p1);
};

window.N_0xa586fbeb32a53dbb = function () {
	return _in(0xa586fbeb, 0x32a53dbb, _r, _ri);
};

window.N_0xa5c80d8e768a9e66 = function (p0) {
	return _in(0xa5c80d8e, 0x768a9e66, _ii(p0) /* may be optional */, _r);
};

/**
 * NOTE: 'p1' might be some kind of array.
 */
window.N_0xa5efc3e847d60507 = function (p0, p1, p2, p3, p4) {
	return _in(0xa5efc3e8, 0x47d60507, _ts(p0), _ts(p1), _ts(p2), _ts(p3), p4, _r);
};

window.N_0xa5f377b175a699c5 = function (p0) {
	return _in(0xa5f377b1, 0x75a699c5, p0);
};

window.N_0xa635c11b8c44afc2 = function () {
	return _in(0xa635c11b, 0x8c44afc2, _r, _ri);
};

window.N_0xa6385deb180f319f = function (p0, p1, p2) {
	return _in(0xa6385deb, 0x180f319f, p0, p1, _fv(p2));
};

window.N_0xa660faf550eb37e5 = function (p0, p1) {
	return _in(0xa660faf5, 0x50eb37e5, p0, p1);
};

/**
 * Dr. Underscore (1/6/18):
 * Only one instances in two scripts. (cellphone_controller, maintransition)
 */
window.N_0xa67c35c56eb1bd9d = function () {
	return _in(0xa67c35c5, 0x6eb1bd9d, _r);
};

window.N_0xa68d3d229f4f3b06 = function (p0) {
	return _in(0xa68d3d22, 0x9f4f3b06, _ts(p0));
};

window.N_0xa699957e60d80214 = function (p0) {
	return _in(0xa699957e, 0x60d80214, p0, _r);
};

window.N_0xa69ac4ade82b57a4 = function (p0) {
	return _in(0xa69ac4ad, 0xe82b57a4, p0, _r);
};

window.N_0xa6f54bb2ffca35ea = function (p0) {
	return _in(0xa6f54bb2, 0xffca35ea, p0);
};

window.N_0xa72835064dd63e4c = function () {
	return _in(0xa7283506, 0x4dd63e4c, _r, _ri);
};

window.N_0xa735353c77334ea0 = function () {
	return _in(0xa735353c, 0x77334ea0, _i, _i);
};

window.N_0xa736cf7fb7c5bff4 = function () {
	return _in(0xa736cf7f, 0xb7c5bff4, _i, _i, _i, _i);
};

/**
 * Called 4 times in the b617d scripts:
 * GAMEPLAY::_A74802FB8D0B7814("CONTRAILS", 0);
 */
window.N_0xa74802fb8d0b7814 = function (p0, p1) {
	return _in(0xa74802fb, 0x8d0b7814, _ts(p0), _fv(p1));
};

window.N_0xa75ccf58a60a5fd1 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0xa75ccf58, 0xa60a5fd1, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
};

window.N_0xa761d4ac6115623d = function () {
	return _in(0xa761d4ac, 0x6115623d, _r, _ri);
};

window.N_0xa76359fc80b2438e = function (p0) {
	return _in(0xa76359fc, 0x80b2438e, _fv(p0));
};

window.N_0xa7862bc5ed1dfd7e = function (p0, p1) {
	return _in(0xa7862bc5, 0xed1dfd7e, p0, p1, _i, _i, _r);
};

/**
 * STATS::0xE3247582(0);
 * STATS::0xE3247582(1);
 * STATS::0xE3247582(2);
 * STATS::0xE3247582(3);
 * STATS::0xE3247582(4);
 * STATS::0xE3247582(5);
 * STATS::0xE3247582(6);
 */
window.N_0xa78b8fa58200da56 = function (p0) {
	return _in(0xa78b8fa5, 0x8200da56, p0);
};

window.N_0xa78de25577300ba1 = function (p0) {
	return _in(0xa78de255, 0x77300ba1, p0);
};

window.N_0xa7a1127490312c36 = function (p0) {
	return _in(0xa7a11274, 0x90312c36, _fv(p0));
};

window.N_0xa7c511fa1c5bda38 = function (p0, p1) {
	return _in(0xa7c511fa, 0x1c5bda38, p0, p1);
};

window.N_0xa7dcdf4ded40a8f4 = function (vehicle, p1) {
	return _in(0xa7dcdf4d, 0xed40a8f4, vehicle, p1);
};

/**
 * NETWORK_OVERRIDE_???
 */
window.N_0xa7e30de9272b6d49 = function (ped, x, y, z, p4) {
	return _in(0xa7e30de9, 0x272b6d49, ped, _fv(x), _fv(y), _fv(z), _fv(p4));
};

/**
 * Found in scripts:
 * if (AI::_A7FFBA498E4AAF67(l_9BC, "Run")) {
 * if (AI::_A7FFBA498E4AAF67(l_9BC, "Escape")) {
 */
window.N_0xa7ffba498e4aaf67 = function (ped, p1) {
	return _in(0xa7ffba49, 0x8e4aaf67, ped, _ts(p1), _r);
};

/**
 * p1 always false.
 */
window.N_0xa80ae305e0a3044f = function (entity, p1) {
	return _in(0xa80ae305, 0xe0a3044f, entity, p1);
};

window.N_0xa8434f1dff41d6e7 = function (p0) {
	return _in(0xa8434f1d, 0xff41d6e7, _fv(p0));
};

window.N_0xa85a21582451e951 = function (doorHash, p1) {
	return _in(0xa85a2158, 0x2451e951, _ch(doorHash), p1);
};

window.N_0xa8733668d1047b51 = function (p0) {
	return _in(0xa8733668, 0xd1047b51, p0);
};

window.N_0xa8acb6459542a8c8 = function () {
	return _in(0xa8acb645, 0x9542a8c8, _r, _ri);
};

window.N_0xa8b6afdac320ac87 = function (p0, p1) {
	return _in(0xa8b6afda, 0xc320ac87, p0, p1);
};

window.N_0xa8fdb297a8d25fba = function () {
	return _in(0xa8fdb297, 0xa8d25fba);
};

window.N_0xa905192a6781c41b = function (x, y, z) {
	return _in(0xa905192a, 0x6781c41b, _fv(x), _fv(y), _fv(z));
};

window.N_0xa90e7227a9303fa9 = function (p0, p1) {
	return _in(0xa90e7227, 0xa9303fa9, p0, p1);
};

window.N_0xa9240a96c74cca13 = function (p0) {
	return _in(0xa9240a96, 0xc74cca13, p0, _r);
};

window.N_0xa943fd1722e11efd = function () {
	return _in(0xa943fd17, 0x22e11efd, _r, _ri);
};

window.N_0xa95f667a755725da = function (p0, p1, p2, p3) {
	return _in(0xa95f667a, 0x755725da, p0, p1, p2, p3);
};

window.N_0xa9b61a329bfdcbea = function (p0, p1) {
	return _in(0xa9b61a32, 0x9bfdcbea, p0, p1);
};

window.N_0xa9cbfd40b3fa3010 = function () {
	return _in(0xa9cbfd40, 0xb3fa3010, _r, _ri);
};

window.N_0xa9f9c2e0fde11cbb = function (p0, p1, p2) {
	return _in(0xa9f9c2e0, 0xfde11cbb, p0, p1, _ii(p2) /* may be optional */, _r);
};

window.N_0xaa19f5572c38b564 = function (p0) {
	return _in(0xaa19f557, 0x2c38b564, _ii(p0) /* may be optional */, _r, _ri);
};

window.N_0xaa3f739abddcf21f = function () {
	return _in(0xaa3f739a, 0xbddcf21f);
};

window.N_0xaa525dff66bb82f5 = function (p0, p1, p2) {
	return _in(0xaa525dff, 0x66bb82f5, p0, p1, p2);
};

window.N_0xaa5fafcd2c5f5e47 = function () {
	return _in(0xaa5fafcd, 0x2c5f5e47, _r, _ri);
};

window.N_0xaa76052dda9bfc3e = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xaa76052d, 0xda9bfc3e, p0, p1, p2, p3, p4, p5, p6);
};

/**
 * console hash: 0xFD0F7EDD
 */
window.N_0xaaa553e7dd28a457 = function (p0) {
	return _in(0xaaa553e7, 0xdd28a457, p0);
};

window.N_0xaaa6a3698a69e048 = function (p0) {
	return _in(0xaaa6a369, 0x8a69e048, p0, _r, _ri);
};

window.N_0xab04325045427aae = function (vehicle, p1) {
	return _in(0xab043250, 0x45427aae, vehicle, p1);
};

window.N_0xab13a5565480b6d9 = function (p0, p1) {
	return _in(0xab13a556, 0x5480b6d9, p0, p1, _r, _ri);
};

window.N_0xab31ef4de6800ce9 = function (p0, p1) {
	return _in(0xab31ef4d, 0xe6800ce9, p0, p1);
};

window.N_0xabb2fa71c83a1b72 = function () {
	return _in(0xabb2fa71, 0xc83a1b72, _r, _ri);
};

window.N_0xac272c0ae01b4bd8 = function (p0, p1, p2, p3) {
	return _in(0xac272c0a, 0xe01b4bd8, p0, p1, p2, p3);
};

window.N_0xac2890471901861c = function (p0) {
	return _in(0xac289047, 0x1901861c, _fv(p0));
};

window.N_0xad5fdf34b81bfe79 = function () {
	return _in(0xad5fdf34, 0xb81bfe79);
};

window.N_0xad6875bbc0fc899c = function (x) {
	return _in(0xad6875bb, 0xc0fc899c, x);
};

/**
 * This has been found in use in the decompiled files.
 */
window.N_0xad73ce5a09e42d12 = function (player) {
	return _in(0xad73ce5a, 0x09e42d12, player, _r, _ri);
};

/**
 * gets 2 floats from the CNetGamePlayer of p0 and stores them in p1 and p2.
 * Possibly waypoint?
 */
window.N_0xadb57e5b663cca8b = function (p0) {
	return _in(0xadb57e5b, 0x663cca8b, p0, _f, _f);
};

window.N_0xaddd1c754e2e2914 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0xaddd1c75, 0x4e2e2914, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
};

window.N_0xaded7f5748acafe6 = function () {
	return _in(0xaded7f57, 0x48acafe6);
};

window.N_0xae3fee8709b39dcb = function (vehicle) {
	return _in(0xae3fee87, 0x09b39dcb, vehicle, _r);
};

window.N_0xae51bc858f32ba66 = function (p0, p1, p2, p3, p4) {
	return _in(0xae51bc85, 0x8f32ba66, p0, _fv(p1), _fv(p2), _fv(p3), _fv(p4));
};

window.N_0xaeab987727c5a8a4 = function (p0) {
	return _in(0xaeab9877, 0x27c5a8a4, p0, _r);
};

window.N_0xaeef48cdf5b6ce7c = function (p0, p1) {
	return _in(0xaeef48cd, 0xf5b6ce7c, p0, p1, _r);
};

window.N_0xaf03011701811146 = function (p0, p1) {
	return _in(0xaf030117, 0x01811146, p0, p1, _r, _ri);
};

/**
 * Possible p0 values:
 * "prologue"
 * "Prologue_Main"
 */
window.N_0xaf12610c644a35c9 = function (p0, p1) {
	return _in(0xaf12610c, 0x644a35c9, _ts(p0), p1);
};

/**
 * Exemple of use(carmod_shop.c4)
 * INTERIOR::_AF348AFCB575A441("V_CarModRoom");
 */
window.N_0xaf348afcb575a441 = function (roomName) {
	return _in(0xaf348afc, 0xb575a441, _ts(roomName));
};

window.N_0xaf42195a42c63bba = function () {
	return _in(0xaf42195a, 0x42c63bba, _r, _ri);
};

window.N_0xaf60e6a2936f982a = function (p0, p1) {
	return _in(0xaf60e6a2, 0x936f982a, p0, p1);
};

window.N_0xaf66dcee6609b148 = function () {
	return _in(0xaf66dcee, 0x6609b148);
};

window.N_0xafc976fd0580c7b3 = function (ped, toggle) {
	return _in(0xafc976fd, 0x0580c7b3, ped, toggle);
};

window.N_0xaff4710e2a0a6c12 = function (ped) {
	return _in(0xaff4710e, 0x2a0a6c12, ped);
};

window.N_0xaff47709f1d5dcce = function () {
	return _in(0xaff47709, 0xf1d5dcce, _r, _ri);
};

window.N_0xb055a34527cb8fd7 = function (vehicle, p1) {
	return _in(0xb055a345, 0x27cb8fd7, vehicle, p1);
};

window.N_0xb07d3185e11657a5 = function (p0) {
	return _in(0xb07d3185, 0xe11657a5, p0, _r);
};

window.N_0xb088e9a47ae6edd5 = function (vehicle, p1) {
	return _in(0xb088e9a4, 0x7ae6edd5, vehicle, p1);
};

window.N_0xb08b85d860e7ba3c = function (p0, p1, p2) {
	return _in(0xb08b85d8, 0x60e7ba3c, p0, p1, p2);
};

window.N_0xb094bc1db4018240 = function (p0, p1, p2, p3) {
	return _in(0xb094bc1d, 0xb4018240, p0, p1, _fv(p2), _fv(p3));
};

window.N_0xb09d25e77c33eb3f = function (p0, p1, p2) {
	return _in(0xb09d25e7, 0x7c33eb3f, p0, p1, p2, _r, _ri);
};

window.N_0xb0ad1238a709b1a2 = function (p0) {
	return _in(0xb0ad1238, 0xa709b1a2, p0, _r, _ri);
};

window.N_0xb0c56bd3d808d863 = function (p0) {
	return _in(0xb0c56bd3, 0xd808d863, p0);
};
window.GetBroadcastFinshedLosSound = window.N_0xb0c56bd3d808d863;

/**
 * Has something to do with player switch.
 * Only possible values:
 * - "CSM_ST_BOX3x3"
 */
window.N_0xb11d94bc55f41932 = function (p0) {
	return _in(0xb11d94bc, 0x55f41932, _ts(p0));
};

window.N_0xb129e447a2eda4bf = function (p0, p1) {
	return _in(0xb129e447, 0xa2eda4bf, p0, p1);
};

/**
 * Called in decompiled scripts as alternative to _SET_PED_ENEMY_AI_BLIP in an else, when the additional parameter p3 is not -1
 */
window.N_0xb13dcb4c6faad238 = function (ped, toggle, p3) {
	return _in(0xb13dcb4c, 0x6faad238, ped, toggle, p3);
};

window.N_0xb13e88e655e5a3bc = function () {
	return _in(0xb13e88e6, 0x55e5a3bc);
};

window.N_0xb1577667c3708f9b = function () {
	return _in(0xb1577667, 0xc3708f9b);
};

window.N_0xb17bc6453f6cf5ac = function (p0, p1) {
	return _in(0xb17bc645, 0x3f6cf5ac, p0, p1);
};

window.N_0xb1b6216ca2e7b55e = function (p0, p1, p2) {
	return _in(0xb1b6216c, 0xa2e7b55e, p0, p1, p2);
};

/**
 * 12 matches across 4 scripts. All 4 scripts were job creators.
 * type ranged from 0 - 2.
 * p4 was always 0.2f. Likely scale.
 * assuming p5 - p8 is RGBA, the graphic is always yellow (255, 255, 0, 255).
 * Tested but noticed nothing.
 */
window.N_0xb1bb03742917a5d6 = function (type, xPos, yPos, zPos, p4, red, green, blue, alpha) {
	return _in(0xb1bb0374, 0x2917a5d6, type, _fv(xPos), _fv(yPos), _fv(zPos), _fv(p4), red, green, blue, alpha);
};

window.N_0xb1d2bb1e1631f5b1 = function () {
	return _in(0xb1d2bb1e, 0x1631f5b1, _r);
};

window.N_0xb2092a1eaa7fd45f = function (p0) {
	return _in(0xb2092a1e, 0xaa7fd45f, p0, _r, _ri);
};

window.N_0xb214d570ead7f81a = function (p0, p1) {
	return _in(0xb214d570, 0xead7f81a, p0, p1);
};

/**
 * This native doesn't seem to do anything, might be a debug-only native.
 * Confirmed, it is a debug native.
 */
window.N_0xb264c4d2f2b0a78b = function (vehicle) {
	return _in(0xb264c4d2, 0xf2b0a78b, vehicle);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xb282749d5e028163 = function (p0, p1) {
	return _in(0xb282749d, 0x5e028163, p0, p1);
};

/**
 * No observed effect.
 */
window.N_0xb28b1fe5bfadd7f5 = function (vehicle, p1) {
	return _in(0xb28b1fe5, 0xbfadd7f5, vehicle, p1);
};

window.N_0xb2a592b04648a9cb = function () {
	return _in(0xb2a592b0, 0x4648a9cb, _r, _ri);
};

window.N_0xb2aff10216defa2f = function (x, y, z, p3, p4, p5, p6, interiorFlags, scale, duration) {
	return _in(0xb2aff102, 0x16defa2f, _fv(x), _fv(y), _fv(z), _fv(p3), _fv(p4), _fv(p5), _fv(p6), interiorFlags, _fv(scale), duration);
};

window.N_0xb2d0bde54f0e8e5a = function (object, toggle) {
	return _in(0xb2d0bde5, 0x4f0e8e5a, object, toggle);
};

window.N_0xb2e0c0d6922d31f2 = function (vehicle, toggle) {
	return _in(0xb2e0c0d6, 0x922d31f2, vehicle, toggle);
};

window.N_0xb2ebe8cbc58b90e9 = function () {
	return _in(0xb2ebe8cb, 0xc58b90e9, _r, _ri);
};

window.N_0xb309ebea797e001f = function (p0) {
	return _in(0xb309ebea, 0x797e001f, p0, _r, _ri);
};

window.N_0xb328dcc3a3aa401b = function (p0) {
	return _in(0xb328dcc3, 0xa3aa401b, p0, _r, _ri);
};

/**
 * This line found 48 times in the scripts:
 * GAMEPLAY::_B335F761606DB47C(&v_4, &v_7, a_0, v_A);
 */
window.N_0xb335f761606db47c = function (p3, p4) {
	return _in(0xb335f761, 0x606db47c, _i, _i, p3, p4, _r);
};

window.N_0xb37e4e6a2388ca7b = function () {
	return _in(0xb37e4e6a, 0x2388ca7b, _r, _ri);
};

window.N_0xb3c641f3630bf6da = function (p0) {
	return _in(0xb3c641f3, 0x630bf6da, _fv(p0));
};

window.N_0xb3cd58cca6cda852 = function () {
	return _in(0xb3cd58cc, 0xa6cda852);
};

/**
 * This function is hard-coded to always return 1.
 */
window.N_0xb3da2606774a8e2d = function () {
	return _in(0xb3da2606, 0x774a8e2d, _r, _ri);
};

window.N_0xb3e6360dde733e82 = function (p0) {
	return _in(0xb3e6360d, 0xde733e82, _fv(p0));
};

window.N_0xb3ea4feabf41464b = function (p0, p1) {
	return _in(0xb3ea4fea, 0xbf41464b, p0, p1, _r, _ri);
};

window.N_0xb3eca65c7317f174 = function () {
	return _in(0xb3eca65c, 0x7317f174, _r, _ri);
};

window.N_0xb4271092ca7edf48 = function (p0) {
	return _in(0xb4271092, 0xca7edf48, p0, _r, _ri);
};

/**
 * PLAYER::0xBF6993C7(rPtr((&l_122) + 71)); // Found in decompilation
 * ***
 * In "am_hold_up.ysc" used once:
 * l_8d._f47 = GAMEPLAY::GET_RANDOM_FLOAT_IN_RANGE(18.0, 28.0);
 * PLAYER::_B45EFF719D8427A6((l_8d._f47));
 */
window.N_0xb45eff719d8427a6 = function (p0) {
	return _in(0xb45eff71, 0x9d8427a6, _fv(p0));
};

window.N_0xb475f27c6a994d65 = function () {
	return _in(0xb475f27c, 0x6a994d65);
};

/**
 * This native is called 3 times in the decompiled scripts. Weapons hashes used are: weapon_railgun, weapon_proxmine and weapon_minigun.
 */
window.N_0xb4771b9aaf4e68e4 = function (ped, weaponHash, p2) {
	return _in(0xb4771b9a, 0xaf4e68e4, ped, _ch(weaponHash), p2);
};

window.N_0xb49eca122467d05f = function (p0, p1, p2, p3) {
	return _in(0xb49eca12, 0x2467d05f, p0, p1, p2, p3);
};

/**
 * Found in the b617d scripts, duplicates removed:
 * AUDIO::_B4BBFD9CD8B3922B("V_CARSHOWROOM_PS_WINDOW_UNBROKEN");
 * AUDIO::_B4BBFD9CD8B3922B("V_CIA_PS_WINDOW_UNBROKEN");
 * AUDIO::_B4BBFD9CD8B3922B("V_DLC_HEIST_APARTMENT_DOOR_CLOSED");
 * AUDIO::_B4BBFD9CD8B3922B("V_FINALEBANK_PS_VAULT_INTACT");
 * AUDIO::_B4BBFD9CD8B3922B("V_MICHAEL_PS_BATHROOM_WITH_WINDOW");
 */
window.N_0xb4bbfd9cd8b3922b = function (p0) {
	return _in(0xb4bbfd9c, 0xd8b3922b, _ts(p0));
};

window.N_0xb4c2ec463672474e = function (p0, p1, p2, p3) {
	return _in(0xb4c2ec46, 0x3672474e, p0, p1, p2, p3);
};

/**
 * Only used once in the scripts
 * weapon::_0xB4C8D77C80C0421E(Local_888[3  -- [[33]] ], -1082130432);
 * The code following this relates to manually triggering an RPG rocket (creating the object, the particle fx and sound)
 */
window.N_0xb4c8d77c80c0421e = function (ped, p1) {
	return _in(0xb4c8d77c, 0x80c0421e, ped, _fv(p1), _r, _ri);
};

window.N_0xb4f47213df45a64c = function (ped, p1) {
	return _in(0xb4f47213, 0xdf45a64c, ped, _ts(p1), _r);
};

window.N_0xb51b9ab9ef81868c = function (toggle) {
	return _in(0xb51b9ab9, 0xef81868c, toggle);
};

window.N_0xb542de8c3d1cb210 = function (p0) {
	return _in(0xb542de8c, 0x3d1cb210, p0);
};

window.N_0xb552929b85fc27ec = function (p0, p1) {
	return _in(0xb552929b, 0x85fc27ec, p0, p1);
};

window.N_0xb569f41f3e7e83a4 = function (p0) {
	return _in(0xb569f41f, 0x3e7e83a4, p0);
};

/**
 * "Can request assets for cutscene entity"? (found in decompiled scripts)
 */
window.N_0xb56bbbcc2955d9cb = function () {
	return _in(0xb56bbbcc, 0x2955d9cb, _r);
};

window.N_0xb57a49545ba53ce7 = function (p0) {
	return _in(0xb57a4954, 0x5ba53ce7, _ii(p0) /* may be optional */, _r);
};

window.N_0xb5d3453c98456528 = function () {
	return _in(0xb5d3453c, 0x98456528, _r, _ri);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xb606e6cc59664972 = function (p0) {
	return _in(0xb606e6cc, 0x59664972, p0);
};

window.N_0xb6871b0555b02996 = function (p2, p5) {
	return _in(0xb6871b05, 0x55b02996, _i, _i, p2, _i, _i, p5, _r, _ri);
};

window.N_0xb695e2cd0a2da9ee = function () {
	return _in(0xb695e2cd, 0x0a2da9ee);
};

window.N_0xb7257ba2550ea10a = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xb7257ba2, 0x550ea10a, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0xb743f735c03d7810 = function (p0, p1) {
	return _in(0xb743f735, 0xc03d7810, p0, p1);
};

window.N_0xb746d20b17f2a229 = function () {
	return _in(0xb746d20b, 0x17f2a229, _i, _i, _r);
};

window.N_0xb782f8238512bad5 = function (p0, p1) {
	return _in(0xb782f823, 0x8512bad5, p0, _ii(p1) /* may be optional */);
};

window.N_0xb7c7f6ad6424304b = function () {
	return _in(0xb7c7f6ad, 0x6424304b);
};

/**
 * GRAPHICS::_0xB7ED70C49521A61D(9123);
 * GRAPHICS::SET_STREAMED_TEXTURE_DICT_AS_NO_LONGER_NEEDED("MPMissMarkers256");
 */
window.N_0xb7ed70c49521a61d = function (decalType) {
	return _in(0xb7ed70c4, 0x9521a61d, decalType);
};

window.N_0xb81cf134aeb56ffb = function () {
	return _in(0xb81cf134, 0xaeb56ffb);
};

window.N_0xb8721407ee9c3ff6 = function (p0, p1, p2) {
	return _in(0xb8721407, 0xee9c3ff6, p0, p1, p2);
};

/**
 * Old Gen: 0x47D6004E
 * Disables something. Used only once in R* scripts (freemode.ysc).
 */
window.N_0xb885852c39cc265d = function () {
	return _in(0xb885852c, 0x39cc265d);
};

/**
 * if (!$B8B52E498014F5B0(PLAYER::PLAYER_PED_ID())) {
 */
window.N_0xb8b52e498014f5b0 = function (ped) {
	return _in(0xb8b52e49, 0x8014f5b0, ped, _r);
};

window.N_0xb8f87ead7533b176 = function (p0) {
	return _in(0xb8f87ead, 0x7533b176, _fv(p0));
};

window.N_0xb9496ce47546db2c = function (p0) {
	return _in(0xb9496ce4, 0x7546db2c, p0, _r, _ri);
};

window.N_0xb9562064627ff9db = function (p0, p1) {
	return _in(0xb9562064, 0x627ff9db, p0, p1);
};

window.N_0xb9854dfde0d833d6 = function (p0) {
	return _in(0xb9854dfd, 0xe0d833d6, _fv(p0));
};

window.N_0xb99c4e4d9499df29 = function (p0) {
	return _in(0xb99c4e4d, 0x9499df29, p0);
};

window.N_0xb9c362babecddc7a = function (p0, p1, p2, p3, p4) {
	return _in(0xb9c362ba, 0xbecddc7a, p0, p1, p2, p3, p4);
};

/**
 * Seem to return bool
 * Dr. Underscore (1/6/18):
 * It does return bool.
 */
window.N_0xb9cf1f793a9f1bf1 = function () {
	return _in(0xb9cf1f79, 0x3a9f1bf1, _r);
};

window.N_0xba0127da25fd54c9 = function (p0, p1) {
	return _in(0xba0127da, 0x25fd54c9, p0, p1);
};

window.N_0xba3d194057c79a7b = function (p0) {
	return _in(0xba3d1940, 0x57c79a7b, p0);
};

/**
 * Every p2 - p5 occurrence was 0f.
 */
window.N_0xba3d65906822bed5 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xba3d6590, 0x6822bed5, p0, p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5));
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xba4b8d83bdc75551 = function (p0) {
	return _in(0xba4b8d83, 0xbdc75551, p0);
};

window.N_0xba63d9fe45412247 = function (ped, p1) {
	return _in(0xba63d9fe, 0x45412247, ped, p1, _r);
};

window.N_0xba751764f0821256 = function () {
	return _in(0xba751764, 0xf0821256);
};

window.N_0xba7f0b77d80a4eb7 = function (p0, p1) {
	return _in(0xba7f0b77, 0xd80a4eb7, p0, p1);
};

window.N_0xba8805a1108a2515 = function (p0) {
	return _in(0xba8805a1, 0x108a2515, p0, _r, _ri);
};

window.N_0xba8d65c1c65702e5 = function (p0) {
	return _in(0xba8d65c1, 0xc65702e5, p0);
};

window.N_0xba91d045575699ad = function (p0) {
	return _in(0xba91d045, 0x575699ad, p0, _r, _ri);
};

window.N_0xba96394a0eecfa65 = function () {
	return _in(0xba96394a, 0x0eecfa65);
};

window.N_0xba9749cc94c1fd85 = function () {
	return _in(0xba9749cc, 0x94c1fd85, _r, _ri);
};

window.N_0xba9775570db788cf = function () {
	return _in(0xba977557, 0x0db788cf, _r, _ri);
};

window.N_0xbaa045b4e42f3c06 = function (p0, p1) {
	return _in(0xbaa045b4, 0xe42f3c06, p0, p1);
};

window.N_0xbaa2f0490e146be8 = function (p0) {
	return _in(0xbaa2f049, 0x0e146be8, p0);
};

window.N_0xbae4f9b97cd43b30 = function (p0) {
	return _in(0xbae4f9b9, 0x7cd43b30, p0);
};

window.N_0xbaf6babf9e7ccc13 = function (p0, p1) {
	return _in(0xbaf6babf, 0x9e7ccc13, p0, _ii(p1) /* may be optional */, _r, _ri);
};

window.N_0xbb2333bb87ddd87f = function (p0, p1) {
	return _in(0xbb2333bb, 0x87ddd87f, p0, p1);
};

window.N_0xbb90e12cac1dab25 = function (p0) {
	return _in(0xbb90e12c, 0xac1dab25, _fv(p0));
};

window.N_0xbbb45c3cf5c8aa85 = function () {
	return _in(0xbbb45c3c, 0xf5c8aa85, _r, _ri);
};

window.N_0xbbdf066252829606 = function (p0, p1) {
	return _in(0xbbdf0662, 0x52829606, p0, p1);
};

window.N_0xbbf327ded94e4deb = function (p0) {
	return _in(0xbbf327de, 0xd94e4deb, _ts(p0));
};

/**
 * var num3 = PLAYER::GET_PLAYER_PED(l_2171); // proof l_2171 is a player
 * var num17 = PLAYER::0x9DF75B2A(l_2171, 100, 0); // l_2171
 * .ysc:
 * if (PLAYER::GET_PLAYER_WANTED_LEVEL(l_6EF) < v_4) { // l_6EF is a player
 * PLAYER::SET_PLAYER_WANTED_LEVEL(l_6EF, v_4, 0); // l_6EF
 * PLAYER::SET_PLAYER_WANTED_LEVEL_NOW(l_6EF, 0); // l_6EF
 * } else {
 * PLAYER::_4669B3ED80F24B4E(l_6EF); // l_6EF
 * UI::_BA8D65C1C65702E5(1);
 * a_0 = 1;
 * }
 * if (l_4B24[l_6F2 -- [[156]] ]._f8C != PLAYER::_BC0753C9CA14B506(l_6EF, 100, 0)) { // l_6EF
 * l_4B24[l_6F2 -- [[156]] ]._f8C = PLAYER::_BC0753C9CA14B506(l_6EF, 100, 0); // l_6EF
 * }
 * Both was taken from fm_mission_controller
 * GET_PLAYER_*
 */
window.N_0xbc0753c9ca14b506 = function (player, p1, p2) {
	return _in(0xbc0753c9, 0xca14b506, player, p1, p2, _r);
};

/**
 * Most likely ROPE_ATTACH_*
 */
window.N_0xbc0ce682d4d05650 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13) {
	return _in(0xbc0ce682, 0xd4d05650, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13);
};

window.N_0xbc1cc91205ec8d6e = function () {
	return _in(0xbc1cc912, 0x05ec8d6e, _r, _ri);
};

window.N_0xbc3cca5844452b06 = function (p0) {
	return _in(0xbc3cca58, 0x44452b06, _fv(p0));
};

/**
 * Seems to only appear in scripts used in Singleplayer.
 * AI_PHONE_ARGS is a hash collision!!!
 * Always used like this in scripts
 * PLAYER::_BC9490CA15AEA8FB(PLAYER::PLAYER_ID());
 */
window.N_0xbc9490ca15aea8fb = function (player) {
	return _in(0xbc9490ca, 0x15aea8fb, player);
};

window.N_0xbc9823ab80a3dcac = function () {
	return _in(0xbc9823ab, 0x80a3dcac, _r, _ri);
};

window.N_0xbce595371a5fbaaf = function (p0, p1) {
	return _in(0xbce59537, 0x1a5fbaaf, p0, p1);
};

window.N_0xbcedb009461da156 = function () {
	return _in(0xbcedb009, 0x461da156, _r, _ri);
};

window.N_0xbcfde9ede4cf27dc = function (p0, p1) {
	return _in(0xbcfde9ed, 0xe4cf27dc, p0, p1);
};

window.N_0xbd0be0bfc927eac1 = function () {
	return _in(0xbd0be0bf, 0xc927eac1);
};

window.N_0xbd0efb25cca8f97a = function (p0, p1, p2, p3) {
	return _in(0xbd0efb25, 0xcca8f97a, p0, p1, p2, p3);
};

window.N_0xbd32e46aa95c1dd2 = function (p0) {
	return _in(0xbd32e46a, 0xa95c1dd2, p0);
};

/**
 * MulleDK19: This function is hard-coded to always return 1.
 */
window.N_0xbd545d44cce70597 = function () {
	return _in(0xbd545d44, 0xcce70597, _r);
};

window.N_0xbd605b8e0e18b3bb = function () {
	return _in(0xbd605b8e, 0x0e18b3bb);
};

window.N_0xbdb6f89c729cf388 = function () {
	return _in(0xbdb6f89c, 0x729cf388, _r, _ri);
};

window.N_0xbdeb86f4d5809204 = function (p0) {
	return _in(0xbdeb86f4, 0xd5809204, _fv(p0));
};

/**
 * This function is hard-coded to always return 0.
 */
window.N_0xbe197eaa669238f4 = function (p0, p1, p2, p3) {
	return _in(0xbe197eaa, 0x669238f4, p0, p1, p2, p3, _r, _ri);
};

window.N_0xbe3db208333d9844 = function () {
	return _in(0xbe3db208, 0x333d9844, _r, _ri);
};

window.N_0xbe509b0a3693de8b = function (p0) {
	return _in(0xbe509b0a, 0x3693de8b, p0);
};

window.N_0xbe5c1255a1830ff5 = function (vehicle, toggle) {
	return _in(0xbe5c1255, 0xa1830ff5, vehicle, toggle);
};

window.N_0xbeb2d9a1d9a8f55a = function (p0, p1, p2, p3) {
	return _in(0xbeb2d9a1, 0xd9a8f55a, p0, p1, p2, p3);
};

window.N_0xbeb3d46bb7f043c0 = function (p0) {
	return _in(0xbeb3d46b, 0xb7f043c0, p0);
};

window.N_0xbec0816ff5acbcda = function (p0, p1) {
	return _in(0xbec0816f, 0xf5acbcda, p0, p1);
};

window.N_0xbed8ca5ff5e04113 = function (p0, p1, p2, p3) {
	return _in(0xbed8ca5f, 0xf5e04113, _fv(p0), _fv(p1), _fv(p2), _fv(p3));
};

window.N_0xbed9f5693f34ed17 = function (statName, p1, outValue) {
	return _in(0xbed9f569, 0x3f34ed17, _ch(statName), p1, _fi(outValue) /* may be optional */, _r);
};

window.N_0xbef34b1d9624d5dd = function (p0) {
	return _in(0xbef34b1d, 0x9624d5dd, p0);
};

window.N_0xbf09786a7fcab582 = function (p0) {
	return _in(0xbf09786a, 0x7fcab582, p0, _r, _ri);
};

/**
 * respawn player
 */
window.N_0xbf22e0f32968e967 = function (player, p1) {
	return _in(0xbf22e0f3, 0x2968e967, player, p1);
};

window.N_0xbf371cd2b64212fd = function (p0) {
	return _in(0xbf371cd2, 0xb64212fd, p0);
};

window.N_0xbf4dc1784be94dfa = function (p0, p1, p2) {
	return _in(0xbf4dc178, 0x4be94dfa, p0, p1, p2);
};

window.N_0xbf4f34a85ca2970c = function () {
	return _in(0xbf4f34a8, 0x5ca2970c);
};

/**
 * Something to do with timecycles.
 */
window.N_0xbf59707b3e5ed531 = function (p0) {
	return _in(0xbf59707b, 0x3e5ed531, _ts(p0));
};

window.N_0xbf72910d0f26f025 = function () {
	return _in(0xbf72910d, 0x0f26f025, _r, _ri);
};

window.N_0xbfa0a56a817c6c7d = function (p0) {
	return _in(0xbfa0a56a, 0x817c6c7d, p0);
};

window.N_0xbfafdb5faaa5c5ab = function (p0) {
	return _in(0xbfafdb5f, 0xaaa5c5ab, p0);
};

window.N_0xc0416b061f2b7e5e = function (p0) {
	return _in(0xc0416b06, 0x1f2b7e5e, p0);
};

/**
 * Use _GET_VEHICLE_MOD_DATA for modData
 * Appears to be a GET_DLC_VEHICLE_MOD_* native.
 */
window.N_0xc098810437312fff = function (modData) {
	return _in(0xc0988104, 0x37312fff, modData, _r, _ri);
};

window.N_0xc0d2af00bcc234ca = function () {
	return _in(0xc0d2af00, 0xbcc234ca, _r, _ri);
};

window.N_0xc0e0d686ddfc6eae = function () {
	return _in(0xc0e0d686, 0xddfc6eae, _r, _ri);
};

window.N_0xc0ed6438e6d39ba8 = function (p0, p1, p2) {
	return _in(0xc0ed6438, 0xe6d39ba8, p0, p1, p2);
};

window.N_0xc13c38e47ea5df31 = function (p0) {
	return _in(0xc13c38e4, 0x7ea5df31, _ii(p0) /* may be optional */, _r);
};

window.N_0xc141b8917e0017ec = function () {
	return _in(0xc141b891, 0x7e0017ec);
};

window.N_0xc15907d667f7cfb2 = function (vehicle, toggle) {
	return _in(0xc15907d6, 0x67f7cfb2, vehicle, toggle);
};

window.N_0xc17ad0e5752becda = function (componentHash) {
	return _in(0xc17ad0e5, 0x752becda, _ch(componentHash), _r, _ri);
};

window.N_0xc1805d05e6d4fe10 = function (vehicle) {
	return _in(0xc1805d05, 0xe6d4fe10, vehicle);
};

window.N_0xc1952f3773ba18fe = function (p0, p1, p2) {
	return _in(0xc1952f37, 0x73ba18fe, p0, p1, p2);
};

window.N_0xc1f6ebf9a3d55538 = function (p0, p1) {
	return _in(0xc1f6ebf9, 0xa3d55538, p0, p1);
};

/**
 * same call as VEHICLE::_0x0F3B4D4E43177236
 */
window.N_0xc1f981a6f74f0c23 = function (p0, p1) {
	return _in(0xc1f981a6, 0xf74f0c23, p0, p1);
};

/**
 * Seems to return time in vector3
 */
window.N_0xc22912b1d85f26b1 = function (p0) {
	return _in(0xc22912b1, 0xd85f26b1, p0, _i, _v, _r);
};

window.N_0xc24075310a8b9cd1 = function (p0, p1, p2, p3, p4) {
	return _in(0xc2407531, 0x0a8b9cd1, p0, p1, p2, p3, p4);
};

window.N_0xc265df9fb44a9fbd = function (p0) {
	return _in(0xc265df9f, 0xb44a9fbd, p0, _r);
};

window.N_0xc2d15bef167e27bc = function () {
	return _in(0xc2d15bef, 0x167e27bc);
};

window.N_0xc2d2ad9eaae265b8 = function () {
	return _in(0xc2d2ad9e, 0xaae265b8, _r, _ri);
};

/**
 * CAM::_C2EAE3FB8CDBED31("SHAKE_CAM_medium", "medium", "", 0.5f);
 */
window.N_0xc2eae3fb8cdbed31 = function (p0, p1, p2, p3) {
	return _in(0xc2eae3fb, 0x8cdbed31, _ts(p0), _ts(p1), _ts(p2), _fv(p3));
};

window.N_0xc2ee020f5fb4db53 = function (ped) {
	return _in(0xc2ee020f, 0x5fb4db53, ped);
};

window.N_0xc32ea7a2f6ca7557 = function () {
	return _in(0xc32ea7a2, 0xf6ca7557, _r, _ri);
};

/**
 * - This is called after SET_ALL_RANDOM_PEDS_FLEE_THIS_FRAME
 * hash collision
 * 0xc3376f42b1faccc6, 0xd5d0d2853191399c, // set_areas_generator_orientation
 */
window.N_0xc3376f42b1faccc6 = function (player) {
	return _in(0xc3376f42, 0xb1faccc6, player);
};
window.SetAreasGeneratorOrientation = window.N_0xc3376f42b1faccc6;

window.N_0xc34bc448da29f5e9 = function (p0, p1) {
	return _in(0xc34bc448, 0xda29f5e9, p0, p1);
};

window.N_0xc35a6d07c93802b2 = function () {
	return _in(0xc35a6d07, 0xc93802b2);
};

window.N_0xc361aa040d6637a8 = function (vehicle, p1) {
	return _in(0xc361aa04, 0x0d6637a8, vehicle, p1);
};

window.N_0xc388a0f065f5bc34 = function (p0, p1) {
	return _in(0xc388a0f0, 0x65f5bc34, p0, p1);
};

window.N_0xc38dc1e90d22547c = function () {
	return _in(0xc38dc1e9, 0x0d22547c, _i, _i, _i, _r);
};

window.N_0xc3bfed92026a2aad = function (p0, p1, p2, p3, p4) {
	return _in(0xc3bfed92, 0x026a2aad, p0, p1, p2, p3, p4, _r, _ri);
};

window.N_0xc3c221addde31a11 = function (p0) {
	return _in(0xc3c221ad, 0xdde31a11, _fv(p0));
};

window.N_0xc3ead29ab273ece8 = function (p0) {
	return _in(0xc3ead29a, 0xb273ece8, _fv(p0));
};

window.N_0xc4278f70131baa6d = function (p0, p1) {
	return _in(0xc4278f70, 0x131baa6d, p0, p1);
};

window.N_0xc42dd763159f3461 = function () {
	return _in(0xc42dd763, 0x159f3461, _r, _ri);
};

window.N_0xc434133d9ba52777 = function (p0, p1) {
	return _in(0xc434133d, 0x9ba52777, p0, p1, _r, _ri);
};

window.N_0xc45c27ef50f36adc = function (vehicle, p1) {
	return _in(0xc45c27ef, 0x50f36adc, vehicle, p1);
};

window.N_0xc485e07e4f0b7958 = function (doorHash, p1, p2, p3) {
	return _in(0xc485e07e, 0x4f0b7958, _ch(doorHash), p1, p2, p3);
};

window.N_0xc4b3347bd68bd609 = function (p0) {
	return _in(0xc4b3347b, 0xd68bd609, p0);
};

window.N_0xc505036a35afd01b = function (p0) {
	return _in(0xc505036a, 0x35afd01b, p0);
};

window.N_0xc50ce861b55eab8b = function (vehicle, p1) {
	return _in(0xc50ce861, 0xb55eab8b, vehicle, p1);
};

/**
 * This seems to edit the water wave, intensity around your current location.
 * 0.0f = Normal
 * 1.0f = So Calm and Smooth, a boat will stay still.
 * 3.0f = Really Intense.
 */
window.N_0xc54a08c85ae4d410 = function (p0) {
	return _in(0xc54a08c8, 0x5ae4d410, _fv(p0));
};

window.N_0xc55854c7d7274882 = function () {
	return _in(0xc55854c7, 0xd7274882);
};

window.N_0xc55a0b40ffb1ed23 = function () {
	return _in(0xc55a0b40, 0xffb1ed23, _r, _ri);
};

window.N_0xc56fbf2f228e1dac = function (modelHash, p1, p2) {
	return _in(0xc56fbf2f, 0x228e1dac, _ch(modelHash), p1, p2, _r, _ri);
};

/**
 * NETWORK_IS_TRANSITION_???
 */
window.N_0xc571d0e77d8bbc29 = function () {
	return _in(0xc571d0e7, 0x7d8bbc29, _r, _ri);
};

/**
 * Interesting fact: A hash collision for this is RESET_JETPACK_MODEL_SETTINGS
 */
window.N_0xc594b315edf2d4af = function (ped) {
	return _in(0xc594b315, 0xedf2d4af, ped);
};

window.N_0xc5be134ec7ba96a0 = function (p0, p1, p2, p3, p4) {
	return _in(0xc5be134e, 0xc7ba96a0, p0, p1, p2, p3, p4);
};

window.N_0xc5c8f970d4edff71 = function (p0) {
	return _in(0xc5c8f970, 0xd4edff71, p0);
};

window.N_0xc6033d32241f6fb5 = function (p0, p1) {
	return _in(0xc6033d32, 0x241f6fb5, p0, p1);
};

/**
 * Toggles a value (bool) for cutscenes.
 */
window.N_0xc61b86c9f61eb404 = function (toggle) {
	return _in(0xc61b86c9, 0xf61eb404, toggle);
};

window.N_0xc64ded7ef0d2fe37 = function (p0) {
	return _in(0xc64ded7e, 0xf0d2fe37, _ii(p0) /* may be optional */, _r, _ri);
};

/**
 * Often called after _REMOVE_LOADING_PROMPT. Unsure what exactly it does, but It references busy_spinner, I can only guess its freeing the busy_spinner scaleform from memory
 */
window.N_0xc65ab383cd91df98 = function () {
	return _in(0xc65ab383, 0xcd91df98);
};

window.N_0xc6e0e2616a7576bb = function () {
	return _in(0xc6e0e261, 0x6a7576bb, _r, _ri);
};

window.N_0xc70ddce56d0d3a99 = function () {
	return _in(0xc70ddce5, 0x6d0d3a99, _r, _ri);
};

window.N_0xc729991a9065376e = function (p0) {
	return _in(0xc729991a, 0x9065376e, p0);
};

window.N_0xc7397a83f7a2a462 = function (p1, p2) {
	return _in(0xc7397a83, 0xf7a2a462, _i, p1, p2, _i, _r);
};

window.N_0xc78e239ac5b2ddb9 = function (p0, p1, p2) {
	return _in(0xc78e239a, 0xc5b2ddb9, p0, p1, p2);
};

window.N_0xc79196dcb36f6121 = function (p0) {
	return _in(0xc79196dc, 0xb36f6121, p0);
};

window.N_0xc79ae21974b01fb2 = function () {
	return _in(0xc79ae219, 0x74b01fb2);
};

window.N_0xc7abac5de675ee3b = function () {
	return _in(0xc7abac5d, 0xe675ee3b, _r, _ri);
};

window.N_0xc7be335216b5ec7c = function () {
	return _in(0xc7be3352, 0x16b5ec7c, _r, _ri);
};

window.N_0xc7db36c24634f52b = function () {
	return _in(0xc7db36c2, 0x4634f52b);
};

window.N_0xc7e7181c09f33b69 = function (p0) {
	return _in(0xc7e7181c, 0x09f33b69, p0);
};

window.N_0xc7f29ca00f46350e = function (p0) {
	return _in(0xc7f29ca0, 0x0f46350e, p0);
};

window.N_0xc8391c309684595a = function () {
	return _in(0xc8391c30, 0x9684595a);
};

window.N_0xc8407624cef2354b = function (p0, p1) {
	return _in(0xc8407624, 0xcef2354b, p0, p1);
};

window.N_0xc84527e235fca219 = function (p0, p1, p2, type, p6) {
	return _in(0xc84527e2, 0x35fca219, _ts(p0), p1, _ts(p2), _i, _i, _ts(type), p6, _r);
};

window.N_0xc847b43f369ac0b5 = function () {
	return _in(0xc847b43f, 0x369ac0b5);
};

window.N_0xc87e740d9f3872cc = function () {
	return _in(0xc87e740d, 0x9f3872cc, _r, _ri);
};

window.N_0xc8b1b2425604cdd0 = function () {
	return _in(0xc8b1b242, 0x5604cdd0, _r, _ri);
};

window.N_0xc8b5c4a79cc18b94 = function (p0) {
	return _in(0xc8b5c4a7, 0x9cc18b94, p0);
};

window.N_0xc8e1071177a23be5 = function () {
	return _in(0xc8e10711, 0x77a23be5, _i, _i, _i, _r);
};

window.N_0xc8ede9bdbccba6d4 = function (p1, p2, p3) {
	return _in(0xc8ede9bd, 0xbccba6d4, _i, _fv(p1), _fv(p2), _fv(p3));
};

window.N_0xc8f3aaf93d0600bf = function (p0, p1, p2, p3) {
	return _in(0xc8f3aaf9, 0x3d0600bf, p0, p1, p2, p3, _r, _ri);
};

window.N_0xc91c6c55199308ca = function (p0, p1, p2, p3) {
	return _in(0xc91c6c55, 0x199308ca, p0, _fv(p1), _fv(p2), _fv(p3));
};

window.N_0xc92717ef615b6704 = function (p0) {
	return _in(0xc92717ef, 0x615b6704, _fv(p0));
};

window.N_0xc980e62e33df1d5c = function () {
	return _in(0xc980e62e, 0x33df1d5c, _i, _i, _r);
};

window.N_0xc9a763d8fe87436a = function (player) {
	return _in(0xc9a763d8, 0xfe87436a, player);
};

window.N_0xc9b18b4619f48f7b = function (p0) {
	return _in(0xc9b18b46, 0x19f48f7b, _fv(p0));
};

window.N_0xc9b43a33d09cada7 = function (p0) {
	return _in(0xc9b43a33, 0xd09cada7, p0);
};

window.N_0xca465d9cc0d231ba = function (p0) {
	return _in(0xca465d9c, 0xc0d231ba, p0);
};

window.N_0xca4ac3eaae46ec7b = function (p0, p1) {
	return _in(0xca4ac3ea, 0xae46ec7b, p0, p1, _r, _ri);
};

window.N_0xca4ae345a153d573 = function (p0) {
	return _in(0xca4ae345, 0xa153d573, p0);
};

window.N_0xca575c391fea25cc = function (p0) {
	return _in(0xca575c39, 0x1fea25cc, p0);
};

window.N_0xca6b2f7ce32ab653 = function (p0, p2) {
	return _in(0xca6b2f7c, 0xe32ab653, p0, _i, p2, _r);
};

window.N_0xca94551b50b4932c = function (p0) {
	return _in(0xca94551b, 0x50b4932c, p0, _r, _ri);
};

window.N_0xca9d2aa3e326d720 = function () {
	return _in(0xca9d2aa3, 0xe326d720, _r);
};

/**
 * Found in "director_mode", "fm_bj_race_controler", "fm_deathmatch_controler", "fm_impromptu_dm_controler", "fm_race_controler", "gb_deathmatch".
 */
window.N_0xcac57395b151135f = function (player, p1) {
	return _in(0xcac57395, 0xb151135f, player, p1);
};

/**
 * rerere
 */
window.N_0xcac66558b944da67 = function (vehicle, p1) {
	return _in(0xcac66558, 0xb944da67, _ts(vehicle), p1);
};

/**
 * Only call found in the b617d scripts:
 * AUDIO::_CADA5A0D0702381E("BACK", "HUD_FREEMODE_SOUNDSET");
 */
window.N_0xcada5a0d0702381e = function (p0, soundset) {
	return _in(0xcada5a0d, 0x0702381e, _ts(p0), _ts(soundset));
};

window.N_0xcae55f48d3d7875c = function (p0) {
	return _in(0xcae55f48, 0xd3d7875c, p0);
};

window.N_0xcb00196b31c39eb1 = function (p0, p1, p2, p3) {
	return _in(0xcb00196b, 0x31c39eb1, p0, p1, p2, p3);
};

window.N_0xcb0360efefb2580d = function (p0) {
	return _in(0xcb0360ef, 0xefb2580d, p0);
};

window.N_0xcb215c4b56a7fae7 = function (p0) {
	return _in(0xcb215c4b, 0x56a7fae7, p0, _r, _ri);
};

window.N_0xcb645e85e97ea48b = function () {
	return _in(0xcb645e85, 0xe97ea48b, _r, _ri);
};

window.N_0xcb82a0bf0e3e3265 = function (p0) {
	return _in(0xcb82a0bf, 0x0e3e3265, p0, _r, _ri);
};

window.N_0xcb968b53fc7f916d = function (p0, p1, p2, p3) {
	return _in(0xcb968b53, 0xfc7f916d, p0, p1, p2, p3);
};

window.N_0xcc25a4553dfbf9ea = function (p0, p1, p2, p3, p4) {
	return _in(0xcc25a455, 0x3dfbf9ea, p0, p1, p2, p3, p4);
};

/**
 * Allows opening the pause menu this frame, when the player is dead.
 */
window.N_0xcc3fdded67bcfc63 = function () {
	return _in(0xcc3fdded, 0x67bcfc63);
};

window.N_0xcc6e3b6bb69501f1 = function (p0) {
	return _in(0xcc6e3b6b, 0xb69501f1, p0, _r, _ri);
};

/**
 * RESET_*
 */
window.N_0xcc6e963682533882 = function (p0) {
	return _in(0xcc6e9636, 0x82533882, p0);
};

/**
 * p4 seems to vary from 0 to 3.
 */
window.N_0xcc9682b8951c5229 = function (ped, r, g, b, p4) {
	return _in(0xcc9682b8, 0x951c5229, ped, r, g, b, p4);
};

window.N_0xcca4318e1ab03f1f = function (p0) {
	return _in(0xcca4318e, 0x1ab03f1f, _ii(p0) /* may be optional */, _r);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xccd078c2665d2973 = function (p0) {
	return _in(0xccd078c2, 0x665d2973, p0);
};

window.N_0xcd018c591f94cb43 = function (p0, p1) {
	return _in(0xcd018c59, 0x1f94cb43, p0, p1);
};

window.N_0xcd71a4ecab22709e = function (entity) {
	return _in(0xcd71a4ec, 0xab22709e, entity);
};

window.N_0xcd74233600c4ea6b = function (p0) {
	return _in(0xcd742336, 0x00c4ea6b, p0);
};

window.N_0xcd79a550999d7d4f = function (p0) {
	return _in(0xcd79a550, 0x999d7d4f, p0, _r, _ri);
};

window.N_0xcda1c62be2777802 = function (p0, p1, p2) {
	return _in(0xcda1c62b, 0xe2777802, p0, p1, p2);
};

/**
 * Probably SET_VEHICLE_SOMETHING
 */
window.N_0xcda42c4bb9bde779 = function (vehicle, p1) {
	return _in(0xcda42c4b, 0xb9bde779, vehicle, p1);
};

window.N_0xcdca26e80faecb8f = function () {
	return _in(0xcdca26e8, 0x0faecb8f);
};

window.N_0xce5aa445aba8dee0 = function (p0) {
	return _in(0xce5aa445, 0xaba8dee0, _ii(p0) /* may be optional */, _r, _ri);
};

window.N_0xce6294a232d03786 = function (p0, p1) {
	return _in(0xce6294a2, 0x32d03786, p0, p1, _r, _rv);
};

window.N_0xcea553e35c2246e1 = function (p0, p1, p2) {
	return _in(0xcea553e3, 0x5c2246e1, p0, p1, p2);
};

window.N_0xcea7c8e1b48ff68c = function (p0, p1) {
	return _in(0xcea7c8e1, 0xb48ff68c, p0, p1);
};

window.N_0xced08cbe8ebb97c7 = function (p0, p1) {
	return _in(0xced08cbe, 0x8ebb97c7, _fv(p0), _fv(p1));
};

window.N_0xceda60a74219d064 = function (p0, p1) {
	return _in(0xceda60a7, 0x4219d064, p0, p1);
};

window.N_0xcef214315d276fd1 = function (p0) {
	return _in(0xcef21431, 0x5d276fd1, p0);
};

window.N_0xcf1182f682f65307 = function (p0, p1) {
	return _in(0xcf1182f6, 0x82f65307, p0, p1);
};

window.N_0xcf38dafbb49ede5e = function (p0) {
	return _in(0xcf38dafb, 0xb49ede5e, _ii(p0) /* may be optional */, _r);
};

window.N_0xcf61d4b4702ee9eb = function () {
	return _in(0xcf61d4b4, 0x702ee9eb, _r, _ri);
};

window.N_0xcf9159024555488c = function (p0) {
	return _in(0xcf915902, 0x4555488c, p0);
};

window.N_0xcfd115b373c0df63 = function (p0, p1) {
	return _in(0xcfd115b3, 0x73c0df63, p0, _ii(p1) /* may be optional */);
};

/**
 * what does this do?
 */
window.N_0xcfd778e7904c255e = function (vehicle) {
	return _in(0xcfd778e7, 0x904c255e, vehicle);
};

window.N_0xcfeb46dcd7d8d5eb = function (p0) {
	return _in(0xcfeb46dc, 0xd7d8d5eb, p0);
};

window.N_0xcfeb8af24fc1d0bb = function (p0) {
	return _in(0xcfeb8af2, 0x4fc1d0bb, p0);
};

/**
 * Maybe gets gameplay cam near clip?
 */
window.N_0xd0082607100d7193 = function () {
	return _in(0xd0082607, 0x100d7193, _r, _rf);
};

window.N_0xd00d76a7dfc9d852 = function (p0) {
	return _in(0xd00d76a7, 0xdfc9d852, _ii(p0) /* may be optional */);
};

/**
 * Similar to 0xDDC635D5B3262C56. Enable?
 */
window.N_0xd01005d2ba2eb778 = function (p0) {
	return _in(0xd01005d2, 0xba2eb778, _ts(p0));
};

window.N_0xd01015c7316ae176 = function (ped, p1) {
	return _in(0xd01015c7, 0x316ae176, ped, _ts(p1), _r, _ri);
};

window.N_0xd05d1a6c74da3498 = function (p1) {
	return _in(0xd05d1a6c, 0x74da3498, _i, p1, _i, _r);
};

/**
 * x360 Hash: 0xF637166E
 */
window.N_0xd0a484cb2f829fbe = function () {
	return _in(0xd0a484cb, 0x2f829fbe, _r, _ri);
};

window.N_0xd0bc1c6fb18ee154 = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xd0bc1c6f, 0xb18ee154, p0, p1, p2, p3, p4, p5, p6);
};

window.N_0xd0ee05fe193646ea = function () {
	return _in(0xd0ee05fe, 0x193646ea, _i, _i, _i, _r);
};

window.N_0xd10282b6e3751ba0 = function () {
	return _in(0xd10282b6, 0xe3751ba0, _r, _ri);
};

window.N_0xd1032e482629049e = function (p0) {
	return _in(0xd1032e48, 0x2629049e, p0);
};

window.N_0xd10f442036302d50 = function (p0, p1, p2) {
	return _in(0xd10f4420, 0x36302d50, p0, p1, p2);
};

window.N_0xd12882d3ff82bf11 = function () {
	return _in(0xd12882d3, 0xff82bf11);
};

window.N_0xd1871251f3b5acd7 = function (ped) {
	return _in(0xd1871251, 0xf3b5acd7, ped, _r);
};

window.N_0xd1942374085c8469 = function (p0) {
	return _in(0xd1942374, 0x085c8469, p0);
};

window.N_0xd1a1ee3b4fa8e760 = function (p0) {
	return _in(0xd1a1ee3b, 0x4fa8e760, p0);
};

window.N_0xd1b0f412f109ea5d = function (p0, p1) {
	return _in(0xd1b0f412, 0xf109ea5d, p0, p1);
};

/**
 * SET_TV_???
 */
window.N_0xd1c55b110e4df534 = function (p0) {
	return _in(0xd1c55b11, 0x0e4df534, p0);
};

window.N_0xd1c7cb175e012964 = function (scaleformHandle) {
	return _in(0xd1c7cb17, 0x5e012964, scaleformHandle, _r);
};

window.N_0xd1c9b92bdd3f151d = function (p0, p1, p2) {
	return _in(0xd1c9b92b, 0xdd3f151d, p0, p1, p2);
};

window.N_0xd1f8363dfad03848 = function (p0) {
	return _in(0xd1f8363d, 0xfad03848, _fv(p0));
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xd2049635deb9c375 = function () {
	return _in(0xd2049635, 0xdeb9c375);
};

/**
 * "SwitchHUDFranklinOut",
 * "SwitchHUDMichaelOut",
 * "SwitchHUDOut",
 * "SwitchHUDTrevorOut",
 * "SwitchOpenFranklinOut",
 * "SwitchOpenMichaelIn",
 * "SwitchOpenNeutral"
 */
window.N_0xd2209be128b5418c = function (graphicsName) {
	return _in(0xd2209be1, 0x28b5418c, _ts(graphicsName));
};

window.N_0xd2300034310557e4 = function (vehicle, p1) {
	return _in(0xd2300034, 0x310557e4, vehicle, p1);
};

window.N_0xd261ba3e7e998072 = function (p0, p1) {
	return _in(0xd261ba3e, 0x7e998072, p0, _fv(p1));
};

window.N_0xd2936cab8b58fcbd = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0xd2936cab, 0x8b58fcbd, p0, p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6, _fv(p7));
};

/**
 * 1.0.335.2, 1.0.350.1/2, 1.0.372.2, 1.0.393.2, 1.0.393.4, 1.0.463.1;
 */
window.N_0xd2b315b6689d537d = function (player, p1) {
	return _in(0xd2b315b6, 0x689d537d, player, p1);
};

window.N_0xd2b32be3fc1626c6 = function () {
	return _in(0xd2b32be3, 0xfc1626c6);
};

window.N_0xd2cc78cd3d0b50f9 = function (p0, p1) {
	return _in(0xd2cc78cd, 0x3d0b50f9, p0, p1);
};

window.N_0xd2dccd8e16e20997 = function (p0) {
	return _in(0xd2dccd8e, 0x16e20997, p0);
};

window.N_0xd302e99edf0449cf = function (p0) {
	return _in(0xd302e99e, 0xdf0449cf, p0, _r, _ri);
};

window.N_0xd313de83394af134 = function () {
	return _in(0xd313de83, 0x394af134, _r, _ri);
};

window.N_0xd3301660a57c9272 = function (p0) {
	return _in(0xd3301660, 0xa57c9272, p0);
};

window.N_0xd33daa36272177c4 = function (ped) {
	return _in(0xd33daa36, 0x272177c4, ped);
};

window.N_0xd38c4a6d047c019d = function () {
	return _in(0xd38c4a6d, 0x047c019d, _r, _ri);
};

window.N_0xd39b3fff8ffdd5bf = function (p0) {
	return _in(0xd39b3fff, 0x8ffdd5bf, p0, _r, _ri);
};

window.N_0xd39d13c9febf0511 = function (p0) {
	return _in(0xd39d13c9, 0xfebf0511, p0);
};

window.N_0xd3a10fc7fd8d98cd = function () {
	return _in(0xd3a10fc7, 0xfd8d98cd, _r);
};

window.N_0xd3a6a0ef48823a8c = function () {
	return _in(0xd3a6a0ef, 0x48823a8c, _r, _ri);
};

window.N_0xd3e51c0ab8c26eee = function (p0, p1) {
	return _in(0xd3e51c0a, 0xb8c26eee, p0, p1, _r, _ri);
};

/**
 * Decompiled scripts have this listed as `FILES::_GET_NUM_DLC_PED_PROPS_UNK`, but that seems wrong.
 * Has something to do with ped (dlc) helmet props.
 * This native returns 1/true when the player helmet has a visor (there is another prop index for the same helmet with closed/opened visor variant) that can be toggled, 0/false if there's no alternative version with a visor for this helmet prop.
 * So something like `_DOES_HELMET_HASH_HAVE_A_VISOR`, anyone that knows the joaat hash?
 * Decompiled scripts handle this as an int. But the result is always 0 or 1 (after testing every prop hash on freemode peds). So might actually be a bool?
 * ```
 * iVar16 = PED::GET_PED_PROP_INDEX(PLAYER::PLAYER_PED_ID(), 0);
 * iVar17 = PED::GET_PED_PROP_TEXTURE_INDEX(PLAYER::PLAYER_PED_ID(), 0);
 * iVar18 = FILES::GET_HASH_NAME_FOR_PROP(PLAYER::PLAYER_PED_ID(), 0, iVar16, iVar17);
 * if (FILES::_GET_NUM_DLC_PED_PROPS_UNK(iVar18) > 0) // _0xD40AAC51E8E4C663
 * {
 * HUD::BEGIN_TEXT_COMMAND_DISPLAY_HELP("VISOR_TOGGLE");
 * HUD::END_TEXT_COMMAND_DISPLAY_HELP(0, 0, true, 6000);
 * iVar15++;
 * func_12660(7668, iVar15, -1, 1);
 * MISC::SET_BIT(&(Global_2512581.f_1710), 24);
 * }
 * ```
 * @param propHash Ped helmet prop hash
 * @return This native returns 1 when the player helmet has a visor (there is another prop index for the same helmet with closed/opened visor variant) that can be toggled. 0 if there's no alternative version with a visor for this helmet prop.
 */
window.N_0xd40aac51e8e4c663 = function (propHash) {
	return _in(0xd40aac51, 0xe8e4c663, _ch(propHash), _r, _ri);
};

window.N_0xd4196117af7bb974 = function (p0, p1) {
	return _in(0xd4196117, 0xaf7bb974, p0, p1, _r, _ri);
};

window.N_0xd4438c0564490e63 = function () {
	return _in(0xd4438c05, 0x64490e63);
};

window.N_0xd4793dff3af2abcd = function () {
	return _in(0xd4793dff, 0x3af2abcd);
};

/**
 * Only used like this:
 * if (VEHICLE::_D4C4642CB7F50B5D(ENTITY::GET_VEHICLE_INDEX_FROM_ENTITY_INDEX(v_3))) {                                                        sub_157e9c(g_40001._f1868, 0);
 * }
 */
window.N_0xd4c4642cb7f50b5d = function (vehicle) {
	return _in(0xd4c4642c, 0xb7f50b5d, vehicle, _r);
};

window.N_0xd53acdbef24a46e8 = function () {
	return _in(0xd53acdbe, 0xf24a46e8, _r, _ri);
};

window.N_0xd558bec0bba7e8d2 = function (p0, p1, p2, p3, p4) {
	return _in(0xd558bec0, 0xbba7e8d2, p0, p1, p2, p3, p4);
};

window.N_0xd565f438137f0e10 = function (p0, p1) {
	return _in(0xd565f438, 0x137f0e10, p0, p1);
};

window.N_0xd57aaae0e2214d11 = function () {
	return _in(0xd57aaae0, 0xe2214d11);
};

window.N_0xd5a4b59980401588 = function (p0, p1) {
	return _in(0xd5a4b599, 0x80401588, p0, p1, _i, _i, _r);
};

window.N_0xd642319c54aadeb6 = function () {
	return _in(0xd642319c, 0x54aadeb6, _r, _ri);
};

window.N_0xd66c9e72b3cc4982 = function (p1) {
	return _in(0xd66c9e72, 0xb3cc4982, _i, p1, _r, _ri);
};

window.N_0xd6781e42755531f7 = function (p0) {
	return _in(0xd6781e42, 0x755531f7, p0);
};

window.N_0xd68a5ff8a3a89874 = function (r, g, b, a) {
	return _in(0xd68a5ff8, 0xa3a89874, r, g, b, a);
};

/**
 * Something related to the environmental effects natives.
 * In the "agency_heist3b" script, p1 - p3 are always under 100 - usually they are {87, 81, 68}. If SET_PED_ENVEFF_SCALE is set to 0.65 (instead of the usual 1.0), they use {74, 69, 60}
 */
window.N_0xd69411aa0cebf9e9 = function (ped, p1, p2, p3) {
	return _in(0xd69411aa, 0x0cebf9e9, ped, p1, p2, p3);
};

window.N_0xd6ade981781fca09 = function (p0) {
	return _in(0xd6ade981, 0x781fca09, _fv(p0));
};

/**
 * Only one match in the scripts:
 * GRAPHICS::_D7021272EB0A451E("int_carrier_hanger");
 */
window.N_0xd7021272eb0a451e = function (p0) {
	return _in(0xd7021272, 0xeb0a451e, _ts(p0));
};

window.N_0xd7360051c885628b = function () {
	return _in(0xd7360051, 0xc885628b, _r, _ri);
};

window.N_0xd76eeef746057fd6 = function (p0) {
	return _in(0xd76eeef7, 0x46057fd6, p0, _r, _ri);
};

window.N_0xd79185689f8fd5df = function (p0) {
	return _in(0xd7918568, 0x9f8fd5df, p0);
};

window.N_0xd7b6c73cad419bcf = function (p0) {
	return _in(0xd7b6c73c, 0xad419bcf, p0);
};

/**
 * Unloads GROUP_MAP (GTAO/MP) DLC data and loads GROUP_MAP_SP DLC. Neither are loaded by default, 0888C3502DBBEEF5 is a cognate to this function and loads MP DLC (and unloads SP DLC by extension).
 * The original (and wrong) definition is below:
 * This unload the GTA:O DLC map parts (like high end garages/apartments).
 * Works in singleplayer.
 * console hash: 0x8BF60FC3
 */
window.N_0xd7c10c4a637992c9 = function () {
	return _in(0xd7c10c4a, 0x637992c9);
};
window.LoadSpDlcMaps = window.N_0xd7c10c4a637992c9;

window.N_0xd7cccba28c4ecaf0 = function (p0, p1, p2, p3, p4) {
	return _in(0xd7cccba2, 0x8c4ecaf0, p0, p1, p2, p3, p4);
};

window.N_0xd7d0b00177485411 = function (p0, p1) {
	return _in(0xd7d0b001, 0x77485411, p0, _fv(p1));
};

window.N_0xd7d22f5592aed8ba = function (p0) {
	return _in(0xd7d22f55, 0x92aed8ba, p0, _r, _ri);
};

/**
 * 4 matches across 2 scripts.
 * appcamera:
 * called after UI::HIDE_HUD_AND_RADAR_THIS_FRAME() and before GRAPHICS::0x108F36CC();
 * cellphone_controller:
 * called after GRAPHICS::0xE9F2B68F(0, 0) and before GRAPHICS::0x108F36CC();
 */
window.N_0xd801cc02177fa3f1 = function () {
	return _in(0xd801cc02, 0x177fa3f1);
};

window.N_0xd80a80346a45d761 = function (p0) {
	return _in(0xd80a8034, 0x6a45d761, p0, _r, _ri);
};

window.N_0xd8122c407663b995 = function () {
	return _in(0xd8122c40, 0x7663b995, _r, _ri);
};

window.N_0xd81b7f27bc773e66 = function (p0, p1, p2, p3, p4) {
	return _in(0xd81b7f27, 0xbc773e66, p0, p1, p2, p3, p4);
};

window.N_0xd821056b9acf8052 = function (p0, p1) {
	return _in(0xd821056b, 0x9acf8052, p0, p1);
};

window.N_0xd8c3be3ee94caf2d = function (p0, p1, p2, p3, p4) {
	return _in(0xd8c3be3e, 0xe94caf2d, p0, p1, p2, p3, p4);
};

window.N_0xd8e694757bcea8e9 = function () {
	return _in(0xd8e69475, 0x7bcea8e9);
};

window.N_0xd9454b5752c857dc = function () {
	return _in(0xd9454b57, 0x52c857dc);
};

window.N_0xd95cc5d2ab15a09f = function (p0) {
	return _in(0xd95cc5d2, 0xab15a09f, p0, _r, _ri);
};

window.N_0xd99db210089617fe = function (p0, p1, p2) {
	return _in(0xd99db210, 0x089617fe, p0, p1, p2);
};

window.N_0xd9b71952f78a2640 = function (doorHash, p1) {
	return _in(0xd9b71952, 0xf78a2640, _ch(doorHash), p1);
};

window.N_0xd9f692d349249528 = function () {
	return _in(0xd9f692d3, 0x49249528);
};

/**
 * In scripts it's used with a var, that is used elsewhere in a check regarding if the given networkHandle is valid.
 */
window.N_0xda024bdbd600f44a = function (networkHandle) {
	return _in(0xda024bdb, 0xd600f44a, _ii(networkHandle) /* may be optional */);
};

window.N_0xda05194260cdcdf9 = function (p0, p1) {
	return _in(0xda051942, 0x60cdcdf9, p0, p1);
};

window.N_0xda07819e452ffe8f = function (p0) {
	return _in(0xda07819e, 0x452ffe8f, p0);
};

window.N_0xdab963831dbfd3f4 = function (p0, p1, p2, p3, p4) {
	return _in(0xdab96383, 0x1dbfd3f4, p0, p1, p2, p3, p4, _r, _ri);
};

/**
 * Set profile setting 866
 */
window.N_0xdac073c7901f9e15 = function (p0) {
	return _in(0xdac073c7, 0x901f9e15, p0);
};

window.N_0xdaf80797fc534bec = function (p0) {
	return _in(0xdaf80797, 0xfc534bec, p0);
};

window.N_0xdaf87174be7454ff = function (p0) {
	return _in(0xdaf87174, 0xbe7454ff, p0, _r);
};

window.N_0xdb34e8d56fc13b08 = function (p0, p1, p2) {
	return _in(0xdb34e8d5, 0x6fc13b08, p0, p1, p2);
};

window.N_0xdb41d07a45a6d4b7 = function (p0) {
	return _in(0xdb41d07a, 0x45a6d4b7, p0, _r, _ri);
};

window.N_0xdb90c6cca48940f1 = function (p0) {
	return _in(0xdb90c6cc, 0xa48940f1, p0);
};

/**
 * REQUEST_VEHICLE_*
 */
window.N_0xdba3c090e3d74690 = function (vehicle) {
	return _in(0xdba3c090, 0xe3d74690, vehicle);
};

window.N_0xdbaa5ec848ba2d46 = function (p0, p1) {
	return _in(0xdbaa5ec8, 0x48ba2d46, p0, p1);
};

/**
 * Related to locking the vehicle or something similar.
 * In the decompiled scripts, its always called after
 * VEHICLE::_SET_EXCLUSIVE_DRIVER(a_0, 0, 0);
 * VEHICLE::SET_VEHICLE_DOORS_LOCKED_FOR_ALL_PLAYERS(a_0, 1);
 * VEHICLE::SET_VEHICLE_DOORS_LOCKED_FOR_PLAYER(a_0, PLAYER::PLAYER_ID(), 0);
 */
window.N_0xdbc631f109350b8c = function (vehicle, p1) {
	return _in(0xdbc631f1, 0x09350b8c, vehicle, p1);
};

window.N_0xdbc966a01c02bca7 = function (p0, p1, p2) {
	return _in(0xdbc966a0, 0x1c02bca7, p0, p1, p2);
};

/**
 * probably 0x3461981 on console
 */
window.N_0xdc18531d7019a535 = function (p0, p1) {
	return _in(0xdc18531d, 0x7019a535, p0, p1, _r);
};

window.N_0xdc459cfa0cce245b = function (p0) {
	return _in(0xdc459cfa, 0x0cce245b, p0);
};

window.N_0xdc57a637a20006ed = function (p0, p1) {
	return _in(0xdc57a637, 0xa20006ed, p0, p1);
};

/**
 * Has something to do with police.
 */
window.N_0xdc64d2c53493ed12 = function (player) {
	return _in(0xdc64d2c5, 0x3493ed12, player);
};

/**
 * SET_ENTITY_*
 * x360 Hash: 0xA0466A69
 * Only called within 1 script for x360. 'fm_mission_controller' and it used on an object.
 * Ran after these 2 natives,
 * set_object_targettable(uParam0, 0);
 * set_entity_invincible(uParam0, 1);
 */
window.N_0xdc6f8601faf2e893 = function (entity, p1) {
	return _in(0xdc6f8601, 0xfaf2e893, entity, p1);
};

window.N_0xdc9274a7ef6b2867 = function () {
	return _in(0xdc9274a7, 0xef6b2867, _r, _ri);
};

window.N_0xdc9da9e8789f5246 = function () {
	return _in(0xdc9da9e8, 0x789f5246);
};

window.N_0xdcca191df9980fd7 = function (ped) {
	return _in(0xdcca191d, 0xf9980fd7, ped, _r);
};

window.N_0xdce97bdf8a0eabc8 = function () {
	return _in(0xdce97bdf, 0x8a0eabc8, _r, _ri);
};

window.N_0xdd2238f57b977751 = function (p0) {
	return _in(0xdd2238f5, 0x7b977751, p0, _r);
};

/**
 * 2 occurrences in agency_heist3a. p1 was 0.7f then 0.4f.
 */
window.N_0xdd2620b7b9d16ff1 = function (player, p1) {
	return _in(0xdd2620b7, 0xb9d16ff1, player, _fv(p1), _r);
};

/**
 * Tune Backwards... ?
 */
window.N_0xdd6bcf9e94425df9 = function () {
	return _in(0xdd6bcf9e, 0x94425df9);
};

window.N_0xdd79df9f4d26e1c9 = function () {
	return _in(0xdd79df9f, 0x4d26e1c9);
};

/**
 * Similar to 0xD01005D2BA2EB778. Disable?
 */
window.N_0xddc635d5b3262c56 = function (p0) {
	return _in(0xddc635d5, 0xb3262c56, _ts(p0));
};

window.N_0xde03620f8703a9df = function () {
	return _in(0xde03620f, 0x8703a9df, _r, _ri);
};

window.N_0xde45d1a1ef45ee61 = function (player, toggle) {
	return _in(0xde45d1a1, 0xef45ee61, player, toggle);
};
window.SetHudAnimStopLevel = window.N_0xde45d1a1ef45ee61;

window.N_0xde81239437e8c5a8 = function () {
	return _in(0xde812394, 0x37e8c5a8);
};

/**
 * Dr. Underscore (1/6/18):
 * Most references of this native come from the creator scripts. (creator, fm_capture_creator, fm_deathmatch_creator, fm_lts_creator, fm_race_creator).
 * Seems to have something to do with initializing/destroying creator shit.
 */
window.N_0xdea36202fc3382df = function (p0) {
	return _in(0xdea36202, 0xfc3382df, p0);
};

window.N_0xdeaaf77eb3687e97 = function (p0, p1) {
	return _in(0xdeaaf77e, 0xb3687e97, p0, _ii(p1) /* may be optional */, _r, _ri);
};

window.N_0xdeb2b99a1af1a2a6 = function (p0) {
	return _in(0xdeb2b99a, 0x1af1a2a6, p0, _r, _ri);
};

/**
 * Scripts use 0.2, 0.5 and 1.0.
 * SET_DRIVER_*
 */
window.N_0xded5af5a0ea4b297 = function (driver, p1) {
	return _in(0xded5af5a, 0x0ea4b297, driver, _fv(p1));
};

window.N_0xdf4b952f7d381b95 = function () {
	return _in(0xdf4b952f, 0x7d381b95, _r, _ri);
};

window.N_0xdf649c4e9afdd788 = function () {
	return _in(0xdf649c4e, 0x9afdd788, _r, _ri);
};

window.N_0xdf6ca0330f2e737b = function (p0, p1) {
	return _in(0xdf6ca033, 0x0f2e737b, p0, p1);
};

/**
 * Outputs 2 Vector3's.
 * Scripts check if out2.x - out1.x > someshit.x
 * Could be suspension related, as in max suspension height and min suspension height, considering the natives location.
 */
window.N_0xdf7e3eeb29642c38 = function (vehicle) {
	return _in(0xdf7e3eeb, 0x29642c38, vehicle, _v, _v);
};

window.N_0xdf97cdd4fc08fd34 = function (p0) {
	return _in(0xdf97cdd4, 0xfc08fd34, p0, _r);
};

window.N_0xdfa80cb25d0a19b3 = function () {
	return _in(0xdfa80cb2, 0x5d0a19b3, _r, _ri);
};

window.N_0xdffa5be8381c3314 = function () {
	return _in(0xdffa5be8, 0x381c3314, _r, _ri);
};

window.N_0xdffcef48e511db48 = function (p0, p1) {
	return _in(0xdffcef48, 0xe511db48, p0, p1);
};

window.N_0xe0130b41d3cf4574 = function () {
	return _in(0xe0130b41, 0xd3cf4574, _r, _rf);
};

window.N_0xe01903c47c7ac89e = function () {
	return _in(0xe01903c4, 0x7c7ac89e);
};

window.N_0xe058175f8eafe79a = function (p0) {
	return _in(0xe058175f, 0x8eafe79a, p0);
};

window.N_0xe05dd0e9707003a3 = function (p0, p1) {
	return _in(0xe05dd0e9, 0x707003a3, p0, p1);
};

window.N_0xe0a6138401bcb837 = function () {
	return _in(0xe0a61384, 0x01bcb837, _r, _ri);
};

window.N_0xe111a7c0d200cbc5 = function (p0, p1) {
	return _in(0xe111a7c0, 0xd200cbc5, p0, _fv(p1));
};

/**
 * p1 always false.
 */
window.N_0xe12abe5e3a389a6c = function (entity, p1) {
	return _in(0xe12abe5e, 0x3a389a6c, entity, p1);
};

/**
 * This function is hard-coded to always return 1.
 */
window.N_0xe154b48b68ef72bc = function (p0) {
	return _in(0xe154b48b, 0x68ef72bc, p0, _r);
};

window.N_0xe16142b94664defd = function (vehicle, p1) {
	return _in(0xe16142b9, 0x4664defd, vehicle, p1);
};

/**
 * Used with IS_LOOK_INVERTED() and negates its affect.
 * --
 * Not sure how the person above got that description, but here's an actual example:
 * if (CONTROLS::_GET_LAST_INPUT_METHOD(2)) {
 * if (a_5) {
 * if (CONTROLS::IS_LOOK_INVERTED()) {
 * a_3 *= -1;
 * }
 * if (CONTROLS::_E1615EC03B3BB4FD()) {
 * a_3 *= -1;
 * }
 * }
 * }
 */
window.N_0xe1615ec03b3bb4fd = function () {
	return _in(0xe1615ec0, 0x3b3bb4fd, _r);
};

window.N_0xe16aa70ce9beedc3 = function (p0) {
	return _in(0xe16aa70c, 0xe9beedc3, p0, _r, _ri);
};

window.N_0xe1c8709406f2c41c = function () {
	return _in(0xe1c87094, 0x06f2c41c);
};

window.N_0xe1ca84ebf72e691d = function (p0, p1) {
	return _in(0xe1ca84eb, 0xf72e691d, p0, p1, _i, _i, _i);
};

window.N_0xe1cd1e48e025e661 = function () {
	return _in(0xe1cd1e48, 0xe025e661);
};

window.N_0xe23adc6fcb1f29ae = function (p0, p1, p2) {
	return _in(0xe23adc6f, 0xcb1f29ae, p0, p1, p2);
};

window.N_0xe260e0bb9cd995ac = function (p0) {
	return _in(0xe260e0bb, 0x9cd995ac, p0, _r);
};

window.N_0xe266ed23311f24d4 = function (p0, p3, p4, p5) {
	return _in(0xe266ed23, 0x311f24d4, p0, _i, _i, _fv(p3), _fv(p4), p5);
};

window.N_0xe2892e7e55d7073a = function (p0) {
	return _in(0xe2892e7e, 0x55d7073a, _fv(p0));
};

window.N_0xe2f53f172b45ede1 = function () {
	return _in(0xe2f53f17, 0x2b45ede1);
};

window.N_0xe301bd63e9e13cf0 = function (vehicle, cargobob) {
	return _in(0xe301bd63, 0xe9e13cf0, vehicle, cargobob);
};

/**
 * REMOTE_VEHICLE_*
 */
window.N_0xe30524e1871f481d = function (p0) {
	return _in(0xe30524e1, 0x871f481d, p0);
};

window.N_0xe3261d791eb44acb = function (p0) {
	return _in(0xe3261d79, 0x1eb44acb, p0);
};

/**
 * IS_*
 */
window.N_0xe33ffa906ce74880 = function (vehicle, p1) {
	return _in(0xe33ffa90, 0x6ce74880, vehicle, p1, _r);
};

window.N_0xe35b38a27e8e7179 = function (p0) {
	return _in(0xe35b38a2, 0x7e8e7179, p0, _r, _ri);
};

window.N_0xe36a98d8ab3d3c66 = function (p0) {
	return _in(0xe36a98d8, 0xab3d3c66, p0);
};

/**
 * UI::GET_CURRENT_WEBSITE_PAGE_ID(int websiteID)
 * returns the current website page sometimes returns false
 */
window.N_0xe3b05614dce1d014 = function (p0) {
	return _in(0xe3b05614, 0xdce1d014, p0, _r, _ri);
};

/**
 * sets something to 1
 */
window.N_0xe3d969d2785ffb5e = function () {
	return _in(0xe3d969d2, 0x785ffb5e);
};

/**
 * Sets an unknown value related to timecycles.
 */
window.N_0xe3e2c1b4c59dbc77 = function (unk) {
	return _in(0xe3e2c1b4, 0xc59dbc77, unk);
};

window.N_0xe3e5a7c64ca2c6ed = function () {
	return _in(0xe3e5a7c6, 0x4ca2c6ed, _r, _ri);
};

/**
 * No observed effect.
 */
window.N_0xe3ebaae484798530 = function (vehicle, p1) {
	return _in(0xe3ebaae4, 0x84798530, vehicle, p1);
};

window.N_0xe43a13c9e4cccbcf = function (ped, p1) {
	return _in(0xe43a13c9, 0xe4cccbcf, ped, p1);
};

window.N_0xe44a982368a4af23 = function (vehicle, vehicle2) {
	return _in(0xe44a9823, 0x68a4af23, vehicle, vehicle2);
};

window.N_0xe4723db6e736ccff = function (ped, p1, p2, p3, p4, p5, p6) {
	return _in(0xe4723db6, 0xe736ccff, ped, p1, _fv(p2), _fv(p3), _fv(p4), _fv(p5), p6);
};

window.N_0xe496a53ba5f50a56 = function (p0) {
	return _in(0xe496a53b, 0xa5f50a56, p0, _r, _ri);
};

window.N_0xe4dcec7fd5b739a5 = function (ped) {
	return _in(0xe4dcec7f, 0xd5b739a5, ped);
};

window.N_0xe4e2fd323574965c = function (p0, p1) {
	return _in(0xe4e2fd32, 0x3574965c, p0, p1);
};

window.N_0xe4e6dd5566d28c82 = function () {
	return _in(0xe4e6dd55, 0x66d28c82);
};

window.N_0xe532ec1a63231b4f = function (p0, p1) {
	return _in(0xe532ec1a, 0x63231b4f, p0, p1);
};

window.N_0xe547e9114277098f = function () {
	return _in(0xe547e911, 0x4277098f, _r, _ri);
};

window.N_0xe574a662acaefbb1 = function () {
	return _in(0xe574a662, 0xacaefbb1);
};

window.N_0xe5810ac70602f2f5 = function (vehicle, p1) {
	return _in(0xe5810ac7, 0x0602f2f5, vehicle, _fv(p1));
};

window.N_0xe59343e9e96529e7 = function () {
	return _in(0xe59343e9, 0xe96529e7, _r, _ri);
};

window.N_0xe620fd3512a04f18 = function (p0) {
	return _in(0xe620fd35, 0x12a04f18, _fv(p0));
};

window.N_0xe63d7c6eececb66b = function (p0) {
	return _in(0xe63d7c6e, 0xececb66b, p0);
};

window.N_0xe64a3ca08dfa37a9 = function (p0) {
	return _in(0xe64a3ca0, 0x8dfa37a9, p0, _r);
};

window.N_0xe66c690248f11150 = function (p0, p1) {
	return _in(0xe66c6902, 0x48f11150, p0, p1);
};

window.N_0xe6717e652b8c8d8a = function (p0, p1) {
	return _in(0xe6717e65, 0x2b8c8d8a, p0, p1);
};

window.N_0xe67c6dfd386ea5e7 = function (p0) {
	return _in(0xe67c6dfd, 0x386ea5e7, p0);
};

window.N_0xe6869becdd8f2403 = function (p0, p1) {
	return _in(0xe6869bec, 0xdd8f2403, p0, p1);
};

window.N_0xe6a9f00d4240b519 = function (p0, p1) {
	return _in(0xe6a9f00d, 0x4240b519, p0, p1);
};

/**
 * GET_VEHICLE_*
 */
window.N_0xe6b0e8cfc3633bf0 = function (vehicle) {
	return _in(0xe6b0e8cf, 0xc3633bf0, vehicle, _r, _ri);
};

window.N_0xe6c0c80b8c867537 = function (p0) {
	return _in(0xe6c0c80b, 0x8c867537, p0);
};

window.N_0xe6ca85e7259ce16b = function (p0) {
	return _in(0xe6ca85e7, 0x259ce16b, p0);
};

window.N_0xe6de0561d9232a64 = function () {
	return _in(0xe6de0561, 0xd9232a64);
};

window.N_0xe6f13851780394da = function (vehicle, p1) {
	return _in(0xe6f13851, 0x780394da, vehicle, _fv(p1));
};

window.N_0xe70ba7b90f8390dc = function (p0, p1, p2, p3) {
	return _in(0xe70ba7b9, 0x0f8390dc, p0, p1, p2, p3);
};

window.N_0xe73364db90778ffa = function () {
	return _in(0xe73364db, 0x90778ffa, _r, _ri);
};

/**
 * This function is hard-coded to always return 0.
 */
window.N_0xe791df1f73ed2c8b = function (p0) {
	return _in(0xe791df1f, 0x73ed2c8b, p0, _r, _ri);
};

window.N_0xe7df4e0545dfb56e = function (p0, p1, p2) {
	return _in(0xe7df4e05, 0x45dfb56e, p0, p1, p2);
};

window.N_0xe7e4c198b0185900 = function (p0, p1, p2) {
	return _in(0xe7e4c198, 0xb0185900, p0, p1, p2);
};

window.N_0xe82728f0de75d13a = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24) {
	return _in(0xe82728f0, 0xde75d13a, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24);
};

window.N_0xe827b9382cfb41ba = function (p0, p1, p2, p3) {
	return _in(0xe827b938, 0x2cfb41ba, p0, p1, p2, p3);
};

/**
 * Vehicle must be a boat.
 */
window.N_0xe842a9398079bd82 = function (vehicle, p1) {
	return _in(0xe842a939, 0x8079bd82, vehicle, _fv(p1));
};

window.N_0xe84eb93729c5f36a = function (p0) {
	return _in(0xe84eb937, 0x29c5f36a, p0, _r, _ri);
};

window.N_0xe851e480b814d4ba = function (vehicle, p1) {
	return _in(0xe851e480, 0xb814d4ba, vehicle, p1);
};

window.N_0xe861d0b05c7662b8 = function (p0, p1, p2) {
	return _in(0xe861d0b0, 0x5c7662b8, p0, p1, _ii(p2) /* may be optional */);
};

window.N_0xe8853fbce7d8d0d6 = function () {
	return _in(0xe8853fbc, 0xe7d8d0d6, _r, _ri);
};

window.N_0xe8a169e666cbc541 = function () {
	return _in(0xe8a169e6, 0x66cbc541, _r, _ri);
};

window.N_0xe8b0b270b6e7c76e = function (p0, p1, p2, p3) {
	return _in(0xe8b0b270, 0xb6e7c76e, p0, p1, p2, p3);
};

window.N_0xe8b9c0ec9e183f35 = function () {
	return _in(0xe8b9c0ec, 0x9e183f35, _r);
};

window.N_0xe906ec930f5fe7c8 = function (p0, p1) {
	return _in(0xe906ec93, 0x0f5fe7c8, p0, p1);
};

window.N_0xe95b0c7d5ba3b96b = function (p0) {
	return _in(0xe95b0c7d, 0x5ba3b96b, p0, _r);
};

window.N_0xe95c8a1875a02ca4 = function (p0, p1, p2) {
	return _in(0xe95c8a18, 0x75a02ca4, p0, p1, p2);
};

window.N_0xe9b99b6853181409 = function () {
	return _in(0xe9b99b68, 0x53181409);
};

window.N_0xe9ea16d6e54cdca4 = function (p0, p1) {
	return _in(0xe9ea16d6, 0xe54cdca4, p0, p1, _r, _ri);
};

window.N_0xea14eef5b7cd2c30 = function () {
	return _in(0xea14eef5, 0xb7cd2c30, _r, _ri);
};

window.N_0xea2f2061875eed90 = function () {
	return _in(0xea2f2061, 0x875eed90, _r, _ri);
};

window.N_0xea9960d07dadcf10 = function (p0) {
	return _in(0xea9960d0, 0x7dadcf10, p0, _r, _ri);
};

window.N_0xeaf0fa793d05c592 = function () {
	return _in(0xeaf0fa79, 0x3d05c592, _r, _ri);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xeb078ca2b5e82add = function (p0, p1) {
	return _in(0xeb078ca2, 0xb5e82add, p0, p1);
};

window.N_0xeb2104e905c6f2e9 = function () {
	return _in(0xeb2104e9, 0x05c6f2e9, _r, _ri);
};

window.N_0xeb2bf817463dfa28 = function (p0, p1) {
	return _in(0xeb2bf817, 0x463dfa28, p0, p1, _r, _ri);
};

window.N_0xeb3dac2c86001e5e = function () {
	return _in(0xeb3dac2c, 0x86001e5e, _r);
};

window.N_0xeb6f1a9b5510a5d2 = function (p0, p1) {
	return _in(0xeb6f1a9b, 0x5510a5d2, p0, p1);
};

window.N_0xebb376779a760aa8 = function () {
	return _in(0xebb37677, 0x9a760aa8, _r, _ri);
};

/**
 * MulleDK19: This function is hard-coded to always return 1.
 */
window.N_0xebcab9e5048434f4 = function () {
	return _in(0xebcab9e5, 0x048434f4, _r, _ri);
};

window.N_0xebd0edba5be957cf = function (ped) {
	return _in(0xebd0edba, 0x5be957cf, ped, _r);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.N_0xebd3205a207939ed = function (p0) {
	return _in(0xebd3205a, 0x207939ed, _ii(p0) /* may be optional */);
};

/**
 * example from scripts:
 * unk_0xE0C28DB5(0,Global_2398291.imm_726,1);
 * that global is for ps3/xbox not pc
 * no idea what this does does
 */
window.N_0xebefc2e77084f599 = function (p0, p1, p2) {
	return _in(0xebefc2e7, 0x7084f599, p0, _ts(p1), p2);
};

window.N_0xebf8284d8cadeb53 = function () {
	return _in(0xebf8284d, 0x8cadeb53);
};

window.N_0xebfa8d50addc54c4 = function (p0) {
	return _in(0xebfa8d50, 0xaddc54c4, p0, _r);
};

/**
 * SET_PED_*
 * Has most likely to do with some shooting attributes as it sets the float which is in the same range as shootRate.
 */
window.N_0xec4b4b3b9908052a = function (ped, unk) {
	return _in(0xec4b4b3b, 0x9908052a, ped, _fv(unk));
};

/**
 * _push_scaleform_movie_function(iLocal_117, "SET_TEXT");
 * if (bParam0)
 * {
 * _0xEC52C631A1831C03(2);
 * }
 * else
 * {
 * _0xEC52C631A1831C03(1);
 * }
 * _pop_scaleform_movie_function_void();
 */
window.N_0xec52c631a1831c03 = function (p0) {
	return _in(0xec52c631, 0xa1831c03, p0);
};

window.N_0xec6935ebe0847b90 = function (p0, p1, p2, p3) {
	return _in(0xec6935eb, 0xe0847b90, p0, p1, p2, p3, _r, _ri);
};

/**
 * This function is hard-coded to always return 0.
 */
window.N_0xec72c258667be5ea = function (p0) {
	return _in(0xec72c258, 0x667be5ea, p0, _r, _ri);
};

/**
 * Disables frontend (works in custom frontends, not sure about regular pause menu) navigation keys on keyboard. Not sure about controller. Does not disable mouse controls. No need to call this every tick.
 * To enable the keys again, use [`0x14621BB1DF14E2B2`](#_0x14621BB1DF14E2B2).
 */
window.N_0xec9264727eec0f28 = function () {
	return _in(0xec926472, 0x7eec0f28);
};

window.N_0xeca658ce2a4e5a72 = function (p0, p1) {
	return _in(0xeca658ce, 0x2a4e5a72, p0, p1);
};

window.N_0xecb41ac6ab754401 = function () {
	return _in(0xecb41ac6, 0xab754401, _r);
};

window.N_0xecdc202b25e5cf48 = function (player, p1, p2) {
	return _in(0xecdc202b, 0x25e5cf48, player, p1, p2);
};

window.N_0xed3c76adfa6d07c4 = function (ped) {
	return _in(0xed3c76ad, 0xfa6d07c4, ped);
};

window.N_0xed5ede9e676643c9 = function (p0, p1) {
	return _in(0xed5ede9e, 0x676643c9, p0, p1);
};

window.N_0xed5fd7af10f5e262 = function (p0, p1, p2, p3) {
	return _in(0xed5fd7af, 0x10f5e262, p0, p1, p2, p3);
};

window.N_0xed6d8e27a43b8cde = function (p0) {
	return _in(0xed6d8e27, 0xa43b8cde, p0, _r);
};

window.N_0xed8286f71a819baa = function (cargobob, p1) {
	return _in(0xed8286f7, 0x1a819baa, cargobob, _fv(p1));
};

window.N_0xedbc8405b3895cc9 = function (p0, p1) {
	return _in(0xedbc8405, 0xb3895cc9, p0, p1);
};

window.N_0xedbf6c9b0d2c65c8 = function (p0) {
	return _in(0xedbf6c9b, 0x0d2c65c8, p0);
};

window.N_0xedead9a91ec768b3 = function (p0, p1, p2) {
	return _in(0xedead9a9, 0x1ec768b3, p0, p1, p2);
};

window.N_0xedf7f927136c224b = function () {
	return _in(0xedf7f927, 0x136c224b, _r, _ri);
};

window.N_0xee066c7006c49c0a = function (p0, p1, p2) {
	return _in(0xee066c70, 0x06c49c0a, p0, p1, _ii(p2) /* may be optional */);
};

/**
 * Hides the hud element displayed by _0x523A590C1A3CC0D3
 */
window.N_0xee4c0e6dbc6f2c6f = function () {
	return _in(0xee4c0e6d, 0xbc6f2c6f);
};

/**
 * interprets the result of CAM::_0x19CAFA3C87F7C2FF()
 * example: // checks if you're currently in first person
 * if ((CAM::_EE778F8C7E1142E2(CAM::_19CAFA3C87F7C2FF()) == 4) && (!__463_$28ED382849B17AFC())) {
 * UI::_FDEC055AB549E328();
 * UI::_SET_NOTIFICATION_TEXT_ENTRY("REC_FEED_WAR");
 * l_CE[0 -- [[1]] ] = UI::_DRAW_NOTIFICATION(0, 1);
 * }
 */
window.N_0xee778f8c7e1142e2 = function (p0) {
	return _in(0xee778f8c, 0x7e1142e2, p0, _r, _ri);
};

/**
 * Some kind of flags.
 */
window.N_0xeebfc7a7efdc35b4 = function (vehicle) {
	return _in(0xeebfc7a7, 0xefdc35b4, vehicle, _r, _ri);
};

window.N_0xeeed8fafec331a70 = function (p0, p1, p2, p3) {
	return _in(0xeeed8faf, 0xec331a70, p0, p1, p2, p3, _r, _ri);
};

/**
 * dont know what this native does but im storing some documentation here
 * _NETWORK_VOICE_CONNECT_TO_PLAYER
 * _NETWORK_GET_GAMER_STATUS
 * _NETWORK_HAS_TRANSITION_INVITE_BEEN_ACKED
 * _NETWORK_SEND_PRESENCE_INVITE
 * _NETWORK_SEND_PRESENCE_TRANSITION_INVITE
 * _NETWORK_CHECK_DATA_MANAGER_SUCCEEDED_FOR_HANDLE
 * _NETWORK_CHECK_DATA_MANAGER_FOR_HANDLE
 * _NETWORK_CAN_COMMUNICATE_WITH_GAMER
 * _NETWORK_CRC_HASH_CHECK_EVENT
 */
window.N_0xef0912ddf7c4cb4b = function () {
	return _in(0xef0912dd, 0xf7c4cb4b, _r);
};

window.N_0xef398beee4ef45f9 = function (p0) {
	return _in(0xef398bee, 0xe4ef45f9, p0);
};

window.N_0xef39ee20c537e98c = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xef39ee20, 0xc537e98c, p0, p1, p2, p3, p4, p5);
};

window.N_0xef7d17bc6c85264c = function () {
	return _in(0xef7d17bc, 0x6c85264c, _r);
};

window.N_0xefabc7722293da7c = function () {
	return _in(0xefabc772, 0x2293da7c);
};

window.N_0xefb55e7c25d3b3be = function () {
	return _in(0xefb55e7c, 0x25d3b3be);
};

window.N_0xefc13b1ce30d755d = function (p0, p1) {
	return _in(0xefc13b1c, 0xe30d755d, p0, p1);
};

window.N_0xefd79fa81dfba9cb = function (p0, p1) {
	return _in(0xefd79fa8, 0x1dfba9cb, p0, p1);
};

window.N_0xefd97ff47b745b8d = function (p0) {
	return _in(0xefd97ff4, 0x7b745b8d, p0);
};

window.N_0xeff296097ff1e509 = function (p0, p1) {
	return _in(0xeff29609, 0x7ff1e509, p0, p1);
};

window.N_0xf033419d1b81fae8 = function (p0) {
	return _in(0xf033419d, 0x1b81fae8, p0, _r, _ri);
};

window.N_0xf03755696450470c = function () {
	return _in(0xf0375569, 0x6450470c);
};

window.N_0xf051d9bfb6ba39c0 = function (p0) {
	return _in(0xf051d9bf, 0xb6ba39c0, p0);
};

window.N_0xf06a16ca55d138d8 = function (p0, p1) {
	return _in(0xf06a16ca, 0x55d138d8, p0, p1);
};

window.N_0xf06a6f41cb445443 = function (p0) {
	return _in(0xf06a6f41, 0xcb445443, p0);
};

window.N_0xf06ebb91a81e09e3 = function (p0) {
	return _in(0xf06ebb91, 0xa81e09e3, p0);
};

window.N_0xf083835b70ba9bfe = function () {
	return _in(0xf083835b, 0x70ba9bfe);
};

window.N_0xf086ad9354fac3a3 = function (p0) {
	return _in(0xf086ad93, 0x54fac3a3, p0);
};

window.N_0xf0a60040be558f2d = function (p0, p1, p2) {
	return _in(0xf0a60040, 0xbe558f2d, p0, p1, p2, _r, _ri);
};

window.N_0xf0daef2f545bee25 = function (p0) {
	return _in(0xf0daef2f, 0x545bee25, p0, _r);
};

/**
 * Adds some kind of shadow to the vehicle.
 */
window.N_0xf0e4ba16d1db546c = function (vehicle, p1, p2) {
	return _in(0xf0e4ba16, 0xd1db546c, vehicle, p1, p2);
};

/**
 * IS_OBJECT_???
 */
window.N_0xf0eed5a6bc7b237a = function (p0, entity, p2) {
	return _in(0xf0eed5a6, 0xbc7b237a, p0, entity, p2, _r);
};

window.N_0xf0f2103efaf8cba7 = function (p0, p1) {
	return _in(0xf0f2103e, 0xfaf8cba7, p0, _fv(p1), _r, _rv);
};

/**
 * Only 1 occurrence. p1 was 2.
 */
window.N_0xf10b44fd479d69f3 = function (player, p1) {
	return _in(0xf10b44fd, 0x479d69f3, player, p1, _r);
};

window.N_0xf11f01d98113536a = function (p0) {
	return _in(0xf11f01d9, 0x8113536a, p0, _r, _ri);
};

window.N_0xf12e33034d887f66 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xf12e3303, 0x4d887f66, p0, p1, p2, p3, p4, p5, _r, _ri);
};

window.N_0xf12e6cd06c73d69e = function () {
	return _in(0xf12e6cd0, 0x6c73d69e, _r, _ri);
};

window.N_0xf13fe2a80c05c561 = function () {
	return _in(0xf13fe2a8, 0x0c05c561, _r, _ri);
};

window.N_0xf154b8d1775b2dec = function (p0) {
	return _in(0xf154b8d1, 0x775b2dec, p0);
};

/**
 * Sets profile setting 933
 */
window.N_0xf1a1803d3476f215 = function (value) {
	return _in(0xf1a1803d, 0x3476f215, value);
};

window.N_0xf1a6c18b35bcade6 = function (p0) {
	return _in(0xf1a6c18b, 0x35bcade6, p0);
};

/**
 * LEADERBOARDS2_READ_BY_???
 */
window.N_0xf1ae5dcdbfca2721 = function () {
	return _in(0xf1ae5dcd, 0xbfca2721, _i, _i, _i, _r);
};

window.N_0xf1b84178f8674195 = function (p0) {
	return _in(0xf1b84178, 0xf8674195, p0);
};

window.N_0xf1c03a5352243a30 = function (p0) {
	return _in(0xf1c03a53, 0x52243a30, p0);
};

window.N_0xf1cea8a4198d8e9a = function (p0) {
	return _in(0xf1cea8a4, 0x198d8e9a, _ts(p0), _r);
};

window.N_0xf1e22dc13f5eebad = function (p0) {
	return _in(0xf1e22dc1, 0x3f5eebad, _fv(p0));
};

window.N_0xf1eea2dda9ffa69d = function (p0) {
	return _in(0xf1eea2dd, 0xa9ffa69d, p0);
};

/**
 * 2 calls found in the b617d scripts:
 * AUDIO::_F1F8157B8C3F171C(l_A42, "Franklin_Bike_Rev", "BIG_SCORE_3A_SOUNDS");
 * AUDIO::_F1F8157B8C3F171C(l_166, "Trevor_Revs_Off", "PALETO_SCORE_SETUP_SOUNDS");
 */
window.N_0xf1f8157b8c3f171c = function (p0, p1, p2) {
	return _in(0xf1f8157b, 0x8c3f171c, p0, _ts(p1), _ts(p2));
};

window.N_0xf22ca0fd74b80e7a = function (p0) {
	return _in(0xf22ca0fd, 0x74b80e7a, p0, _r);
};

window.N_0xf2385935bffd4d92 = function (p0) {
	return _in(0xf2385935, 0xbffd4d92, p0, _r);
};

window.N_0xf239400e16c23e08 = function (p0, p1) {
	return _in(0xf239400e, 0x16c23e08, p0, p1);
};

window.N_0xf25e02cb9c5818f8 = function () {
	return _in(0xf25e02cb, 0x9c5818f8);
};

window.N_0xf284ac67940c6812 = function () {
	return _in(0xf284ac67, 0x940c6812, _r, _ri);
};

window.N_0xf287f506767cc8a9 = function () {
	return _in(0xf287f506, 0x767cc8a9, _r, _ri);
};

/**
 * toggle was always 0 except in one instance (b678).
 * The one time this is set to true seems to do with when you fail the mission.
 */
window.N_0xf2bebcdfafdaa19e = function (toggle) {
	return _in(0xf2bebcdf, 0xafdaa19e, toggle);
};

/**
 * MulleDK19: This function is hard-coded to always return 0.
 */
window.N_0xf2ca003f167e21d2 = function () {
	return _in(0xf2ca003f, 0x167e21d2, _r, _ri);
};
window.ReturnZero = window.N_0xf2ca003f167e21d2;

/**
 * MulleDK19: This function is hard-coded to always return 1.
 */
window.N_0xf2e07819ef1a5289 = function () {
	return _in(0xf2e07819, 0xef1a5289, _r);
};

window.N_0xf2e1a7133dd356a6 = function (hash, toggle) {
	return _in(0xf2e1a713, 0x3dd356a6, _ch(hash), toggle);
};

window.N_0xf2eac213d5ea0623 = function () {
	return _in(0xf2eac213, 0xd5ea0623, _r, _ri);
};

window.N_0xf2f6a2fa49278625 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0xf2f6a2fa, 0x49278625, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), _i, _i, _i, _i);
};

window.N_0xf3162836c28f9da5 = function (p0, p1, p2, p3) {
	return _in(0xf3162836, 0xc28f9da5, p0, p1, p2, p3, _r, _ri);
};

window.N_0xf3365489e0dd50f9 = function (p0, p1) {
	return _in(0xf3365489, 0xe0dd50f9, p0, p1);
};

window.N_0xf3b0e0aed097a3f5 = function (p0, p1) {
	return _in(0xf3b0e0ae, 0xd097a3f5, p0, p1, _r, _ri);
};

/**
 * characters
 * 0: Michael
 * 1: Franklin
 * 2: Trevor
 * 3: MPMale
 * 4: MPFemale
 */
window.N_0xf3fbe2d50a6a8c28 = function (character, p1) {
	return _in(0xf3fbe2d5, 0x0a6a8c28, character, p1, _r, _ri);
};

window.N_0xf41b5d290c99a3d6 = function (p0) {
	return _in(0xf41b5d29, 0x0c99a3d6, p0, _r);
};

window.N_0xf434a10ba01c37d0 = function (p0) {
	return _in(0xf434a10b, 0xa01c37d0, p0);
};

window.N_0xf445de8da80a1792 = function () {
	return _in(0xf445de8d, 0xa80a1792, _r, _ri);
};

/**
 * Another function related to "HUD scaleforms"
 */
window.N_0xf44a5456ac3f4f97 = function (p0) {
	return _in(0xf44a5456, 0xac3f4f97, p0);
};

/**
 * bufferSize is 35 in the scripts.
 */
window.N_0xf45352426ff3a4f0 = function (bufferSize) {
	return _in(0xf4535242, 0x6ff3a4f0, _i, bufferSize, _i);
};

window.N_0xf46a1e03e8755980 = function (p0) {
	return _in(0xf46a1e03, 0xe8755980, p0);
};

window.N_0xf47e567b3630dd12 = function (p0, p1) {
	return _in(0xf47e567b, 0x3630dd12, p0, p1);
};

window.N_0xf488c566413b4232 = function (p0, p1) {
	return _in(0xf488c566, 0x413b4232, p0, _fv(p1));
};

window.N_0xf49abc20d8552257 = function (p0) {
	return _in(0xf49abc20, 0xd8552257, p0);
};

window.N_0xf4a0dadb70f57fa6 = function () {
	return _in(0xf4a0dadb, 0x70f57fa6);
};

/**
 * Something to do with shake:
 * CAM::_F4C8CF9E353AFECA("HAND_SHAKE", 0.2);
 */
window.N_0xf4c8cf9e353afeca = function (p0, p1) {
	return _in(0xf4c8cf9e, 0x353afeca, _ts(p0), _fv(p1));
};

/**
 * Needs more research. Possibly used to calculate the "mask" when calling "STAT_SET_BOOL_MASKED"?
 */
window.N_0xf4d8e7ac2a27758c = function (p0) {
	return _in(0xf4d8e7ac, 0x2a27758c, p0, _r, _ri);
};

window.N_0xf4f2c0d4ee209e20 = function () {
	return _in(0xf4f2c0d4, 0xee209e20);
};

window.N_0xf4ff020a08bc8863 = function (p0, p1) {
	return _in(0xf4ff020a, 0x08bc8863, p0, p1);
};

/**
 * This does not move an existing checkpoint... so wtf.
 */
window.N_0xf51d36185993515d = function (checkpoint, posX, posY, posZ, unkX, unkY, unkZ) {
	return _in(0xf51d3618, 0x5993515d, checkpoint, _fv(posX), _fv(posY), _fv(posZ), _fv(unkX), _fv(unkY), _fv(unkZ));
};

window.N_0xf534d94dfa2ead26 = function (p0, p1, p2, p3, p4) {
	return _in(0xf534d94d, 0xfa2ead26, p0, p1, p2, p3, p4);
};

window.N_0xf53e48461b71eecb = function (p0) {
	return _in(0xf53e4846, 0x1b71eecb, p0, _r);
};

window.N_0xf55e4046f6f831dc = function (p0, p1) {
	return _in(0xf55e4046, 0xf6f831dc, p0, _fv(p1));
};

window.N_0xf56dfb7b61be7276 = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12) {
	return _in(0xf56dfb7b, 0x61be7276, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7), _fv(p8), _fv(p9), _fv(p10), _fv(p11), _ii(p12) /* may be optional */, _r);
};

window.N_0xf5846edb26a98a24 = function (ped, p1) {
	return _in(0xf5846edb, 0x26a98a24, ped, p1);
};

window.N_0xf5bb8dac426a52c0 = function () {
	return _in(0xf5bb8dac, 0x426a52c0, _i, _i, _i, _i);
};

/**
 * 3 matches across 3 scripts. First 2 were 0, 3rd was 1. Possibly a bool.
 * appcamera, appmedia, and cellphone_controller.
 */
window.N_0xf5bed327cea362b1 = function (p0) {
	return _in(0xf5bed327, 0xcea362b1, p0, _r, _ri);
};

window.N_0xf60165e1d2c5370b = function (ped) {
	return _in(0xf60165e1, 0xd2c5370b, ped, _i, _i, _r);
};

/**
 * Set profile setting 501
 */
window.N_0xf6792800ac95350d = function (p0) {
	return _in(0xf6792800, 0xac95350d, p0);
};

window.N_0xf6baaaf762e1bf40 = function (p0, p1) {
	return _in(0xf6baaaf7, 0x62e1bf40, _ts(p0), _ii(p1) /* may be optional */, _r);
};

window.N_0xf6f4383b7c92f11a = function (p0) {
	return _in(0xf6f4383b, 0x7c92f11a, p0);
};

window.N_0xf70efa14fe091429 = function (p0) {
	return _in(0xf70efa14, 0xfe091429, p0, _r, _ri);
};

window.N_0xf751b16fb32abc1d = function (p0) {
	return _in(0xf751b16f, 0xb32abc1d, _fv(p0));
};

window.N_0xf78b803082d4386f = function (p0) {
	return _in(0xf78b8030, 0x82d4386f, _fv(p0));
};

window.N_0xf78f94d60248c737 = function (p0, p1) {
	return _in(0xf78f94d6, 0x0248c737, p0, p1, _r);
};

window.N_0xf79f9def0aade61a = function (ped) {
	return _in(0xf79f9def, 0x0aade61a, ped);
};

/**
 * Only did a quick disassembly, but this function seems to load all path nodes in the given area. Parameters appear to be start x, start y, end x, end y.
 */
window.N_0xf7b79a50b905a30d = function (p0, p1, p2, p3) {
	return _in(0xf7b79a50, 0xb905a30d, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _r);
};

/**
 * IS_S*
 */
window.N_0xf7f203e31f96f6a1 = function (vehicle, flag) {
	return _in(0xf7f203e3, 0x1f96f6a1, vehicle, flag, _r);
};

window.N_0xf814fec6a19fd6e0 = function () {
	return _in(0xf814fec6, 0xa19fd6e0);
};

window.N_0xf8155a7f03ddfc8e = function (p0) {
	return _in(0xf8155a7f, 0x03ddfc8e, p0);
};

window.N_0xf854439efbb3b583 = function () {
	return _in(0xf854439e, 0xfbb3b583);
};

window.N_0xf87d9f2301f7d206 = function (p0) {
	return _in(0xf87d9f23, 0x01f7d206, p0);
};

window.N_0xf8bdbf3d573049a1 = function (p0) {
	return _in(0xf8bdbf3d, 0x573049a1, _fv(p0));
};

window.N_0xf8c54a461c3e11dc = function () {
	return _in(0xf8c54a46, 0x1c3e11dc, _i, _i, _i, _i);
};

window.N_0xf8cc1ebe0b62e29f = function (p0) {
	return _in(0xf8cc1ebe, 0x0b62e29f, p0, _r);
};

window.N_0xf8ebccc96adb9fb7 = function (p0, p1, p2) {
	return _in(0xf8ebccc9, 0x6adb9fb7, p0, _fv(p1), p2);
};

window.N_0xf92099527db8e2a7 = function (p0, p1) {
	return _in(0xf9209952, 0x7db8e2a7, p0, p1);
};

window.N_0xf98dde0a8ed09323 = function (p0) {
	return _in(0xf98dde0a, 0x8ed09323, p0);
};

window.N_0xf98e4b3e56afc7b1 = function (p0, p1) {
	return _in(0xf98e4b3e, 0x56afc7b1, p0, _fv(p1));
};

/**
 * p1 was always 1 (true).
 * Kicks the ped from the current vehicle and keeps the rendering-focus on this ped (also disables its collision). If doing this for your player ped, you'll still be able to drive the vehicle.
 * Actual name begins with 'S'
 */
window.N_0xf9acf4a08098ea25 = function (ped, p1) {
	return _in(0xf9acf4a0, 0x8098ea25, ped, p1);
};

window.N_0xf9b83b77929d8863 = function () {
	return _in(0xf9b83b77, 0x929d8863, _r, _ri);
};

window.N_0xf9c1681347c8bd15 = function (object) {
	return _in(0xf9c16813, 0x47c8bd15, object);
};

window.N_0xf9e1ccae8ba4c281 = function (p0, p1) {
	return _in(0xf9e1ccae, 0x8ba4c281, p0, p1, _i, _i, _r);
};

window.N_0xf9f2922717b819ec = function () {
	return _in(0xf9f29227, 0x17b819ec, _r, _ri);
};

window.N_0xfa07759e6fddd7cf = function (p0, p1, p2, p3) {
	return _in(0xfa07759e, 0x6fddd7cf, p0, p1, p2, p3);
};

window.N_0xfa1e0e893d915215 = function (p0) {
	return _in(0xfa1e0e89, 0x3d915215, p0);
};

window.N_0xfa2888e3833c8e96 = function () {
	return _in(0xfa2888e3, 0x833c8e96);
};

/**
 * Another unknown label type...
 * GAMEPLAY::_FAA457EF263E8763(a_0, "Thumb_label");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f10, "Photo_label");
 * GAMEPLAY::_FAA457EF263E8763(a_0, "GXTlabel");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f21, "StringComp");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f43, "SecondStringComp");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f53, "ThirdStringComp");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f32, "SenderStringComp");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f726[v_1A -- [[16]] ], &v_20); // where v_20 is "LastJobTL_0_1" thru "LastJobTL_2_1", gets saved in a struct called "LAST_JobGamer_TL"
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f4B, "PAID_PLAYER");
 * GAMEPLAY::_FAA457EF263E8763(&a_0._f5B, "RADIO_STATION");
 */
window.N_0xfaa457ef263e8763 = function (name) {
	return _in(0xfaa457ef, 0x263e8763, _i, _ts(name));
};

window.N_0xfac75988a7d078d3 = function (p0) {
	return _in(0xfac75988, 0xa7d078d3, p0);
};

window.N_0xfae628f1e9adb239 = function (p0, p1, p2) {
	return _in(0xfae628f1, 0xe9adb239, p0, p1, p2);
};

window.N_0xfaf2a78061fd9ef4 = function (p0, p1, p2, p3) {
	return _in(0xfaf2a780, 0x61fd9ef4, p0, _fv(p1), _fv(p2), _fv(p3));
};

window.N_0xfafc23aee23868db = function () {
	return _in(0xfafc23ae, 0xe23868db, _r, _ri);
};

window.N_0xfb00ca71da386228 = function () {
	return _in(0xfb00ca71, 0xda386228);
};

window.N_0xfb199266061f820a = function () {
	return _in(0xfb199266, 0x061f820a, _r, _ri);
};

/**
 * p0 is always 0. p1 is pointing to a global.
 */
window.N_0xfb1f9381e80fa13f = function (p0, p1) {
	return _in(0xfb1f9381, 0xe80fa13f, p0, _ii(p1) /* may be optional */, _r, _ri);
};

window.N_0xfb680d403909dc70 = function (p0, p1) {
	return _in(0xfb680d40, 0x3909dc70, p0, p1);
};

window.N_0xfb6c4072e9a32e92 = function (p0, p1) {
	return _in(0xfb6c4072, 0xe9a32e92, p0, p1, _r, _ri);
};

window.N_0xfb80ab299d2ee1bd = function (p0) {
	return _in(0xfb80ab29, 0x9d2ee1bd, p0);
};

window.N_0xfb8f2a6f3df08cbe = function () {
	return _in(0xfb8f2a6f, 0x3df08cbe);
};

window.N_0xfbc5e768c7a77a6a = function () {
	return _in(0xfbc5e768, 0xc7a77a6a, _r, _ri);
};

window.N_0xfbe20329593dec9d = function (p0, p1, p2, p3) {
	return _in(0xfbe20329, 0x593dec9d, p0, p1, p2, p3);
};

window.N_0xfc18db55ae19e046 = function (p0) {
	return _in(0xfc18db55, 0xae19e046, p0);
};

window.N_0xfc40cbf7b90ca77c = function (vehicle) {
	return _in(0xfc40cbf7, 0xb90ca77c, vehicle);
};

window.N_0xfc4ee00a7b3bfb76 = function (p0, p1, p2) {
	return _in(0xfc4ee00a, 0x7b3bfb76, p0, p1, p2);
};

window.N_0xfc859e2374407556 = function () {
	return _in(0xfc859e23, 0x74407556, _r);
};

window.N_0xfcc228e07217fcac = function (p0) {
	return _in(0xfcc228e0, 0x7217fcac, p0);
};

window.N_0xfccae5b92a830878 = function (p0) {
	return _in(0xfccae5b9, 0x2a830878, p0, _r);
};

window.N_0xfcf37a457cb96dc0 = function (p0, p1, p2, p3, p4) {
	return _in(0xfcf37a45, 0x7cb96dc0, p0, _fv(p1), _fv(p2), _fv(p3), _fv(p4), _r);
};

window.N_0xfcfacd0db9d7a57d = function (ped, p1) {
	return _in(0xfcfacd0d, 0xb9d7a57d, ped, p1);
};

window.N_0xfd1695c5d3b05439 = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xfd1695c5, 0xd3b05439, p0, p1, p2, p3, p4, p5);
};

window.N_0xfd3151cd37ea2245 = function (p0) {
	return _in(0xfd3151cd, 0x37ea2245, p0);
};

window.N_0xfd75dabc0957bf33 = function (p0) {
	return _in(0xfd75dabc, 0x0957bf33, p0);
};

/**
 * NETWORK_IS_IN_???
 */
window.N_0xfd8b834a8ba05048 = function () {
	return _in(0xfd8b834a, 0x8ba05048, _r, _ri);
};

window.N_0xfdb423997fa30340 = function () {
	return _in(0xfdb42399, 0x7fa30340);
};

window.N_0xfdd85225b2dea55e = function () {
	return _in(0xfdd85225, 0xb2dea55e);
};

window.N_0xfdec055ab549e328 = function () {
	return _in(0xfdec055a, 0xb549e328);
};

window.N_0xfe07ff6495d52e2a = function (p0, p1, p2, p3) {
	return _in(0xfe07ff64, 0x95d52e2a, p0, p1, p2, p3, _r, _ri);
};

window.N_0xfe205f38aaa58e5b = function (p0, p1) {
	return _in(0xfe205f38, 0xaaa58e5b, p0, p1);
};

window.N_0xfe26117a5841b2ff = function (vehicle, p1) {
	return _in(0xfe26117a, 0x5841b2ff, vehicle, p1, _r, _ri);
};

window.N_0xfe4c1d0d3b9cc17e = function (p0, p1) {
	return _in(0xfe4c1d0d, 0x3b9cc17e, p0, p1, _r);
};

window.N_0xfebfbfdfb66039de = function (p0) {
	return _in(0xfebfbfdf, 0xb66039de, p0);
};

window.N_0xfec9a3b1820f3331 = function (p0) {
	return _in(0xfec9a3b1, 0x820f3331, p0, _r);
};

window.N_0xfee4a5459472a9f8 = function () {
	return _in(0xfee4a545, 0x9472a9f8);
};

/**
 * Tune Forward... ?
 */
window.N_0xff266d1d0eb1195d = function () {
	return _in(0xff266d1d, 0x0eb1195d);
};

/**
 * gets byte at offset 0x862 in the specified players data (ped data + 0xbd0) and stores the bool p1 in it.
 * lwz       r3, 0xBD0(r3) ;r3 is player data
 * lbz       r4, 0x862(r3) ;r4 is now the byte
 * insrwi    r4, r31, 1,28 ;stores p1 as a bit in place 28 idk
 * stb       r4, 0x862(r3) ; puts the newly modified one back in
 * SET_PLAYER_*
 */
window.N_0xff300c7649724a0b = function (player, p1) {
	return _in(0xff300c76, 0x49724a0b, player, p1);
};

window.N_0xff4803bc019852d9 = function (p0, p1) {
	return _in(0xff4803bc, 0x019852d9, _fv(p0), p1);
};

window.N_0xff5992e1c9e65d05 = function (p0) {
	return _in(0xff5992e1, 0xc9e65d05, p0);
};

window.N_0xff8f3a92b75ed67a = function () {
	return _in(0xff8f3a92, 0xb75ed67a, _r, _ri);
};

window.N_0xffbe02cd385356bd = function () {
	return _in(0xffbe02cd, 0x385356bd, _r, _ri);
};

/**
 * may be 0xBF21818E
 * related to: NETWORK_BAIL
 * NETWORK_BAIL_TRANSITION
 * NETWORK_JOIN_GROUP_ACTIVITY
 * NETWORK_JOIN_TRANSITION
 * NETWORK_LAUNCH_TRANSITION
 * NETWORK_SESSION_HOST
 * NETWORK_SESSION_HOST_CLOSED
 * NETWORK_SESSION_HOST_FRIENDS_ONLY
 * NETWORK_SESSION_HOST_SINGLE_PLAYER
 * NETWORK_SESSION_VOICE_LEAVE
 */
window.N_0xffe1e5b792d92b34 = function () {
	return _in(0xffe1e5b7, 0x92d92b34, _r, _ri);
};

window.N_0xffee8fa29ab9a18e = function (player) {
	return _in(0xffee8fa2, 0x9ab9a18e, player);
};

/**
 * gets the entity id of a network id
 */
window.NetToEnt = function (netHandle) {
	return _in(0xbffeab45, 0xa9a9094a, netHandle, _r, _ri);
};

/**
 * gets the object id of a network id
 */
window.NetToObj = function (netHandle) {
	return _in(0xd8515f5f, 0xea14cb3f, netHandle, _r, _ri);
};

/**
 * gets the ped id of a network id
 */
window.NetToPed = function (netHandle) {
	return _in(0xbdcd95fc, 0x216a8b3e, netHandle, _r, _ri);
};

window.NetToVeh = function (netHandle) {
	return _in(0x367b9366, 0x10ba360c, netHandle, _r, _ri);
};

window.NetworkAcceptPresenceInvite = function (p0) {
	return _in(0xfa91550d, 0xf9318b22, p0, _r);
};

/**
 * Some of the tunable contexts used in the PC scripts:
 * - "BASE_GLOBALS"
 * - "MP_GLOBAL"
 * and some of the tunable names used in the PC scripts:
 * - "XP_MULTIPLIER"
 * - "CASH_MULTIPLIER"
 * - "ARMOUR_REWARD_GIFT"
 * - "TOGGLE_CREATORS_OFF"
 * - "MULTIPLAYER_DISABLED"
 */
window.NetworkAccessTunableBool = function (tunableContext, tunableName) {
	return _in(0xaa6a47a5, 0x73abb75a, _ts(tunableContext), _ts(tunableName), _r);
};
window.N_0xaa6a47a573abb75a = window.NetworkAccessTunableBool;

/**
 * Console Hash - 0x18867C61 = NETWORK_ACCESS_TUNABLE_BOOL_HASH
 */
window.NetworkAccessTunableBoolHash = function (tunableContext, tunableName) {
	return _in(0xea16b69d, 0x93d71a45, _ch(tunableContext), _ch(tunableName), _r);
};
window.N_0xea16b69d93d71a45 = window.NetworkAccessTunableBoolHash;

/**
 * Returns a default value if the tunable don't exist.
 * Console Hash
 */
window.NetworkAccessTunableBoolHashFailVal = function (tunableContext, tunableName, defaultValue) {
	return _in(0xc7420099, 0x936ce286, _ch(tunableContext), _ch(tunableName), defaultValue, _r);
};
window.N_0xc7420099936ce286 = window.NetworkAccessTunableBoolHashFailVal;

/**
 * Some of the tunable contexts used in the PC scripts:
 * - "BASE_GLOBALS"
 * - "MP_GLOBAL"
 * - "MP_FM_RACES"
 * - "MP_FM_RACES_CAR"
 * - "MP_FM_RACES_SEA"
 * - "MP_FM_RACES_CAR"
 * - "MP_FM_RACES_AIR"
 * - "MP_FM_BASEJUMP"
 * - "MP_FM_RACES_CYCLE"
 * - "MP_FM_RACES_BIKE"
 * - "MP_FM_MISSIONS"
 * - "MP_FM_CONTACT"
 * - "MP_FM_RANDOM"
 * - "MP_FM_VERSUS"
 * - "MP_FM_LTS"
 * - "MP_FM_CAPTURE"
 * - "MP_FM_DM"
 * - "MP_FM_SURVIVAL"
 * - "MP_FM_GANG_ATTACK"
 * - "MP_FM_BASEJUMP"
 * - "MP_CNC_TEAM_COP"
 * - "MP_CNC_TEAM_VAGOS"
 * - "MP_CNC_TEAM_LOST"
 * and some of the tunable names used in the PC scripts:
 * - "XP_MULTIPLIER"
 * - "CASH_MULTIPLIER"
 * - "ARMOUR_REWARD_GIFT"
 * - "TOGGLE_CREATORS_OFF"
 */
window.NetworkAccessTunableFloat = function (tunableContext, tunableName, value) {
	return _in(0xe5608ca7, 0xbc163a5f, _ts(tunableContext), _ts(tunableName), _fi(value) /* may be optional */, _r);
};
window.N_0xe5608ca7bc163a5f = window.NetworkAccessTunableFloat;

/**
 * Console Hash - 0x3972551F = NETWORK_ACCESS_TUNABLE_FLOAT_HASH
 */
window.NetworkAccessTunableFloatHash = function (tunableContext, tunableName, value) {
	return _in(0x972bc203, 0xbbc4c4d5, _ch(tunableContext), _ch(tunableName), _fi(value) /* may be optional */, _r);
};
window.N_0x972bc203bbc4c4d5 = window.NetworkAccessTunableFloatHash;

/**
 * Some of the tunable contexts used in the PC scripts:
 * - "MP_FM_RACES"
 * - "MP_FM_RACES_CAR"
 * - "MP_FM_RACES_SEA"
 * - "MP_FM_RACES_CAR"
 * - "MP_FM_RACES_AIR"
 * - "MP_FM_BASEJUMP"
 * - "MP_FM_RACES_CYCLE"
 * - "MP_FM_RACES_BIKE"
 * - "MP_FM_MISSIONS"
 * - "MP_FM_CONTACT"
 * - "MP_FM_RANDOM"
 * - "MP_FM_VERSUS"
 * - "MP_FM_LTS"
 * - "MP_FM_CAPTURE"
 * - "MP_FM_DM"
 * - "MP_FM_SURVIVAL"
 * - "MP_FM_GANG_ATTACK"
 * - "MP_FM_BASEJUMP"
 * - "BASE_GLOBALS"
 * - "MP_GLOBAL"
 * and some of the tunable names used in the PC scripts:
 * - "XP_MULTIPLIER"
 * - "CASH_MULTIPLIER"
 * - "ARMOUR_REWARD_GIFT"
 * - "TOGGLE_CREATORS_OFF"
 */
window.NetworkAccessTunableInt = function (tunableContext, tunableName, value) {
	return _in(0x8be1146d, 0xfd5d4468, _ts(tunableContext), _ts(tunableName), _ii(value) /* may be optional */, _r);
};
window.N_0x8be1146dfd5d4468 = window.NetworkAccessTunableInt;

/**
 * Console Hash - 0xB2E83B75 = NETWORK_ACCESS_TUNABLE_INT_HASH
 */
window.NetworkAccessTunableIntHash = function (tunableContext, tunableName, value) {
	return _in(0x40fce03e, 0x50e8dbe8, _ch(tunableContext), _ch(tunableName), _ii(value) /* may be optional */, _r);
};
window.N_0x40fce03e50e8dbe8 = window.NetworkAccessTunableIntHash;

window.NetworkActionFollowInvite = function () {
	return _in(0xc88156eb, 0xb786f8d5, _r, _ri);
};
window.N_0xc88156ebb786f8d5 = window.NetworkActionFollowInvite;

/**
 * Console hash: 0xCD69BEA1
 */
window.NetworkAddEntityAngledArea = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0x376c6375, 0xba60293a, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _r, _ri);
};
window.N_0x376c6375ba60293a = window.NetworkAddEntityAngledArea;

window.NetworkAddEntityArea = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x494c8fb2, 0x99290269, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _r, _ri);
};

window.NetworkAddEntityToSynchronisedScene = function (entity, netScene, animDict, animName, speed, speedMulitiplier, flag) {
	return _in(0xf2404d68, 0xcbc855fa, entity, netScene, _ts(animDict), _ts(animName), _fv(speed), _fv(speedMulitiplier), flag);
};

/**
 * ..
 */
window.NetworkAddFollowers = function (p1) {
	return _in(0x236406f6, 0x0cf216d6, _i, p1);
};
window.N_0x236406f60cf216d6 = window.NetworkAddFollowers;

window.NetworkAddFriend = function (message) {
	return _in(0x8e02d739, 0x14064223, _i, _ts(message), _r);
};

window.NetworkAddPedToSynchronisedScene = function (ped, netScene, animDict, animnName, speed, speedMultiplier, duration, flag, playbackRate, p9) {
	return _in(0x742a6374, 0x71bcecd9, ped, netScene, _ts(animDict), _ts(animnName), _fv(speed), _fv(speedMultiplier), duration, flag, _fv(playbackRate), p9);
};

window.NetworkAmIBlockedByGamer = function (p0) {
	return _in(0x15337c7c, 0x268a27b2, _ii(p0) /* may be optional */, _r);
};

window.NetworkAmIBlockedByPlayer = function (player) {
	return _in(0x87f395d9, 0x57d4353d, player, _r);
};

window.NetworkAmIMutedByGamer = function (p0) {
	return _in(0xdf02a2c9, 0x3f1f26da, _ii(p0) /* may be optional */, _r);
};

window.NetworkAmIMutedByPlayer = function (player) {
	return _in(0x9d6981df, 0xc91a8604, player, _r);
};

window.NetworkApplyTransitionParameter = function (p0, p1) {
	return _in(0x521638ad, 0xa1ba0d18, p0, p1);
};
window.N_0x521638ada1ba0d18 = window.NetworkApplyTransitionParameter;

window.NetworkAreHandlesTheSame = function () {
	return _in(0x57dba049, 0xe110f217, _i, _i, _r);
};

/**
 * Returns whether the Rockstar game services are available or not:
 * SCLB_NO_ROS = The Rockstar game services are unavailable right now. Please try again later.
 * ros.rockstargames.com
 */
window.NetworkAreRosAvailable = function () {
	return _in(0x85443ff4, 0xc328f53b, _r);
};
window.N_0x85443ff4c328f53b = window.NetworkAreRosAvailable;

window.NetworkAreTransitionDetailsValid = function (p0) {
	return _in(0x2615aa2a, 0x695930c1, p0, _r);
};
window.N_0x2615aa2a695930c1 = window.NetworkAreTransitionDetailsValid;

window.NetworkAttachSynchronisedSceneToEntity = function (netScene, entity, bone) {
	return _in(0x478dcbd2, 0xa98b705a, netScene, entity, bone);
};

/**
 * This has arguments.. in PC scripts.
 */
window.NetworkBail = function () {
	return _in(0x95914459, 0xa87eba28);
};

window.NetworkBailTransition = function () {
	return _in(0xeaa57203, 0x6990cd1b);
};

window.NetworkBlockInvites = function (toggle) {
	return _in(0x34f9e904, 0x9454a7a0, toggle);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.NetworkBlockInvites_2 = function (p0) {
	return _in(0x4a9fde3a, 0x5a6d0437, p0);
};
window.N_0x4a9fde3a5a6d0437 = window.NetworkBlockInvites_2;

window.NetworkBlockKickedPlayers = function (p0) {
	return _in(0x6b07b9ce, 0x4d390375, p0);
};
window.N_0x6b07b9ce4d390375 = window.NetworkBlockKickedPlayers;

/**
 * p1 = 0 (always)
 * p2 = 1 (always)
 */
window.NetworkBuyAirstrike = function (cost, p1, p2) {
	return _in(0x763b4bd3, 0x05338f19, cost, p1, p2);
};

/**
 * p1 is just an assumption. p2 was false and p3 was true.
 */
window.NetworkBuyBounty = function (amount, victim, p2, p3) {
	return _in(0x7b718e19, 0x7453f2d9, amount, victim, p2, p3);
};

/**
 * The first parameter is the amount spent which is store in a global when this native is called. The global returns 10. Which is the price for both rides.
 * The last 3 parameters are,
 * 2,0,1 in the am_ferriswheel.c
 * 1,0,1 in the am_rollercoaster.c
 */
window.NetworkBuyFairgroundRide = function (amountSpent, p1, p2, p3) {
	return _in(0x8a7b3952, 0xdd64d2b5, amountSpent, p1, p2, p3);
};
window.N_0x8a7b3952dd64d2b5 = window.NetworkBuyFairgroundRide;

window.NetworkBuyHealthcare = function (cost, p1, p2) {
	return _in(0xd9b067e5, 0x5253e3dd, cost, p1, p2);
};

/**
 * p1 = 0 (always)
 * p2 = 1 (always)
 */
window.NetworkBuyHeliStrike = function (cost, p1, p2) {
	return _in(0x81aa4610, 0xe3fd3a69, cost, p1, p2);
};

window.NetworkBuyItem = function (player, item, p2, p3, p4, item_name, p6, p7, p8, p9) {
	return _in(0xf0077c79, 0x7f66a355, player, _ch(item), p2, p3, p4, _ts(item_name), p6, p7, p8, p9);
};

window.NetworkBuyProperty = function (propertyCost, propertyName, p2, p3) {
	return _in(0x650a08a2, 0x80870af6, _fv(propertyCost), _ch(propertyName), p2, p3);
};

/**
 * 11 - Need to download tunables.
 * 12 - Need to download background script.
 * Returns 1 if the multiplayer is loaded, otherwhise 0.
 */
window.NetworkCanAccessMultiplayer = function (loadingState) {
	return _in(0xaf50da1a, 0x3f8b1ba4, _ii(loadingState) /* may be optional */, _r);
};
window.N_0xaf50da1a3f8b1ba4 = window.NetworkCanAccessMultiplayer;

window.NetworkCanBail = function () {
	return _in(0x580ce443, 0x8479cc61, _r);
};

window.NetworkCanBet = function (p0) {
	return _in(0x3a54e336, 0x60ded67f, p0, _r);
};
window.N_0x3a54e33660ded67f = window.NetworkCanBet;

window.NetworkCanCommunicateWithGamer = function (player) {
	return _in(0xa150a4f0, 0x65806b1f, _ii(player) /* may be optional */, _r);
};

window.NetworkCanEnterMultiplayer = function () {
	return _in(0x7e782a91, 0x0c362c25, _r);
};

window.NetworkCanNetworkIdBeSeen = function (netId) {
	return _in(0xa1607996, 0x431332df, netId, _r);
};
window.N_0xa1607996431332df = window.NetworkCanNetworkIdBeSeen;

window.NetworkCanReceivePlayerCash = function (p0, p1, p2, p3) {
	return _in(0x5d17be59, 0xd2123284, p0, p1, p2, p3, _r);
};

window.NetworkCanSessionEnd = function () {
	return _in(0x4eebc369, 0x4e49c572, _r);
};

window.NetworkCanSetWaypoint = function () {
	return _in(0xc927ec22, 0x9934af60, _r);
};

window.NetworkCanSpendMoney = function (p0, p1, p2, p3, p4) {
	return _in(0xab3caa6b, 0x422164da, p0, p1, p2, p3, p4, _r);
};
window.N_0xab3caa6b422164da = window.NetworkCanSpendMoney;

window.NetworkChangeTransitionSlots = function (p0, p1) {
	return _in(0xeeeda5e6, 0xd7080987, p0, p1);
};
window.N_0xeeeda5e6d7080987 = window.NetworkChangeTransitionSlots;

/**
 * this function is toggle when people report you and you get the auto mute message
 */
window.NetworkChatMute = function (p0) {
	return _in(0x57b192b4, 0xd4ad23d5, p0);
};
window.N_0x57b192b4d4ad23d5 = window.NetworkChatMute;

/**
 * console hash: 0x3624F054
 */
window.NetworkCheckDataManagerForHandle = function (p0) {
	return _in(0x796a87b3, 0xb68d1f3d, _ii(p0) /* may be optional */, _r);
};
window.N_0x796a87b3b68d1f3d = window.NetworkCheckDataManagerForHandle;

/**
 * Only documented...
 */
window.NetworkClanAnimation = function (animDict, animName) {
	return _in(0x729e3401, 0xf0430686, _ts(animDict), _ts(animName), _r);
};
window.N_0x729e3401f0430686 = window.NetworkClanAnimation;

window.NetworkClanDownloadMembership = function (networkHandle) {
	return _in(0xa989044e, 0x70010abe, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkClanDownloadMembershipPending = function (p0) {
	return _in(0x5b9e023d, 0xc6ebedc0, _ii(p0) /* may be optional */, _r);
};

/**
 * BOOL DEBUG_MEMBRESHIP(int Param)
 * {
 * int membership;
 * networkHandleMgr handle;
 * NETWORK_HANDLE_FROM_PLAYER(iSelectedPlayer, &handle.netHandle, 13);
 * if (!_NETWORK_IS_CLAN_MEMBERSHIP_FINISHED_DOWNLOADING())
 * {
 * if (NETWORK_CLAN_REMOTE_MEMBERSHIPS_ARE_IN_CACHE(&Param))
 * {
 * if (NETWORK_CLAN_GET_MEMBERSHIP_COUNT(&Param) > 0)
 * {
 * if (NETWORK_CLAN_GET_MEMBERSHIP_VALID(&Param, 0))
 * {
 * if (NETWORK_CLAN_GET_MEMBERSHIP(&Param, &membership, -1))
 * {
 * _0xF633805A(&membership, 35, &handle.netHandle);
 * }
 * }
 * }
 * }
 * }
 * else
 * {
 * NETWORK_CLAN_DOWNLOAD_MEMBERSHIP(&handle.netHandle);
 * }
 * }
 */
window.NetworkClanGetMembership = function (p2) {
	return _in(0xc8bc2011, 0xf67b3411, _i, _i, p2, _r);
};

window.NetworkClanGetMembershipCount = function (p0) {
	return _in(0xaab11f6c, 0x4adbc2c1, _ii(p0) /* may be optional */, _r, _ri);
};

/**
 * networkMembershipMgr memShip;
 * int maxMemship = _GET_NUM_MEMBERSHIP_DESC();
 * for (int i = 0; i < maxMemship; i++)
 * {
 * NETWORK_CLAN_GET_MEMBERSHIP_DESC(&memShip.memHandle, i);
 * }
 */
window.NetworkClanGetMembershipDesc = function (p1) {
	return _in(0x48de78af, 0x2c8885b8, _i, p1, _r);
};

window.NetworkClanGetMembershipValid = function (p1) {
	return _in(0x48a59cf8, 0x8d43df0e, _i, p1, _r);
};

window.NetworkClanJoin = function (clanDesc) {
	return _in(0x9faaa4f4, 0xfc71f87f, clanDesc, _r);
};

/**
 * bufferSize is 35 in the scripts.
 * bufferSize is the elementCount of p0(desc), sizeof(p0) == 280 == p1*8 == 35 * 8, p2(netHandle) is obtained from NETWORK::NETWORK_HANDLE_FROM_PLAYER.  And no, I can't explain why 35 * sizeof(int) == 280 and not 140, but I'll get back to you on that.
 * the answer is: because p0 an int64_t* / int64_t[35].  and FYI p2 is an int64_t[13]
 * pastebin.com/cSZniHak
 */
window.NetworkClanPlayerGetDesc = function (bufferSize) {
	return _in(0xeee6eacb, 0xe8874fba, _i, bufferSize, _i, _r);
};

window.NetworkClanPlayerIsActive = function (networkHandle) {
	return _in(0xb124b57f, 0x571d8f18, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkClanRemoteMembershipsAreInCache = function (p0) {
	return _in(0xbb6e6fee, 0x99d866b2, _ii(p0) /* may be optional */, _r);
};

window.NetworkClearCharacterWallet = function (p0) {
	return _in(0xa921ded1, 0x5fdf28f5, p0);
};
window.N_0xa921ded15fdf28f5 = window.NetworkClearCharacterWallet;

window.NetworkClearClockTimeOverride = function () {
	return _in(0xd972df67, 0x326f966e);
};
window.N_0xd972df67326f966e = window.NetworkClearClockTimeOverride;

window.NetworkClearFollowInvite = function () {
	return _in(0x439bfde3, 0xcd0610f6, _r, _ri);
};
window.N_0x439bfde3cd0610f6 = window.NetworkClearFollowInvite;

window.NetworkClearFollowers = function () {
	return _in(0x058f43ec, 0x59a8631a);
};
window.N_0x058f43ec59a8631a = window.NetworkClearFollowers;

window.NetworkClearFoundGamers = function () {
	return _in(0x6d14ccee, 0x1b40381a);
};

window.NetworkClearPropertyId = function () {
	return _in(0xc2b82527, 0xca77053e);
};
window.N_0xc2b82527ca77053e = window.NetworkClearPropertyId;

window.NetworkClearTransitionCreatorHandle = function () {
	return _in(0xfb327222, 0x9a82c759);
};

window.NetworkClearVoiceChannel = function () {
	return _in(0xe036a705, 0xf989e049);
};
window.N_0xe036a705f989e049 = window.NetworkClearVoiceChannel;

window.NetworkCloseTransitionMatchmaking = function () {
	return _in(0x43f4dba6, 0x9710e01e);
};
window.N_0x43f4dba69710e01e = window.NetworkCloseTransitionMatchmaking;

/**
 * netScene to scene
 */
window.NetworkConvertSynchronisedSceneToSynchronizedScene = function (netScene) {
	return _in(0x02c40bf8, 0x85c567b6, netScene, _r, _ri);
};
window.N_0x02c40bf885c567b6 = window.NetworkConvertSynchronisedSceneToSynchronizedScene;
window.NetworkUnlinkNetworkedSynchronisedScene = window.NetworkConvertSynchronisedSceneToSynchronizedScene;

/**
 * console hash: 0x99F58A07
 * Sadly I thought this copied their tattoos, but it just seems to copy their 'blend data'. E.G. skin tone/color, fat/skinny face, etc.
 */
window.NetworkCopyPedBlendData = function (ped, player) {
	return _in(0x99b72c7a, 0xbde5c910, ped, player, _r);
};
window.N_0x99b72c7abde5c910 = window.NetworkCopyPedBlendData;

/**
 * returns netScene
 * this native is missing 2 params
 * float p10, float p11
 */
window.NetworkCreateSynchronisedScene = function (x, y, z, xRot, yRot, zRot, p6, p7, p8, p9) {
	return _in(0x7cd6bc4c, 0x2bbdd526, _fv(x), _fv(y), _fv(z), _fv(xRot), _fv(yRot), _fv(zRot), p6, p7, p8, _fv(p9), _r, _ri);
};

/**
 * Note the 2nd parameters are always 1, 0. I have a feeling it deals with your money, wallet, bank. So when you delete the character it of course wipes the wallet cash at that time. So if that was the case, it would be eg, NETWORK_DELETE_CHARACTER(characterIndex, deleteWalletCash, deleteBankCash);
 */
window.NetworkDeleteCharacter = function (characterIndex, p1, p2) {
	return _in(0x05a50af3, 0x8947eb8d, characterIndex, p1, p2);
};

/**
 * hash collision???
 * I did this and I didn't see anything happening
 * int pindex;
 * for (int i = 0; i < 32; i++)
 * {
 * if (NETWORK_IS_PARTICIPANT_ACTIVE(INT_TO_PARTICIPANTINDEX(i)))
 * {
 * pindex = NETWORK_GET_PLAYER_INDEX(INT_TO_PARTICIPANTINDEX(i));
 * NETWORK_DISABLE_INVINCIBLE_FLASHING(pindex, 1);
 * }
 * }
 */
window.NetworkDisableInvincibleFlashing = function (player, p1) {
	return _in(0x9dd368bf, 0x06983221, player, p1);
};
window.N_0x9dd368bf06983221 = window.NetworkDisableInvincibleFlashing;

window.NetworkDoTransitionQuickmatch = function (p0, p1, p2, p3) {
	return _in(0x71fb0ebc, 0xd4915d56, p0, p1, p2, p3, _r);
};
window.N_0x71fb0ebcd4915d56 = window.NetworkDoTransitionQuickmatch;

window.NetworkDoTransitionQuickmatchAsync = function (p0, p1, p2, p3) {
	return _in(0xa091a5e4, 0x4f0072e5, p0, p1, p2, p3, _r);
};
window.N_0xa091a5e44f0072e5 = window.NetworkDoTransitionQuickmatchAsync;

window.NetworkDoTransitionQuickmatchWithGroup = function (p0, p1, p2, p3, p5) {
	return _in(0x9c4ab584, 0x91fdc98a, p0, p1, p2, p3, _i, p5, _r);
};

/**
 * p2 is true 3/4 of the occurrences I found.
 * 'players' is the number of players for a session. On PS3/360 it's always 18. On PC it's 32.
 */
window.NetworkDoTransitionToFreemode = function (p1, p2, players, p4) {
	return _in(0x3aad8b2f, 0xca1e289f, _i, p1, p2, players, p4, _r);
};

window.NetworkDoTransitionToGame = function (p0, maxPlayers) {
	return _in(0x3e9bb381, 0x02a589b0, p0, maxPlayers, _r);
};

window.NetworkDoTransitionToNewFreemode = function (players, p3, p4, p5) {
	return _in(0x9e80a5ba, 0x8109f974, _i, _i, players, p3, p4, p5, _r);
};

window.NetworkDoTransitionToNewGame = function (p0, maxPlayers, p2) {
	return _in(0x4665f51e, 0xfed00034, p0, maxPlayers, p2, _r);
};

window.NetworkDoesEntityExistWithNetworkId = function (entity) {
	return _in(0x18a47d07, 0x4708fd68, entity, _r);
};

window.NetworkDoesNetworkIdExist = function (netID) {
	return _in(0x38ce16c9, 0x6bd11344, netID, _r);
};

/**
 * Some of the tunable contexts used in the PC scripts:
 * - "MP_FM_RACES"
 * - "MP_FM_RACES_CAR"
 * - "MP_FM_RACES_SEA"
 * - "MP_FM_RACES_CAR"
 * - "MP_FM_RACES_AIR"
 * - "MP_FM_BASEJUMP"
 * - "MP_FM_RACES_CYCLE"
 * - "MP_FM_RACES_BIKE"
 * - "MP_FM_MISSIONS"
 * - "MP_FM_CONTACT"
 * - "MP_FM_RANDOM"
 * - "MP_FM_VERSUS"
 * - "MP_FM_LTS"
 * - "MP_FM_CAPTURE"
 * - "MP_FM_DM"
 * - "MP_FM_SURVIVAL"
 * - "MP_FM_GANG_ATTACK"
 * - "MP_FM_BASEJUMP"
 * - "BASE_GLOBALS"
 * - "MP_GLOBAL"
 * and some of the tunable names used in the PC scripts:
 * - "XP_MULTIPLIER"
 * - "CASH_MULTIPLIER"
 * - "ARMOUR_REWARD_GIFT"
 * - "TOGGLE_CREATORS_OFF"
 */
window.NetworkDoesTunableExist = function (tunableContext, tunableName) {
	return _in(0x85e5f8b9, 0xb898b20a, _ts(tunableContext), _ts(tunableName), _r);
};

/**
 * Console Hash - 0x25915CB9 = NETWORK_DOES_TUNABLE_EXIST_HASH
 */
window.NetworkDoesTunableExistHash = function (tunableContext, tunableName) {
	return _in(0xe4e53e14, 0x19d81127, _ch(tunableContext), _ch(tunableName), _r);
};
window.N_0xe4e53e1419d81127 = window.NetworkDoesTunableExistHash;

/**
 * DSPORT
 */
window.NetworkEarnFromAiTargetKill = function (p0, p1) {
	return _in(0x515b4a22, 0xe4d3c6d7, p0, p1);
};
window.N_0x515b4a22e4d3c6d7 = window.NetworkEarnFromAiTargetKill;

/**
 * Console Hash - 0xA14CC95D = NETWORK_EARN_FROM_AMBIENT_JOB
 * Example for p1: "AM_DISTRACT_COPS"
 */
window.NetworkEarnFromAmbientJob = function (p0, p1, p2) {
	return _in(0xfb6db092, 0xfbae29e6, p0, _ts(p1), _ii(p2) /* may be optional */);
};
window.N_0xfb6db092fbae29e6 = window.NetworkEarnFromAmbientJob;

/**
 * For the money bags that drop a max of $40,000. Often called 40k bags.
 * Most likely NETWORK_EARN_FROM_ROB***
 * MONEY_EARN_JOBS
 */
window.NetworkEarnFromArmourTruck = function (amount) {
	return _in(0xf514621e, 0x8ea463d0, amount);
};
window.N_0xf514621e8ea463d0 = window.NetworkEarnFromArmourTruck;

window.NetworkEarnFromBetting = function (amount, p1) {
	return _in(0x827a5ba1, 0xa44aca6d, amount, _ts(p1));
};

window.NetworkEarnFromBounty = function (amount, p3) {
	return _in(0x131bb5da, 0x15453acf, amount, _i, _i, p3);
};

window.NetworkEarnFromChallengeWin = function (p0, p2) {
	return _in(0x2b171e6b, 0x2f64d8df, p0, _i, p2);
};
window.N_0x2b171e6b2f64d8df = window.NetworkEarnFromChallengeWin;

window.NetworkEarnFromCrateDrop = function (amount) {
	return _in(0xb1cc1b9e, 0xc3007a2a, amount);
};
window.N_0xb1cc1b9ec3007a2a = window.NetworkEarnFromCrateDrop;

/**
 * Console Hash - 0xAB6BD72F = NETWORK_EARN_FROM_DAILY_OBJECTIVE
 */
window.NetworkEarnFromDailyObjective = function (p0, p1, p2) {
	return _in(0x6ea318c9, 0x1c1a8786, p0, _ts(p1), p2);
};
window.N_0x6ea318c91c1a8786 = window.NetworkEarnFromDailyObjective;

/**
 * MONEY_EARN_PICKED_UP
 */
window.NetworkEarnFromGangPickup = function (amount) {
	return _in(0xa03d4ace, 0x0a3284ce, amount);
};
window.N_0xa03d4ace0a3284ce = window.NetworkEarnFromGangPickup;

window.NetworkEarnFromHoldups = function (amount) {
	return _in(0x45b8154e, 0x077d9e4d, amount);
};

window.NetworkEarnFromImportExport = function (p0, p1) {
	return _in(0xf92a014a, 0x634442d6, p0, p1);
};

window.NetworkEarnFromJob = function (amount, p1) {
	return _in(0xb2cc4836, 0x834e8a98, amount, _ts(p1));
};

/**
 * Console Hash - 0xBEE23713 = NETWORK_EARN_FROM_JOB_BONUS
 */
window.NetworkEarnFromJobBonus = function (p0) {
	return _in(0x6816fb44, 0x16760775, p0, _i, _i);
};
window.N_0x6816fb4416760775 = window.NetworkEarnFromJobBonus;

/**
 * Pretty sure this is actually a hash collision.
 * It should be NETWORK_EARN_FROM_A*** or NETWORK_EARN_FROM_B***
 * =============================================================
 * Not a hash collision, test it for yourself when finishing heist.
 * lackos; 2017.03.12
 */
window.NetworkEarnFromMissionH = function (amount, heistHash) {
	return _in(0x61326ee6, 0xdf15b0ca, amount, _ts(heistHash));
};
window.N_0x61326ee6df15b0ca = window.NetworkEarnFromMissionH;

/**
 * Enough007: Adds an entry in the Network Transaction Log.
 * Max value for amount 2000
 */
window.NetworkEarnFromNotBadsport = function (amount) {
	return _in(0x4337511f, 0xa8221d36, amount);
};
window.N_0x4337511fa8221d36 = window.NetworkEarnFromNotBadsport;

/**
 * Now has 9 parameters.
 */
window.NetworkEarnFromPersonalVehicle = function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
	return _in(0x3f4d0016, 0x7e41e0ad, p0, p1, p2, p3, p4, p5, p6, p7, p8);
};
window.N_0x3f4d00167e41e0ad = window.NetworkEarnFromPersonalVehicle;

window.NetworkEarnFromPickup = function (amount) {
	return _in(0xed1517d3, 0xaf17c698, amount, _r, _ri);
};

window.NetworkEarnFromProperty = function (amount, propertyName) {
	return _in(0x84964834, 0x9d77f5c5, amount, _ch(propertyName));
};

/**
 * This merely adds an entry in the Network Transaction Log;
 * it does not grant cash to the player (on PC).
 * Max value for amount is 9999999.
 */
window.NetworkEarnFromRockstar = function (amount) {
	return _in(0x02ce1d6a, 0xc0fc73ea, amount);
};

/**
 * Now has 8 params.
 */
window.NetworkEarnFromVehicle = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0xb539bd8a, 0x4c1eecf8, p0, p1, p2, p3, p4, p5, p6, p7);
};

/**
 * Pretty sure this is a hash collision
 */
window.NetworkEnableMotionDrugged = function () {
	return _in(0x0b0cc107, 0x20653f3b, _r, _ri);
};
window.N_0x0b0cc10720653f3b = window.NetworkEnableMotionDrugged;

window.NetworkEndTutorialSession = function () {
	return _in(0xd0afaff5, 0xa51d72f7);
};

/**
 * In the console script dumps, this is only referenced once.
 * NETWORK::NETWORK_EXPLODE_VEHICLE(vehicle, 1, 0, 0);
 * ^^^^^ That must be PC script dumps? In X360 Script Dumps it is reference a few times with 2 differences in the parameters.
 * Which as you see below is 1, 0, 0 + 1, 1, 0 + 1, 0, and a *param?
 * am_plane_takedown.c
 * network_explode_vehicle(net_to_veh(Local_40.imm_2), 1, 1, 0);
 * armenian2.c
 * network_explode_vehicle(Local_80[6 <2>], 1, 0, 0);
 * fm_horde_controler.c
 * network_explode_vehicle(net_to_veh(*uParam0), 1, 0, *uParam0);
 * fm_mission_controller.c, has 6 hits so not going to list them.
 * Side note, setting the first parameter to 0 seems to mute sound or so?
 * Seems it's like ADD_EXPLOSION, etc. the first 2 params. The 3rd atm no need to worry since it always seems to be 0.
 */
window.NetworkExplodeVehicle = function (vehicle, isAudible, isInvisible, p3) {
	return _in(0x301a4215, 0x3c9ad707, vehicle, isAudible, isInvisible, p3, _r, _ri);
};

/**
 * state - 0 does 5 fades
 * state - 1 does 6 fades
 * native is missing third argument, also boolean, setting to 1 made vehicle fade in slower, probably "slow" as per NETWORK_FADE_OUT_ENTITY
 */
window.NetworkFadeInEntity = function (entity, state) {
	return _in(0x1f4ed342, 0xacefe62d, entity, state);
};

/**
 * normal - transition like when your coming out of LSC
 * slow - transition like when you walk into a mission
 */
window.NetworkFadeOutEntity = function (entity, normal, slow) {
	return _in(0xde564951, 0xf95e09ed, entity, normal, slow);
};

window.NetworkFindMatchedGamers = function (p0, p1, p2, p3) {
	return _in(0xf7b2cfde, 0x5c9f700d, p0, _fv(p1), _fv(p2), _fv(p3), _r);
};
window.N_0xf7b2cfde5c9f700d = window.NetworkFindMatchedGamers;

window.NetworkForceLocalUseOfSyncedSceneCamera = function (netScene, animDict, animName) {
	return _in(0xcf8bd3b0, 0xbd6d42d7, netScene, _ts(animDict), _ts(animName));
};
window.N_0xcf8bd3b0bd6d42d7 = window.NetworkForceLocalUseOfSyncedSceneCamera;

window.NetworkGamerHasHeadset = function (p0) {
	return _in(0xf2fd55cb, 0x574bcc55, _ii(p0) /* may be optional */, _r);
};

window.NetworkGamertagFromHandlePending = function () {
	return _in(0xb071e279, 0x58ef4cf0, _r);
};

window.NetworkGamertagFromHandleStart = function (networkHandle) {
	return _in(0x9f0c0a98, 0x1d73fa56, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkGamertagFromHandleSucceeded = function () {
	return _in(0xfd00798d, 0xba7523dd, _r);
};

window.NetworkGetActivityPlayerNum = function (p0) {
	return _in(0x73e2b500, 0x410da5a2, p0, _r, _ri);
};

window.NetworkGetBackgroundLoadingRecipients = function (p0, p1) {
	return _in(0x97a770be, 0xef227e2b, p0, p1, _i, _i, _r);
};
window.N_0x97a770beef227e2b = window.NetworkGetBackgroundLoadingRecipients;

/**
 * Console Hash: Probably 0xAA7EA3BD
 */
window.NetworkGetBankBalanceString = function () {
	return _in(0xa6fa3979, 0xbed01b81, _r, _s);
};
window.N_0xa6fa3979bed01b81 = window.NetworkGetBankBalanceString;

window.NetworkGetCurrentlySelectedGamerHandleFromInviteMenu = function (p0) {
	return _in(0x74881e6b, 0xcae2327c, _ii(p0) /* may be optional */, _r);
};

window.NetworkGetDesroyerOfEntity = function (p0, p1, weaponHash) {
	return _in(0x4caca844, 0x40fa26f6, p0, p1, _ii(weaponHash) /* may be optional */, _r);
};
window.N_0x4caca84440fa26f6 = window.NetworkGetDesroyerOfEntity;

window.NetworkGetDestroyerOfNetworkId = function (netId, weaponHash) {
	return _in(0x7a1adeef, 0x01740a24, netId, _ii(weaponHash) /* may be optional */, _r, _ri);
};

window.NetworkGetEntityFromNetworkId = function (netId) {
	return _in(0xce4e5d9b, 0x0a4ff560, netId, _r, _ri);
};

window.NetworkGetEntityIsLocal = function (entity) {
	return _in(0x0991549d, 0xe4d64762, entity, _r);
};

window.NetworkGetEntityIsNetworked = function (entity) {
	return _in(0xc7827959, 0x479dcc78, entity, _r);
};
window.N_0xc7827959479dcc78 = window.NetworkGetEntityIsNetworked;

window.NetworkGetEntityKillerOfPlayer = function (player, weaponHash) {
	return _in(0x42b2daa6, 0xb596f5f8, player, _ii(weaponHash) /* may be optional */, _r, _ri);
};

/**
 * Returns the owner ID of the specified entity.
 * @param entity The entity to get the owner for.
 * @return On the server, the server ID of the entity owner. On the client, returns the player/slot ID of the entity owner.
 */
window.NetworkGetEntityOwner = function (entity) {
	return _in(0x00000000, 0x526fee31, entity, _r, _ri);
};

window.NetworkGetFoundGamer = function (p1) {
	return _in(0x9dcff2af, 0xb68b3476, _i, p1, _r);
};

window.NetworkGetFriendCount = function () {
	return _in(0x203f1cfd, 0x823b27a4, _r, _ri);
};

window.NetworkGetFriendName = function (friendIndex) {
	return _in(0xe11ebbb2, 0xa783fe8b, friendIndex, _r, _s);
};

window.NetworkGetFriendNameFromIndex = function (friendIndex) {
	return _in(0x4164f227, 0xd052e293, friendIndex, _r, _s);
};
window.NetworkGetFriendName = window.NetworkGetFriendNameFromIndex;

window.NetworkGetGamertagFromHandle = function (networkHandle) {
	return _in(0x42614116, 0x2ebe5cdb, _ii(networkHandle) /* may be optional */, _r, _s);
};

/**
 * scriptName examples:
 * "freemode", "AM_CR_SecurityVan", ...
 * Most of the time, these values are used:
 * p1 = -1
 * p2 = 0
 */
window.NetworkGetHostOfScript = function (scriptName, p1, p2) {
	return _in(0x1d6a14f1, 0xf9a736fc, _ts(scriptName), p1, p2, _r, _ri);
};

window.NetworkGetHostOfThisScript = function () {
	return _in(0xc7b4d79b, 0x01fa7a5c, _r, _ri);
};

/**
 * Retrieves the local player's NetworkHandle* and stores it in the given buffer.
 * * Currently unknown struct
 */
window.NetworkGetLocalHandle = function (bufferSize) {
	return _in(0xe8605178, 0x6b66cd8e, _i, bufferSize);
};

/**
 * On PC this is hardcoded to 250.
 */
window.NetworkGetMaxFriends = function () {
	return _in(0xafebb0d5, 0xd8f687d2, _r, _ri);
};

window.NetworkGetNetworkIdFromEntity = function (entity) {
	return _in(0xa1170068, 0x2f3ad45c, entity, _r, _ri);
};

/**
 * Returns the amount of players connected in the current session. Only works when connected to a session/server.
 */
window.NetworkGetNumConnectedPlayers = function () {
	return _in(0xa4a79dd2, 0xd9600654, _r, _ri);
};

window.NetworkGetNumFoundGamers = function () {
	return _in(0xa1b043ee, 0x79a916fb, _r, _ri);
};

window.NetworkGetNumParticipants = function () {
	return _in(0x18d0456e, 0x86604654, _r, _ri);
};

/**
 * Seems to always return 0, but it's used in quite a few loops.
 * for (num3 = 0; num3 < NETWORK::0xCCD8C02D(); num3++)
 * {
 * if (NETWORK::NETWORK_IS_PARTICIPANT_ACTIVE(PLAYER::0x98F3B274(num3)) != 0)
 * {
 * var num5 = NETWORK::NETWORK_GET_PLAYER_INDEX(PLAYER::0x98F3B274(num3));
 */
window.NetworkGetNumParticipantsHost = function () {
	return _in(0xa6c90fbc, 0x38e395ee, _r, _ri);
};

window.NetworkGetNumPresenceInvites = function () {
	return _in(0xcefa9689, 0x12d0f78d, _r, _ri);
};
window.N_0xcefa968912d0f78d = window.NetworkGetNumPresenceInvites;

window.NetworkGetNumScriptParticipants = function (p1, p2) {
	return _in(0x3658e8cd, 0x94fc121a, _i, p1, p2, _r, _ri);
};
window.N_0x3658e8cd94fc121a = window.NetworkGetNumScriptParticipants;

window.NetworkGetParticipantIndex = function (index) {
	return _in(0x1b84df6a, 0xf2a46938, index, _r, _ri);
};

/**
 * Returns the coordinates of another player.
 * Does not work if you enter your own player id as p0 (will return `(0.0, 0.0, 0.0)` in that case).
 * @param player The player id, MUST be another player.
 * @return A Vector3 containing the coordinates of another player.
 */
window.NetworkGetPlayerCoords = function (player) {
	return _in(0x125e6d63, 0x8b8605d4, player, _r, _rv);
};
window.N_0x125e6d638b8605d4 = window.NetworkGetPlayerCoords;

window.NetworkGetPlayerCrewEmblemTxdName = function () {
	return _in(0x5835d9cd, 0x92e83184, _i, _i, _r);
};
window.N_0x5835d9cd92e83184 = window.NetworkGetPlayerCrewEmblemTxdName;

window.NetworkGetPlayerFromGamerHandle = function (networkHandle) {
	return _in(0xce5f689c, 0xf5a0a49d, _ii(networkHandle) /* may be optional */, _r, _ri);
};

window.NetworkGetPlayerIndex = function (player) {
	return _in(0x24fb80d1, 0x07371267, player, _r, _ri);
};

/**
 * Returns the Player associated to a given Ped when in an online session.
 */
window.NetworkGetPlayerIndexFromPed = function (ped) {
	return _in(0x6c0e2e01, 0x25610278, ped, _r, _ri);
};
window.N_0x6c0e2e0125610278 = window.NetworkGetPlayerIndexFromPed;

window.NetworkGetPlayerLoudness = function (p0) {
	return _in(0x21a1684a, 0x25c2867f, p0, _r, _rf);
};

window.NetworkGetPresenceInviteHandle = function (p0, p1) {
	return _in(0x38d5b0fe, 0xbb086f75, p0, _ii(p1) /* may be optional */, _r);
};

window.NetworkGetPresenceInviteId = function (p0) {
	return _in(0xdff09646, 0xe12ec386, p0, _r, _ri);
};
window.N_0xdff09646e12ec386 = window.NetworkGetPresenceInviteId;

window.NetworkGetPresenceInviteInviter = function (p0) {
	return _in(0x4962cc4a, 0xa2f345b7, p0, _r, _ri);
};
window.N_0x4962cc4aa2f345b7 = window.NetworkGetPresenceInviteInviter;

window.NetworkGetPresenceInviteSessionId = function (p0) {
	return _in(0x26e1cd96, 0xb0903d60, p0, _r, _ri);
};
window.N_0x26e1cd96b0903d60 = window.NetworkGetPresenceInviteSessionId;

window.NetworkGetPrimaryClanDataCancel = function () {
	return _in(0x042e4b70, 0xb93e6054);
};
window.N_0x042e4b70b93e6054 = window.NetworkGetPrimaryClanDataCancel;

window.NetworkGetPrimaryClanDataClear = function () {
	return _in(0x9aa46bad, 0xad0e27ed, _r, _ri);
};
window.N_0x9aa46badad0e27ed = window.NetworkGetPrimaryClanDataClear;

window.NetworkGetPrimaryClanDataNew = function () {
	return _in(0xc080ff65, 0x8b2e41da, _i, _i, _r);
};

window.NetworkGetPrimaryClanDataPending = function () {
	return _in(0xb5074db8, 0x04e28ce7, _r, _ri);
};
window.N_0xb5074db804e28ce7 = window.NetworkGetPrimaryClanDataPending;

window.NetworkGetPrimaryClanDataStart = function (p1) {
	return _in(0xce86d819, 0x1b762107, _i, p1, _r);
};

window.NetworkGetPrimaryClanDataSuccess = function () {
	return _in(0x5b4f04f1, 0x9376a0ba, _r, _ri);
};
window.N_0x5b4f04f19376a0ba = window.NetworkGetPrimaryClanDataSuccess;

window.NetworkGetRandomInt = function () {
	return _in(0x599e4fa1, 0xf87eb5ff, _r, _ri);
};
window.N_0x599e4fa1f87eb5ff = window.NetworkGetRandomInt;

/**
 * Same as GAMEPLAY::GET_RANDOM_INT_IN_RANGE
 */
window.NetworkGetRandomIntInRange = function (rangeStart, rangeEnd) {
	return _in(0xe30cf56f, 0x1efa5f43, rangeStart, rangeEnd, _r, _ri);
};
window.N_0xe30cf56f1efa5f43 = window.NetworkGetRandomIntInRange;

/**
 * Based on scripts such as in freemode.c how they call their vars vVar and fVar the 2nd and 3rd param it a Vector3 and Float, but the first is based on get_random_int_in_range..
 */
window.NetworkGetRespawnResult = function (randomInt) {
	return _in(0x371ea436, 0x92861cf1, randomInt, _v, _f);
};

window.NetworkGetScriptStatus = function () {
	return _in(0x57d15864, 0x7a6bfabf, _r, _ri);
};

window.NetworkGetServerTime = function () {
	return _in(0x6d03bfbd, 0x643b2a02, _i, _i, _i);
};
window.N_0x6d03bfbd643b2a02 = window.NetworkGetServerTime;

window.NetworkGetTalkerProximity = function () {
	return _in(0x84f0f131, 0x20b4e098, _r, _ri);
};

window.NetworkGetThisScriptIsNetworkScript = function () {
	return _in(0x29106699, 0x69e9535e, _r);
};

/**
 * Returns the value of the tunable 0x9A82F2B. Usually 8000 iirc.
 */
window.NetworkGetTimeoutTime = function () {
	return _in(0x5ed0356a, 0x0ce3a34f, _r, _ri);
};
window.N_0x5ed0356a0ce3a34f = window.NetworkGetTimeoutTime;

window.NetworkGetTransitionHost = function (networkHandle) {
	return _in(0x65042b97, 0x74c4435e, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkGetTransitionMembers = function (p1) {
	return _in(0x73b000f7, 0xfbc55829, _i, p1, _r, _ri);
};

window.NetworkGetVcBalance = function () {
	return _in(0x5cbad97e, 0x059e1b94, _r, _ri);
};
window.N_0x5cbad97e059e1b94 = window.NetworkGetVcBalance;

/**
 * From what I can see in ida, I believe it retrieves the players online bank balance.
 */
window.NetworkGetVcBankBalance = function () {
	return _in(0x76ef28da, 0x05ea395a, _r, _ri);
};
window.N_0x76ef28da05ea395a = window.NetworkGetVcBankBalance;

/**
 * From what I understand, it retrieves STAT_WALLET_BALANCE for the specified character (-1 means use MPPLY_LAST_MP_CHAR)
 */
window.NetworkGetVcWalletBalance = function (character) {
	return _in(0xa40f9c26, 0x23f6a8b5, character, _r, _ri);
};
window.N_0xa40f9c2623f6a8b5 = window.NetworkGetVcWalletBalance;

window.NetworkGivePlayerJobshareCash = function (amount, networkHandle) {
	return _in(0xfb18df9c, 0xb95e0105, amount, _ii(networkHandle) /* may be optional */);
};

window.NetworkHandleFromFriend = function (friendIndex, bufferSize) {
	return _in(0xd45cb817, 0xd7e177d2, friendIndex, _i, bufferSize);
};

/**
 * Returns a NetworkHandle* from the specified member ID and stores it in a given buffer.
 * * Currently unknown struct
 */
window.NetworkHandleFromMemberId = function (memberId, bufferSize) {
	return _in(0xa0fd21be, 0xd61e5c4c, _ts(memberId), _i, bufferSize);
};

/**
 * Returns a handle to networkHandle* from the specified player handle and stores it in a given buffer.
 * * Currently unknown struct
 * Example:
 * std::vector<UINT64> GetPlayerNetworkHandle(Player player) {
 * const int size = 13;
 * uint64_t *buffer = std::make_unique<uint64_t[]>(size).get();
 * NETWORK::NETWORK_HANDLE_FROM_PLAYER(player, reinterpret_cast<int *>(buffer), 13);
 * for (int i = 0; i < size; i++) {
 * Log::Msg("networkhandle[%i]: %llx", i, buffer[i]);
 * }
 * std::vector<UINT64> result(buffer, buffer + sizeof(buffer));
 * return result;
 * }
 */
window.NetworkHandleFromPlayer = function (player, bufferSize) {
	return _in(0x388eb2b8, 0x6c73b6b3, player, _i, bufferSize);
};

/**
 * Returns a NetworkHandle* from the specified user ID and stores it in a given buffer.
 * * Currently unknown struct
 */
window.NetworkHandleFromUserId = function (userId, bufferSize) {
	return _in(0xdcd51dd8, 0xf87aec5c, _ts(userId), _i, bufferSize);
};

window.NetworkHasControlOfDoor = function (doorHash) {
	return _in(0xcb3c68ad, 0xb06195df, _ch(doorHash), _r);
};

window.NetworkHasControlOfEntity = function (entity) {
	return _in(0x01bf60a5, 0x00e28887, entity, _r);
};

window.NetworkHasControlOfNetworkId = function (netId) {
	return _in(0x4d36070f, 0xe0215186, netId, _r);
};

/**
 * console hash: 0xD14D9C07
 */
window.NetworkHasControlOfPavementStats = function (doorHash) {
	return _in(0xc01e93fa, 0xc20c3346, _ch(doorHash), _r);
};
window.N_0xc01e93fac20c3346 = window.NetworkHasControlOfPavementStats;

window.NetworkHasControlOfPickup = function (pickup) {
	return _in(0x5bc9495f, 0x0b3b6fa6, pickup, _r);
};

window.NetworkHasFollowInvite = function () {
	return _in(0x76d9b976, 0xc4c09fde, _r);
};
window.N_0x76d9b976c4c09fde = window.NetworkHasFollowInvite;

window.NetworkHasHeadset = function () {
	return _in(0xe870f9f1, 0xf7b4f1fa, _r);
};

window.NetworkHasInvitedGamer = function (p0) {
	return _in(0x4d86cd31, 0xe8976ece, _ii(p0) /* may be optional */, _r);
};

window.NetworkHasInvitedGamerToTransition = function (p0) {
	return _in(0x7284a47b, 0x3540e6cf, _ii(p0) /* may be optional */, _r);
};

window.NetworkHasPendingInvite = function () {
	return _in(0xac8c7b9b, 0x88c4a668, _r);
};

window.NetworkHasPlayerStartedTransition = function (player) {
	return _in(0x9ac9ccbf, 0xa8c29795, player, _r);
};

/**
 * console hash: 0x5AC9F04D = network_hash_from_gamer_handle
 */
window.NetworkHashFromGamerHandle = function (networkHandle) {
	return _in(0x58575ac3, 0xcf2ca8ec, _ii(networkHandle) /* may be optional */, _r, _ri);
};
window.N_0x58575ac3cf2ca8ec = window.NetworkHashFromGamerHandle;

/**
 * console hash: 0xF8D7AF3B = NETWORK_HASH_FROM_PLAYER_HANDLE
 */
window.NetworkHashFromPlayerHandle = function (player) {
	return _in(0xbc1d768f, 0x2f5d6c05, player, _r, _ri);
};
window.N_0xbc1d768f2f5d6c05 = window.NetworkHashFromPlayerHandle;

window.NetworkHaveOnlinePrivileges = function () {
	return _in(0x25cb5a9f, 0x37bfd063, _r);
};

/**
 * From what I can tell it looks like it does the following:
 * Creates/hosts a new transition to another online session, using this in FiveM will result in other players being disconencted from the server/preventing them from joining. This is most likely because I entered the wrong session parameters since they're pretty much all unknown right now.
 * You also need to use `NetworkJoinTransition(Player player)` and `NetworkLaunchTransition()`.
 * @param p0 Unknown int
 * @param p1 Unknown int
 * @param p2 Unknown int
 * @param p3 Unknown int
 * @param p4 Unknown always 0 in decompiled scripts
 * @param p5 BOOL purpose unknown, both 0 and 1 are used in decompiled scripts.
 * @param p6 BOOL purpose unknown, both 0 and 1 are used in decompiled scripts.
 * @param p7 Unknown int, it's an int according to decompiled scripts, however the value is always 0 or 1.
 * @param p8 Unknown int, it's an int according to decompiled scripts, however the value is always 0 or 1.
 * @param p9 Unknown int, sometimes 0, but also 32768 or 16384 appear in decompiled scripst, maybe a flag of some sort?
 * @return Probably a bool indicating if the transition was created.
 */
window.NetworkHostTransition = function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
	return _in(0xa60bb5ce, 0x242bb254, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, _r);
};

window.NetworkInitializeCash = function (p0, p1) {
	return _in(0x3da5ecd1, 0xa56cba6d, p0, p1);
};
window.N_0x3da5ecd1a56cba6d = window.NetworkInitializeCash;

/**
 * //nothing doin
 * int Global_1837683 = GlobalVariable::Get(1837683);
 * int Global_1837683_f_404 = GlobalVariable::Get(1837683 + 404);
 * NETWORK_INVITE_GAMERS(&Global_1837683, Global_1837683_f_404, 0, 0);
 */
window.NetworkInviteGamers = function (p1) {
	return _in(0x9d80cd1d, 0x0e6327de, _i, p1, _i, _i, _r);
};

window.NetworkInviteGamersToTransition = function (p1) {
	return _in(0x4a595c32, 0xf77dff76, _i, p1, _r);
};

window.NetworkIsActivitySession = function () {
	return _in(0x05095437, 0x424397fa, _r);
};

window.NetworkIsActivitySpectator = function () {
	return _in(0x12103b9e, 0x0c9f92fb, _r, _ri);
};

window.NetworkIsActivitySpectatorFromHandle = function (networkHandle) {
	return _in(0x2763bbaa, 0x72a7bcb9, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkIsAddingFriend = function () {
	return _in(0x6ea10160, 0x6f6e4d81, _r);
};

window.NetworkIsCableConnected = function () {
	return _in(0xeffb2545, 0x3d8600f9, _r);
};
window.N_0xeffb25453d8600f9 = window.NetworkIsCableConnected;

/**
 * This would be nice to see if someone is in party chat, but 2 sad notes.
 * 1) It only becomes true if said person is speaking in that party at the time.
 * 2) It will never, become true unless you are in that party with said person.
 */
window.NetworkIsChattingInPlatformParty = function (networkHandle) {
	return _in(0x8de9945b, 0xcc9aec52, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkIsClanMembershipFinishedDownloading = function () {
	return _in(0xb3f64a6a, 0x91432477, _r);
};
window.N_0xb3f64a6a91432477 = window.NetworkIsClanMembershipFinishedDownloading;

window.NetworkIsClockTimeOverridden = function () {
	return _in(0xd7c95d32, 0x2ff57522, _r);
};
window.N_0xd7c95d322ff57522 = window.NetworkIsClockTimeOverridden;

window.NetworkIsCloudAvailable = function () {
	return _in(0x9a4cf4f4, 0x8ad77302, _r);
};

window.NetworkIsFindingGamers = function () {
	return _in(0xdddf64c9, 0x1bfcf0aa, _r);
};

window.NetworkIsFriend = function (networkHandle) {
	return _in(0x1a24a179, 0xf9b31654, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkIsFriendInMultiplayer = function (friendName) {
	return _in(0x57005c18, 0x827f3a28, _ts(friendName), _r);
};

/**
 * In scripts R* calls 'NETWORK_GET_FRIEND_NAME' in this param.
 */
window.NetworkIsFriendInSameTitle = function (friendName) {
	return _in(0x2ea9a3be, 0xdf3f17b8, _ts(friendName), _r);
};

window.NetworkIsFriendIndexOnline = function (friendIndex) {
	return _in(0xbad8f2a4, 0x2b844821, friendIndex, _r);
};
window.N_0xbad8f2a42b844821 = window.NetworkIsFriendIndexOnline;

window.NetworkIsFriendOnline = function (name) {
	return _in(0x425a4453, 0x3437b64d, _ts(name), _r);
};

window.NetworkIsFriendOnline_2 = function (networkHandle) {
	return _in(0x87eb7a3f, 0xfcb314db, _ii(networkHandle) /* may be optional */, _r);
};
window.N_0x87eb7a3ffcb314db = window.NetworkIsFriendOnline_2;

window.NetworkIsGameInProgress = function () {
	return _in(0x10fab354, 0x28ccc9d7, _r);
};

window.NetworkIsGamerBlockedByMe = function (p0) {
	return _in(0xe944c4f5, 0xaf1b5883, _ii(p0) /* may be optional */, _r);
};

window.NetworkIsGamerInMySession = function (networkHandle) {
	return _in(0x0f10b05d, 0xdf8d16e9, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkIsGamerMutedByMe = function (p0) {
	return _in(0xce60de01, 0x1b6c7978, _ii(p0) /* may be optional */, _r);
};

window.NetworkIsGamerTalking = function (p0) {
	return _in(0x71c33b22, 0x606cd88a, _ii(p0) /* may be optional */, _r);
};

window.NetworkIsHandleValid = function (bufferSize) {
	return _in(0x6f79b93b, 0x0a8e4133, _i, bufferSize, _r);
};

/**
 * If you are host, returns true else returns false.
 * anyone know how to use this to find correct host? is possible?
 * go to a mission and it will set a host then search the host name using a program then find the pointer to the host name
 */
window.NetworkIsHost = function () {
	return _in(0x8db296b8, 0x14edda07, _r);
};

window.NetworkIsHostOfThisScript = function () {
	return _in(0x83cd99a1, 0xe6061ab5, _r);
};

window.NetworkIsInMpCutscene = function () {
	return _in(0x6cc27c9f, 0xa2040220, _r);
};

/**
 * Note according to IDA TU27 X360(Console),
 * This native & 'NETWORK_IS_PARTY_MEMBER' both jump to the same location.
 * Side note: This location just stops where it's at once jumped to.
 * Screenshot for side note,
 * h t t p ://i.imgur.com/m2ci1mF.png
 * h t t p://i.imgur.com/Z0Wx2B6.png
 */
window.NetworkIsInParty = function () {
	return _in(0x966c2bc2, 0xa7fe3f30, _r);
};

window.NetworkIsInSession = function () {
	return _in(0xca972461, 0x03b63917, _r);
};

window.NetworkIsInSpectatorMode = function () {
	return _in(0x048746e3, 0x88762e11, _r);
};

window.NetworkIsInTransition = function () {
	return _in(0x68049aef, 0xf83d8f0a, _r);
};

window.NetworkIsInTutorialSession = function () {
	return _in(0xada24309, 0xfe08dacf, _r, _ri);
};

window.NetworkIsInactiveProfile = function (p0) {
	return _in(0x7e587455, 0x04313a2e, _ii(p0) /* may be optional */, _r);
};

window.NetworkIsLocalPlayerInvincible = function () {
	return _in(0x8a8694b4, 0x8715b000, _r);
};

window.NetworkIsMultiplayerDisabled = function () {
	return _in(0x97472928, 0x07126eda, _r, _ri);
};
window.N_0x9747292807126eda = window.NetworkIsMultiplayerDisabled;

window.NetworkIsParticipantActive = function (p0) {
	return _in(0x6ff8ff40, 0xb6357d45, p0, _r);
};

/**
 * Note according to IDA TU27 X360(Console),
 * This native & 'NETWORK_IS_PARTY_MEMBER' both jump to the same location.
 * Side note: This location just stops where it's at once jumped to.
 * Screenshot for side note,
 * h t t p ://i.imgur.com/m2ci1mF.png
 * h t t p://i.imgur.com/Z0Wx2B6.png
 */
window.NetworkIsPartyMember = function (networkHandle) {
	return _in(0x676ed266, 0xaadd31e0, _ii(networkHandle) /* may be optional */, _r);
};

/**
 * This function is hard-coded to always return 0.
 */
window.NetworkIsPendingFriend = function (p0) {
	return _in(0x0be73da6, 0x984a6e33, p0, _r);
};

window.NetworkIsPlayerAParticipant = function (p0) {
	return _in(0x3ca58f6c, 0xb7cbd784, p0, _r);
};

window.NetworkIsPlayerActive = function (player) {
	return _in(0xb8dfd30d, 0x6973e135, player, _r);
};

/**
 * hash collision
 */
window.NetworkIsPlayerAnimationDrawingSynchronized = function () {
	return _in(0xc6f8ab8a, 0x4189cf3a);
};

window.NetworkIsPlayerBlockedByMe = function (player) {
	return _in(0x57af1f8e, 0x27483721, player, _r);
};

window.NetworkIsPlayerConnected = function (player) {
	return _in(0x93dc1be4, 0xe1abe9d1, player, _r);
};

/**
 * NETWORK_ARE_*
 */
window.NetworkIsPlayerEqualToIndex = function (player, index) {
	return _in(0x9de986fc, 0x9a87c474, player, index, _r);
};
window.N_0x9de986fc9a87c474 = window.NetworkIsPlayerEqualToIndex;

window.NetworkIsPlayerInMpCutscene = function (player) {
	return _in(0x63f9ee20, 0x3c3619f2, player, _r);
};

/**
 * p1 = 6
 * NETWORK_CRC_HASH_CHECK?
 */
window.NetworkIsPlayerInScript = function (player, p1, scriptHash) {
	return _in(0x46fb3ed4, 0x15c7641c, player, p1, _ch(scriptHash), _r);
};
window.N_0x46fb3ed415c7641c = window.NetworkIsPlayerInScript;

window.NetworkIsPlayerMutedByMe = function (player) {
	return _in(0x8c71288a, 0xe68ede39, player, _r);
};

/**
 * returns true if someone is screaming or talking in a microphone
 */
window.NetworkIsPlayerTalking = function (player) {
	return _in(0x031e11f3, 0xd447647e, player, _r);
};

window.NetworkIsPsnAvailable = function () {
	return _in(0x8d11e61a, 0x4abf49cc, _r);
};
window.N_0x8d11e61a4abf49cc = window.NetworkIsPsnAvailable;

window.NetworkIsScriptActive = function (scriptName, player, p2, p3) {
	return _in(0x9d40df90, 0xfad26098, _ts(scriptName), player, p2, p3, _r);
};

window.NetworkIsSessionActive = function () {
	return _in(0xd83c2b94, 0xe7508980, _r);
};

window.NetworkIsSessionBusy = function () {
	return _in(0xf4435d66, 0xa8e2905e, _r);
};

/**
 * This checks if player is playing on gta online or not.
 * Please add an if and block your mod if this is "true".
 */
window.NetworkIsSessionStarted = function () {
	return _in(0x9de624d2, 0xfc4b603f, _r);
};

/**
 * Returns whether the player is signed into Social Club.
 */
window.NetworkIsSignedIn = function () {
	return _in(0x054354a9, 0x9211eb96, _r);
};

/**
 * Returns whether the game is not in offline mode.
 * seemed not to work for some ppl
 */
window.NetworkIsSignedOnline = function () {
	return _in(0x1077788e, 0x268557c2, _r);
};

/**
 * Same as _IS_TEXT_CHAT_ACTIVE, except it does not check if the text chat HUD component is initialized, and therefore may crash.
 */
window.NetworkIsTextChatActive = function () {
	return _in(0x5fcf4d70, 0x69b09026, _r);
};

window.NetworkIsThisScriptMarked = function (p0, p1, p2) {
	return _in(0xd1110739, 0xeeadb592, p0, p1, p2, _r);
};
window.N_0xd1110739eeadb592 = window.NetworkIsThisScriptMarked;
window.NetworkSetThisScriptMarked = window.NetworkIsThisScriptMarked;

window.NetworkIsTransitionBusy = function () {
	return _in(0x520f3282, 0xa53d26b7, _r, _ri);
};

window.NetworkIsTransitionHost = function () {
	return _in(0x0b824797, 0xc9bf2159, _r, _ri);
};

window.NetworkIsTransitionHostFromHandle = function (networkHandle) {
	return _in(0x6b5c83ba, 0x3efe6a10, _ii(networkHandle) /* may be optional */, _r);
};

window.NetworkIsTransitionMatchmaking = function () {
	return _in(0x292564c7, 0x35375edf, _r, _ri);
};
window.N_0x292564c735375edf = window.NetworkIsTransitionMatchmaking;

window.NetworkIsTransitionStarted = function () {
	return _in(0x53fa8340, 0x1d9c07fe, _r);
};

window.NetworkIsTransitionToGame = function () {
	return _in(0x9d7696d8, 0xf4fa6cb7, _r, _ri);
};

window.NetworkJoinGroupActivity = function () {
	return _in(0xa06509a6, 0x91d12be4, _r, _ri);
};
window.N_0xa06509a691d12be4 = window.NetworkJoinGroupActivity;

/**
 * int handle[76];
 * NETWORK_HANDLE_FROM_FRIEND(iSelectedPlayer, &handle[0], 13);
 * Player uVar2 = NETWORK_GET_PLAYER_FROM_GAMER_HANDLE(&handle[0]);
 * NETWORK_JOIN_TRANSITION(uVar2);
 * nothing doin.
 */
window.NetworkJoinTransition = function (player) {
	return _in(0x9d060b08, 0xcd63321a, player, _r);
};

window.NetworkLaunchTransition = function () {
	return _in(0x2dcf46cb, 0x1a4f0884, _r, _ri);
};

window.NetworkLeaveTransition = function () {
	return _in(0xd23a1a81, 0x5d21db19, _r, _ri);
};

window.NetworkMarkTransitionGamerAsFullyJoined = function (p0) {
	return _in(0x5728bb6d, 0x63e3ff1d, _ii(p0) /* may be optional */, _r);
};

window.NetworkMemberIdFromGamerHandle = function (networkHandle) {
	return _in(0xc8263013, 0x2081bb6f, _ii(networkHandle) /* may be optional */, _r, _s);
};

window.NetworkMoneyCanBet = function (p0, p1, p2) {
	return _in(0x81404f3d, 0xc124fe5b, p0, p1, p2, _r);
};
window.N_0x81404f3dc124fe5b = window.NetworkMoneyCanBet;

window.NetworkOpenTransitionMatchmaking = function () {
	return _in(0x2b3a8f7c, 0xa3a38fde);
};
window.N_0x2b3a8f7ca3a38fde = window.NetworkOpenTransitionMatchmaking;

/**
 * Could possibly bypass being muted or automatically muted
 */
window.NetworkOverrideChatRestrictions = function (player, toggle) {
	return _in(0x3039ae5a, 0xd2c9c0c4, player, toggle);
};
window.N_0x3039ae5ad2c9c0c4 = window.NetworkOverrideChatRestrictions;

/**
 * Works in Singleplayer too.
 * Actually has a 4th param (BOOL) that sets byte_14273C46C (in b944) to whatever was passed to p3.
 */
window.NetworkOverrideClockTime = function (Hours, Minutes, Seconds) {
	return _in(0xe679e3e0, 0x6e363892, Hours, Minutes, Seconds);
};

/**
 * R* uses this to hear all player when spectating.
 * It allows you to hear other online players when their chat is on none, crew and or friends
 */
window.NetworkOverrideReceiveRestrictions = function (player, toggle) {
	return _in(0xddf73e2b, 0x1fec5ab4, player, toggle);
};
window.N_0xddf73e2b1fec5ab4 = window.NetworkOverrideReceiveRestrictions;

/**
 * Console Hash: 0x6C344AE3
 * "NETWORK_OVERRIDE_SEND_RESTRICTIONS" is right, but dev-c put a _ by default.
 * This is used alongside the native,
 * 'NETWORK_OVERRIDE_RECEIVE_RESTRICTIONS'. Read it's description for more info.
 */
window.NetworkOverrideSendRestrictions = function (player, toggle) {
	return _in(0x97dd4c59, 0x44cc2e6a, player, toggle);
};
window.N_0x97dd4c5944cc2e6a = window.NetworkOverrideSendRestrictions;

window.NetworkOverrideTransitionChat = function (p0) {
	return _in(0xaf66059a, 0x131aa269, p0);
};
window.N_0xaf66059a131aa269 = window.NetworkOverrideTransitionChat;

window.NetworkPayEmployeeWage = function (p0, p1, p2) {
	return _in(0x5fd5ed82, 0xcbbe9989, p0, p1, p2);
};
window.N_0x5fd5ed82cbbe9989 = window.NetworkPayEmployeeWage;

window.NetworkPayMatchEntryFee = function (value, p2, p3) {
	return _in(0x9346e14f, 0x2af74d46, value, _i, p2, p3);
};
window.N_0x9346e14f2af74d46 = window.NetworkPayMatchEntryFee;

window.NetworkPayUtilityBill = function (p0, p1, p2) {
	return _in(0xafe08b35, 0xec0c9eae, p0, p1, p2);
};
window.N_0xafe08b35ec0c9eae = window.NetworkPayUtilityBill;

/**
 * Returns the name of a given player. Returns "**Invalid**" if CPlayerInfo of the given player cannot be retrieved or the player doesn't exist.
 * Does exactly the same as GET_PLAYER_NAME.
 */
window.NetworkPlayerGetName = function (player) {
	return _in(0x7718d2e2, 0x060837d2, player, _r, _s);
};

/**
 * Sets [userID] to the user id of the given player. Returns "**Invalid**" if CPlayerInfo of the given player cannot be retrieved or the player doesn't exist.
 */
window.NetworkPlayerGetUserid = function (player, userID) {
	return _in(0x4927fc39, 0xcd0869a0, player, _ts(userID), _r, _s);
};
window.NetworkPlayerGetUserId = window.NetworkPlayerGetUserid;

window.NetworkPlayerHasHeadset = function (player) {
	return _in(0x3fb99a8b, 0x08d18fd6, player, _r);
};

/**
 * Does exactly the same thing as PLAYER_ID()
 */
window.NetworkPlayerIdToInt = function () {
	return _in(0xee68096f, 0x9f37341e, _r, _ri);
};

/**
 * Returns whether the player has been reported too often or not.
 * Example : griefing.
 */
window.NetworkPlayerIsBadsport = function () {
	return _in(0x19d8da0e, 0x5a68045a, _r);
};

window.NetworkPlayerIsCheater = function () {
	return _in(0x655b91f1, 0x495a9090, _r);
};

window.NetworkPlayerIsInClan = function () {
	return _in(0x579cced0, 0x265d4896, _r);
};

/**
 * Checks if a specific value (BYTE) in CPlayerInfo is nonzero.
 * Returns always false in Singleplayer.
 * No longer used for dev checks since first mods were released on PS3 & 360.
 * R* now checks with the is_dlc_present native for the dlc hash 2532323046,
 * if that is present it will unlock dev stuff.
 */
window.NetworkPlayerIsRockstarDev = function (player) {
	return _in(0x544abdda, 0x3b409b6d, player, _r);
};

/**
 * fuck this function in particular.
 * It's similar to unk_0x9A176B6E but this ones got a different stat hash:
 * 0xBC707798
 */
window.NetworkPlayerIsUnk = function () {
	return _in(0x172f75b6, 0xee2233ba, _r);
};
window.N_0x172f75b6ee2233ba = window.NetworkPlayerIsUnk;

/**
 * NETWORK_PLAYER_???
 */
window.NetworkPlayerSomething = function (player) {
	return _in(0x565e430d, 0xb3b05bec, player, _r);
};
window.N_0x565e430db3b05bec = window.NetworkPlayerSomething;

window.NetworkReceivePlayerJobshareCash = function (value, networkHandle) {
	return _in(0x56a3b519, 0x44c50598, value, _ii(networkHandle) /* may be optional */);
};

/**
 * index
 * -------
 * See function sub_1005 in am_boat_taxi.ysc
 * context
 * ----------
 * "BACKUP_VAGOS"
 * "BACKUP_LOST"
 * "BACKUP_FAMILIES"
 * "HIRE_MUGGER"
 * "HIRE_MERCENARY"
 * "BUY_CARDROPOFF"
 * "HELI_PICKUP"
 * "BOAT_PICKUP"
 * "CLEAR_WANTED"
 * "HEAD_2_HEAD"
 * "CHALLENGE"
 * "SHARE_LAST_JOB"
 * "DEFAULT"
 * reason
 * ---------
 * "NOTREACHTARGET"
 * "TARGET_ESCAPE"
 * "DELIVERY_FAIL"
 * "NOT_USED"
 * "TEAM_QUIT"
 * "SERVER_ERROR"
 * "RECEIVE_LJ_L"
 * "CHALLENGE_PLAYER_LEFT"
 * "DEFAULT"
 * unk
 * -----
 * Unknown bool value
 */
window.NetworkRefundCash = function (index, context, reason, unk) {
	return _in(0xf9c812cd, 0x7c46e817, index, _ts(context), _ts(reason), unk);
};
window.N_0xf9c812cd7c46e817 = window.NetworkRefundCash;

window.NetworkRegisterEntityAsNetworked = function (entity) {
	return _in(0x06faacd6, 0x25d80caa, entity);
};
window.N_0x06faacd625d80caa = window.NetworkRegisterEntityAsNetworked;

/**
 * sizeofVars is in bytes
 */
window.NetworkRegisterHostBroadcastVariables = function (sizeofVars) {
	return _in(0x3e9b2f01, 0xc50df595, _i, sizeofVars);
};

window.NetworkRegisterPlayerBroadcastVariables = function (numVars) {
	return _in(0x3364aa97, 0x340ca215, _i, numVars);
};

window.NetworkRemoveAllTransitionInvite = function () {
	return _in(0x726e0375, 0xc7a26368);
};
window.N_0x726e0375c7a26368 = window.NetworkRemoveAllTransitionInvite;

window.NetworkRemoveEntityArea = function (p0) {
	return _in(0x93cf869b, 0xaa0c4874, p0, _r);
};

window.NetworkRemovePresenceInvite = function (p0) {
	return _in(0xf0210268, 0xdb0974b1, p0, _r);
};
window.N_0xf0210268db0974b1 = window.NetworkRemovePresenceInvite;

window.NetworkRemoveTransitionInvite = function (p0) {
	return _in(0x7524b431, 0xb2e6f7ee, _ii(p0) /* may be optional */);
};

/**
 * NETWORK_REQUEST_CLOUD_BACKGROUND_SCRIPTS - Correct console hash is 0x98EFB921
 * Start the downloading of BG_NG.RPF from R* Cloud which contains hotfix.
 * The console hash given is incorrect for Xbox360 that is. I searched in IDA and found 0x98EFB921 which came right after 0x155465EE. Then I searched it in TU27 X360 scripts and found it was the same results same scripts as the PC Hash for this which is obviously correct. I found the correct one as I noticed TU27 X360 script search pulled no results for 0x29532731 when it should have.
 * As you can see here you will see the 155465EE first then the correct hash for this native. Then the current 29532731 one which could be the native below or the native below's hash could be the has below the 29532731
 * puu.sh/nhdQI/e0ca5567b4.png
 * 0x98EFB921 is the correct console hash for "_DOWNLOAD_BG_SCRIPT_RPF". 0x29532731 is "_HAS_BG_SCRIPT_BEEN_DOWNLOADED"
 * The code:
 * seg001:00000000003EFF4C uunk_0x29532731:                        # CODE XREF: sub_158C8AC+14p
 * seg001:00000000003EFF4C                 lis       r3, dword_1CFB100@ha
 * seg001:00000000003EFF50                 lwz       r3, dword_1CFB100@l(r3)
 * seg001:00000000003EFF54                 ld        r3, 0x1020(r3)
 * seg001:00000000003EFF58                 extsw     r3, r3
 * seg001:00000000003EFF5C                 blr
 * seg001:00000000003EFF5C # End of function uunk_0x29532731
 */
window.NetworkRequestCloudBackgroundScripts = function () {
	return _in(0x924426bf, 0xfd82e915, _r);
};
window.N_0x924426bffd82e915 = window.NetworkRequestCloudBackgroundScripts;

/**
 * This native start the download of tunables from R* cloud
 */
window.NetworkRequestCloudTunables = function () {
	return _in(0x42fb3b53, 0x2d526e6c);
};
window.N_0x42fb3b532d526e6c = window.NetworkRequestCloudTunables;

window.NetworkRequestControlOfDoor = function (doorID) {
	return _in(0x870ddfd5, 0xa4a796e4, doorID, _r);
};

window.NetworkRequestControlOfEntity = function (entity) {
	return _in(0xb69317bf, 0x5e782347, entity, _r);
};

window.NetworkRequestControlOfNetworkId = function (netId) {
	return _in(0xa670b366, 0x2faffbd0, netId, _r);
};

/**
 * hash collision?? - Not sure, but fits alphabetically
 */
window.NetworkResetBodyTracker = function () {
	return _in(0x72433699, 0xb4e6dd64);
};

/**
 * p4 and p5 are always 0 in scripts
 */
window.NetworkRespawnCoords = function (player, x, y, z, p4, p5) {
	return _in(0x9769f811, 0xd1785b03, player, _fv(x), _fv(y), _fv(z), p4, p5);
};
window.N_0x9769f811d1785b03 = window.NetworkRespawnCoords;

window.NetworkResurrectLocalPlayer = function (x, y, z, heading, unk, changetime) {
	return _in(0xea23c49e, 0xaa83acfb, _fv(x), _fv(y), _fv(z), _fv(heading), unk, changetime);
};

/**
 * p0 = 0 or 4
 */
window.NetworkSctvSlots = function (p0) {
	return _in(0x49ec8030, 0xf5015f8b, p0);
};
window.N_0x49ec8030f5015f8b = window.NetworkSctvSlots;

window.NetworkSendPresenceInvite = function (p2, p3) {
	return _in(0xc3c7a6af, 0xdb244624, _i, _i, p2, p3, _r);
};
window.N_0xc3c7a6afdb244624 = window.NetworkSendPresenceInvite;

/**
 * String "NETWORK_SEND_PRESENCE_TRANSITION_INVITE" is contained in the function in ida so this one is correct.
 */
window.NetworkSendPresenceTransitionInvite = function (p2, p3) {
	return _in(0xc116ff9b, 0x4d488291, _i, _i, p2, p3, _r);
};
window.N_0xc116ff9b4d488291 = window.NetworkSendPresenceTransitionInvite;

/**
 * how can I increase the character limit on this native?
 * --------------------------------
 * return - it's possible for it to have an error and return a value. One error is if it cannot find space to create the event it doesn't send the text and returns zero. It also returns 0 is the strlen is 0 or the strlen > 0x100 (I thought it was 64 so idk why it's checking 265. I may just be dumb :P ) There are other ways it could return 0 also but who the hell cares cuz it's very unlikely, but it returns a bool.
 * to the top guy, idk if it is possible. It is probably read a max of 64 characters on the recieving end so even if we did modify it to send more it probably wouldn't work. One of the other problems is that in part of the function it copies the string to the local stack which means we would have to change that to make it work.
 */
window.NetworkSendTextMessage = function (message, networkHandle) {
	return _in(0x3a214f2e, 0xc889b100, _ts(message), _ii(networkHandle) /* may be optional */, _r);
};

/**
 * the first arg seems to be the network player handle (&handle) and the second var is pretty much always "" and the third seems to be a number between 0 and ~10 and the 4th is is something like 0 to 5 and I guess the 5th is a bool cuz it is always 0 or 1
 * does this send an invite to a player?
 */
window.NetworkSendTransitionGamerInstruction = function (p1, p2, p3, p4) {
	return _in(0x31d1d2b8, 0x58d25e6b, _i, _ts(p1), p2, p3, p4, _r);
};

window.NetworkSessionActivityQuickmatch = function (p0, p1, p2, p3) {
	return _in(0xbe3e347a, 0x87aceb82, p0, p1, p2, p3, _r);
};
window.N_0xbe3e347a87aceb82 = window.NetworkSessionActivityQuickmatch;

window.NetworkSessionBlockJoinRequests = function (p0) {
	return _in(0xa7366748, 0x4d7037c3, p0);
};
window.N_0xa73667484d7037c3 = window.NetworkSessionBlockJoinRequests;

window.NetworkSessionCancelInvite = function () {
	return _in(0x2fbf47b1, 0xb36d36f9);
};

window.NetworkSessionChangeSlots = function (p0, p1) {
	return _in(0xb4ab419e, 0x0d86acae, p0, p1);
};
window.N_0xb4ab419e0d86acae = window.NetworkSessionChangeSlots;

window.NetworkSessionCrewMatchmaking = function (p0, p1, p2, maxPlayers, p4) {
	return _in(0x94bc51e9, 0x449d917f, p0, p1, p2, maxPlayers, p4, _r);
};
window.N_0x94bc51e9449d917f = window.NetworkSessionCrewMatchmaking;

/**
 * p0 is always false and p1 varies.
 * NETWORK_SESSION_END(0, 1)
 * NETWORK_SESSION_END(0, 0)
 * Results in: "Connection to session lost due to an unknown network error. Please return to Grand Theft Auto V and try again later."
 */
window.NetworkSessionEnd = function (p0, p1) {
	return _in(0xa02e5956, 0x2d711006, p0, p1, _r);
};

/**
 * unknown params
 * p0 = 0, 2, or 999 (The global is 999 by default.)
 * p1 = 0 (Always in every script it's found in atleast.)
 * p2 = 0, 3, or 4 (Based on a var that is determined by a function.)
 * p3 = maxPlayers (It's obvious in x360 scripts it's always 18)
 * p4 = 0 (Always in every script it's found in atleast.)
 * p5 = 0 or 1. (1 if network_can_enter_multiplayer, but set to 0 if other checks after that are passed.)
 * p5 is reset to 0 if,
 * Global_1315318 = 0 or Global_1315323 = 9 or 12 or (Global_1312629 = 0 && Global_1312631 = true/1) those are passed.
 */
window.NetworkSessionEnter = function (p0, p1, p2, maxPlayers, p4, p5) {
	return _in(0x330ed4d0, 0x5491934f, p0, p1, p2, maxPlayers, p4, p5, _r, _ri);
};

window.NetworkSessionForceCancelInvite = function () {
	return _in(0xa29177f7, 0x703b5644);
};
window.N_0xa29177f7703b5644 = window.NetworkSessionForceCancelInvite;

window.NetworkSessionFriendMatchmaking = function (p0, p1, maxPlayers, p3) {
	return _in(0x2cfc76e0, 0xd087c994, p0, p1, maxPlayers, p3, _r);
};
window.N_0x2cfc76e0d087c994 = window.NetworkSessionFriendMatchmaking;

window.NetworkSessionGetInviter = function (networkHandle) {
	return _in(0xe57397b4, 0xa3429dd0, _ii(networkHandle) /* may be optional */);
};

window.NetworkSessionGetUnk = function (p0) {
	return _in(0x56ce8208, 0x30ef040b, p0, _r, _ri);
};
window.N_0x56ce820830ef040b = window.NetworkSessionGetUnk;

/**
 * Does nothing in online but in offline it will cause the screen to fade to black. Nothing happens past then, the screen will sit at black until you restart GTA. Other stuff must be needed to actually host a session.
 */
window.NetworkSessionHost = function (p0, maxPlayers, p2) {
	return _in(0x6f3d4ed9, 0xbee4e61d, p0, maxPlayers, p2, _r);
};

window.NetworkSessionHostClosed = function (p0, maxPlayers) {
	return _in(0xed34c0c0, 0x2c098bb7, p0, maxPlayers, _r);
};
window.N_0xed34c0c02c098bb7 = window.NetworkSessionHostClosed;

/**
 * Does nothing in online but in offline it will cause the screen to fade to black. Nothing happens past then, the screen will sit at black until you restart GTA. Other stuff must be needed to actually host a session.
 */
window.NetworkSessionHostFriendsOnly = function (p0, maxPlayers) {
	return _in(0xb9cfd27a, 0x5d578d83, p0, maxPlayers, _r);
};

/**
 * Loads up the map that is loaded when beeing in mission creator
 * Player gets placed in a mix between online/offline mode
 * p0 is always 2 in R* scripts.
 * Appears to be patched in gtav b757 (game gets terminated) alonside with most other network natives to prevent online modding ~ghost30812
 */
window.NetworkSessionHostSinglePlayer = function (p0) {
	return _in(0xc74c33fc, 0xa52856d5, p0);
};

window.NetworkSessionHosted = function (p0) {
	return _in(0xc19f6c8e, 0x7865a6ff, p0);
};
window.N_0xc19f6c8e7865a6ff = window.NetworkSessionHosted;

window.NetworkSessionIsClosedCrew = function () {
	return _in(0x74732c6c, 0xa90da2b4, _r);
};
window.N_0x74732c6ca90da2b4 = window.NetworkSessionIsClosedCrew;

window.NetworkSessionIsClosedFriends = function () {
	return _in(0xfbcfa2ea, 0x2e206890, _r);
};
window.N_0xfbcfa2ea2e206890 = window.NetworkSessionIsClosedFriends;

window.NetworkSessionIsPlayerVotedToKick = function (player) {
	return _in(0xd6d09a6f, 0x32f49ef1, player, _r);
};
window.NetworkSessionArePlayersVotingToKick = window.NetworkSessionIsPlayerVotedToKick;

window.NetworkSessionIsPrivate = function () {
	return _in(0xcef70aa5, 0xb3f89ba1, _r);
};
window.N_0xcef70aa5b3f89ba1 = window.NetworkSessionIsPrivate;

window.NetworkSessionIsSolo = function () {
	return _in(0xf3929c23, 0x79b60cce, _r);
};
window.N_0xf3929c2379b60cce = window.NetworkSessionIsSolo;

window.NetworkSessionIsVisible = function () {
	return _in(0xba416d68, 0xc631496a, _r);
};
window.N_0xba416d68c631496a = window.NetworkSessionIsVisible;

/**
 * Only works when you are host.
 */
window.NetworkSessionKickPlayer = function (player) {
	return _in(0xfa8904dc, 0x5f304220, player);
};

window.NetworkSessionLeaveSinglePlayer = function () {
	return _in(0x34427754, 0x28fd2daa);
};

window.NetworkSessionMarkVisible = function (p0) {
	return _in(0x271cc6ab, 0x59ebf9a5, p0);
};
window.N_0x271cc6ab59ebf9a5 = window.NetworkSessionMarkVisible;

/**
 * BLR the shit.
 */
window.NetworkSessionSetMaxPlayers = function (playerType, playerCount) {
	return _in(0x8b6a4dd0, 0xaf9ce215, playerType, playerCount);
};
window.N_0x8b6a4dd0af9ce215 = window.NetworkSessionSetMaxPlayers;

window.NetworkSessionVoiceHost = function () {
	return _in(0x9c155670, 0x5f864230);
};

window.NetworkSessionVoiceLeave = function () {
	return _in(0x6793e42b, 0xe02b575d);
};

window.NetworkSessionWasInvited = function () {
	return _in(0x23dfb504, 0x655d0ce4, _r);
};
window.N_0x23dfb504655d0ce4 = window.NetworkSessionWasInvited;

window.NetworkSetActivitySpectator = function (toggle) {
	return _in(0x75138790, 0xb4359a74, toggle);
};

window.NetworkSetActivitySpectatorMax = function (maxSpectators) {
	return _in(0x9d277b76, 0xd1d12222, maxSpectators);
};

window.NetworkSetCurrentlySelectedGamerHandleFromInviteMenu = function (p0) {
	return _in(0x7206f674, 0xf2a3b1bb, _ii(p0) /* may be optional */, _r);
};

window.NetworkSetEntityCanBlend = function (entity, toggle) {
	return _in(0xd830567d, 0x88a1e873, entity, toggle);
};

/**
 * if set to true other network players can't see it
 * if set to false other network player can see it
 * =========================================
 * ^^ I attempted this by grabbing an object with GET_ENTITY_PLAYER_IS_FREE_AIMING_AT and setting this naive no matter the toggle he could still see it.
 * pc or last gen?
 * ^^ last-gen
 */
window.NetworkSetEntityInvisibleToNetwork = function (entity, toggle) {
	return _in(0xf1ca12b1, 0x8aef5298, entity, toggle);
};
window.N_0xf1ca12b18aef5298 = window.NetworkSetEntityInvisibleToNetwork;
window.NetworkSetEntityVisibleToNetwork = window.NetworkSetEntityInvisibleToNetwork;

/**
 * //friendly fire toggle
 */
window.NetworkSetFriendlyFireOption = function (toggle) {
	return _in(0xf808475f, 0xa571d823, toggle);
};

window.NetworkSetGamerInvitedToTransition = function (networkHandle) {
	return _in(0xca2c8073, 0x411ecdb6, _ii(networkHandle) /* may be optional */);
};

window.NetworkSetInMpCutscene = function (p0, p1) {
	return _in(0x9ca5de65, 0x5269fec4, p0, p1);
};

window.NetworkSetInSpectatorMode = function (toggle, playerPed) {
	return _in(0x423de385, 0x4bb50894, toggle, playerPed);
};

/**
 * hash collision???
 */
window.NetworkSetKeepFocuspoint = function (p0, p1) {
	return _in(0x7f8413b7, 0xfc2aa6b9, p0, p1);
};

window.NetworkSetLocalPlayerInvincibleTime = function (time) {
	return _in(0x2d95c7e2, 0xd7e07307, time);
};

window.NetworkSetMissionFinished = function () {
	return _in(0x3b3d11cd, 0x9ffcdfc9);
};

/**
 * This is called shortly after setting Network ID Migration off it seems. Does anyone know the point of this?
 * Example scenario,
 * If I were to request and gain control of an online players vehicle then their vehicle's Network ID and turn migration off. I wouldn't need to ever request control again as they wouldn't gain control back.
 * - scenario over -
 * So what would be the point hereafter of setting it 'dynamic'?
 */
window.NetworkSetNetworkIdDynamic = function (netID, toggle) {
	return _in(0x2b1813ab, 0xa29016c5, netID, toggle);
};
window.N_0x2b1813aba29016c5 = window.NetworkSetNetworkIdDynamic;

window.NetworkSetOverrideSpectatorMode = function (toggle) {
	return _in(0x70da3bf8, 0xdacd3210, toggle);
};

window.NetworkSetPropertyId = function (p0) {
	return _in(0x1775961c, 0x2fbbcb5c, p0);
};

/**
 * On PC it's a nullsub which means it does absolutely nothing.
 * Now that Discord supports Rich Presence, R* might finally implement this for PC. Or maybe in future games like RDR2, GTA VI...
 */
window.NetworkSetRichPresence = function (p0, p1, p2, p3) {
	return _in(0x1dccacdc, 0xfc569362, p0, p1, p2, p3);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 * ```
 * NETWORK_SET_RICH_PRESENCE but for PlayStation? (On PC it's a nullsub)
 * ```
 */
window.NetworkSetRichPresence_2 = function (p0, gxtLabel) {
	return _in(0x3e200c2b, 0xcf4164eb, p0, _ts(gxtLabel));
};
window.N_0x3e200c2bcf4164eb = window.NetworkSetRichPresence_2;

window.NetworkSetScriptIsSafeForNetworkGame = function () {
	return _in(0x9243bac9, 0x6d64c050);
};

window.NetworkSetTalkerProximity = function (p0) {
	return _in(0xcbf12d65, 0xf95ad686, _fv(p0));
};

window.NetworkSetTeamOnlyChat = function (toggle) {
	return _in(0xd5b4883a, 0xc32f24c3, toggle);
};

/**
 * p1 is always 0
 */
window.NetworkSetThisScriptIsNetworkScript = function (lobbySize, p1, playerId) {
	return _in(0x1ca59e30, 0x6ecb80a5, lobbySize, p1, playerId);
};

window.NetworkSetTransitionActivityId = function (p0) {
	return _in(0x30de938b, 0x516f0ad2, p0);
};
window.N_0x30de938b516f0ad2 = window.NetworkSetTransitionActivityId;

window.NetworkSetTransitionCreatorHandle = function (p0) {
	return _in(0xef26739b, 0xcd9907d5, _ii(p0) /* may be optional */);
};

window.NetworkSetVoiceActive = function (toggle) {
	return _in(0xbabec9e6, 0x9a91c57b, toggle);
};

window.NetworkSetVoiceChannel = function (p0) {
	return _in(0xef6212c2, 0xefef1a23, p0);
};

/**
 * p0 is pointer to a script array
 */
window.NetworkShopBasketAddItem = function (p1) {
	return _in(0xf3098071, 0x8c8ed876, _i, p1, _r);
};
window.N_0xf30980718c8ed876 = window.NetworkShopBasketAddItem;

/**
 * p0 => unk3::_network_shop_basket_apply_server_data(Global_2590199[iParam0  -- [[76]] ], &uVar6); => script array
 */
window.NetworkShopBasketApplyServerData = function (p0, p1) {
	return _in(0xe1a0450e, 0xd46a7812, p0, _ii(p1) /* may be optional */, _r);
};
window.N_0xe1a0450ed46a7812 = window.NetworkShopBasketApplyServerData;

window.NetworkShopBasketEnd = function () {
	return _in(0xa6556812, 0x1df2ea26, _r);
};
window.N_0xa65568121df2ea26 = window.NetworkShopBasketEnd;

window.NetworkShopBasketIsFull = function () {
	return _in(0x27f76cc6, 0xc55ad30e, _r, _ri);
};
window.N_0x27f76cc6c55ad30e = window.NetworkShopBasketIsFull;

window.NetworkShopBasketStart = function (p1, p2, p3) {
	return _in(0x279f08b1, 0xa4b29b7e, _i, p1, p2, p3, _r);
};

/**
 * No longer works if you hook it as a stealth money method
 * Modes------------------
 * 1: Wallet
 * 2: Bank
 * 4: Bank
 * 8: Wallet
 * Only difference I noticed.
 */
window.NetworkShopBeginService = function (p1, transactionHash, amount, p4, mode) {
	return _in(0x3c5fd37b, 0x5499582e, _i, _ch(p1), _ch(transactionHash), amount, _ch(p4), mode, _r);
};
window.N_0x3c5fd37b5499582e = window.NetworkShopBeginService;

window.NetworkShopCashTransferSetTelemetryNonceSeed = function () {
	return _in(0x498c1e05, 0xce5f7877, _r);
};
window.N_0x498c1e05ce5f7877 = window.NetworkShopCashTransferSetTelemetryNonceSeed;

window.NetworkShopCheckoutStart = function (transactionID) {
	return _in(0x39be7cea, 0x8d9cc8e6, transactionID, _r);
};
window.N_0x39be7cea8d9cc8e6 = window.NetworkShopCheckoutStart;

window.NetworkShopDeleteSetTelemetryNonceSeed = function () {
	return _in(0x112cef16, 0x15a1139f, _r, _ri);
};
window.N_0x112cef1615a1139f = window.NetworkShopDeleteSetTelemetryNonceSeed;

/**
 * Belongs in UNK3, non-hashed version of 0x247F0F73A182EA0B
 */
window.NetworkShopDoesItemExist = function (name) {
	return _in(0xbd4d7eaf, 0x8a30f637, _ts(name), _r);
};
window.N_0xbd4d7eaf8a30f637 = window.NetworkShopDoesItemExist;
window.NetworkShopIsItemUnlocked = window.NetworkShopDoesItemExist;

/**
 * ex.:
 * v_15 = sub_10cc8(VEHICLE::GET_VEHICLE_WHEEL_TYPE(a_2));
 * if (!MOBILE::_247F0F73A182EA0B(v_15)) {
 * return 1;
 * }
 * Belongs in UNK3, hashed version of 0xBD4D7EAF8A30F637
 */
window.NetworkShopDoesItemExistHash = function (hash) {
	return _in(0x247f0f73, 0xa182ea0b, _ch(hash), _r);
};
window.N_0x247f0f73a182ea0b = window.NetworkShopDoesItemExistHash;
window.NetworkShopIsItemUnlockedHash = window.NetworkShopDoesItemExistHash;

/**
 * bool is always true in game scripts
 */
window.NetworkShopGetPrice = function (itemHash, hash2, p2) {
	return _in(0xc2700942, 0x2fcca88d, _ch(itemHash), _ch(hash2), p2, _r, _ri);
};

window.NetworkShopGetTransactionsDisabled = function () {
	return _in(0x810e8431, 0xc0614bf9, _r);
};
window.N_0x810e8431c0614bf9 = window.NetworkShopGetTransactionsDisabled;

window.NetworkShopGetTransactionsEnabledForCharacter = function (mpChar) {
	return _in(0xb24f0944, 0xda203d9e, mpChar, _r);
};
window.N_0xb24f0944da203d9e = window.NetworkShopGetTransactionsEnabledForCharacter;

window.NetworkShopSessionApplyReceivedData = function (p0) {
	return _in(0x2f41d51b, 0xa3bcd1f1, p0, _r);
};
window.N_0x2f41d51ba3bcd1f1 = window.NetworkShopSessionApplyReceivedData;

window.NetworkShopSetTelemetryNonceSeed = function (p0) {
	return _in(0x9507d427, 0x1988e1ae, p0, _r);
};
window.N_0x9507d4271988e1ae = window.NetworkShopSetTelemetryNonceSeed;

window.NetworkShopStartSession = function (p0) {
	return _in(0xa135ac89, 0x2a58fc07, p0, _r);
};
window.N_0xa135ac892a58fc07 = window.NetworkShopStartSession;

/**
 * Will cancel the transaction
 */
window.NetworkShopTerminateService = function (transactionID) {
	return _in(0xe2a99a9b, 0x524befff, transactionID, _r);
};
window.N_0xe2a99a9b524befff = window.NetworkShopTerminateService;
window.NetworkShopEndService = window.NetworkShopTerminateService;

/**
 * Example:
 * int playerHandle;
 * NETWORK_HANDLE_FROM_PLAYER(selectedPlayer, &playerHandle, 13);
 * NETWORK_SHOW_PROFILE_UI(&playerHandle);
 */
window.NetworkShowProfileUi = function (networkHandle) {
	return _in(0x859ed1ce, 0xa343fca8, _ii(networkHandle) /* may be optional */);
};

window.NetworkSpentAmmoDrop = function (p0, p1, p2) {
	return _in(0xb162dc95, 0xc0a3317b, p0, p1, p2);
};

window.NetworkSpentArrestBail = function (p0, p1, p2) {
	return _in(0x812f5488, 0xb1b2a299, p0, p1, p2);
};

window.NetworkSpentBetting = function (p0, p1, p3, p4) {
	return _in(0x1c436fd1, 0x1ffa692f, p0, p1, _i, p3, p4);
};

window.NetworkSpentBoatPickup = function (p0, p1, p2) {
	return _in(0x524ee43a, 0x37232c00, p0, p1, p2);
};

window.NetworkSpentBounty = function (p0, p1, p2) {
	return _in(0x29b260b8, 0x4947dfcc, p0, p1, p2);
};

window.NetworkSpentBullShark = function (p0, p1, p2) {
	return _in(0xa6dd8458, 0xce24012c, p0, p1, p2);
};

window.NetworkSpentBuyOfftheradar = function (p0, p1, p2) {
	return _in(0xa628a745, 0xe2275c5d, p0, p1, p2);
};

window.NetworkSpentBuyPassiveMode = function (p0, p1, p2) {
	return _in(0x6d3a430d, 0x1a809179, p0, p1, p2);
};

window.NetworkSpentBuyRevealPlayers = function (p0, p1, p2) {
	return _in(0x6e176f1b, 0x18bc0637, p0, p1, p2);
};

window.NetworkSpentBuyWantedlevel = function (p0, p2, p3) {
	return _in(0xe1b13771, 0xa843c4f6, p0, _i, p2, p3);
};

window.NetworkSpentCallPlayer = function (p0, p2, p3) {
	return _in(0xacde7185, 0xb374177c, p0, _i, p2, p3);
};

window.NetworkSpentCarwash = function (p0, p1, p2, p3, p4) {
	return _in(0xec03c719, 0xdb2f4306, p0, p1, p2, p3, p4);
};

window.NetworkSpentCashDrop = function (amount, p1, p2) {
	return _in(0x289016ec, 0x778d60e0, amount, p1, p2);
};

window.NetworkSpentCinema = function (p0, p1, p2, p3) {
	return _in(0x6b38ecb0, 0x5a63a685, p0, p1, p2, p3);
};

window.NetworkSpentFromRockstar = function (bank, p1, p2) {
	return _in(0x6a445b64, 0xed7abeb5, bank, p1, p2);
};
window.N_0x6a445b64ed7abeb5 = window.NetworkSpentFromRockstar;

window.NetworkSpentHeliPickup = function (p0, p1, p2) {
	return _in(0x7bf1d73d, 0xb2eca492, p0, p1, p2);
};

window.NetworkSpentHireMercenary = function (p0, p1, p2) {
	return _in(0xe7b80e2b, 0xf9d80bd6, p0, p1, p2);
};

/**
 * Only used once in a script (am_contact_requests)
 * p1 = 0
 * p2 = 1
 */
window.NetworkSpentHireMugger = function (p0, p1, p2) {
	return _in(0xe404bfb9, 0x81665bf0, p0, p1, p2);
};

window.NetworkSpentHoldups = function (p0, p1, p2) {
	return _in(0xd9b86b98, 0x72039763, p0, p1, p2);
};

window.NetworkSpentInStripclub = function (p0, p1, p2, p3) {
	return _in(0xee99784e, 0x4467689c, p0, p1, p2, p3);
};
window.N_0xee99784e4467689c = window.NetworkSpentInStripclub;

window.NetworkSpentNoCops = function (p0, p1, p2) {
	return _in(0xd5bb406f, 0x4e04019f, p0, p1, p2);
};
window.N_0xd5bb406f4e04019f = window.NetworkSpentNoCops;

/**
 * According to how I understood this in the freemode script alone,
 * The first parameter is determined by a function named, func_5749 within the freemode script which has a list of all the vehicles and a set price to return which some vehicles deals with globals as well. So the first parameter is basically the set in stone insurance cost it's gonna charge you for that specific vehicle model.
 * The second parameter whoever put it was right, they call GET_ENTITY_MODEL with the vehicle as the paremeter.
 * The third parameter is the network handle as they call their little struct<13> func or atleast how the script decompiled it to look which in lamens terms just returns the network handle of the previous owner based on DECOR_GET_INT(vehicle, "Previous_Owner").
 * The fourth parameter is a bool that returns true/false depending on if your bank balance is greater then 0.
 * The fifth and last parameter is a bool that returns true/false depending on if you have the money for the car based on the cost returned by func_5749. In the freemode script eg,
 * bool hasTheMoney = NETWORKCASH::_GET_BANK_BALANCE() < carCost.
 */
window.NetworkSpentPayVehicleInsurancePremium = function (amount, vehicleModel, notBankrupt, hasTheMoney) {
	return _in(0x9ff28d88, 0xc766e3e8, amount, _ch(vehicleModel), _i, notBankrupt, hasTheMoney);
};

window.NetworkSpentPlayerHealthcare = function (p0, p1, p2, p3) {
	return _in(0x7c99101f, 0x7fce2ee5, p0, p1, p2, p3);
};
window.N_0x7c99101f7fce2ee5 = window.NetworkSpentPlayerHealthcare;

window.NetworkSpentProstitutes = function (p0, p1, p2) {
	return _in(0xb21b8950, 0x1cfac79e, p0, p1, p2);
};

/**
 * Console Hash 0xF4287778 = NETWORK_SPENT_REQUEST_HEIST
 */
window.NetworkSpentRequestHeist = function (p0, p1, p2) {
	return _in(0x9d26502b, 0xb97bfe62, p0, p1, p2);
};
window.N_0x9d26502bb97bfe62 = window.NetworkSpentRequestHeist;

window.NetworkSpentRequestJob = function (p0, p1, p2) {
	return _in(0x8204da79, 0x34df3155, p0, p1, p2);
};
window.N_0x8204da7934df3155 = window.NetworkSpentRequestJob;

window.NetworkSpentRobbedByMugger = function (amount, p1, p2) {
	return _in(0x995a65f1, 0x5f581359, amount, p1, p2);
};
window.N_0x995a65f15f581359 = window.NetworkSpentRobbedByMugger;

window.NetworkSpentTaxi = function (amount, p1, p2) {
	return _in(0x17c3a7d3, 0x1eae39f9, amount, p1, p2);
};

window.NetworkSpentTelescope = function (p0, p1, p2) {
	return _in(0x7fe61782, 0xad94cc09, p0, p1, p2);
};

window.NetworkStartSynchronisedScene = function (netScene) {
	return _in(0x9a1b3fcd, 0xb36c8697, netScene);
};

window.NetworkStopLoadScene = function () {
	return _in(0x64e630fa, 0xf5f60f44);
};

window.NetworkStopSynchronisedScene = function (netScene) {
	return _in(0xc254481a, 0x4574cb2f, netScene);
};

window.NetworkSuppressInvite = function (toggle) {
	return _in(0xa0682d67, 0xef1fba3d, toggle);
};

/**
 * used in atm_trigger script.
 * usage:
 * int iVar0;STATS::STAT_GET_INT(GAMEPLAY::GET_HASH_KEY("mpply_last_mp_char"), &iVar0, -1);
 * UNK3::_NETWORK_TRANSFER_WALLET_TO_BANK(iVar0, amount);
 * used to deposit money into bank from wallet, shows up in transaction log.
 */
window.NetworkTransferBankToWallet = function (charStatInt, amount) {
	return _in(0xd47a2c1b, 0xa117471d, charStatInt, amount, _r);
};
window.N_0xd47a2c1ba117471d = window.NetworkTransferBankToWallet;

/**
 * used in atm_trigger script.
 * usage:
 * int iVar0; STATS::STAT_GET_INT(GAMEPLAY::GET_HASH_KEY("mpply_last_mp_char"), &iVar0, -1);
 * UNK3::_NETWORK_TRANSFER_BANK_TO_WALLET(iVar0, amount);
 * used to withdraw money from bank into wallet, shows up in transaction log.
 */
window.NetworkTransferWalletToBank = function (charStatInt, amount) {
	return _in(0xc2f7fe53, 0x09181c7d, charStatInt, amount, _r);
};
window.N_0xc2f7fe5309181c7d = window.NetworkTransferWalletToBank;

window.NetworkUnregisterNetworkedEntity = function (entity) {
	return _in(0x7368e683, 0xbb9038d6, entity);
};
window.N_0x7368e683bb9038d6 = window.NetworkUnregisterNetworkedEntity;

window.NetworkUpdateLoadScene = function () {
	return _in(0xc4582015, 0x556d1c46);
};

/**
 * Only one occurence in the scripts:
 * auto sub_cb43(auto a_0, auto a_1) {
 * if (g_2594CB._f1) {
 * if (NETWORK::_855BC38818F6F684()) {
 * NETWORK::_ABD5E88B8A2D3DB2(&a_0._fB93);
 * g_2594CB._f14 -- [[{13}]]  = a_0._fB93;
 * g_2594CB._f4 -- [["64"]]  = a_1;
 * return 1;
 * }
 * }
 * return 0;
 * }
 * other:
 * looks like it passes a player in the paramater
 * Contains string "NETWORK_VOICE_CONNECT_TO_PLAYER" in ida
 */
window.NetworkVoiceConnectToPlayer = function (globalPtr) {
	return _in(0xabd5e88b, 0x8a2d3db2, _ii(globalPtr) /* may be optional */);
};
window.N_0xabd5e88b8a2d3db2 = window.NetworkVoiceConnectToPlayer;

window.NetworkXAffectsGamers = function (p0) {
	return _in(0xe532d681, 0x1b3a4d2a, p0, _r);
};
window.N_0xe532d6811b3a4d2a = window.NetworkXAffectsGamers;

window.NewLoadSceneStart = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0x212a8d0d, 0x2babfac2, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), p7, _r);
};

/**
 * if (!sub_8f12("START LOAD SCENE SAFE")) {
 * if (CUTSCENE::GET_CUTSCENE_TIME() > 4178) {
 * STREAMING::_ACCFB4ACF53551B0(1973.845458984375, 3818.447265625, 32.43629837036133, 15.0, 2);
 * sub_8e9e("START LOAD SCENE SAFE", 1);
 * }
 * }
 * (Previously known as STREAMING::_NEW_LOAD_SCENE_START_SAFE)
 */
window.NewLoadSceneStartSphere = function (x, y, z, radius, p4) {
	return _in(0xaccfb4ac, 0xf53551b0, _fv(x), _fv(y), _fv(z), _fv(radius), p4, _r);
};
window.N_0xaccfb4acf53551b0 = window.NewLoadSceneStartSphere;

window.NewLoadSceneStop = function () {
	return _in(0xc197616d, 0x221ff4a4);
};

/**
 * Sets the value of the specified variable to 0.
 * Always returns true.
 * bool _NULLIFY(void* variable, int unused)
 * {
 * *variable = NULL;
 * return true;
 * }
 */
window.Nullify = function (unused) {
	return _in(0x46e2b844, 0x905bc5f0, _i, unused, _r);
};

/**
 * Lets objects spawn online simply do it like this:
 * int createdObject = OBJ_TO_NET(CREATE_OBJECT_NO_OFFSET(oball, pCoords.x, pCoords.y, pCoords.z, 1, 0, 0));
 */
window.ObjToNet = function (object) {
	return _in(0x99bfdc94, 0xa603e541, object, _r, _ri);
};

/**
 * Please change back to _0x444D8CF241EC25C5 (hash collision)
 */
window.ObjectDecalToggle = function (hash) {
	return _in(0x444d8cf2, 0x41ec25c5, _ch(hash));
};

window.ObjectValueAddArray = function (key) {
	return _in(0x5b117285, 0x27ca6e5f, _i, _ts(key), _r, _ri);
};

window.ObjectValueAddBoolean = function (key, value) {
	return _in(0x35124302, 0xa556a325, _i, _ts(key), value);
};

window.ObjectValueAddFloat = function (key, value) {
	return _in(0xc27e1cc2, 0xd795105e, _i, _ts(key), _fv(value));
};

window.ObjectValueAddInteger = function (key, value) {
	return _in(0xe7e03545, 0x0a7948d5, _i, _ts(key), value);
};

window.ObjectValueAddObject = function (key) {
	return _in(0xa358f56f, 0x10732ee1, _i, _ts(key), _r, _ri);
};

window.ObjectValueAddString = function (key, value) {
	return _in(0x8ff3847d, 0xadd8e30c, _i, _ts(key), _ts(value));
};

window.ObjectValueAddVector3 = function (key, valueX, valueY, valueZ) {
	return _in(0x4cd49b76, 0x338c7dee, _i, _ts(key), _fv(valueX), _fv(valueY), _fv(valueZ));
};

window.ObjectValueGetArray = function (key) {
	return _in(0x7a983aa9, 0xda2659ed, _i, _ts(key), _r, _ri);
};

window.ObjectValueGetBoolean = function (key) {
	return _in(0x1186940e, 0xd72ffeec, _i, _ts(key), _r);
};

window.ObjectValueGetFloat = function (key) {
	return _in(0x06610343, 0xe73b9727, _i, _ts(key), _r, _rf);
};

window.ObjectValueGetInteger = function (key) {
	return _in(0x78f06f6b, 0x1fb5a80c, _i, _ts(key), _r, _ri);
};

window.ObjectValueGetObject = function (key) {
	return _in(0xb6b9ddc4, 0x12fceee2, _i, _ts(key), _r, _ri);
};

window.ObjectValueGetString = function (key) {
	return _in(0x3d2fd9e7, 0x63b24472, _i, _ts(key), _r, _s);
};

/**
 * Types:
 * 1 = Boolean
 * 2 = Integer
 * 3 = Float
 * 4 = String
 * 5 = Vector3
 * 6 = Object
 * 7 = Array
 */
window.ObjectValueGetType = function (key) {
	return _in(0x031c55ed, 0x33227371, _i, _ts(key), _r, _ri);
};

window.ObjectValueGetVector3 = function (key) {
	return _in(0x46cd3cb6, 0x6e0825cc, _i, _ts(key), _r, _rv);
};

window.OpenBombBayDoors = function (vehicle) {
	return _in(0x87e7f242, 0x70732cb1, vehicle);
};
window.OpenVehicleBombBay = window.OpenBombBayDoors;

/**
 * patrolRoutes found in the b617d scripts:
 * "miss_Ass0",
 * "miss_Ass1",
 * "miss_Ass2",
 * "miss_Ass3",
 * "miss_Ass4",
 * "miss_Ass5",
 * "miss_Ass6",
 * "MISS_PATROL_6",
 * "MISS_PATROL_7",
 * "MISS_PATROL_8",
 * "MISS_PATROL_9",
 * "miss_Tower_01",
 * "miss_Tower_02",
 * "miss_Tower_03",
 * "miss_Tower_04",
 * "miss_Tower_05",
 * "miss_Tower_06",
 * "miss_Tower_07",
 * "miss_Tower_08",
 * "miss_Tower_10"
 */
window.OpenPatrolRoute = function (patrolRoute) {
	return _in(0xa36bfb5e, 0xe89f3d82, _ts(patrolRoute));
};

window.OpenSequenceTask = function (taskSequence) {
	return _in(0xe8854a43, 0x26b9e12b, _ii(taskSequence) /* may be optional */, _r, _ri);
};

/**
 * Max value for p1 is 15.
 */
window.OverrideCamSplineMotionBlur = function (cam, p1, p2, p3) {
	return _in(0x7dcf7c70, 0x8d292d55, cam, p1, _fv(p2), _fv(p3));
};

window.OverrideCamSplineVelocity = function (cam, p1, p2, p3) {
	return _in(0x40b62fa0, 0x33eb0346, cam, p1, _fv(p2), _fv(p3));
};

/**
 * Only used once in the decompiled scripts. Seems to be related to scripted vehicle generators.
 * Modified example from "am_imp_exp.c4", line 6406:
 *  -- [[ popSchedules[0] = ZONE::GET_ZONE_POPSCHEDULE(ZONE::GET_ZONE_AT_COORDS(891.3, 807.9, 188.1));
 * etc.
 * ]] 
 * ZONE::OVERRIDE_POPSCHEDULE_VEHICLE_MODEL(popSchedules[index], vehicleHash);
 * STREAMING::REQUEST_MODEL(vehicleHash);
 */
window.OverridePopscheduleVehicleModel = function (scheduleId, vehicleHash) {
	return _in(0x5f7d596b, 0xac2e7777, scheduleId, _ch(vehicleHash));
};

window.OverrideSaveHouse = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0x1162ea8a, 0xe9d24eea, p0, _fv(p1), _fv(p2), _fv(p3), _fv(p4), p5, _fv(p6), _fv(p7), _r);
};

window.OverrideTrevorRage = function (p0) {
	return _in(0x13ad6650, 0x62541a7e, _ii(p0) /* may be optional */);
};

window.OverrideUnderwaterStream = function (p1) {
	return _in(0xf2a9cdab, 0xcea04bd6, _i, p1);
};

/**
 * Overrides the vehicle's horn hash.
 * When changing this hash on a vehicle, [`_GET_VEHICLE_HORN_HASH`](#_0xACB5DCCA1EC76840) will **not** return the 'overwritten' hash. It will still always return the default horn hash (same as [`GET_VEHICLE_DEFAULT_HORN`](#_0x02165D55000219AC)).
 * List of possible hashes (found in decompiled scripts):
 * |        signed |     unsigned |      hex     |
 * | ------------: | -----------: | :----------: |
 * |  `1604822495` | `1604822495` | `0x5FA7A5DF` |
 * | `-1262465009` | `3032502287` | `0xB4C0500F` |
 * |  `-889553789` | `3405413507` | `0xCAFA7C83` |
 * | `-1557943086` | `2737024210` | `0xA323ACD2` |
 * | `-1318696617` | `2976270679` | `0xB1664957` |
 * |    `-7740003` | `4287227293` | `0xFF89E59D` |
 * | `-1815146967` | `2479820329` | `0x93CF0E29` |
 * |  `-339919356` | `3955047940` | `0xEBBD3E04` |
 * Old description:
 * ```
 * vehicle - the vehicle whose horn should be overwritten
 * mute - p1 seems to be an option for muting the horn
 * p2 - maybe a horn id, since the function AUDIO::GET_VEHICLE_DEFAULT_HORN(veh) exists?
 * ```
 * @param vehicle The vehicle you want to change the horn on.
 * @param override Must be set to true. If set to false, the default horn hash will be restored.
 * @param hornHash A horn hash.
 */
window.OverrideVehHorn = function (vehicle, override, hornHash) {
	return _in(0x3cdc1e62, 0x2cce0356, vehicle, override, hornHash);
};

/**
 * Return the local Participant ID
 */
window.ParticipantId = function () {
	return _in(0x90986e88, 0x76ce0a83, _r, _ri);
};

/**
 * Return the local Participant ID.
 * This native is exactly the same as 'PARTICIPANT_ID' native.
 */
window.ParticipantIdToInt = function () {
	return _in(0x57a3bdda, 0xd8e5aa0a, _r, _ri);
};

window.PauseClock = function (toggle) {
	return _in(0x4055e40b, 0xd2dbec1d, toggle);
};

/**
 * Activates the specified frontend menu context.
 * pausemenu.xml defines some specific menu options using 'context'. Context is basically a 'condition'.
 * The `*ALL*` part of the context means that whatever is being defined, will be active when any or all of those conditions after `*ALL*` are met.
 * The `*NONE*` part of the context section means that whatever is being defined, will NOT be active if any or all of the conditions after `*NONE*` are met.
 * This basically allows you to hide certain menu sections, or things like instructional buttons.
 * See the old description below for more info.
 * * * *
 * > Seems to add/set the current menu context (to show/hide buttons?)
 * > Pausemenu.xml:
 * > `<Contexts>*ALL*, DISPLAY_CORONA_BUTTONS, *NONE*, BET_LOCKED, BET_AVAILABLE, SCROLL_OPTION</Contexts>`
 * > Code:
 * >
 * > ```
 * > if (...) {
 * >     sub_bbd34(a_0, 0, "FM_BET_HELP");
 * >     UI::PAUSE_MENU_ACTIVATE_CONTEXT(${bet_available}); // This native
 * >     UI::OBJECT_DECAL_TOGGLE(${bet_locked});
 * > } else {
 * >     sub_bbd34(a_0, 0, "");
 * >     UI::OBJECT_DECAL_TOGGLE(${bet_available});
 * >     UI::PAUSE_MENU_ACTIVATE_CONTEXT(${bet_locked}); // This native
 * > }
 * > ```
 * >
 * > OBJECT_DECAL_TOGGLE seems to remove a context, It also has a hash collision
 * > // Old
 * > Scripts do not make this native's purpose clear. However, this native most likely has something to do with decals since in nearly every instance, "OBJECT_DECAL_TOGGLE" is called prior.
 * @param hash Context name hash.
 */
window.PauseMenuActivateContext = function (hash) {
	return _in(0xdd564bdd, 0x0472c936, _ch(hash));
};
window.N_0xdd564bdd0472c936 = window.PauseMenuActivateContext;
window.AddFrontendMenuContext = window.PauseMenuActivateContext;

window.PausePlaybackRecordedVehicle = function (p0) {
	return _in(0x632a689b, 0xf42301b1, p0);
};

window.PauseScriptedConversation = function (p0) {
	return _in(0x8530ad77, 0x6cd72b12, p0);
};

window.PedHasUseScenarioTask = function (ped) {
	return _in(0x295e3cce, 0xc879ccd7, ped, _r);
};

/**
 * [23.03.2017 19:08] by ins1de :
 * "_IS_PED_RELOADING" is totally a wrong name...
 * This native actually disables the reloading animation and script for the specified ped. Native renamed.
 */
window.PedSkipNextReloading = function (ped) {
	return _in(0x8c0d57ea, 0x686fad87, ped, _r);
};
window.IsPedReloading = window.PedSkipNextReloading;

/**
 * gets the network id of a ped
 */
window.PedToNet = function (ped) {
	return _in(0x0edec3c2, 0x76198689, ped, _r, _ri);
};

window.PinRopeVertex = function (rope, vertex, x, y, z) {
	return _in(0x2b320cf1, 0x4146b69a, rope, vertex, _fv(x), _fv(y), _fv(z));
};

window.PlaceObjectOnGroundProperly = function (object) {
	return _in(0x58a850ea, 0xee20faa3, object, _r);
};

/**
 * Plays ambient speech. See also _0x444180DB.
 * ped: The ped to play the ambient speech.
 * speechName: Name of the speech to play, eg. "GENERIC_HI".
 * speechParam: Can be one of the following:
 * SPEECH_PARAMS_STANDARD
 * SPEECH_PARAMS_ALLOW_REPEAT
 * SPEECH_PARAMS_BEAT
 * SPEECH_PARAMS_FORCE
 * SPEECH_PARAMS_FORCE_FRONTEND
 * SPEECH_PARAMS_FORCE_NO_REPEAT_FRONTEND
 * SPEECH_PARAMS_FORCE_NORMAL
 * SPEECH_PARAMS_FORCE_NORMAL_CLEAR
 * SPEECH_PARAMS_FORCE_NORMAL_CRITICAL
 * SPEECH_PARAMS_FORCE_SHOUTED
 * SPEECH_PARAMS_FORCE_SHOUTED_CLEAR
 * SPEECH_PARAMS_FORCE_SHOUTED_CRITICAL
 * SPEECH_PARAMS_FORCE_PRELOAD_ONLY
 * SPEECH_PARAMS_MEGAPHONE
 * SPEECH_PARAMS_HELI
 * SPEECH_PARAMS_FORCE_MEGAPHONE
 * SPEECH_PARAMS_FORCE_HELI
 * SPEECH_PARAMS_INTERRUPT
 * SPEECH_PARAMS_INTERRUPT_SHOUTED
 * SPEECH_PARAMS_INTERRUPT_SHOUTED_CLEAR
 * SPEECH_PARAMS_INTERRUPT_SHOUTED_CRITICAL
 * SPEECH_PARAMS_INTERRUPT_NO_FORCE
 * SPEECH_PARAMS_INTERRUPT_FRONTEND
 * SPEECH_PARAMS_INTERRUPT_NO_FORCE_FRONTEND
 * SPEECH_PARAMS_ADD_BLIP
 * SPEECH_PARAMS_ADD_BLIP_ALLOW_REPEAT
 * SPEECH_PARAMS_ADD_BLIP_FORCE
 * SPEECH_PARAMS_ADD_BLIP_SHOUTED
 * SPEECH_PARAMS_ADD_BLIP_SHOUTED_FORCE
 * SPEECH_PARAMS_ADD_BLIP_INTERRUPT
 * SPEECH_PARAMS_ADD_BLIP_INTERRUPT_FORCE
 * SPEECH_PARAMS_FORCE_PRELOAD_ONLY_SHOUTED
 * SPEECH_PARAMS_FORCE_PRELOAD_ONLY_SHOUTED_CLEAR
 * SPEECH_PARAMS_FORCE_PRELOAD_ONLY_SHOUTED_CRITICAL
 * SPEECH_PARAMS_SHOUTED
 * SPEECH_PARAMS_SHOUTED_CLEAR
 * SPEECH_PARAMS_SHOUTED_CRITICAL
 * Note: A list of Name and Parameters can be found here pastebin.com/1GZS5dCL
 * Full list of speeches and voices names by some spanish shitbag: gist.github.com/alexguirre/0af600eb3d4c91ad4f900120a63b8992
 */
window.PlayAmbientSpeech1 = function (ped, speechName, speechParam) {
	return _in(0x8e04fedd, 0x28d42462, ped, _ts(speechName), _ts(speechParam));
};

/**
 * Plays ambient speech. See also _0x5C57B85D.
 * See _PLAY_AMBIENT_SPEECH1 for parameter specifications.
 * Full list of speeches and voices names: gist.github.com/alexguirre/0af600eb3d4c91ad4f900120a63b8992
 */
window.PlayAmbientSpeech2 = function (ped, speechName, speechParam) {
	return _in(0xc6941b4a, 0x3a8fbbb9, ped, _ts(speechName), _ts(speechParam));
};

window.PlayAmbientSpeechAtCoords = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xed640017, 0xed337e45, _ts(p0), _ts(p1), _fv(p2), _fv(p3), _fv(p4), _ts(p5));
};
window.N_0xed640017ed337e45 = window.PlayAmbientSpeechAtCoords;

/**
 * This is the same as _PLAY_AMBIENT_SPEECH1 and _PLAY_AMBIENT_SPEECH2 but it will allow you to play a speech file from a specific voice file. It works on players and all peds, even animals.
 * EX (C#):
 * GTA.Native.Function.Call(Hash._0x3523634255FC3318, Game.Player.Character, "GENERIC_INSULT_HIGH", "s_m_y_sheriff_01_white_full_01", "SPEECH_PARAMS_FORCE_SHOUTED", 0);
 * The first param is the ped you want to play it on, the second is the speech name, the third is the voice name, the fourth is the speech param, and the last param is usually always 0.
 * Full list of speeches and voices names: gist.github.com/alexguirre/0af600eb3d4c91ad4f900120a63b8992
 */
window.PlayAmbientSpeechWithVoice = function (p0, speechName, voiceName, speechParam, p4) {
	return _in(0x35236342, 0x55fc3318, p0, _ts(speechName), _ts(voiceName), _ts(speechParam), p4);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.PlayAnimOnRunningScenario = function (ped, animDict, animName) {
	return _in(0x74804046, 0x0f8df5dc, ped, _ts(animDict), _ts(animName));
};

/**
 * Atleast one time in a script for the zRot Rockstar uses GET_ENTITY_HEADING to help fill the parameter.
 * p9 is unknown at this time.
 * p10 throughout all the X360 Scripts is always 2.
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.PlayCamAnim = function (cam, animName, animDictionary, x, y, z, xRot, yRot, zRot, p9, p10) {
	return _in(0x9a2d0fb2, 0xe7852392, cam, _ts(animName), _ts(animDictionary), _fv(x), _fv(y), _fv(z), _fv(xRot), _fv(yRot), _fv(zRot), p9, p10, _r);
};

window.PlayEndCreditsMusic = function (play) {
	return _in(0xcd536c4d, 0x33dcc900, play);
};

/**
 * delta and bitset are guessed fields. They are based on the fact that most of the calls have 0 or nil field types passed in.
 * The only time bitset has a value is 0x4000 and the only time delta has a value is during stealth with usually <1.0f values.
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.PlayEntityAnim = function (entity, animName, animDict, p3, loop, stayInAnim, p6, delta, bitset) {
	return _in(0x7fb21826, 0x2b810701, entity, _ts(animName), _ts(animDict), _fv(p3), loop, stayInAnim, p6, _fv(delta), bitset, _r);
};

window.PlayEntityScriptedAnim = function (p0, p4, p5) {
	return _in(0x77a1eec5, 0x47e7fcf1, p0, _i, _i, _i, _fv(p4), _fv(p5));
};

/**
 * Look at facials@gen_male@base and facials@gen_female@base for some common facial animations.
 * !!!NOTE!!!
 * Unlike most animation natives, the animation comes BEFORE the animation dictionary here. So you could call e.g.
 * PLAY_FACIAL_ANIM(ped, "dead_1", "facials@gen_male@base")
 */
window.PlayFacialAnim = function (ped, animName, animDict) {
	return _in(0xe1e65ca8, 0xac9c00ed, ped, _ts(animName), _ts(animDict));
};

/**
 * Called 38 times in the scripts. There are 5 different audioNames used.
 * One unknown removed below.
 * AUDIO::PLAY_MISSION_COMPLETE_AUDIO("DEAD");
 * AUDIO::PLAY_MISSION_COMPLETE_AUDIO("FRANKLIN_BIG_01");
 * AUDIO::PLAY_MISSION_COMPLETE_AUDIO("GENERIC_FAILED");
 * AUDIO::PLAY_MISSION_COMPLETE_AUDIO("TREVOR_SMALL_01");
 */
window.PlayMissionCompleteAudio = function (audioName) {
	return _in(0xb138aab8, 0xa70d3c69, _ts(audioName));
};

/**
 * Needs another parameter [int p2]. The signature is PED::PLAY_PAIN(Ped ped, int painID, int p1, int p2);
 * Last 2 parameters always seem to be 0.
 * EX: Function.Call(Hash.PLAY_PAIN, TestPed, 6, 0, 0);
 * Known Pain IDs
 * ________________________
 * 1 - Doesn't seem to do anything. Does NOT crash the game like previously said. (Latest patch)
 * 6 - Scream (Short)
 * 7 - Scared Scream (Kinda Long)
 * 8 - On Fire
 */
window.PlayPain = function (ped, painID, p1) {
	return _in(0xbc9ae166, 0x038a5cec, ped, painID, p1);
};

/**
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/RFb4GTny
 * AUDIO::PLAY_PED_RINGTONE("Remote_Ring", PLAYER::PLAYER_PED_ID(), 1);
 * AUDIO::PLAY_PED_RINGTONE("Dial_and_Remote_Ring", PLAYER::PLAYER_PED_ID(), 1);
 */
window.PlayPedRingtone = function (ringtoneName, ped, p2) {
	return _in(0xf9e56683, 0xca8e11a5, _ts(ringtoneName), ped, p2);
};

/**
 * Please change to void. (Does not return anything!)
 * Plays the given police radio message.
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/GBnsQ5hr
 */
window.PlayPoliceReport = function (name, p1) {
	return _in(0xdfebd56d, 0x9bd1eb16, _ts(name), _fv(p1), _r, _ri);
};

/**
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/A8Ny8AHZ
 */
window.PlaySound = function (soundId, audioName, audioRef, p3, p4, p5) {
	return _in(0x7ff4944c, 0xc209192d, soundId, _ts(audioName), _ts(audioRef), p3, p4, p5);
};

/**
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/eeFc5DiW
 * gtaforums.com/topic/795622-audio-for-mods
 */
window.PlaySoundFromCoord = function (soundId, audioName, x, y, z, audioRef, p6, range, p8) {
	return _in(0x8d8686b6, 0x22b88120, soundId, _ts(audioName), _fv(x), _fv(y), _fv(z), _ts(audioRef), p6, range, p8);
};

/**
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/f2A7vTj0
 * No changes made in b678d.
 * gtaforums.com/topic/795622-audio-for-mods
 */
window.PlaySoundFromEntity = function (soundId, audioName, entity, audioRef, p4, p5) {
	return _in(0xe65f427e, 0xb70ab1ed, soundId, _ts(audioName), entity, _ts(audioRef), p4, p5);
};

/**
 * list: pastebin.com/DCeRiaLJ
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/0neZdsZ5
 */
window.PlaySoundFrontend = function (soundId, audioName, audioRef, p3) {
	return _in(0x67c540aa, 0x08e4a6f5, soundId, _ts(audioName), _ts(audioRef), p3);
};

/**
 * Used with AUDIO::LOAD_STREAM
 * Example from finale_heist2b.c4:
 * AI::TASK_SYNCHRONIZED_SCENE(l_4C8[2 -- [[14]] ], l_4C8[2 -- [[14]] ]._f7, l_30A, "push_out_vault_l", 4.0, -1.5, 5, 713, 4.0, 0);
 * PED::SET_SYNCHRONIZED_SCENE_PHASE(l_4C8[2 -- [[14]] ]._f7, 0.0);
 * PED::_2208438012482A1A(l_4C8[2 -- [[14]] ], 0, 0);
 * PED::SET_PED_COMBAT_ATTRIBUTES(l_4C8[2 -- [[14]] ], 38, 1);
 * PED::SET_BLOCKING_OF_NON_TEMPORARY_EVENTS(l_4C8[2 -- [[14]] ], 1);
 * if (AUDIO::LOAD_STREAM("Gold_Cart_Push_Anim_01", "BIG_SCORE_3B_SOUNDS")) {
 * AUDIO::PLAY_STREAM_FROM_OBJECT(l_36F[0 -- [[1]] ]);
 * }
 */
window.PlayStreamFromObject = function (object) {
	return _in(0xebaa9b64, 0xd76356fd, object);
};

window.PlayStreamFromPed = function (ped) {
	return _in(0x89049dd6, 0x3c08b5d1, ped);
};
window.N_0x89049dd63c08b5d1 = window.PlayStreamFromPed;

window.PlayStreamFromVehicle = function (vehicle) {
	return _in(0xb70374a7, 0x58007dfa, vehicle);
};

window.PlayStreamFrontend = function () {
	return _in(0x58fce434, 0x88f9f5f4);
};

window.PlaySynchronizedAudioEvent = function (p0) {
	return _in(0x8b2fd456, 0x0e55dd2d, p0, _r);
};

/**
 * Examples:
 * CAM::PLAY_SYNCHRONIZED_CAM_ANIM(l_2734, NETWORK::_02C40BF885C567B6(l_2739), "PLAYER_EXIT_L_CAM", "mp_doorbell");
 * CAM::PLAY_SYNCHRONIZED_CAM_ANIM(l_F0D[7 -- [[1]] ], l_F4D[15 -- [[1]] ], "ah3b_attackheli_cam2", "missheistfbi3b_helicrash");
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.PlaySynchronizedCamAnim = function (p0, p1, animName, animDictionary) {
	return _in(0xe32efe9a, 0xb4a9aa0c, p0, p1, _ts(animName), _ts(animDictionary), _r);
};

/**
 * p4 and p7 are usually 1000.0f.
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.PlaySynchronizedEntityAnim = function (entity, syncedScene, animation, propName, p4, p5, p6, p7) {
	return _in(0xc77720a1, 0x2fe14a86, entity, syncedScene, _ts(animation), _ts(propName), _fv(p4), _fv(p5), p6, _fv(p7), _r);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.PlaySynchronizedMapEntityAnim = function (p0, p1, p2, p3, p4, p5, p8, p9, p10, p11) {
	return _in(0xb9c54555, 0xed30fbc4, _fv(p0), _fv(p1), _fv(p2), _fv(p3), p4, p5, _i, _i, _fv(p8), _fv(p9), p10, _fv(p11), _r);
};

/**
 * This native only comes up once. And in that one instance, p1 is "1".
 */
window.PlayVehicleDoorCloseSound = function (vehicle, p1) {
	return _in(0x62a456aa, 0x4769ef34, vehicle, p1);
};

/**
 * p1 appears to only be "0" or "3". I personally use "0" as p1.
 */
window.PlayVehicleDoorOpenSound = function (vehicle, p1) {
	return _in(0x3a539d52, 0x857ea82d, vehicle, p1);
};

/**
 * Only 1 match. ob_sofa_michael.
 * PLAYER::PLAYER_ATTACH_VIRTUAL_BOUND(-804.5928f, 173.1801f, 71.68436f, 0f, 0f, 0.590625f, 1f, 0.7f);1.0.335.2, 1.0.350.1/2, 1.0.372.2, 1.0.393.2, 1.0.393.4, 1.0.463.1;
 */
window.PlayerAttachVirtualBound = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0xed51733d, 0xc73aed51, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(p6), _fv(p7));
};

/**
 * 1.0.335.2, 1.0.350.1/2, 1.0.372.2, 1.0.393.2, 1.0.393.4, 1.0.463.1;
 */
window.PlayerDetachVirtualBound = function () {
	return _in(0x1dd5897e, 0x2fa6e7c9);
};

/**
 * This returns YOUR 'identity' as a Player type.
 * Always returns 0 in story mode.
 */
window.PlayerId = function () {
	return _in(0x4f8644af, 0x03d0e0d6, _r, _ri);
};

/**
 * Returns current player ped
 */
window.PlayerPedId = function () {
	return _in(0xd80958fc, 0x74e988a6, _r, _ri);
};

window.PlaystatsAmbientMissionCrateCreated = function (p0, p1, p2) {
	return _in(0xafc7e5e0, 0x75a96f46, _fv(p0), _fv(p1), _fv(p2));
};
window.N_0xafc7e5e075a96f46 = window.PlaystatsAmbientMissionCrateCreated;

window.PlaystatsAwardXp = function (p0, p1, p2) {
	return _in(0x46f917f6, 0xb4128fe4, p0, p1, p2);
};

window.PlaystatsCheatApplied = function (cheat) {
	return _in(0x6058665d, 0x72302d3f, _ts(cheat));
};

window.PlaystatsClothChange = function (p0, p1, p2, p3, p4) {
	return _in(0x34b97304, 0x7a2268b9, p0, p1, p2, p3, p4);
};

window.PlaystatsFriendActivity = function (p0, p1) {
	return _in(0x0f71de29, 0xab2258f1, p0, p1);
};

window.PlaystatsMatchStarted = function (p0, p1, p2, p3, p4, p5, p6) {
	return _in(0xbc80e22d, 0xed931e3d, p0, p1, p2, p3, p4, p5, p6);
};

window.PlaystatsMissionCheckpoint = function (p1, p2, p3) {
	return _in(0xc900596a, 0x63978c1d, _i, p1, p2, p3);
};

window.PlaystatsMissionOver = function (p1, p2, p3, p4, p5) {
	return _in(0x7c4bb33a, 0x8ced7324, _i, p1, p2, p3, p4, p5);
};

window.PlaystatsMissionStarted = function (p1, p2, p3) {
	return _in(0xc19a2925, 0xc34d2231, _i, p1, p2, p3);
};

window.PlaystatsNpcInvite = function (p0) {
	return _in(0x93054c88, 0xe6aa7c44, _ii(p0) /* may be optional */);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.PlaystatsOddjobDone = function (p0, p1, p2) {
	return _in(0x69dea3e9, 0xdb727b4c, p0, p1, p2);
};

window.PlaystatsPropChange = function (p0, p1, p2, p3) {
	return _in(0xba739d6d, 0x5a05d6e7, p0, p1, p2, p3);
};

window.PlaystatsRaceCheckpoint = function (p0, p1, p2, p3, p4) {
	return _in(0x9c375c31, 0x5099dde4, p0, p1, p2, p3, p4);
};

window.PlaystatsRankUp = function (p0) {
	return _in(0xc7f2de41, 0xd102bfb4, p0);
};

window.PlaystatsShopItem = function (p0, p1, p2, p3, p4) {
	return _in(0x176852ac, 0xaac173d1, p0, p1, p2, p3, p4);
};

window.PlaystatsWebsiteVisited = function (scaleformHash, p1) {
	return _in(0xddf24d53, 0x5060f811, _ch(scaleformHash), p1);
};
window.N_0xddf24d535060f811 = window.PlaystatsWebsiteVisited;

window.PointCamAtCoord = function (cam, x, y, z) {
	return _in(0xf75497bb, 0x865f0803, cam, _fv(x), _fv(y), _fv(z));
};

/**
 * p5 always seems to be 1 i.e TRUE
 */
window.PointCamAtEntity = function (cam, entity, p2, p3, p4, p5) {
	return _in(0x5640bff8, 0x6b16e8dc, cam, entity, _fv(p2), _fv(p3), _fv(p4), p5);
};

/**
 * Parameters p0-p5 seems correct. The bool p6 is unknown, but through every X360 script it's always 1. Please correct p0-p5 if any prove to be wrong.
 */
window.PointCamAtPedBone = function (cam, ped, boneIndex, x, y, z, p6) {
	return _in(0x68b2b5f3, 0x3ba63c41, cam, ped, boneIndex, _fv(x), _fv(y), _fv(z), p6);
};

window.PopTimecycleModifier = function () {
	return _in(0x3c8938d7, 0xd872211e);
};

/**
 * spawns a few distant/out-of-sight peds, vehicles, animals etc each time it is called
 */
window.PopulateNow = function () {
	return _in(0x7472bb27, 0x0d7b4f3e);
};

window.Pow = function (base, exponent) {
	return _in(0xe3621cc4, 0x0f31fe2e, _fv(base), _fv(exponent), _r, _rf);
};

/**
 * This native is used to attribute the SRL that BeginSrl is going to load. This is usually used for 'in-game' cinematics (not cutscenes but camera stuff) instead of SetFocusArea because it loads a specific area of the map which is pretty useful when the camera moves from distant areas.
 * For instance, GTA:O opening cutscene.
 * <https://pastebin.com/2EeKVeLA> : a list of SRL found in srllist.meta
 * <https://pastebin.com/zd9XYUWY> : here is the content of a SRL file opened with codewalker.
 * @param srl A SRL name.
 */
window.PrefetchSrl = function (srl) {
	return _in(0x3d245789, 0xce12982c, _ts(srl));
};

window.PreloadScriptConversation = function (p0, p1, p2, p3) {
	return _in(0x3b3cad61, 0x66916d87, p0, p1, p2, p3);
};

window.PreloadScriptPhoneConversation = function (p0, p1) {
	return _in(0x6004bcb0, 0xe226aaea, p0, p1);
};

window.PreloadVehicleMod = function (p0, modType, p2) {
	return _in(0x758f49c2, 0x4925568a, p0, modType, p2);
};

/**
 * Example:
 * bool prepareAlarm = AUDIO::PREPARE_ALARM("PORT_OF_LS_HEIST_FORT_ZANCUDO_ALARMS");
 */
window.PrepareAlarm = function (alarmName) {
	return _in(0x9d74ae34, 0x3db65533, _ts(alarmName), _r);
};

/**
 * All music event names found in the b617d scripts: pastebin.com/GnYt0R3P
 */
window.PrepareMusicEvent = function (eventName) {
	return _in(0x1e5185b7, 0x2ef5158a, _ts(eventName), _r);
};

window.PrepareSynchronizedAudioEvent = function (p0, p1) {
	return _in(0xc7abcaca, 0x4985a766, _ts(p0), p1, _r, _ri);
};

window.PrepareSynchronizedAudioEventForScene = function (p0, p1) {
	return _in(0x029fe7cd, 0x1b7e2e75, p0, _ii(p1) /* may be optional */, _r);
};

/**
 * This isn't a hash collision. It is used to give the player cash via the CASH_GIFT stats.
 */
window.ProcessCashGift = function (p2) {
	return _in(0x20194d48, 0xeaec9a41, _i, _i, _ts(p2), _r, _s);
};
window.N_0x20194d48eaec9a41 = window.ProcessCashGift;

/**
 * Called to update entity attachments.
 * When using ATTACH_ENTITY_TO_ENTITY and using bone '0' then you set the first entity invisible. The attachments will mess up, use bone '-1' to fix that issue
 */
window.ProcessEntityAttachments = function (entity) {
	return _in(0xf4080490, 0xadc51c6f, entity);
};

window.PulseBlip = function (blip) {
	return _in(0x742d6fd4, 0x3115af73, blip);
};

/**
 * This method is the equivalent to PUSH_SCALEFORM_MOVIE_FUNCTION_PARAMETER_STRING when using it to add a new button (like "INSTRUCTIONAL_BUTTONS").
 * When switching with a controller, the icons update and become the controller's icons.
 */
window.PushScaleformMovieMethodParameterButtonName = function (button) {
	return _in(0xe83a3e35, 0x57a56640, _ts(button));
};
window.N_0xe83a3e3557a56640 = window.PushScaleformMovieMethodParameterButtonName;

window.PushScaleformMovieMethodParameterString = function (value) {
	return _in(0xba714848, 0x4bd90365, _ts(value));
};
window.PushScaleformMovieFunctionParameterString = window.PushScaleformMovieMethodParameterString;

/**
 * GRAPHICS::\_0x77FE3402004CD1B0(HUD::\_GET_LABEL_TEXT("YACHT_GSY"));
 * GRAPHICS::\_0x77FE3402004CD1B0(PLAYER::GET_PLAYER_NAME(PLAYER::PLAYER_ID()));
 * Both \_0xBA7148484BD90365 / \_0x77FE3402004CD1B0 works, but \_0x77FE3402004CD1B0 is usually used for "name" (organisation, players..).
 */
window.PushScaleformMovieMethodParameterString_2 = function (value) {
	return _in(0x77fe3402, 0x004cd1b0, _ts(value));
};
window.N_0x77fe3402004cd1b0 = window.PushScaleformMovieMethodParameterString_2;

window.PushTimecycleModifier = function () {
	return _in(0x58f73529, 0x0861e6b4);
};

window.RaiseConvertibleRoof = function (vehicle, instantlyRaise) {
	return _in(0x8f5fb35d, 0x7e88fc70, vehicle, instantlyRaise);
};

window.RaiseLowerableWheels = function (vehicle) {
	return _in(0xf6606025, 0x46d27ba8, vehicle);
};

window.RefreshInterior = function (interiorID) {
	return _in(0x41f37c34, 0x27c75ae0, interiorID);
};

window.RefreshWaypoint = function () {
	return _in(0x81fa173f, 0x170560d1);
};

/**
 * **Experimental**: This native may be altered or removed in future versions of CitizenFX without warning.
 * Registers a set of archetypes with the game engine. These should match `CBaseArchetypeDef` class information from the game.
 * @param factory A function returning a list of archetypes.
 */
window.RegisterArchetypes = function (factory) {
	return _in(0x00000000, 0x3c2f9037, _mfr(factory));
};

window.RegisterBoolToSave = function (name) {
	return _in(0xc8f41314, 0x14c835a1, _i, _ts(name));
};

/**
 * Registered commands can be executed by entering them in the client console (this works for client side and server side registered commands). Or by entering them in the server console/through an RCON client (only works for server side registered commands). Or if you use a supported chat resource, like the default one provided in the cfx-server-data repository, then you can enter the command in chat by prefixing it with a `/`.
 * Commands registered using this function can also be executed by resources, using the [`ExecuteCommand` native](#_0x561C060B).
 * The restricted bool is not used on the client side. Permissions can only be checked on the server side, so if you want to limit your command with an ace permission automatically, make it a server command (by registering it in a server script).
 * **Example result**:
 * ![](https://i.imgur.com/TaCnG09.png)
 * @param commandName The command you want to register.
 * @param handler A handler function that gets called whenever the command is executed.
 * @param restricted If this is a server command and you set this to true, then players will need the command.yourCommandName ace permission to execute this command.
 */
window.RegisterCommand = function (commandName, handler, restricted) {
	return _in(0x00000000, 0x5fa79b0f, _ts(commandName), _mfr(handler), restricted);
};

/**
 * **Experimental**: This native may be altered or removed in future versions of CitizenFX without warning.
 * Registers a set of entities with the game engine. These should match `CEntityDef` class information from the game.
 * At this time, this function **should not be used in a live environment**.
 * @param factory A function returning a list of entities.
 */
window.RegisterEntities = function (factory) {
	return _in(0x00000000, 0x410da7d3, _mfr(factory));
};

window.RegisterEntityForCutscene = function (cutscenePed, cutsceneEntName, p2, modelHash, p4) {
	return _in(0xe40c1c56, 0xdf95c2e8, cutscenePed, _ts(cutsceneEntName), p2, _ch(modelHash), p4);
};

window.RegisterEnumToSave = function (name) {
	return _in(0x10c2fa78, 0xd0e128a1, _i, _ts(name));
};

window.RegisterFloatToSave = function (name) {
	return _in(0x7caec29e, 0xcb5dfebb, _i, _ts(name));
};

/**
 * Registers a specified .gfx file as GFx font library.
 * The .gfx file has to be registered with the streamer already.
 * @param fileName The name of the .gfx file, without extension.
 */
window.RegisterFontFile = function (fileName) {
	return _in(0x00000000, 0x01b3a363, _ts(fileName));
};

/**
 * Registers a specified font name for use with text draw commands.
 * @param fontName The name of the font in the GFx font library.
 * @return An index to use with [SET_TEXT_FONT](#_0x66E0276CC5F6B9DA) and similar natives.
 */
window.RegisterFontId = function (fontName) {
	return _in(0x00000000, 0xacf6d8ee, _ts(fontName), _r, _ri);
};

/**
 * Based on TASK_COMBAT_HATED_TARGETS_AROUND_PED, the parameters are likely similar (PedHandle, and area to attack in).
 */
window.RegisterHatedTargetsAroundPed = function (ped, radius) {
	return _in(0x9222f300, 0xbf8354fe, ped, _fv(radius));
};

window.RegisterIntToSave = function (name) {
	return _in(0x34c9ee59, 0x86258415, _i, _ts(name));
};

window.RegisterNamedRendertarget = function (p0, p1) {
	return _in(0x57d9c126, 0x35e25ce3, _ts(p0), p1, _r);
};

window.RegisterNuiCallbackType = function (callbackType) {
	return _in(0x00000000, 0xcd03cda9, _ts(callbackType));
};

/**
 * Registers a script for any object with a specific model hash.
 * BRAIN::REGISTER_OBJECT_SCRIPT_BRAIN("ob_telescope", ${prop_telescope_01}, 100, 4.0, -1, 9);
 */
window.RegisterObjectScriptBrain = function (scriptName, objectName, p2, p3, p4, p5) {
	return _in(0x0be84c31, 0x8ba6ec22, _ts(scriptName), _ch(objectName), p2, _fv(p3), p4, p5);
};

/**
 * gtaforums.com/topic/885580-ped-headshotmugshot-txd/
 */
window.RegisterPedheadshot = function (ped) {
	return _in(0x44626587, 0x88425076, ped, _r, _ri);
};

/**
 * Similar to REGISTER_PEDHEADSHOT but creates a transparent background instead of black.
 * **Result of the example code:**
 * <https://i.imgur.com/iHz8ztn.png>
 * @param ped A ped handle.
 * @return The Pedheadshot handle.
 */
window.RegisterPedheadshotTransparent = function (ped) {
	return _in(0x953563ce, 0x563143af, ped, _r, _ri);
};
window.N_0x953563ce563143af = window.RegisterPedheadshotTransparent;

/**
 * An internal function which allows the current resource's HLL script runtimes to receive state for the specified event.
 * @param eventName An event name, or "\*" to disable HLL event filtering for this resource.
 */
window.RegisterResourceAsEventHandler = function (eventName) {
	return _in(0x00000000, 0xd233a168, _ts(eventName));
};

window.RegisterSaveHouse = function (p0, p1, p2, p3, p5, p6) {
	return _in(0xc0714d0a, 0x7eeeca54, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _i, p5, p6, _r, _ri);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.RegisterScriptWithAudio = function (p0) {
	return _in(0xc6ed9d50, 0x92438d91, p0);
};

/**
 * **Experimental**: This native may be altered or removed in future versions of CitizenFX without warning.
 * Registers a dynamic streaming asset from the server with the GTA streaming module system.
 * @param resourceName The resource to add the asset to.
 * @param fileName A file name in the resource.
 * @param cacheString The string returned from `REGISTER_RESOURCE_ASSET` on the server.
 */
window.RegisterStreamingFileFromCache = function (resourceName, fileName, cacheString) {
	return _in(0x00000000, 0xcead2d4b, _ts(resourceName), _ts(fileName), _ts(cacheString));
};

/**
 * **Experimental**: This native may be altered or removed in future versions of CitizenFX without warning.
 * Registers a KVP value as an asset with the GTA streaming module system. This function currently won't work.
 * @param kvsKey The KVP key in the current resource to register as an asset.
 */
window.RegisterStreamingFileFromKvs = function (kvsKey) {
	return _in(0x00000000, 0x1493dcc1, _ts(kvsKey));
};

/**
 * **Experimental**: This native may be altered or removed in future versions of CitizenFX without warning.
 * Registers a file from an URL as a streaming asset in the GTA streaming subsystem. This will asynchronously register the asset, and caching is done based on the URL itself - cache headers are ignored.
 * Use `IS_STREAMING_FILE_READY` to check if the asset has been registered successfully.
 * @param registerAs The file name to register as, for example `asset.ydr`.
 * @param url The URL to fetch the asset from.
 */
window.RegisterStreamingFileFromUrl = function (registerAs, url) {
	return _in(0x00000000, 0xf44bfb95, _ts(registerAs), _ts(url));
};

window.RegisterSynchronisedScriptSpeech = function () {
	return _in(0x21310469, 0x57f31b04);
};

/**
 * PED::REGISTER_TARGET(l_216, PLAYER::PLAYER_PED_ID()); from re_prisonbreak.txt.
 * l_216 = RECSBRobber1
 */
window.RegisterTarget = function (ped, target) {
	return _in(0x2f25d9ae, 0xfa34fba2, ped, target);
};

window.RegisterTextLabelToSave = function (name) {
	return _in(0xedb1232c, 0x5beae62f, _i, _ts(name));
};

window.RegisterWorldPointScriptBrain = function (p1, p2) {
	return _in(0x3cdc7136, 0x613284bd, _i, _fv(p1), p2);
};

window.ReleaseAmbientAudioBank = function () {
	return _in(0x65475a21, 0x8ffaa93d);
};

window.ReleaseMissionAudioBank = function () {
	return _in(0x0ec92a1b, 0xf0857187);
};

window.ReleaseMovieMeshSet = function (movieMeshSet) {
	return _in(0xeb119aa0, 0x14e89183, movieMeshSet);
};

window.ReleaseNamedRendertarget = function (p0) {
	return _in(0xe9f6ffe8, 0x37354dd4, _ii(p0) /* may be optional */, _r);
};

window.ReleaseNamedScriptAudioBank = function (audioBank) {
	return _in(0x77ed1706, 0x67f50170, _ts(audioBank));
};

window.ReleasePreloadMods = function (vehicle) {
	return _in(0x445d79f9, 0x95508307, vehicle);
};

window.ReleaseScriptAudioBank = function () {
	return _in(0x7a2d8ad0, 0xa9eb9c3f);
};

window.ReleaseSoundId = function (soundId) {
	return _in(0x353fc880, 0x830b88fa, soundId);
};

window.RemoveActionModeAsset = function (asset) {
	return _in(0x13e940f8, 0x8470fa51, _ts(asset));
};

window.RemoveAllCoverBlockingAreas = function () {
	return _in(0xdb6708c0, 0xb46f56d8);
};

/**
 * setting the last params to false it does that same so I would suggest its not a toggle
 */
window.RemoveAllPedWeapons = function (ped, p1) {
	return _in(0xf25df915, 0xfa38c5f3, ped, p1);
};

/**
 * Pickup hashes: pastebin.com/8EuSv2r1
 */
window.RemoveAllPickupsOfType = function (pickupHash) {
	return _in(0x27f9d613, 0x092159cf, _ch(pickupHash));
};

/**
 * p1 seems always to be 0
 */
window.RemoveAllProjectilesOfType = function (weaponHash, p1) {
	return _in(0xfc52e0f3, 0x7e446528, _ch(weaponHash), p1);
};

window.RemoveAllShockingEvents = function (p0) {
	return _in(0xeaabe8fd, 0xfa21274c, p0);
};

window.RemoveAnimDict = function (animDict) {
	return _in(0xf66a602f, 0x829e2a06, _ts(animDict));
};

/**
 * Unloads the specified animation set. An animation set provides movement animations for a ped. See SET_PED_MOVEMENT_CLIPSET.
 * Animation set and clip set are synonymous.
 */
window.RemoveAnimSet = function (animSet) {
	return _in(0x16350528, 0xf93024b3, _ts(animSet));
};

/**
 * In the C++ SDK, this seems not to work-- the blip isn't removed immediately. I use it for saving cars.
 * E.g.:
 * Ped pped = PLAYER::PLAYER_PED_ID();
 * Vehicle v = PED::GET_VEHICLE_PED_IS_USING(pped);
 * Blip b = UI::ADD_BLIP_FOR_ENTITY(v);
 * works fine.
 * But later attempting to delete it with:
 * Blip b = UI::GET_BLIP_FROM_ENTITY(v);
 * if (UI::DOES_BLIP_EXIST(b)) UI::REMOVE_BLIP(&b);
 * doesn't work. And yes, doesn't work without the DOES_BLIP_EXIST check either. Also, if you attach multiple blips to the same thing (say, a vehicle), and that thing disappears, the blips randomly attach to other things (in my case, a vehicle).
 * Thus for me, UI::REMOVE_BLIP(&b) only works if there's one blip, (in my case) the vehicle is marked as no longer needed, you drive away from it and it eventually despawns, AND there is only one blip attached to it. I never intentionally attach multiple blips but if the user saves the car, this adds a blip. Then if they delete it, it is supposed to remove the blip, but it doesn't. Then they can immediately save it again, causing another blip to re-appear.
 * -------------
 * Passing the address of the variable instead of the value works for me.
 * e.g.
 * int blip = UI::ADD_BLIP_FOR_ENTITY(ped);
 * UI::REMOVE_BLIP(&blip);
 * Remove blip will currently crash your game, just artificially remove the blip by setting the sprite to a id that is 'invisible'.
 * --
 * It crashes my game.
 */
window.RemoveBlip = function (blip) {
	return _in(0x86a65257, 0x0e5f25dd, _ii(blip) /* may be optional */);
};

/**
 * Alias for REMOVE_ANIM_SET.
 */
window.RemoveClipSet = function (clipSet) {
	return _in(0x01f73a13, 0x1c18cd94, _ts(clipSet));
};

window.RemoveCoverPoint = function (coverpoint) {
	return _in(0xae287c92, 0x3d891715, coverpoint);
};

/**
 * p0 is the handle returned from _0xFDBF4CDBC07E1706
 */
window.RemoveCurrentRise = function (p0) {
	return _in(0xb1252e3e, 0x59a82aaf, p0);
};
window.N_0xb1252e3e59a82aaf = window.RemoveCurrentRise;

window.RemoveCutscene = function () {
	return _in(0x440af51a, 0x3462b86f);
};

window.RemoveDecal = function (decal) {
	return _in(0xed3f3464, 0x29ccd659, decal);
};

window.RemoveDecalsFromObject = function (obj) {
	return _in(0xccf71cbd, 0xdf5b6cb9, obj);
};

window.RemoveDecalsFromObjectFacing = function (obj, x, y, z) {
	return _in(0xa6f6f70f, 0xdc6d144c, obj, _fv(x), _fv(y), _fv(z));
};

window.RemoveDecalsFromVehicle = function (vehicle) {
	return _in(0xe91f1b65, 0xf2b48d57, vehicle);
};

/**
 * Removes all decals in range from a position, it includes the bullet holes, blood pools, petrol...
 */
window.RemoveDecalsInRange = function (x, y, z, range) {
	return _in(0x5d6b2d48, 0x30a67c62, _fv(x), _fv(y), _fv(z), _fv(range));
};

window.RemoveDispatchSpawnBlockingArea = function (p0) {
	return _in(0x264ac28b, 0x01b353a5, p0);
};

window.RemoveDoorFromSystem = function (doorHash) {
	return _in(0x464d8e14, 0x27156fe4, _ch(doorHash));
};

window.RemoveForcedObject = function (p0, p1, p2, p3, p4) {
	return _in(0x61b6775e, 0x83c0db6f, p0, p1, p2, p3, p4);
};

window.RemoveFromItemset = function (p0, p1) {
	return _in(0x25e68244, 0xb0177686, p0, p1);
};

window.RemoveGroup = function (groupId) {
	return _in(0x8eb2f690, 0x76af7053, groupId);
};

/**
 * IPL list: pastebin.com/iNGLY32D
 */
window.RemoveIpl = function (iplName) {
	return _in(0xee6c5ad3, 0xece0a82d, _ts(iplName));
};

/**
 * Removes the loading prompt at the bottom right of the screen, created by the UI::_SHOW_LOADING_PROMPT native.
 */
window.RemoveLoadingPrompt = function () {
	return _in(0x10d37332, 0x3e5b9c0d);
};
window.N_0x10d373323e5b9c0d = window.RemoveLoadingPrompt;

window.RemoveModelHide = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xd9e3006f, 0xb3cbd765, p0, p1, p2, p3, p4, p5);
};

window.RemoveModelSwap = function (x, y, z, radius, originalModel, newModel, p6) {
	return _in(0x033c0f9a, 0x64e229ae, _fv(x), _fv(y), _fv(z), _fv(radius), _ch(originalModel), _ch(newModel), p6);
};

window.RemoveMpGamerTag = function (gamerTagId) {
	return _in(0x31698aa8, 0x0e0223f8, gamerTagId);
};
window.N_0x31698aa80e0223f8 = window.RemoveMpGamerTag;

window.RemoveMultiplayerBankCash = function () {
	return _in(0xc7c6789a, 0xa1cfedd0);
};

/**
 * Removes multiplayer cash hud each frame
 */
window.RemoveMultiplayerHudCash = function () {
	return _in(0x968f270e, 0x39141eca);
};

/**
 * assetName = For example "core"
 * console hash: 0xC44762A1
 */
window.RemoveNamedPtfxAsset = function (assetName) {
	return _in(0x5f61ebbe, 0x1a00f96d, _ts(assetName));
};

window.RemoveNavmeshBlockingObject = function (p0) {
	return _in(0x46399a78, 0x95957c0e, p0);
};

window.RemoveNavmeshRequiredRegions = function () {
	return _in(0x916f0a3c, 0xdec3445e);
};

/**
 * Removes a notification instantly instead of waiting for it to disappear
 */
window.RemoveNotification = function (notificationId) {
	return _in(0xbe4390cb, 0x40b3e627, notificationId);
};

window.RemoveParticleFx = function (ptfxHandle, p1) {
	return _in(0xc401503d, 0xfe8d53cf, ptfxHandle, p1);
};

window.RemoveParticleFxFromEntity = function (entity) {
	return _in(0xb8feaeeb, 0xcc127425, entity);
};

window.RemoveParticleFxInRange = function (X, Y, Z, radius) {
	return _in(0xdd19fa1c, 0x6d657305, _fv(X), _fv(Y), _fv(Z), _fv(radius));
};

/**
 * Ped will no longer get angry when you stay near him.
 */
window.RemovePedDefensiveArea = function (ped, toggle) {
	return _in(0x74d4e028, 0x107450a9, ped, toggle);
};

/**
 * Judging purely from a quick disassembly, if the ped is in a vehicle, the ped will be deleted immediately. If not, it'll be marked as no longer needed. - very elegant..
 */
window.RemovePedElegantly = function (ped) {
	return _in(0xac6d445b, 0x994df95e, _ii(ped) /* may be optional */);
};

window.RemovePedFromGroup = function (ped) {
	return _in(0xed74007f, 0xfb146bc2, ped);
};

window.RemovePedHelmet = function (ped, instantly) {
	return _in(0xa7b2458d, 0x0ad6ded8, ped, instantly);
};

window.RemovePedPreferredCoverSet = function (ped) {
	return _in(0xfddb234c, 0xf74073d9, ped);
};
window.N_0xfddb234cf74073d9 = window.RemovePedPreferredCoverSet;

/**
 * Retracts the hook on the cargobob.
 * Note: after you retract it the natives for dropping the hook no longer work
 */
window.RemovePickUpRopeForCargobob = function (cargobob) {
	return _in(0x9768cf64, 0x8f54c804, cargobob);
};
window.RetractCargobobHook = window.RemovePickUpRopeForCargobob;

window.RemovePickup = function (pickup) {
	return _in(0x3288d8ac, 0xaecd2ab2, pickup);
};

window.RemovePlayerHelmet = function (player, p2) {
	return _in(0xf3ac26d3, 0xcc576528, player, p2, _r, _ri);
};

window.RemovePtfxAsset = function () {
	return _in(0x88c68140, 0x73dd4a73);
};

window.RemoveRelationshipGroup = function (groupHash) {
	return _in(0xb6ba2444, 0xab393da2, _ch(groupHash));
};

/**
 * Experimental natives, please do not use in a live environment.
 */
window.RemoveReplaceTexture = function (origTxd, origTxn) {
	return _in(0x00000000, 0xa896b20a, _ts(origTxd), _ts(origTxn));
};

window.RemoveScenarioBlockingArea = function (p0, p1) {
	return _in(0x31d16b74, 0xc6e29d66, p0, p1);
};

window.RemoveScenarioBlockingAreas = function () {
	return _in(0xd37401d7, 0x8a929a49);
};

window.RemoveScriptFire = function (fireHandle) {
	return _in(0x7ff54838, 0x5680673f, fireHandle);
};

window.RemoveShockingEvent = function (event) {
	return _in(0x2cda538c, 0x44c6cce5, event, _r);
};

window.RemoveShockingEventSpawnBlockingAreas = function () {
	return _in(0x340f1415, 0xb68aeade);
};

/**
 * Used to remove a speedzone.
 * This is the speed zone native.
 * Example usage C#:
 * uint speedZone = Function.Call<uint>((Hash) 0x2CE544C68FB812A0, Game.PlayerPed.Position.X, Game.PlayerPed.Position.Y, Game.PlayerPed.Position.Z, 100.0f, 0.0f, false);
 * bool speedZoneClosed = Function.Call<bool>((Hash) 0x1033371FC8E842A7, speedZone);
 * (Thanks to alexguirre for his help!)
 */
window.RemoveSpeedZone = function (speedzone) {
	return _in(0x1033371f, 0xc8e842a7, speedzone, _r);
};
window.N_0x1033371fc8e842a7 = window.RemoveSpeedZone;

/**
 * Appears to remove stealth kill action from memory.
 * ------------------------------------
 * I agree with the above statement.
 * p1 is unknown, my best guess would be if false it marks the stealth kill for immediate deletion, or if true marks it for deletion later.
 */
window.RemoveStealthKill = function (hash, p1) {
	return _in(0xa6a12939, 0xf16d85be, _ch(hash), p1);
};
window.N_0xa6a12939f16d85be = window.RemoveStealthKill;

window.RemoveStealthModeAsset = function (asset) {
	return _in(0x9219857d, 0x21f0e842, _ts(asset));
};

window.RemoveVehicleAsset = function (vehicleAsset) {
	return _in(0xace699c7, 0x1ab9deb5, vehicleAsset);
};

window.RemoveVehicleHighDetailModel = function (vehicle) {
	return _in(0x00689cde, 0x5f7c6787, vehicle);
};

window.RemoveVehicleMod = function (vehicle, modType) {
	return _in(0x92d619e4, 0x20858204, vehicle, modType);
};

window.RemoveVehicleRecording = function (p0, p1) {
	return _in(0xf1160acc, 0xf98a3fc8, p0, _ii(p1) /* may be optional */);
};

window.RemoveVehicleStuckCheck = function (vehicle) {
	return _in(0x8386bfb6, 0x14d06749, vehicle);
};

window.RemoveVehicleUpsidedownCheck = function (vehicle) {
	return _in(0xc53eb42a, 0x499a7e90, vehicle);
};

/**
 * windowIndex:
 * 0 = Front Right Window
 * 1 = Front Left Window
 * 2 = Back Right Window
 * 3 = Back Left Window
 */
window.RemoveVehicleWindow = function (vehicle, windowIndex) {
	return _in(0xa711568e, 0xedb43069, vehicle, windowIndex);
};

window.RemoveVehiclesFromGeneratorsInArea = function (x1, y1, z1, x2, y2, z2, unk) {
	return _in(0x46a1e1a2, 0x99ec4bba, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), unk);
};

/**
 * For a full list, see here: pastebin.com/Tp0XpBMN
 */
window.RemoveWaypointRecording = function (name) {
	return _in(0xff1b8b4a, 0xa1c25dc8, _ts(name));
};

window.RemoveWeaponAsset = function (weaponHash) {
	return _in(0xaa08ef13, 0xf341c8fc, _ch(weaponHash));
};

window.RemoveWeaponComponentFromPed = function (ped, weaponHash, componentHash) {
	return _in(0x1e8be90c, 0x74fb4c09, ped, _ch(weaponHash), _ch(componentHash));
};

window.RemoveWeaponComponentFromWeaponObject = function (p0, p1) {
	return _in(0xf7d82b0d, 0x66777611, p0, p1);
};

/**
 * This native removes a specified weapon from your selected ped.
 * Weapon Hashes: pastebin.com/0wwDZgkF
 * Example:
 * C#:
 * Function.Call(Hash.REMOVE_WEAPON_FROM_PED, Game.Player.Character, 0x99B507EA);
 * C++:
 * WEAPON::REMOVE_WEAPON_FROM_PED(PLAYER::PLAYER_PED_ID(), 0x99B507EA);
 * The code above removes the knife from the player.
 */
window.RemoveWeaponFromPed = function (ped, weaponHash) {
	return _in(0x4899cb08, 0x8edf59b8, ped, _ch(weaponHash));
};

/**
 * This native makes the gameplay camera zoom into first person/third person with a special effect.
 * For example, if you were first person in a mission and after the cutscene ends, the camera would then zoom into the first person camera view.
 * if (CAM::GET_FOLLOW_PED_CAM_VIEW_MODE() != 4)
 * CAM::_C819F3CBB62BF692(1, 0, 3, 0)
 * This makes the camera zoom in to first person.
 * --------------------------------------------
 * 1st Param Options: 0 or 1 (Changes quit often, toggle?)
 * 2nd Param Options: 0, 0f, 1f, 3.8f, 10f, 20f (Mostly 0)
 * 3rd Param Options: 3, 2, 1 (Mostly 3);
 * Note for the 2nd param 10f (offroad_race.c) and 3rd param 20f (range_modern.c) are the only times those 2 high floats are called.
 * Note for the 3rd param 2 is only ever set in (franklin0.c), but it also sets it as 3. (0, 0, 3) ||(0, 0f, 2) || (0, 0, 3)
 */
window.RenderFirstPersonCam = function (render, p1, p2) {
	return _in(0xc819f3cb, 0xb62bf692, render, _fv(p1), p2);
};
window.N_0xc819f3cbb62bf692 = window.RenderFirstPersonCam;

/**
 * ease - smooth transition between the camera's positions
 * easeTime - Time in milliseconds for the transition to happen
 * If you have created a script (rendering) camera, and want to go back to the
 * character (gameplay) camera, call this native with render set to 0.
 * Setting ease to 1 will smooth the transition.
 */
window.RenderScriptCams = function (render, ease, easeTime, p3, p4) {
	return _in(0x07e5b515, 0xdb0636fc, render, ease, easeTime, p3, p4);
};

/**
 * PLAYER::REPORT_CRIME(PLAYER::PLAYER_ID(), 37, PLAYER::GET_WANTED_LEVEL_THRESHOLD(1));
 * From am_armybase.ysc.c4:
 * PLAYER::REPORT_CRIME(PLAYER::PLAYER_ID(4), 36, PLAYER::GET_WANTED_LEVEL_THRESHOLD(4));
 * -----
 * This was taken from the GTAV.exe v1.334. The function is called sub_140592CE8. For a full decompilation of the function, see here: pastebin.com/09qSMsN7
 * -----
 * crimeType:
 * 1: Firearms possession
 * 2: Person running a red light ("5-0-5")
 * 3: Reckless driver
 * 4: Speeding vehicle (a "5-10")
 * 5: Traffic violation (a "5-0-5")
 * 6: Motorcycle rider without a helmet
 * 7: Vehicle theft (a "5-0-3")
 * 8: Grand Theft Auto
 * 9: ???
 * 10: ???
 * 11: Assault on a civilian (a "2-40")
 * 12: Assault on an officer
 * 13: Assault with a deadly weapon (a "2-45")
 * 14: Officer shot (a "2-45")
 * 15: Pedestrian struck by a vehicle
 * 16: Officer struck by a vehicle
 * 17: Helicopter down (an "AC"?)
 * 18: Civilian on fire (a "2-40")
 * 19: Officer set on fire (a "10-99")
 * 20: Car on fire
 * 21: Air unit down (an "AC"?)
 * 22: An explosion (a "9-96")
 * 23: A stabbing (a "2-45") (also something else I couldn't understand)
 * 24: Officer stabbed (also something else I couldn't understand)
 * 25: Attack on a vehicle ("MDV"?)
 * 26: Damage to property
 * 27: Suspect threatening officer with a firearm
 * 28: Shots fired
 * 29: ???
 * 30: ???
 * 31: ???
 * 32: ???
 * 33: ???
 * 34: A "2-45"
 * 35: ???
 * 36: A "9-25"
 * 37: ???
 * 38: ???
 * 39: ???
 * 40: ???
 * 41: ???
 * 42: ???
 * 43: Possible disturbance
 * 44: Civilian in need of assistance
 * 45: ???
 * 46: ???
 */
window.ReportCrime = function (player, crimeType, wantedLvlThresh) {
	return _in(0xe9b09589, 0x827545e7, player, crimeType, wantedLvlThresh);
};

window.RequestActionModeAsset = function (asset) {
	return _in(0x290e2780, 0xbb7aa598, _ts(asset));
};

/**
 * MulleDK19: Alias of REQUEST_COLLISION_AT_COORD.
 */
window.RequestAdditionalCollisionAtCoord = function (x, y, z) {
	return _in(0xc9156dc1, 0x1411a9ea, _fv(x), _fv(y), _fv(z));
};

/**
 * Request a gxt into the passed slot.
 */
window.RequestAdditionalText = function (gxt, slot) {
	return _in(0x71a78003, 0xc8e71424, _ts(gxt), slot);
};

window.RequestAdditionalText_2 = function (gxt, slot) {
	return _in(0x6009f9f1, 0xae90d8a6, _ts(gxt), slot);
};

/**
 * All occurrences and usages found in b617d, sorted alphabetically and identical lines removed: pastebin.com/XZ1tmGEz
 */
window.RequestAmbientAudioBank = function (p0, p1) {
	return _in(0xfe02ffbe, 0xd8ca9d99, _ts(p0), p1, _r);
};

window.RequestAnimDict = function (animDict) {
	return _in(0xd3bd4095, 0x1412fef6, _ts(animDict));
};

/**
 * Starts loading the specified animation set. An animation set provides movement animations for a ped. See SET_PED_MOVEMENT_CLIPSET.
 */
window.RequestAnimSet = function (animSet) {
	return _in(0x6ea47dae, 0x7fad0eed, _ts(animSet));
};

window.RequestClipSet = function (clipSet) {
	return _in(0xd2a71e1a, 0x77418a49, _ts(clipSet));
};

window.RequestCollisionAtCoord = function (x, y, z) {
	return _in(0x07503f79, 0x48f491a7, _fv(x), _fv(y), _fv(z), _r, _ri);
};

window.RequestCollisionForModel = function (model) {
	return _in(0x923cb32a, 0x3b874fcb, _ch(model));
};

/**
 * p1: usually 8
 * Cutscene list: pastebin.com/Bbj7ANpQ
 */
window.RequestCutscene = function (cutsceneName, p1) {
	return _in(0x7a86743f, 0x475d9e09, _ts(cutsceneName), p1);
};

/**
 * Example:
 * CUTSCENE::_0xC23DE0E91C30B58C("JOSH_1_INT_CONCAT", 13, 8);
 * Cutscene list: pastebin.com/Bbj7ANpQ
 */
window.RequestCutsceneEx = function (cutsceneName, p1, p2) {
	return _in(0xc23de0e9, 0x1c30b58c, _ts(cutsceneName), p1, p2);
};
window.N_0xc23de0e91c30b58c = window.RequestCutsceneEx;

/**
 * http://gtaforums.com/topic/717612-v-scriptnative-documentation-and-research/?p=1068285912
 */
window.RequestHudScaleform = function (hudComponent) {
	return _in(0x9304881d, 0x6f6537ea, hudComponent);
};
window.N_0x9304881d6f6537ea = window.RequestHudScaleform;

/**
 * REQUEST_*
 * Something to do with interiors that have been loaded.
 * STREAMING::_8A7A40100EDFEC58(l_13BC, "V_FIB01_cur_elev");
 * STREAMING::_8A7A40100EDFEC58(l_13BC, "limbo");
 * STREAMING::_8A7A40100EDFEC58(l_13BB, "V_Office_gnd_lifts");
 * STREAMING::_8A7A40100EDFEC58(l_13BB, "limbo");
 * STREAMING::_8A7A40100EDFEC58(l_13BC, "v_fib01_jan_elev");
 * STREAMING::_8A7A40100EDFEC58(l_13BC, "limbo");
 */
window.RequestInteriorRoomByName = function (interiorID, roomName) {
	return _in(0x8a7a4010, 0x0edfec58, interiorID, _ts(roomName));
};
window.N_0x8a7a40100edfec58 = window.RequestInteriorRoomByName;

/**
 * IPL list: pastebin.com/iNGLY32D
 */
window.RequestIpl = function (iplName) {
	return _in(0x41b48938, 0x43bbdb74, _ts(iplName));
};

/**
 * streaming::request_menu_ped_model(joaat("player_zero"));
 * iVar0 = ped::create_ped(25, joaat("player_zero"), cam::_get_gameplay_cam_coords(), 0f, 0, false);
 * entity::freeze_entity_position(iVar0, true);
 * ped::_0x4668d80430d6c299(iVar0);
 * ui::give_ped_to_pause_menu(iVar0, 1);
 */
window.RequestMenuPedModel = function (model) {
	return _in(0xa0261aef, 0x7acfc51e, _ch(model));
};
window.N_0xa0261aef7acfc51e = window.RequestMenuPedModel;

/**
 * All occurrences and usages found in b617d: pastebin.com/NzZZ2Tmm
 */
window.RequestMissionAudioBank = function (p0, p1) {
	return _in(0x7345bdd9, 0x5e62e0f2, _ts(p0), p1, _r);
};

/**
 * Request a model to be loaded into memory
 * Looking it the disassembly, it seems like it actually returns the model if it's already loaded.
 */
window.RequestModel = function (model) {
	return _in(0x963d27a5, 0x8df860ac, _ch(model));
};

/**
 * assetName = For example "core"
 * From the b678d decompiled scripts:
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("core_snow");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("fm_mission_controler");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("proj_xmas_firework");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_apartment_mp");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_biolab_heist");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_indep_fireworks");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_indep_parachute");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_indep_wheelsmoke");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_mp_cig_plane");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_mp_creator");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_mp_tankbattle");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_ornate_heist");
 * STREAMING::REQUEST_NAMED_PTFX_ASSET("scr_prison_break_heist_station");
 */
window.RequestNamedPtfxAsset = function (assetName) {
	return _in(0xb80d8756, 0xb4668ab6, _ts(assetName));
};

/**
 * maps script name (thread + 0xD0) by lookup via scriptfx.dat - does nothing when script name is empty
 */
window.RequestPtfxAsset = function () {
	return _in(0x944955fb, 0x2a3935c8, _r, _ri);
};

/**
 * GTA V Scaleforms Decompiled
 * pastebin.com/mmNdjX2k
 * Gets a new native after almost every update.
 * Update 1.0.393.2
 * 0x67D02A194A2FC2BD
 * Update 1.0.463.1
 * 0xC97D787CE7726A2F
 * Update 1.0.505.2
 * 0x36ECDA4DD9A3F08D
 * Update 1.0.573.1
 * 0xE3C796DC28BC3254
 * Update 1.0.678.1
 * 0x2F14983962462691
 */
window.RequestScaleformMovie = function (scaleformName) {
	return _in(0x11fe353c, 0xf9733e6f, _ts(scaleformName), _r, _ri);
};

/**
 * Also used by 0x67D02A194A2FC2BD
 */
window.RequestScaleformMovieInstance = function (scaleformName) {
	return _in(0xc514489c, 0xfb8af806, _ts(scaleformName), _r, _ri);
};

/**
 * Similar to REQUEST_SCALEFORM_MOVIE, but seems to be some kind of "interactive" scaleform movie?
 * These seem to be the only scaleforms ever requested by this native:
 * "breaking_news"
 * "desktop_pc"
 * "ECG_MONITOR"
 * "Hacking_PC"
 * "TEETH_PULLING"
 * Note: Unless this hash is out-of-order, this native is next-gen only.
 */
window.RequestScaleformMovieInteractive = function (scaleformName) {
	return _in(0xbd06c611, 0xbb9048c2, _ts(scaleformName), _r, _ri);
};
window.RequestScaleformMovie3 = window.RequestScaleformMovieInteractive;

/**
 * For a full list, see here: pastebin.com/yLNWicUi
 */
window.RequestScript = function (scriptName) {
	return _in(0x6eb5f71a, 0xa68f2e8e, _ts(scriptName));
};

/**
 * All occurrences and usages found in b617d, sorted alphabetically and identical lines removed: pastebin.com/AkmDAVn6
 */
window.RequestScriptAudioBank = function (p0, p1) {
	return _in(0x2f844a8b, 0x08d76685, _ts(p0), p1, _r);
};

/**
 * formerly _REQUEST_STREAMED_SCRIPT
 */
window.RequestScriptWithNameHash = function (scriptHash) {
	return _in(0xd62a67d2, 0x6d9653e6, _ch(scriptHash));
};
window.RequestStreamedScript = window.RequestScriptWithNameHash;

window.RequestStealthModeAsset = function (asset) {
	return _in(0x2a0a62fc, 0xdee16d4f, _ts(asset));
};

/**
 * last param seems to be unused in disassembly
 */
window.RequestStreamedTextureDict = function (textureDict, p1) {
	return _in(0xdfa2ef8e, 0x04127dd5, _ts(textureDict), p1);
};

/**
 * REQUEST_VEHICLE_ASSET(GET_HASH_KEY(cargobob3), 3);
 * vehicle found that have asset's:
 * cargobob3
 * submersible
 * blazer
 */
window.RequestVehicleAsset = function (vehicleHash, vehicleAsset) {
	return _in(0x81a15811, 0x460fab3a, _ch(vehicleHash), vehicleAsset);
};

window.RequestVehicleHighDetailModel = function (vehicle) {
	return _in(0xa6e9fdcb, 0x2c76785e, vehicle);
};

/**
 * used for the remote vehicle explode thing with phones
 */
window.RequestVehiclePhoneExplosion = function () {
	return _in(0xef49cf02, 0x70307cbe);
};
window.N_0xef49cf0270307cbe = window.RequestVehiclePhoneExplosion;

/**
 * In script files, seen as REQUEST_VEHICLE_RECORDING(1, "FBIs1UBER");
 */
window.RequestVehicleRecording = function (i, name) {
	return _in(0xaf514cab, 0xe74cbf15, i, _ts(name));
};

/**
 * For a full list, see here: pastebin.com/Tp0XpBMN
 * For a full list of the points, see here: goo.gl/wIH0vn
 * Max number of loaded recordings is 32.
 */
window.RequestWaypointRecording = function (name) {
	return _in(0x9eefb62e, 0xb27b5792, _ts(name));
};

/**
 * Nearly every instance of p1 I found was 31. Nearly every instance of p2 I found was 0.
 * REQUEST_WEAPON_ASSET(iLocal_1888, 31, 26);
 */
window.RequestWeaponAsset = function (weaponHash, p1, p2) {
	return _in(0x5443438f, 0x033e29c3, _ch(weaponHash), p1, p2);
};

window.RequestWeaponHighDetailModel = function (weaponObject) {
	return _in(0x48164dbb, 0x970ac3f0, weaponObject);
};

window.ReserveNetworkMissionObjects = function (amount) {
	return _in(0x4e5c93bd, 0x0c32fbf8, amount);
};

window.ReserveNetworkMissionPeds = function (amount) {
	return _in(0xb60feba4, 0x5333d36f, amount);
};

window.ReserveNetworkMissionVehicles = function (amount) {
	return _in(0x76b02e21, 0xed27a469, amount);
};

window.ResetAiMeleeWeaponDamageModifier = function () {
	return _in(0x46e56a7c, 0xd1d63c3f);
};

window.ResetAiWeaponDamageModifier = function () {
	return _in(0xea16670e, 0x7ba4743c);
};

/**
 * Sets the waves intensity back to original (1.0 in most cases).
 */
window.ResetCurrentIntensity = function () {
	return _in(0x5e5e9928, 0x5ae812db);
};
window.N_0x5e5e99285ae812db = window.ResetCurrentIntensity;
window.ResetWavesIntensity = window.ResetCurrentIntensity;

window.ResetDispatchIdealSpawnDistance = function () {
	return _in(0x77a84429, 0xdd9f0a15);
};

window.ResetDispatchSpawnBlockingAreas = function () {
	return _in(0xac7bfd5c, 0x1d83ea75);
};

/**
 * Sets (almost, not sure) all Rockstar Editor values (bIsRecording etc) to 0.
 */
window.ResetEditorValues = function () {
	return _in(0x3353d13f, 0x09307691);
};
window.N_0x3353d13f09307691 = window.ResetEditorValues;

window.ResetEntityAlpha = function (entity) {
	return _in(0x9b1e824f, 0xfbb7027a, entity, _r, _ri);
};

window.ResetExclusiveScenarioGroup = function () {
	return _in(0x4202bbcb, 0x8684563d);
};

/**
 * Resets the extra timecycle modifier strength normally set with [`SetExtraTimecycleModifierStrength`](#_0x2C328AF17210F009)
 */
window.ResetExtraTimecycleModifierStrength = function () {
	return _in(0x2bf72ad5, 0xb41aa739);
};
window.N_0x2bf72ad5b41aa739 = window.ResetExtraTimecycleModifierStrength;

window.ResetGroupFormationDefaultSpacing = function (groupHandle) {
	return _in(0x63dab4cc, 0xb3273205, groupHandle);
};

window.ResetHudComponentValues = function (id) {
	return _in(0x450930e6, 0x16475d0d, id);
};

/**
 * Sets the localplayer playerinfo state back to playing (State 0)
 * States are:
 * -1: "Invalid"
 * 0: "Playing"
 * 1: "Died"
 * 2: "Arrested"
 * 3: "Failed Mission"
 * 4: "Left Game"
 * 5: "Respawn"
 * 6: "In MP Cutscene"
 */
window.ResetLocalplayerState = function () {
	return _in(0xc0aa53f8, 0x66b3134d);
};

/**
 * console hash: 0x9E8D8B72
 * Resets the effect of _SET_PARTICLE_FX_ASSET_OLD_TO_NEW
 */
window.ResetParticleFxAssetOldToNew = function (name) {
	return _in(0x89c8553d, 0xd3274aae, _ts(name));
};
window.N_0x89c8553dd3274aae = window.ResetParticleFxAssetOldToNew;

window.ResetPedAudioFlags = function (ped) {
	return _in(0xf54bb7b6, 0x1036f335, ped);
};

window.ResetPedInVehicleContext = function (ped) {
	return _in(0x22ef8ff8, 0x778030eb, ped);
};

/**
 * Resets the value for the last vehicle driven by the Ped.
 */
window.ResetPedLastVehicle = function (ped) {
	return _in(0xbb8de8cf, 0x6a8dd8bb, ped);
};

/**
 * If p1 is 0.0, I believe you are back to normal.
 * If p1 is 1.0, it looks like you can only rotate the ped, not walk.
 * Using the following code to reset back to normal
 * PED::RESET_PED_MOVEMENT_CLIPSET(PLAYER::PLAYER_PED_ID(), 0.0);
 */
window.ResetPedMovementClipset = function (ped, p1) {
	return _in(0xaa74ec0c, 0xb0aaea2c, ped, _fv(p1));
};

/**
 * There seem to be 26 flags
 */
window.ResetPedRagdollBlockingFlags = function (ped, flags) {
	return _in(0xd86d101f, 0xcfd00a4b, ped, flags);
};
window.N_0xd86d101fcfd00a4b = window.ResetPedRagdollBlockingFlags;

window.ResetPedRagdollTimer = function (ped) {
	return _in(0x9fa4664c, 0xf62e47e8, ped);
};

window.ResetPedStrafeClipset = function (ped) {
	return _in(0x20510814, 0x175ea477, ped);
};

window.ResetPedVisibleDamage = function (ped) {
	return _in(0x3ac1f7b8, 0x98f30c05, ped, _r, _ri);
};

window.ResetPedWeaponMovementClipset = function (ped) {
	return _in(0x97b0db5b, 0x4aa74e77, ped);
};

window.ResetPlayerArrestState = function (player) {
	return _in(0x2d03e13c, 0x460760d6, player);
};

window.ResetPlayerInputGait = function (player) {
	return _in(0x19531c47, 0xa2abd691, player);
};

window.ResetPlayerStamina = function (player) {
	return _in(0xa6f312fc, 0xce9c1dfe, player);
};

window.ResetReticuleValues = function () {
	return _in(0x12782ce0, 0xa636e9f0);
};

window.ResetScenarioGroupsEnabled = function () {
	return _in(0xdd902d03, 0x49afad3a);
};

window.ResetScenarioTypesEnabled = function () {
	return _in(0x0d40ee2a, 0x7f2b2d6d);
};

/**
 * This function resets the alignment set using `SET_SCRIPT_GFX_ALIGN` and `SET_SCRIPT_GFX_ALIGN_PARAMS` to the default
 * values ('I', 'I'; 0, 0, 0, 0). This should be used after having used the aforementioned functions in order to not affect
 * any other scripts attempting to draw.
 */
window.ResetScriptGfxAlign = function () {
	return _in(0xe3a3db41, 0x4a373dab);
};
window.N_0xe3a3db414a373dab = window.ResetScriptGfxAlign;
window.ScreenDrawPositionEnd = window.ResetScriptGfxAlign;

window.ResetTrevorRage = function () {
	return _in(0xe78503b1, 0x0c4314e0);
};

/**
 * The inner function has a switch on the second parameter. It's the stuck timer index.
 * Here's some pseudo code I wrote for the inner function:
 * void __fastcall NATIVE_RESET_VEHICLE_STUCK_TIMER_INNER(CUnknown* unknownClassInVehicle, int timerIndex)
 * {
 * switch (timerIndex)
 * {
 * case 0:
 * unknownClassInVehicle->FirstStuckTimer = (WORD)0u;
 * case 1:
 * unknownClassInVehicle->SecondStuckTimer = (WORD)0u;
 * case 2:
 * unknownClassInVehicle->ThirdStuckTimer = (WORD)0u;
 * case 3:
 * unknownClassInVehicle->FourthStuckTimer = (WORD)0u;
 * case 4:
 * unknownClassInVehicle->FirstStuckTimer = (WORD)0u;
 * unknownClassInVehicle->SecondStuckTimer = (WORD)0u;
 * unknownClassInVehicle->ThirdStuckTimer = (WORD)0u;
 * unknownClassInVehicle->FourthStuckTimer = (WORD)0u;
 * break;
 * };
 * }
 */
window.ResetVehicleStuckTimer = function (vehicle, nullAttributes) {
	return _in(0xd7591b00, 0x65afaa7a, vehicle, nullAttributes);
};

window.ResetVehicleWheels = function (vehicle, toggle) {
	return _in(0x21d2e566, 0x2c1f6fed, vehicle, toggle);
};

window.ResetWantedLevelDifficulty = function (player) {
	return _in(0xb9d0dd99, 0x0dc141dd, player);
};

/**
 * Please change back to _0xBD12C5EEE184C33 (hash collision)
 * actual native starts with SET_RADAR_ZOOM_...
 */
window.RespondingAsTemp = function (p0) {
	return _in(0xbd12c5ee, 0xe184c337, _fv(p0));
};

/**
 * Before using this native click the native above and look at the decription.
 * Example:
 * int GetHash = Function.Call<int>(Hash.GET_HASH_KEY, "fe_menu_version_corona_lobby");
 * Function.Call(Hash.ACTIVATE_FRONTEND_MENU, GetHash, 0, -1);
 * Function.Call(Hash.RESTART_FRONTEND_MENU(GetHash, -1);
 * This native refreshes the frontend menu.
 * p1 = Hash of Menu
 * p2 = Unknown but always works with -1.
 */
window.RestartFrontendMenu = function (menuHash, p1) {
	return _in(0x10706dc6, 0xad2d49c0, _ch(menuHash), p1);
};

window.RestartScriptedConversation = function () {
	return _in(0x9aeb285d, 0x1818c9ac);
};

window.RestorePlayerStamina = function (player, p1) {
	return _in(0xa352c1b8, 0x64cafd33, player, _fv(p1));
};

/**
 * This function will simply bring the dead person back to life.
 * Try not to use it alone, since using this function alone, will make peds fall through ground in hell(well for the most of the times).
 * Instead, before calling this function, you may want to declare the position, where your Resurrected ped to be spawn at.(For instance, Around 2 floats of Player's current position.)
 * Also, disabling any assigned task immediately helped in the number of scenarios, where If you want peds to perform certain decided tasks.
 */
window.ResurrectPed = function (ped) {
	return _in(0x71bc8e83, 0x8b9c6035, ped);
};

/**
 * It returns two lol
 * li r3, 2
 * blr
 * thats all it does.
 * mov dword ptr [rax], 2
 * Заебись функционал
 */
window.ReturnTwo = function (p0) {
	return _in(0x40afb081, 0xf8add4ee, p0, _r, _ri);
};
window.N_0x40afb081f8add4ee = window.ReturnTwo;

/**
 * It will revive/cure the injured ped. The condition is ped must not be dead.
 * Upon setting and converting the health int, found, if health falls below 5, the ped will lay on the ground in pain(Maximum default health is 100).
 * This function is well suited there.
 */
window.ReviveInjuredPed = function (ped) {
	return _in(0x8d8acd83, 0x88cd99ce, ped);
};

/**
 * windowIndex:
 * 0 = Front Right Window
 * 1 = Front Left Window
 * 2 = Back Right Window
 * 3 = Back Left Window
 */
window.RollDownWindow = function (vehicle, windowIndex) {
	return _in(0x7ad9e6ce, 0x657d69e3, vehicle, windowIndex, _r, _ri);
};

/**
 * Roll down all the windows of the vehicle passed through the first parameter.
 */
window.RollDownWindows = function (vehicle) {
	return _in(0x85796b05, 0x49dde156, vehicle);
};

/**
 * 0 = Front Right Window
 * 1 = Front Left Window
 * 2 = Back Right Window
 * 3 = Back Left Window
 */
window.RollUpWindow = function (vehicle, windowIndex) {
	return _in(0x602e548f, 0x46e24d59, vehicle, windowIndex, _r, _ri);
};

window.RopeAreTexturesLoaded = function () {
	return _in(0xf2d0e6a7, 0x5cc05597, _r);
};

window.RopeConvertToSimple = function (rope) {
	return _in(0x5389d48e, 0xfa2f079a, rope);
};

window.RopeDrawShadowEnabled = function (toggle) {
	return _in(0xf159a638, 0x06bb5ba8, _i, toggle);
};

/**
 * Forces a rope to a certain length.
 */
window.RopeForceLength = function (rope, length) {
	return _in(0xd009f759, 0xa723db1b, rope, _fv(length), _r, _ri);
};

/**
 * Loads rope textures for all ropes in the current scene.
 */
window.RopeLoadTextures = function () {
	return _in(0x9b9039db, 0xf2d258c1, _r, _ri);
};

/**
 * Reset a rope to a certain length.
 */
window.RopeResetLength = function (rope, length) {
	return _in(0xc16de94d, 0x9bea14a0, rope, _fv(length));
};

window.RopeSetUpdatePinverts = function (rope) {
	return _in(0xc8d667ee, 0x52114aba, rope);
};

/**
 * Unloads rope textures for all ropes in the current scene.
 */
window.RopeUnloadTextures = function () {
	return _in(0x6ce36c35, 0xc1ac8163, _r, _ri);
};

window.Round = function (value) {
	return _in(0xf2db717a, 0x73826179, _fv(value), _r, _ri);
};

window.ScEmailMessageClearRecipList = function () {
	return _in(0x55df6db4, 0x5179236e);
};
window.N_0x55df6db45179236e = window.ScEmailMessageClearRecipList;

window.ScEmailMessagePushGamerToRecipList = function (player) {
	return _in(0x2330c12a, 0x7a605d16, _ii(player) /* may be optional */);
};

/**
 * Returns the status of a _SC_START_CHECK_STRING_TASK task.
 * Possible return values:
 * 0: not a profane string
 * 1: a profane string
 * 3: server error occurred
 */
window.ScGetCheckStringStatus = function (taskHandle) {
	return _in(0x82e4a58b, 0xabc15ae7, taskHandle, _r, _ri);
};
window.N_0x82e4a58babc15ae7 = window.ScGetCheckStringStatus;

/**
 * Returns the nickname of the logged-in Rockstar Social Club account.
 */
window.ScGetNickname = function () {
	return _in(0x198d161f, 0x458ecc7f, _r, _ri);
};

/**
 * Returns whether or not a task started with _SC_START_CHECK_STRING_TASK has completed.
 */
window.ScHasCheckStringTaskCompleted = function (taskHandle) {
	return _in(0x1753344c, 0x770358ae, taskHandle, _r);
};
window.N_0x1753344c770358ae = window.ScHasCheckStringTaskCompleted;

window.ScInboxGetEmails = function (offset, limit) {
	return _in(0x040addcb, 0xafa1018a, offset, limit);
};
window.N_0x040addcbafa1018a = window.ScInboxGetEmails;

window.ScInboxMessageGetDataBool = function (p0, p1) {
	return _in(0xffe5c16f, 0x402d851d, p0, _ts(p1), _r);
};
window.N_0xffe5c16f402d851d = window.ScInboxMessageGetDataBool;

window.ScInboxMessageGetDataInt = function (p0, context, out) {
	return _in(0xa00efe40, 0x82c4056e, p0, _ts(context), _ii(out) /* may be optional */, _r);
};

window.ScInboxMessageGetDataString = function (p0, context, out) {
	return _in(0x7572ef42, 0xfc6a9b6d, p0, _ts(context), _ts(out), _r);
};

window.ScInboxMessageGetString = function (p0) {
	return _in(0xf3e31d16, 0xcbdcb304, p0, _r, _s);
};
window.N_0xf3e31d16cbdcb304 = window.ScInboxMessageGetString;

window.ScInboxMessageGetUgcdata = function (p0, p1) {
	return _in(0x69d82604, 0xa1a5a254, p0, _ii(p1) /* may be optional */, _r);
};

window.ScInboxMessageInit = function (p0) {
	return _in(0xbb8ea16e, 0xcbc976c4, p0, _r, _ri);
};
window.N_0xbb8ea16ecbc976c4 = window.ScInboxMessageInit;

window.ScInboxMessagePop = function (p0) {
	return _in(0x2c015348, 0xcf19ca1d, p0, _r);
};
window.N_0x2c015348cf19ca1d = window.ScInboxMessagePop;

window.ScInboxMessagePush = function (p0) {
	return _in(0x9a2c8064, 0xb6c1e41a, p0, _r);
};
window.N_0x9a2c8064b6c1e41a = window.ScInboxMessagePush;

/**
 * Starts a task to check an entered string for profanity on the ROS/Social Club services.
 * See also: 1753344C770358AE, 82E4A58BABC15AE7.
 */
window.ScStartCheckStringTask = function (string, taskHandle) {
	return _in(0x75632c5e, 0xcd7ed843, _ts(string), _ii(taskHandle) /* may be optional */, _r);
};
window.N_0x75632c5ecd7ed843 = window.ScStartCheckStringTask;

/**
 * Pushes a boolean for the Scaleform function onto the stack.
 */
window.ScaleformMovieMethodAddParamBool = function (value) {
	return _in(0xc58424ba, 0x936eb458, value);
};
window.PushScaleformMovieFunctionParameterBool = window.ScaleformMovieMethodAddParamBool;
window.PushScaleformMovieMethodParameterBool = window.ScaleformMovieMethodAddParamBool;

/**
 * Pushes a float for the Scaleform function onto the stack.
 */
window.ScaleformMovieMethodAddParamFloat = function (value) {
	return _in(0xd69736aa, 0xe04db51a, _fv(value));
};
window.PushScaleformMovieFunctionParameterFloat = window.ScaleformMovieMethodAddParamFloat;
window.PushScaleformMovieMethodParameterFloat = window.ScaleformMovieMethodAddParamFloat;

/**
 * Pushes an integer for the Scaleform function onto the stack.
 */
window.ScaleformMovieMethodAddParamInt = function (value) {
	return _in(0xc3d0841a, 0x0cc546a6, value);
};
window.PushScaleformMovieFunctionParameterInt = window.ScaleformMovieMethodAddParamInt;
window.PushScaleformMovieMethodParameterInt = window.ScaleformMovieMethodAddParamInt;

/**
 * If bool Toggle = true so the mobile is hide to screen.
 * If bool Toggle = false so the mobile is show to screen.
 */
window.ScriptIsMovingMobilePhoneOffscreen = function (toggle) {
	return _in(0xf511f759, 0x238a5122, toggle);
};

/**
 * Sends a message to the specific DUI root page. This is similar to SEND_NUI_MESSAGE.
 * @param duiObject The DUI browser handle.
 * @param jsonString The message, encoded as JSON.
 */
window.SendDuiMessage = function (duiObject, jsonString) {
	return _in(0x00000000, 0xcd380da9, duiObject, _ts(jsonString));
};

/**
 * Injects a 'mouse down' event for a DUI object. Coordinates are expected to be set using SEND_DUI_MOUSE_MOVE.
 * @param duiObject The DUI browser handle.
 * @param button Either `'left'`, `'middle'` or `'right'`.
 */
window.SendDuiMouseDown = function (duiObject, button) {
	return _in(0x00000000, 0x5d01f191, duiObject, _ts(button));
};

/**
 * Injects a 'mouse move' event for a DUI object. Coordinates are in browser space.
 * @param duiObject The DUI browser handle.
 * @param x The mouse X position.
 * @param y The mouse Y position.
 */
window.SendDuiMouseMove = function (duiObject, x, y) {
	return _in(0x00000000, 0xd9d7a0aa, duiObject, x, y);
};

/**
 * Injects a 'mouse up' event for a DUI object. Coordinates are expected to be set using SEND_DUI_MOUSE_MOVE.
 * @param duiObject The DUI browser handle.
 * @param button Either `'left'`, `'middle'` or `'right'`.
 */
window.SendDuiMouseUp = function (duiObject, button) {
	return _in(0x00000000, 0x1d735b93, duiObject, _ts(button));
};

/**
 * Injects a 'mouse wheel' event for a DUI object.
 * @param duiObject The DUI browser handle.
 * @param deltaY The wheel Y delta.
 * @param deltaX The wheel X delta.
 */
window.SendDuiMouseWheel = function (duiObject, deltaY, deltaX) {
	return _in(0x00000000, 0x2d62133a, duiObject, deltaY, deltaX);
};

/**
 * Sends a message to the `loadingScreen` NUI frame, which contains the HTML page referenced in `loadscreen` resources.
 * @param jsonString The JSON-encoded message.
 * @return A success value.
 */
window.SendLoadingScreenMessage = function (jsonString) {
	return _in(0x00000000, 0x8bbe6cc0, _ts(jsonString), _r);
};

window.SendNuiMessage = function (jsonString) {
	return _in(0x00000000, 0x78608acb, _ts(jsonString), _r);
};

/**
 * If 'value' is 50 and 'maxValue' is 100, the bar is halfway filled.
 * Same with 5/10, 2/4, etc.
 */
window.SetAbilityBarValue = function (value, maxValue) {
	return _in(0x9969599c, 0xcff5d85e, _fv(value), _fv(maxValue));
};

/**
 * This seems to be related to Steam achievements.
 * p0 and p1 are int (?)
 * ------
 * Can't say anything about the Steam version but it is hardcoded to always return false in the retail version.
 * Dr. Underscore (1/6/18):
 * This has to do with achievement progression. If this achievement has progression, it will set the progression of it to this value.
 * Only tested on un-achieved achievements, Steamworks probably just rejects it if it has already been achieved.
 * Steamworks also seems to not like reversing achievement progression.
 */
window.SetAchievementProgression = function (achId, progression) {
	return _in(0xc2afffda, 0xbbdc2c5c, achId, progression, _r);
};
window.N_0xc2afffdabbdc2c5c = window.SetAchievementProgression;

window.SetActivateObjectPhysicsAsSoonAsItIsUnfrozen = function (object, toggle) {
	return _in(0x406137f8, 0xef90eaf5, object, toggle);
};

/**
 * Makes pedestrians sound their horn longer, faster and more agressive when they use their horn.
 */
window.SetAggressiveHorns = function (toggle) {
	return _in(0x395bf710, 0x85d1b1d9, toggle);
};

/**
 * Previously named _0x97C65887D4B37FA9.
 * Sets the maximum view distance for the AI BIP
 */
window.SetAiBlipMaxDistance = function (ped, distance) {
	return _in(0x97c65887, 0xd4b37fa9, ped, _fv(distance));
};
window.N_0x97c65887d4b37fa9 = window.SetAiBlipMaxDistance;

/**
 * Set a ped's AI blip type:
 * 1 - Yellow blip with no name
 * 2
 */
window.SetAiBlipType = function (ped, type) {
	return _in(0xe52b8e7f, 0x85d39a08, ped, type);
};
window.N_0xe52b8e7f85d39a08 = window.SetAiBlipType;

window.SetAiMeleeWeaponDamageModifier = function (modifier) {
	return _in(0x66460ded, 0xdd417254, _fv(modifier));
};

window.SetAiWeaponDamageModifier = function (value) {
	return _in(0x1b1e2a40, 0xa65b8521, _fv(value));
};

/**
 * This can be between 1.0f - 14.9f
 * You can change the max in IDA from 15.0. I say 15.0 as the function blrs if what you input is greater than or equal to 15.0 hence why it's 14.9 max default.
 * On PC the multiplier can be between 0.0f and 50.0f (inclusive).
 */
window.SetAirDragMultiplierForPlayersVehicle = function (player, multiplier) {
	return _in(0xca7dc832, 0x9f0a1e9e, player, _fv(multiplier));
};

/**
 * Sets the amount of bombs that this vehicle has. As far as I know, this does _not_ impact vehicle weapons or the ammo of those weapons in any way, it is just a way to keep track of the amount of bombs in a specific plane.
 * In decompiled scripts this is used to deduct from or add to the count whenever bombs are dropped or purchased/restocked.
 * Use [`_GET_AIRCRAFT_BOMB_COUNT`](#_0xEA12BD130D7569A1) to get the amount of bombs on that vehicle.
 * @param aircraft The vehicle to set the bombCount on.
 * @param bombCount The amount of bombs to set for this vehicle.
 */
window.SetAircraftBombCount = function (aircraft, bombCount) {
	return _in(0xf4b2ed59, 0xdeb5d774, aircraft, bombCount);
};
window.N_0xf4b2ed59deb5d774 = window.SetAircraftBombCount;
window.SetVehicleBombs = window.SetAircraftBombCount;

/**
 * Similar to [`_SET_AIRCRAFT_BOMB_COUNT`](#_0xF4B2ED59DEB5D774), this sets the amount of countermeasures that are present on this vehicle.
 * Use [`_GET_AIRCRAFT_COUNTERMEASURE_COUNT`](#_0xF846AA63DF56B804) to get the current amount.
 * @param aircraft The vehicle to set the amount of countermeasures on.
 * @param count The amount of countermeasures to set on this vehicle.
 */
window.SetAircraftCountermeasureCount = function (aircraft, count) {
	return _in(0x9bda23bf, 0x666f0855, aircraft, count);
};
window.N_0x9bda23bf666f0855 = window.SetAircraftCountermeasureCount;

window.SetAllLowPriorityVehicleGeneratorsActive = function (active) {
	return _in(0x608207e7, 0xa8fb787c, active);
};

window.SetAllRandomPedsFlee = function (player, toggle) {
	return _in(0x056e0fe8, 0x534c2949, player, toggle);
};

window.SetAllRandomPedsFleeThisFrame = function (player) {
	return _in(0x471d2ff4, 0x2a94b4f2, player);
};

window.SetAllVehicleGeneratorsActive = function () {
	return _in(0x34ad8907, 0x8831a4bc);
};

window.SetAllVehicleGeneratorsActiveInArea = function (x1, y1, z1, x2, y2, z2, p6, p7) {
	return _in(0xc1232182, 0x7687fe4d, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), p6, p7);
};

/**
 * Most likely a hash collision
 */
window.SetAllVehiclesSpawn = function (p0, p1, p2, p3) {
	return _in(0xe023e8ac, 0x4ef7c117, p0, p1, p2, p3, _r, _ri);
};

/**
 * Audio List
 * gtaforums.com/topic/795622-audio-for-mods/
 * All found occurrences in b617d, sorted alphabetically and identical lines removed: pastebin.com/FTeAj4yZ
 * Yes
 */
window.SetAmbientVoiceName = function (ped, name) {
	return _in(0x6c8065a3, 0xb780185b, ped, _ts(name));
};

window.SetAmbientZoneListState = function (p0, p1, p2) {
	return _in(0x9748fa4d, 0xe50cce3e, _ts(p0), p1, p2);
};

/**
 * All occurrences found in b617d, sorted alphabetically and identical lines removed: pastebin.com/WkXDGgQL
 * New Ambient Zone List (Combind with old): pastebin.com/h8BsKgUD -DasChaos
 */
window.SetAmbientZoneListStatePersistent = function (ambientZone, p1, p2) {
	return _in(0xf3638dae, 0x8c4045e1, _ts(ambientZone), p1, p2);
};

window.SetAmbientZoneState = function (p1, p2) {
	return _in(0xbda07e59, 0x50085e46, _i, p1, p2);
};

/**
 * All occurrences found in b617d, sorted alphabetically and identical lines removed: pastebin.com/jYvw7N1S
 * New Ambient Zone List (Combind with old): pastebin.com/h8BsKgUD -DasChaos
 */
window.SetAmbientZoneStatePersistent = function (ambientZone, p1, p2) {
	return _in(0x1d665042, 0x0cec9d3b, _ts(ambientZone), p1, p2);
};

window.SetAmmoInClip = function (ped, weaponHash, ammo) {
	return _in(0xdcd2a934, 0xd65cb497, ped, _ch(weaponHash), ammo, _r);
};

window.SetAnimLooped = function (p0, p1, p2, p3) {
	return _in(0x70033c3c, 0xc29a1ff4, p0, p1, p2, p3);
};

window.SetAnimRate = function (p0, p1, p2, p3) {
	return _in(0x032d49c5, 0xe359c847, p0, _fv(p1), p2, p3);
};

window.SetAnimWeight = function (p0, p1, p2, p3, p4) {
	return _in(0x207f1a47, 0xc0342f48, p0, _fv(p1), p2, p3, p4);
};

/**
 * mood can be 0 or 1 (it's not a boolean value!). Effects audio of the animal.
 */
window.SetAnimalMood = function (animal, mood) {
	return _in(0xcc97b292, 0x85b1dc3b, animal, mood);
};

/**
 * Does not affect weapons, particles, fire/explosions, flashlights or the sun.
 * When set to true, all emissive textures (including ped components that have light effects), street lights, building lights, vehicle lights, etc will all be turned off.
 * Used in Humane Labs Heist for EMP.
 * @param state True turns off all artificial light sources in the map: buildings, street lights, car lights, etc. False turns them back on.
 */
window.SetArtificialLightsState = function (state) {
	return _in(0x1268615a, 0xce24d504, state);
};
window.SetBlackout = window.SetArtificialLightsState;

/**
 * Possible flag names:
 * "ActivateSwitchWheelAudio"
 * "AllowAmbientSpeechInSlowMo"
 * "AllowCutsceneOverScreenFade"
 * "AllowForceRadioAfterRetune"
 * "AllowPainAndAmbientSpeechToPlayDuringCutscene"
 * "AllowPlayerAIOnMission"
 * "AllowPoliceScannerWhenPlayerHasNoControl"
 * "AllowRadioDuringSwitch"
 * "AllowRadioOverScreenFade"
 * "AllowScoreAndRadio"
 * "AllowScriptedSpeechInSlowMo"
 * "AvoidMissionCompleteDelay"
 * "DisableAbortConversationForDeathAndInjury"
 * "DisableAbortConversationForRagdoll"
 * "DisableBarks"
 * "DisableFlightMusic"
 * "DisableReplayScriptStreamRecording"
 * "EnableHeadsetBeep"
 * "ForceConversationInterrupt"
 * "ForceSeamlessRadioSwitch"
 * "ForceSniperAudio"
 * "FrontendRadioDisabled"
 * "HoldMissionCompleteWhenPrepared"
 * "IsDirectorModeActive"
 * "IsPlayerOnMissionForSpeech"
 * "ListenerReverbDisabled"
 * "LoadMPData"
 * "MobileRadioInGame"
 * "OnlyAllowScriptTriggerPoliceScanner"
 * "PlayMenuMusic"
 * "PoliceScannerDisabled"
 * "ScriptedConvListenerMaySpeak"
 * "SpeechDucksScore"
 * "SuppressPlayerScubaBreathing"
 * "WantedMusicDisabled"
 * "WantedMusicOnMission"
 * -------------------------------
 * No added flag names between b393d and b573d, including b573d.
 * #######################################################################
 * "IsDirectorModeActive" is an audio flag which will allow you to play speech infinitely without any pauses like in Director Mode.
 * -----------------------------------------------------------------------
 * All flag IDs and hashes:
 * ID: 01 | Hash: 0x20A7858F
 * ID: 02 | Hash: 0xA11C2259
 * ID: 03 | Hash: 0x08DE4700
 * ID: 04 | Hash: 0x989F652F
 * ID: 05 | Hash: 0x3C9E76BA
 * ID: 06 | Hash: 0xA805FEB0
 * ID: 07 | Hash: 0x4B94EA26
 * ID: 08 | Hash: 0x803ACD34
 * ID: 09 | Hash: 0x7C741226
 * ID: 10 | Hash: 0x31DB9EBD
 * ID: 11 | Hash: 0xDF386F18
 * ID: 12 | Hash: 0x669CED42
 * ID: 13 | Hash: 0x51F22743
 * ID: 14 | Hash: 0x2052B35C
 * ID: 15 | Hash: 0x071472DC
 * ID: 16 | Hash: 0xF9928BCC
 * ID: 17 | Hash: 0x7ADBDD48
 * ID: 18 | Hash: 0xA959BA1A
 * ID: 19 | Hash: 0xBBE89B60
 * ID: 20 | Hash: 0x87A08871
 * ID: 21 | Hash: 0xED1057CE
 * ID: 22 | Hash: 0x1584AD7A
 * ID: 23 | Hash: 0x8582CFCB
 * ID: 24 | Hash: 0x7E5E2FB0
 * ID: 25 | Hash: 0xAE4F72DB
 * ID: 26 | Hash: 0x5D16D1FA
 * ID: 27 | Hash: 0x06B2F4B8
 * ID: 28 | Hash: 0x5D4CDC96
 * ID: 29 | Hash: 0x8B5A48BA
 * ID: 30 | Hash: 0x98FBD539
 * ID: 31 | Hash: 0xD8CB0473
 * ID: 32 | Hash: 0x5CBB4874
 * ID: 33 | Hash: 0x2E9F93A9
 * ID: 34 | Hash: 0xD93BEA86
 * ID: 35 | Hash: 0x92109B7D
 * ID: 36 | Hash: 0xB7EC9E4D
 * ID: 37 | Hash: 0xCABDBB1D
 * ID: 38 | Hash: 0xB3FD4A52
 * ID: 39 | Hash: 0x370D94E5
 * ID: 40 | Hash: 0xA0F7938F
 * ID: 41 | Hash: 0xCBE1CE81
 * ID: 42 | Hash: 0xC27F1271
 * ID: 43 | Hash: 0x9E3258EB
 * ID: 44 | Hash: 0x551CDA5B
 * ID: 45 | Hash: 0xCB6D663C
 * ID: 46 | Hash: 0x7DACE87F
 * ID: 47 | Hash: 0xF9DE416F
 * ID: 48 | Hash: 0x882E6E9E
 * ID: 49 | Hash: 0x16B447E7
 * ID: 50 | Hash: 0xBD867739
 * ID: 51 | Hash: 0xA3A58604
 * ID: 52 | Hash: 0x7E046BBC
 * ID: 53 | Hash: 0xD95FDB98
 * ID: 54 | Hash: 0x5842C0ED
 * ID: 55 | Hash: 0x285FECC6
 * ID: 56 | Hash: 0x9351AC43
 * ID: 57 | Hash: 0x50032E75
 * ID: 58 | Hash: 0xAE6D0D59
 * ID: 59 | Hash: 0xD6351785
 * ID: 60 | Hash: 0xD25D71BC
 * ID: 61 | Hash: 0x1F7F6423
 * ID: 62 | Hash: 0xE24C3AA6
 * ID: 63 | Hash: 0xBFFDD2B7
 */
window.SetAudioFlag = function (flagName, toggle) {
	return _in(0xb9efd5c2, 0x5018725a, _ts(flagName), toggle);
};

window.SetAudioSceneVariable = function (scene, variable, value) {
	return _in(0xef21a9ef, 0x089a2668, _ts(scene), _ts(variable), _fv(value));
};

window.SetAudioVehiclePriority = function (vehicle, p1) {
	return _in(0xe5564483, 0xe407f914, vehicle, p1);
};

window.SetAutoGiveParachuteWhenEnterPlane = function (player, toggle) {
	return _in(0x9f343285, 0xa00b4bb6, player, toggle);
};

window.SetBalanceAddMachine = function () {
	return _in(0x815e5e30, 0x73da1d67, _i, _i, _r);
};

window.SetBalanceAddMachines = function (p1) {
	return _in(0xb8322eeb, 0x38be7c26, _i, p1, _i, _r);
};

/**
 * Toggles the big minimap state like in GTA:Online.
 * To get the current state of the minimap, use [`GetBigmapActive`](#_0xF6AE18A7).
 * @param toggleBigMap Enable or disable the expanded minimap.
 * @param showFullMap Enable or disable the full map from being shown on the minimap, requires p0 to be true.
 */
window.SetBigmapActive = function (toggleBigMap, showFullMap) {
	return _in(0x231c8f89, 0xd0539d8f, toggleBigMap, showFullMap);
};
window.SetRadarBigmapEnabled = window.SetBigmapActive;

/**
 * Only works on bikes, both X and Y work in the -1 - 1 range.
 * X forces the bike to turn left or right (-1, 1)
 * Y forces the bike to lean to the left or to the right (-1, 1)
 * Example with X -1/Y 1
 * http://i.imgur.com/TgIuAPJ.jpg
 */
window.SetBikeLeanAngle = function (vehicle, x, y) {
	return _in(0x9cfa4896, 0xc3a53cbb, vehicle, _fv(x), _fv(y));
};

/**
 * This sets bit [offset] of [address] to on.
 * The offsets used are different bits to be toggled on and off, typically there is only one address used in a script.
 * Example:
 * GAMEPLAY::SET_BIT(&bitAddress, 1);
 * To check if this bit has been enabled:
 * GAMEPLAY::IS_BIT_SET(bitAddress, 1); // will return 1 afterwards
 * Please note, this method may assign a value to [address] when used.
 */
window.SetBit = function (offset) {
	return _in(0x933d6a9e, 0xec1bacd0, _i, offset);
};

window.SetBitsInRange = function (rangeStart, rangeEnd, p3) {
	return _in(0x8ef07e15, 0x701d61ed, _i, rangeStart, rangeEnd, p3);
};

/**
 * Sets alpha-channel for blip color.
 * Example:
 * Blip blip = UI::ADD_BLIP_FOR_ENTITY(entity);
 * UI::SET_BLIP_COLOUR(blip , 3);
 * UI::SET_BLIP_ALPHA(blip , 64);
 */
window.SetBlipAlpha = function (blip, alpha) {
	return _in(0x45ff974e, 0xee1c8734, blip, alpha);
};

/**
 * false for enemy
 * true for friendly
 */
window.SetBlipAsFriendly = function (blip, toggle) {
	return _in(0x6f6f2901, 0x02c02ab4, blip, toggle);
};

window.SetBlipAsMissionCreatorBlip = function (blip, toggle) {
	return _in(0x24ac0137, 0x444f9fd5, blip, toggle);
};

/**
 * Sets whether or not the specified blip should only be displayed when nearby, or on the minimap.
 * @param blip The blip handle.
 * @param toggle True to only display the blip as 'short range', false to display the blip from a longer distance.
 */
window.SetBlipAsShortRange = function (blip, toggle) {
	return _in(0xbe8be4fe, 0x60e27b72, blip, toggle);
};

window.SetBlipBright = function (blip, toggle) {
	return _in(0xb2039137, 0x33f27884, blip, toggle);
};

/**
 * int index:
 * 1 = No Text on blip or Distance
 * 2 = Text on blip
 * 3 = No text, just distance
 * 4+ No Text on blip or distance
 */
window.SetBlipCategory = function (blip, index) {
	return _in(0x234cdd44, 0xd996fd9a, blip, index);
};

/**
 * (Hex code are approximate)
 * 0: White (#fefefe)
 * 1: Red (#e03232)
 * 2: Green (#71cb71)
 * 3: Blue (#5db6e5)
 * 4: White (#fefefe)
 * 5: Taxi Yellow (#eec64e)
 * 6: Light Red (#c25050)
 * 7: Violet (#9c6eaf)
 * 8: Pink (#fe7ac3)
 * 9: Light Orange (#f59d79)
 * 10: Light Brown (#b18f83)
 * 11: Light Green (#8dcea7)
 * 12: Light Blue (Teal) (#70a8ae)
 * 13: Very Light Purple (#d3d1e7)
 * 14: Dark Purple (#8f7e98)
 * 15: Cyan (#6ac4bf)
 * 16: Light Yellow (#d5c398)
 * 17: Orange (#ea8e50)
 * 18: Light Blue (#97cae9)
 * 19: Dark Pink (#b26287)
 * 20: Dark Yellow (#8f8d79)
 * 21: Dark Orange (#a6755e)
 * 22: Light Gray (#afa8a8)
 * 23: Light Pink (#e78d9a)
 * 24: Lemon Green (#bbd65b)
 * 25: Forest Green (#0c7b56)
 * 26: Electric Blue (#7ac3fe)
 * 27: Bright Purple (#ab3ce6)
 * 28: Dark Taxi Yellow (#cda80c)
 * 29: Dark Blue (#4561ab)
 * 30: Dark Cyan (#29a5b8)
 * 31: Light Brown (#b89b7b)
 * 32: Very Light Blue (#c8e0fe)
 * 33: Light Yellow (#f0f096)
 * 34: Light Pink (#ed8ca1)
 * 35: Light Red (#f98a8a)
 * 36: Light Yellow (#fbeea5)
 * 37: White (#fefefe)
 * 38: Blue (#2c6db8)
 * 39: Light Gray (#9a9a9a)
 * 40: Dark Gray (#4c4c4c)
 * Certainly a lot more remaining.
 */
window.SetBlipColour = function (blip, color) {
	return _in(0x03d7fb09, 0xe75d6b7e, blip, color);
};

window.SetBlipCoords = function (blip, posX, posY, posZ) {
	return _in(0xae2af67e, 0x9d9af65d, blip, _fv(posX), _fv(posY), _fv(posZ));
};

/**
 * **displayId Behaviour** <br>
 * 0 = Doesn't show up, ever, anywhere. <br>
 * 1 = Doesn't show up, ever, anywhere. <br>
 * 2 = Shows on both main map and minimap. (Selectable on map) <br>
 * 3 = Shows on main map only. (Selectable on map) <br>
 * 4 = Shows on main map only. (Selectable on map) <br>
 * 5 = Shows on minimap only. <br>
 * 6 = Shows on both main map and minimap. (Selectable on map) <br>
 * 7 = Doesn't show up, ever, anywhere. <br>
 * 8 = Shows on both main map and minimap. (Not selectable on map) <br>
 * 9 = Shows on minimap only. <br>
 * 10 = Shows on both main map and minimap. (Not selectable on map) <br>
 * Anything higher than 10 seems to be exactly the same as 10. <br>
 * <br>
 * Rockstar seem to only use 0, 2, 3, 4, 5 and 8 in the decompiled scripts.
 */
window.SetBlipDisplay = function (blip, displayId) {
	return _in(0x9029b2f3, 0xda924928, blip, displayId);
};

window.SetBlipFade = function (blip, opacity, duration) {
	return _in(0x2aee8f83, 0x90d2298c, blip, opacity, duration);
};

window.SetBlipFlashInterval = function (blip, p1) {
	return _in(0xaa51db31, 0x3c010a7e, blip, p1);
};

/**
 * Adds up after viewing multiple R* scripts. I believe that the duration is in miliseconds.
 */
window.SetBlipFlashTimer = function (blip, duration) {
	return _in(0xd3cd6fd2, 0x97ae87cc, blip, duration);
};

window.SetBlipFlashes = function (blip, toggle) {
	return _in(0xb1455238, 0x3d39ce3e, blip, toggle);
};

window.SetBlipFlashesAlternate = function (blip, toggle) {
	return _in(0x2e8d9498, 0xc56dd0d1, blip, toggle);
};

window.SetBlipHighDetail = function (blip, toggle) {
	return _in(0xe2590bc2, 0x9220cebb, blip, toggle);
};

/**
 * Doesn't work if the label text of gxtEntry is >= 80.
 */
window.SetBlipNameFromTextFile = function (blip, gxtEntry) {
	return _in(0xeaa0ffe1, 0x20d92784, blip, _ts(gxtEntry));
};

window.SetBlipNameToPlayerName = function (blip, player) {
	return _in(0x127de7b2, 0x0c60a6a3, blip, player);
};

/**
 * See this topic for more details : gtaforums.com/topic/717612-v-scriptnative-documentation-and-research/page-35?p=1069477935
 */
window.SetBlipPriority = function (blip, priority) {
	return _in(0xae9fc9ef, 0x6a9fac79, blip, priority);
};

/**
 * After some testing, looks like you need to use UI:CEIL() on the rotation (vehicle/ped heading) before using it there.
 */
window.SetBlipRotation = function (blip, rotation) {
	return _in(0xf87683cd, 0xf73c3f6e, blip, rotation);
};

/**
 * Enable / disable showing route for the Blip-object.
 */
window.SetBlipRoute = function (blip, enabled) {
	return _in(0x4f7d8a9b, 0xfb0b43e9, blip, enabled);
};

window.SetBlipRouteColour = function (blip, colour) {
	return _in(0x837155cd, 0x2f63da09, blip, colour);
};

window.SetBlipScale = function (blip, scale) {
	return _in(0xd3874416, 0x7b2fa257, blip, _fv(scale));
};

window.SetBlipSecondaryColour = function (blip, r, g, b) {
	return _in(0x14892474, 0x891e09eb, blip, _fv(r), _fv(g), _fv(b));
};

window.SetBlipShowCone = function (blip, toggle) {
	return _in(0x13127ec3, 0x665e8ee1, blip, toggle);
};

/**
 * Makes a blip go small when off the minimap.
 */
window.SetBlipShrink = function (blip, toggle) {
	return _in(0x2b6d467d, 0xab714e8d, blip, toggle);
};
window.N_0x2b6d467dab714e8d = window.SetBlipShrink;

/**
 * <!--
 * _loc1_.map((name, idx) => `| ${idx} | ${name} | ![${name}](https://runtime.fivem.net/blips/${name}.svg) |`).join('\n')
 * -->
 * Sets the displayed sprite for a specific blip.
 * There's a [list of sprites](https://docs.fivem.net/game-references/blips/) on the FiveM documentation site.
 * @param blip The blip to change.
 * @param spriteId The sprite ID to set.
 */
window.SetBlipSprite = function (blip, spriteId) {
	return _in(0xdf735600, 0xa4696daf, blip, spriteId);
};

/**
 * works with AI::TASK_SET_BLOCKING_OF_NON_TEMPORARY_EVENTS to make a ped completely oblivious to all events going on around him
 */
window.SetBlockingOfNonTemporaryEvents = function (ped, toggle) {
	return _in(0x9f8aa94d, 0x6d97dbf4, ped, toggle);
};

window.SetBoatAnchor = function (vehicle, toggle) {
	return _in(0x75dbec17, 0x4aeead10, vehicle, toggle);
};

/**
 * Set camera as active/inactive.
 */
window.SetCamActive = function (cam, active) {
	return _in(0x026fb97d, 0x0a425f84, cam, active);
};

/**
 * Previous declaration void SET_CAM_ACTIVE_WITH_INTERP(Cam camTo, Cam camFrom, int duration, BOOL easeLocation, BOOL easeRotation) is completely wrong. The last two params are integers not BOOLs...
 */
window.SetCamActiveWithInterp = function (camTo, camFrom, duration, easeLocation, easeRotation) {
	return _in(0x9fbda379, 0x383a52a4, camTo, camFrom, duration, easeLocation, easeRotation);
};

/**
 * Allows you to aim and shoot at the direction the camera is facing.
 */
window.SetCamAffectsAiming = function (cam, toggle) {
	return _in(0x8c1dc777, 0x0c51dc8d, cam, toggle);
};

window.SetCamAnimCurrentPhase = function (cam, phase) {
	return _in(0x4145a4c4, 0x4ff3b5a6, cam, _fv(phase));
};

/**
 * Sets the position of the cam.
 */
window.SetCamCoord = function (cam, posX, posY, posZ) {
	return _in(0x4d41783f, 0xb745e42e, cam, _fv(posX), _fv(posY), _fv(posZ));
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.SetCamDebugName = function (camera, name) {
	return _in(0x1b93e010, 0x7865dd40, camera, _ts(name));
};

/**
 * This native has its name defined inside its codE
 */
window.SetCamDofFnumberOfLens = function (camera, p1) {
	return _in(0x7dd234d6, 0xf3914c5b, camera, _fv(p1));
};
window.N_0x7dd234d6f3914c5b = window.SetCamDofFnumberOfLens;

/**
 * This native has a name defined inside its code
 */
window.SetCamDofFocusDistanceBias = function (camera, p1) {
	return _in(0xc669eea5, 0xd031b7de, camera, _fv(p1));
};
window.N_0xc669eea5d031b7de = window.SetCamDofFocusDistanceBias;

/**
 * This native has a name defined inside its code
 */
window.SetCamDofMaxNearInFocusDistance = function (camera, p1) {
	return _in(0xc3654a44, 0x1402562d, camera, _fv(p1));
};
window.N_0xc3654a441402562d = window.SetCamDofMaxNearInFocusDistance;

/**
 * This native has a name defined inside its code
 */
window.SetCamDofMaxNearInFocusDistanceBlendLevel = function (camera, p1) {
	return _in(0x2c654b49, 0x43bddf7c, camera, _fv(p1));
};
window.N_0x2c654b4943bddf7c = window.SetCamDofMaxNearInFocusDistanceBlendLevel;

window.SetCamDofPlanes = function (cam, p1, p2, p3, p4) {
	return _in(0x3cf48f6f, 0x96e749dc, cam, _fv(p1), _fv(p2), _fv(p3), _fv(p4));
};

window.SetCamDofStrength = function (cam, dofStrength) {
	return _in(0x5ee29b4d, 0x7d5df897, cam, _fv(dofStrength));
};

/**
 * if p0 is 0, effect is cancelled
 * if p0 is 1, effect zooms in, gradually tilts cam clockwise apx 30 degrees, wobbles slowly. Motion blur is active until cancelled.
 * if p0 is 2, effect immediately tilts cam clockwise apx 30 degrees, begins to wobble slowly, then gradually tilts cam back to normal. The wobbling will continue until the effect is cancelled.
 */
window.SetCamEffect = function (p0) {
	return _in(0x80c8b184, 0x6639bb19, p0);
};

window.SetCamFarClip = function (cam, farClip) {
	return _in(0xae306f2a, 0x904bf86e, cam, _fv(farClip));
};

window.SetCamFarDof = function (cam, farDOF) {
	return _in(0xedd91296, 0xcd01aee0, cam, _fv(farDOF));
};

/**
 * Sets the field of view of the cam.
 * ---------------------------------------------
 * Min: 1.0f
 * Max: 130.0f
 */
window.SetCamFov = function (cam, fieldOfView) {
	return _in(0xb13c14f6, 0x6a00d047, cam, _fv(fieldOfView));
};

/**
 * The native seems to only be called once.
 * The native is used as so,
 * CAM::SET_CAM_INHERIT_ROLL_VEHICLE(l_544, getElem(2, &l_525, 4));
 * In the exile1 script.
 */
window.SetCamInheritRollVehicle = function (cam, p1) {
	return _in(0x45f1de9c, 0x34b93ae6, cam, p1);
};

window.SetCamMotionBlurStrength = function (cam, strength) {
	return _in(0x6f0f77fb, 0xa9a8f2e6, cam, _fv(strength));
};

window.SetCamNearClip = function (cam, nearClip) {
	return _in(0xc7848efc, 0xcc545182, cam, _fv(nearClip));
};

window.SetCamNearDof = function (cam, nearDOF) {
	return _in(0x3fa4bf0a, 0x7ab7de2c, cam, _fv(nearDOF));
};

window.SetCamParams = function (cam, posX, posY, posZ, rotX, rotY, rotZ, fieldOfView, p8, p9, p10, p11) {
	return _in(0xbfd8727a, 0xea3cceba, cam, _fv(posX), _fv(posY), _fv(posZ), _fv(rotX), _fv(rotY), _fv(rotZ), _fv(fieldOfView), p8, p9, p10, p11);
};

/**
 * Sets the rotation of the cam.
 * Last parameter unknown.
 * Last parameter seems to always be set to 2.
 */
window.SetCamRot = function (cam, rotX, rotY, rotZ, rotationOrder) {
	return _in(0x85973643, 0x155d0b07, cam, _fv(rotX), _fv(rotY), _fv(rotZ), rotationOrder);
};

window.SetCamShakeAmplitude = function (cam, amplitude) {
	return _in(0xd93db43b, 0x82bc0d00, cam, _fv(amplitude));
};

/**
 * I named p1 as timeDuration as it is obvious. I'm assuming tho it is ran in ms(Milliseconds) as usual.
 */
window.SetCamSplineDuration = function (cam, timeDuration) {
	return _in(0x1381539f, 0xee034cda, cam, timeDuration);
};

window.SetCamSplinePhase = function (cam, p1) {
	return _in(0x242b5874, 0xf0a4e052, cam, _fv(p1));
};

window.SetCamUseShallowDofMode = function (cam, toggle) {
	return _in(0x16a96863, 0xa17552bb, cam, toggle);
};

window.SetCameraRange = function (cam, range) {
	return _in(0xf9d02130, 0xecdd1d77, cam, _fv(range));
};
window.N_0xf9d02130ecdd1d77 = window.SetCameraRange;

/**
 * Setting ped to true allows the ped to shoot "friendlies".
 * p2 set to true when toggle is also true seams to make peds permanently unable to aim at, even if you set p2 back to false.
 * p1 = false & p2 = false for unable to aim at.
 * p1 = true & p2 = false for able to aim at.
 */
window.SetCanAttackFriendly = function (ped, toggle, p2) {
	return _in(0xb3b1cb34, 0x9ff9c75d, ped, toggle, p2);
};

/**
 * Hardcoded to not work in multiplayer.
 */
window.SetCanResprayVehicle = function (vehicle, state) {
	return _in(0x52bba29d, 0x5ec69356, vehicle, state);
};

/**
 * Something to do with "high speed bump severity"?
 * if (!sub_87a46("SET_CAR_HIGH_SPEED_BUMP_SEVERITY_MULTIPLIER")) {
 * VEHICLE::_84FD40F56075E816(0.0);
 * sub_8795b("SET_CAR_HIGH_SPEED_BUMP_SEVERITY_MULTIPLIER", 1);
 * }
 */
window.SetCarHighSpeedBumpSeverityMultiplier = function (multiplier) {
	return _in(0x84fd40f5, 0x6075e816, _fv(multiplier));
};
window.N_0x84fd40f56075e816 = window.SetCarHighSpeedBumpSeverityMultiplier;

/**
 * For now, I changed the last one from bool to int.
 * According to scripts specifically 'fm_mission_controller' this last parameter is 'false/0' when its called after the create rope native above is called for the magnet and 'true/1' after the create rope native above is called for the hook.
 */
window.SetCargobobHookPosition = function (cargobob, xOffset, yOffset, state) {
	return _in(0x877c1eae, 0xac531023, cargobob, _fv(xOffset), _fv(yOffset), state);
};
window.N_0x877c1eaeac531023 = window.SetCargobobHookPosition;

/**
 * Console Hash: 0xF57066DA
 * Won't attract or magnetize to any helicopters or planes of course, but that's common sense.
 */
window.SetCargobobPickupMagnetActive = function (cargobob, isActive) {
	return _in(0x9a665550, 0xf8da349b, cargobob, isActive);
};
window.CargobobMagnetGrabVehicle = window.SetCargobobPickupMagnetActive;

/**
 * console hash 0xCC3CF97D
 */
window.SetCargobobPickupMagnetStrength = function (cargobob, strength) {
	return _in(0xbcbfcd9d, 0x1dac19e2, cargobob, _fv(strength));
};
window.N_0xbcbfcd9d1dac19e2 = window.SetCargobobPickupMagnetStrength;

window.SetCgAtBoundcenter = function (rope) {
	return _in(0xbe520d97, 0x61ff811f, rope);
};

window.SetCgoffset = function (rope, x, y, z) {
	return _in(0xd8fa3908, 0xd7b86904, rope, _fv(x), _fv(y), _fv(z));
};

/**
 * Sets the cylinder height of the checkpoint.
 * Parameters:
 * * nearHeight - The height of the checkpoint when inside of the radius.
 * * farHeight - The height of the checkpoint when outside of the radius.
 * * radius - The radius of the checkpoint.
 */
window.SetCheckpointCylinderHeight = function (checkpoint, nearHeight, farHeight, radius) {
	return _in(0x2707aae9, 0xd9297d89, checkpoint, _fv(nearHeight), _fv(farHeight), _fv(radius));
};

/**
 * Sets the checkpoint icon color.
 */
window.SetCheckpointIconRgba = function (checkpoint, red, green, blue, alpha) {
	return _in(0xb9ea4090, 0x7c680580, checkpoint, red, green, blue, alpha);
};

/**
 * Sets the checkpoint color.
 */
window.SetCheckpointRgba = function (checkpoint, red, green, blue, alpha) {
	return _in(0x7167371e, 0x8ad747f7, checkpoint, red, green, blue, alpha);
};

/**
 * p0 - Scale? Looks to be a normalized value (0.0 - 1.0)
 * offroad_races.c4, line ~67407:
 * a_3._f7 = GRAPHICS::CREATE_CHECKPOINT(v_D, v_A, a_4, a_7, v_E, v_F, v_10, sub_62b2(v_A, 220, 255), 0);
 * UI::GET_HUD_COLOUR(134, &v_E, &v_F, &v_10, &v_11);
 * GRAPHICS::_SET_CHECKPOINT_ICON_RGBA(a_3._f7, v_E, v_F, v_10, sub_62b2(v_A, 70, 210));
 * GRAPHICS::_4B5B4DA5D79F1943(a_3._f7, 0.95);
 * GRAPHICS::SET_CHECKPOINT_CYLINDER_HEIGHT(a_3._f7, 4.0, 4.0, 100.0);
 */
window.SetCheckpointScale = function (checkpoint, p0) {
	return _in(0x4b5b4da5, 0xd79f1943, checkpoint, _fv(p0));
};
window.N_0x4b5b4da5d79f1943 = window.SetCheckpointScale;

window.SetCinematicButtonActive = function (p0) {
	return _in(0x51669f7d, 0x1fb53d9f, p0);
};

window.SetCinematicCamShakeAmplitude = function (p0) {
	return _in(0xc724c701, 0xc30b2fe7, _fv(p0));
};

/**
 * p0 = 0/1 or true/false
 * It doesn't seems to work
 */
window.SetCinematicModeActive = function (p0) {
	return _in(0xdcf0754a, 0xc3d6fd4e, p0);
};

window.SetClockDate = function (day, month, year) {
	return _in(0xb096419d, 0xf0d06ce7, day, month, year);
};

/**
 * SET_CLOCK_TIME(12, 34, 56);
 */
window.SetClockTime = function (hour, minute, second) {
	return _in(0x47c3b584, 0x8c3e45d8, hour, minute, second);
};

window.SetCloudHatOpacity = function (opacity) {
	return _in(0xf3619922, 0x5d6d8c86, _fv(opacity));
};
window.N_0xf36199225d6d8c86 = window.SetCloudHatOpacity;

window.SetCloudHatTransition = function (type, transitionTime) {
	return _in(0xfc4842a3, 0x4657bfcb, _ts(type), _fv(transitionTime));
};

/**
 * combatType can be between 0-14. See GET_COMBAT_FLOAT below for a list of possible parameters.
 */
window.SetCombatFloat = function (ped, combatType, p2) {
	return _in(0xff41b4b1, 0x41ed981c, ped, combatType, _fv(p2));
};

/**
 * This is for simulating player input.
 * amount is a float value from 0
 * 0, 1 and 2 used in the scripts. 0 is by far the most common of them.
 */
window.SetControlNormal = function (inputGroup, control, amount) {
	return _in(0xe8a25867, 0xfba3b05e, inputGroup, control, _fv(amount), _r);
};
window.N_0xe8a25867fba3b05e = window.SetControlNormal;

window.SetConvertibleRoof = function (vehicle, p1) {
	return _in(0xf39c4f53, 0x8b5124c2, vehicle, p1);
};

window.SetCreateRandomCops = function (toggle) {
	return _in(0x102e68b2, 0x024d536d, toggle);
};

window.SetCreateRandomCopsNotOnScenarios = function (toggle) {
	return _in(0x8a498685, 0x1c4ef6e7, toggle);
};

window.SetCreateRandomCopsOnScenarios = function (toggle) {
	return _in(0x444cb7d7, 0xdbe6973d, toggle);
};

window.SetCreditsActive = function (toggle) {
	return _in(0xb938b7e6, 0xd3c0620c, toggle);
};

/**
 * Sets a value that determines how aggressive the ocean waves will be. Values of 2.0 or more make for very aggressive waves like you see during a thunderstorm.
 * Works only ~200 meters around the player.
 */
window.SetCurrentIntensity = function (intensity) {
	return _in(0xb96b00e9, 0x76be977f, _fv(intensity));
};
window.N_0xb96b00e976be977f = window.SetCurrentIntensity;
window.SetWavesIntensity = window.SetCurrentIntensity;

window.SetCurrentPedVehicleWeapon = function (ped, weaponHash) {
	return _in(0x75c55983, 0xc2c39daa, ped, _ch(weaponHash), _r);
};

window.SetCurrentPedWeapon = function (ped, weaponHash, equipNow) {
	return _in(0xadf692b2, 0x54977c0c, ped, _ch(weaponHash), equipNow);
};

/**
 * Renamed to SET_CURSOR_LOCATION (I previously named it _SET_CURSOR_POSTION) which is the correct name as far as I can tell.
 */
window.SetCursorLocation = function (x, y) {
	return _in(0xfc695459, 0xd4d0e219, _fv(x), _fv(y), _r);
};
window.N_0xfc695459d4d0e219 = window.SetCursorLocation;

/**
 * Changes the mouse cursor's sprite.
 * public enum CursorType
 * {
 * None = 0,
 * Normal = 1,
 * TransparentNormal = 2,
 * PreGrab = 3,
 * Grab = 4,
 * MiddleFinger = 5,
 * LeftArrow = 6,
 * RightArrow = 7,
 * UpArrow = 8,
 * DownArrow = 9,
 * HorizontalExpand = 10,
 * Add = 11,
 * Remove = 12,
 * }
 */
window.SetCursorSprite = function (spriteId) {
	return _in(0x8db8cffd, 0x58b62552, spriteId);
};
window.N_0x8db8cffd58b62552 = window.SetCursorSprite;

/**
 * Specifies a custom respawn position to be used in conjunction with _SET_NEXT_RESPAWN_TO_CUSTOM
 */
window.SetCustomRespawnPosition = function (x, y, z, heading) {
	return _in(0x706b5edc, 0xaa7fa663, _fv(x), _fv(y), _fv(z), _fv(heading));
};
window.N_0x706b5edcaa7fa663 = window.SetCustomRespawnPosition;

/**
 * All occurrences found in b617d, sorted alphabetically and identical lines removed:
 * AUDIO::SET_CUTSCENE_AUDIO_OVERRIDE("_AK");
 * AUDIO::SET_CUTSCENE_AUDIO_OVERRIDE("_CUSTOM");
 * AUDIO::SET_CUTSCENE_AUDIO_OVERRIDE("_TOOTHLESS");
 */
window.SetCutsceneAudioOverride = function (p0) {
	return _in(0x3b4bf5f0, 0x859204d9, _ts(p0));
};

window.SetCutsceneFadeValues = function (p0, p1, p2, p3) {
	return _in(0x8093f23a, 0xbaccc7d4, p0, p1, p2, p3);
};

/**
 * p3 could be heading. Needs more research.
 */
window.SetCutsceneOrigin = function (x, y, z, p3, p4) {
	return _in(0xb812b3fd, 0x1c01cf27, _fv(x), _fv(y), _fv(z), _fv(p3), p4);
};

window.SetCutscenePedComponentVariation = function (cutsceneEntName, p1, p2, p3, modelHash) {
	return _in(0xba01e7b6, 0xdeefbbc9, _ts(cutsceneEntName), p1, p2, p3, _ch(modelHash));
};

/**
 * Thanks R*! ;)
 * if ((l_161 == 0) || (l_161 == 2)) {
 * sub_2ea27("Trying to set Jimmy prop variation");
 * CUTSCENE::_0546524ADE2E9723("Jimmy_Boston", 1, 0, 0, 0);
 * }
 */
window.SetCutscenePedPropVariation = function (cutsceneEntName, p1, p2, p3, modelHash) {
	return _in(0x0546524a, 0xde2e9723, _ts(cutsceneEntName), p1, p2, p3, _ch(modelHash));
};
window.N_0x0546524ade2e9723 = window.SetCutscenePedPropVariation;

/**
 * Only used twice in R* scripts
 */
window.SetCutsceneTriggerArea = function (p0, p1, p2, p3, p4, p5) {
	return _in(0x9896ce47, 0x21be84ba, _fv(p0), _fv(p1), _fv(p2), _fv(p3), _fv(p4), _fv(p5));
};

window.SetDamping = function (rope, vertex, value) {
	return _in(0xeea3b200, 0xa6feb65b, rope, vertex, _fv(value));
};

/**
 * NOTE: Debugging functions are not present in the retail version of the game.
 */
window.SetDebugLinesAndSpheresDrawingActive = function (enabled) {
	return _in(0x175b6bfc, 0x15cdd0c5, enabled);
};

window.SetDecisionMaker = function (ped, name) {
	return _in(0xb604a294, 0x2aded0ee, ped, _ch(name));
};

/**
 * Defines the state of a destructible object.
 * Use the "0xB48FCED898292E52" native to find an object's handle with its name / coords
 * State 2 == object just spawned
 * State 4 == Beginning of the animation
 * State 6 == Start animation
 * State 9 == End of the animation
 */
window.SetDesObjectState = function (handle, state) {
	return _in(0x5c29f698, 0xd404c5e1, handle, state);
};
window.N_0x5c29f698d404c5e1 = window.SetDesObjectState;

/**
 * MulleDK19: This starts moving the VTOL engines towards the specified angle ratio (0f-1f).
 */
window.SetDesiredVerticalFlightPhase = function (vehicle, angleRatio) {
	return _in(0x30d779de, 0x7c4f6dd3, vehicle, _fv(angleRatio));
};
window.N_0x30d779de7c4f6dd3 = window.SetDesiredVerticalFlightPhase;

/**
 * If toggle is true, hides special ability bar / character name in the pause menu
 * If toggle is false, shows special ability bar / character name in the pause menu
 */
window.SetDirectorMode = function (toggle) {
	return _in(0x80851937, 0x3fd336a3, toggle);
};
window.N_0x808519373fd336a3 = window.SetDirectorMode;

window.SetDisableAmbientMeleeMove = function (player, toggle) {
	return _in(0x2e8aabfa, 0x40a84f8c, player, toggle);
};

window.SetDisableBreaking = function (rope, enabled) {
	return _in(0x5cec1a84, 0x620e7d5b, rope, enabled, _r, _ri);
};

/**
 * sometimes used used with NET_TO_OBJ
 * hash collision last 2 words
 */
window.SetDisableFragDamage = function (object, toggle) {
	return _in(0x01ba3aed, 0x21c16cfb, object, toggle);
};

window.SetDisableVehiclePetrolTankDamage = function (vehicle, toggle) {
	return _in(0x37c8252a, 0x7c92d017, vehicle, toggle);
};

window.SetDisableVehiclePetrolTankFires = function (vehicle, toggle) {
	return _in(0x465bf26a, 0xb9684352, vehicle, toggle);
};
window.N_0x465bf26ab9684352 = window.SetDisableVehiclePetrolTankFires;

/**
 * This native sets the app id for the discord rich presence implementation.
 */
window.SetDiscordAppId = function (appId) {
	return _in(0x00000000, 0x6a02254d, _ts(appId));
};

/**
 * This native sets the image asset for the discord rich presence implementation.
 * @param assetName The name of a valid asset registered on Discordapp's developer dashboard. note that the asset has to be registered under the same discord API application set using the SET_DISCORD_APP_ID native.
 */
window.SetDiscordRichPresenceAsset = function (assetName) {
	return _in(0x00000000, 0x53dfd530, _ts(assetName));
};

/**
 * This native sets the small image asset for the discord rich presence implementation.
 * @param assetName The name of a valid asset registered on Discordapp's developer dashboard. Note that the asset has to be registered under the same discord API application set using the SET_DISCORD_APP_ID native.
 */
window.SetDiscordRichPresenceAssetSmall = function (assetName) {
	return _in(0x00000000, 0xf61d04c4, _ts(assetName));
};

/**
 * This native sets the hover text of the small image asset for the discord rich presence implementation.
 * @param text Text to be displayed when hovering over small image asset. Note that you must also set a valid small image asset using the SET_DISCORD_RICH_PRESENCE_ASSET_SMALL native.
 */
window.SetDiscordRichPresenceAssetSmallText = function (text) {
	return _in(0x00000000, 0x35e62b6a, _ts(text));
};

/**
 * This native sets the hover text of the image asset for the discord rich presence implementation.
 * @param text Text to be displayed when hovering over image asset. Note that you must also set a valid image asset using the SET_DISCORD_RICH_PRESENCE_ASSET native.
 */
window.SetDiscordRichPresenceAssetText = function (text) {
	return _in(0x00000000, 0xb029d2fa, _ts(text));
};

window.SetDispatchCopsForPlayer = function (player, toggle) {
	return _in(0xdb172424, 0x876553f4, player, toggle);
};

window.SetDispatchIdealSpawnDistance = function (p0) {
	return _in(0x6fe601a6, 0x4180d423, _fv(p0));
};

window.SetDispatchTimeBetweenSpawnAttempts = function (p0, p1) {
	return _in(0x44f7cbc1, 0xbeb3327d, p0, _fv(p1));
};

window.SetDispatchTimeBetweenSpawnAttemptsMultiplier = function (p0, p1) {
	return _in(0x48838ed9, 0x937a15d1, p0, _fv(p1));
};

/**
 * This is a NOP function. It does nothing at all.
 */
window.SetDitchPoliceModels = function (toggle) {
	return _in(0x42cbe544, 0x62d92634, toggle);
};

/**
 * Sets the acceleration limit of a door.
 * How fast it can open, or the inverse hinge resistance.
 * A limit of 0 seems to lock doors.
 * p2 is always 0, p3 is always 1.
 */
window.SetDoorAccelerationLimit = function (doorHash, limit, p2, p3) {
	return _in(0x6bab9442, 0x830c7f53, _ch(doorHash), limit, p2, p3);
};
window.N_0x6bab9442830c7f53 = window.SetDoorAccelerationLimit;

/**
 * Sets the ajar angle of a door.
 * Ranges from -1.0 to 1.0, and 0.0 is closed / default.
 * p2 is always 0, p3 is always 1.
 */
window.SetDoorAjarAngle = function (doorHash, ajar, p2, p3) {
	return _in(0xb6e6fba9, 0x5c7324ac, _ch(doorHash), _fv(ajar), p2, p3);
};
window.N_0xb6e6fba95c7324ac = window.SetDoorAjarAngle;

/**
 * Sets the on-screen drawing origin for draw-functions (which is normally x=0,y=0 in the upper left corner of the screen) to a world coordinate.
 * From now on, the screen coordinate which displays the given world coordinate on the screen is seen as x=0,y=0.
 * Example in C#:
 * Vector3 boneCoord = somePed.GetBoneCoord(Bone.SKEL_Head);
 * Function.Call(Hash.SET_DRAW_ORIGIN, boneCoord.X, boneCoord.Y, boneCoord.Z, 0);
 * Function.Call(Hash.DRAW_SPRITE, "helicopterhud", "hud_corner", -0.01, -0.015, 0.013, 0.013, 0.0, 255, 0, 0, 200);
 * Function.Call(Hash.DRAW_SPRITE, "helicopterhud", "hud_corner", 0.01, -0.015, 0.013, 0.013, 90.0, 255, 0, 0, 200);
 * Function.Call(Hash.DRAW_SPRITE, "helicopterhud", "hud_corner", -0.01, 0.015, 0.013, 0.013, 270.0, 255, 0, 0, 200);
 * Function.Call(Hash.DRAW_SPRITE, "helicopterhud", "hud_corner", 0.01, 0.015, 0.013, 0.013, 180.0, 255, 0, 0, 200);
 * Function.Call(Hash.CLEAR_DRAW_ORIGIN);
 * Result: www11.pic-upload.de/19.06.15/bkqohvil2uao.jpg
 * If the pedestrian starts walking around now, the sprites are always around her head, no matter where the head is displayed on the screen.
 * This function also effects the drawing of texts and other UI-elements.
 * The effect can be reset by calling GRAPHICS::CLEAR_DRAW_ORIGIN().
 */
window.SetDrawOrigin = function (x, y, z, p3) {
	return _in(0xaa0008f3, 0xbbb8f416, _fv(x), _fv(y), _fv(z), p3);
};

window.SetDriveTaskCruiseSpeed = function (driver, cruiseSpeed) {
	return _in(0x5c9b84bd, 0x7d31d908, driver, _fv(cruiseSpeed));
};

/**
 * This native is used to set the driving style for specific ped.
 * Driving styles id seems to be:
 * 786468
 * 262144
 * 786469
 * http://gtaforums.com/topic/822314-guide-driving-styles/
 */
window.SetDriveTaskDrivingStyle = function (ped, drivingStyle) {
	return _in(0xdace1be3, 0x7d88af67, ped, drivingStyle);
};

window.SetDriveTaskMaxCruiseSpeed = function (p0, p1) {
	return _in(0x404a5aa9, 0xb9f0b746, p0, _fv(p1));
};

/**
 * For p1 & p2 (Ped, Vehicle). I could be wrong, as the only time this native is called in scripts is once and both are 0, but I assume this native will work like SET_MOUNTED_WEAPON_TARGET in which has the same exact amount of parameters and the 1st and last 3 parameters are right and the same for both natives.
 */
window.SetDrivebyTaskTarget = function (shootingPed, targetPed, targetVehicle, x, y, z) {
	return _in(0xe5b30211, 0x4d8162ee, shootingPed, targetPed, targetVehicle, _fv(x), _fv(y), _fv(z));
};

/**
 * The function specifically verifies the value is equal to, or less than 1.0f. If it is greater than 1.0f, the function does nothing at all.
 */
window.SetDriverAbility = function (driver, ability) {
	return _in(0xb195ffa8, 0x042fc5c3, driver, _fv(ability));
};

/**
 * range 0.0f - 1.0f
 */
window.SetDriverAggressiveness = function (driver, aggressiveness) {
	return _in(0xa731f608, 0xca104e3c, driver, _fv(aggressiveness));
};

/**
 * Navigates the specified DUI browser to a different URL.
 * @param duiObject The DUI browser handle.
 * @param url The new URL.
 */
window.SetDuiUrl = function (duiObject, url) {
	return _in(0x00000000, 0xf761d9f3, duiObject, _ts(url));
};

window.SetEmitterRadioStation = function (emitterName, radioStation) {
	return _in(0xacf57305, 0xb12af907, _ts(emitterName), _ts(radioStation));
};

/**
 * Used with [SET_ENABLE_HANDCUFFS](#_0xDF1AF8B5D56542FA) in decompiled scripts. From my observations, I have noticed that while being ragdolled you are not able to get up but you can still run. Your legs can also bend.
 */
window.SetEnableBoundAnkles = function (ped, toggle) {
	return _in(0xc52e0f85, 0x5c58fc2e, ped, toggle);
};

/**
 * ped can not pull out a weapon when true
 */
window.SetEnableHandcuffs = function (ped, toggle) {
	return _in(0xdf1af8b5, 0xd56542fa, ped, toggle);
};

window.SetEnablePedEnveffScale = function (ped, toggle) {
	return _in(0xd2c5aa0c, 0x0e8d0f1e, ped, toggle);
};

/**
 * Enables diving motion when underwater.
 */
window.SetEnableScuba = function (ped, toggle) {
	return _in(0xf99f6200, 0x4024d506, ped, toggle);
};

/**
 * skin - everything alpha except skin
 * Set entity alpha level. Ranging from 0 to 255 but chnages occur after every 20 percent (after every 51).
 */
window.SetEntityAlpha = function (entity, alphaLevel, skin) {
	return _in(0x44a0870b, 0x7e92d7c0, entity, alphaLevel, skin);
};

window.SetEntityAlwaysPrerender = function (entity, toggle) {
	return _in(0xacad101e, 0x1fb66689, entity, toggle);
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.SetEntityAnimCurrentTime = function (entity, animDictionary, animName, time) {
	return _in(0x4487c259, 0xf0f70977, entity, _ts(animDictionary), _ts(animName), _fv(time));
};

/**
 * Animations list : www.los-santos-multiplayer.com/dev.airdancer?cxt=anim
 */
window.SetEntityAnimSpeed = function (entity, animDictionary, animName, speedMultiplier) {
	return _in(0x28d1a165, 0x53c51776, entity, _ts(animDictionary), _ts(animName), _fv(speedMultiplier));
};

/**
 * Makes the specified entity (ped, vehicle or object) persistent. Persistent entities will not automatically be removed by the engine.
 * p1 has no effect when either its on or off
 * maybe a quick disassembly will tell us what it does
 * p2 has no effect when either its on or off
 * maybe a quick disassembly will tell us what it does
 */
window.SetEntityAsMissionEntity = function (entity, p1, p2) {
	return _in(0xad738c30, 0x85fe7e11, entity, p1, p2);
};

/**
 * Marks the specified entity (ped, vehicle or object) as no longer needed.
 * Entities marked as no longer needed, will be deleted as the engine sees fit.
 */
window.SetEntityAsNoLongerNeeded = function (entity) {
	return _in(0xb736a491, 0xe64a32cf, _ii(entity) /* may be optional */);
};

window.SetEntityCanBeDamaged = function (entity, toggle) {
	return _in(0x1760ffa8, 0xab074d66, entity, toggle);
};

window.SetEntityCanBeDamagedByRelationshipGroup = function (entity, bCanBeDamaged, relGroup) {
	return _in(0xe22d8fde, 0x858b8119, entity, bCanBeDamaged, relGroup);
};

/**
 * Sets whether the entity can be targeted without being in line-of-sight.
 */
window.SetEntityCanBeTargetedWithoutLos = function (entity, toggle) {
	return _in(0xd3997889, 0x736fd899, entity, toggle);
};

window.SetEntityCollision = function (entity, toggle, keepPhysics) {
	return _in(0x1a9205c1, 0xb9ee827f, entity, toggle, keepPhysics);
};

/**
 * console hash: 0xBD0D4831
 * internally it calls the same function as 'SET_ENTITY_COLLISION'. but uses a hard coded parameter that only activates when p1 is set to true
 * =============================
 * Weirdly enough in the 3 scripts it's used in on PC,
 * - director_mode (2 hits)
 * - re_duel (2 hits)
 * - re_seaplane (1 hit)
 * Most of the time in the hits its actually used after the normal SET_ENTITY_COLLISION. Example from re_seaplane,
 * Local_49[iParam0  -- [[6]] ] = create_ped(26, iVar4, vVar0, fVar3, 1, true);
 * set_entity_collision(Local_49[iParam0  -- [[6]] ], iVar42, 0);
 * _0x9EBC85ED0FFFE51C(Local_49[iParam0  -- [[6]] ], !iVar66, 0); (_SET_ENTITY_COLLISION_2)
 * iVar42 being true so the normal collision native is true, 0
 * iVar66 being false so !false so it's true, 0
 * Gonna ignore the 'vars' for the create_ped no point in defining them.
 */
window.SetEntityCollision_2 = function (entity, p1, p2) {
	return _in(0x9ebc85ed, 0x0fffe51c, entity, p1, p2);
};
window.N_0x9ebc85ed0fffe51c = window.SetEntityCollision_2;

/**
 * p7 is always 1 in the scripts. Set to 1, an area around the destination coords for the moved entity is cleared from other entities.
 * Often ends with 1, 0, 0, 1); in the scripts. It works.
 * Axis - Invert Axis Flags
 */
window.SetEntityCoords = function (entity, xPos, yPos, zPos, xAxis, yAxis, zAxis, clearArea) {
	return _in(0x06843da7, 0x060a026b, entity, _fv(xPos), _fv(yPos), _fv(zPos), xAxis, yAxis, zAxis, clearArea);
};

/**
 * Axis - Invert Axis Flags
 */
window.SetEntityCoordsNoOffset = function (entity, xPos, yPos, zPos, xAxis, yAxis, zAxis) {
	return _in(0x239a3351, 0xac1da385, entity, _fv(xPos), _fv(yPos), _fv(zPos), xAxis, yAxis, zAxis);
};

/**
 * does the same as SET_ENTITY_COORDS.
 * Console Hash: 0x749B282E
 */
window.SetEntityCoords_2 = function (entity, xPos, yPos, zPos, xAxis, yAxis, zAxis, clearArea) {
	return _in(0x621873ec, 0xe1178967, entity, _fv(xPos), _fv(yPos), _fv(zPos), xAxis, yAxis, zAxis, clearArea);
};

window.SetEntityDynamic = function (entity, toggle) {
	return _in(0x1718de8e, 0x3f2823ca, entity, toggle);
};

window.SetEntityHasGravity = function (entity, toggle) {
	return _in(0x4a472244, 0x8f18eef5, entity, toggle);
};

window.SetEntityHeading = function (entity, heading) {
	return _in(0x8e2530aa, 0x8ada980e, entity, _fv(heading));
};

/**
 * health >= 0
 */
window.SetEntityHealth = function (entity, health) {
	return _in(0x6b76dc1f, 0x3ae6e6a3, entity, health);
};

window.SetEntityIconColor = function (entity, red, green, blue, alpha) {
	return _in(0x1d5f595c, 0xcae2e238, entity, red, green, blue, alpha);
};

window.SetEntityIconVisibility = function (entity, toggle) {
	return _in(0xe0e8beec, 0xca96ba31, entity, toggle);
};

/**
 * Sets a ped or an object totally invincible. It doesn't take any kind of damage. Peds will not ragdoll on explosions and the tazer animation won't apply either.
 * If you use this for a ped and you want Ragdoll to stay enabled, then do:
 * *(DWORD *)(pedAddress + 0x188) |= (1 << 9);
 * Use this if you want to get the invincibility status:
 * bool IsPedInvincible(Ped ped)
 * {
 * auto addr = getScriptHandleBaseAddress(ped);
 * if (addr)
 * {
 * DWORD flag = *(DWORD *)(addr + 0x188);
 * return ((flag & (1 << 8)) != 0) || ((flag & (1 << 9)) != 0);
 * }
 * return false;
 * }
 */
window.SetEntityInvincible = function (entity, toggle) {
	return _in(0x3882114b, 0xde571ad4, entity, toggle);
};

window.SetEntityIsTargetPriority = function (entity, p1, p2) {
	return _in(0xea02e132, 0xf5c68722, entity, p1, _fv(p2));
};

window.SetEntityLights = function (entity, toggle) {
	return _in(0x7cfba6a8, 0x0bdf3874, entity, toggle);
};

/**
 * Certainly not the main usage of this native but when set to true for a Vehicle, it will prevent the vehicle to explode if it is spawned far away from the player.
 */
window.SetEntityLoadCollisionFlag = function (entity, toggle) {
	return _in(0x0dc7caba, 0xb1e9b67e, entity, toggle);
};

/**
 * I tried using this and I see nothing happening, what is this suppose to do?
 */
window.SetEntityLocallyInvisible = function (entity) {
	return _in(0xe135a9ff, 0x3f5d05d8, entity);
};

/**
 * I tried using this and I see nothing happening, what is this suppose to do?
 */
window.SetEntityLocallyVisible = function (entity) {
	return _in(0x241e289b, 0x5c059edc, entity);
};

/**
 * LOD distance can be 0 to 0xFFFF (higher values will result in 0xFFFF) as it is actually stored as a 16-bit value (aka uint16_t).
 */
window.SetEntityLodDist = function (entity, value) {
	return _in(0x5927f96a, 0x78577363, entity, value);
};

/**
 * For instance: ENTITY::SET_ENTITY_MAX_HEALTH(PLAYER::PLAYER_PED_ID(), 200); // director_mode.c4: 67849
 */
window.SetEntityMaxHealth = function (entity, value) {
	return _in(0x166e7cf6, 0x8597d8b5, entity, value);
};

window.SetEntityMaxSpeed = function (entity, speed) {
	return _in(0x0e46a3fc, 0xbde2a1b1, entity, _fv(speed));
};

window.SetEntityMotionBlur = function (entity, toggle) {
	return _in(0x295d82a8, 0x559f9150, entity, toggle);
};

/**
 * Calling this function, regardless of the "unknown" value, disabled collision between two entities.
 * Importance of entity1 and 2 order is unclear.
 */
window.SetEntityNoCollisionEntity = function (entity1, entity2, unknown) {
	return _in(0xa53ed552, 0x0c07654a, entity1, entity2, unknown);
};

window.SetEntityOnlyDamagedByPlayer = function (entity, toggle) {
	return _in(0x79f020ff, 0x9edc0748, entity, toggle);
};

window.SetEntityOnlyDamagedByRelationshipGroup = function (entity, p1, relationshipHash) {
	return _in(0x7022bd82, 0x8fa0b082, entity, p1, _ch(relationshipHash));
};

/**
 * Enable / disable each type of damage.
 * --------------
 * p7 is to to '1' in am_mp_property_ext/int: entity::set_entity_proofs(uParam0->f_19, true, true, true, true, true, true, 1, true);
 */
window.SetEntityProofs = function (entity, bulletProof, fireProof, explosionProof, collisionProof, meleeProof, p6, p7, p8) {
	return _in(0xfaee099c, 0x6f890bb8, entity, bulletProof, fireProof, explosionProof, collisionProof, meleeProof, p6, p7, p8);
};

/**
 * w is the correct parameter name!
 */
window.SetEntityQuaternion = function (entity, x, y, z, w) {
	return _in(0x77b21be7, 0xac540f07, entity, _fv(x), _fv(y), _fv(z), _fv(w));
};

window.SetEntityRecordsCollisions = function (entity, toggle) {
	return _in(0x0a50a1ee, 0xdad01e65, entity, toggle);
};

window.SetEntityRenderScorched = function (entity, toggle) {
	return _in(0x730f5f8d, 0x3f0f2050, entity, toggle);
};

/**
 * rotationOrder refers to the order yaw pitch roll is applied
 * value ranges from 0 to 5. What you use for rotationOrder when setting must be the same as rotationOrder when getting the rotation.
 * Unsure what value corresponds to what rotation order, more testing will be needed for that.
 * For the most part R* uses 1 or 2 as the order.
 * p5 is usually set as true
 */
window.SetEntityRotation = function (entity, pitch, roll, yaw, rotationOrder, p5) {
	return _in(0x8524a8b0, 0x171d5e07, entity, _fv(pitch), _fv(roll), _fv(yaw), rotationOrder, p5);
};

/**
 * what does this native do?
 * bool IsEntitySomething(Entity entity)
 * {
 * auto addr = getScriptHandleBaseAddress(entity);
 * printf("addr: 0x%X \n", addr);
 * if (addr)
 * {
 * DWORD flag = *(DWORD *)(addr + 0x48D);
 * printf("flag: 0x%X \n", flag);
 * return ((flag & (1 << 3)) != 0) || ((flag & (1 << 30)) != 0);
 * }
 * return false;
 * }
 * wot ?
 */
window.SetEntitySomething = function (entity, toggle) {
	return _in(0x3910051c, 0xcecdb00c, entity, toggle);
};
window.N_0x3910051ccecdb00c = window.SetEntitySomething;
window.SetEntityRegister = window.SetEntitySomething;

/**
 * Example here: www.gtaforums.com/topic/830463-help-with-turning-lights-green-and-causing-peds-to-crash-into-each-other/#entry1068211340
 * 0 = green
 * 1 = red
 * 2 = yellow
 * changing lights may not change the behavior of vehicles
 */
window.SetEntityTrafficlightOverride = function (entity, state) {
	return _in(0x57c5db65, 0x6185eac4, entity, state);
};

/**
 * Note that the third parameter(denoted as z) is "up and down" with positive ment.
 */
window.SetEntityVelocity = function (entity, x, y, z) {
	return _in(0x1c99bb7b, 0x6e96d16f, entity, _fv(x), _fv(y), _fv(z));
};

/**
 * unk was always 0.
 */
window.SetEntityVisible = function (entity, toggle, unk) {
	return _in(0xea1c610a, 0x04db6bbb, entity, toggle, unk);
};

window.SetEntityVisibleInCutscene = function (p0, p1, p2) {
	return _in(0xe0031d3c, 0x8f36ab82, p0, p1, p2);
};

window.SetEveryoneIgnorePlayer = function (player, toggle) {
	return _in(0x8eeda153, 0xad141ba4, player, toggle);
};

/**
 * In appcamera.c4, Line 106:
 * if (VEHICLE::IS_VEHICLE_DRIVEABLE(PED::SET_EXCLUSIVE_PHONE_RELATIONSHIPS(PLAYER::PLAYER_PED_ID()), 0))
 * So return type could be a vehicle?
 * !Hash collision - gets the vehicle handle from ped which is about entering the vehicle!
 * sfink: agreed, 100%
 * Proper name is GET_VEHICLE_PED_IS_ENTERING
 */
window.SetExclusivePhoneRelationships = function (ped) {
	return _in(0xf92691ae, 0xd837a5fc, ped, _r, _ri);
};

/**
 * Groups found in the scripts used with this native:
 * "AMMUNATION",
 * "QUARRY",
 * "Triathlon_1",
 * "Triathlon_2",
 * "Triathlon_3"
 */
window.SetExclusiveScenarioGroup = function (scenarioGroup) {
	return _in(0x535e97e1, 0xf7fc0c6a, _ts(scenarioGroup));
};

window.SetExplosiveAmmoThisFrame = function (player) {
	return _in(0xa66c71c9, 0x8d5f2cfb, player);
};

window.SetExplosiveMeleeThisFrame = function (player) {
	return _in(0xff1bed81, 0xbfdc0fe0, player, _r, _ri);
};

/**
 * Sets a secondary timecycle modifier.
 */
window.SetExtraTimecycleModifier = function (modifierName) {
	return _in(0x5096fd9c, 0xcb49056d, _ts(modifierName));
};
window.N_0x3b2fd68db5f8331c = window.SetExtraTimecycleModifier;

/**
 * The same as [`SetTimecycleModifierStrength`](#_0x82E7FFCD5B2326B3) but for the secondary tiemcycle modifier.
 * @param strength :
 */
window.SetExtraTimecycleModifierStrength = function (strength) {
	return _in(0x2c328af1, 0x7210f009, _fv(strength));
};
window.N_0x2c328af17210f009 = window.SetExtraTimecycleModifierStrength;

window.SetFacialIdleAnimOverride = function (ped, animName, animDict) {
	return _in(0xffc24b98, 0x8b938b38, ped, _ts(animName), _ts(animDict));
};

/**
 * Sets whether the game should fade in after the player dies or is arrested.
 */
window.SetFadeInAfterDeathArrest = function (toggle) {
	return _in(0xda66d279, 0x6ba33f12, toggle);
};

window.SetFadeInAfterLoad = function (toggle) {
	return _in(0xf3d78f59, 0xdfe18d79, toggle);
};

/**
 * Sets whether the game should fade out after the player is arrested.
 */
window.SetFadeOutAfterArrest = function (toggle) {
	return _in(0x1e0b4dc0, 0xd990a4e7, toggle);
};

/**
 * Sets whether the game should fade out after the player dies.
 */
window.SetFadeOutAfterDeath = function (toggle) {
	return _in(0x4a18e01d, 0xf2c87b86, toggle);
};

/**
 * Sets a visually fake wanted level on the user interface. Used by Rockstar's scripts to "override" regular wanted levels and make custom ones while the real wanted level and multipliers are ignored.
 * Max is 6. Also the mini-map gets the red & blue flashing effect.
 */
window.SetFakeWantedLevel = function (fakeWantedLevel) {
	return _in(0x1454f244, 0x8de30163, fakeWantedLevel);
};

window.SetFarDrawVehicles = function (toggle) {
	return _in(0x26324f33, 0x423f3cc3, toggle);
};

/**
 * When this is set to ON, shadows only draw as you get nearer.
 * When OFF, they draw from a further distance. (((BUT))) f*ck up nearer shadows quality.
 */
window.SetFarShadowsSuppressed = function (toggle) {
	return _in(0x80ecbc0c, 0x856d3b0b, toggle);
};

window.SetFireAmmoThisFrame = function (player) {
	return _in(0x11879cdd, 0x803d30f4, player, _r, _ri);
};

/**
 * Sets the near clipping plane of the first person camera.
 */
window.SetFirstPersonCamNearClip = function (distance) {
	return _in(0x0af7b437, 0x918103b3, _fv(distance));
};
window.N_0x0af7b437918103b3 = window.SetFirstPersonCamNearClip;

/**
 * Similar to _CLAMP_GAMEPLAY_CAM_PITCH except this is specifically for the FP camera, and it only lets you clamp the pitch within the normal range.
 */
window.SetFirstPersonCamPitchRange = function (minAngle, maxAngle) {
	return _in(0xbcfc632d, 0xb7673bf0, _fv(minAngle), _fv(maxAngle));
};
window.N_0xbcfc632db7673bf0 = window.SetFirstPersonCamPitchRange;

/**
 * Purpose of p0 and p1 unknown.
 */
window.SetFlash = function (p0, p1, fadeIn, duration, fadeOut) {
	return _in(0x0ab84296, 0xfed9cfc6, _fv(p0), _fv(p1), _fv(fadeIn), _fv(duration), _fv(fadeOut));
};

window.SetFlashLightFadeDistance = function (distance) {
	return _in(0xcea66dad, 0x478cd39b, _fv(distance), _r, _ri);
};

/**
 * Override the area where the camera will render the terrain.
 * p3, p4 and p5 are usually set to 0.0
 */
window.SetFocusArea = function (x, y, z, offsetX, offsetY, offsetZ) {
	return _in(0xbb7454ba, 0xff08fe25, _fv(x), _fv(y), _fv(z), _fv(offsetX), _fv(offsetY), _fv(offsetZ));
};

/**
 * It seems to make the entity's coords mark the point from which LOD-distances are measured. In my testing, setting a vehicle as the focus entity and moving that vehicle more than 300 distance units away from the player will make the level of detail around the player go down drastically (shadows disappear, textures go extremely low res, etc). The player seems to be the default focus entity.
 */
window.SetFocusEntity = function (entity) {
	return _in(0x198f7770, 0x5fa0931d, entity);
};

/**
 * From the b617d scripts:
 * CAM::SET_FOLLOW_PED_CAM_CUTSCENE_CHAT("FOLLOW_PED_ATTACHED_TO_ROPE_CAMERA", 0);
 * CAM::SET_FOLLOW_PED_CAM_CUTSCENE_CHAT("FOLLOW_PED_ON_EXILE1_LADDER_CAMERA", 1500);
 * CAM::SET_FOLLOW_PED_CAM_CUTSCENE_CHAT("FOLLOW_PED_SKY_DIVING_CAMERA", 0);
 * CAM::SET_FOLLOW_PED_CAM_CUTSCENE_CHAT("FOLLOW_PED_SKY_DIVING_CAMERA", 3000);
 * CAM::SET_FOLLOW_PED_CAM_CUTSCENE_CHAT("FOLLOW_PED_SKY_DIVING_FAMILY5_CAMERA", 0);
 * CAM::SET_FOLLOW_PED_CAM_CUTSCENE_CHAT("FOLLOW_PED_SKY_DIVING_CAMERA", 0);
 */
window.SetFollowPedCamCutsceneChat = function (p0, p1) {
	return _in(0x44a113dd, 0x6ffc48d1, _ts(p0), p1, _r);
};

/**
 * Sets the type of Player camera:
 * 0 - Third Person Close
 * 1 - Third Person Mid
 * 2 - Third Person Far
 * 4 - First Person
 */
window.SetFollowPedCamViewMode = function (viewMode) {
	return _in(0x5a4f9edf, 0x1673f704, viewMode);
};

/**
 * Sets the type of Player camera in vehicles:
 * 0 - Third Person Close
 * 1 - Third Person Mid
 * 2 - Third Person Far
 * 4 - First Person
 */
window.SetFollowVehicleCamViewMode = function (viewMode) {
	return _in(0xac253d78, 0x42768f48, viewMode);
};

window.SetFollowVehicleCamZoomLevel = function (zoomLevel) {
	return _in(0x19464cb6, 0xe4078c8a, zoomLevel);
};

window.SetForceHdVehicle = function (vehicle, toggle) {
	return _in(0x97ce68cb, 0x032583f0, vehicle, toggle);
};
window.N_0x97ce68cb032583f0 = window.SetForceHdVehicle;

window.SetForceObjectThisFrame = function (p0, p1, p2, p3) {
	return _in(0xf5380819, 0x86e49e9d, p0, p1, p2, p3);
};

/**
 * Forces footstep tracks on all surfaces.
 */
window.SetForcePedFootstepsTracks = function (toggle) {
	return _in(0xaeedad14, 0x20c65cc0, toggle);
};

/**
 * Forces vehicle trails on all surfaces.
 */
window.SetForceVehicleTrails = function (toggle) {
	return _in(0x4cc7f0fe, 0xa5283fe0, toggle);
};

/**
 * Sets some values in a vehicle gadget (tow arm, digger arm, etc.). Don't know which one though.
 * I've tested on the towtruck 1 & 2, Dock Lift (Crate Arm), Dozer, and such have no effect. However when used on a Forklift it sets the height of the forks. 0.0 = Lowest 1.0 = Highest. This is best to be used if you wanna pick-up a car since un-realistically on GTA V forklifts can't pick up much of anything due to vehicle mass. If you put this under a car then set it above 0.0 to a 'lifted-value' it will raise the car with no issue lol
 */
window.SetForkliftForkHeight = function (vehicle, height) {
	return _in(0x37ebbf31, 0x17bd6a25, vehicle, _fv(height));
};
window.N_0x37ebbf3117bd6a25 = window.SetForkliftForkHeight;

window.SetFrontendActive = function (active) {
	return _in(0x745711a7, 0x5ab09277, active);
};

window.SetFrontendRadioActive = function (active) {
	return _in(0xf7f26c6e, 0x9cc9ebb8, active);
};

window.SetFrozenRenderingDisabled = function (enabled) {
	return _in(0xdfc252d8, 0xa3e15ab7, enabled);
};
window.EnableGameplayCam = window.SetFrozenRenderingDisabled;

/**
 * Make sure to call this from the correct thread if you're using multiple threads because all other threads except the one which is calling SET_GAME_PAUSED will be paused which means you will lose control and the game remains in paused mode until you exit GTA5.exe
 */
window.SetGamePaused = function (toggle) {
	return _in(0x577d1284, 0xd6873711, toggle);
};

window.SetGamePausesForStreaming = function (toggle) {
	return _in(0x717cd6e6, 0xfaebbedc, toggle);
};

window.SetGameplayCamRawPitch = function (pitch) {
	return _in(0x759e13eb, 0xc1c15c5a, _fv(pitch));
};

/**
 * Does nothing
 */
window.SetGameplayCamRawYaw = function (yaw) {
	return _in(0x103991d4, 0xa307d472, _fv(yaw));
};

/**
 * Sets the camera position relative to heading in float from -360 to +360.
 * Heading is alwyas 0 in aiming camera.
 */
window.SetGameplayCamRelativeHeading = function (heading) {
	return _in(0xb4ec2312, 0xf4e5b1f1, _fv(heading));
};

/**
 * Sets the camera pitch.
 * Parameters:
 * x = pitches the camera on the x axis.
 * Value2 = always seems to be hex 0x3F800000 (1.000000 float).
 */
window.SetGameplayCamRelativePitch = function (x, Value2) {
	return _in(0x6d0858b8, 0xedfd2b7d, _fv(x), _fv(Value2));
};

/**
 * Sets the amplitude for the gameplay (i.e. 3rd or 1st) camera to shake. Used in script "drunk_controller.ysc.c4" to simulate making the player drunk.
 */
window.SetGameplayCamShakeAmplitude = function (amplitude) {
	return _in(0xa87e0093, 0x2db4d85d, _fv(amplitude));
};

/**
 * Example C#:
 * Function.Call(Hash.SET_GAMEPLAY_COORD_HINT, position.X, position.Y, position.Z, hintDuration, 1500, 1000, 0);
 * The camera look-at is canceled if the user is already panning the camera around.
 */
window.SetGameplayCoordHint = function (x, y, z, duration, blendOutDuration, blendInDuration, unk) {
	return _in(0xd51adcd2, 0xd8bc0fb3, _fv(x), _fv(y), _fv(z), duration, blendOutDuration, blendInDuration, unk);
};

/**
 * p6 & p7 - possibly length or time
 */
window.SetGameplayEntityHint = function (entity, xOffset, yOffset, zOffset, p4, p5, p6, p7, p8) {
	return _in(0x189e955a, 0x8313e298, entity, _fv(xOffset), _fv(yOffset), _fv(zOffset), p4, p5, p6, p7, p8);
};

window.SetGameplayHintFov = function (FOV) {
	return _in(0x513403fb, 0x9c56211f, _fv(FOV));
};

window.SetGameplayObjectHint = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0x83e87508, 0xa2ca2ac6, p0, _fv(p1), _fv(p2), _fv(p3), p4, p5, p6, p7);
};

window.SetGameplayPedHint = function (p0, x1, y1, z1, p4, p5, p6, p7) {
	return _in(0x2b486269, 0xacd548d3, p0, _fv(x1), _fv(y1), _fv(z1), p4, p5, p6, p7);
};

window.SetGameplayVehicleHint = function (p0, p1, p2, p3, p4, p5, p6, p7) {
	return _in(0xa2297e18, 0xf3e71c2e, p0, _fv(p1), _fv(p2), _fv(p3), p4, p5, p6, p7);
};

window.SetGarbageTrucks = function (toggle) {
	return _in(0x2afd795e, 0xeac8d30d, toggle, _r, _ri);
};

/**
 * Needs to be looped! And yes, it does work and is not a hash collision.
 * Birds will try to reach the given height.
 */
window.SetGlobalMinBirdFlightHeight = function (height) {
	return _in(0x6c6b1485, 0x86f934f7, _fv(height));
};

window.SetGpsActive = function (active) {
	return _in(0x3bd3f52b, 0xa9b1e4e8, active);
};

window.SetGpsDisabledZone = function (p0, p1, p2, p3, p4, p5) {
	return _in(0xdc20483c, 0xd3dd5201, p0, p1, p2, p3, p4, p5);
};

/**
 * Only the script that originally called SET_GPS_FLAGS can set them again. Another script cannot set the flags, until the first script that called it has called CLEAR_GPS_FLAGS.
 * Doesn't seem like the flags are actually read by the game at all.
 * ---------------
 * Might be left-over from GTA IV. I kind of miss the *ding-dong* turn left in 2 meters lady lol.
 */
window.SetGpsFlags = function (p0, p1) {
	return _in(0x5b440763, 0xa4c8d15b, p0, _fv(p1));
};

window.SetGpsFlashes = function (toggle) {
	return _in(0x320d0e0d, 0x936a0e9b, toggle);
};

/**
 * level can be from 0 to 3
 * 0: 9.8
 * 1: 2.4
 * 2: 0.1 - very low
 * 3: 0.0
 */
window.SetGravityLevel = function (level) {
	return _in(0x740e14fa, 0xd5842351, level);
};

/**
 * 0: Default
 * 1: Circle Around Leader
 * 2: Alternative Circle Around Leader
 * 3: Line, with Leader at center
 */
window.SetGroupFormation = function (groupId, formationType) {
	return _in(0xce2f5fc3, 0xaf7e8c1e, groupId, formationType);
};

window.SetGroupFormationSpacing = function (groupId, p1, p2, p3) {
	return _in(0x1d9d4500, 0x4c28c916, groupId, _fv(p1), _fv(p2), _fv(p3));
};

/**
 * Sets the range at which members will automatically leave the group.
 */
window.SetGroupSeparationRange = function (groupHandle, separationRange) {
	return _in(0x4102c785, 0x8cfee4e4, groupHandle, _fv(separationRange));
};

/**
 * Sets a global handling override for a specific vehicle class. The name is supposed to match the `handlingName` field from handling.meta.
 * Example: `SetHandlingField('AIRTUG', 'CHandlingData', 'fSteeringLock', 360.0)`
 * @param vehicle The vehicle class to set data for.
 * @param class_ The handling class to set. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to set. These match the keys in `handling.meta`.
 * @param value The value to set.
 */
window.SetHandlingField = function (vehicle, class_, fieldName, value) {
	return _in(0x00000000, 0xfe8064e3, _ts(vehicle), _ts(class_), _ts(fieldName), value);
};

/**
 * Sets a global handling override for a specific vehicle class. The name is supposed to match the `handlingName` field from handling.meta.
 * Example: `SetHandlingFloat('AIRTUG', 'CHandlingData', 'fSteeringLock', 360.0)`
 * @param vehicle The vehicle class to set data for.
 * @param class_ The handling class to set. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to set. These match the keys in `handling.meta`.
 * @param value The floating-point value to set.
 */
window.SetHandlingFloat = function (vehicle, class_, fieldName, value) {
	return _in(0x00000000, 0x090dd01c, _ts(vehicle), _ts(class_), _ts(fieldName), _fv(value));
};

/**
 * Sets a global handling override for a specific vehicle class. The name is supposed to match the `handlingName` field from handling.meta.
 * @param vehicle The vehicle class to set data for.
 * @param class_ The handling class to set. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to set. These match the keys in `handling.meta`.
 * @param value The integer value to set.
 */
window.SetHandlingInt = function (vehicle, class_, fieldName, value) {
	return _in(0x00000000, 0x8ab3f46c, _ts(vehicle), _ts(class_), _ts(fieldName), value);
};

/**
 * Sets a global handling override for a specific vehicle class. The name is supposed to match the `handlingName` field from handling.meta.
 * Example: `SetHandlingVector('AIRTUG', 'CHandlingData', 'vecCentreOfMassOffset', vector3(0.0, 0.0, -5.0))`
 * @param vehicle The vehicle class to set data for.
 * @param class_ The handling class to set. Only "CHandlingData" is supported at this time.
 * @param fieldName The field name to set. These match the keys in `handling.meta`.
 * @param value The Vector3 value to set.
 */
window.SetHandlingVector = function (vehicle, class_, fieldName, value) {
	return _in(0x00000000, 0x07f9d543, _ts(vehicle), _ts(class_), _ts(fieldName), value);
};

/**
 * Harcoded limit for radius is 30.0f
 */
window.SetHdArea = function (x, y, z, radius) {
	return _in(0xb85f2661, 0x9073e775, _fv(x), _fv(y), _fv(z), _fv(radius));
};

/**
 * Equivalent of SET_HELI_BLADES_SPEED(vehicleHandle, 1.0f);
 * this native works on planes to?
 */
window.SetHeliBladesFullSpeed = function (vehicle) {
	return _in(0xa178472e, 0xbb8ae60d, vehicle);
};

/**
 * Sets the speed of the helicopter blades in percentage of the full speed.
 * vehicleHandle: The helicopter.
 * speed: The speed in percentage, 0.0f being 0% and 1.0f being 100%.
 */
window.SetHeliBladesSpeed = function (vehicle, speed) {
	return _in(0xfd280b4d, 0x7f3abc4d, vehicle, _fv(speed));
};

/**
 * value between 0.0 and 1.0
 */
window.SetHelicopterRollPitchYawMult = function (helicopter, multiplier) {
	return _in(0x6e0859b5, 0x30a365cc, helicopter, _fv(multiplier));
};

/**
 * Makes the ped ragdoll like when falling from a great height
 */
window.SetHighFallTask = function (ped, p1, p2, p3) {
	return _in(0x8c825bdc, 0x7741d37c, ped, p1, p2, p3);
};

window.SetHornEnabled = function (vehicle, toggle) {
	return _in(0x76d683c1, 0x08594d0e, vehicle, toggle);
};

/**
 * HUD colors and their values: pastebin.com/d9aHPbXN
 */
window.SetHudColour = function (hudColorIndex, r, g, b, a) {
	return _in(0xf314cf4f, 0x0211894e, hudColorIndex, r, g, b, a);
};
window.N_0xf314cf4f0211894e = window.SetHudColour;

/**
 * HUD colors and their values: pastebin.com/d9aHPbXN
 * --------------------------------------------------
 * makes hudColorIndex2 color into hudColorIndex color
 */
window.SetHudColoursSwitch = function (hudColorIndex, hudColorIndex2) {
	return _in(0x1ccc708f, 0x0f850613, hudColorIndex, hudColorIndex2);
};
window.N_0x1ccc708f0f850613 = window.SetHudColoursSwitch;

window.SetHudComponentPosition = function (id, x, y) {
	return _in(0xaabb1f56, 0xe2a17ced, id, _fv(x), _fv(y));
};

window.SetIgnoreLowPriorityShockingEvents = function (player, toggle) {
	return _in(0x596976b0, 0x2b6b5700, player, toggle);
};

window.SetIgnoreNoGpsFlag = function (ignore) {
	return _in(0x72751156, 0xe7678833, ignore);
};

/**
 * No other indices work...
 * IK Index ---------
 * 1 = head
 * 3 = left arm
 * 4 = right arm
 * ------------------
 * EntityLookAt can be null (0 handle)
 */
window.SetIkTarget = function (ped, ikIndex, entityLookAt, boneLookAt, offsetX, offsetY, offsetZ, p7, blendInDuration, blendOutDuration) {
	return _in(0xc32779c1, 0x6fceecd9, ped, ikIndex, entityLookAt, boneLookAt, _fv(offsetX), _fv(offsetY), _fv(offsetZ), p7, blendInDuration, blendOutDuration);
};

window.SetInitialPlayerStation = function (radioStation) {
	return _in(0x88795f13, 0xfacda88d, _ts(radioStation));
};

window.SetInputExclusive = function (inputGroup, control) {
	return _in(0xede476e5, 0xee29edb1, inputGroup, control);
};

window.SetInteriorActive = function (interiorID, toggle) {
	return _in(0xe37b76c3, 0x87be28ed, interiorID, toggle);
};

window.SetInteriorPropColor = function (interiorID, propName, color) {
	return _in(0xc1f1920b, 0xaf281317, interiorID, _ts(propName), color);
};

window.SetLastDrivenVehicle = function (vehicle) {
	return _in(0xacfb2463, 0xcc22bed2, vehicle);
};
window.N_0xacfb2463cc22bed2 = window.SetLastDrivenVehicle;

window.SetLocalPlayerInvisibleLocally = function (p0) {
	return _in(0xe5f773c1, 0xa1d9d168, p0);
};

window.SetLocalPlayerVisibleInCutscene = function (p0, p1) {
	return _in(0xd1065d68, 0x947e7b6e, p0, p1);
};

window.SetLocalPlayerVisibleLocally = function (p0) {
	return _in(0x7619364c, 0x82d3bf14, p0);
};

/**
 * Sets whether or not `SHUTDOWN_LOADING_SCREEN` automatically shuts down the NUI frame for the loading screen. If this is enabled,
 * you will have to manually invoke `SHUTDOWN_LOADING_SCREEN_NUI` whenever you want to hide the NUI loading screen.
 * @param manualShutdown TRUE to manually shut down the loading screen NUI.
 */
window.SetManualShutdownLoadingScreenNui = function (manualShutdown) {
	return _in(0x00000000, 0x1722c938, manualShutdown);
};

/**
 * If toggle is true, the map is shown in full screen
 * If toggle is false, the map is shown in normal mode
 */
window.SetMapFullScreen = function (toggle) {
	return _in(0x5354c5ba, 0x2ea868a4, toggle);
};
window.N_0x5354c5ba2ea868a4 = window.SetMapFullScreen;

window.SetMaxWantedLevel = function (maxWantedLevel) {
	return _in(0xaa5f02db, 0x48d704b9, maxWantedLevel);
};

/**
 * If this is the correct name, what microphone? I know your TV isn't going to reach out and adjust your headset so..
 */
window.SetMicrophonePosition = function (p0, x1, y1, z1, x2, y2, z2, x3, y3, z3) {
	return _in(0xb6ae90ed, 0xde95c762, p0, _fv(x1), _fv(y1), _fv(z1), _fv(x2), _fv(y2), _fv(z2), _fv(x3), _fv(y3), _fv(z3));
};

window.SetMinigameInProgress = function (toggle) {
	return _in(0x19e00d73, 0x22c6f85b, toggle);
};

/**
 * Argument must be 0.0f or above 38.0f, or it will be ignored.
 */
window.SetMinimapAttitudeIndicatorLevel = function (altitude, p1) {
	return _in(0xd201f3ff, 0x917a506d, _fv(altitude), p1);
};

window.SetMinimapBlockWaypoint = function (toggle) {
	return _in(0x58fadded, 0x207897dc, toggle);
};

/**
 * This native is used to toggle map components like the army base at the top of the map.
 * p2 appears to be always -1.
 * An incomplete list of components ID:
 * ```
 * 0: Los Santos' air port yellow lift-off markers.
 * 1: Sandy Shore's air port yellow lift-off markers.
 * 2: Trevor's air port yellow lift-off markers.
 * 3: Unknown.
 * 4: Unknown.
 * 5: Unknown.
 * 6: Vespucci Beach lifeguard building.
 * 7: Unknown.
 * 8: Unknown.
 * 15: Army base.
 * ```
 */
window.SetMinimapComponent = function (componentID, toggle, p2) {
	return _in(0x75a9a109, 0x48d1dea6, componentID, toggle, p2, _r, _ri);
};

/**
 * Not much is known so far on what it does _exactly_.
 * All I know for sure is that it draws the specified hole ID on the pause menu map as well as on the mini-map/radar. This native also seems to change some other things related to the pause menu map's behaviour, for example: you can no longer set waypoints, the pause menu map starts up in a 'zoomed in' state. This native does not need to be executed every tick.
 * You need to center the minimap manually as well as change/lock it's zoom and angle in order for it to appear correctly on the minimap.
 * You'll also need to use the `GOLF` scaleform in order to get the correct minmap border to show up.
 * Use [`N_0x35edd5b2e3ff01c0()`](https://runtime.fivem.net/doc/reference.html#_0x35EDD5B2E3FF01C0) to reset the map when you no longer want to display any golf holes (you still need to unlock zoom, position and angle of the radar manually after calling this).
 * @param hole The ID of the hole to draw on the map. ID starts with 1 for hole 1, 2 for hole 2, etc. 0 disables the golf map behaviour.
 */
window.SetMinimapGolfCourse = function (hole) {
	return _in(0x71bdb63d, 0xbaf8da59, hole);
};
window.N_0x71bdb63dbaf8da59 = window.SetMinimapGolfCourse;

/**
 * Sets the display info for a minimap overlay.
 * @param miniMap The minimap overlay ID.
 * @param x The X position for the overlay. This is equivalent to a game coordinate X.
 * @param y The Y position for the overlay. This is equivalent to a game coordinate Y, except that it's inverted (gfxY = -gameY).
 * @param xScale The X scale for the overlay. This is equivalent to the Flash \_xscale property, therefore 100 = 100%.
 * @param yScale The Y scale for the overlay. This is equivalent to the Flash \_yscale property.
 * @param alpha The alpha value for the overlay. This is equivalent to the Flash \_alpha property, therefore 100 = 100%.
 */
window.SetMinimapOverlayDisplay = function (miniMap, x, y, xScale, yScale, alpha) {
	return _in(0x00000000, 0x6a48b3ca, miniMap, _fv(x), _fv(y), _fv(xScale), _fv(yScale), _fv(alpha));
};

/**
 * If true, the entire map will be revealed.
 */
window.SetMinimapRevealed = function (toggle) {
	return _in(0xf8dee0a5, 0x600cbb93, toggle);
};
window.N_0xf8dee0a5600cbb93 = window.SetMinimapRevealed;

/**
 * If true, the player can't save the game.
 * If the parameter is true, sets the mission flag to true, if the parameter is false, the function does nothing at all.
 * ^ also, if the mission flag is already set, the function does nothing at all
 */
window.SetMissionFlag = function (toggle) {
	return _in(0xc4301e51, 0x21a0ed73, toggle);
};

/**
 * Takes a text label, gets the string (must not be longer than 600 chars, should not exceed 64 chars) and sets the name to that string.
 * p0 must be true.
 */
window.SetMissionName = function (p0, name) {
	return _in(0x5f28ecf5, 0xfc84772f, p0, _ts(name));
};

/**
 * Similar to SET_MISSION_NAME but this one can take any string (must not be greater than 600 chars, should not exceed 64 chars), not just text labels.
 * p0 must be true.
 */
window.SetMissionName_2 = function (p0, name) {
	return _in(0xe45087d8, 0x5f468bc2, p0, _ts(name));
};
window.N_0xe45087d85f468bc2 = window.SetMissionName_2;

/**
 * p1 is always 0
 */
window.SetMissionTrainAsNoLongerNeeded = function (p1) {
	return _in(0xbbe76483, 0x49b49be8, _i, p1);
};

window.SetMissionTrainCoords = function (train, x, y, z) {
	return _in(0x591ca673, 0xaa6ab736, train, _fv(x), _fv(y), _fv(z));
};

window.SetMobilePhonePosition = function (posX, posY, posZ) {
	return _in(0x693a5c6d, 0x6734085b, _fv(posX), _fv(posY), _fv(posZ));
};

window.SetMobilePhoneRadioState = function (state) {
	return _in(0xbf286c55, 0x4784f3df, state);
};

/**
 * Last parameter is unknown and always zero.
 */
window.SetMobilePhoneRotation = function (rotX, rotY, rotZ, p3) {
	return _in(0xbb779c0c, 0xa917e865, _fv(rotX), _fv(rotY), _fv(rotZ), p3);
};

/**
 * The minimum/default is 500.0f. If you plan to make it bigger set it's position as well. Also this seems to need to be called in a loop as when you close the phone the scale is reset. If not in a loop you'd need to call it everytime before you re-open the phone.
 */
window.SetMobilePhoneScale = function (scale) {
	return _in(0xcbdd322a, 0x73d6d932, _fv(scale));
};

/**
 * Enables Radio on phone.
 */
window.SetMobileRadioEnabledDuringGameplay = function (Toggle) {
	return _in(0x1098355a, 0x16064bb3, Toggle);
};

/**
 * Unloads model from memory
 */
window.SetModelAsNoLongerNeeded = function (model) {
	return _in(0xe532f5d7, 0x8798daab, _ch(model));
};

window.SetModelHeadlightConfiguration = function (modelHash, ratePerSecond, headlightRotation, invertRotation) {
	return _in(0x00000000, 0x7f6b8d75, _ch(modelHash), _fv(ratePerSecond), _fv(headlightRotation), invertRotation);
};

/**
 * Note: Look in decompiled scripts and the times that p1 and p2 aren't 0. They are filled with vars. If you look through out that script what other natives those vars are used in, you can tell p1 is a ped and p2 is a vehicle. Which most likely means if you want the mounted weapon to target a ped set targetVehicle to 0 or vice-versa.
 */
window.SetMountedWeaponTarget = function (shootingPed, targetPed, targetVehicle, x, y, z) {
	return _in(0xccd89219, 0x2c6d2bb9, shootingPed, targetPed, targetVehicle, _fv(x), _fv(y), _fv(z));
};

/**
 * Sets flag's sprite transparency. 0-255.
 */
window.SetMpGamerTagAlpha = function (gamerTagId, component, alpha) {
	return _in(0xd48fe545, 0xcd46f857, gamerTagId, component, alpha);
};
window.N_0xd48fe545cd46f857 = window.SetMpGamerTagAlpha;

/**
 * Set's the string displayed when flag 3 (AudioSpeaker) active.
 */
window.SetMpGamerTagChatting = function (gamerTagId, string) {
	return _in(0x7b772374, 0x7ccb55b6, gamerTagId, _ts(string));
};
window.N_0x7b7723747ccb55b6 = window.SetMpGamerTagChatting;

window.SetMpGamerTagColor = function (headDisplayId, username, pointedClanTag, isRockstarClan, clanTag, p5, r, g, b) {
	return _in(0x6dd05e9d, 0x83efa4c9, headDisplayId, _ts(username), pointedClanTag, isRockstarClan, _ts(clanTag), p5, r, g, b);
};
window.N_0x6dd05e9d83efa4c9 = window.SetMpGamerTagColor;
window.CreateMpGamerTagColor = window.SetMpGamerTagColor;

/**
 * Ranges from 0 to 255. 0 is grey health bar, ~50 yellow, 200 purple.
 */
window.SetMpGamerTagColour = function (gamerTagId, flag, color) {
	return _in(0x613ed644, 0x950626ae, gamerTagId, flag, color);
};
window.N_0x613ed644950626ae = window.SetMpGamerTagColour;

/**
 * Ranges from 0 to 255. 0 is grey health bar, ~50 yellow, 200 purple.
 * Should be enabled as flag (2). Has 0 opacity by default.
 * - This was _SET_MP_GAMER_TAG_HEALTH_BAR_COLOR,
 */
window.SetMpGamerTagHealthBarColour = function (headDisplayId, color) {
	return _in(0x3158c77a, 0x7e888ab4, headDisplayId, color);
};
window.N_0x3158c77a7e888ab4 = window.SetMpGamerTagHealthBarColour;
window.SetMpGamerTagHealthBarColor = window.SetMpGamerTagHealthBarColour;

/**
 * Displays a bunch of icons above the players name, and level, and their name twice
 */
window.SetMpGamerTagIcons = function (headDisplayId, p1) {
	return _in(0xa67f9c46, 0xd612b6f1, headDisplayId, p1);
};
window.N_0xa67f9c46d612b6f1 = window.SetMpGamerTagIcons;

window.SetMpGamerTagName = function (gamerTagId, string) {
	return _in(0xdea2b828, 0x3baa3944, gamerTagId, _ts(string));
};
window.N_0xdea2b8283baa3944 = window.SetMpGamerTagName;

/**
 * enum MpGamerTagComponent
 * {
 * GAMER_NAME = 0,
 * CREW_TAG,
 * healthArmour,
 * BIG_TEXT,
 * AUDIO_ICON,
 * MP_USING_MENU,
 * MP_PASSIVE_MODE,
 * WANTED_STARS,
 * MP_DRIVER,
 * MP_CO_DRIVER,
 * MP_TAGGED,
 * GAMER_NAME_NEARBY,
 * ARROW,
 * MP_PACKAGES,
 * INV_IF_PED_FOLLOWING,
 * RANK_TEXT,
 * MP_TYPING
 * };
 */
window.SetMpGamerTagVisibility = function (gamerTagId, component, toggle) {
	return _in(0x63bb75ab, 0xedc1f6a0, gamerTagId, component, toggle);
};
window.N_0x63bb75abedc1f6a0 = window.SetMpGamerTagVisibility;

/**
 * displays wanted star above head
 */
window.SetMpGamerTagWantedLevel = function (gamerTagId, wantedlvl) {
	return _in(0xcf228e2a, 0xa03099c3, gamerTagId, wantedlvl);
};
window.N_0xcf228e2aa03099c3 = window.SetMpGamerTagWantedLevel;

window.SetMpGamerTag_ = function (headDisplayId, p1) {
	return _in(0xee76ff7e, 0x6a0166b0, headDisplayId, p1);
};
window.N_0xee76ff7e6a0166b0 = window.SetMpGamerTag_;

window.SetMultiplayerBankCash = function () {
	return _in(0xdd21b55d, 0xf695cd0a);
};

/**
 * **This native does absolutely nothing, just a nullsub**
 */
window.SetMultiplayerHudCash = function (p0, p1) {
	return _in(0xfd1d2203, 0x94bcb824, p0, p1);
};

/**
 * Whether or not another player is allowed to take control of the entity
 */
window.SetNetworkIdCanMigrate = function (netId, toggle) {
	return _in(0x299eeb23, 0x175895fc, netId, toggle);
};

window.SetNetworkIdExistsOnAllMachines = function (netId, toggle) {
	return _in(0xe05e81a8, 0x88fa63c8, netId, toggle);
};

/**
 * not tested....
 */
window.SetNetworkIdSyncToPlayer = function (netId, player, toggle) {
	return _in(0xa8a02458, 0x7329f36a, netId, player, toggle);
};
window.N_0xa8a024587329f36a = window.SetNetworkIdSyncToPlayer;

window.SetNetworkIdVisibleInCutscene = function (netId, p1, p2) {
	return _in(0xa6928482, 0x543022b4, netId, p1, p2);
};

/**
 * Original put name,
 * _SET_NETWORK_VEHICLE_NON_CONTACT
 * However changed to 'object' as the instances where this is called in scripts both freemode and golf it's only used on objects after the objects are called OBJ_TO_NET p_parachute_s (freemode) prop_golf_ball (golf). Tho the script search was done via TU27 Xbox360 ones.
 * Got my hopes up whoever put this as vehicle. I was hoping it was what R* used in non-contact races.
 */
window.SetNetworkObjectNonContact = function (object, toggle) {
	return _in(0x6274c471, 0x2850841e, object, toggle);
};
window.N_0x6274c4712850841e = window.SetNetworkObjectNonContact;

window.SetNetworkVehicleRespotTimer = function (netId, time) {
	return _in(0xec51713a, 0xb6ec36e8, netId, time);
};

window.SetNewWaypoint = function (x, y) {
	return _in(0xfe43368d, 0x2aa4f2fc, _fv(x), _fv(y));
};

/**
 * **This native does absolutely nothing, just a nullsub**
 * ```
 * Not used in the scripts.
 * Bullshit! It's used in spawn_activities
 * ```
 */
window.SetNextDesiredMoveState = function (p0) {
	return _in(0xf1b9f16e, 0x89e2c93a, _fv(p0));
};

/**
 * Sets the next spawn location to the position supplied to _SET_CUSTOM_RESPAWN_POSITION.
 */
window.SetNextRespawnToCustom = function () {
	return _in(0xa2716d40, 0x842eaf79);
};
window.N_0xa2716d40842eaf79 = window.SetNextRespawnToCustom;

/**
 * Enables Night Vision.
 * Example:
 * C#: Function.Call(Hash.SET_NIGHTVISION, true);
 * C++: GRAPHICS::SET_NIGHTVISION(true);
 * BOOL toggle:
 * true = turns night vision on for your player.
 * false = turns night vision off for your player.
 */
window.SetNightvision = function (toggle) {
	return _in(0x18f621f7, 0xa5b1f85d, toggle);
};

window.SetNoLoadingScreen = function (toggle) {
	return _in(0x5262cc19, 0x95d07e09, toggle);
};

window.SetNoiseoveride = function (toggle) {
	return _in(0xe787bf1c, 0x5cf823c9, toggle);
};

window.SetNoisinessoveride = function (value) {
	return _in(0xcb6a7c3b, 0xb17a0c67, _fv(value));
};

/**
 * Toggles the North Yankton map
 */
window.SetNorthYanktonMap = function (toggle) {
	return _in(0x9133955f, 0x1a2da957, toggle);
};
window.SetDrawMapVisible = window.SetNorthYanktonMap;

/**
 * From the decompiled scripts:
 * UI::_92F0DA1E27DB96DC(6);
 * UI::_92F0DA1E27DB96DC(184);
 * UI::_92F0DA1E27DB96DC(190);
 * sets background color for the next notification
 * 6 = red
 * 184 = green
 * 190 = yellow
 * Here is a list of some colors that can be used: gyazo.com/68bd384455fceb0a85a8729e48216e15
 * this seems to set the alpha to 255 automatically, if you have a work around let me know
 */
window.SetNotificationBackgroundColor = function (hudIndex) {
	return _in(0x92f0da1e, 0x27db96dc, hudIndex);
};
window.N_0x92f0da1e27db96dc = window.SetNotificationBackgroundColor;

/**
 * sets font color for the next notification
 */
window.SetNotificationColorNext = function (hudIndex) {
	return _in(0x39bbf623, 0xfc803eac, hudIndex);
};
window.N_0x39bbf623fc803eac = window.SetNotificationColorNext;

/**
 * sets color for notification flash
 */
window.SetNotificationFlashColor = function (red, green, blue, alpha) {
	return _in(0x17430b91, 0x8701c342, red, green, blue, alpha);
};
window.N_0x17430b918701c342 = window.SetNotificationFlashColor;

/**
 * Sets some extra options for a notification. It adds an image (or icon type) and sets a notification title (sender) and subtitle (subject).
 * Texture dictionary and texture name parameters are usually the same exact value.
 * Example result:
 * ![](https://i.imgur.com/LviutDl.png)
 * Old description with list of possible icons and texture names:
 * ```text
 * List of picNames: pastebin.com/XdpJVbHz
 * flash is a bool for fading in.
 * iconTypes:
 * 1 : Chat Box
 * 2 : Email
 * 3 : Add Friend Request
 * 4 : Nothing
 * 5 : Nothing
 * 6 : Nothing
 * 7 : Right Jumping Arrow
 * 8 : RP Icon
 * 9 : $ Icon
 * "sender" is the very top header. This can be any old string.
 * "subject" is the header under the sender.
 * ```
 * @param textureDict The texture dictionary for the icon.
 * @param textureName The texture name for the icon.
 * @param flash Flash, doesn't seem to work no matter what.
 * @param iconType The icon type, see the list above in the description.
 * @param sender The notification title.
 * @param subject The notification subtitle.
 * @return The notification handle.
 */
window.SetNotificationMessage = function (textureDict, textureName, flash, iconType, sender, subject) {
	return _in(0x1ccd9a37, 0x359072cf, _ts(textureDict), _ts(textureName), flash, iconType, _ts(sender), _ts(subject), _r, _ri);
};

/**
 * List of picNames pastebin.com/XdpJVbHz
 * flash is a bool for fading in.
 * iconTypes:
 * 1 : Chat Box
 * 2 : Email
 * 3 : Add Friend Request
 * 4 : Nothing
 * 5 : Nothing
 * 6 : Nothing
 * 7 : Right Jumping Arrow
 * 8 : RP Icon
 * 9 : $ Icon
 * "sender" is the very top header. This can be any old string.
 * "subject" is the header under the sender.
 * "duration" is a multiplier, so 1.0 is normal, 2.0 is twice as long (very slow), and 0.5 is half as long.
 * "clanTag" shows a crew tag in the "sender" header, after the text. You need to use 3 underscores as padding. Maximum length of this field seems to be 7. (e.g. "MK" becomes "___MK", "ACE" becomes "___ACE", etc.)
 */
window.SetNotificationMessageClanTag = function (picName1, picName2, flash, iconType, sender, subject, duration, clanTag) {
	return _in(0x5cbf7bad, 0xe20db93e, _ts(picName1), _ts(picName2), flash, iconType, _ts(sender), _ts(subject), _fv(duration), _ts(clanTag), _r, _ri);
};

/**
 * List of picNames: pastebin.com/XdpJVbHz
 * flash is a bool for fading in.
 * iconTypes:
 * 1 : Chat Box
 * 2 : Email
 * 3 : Add Friend Request
 * 4 : Nothing
 * 5 : Nothing
 * 6 : Nothing
 * 7 : Right Jumping Arrow
 * 8 : RP Icon
 * 9 : $ Icon
 * "sender" is the very top header. This can be any old string.
 * "subject" is the header under the sender.
 * "duration" is a multiplier, so 1.0 is normal, 2.0 is twice as long (very slow), and 0.5 is half as long.
 * "clanTag" shows a crew tag in the "sender" header, after the text. You need to use 3 underscores as padding. Maximum length of this field seems to be 7. (e.g. "MK" becomes "___MK", "ACE" becomes "___ACE", etc.)
 * iconType2 is a mirror of iconType. It shows in the "subject" line, right under the original iconType.
 * int IconNotification(char *text, char *text2, char *Subject)
 * {
 * _SET_NOTIFICATION_TEXT_ENTRY("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * _SET_NOTIFICATION_MESSAGE_CLAN_TAG_2("CHAR_SOCIAL_CLUB", "CHAR_SOCIAL_CLUB", 1, 7, text2, Subject, 1.0f, "__EXAMPLE", 7);
 * return _DRAW_NOTIFICATION(1, 1);
 * }
 */
window.SetNotificationMessageClanTag_2 = function (picName1, picName2, flash, iconType1, sender, subject, duration, clanTag, iconType2, p9) {
	return _in(0x531b84e7, 0xda981fb6, _ts(picName1), _ts(picName2), flash, iconType1, _ts(sender), _ts(subject), _fv(duration), _ts(clanTag), iconType2, p9, _r, _ri);
};

/**
 * List of picNames: pastebin.com/XdpJVbHz
 */
window.SetNotificationMessage_2 = function (picName1, picName2, flash, iconType, p4, sender, subject) {
	return _in(0x2b7e9a4e, 0xaaa93c89, _ts(picName1), picName2, flash, iconType, p4, _ts(sender), _ts(subject), _r, _ri);
};
window.N_0x2b7e9a4eaaa93c89 = window.SetNotificationMessage_2;

/**
 * Needs more research.
 * Only one type of usage in the scripts:
 * UI::_C6F580E4C94926AC("CHAR_ACTING_UP", "CHAR_ACTING_UP", 0, 0, "DI_FEED_CHAR", a_0);
 */
window.SetNotificationMessage_3 = function (picName1, picName2, p2, p3, p4, p5) {
	return _in(0xc6f580e4, 0xc94926ac, _ts(picName1), _ts(picName2), p2, p3, _ts(p4), _ts(p5), _r, _ri);
};
window.N_0xc6f580e4c94926ac = window.SetNotificationMessage_3;

/**
 * NOTE: 'duration' is a multiplier, so 1.0 is normal, 2.0 is twice as long (very slow), and 0.5 is half as long.
 * Example, only occurrence in the scripts:
 * v_8 = UI::_1E6611149DB3DB6B("CHAR_SOCIAL_CLUB", "CHAR_SOCIAL_CLUB", 0, 0, &v_9, "", a_5);
 */
window.SetNotificationMessage_4 = function (picName1, picName2, flash, iconType, sender, subject, duration) {
	return _in(0x1e661114, 0x9db3db6b, _ts(picName1), _ts(picName2), flash, iconType, _ts(sender), _ts(subject), _fv(duration), _r, _ri);
};
window.N_0x1e6611149db3db6b = window.SetNotificationMessage_4;

/**
 * Declares the entry type of a notification, for example "STRING".
 * int ShowNotification(char *text)
 * {
 * _SET_NOTIFICATION_TEXT_ENTRY("STRING");
 * ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME(text);
 * return _DRAW_NOTIFICATION(1, 1);
 * }
 */
window.SetNotificationTextEntry = function (text) {
	return _in(0x202709f4, 0xc58a0424, _ts(text));
};

window.SetNuiFocus = function (hasFocus, hasCursor) {
	return _in(0x00000000, 0x5b98ae30, hasFocus, hasCursor);
};

window.SetNumberOfParkedVehicles = function (value) {
	return _in(0xcaa15f13, 0xebd417ff, value, _r, _ri);
};

/**
 * This is an alias of SET_ENTITY_AS_NO_LONGER_NEEDED.
 */
window.SetObjectAsNoLongerNeeded = function (object) {
	return _in(0x3ae22deb, 0x5ba5a3e6, _ii(object) /* may be optional */);
};

/**
 * Seems to set the colour of the prop. Haven't really tested it on other props.
 * Only appears in am_mp_nightclub.c for the nightclub dancefloor.
 * Not sure what p1 does, seems to only ever be '1' in scripts.
 * @param R :
 * @param G :
 * @param B :
 */
window.SetObjectColour = function (entity, p1, R, G, B) {
	return _in(0x3b2fd68d, 0xb5f8331c, entity, p1, R, G, B);
};
window.N_0x3b2fd68db5f8331c = window.SetObjectColour;

/**
 * Adjust the physics parameters of a prop, or otherwise known as "object". This is useful for simulated gravity.
 * Other parameters seem to be unknown.
 * p2: seems to be weight and gravity related. Higher value makes the obj fall faster. Very sensitive?
 * p3: seems similar to p2
 * p4: makes obj fall slower the higher the value
 * p5: similar to p4
 */
window.SetObjectPhysicsParams = function (object, weight, p2, p3, p4, p5, gravity, p7, p8, p9, p10, buoyancy) {
	return _in(0xf6df6e90, 0xde7df90f, object, _fv(weight), _fv(p2), _fv(p3), _fv(p4), _fv(p5), _fv(gravity), _fv(p7), _fv(p8), _fv(p9), _fv(p10), _fv(buoyancy));
};

/**
 * `
 * i don't know what this does
 * ```<pre>
 * void __fastcall OBJECT___0x77F33F2CCF64B3AA_START(scrNativeCallContext *args)
 * {
 * bool p2; // bl@1
 * CObject *pObject; // rax@1
 * scrNativeCallContextArgStruct *pArgs; // rax@1
 * pArgs = args->pArgs;
 * p2 = pArgs->a2.BOOL != 0;
 * pObject = getAddressOfObject(pArgs->a1.Object);
 * if ( pObject )
 * {
 * pObject->field_425 &= 0xDFu;                // 1101 1111 (clear bit 6)
 * pObject->field_425 |= 32 * p2;              // bit 6 = p2
 * }
 * }
 * // sfink
 * // note to AB: please set "white-space: pre" in css
 * ````
 * ```
 * ## Parameters
 * * **object**:
 * * **p1**:
 */
window.SetObjectSomething = function (object, p1) {
	return _in(0x77f33f2c, 0xcf64b3aa, object, p1);
};
window.N_0x77f33f2ccf64b3aa = window.SetObjectSomething;

window.SetObjectTargettable = function (object, targettable) {
	return _in(0x8a739169, 0x0f5afd81, object, targettable, _r, _ri);
};

/**
 * enum ObjectPaintVariants
 * {
 * Pacific = 0,
 * Azure = 1,
 * Nautical = 2,
 * Continental = 3,
 * Battleship = 4,
 * Intrepid = 5,
 * Uniform = 6,
 * Classico = 7,
 * Mediterranean = 8,
 * Command = 9,
 * Mariner = 10,
 * Ruby = 11,
 * Vintage = 12,
 * Pristine = 13,
 * Merchant = 14,
 * Voyager = 15
 * };
 */
window.SetObjectTextureVariant = function (object, paintIndex) {
	return _in(0x971da005, 0x5324d033, object, paintIndex);
};
window.N_0x971da0055324d033 = window.SetObjectTextureVariant;

/**
 * Appears to have an optional bool parameter that is unused in the scripts.
 * If you pass true, something will be set to zero.
 */
window.SetOverrideWeather = function (weatherType) {
	return _in(0xa43d5c6f, 0xe51adbef, _ts(weatherType));
};

/**
 * p0 always seems to be 0
 * duration in milliseconds
 * frequency should range from about 10 (slow vibration) to 255 (very fast)
 * appears to be a hash collision, though it does do what it says
 * example:
 * SET_PAD_SHAKE(0, 100, 200);
 */
window.SetPadShake = function (p0, duration, frequency) {
	return _in(0x48b3886c, 0x1358d0d5, p0, duration, frequency);
};

window.SetParachuteTaskTarget = function (ped, x, y, z) {
	return _in(0xc313379a, 0xf0fceda7, ped, _fv(x), _fv(y), _fv(z));
};

window.SetParachuteTaskThrust = function (ped, thrust) {
	return _in(0x0729bac1, 0xb8c64317, ped, _fv(thrust));
};

window.SetParkedVehicleDensityMultiplierThisFrame = function (multiplier) {
	return _in(0xeae6dcc7, 0xeee3db1d, _fv(multiplier));
};

/**
 * console hash: 0xC92719A7
 */
window.SetParticleFxAssetOldToNew = function (oldAsset, newAsset) {
	return _in(0xea1e2d93, 0xf6f75ed9, _ts(oldAsset), _ts(newAsset));
};
window.SetPtfxAssetOld_2New = window.SetParticleFxAssetOldToNew;

/**
 * hash collision
 */
window.SetParticleFxBloodScale = function (p0) {
	return _in(0x5f6df3d9, 0x2271e8a1, p0);
};

window.SetParticleFxCamInsideNonplayerVehicle = function (p0, p1) {
	return _in(0xacee6f36, 0x0fc1f6b6, p0, p1);
};

window.SetParticleFxCamInsideVehicle = function (p0) {
	return _in(0xeec40470, 0x28426510, p0);
};

window.SetParticleFxLoopedAlpha = function (ptfxHandle, alpha) {
	return _in(0x72684513, 0x2380142e, ptfxHandle, _fv(alpha));
};

/**
 * only works on some fx's
 * p4 = 0
 */
window.SetParticleFxLoopedColour = function (ptfxHandle, r, g, b, p4) {
	return _in(0x7f8f6587, 0x7f88783b, ptfxHandle, _fv(r), _fv(g), _fv(b), p4);
};

/**
 * Should be named SET_PARTICLE_FX_LOOPED_PROPERTY. "Evolution" doesn't make much sense...
 * --------
 * p4 seems to be always 0.
 * Usage:
 * if (!GRAPHICS::DOES_PARTICLE_FX_LOOPED_EXIST(l_25C7)) {
 * l_25C7 = GRAPHICS::_DDE23F30CC5A0F03("scr_veh_plane_gen_damage", l_8B9, l_25C4, 0.0, 0.0, 0.0, ENTITY::_GET_ENTITY_BONE_INDEX(l_8B9, "exhaust"), 1.0, 0, 0, 0);
 * GRAPHICS::SET_PARTICLE_FX_LOOPED_EVOLUTION(l_25C7, "damage_smoke", 0.5, 0);
 * GRAPHICS::SET_PARTICLE_FX_LOOPED_EVOLUTION(l_25C7, "damage_fire", 0.2, 0);
 * }
 */
window.SetParticleFxLoopedEvol