--- Gets an entity's population type.
-- **Valid population types:**
-- ```cpp
-- enum ePopulationType
-- {
-- POPTYPE_UNKNOWN = 0,
-- POPTYPE_RANDOM_PERMANENT,
-- POPTYPE_RANDOM_PARKED,
-- POPTYPE_RANDOM_PATROL,
-- POPTYPE_RANDOM_SCENARIO,
-- POPTYPE_RANDOM_AMBIENT,
-- POPTYPE_PERMANENT,
-- POPTYPE_MISSION,
-- POPTYPE_REPLAY,
-- POPTYPE_CACHE,
-- POPTYPE_TOOL
-- };
-- ```
-- @param entity The entity to obtain the population type from.
-- @return A population type, from the enumeration above.
function Global.GetEntityPopulationType(entity)
	return _in(0xF6F5161F4534EDFF, entity, _r, _ri)
end
