--- Returns the distance between two three-dimensional points, optionally ignoring the Z values.
-- You'll most likely want to use your language's native vector functionality instead.
-- @param x1 The X coordinate of the first point.
-- @param y1 The Y coordinate of the first point.
-- @param z1 The Z coordinate of the first point.
-- @param x2 The X coordinate of the second point.
-- @param y2 The Y coordinate of the second point.
-- @param z2 The Z coordinate of the second point.
-- @param useZ Whether or not to use the Z coordinate.
-- @return The distance between the passed points in units.
function Global.GetDistanceBetweenCoords(x1, y1, z1, x2, y2, z2, useZ)
	return _in(0xF1B760881820C952, x1, y1, z1, x2, y2, z2, useZ, _r, _rf)
end
