--- Sets a pixel in the specified runtime texture. This will have to be committed using `COMMIT_RUNTIME_TEXTURE` to have any effect.
-- @param tex A handle to the runtime texture.
-- @param x The X position of the pixel to change.
-- @param y The Y position of the pixel to change.
-- @param r The new R value (0-255).
-- @param g The new G value (0-255).
-- @param b The new B value (0-255).
-- @param a The new A value (0-255).
function Global.SetRuntimeTexturePixel(tex, x, y, r, g, b, a)
	return _in(0xab65acee, tex, x, y, r, g, b, a)
end
