--- Creates a new stunt jump.
-- The radius1 and radius2 might actually not be a radius at all, but that's what it seems to me testing them in-game. But they may be 'angle' floats instead, considering this native is named ADD_STUNT_JUMP\_**ANGLED**.
-- Info about the specific 'parameter sections':
-- **x1, y1, z1, x2, y2, z2 and radius1:**
-- First coordinates are for the jump entry area, and the radius that will be checked around that area. So if you're not exactly within the coordinates, but you are within the outter radius limit then it will still register as entering the stunt jump. Note as mentioned above, the radius is just a guess, I'm not really sure about it's exact purpose.
-- **x3, y3, z3, x4, y4, z4 and radius2:**
-- Next part is the landing area, again starting with the left bottom (nearest to the stunt jump entry zone) coordinate, and the second one being the top right furthest away part of the landing area. Followed by another (most likely) radius float, this is usually slightly larger than the entry zone 'radius' float value, just because you have quite a lot of places where you can land (I'm guessing).
-- **camX, camY and camZ:**
-- The final coordinate in this native is the Camera position. Rotation and zoom/FOV is managed by the game itself, you just need to provide the camera location.
-- **unk1, unk2 and unk3:**
-- Not sure what these are for, but they're always `150, 0, 0` in decompiled scripts.
-- Visualized example in-game:
-- ![](https://d.fivem.dev/2019-03-15_18-24_c7802_846.png)
-- Here is a list of almost all of the stunt jumps from GTA V (taken from decompiled scripts): <https://pastebin.com/EW1jBPkY>
-- @param x1 Entry zone bottom left corner x.
-- @param y1 Entry zone bottom left corner y.
-- @param z1 Entry zone bottom left corner z.
-- @param x2 Entry zone top right corner x.
-- @param y2 Entry zone top right corner y.
-- @param z2 Entry zone top right corner z.
-- @param radius1 Probably a "feather" radius for entry zone, you need to enter the jump within the min/max coordinates, or within this radius of those two coordinates.
-- @param x3 Landing zone start corner coordinate x.
-- @param y3 Landing zone start corner coordinate y.
-- @param z3 Landing zone start corner coordinate z.
-- @param x4 Landing zone end corner coordinate x.
-- @param y4 Landing zone end corner coordinate y.
-- @param z4 Landing zone end corner coordinate z.
-- @param radius2 Probably a "feather" radius for landing zone, you need to land within the min/max coordinates, or within this radius of those two coordinates.
-- @param camX Stunt (cinematic) camera x position.
-- @param camY Stunt (cinematic) camera y position.
-- @param camZ Stunt (cinematic) camera z position.
-- @param unk1 always 150
-- @param unk2 always 0
-- @param unk3 always 0
-- @return The ID of the stuntjump that was created.
function Global.AddStuntJumpAngled(x1, y1, z1, x2, y2, z2, radius1, x3, y3, z3, x4, y4, z4, radius2, camX, camY, camZ, unk1, unk2, unk3)
	return _in(0xBBE5D803A5360CBF, x1, y1, z1, x2, y2, z2, radius1, x3, y3, z3, x4, y4, z4, radius2, camX, camY, camZ, unk1, unk2, unk3, _r, _ri)
end
