--- This native is used along with these two natives: [`0xa356990e161c9e65`](https://runtime.fivem.net/doc/reference.html#_0xA356990E161C9E65) and [`0x5ce62918f8d703c7`](https://runtime.fivem.net/doc/reference.html#_0x5CE62918F8D703C7).
-- This native configures the location, size, rotation, normal height, and the difference ratio between min, normal and max.
-- All those natives combined they will output something like this: <https://i.imgur.com/TC6cku6.png>
-- @param x Grid center x coord.
-- @param y Grid center y coord.
-- @param z Grid center z coord.
-- @param p3 Not sure, but seems to be the amount of lines top/bottom there are in the grid. -1.0 works best.
-- @param rotation Grid rotation (keep between 0.0 and 1.0).
-- @param p5 Offset top/bottom (? not sure about this one, seems weird).
-- @param width Grid width (usually 15.0).
-- @param height Grid height (usually 15.0).
-- @param p8 Not sure, but seems to be the amount of lines left/right there are in the grid. -1.0 works best.
-- @param scale Zoom / scale (higher values = smaller (more) squares) (lower values = bigger (less) squares).
-- @param glowIntensity glow intensity / opacity (40.0 is fine for daylight, 15.0 is fine for night time).
-- @param normalHeight The z coord for 'normal' height (white grid lines level).
-- @param heightDiff This is the height difference/margin used for line color changes. 0.2 works fine (normalHeight + 0.2 = yellow, normalHeight - 0.2 = red).
function Global.N_0x1c4fc5752bcd8e48(x, y, z, p3, rotation, p5, width, height, p8, scale, glowIntensity, normalHeight, heightDiff)
	return _in(0x1C4FC5752BCD8E48, x, y, z, p3, rotation, p5, width, height, p8, scale, glowIntensity, normalHeight, heightDiff)
end
