--- Enables or disables the owner check for the specified entity in network-synchronized scenes. When set to `false`, the entity cannot participate in synced scenes initiated by clients that do not own the entity.
-- By default, this is `false` for all entities, meaning only the entity's owner can include it in networked synchronized scenes.
-- @param entity The entity to set the flag for.
-- @param allow Whether to allow remote synced scenes for the entity.
function Global.SetEntityRemoteSyncedScenesAllowed(entity, allow)
	return _in(0xd3fc9d88, entity, allow)
end
