--- Getter to check if one of the neon lights of a vehicle is enabled. This native is the server side getter of [IS_VEHICLE_NEON_LIGHT_ENABLED](#\_0x8C4B92553E4766A5).
-- ```cpp
-- enum neonIndex
-- {
-- NEON_BACK = 0,   // Back neon
-- NEON_RIGHT = 1,  // Right neon
-- NEON_LEFT = 2,   // Left neon
-- NEON_FRONT = 3   // Front neon
-- };
-- ```
-- @param vehicle The vehicle to check.
-- @param neonIndex A value from the neonIndex enum representing the neon light to check.
-- @return Returns `true` if the specified neon light is enabled, `false` otherwise.
function Global.GetVehicleNeonEnabled(vehicle, neonIndex)
	return _in(0x684bdbf2, vehicle, neonIndex, _r)
end
