--- Sets the rotation of a specified entity in the game world.
-- ```
-- NativeDB Introduced: v323
-- ```
-- @param entity The entity to rotate.
-- @param pitch The pitch (X-axis) rotation in degrees.
-- @param roll The roll (Y-axis) rotation in degrees.
-- @param yaw The yaw (Z-axis) rotation in degrees.
-- @param rotationOrder Specifies the order in which yaw, pitch, and roll are applied, see [`GET_ENTITY_ROTATION`](#\_0xAFBD61CC738D9EB9) for the available rotation orders.
-- @param bDeadCheck Usually set to `true`. Determines whether to check if the entity is dead before applying the rotation.
function Global.SetEntityRotation(entity, pitch, roll, yaw, rotationOrder, bDeadCheck)
	return _in(0xa345efe, entity, pitch, roll, yaw, rotationOrder, bDeadCheck)
end
