/*!
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *                     _            _       _           _       
 *                    | |___  __   / \   __| |_ __ ___ (_)_ __  
 *                    | __\ \/ /  / _ \ / _` | '_ ` _ \| | '_ \ 
 *                    | |_ >  <  / ___ \ (_| | | | | | | | | | |
 *                     \__/_/\_\/_/   \_\__,_|_| |_| |_|_|_| |_|
 *                                                              
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 * Author: André Tabarra (https://github.com/tabarra)
 * Repository: https://github.com/tabarra/txAdmin
 * txAdmin is a free open source software provided under the license below.
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 * MIT License
 * 
 * Copyright (c) 2019-2025 André Tabarra <maintainer@txadmin.gg>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 * This distribution also includes third party code under their own licenses, which
 * can be found in ../THIRD-PARTY-LICENSES.txt or their respective repositories.
 * Attribution for non-code assets can be found at the bottom of ../README.md or at
 * the top of the respective file.
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 */
"use strict";var __create=Object.create;var __defProp=Object.defineProperty;var __getOwnPropDesc=Object.getOwnPropertyDescriptor;var __getOwnPropNames=Object.getOwnPropertyNames;var __getProtoOf=Object.getPrototypeOf;var __hasOwnProp=Object.prototype.hasOwnProperty;var __typeError=msg=>{throw TypeError(msg)};var __esm=(fn2,res)=>function __init(){return fn2&&(res=(0,fn2[__getOwnPropNames(fn2)[0]])(fn2=0)),res};var __commonJS=(cb,mod3)=>function __require(){return mod3||(0,cb[__getOwnPropNames(cb)[0]])((mod3={exports:{}}).exports,mod3),mod3.exports};var __export=(target,all2)=>{for(var name in all2)__defProp(target,name,{get:all2[name],enumerable:true})};var __copyProps=(to,from,except,desc)=>{if(from&&typeof from==="object"||typeof from==="function"){for(let key of __getOwnPropNames(from))if(!__hasOwnProp.call(to,key)&&key!==except)__defProp(to,key,{get:()=>from[key],enumerable:!(desc=__getOwnPropDesc(from,key))||desc.enumerable})}return to};var __toESM=(mod3,isNodeMode,target)=>(target=mod3!=null?__create(__getProtoOf(mod3)):{},__copyProps(isNodeMode||!mod3||!mod3.__esModule?__defProp(target,"default",{value:mod3,enumerable:true}):target,mod3));var __toCommonJS=mod3=>__copyProps(__defProp({},"__esModule",{value:true}),mod3);var __accessCheck=(obj,member,msg)=>member.has(obj)||__typeError("Cannot "+msg);var __privateGet=(obj,member,getter)=>(__accessCheck(obj,member,"read from private field"),getter?getter.call(obj):member.get(obj));var __privateAdd=(obj,member,value)=>member.has(obj)?__typeError("Cannot add the same private member more than once"):member instanceof WeakSet?member.add(obj):member.set(obj,value);var __privateSet=(obj,member,value,setter)=>(__accessCheck(obj,member,"write to private field"),setter?setter.call(obj,value):member.set(obj,value),value);var require_stackframe=__commonJS({"node_modules/stackframe/stackframe.js"(exports2,module2){(function(root2,factory){"use strict";if(typeof define==="function"&&define.amd){define("stackframe",[],factory)}else if(typeof exports2==="object"){module2.exports=factory()}else{root2.StackFrame=factory()}})(exports2,function(){"use strict";function _isNumber(n){return!isNaN(parseFloat(n))&&isFinite(n)}function _capitalize(str2){return str2.charAt(0).toUpperCase()+str2.substring(1)}function _getter(p){return function(){return this[p]}}var booleanProps=["isConstructor","isEval","isNative","isToplevel"];var numericProps=["columnNumber","lineNumber"];var stringProps=["fileName","functionName","source"];var arrayProps=["args"];var objectProps=["evalOrigin"];var props=booleanProps.concat(numericProps,stringProps,arrayProps,objectProps);function StackFrame(obj){if(!obj)return;for(var i2=0;i2<props.length;i2++){if(obj[props[i2]]!==void 0){this["set"+_capitalize(props[i2])](obj[props[i2]])}}}StackFrame.prototype={getArgs:function(){return this.args},setArgs:function(v){if(Object.prototype.toString.call(v)!=="[object Array]"){throw new TypeError("Args must be an Array")}this.args=v},getEvalOrigin:function(){return this.evalOrigin},setEvalOrigin:function(v){if(v instanceof StackFrame){this.evalOrigin=v}else if(v instanceof Object){this.evalOrigin=new StackFrame(v)}else{throw new TypeError("Eval Origin must be an Object or StackFrame")}},toString:function(){var fileName=this.getFileName()||"";var lineNumber=this.getLineNumber()||"";var columnNumber=this.getColumnNumber()||"";var functionName=this.getFunctionName()||"";if(this.getIsEval()){if(fileName){return"[eval] ("+fileName+":"+lineNumber+":"+columnNumber+")"}return"[eval]:"+lineNumber+":"+columnNumber}if(functionName){return functionName+" ("+fileName+":"+lineNumber+":"+columnNumber+")"}return fileName+":"+lineNumber+":"+columnNumber}};StackFrame.fromString=function StackFrame$$fromString(str2){var argsStartIndex=str2.indexOf("(");var argsEndIndex=str2.lastIndexOf(")");var functionName=str2.substring(0,argsStartIndex);var args2=str2.substring(argsStartIndex+1,argsEndIndex).split(",");var locationString=str2.substring(argsEndIndex+1);if(locationString.indexOf("@")===0){var parts=/@(.+?)(?::(\d+))?(?::(\d+))?$/.exec(locationString,"");var fileName=parts[1];var lineNumber=parts[2];var columnNumber=parts[3]}return new StackFrame({functionName,args:args2||void 0,fileName,lineNumber:lineNumber||void 0,columnNumber:columnNumber||void 0})};for(var i=0;i<booleanProps.length;i++){StackFrame.prototype["get"+_capitalize(booleanProps[i])]=_getter(booleanProps[i]);StackFrame.prototype["set"+_capitalize(booleanProps[i])]=function(p){return function(v){this[p]=Boolean(v)}}(booleanProps[i])}for(var j=0;j<numericProps.length;j++){StackFrame.prototype["get"+_capitalize(numericProps[j])]=_getter(numericProps[j]);StackFrame.prototype["set"+_capitalize(numericProps[j])]=function(p){return function(v){if(!_isNumber(v)){throw new TypeError(p+" must be a Number")}this[p]=Number(v)}}(numericProps[j])}for(var k=0;k<stringProps.length;k++){StackFrame.prototype["get"+_capitalize(stringProps[k])]=_getter(stringProps[k]);StackFrame.prototype["set"+_capitalize(stringProps[k])]=function(p){return function(v){this[p]=String(v)}}(stringProps[k])}return StackFrame})}});var require_error_stack_parser=__commonJS({"node_modules/error-stack-parser/error-stack-parser.js"(exports2,module2){(function(root2,factory){"use strict";if(typeof define==="function"&&define.amd){define("error-stack-parser",["stackframe"],factory)}else if(typeof exports2==="object"){module2.exports=factory(require_stackframe())}else{root2.ErrorStackParser=factory(root2.StackFrame)}})(exports2,function ErrorStackParser2(StackFrame){"use strict";var FIREFOX_SAFARI_STACK_REGEXP=/(^|@)\S+:\d+/;var CHROME_IE_STACK_REGEXP=/^\s*at .*(\S+:\d+|\(native\))/m;var SAFARI_NATIVE_CODE_REGEXP=/^(eval@)?(\[native code])?$/;return{parse:function ErrorStackParser$$parse(error){if(typeof error.stacktrace!=="undefined"||typeof error["opera#sourceloc"]!=="undefined"){return this.parseOpera(error)}else if(error.stack&&error.stack.match(CHROME_IE_STACK_REGEXP)){return this.parseV8OrIE(error)}else if(error.stack){return this.parseFFOrSafari(error)}else{throw new Error("Cannot parse given Error object")}},extractLocation:function ErrorStackParser$$extractLocation(urlLike){if(urlLike.indexOf(":")===-1){return[urlLike]}var regExp=/(.+?)(?::(\d+))?(?::(\d+))?$/;var parts=regExp.exec(urlLike.replace(/[()]/g,""));return[parts[1],parts[2]||void 0,parts[3]||void 0]},parseV8OrIE:function ErrorStackParser$$parseV8OrIE(error){var filtered=error.stack.split("\n").filter(function(line){return!!line.match(CHROME_IE_STACK_REGEXP)},this);return filtered.map(function(line){if(line.indexOf("(eval ")>-1){line=line.replace(/eval code/g,"eval").replace(/(\(eval at [^()]*)|(,.*$)/g,"")}var sanitizedLine=line.replace(/^\s+/,"").replace(/\(eval code/g,"(").replace(/^.*?\s+/,"");var location=sanitizedLine.match(/ (\(.+\)$)/);sanitizedLine=location?sanitizedLine.replace(location[0],""):sanitizedLine;var locationParts=this.extractLocation(location?location[1]:sanitizedLine);var functionName=location&&sanitizedLine||void 0;var fileName=["eval","<anonymous>"].indexOf(locationParts[0])>-1?void 0:locationParts[0];return new StackFrame({functionName,fileName,lineNumber:locationParts[1],columnNumber:locationParts[2],source:line})},this)},parseFFOrSafari:function ErrorStackParser$$parseFFOrSafari(error){var filtered=error.stack.split("\n").filter(function(line){return!line.match(SAFARI_NATIVE_CODE_REGEXP)},this);return filtered.map(function(line){if(line.indexOf(" > eval")>-1){line=line.replace(/ line (\d+)(?: > eval line \d+)* > eval:\d+:\d+/g,":$1")}if(line.indexOf("@")===-1&&line.indexOf(":")===-1){return new StackFrame({functionName:line})}else{var functionNameRegex=/((.*".+"[^@]*)?[^@]*)(?:@)/;var matches2=line.match(functionNameRegex);var functionName=matches2&&matches2[1]?matches2[1]:void 0;var locationParts=this.extractLocation(line.replace(functionNameRegex,""));return new StackFrame({functionName,fileName:locationParts[0],lineNumber:locationParts[1],columnNumber:locationParts[2],source:line})}},this)},parseOpera:function ErrorStackParser$$parseOpera(e){if(!e.stacktrace||e.message.indexOf("\n")>-1&&e.message.split("\n").length>e.stacktrace.split("\n").length){return this.parseOpera9(e)}else if(!e.stack){return this.parseOpera10(e)}else{return this.parseOpera11(e)}},parseOpera9:function ErrorStackParser$$parseOpera9(e){var lineRE=/Line (\d+).*script (?:in )?(\S+)/i;var lines=e.message.split("\n");var result2=[];for(var i=2,len=lines.length;i<len;i+=2){var match=lineRE.exec(lines[i]);if(match){result2.push(new StackFrame({fileName:match[2],lineNumber:match[1],source:lines[i]}))}}return result2},parseOpera10:function ErrorStackParser$$parseOpera10(e){var lineRE=/Line (\d+).*script (?:in )?(\S+)(?:: In function (\S+))?$/i;var lines=e.stacktrace.split("\n");var result2=[];for(var i=0,len=lines.length;i<len;i+=2){var match=lineRE.exec(lines[i]);if(match){result2.push(new StackFrame({functionName:match[3]||void 0,fileName:match[2],lineNumber:match[1],source:lines[i]}))}}return result2},parseOpera11:function ErrorStackParser$$parseOpera11(error){var filtered=error.stack.split("\n").filter(function(line){return!!line.match(FIREFOX_SAFARI_STACK_REGEXP)&&!line.match(/^Error created at/)},this);return filtered.map(function(line){var tokens=line.split("@");var locationParts=this.extractLocation(tokens.pop());var functionCall=tokens.shift()||"";var functionName=functionCall.replace(/<anonymous function(: (\w+))?>/,"$2").replace(/\([^)]*\)/g,"")||void 0;var argsRaw;if(functionCall.match(/\(([^)]*)\)/)){argsRaw=functionCall.replace(/^[^(]+\(([^)]*)\)$/,"$1")}var args2=argsRaw===void 0||argsRaw==="[arguments not available]"?void 0:argsRaw.split(",");return new StackFrame({functionName,args:args2,fileName:locationParts[0],lineNumber:locationParts[1],columnNumber:locationParts[2],source:line})},this)}}})}});var require_base64=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/base64.js"(exports2){var intToCharMap="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");exports2.encode=function(number2){if(0<=number2&&number2<intToCharMap.length){return intToCharMap[number2]}throw new TypeError("Must be between 0 and 63: "+number2)};exports2.decode=function(charCode){var bigA=65;var bigZ=90;var littleA=97;var littleZ=122;var zero=48;var nine=57;var plus=43;var slash2=47;var littleOffset=26;var numberOffset=52;if(bigA<=charCode&&charCode<=bigZ){return charCode-bigA}if(littleA<=charCode&&charCode<=littleZ){return charCode-littleA+littleOffset}if(zero<=charCode&&charCode<=nine){return charCode-zero+numberOffset}if(charCode==plus){return 62}if(charCode==slash2){return 63}return-1}}});var require_base64_vlq=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/base64-vlq.js"(exports2){var base64=require_base64();var VLQ_BASE_SHIFT=5;var VLQ_BASE=1<<VLQ_BASE_SHIFT;var VLQ_BASE_MASK=VLQ_BASE-1;var VLQ_CONTINUATION_BIT=VLQ_BASE;function toVLQSigned(aValue){return aValue<0?(-aValue<<1)+1:(aValue<<1)+0}function fromVLQSigned(aValue){var isNegative=(aValue&1)===1;var shifted=aValue>>1;return isNegative?-shifted:shifted}exports2.encode=function base64VLQ_encode(aValue){var encoded="";var digit;var vlq=toVLQSigned(aValue);do{digit=vlq&VLQ_BASE_MASK;vlq>>>=VLQ_BASE_SHIFT;if(vlq>0){digit|=VLQ_CONTINUATION_BIT}encoded+=base64.encode(digit)}while(vlq>0);return encoded};exports2.decode=function base64VLQ_decode(aStr,aIndex,aOutParam){var strLen=aStr.length;var result2=0;var shift=0;var continuation,digit;do{if(aIndex>=strLen){throw new Error("Expected more digits in base 64 VLQ value.")}digit=base64.decode(aStr.charCodeAt(aIndex++));if(digit===-1){throw new Error("Invalid base64 digit: "+aStr.charAt(aIndex-1))}continuation=!!(digit&VLQ_CONTINUATION_BIT);digit&=VLQ_BASE_MASK;result2=result2+(digit<<shift);shift+=VLQ_BASE_SHIFT}while(continuation);aOutParam.value=fromVLQSigned(result2);aOutParam.rest=aIndex}}});var require_util=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/util.js"(exports2){function getArg(aArgs,aName,aDefaultValue){if(aName in aArgs){return aArgs[aName]}else if(arguments.length===3){return aDefaultValue}else{throw new Error('"'+aName+'" is a required argument.')}}exports2.getArg=getArg;var urlRegexp=/^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;var dataUrlRegexp=/^data:.+\,.+$/;function urlParse(aUrl){var match=aUrl.match(urlRegexp);if(!match){return null}return{scheme:match[1],auth:match[2],host:match[3],port:match[4],path:match[5]}}exports2.urlParse=urlParse;function urlGenerate(aParsedUrl){var url="";if(aParsedUrl.scheme){url+=aParsedUrl.scheme+":"}url+="//";if(aParsedUrl.auth){url+=aParsedUrl.auth+"@"}if(aParsedUrl.host){url+=aParsedUrl.host}if(aParsedUrl.port){url+=":"+aParsedUrl.port}if(aParsedUrl.path){url+=aParsedUrl.path}return url}exports2.urlGenerate=urlGenerate;function normalize(aPath){var path27=aPath;var url=urlParse(aPath);if(url){if(!url.path){return aPath}path27=url.path}var isAbsolute=exports2.isAbsolute(path27);var parts=path27.split(/\/+/);for(var part,up=0,i=parts.length-1;i>=0;i--){part=parts[i];if(part==="."){parts.splice(i,1)}else if(part===".."){up++}else if(up>0){if(part===""){parts.splice(i+1,up);up=0}else{parts.splice(i,2);up--}}}path27=parts.join("/");if(path27===""){path27=isAbsolute?"/":"."}if(url){url.path=path27;return urlGenerate(url)}return path27}exports2.normalize=normalize;function join4(aRoot,aPath){if(aRoot===""){aRoot="."}if(aPath===""){aPath="."}var aPathUrl=urlParse(aPath);var aRootUrl=urlParse(aRoot);if(aRootUrl){aRoot=aRootUrl.path||"/"}if(aPathUrl&&!aPathUrl.scheme){if(aRootUrl){aPathUrl.scheme=aRootUrl.scheme}return urlGenerate(aPathUrl)}if(aPathUrl||aPath.match(dataUrlRegexp)){return aPath}if(aRootUrl&&!aRootUrl.host&&!aRootUrl.path){aRootUrl.host=aPath;return urlGenerate(aRootUrl)}var joined=aPath.charAt(0)==="/"?aPath:normalize(aRoot.replace(/\/+$/,"")+"/"+aPath);if(aRootUrl){aRootUrl.path=joined;return urlGenerate(aRootUrl)}return joined}exports2.join=join4;exports2.isAbsolute=function(aPath){return aPath.charAt(0)==="/"||urlRegexp.test(aPath)};function relative3(aRoot,aPath){if(aRoot===""){aRoot="."}aRoot=aRoot.replace(/\/$/,"");var level=0;while(aPath.indexOf(aRoot+"/")!==0){var index=aRoot.lastIndexOf("/");if(index<0){return aPath}aRoot=aRoot.slice(0,index);if(aRoot.match(/^([^\/]+:\/)?\/*$/)){return aPath}++level}return Array(level+1).join("../")+aPath.substr(aRoot.length+1)}exports2.relative=relative3;var supportsNullProto=function(){var obj=Object.create(null);return!("__proto__"in obj)}();function identity2(s){return s}function toSetString(aStr){if(isProtoString(aStr)){return"$"+aStr}return aStr}exports2.toSetString=supportsNullProto?identity2:toSetString;function fromSetString(aStr){if(isProtoString(aStr)){return aStr.slice(1)}return aStr}exports2.fromSetString=supportsNullProto?identity2:fromSetString;function isProtoString(s){if(!s){return false}var length=s.length;if(length<9){return false}if(s.charCodeAt(length-1)!==95||s.charCodeAt(length-2)!==95||s.charCodeAt(length-3)!==111||s.charCodeAt(length-4)!==116||s.charCodeAt(length-5)!==111||s.charCodeAt(length-6)!==114||s.charCodeAt(length-7)!==112||s.charCodeAt(length-8)!==95||s.charCodeAt(length-9)!==95){return false}for(var i=length-10;i>=0;i--){if(s.charCodeAt(i)!==36){return false}}return true}function compareByOriginalPositions(mappingA,mappingB,onlyCompareOriginal){var cmp=strcmp(mappingA.source,mappingB.source);if(cmp!==0){return cmp}cmp=mappingA.originalLine-mappingB.originalLine;if(cmp!==0){return cmp}cmp=mappingA.originalColumn-mappingB.originalColumn;if(cmp!==0||onlyCompareOriginal){return cmp}cmp=mappingA.generatedColumn-mappingB.generatedColumn;if(cmp!==0){return cmp}cmp=mappingA.generatedLine-mappingB.generatedLine;if(cmp!==0){return cmp}return strcmp(mappingA.name,mappingB.name)}exports2.compareByOriginalPositions=compareByOriginalPositions;function compareByGeneratedPositionsDeflated(mappingA,mappingB,onlyCompareGenerated){var cmp=mappingA.generatedLine-mappingB.generatedLine;if(cmp!==0){return cmp}cmp=mappingA.generatedColumn-mappingB.generatedColumn;if(cmp!==0||onlyCompareGenerated){return cmp}cmp=strcmp(mappingA.source,mappingB.source);if(cmp!==0){return cmp}cmp=mappingA.originalLine-mappingB.originalLine;if(cmp!==0){return cmp}cmp=mappingA.originalColumn-mappingB.originalColumn;if(cmp!==0){return cmp}return strcmp(mappingA.name,mappingB.name)}exports2.compareByGeneratedPositionsDeflated=compareByGeneratedPositionsDeflated;function strcmp(aStr1,aStr2){if(aStr1===aStr2){return 0}if(aStr1===null){return 1}if(aStr2===null){return-1}if(aStr1>aStr2){return 1}return-1}function compareByGeneratedPositionsInflated(mappingA,mappingB){var cmp=mappingA.generatedLine-mappingB.generatedLine;if(cmp!==0){return cmp}cmp=mappingA.generatedColumn-mappingB.generatedColumn;if(cmp!==0){return cmp}cmp=strcmp(mappingA.source,mappingB.source);if(cmp!==0){return cmp}cmp=mappingA.originalLine-mappingB.originalLine;if(cmp!==0){return cmp}cmp=mappingA.originalColumn-mappingB.originalColumn;if(cmp!==0){return cmp}return strcmp(mappingA.name,mappingB.name)}exports2.compareByGeneratedPositionsInflated=compareByGeneratedPositionsInflated;function parseSourceMapInput(str2){return JSON.parse(str2.replace(/^\)]}'[^\n]*\n/,""))}exports2.parseSourceMapInput=parseSourceMapInput;function computeSourceURL(sourceRoot,sourceURL,sourceMapURL){sourceURL=sourceURL||"";if(sourceRoot){if(sourceRoot[sourceRoot.length-1]!=="/"&&sourceURL[0]!=="/"){sourceRoot+="/"}sourceURL=sourceRoot+sourceURL}if(sourceMapURL){var parsed=urlParse(sourceMapURL);if(!parsed){throw new Error("sourceMapURL could not be parsed")}if(parsed.path){var index=parsed.path.lastIndexOf("/");if(index>=0){parsed.path=parsed.path.substring(0,index+1)}}sourceURL=join4(urlGenerate(parsed),sourceURL)}return normalize(sourceURL)}exports2.computeSourceURL=computeSourceURL}});var require_array_set=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/array-set.js"(exports2){var util4=require_util();var has3=Object.prototype.hasOwnProperty;var hasNativeMap=typeof Map!=="undefined";function ArraySet(){this._array=[];this._set=hasNativeMap?new Map:Object.create(null)}ArraySet.fromArray=function ArraySet_fromArray(aArray,aAllowDuplicates){var set3=new ArraySet;for(var i=0,len=aArray.length;i<len;i++){set3.add(aArray[i],aAllowDuplicates)}return set3};ArraySet.prototype.size=function ArraySet_size(){return hasNativeMap?this._set.size:Object.getOwnPropertyNames(this._set).length};ArraySet.prototype.add=function ArraySet_add(aStr,aAllowDuplicates){var sStr=hasNativeMap?aStr:util4.toSetString(aStr);var isDuplicate=hasNativeMap?this.has(aStr):has3.call(this._set,sStr);var idx=this._array.length;if(!isDuplicate||aAllowDuplicates){this._array.push(aStr)}if(!isDuplicate){if(hasNativeMap){this._set.set(aStr,idx)}else{this._set[sStr]=idx}}};ArraySet.prototype.has=function ArraySet_has(aStr){if(hasNativeMap){return this._set.has(aStr)}else{var sStr=util4.toSetString(aStr);return has3.call(this._set,sStr)}};ArraySet.prototype.indexOf=function ArraySet_indexOf(aStr){if(hasNativeMap){var idx=this._set.get(aStr);if(idx>=0){return idx}}else{var sStr=util4.toSetString(aStr);if(has3.call(this._set,sStr)){return this._set[sStr]}}throw new Error('"'+aStr+'" is not in the set.')};ArraySet.prototype.at=function ArraySet_at(aIdx){if(aIdx>=0&&aIdx<this._array.length){return this._array[aIdx]}throw new Error("No element indexed by "+aIdx)};ArraySet.prototype.toArray=function ArraySet_toArray(){return this._array.slice()};exports2.ArraySet=ArraySet}});var require_mapping_list=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/mapping-list.js"(exports2){var util4=require_util();function generatedPositionAfter(mappingA,mappingB){var lineA=mappingA.generatedLine;var lineB=mappingB.generatedLine;var columnA=mappingA.generatedColumn;var columnB=mappingB.generatedColumn;return lineB>lineA||lineB==lineA&&columnB>=columnA||util4.compareByGeneratedPositionsInflated(mappingA,mappingB)<=0}function MappingList(){this._array=[];this._sorted=true;this._last={generatedLine:-1,generatedColumn:0}}MappingList.prototype.unsortedForEach=function MappingList_forEach(aCallback,aThisArg){this._array.forEach(aCallback,aThisArg)};MappingList.prototype.add=function MappingList_add(aMapping){if(generatedPositionAfter(this._last,aMapping)){this._last=aMapping;this._array.push(aMapping)}else{this._sorted=false;this._array.push(aMapping)}};MappingList.prototype.toArray=function MappingList_toArray(){if(!this._sorted){this._array.sort(util4.compareByGeneratedPositionsInflated);this._sorted=true}return this._array};exports2.MappingList=MappingList}});var require_source_map_generator=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/source-map-generator.js"(exports2){var base64VLQ=require_base64_vlq();var util4=require_util();var ArraySet=require_array_set().ArraySet;var MappingList=require_mapping_list().MappingList;function SourceMapGenerator(aArgs){if(!aArgs){aArgs={}}this._file=util4.getArg(aArgs,"file",null);this._sourceRoot=util4.getArg(aArgs,"sourceRoot",null);this._skipValidation=util4.getArg(aArgs,"skipValidation",false);this._sources=new ArraySet;this._names=new ArraySet;this._mappings=new MappingList;this._sourcesContents=null}SourceMapGenerator.prototype._version=3;SourceMapGenerator.fromSourceMap=function SourceMapGenerator_fromSourceMap(aSourceMapConsumer){var sourceRoot=aSourceMapConsumer.sourceRoot;var generator=new SourceMapGenerator({file:aSourceMapConsumer.file,sourceRoot});aSourceMapConsumer.eachMapping(function(mapping){var newMapping={generated:{line:mapping.generatedLine,column:mapping.generatedColumn}};if(mapping.source!=null){newMapping.source=mapping.source;if(sourceRoot!=null){newMapping.source=util4.relative(sourceRoot,newMapping.source)}newMapping.original={line:mapping.originalLine,column:mapping.originalColumn};if(mapping.name!=null){newMapping.name=mapping.name}}generator.addMapping(newMapping)});aSourceMapConsumer.sources.forEach(function(sourceFile){var sourceRelative=sourceFile;if(sourceRoot!==null){sourceRelative=util4.relative(sourceRoot,sourceFile)}if(!generator._sources.has(sourceRelative)){generator._sources.add(sourceRelative)}var content=aSourceMapConsumer.sourceContentFor(sourceFile);if(content!=null){generator.setSourceContent(sourceFile,content)}});return generator};SourceMapGenerator.prototype.addMapping=function SourceMapGenerator_addMapping(aArgs){var generated=util4.getArg(aArgs,"generated");var original=util4.getArg(aArgs,"original",null);var source=util4.getArg(aArgs,"source",null);var name=util4.getArg(aArgs,"name",null);if(!this._skipValidation){this._validateMapping(generated,original,source,name)}if(source!=null){source=String(source);if(!this._sources.has(source)){this._sources.add(source)}}if(name!=null){name=String(name);if(!this._names.has(name)){this._names.add(name)}}this._mappings.add({generatedLine:generated.line,generatedColumn:generated.column,originalLine:original!=null&&original.line,originalColumn:original!=null&&original.column,source,name})};SourceMapGenerator.prototype.setSourceContent=function SourceMapGenerator_setSourceContent(aSourceFile,aSourceContent){var source=aSourceFile;if(this._sourceRoot!=null){source=util4.relative(this._sourceRoot,source)}if(aSourceContent!=null){if(!this._sourcesContents){this._sourcesContents=Object.create(null)}this._sourcesContents[util4.toSetString(source)]=aSourceContent}else if(this._sourcesContents){delete this._sourcesContents[util4.toSetString(source)];if(Object.keys(this._sourcesContents).length===0){this._sourcesContents=null}}};SourceMapGenerator.prototype.applySourceMap=function SourceMapGenerator_applySourceMap(aSourceMapConsumer,aSourceFile,aSourceMapPath){var sourceFile=aSourceFile;if(aSourceFile==null){if(aSourceMapConsumer.file==null){throw new Error(`SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`)}sourceFile=aSourceMapConsumer.file}var sourceRoot=this._sourceRoot;if(sourceRoot!=null){sourceFile=util4.relative(sourceRoot,sourceFile)}var newSources=new ArraySet;var newNames=new ArraySet;this._mappings.unsortedForEach(function(mapping){if(mapping.source===sourceFile&&mapping.originalLine!=null){var original=aSourceMapConsumer.originalPositionFor({line:mapping.originalLine,column:mapping.originalColumn});if(original.source!=null){mapping.source=original.source;if(aSourceMapPath!=null){mapping.source=util4.join(aSourceMapPath,mapping.source)}if(sourceRoot!=null){mapping.source=util4.relative(sourceRoot,mapping.source)}mapping.originalLine=original.line;mapping.originalColumn=original.column;if(original.name!=null){mapping.name=original.name}}}var source=mapping.source;if(source!=null&&!newSources.has(source)){newSources.add(source)}var name=mapping.name;if(name!=null&&!newNames.has(name)){newNames.add(name)}},this);this._sources=newSources;this._names=newNames;aSourceMapConsumer.sources.forEach(function(sourceFile2){var content=aSourceMapConsumer.sourceContentFor(sourceFile2);if(content!=null){if(aSourceMapPath!=null){sourceFile2=util4.join(aSourceMapPath,sourceFile2)}if(sourceRoot!=null){sourceFile2=util4.relative(sourceRoot,sourceFile2)}this.setSourceContent(sourceFile2,content)}},this)};SourceMapGenerator.prototype._validateMapping=function SourceMapGenerator_validateMapping(aGenerated,aOriginal,aSource,aName){if(aOriginal&&typeof aOriginal.line!=="number"&&typeof aOriginal.column!=="number"){throw new Error("original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.")}if(aGenerated&&"line"in aGenerated&&"column"in aGenerated&&aGenerated.line>0&&aGenerated.column>=0&&!aOriginal&&!aSource&&!aName){return}else if(aGenerated&&"line"in aGenerated&&"column"in aGenerated&&aOriginal&&"line"in aOriginal&&"column"in aOriginal&&aGenerated.line>0&&aGenerated.column>=0&&aOriginal.line>0&&aOriginal.column>=0&&aSource){return}else{throw new Error("Invalid mapping: "+JSON.stringify({generated:aGenerated,source:aSource,original:aOriginal,name:aName}))}};SourceMapGenerator.prototype._serializeMappings=function SourceMapGenerator_serializeMappings(){var previousGeneratedColumn=0;var previousGeneratedLine=1;var previousOriginalColumn=0;var previousOriginalLine=0;var previousName=0;var previousSource=0;var result2="";var next;var mapping;var nameIdx;var sourceIdx;var mappings=this._mappings.toArray();for(var i=0,len=mappings.length;i<len;i++){mapping=mappings[i];next="";if(mapping.generatedLine!==previousGeneratedLine){previousGeneratedColumn=0;while(mapping.generatedLine!==previousGeneratedLine){next+=";";previousGeneratedLine++}}else{if(i>0){if(!util4.compareByGeneratedPositionsInflated(mapping,mappings[i-1])){continue}next+=","}}next+=base64VLQ.encode(mapping.generatedColumn-previousGeneratedColumn);previousGeneratedColumn=mapping.generatedColumn;if(mapping.source!=null){sourceIdx=this._sources.indexOf(mapping.source);next+=base64VLQ.encode(sourceIdx-previousSource);previousSource=sourceIdx;next+=base64VLQ.encode(mapping.originalLine-1-previousOriginalLine);previousOriginalLine=mapping.originalLine-1;next+=base64VLQ.encode(mapping.originalColumn-previousOriginalColumn);previousOriginalColumn=mapping.originalColumn;if(mapping.name!=null){nameIdx=this._names.indexOf(mapping.name);next+=base64VLQ.encode(nameIdx-previousName);previousName=nameIdx}}result2+=next}return result2};SourceMapGenerator.prototype._generateSourcesContent=function SourceMapGenerator_generateSourcesContent(aSources,aSourceRoot){return aSources.map(function(source){if(!this._sourcesContents){return null}if(aSourceRoot!=null){source=util4.relative(aSourceRoot,source)}var key=util4.toSetString(source);return Object.prototype.hasOwnProperty.call(this._sourcesContents,key)?this._sourcesContents[key]:null},this)};SourceMapGenerator.prototype.toJSON=function SourceMapGenerator_toJSON(){var map3={version:this._version,sources:this._sources.toArray(),names:this._names.toArray(),mappings:this._serializeMappings()};if(this._file!=null){map3.file=this._file}if(this._sourceRoot!=null){map3.sourceRoot=this._sourceRoot}if(this._sourcesContents){map3.sourcesContent=this._generateSourcesContent(map3.sources,map3.sourceRoot)}return map3};SourceMapGenerator.prototype.toString=function SourceMapGenerator_toString(){return JSON.stringify(this.toJSON())};exports2.SourceMapGenerator=SourceMapGenerator}});var require_binary_search=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/binary-search.js"(exports2){exports2.GREATEST_LOWER_BOUND=1;exports2.LEAST_UPPER_BOUND=2;function recursiveSearch(aLow,aHigh,aNeedle,aHaystack,aCompare,aBias){var mid=Math.floor((aHigh-aLow)/2)+aLow;var cmp=aCompare(aNeedle,aHaystack[mid],true);if(cmp===0){return mid}else if(cmp>0){if(aHigh-mid>1){return recursiveSearch(mid,aHigh,aNeedle,aHaystack,aCompare,aBias)}if(aBias==exports2.LEAST_UPPER_BOUND){return aHigh<aHaystack.length?aHigh:-1}else{return mid}}else{if(mid-aLow>1){return recursiveSearch(aLow,mid,aNeedle,aHaystack,aCompare,aBias)}if(aBias==exports2.LEAST_UPPER_BOUND){return mid}else{return aLow<0?-1:aLow}}}exports2.search=function search2(aNeedle,aHaystack,aCompare,aBias){if(aHaystack.length===0){return-1}var index=recursiveSearch(-1,aHaystack.length,aNeedle,aHaystack,aCompare,aBias||exports2.GREATEST_LOWER_BOUND);if(index<0){return-1}while(index-1>=0){if(aCompare(aHaystack[index],aHaystack[index-1],true)!==0){break}--index}return index}}});var require_quick_sort=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/quick-sort.js"(exports2){function swap2(ary2,x,y){var temp=ary2[x];ary2[x]=ary2[y];ary2[y]=temp}function randomIntInRange(low,high){return Math.round(low+Math.random()*(high-low))}function doQuickSort(ary2,comparator,p,r){if(p<r){var pivotIndex=randomIntInRange(p,r);var i=p-1;swap2(ary2,pivotIndex,r);var pivot=ary2[r];for(var j=p;j<r;j++){if(comparator(ary2[j],pivot)<=0){i+=1;swap2(ary2,i,j)}}swap2(ary2,i+1,j);var q=i+1;doQuickSort(ary2,comparator,p,q-1);doQuickSort(ary2,comparator,q+1,r)}}exports2.quickSort=function(ary2,comparator){doQuickSort(ary2,comparator,0,ary2.length-1)}}});var require_source_map_consumer=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/source-map-consumer.js"(exports2){var util4=require_util();var binarySearch=require_binary_search();var ArraySet=require_array_set().ArraySet;var base64VLQ=require_base64_vlq();var quickSort=require_quick_sort().quickSort;function SourceMapConsumer(aSourceMap,aSourceMapURL){var sourceMap=aSourceMap;if(typeof aSourceMap==="string"){sourceMap=util4.parseSourceMapInput(aSourceMap)}return sourceMap.sections!=null?new IndexedSourceMapConsumer(sourceMap,aSourceMapURL):new BasicSourceMapConsumer(sourceMap,aSourceMapURL)}SourceMapConsumer.fromSourceMap=function(aSourceMap,aSourceMapURL){return BasicSourceMapConsumer.fromSourceMap(aSourceMap,aSourceMapURL)};SourceMapConsumer.prototype._version=3;SourceMapConsumer.prototype.__generatedMappings=null;Object.defineProperty(SourceMapConsumer.prototype,"_generatedMappings",{configurable:true,enumerable:true,get:function(){if(!this.__generatedMappings){this._parseMappings(this._mappings,this.sourceRoot)}return this.__generatedMappings}});SourceMapConsumer.prototype.__originalMappings=null;Object.defineProperty(SourceMapConsumer.prototype,"_originalMappings",{configurable:true,enumerable:true,get:function(){if(!this.__originalMappings){this._parseMappings(this._mappings,this.sourceRoot)}return this.__originalMappings}});SourceMapConsumer.prototype._charIsMappingSeparator=function SourceMapConsumer_charIsMappingSeparator(aStr,index){var c=aStr.charAt(index);return c===";"||c===","};SourceMapConsumer.prototype._parseMappings=function SourceMapConsumer_parseMappings(aStr,aSourceRoot){throw new Error("Subclasses must implement _parseMappings")};SourceMapConsumer.GENERATED_ORDER=1;SourceMapConsumer.ORIGINAL_ORDER=2;SourceMapConsumer.GREATEST_LOWER_BOUND=1;SourceMapConsumer.LEAST_UPPER_BOUND=2;SourceMapConsumer.prototype.eachMapping=function SourceMapConsumer_eachMapping(aCallback,aContext,aOrder){var context=aContext||null;var order=aOrder||SourceMapConsumer.GENERATED_ORDER;var mappings;switch(order){case SourceMapConsumer.GENERATED_ORDER:mappings=this._generatedMappings;break;case SourceMapConsumer.ORIGINAL_ORDER:mappings=this._originalMappings;break;default:throw new Error("Unknown order of iteration.")}var sourceRoot=this.sourceRoot;mappings.map(function(mapping){var source=mapping.source===null?null:this._sources.at(mapping.source);source=util4.computeSourceURL(sourceRoot,source,this._sourceMapURL);return{source,generatedLine:mapping.generatedLine,generatedColumn:mapping.generatedColumn,originalLine:mapping.originalLine,originalColumn:mapping.originalColumn,name:mapping.name===null?null:this._names.at(mapping.name)}},this).forEach(aCallback,context)};SourceMapConsumer.prototype.allGeneratedPositionsFor=function SourceMapConsumer_allGeneratedPositionsFor(aArgs){var line=util4.getArg(aArgs,"line");var needle={source:util4.getArg(aArgs,"source"),originalLine:line,originalColumn:util4.getArg(aArgs,"column",0)};needle.source=this._findSourceIndex(needle.source);if(needle.source<0){return[]}var mappings=[];var index=this._findMapping(needle,this._originalMappings,"originalLine","originalColumn",util4.compareByOriginalPositions,binarySearch.LEAST_UPPER_BOUND);if(index>=0){var mapping=this._originalMappings[index];if(aArgs.column===void 0){var originalLine=mapping.originalLine;while(mapping&&mapping.originalLine===originalLine){mappings.push({line:util4.getArg(mapping,"generatedLine",null),column:util4.getArg(mapping,"generatedColumn",null),lastColumn:util4.getArg(mapping,"lastGeneratedColumn",null)});mapping=this._originalMappings[++index]}}else{var originalColumn=mapping.originalColumn;while(mapping&&mapping.originalLine===line&&mapping.originalColumn==originalColumn){mappings.push({line:util4.getArg(mapping,"generatedLine",null),column:util4.getArg(mapping,"generatedColumn",null),lastColumn:util4.getArg(mapping,"lastGeneratedColumn",null)});mapping=this._originalMappings[++index]}}}return mappings};exports2.SourceMapConsumer=SourceMapConsumer;function BasicSourceMapConsumer(aSourceMap,aSourceMapURL){var sourceMap=aSourceMap;if(typeof aSourceMap==="string"){sourceMap=util4.parseSourceMapInput(aSourceMap)}var version=util4.getArg(sourceMap,"version");var sources=util4.getArg(sourceMap,"sources");var names2=util4.getArg(sourceMap,"names",[]);var sourceRoot=util4.getArg(sourceMap,"sourceRoot",null);var sourcesContent=util4.getArg(sourceMap,"sourcesContent",null);var mappings=util4.getArg(sourceMap,"mappings");var file=util4.getArg(sourceMap,"file",null);if(version!=this._version){throw new Error("Unsupported version: "+version)}if(sourceRoot){sourceRoot=util4.normalize(sourceRoot)}sources=sources.map(String).map(util4.normalize).map(function(source){return sourceRoot&&util4.isAbsolute(sourceRoot)&&util4.isAbsolute(source)?util4.relative(sourceRoot,source):source});this._names=ArraySet.fromArray(names2.map(String),true);this._sources=ArraySet.fromArray(sources,true);this._absoluteSources=this._sources.toArray().map(function(s){return util4.computeSourceURL(sourceRoot,s,aSourceMapURL)});this.sourceRoot=sourceRoot;this.sourcesContent=sourcesContent;this._mappings=mappings;this._sourceMapURL=aSourceMapURL;this.file=file}BasicSourceMapConsumer.prototype=Object.create(SourceMapConsumer.prototype);BasicSourceMapConsumer.prototype.consumer=SourceMapConsumer;BasicSourceMapConsumer.prototype._findSourceIndex=function(aSource){var relativeSource=aSource;if(this.sourceRoot!=null){relativeSource=util4.relative(this.sourceRoot,relativeSource)}if(this._sources.has(relativeSource)){return this._sources.indexOf(relativeSource)}var i;for(i=0;i<this._absoluteSources.length;++i){if(this._absoluteSources[i]==aSource){return i}}return-1};BasicSourceMapConsumer.fromSourceMap=function SourceMapConsumer_fromSourceMap(aSourceMap,aSourceMapURL){var smc=Object.create(BasicSourceMapConsumer.prototype);var names2=smc._names=ArraySet.fromArray(aSourceMap._names.toArray(),true);var sources=smc._sources=ArraySet.fromArray(aSourceMap._sources.toArray(),true);smc.sourceRoot=aSourceMap._sourceRoot;smc.sourcesContent=aSourceMap._generateSourcesContent(smc._sources.toArray(),smc.sourceRoot);smc.file=aSourceMap._file;smc._sourceMapURL=aSourceMapURL;smc._absoluteSources=smc._sources.toArray().map(function(s){return util4.computeSourceURL(smc.sourceRoot,s,aSourceMapURL)});var generatedMappings=aSourceMap._mappings.toArray().slice();var destGeneratedMappings=smc.__generatedMappings=[];var destOriginalMappings=smc.__originalMappings=[];for(var i=0,length=generatedMappings.length;i<length;i++){var srcMapping=generatedMappings[i];var destMapping=new Mapping;destMapping.generatedLine=srcMapping.generatedLine;destMapping.generatedColumn=srcMapping.generatedColumn;if(srcMapping.source){destMapping.source=sources.indexOf(srcMapping.source);destMapping.originalLine=srcMapping.originalLine;destMapping.originalColumn=srcMapping.originalColumn;if(srcMapping.name){destMapping.name=names2.indexOf(srcMapping.name)}destOriginalMappings.push(destMapping)}destGeneratedMappings.push(destMapping)}quickSort(smc.__originalMappings,util4.compareByOriginalPositions);return smc};BasicSourceMapConsumer.prototype._version=3;Object.defineProperty(BasicSourceMapConsumer.prototype,"sources",{get:function(){return this._absoluteSources.slice()}});function Mapping(){this.generatedLine=0;this.generatedColumn=0;this.source=null;this.originalLine=null;this.originalColumn=null;this.name=null}BasicSourceMapConsumer.prototype._parseMappings=function SourceMapConsumer_parseMappings(aStr,aSourceRoot){var generatedLine=1;var previousGeneratedColumn=0;var previousOriginalLine=0;var previousOriginalColumn=0;var previousSource=0;var previousName=0;var length=aStr.length;var index=0;var cachedSegments={};var temp={};var originalMappings=[];var generatedMappings=[];var mapping,str2,segment,end,value;while(index<length){if(aStr.charAt(index)===";"){generatedLine++;index++;previousGeneratedColumn=0}else if(aStr.charAt(index)===","){index++}else{mapping=new Mapping;mapping.generatedLine=generatedLine;for(end=index;end<length;end++){if(this._charIsMappingSeparator(aStr,end)){break}}str2=aStr.slice(index,end);segment=cachedSegments[str2];if(segment){index+=str2.length}else{segment=[];while(index<end){base64VLQ.decode(aStr,index,temp);value=temp.value;index=temp.rest;segment.push(value)}if(segment.length===2){throw new Error("Found a source, but no line and column")}if(segment.length===3){throw new Error("Found a source and line, but no column")}cachedSegments[str2]=segment}mapping.generatedColumn=previousGeneratedColumn+segment[0];previousGeneratedColumn=mapping.generatedColumn;if(segment.length>1){mapping.source=previousSource+segment[1];previousSource+=segment[1];mapping.originalLine=previousOriginalLine+segment[2];previousOriginalLine=mapping.originalLine;mapping.originalLine+=1;mapping.originalColumn=previousOriginalColumn+segment[3];previousOriginalColumn=mapping.originalColumn;if(segment.length>4){mapping.name=previousName+segment[4];previousName+=segment[4]}}generatedMappings.push(mapping);if(typeof mapping.originalLine==="number"){originalMappings.push(mapping)}}}quickSort(generatedMappings,util4.compareByGeneratedPositionsDeflated);this.__generatedMappings=generatedMappings;quickSort(originalMappings,util4.compareByOriginalPositions);this.__originalMappings=originalMappings};BasicSourceMapConsumer.prototype._findMapping=function SourceMapConsumer_findMapping(aNeedle,aMappings,aLineName,aColumnName,aComparator,aBias){if(aNeedle[aLineName]<=0){throw new TypeError("Line must be greater than or equal to 1, got "+aNeedle[aLineName])}if(aNeedle[aColumnName]<0){throw new TypeError("Column must be greater than or equal to 0, got "+aNeedle[aColumnName])}return binarySearch.search(aNeedle,aMappings,aComparator,aBias)};BasicSourceMapConsumer.prototype.computeColumnSpans=function SourceMapConsumer_computeColumnSpans(){for(var index=0;index<this._generatedMappings.length;++index){var mapping=this._generatedMappings[index];if(index+1<this._generatedMappings.length){var nextMapping=this._generatedMappings[index+1];if(mapping.generatedLine===nextMapping.generatedLine){mapping.lastGeneratedColumn=nextMapping.generatedColumn-1;continue}}mapping.lastGeneratedColumn=Infinity}};BasicSourceMapConsumer.prototype.originalPositionFor=function SourceMapConsumer_originalPositionFor(aArgs){var needle={generatedLine:util4.getArg(aArgs,"line"),generatedColumn:util4.getArg(aArgs,"column")};var index=this._findMapping(needle,this._generatedMappings,"generatedLine","generatedColumn",util4.compareByGeneratedPositionsDeflated,util4.getArg(aArgs,"bias",SourceMapConsumer.GREATEST_LOWER_BOUND));if(index>=0){var mapping=this._generatedMappings[index];if(mapping.generatedLine===needle.generatedLine){var source=util4.getArg(mapping,"source",null);if(source!==null){source=this._sources.at(source);source=util4.computeSourceURL(this.sourceRoot,source,this._sourceMapURL)}var name=util4.getArg(mapping,"name",null);if(name!==null){name=this._names.at(name)}return{source,line:util4.getArg(mapping,"originalLine",null),column:util4.getArg(mapping,"originalColumn",null),name}}}return{source:null,line:null,column:null,name:null}};BasicSourceMapConsumer.prototype.hasContentsOfAllSources=function BasicSourceMapConsumer_hasContentsOfAllSources(){if(!this.sourcesContent){return false}return this.sourcesContent.length>=this._sources.size()&&!this.sourcesContent.some(function(sc){return sc==null})};BasicSourceMapConsumer.prototype.sourceContentFor=function SourceMapConsumer_sourceContentFor(aSource,nullOnMissing){if(!this.sourcesContent){return null}var index=this._findSourceIndex(aSource);if(index>=0){return this.sourcesContent[index]}var relativeSource=aSource;if(this.sourceRoot!=null){relativeSource=util4.relative(this.sourceRoot,relativeSource)}var url;if(this.sourceRoot!=null&&(url=util4.urlParse(this.sourceRoot))){var fileUriAbsPath=relativeSource.replace(/^file:\/\//,"");if(url.scheme=="file"&&this._sources.has(fileUriAbsPath)){return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]}if((!url.path||url.path=="/")&&this._sources.has("/"+relativeSource)){return this.sourcesContent[this._sources.indexOf("/"+relativeSource)]}}if(nullOnMissing){return null}else{throw new Error('"'+relativeSource+'" is not in the SourceMap.')}};BasicSourceMapConsumer.prototype.generatedPositionFor=function SourceMapConsumer_generatedPositionFor(aArgs){var source=util4.getArg(aArgs,"source");source=this._findSourceIndex(source);if(source<0){return{line:null,column:null,lastColumn:null}}var needle={source,originalLine:util4.getArg(aArgs,"line"),originalColumn:util4.getArg(aArgs,"column")};var index=this._findMapping(needle,this._originalMappings,"originalLine","originalColumn",util4.compareByOriginalPositions,util4.getArg(aArgs,"bias",SourceMapConsumer.GREATEST_LOWER_BOUND));if(index>=0){var mapping=this._originalMappings[index];if(mapping.source===needle.source){return{line:util4.getArg(mapping,"generatedLine",null),column:util4.getArg(mapping,"generatedColumn",null),lastColumn:util4.getArg(mapping,"lastGeneratedColumn",null)}}}return{line:null,column:null,lastColumn:null}};exports2.BasicSourceMapConsumer=BasicSourceMapConsumer;function IndexedSourceMapConsumer(aSourceMap,aSourceMapURL){var sourceMap=aSourceMap;if(typeof aSourceMap==="string"){sourceMap=util4.parseSourceMapInput(aSourceMap)}var version=util4.getArg(sourceMap,"version");var sections=util4.getArg(sourceMap,"sections");if(version!=this._version){throw new Error("Unsupported version: "+version)}this._sources=new ArraySet;this._names=new ArraySet;var lastOffset={line:-1,column:0};this._sections=sections.map(function(s){if(s.url){throw new Error("Support for url field in sections not implemented.")}var offset=util4.getArg(s,"offset");var offsetLine=util4.getArg(offset,"line");var offsetColumn=util4.getArg(offset,"column");if(offsetLine<lastOffset.line||offsetLine===lastOffset.line&&offsetColumn<lastOffset.column){throw new Error("Section offsets must be ordered and non-overlapping.")}lastOffset=offset;return{generatedOffset:{generatedLine:offsetLine+1,generatedColumn:offsetColumn+1},consumer:new SourceMapConsumer(util4.getArg(s,"map"),aSourceMapURL)}})}IndexedSourceMapConsumer.prototype=Object.create(SourceMapConsumer.prototype);IndexedSourceMapConsumer.prototype.constructor=SourceMapConsumer;IndexedSourceMapConsumer.prototype._version=3;Object.defineProperty(IndexedSourceMapConsumer.prototype,"sources",{get:function(){var sources=[];for(var i=0;i<this._sections.length;i++){for(var j=0;j<this._sections[i].consumer.sources.length;j++){sources.push(this._sections[i].consumer.sources[j])}}return sources}});IndexedSourceMapConsumer.prototype.originalPositionFor=function IndexedSourceMapConsumer_originalPositionFor(aArgs){var needle={generatedLine:util4.getArg(aArgs,"line"),generatedColumn:util4.getArg(aArgs,"column")};var sectionIndex=binarySearch.search(needle,this._sections,function(needle2,section2){var cmp=needle2.generatedLine-section2.generatedOffset.generatedLine;if(cmp){return cmp}return needle2.generatedColumn-section2.generatedOffset.generatedColumn});var section=this._sections[sectionIndex];if(!section){return{source:null,line:null,column:null,name:null}}return section.consumer.originalPositionFor({line:needle.generatedLine-(section.generatedOffset.generatedLine-1),column:needle.generatedColumn-(section.generatedOffset.generatedLine===needle.generatedLine?section.generatedOffset.generatedColumn-1:0),bias:aArgs.bias})};IndexedSourceMapConsumer.prototype.hasContentsOfAllSources=function IndexedSourceMapConsumer_hasContentsOfAllSources(){return this._sections.every(function(s){return s.consumer.hasContentsOfAllSources()})};IndexedSourceMapConsumer.prototype.sourceContentFor=function IndexedSourceMapConsumer_sourceContentFor(aSource,nullOnMissing){for(var i=0;i<this._sections.length;i++){var section=this._sections[i];var content=section.consumer.sourceContentFor(aSource,true);if(content){return content}}if(nullOnMissing){return null}else{throw new Error('"'+aSource+'" is not in the SourceMap.')}};IndexedSourceMapConsumer.prototype.generatedPositionFor=function IndexedSourceMapConsumer_generatedPositionFor(aArgs){for(var i=0;i<this._sections.length;i++){var section=this._sections[i];if(section.consumer._findSourceIndex(util4.getArg(aArgs,"source"))===-1){continue}var generatedPosition=section.consumer.generatedPositionFor(aArgs);if(generatedPosition){var ret={line:generatedPosition.line+(section.generatedOffset.generatedLine-1),column:generatedPosition.column+(section.generatedOffset.generatedLine===generatedPosition.line?section.generatedOffset.generatedColumn-1:0)};return ret}}return{line:null,column:null}};IndexedSourceMapConsumer.prototype._parseMappings=function IndexedSourceMapConsumer_parseMappings(aStr,aSourceRoot){this.__generatedMappings=[];this.__originalMappings=[];for(var i=0;i<this._sections.length;i++){var section=this._sections[i];var sectionMappings=section.consumer._generatedMappings;for(var j=0;j<sectionMappings.length;j++){var mapping=sectionMappings[j];var source=section.consumer._sources.at(mapping.source);source=util4.computeSourceURL(section.consumer.sourceRoot,source,this._sourceMapURL);this._sources.add(source);source=this._sources.indexOf(source);var name=null;if(mapping.name){name=section.consumer._names.at(mapping.name);this._names.add(name);name=this._names.indexOf(name)}var adjustedMapping={source,generatedLine:mapping.generatedLine+(section.generatedOffset.generatedLine-1),generatedColumn:mapping.generatedColumn+(section.generatedOffset.generatedLine===mapping.generatedLine?section.generatedOffset.generatedColumn-1:0),originalLine:mapping.originalLine,originalColumn:mapping.originalColumn,name};this.__generatedMappings.push(adjustedMapping);if(typeof adjustedMapping.originalLine==="number"){this.__originalMappings.push(adjustedMapping)}}}quickSort(this.__generatedMappings,util4.compareByGeneratedPositionsDeflated);quickSort(this.__originalMappings,util4.compareByOriginalPositions)};exports2.IndexedSourceMapConsumer=IndexedSourceMapConsumer}});var require_source_node=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/source-node.js"(exports2){var SourceMapGenerator=require_source_map_generator().SourceMapGenerator;var util4=require_util();var REGEX_NEWLINE=/(\r?\n)/;var NEWLINE_CODE=10;var isSourceNode="$$$isSourceNode$$$";function SourceNode(aLine,aColumn,aSource,aChunks,aName){this.children=[];this.sourceContents={};this.line=aLine==null?null:aLine;this.column=aColumn==null?null:aColumn;this.source=aSource==null?null:aSource;this.name=aName==null?null:aName;this[isSourceNode]=true;if(aChunks!=null)this.add(aChunks)}SourceNode.fromStringWithSourceMap=function SourceNode_fromStringWithSourceMap(aGeneratedCode,aSourceMapConsumer,aRelativePath){var node=new SourceNode;var remainingLines=aGeneratedCode.split(REGEX_NEWLINE);var remainingLinesIndex=0;var shiftNextLine=function(){var lineContents=getNextLine();var newLine=getNextLine()||"";return lineContents+newLine;function getNextLine(){return remainingLinesIndex<remainingLines.length?remainingLines[remainingLinesIndex++]:void 0}};var lastGeneratedLine=1,lastGeneratedColumn=0;var lastMapping=null;aSourceMapConsumer.eachMapping(function(mapping){if(lastMapping!==null){if(lastGeneratedLine<mapping.generatedLine){addMappingWithCode(lastMapping,shiftNextLine());lastGeneratedLine++;lastGeneratedColumn=0}else{var nextLine=remainingLines[remainingLinesIndex]||"";var code=nextLine.substr(0,mapping.generatedColumn-lastGeneratedColumn);remainingLines[remainingLinesIndex]=nextLine.substr(mapping.generatedColumn-lastGeneratedColumn);lastGeneratedColumn=mapping.generatedColumn;addMappingWithCode(lastMapping,code);lastMapping=mapping;return}}while(lastGeneratedLine<mapping.generatedLine){node.add(shiftNextLine());lastGeneratedLine++}if(lastGeneratedColumn<mapping.generatedColumn){var nextLine=remainingLines[remainingLinesIndex]||"";node.add(nextLine.substr(0,mapping.generatedColumn));remainingLines[remainingLinesIndex]=nextLine.substr(mapping.generatedColumn);lastGeneratedColumn=mapping.generatedColumn}lastMapping=mapping},this);if(remainingLinesIndex<remainingLines.length){if(lastMapping){addMappingWithCode(lastMapping,shiftNextLine())}node.add(remainingLines.splice(remainingLinesIndex).join(""))}aSourceMapConsumer.sources.forEach(function(sourceFile){var content=aSourceMapConsumer.sourceContentFor(sourceFile);if(content!=null){if(aRelativePath!=null){sourceFile=util4.join(aRelativePath,sourceFile)}node.setSourceContent(sourceFile,content)}});return node;function addMappingWithCode(mapping,code){if(mapping===null||mapping.source===void 0){node.add(code)}else{var source=aRelativePath?util4.join(aRelativePath,mapping.source):mapping.source;node.add(new SourceNode(mapping.originalLine,mapping.originalColumn,source,code,mapping.name))}}};SourceNode.prototype.add=function SourceNode_add(aChunk){if(Array.isArray(aChunk)){aChunk.forEach(function(chunk2){this.add(chunk2)},this)}else if(aChunk[isSourceNode]||typeof aChunk==="string"){if(aChunk){this.children.push(aChunk)}}else{throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got "+aChunk)}return this};SourceNode.prototype.prepend=function SourceNode_prepend(aChunk){if(Array.isArray(aChunk)){for(var i=aChunk.length-1;i>=0;i--){this.prepend(aChunk[i])}}else if(aChunk[isSourceNode]||typeof aChunk==="string"){this.children.unshift(aChunk)}else{throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got "+aChunk)}return this};SourceNode.prototype.walk=function SourceNode_walk(aFn){var chunk2;for(var i=0,len=this.children.length;i<len;i++){chunk2=this.children[i];if(chunk2[isSourceNode]){chunk2.walk(aFn)}else{if(chunk2!==""){aFn(chunk2,{source:this.source,line:this.line,column:this.column,name:this.name})}}}};SourceNode.prototype.join=function SourceNode_join(aSep){var newChildren;var i;var len=this.children.length;if(len>0){newChildren=[];for(i=0;i<len-1;i++){newChildren.push(this.children[i]);newChildren.push(aSep)}newChildren.push(this.children[i]);this.children=newChildren}return this};SourceNode.prototype.replaceRight=function SourceNode_replaceRight(aPattern,aReplacement){var lastChild=this.children[this.children.length-1];if(lastChild[isSourceNode]){lastChild.replaceRight(aPattern,aReplacement)}else if(typeof lastChild==="string"){this.children[this.children.length-1]=lastChild.replace(aPattern,aReplacement)}else{this.children.push("".replace(aPattern,aReplacement))}return this};SourceNode.prototype.setSourceContent=function SourceNode_setSourceContent(aSourceFile,aSourceContent){this.sourceContents[util4.toSetString(aSourceFile)]=aSourceContent};SourceNode.prototype.walkSourceContents=function SourceNode_walkSourceContents(aFn){for(var i=0,len=this.children.length;i<len;i++){if(this.children[i][isSourceNode]){this.children[i].walkSourceContents(aFn)}}var sources=Object.keys(this.sourceContents);for(var i=0,len=sources.length;i<len;i++){aFn(util4.fromSetString(sources[i]),this.sourceContents[sources[i]])}};SourceNode.prototype.toString=function SourceNode_toString(){var str2="";this.walk(function(chunk2){str2+=chunk2});return str2};SourceNode.prototype.toStringWithSourceMap=function SourceNode_toStringWithSourceMap(aArgs){var generated={code:"",line:1,column:0};var map3=new SourceMapGenerator(aArgs);var sourceMappingActive=false;var lastOriginalSource=null;var lastOriginalLine=null;var lastOriginalColumn=null;var lastOriginalName=null;this.walk(function(chunk2,original){generated.code+=chunk2;if(original.source!==null&&original.line!==null&&original.column!==null){if(lastOriginalSource!==original.source||lastOriginalLine!==original.line||lastOriginalColumn!==original.column||lastOriginalName!==original.name){map3.addMapping({source:original.source,original:{line:original.line,column:original.column},generated:{line:generated.line,column:generated.column},name:original.name})}lastOriginalSource=original.source;lastOriginalLine=original.line;lastOriginalColumn=original.column;lastOriginalName=original.name;sourceMappingActive=true}else if(sourceMappingActive){map3.addMapping({generated:{line:generated.line,column:generated.column}});lastOriginalSource=null;sourceMappingActive=false}for(var idx=0,length=chunk2.length;idx<length;idx++){if(chunk2.charCodeAt(idx)===NEWLINE_CODE){generated.line++;generated.column=0;if(idx+1===length){lastOriginalSource=null;sourceMappingActive=false}else if(sourceMappingActive){map3.addMapping({source:original.source,original:{line:original.line,column:original.column},generated:{line:generated.line,column:generated.column},name:original.name})}}else{generated.column++}}});this.walkSourceContents(function(sourceFile,sourceContent){map3.setSourceContent(sourceFile,sourceContent)});return{code:generated.code,map:map3}};exports2.SourceNode=SourceNode}});var require_source_map=__commonJS({"node_modules/source-map-support/node_modules/source-map/source-map.js"(exports2){exports2.SourceMapGenerator=require_source_map_generator().SourceMapGenerator;exports2.SourceMapConsumer=require_source_map_consumer().SourceMapConsumer;exports2.SourceNode=require_source_node().SourceNode}});var require_buffer_from=__commonJS({"node_modules/buffer-from/index.js"(exports2,module2){var toString5=Object.prototype.toString;var isModern=typeof Buffer!=="undefined"&&typeof Buffer.alloc==="function"&&typeof Buffer.allocUnsafe==="function"&&typeof Buffer.from==="function";function isArrayBuffer2(input){return toString5.call(input).slice(8,-1)==="ArrayBuffer"}function fromArrayBuffer(obj,byteOffset,length){byteOffset>>>=0;var maxLength=obj.byteLength-byteOffset;if(maxLength<0){throw new RangeError("'offset' is out of bounds")}if(length===void 0){length=maxLength}else{length>>>=0;if(length>maxLength){throw new RangeError("'length' is out of bounds")}}return isModern?Buffer.from(obj.slice(byteOffset,byteOffset+length)):new Buffer(new Uint8Array(obj.slice(byteOffset,byteOffset+length)))}function fromString(string,encoding){if(typeof encoding!=="string"||encoding===""){encoding="utf8"}if(!Buffer.isEncoding(encoding)){throw new TypeError('"encoding" must be a valid string encoding')}return isModern?Buffer.from(string,encoding):new Buffer(string,encoding)}function bufferFrom(value,encodingOrOffset,length){if(typeof value==="number"){throw new TypeError('"value" argument must not be a number')}if(isArrayBuffer2(value)){return fromArrayBuffer(value,encodingOrOffset,length)}if(typeof value==="string"){return fromString(value,encodingOrOffset)}return isModern?Buffer.from(value):new Buffer(value)}module2.exports=bufferFrom}});var require_source_map_support=__commonJS({"node_modules/source-map-support/source-map-support.js"(exports2,module2){var SourceMapConsumer=require_source_map().SourceMapConsumer;var path27=require("path");var fs14;try{fs14=require("fs");if(!fs14.existsSync||!fs14.readFileSync){fs14=null}}catch(err){}var bufferFrom=require_buffer_from();function dynamicRequire(mod3,request){return mod3.require(request)}var errorFormatterInstalled=false;var uncaughtShimInstalled=false;var emptyCacheBetweenOperations=false;var environment="auto";var fileContentsCache={};var sourceMapCache={};var reSourceMap=/^data:application\/json[^,]+base64,/;var retrieveFileHandlers=[];var retrieveMapHandlers=[];function isInBrowser(){if(environment==="browser")return true;if(environment==="node")return false;return typeof window!=="undefined"&&typeof XMLHttpRequest==="function"&&!(window.require&&window.module&&window.process&&window.process.type==="renderer")}function hasGlobalProcessEventEmitter(){return typeof process==="object"&&process!==null&&typeof process.on==="function"}function globalProcessVersion(){if(typeof process==="object"&&process!==null){return process.version}else{return""}}function globalProcessStderr(){if(typeof process==="object"&&process!==null){return process.stderr}}function globalProcessExit(code){if(typeof process==="object"&&process!==null&&typeof process.exit==="function"){return process.exit(code)}}function handlerExec(list){return function(arg){for(var i=0;i<list.length;i++){var ret=list[i](arg);if(ret){return ret}}return null}}var retrieveFile=handlerExec(retrieveFileHandlers);retrieveFileHandlers.push(function(path28){path28=path28.trim();if(/^file:/.test(path28)){path28=path28.replace(/file:\/\/\/(\w:)?/,function(protocol,drive){return drive?"":"/"})}if(path28 in fileContentsCache){return fileContentsCache[path28]}var contents="";try{if(!fs14){var xhr=new XMLHttpRequest;xhr.open("GET",path28,false);xhr.send(null);if(xhr.readyState===4&&xhr.status===200){contents=xhr.responseText}}else if(fs14.existsSync(path28)){contents=fs14.readFileSync(path28,"utf8")}}catch(er){}return fileContentsCache[path28]=contents});function supportRelativeURL(file,url){if(!file)return url;var dir=path27.dirname(file);var match=/^\w+:\/\/[^\/]*/.exec(dir);var protocol=match?match[0]:"";var startPath=dir.slice(protocol.length);if(protocol&&/^\/\w\:/.test(startPath)){protocol+="/";return protocol+path27.resolve(dir.slice(protocol.length),url).replace(/\\/g,"/")}return protocol+path27.resolve(dir.slice(protocol.length),url)}function retrieveSourceMapURL(source){var fileData;if(isInBrowser()){try{var xhr=new XMLHttpRequest;xhr.open("GET",source,false);xhr.send(null);fileData=xhr.readyState===4?xhr.responseText:null;var sourceMapHeader=xhr.getResponseHeader("SourceMap")||xhr.getResponseHeader("X-SourceMap");if(sourceMapHeader){return sourceMapHeader}}catch(e){}}fileData=retrieveFile(source);var re=/(?:\/\/[@#][\s]*sourceMappingURL=([^\s'"]+)[\s]*$)|(?:\/\*[@#][\s]*sourceMappingURL=([^\s*'"]+)[\s]*(?:\*\/)[\s]*$)/mg;var lastMatch,match;while(match=re.exec(fileData))lastMatch=match;if(!lastMatch)return null;return lastMatch[1]}var retrieveSourceMap=handlerExec(retrieveMapHandlers);retrieveMapHandlers.push(function(source){var sourceMappingURL=retrieveSourceMapURL(source);if(!sourceMappingURL)return null;var sourceMapData;if(reSourceMap.test(sourceMappingURL)){var rawData=sourceMappingURL.slice(sourceMappingURL.indexOf(",")+1);sourceMapData=bufferFrom(rawData,"base64").toString();sourceMappingURL=source}else{sourceMappingURL=supportRelativeURL(source,sourceMappingURL);sourceMapData=retrieveFile(sourceMappingURL)}if(!sourceMapData){return null}return{url:sourceMappingURL,map:sourceMapData}});function mapSourcePosition(position){var sourceMap=sourceMapCache[position.source];if(!sourceMap){var urlAndMap=retrieveSourceMap(position.source);if(urlAndMap){sourceMap=sourceMapCache[position.source]={url:urlAndMap.url,map:new SourceMapConsumer(urlAndMap.map)};if(sourceMap.map.sourcesContent){sourceMap.map.sources.forEach(function(source,i){var contents=sourceMap.map.sourcesContent[i];if(contents){var url=supportRelativeURL(sourceMap.url,source);fileContentsCache[url]=contents}})}}else{sourceMap=sourceMapCache[position.source]={url:null,map:null}}}if(sourceMap&&sourceMap.map&&typeof sourceMap.map.originalPositionFor==="function"){var originalPosition=sourceMap.map.originalPositionFor(position);if(originalPosition.source!==null){originalPosition.source=supportRelativeURL(sourceMap.url,originalPosition.source);return originalPosition}}return position}function mapEvalOrigin(origin){var match=/^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(origin);if(match){var position=mapSourcePosition({source:match[2],line:+match[3],column:match[4]-1});return"eval at "+match[1]+" ("+position.source+":"+position.line+":"+(position.column+1)+")"}match=/^eval at ([^(]+) \((.+)\)$/.exec(origin);if(match){return"eval at "+match[1]+" ("+mapEvalOrigin(match[2])+")"}return origin}function CallSiteToString(){var fileName;var fileLocation="";if(this.isNative()){fileLocation="native"}else{fileName=this.getScriptNameOrSourceURL();if(!fileName&&this.isEval()){fileLocation=this.getEvalOrigin();fileLocation+=", "}if(fileName){fileLocation+=fileName}else{fileLocation+="<anonymous>"}var lineNumber=this.getLineNumber();if(lineNumber!=null){fileLocation+=":"+lineNumber;var columnNumber=this.getColumnNumber();if(columnNumber){fileLocation+=":"+columnNumber}}}var line="";var functionName=this.getFunctionName();var addSuffix=true;var isConstructor=this.isConstructor();var isMethodCall=!(this.isToplevel()||isConstructor);if(isMethodCall){var typeName=this.getTypeName();if(typeName==="[object Object]"){typeName="null"}var methodName=this.getMethodName();if(functionName){if(typeName&&functionName.indexOf(typeName)!=0){line+=typeName+"."}line+=functionName;if(methodName&&functionName.indexOf("."+methodName)!=functionName.length-methodName.length-1){line+=" [as "+methodName+"]"}}else{line+=typeName+"."+(methodName||"<anonymous>")}}else if(isConstructor){line+="new "+(functionName||"<anonymous>")}else if(functionName){line+=functionName}else{line+=fileLocation;addSuffix=false}if(addSuffix){line+=" ("+fileLocation+")"}return line}function cloneCallSite(frame){var object={};Object.getOwnPropertyNames(Object.getPrototypeOf(frame)).forEach(function(name){object[name]=/^(?:is|get)/.test(name)?function(){return frame[name].call(frame)}:frame[name]});object.toString=CallSiteToString;return object}function wrapCallSite(frame,state){if(state===void 0){state={nextPosition:null,curPosition:null}}if(frame.isNative()){state.curPosition=null;return frame}var source=frame.getFileName()||frame.getScriptNameOrSourceURL();if(source){var line=frame.getLineNumber();var column=frame.getColumnNumber()-1;var noHeader=/^v(10\.1[6-9]|10\.[2-9][0-9]|10\.[0-9]{3,}|1[2-9]\d*|[2-9]\d|\d{3,}|11\.11)/;var headerLength=noHeader.test(globalProcessVersion())?0:62;if(line===1&&column>headerLength&&!isInBrowser()&&!frame.isEval()){column-=headerLength}var position=mapSourcePosition({source,line,column});state.curPosition=position;frame=cloneCallSite(frame);var originalFunctionName=frame.getFunctionName;frame.getFunctionName=function(){if(state.nextPosition==null){return originalFunctionName()}return state.nextPosition.name||originalFunctionName()};frame.getFileName=function(){return position.source};frame.getLineNumber=function(){return position.line};frame.getColumnNumber=function(){return position.column+1};frame.getScriptNameOrSourceURL=function(){return position.source};return frame}var origin=frame.isEval()&&frame.getEvalOrigin();if(origin){origin=mapEvalOrigin(origin);frame=cloneCallSite(frame);frame.getEvalOrigin=function(){return origin};return frame}return frame}function prepareStackTrace(error,stack2){if(emptyCacheBetweenOperations){fileContentsCache={};sourceMapCache={}}var name=error.name||"Error";var message3=error.message||"";var errorString=name+": "+message3;var state={nextPosition:null,curPosition:null};var processedStack=[];for(var i=stack2.length-1;i>=0;i--){processedStack.push("\n    at "+wrapCallSite(stack2[i],state));state.nextPosition=state.curPosition}state.curPosition=state.nextPosition=null;return errorString+processedStack.reverse().join("")}function getErrorSource(error){var match=/\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(error.stack);if(match){var source=match[1];var line=+match[2];var column=+match[3];var contents=fileContentsCache[source];if(!contents&&fs14&&fs14.existsSync(source)){try{contents=fs14.readFileSync(source,"utf8")}catch(er){contents=""}}if(contents){var code=contents.split(/(?:\r\n|\r|\n)/)[line-1];if(code){return source+":"+line+"\n"+code+"\n"+new Array(column).join(" ")+"^"}}}return null}function printErrorAndExit(error){var source=getErrorSource(error);var stderr=globalProcessStderr();if(stderr&&stderr._handle&&stderr._handle.setBlocking){stderr._handle.setBlocking(true)}if(source){console.error();console.error(source)}console.error(error.stack);globalProcessExit(1)}function shimEmitUncaughtException(){var origEmit=process.emit;process.emit=function(type2){if(type2==="uncaughtException"){var hasStack=arguments[1]&&arguments[1].stack;var hasListeners=this.listeners(type2).length>0;if(hasStack&&!hasListeners){return printErrorAndExit(arguments[1])}}return origEmit.apply(this,arguments)}}var originalRetrieveFileHandlers=retrieveFileHandlers.slice(0);var originalRetrieveMapHandlers=retrieveMapHandlers.slice(0);exports2.wrapCallSite=wrapCallSite;exports2.getErrorSource=getErrorSource;exports2.mapSourcePosition=mapSourcePosition;exports2.retrieveSourceMap=retrieveSourceMap;exports2.install=function(options){options=options||{};if(options.environment){environment=options.environment;if(["node","browser","auto"].indexOf(environment)===-1){throw new Error("environment "+environment+" was unknown. Available options are {auto, browser, node}")}}if(options.retrieveFile){if(options.overrideRetrieveFile){retrieveFileHandlers.length=0}retrieveFileHandlers.unshift(options.retrieveFile)}if(options.retrieveSourceMap){if(options.overrideRetrieveSourceMap){retrieveMapHandlers.length=0}retrieveMapHandlers.unshift(options.retrieveSourceMap)}if(options.hookRequire&&!isInBrowser()){var Module=dynamicRequire(module2,"module");var $compile=Module.prototype._compile;if(!$compile.__sourceMapSupport){Module.prototype._compile=function(content,filename){fileContentsCache[filename]=content;sourceMapCache[filename]=void 0;return $compile.call(this,content,filename)};Module.prototype._compile.__sourceMapSupport=true}}if(!emptyCacheBetweenOperations){emptyCacheBetweenOperations="emptyCacheBetweenOperations"in options?options.emptyCacheBetweenOperations:false}if(!errorFormatterInstalled){errorFormatterInstalled=true;Error.prepareStackTrace=prepareStackTrace}if(!uncaughtShimInstalled){var installHandler="handleUncaughtExceptions"in options?options.handleUncaughtExceptions:true;try{var worker_threads=dynamicRequire(module2,"worker_threads");if(worker_threads.isMainThread===false){installHandler=false}}catch(e){}if(installHandler&&hasGlobalProcessEventEmitter()){uncaughtShimInstalled=true;shimEmitUncaughtException()}}};exports2.resetRetrieveHandlers=function(){retrieveFileHandlers.length=0;retrieveMapHandlers.length=0;retrieveFileHandlers=originalRetrieveFileHandlers.slice(0);retrieveMapHandlers=originalRetrieveMapHandlers.slice(0);retrieveSourceMap=handlerExec(retrieveMapHandlers);retrieveFile=handlerExec(retrieveFileHandlers)}}});var require_humanize_duration=__commonJS({"node_modules/humanize-duration/humanize-duration.js"(exports2,module2){(function(){var assign2=Object.assign||function(destination){var source;for(var i=1;i<arguments.length;i++){source=arguments[i];for(var prop in source){if(has3(source,prop)){destination[prop]=source[prop]}}}return destination};var isArray3=Array.isArray||function(arg){return Object.prototype.toString.call(arg)==="[object Array]"};var GREEK=language2(function(c){return c===1?"χρόνος":"χρόνια"},function(c){return c===1?"μήνας":"μήνες"},function(c){return c===1?"εβδομάδα":"εβδομάδες"},function(c){return c===1?"μέρα":"μέρες"},function(c){return c===1?"ώρα":"ώρες"},function(c){return c===1?"λεπτό":"λεπτά"},function(c){return c===1?"δευτερόλεπτο":"δευτερόλεπτα"},function(c){return(c===1?"χιλιοστό":"χιλιοστά")+" του δευτερολέπτου"},",");var LANGUAGES={af:language2("jaar",function(c){return"maand"+(c===1?"":"e")},function(c){return c===1?"week":"weke"},function(c){return c===1?"dag":"dae"},function(c){return c===1?"uur":"ure"},function(c){return c===1?"minuut":"minute"},function(c){return"sekonde"+(c===1?"":"s")},function(c){return"millisekonde"+(c===1?"":"s")},","),am:language2("ዓመት","ወር","ሳምንት","ቀን","ሰዓት","ደቂቃ","ሰከንድ","ሚሊሰከንድ"),ar:assign2(language2(function(c){return["سنة","سنتان","سنوات"][getArabicForm(c)]},function(c){return["شهر","شهران","أشهر"][getArabicForm(c)]},function(c){return["أسبوع","أسبوعين","أسابيع"][getArabicForm(c)]},function(c){return["يوم","يومين","أيام"][getArabicForm(c)]},function(c){return["ساعة","ساعتين","ساعات"][getArabicForm(c)]},function(c){return["دقيقة","دقيقتان","دقائق"][getArabicForm(c)]},function(c){return["ثانية","ثانيتان","ثواني"][getArabicForm(c)]},function(c){return["جزء من الثانية","جزآن من الثانية","أجزاء من الثانية"][getArabicForm(c)]},","),{delimiter:" ﻭ ",_hideCountIf2:true,_digitReplacements:["۰","١","٢","٣","٤","٥","٦","٧","٨","٩"]}),bg:language2(function(c){return["години","година","години"][getSlavicForm(c)]},function(c){return["месеца","месец","месеца"][getSlavicForm(c)]},function(c){return["седмици","седмица","седмици"][getSlavicForm(c)]},function(c){return["дни","ден","дни"][getSlavicForm(c)]},function(c){return["часа","час","часа"][getSlavicForm(c)]},function(c){return["минути","минута","минути"][getSlavicForm(c)]},function(c){return["секунди","секунда","секунди"][getSlavicForm(c)]},function(c){return["милисекунди","милисекунда","милисекунди"][getSlavicForm(c)]},","),bn:language2("বছর","মাস","সপ্তাহ","দিন","ঘন্টা","মিনিট","সেকেন্ড","মিলিসেকেন্ড"),ca:language2(function(c){return"any"+(c===1?"":"s")},function(c){return"mes"+(c===1?"":"os")},function(c){return"setman"+(c===1?"a":"es")},function(c){return"di"+(c===1?"a":"es")},function(c){return"hor"+(c===1?"a":"es")},function(c){return"minut"+(c===1?"":"s")},function(c){return"segon"+(c===1?"":"s")},function(c){return"milisegon"+(c===1?"":"s")},","),ckb:language2("ساڵ","مانگ","هەفتە","ڕۆژ","کاژێر","خولەک","چرکە","میلی چرکە","."),cs:language2(function(c){return["rok","roku","roky","let"][getCzechOrSlovakForm(c)]},function(c){return["měsíc","měsíce","měsíce","měsíců"][getCzechOrSlovakForm(c)]},function(c){return["týden","týdne","týdny","týdnů"][getCzechOrSlovakForm(c)]},function(c){return["den","dne","dny","dní"][getCzechOrSlovakForm(c)]},function(c){return["hodina","hodiny","hodiny","hodin"][getCzechOrSlovakForm(c)]},function(c){return["minuta","minuty","minuty","minut"][getCzechOrSlovakForm(c)]},function(c){return["sekunda","sekundy","sekundy","sekund"][getCzechOrSlovakForm(c)]},function(c){return["milisekunda","milisekundy","milisekundy","milisekund"][getCzechOrSlovakForm(c)]},","),cy:language2("flwyddyn","mis","wythnos","diwrnod","awr","munud","eiliad","milieiliad"),da:language2("år",function(c){return"måned"+(c===1?"":"er")},function(c){return"uge"+(c===1?"":"r")},function(c){return"dag"+(c===1?"":"e")},function(c){return"time"+(c===1?"":"r")},function(c){return"minut"+(c===1?"":"ter")},function(c){return"sekund"+(c===1?"":"er")},function(c){return"millisekund"+(c===1?"":"er")},","),de:language2(function(c){return"Jahr"+(c===1?"":"e")},function(c){return"Monat"+(c===1?"":"e")},function(c){return"Woche"+(c===1?"":"n")},function(c){return"Tag"+(c===1?"":"e")},function(c){return"Stunde"+(c===1?"":"n")},function(c){return"Minute"+(c===1?"":"n")},function(c){return"Sekunde"+(c===1?"":"n")},function(c){return"Millisekunde"+(c===1?"":"n")},","),el:GREEK,en:language2(function(c){return"year"+(c===1?"":"s")},function(c){return"month"+(c===1?"":"s")},function(c){return"week"+(c===1?"":"s")},function(c){return"day"+(c===1?"":"s")},function(c){return"hour"+(c===1?"":"s")},function(c){return"minute"+(c===1?"":"s")},function(c){return"second"+(c===1?"":"s")},function(c){return"millisecond"+(c===1?"":"s")}),eo:language2(function(c){return"jaro"+(c===1?"":"j")},function(c){return"monato"+(c===1?"":"j")},function(c){return"semajno"+(c===1?"":"j")},function(c){return"tago"+(c===1?"":"j")},function(c){return"horo"+(c===1?"":"j")},function(c){return"minuto"+(c===1?"":"j")},function(c){return"sekundo"+(c===1?"":"j")},function(c){return"milisekundo"+(c===1?"":"j")},","),es:language2(function(c){return"año"+(c===1?"":"s")},function(c){return"mes"+(c===1?"":"es")},function(c){return"semana"+(c===1?"":"s")},function(c){return"día"+(c===1?"":"s")},function(c){return"hora"+(c===1?"":"s")},function(c){return"minuto"+(c===1?"":"s")},function(c){return"segundo"+(c===1?"":"s")},function(c){return"milisegundo"+(c===1?"":"s")},","),et:language2(function(c){return"aasta"+(c===1?"":"t")},function(c){return"kuu"+(c===1?"":"d")},function(c){return"nädal"+(c===1?"":"at")},function(c){return"päev"+(c===1?"":"a")},function(c){return"tund"+(c===1?"":"i")},function(c){return"minut"+(c===1?"":"it")},function(c){return"sekund"+(c===1?"":"it")},function(c){return"millisekund"+(c===1?"":"it")},","),eu:language2("urte","hilabete","aste","egun","ordu","minutu","segundo","milisegundo",","),fa:language2("سال","ماه","هفته","روز","ساعت","دقیقه","ثانیه","میلی ثانیه"),fi:language2(function(c){return c===1?"vuosi":"vuotta"},function(c){return c===1?"kuukausi":"kuukautta"},function(c){return"viikko"+(c===1?"":"a")},function(c){return"päivä"+(c===1?"":"ä")},function(c){return"tunti"+(c===1?"":"a")},function(c){return"minuutti"+(c===1?"":"a")},function(c){return"sekunti"+(c===1?"":"a")},function(c){return"millisekunti"+(c===1?"":"a")},","),fo:language2("ár",function(c){return c===1?"mánaður":"mánaðir"},function(c){return c===1?"vika":"vikur"},function(c){return c===1?"dagur":"dagar"},function(c){return c===1?"tími":"tímar"},function(c){return c===1?"minuttur":"minuttir"},"sekund","millisekund",","),fr:language2(function(c){return"an"+(c>=2?"s":"")},"mois",function(c){return"semaine"+(c>=2?"s":"")},function(c){return"jour"+(c>=2?"s":"")},function(c){return"heure"+(c>=2?"s":"")},function(c){return"minute"+(c>=2?"s":"")},function(c){return"seconde"+(c>=2?"s":"")},function(c){return"milliseconde"+(c>=2?"s":"")},","),gr:GREEK,he:language2(function(c){return c===1?"שנה":"שנים"},function(c){return c===1?"חודש":"חודשים"},function(c){return c===1?"שבוע":"שבועות"},function(c){return c===1?"יום":"ימים"},function(c){return c===1?"שעה":"שעות"},function(c){return c===1?"דקה":"דקות"},function(c){return c===1?"שניה":"שניות"},function(c){return c===1?"מילישנייה":"מילישניות"}),hr:language2(function(c){if(c%10===2||c%10===3||c%10===4){return"godine"}return"godina"},function(c){if(c===1){return"mjesec"}else if(c===2||c===3||c===4){return"mjeseca"}return"mjeseci"},function(c){if(c%10===1&&c!==11){return"tjedan"}return"tjedna"},function(c){return c===1?"dan":"dana"},function(c){if(c===1){return"sat"}else if(c===2||c===3||c===4){return"sata"}return"sati"},function(c){var mod10=c%10;if((mod10===2||mod10===3||mod10===4)&&(c<10||c>14)){return"minute"}return"minuta"},function(c){var mod10=c%10;if(mod10===5||Math.floor(c)===c&&c>=10&&c<=19){return"sekundi"}else if(mod10===1){return"sekunda"}else if(mod10===2||mod10===3||mod10===4){return"sekunde"}return"sekundi"},function(c){if(c===1){return"milisekunda"}else if(c%10===2||c%10===3||c%10===4){return"milisekunde"}return"milisekundi"},","),hi:language2("साल",function(c){return c===1?"महीना":"महीने"},function(c){return c===1?"हफ़्ता":"हफ्ते"},"दिन",function(c){return c===1?"घंटा":"घंटे"},"मिनट","सेकंड","मिलीसेकंड"),hu:language2("év","hónap","hét","nap","óra","perc","másodperc","ezredmásodperc",","),id:language2("tahun","bulan","minggu","hari","jam","menit","detik","milidetik"),is:language2("ár",function(c){return"mánuð"+(c===1?"ur":"ir")},function(c){return"vik"+(c===1?"a":"ur")},function(c){return"dag"+(c===1?"ur":"ar")},function(c){return"klukkutím"+(c===1?"i":"ar")},function(c){return"mínút"+(c===1?"a":"ur")},function(c){return"sekúnd"+(c===1?"a":"ur")},function(c){return"millisekúnd"+(c===1?"a":"ur")}),it:language2(function(c){return"ann"+(c===1?"o":"i")},function(c){return"mes"+(c===1?"e":"i")},function(c){return"settiman"+(c===1?"a":"e")},function(c){return"giorn"+(c===1?"o":"i")},function(c){return"or"+(c===1?"a":"e")},function(c){return"minut"+(c===1?"o":"i")},function(c){return"second"+(c===1?"o":"i")},function(c){return"millisecond"+(c===1?"o":"i")},","),ja:language2("年","ヶ月","週","日","時間","分","秒","ミリ秒"),km:language2("ឆ្នាំ","ខែ","សប្តាហ៍","ថ្ងៃ","ម៉ោង","នាទី","វិនាទី","មិល្លីវិនាទី"),kn:language2(function(c){return c===1?"ವರ್ಷ":"ವರ್ಷಗಳು"},function(c){return c===1?"ತಿಂಗಳು":"ತಿಂಗಳುಗಳು"},function(c){return c===1?"ವಾರ":"ವಾರಗಳು"},function(c){return c===1?"ದಿನ":"ದಿನಗಳು"},function(c){return c===1?"ಗಂಟೆ":"ಗಂಟೆಗಳು"},function(c){return c===1?"ನಿಮಿಷ":"ನಿಮಿಷಗಳು"},function(c){return c===1?"ಸೆಕೆಂಡ್":"ಸೆಕೆಂಡುಗಳು"},function(c){return c===1?"ಮಿಲಿಸೆಕೆಂಡ್":"ಮಿಲಿಸೆಕೆಂಡುಗಳು"}),ko:language2("년","개월","주일","일","시간","분","초","밀리 초"),ku:language2("sal","meh","hefte","roj","seet","deqe","saniye","mîlîçirk",","),lo:language2("ປີ","ເດືອນ","ອາທິດ","ມື້","ຊົ່ວໂມງ","ນາທີ","ວິນາທີ","ມິນລິວິນາທີ",","),lt:language2(function(c){return c%10===0||c%100>=10&&c%100<=20?"metų":"metai"},function(c){return["mėnuo","mėnesiai","mėnesių"][getLithuanianForm(c)]},function(c){return["savaitė","savaitės","savaičių"][getLithuanianForm(c)]},function(c){return["diena","dienos","dienų"][getLithuanianForm(c)]},function(c){return["valanda","valandos","valandų"][getLithuanianForm(c)]},function(c){return["minutė","minutės","minučių"][getLithuanianForm(c)]},function(c){return["sekundė","sekundės","sekundžių"][getLithuanianForm(c)]},function(c){return["milisekundė","milisekundės","milisekundžių"][getLithuanianForm(c)]},","),lv:language2(function(c){return getLatvianForm(c)?"gads":"gadi"},function(c){return getLatvianForm(c)?"mēnesis":"mēneši"},function(c){return getLatvianForm(c)?"nedēļa":"nedēļas"},function(c){return getLatvianForm(c)?"diena":"dienas"},function(c){return getLatvianForm(c)?"stunda":"stundas"},function(c){return getLatvianForm(c)?"minūte":"minūtes"},function(c){return getLatvianForm(c)?"sekunde":"sekundes"},function(c){return getLatvianForm(c)?"milisekunde":"milisekundes"},","),mk:language2(function(c){return c===1?"година":"години"},function(c){return c===1?"месец":"месеци"},function(c){return c===1?"недела":"недели"},function(c){return c===1?"ден":"дена"},function(c){return c===1?"час":"часа"},function(c){return c===1?"минута":"минути"},function(c){return c===1?"секунда":"секунди"},function(c){return c===1?"милисекунда":"милисекунди"},","),mn:language2("жил","сар","долоо хоног","өдөр","цаг","минут","секунд","миллисекунд"),mr:language2(function(c){return c===1?"वर्ष":"वर्षे"},function(c){return c===1?"महिना":"महिने"},function(c){return c===1?"आठवडा":"आठवडे"},"दिवस","तास",function(c){return c===1?"मिनिट":"मिनिटे"},"सेकंद","मिलिसेकंद"),ms:language2("tahun","bulan","minggu","hari","jam","minit","saat","milisaat"),nl:language2("jaar",function(c){return c===1?"maand":"maanden"},function(c){return c===1?"week":"weken"},function(c){return c===1?"dag":"dagen"},"uur",function(c){return c===1?"minuut":"minuten"},function(c){return c===1?"seconde":"seconden"},function(c){return c===1?"milliseconde":"milliseconden"},","),no:language2("år",function(c){return"måned"+(c===1?"":"er")},function(c){return"uke"+(c===1?"":"r")},function(c){return"dag"+(c===1?"":"er")},function(c){return"time"+(c===1?"":"r")},function(c){return"minutt"+(c===1?"":"er")},function(c){return"sekund"+(c===1?"":"er")},function(c){return"millisekund"+(c===1?"":"er")},","),pl:language2(function(c){return["rok","roku","lata","lat"][getPolishForm(c)]},function(c){return["miesiąc","miesiąca","miesiące","miesięcy"][getPolishForm(c)]},function(c){return["tydzień","tygodnia","tygodnie","tygodni"][getPolishForm(c)]},function(c){return["dzień","dnia","dni","dni"][getPolishForm(c)]},function(c){return["godzina","godziny","godziny","godzin"][getPolishForm(c)]},function(c){return["minuta","minuty","minuty","minut"][getPolishForm(c)]},function(c){return["sekunda","sekundy","sekundy","sekund"][getPolishForm(c)]},function(c){return["milisekunda","milisekundy","milisekundy","milisekund"][getPolishForm(c)]},","),pt:language2(function(c){return"ano"+(c===1?"":"s")},function(c){return c===1?"mês":"meses"},function(c){return"semana"+(c===1?"":"s")},function(c){return"dia"+(c===1?"":"s")},function(c){return"hora"+(c===1?"":"s")},function(c){return"minuto"+(c===1?"":"s")},function(c){return"segundo"+(c===1?"":"s")},function(c){return"milissegundo"+(c===1?"":"s")},","),ro:language2(function(c){return c===1?"an":"ani"},function(c){return c===1?"lună":"luni"},function(c){return c===1?"săptămână":"săptămâni"},function(c){return c===1?"zi":"zile"},function(c){return c===1?"oră":"ore"},function(c){return c===1?"minut":"minute"},function(c){return c===1?"secundă":"secunde"},function(c){return c===1?"milisecundă":"milisecunde"},","),ru:language2(function(c){return["лет","год","года"][getSlavicForm(c)]},function(c){return["месяцев","месяц","месяца"][getSlavicForm(c)]},function(c){return["недель","неделя","недели"][getSlavicForm(c)]},function(c){return["дней","день","дня"][getSlavicForm(c)]},function(c){return["часов","час","часа"][getSlavicForm(c)]},function(c){return["минут","минута","минуты"][getSlavicForm(c)]},function(c){return["секунд","секунда","секунды"][getSlavicForm(c)]},function(c){return["миллисекунд","миллисекунда","миллисекунды"][getSlavicForm(c)]},","),sq:language2(function(c){return c===1?"vit":"vjet"},"muaj","javë","ditë","orë",function(c){return"minut"+(c===1?"ë":"a")},function(c){return"sekond"+(c===1?"ë":"a")},function(c){return"milisekond"+(c===1?"ë":"a")},","),sr:language2(function(c){return["години","година","године"][getSlavicForm(c)]},function(c){return["месеци","месец","месеца"][getSlavicForm(c)]},function(c){return["недељи","недеља","недеље"][getSlavicForm(c)]},function(c){return["дани","дан","дана"][getSlavicForm(c)]},function(c){return["сати","сат","сата"][getSlavicForm(c)]},function(c){return["минута","минут","минута"][getSlavicForm(c)]},function(c){return["секунди","секунда","секунде"][getSlavicForm(c)]},function(c){return["милисекунди","милисекунда","милисекунде"][getSlavicForm(c)]},","),ta:language2(function(c){return c===1?"வருடம்":"ஆண்டுகள்"},function(c){return c===1?"மாதம்":"மாதங்கள்"},function(c){return c===1?"வாரம்":"வாரங்கள்"},function(c){return c===1?"நாள்":"நாட்கள்"},function(c){return c===1?"மணி":"மணிநேரம்"},function(c){return"நிமிட"+(c===1?"ம்":"ங்கள்")},function(c){return"வினாடி"+(c===1?"":"கள்")},function(c){return"மில்லி விநாடி"+(c===1?"":"கள்")}),te:language2(function(c){return"సంవత్స"+(c===1?"రం":"రాల")},function(c){return"నెల"+(c===1?"":"ల")},function(c){return c===1?"వారం":"వారాలు"},function(c){return"రోజు"+(c===1?"":"లు")},function(c){return"గంట"+(c===1?"":"లు")},function(c){return c===1?"నిమిషం":"నిమిషాలు"},function(c){return c===1?"సెకను":"సెకన్లు"},function(c){return c===1?"మిల్లీసెకన్":"మిల్లీసెకన్లు"}),uk:language2(function(c){return["років","рік","роки"][getSlavicForm(c)]},function(c){return["місяців","місяць","місяці"][getSlavicForm(c)]},function(c){return["тижнів","тиждень","тижні"][getSlavicForm(c)]},function(c){return["днів","день","дні"][getSlavicForm(c)]},function(c){return["годин","година","години"][getSlavicForm(c)]},function(c){return["хвилин","хвилина","хвилини"][getSlavicForm(c)]},function(c){return["секунд","секунда","секунди"][getSlavicForm(c)]},function(c){return["мілісекунд","мілісекунда","мілісекунди"][getSlavicForm(c)]},","),ur:language2("سال",function(c){return c===1?"مہینہ":"مہینے"},function(c){return c===1?"ہفتہ":"ہفتے"},"دن",function(c){return c===1?"گھنٹہ":"گھنٹے"},"منٹ","سیکنڈ","ملی سیکنڈ"),sk:language2(function(c){return["rok","roky","roky","rokov"][getCzechOrSlovakForm(c)]},function(c){return["mesiac","mesiace","mesiace","mesiacov"][getCzechOrSlovakForm(c)]},function(c){return["týždeň","týždne","týždne","týždňov"][getCzechOrSlovakForm(c)]},function(c){return["deň","dni","dni","dní"][getCzechOrSlovakForm(c)]},function(c){return["hodina","hodiny","hodiny","hodín"][getCzechOrSlovakForm(c)]},function(c){return["minúta","minúty","minúty","minút"][getCzechOrSlovakForm(c)]},function(c){return["sekunda","sekundy","sekundy","sekúnd"][getCzechOrSlovakForm(c)]},function(c){return["milisekunda","milisekundy","milisekundy","milisekúnd"][getCzechOrSlovakForm(c)]},","),sl:language2(function(c){if(c%10===1){return"leto"}else if(c%100===2){return"leti"}else if(c%100===3||c%100===4||Math.floor(c)!==c&&c%100<=5){return"leta"}else{return"let"}},function(c){if(c%10===1){return"mesec"}else if(c%100===2||Math.floor(c)!==c&&c%100<=5){return"meseca"}else if(c%10===3||c%10===4){return"mesece"}else{return"mesecev"}},function(c){if(c%10===1){return"teden"}else if(c%10===2||Math.floor(c)!==c&&c%100<=4){return"tedna"}else if(c%10===3||c%10===4){return"tedne"}else{return"tednov"}},function(c){return c%100===1?"dan":"dni"},function(c){if(c%10===1){return"ura"}else if(c%100===2){return"uri"}else if(c%10===3||c%10===4||Math.floor(c)!==c){return"ure"}else{return"ur"}},function(c){if(c%10===1){return"minuta"}else if(c%10===2){return"minuti"}else if(c%10===3||c%10===4||Math.floor(c)!==c&&c%100<=4){return"minute"}else{return"minut"}},function(c){if(c%10===1){return"sekunda"}else if(c%100===2){return"sekundi"}else if(c%100===3||c%100===4||Math.floor(c)!==c){return"sekunde"}else{return"sekund"}},function(c){if(c%10===1){return"milisekunda"}else if(c%100===2){return"milisekundi"}else if(c%100===3||c%100===4||Math.floor(c)!==c){return"milisekunde"}else{return"milisekund"}},","),sv:language2("år",function(c){return"månad"+(c===1?"":"er")},function(c){return"veck"+(c===1?"a":"or")},function(c){return"dag"+(c===1?"":"ar")},function(c){return"timm"+(c===1?"e":"ar")},function(c){return"minut"+(c===1?"":"er")},function(c){return"sekund"+(c===1?"":"er")},function(c){return"millisekund"+(c===1?"":"er")},","),sw:assign2(language2(function(c){return c===1?"mwaka":"miaka"},function(c){return c===1?"mwezi":"miezi"},"wiki",function(c){return c===1?"siku":"masiku"},function(c){return c===1?"saa":"masaa"},"dakika","sekunde","milisekunde"),{_numberFirst:true}),tr:language2("yıl","ay","hafta","gün","saat","dakika","saniye","milisaniye",","),th:language2("ปี","เดือน","สัปดาห์","วัน","ชั่วโมง","นาที","วินาที","มิลลิวินาที"),uz:language2("yil","oy","hafta","kun","soat","minut","sekund","millisekund"),uz_CYR:language2("йил","ой","ҳафта","кун","соат","минут","секунд","миллисекунд"),vi:language2("năm","tháng","tuần","ngày","giờ","phút","giây","mili giây",","),zh_CN:language2("年","个月","周","天","小时","分钟","秒","毫秒"),zh_TW:language2("年","個月","周","天","小時","分鐘","秒","毫秒")};function language2(y,mo,w,d,h,m,s,ms,decimal){var result2={y,mo,w,d,h,m,s,ms};if(typeof decimal!=="undefined"){result2.decimal=decimal}return result2}function getArabicForm(c){if(c===2){return 1}if(c>2&&c<11){return 2}return 0}function getPolishForm(c){if(c===1){return 0}if(Math.floor(c)!==c){return 1}if(c%10>=2&&c%10<=4&&!(c%100>10&&c%100<20)){return 2}return 3}function getSlavicForm(c){if(Math.floor(c)!==c){return 2}if(c%100>=5&&c%100<=20||c%10>=5&&c%10<=9||c%10===0){return 0}if(c%10===1){return 1}if(c>1){return 2}return 0}function getCzechOrSlovakForm(c){if(c===1){return 0}if(Math.floor(c)!==c){return 1}if(c%10>=2&&c%10<=4&&c%100<10){return 2}return 3}function getLithuanianForm(c){if(c===1||c%10===1&&c%100>20){return 0}if(Math.floor(c)!==c||c%10>=2&&c%100>20||c%10>=2&&c%100<10){return 1}return 2}function getLatvianForm(c){return c%10===1&&c%100!==11}function has3(obj,key){return Object.prototype.hasOwnProperty.call(obj,key)}function getLanguage(options){var possibleLanguages=[options.language];if(has3(options,"fallbacks")){if(isArray3(options.fallbacks)&&options.fallbacks.length){possibleLanguages=possibleLanguages.concat(options.fallbacks)}else{throw new Error("fallbacks must be an array with at least one element")}}for(var i=0;i<possibleLanguages.length;i++){var languageToTry=possibleLanguages[i];if(has3(options.languages,languageToTry)){return options.languages[languageToTry]}if(has3(LANGUAGES,languageToTry)){return LANGUAGES[languageToTry]}}throw new Error("No language found.")}function renderPiece(piece,language3,options){var unitName=piece.unitName;var unitCount=piece.unitCount;var spacer=options.spacer;var maxDecimalPoints=options.maxDecimalPoints;var decimal;if(has3(options,"decimal")){decimal=options.decimal}else if(has3(language3,"decimal")){decimal=language3.decimal}else{decimal="."}var digitReplacements;if("digitReplacements"in options){digitReplacements=options.digitReplacements}else if("_digitReplacements"in language3){digitReplacements=language3._digitReplacements}var formattedCount;var normalizedUnitCount=maxDecimalPoints===void 0?unitCount:Math.floor(unitCount*Math.pow(10,maxDecimalPoints))/Math.pow(10,maxDecimalPoints);var countStr=normalizedUnitCount.toString();if(language3._hideCountIf2&&unitCount===2){formattedCount="";spacer=""}else{if(digitReplacements){formattedCount="";for(var i=0;i<countStr.length;i++){var char=countStr[i];if(char==="."){formattedCount+=decimal}else{formattedCount+=digitReplacements[char]}}}else{formattedCount=countStr.replace(".",decimal)}}var languageWord=language3[unitName];var word;if(typeof languageWord==="function"){word=languageWord(unitCount)}else{word=languageWord}if(language3._numberFirst){return word+spacer+formattedCount}return formattedCount+spacer+word}function getPieces(ms,options){var unitName;var i;var unitCount;var msRemaining;var units=options.units;var unitMeasures=options.unitMeasures;var largest="largest"in options?options.largest:Infinity;if(!units.length)return[];var unitCounts={};msRemaining=ms;for(i=0;i<units.length;i++){unitName=units[i];var unitMs=unitMeasures[unitName];var isLast=i===units.length-1;unitCount=isLast?msRemaining/unitMs:Math.floor(msRemaining/unitMs);unitCounts[unitName]=unitCount;msRemaining-=unitCount*unitMs}if(options.round){var unitsRemainingBeforeRound=largest;for(i=0;i<units.length;i++){unitName=units[i];unitCount=unitCounts[unitName];if(unitCount===0)continue;unitsRemainingBeforeRound--;if(unitsRemainingBeforeRound===0){for(var j=i+1;j<units.length;j++){var smallerUnitName=units[j];var smallerUnitCount=unitCounts[smallerUnitName];unitCounts[unitName]+=smallerUnitCount*unitMeasures[smallerUnitName]/unitMeasures[unitName];unitCounts[smallerUnitName]=0}break}}for(i=units.length-1;i>=0;i--){unitName=units[i];unitCount=unitCounts[unitName];if(unitCount===0)continue;var rounded=Math.round(unitCount);unitCounts[unitName]=rounded;if(i===0)break;var previousUnitName=units[i-1];var previousUnitMs=unitMeasures[previousUnitName];var amountOfPreviousUnit=Math.floor(rounded*unitMeasures[unitName]/previousUnitMs);if(amountOfPreviousUnit){unitCounts[previousUnitName]+=amountOfPreviousUnit;unitCounts[unitName]=0}else{break}}}var result2=[];for(i=0;i<units.length&&result2.length<largest;i++){unitName=units[i];unitCount=unitCounts[unitName];if(unitCount){result2.push({unitName,unitCount})}}return result2}function formatPieces(pieces,options){var language3=getLanguage(options);if(!pieces.length){var units=options.units;var smallestUnitName=units[units.length-1];return renderPiece({unitName:smallestUnitName,unitCount:0},language3,options)}var conjunction=options.conjunction;var serialComma=options.serialComma;var delimiter;if(has3(options,"delimiter")){delimiter=options.delimiter}else if(has3(language3,"delimiter")){delimiter=language3.delimiter}else{delimiter=", "}var renderedPieces=[];for(var i=0;i<pieces.length;i++){renderedPieces.push(renderPiece(pieces[i],language3,options))}if(!conjunction||pieces.length===1){return renderedPieces.join(delimiter)}if(pieces.length===2){return renderedPieces.join(conjunction)}return renderedPieces.slice(0,-1).join(delimiter)+(serialComma?",":"")+conjunction+renderedPieces.slice(-1)}function humanizer(passedOptions){var result2=function humanizer2(ms,humanizerOptions){ms=Math.abs(ms);var options=assign2({},result2,humanizerOptions||{});var pieces=getPieces(ms,options);return formatPieces(pieces,options)};return assign2(result2,{language:"en",spacer:" ",conjunction:"",serialComma:true,units:["y","mo","w","d","h","m","s"],languages:{},round:false,unitMeasures:{y:315576e5,mo:26298e5,w:6048e5,d:864e5,h:36e5,m:6e4,s:1e3,ms:1}},passedOptions)}var humanizeDuration3=assign2(humanizer({}),{getSupportedLanguages:function getSupportedLanguages(){var result2=[];for(var language3 in LANGUAGES){if(has3(LANGUAGES,language3)&&language3!=="gr"){result2.push(language3)}}return result2},humanizer});if(typeof define==="function"&&define.amd){define(function(){return humanizeDuration3})}else if(typeof module2!=="undefined"&&module2.exports){module2.exports=humanizeDuration3}else{this.humanizeDuration=humanizeDuration3}})()}});var require_lowercase=__commonJS({"node_modules/nanoid-dictionary/lowercase.js"(exports2,module2){module2.exports="abcdefghijklmnopqrstuvwxyz"}});var require_uppercase=__commonJS({"node_modules/nanoid-dictionary/uppercase.js"(exports2,module2){module2.exports="ABCDEFGHIJKLMNOPQRSTUVWXYZ"}});var require_numbers=__commonJS({"node_modules/nanoid-dictionary/numbers.js"(exports2,module2){module2.exports="0123456789"}});var require_nolookalikes=__commonJS({"node_modules/nanoid-dictionary/nolookalikes.js"(exports2,module2){module2.exports="346789ABCDEFGHJKLMNPQRTUVWXYabcdefghijkmnpqrtwxyz"}});var require_nolookalikes_safe=__commonJS({"node_modules/nanoid-dictionary/nolookalikes-safe.js"(exports2,module2){module2.exports="6789BCDFGHJKLMNPQRTWbcdfghjkmnpqrtwz"}});var require_alphanumeric=__commonJS({"node_modules/nanoid-dictionary/alphanumeric.js"(exports2,module2){var numbers2=require_numbers();var lowercase=require_lowercase();var uppercase=require_uppercase();module2.exports=numbers2+lowercase+uppercase}});var require_nanoid_dictionary=__commonJS({"node_modules/nanoid-dictionary/index.js"(exports2,module2){module2.exports={lowercase:require_lowercase(),uppercase:require_uppercase(),numbers:require_numbers(),nolookalikes:require_nolookalikes(),nolookalikesSafe:require_nolookalikes_safe(),alphanumeric:require_alphanumeric()}}});var require_lodash=__commonJS({"node_modules/lodash/lodash.js"(exports2,module2){(function(){var undefined2;var VERSION2="4.17.21";var LARGE_ARRAY_SIZE4=200;var CORE_ERROR_TEXT2="Unsupported core-js use. Try https://npms.io/search?q=ponyfill.",FUNC_ERROR_TEXT13="Expected a function",INVALID_TEMPL_VAR_ERROR_TEXT2="Invalid `variable` option passed into `_.template`";var HASH_UNDEFINED4="__lodash_hash_undefined__";var MAX_MEMOIZE_SIZE2=500;var PLACEHOLDER3="__lodash_placeholder__";var CLONE_DEEP_FLAG9=1,CLONE_FLAT_FLAG3=2,CLONE_SYMBOLS_FLAG7=4;var COMPARE_PARTIAL_FLAG7=1,COMPARE_UNORDERED_FLAG5=2;var WRAP_BIND_FLAG10=1,WRAP_BIND_KEY_FLAG8=2,WRAP_CURRY_BOUND_FLAG3=4,WRAP_CURRY_FLAG8=8,WRAP_CURRY_RIGHT_FLAG5=16,WRAP_PARTIAL_FLAG8=32,WRAP_PARTIAL_RIGHT_FLAG5=64,WRAP_ARY_FLAG6=128,WRAP_REARG_FLAG5=256,WRAP_FLIP_FLAG4=512;var DEFAULT_TRUNC_LENGTH2=30,DEFAULT_TRUNC_OMISSION2="...";var HOT_COUNT2=800,HOT_SPAN2=16;var LAZY_FILTER_FLAG3=1,LAZY_MAP_FLAG2=2,LAZY_WHILE_FLAG2=3;var INFINITY8=1/0,MAX_SAFE_INTEGER7=9007199254740991,MAX_INTEGER2=17976931348623157e292,NAN4=0/0;var MAX_ARRAY_LENGTH8=4294967295,MAX_ARRAY_INDEX2=MAX_ARRAY_LENGTH8-1,HALF_MAX_ARRAY_LENGTH2=MAX_ARRAY_LENGTH8>>>1;var wrapFlags2=[["ary",WRAP_ARY_FLAG6],["bind",WRAP_BIND_FLAG10],["bindKey",WRAP_BIND_KEY_FLAG8],["curry",WRAP_CURRY_FLAG8],["curryRight",WRAP_CURRY_RIGHT_FLAG5],["flip",WRAP_FLIP_FLAG4],["partial",WRAP_PARTIAL_FLAG8],["partialRight",WRAP_PARTIAL_RIGHT_FLAG5],["rearg",WRAP_REARG_FLAG5]];var argsTag5="[object Arguments]",arrayTag4="[object Array]",asyncTag2="[object AsyncFunction]",boolTag6="[object Boolean]",dateTag6="[object Date]",domExcTag2="[object DOMException]",errorTag5="[object Error]",funcTag4="[object Function]",genTag3="[object GeneratorFunction]",mapTag11="[object Map]",numberTag6="[object Number]",nullTag2="[object Null]",objectTag6="[object Object]",promiseTag2="[object Promise]",proxyTag2="[object Proxy]",regexpTag6="[object RegExp]",setTag11="[object Set]",stringTag6="[object String]",symbolTag5="[object Symbol]",undefinedTag2="[object Undefined]",weakMapTag5="[object WeakMap]",weakSetTag2="[object WeakSet]";var arrayBufferTag6="[object ArrayBuffer]",dataViewTag6="[object DataView]",float32Tag4="[object Float32Array]",float64Tag4="[object Float64Array]",int8Tag4="[object Int8Array]",int16Tag4="[object Int16Array]",int32Tag4="[object Int32Array]",uint8Tag4="[object Uint8Array]",uint8ClampedTag4="[object Uint8ClampedArray]",uint16Tag4="[object Uint16Array]",uint32Tag4="[object Uint32Array]";var reEmptyStringLeading2=/\b__p \+= '';/g,reEmptyStringMiddle2=/\b(__p \+=) '' \+/g,reEmptyStringTrailing2=/(__e\(.*?\)|\b__t\)) \+\n'';/g;var reEscapedHtml2=/&(?:amp|lt|gt|quot|#39);/g,reUnescapedHtml2=/[&<>"']/g,reHasEscapedHtml2=RegExp(reEscapedHtml2.source),reHasUnescapedHtml2=RegExp(reUnescapedHtml2.source);var reEscape2=/<%-([\s\S]+?)%>/g,reEvaluate2=/<%([\s\S]+?)%>/g,reInterpolate2=/<%=([\s\S]+?)%>/g;var reIsDeepProp2=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp2=/^\w*$/,rePropName2=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var reRegExpChar3=/[\\^$.*+?()[\]{}|]/g,reHasRegExpChar2=RegExp(reRegExpChar3.source);var reTrimStart4=/^\s+/;var reWhitespace2=/\s/;var reWrapComment2=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,reWrapDetails2=/\{\n\/\* \[wrapped with (.+)\] \*/,reSplitDetails2=/,? & /;var reAsciiWord2=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;var reForbiddenIdentifierChars2=/[()=,{}\[\]\/\s]/;var reEscapeChar2=/\\(\\)?/g;var reEsTemplate2=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;var reFlags3=/\w*$/;var reIsBadHex2=/^[-+]0x[0-9a-f]+$/i;var reIsBinary2=/^0b[01]+$/i;var reIsHostCtor2=/^\[object .+?Constructor\]$/;var reIsOctal2=/^0o[0-7]+$/i;var reIsUint2=/^(?:0|[1-9]\d*)$/;var reLatin2=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;var reNoMatch2=/($^)/;var reUnescapedString2=/['\n\r\u2028\u2029\\]/g;var rsAstralRange5="\\ud800-\\udfff",rsComboMarksRange6="\\u0300-\\u036f",reComboHalfMarksRange6="\\ufe20-\\ufe2f",rsComboSymbolsRange6="\\u20d0-\\u20ff",rsComboRange6=rsComboMarksRange6+reComboHalfMarksRange6+rsComboSymbolsRange6,rsDingbatRange2="\\u2700-\\u27bf",rsLowerRange2="a-z\\xdf-\\xf6\\xf8-\\xff",rsMathOpRange2="\\xac\\xb1\\xd7\\xf7",rsNonCharRange2="\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf",rsPunctuationRange2="\\u2000-\\u206f",rsSpaceRange2=" \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",rsUpperRange2="A-Z\\xc0-\\xd6\\xd8-\\xde",rsVarRange5="\\ufe0e\\ufe0f",rsBreakRange2=rsMathOpRange2+rsNonCharRange2+rsPunctuationRange2+rsSpaceRange2;var rsApos3="['’]",rsAstral3="["+rsAstralRange5+"]",rsBreak2="["+rsBreakRange2+"]",rsCombo5="["+rsComboRange6+"]",rsDigits2="\\d+",rsDingbat2="["+rsDingbatRange2+"]",rsLower2="["+rsLowerRange2+"]",rsMisc2="[^"+rsAstralRange5+rsBreakRange2+rsDigits2+rsDingbatRange2+rsLowerRange2+rsUpperRange2+"]",rsFitz4="\\ud83c[\\udffb-\\udfff]",rsModifier4="(?:"+rsCombo5+"|"+rsFitz4+")",rsNonAstral4="[^"+rsAstralRange5+"]",rsRegional4="(?:\\ud83c[\\udde6-\\uddff]){2}",rsSurrPair4="[\\ud800-\\udbff][\\udc00-\\udfff]",rsUpper2="["+rsUpperRange2+"]",rsZWJ5="\\u200d";var rsMiscLower2="(?:"+rsLower2+"|"+rsMisc2+")",rsMiscUpper2="(?:"+rsUpper2+"|"+rsMisc2+")",rsOptContrLower2="(?:"+rsApos3+"(?:d|ll|m|re|s|t|ve))?",rsOptContrUpper2="(?:"+rsApos3+"(?:D|LL|M|RE|S|T|VE))?",reOptMod4=rsModifier4+"?",rsOptVar4="["+rsVarRange5+"]?",rsOptJoin4="(?:"+rsZWJ5+"(?:"+[rsNonAstral4,rsRegional4,rsSurrPair4].join("|")+")"+rsOptVar4+reOptMod4+")*",rsOrdLower2="\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",rsOrdUpper2="\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])",rsSeq4=rsOptVar4+reOptMod4+rsOptJoin4,rsEmoji2="(?:"+[rsDingbat2,rsRegional4,rsSurrPair4].join("|")+")"+rsSeq4,rsSymbol3="(?:"+[rsNonAstral4+rsCombo5+"?",rsCombo5,rsRegional4,rsSurrPair4,rsAstral3].join("|")+")";var reApos2=RegExp(rsApos3,"g");var reComboMark2=RegExp(rsCombo5,"g");var reUnicode3=RegExp(rsFitz4+"(?="+rsFitz4+")|"+rsSymbol3+rsSeq4,"g");var reUnicodeWord2=RegExp([rsUpper2+"?"+rsLower2+"+"+rsOptContrLower2+"(?="+[rsBreak2,rsUpper2,"$"].join("|")+")",rsMiscUpper2+"+"+rsOptContrUpper2+"(?="+[rsBreak2,rsUpper2+rsMiscLower2,"$"].join("|")+")",rsUpper2+"?"+rsMiscLower2+"+"+rsOptContrLower2,rsUpper2+"+"+rsOptContrUpper2,rsOrdUpper2,rsOrdLower2,rsDigits2,rsEmoji2].join("|"),"g");var reHasUnicode2=RegExp("["+rsZWJ5+rsAstralRange5+rsComboRange6+rsVarRange5+"]");var reHasUnicodeWord2=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;var contextProps=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"];var templateCounter=-1;var typedArrayTags2={};typedArrayTags2[float32Tag4]=typedArrayTags2[float64Tag4]=typedArrayTags2[int8Tag4]=typedArrayTags2[int16Tag4]=typedArrayTags2[int32Tag4]=typedArrayTags2[uint8Tag4]=typedArrayTags2[uint8ClampedTag4]=typedArrayTags2[uint16Tag4]=typedArrayTags2[uint32Tag4]=true;typedArrayTags2[argsTag5]=typedArrayTags2[arrayTag4]=typedArrayTags2[arrayBufferTag6]=typedArrayTags2[boolTag6]=typedArrayTags2[dataViewTag6]=typedArrayTags2[dateTag6]=typedArrayTags2[errorTag5]=typedArrayTags2[funcTag4]=typedArrayTags2[mapTag11]=typedArrayTags2[numberTag6]=typedArrayTags2[objectTag6]=typedArrayTags2[regexpTag6]=typedArrayTags2[setTag11]=typedArrayTags2[stringTag6]=typedArrayTags2[weakMapTag5]=false;var cloneableTags2={};cloneableTags2[argsTag5]=cloneableTags2[arrayTag4]=cloneableTags2[arrayBufferTag6]=cloneableTags2[dataViewTag6]=cloneableTags2[boolTag6]=cloneableTags2[dateTag6]=cloneableTags2[float32Tag4]=cloneableTags2[float64Tag4]=cloneableTags2[int8Tag4]=cloneableTags2[int16Tag4]=cloneableTags2[int32Tag4]=cloneableTags2[mapTag11]=cloneableTags2[numberTag6]=cloneableTags2[objectTag6]=cloneableTags2[regexpTag6]=cloneableTags2[setTag11]=cloneableTags2[stringTag6]=cloneableTags2[symbolTag5]=cloneableTags2[uint8Tag4]=cloneableTags2[uint8ClampedTag4]=cloneableTags2[uint16Tag4]=cloneableTags2[uint32Tag4]=true;cloneableTags2[errorTag5]=cloneableTags2[funcTag4]=cloneableTags2[weakMapTag5]=false;var deburredLetters2={"À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","Ç":"C","ç":"c","Ð":"D","ð":"d","È":"E","É":"E","Ê":"E","Ë":"E","è":"e","é":"e","ê":"e","ë":"e","Ì":"I","Í":"I","Î":"I","Ï":"I","ì":"i","í":"i","î":"i","ï":"i","Ñ":"N","ñ":"n","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","Ù":"U","Ú":"U","Û":"U","Ü":"U","ù":"u","ú":"u","û":"u","ü":"u","Ý":"Y","ý":"y","ÿ":"y","Æ":"Ae","æ":"ae","Þ":"Th","þ":"th","ß":"ss","Ā":"A","Ă":"A","Ą":"A","ā":"a","ă":"a","ą":"a","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","ć":"c","ĉ":"c","ċ":"c","č":"c","Ď":"D","Đ":"D","ď":"d","đ":"d","Ē":"E","Ĕ":"E","Ė":"E","Ę":"E","Ě":"E","ē":"e","ĕ":"e","ė":"e","ę":"e","ě":"e","Ĝ":"G","Ğ":"G","Ġ":"G","Ģ":"G","ĝ":"g","ğ":"g","ġ":"g","ģ":"g","Ĥ":"H","Ħ":"H","ĥ":"h","ħ":"h","Ĩ":"I","Ī":"I","Ĭ":"I","Į":"I","İ":"I","ĩ":"i","ī":"i","ĭ":"i","į":"i","ı":"i","Ĵ":"J","ĵ":"j","Ķ":"K","ķ":"k","ĸ":"k","Ĺ":"L","Ļ":"L","Ľ":"L","Ŀ":"L","Ł":"L","ĺ":"l","ļ":"l","ľ":"l","ŀ":"l","ł":"l","Ń":"N","Ņ":"N","Ň":"N","Ŋ":"N","ń":"n","ņ":"n","ň":"n","ŋ":"n","Ō":"O","Ŏ":"O","Ő":"O","ō":"o","ŏ":"o","ő":"o","Ŕ":"R","Ŗ":"R","Ř":"R","ŕ":"r","ŗ":"r","ř":"r","Ś":"S","Ŝ":"S","Ş":"S","Š":"S","ś":"s","ŝ":"s","ş":"s","š":"s","Ţ":"T","Ť":"T","Ŧ":"T","ţ":"t","ť":"t","ŧ":"t","Ũ":"U","Ū":"U","Ŭ":"U","Ů":"U","Ű":"U","Ų":"U","ũ":"u","ū":"u","ŭ":"u","ů":"u","ű":"u","ų":"u","Ŵ":"W","ŵ":"w","Ŷ":"Y","ŷ":"y","Ÿ":"Y","Ź":"Z","Ż":"Z","Ž":"Z","ź":"z","ż":"z","ž":"z","Ĳ":"IJ","ĳ":"ij","Œ":"Oe","œ":"oe","ŉ":"'n","ſ":"s"};var htmlEscapes2={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"};var htmlUnescapes2={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"};var stringEscapes2={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"};var freeParseFloat2=parseFloat,freeParseInt2=parseInt;var freeGlobal2=typeof global=="object"&&global&&global.Object===Object&&global;var freeSelf2=typeof self=="object"&&self&&self.Object===Object&&self;var root2=freeGlobal2||freeSelf2||Function("return this")();var freeExports4=typeof exports2=="object"&&exports2&&!exports2.nodeType&&exports2;var freeModule4=freeExports4&&typeof module2=="object"&&module2&&!module2.nodeType&&module2;var moduleExports4=freeModule4&&freeModule4.exports===freeExports4;var freeProcess2=moduleExports4&&freeGlobal2.process;var nodeUtil2=function(){try{var types6=freeModule4&&freeModule4.require&&freeModule4.require("util").types;if(types6){return types6}return freeProcess2&&freeProcess2.binding&&freeProcess2.binding("util")}catch(e){}}();var nodeIsArrayBuffer2=nodeUtil2&&nodeUtil2.isArrayBuffer,nodeIsDate2=nodeUtil2&&nodeUtil2.isDate,nodeIsMap2=nodeUtil2&&nodeUtil2.isMap,nodeIsRegExp2=nodeUtil2&&nodeUtil2.isRegExp,nodeIsSet2=nodeUtil2&&nodeUtil2.isSet,nodeIsTypedArray2=nodeUtil2&&nodeUtil2.isTypedArray;function apply2(func,thisArg,args2){switch(args2.length){case 0:return func.call(thisArg);case 1:return func.call(thisArg,args2[0]);case 2:return func.call(thisArg,args2[0],args2[1]);case 3:return func.call(thisArg,args2[0],args2[1],args2[2])}return func.apply(thisArg,args2)}function arrayAggregator2(array,setter,iteratee2,accumulator){var index=-1,length=array==null?0:array.length;while(++index<length){var value=array[index];setter(accumulator,value,iteratee2(value),array)}return accumulator}function arrayEach2(array,iteratee2){var index=-1,length=array==null?0:array.length;while(++index<length){if(iteratee2(array[index],index,array)===false){break}}return array}function arrayEachRight2(array,iteratee2){var length=array==null?0:array.length;while(length--){if(iteratee2(array[length],length,array)===false){break}}return array}function arrayEvery2(array,predicate){var index=-1,length=array==null?0:array.length;while(++index<length){if(!predicate(array[index],index,array)){return false}}return true}function arrayFilter2(array,predicate){var index=-1,length=array==null?0:array.length,resIndex=0,result2=[];while(++index<length){var value=array[index];if(predicate(value,index,array)){result2[resIndex++]=value}}return result2}function arrayIncludes2(array,value){var length=array==null?0:array.length;return!!length&&baseIndexOf2(array,value,0)>-1}function arrayIncludesWith2(array,value,comparator){var index=-1,length=array==null?0:array.length;while(++index<length){if(comparator(value,array[index])){return true}}return false}function arrayMap2(array,iteratee2){var index=-1,length=array==null?0:array.length,result2=Array(length);while(++index<length){result2[index]=iteratee2(array[index],index,array)}return result2}function arrayPush2(array,values2){var index=-1,length=values2.length,offset=array.length;while(++index<length){array[offset+index]=values2[index]}return array}function arrayReduce2(array,iteratee2,accumulator,initAccum){var index=-1,length=array==null?0:array.length;if(initAccum&&length){accumulator=array[++index]}while(++index<length){accumulator=iteratee2(accumulator,array[index],index,array)}return accumulator}function arrayReduceRight2(array,iteratee2,accumulator,initAccum){var length=array==null?0:array.length;if(initAccum&&length){accumulator=array[--length]}while(length--){accumulator=iteratee2(accumulator,array[length],length,array)}return accumulator}function arraySome2(array,predicate){var index=-1,length=array==null?0:array.length;while(++index<length){if(predicate(array[index],index,array)){return true}}return false}var asciiSize2=baseProperty2("length");function asciiToArray2(string){return string.split("")}function asciiWords2(string){return string.match(reAsciiWord2)||[]}function baseFindKey2(collection,predicate,eachFunc){var result2;eachFunc(collection,function(value,key,collection2){if(predicate(value,key,collection2)){result2=key;return false}});return result2}function baseFindIndex2(array,predicate,fromIndex,fromRight){var length=array.length,index=fromIndex+(fromRight?1:-1);while(fromRight?index--:++index<length){if(predicate(array[index],index,array)){return index}}return-1}function baseIndexOf2(array,value,fromIndex){return value===value?strictIndexOf2(array,value,fromIndex):baseFindIndex2(array,baseIsNaN2,fromIndex)}function baseIndexOfWith2(array,value,fromIndex,comparator){var index=fromIndex-1,length=array.length;while(++index<length){if(comparator(array[index],value)){return index}}return-1}function baseIsNaN2(value){return value!==value}function baseMean2(array,iteratee2){var length=array==null?0:array.length;return length?baseSum2(array,iteratee2)/length:NAN4}function baseProperty2(key){return function(object){return object==null?undefined2:object[key]}}function basePropertyOf2(object){return function(key){return object==null?undefined2:object[key]}}function baseReduce2(collection,iteratee2,accumulator,initAccum,eachFunc){eachFunc(collection,function(value,index,collection2){accumulator=initAccum?(initAccum=false,value):iteratee2(accumulator,value,index,collection2)});return accumulator}function baseSortBy2(array,comparer){var length=array.length;array.sort(comparer);while(length--){array[length]=array[length].value}return array}function baseSum2(array,iteratee2){var result2,index=-1,length=array.length;while(++index<length){var current=iteratee2(array[index]);if(current!==undefined2){result2=result2===undefined2?current:result2+current}}return result2}function baseTimes2(n,iteratee2){var index=-1,result2=Array(n);while(++index<n){result2[index]=iteratee2(index)}return result2}function baseToPairs2(object,props){return arrayMap2(props,function(key){return[key,object[key]]})}function baseTrim2(string){return string?string.slice(0,trimmedEndIndex2(string)+1).replace(reTrimStart4,""):string}function baseUnary2(func){return function(value){return func(value)}}function baseValues2(object,props){return arrayMap2(props,function(key){return object[key]})}function cacheHas2(cache2,key){return cache2.has(key)}function charsStartIndex2(strSymbols,chrSymbols){var index=-1,length=strSymbols.length;while(++index<length&&baseIndexOf2(chrSymbols,strSymbols[index],0)>-1){}return index}function charsEndIndex2(strSymbols,chrSymbols){var index=strSymbols.length;while(index--&&baseIndexOf2(chrSymbols,strSymbols[index],0)>-1){}return index}function countHolders2(array,placeholder){var length=array.length,result2=0;while(length--){if(array[length]===placeholder){++result2}}return result2}var deburrLetter2=basePropertyOf2(deburredLetters2);var escapeHtmlChar2=basePropertyOf2(htmlEscapes2);function escapeStringChar2(chr){return"\\"+stringEscapes2[chr]}function getValue2(object,key){return object==null?undefined2:object[key]}function hasUnicode2(string){return reHasUnicode2.test(string)}function hasUnicodeWord2(string){return reHasUnicodeWord2.test(string)}function iteratorToArray2(iterator){var data,result2=[];while(!(data=iterator.next()).done){result2.push(data.value)}return result2}function mapToArray2(map3){var index=-1,result2=Array(map3.size);map3.forEach(function(value,key){result2[++index]=[key,value]});return result2}function overArg2(func,transform2){return function(arg){return func(transform2(arg))}}function replaceHolders2(array,placeholder){var index=-1,length=array.length,resIndex=0,result2=[];while(++index<length){var value=array[index];if(value===placeholder||value===PLACEHOLDER3){array[index]=PLACEHOLDER3;result2[resIndex++]=index}}return result2}function setToArray2(set3){var index=-1,result2=Array(set3.size);set3.forEach(function(value){result2[++index]=value});return result2}function setToPairs2(set3){var index=-1,result2=Array(set3.size);set3.forEach(function(value){result2[++index]=[value,value]});return result2}function strictIndexOf2(array,value,fromIndex){var index=fromIndex-1,length=array.length;while(++index<length){if(array[index]===value){return index}}return-1}function strictLastIndexOf2(array,value,fromIndex){var index=fromIndex+1;while(index--){if(array[index]===value){return index}}return index}function stringSize2(string){return hasUnicode2(string)?unicodeSize2(string):asciiSize2(string)}function stringToArray2(string){return hasUnicode2(string)?unicodeToArray2(string):asciiToArray2(string)}function trimmedEndIndex2(string){var index=string.length;while(index--&&reWhitespace2.test(string.charAt(index))){}return index}var unescapeHtmlChar2=basePropertyOf2(htmlUnescapes2);function unicodeSize2(string){var result2=reUnicode3.lastIndex=0;while(reUnicode3.test(string)){++result2}return result2}function unicodeToArray2(string){return string.match(reUnicode3)||[]}function unicodeWords2(string){return string.match(reUnicodeWord2)||[]}var runInContext=function runInContext2(context){context=context==null?root2:_.defaults(root2.Object(),context,_.pick(root2,contextProps));var Array2=context.Array,Date2=context.Date,Error2=context.Error,Function2=context.Function,Math2=context.Math,Object2=context.Object,RegExp2=context.RegExp,String2=context.String,TypeError2=context.TypeError;var arrayProto7=Array2.prototype,funcProto4=Function2.prototype,objectProto30=Object2.prototype;var coreJsData2=context["__core-js_shared__"];var funcToString4=funcProto4.toString;var hasOwnProperty26=objectProto30.hasOwnProperty;var idCounter2=0;var maskSrcKey2=function(){var uid=/[^.]+$/.exec(coreJsData2&&coreJsData2.keys&&coreJsData2.keys.IE_PROTO||"");return uid?"Symbol(src)_1."+uid:""}();var nativeObjectToString5=objectProto30.toString;var objectCtorString2=funcToString4.call(Object2);var oldDash=root2._;var reIsNative2=RegExp2("^"+funcToString4.call(hasOwnProperty26).replace(reRegExpChar3,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Buffer12=moduleExports4?context.Buffer:undefined2,Symbol3=context.Symbol,Uint8Array3=context.Uint8Array,allocUnsafe2=Buffer12?Buffer12.allocUnsafe:undefined2,getPrototype2=overArg2(Object2.getPrototypeOf,Object2),objectCreate2=Object2.create,propertyIsEnumerable3=objectProto30.propertyIsEnumerable,splice4=arrayProto7.splice,spreadableSymbol2=Symbol3?Symbol3.isConcatSpreadable:undefined2,symIterator3=Symbol3?Symbol3.iterator:undefined2,symToStringTag3=Symbol3?Symbol3.toStringTag:undefined2;var defineProperty2=function(){try{var func=getNative2(Object2,"defineProperty");func({},"",{});return func}catch(e){}}();var ctxClearTimeout=context.clearTimeout!==root2.clearTimeout&&context.clearTimeout,ctxNow=Date2&&Date2.now!==root2.Date.now&&Date2.now,ctxSetTimeout=context.setTimeout!==root2.setTimeout&&context.setTimeout;var nativeCeil5=Math2.ceil,nativeFloor5=Math2.floor,nativeGetSymbols3=Object2.getOwnPropertySymbols,nativeIsBuffer2=Buffer12?Buffer12.isBuffer:undefined2,nativeIsFinite3=context.isFinite,nativeJoin2=arrayProto7.join,nativeKeys2=overArg2(Object2.keys,Object2),nativeMax18=Math2.max,nativeMin16=Math2.min,nativeNow2=Date2.now,nativeParseInt2=context.parseInt,nativeRandom3=Math2.random,nativeReverse2=arrayProto7.reverse;var DataView3=getNative2(context,"DataView"),Map3=getNative2(context,"Map"),Promise3=getNative2(context,"Promise"),Set3=getNative2(context,"Set"),WeakMap3=getNative2(context,"WeakMap"),nativeCreate2=getNative2(Object2,"create");var metaMap2=WeakMap3&&new WeakMap3;var realNames2={};var dataViewCtorString2=toSource2(DataView3),mapCtorString2=toSource2(Map3),promiseCtorString2=toSource2(Promise3),setCtorString2=toSource2(Set3),weakMapCtorString2=toSource2(WeakMap3);var symbolProto4=Symbol3?Symbol3.prototype:undefined2,symbolValueOf3=symbolProto4?symbolProto4.valueOf:undefined2,symbolToString2=symbolProto4?symbolProto4.toString:undefined2;function lodash3(value){if(isObjectLike3(value)&&!isArray3(value)&&!(value instanceof LazyWrapper2)){if(value instanceof LodashWrapper2){return value}if(hasOwnProperty26.call(value,"__wrapped__")){return wrapperClone2(value)}}return new LodashWrapper2(value)}var baseCreate2=function(){function object(){}return function(proto2){if(!isObject4(proto2)){return{}}if(objectCreate2){return objectCreate2(proto2)}object.prototype=proto2;var result3=new object;object.prototype=undefined2;return result3}}();function baseLodash2(){}function LodashWrapper2(value,chainAll){this.__wrapped__=value;this.__actions__=[];this.__chain__=!!chainAll;this.__index__=0;this.__values__=undefined2}lodash3.templateSettings={"escape":reEscape2,"evaluate":reEvaluate2,"interpolate":reInterpolate2,"variable":"","imports":{"_":lodash3}};lodash3.prototype=baseLodash2.prototype;lodash3.prototype.constructor=lodash3;LodashWrapper2.prototype=baseCreate2(baseLodash2.prototype);LodashWrapper2.prototype.constructor=LodashWrapper2;function LazyWrapper2(value){this.__wrapped__=value;this.__actions__=[];this.__dir__=1;this.__filtered__=false;this.__iteratees__=[];this.__takeCount__=MAX_ARRAY_LENGTH8;this.__views__=[]}function lazyClone2(){var result3=new LazyWrapper2(this.__wrapped__);result3.__actions__=copyArray2(this.__actions__);result3.__dir__=this.__dir__;result3.__filtered__=this.__filtered__;result3.__iteratees__=copyArray2(this.__iteratees__);result3.__takeCount__=this.__takeCount__;result3.__views__=copyArray2(this.__views__);return result3}function lazyReverse2(){if(this.__filtered__){var result3=new LazyWrapper2(this);result3.__dir__=-1;result3.__filtered__=true}else{result3=this.clone();result3.__dir__*=-1}return result3}function lazyValue2(){var array=this.__wrapped__.value(),dir=this.__dir__,isArr=isArray3(array),isRight=dir<0,arrLength=isArr?array.length:0,view=getView2(0,arrLength,this.__views__),start=view.start,end=view.end,length=end-start,index=isRight?end:start-1,iteratees=this.__iteratees__,iterLength=iteratees.length,resIndex=0,takeCount=nativeMin16(length,this.__takeCount__);if(!isArr||!isRight&&arrLength==length&&takeCount==length){return baseWrapperValue2(array,this.__actions__)}var result3=[];outer:while(length--&&resIndex<takeCount){index+=dir;var iterIndex=-1,value=array[index];while(++iterIndex<iterLength){var data=iteratees[iterIndex],iteratee3=data.iteratee,type2=data.type,computed=iteratee3(value);if(type2==LAZY_MAP_FLAG2){value=computed}else if(!computed){if(type2==LAZY_FILTER_FLAG3){continue outer}else{break outer}}}result3[resIndex++]=value}return result3}LazyWrapper2.prototype=baseCreate2(baseLodash2.prototype);LazyWrapper2.prototype.constructor=LazyWrapper2;function Hash2(entries2){var index=-1,length=entries2==null?0:entries2.length;this.clear();while(++index<length){var entry=entries2[index];this.set(entry[0],entry[1])}}function hashClear2(){this.__data__=nativeCreate2?nativeCreate2(null):{};this.size=0}function hashDelete2(key){var result3=this.has(key)&&delete this.__data__[key];this.size-=result3?1:0;return result3}function hashGet2(key){var data=this.__data__;if(nativeCreate2){var result3=data[key];return result3===HASH_UNDEFINED4?undefined2:result3}return hasOwnProperty26.call(data,key)?data[key]:undefined2}function hashHas2(key){var data=this.__data__;return nativeCreate2?data[key]!==undefined2:hasOwnProperty26.call(data,key)}function hashSet2(key,value){var data=this.__data__;this.size+=this.has(key)?0:1;data[key]=nativeCreate2&&value===undefined2?HASH_UNDEFINED4:value;return this}Hash2.prototype.clear=hashClear2;Hash2.prototype["delete"]=hashDelete2;Hash2.prototype.get=hashGet2;Hash2.prototype.has=hashHas2;Hash2.prototype.set=hashSet2;function ListCache2(entries2){var index=-1,length=entries2==null?0:entries2.length;this.clear();while(++index<length){var entry=entries2[index];this.set(entry[0],entry[1])}}function listCacheClear2(){this.__data__=[];this.size=0}function listCacheDelete2(key){var data=this.__data__,index=assocIndexOf2(data,key);if(index<0){return false}var lastIndex=data.length-1;if(index==lastIndex){data.pop()}else{splice4.call(data,index,1)}--this.size;return true}function listCacheGet2(key){var data=this.__data__,index=assocIndexOf2(data,key);return index<0?undefined2:data[index][1]}function listCacheHas2(key){return assocIndexOf2(this.__data__,key)>-1}function listCacheSet2(key,value){var data=this.__data__,index=assocIndexOf2(data,key);if(index<0){++this.size;data.push([key,value])}else{data[index][1]=value}return this}ListCache2.prototype.clear=listCacheClear2;ListCache2.prototype["delete"]=listCacheDelete2;ListCache2.prototype.get=listCacheGet2;ListCache2.prototype.has=listCacheHas2;ListCache2.prototype.set=listCacheSet2;function MapCache2(entries2){var index=-1,length=entries2==null?0:entries2.length;this.clear();while(++index<length){var entry=entries2[index];this.set(entry[0],entry[1])}}function mapCacheClear2(){this.size=0;this.__data__={"hash":new Hash2,"map":new(Map3||ListCache2),"string":new Hash2}}function mapCacheDelete2(key){var result3=getMapData2(this,key)["delete"](key);this.size-=result3?1:0;return result3}function mapCacheGet2(key){return getMapData2(this,key).get(key)}function mapCacheHas2(key){return getMapData2(this,key).has(key)}function mapCacheSet2(key,value){var data=getMapData2(this,key),size3=data.size;data.set(key,value);this.size+=data.size==size3?0:1;return this}MapCache2.prototype.clear=mapCacheClear2;MapCache2.prototype["delete"]=mapCacheDelete2;MapCache2.prototype.get=mapCacheGet2;MapCache2.prototype.has=mapCacheHas2;MapCache2.prototype.set=mapCacheSet2;function SetCache2(values3){var index=-1,length=values3==null?0:values3.length;this.__data__=new MapCache2;while(++index<length){this.add(values3[index])}}function setCacheAdd2(value){this.__data__.set(value,HASH_UNDEFINED4);return this}function setCacheHas2(value){return this.__data__.has(value)}SetCache2.prototype.add=SetCache2.prototype.push=setCacheAdd2;SetCache2.prototype.has=setCacheHas2;function Stack2(entries2){var data=this.__data__=new ListCache2(entries2);this.size=data.size}function stackClear2(){this.__data__=new ListCache2;this.size=0}function stackDelete2(key){var data=this.__data__,result3=data["delete"](key);this.size=data.size;return result3}function stackGet2(key){return this.__data__.get(key)}function stackHas2(key){return this.__data__.has(key)}function stackSet2(key,value){var data=this.__data__;if(data instanceof ListCache2){var pairs2=data.__data__;if(!Map3||pairs2.length<LARGE_ARRAY_SIZE4-1){pairs2.push([key,value]);this.size=++data.size;return this}data=this.__data__=new MapCache2(pairs2)}data.set(key,value);this.size=data.size;return this}Stack2.prototype.clear=stackClear2;Stack2.prototype["delete"]=stackDelete2;Stack2.prototype.get=stackGet2;Stack2.prototype.has=stackHas2;Stack2.prototype.set=stackSet2;function arrayLikeKeys2(value,inherited){var isArr=isArray3(value),isArg=!isArr&&isArguments2(value),isBuff=!isArr&&!isArg&&isBuffer2(value),isType=!isArr&&!isArg&&!isBuff&&isTypedArray2(value),skipIndexes=isArr||isArg||isBuff||isType,result3=skipIndexes?baseTimes2(value.length,String2):[],length=result3.length;for(var key in value){if((inherited||hasOwnProperty26.call(value,key))&&!(skipIndexes&&(key=="length"||isBuff&&(key=="offset"||key=="parent")||isType&&(key=="buffer"||key=="byteLength"||key=="byteOffset")||isIndex2(key,length)))){result3.push(key)}}return result3}function arraySample2(array){var length=array.length;return length?array[baseRandom2(0,length-1)]:undefined2}function arraySampleSize2(array,n){return shuffleSelf2(copyArray2(array),baseClamp2(n,0,array.length))}function arrayShuffle2(array){return shuffleSelf2(copyArray2(array))}function assignMergeValue2(object,key,value){if(value!==undefined2&&!eq2(object[key],value)||value===undefined2&&!(key in object)){baseAssignValue2(object,key,value)}}function assignValue2(object,key,value){var objValue=object[key];if(!(hasOwnProperty26.call(object,key)&&eq2(objValue,value))||value===undefined2&&!(key in object)){baseAssignValue2(object,key,value)}}function assocIndexOf2(array,key){var length=array.length;while(length--){if(eq2(array[length][0],key)){return length}}return-1}function baseAggregator2(collection,setter,iteratee3,accumulator){baseEach2(collection,function(value,key,collection2){setter(accumulator,value,iteratee3(value),collection2)});return accumulator}function baseAssign2(object,source){return object&&copyObject2(source,keys2(source),object)}function baseAssignIn2(object,source){return object&&copyObject2(source,keysIn2(source),object)}function baseAssignValue2(object,key,value){if(key=="__proto__"&&defineProperty2){defineProperty2(object,key,{"configurable":true,"enumerable":true,"value":value,"writable":true})}else{object[key]=value}}function baseAt2(object,paths){var index=-1,length=paths.length,result3=Array2(length),skip=object==null;while(++index<length){result3[index]=skip?undefined2:get4(object,paths[index])}return result3}function baseClamp2(number2,lower,upper){if(number2===number2){if(upper!==undefined2){number2=number2<=upper?number2:upper}if(lower!==undefined2){number2=number2>=lower?number2:lower}}return number2}function baseClone2(value,bitmask,customizer,key,object,stack2){var result3,isDeep=bitmask&CLONE_DEEP_FLAG9,isFlat=bitmask&CLONE_FLAT_FLAG3,isFull=bitmask&CLONE_SYMBOLS_FLAG7;if(customizer){result3=object?customizer(value,key,object,stack2):customizer(value)}if(result3!==undefined2){return result3}if(!isObject4(value)){return value}var isArr=isArray3(value);if(isArr){result3=initCloneArray2(value);if(!isDeep){return copyArray2(value,result3)}}else{var tag=getTag3(value),isFunc=tag==funcTag4||tag==genTag3;if(isBuffer2(value)){return cloneBuffer2(value,isDeep)}if(tag==objectTag6||tag==argsTag5||isFunc&&!object){result3=isFlat||isFunc?{}:initCloneObject2(value);if(!isDeep){return isFlat?copySymbolsIn2(value,baseAssignIn2(result3,value)):copySymbols2(value,baseAssign2(result3,value))}}else{if(!cloneableTags2[tag]){return object?value:{}}result3=initCloneByTag2(value,tag,isDeep)}}stack2||(stack2=new Stack2);var stacked=stack2.get(value);if(stacked){return stacked}stack2.set(value,result3);if(isSet2(value)){value.forEach(function(subValue){result3.add(baseClone2(subValue,bitmask,customizer,subValue,value,stack2))})}else if(isMap2(value)){value.forEach(function(subValue,key2){result3.set(key2,baseClone2(subValue,bitmask,customizer,key2,value,stack2))})}var keysFunc=isFull?isFlat?getAllKeysIn2:getAllKeys2:isFlat?keysIn2:keys2;var props=isArr?undefined2:keysFunc(value);arrayEach2(props||value,function(subValue,key2){if(props){key2=subValue;subValue=value[key2]}assignValue2(result3,key2,baseClone2(subValue,bitmask,customizer,key2,value,stack2))});return result3}function baseConforms2(source){var props=keys2(source);return function(object){return baseConformsTo2(object,source,props)}}function baseConformsTo2(object,source,props){var length=props.length;if(object==null){return!length}object=Object2(object);while(length--){var key=props[length],predicate=source[key],value=object[key];if(value===undefined2&&!(key in object)||!predicate(value)){return false}}return true}function baseDelay2(func,wait,args2){if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}return setTimeout3(function(){func.apply(undefined2,args2)},wait)}function baseDifference2(array,values3,iteratee3,comparator){var index=-1,includes3=arrayIncludes2,isCommon=true,length=array.length,result3=[],valuesLength=values3.length;if(!length){return result3}if(iteratee3){values3=arrayMap2(values3,baseUnary2(iteratee3))}if(comparator){includes3=arrayIncludesWith2;isCommon=false}else if(values3.length>=LARGE_ARRAY_SIZE4){includes3=cacheHas2;isCommon=false;values3=new SetCache2(values3)}outer:while(++index<length){var value=array[index],computed=iteratee3==null?value:iteratee3(value);value=comparator||value!==0?value:0;if(isCommon&&computed===computed){var valuesIndex=valuesLength;while(valuesIndex--){if(values3[valuesIndex]===computed){continue outer}}result3.push(value)}else if(!includes3(values3,computed,comparator)){result3.push(value)}}return result3}var baseEach2=createBaseEach2(baseForOwn2);var baseEachRight2=createBaseEach2(baseForOwnRight2,true);function baseEvery2(collection,predicate){var result3=true;baseEach2(collection,function(value,index,collection2){result3=!!predicate(value,index,collection2);return result3});return result3}function baseExtremum2(array,iteratee3,comparator){var index=-1,length=array.length;while(++index<length){var value=array[index],current=iteratee3(value);if(current!=null&&(computed===undefined2?current===current&&!isSymbol2(current):comparator(current,computed))){var computed=current,result3=value}}return result3}function baseFill2(array,value,start,end){var length=array.length;start=toInteger2(start);if(start<0){start=-start>length?0:length+start}end=end===undefined2||end>length?length:toInteger2(end);if(end<0){end+=length}end=start>end?0:toLength2(end);while(start<end){array[start++]=value}return array}function baseFilter2(collection,predicate){var result3=[];baseEach2(collection,function(value,index,collection2){if(predicate(value,index,collection2)){result3.push(value)}});return result3}function baseFlatten2(array,depth,predicate,isStrict,result3){var index=-1,length=array.length;predicate||(predicate=isFlattenable2);result3||(result3=[]);while(++index<length){var value=array[index];if(depth>0&&predicate(value)){if(depth>1){baseFlatten2(value,depth-1,predicate,isStrict,result3)}else{arrayPush2(result3,value)}}else if(!isStrict){result3[result3.length]=value}}return result3}var baseFor2=createBaseFor2();var baseForRight2=createBaseFor2(true);function baseForOwn2(object,iteratee3){return object&&baseFor2(object,iteratee3,keys2)}function baseForOwnRight2(object,iteratee3){return object&&baseForRight2(object,iteratee3,keys2)}function baseFunctions2(object,props){return arrayFilter2(props,function(key){return isFunction3(object[key])})}function baseGet2(object,path27){path27=castPath2(path27,object);var index=0,length=path27.length;while(object!=null&&index<length){object=object[toKey2(path27[index++])]}return index&&index==length?object:undefined2}function baseGetAllKeys2(object,keysFunc,symbolsFunc){var result3=keysFunc(object);return isArray3(object)?result3:arrayPush2(result3,symbolsFunc(object))}function baseGetTag2(value){if(value==null){return value===undefined2?undefinedTag2:nullTag2}return symToStringTag3&&symToStringTag3 in Object2(value)?getRawTag2(value):objectToString2(value)}function baseGt2(value,other){return value>other}function baseHas2(object,key){return object!=null&&hasOwnProperty26.call(object,key)}function baseHasIn2(object,key){return object!=null&&key in Object2(object)}function baseInRange2(number2,start,end){return number2>=nativeMin16(start,end)&&number2<nativeMax18(start,end)}function baseIntersection2(arrays,iteratee3,comparator){var includes3=comparator?arrayIncludesWith2:arrayIncludes2,length=arrays[0].length,othLength=arrays.length,othIndex=othLength,caches=Array2(othLength),maxLength=Infinity,result3=[];while(othIndex--){var array=arrays[othIndex];if(othIndex&&iteratee3){array=arrayMap2(array,baseUnary2(iteratee3))}maxLength=nativeMin16(array.length,maxLength);caches[othIndex]=!comparator&&(iteratee3||length>=120&&array.length>=120)?new SetCache2(othIndex&&array):undefined2}array=arrays[0];var index=-1,seen=caches[0];outer:while(++index<length&&result3.length<maxLength){var value=array[index],computed=iteratee3?iteratee3(value):value;value=comparator||value!==0?value:0;if(!(seen?cacheHas2(seen,computed):includes3(result3,computed,comparator))){othIndex=othLength;while(--othIndex){var cache2=caches[othIndex];if(!(cache2?cacheHas2(cache2,computed):includes3(arrays[othIndex],computed,comparator))){continue outer}}if(seen){seen.push(computed)}result3.push(value)}}return result3}function baseInverter2(object,setter,iteratee3,accumulator){baseForOwn2(object,function(value,key,object2){setter(accumulator,iteratee3(value),key,object2)});return accumulator}function baseInvoke2(object,path27,args2){path27=castPath2(path27,object);object=parent2(object,path27);var func=object==null?object:object[toKey2(last2(path27))];return func==null?undefined2:apply2(func,object,args2)}function baseIsArguments2(value){return isObjectLike3(value)&&baseGetTag2(value)==argsTag5}function baseIsArrayBuffer2(value){return isObjectLike3(value)&&baseGetTag2(value)==arrayBufferTag6}function baseIsDate2(value){return isObjectLike3(value)&&baseGetTag2(value)==dateTag6}function baseIsEqual2(value,other,bitmask,customizer,stack2){if(value===other){return true}if(value==null||other==null||!isObjectLike3(value)&&!isObjectLike3(other)){return value!==value&&other!==other}return baseIsEqualDeep2(value,other,bitmask,customizer,baseIsEqual2,stack2)}function baseIsEqualDeep2(object,other,bitmask,customizer,equalFunc,stack2){var objIsArr=isArray3(object),othIsArr=isArray3(other),objTag=objIsArr?arrayTag4:getTag3(object),othTag=othIsArr?arrayTag4:getTag3(other);objTag=objTag==argsTag5?objectTag6:objTag;othTag=othTag==argsTag5?objectTag6:othTag;var objIsObj=objTag==objectTag6,othIsObj=othTag==objectTag6,isSameTag=objTag==othTag;if(isSameTag&&isBuffer2(object)){if(!isBuffer2(other)){return false}objIsArr=true;objIsObj=false}if(isSameTag&&!objIsObj){stack2||(stack2=new Stack2);return objIsArr||isTypedArray2(object)?equalArrays2(object,other,bitmask,customizer,equalFunc,stack2):equalByTag2(object,other,objTag,bitmask,customizer,equalFunc,stack2)}if(!(bitmask&COMPARE_PARTIAL_FLAG7)){var objIsWrapped=objIsObj&&hasOwnProperty26.call(object,"__wrapped__"),othIsWrapped=othIsObj&&hasOwnProperty26.call(other,"__wrapped__");if(objIsWrapped||othIsWrapped){var objUnwrapped=objIsWrapped?object.value():object,othUnwrapped=othIsWrapped?other.value():other;stack2||(stack2=new Stack2);return equalFunc(objUnwrapped,othUnwrapped,bitmask,customizer,stack2)}}if(!isSameTag){return false}stack2||(stack2=new Stack2);return equalObjects2(object,other,bitmask,customizer,equalFunc,stack2)}function baseIsMap2(value){return isObjectLike3(value)&&getTag3(value)==mapTag11}function baseIsMatch2(object,source,matchData,customizer){var index=matchData.length,length=index,noCustomizer=!customizer;if(object==null){return!length}object=Object2(object);while(index--){var data=matchData[index];if(noCustomizer&&data[2]?data[1]!==object[data[0]]:!(data[0]in object)){return false}}while(++index<length){data=matchData[index];var key=data[0],objValue=object[key],srcValue=data[1];if(noCustomizer&&data[2]){if(objValue===undefined2&&!(key in object)){return false}}else{var stack2=new Stack2;if(customizer){var result3=customizer(objValue,srcValue,key,object,source,stack2)}if(!(result3===undefined2?baseIsEqual2(srcValue,objValue,COMPARE_PARTIAL_FLAG7|COMPARE_UNORDERED_FLAG5,customizer,stack2):result3)){return false}}}return true}function baseIsNative2(value){if(!isObject4(value)||isMasked2(value)){return false}var pattern=isFunction3(value)?reIsNative2:reIsHostCtor2;return pattern.test(toSource2(value))}function baseIsRegExp2(value){return isObjectLike3(value)&&baseGetTag2(value)==regexpTag6}function baseIsSet2(value){return isObjectLike3(value)&&getTag3(value)==setTag11}function baseIsTypedArray2(value){return isObjectLike3(value)&&isLength2(value.length)&&!!typedArrayTags2[baseGetTag2(value)]}function baseIteratee2(value){if(typeof value=="function"){return value}if(value==null){return identity2}if(typeof value=="object"){return isArray3(value)?baseMatchesProperty2(value[0],value[1]):baseMatches2(value)}return property2(value)}function baseKeys2(object){if(!isPrototype2(object)){return nativeKeys2(object)}var result3=[];for(var key in Object2(object)){if(hasOwnProperty26.call(object,key)&&key!="constructor"){result3.push(key)}}return result3}function baseKeysIn2(object){if(!isObject4(object)){return nativeKeysIn2(object)}var isProto=isPrototype2(object),result3=[];for(var key in object){if(!(key=="constructor"&&(isProto||!hasOwnProperty26.call(object,key)))){result3.push(key)}}return result3}function baseLt2(value,other){return value<other}function baseMap2(collection,iteratee3){var index=-1,result3=isArrayLike2(collection)?Array2(collection.length):[];baseEach2(collection,function(value,key,collection2){result3[++index]=iteratee3(value,key,collection2)});return result3}function baseMatches2(source){var matchData=getMatchData2(source);if(matchData.length==1&&matchData[0][2]){return matchesStrictComparable2(matchData[0][0],matchData[0][1])}return function(object){return object===source||baseIsMatch2(object,source,matchData)}}function baseMatchesProperty2(path27,srcValue){if(isKey2(path27)&&isStrictComparable2(srcValue)){return matchesStrictComparable2(toKey2(path27),srcValue)}return function(object){var objValue=get4(object,path27);return objValue===undefined2&&objValue===srcValue?hasIn2(object,path27):baseIsEqual2(srcValue,objValue,COMPARE_PARTIAL_FLAG7|COMPARE_UNORDERED_FLAG5)}}function baseMerge2(object,source,srcIndex,customizer,stack2){if(object===source){return}baseFor2(source,function(srcValue,key){stack2||(stack2=new Stack2);if(isObject4(srcValue)){baseMergeDeep2(object,source,key,srcIndex,baseMerge2,customizer,stack2)}else{var newValue=customizer?customizer(safeGet2(object,key),srcValue,key+"",object,source,stack2):undefined2;if(newValue===undefined2){newValue=srcValue}assignMergeValue2(object,key,newValue)}},keysIn2)}function baseMergeDeep2(object,source,key,srcIndex,mergeFunc,customizer,stack2){var objValue=safeGet2(object,key),srcValue=safeGet2(source,key),stacked=stack2.get(srcValue);if(stacked){assignMergeValue2(object,key,stacked);return}var newValue=customizer?customizer(objValue,srcValue,key+"",object,source,stack2):undefined2;var isCommon=newValue===undefined2;if(isCommon){var isArr=isArray3(srcValue),isBuff=!isArr&&isBuffer2(srcValue),isTyped=!isArr&&!isBuff&&isTypedArray2(srcValue);newValue=srcValue;if(isArr||isBuff||isTyped){if(isArray3(objValue)){newValue=objValue}else if(isArrayLikeObject2(objValue)){newValue=copyArray2(objValue)}else if(isBuff){isCommon=false;newValue=cloneBuffer2(srcValue,true)}else if(isTyped){isCommon=false;newValue=cloneTypedArray2(srcValue,true)}else{newValue=[]}}else if(isPlainObject3(srcValue)||isArguments2(srcValue)){newValue=objValue;if(isArguments2(objValue)){newValue=toPlainObject2(objValue)}else if(!isObject4(objValue)||isFunction3(objValue)){newValue=initCloneObject2(srcValue)}}else{isCommon=false}}if(isCommon){stack2.set(srcValue,newValue);mergeFunc(newValue,srcValue,srcIndex,customizer,stack2);stack2["delete"](srcValue)}assignMergeValue2(object,key,newValue)}function baseNth2(array,n){var length=array.length;if(!length){return}n+=n<0?length:0;return isIndex2(n,length)?array[n]:undefined2}function baseOrderBy2(collection,iteratees,orders){if(iteratees.length){iteratees=arrayMap2(iteratees,function(iteratee3){if(isArray3(iteratee3)){return function(value){return baseGet2(value,iteratee3.length===1?iteratee3[0]:iteratee3)}}return iteratee3})}else{iteratees=[identity2]}var index=-1;iteratees=arrayMap2(iteratees,baseUnary2(getIteratee()));var result3=baseMap2(collection,function(value,key,collection2){var criteria=arrayMap2(iteratees,function(iteratee3){return iteratee3(value)});return{"criteria":criteria,"index":++index,"value":value}});return baseSortBy2(result3,function(object,other){return compareMultiple2(object,other,orders)})}function basePick2(object,paths){return basePickBy2(object,paths,function(value,path27){return hasIn2(object,path27)})}function basePickBy2(object,paths,predicate){var index=-1,length=paths.length,result3={};while(++index<length){var path27=paths[index],value=baseGet2(object,path27);if(predicate(value,path27)){baseSet2(result3,castPath2(path27,object),value)}}return result3}function basePropertyDeep2(path27){return function(object){return baseGet2(object,path27)}}function basePullAll2(array,values3,iteratee3,comparator){var indexOf3=comparator?baseIndexOfWith2:baseIndexOf2,index=-1,length=values3.length,seen=array;if(array===values3){values3=copyArray2(values3)}if(iteratee3){seen=arrayMap2(array,baseUnary2(iteratee3))}while(++index<length){var fromIndex=0,value=values3[index],computed=iteratee3?iteratee3(value):value;while((fromIndex=indexOf3(seen,computed,fromIndex,comparator))>-1){if(seen!==array){splice4.call(seen,fromIndex,1)}splice4.call(array,fromIndex,1)}}return array}function basePullAt2(array,indexes){var length=array?indexes.length:0,lastIndex=length-1;while(length--){var index=indexes[length];if(length==lastIndex||index!==previous){var previous=index;if(isIndex2(index)){splice4.call(array,index,1)}else{baseUnset2(array,index)}}}return array}function baseRandom2(lower,upper){return lower+nativeFloor5(nativeRandom3()*(upper-lower+1))}function baseRange2(start,end,step,fromRight){var index=-1,length=nativeMax18(nativeCeil5((end-start)/(step||1)),0),result3=Array2(length);while(length--){result3[fromRight?length:++index]=start;start+=step}return result3}function baseRepeat2(string,n){var result3="";if(!string||n<1||n>MAX_SAFE_INTEGER7){return result3}do{if(n%2){result3+=string}n=nativeFloor5(n/2);if(n){string+=string}}while(n);return result3}function baseRest2(func,start){return setToString2(overRest2(func,start,identity2),func+"")}function baseSample2(collection){return arraySample2(values2(collection))}function baseSampleSize2(collection,n){var array=values2(collection);return shuffleSelf2(array,baseClamp2(n,0,array.length))}function baseSet2(object,path27,value,customizer){if(!isObject4(object)){return object}path27=castPath2(path27,object);var index=-1,length=path27.length,lastIndex=length-1,nested=object;while(nested!=null&&++index<length){var key=toKey2(path27[index]),newValue=value;if(key==="__proto__"||key==="constructor"||key==="prototype"){return object}if(index!=lastIndex){var objValue=nested[key];newValue=customizer?customizer(objValue,key,nested):undefined2;if(newValue===undefined2){newValue=isObject4(objValue)?objValue:isIndex2(path27[index+1])?[]:{}}}assignValue2(nested,key,newValue);nested=nested[key]}return object}var baseSetData2=!metaMap2?identity2:function(func,data){metaMap2.set(func,data);return func};var baseSetToString2=!defineProperty2?identity2:function(func,string){return defineProperty2(func,"toString",{"configurable":true,"enumerable":false,"value":constant2(string),"writable":true})};function baseShuffle2(collection){return shuffleSelf2(values2(collection))}function baseSlice2(array,start,end){var index=-1,length=array.length;if(start<0){start=-start>length?0:length+start}end=end>length?length:end;if(end<0){end+=length}length=start>end?0:end-start>>>0;start>>>=0;var result3=Array2(length);while(++index<length){result3[index]=array[index+start]}return result3}function baseSome2(collection,predicate){var result3;baseEach2(collection,function(value,index,collection2){result3=predicate(value,index,collection2);return!result3});return!!result3}function baseSortedIndex2(array,value,retHighest){var low=0,high=array==null?low:array.length;if(typeof value=="number"&&value===value&&high<=HALF_MAX_ARRAY_LENGTH2){while(low<high){var mid=low+high>>>1,computed=array[mid];if(computed!==null&&!isSymbol2(computed)&&(retHighest?computed<=value:computed<value)){low=mid+1}else{high=mid}}return high}return baseSortedIndexBy2(array,value,identity2,retHighest)}function baseSortedIndexBy2(array,value,iteratee3,retHighest){var low=0,high=array==null?0:array.length;if(high===0){return 0}value=iteratee3(value);var valIsNaN=value!==value,valIsNull=value===null,valIsSymbol=isSymbol2(value),valIsUndefined=value===undefined2;while(low<high){var mid=nativeFloor5((low+high)/2),computed=iteratee3(array[mid]),othIsDefined=computed!==undefined2,othIsNull=computed===null,othIsReflexive=computed===computed,othIsSymbol=isSymbol2(computed);if(valIsNaN){var setLow=retHighest||othIsReflexive}else if(valIsUndefined){setLow=othIsReflexive&&(retHighest||othIsDefined)}else if(valIsNull){setLow=othIsReflexive&&othIsDefined&&(retHighest||!othIsNull)}else if(valIsSymbol){setLow=othIsReflexive&&othIsDefined&&!othIsNull&&(retHighest||!othIsSymbol)}else if(othIsNull||othIsSymbol){setLow=false}else{setLow=retHighest?computed<=value:computed<value}if(setLow){low=mid+1}else{high=mid}}return nativeMin16(high,MAX_ARRAY_INDEX2)}function baseSortedUniq2(array,iteratee3){var index=-1,length=array.length,resIndex=0,result3=[];while(++index<length){var value=array[index],computed=iteratee3?iteratee3(value):value;if(!index||!eq2(computed,seen)){var seen=computed;result3[resIndex++]=value===0?0:value}}return result3}function baseToNumber2(value){if(typeof value=="number"){return value}if(isSymbol2(value)){return NAN4}return+value}function baseToString3(value){if(typeof value=="string"){return value}if(isArray3(value)){return arrayMap2(value,baseToString3)+""}if(isSymbol2(value)){return symbolToString2?symbolToString2.call(value):""}var result3=value+"";return result3=="0"&&1/value==-INFINITY8?"-0":result3}function baseUniq2(array,iteratee3,comparator){var index=-1,includes3=arrayIncludes2,length=array.length,isCommon=true,result3=[],seen=result3;if(comparator){isCommon=false;includes3=arrayIncludesWith2}else if(length>=LARGE_ARRAY_SIZE4){var set4=iteratee3?null:createSet2(array);if(set4){return setToArray2(set4)}isCommon=false;includes3=cacheHas2;seen=new SetCache2}else{seen=iteratee3?[]:result3}outer:while(++index<length){var value=array[index],computed=iteratee3?iteratee3(value):value;value=comparator||value!==0?value:0;if(isCommon&&computed===computed){var seenIndex=seen.length;while(seenIndex--){if(seen[seenIndex]===computed){continue outer}}if(iteratee3){seen.push(computed)}result3.push(value)}else if(!includes3(seen,computed,comparator)){if(seen!==result3){seen.push(computed)}result3.push(value)}}return result3}function baseUnset2(object,path27){path27=castPath2(path27,object);object=parent2(object,path27);return object==null||delete object[toKey2(last2(path27))]}function baseUpdate2(object,path27,updater,customizer){return baseSet2(object,path27,updater(baseGet2(object,path27)),customizer)}function baseWhile2(array,predicate,isDrop,fromRight){var length=array.length,index=fromRight?length:-1;while((fromRight?index--:++index<length)&&predicate(array[index],index,array)){}return isDrop?baseSlice2(array,fromRight?0:index,fromRight?index+1:length):baseSlice2(array,fromRight?index+1:0,fromRight?length:index)}function baseWrapperValue2(value,actions){var result3=value;if(result3 instanceof LazyWrapper2){result3=result3.value()}return arrayReduce2(actions,function(result4,action){return action.func.apply(action.thisArg,arrayPush2([result4],action.args))},result3)}function baseXor2(arrays,iteratee3,comparator){var length=arrays.length;if(length<2){return length?baseUniq2(arrays[0]):[]}var index=-1,result3=Array2(length);while(++index<length){var array=arrays[index],othIndex=-1;while(++othIndex<length){if(othIndex!=index){result3[index]=baseDifference2(result3[index]||array,arrays[othIndex],iteratee3,comparator)}}}return baseUniq2(baseFlatten2(result3,1),iteratee3,comparator)}function baseZipObject2(props,values3,assignFunc){var index=-1,length=props.length,valsLength=values3.length,result3={};while(++index<length){var value=index<valsLength?values3[index]:undefined2;assignFunc(result3,props[index],value)}return result3}function castArrayLikeObject2(value){return isArrayLikeObject2(value)?value:[]}function castFunction2(value){return typeof value=="function"?value:identity2}function castPath2(value,object){if(isArray3(value)){return value}return isKey2(value,object)?[value]:stringToPath2(toString5(value))}var castRest2=baseRest2;function castSlice2(array,start,end){var length=array.length;end=end===undefined2?length:end;return!start&&end>=length?array:baseSlice2(array,start,end)}var clearTimeout2=ctxClearTimeout||function(id){return root2.clearTimeout(id)};function cloneBuffer2(buffer,isDeep){if(isDeep){return buffer.slice()}var length=buffer.length,result3=allocUnsafe2?allocUnsafe2(length):new buffer.constructor(length);buffer.copy(result3);return result3}function cloneArrayBuffer2(arrayBuffer){var result3=new arrayBuffer.constructor(arrayBuffer.byteLength);new Uint8Array3(result3).set(new Uint8Array3(arrayBuffer));return result3}function cloneDataView2(dataView,isDeep){var buffer=isDeep?cloneArrayBuffer2(dataView.buffer):dataView.buffer;return new dataView.constructor(buffer,dataView.byteOffset,dataView.byteLength)}function cloneRegExp2(regexp){var result3=new regexp.constructor(regexp.source,reFlags3.exec(regexp));result3.lastIndex=regexp.lastIndex;return result3}function cloneSymbol2(symbol){return symbolValueOf3?Object2(symbolValueOf3.call(symbol)):{}}function cloneTypedArray2(typedArray,isDeep){var buffer=isDeep?cloneArrayBuffer2(typedArray.buffer):typedArray.buffer;return new typedArray.constructor(buffer,typedArray.byteOffset,typedArray.length)}function compareAscending2(value,other){if(value!==other){var valIsDefined=value!==undefined2,valIsNull=value===null,valIsReflexive=value===value,valIsSymbol=isSymbol2(value);var othIsDefined=other!==undefined2,othIsNull=other===null,othIsReflexive=other===other,othIsSymbol=isSymbol2(other);if(!othIsNull&&!othIsSymbol&&!valIsSymbol&&value>other||valIsSymbol&&othIsDefined&&othIsReflexive&&!othIsNull&&!othIsSymbol||valIsNull&&othIsDefined&&othIsReflexive||!valIsDefined&&othIsReflexive||!valIsReflexive){return 1}if(!valIsNull&&!valIsSymbol&&!othIsSymbol&&value<other||othIsSymbol&&valIsDefined&&valIsReflexive&&!valIsNull&&!valIsSymbol||othIsNull&&valIsDefined&&valIsReflexive||!othIsDefined&&valIsReflexive||!othIsReflexive){return-1}}return 0}function compareMultiple2(object,other,orders){var index=-1,objCriteria=object.criteria,othCriteria=other.criteria,length=objCriteria.length,ordersLength=orders.length;while(++index<length){var result3=compareAscending2(objCriteria[index],othCriteria[index]);if(result3){if(index>=ordersLength){return result3}var order=orders[index];return result3*(order=="desc"?-1:1)}}return object.index-other.index}function composeArgs2(args2,partials,holders,isCurried){var argsIndex=-1,argsLength=args2.length,holdersLength=holders.length,leftIndex=-1,leftLength=partials.length,rangeLength=nativeMax18(argsLength-holdersLength,0),result3=Array2(leftLength+rangeLength),isUncurried=!isCurried;while(++leftIndex<leftLength){result3[leftIndex]=partials[leftIndex]}while(++argsIndex<holdersLength){if(isUncurried||argsIndex<argsLength){result3[holders[argsIndex]]=args2[argsIndex]}}while(rangeLength--){result3[leftIndex++]=args2[argsIndex++]}return result3}function composeArgsRight2(args2,partials,holders,isCurried){var argsIndex=-1,argsLength=args2.length,holdersIndex=-1,holdersLength=holders.length,rightIndex=-1,rightLength=partials.length,rangeLength=nativeMax18(argsLength-holdersLength,0),result3=Array2(rangeLength+rightLength),isUncurried=!isCurried;while(++argsIndex<rangeLength){result3[argsIndex]=args2[argsIndex]}var offset=argsIndex;while(++rightIndex<rightLength){result3[offset+rightIndex]=partials[rightIndex]}while(++holdersIndex<holdersLength){if(isUncurried||argsIndex<argsLength){result3[offset+holders[holdersIndex]]=args2[argsIndex++]}}return result3}function copyArray2(source,array){var index=-1,length=source.length;array||(array=Array2(length));while(++index<length){array[index]=source[index]}return array}function copyObject2(source,props,object,customizer){var isNew=!object;object||(object={});var index=-1,length=props.length;while(++index<length){var key=props[index];var newValue=customizer?customizer(object[key],source[key],key,object,source):undefined2;if(newValue===undefined2){newValue=source[key]}if(isNew){baseAssignValue2(object,key,newValue)}else{assignValue2(object,key,newValue)}}return object}function copySymbols2(source,object){return copyObject2(source,getSymbols2(source),object)}function copySymbolsIn2(source,object){return copyObject2(source,getSymbolsIn2(source),object)}function createAggregator2(setter,initializer){return function(collection,iteratee3){var func=isArray3(collection)?arrayAggregator2:baseAggregator2,accumulator=initializer?initializer():{};return func(collection,setter,getIteratee(iteratee3,2),accumulator)}}function createAssigner2(assigner){return baseRest2(function(object,sources){var index=-1,length=sources.length,customizer=length>1?sources[length-1]:undefined2,guard=length>2?sources[2]:undefined2;customizer=assigner.length>3&&typeof customizer=="function"?(length--,customizer):undefined2;if(guard&&isIterateeCall2(sources[0],sources[1],guard)){customizer=length<3?undefined2:customizer;length=1}object=Object2(object);while(++index<length){var source=sources[index];if(source){assigner(object,source,index,customizer)}}return object})}function createBaseEach2(eachFunc,fromRight){return function(collection,iteratee3){if(collection==null){return collection}if(!isArrayLike2(collection)){return eachFunc(collection,iteratee3)}var length=collection.length,index=fromRight?length:-1,iterable=Object2(collection);while(fromRight?index--:++index<length){if(iteratee3(iterable[index],index,iterable)===false){break}}return collection}}function createBaseFor2(fromRight){return function(object,iteratee3,keysFunc){var index=-1,iterable=Object2(object),props=keysFunc(object),length=props.length;while(length--){var key=props[fromRight?length:++index];if(iteratee3(iterable[key],key,iterable)===false){break}}return object}}function createBind2(func,bitmask,thisArg){var isBind=bitmask&WRAP_BIND_FLAG10,Ctor=createCtor2(func);function wrapper(){var fn2=this&&this!==root2&&this instanceof wrapper?Ctor:func;return fn2.apply(isBind?thisArg:this,arguments)}return wrapper}function createCaseFirst2(methodName){return function(string){string=toString5(string);var strSymbols=hasUnicode2(string)?stringToArray2(string):undefined2;var chr=strSymbols?strSymbols[0]:string.charAt(0);var trailing=strSymbols?castSlice2(strSymbols,1).join(""):string.slice(1);return chr[methodName]()+trailing}}function createCompounder2(callback){return function(string){return arrayReduce2(words2(deburr2(string).replace(reApos2,"")),callback,"")}}function createCtor2(Ctor){return function(){var args2=arguments;switch(args2.length){case 0:return new Ctor;case 1:return new Ctor(args2[0]);case 2:return new Ctor(args2[0],args2[1]);case 3:return new Ctor(args2[0],args2[1],args2[2]);case 4:return new Ctor(args2[0],args2[1],args2[2],args2[3]);case 5:return new Ctor(args2[0],args2[1],args2[2],args2[3],args2[4]);case 6:return new Ctor(args2[0],args2[1],args2[2],args2[3],args2[4],args2[5]);case 7:return new Ctor(args2[0],args2[1],args2[2],args2[3],args2[4],args2[5],args2[6])}var thisBinding=baseCreate2(Ctor.prototype),result3=Ctor.apply(thisBinding,args2);return isObject4(result3)?result3:thisBinding}}function createCurry2(func,bitmask,arity){var Ctor=createCtor2(func);function wrapper(){var length=arguments.length,args2=Array2(length),index=length,placeholder=getHolder2(wrapper);while(index--){args2[index]=arguments[index]}var holders=length<3&&args2[0]!==placeholder&&args2[length-1]!==placeholder?[]:replaceHolders2(args2,placeholder);length-=holders.length;if(length<arity){return createRecurry2(func,bitmask,createHybrid2,wrapper.placeholder,undefined2,args2,holders,undefined2,undefined2,arity-length)}var fn2=this&&this!==root2&&this instanceof wrapper?Ctor:func;return apply2(fn2,this,args2)}return wrapper}function createFind2(findIndexFunc){return function(collection,predicate,fromIndex){var iterable=Object2(collection);if(!isArrayLike2(collection)){var iteratee3=getIteratee(predicate,3);collection=keys2(collection);predicate=function(key){return iteratee3(iterable[key],key,iterable)}}var index=findIndexFunc(collection,predicate,fromIndex);return index>-1?iterable[iteratee3?collection[index]:index]:undefined2}}function createFlow2(fromRight){return flatRest2(function(funcs){var length=funcs.length,index=length,prereq=LodashWrapper2.prototype.thru;if(fromRight){funcs.reverse()}while(index--){var func=funcs[index];if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}if(prereq&&!wrapper&&getFuncName2(func)=="wrapper"){var wrapper=new LodashWrapper2([],true)}}index=wrapper?index:length;while(++index<length){func=funcs[index];var funcName=getFuncName2(func),data=funcName=="wrapper"?getData2(func):undefined2;if(data&&isLaziable2(data[0])&&data[1]==(WRAP_ARY_FLAG6|WRAP_CURRY_FLAG8|WRAP_PARTIAL_FLAG8|WRAP_REARG_FLAG5)&&!data[4].length&&data[9]==1){wrapper=wrapper[getFuncName2(data[0])].apply(wrapper,data[3])}else{wrapper=func.length==1&&isLaziable2(func)?wrapper[funcName]():wrapper.thru(func)}}return function(){var args2=arguments,value=args2[0];if(wrapper&&args2.length==1&&isArray3(value)){return wrapper.plant(value).value()}var index2=0,result3=length?funcs[index2].apply(this,args2):value;while(++index2<length){result3=funcs[index2].call(this,result3)}return result3}})}function createHybrid2(func,bitmask,thisArg,partials,holders,partialsRight,holdersRight,argPos,ary3,arity){var isAry=bitmask&WRAP_ARY_FLAG6,isBind=bitmask&WRAP_BIND_FLAG10,isBindKey=bitmask&WRAP_BIND_KEY_FLAG8,isCurried=bitmask&(WRAP_CURRY_FLAG8|WRAP_CURRY_RIGHT_FLAG5),isFlip=bitmask&WRAP_FLIP_FLAG4,Ctor=isBindKey?undefined2:createCtor2(func);function wrapper(){var length=arguments.length,args2=Array2(length),index=length;while(index--){args2[index]=arguments[index]}if(isCurried){var placeholder=getHolder2(wrapper),holdersCount=countHolders2(args2,placeholder)}if(partials){args2=composeArgs2(args2,partials,holders,isCurried)}if(partialsRight){args2=composeArgsRight2(args2,partialsRight,holdersRight,isCurried)}length-=holdersCount;if(isCurried&&length<arity){var newHolders=replaceHolders2(args2,placeholder);return createRecurry2(func,bitmask,createHybrid2,wrapper.placeholder,thisArg,args2,newHolders,argPos,ary3,arity-length)}var thisBinding=isBind?thisArg:this,fn2=isBindKey?thisBinding[func]:func;length=args2.length;if(argPos){args2=reorder2(args2,argPos)}else if(isFlip&&length>1){args2.reverse()}if(isAry&&ary3<length){args2.length=ary3}if(this&&this!==root2&&this instanceof wrapper){fn2=Ctor||createCtor2(fn2)}return fn2.apply(thisBinding,args2)}return wrapper}function createInverter2(setter,toIteratee){return function(object,iteratee3){return baseInverter2(object,setter,toIteratee(iteratee3),{})}}function createMathOperation2(operator,defaultValue){return function(value,other){var result3;if(value===undefined2&&other===undefined2){return defaultValue}if(value!==undefined2){result3=value}if(other!==undefined2){if(result3===undefined2){return other}if(typeof value=="string"||typeof other=="string"){value=baseToString3(value);other=baseToString3(other)}else{value=baseToNumber2(value);other=baseToNumber2(other)}result3=operator(value,other)}return result3}}function createOver2(arrayFunc){return flatRest2(function(iteratees){iteratees=arrayMap2(iteratees,baseUnary2(getIteratee()));return baseRest2(function(args2){var thisArg=this;return arrayFunc(iteratees,function(iteratee3){return apply2(iteratee3,thisArg,args2)})})})}function createPadding2(length,chars){chars=chars===undefined2?" ":baseToString3(chars);var charsLength=chars.length;if(charsLength<2){return charsLength?baseRepeat2(chars,length):chars}var result3=baseRepeat2(chars,nativeCeil5(length/stringSize2(chars)));return hasUnicode2(chars)?castSlice2(stringToArray2(result3),0,length).join(""):result3.slice(0,length)}function createPartial2(func,bitmask,thisArg,partials){var isBind=bitmask&WRAP_BIND_FLAG10,Ctor=createCtor2(func);function wrapper(){var argsIndex=-1,argsLength=arguments.length,leftIndex=-1,leftLength=partials.length,args2=Array2(leftLength+argsLength),fn2=this&&this!==root2&&this instanceof wrapper?Ctor:func;while(++leftIndex<leftLength){args2[leftIndex]=partials[leftIndex]}while(argsLength--){args2[leftIndex++]=arguments[++argsIndex]}return apply2(fn2,isBind?thisArg:this,args2)}return wrapper}function createRange2(fromRight){return function(start,end,step){if(step&&typeof step!="number"&&isIterateeCall2(start,end,step)){end=step=undefined2}start=toFinite2(start);if(end===undefined2){end=start;start=0}else{end=toFinite2(end)}step=step===undefined2?start<end?1:-1:toFinite2(step);return baseRange2(start,end,step,fromRight)}}function createRelationalOperation2(operator){return function(value,other){if(!(typeof value=="string"&&typeof other=="string")){value=toNumber2(value);other=toNumber2(other)}return operator(value,other)}}function createRecurry2(func,bitmask,wrapFunc,placeholder,thisArg,partials,holders,argPos,ary3,arity){var isCurry=bitmask&WRAP_CURRY_FLAG8,newHolders=isCurry?holders:undefined2,newHoldersRight=isCurry?undefined2:holders,newPartials=isCurry?partials:undefined2,newPartialsRight=isCurry?undefined2:partials;bitmask|=isCurry?WRAP_PARTIAL_FLAG8:WRAP_PARTIAL_RIGHT_FLAG5;bitmask&=~(isCurry?WRAP_PARTIAL_RIGHT_FLAG5:WRAP_PARTIAL_FLAG8);if(!(bitmask&WRAP_CURRY_BOUND_FLAG3)){bitmask&=~(WRAP_BIND_FLAG10|WRAP_BIND_KEY_FLAG8)}var newData=[func,bitmask,thisArg,newPartials,newHolders,newPartialsRight,newHoldersRight,argPos,ary3,arity];var result3=wrapFunc.apply(undefined2,newData);if(isLaziable2(func)){setData2(result3,newData)}result3.placeholder=placeholder;return setWrapToString2(result3,func,bitmask)}function createRound2(methodName){var func=Math2[methodName];return function(number2,precision){number2=toNumber2(number2);precision=precision==null?0:nativeMin16(toInteger2(precision),292);if(precision&&nativeIsFinite3(number2)){var pair=(toString5(number2)+"e").split("e"),value=func(pair[0]+"e"+(+pair[1]+precision));pair=(toString5(value)+"e").split("e");return+(pair[0]+"e"+(+pair[1]-precision))}return func(number2)}}var createSet2=!(Set3&&1/setToArray2(new Set3([,-0]))[1]==INFINITY8)?noop4:function(values3){return new Set3(values3)};function createToPairs2(keysFunc){return function(object){var tag=getTag3(object);if(tag==mapTag11){return mapToArray2(object)}if(tag==setTag11){return setToPairs2(object)}return baseToPairs2(object,keysFunc(object))}}function createWrap2(func,bitmask,thisArg,partials,holders,argPos,ary3,arity){var isBindKey=bitmask&WRAP_BIND_KEY_FLAG8;if(!isBindKey&&typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}var length=partials?partials.length:0;if(!length){bitmask&=~(WRAP_PARTIAL_FLAG8|WRAP_PARTIAL_RIGHT_FLAG5);partials=holders=undefined2}ary3=ary3===undefined2?ary3:nativeMax18(toInteger2(ary3),0);arity=arity===undefined2?arity:toInteger2(arity);length-=holders?holders.length:0;if(bitmask&WRAP_PARTIAL_RIGHT_FLAG5){var partialsRight=partials,holdersRight=holders;partials=holders=undefined2}var data=isBindKey?undefined2:getData2(func);var newData=[func,bitmask,thisArg,partials,holders,partialsRight,holdersRight,argPos,ary3,arity];if(data){mergeData2(newData,data)}func=newData[0];bitmask=newData[1];thisArg=newData[2];partials=newData[3];holders=newData[4];arity=newData[9]=newData[9]===undefined2?isBindKey?0:func.length:nativeMax18(newData[9]-length,0);if(!arity&&bitmask&(WRAP_CURRY_FLAG8|WRAP_CURRY_RIGHT_FLAG5)){bitmask&=~(WRAP_CURRY_FLAG8|WRAP_CURRY_RIGHT_FLAG5)}if(!bitmask||bitmask==WRAP_BIND_FLAG10){var result3=createBind2(func,bitmask,thisArg)}else if(bitmask==WRAP_CURRY_FLAG8||bitmask==WRAP_CURRY_RIGHT_FLAG5){result3=createCurry2(func,bitmask,arity)}else if((bitmask==WRAP_PARTIAL_FLAG8||bitmask==(WRAP_BIND_FLAG10|WRAP_PARTIAL_FLAG8))&&!holders.length){result3=createPartial2(func,bitmask,thisArg,partials)}else{result3=createHybrid2.apply(undefined2,newData)}var setter=data?baseSetData2:setData2;return setWrapToString2(setter(result3,newData),func,bitmask)}function customDefaultsAssignIn2(objValue,srcValue,key,object){if(objValue===undefined2||eq2(objValue,objectProto30[key])&&!hasOwnProperty26.call(object,key)){return srcValue}return objValue}function customDefaultsMerge2(objValue,srcValue,key,object,source,stack2){if(isObject4(objValue)&&isObject4(srcValue)){stack2.set(srcValue,objValue);baseMerge2(objValue,srcValue,undefined2,customDefaultsMerge2,stack2);stack2["delete"](srcValue)}return objValue}function customOmitClone2(value){return isPlainObject3(value)?undefined2:value}function equalArrays2(array,other,bitmask,customizer,equalFunc,stack2){var isPartial=bitmask&COMPARE_PARTIAL_FLAG7,arrLength=array.length,othLength=other.length;if(arrLength!=othLength&&!(isPartial&&othLength>arrLength)){return false}var arrStacked=stack2.get(array);var othStacked=stack2.get(other);if(arrStacked&&othStacked){return arrStacked==other&&othStacked==array}var index=-1,result3=true,seen=bitmask&COMPARE_UNORDERED_FLAG5?new SetCache2:undefined2;stack2.set(array,other);stack2.set(other,array);while(++index<arrLength){var arrValue=array[index],othValue=other[index];if(customizer){var compared=isPartial?customizer(othValue,arrValue,index,other,array,stack2):customizer(arrValue,othValue,index,array,other,stack2)}if(compared!==undefined2){if(compared){continue}result3=false;break}if(seen){if(!arraySome2(other,function(othValue2,othIndex){if(!cacheHas2(seen,othIndex)&&(arrValue===othValue2||equalFunc(arrValue,othValue2,bitmask,customizer,stack2))){return seen.push(othIndex)}})){result3=false;break}}else if(!(arrValue===othValue||equalFunc(arrValue,othValue,bitmask,customizer,stack2))){result3=false;break}}stack2["delete"](array);stack2["delete"](other);return result3}function equalByTag2(object,other,tag,bitmask,customizer,equalFunc,stack2){switch(tag){case dataViewTag6:if(object.byteLength!=other.byteLength||object.byteOffset!=other.byteOffset){return false}object=object.buffer;other=other.buffer;case arrayBufferTag6:if(object.byteLength!=other.byteLength||!equalFunc(new Uint8Array3(object),new Uint8Array3(other))){return false}return true;case boolTag6:case dateTag6:case numberTag6:return eq2(+object,+other);case errorTag5:return object.name==other.name&&object.message==other.message;case regexpTag6:case stringTag6:return object==other+"";case mapTag11:var convert=mapToArray2;case setTag11:var isPartial=bitmask&COMPARE_PARTIAL_FLAG7;convert||(convert=setToArray2);if(object.size!=other.size&&!isPartial){return false}var stacked=stack2.get(object);if(stacked){return stacked==other}bitmask|=COMPARE_UNORDERED_FLAG5;stack2.set(object,other);var result3=equalArrays2(convert(object),convert(other),bitmask,customizer,equalFunc,stack2);stack2["delete"](object);return result3;case symbolTag5:if(symbolValueOf3){return symbolValueOf3.call(object)==symbolValueOf3.call(other)}}return false}function equalObjects2(object,other,bitmask,customizer,equalFunc,stack2){var isPartial=bitmask&COMPARE_PARTIAL_FLAG7,objProps=getAllKeys2(object),objLength=objProps.length,othProps=getAllKeys2(other),othLength=othProps.length;if(objLength!=othLength&&!isPartial){return false}var index=objLength;while(index--){var key=objProps[index];if(!(isPartial?key in other:hasOwnProperty26.call(other,key))){return false}}var objStacked=stack2.get(object);var othStacked=stack2.get(other);if(objStacked&&othStacked){return objStacked==other&&othStacked==object}var result3=true;stack2.set(object,other);stack2.set(other,object);var skipCtor=isPartial;while(++index<objLength){key=objProps[index];var objValue=object[key],othValue=other[key];if(customizer){var compared=isPartial?customizer(othValue,objValue,key,other,object,stack2):customizer(objValue,othValue,key,object,other,stack2)}if(!(compared===undefined2?objValue===othValue||equalFunc(objValue,othValue,bitmask,customizer,stack2):compared)){result3=false;break}skipCtor||(skipCtor=key=="constructor")}if(result3&&!skipCtor){var objCtor=object.constructor,othCtor=other.constructor;if(objCtor!=othCtor&&("constructor"in object&&"constructor"in other)&&!(typeof objCtor=="function"&&objCtor instanceof objCtor&&typeof othCtor=="function"&&othCtor instanceof othCtor)){result3=false}}stack2["delete"](object);stack2["delete"](other);return result3}function flatRest2(func){return setToString2(overRest2(func,undefined2,flatten2),func+"")}function getAllKeys2(object){return baseGetAllKeys2(object,keys2,getSymbols2)}function getAllKeysIn2(object){return baseGetAllKeys2(object,keysIn2,getSymbolsIn2)}var getData2=!metaMap2?noop4:function(func){return metaMap2.get(func)};function getFuncName2(func){var result3=func.name+"",array=realNames2[result3],length=hasOwnProperty26.call(realNames2,result3)?array.length:0;while(length--){var data=array[length],otherFunc=data.func;if(otherFunc==null||otherFunc==func){return data.name}}return result3}function getHolder2(func){var object=hasOwnProperty26.call(lodash3,"placeholder")?lodash3:func;return object.placeholder}function getIteratee(){var result3=lodash3.iteratee||iteratee2;result3=result3===iteratee2?baseIteratee2:result3;return arguments.length?result3(arguments[0],arguments[1]):result3}function getMapData2(map4,key){var data=map4.__data__;return isKeyable2(key)?data[typeof key=="string"?"string":"hash"]:data.map}function getMatchData2(object){var result3=keys2(object),length=result3.length;while(length--){var key=result3[length],value=object[key];result3[length]=[key,value,isStrictComparable2(value)]}return result3}function getNative2(object,key){var value=getValue2(object,key);return baseIsNative2(value)?value:undefined2}function getRawTag2(value){var isOwn=hasOwnProperty26.call(value,symToStringTag3),tag=value[symToStringTag3];try{value[symToStringTag3]=undefined2;var unmasked=true}catch(e){}var result3=nativeObjectToString5.call(value);if(unmasked){if(isOwn){value[symToStringTag3]=tag}else{delete value[symToStringTag3]}}return result3}var getSymbols2=!nativeGetSymbols3?stubArray2:function(object){if(object==null){return[]}object=Object2(object);return arrayFilter2(nativeGetSymbols3(object),function(symbol){return propertyIsEnumerable3.call(object,symbol)})};var getSymbolsIn2=!nativeGetSymbols3?stubArray2:function(object){var result3=[];while(object){arrayPush2(result3,getSymbols2(object));object=getPrototype2(object)}return result3};var getTag3=baseGetTag2;if(DataView3&&getTag3(new DataView3(new ArrayBuffer(1)))!=dataViewTag6||Map3&&getTag3(new Map3)!=mapTag11||Promise3&&getTag3(Promise3.resolve())!=promiseTag2||Set3&&getTag3(new Set3)!=setTag11||WeakMap3&&getTag3(new WeakMap3)!=weakMapTag5){getTag3=function(value){var result3=baseGetTag2(value),Ctor=result3==objectTag6?value.constructor:undefined2,ctorString=Ctor?toSource2(Ctor):"";if(ctorString){switch(ctorString){case dataViewCtorString2:return dataViewTag6;case mapCtorString2:return mapTag11;case promiseCtorString2:return promiseTag2;case setCtorString2:return setTag11;case weakMapCtorString2:return weakMapTag5}}return result3}}function getView2(start,end,transforms){var index=-1,length=transforms.length;while(++index<length){var data=transforms[index],size3=data.size;switch(data.type){case"drop":start+=size3;break;case"dropRight":end-=size3;break;case"take":end=nativeMin16(end,start+size3);break;case"takeRight":start=nativeMax18(start,end-size3);break}}return{"start":start,"end":end}}function getWrapDetails2(source){var match=source.match(reWrapDetails2);return match?match[1].split(reSplitDetails2):[]}function hasPath2(object,path27,hasFunc){path27=castPath2(path27,object);var index=-1,length=path27.length,result3=false;while(++index<length){var key=toKey2(path27[index]);if(!(result3=object!=null&&hasFunc(object,key))){break}object=object[key]}if(result3||++index!=length){return result3}length=object==null?0:object.length;return!!length&&isLength2(length)&&isIndex2(key,length)&&(isArray3(object)||isArguments2(object))}function initCloneArray2(array){var length=array.length,result3=new array.constructor(length);if(length&&typeof array[0]=="string"&&hasOwnProperty26.call(array,"index")){result3.index=array.index;result3.input=array.input}return result3}function initCloneObject2(object){return typeof object.constructor=="function"&&!isPrototype2(object)?baseCreate2(getPrototype2(object)):{}}function initCloneByTag2(object,tag,isDeep){var Ctor=object.constructor;switch(tag){case arrayBufferTag6:return cloneArrayBuffer2(object);case boolTag6:case dateTag6:return new Ctor(+object);case dataViewTag6:return cloneDataView2(object,isDeep);case float32Tag4:case float64Tag4:case int8Tag4:case int16Tag4:case int32Tag4:case uint8Tag4:case uint8ClampedTag4:case uint16Tag4:case uint32Tag4:return cloneTypedArray2(object,isDeep);case mapTag11:return new Ctor;case numberTag6:case stringTag6:return new Ctor(object);case regexpTag6:return cloneRegExp2(object);case setTag11:return new Ctor;case symbolTag5:return cloneSymbol2(object)}}function insertWrapDetails2(source,details){var length=details.length;if(!length){return source}var lastIndex=length-1;details[lastIndex]=(length>1?"& ":"")+details[lastIndex];details=details.join(length>2?", ":" ");return source.replace(reWrapComment2,"{\n/* [wrapped with "+details+"] */\n")}function isFlattenable2(value){return isArray3(value)||isArguments2(value)||!!(spreadableSymbol2&&value&&value[spreadableSymbol2])}function isIndex2(value,length){var type2=typeof value;length=length==null?MAX_SAFE_INTEGER7:length;return!!length&&(type2=="number"||type2!="symbol"&&reIsUint2.test(value))&&(value>-1&&value%1==0&&value<length)}function isIterateeCall2(value,index,object){if(!isObject4(object)){return false}var type2=typeof index;if(type2=="number"?isArrayLike2(object)&&isIndex2(index,object.length):type2=="string"&&index in object){return eq2(object[index],value)}return false}function isKey2(value,object){if(isArray3(value)){return false}var type2=typeof value;if(type2=="number"||type2=="symbol"||type2=="boolean"||value==null||isSymbol2(value)){return true}return reIsPlainProp2.test(value)||!reIsDeepProp2.test(value)||object!=null&&value in Object2(object)}function isKeyable2(value){var type2=typeof value;return type2=="string"||type2=="number"||type2=="symbol"||type2=="boolean"?value!=="__proto__":value===null}function isLaziable2(func){var funcName=getFuncName2(func),other=lodash3[funcName];if(typeof other!="function"||!(funcName in LazyWrapper2.prototype)){return false}if(func===other){return true}var data=getData2(other);return!!data&&func===data[0]}function isMasked2(func){return!!maskSrcKey2&&maskSrcKey2 in func}var isMaskable2=coreJsData2?isFunction3:stubFalse2;function isPrototype2(value){var Ctor=value&&value.constructor,proto2=typeof Ctor=="function"&&Ctor.prototype||objectProto30;return value===proto2}function isStrictComparable2(value){return value===value&&!isObject4(value)}function matchesStrictComparable2(key,srcValue){return function(object){if(object==null){return false}return object[key]===srcValue&&(srcValue!==undefined2||key in Object2(object))}}function memoizeCapped2(func){var result3=memoize2(func,function(key){if(cache2.size===MAX_MEMOIZE_SIZE2){cache2.clear()}return key});var cache2=result3.cache;return result3}function mergeData2(data,source){var bitmask=data[1],srcBitmask=source[1],newBitmask=bitmask|srcBitmask,isCommon=newBitmask<(WRAP_BIND_FLAG10|WRAP_BIND_KEY_FLAG8|WRAP_ARY_FLAG6);var isCombo=srcBitmask==WRAP_ARY_FLAG6&&bitmask==WRAP_CURRY_FLAG8||srcBitmask==WRAP_ARY_FLAG6&&bitmask==WRAP_REARG_FLAG5&&data[7].length<=source[8]||srcBitmask==(WRAP_ARY_FLAG6|WRAP_REARG_FLAG5)&&source[7].length<=source[8]&&bitmask==WRAP_CURRY_FLAG8;if(!(isCommon||isCombo)){return data}if(srcBitmask&WRAP_BIND_FLAG10){data[2]=source[2];newBitmask|=bitmask&WRAP_BIND_FLAG10?0:WRAP_CURRY_BOUND_FLAG3}var value=source[3];if(value){var partials=data[3];data[3]=partials?composeArgs2(partials,value,source[4]):value;data[4]=partials?replaceHolders2(data[3],PLACEHOLDER3):source[4]}value=source[5];if(value){partials=data[5];data[5]=partials?composeArgsRight2(partials,value,source[6]):value;data[6]=partials?replaceHolders2(data[5],PLACEHOLDER3):source[6]}value=source[7];if(value){data[7]=value}if(srcBitmask&WRAP_ARY_FLAG6){data[8]=data[8]==null?source[8]:nativeMin16(data[8],source[8])}if(data[9]==null){data[9]=source[9]}data[0]=source[0];data[1]=newBitmask;return data}function nativeKeysIn2(object){var result3=[];if(object!=null){for(var key in Object2(object)){result3.push(key)}}return result3}function objectToString2(value){return nativeObjectToString5.call(value)}function overRest2(func,start,transform3){start=nativeMax18(start===undefined2?func.length-1:start,0);return function(){var args2=arguments,index=-1,length=nativeMax18(args2.length-start,0),array=Array2(length);while(++index<length){array[index]=args2[start+index]}index=-1;var otherArgs=Array2(start+1);while(++index<start){otherArgs[index]=args2[index]}otherArgs[start]=transform3(array);return apply2(func,this,otherArgs)}}function parent2(object,path27){return path27.length<2?object:baseGet2(object,baseSlice2(path27,0,-1))}function reorder2(array,indexes){var arrLength=array.length,length=nativeMin16(indexes.length,arrLength),oldArray=copyArray2(array);while(length--){var index=indexes[length];array[length]=isIndex2(index,arrLength)?oldArray[index]:undefined2}return array}function safeGet2(object,key){if(key==="constructor"&&typeof object[key]==="function"){return}if(key=="__proto__"){return}return object[key]}var setData2=shortOut2(baseSetData2);var setTimeout3=ctxSetTimeout||function(func,wait){return root2.setTimeout(func,wait)};var setToString2=shortOut2(baseSetToString2);function setWrapToString2(wrapper,reference,bitmask){var source=reference+"";return setToString2(wrapper,insertWrapDetails2(source,updateWrapDetails2(getWrapDetails2(source),bitmask)))}function shortOut2(func){var count=0,lastCalled=0;return function(){var stamp=nativeNow2(),remaining=HOT_SPAN2-(stamp-lastCalled);lastCalled=stamp;if(remaining>0){if(++count>=HOT_COUNT2){return arguments[0]}}else{count=0}return func.apply(undefined2,arguments)}}function shuffleSelf2(array,size3){var index=-1,length=array.length,lastIndex=length-1;size3=size3===undefined2?length:size3;while(++index<size3){var rand=baseRandom2(index,lastIndex),value=array[rand];array[rand]=array[index];array[index]=value}array.length=size3;return array}var stringToPath2=memoizeCapped2(function(string){var result3=[];if(string.charCodeAt(0)===46){result3.push("")}string.replace(rePropName2,function(match,number2,quote,subString){result3.push(quote?subString.replace(reEscapeChar2,"$1"):number2||match)});return result3});function toKey2(value){if(typeof value=="string"||isSymbol2(value)){return value}var result3=value+"";return result3=="0"&&1/value==-INFINITY8?"-0":result3}function toSource2(func){if(func!=null){try{return funcToString4.call(func)}catch(e){}try{return func+""}catch(e){}}return""}function updateWrapDetails2(details,bitmask){arrayEach2(wrapFlags2,function(pair){var value="_."+pair[0];if(bitmask&pair[1]&&!arrayIncludes2(details,value)){details.push(value)}});return details.sort()}function wrapperClone2(wrapper){if(wrapper instanceof LazyWrapper2){return wrapper.clone()}var result3=new LodashWrapper2(wrapper.__wrapped__,wrapper.__chain__);result3.__actions__=copyArray2(wrapper.__actions__);result3.__index__=wrapper.__index__;result3.__values__=wrapper.__values__;return result3}function chunk2(array,size3,guard){if(guard?isIterateeCall2(array,size3,guard):size3===undefined2){size3=1}else{size3=nativeMax18(toInteger2(size3),0)}var length=array==null?0:array.length;if(!length||size3<1){return[]}var index=0,resIndex=0,result3=Array2(nativeCeil5(length/size3));while(index<length){result3[resIndex++]=baseSlice2(array,index,index+=size3)}return result3}function compact2(array){var index=-1,length=array==null?0:array.length,resIndex=0,result3=[];while(++index<length){var value=array[index];if(value){result3[resIndex++]=value}}return result3}function concat3(){var length=arguments.length;if(!length){return[]}var args2=Array2(length-1),array=arguments[0],index=length;while(index--){args2[index-1]=arguments[index]}return arrayPush2(isArray3(array)?copyArray2(array):[array],baseFlatten2(args2,1))}var difference2=baseRest2(function(array,values3){return isArrayLikeObject2(array)?baseDifference2(array,baseFlatten2(values3,1,isArrayLikeObject2,true)):[]});var differenceBy2=baseRest2(function(array,values3){var iteratee3=last2(values3);if(isArrayLikeObject2(iteratee3)){iteratee3=undefined2}return isArrayLikeObject2(array)?baseDifference2(array,baseFlatten2(values3,1,isArrayLikeObject2,true),getIteratee(iteratee3,2)):[]});var differenceWith2=baseRest2(function(array,values3){var comparator=last2(values3);if(isArrayLikeObject2(comparator)){comparator=undefined2}return isArrayLikeObject2(array)?baseDifference2(array,baseFlatten2(values3,1,isArrayLikeObject2,true),undefined2,comparator):[]});function drop2(array,n,guard){var length=array==null?0:array.length;if(!length){return[]}n=guard||n===undefined2?1:toInteger2(n);return baseSlice2(array,n<0?0:n,length)}function dropRight2(array,n,guard){var length=array==null?0:array.length;if(!length){return[]}n=guard||n===undefined2?1:toInteger2(n);n=length-n;return baseSlice2(array,0,n<0?0:n)}function dropRightWhile2(array,predicate){return array&&array.length?baseWhile2(array,getIteratee(predicate,3),true,true):[]}function dropWhile2(array,predicate){return array&&array.length?baseWhile2(array,getIteratee(predicate,3),true):[]}function fill2(array,value,start,end){var length=array==null?0:array.length;if(!length){return[]}if(start&&typeof start!="number"&&isIterateeCall2(array,value,start)){start=0;end=length}return baseFill2(array,value,start,end)}function findIndex2(array,predicate,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=fromIndex==null?0:toInteger2(fromIndex);if(index<0){index=nativeMax18(length+index,0)}return baseFindIndex2(array,getIteratee(predicate,3),index)}function findLastIndex2(array,predicate,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=length-1;if(fromIndex!==undefined2){index=toInteger2(fromIndex);index=fromIndex<0?nativeMax18(length+index,0):nativeMin16(index,length-1)}return baseFindIndex2(array,getIteratee(predicate,3),index,true)}function flatten2(array){var length=array==null?0:array.length;return length?baseFlatten2(array,1):[]}function flattenDeep2(array){var length=array==null?0:array.length;return length?baseFlatten2(array,INFINITY8):[]}function flattenDepth2(array,depth){var length=array==null?0:array.length;if(!length){return[]}depth=depth===undefined2?1:toInteger2(depth);return baseFlatten2(array,depth)}function fromPairs2(pairs2){var index=-1,length=pairs2==null?0:pairs2.length,result3={};while(++index<length){var pair=pairs2[index];result3[pair[0]]=pair[1]}return result3}function head2(array){return array&&array.length?array[0]:undefined2}function indexOf2(array,value,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=fromIndex==null?0:toInteger2(fromIndex);if(index<0){index=nativeMax18(length+index,0)}return baseIndexOf2(array,value,index)}function initial2(array){var length=array==null?0:array.length;return length?baseSlice2(array,0,-1):[]}var intersection2=baseRest2(function(arrays){var mapped=arrayMap2(arrays,castArrayLikeObject2);return mapped.length&&mapped[0]===arrays[0]?baseIntersection2(mapped):[]});var intersectionBy2=baseRest2(function(arrays){var iteratee3=last2(arrays),mapped=arrayMap2(arrays,castArrayLikeObject2);if(iteratee3===last2(mapped)){iteratee3=undefined2}else{mapped.pop()}return mapped.length&&mapped[0]===arrays[0]?baseIntersection2(mapped,getIteratee(iteratee3,2)):[]});var intersectionWith2=baseRest2(function(arrays){var comparator=last2(arrays),mapped=arrayMap2(arrays,castArrayLikeObject2);comparator=typeof comparator=="function"?comparator:undefined2;if(comparator){mapped.pop()}return mapped.length&&mapped[0]===arrays[0]?baseIntersection2(mapped,undefined2,comparator):[]});function join4(array,separator){return array==null?"":nativeJoin2.call(array,separator)}function last2(array){var length=array==null?0:array.length;return length?array[length-1]:undefined2}function lastIndexOf2(array,value,fromIndex){var length=array==null?0:array.length;if(!length){return-1}var index=length;if(fromIndex!==undefined2){index=toInteger2(fromIndex);index=index<0?nativeMax18(length+index,0):nativeMin16(index,length-1)}return value===value?strictLastIndexOf2(array,value,index):baseFindIndex2(array,baseIsNaN2,index,true)}function nth2(array,n){return array&&array.length?baseNth2(array,toInteger2(n)):undefined2}var pull2=baseRest2(pullAll2);function pullAll2(array,values3){return array&&array.length&&values3&&values3.length?basePullAll2(array,values3):array}function pullAllBy2(array,values3,iteratee3){return array&&array.length&&values3&&values3.length?basePullAll2(array,values3,getIteratee(iteratee3,2)):array}function pullAllWith2(array,values3,comparator){return array&&array.length&&values3&&values3.length?basePullAll2(array,values3,undefined2,comparator):array}var pullAt2=flatRest2(function(array,indexes){var length=array==null?0:array.length,result3=baseAt2(array,indexes);basePullAt2(array,arrayMap2(indexes,function(index){return isIndex2(index,length)?+index:index}).sort(compareAscending2));return result3});function remove2(array,predicate){var result3=[];if(!(array&&array.length)){return result3}var index=-1,indexes=[],length=array.length;predicate=getIteratee(predicate,3);while(++index<length){var value=array[index];if(predicate(value,index,array)){result3.push(value);indexes.push(index)}}basePullAt2(array,indexes);return result3}function reverse2(array){return array==null?array:nativeReverse2.call(array)}function slice2(array,start,end){var length=array==null?0:array.length;if(!length){return[]}if(end&&typeof end!="number"&&isIterateeCall2(array,start,end)){start=0;end=length}else{start=start==null?0:toInteger2(start);end=end===undefined2?length:toInteger2(end)}return baseSlice2(array,start,end)}function sortedIndex2(array,value){return baseSortedIndex2(array,value)}function sortedIndexBy2(array,value,iteratee3){return baseSortedIndexBy2(array,value,getIteratee(iteratee3,2))}function sortedIndexOf2(array,value){var length=array==null?0:array.length;if(length){var index=baseSortedIndex2(array,value);if(index<length&&eq2(array[index],value)){return index}}return-1}function sortedLastIndex2(array,value){return baseSortedIndex2(array,value,true)}function sortedLastIndexBy2(array,value,iteratee3){return baseSortedIndexBy2(array,value,getIteratee(iteratee3,2),true)}function sortedLastIndexOf2(array,value){var length=array==null?0:array.length;if(length){var index=baseSortedIndex2(array,value,true)-1;if(eq2(array[index],value)){return index}}return-1}function sortedUniq2(array){return array&&array.length?baseSortedUniq2(array):[]}function sortedUniqBy2(array,iteratee3){return array&&array.length?baseSortedUniq2(array,getIteratee(iteratee3,2)):[]}function tail2(array){var length=array==null?0:array.length;return length?baseSlice2(array,1,length):[]}function take2(array,n,guard){if(!(array&&array.length)){return[]}n=guard||n===undefined2?1:toInteger2(n);return baseSlice2(array,0,n<0?0:n)}function takeRight2(array,n,guard){var length=array==null?0:array.length;if(!length){return[]}n=guard||n===undefined2?1:toInteger2(n);n=length-n;return baseSlice2(array,n<0?0:n,length)}function takeRightWhile2(array,predicate){return array&&array.length?baseWhile2(array,getIteratee(predicate,3),false,true):[]}function takeWhile2(array,predicate){return array&&array.length?baseWhile2(array,getIteratee(predicate,3)):[]}var union2=baseRest2(function(arrays){return baseUniq2(baseFlatten2(arrays,1,isArrayLikeObject2,true))});var unionBy2=baseRest2(function(arrays){var iteratee3=last2(arrays);if(isArrayLikeObject2(iteratee3)){iteratee3=undefined2}return baseUniq2(baseFlatten2(arrays,1,isArrayLikeObject2,true),getIteratee(iteratee3,2))});var unionWith2=baseRest2(function(arrays){var comparator=last2(arrays);comparator=typeof comparator=="function"?comparator:undefined2;return baseUniq2(baseFlatten2(arrays,1,isArrayLikeObject2,true),undefined2,comparator)});function uniq2(array){return array&&array.length?baseUniq2(array):[]}function uniqBy2(array,iteratee3){return array&&array.length?baseUniq2(array,getIteratee(iteratee3,2)):[]}function uniqWith2(array,comparator){comparator=typeof comparator=="function"?comparator:undefined2;return array&&array.length?baseUniq2(array,undefined2,comparator):[]}function unzip2(array){if(!(array&&array.length)){return[]}var length=0;array=arrayFilter2(array,function(group){if(isArrayLikeObject2(group)){length=nativeMax18(group.length,length);return true}});return baseTimes2(length,function(index){return arrayMap2(array,baseProperty2(index))})}function unzipWith2(array,iteratee3){if(!(array&&array.length)){return[]}var result3=unzip2(array);if(iteratee3==null){return result3}return arrayMap2(result3,function(group){return apply2(iteratee3,undefined2,group)})}var without2=baseRest2(function(array,values3){return isArrayLikeObject2(array)?baseDifference2(array,values3):[]});var xor2=baseRest2(function(arrays){return baseXor2(arrayFilter2(arrays,isArrayLikeObject2))});var xorBy2=baseRest2(function(arrays){var iteratee3=last2(arrays);if(isArrayLikeObject2(iteratee3)){iteratee3=undefined2}return baseXor2(arrayFilter2(arrays,isArrayLikeObject2),getIteratee(iteratee3,2))});var xorWith2=baseRest2(function(arrays){var comparator=last2(arrays);comparator=typeof comparator=="function"?comparator:undefined2;return baseXor2(arrayFilter2(arrays,isArrayLikeObject2),undefined2,comparator)});var zip2=baseRest2(unzip2);function zipObject2(props,values3){return baseZipObject2(props||[],values3||[],assignValue2)}function zipObjectDeep2(props,values3){return baseZipObject2(props||[],values3||[],baseSet2)}var zipWith2=baseRest2(function(arrays){var length=arrays.length,iteratee3=length>1?arrays[length-1]:undefined2;iteratee3=typeof iteratee3=="function"?(arrays.pop(),iteratee3):undefined2;return unzipWith2(arrays,iteratee3)});function chain2(value){var result3=lodash3(value);result3.__chain__=true;return result3}function tap2(value,interceptor){interceptor(value);return value}function thru2(value,interceptor){return interceptor(value)}var wrapperAt2=flatRest2(function(paths){var length=paths.length,start=length?paths[0]:0,value=this.__wrapped__,interceptor=function(object){return baseAt2(object,paths)};if(length>1||this.__actions__.length||!(value instanceof LazyWrapper2)||!isIndex2(start)){return this.thru(interceptor)}value=value.slice(start,+start+(length?1:0));value.__actions__.push({"func":thru2,"args":[interceptor],"thisArg":undefined2});return new LodashWrapper2(value,this.__chain__).thru(function(array){if(length&&!array.length){array.push(undefined2)}return array})});function wrapperChain2(){return chain2(this)}function wrapperCommit2(){return new LodashWrapper2(this.value(),this.__chain__)}function wrapperNext2(){if(this.__values__===undefined2){this.__values__=toArray3(this.value())}var done=this.__index__>=this.__values__.length,value=done?undefined2:this.__values__[this.__index__++];return{"done":done,"value":value}}function wrapperToIterator2(){return this}function wrapperPlant2(value){var result3,parent3=this;while(parent3 instanceof baseLodash2){var clone3=wrapperClone2(parent3);clone3.__index__=0;clone3.__values__=undefined2;if(result3){previous.__wrapped__=clone3}else{result3=clone3}var previous=clone3;parent3=parent3.__wrapped__}previous.__wrapped__=value;return result3}function wrapperReverse2(){var value=this.__wrapped__;if(value instanceof LazyWrapper2){var wrapped=value;if(this.__actions__.length){wrapped=new LazyWrapper2(this)}wrapped=wrapped.reverse();wrapped.__actions__.push({"func":thru2,"args":[reverse2],"thisArg":undefined2});return new LodashWrapper2(wrapped,this.__chain__)}return this.thru(reverse2)}function wrapperValue2(){return baseWrapperValue2(this.__wrapped__,this.__actions__)}var countBy2=createAggregator2(function(result3,value,key){if(hasOwnProperty26.call(result3,key)){++result3[key]}else{baseAssignValue2(result3,key,1)}});function every2(collection,predicate,guard){var func=isArray3(collection)?arrayEvery2:baseEvery2;if(guard&&isIterateeCall2(collection,predicate,guard)){predicate=undefined2}return func(collection,getIteratee(predicate,3))}function filter2(collection,predicate){var func=isArray3(collection)?arrayFilter2:baseFilter2;return func(collection,getIteratee(predicate,3))}var find2=createFind2(findIndex2);var findLast2=createFind2(findLastIndex2);function flatMap2(collection,iteratee3){return baseFlatten2(map3(collection,iteratee3),1)}function flatMapDeep2(collection,iteratee3){return baseFlatten2(map3(collection,iteratee3),INFINITY8)}function flatMapDepth2(collection,iteratee3,depth){depth=depth===undefined2?1:toInteger2(depth);return baseFlatten2(map3(collection,iteratee3),depth)}function forEach2(collection,iteratee3){var func=isArray3(collection)?arrayEach2:baseEach2;return func(collection,getIteratee(iteratee3,3))}function forEachRight2(collection,iteratee3){var func=isArray3(collection)?arrayEachRight2:baseEachRight2;return func(collection,getIteratee(iteratee3,3))}var groupBy2=createAggregator2(function(result3,value,key){if(hasOwnProperty26.call(result3,key)){result3[key].push(value)}else{baseAssignValue2(result3,key,[value])}});function includes2(collection,value,fromIndex,guard){collection=isArrayLike2(collection)?collection:values2(collection);fromIndex=fromIndex&&!guard?toInteger2(fromIndex):0;var length=collection.length;if(fromIndex<0){fromIndex=nativeMax18(length+fromIndex,0)}return isString4(collection)?fromIndex<=length&&collection.indexOf(value,fromIndex)>-1:!!length&&baseIndexOf2(collection,value,fromIndex)>-1}var invokeMap2=baseRest2(function(collection,path27,args2){var index=-1,isFunc=typeof path27=="function",result3=isArrayLike2(collection)?Array2(collection.length):[];baseEach2(collection,function(value){result3[++index]=isFunc?apply2(path27,value,args2):baseInvoke2(value,path27,args2)});return result3});var keyBy2=createAggregator2(function(result3,value,key){baseAssignValue2(result3,key,value)});function map3(collection,iteratee3){var func=isArray3(collection)?arrayMap2:baseMap2;return func(collection,getIteratee(iteratee3,3))}function orderBy2(collection,iteratees,orders,guard){if(collection==null){return[]}if(!isArray3(iteratees)){iteratees=iteratees==null?[]:[iteratees]}orders=guard?undefined2:orders;if(!isArray3(orders)){orders=orders==null?[]:[orders]}return baseOrderBy2(collection,iteratees,orders)}var partition2=createAggregator2(function(result3,value,key){result3[key?0:1].push(value)},function(){return[[],[]]});function reduce2(collection,iteratee3,accumulator){var func=isArray3(collection)?arrayReduce2:baseReduce2,initAccum=arguments.length<3;return func(collection,getIteratee(iteratee3,4),accumulator,initAccum,baseEach2)}function reduceRight2(collection,iteratee3,accumulator){var func=isArray3(collection)?arrayReduceRight2:baseReduce2,initAccum=arguments.length<3;return func(collection,getIteratee(iteratee3,4),accumulator,initAccum,baseEachRight2)}function reject2(collection,predicate){var func=isArray3(collection)?arrayFilter2:baseFilter2;return func(collection,negate2(getIteratee(predicate,3)))}function sample2(collection){var func=isArray3(collection)?arraySample2:baseSample2;return func(collection)}function sampleSize2(collection,n,guard){if(guard?isIterateeCall2(collection,n,guard):n===undefined2){n=1}else{n=toInteger2(n)}var func=isArray3(collection)?arraySampleSize2:baseSampleSize2;return func(collection,n)}function shuffle2(collection){var func=isArray3(collection)?arrayShuffle2:baseShuffle2;return func(collection)}function size2(collection){if(collection==null){return 0}if(isArrayLike2(collection)){return isString4(collection)?stringSize2(collection):collection.length}var tag=getTag3(collection);if(tag==mapTag11||tag==setTag11){return collection.size}return baseKeys2(collection).length}function some2(collection,predicate,guard){var func=isArray3(collection)?arraySome2:baseSome2;if(guard&&isIterateeCall2(collection,predicate,guard)){predicate=undefined2}return func(collection,getIteratee(predicate,3))}var sortBy2=baseRest2(function(collection,iteratees){if(collection==null){return[]}var length=iteratees.length;if(length>1&&isIterateeCall2(collection,iteratees[0],iteratees[1])){iteratees=[]}else if(length>2&&isIterateeCall2(iteratees[0],iteratees[1],iteratees[2])){iteratees=[iteratees[0]]}return baseOrderBy2(collection,baseFlatten2(iteratees,1),[])});var now3=ctxNow||function(){return root2.Date.now()};function after2(n,func){if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}n=toInteger2(n);return function(){if(--n<1){return func.apply(this,arguments)}}}function ary2(func,n,guard){n=guard?undefined2:n;n=func&&n==null?func.length:n;return createWrap2(func,WRAP_ARY_FLAG6,undefined2,undefined2,undefined2,undefined2,n)}function before2(n,func){var result3;if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}n=toInteger2(n);return function(){if(--n>0){result3=func.apply(this,arguments)}if(n<=1){func=undefined2}return result3}}var bind2=baseRest2(function(func,thisArg,partials){var bitmask=WRAP_BIND_FLAG10;if(partials.length){var holders=replaceHolders2(partials,getHolder2(bind2));bitmask|=WRAP_PARTIAL_FLAG8}return createWrap2(func,bitmask,thisArg,partials,holders)});var bindKey2=baseRest2(function(object,key,partials){var bitmask=WRAP_BIND_FLAG10|WRAP_BIND_KEY_FLAG8;if(partials.length){var holders=replaceHolders2(partials,getHolder2(bindKey2));bitmask|=WRAP_PARTIAL_FLAG8}return createWrap2(key,bitmask,object,partials,holders)});function curry2(func,arity,guard){arity=guard?undefined2:arity;var result3=createWrap2(func,WRAP_CURRY_FLAG8,undefined2,undefined2,undefined2,undefined2,undefined2,arity);result3.placeholder=curry2.placeholder;return result3}function curryRight2(func,arity,guard){arity=guard?undefined2:arity;var result3=createWrap2(func,WRAP_CURRY_RIGHT_FLAG5,undefined2,undefined2,undefined2,undefined2,undefined2,arity);result3.placeholder=curryRight2.placeholder;return result3}function debounce2(func,wait,options){var lastArgs,lastThis,maxWait,result3,timerId,lastCallTime,lastInvokeTime=0,leading=false,maxing=false,trailing=true;if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}wait=toNumber2(wait)||0;if(isObject4(options)){leading=!!options.leading;maxing="maxWait"in options;maxWait=maxing?nativeMax18(toNumber2(options.maxWait)||0,wait):maxWait;trailing="trailing"in options?!!options.trailing:trailing}function invokeFunc(time){var args2=lastArgs,thisArg=lastThis;lastArgs=lastThis=undefined2;lastInvokeTime=time;result3=func.apply(thisArg,args2);return result3}function leadingEdge(time){lastInvokeTime=time;timerId=setTimeout3(timerExpired,wait);return leading?invokeFunc(time):result3}function remainingWait(time){var timeSinceLastCall=time-lastCallTime,timeSinceLastInvoke=time-lastInvokeTime,timeWaiting=wait-timeSinceLastCall;return maxing?nativeMin16(timeWaiting,maxWait-timeSinceLastInvoke):timeWaiting}function shouldInvoke(time){var timeSinceLastCall=time-lastCallTime,timeSinceLastInvoke=time-lastInvokeTime;return lastCallTime===undefined2||timeSinceLastCall>=wait||timeSinceLastCall<0||maxing&&timeSinceLastInvoke>=maxWait}function timerExpired(){var time=now3();if(shouldInvoke(time)){return trailingEdge(time)}timerId=setTimeout3(timerExpired,remainingWait(time))}function trailingEdge(time){timerId=undefined2;if(trailing&&lastArgs){return invokeFunc(time)}lastArgs=lastThis=undefined2;return result3}function cancel(){if(timerId!==undefined2){clearTimeout2(timerId)}lastInvokeTime=0;lastArgs=lastCallTime=lastThis=timerId=undefined2}function flush(){return timerId===undefined2?result3:trailingEdge(now3())}function debounced(){var time=now3(),isInvoking=shouldInvoke(time);lastArgs=arguments;lastThis=this;lastCallTime=time;if(isInvoking){if(timerId===undefined2){return leadingEdge(lastCallTime)}if(maxing){clearTimeout2(timerId);timerId=setTimeout3(timerExpired,wait);return invokeFunc(lastCallTime)}}if(timerId===undefined2){timerId=setTimeout3(timerExpired,wait)}return result3}debounced.cancel=cancel;debounced.flush=flush;return debounced}var defer2=baseRest2(function(func,args2){return baseDelay2(func,1,args2)});var delay4=baseRest2(function(func,wait,args2){return baseDelay2(func,toNumber2(wait)||0,args2)});function flip2(func){return createWrap2(func,WRAP_FLIP_FLAG4)}function memoize2(func,resolver){if(typeof func!="function"||resolver!=null&&typeof resolver!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}var memoized=function(){var args2=arguments,key=resolver?resolver.apply(this,args2):args2[0],cache2=memoized.cache;if(cache2.has(key)){return cache2.get(key)}var result3=func.apply(this,args2);memoized.cache=cache2.set(key,result3)||cache2;return result3};memoized.cache=new(memoize2.Cache||MapCache2);return memoized}memoize2.Cache=MapCache2;function negate2(predicate){if(typeof predicate!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}return function(){var args2=arguments;switch(args2.length){case 0:return!predicate.call(this);case 1:return!predicate.call(this,args2[0]);case 2:return!predicate.call(this,args2[0],args2[1]);case 3:return!predicate.call(this,args2[0],args2[1],args2[2])}return!predicate.apply(this,args2)}}function once2(func){return before2(2,func)}var overArgs2=castRest2(function(func,transforms){transforms=transforms.length==1&&isArray3(transforms[0])?arrayMap2(transforms[0],baseUnary2(getIteratee())):arrayMap2(baseFlatten2(transforms,1),baseUnary2(getIteratee()));var funcsLength=transforms.length;return baseRest2(function(args2){var index=-1,length=nativeMin16(args2.length,funcsLength);while(++index<length){args2[index]=transforms[index].call(this,args2[index])}return apply2(func,this,args2)})});var partial2=baseRest2(function(func,partials){var holders=replaceHolders2(partials,getHolder2(partial2));return createWrap2(func,WRAP_PARTIAL_FLAG8,undefined2,partials,holders)});var partialRight2=baseRest2(function(func,partials){var holders=replaceHolders2(partials,getHolder2(partialRight2));return createWrap2(func,WRAP_PARTIAL_RIGHT_FLAG5,undefined2,partials,holders)});var rearg2=flatRest2(function(func,indexes){return createWrap2(func,WRAP_REARG_FLAG5,undefined2,undefined2,undefined2,indexes)});function rest2(func,start){if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}start=start===undefined2?start:toInteger2(start);return baseRest2(func,start)}function spread2(func,start){if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}start=start==null?0:nativeMax18(toInteger2(start),0);return baseRest2(function(args2){var array=args2[start],otherArgs=castSlice2(args2,0,start);if(array){arrayPush2(otherArgs,array)}return apply2(func,this,otherArgs)})}function throttle3(func,wait,options){var leading=true,trailing=true;if(typeof func!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}if(isObject4(options)){leading="leading"in options?!!options.leading:leading;trailing="trailing"in options?!!options.trailing:trailing}return debounce2(func,wait,{"leading":leading,"maxWait":wait,"trailing":trailing})}function unary2(func){return ary2(func,1)}function wrap4(value,wrapper){return partial2(castFunction2(wrapper),value)}function castArray2(){if(!arguments.length){return[]}var value=arguments[0];return isArray3(value)?value:[value]}function clone2(value){return baseClone2(value,CLONE_SYMBOLS_FLAG7)}function cloneWith2(value,customizer){customizer=typeof customizer=="function"?customizer:undefined2;return baseClone2(value,CLONE_SYMBOLS_FLAG7,customizer)}function cloneDeep3(value){return baseClone2(value,CLONE_DEEP_FLAG9|CLONE_SYMBOLS_FLAG7)}function cloneDeepWith2(value,customizer){customizer=typeof customizer=="function"?customizer:undefined2;return baseClone2(value,CLONE_DEEP_FLAG9|CLONE_SYMBOLS_FLAG7,customizer)}function conformsTo2(object,source){return source==null||baseConformsTo2(object,source,keys2(source))}function eq2(value,other){return value===other||value!==value&&other!==other}var gt2=createRelationalOperation2(baseGt2);var gte2=createRelationalOperation2(function(value,other){return value>=other});var isArguments2=baseIsArguments2(function(){return arguments}())?baseIsArguments2:function(value){return isObjectLike3(value)&&hasOwnProperty26.call(value,"callee")&&!propertyIsEnumerable3.call(value,"callee")};var isArray3=Array2.isArray;var isArrayBuffer2=nodeIsArrayBuffer2?baseUnary2(nodeIsArrayBuffer2):baseIsArrayBuffer2;function isArrayLike2(value){return value!=null&&isLength2(value.length)&&!isFunction3(value)}function isArrayLikeObject2(value){return isObjectLike3(value)&&isArrayLike2(value)}function isBoolean4(value){return value===true||value===false||isObjectLike3(value)&&baseGetTag2(value)==boolTag6}var isBuffer2=nativeIsBuffer2||stubFalse2;var isDate2=nodeIsDate2?baseUnary2(nodeIsDate2):baseIsDate2;function isElement2(value){return isObjectLike3(value)&&value.nodeType===1&&!isPlainObject3(value)}function isEmpty2(value){if(value==null){return true}if(isArrayLike2(value)&&(isArray3(value)||typeof value=="string"||typeof value.splice=="function"||isBuffer2(value)||isTypedArray2(value)||isArguments2(value))){return!value.length}var tag=getTag3(value);if(tag==mapTag11||tag==setTag11){return!value.size}if(isPrototype2(value)){return!baseKeys2(value).length}for(var key in value){if(hasOwnProperty26.call(value,key)){return false}}return true}function isEqual2(value,other){return baseIsEqual2(value,other)}function isEqualWith2(value,other,customizer){customizer=typeof customizer=="function"?customizer:undefined2;var result3=customizer?customizer(value,other):undefined2;return result3===undefined2?baseIsEqual2(value,other,undefined2,customizer):!!result3}function isError2(value){if(!isObjectLike3(value)){return false}var tag=baseGetTag2(value);return tag==errorTag5||tag==domExcTag2||typeof value.message=="string"&&typeof value.name=="string"&&!isPlainObject3(value)}function isFinite3(value){return typeof value=="number"&&nativeIsFinite3(value)}function isFunction3(value){if(!isObject4(value)){return false}var tag=baseGetTag2(value);return tag==funcTag4||tag==genTag3||tag==asyncTag2||tag==proxyTag2}function isInteger3(value){return typeof value=="number"&&value==toInteger2(value)}function isLength2(value){return typeof value=="number"&&value>-1&&value%1==0&&value<=MAX_SAFE_INTEGER7}function isObject4(value){var type2=typeof value;return value!=null&&(type2=="object"||type2=="function")}function isObjectLike3(value){return value!=null&&typeof value=="object"}var isMap2=nodeIsMap2?baseUnary2(nodeIsMap2):baseIsMap2;function isMatch2(object,source){return object===source||baseIsMatch2(object,source,getMatchData2(source))}function isMatchWith2(object,source,customizer){customizer=typeof customizer=="function"?customizer:undefined2;return baseIsMatch2(object,source,getMatchData2(source),customizer)}function isNaN3(value){return isNumber4(value)&&value!=+value}function isNative2(value){if(isMaskable2(value)){throw new Error2(CORE_ERROR_TEXT2)}return baseIsNative2(value)}function isNull3(value){return value===null}function isNil2(value){return value==null}function isNumber4(value){return typeof value=="number"||isObjectLike3(value)&&baseGetTag2(value)==numberTag6}function isPlainObject3(value){if(!isObjectLike3(value)||baseGetTag2(value)!=objectTag6){return false}var proto2=getPrototype2(value);if(proto2===null){return true}var Ctor=hasOwnProperty26.call(proto2,"constructor")&&proto2.constructor;return typeof Ctor=="function"&&Ctor instanceof Ctor&&funcToString4.call(Ctor)==objectCtorString2}var isRegExp2=nodeIsRegExp2?baseUnary2(nodeIsRegExp2):baseIsRegExp2;function isSafeInteger2(value){return isInteger3(value)&&value>=-MAX_SAFE_INTEGER7&&value<=MAX_SAFE_INTEGER7}var isSet2=nodeIsSet2?baseUnary2(nodeIsSet2):baseIsSet2;function isString4(value){return typeof value=="string"||!isArray3(value)&&isObjectLike3(value)&&baseGetTag2(value)==stringTag6}function isSymbol2(value){return typeof value=="symbol"||isObjectLike3(value)&&baseGetTag2(value)==symbolTag5}var isTypedArray2=nodeIsTypedArray2?baseUnary2(nodeIsTypedArray2):baseIsTypedArray2;function isUndefined7(value){return value===undefined2}function isWeakMap2(value){return isObjectLike3(value)&&getTag3(value)==weakMapTag5}function isWeakSet2(value){return isObjectLike3(value)&&baseGetTag2(value)==weakSetTag2}var lt2=createRelationalOperation2(baseLt2);var lte2=createRelationalOperation2(function(value,other){return value<=other});function toArray3(value){if(!value){return[]}if(isArrayLike2(value)){return isString4(value)?stringToArray2(value):copyArray2(value)}if(symIterator3&&value[symIterator3]){return iteratorToArray2(value[symIterator3]())}var tag=getTag3(value),func=tag==mapTag11?mapToArray2:tag==setTag11?setToArray2:values2;return func(value)}function toFinite2(value){if(!value){return value===0?value:0}value=toNumber2(value);if(value===INFINITY8||value===-INFINITY8){var sign=value<0?-1:1;return sign*MAX_INTEGER2}return value===value?value:0}function toInteger2(value){var result3=toFinite2(value),remainder=result3%1;return result3===result3?remainder?result3-remainder:result3:0}function toLength2(value){return value?baseClamp2(toInteger2(value),0,MAX_ARRAY_LENGTH8):0}function toNumber2(value){if(typeof value=="number"){return value}if(isSymbol2(value)){return NAN4}if(isObject4(value)){var other=typeof value.valueOf=="function"?value.valueOf():value;value=isObject4(other)?other+"":other}if(typeof value!="string"){return value===0?value:+value}value=baseTrim2(value);var isBinary2=reIsBinary2.test(value);return isBinary2||reIsOctal2.test(value)?freeParseInt2(value.slice(2),isBinary2?2:8):reIsBadHex2.test(value)?NAN4:+value}function toPlainObject2(value){return copyObject2(value,keysIn2(value))}function toSafeInteger2(value){return value?baseClamp2(toInteger2(value),-MAX_SAFE_INTEGER7,MAX_SAFE_INTEGER7):value===0?value:0}function toString5(value){return value==null?"":baseToString3(value)}var assign2=createAssigner2(function(object,source){if(isPrototype2(source)||isArrayLike2(source)){copyObject2(source,keys2(source),object);return}for(var key in source){if(hasOwnProperty26.call(source,key)){assignValue2(object,key,source[key])}}});var assignIn2=createAssigner2(function(object,source){copyObject2(source,keysIn2(source),object)});var assignInWith2=createAssigner2(function(object,source,srcIndex,customizer){copyObject2(source,keysIn2(source),object,customizer)});var assignWith2=createAssigner2(function(object,source,srcIndex,customizer){copyObject2(source,keys2(source),object,customizer)});var at2=flatRest2(baseAt2);function create3(prototype,properties){var result3=baseCreate2(prototype);return properties==null?result3:baseAssign2(result3,properties)}var defaults3=baseRest2(function(object,sources){object=Object2(object);var index=-1;var length=sources.length;var guard=length>2?sources[2]:undefined2;if(guard&&isIterateeCall2(sources[0],sources[1],guard)){length=1}while(++index<length){var source=sources[index];var props=keysIn2(source);var propsIndex=-1;var propsLength=props.length;while(++propsIndex<propsLength){var key=props[propsIndex];var value=object[key];if(value===undefined2||eq2(value,objectProto30[key])&&!hasOwnProperty26.call(object,key)){object[key]=source[key]}}}return object});var defaultsDeep2=baseRest2(function(args2){args2.push(undefined2,customDefaultsMerge2);return apply2(mergeWith2,undefined2,args2)});function findKey2(object,predicate){return baseFindKey2(object,getIteratee(predicate,3),baseForOwn2)}function findLastKey2(object,predicate){return baseFindKey2(object,getIteratee(predicate,3),baseForOwnRight2)}function forIn2(object,iteratee3){return object==null?object:baseFor2(object,getIteratee(iteratee3,3),keysIn2)}function forInRight2(object,iteratee3){return object==null?object:baseForRight2(object,getIteratee(iteratee3,3),keysIn2)}function forOwn2(object,iteratee3){return object&&baseForOwn2(object,getIteratee(iteratee3,3))}function forOwnRight2(object,iteratee3){return object&&baseForOwnRight2(object,getIteratee(iteratee3,3))}function functions2(object){return object==null?[]:baseFunctions2(object,keys2(object))}function functionsIn2(object){return object==null?[]:baseFunctions2(object,keysIn2(object))}function get4(object,path27,defaultValue){var result3=object==null?undefined2:baseGet2(object,path27);return result3===undefined2?defaultValue:result3}function has3(object,path27){return object!=null&&hasPath2(object,path27,baseHas2)}function hasIn2(object,path27){return object!=null&&hasPath2(object,path27,baseHasIn2)}var invert2=createInverter2(function(result3,value,key){if(value!=null&&typeof value.toString!="function"){value=nativeObjectToString5.call(value)}result3[value]=key},constant2(identity2));var invertBy2=createInverter2(function(result3,value,key){if(value!=null&&typeof value.toString!="function"){value=nativeObjectToString5.call(value)}if(hasOwnProperty26.call(result3,value)){result3[value].push(key)}else{result3[value]=[key]}},getIteratee);var invoke2=baseRest2(baseInvoke2);function keys2(object){return isArrayLike2(object)?arrayLikeKeys2(object):baseKeys2(object)}function keysIn2(object){return isArrayLike2(object)?arrayLikeKeys2(object,true):baseKeysIn2(object)}function mapKeys2(object,iteratee3){var result3={};iteratee3=getIteratee(iteratee3,3);baseForOwn2(object,function(value,key,object2){baseAssignValue2(result3,iteratee3(value,key,object2),value)});return result3}function mapValues2(object,iteratee3){var result3={};iteratee3=getIteratee(iteratee3,3);baseForOwn2(object,function(value,key,object2){baseAssignValue2(result3,key,iteratee3(value,key,object2))});return result3}var merge3=createAssigner2(function(object,source,srcIndex){baseMerge2(object,source,srcIndex)});var mergeWith2=createAssigner2(function(object,source,srcIndex,customizer){baseMerge2(object,source,srcIndex,customizer)});var omit2=flatRest2(function(object,paths){var result3={};if(object==null){return result3}var isDeep=false;paths=arrayMap2(paths,function(path27){path27=castPath2(path27,object);isDeep||(isDeep=path27.length>1);return path27});copyObject2(object,getAllKeysIn2(object),result3);if(isDeep){result3=baseClone2(result3,CLONE_DEEP_FLAG9|CLONE_FLAT_FLAG3|CLONE_SYMBOLS_FLAG7,customOmitClone2)}var length=paths.length;while(length--){baseUnset2(result3,paths[length])}return result3});function omitBy2(object,predicate){return pickBy2(object,negate2(getIteratee(predicate)))}var pick2=flatRest2(function(object,paths){return object==null?{}:basePick2(object,paths)});function pickBy2(object,predicate){if(object==null){return{}}var props=arrayMap2(getAllKeysIn2(object),function(prop){return[prop]});predicate=getIteratee(predicate);return basePickBy2(object,props,function(value,path27){return predicate(value,path27[0])})}function result2(object,path27,defaultValue){path27=castPath2(path27,object);var index=-1,length=path27.length;if(!length){length=1;object=undefined2}while(++index<length){var value=object==null?undefined2:object[toKey2(path27[index])];if(value===undefined2){index=length;value=defaultValue}object=isFunction3(value)?value.call(object):value}return object}function set3(object,path27,value){return object==null?object:baseSet2(object,path27,value)}function setWith2(object,path27,value,customizer){customizer=typeof customizer=="function"?customizer:undefined2;return object==null?object:baseSet2(object,path27,value,customizer)}var toPairs2=createToPairs2(keys2);var toPairsIn2=createToPairs2(keysIn2);function transform2(object,iteratee3,accumulator){var isArr=isArray3(object),isArrLike=isArr||isBuffer2(object)||isTypedArray2(object);iteratee3=getIteratee(iteratee3,4);if(accumulator==null){var Ctor=object&&object.constructor;if(isArrLike){accumulator=isArr?new Ctor:[]}else if(isObject4(object)){accumulator=isFunction3(Ctor)?baseCreate2(getPrototype2(object)):{}}else{accumulator={}}}(isArrLike?arrayEach2:baseForOwn2)(object,function(value,index,object2){return iteratee3(accumulator,value,index,object2)});return accumulator}function unset2(object,path27){return object==null?true:baseUnset2(object,path27)}function update2(object,path27,updater){return object==null?object:baseUpdate2(object,path27,castFunction2(updater))}function updateWith2(object,path27,updater,customizer){customizer=typeof customizer=="function"?customizer:undefined2;return object==null?object:baseUpdate2(object,path27,castFunction2(updater),customizer)}function values2(object){return object==null?[]:baseValues2(object,keys2(object))}function valuesIn2(object){return object==null?[]:baseValues2(object,keysIn2(object))}function clamp2(number2,lower,upper){if(upper===undefined2){upper=lower;lower=undefined2}if(upper!==undefined2){upper=toNumber2(upper);upper=upper===upper?upper:0}if(lower!==undefined2){lower=toNumber2(lower);lower=lower===lower?lower:0}return baseClamp2(toNumber2(number2),lower,upper)}function inRange2(number2,start,end){start=toFinite2(start);if(end===undefined2){end=start;start=0}else{end=toFinite2(end)}number2=toNumber2(number2);return baseInRange2(number2,start,end)}function random3(lower,upper,floating){if(floating&&typeof floating!="boolean"&&isIterateeCall2(lower,upper,floating)){upper=floating=undefined2}if(floating===undefined2){if(typeof upper=="boolean"){floating=upper;upper=undefined2}else if(typeof lower=="boolean"){floating=lower;lower=undefined2}}if(lower===undefined2&&upper===undefined2){lower=0;upper=1}else{lower=toFinite2(lower);if(upper===undefined2){upper=lower;lower=0}else{upper=toFinite2(upper)}}if(lower>upper){var temp=lower;lower=upper;upper=temp}if(floating||lower%1||upper%1){var rand=nativeRandom3();return nativeMin16(lower+rand*(upper-lower+freeParseFloat2("1e-"+((rand+"").length-1))),upper)}return baseRandom2(lower,upper)}var camelCase3=createCompounder2(function(result3,word,index){word=word.toLowerCase();return result3+(index?capitalize2(word):word)});function capitalize2(string){return upperFirst2(toString5(string).toLowerCase())}function deburr2(string){string=toString5(string);return string&&string.replace(reLatin2,deburrLetter2).replace(reComboMark2,"")}function endsWith2(string,target,position){string=toString5(string);target=baseToString3(target);var length=string.length;position=position===undefined2?length:baseClamp2(toInteger2(position),0,length);var end=position;position-=target.length;return position>=0&&string.slice(position,end)==target}function escape3(string){string=toString5(string);return string&&reHasUnescapedHtml2.test(string)?string.replace(reUnescapedHtml2,escapeHtmlChar2):string}function escapeRegExp2(string){string=toString5(string);return string&&reHasRegExpChar2.test(string)?string.replace(reRegExpChar3,"\\$&"):string}var kebabCase2=createCompounder2(function(result3,word,index){return result3+(index?"-":"")+word.toLowerCase()});var lowerCase2=createCompounder2(function(result3,word,index){return result3+(index?" ":"")+word.toLowerCase()});var lowerFirst2=createCaseFirst2("toLowerCase");function pad4(string,length,chars){string=toString5(string);length=toInteger2(length);var strLength=length?stringSize2(string):0;if(!length||strLength>=length){return string}var mid=(length-strLength)/2;return createPadding2(nativeFloor5(mid),chars)+string+createPadding2(nativeCeil5(mid),chars)}function padEnd2(string,length,chars){string=toString5(string);length=toInteger2(length);var strLength=length?stringSize2(string):0;return length&&strLength<length?string+createPadding2(length-strLength,chars):string}function padStart3(string,length,chars){string=toString5(string);length=toInteger2(length);var strLength=length?stringSize2(string):0;return length&&strLength<length?createPadding2(length-strLength,chars)+string:string}function parseInt3(string,radix,guard){if(guard||radix==null){radix=0}else if(radix){radix=+radix}return nativeParseInt2(toString5(string).replace(reTrimStart4,""),radix||0)}function repeat3(string,n,guard){if(guard?isIterateeCall2(string,n,guard):n===undefined2){n=1}else{n=toInteger2(n)}return baseRepeat2(toString5(string),n)}function replace2(){var args2=arguments,string=toString5(args2[0]);return args2.length<3?string:string.replace(args2[1],args2[2])}var snakeCase2=createCompounder2(function(result3,word,index){return result3+(index?"_":"")+word.toLowerCase()});function split2(string,separator,limit){if(limit&&typeof limit!="number"&&isIterateeCall2(string,separator,limit)){separator=limit=undefined2}limit=limit===undefined2?MAX_ARRAY_LENGTH8:limit>>>0;if(!limit){return[]}string=toString5(string);if(string&&(typeof separator=="string"||separator!=null&&!isRegExp2(separator))){separator=baseToString3(separator);if(!separator&&hasUnicode2(string)){return castSlice2(stringToArray2(string),0,limit)}}return string.split(separator,limit)}var startCase2=createCompounder2(function(result3,word,index){return result3+(index?" ":"")+upperFirst2(word)});function startsWith2(string,target,position){string=toString5(string);position=position==null?0:baseClamp2(toInteger2(position),0,string.length);target=baseToString3(target);return string.slice(position,position+target.length)==target}function template2(string,options,guard){var settings=lodash3.templateSettings;if(guard&&isIterateeCall2(string,options,guard)){options=undefined2}string=toString5(string);options=assignInWith2({},options,settings,customDefaultsAssignIn2);var imports=assignInWith2({},options.imports,settings.imports,customDefaultsAssignIn2),importsKeys=keys2(imports),importsValues=baseValues2(imports,importsKeys);var isEscaping,isEvaluating,index=0,interpolate=options.interpolate||reNoMatch2,source="__p += '";var reDelimiters=RegExp2((options.escape||reNoMatch2).source+"|"+interpolate.source+"|"+(interpolate===reInterpolate2?reEsTemplate2:reNoMatch2).source+"|"+(options.evaluate||reNoMatch2).source+"|$","g");var sourceURL="//# sourceURL="+(hasOwnProperty26.call(options,"sourceURL")?(options.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++templateCounter+"]")+"\n";string.replace(reDelimiters,function(match,escapeValue,interpolateValue,esTemplateValue,evaluateValue,offset){interpolateValue||(interpolateValue=esTemplateValue);source+=string.slice(index,offset).replace(reUnescapedString2,escapeStringChar2);if(escapeValue){isEscaping=true;source+="' +\n__e("+escapeValue+") +\n'"}if(evaluateValue){isEvaluating=true;source+="';\n"+evaluateValue+";\n__p += '"}if(interpolateValue){source+="' +\n((__t = ("+interpolateValue+")) == null ? '' : __t) +\n'"}index=offset+match.length;return match});source+="';\n";var variable=hasOwnProperty26.call(options,"variable")&&options.variable;if(!variable){source="with (obj) {\n"+source+"\n}\n"}else if(reForbiddenIdentifierChars2.test(variable)){throw new Error2(INVALID_TEMPL_VAR_ERROR_TEXT2)}source=(isEvaluating?source.replace(reEmptyStringLeading2,""):source).replace(reEmptyStringMiddle2,"$1").replace(reEmptyStringTrailing2,"$1;");source="function("+(variable||"obj")+") {\n"+(variable?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(isEscaping?", __e = _.escape":"")+(isEvaluating?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+source+"return __p\n}";var result3=attempt2(function(){return Function2(importsKeys,sourceURL+"return "+source).apply(undefined2,importsValues)});result3.source=source;if(isError2(result3)){throw result3}return result3}function toLower2(value){return toString5(value).toLowerCase()}function toUpper2(value){return toString5(value).toUpperCase()}function trim2(string,chars,guard){string=toString5(string);if(string&&(guard||chars===undefined2)){return baseTrim2(string)}if(!string||!(chars=baseToString3(chars))){return string}var strSymbols=stringToArray2(string),chrSymbols=stringToArray2(chars),start=charsStartIndex2(strSymbols,chrSymbols),end=charsEndIndex2(strSymbols,chrSymbols)+1;return castSlice2(strSymbols,start,end).join("")}function trimEnd2(string,chars,guard){string=toString5(string);if(string&&(guard||chars===undefined2)){return string.slice(0,trimmedEndIndex2(string)+1)}if(!string||!(chars=baseToString3(chars))){return string}var strSymbols=stringToArray2(string),end=charsEndIndex2(strSymbols,stringToArray2(chars))+1;return castSlice2(strSymbols,0,end).join("")}function trimStart2(string,chars,guard){string=toString5(string);if(string&&(guard||chars===undefined2)){return string.replace(reTrimStart4,"")}if(!string||!(chars=baseToString3(chars))){return string}var strSymbols=stringToArray2(string),start=charsStartIndex2(strSymbols,stringToArray2(chars));return castSlice2(strSymbols,start).join("")}function truncate2(string,options){var length=DEFAULT_TRUNC_LENGTH2,omission=DEFAULT_TRUNC_OMISSION2;if(isObject4(options)){var separator="separator"in options?options.separator:separator;length="length"in options?toInteger2(options.length):length;omission="omission"in options?baseToString3(options.omission):omission}string=toString5(string);var strLength=string.length;if(hasUnicode2(string)){var strSymbols=stringToArray2(string);strLength=strSymbols.length}if(length>=strLength){return string}var end=length-stringSize2(omission);if(end<1){return omission}var result3=strSymbols?castSlice2(strSymbols,0,end).join(""):string.slice(0,end);if(separator===undefined2){return result3+omission}if(strSymbols){end+=result3.length-end}if(isRegExp2(separator)){if(string.slice(end).search(separator)){var match,substring=result3;if(!separator.global){separator=RegExp2(separator.source,toString5(reFlags3.exec(separator))+"g")}separator.lastIndex=0;while(match=separator.exec(substring)){var newEnd=match.index}result3=result3.slice(0,newEnd===undefined2?end:newEnd)}}else if(string.indexOf(baseToString3(separator),end)!=end){var index=result3.lastIndexOf(separator);if(index>-1){result3=result3.slice(0,index)}}return result3+omission}function unescape3(string){string=toString5(string);return string&&reHasEscapedHtml2.test(string)?string.replace(reEscapedHtml2,unescapeHtmlChar2):string}var upperCase2=createCompounder2(function(result3,word,index){return result3+(index?" ":"")+word.toUpperCase()});var upperFirst2=createCaseFirst2("toUpperCase");function words2(string,pattern,guard){string=toString5(string);pattern=guard?undefined2:pattern;if(pattern===undefined2){return hasUnicodeWord2(string)?unicodeWords2(string):asciiWords2(string)}return string.match(pattern)||[]}var attempt2=baseRest2(function(func,args2){try{return apply2(func,undefined2,args2)}catch(e){return isError2(e)?e:new Error2(e)}});var bindAll2=flatRest2(function(object,methodNames){arrayEach2(methodNames,function(key){key=toKey2(key);baseAssignValue2(object,key,bind2(object[key],object))});return object});function cond2(pairs2){var length=pairs2==null?0:pairs2.length,toIteratee=getIteratee();pairs2=!length?[]:arrayMap2(pairs2,function(pair){if(typeof pair[1]!="function"){throw new TypeError2(FUNC_ERROR_TEXT13)}return[toIteratee(pair[0]),pair[1]]});return baseRest2(function(args2){var index=-1;while(++index<length){var pair=pairs2[index];if(apply2(pair[0],this,args2)){return apply2(pair[1],this,args2)}}})}function conforms2(source){return baseConforms2(baseClone2(source,CLONE_DEEP_FLAG9))}function constant2(value){return function(){return value}}function defaultTo2(value,defaultValue){return value==null||value!==value?defaultValue:value}var flow2=createFlow2();var flowRight2=createFlow2(true);function identity2(value){return value}function iteratee2(func){return baseIteratee2(typeof func=="function"?func:baseClone2(func,CLONE_DEEP_FLAG9))}function matches2(source){return baseMatches2(baseClone2(source,CLONE_DEEP_FLAG9))}function matchesProperty2(path27,srcValue){return baseMatchesProperty2(path27,baseClone2(srcValue,CLONE_DEEP_FLAG9))}var method2=baseRest2(function(path27,args2){return function(object){return baseInvoke2(object,path27,args2)}});var methodOf2=baseRest2(function(object,args2){return function(path27){return baseInvoke2(object,path27,args2)}});function mixin3(object,source,options){var props=keys2(source),methodNames=baseFunctions2(source,props);if(options==null&&!(isObject4(source)&&(methodNames.length||!props.length))){options=source;source=object;object=this;methodNames=baseFunctions2(source,keys2(source))}var chain3=!(isObject4(options)&&"chain"in options)||!!options.chain,isFunc=isFunction3(object);arrayEach2(methodNames,function(methodName){var func=source[methodName];object[methodName]=func;if(isFunc){object.prototype[methodName]=function(){var chainAll=this.__chain__;if(chain3||chainAll){var result3=object(this.__wrapped__),actions=result3.__actions__=copyArray2(this.__actions__);actions.push({"func":func,"args":arguments,"thisArg":object});result3.__chain__=chainAll;return result3}return func.apply(object,arrayPush2([this.value()],arguments))}}});return object}function noConflict(){if(root2._===this){root2._=oldDash}return this}function noop4(){}function nthArg2(n){n=toInteger2(n);return baseRest2(function(args2){return baseNth2(args2,n)})}var over2=createOver2(arrayMap2);var overEvery2=createOver2(arrayEvery2);var overSome2=createOver2(arraySome2);function property2(path27){return isKey2(path27)?baseProperty2(toKey2(path27)):basePropertyDeep2(path27)}function propertyOf2(object){return function(path27){return object==null?undefined2:baseGet2(object,path27)}}var range2=createRange2();var rangeRight2=createRange2(true);function stubArray2(){return[]}function stubFalse2(){return false}function stubObject2(){return{}}function stubString2(){return""}function stubTrue2(){return true}function times2(n,iteratee3){n=toInteger2(n);if(n<1||n>MAX_SAFE_INTEGER7){return[]}var index=MAX_ARRAY_LENGTH8,length=nativeMin16(n,MAX_ARRAY_LENGTH8);iteratee3=getIteratee(iteratee3);n-=MAX_ARRAY_LENGTH8;var result3=baseTimes2(length,iteratee3);while(++index<n){iteratee3(index)}return result3}function toPath2(value){if(isArray3(value)){return arrayMap2(value,toKey2)}return isSymbol2(value)?[value]:copyArray2(stringToPath2(toString5(value)))}function uniqueId2(prefix){var id=++idCounter2;return toString5(prefix)+id}var add2=createMathOperation2(function(augend,addend){return augend+addend},0);var ceil2=createRound2("ceil");var divide2=createMathOperation2(function(dividend,divisor){return dividend/divisor},1);var floor2=createRound2("floor");function max3(array){return array&&array.length?baseExtremum2(array,identity2,baseGt2):undefined2}function maxBy2(array,iteratee3){return array&&array.length?baseExtremum2(array,getIteratee(iteratee3,2),baseGt2):undefined2}function mean2(array){return baseMean2(array,identity2)}function meanBy2(array,iteratee3){return baseMean2(array,getIteratee(iteratee3,2))}function min3(array){return array&&array.length?baseExtremum2(array,identity2,baseLt2):undefined2}function minBy2(array,iteratee3){return array&&array.length?baseExtremum2(array,getIteratee(iteratee3,2),baseLt2):undefined2}var multiply2=createMathOperation2(function(multiplier,multiplicand){return multiplier*multiplicand},1);var round2=createRound2("round");var subtract2=createMathOperation2(function(minuend,subtrahend){return minuend-subtrahend},0);function sum2(array){return array&&array.length?baseSum2(array,identity2):0}function sumBy2(array,iteratee3){return array&&array.length?baseSum2(array,getIteratee(iteratee3,2)):0}lodash3.after=after2;lodash3.ary=ary2;lodash3.assign=assign2;lodash3.assignIn=assignIn2;lodash3.assignInWith=assignInWith2;lodash3.assignWith=assignWith2;lodash3.at=at2;lodash3.before=before2;lodash3.bind=bind2;lodash3.bindAll=bindAll2;lodash3.bindKey=bindKey2;lodash3.castArray=castArray2;lodash3.chain=chain2;lodash3.chunk=chunk2;lodash3.compact=compact2;lodash3.concat=concat3;lodash3.cond=cond2;lodash3.conforms=conforms2;lodash3.constant=constant2;lodash3.countBy=countBy2;lodash3.create=create3;lodash3.curry=curry2;lodash3.curryRight=curryRight2;lodash3.debounce=debounce2;lodash3.defaults=defaults3;lodash3.defaultsDeep=defaultsDeep2;lodash3.defer=defer2;lodash3.delay=delay4;lodash3.difference=difference2;lodash3.differenceBy=differenceBy2;lodash3.differenceWith=differenceWith2;lodash3.drop=drop2;lodash3.dropRight=dropRight2;lodash3.dropRightWhile=dropRightWhile2;lodash3.dropWhile=dropWhile2;lodash3.fill=fill2;lodash3.filter=filter2;lodash3.flatMap=flatMap2;lodash3.flatMapDeep=flatMapDeep2;lodash3.flatMapDepth=flatMapDepth2;lodash3.flatten=flatten2;lodash3.flattenDeep=flattenDeep2;lodash3.flattenDepth=flattenDepth2;lodash3.flip=flip2;lodash3.flow=flow2;lodash3.flowRight=flowRight2;lodash3.fromPairs=fromPairs2;lodash3.functions=functions2;lodash3.functionsIn=functionsIn2;lodash3.groupBy=groupBy2;lodash3.initial=initial2;lodash3.intersection=intersection2;lodash3.intersectionBy=intersectionBy2;lodash3.intersectionWith=intersectionWith2;lodash3.invert=invert2;lodash3.invertBy=invertBy2;lodash3.invokeMap=invokeMap2;lodash3.iteratee=iteratee2;lodash3.keyBy=keyBy2;lodash3.keys=keys2;lodash3.keysIn=keysIn2;lodash3.map=map3;lodash3.mapKeys=mapKeys2;lodash3.mapValues=mapValues2;lodash3.matches=matches2;lodash3.matchesProperty=matchesProperty2;lodash3.memoize=memoize2;lodash3.merge=merge3;lodash3.mergeWith=mergeWith2;lodash3.method=method2;lodash3.methodOf=methodOf2;lodash3.mixin=mixin3;lodash3.negate=negate2;lodash3.nthArg=nthArg2;lodash3.omit=omit2;lodash3.omitBy=omitBy2;lodash3.once=once2;lodash3.orderBy=orderBy2;lodash3.over=over2;lodash3.overArgs=overArgs2;lodash3.overEvery=overEvery2;lodash3.overSome=overSome2;lodash3.partial=partial2;lodash3.partialRight=partialRight2;lodash3.partition=partition2;lodash3.pick=pick2;lodash3.pickBy=pickBy2;lodash3.property=property2;lodash3.propertyOf=propertyOf2;lodash3.pull=pull2;lodash3.pullAll=pullAll2;lodash3.pullAllBy=pullAllBy2;lodash3.pullAllWith=pullAllWith2;lodash3.pullAt=pullAt2;lodash3.range=range2;lodash3.rangeRight=rangeRight2;lodash3.rearg=rearg2;lodash3.reject=reject2;lodash3.remove=remove2;lodash3.rest=rest2;lodash3.reverse=reverse2;lodash3.sampleSize=sampleSize2;lodash3.set=set3;lodash3.setWith=setWith2;lodash3.shuffle=shuffle2;lodash3.slice=slice2;lodash3.sortBy=sortBy2;lodash3.sortedUniq=sortedUniq2;lodash3.sortedUniqBy=sortedUniqBy2;lodash3.split=split2;lodash3.spread=spread2;lodash3.tail=tail2;lodash3.take=take2;lodash3.takeRight=takeRight2;lodash3.takeRightWhile=takeRightWhile2;lodash3.takeWhile=takeWhile2;lodash3.tap=tap2;lodash3.throttle=throttle3;lodash3.thru=thru2;lodash3.toArray=toArray3;lodash3.toPairs=toPairs2;lodash3.toPairsIn=toPairsIn2;lodash3.toPath=toPath2;lodash3.toPlainObject=toPlainObject2;lodash3.transform=transform2;lodash3.unary=unary2;lodash3.union=union2;lodash3.unionBy=unionBy2;lodash3.unionWith=unionWith2;lodash3.uniq=uniq2;lodash3.uniqBy=uniqBy2;lodash3.uniqWith=uniqWith2;lodash3.unset=unset2;lodash3.unzip=unzip2;lodash3.unzipWith=unzipWith2;lodash3.update=update2;lodash3.updateWith=updateWith2;lodash3.values=values2;lodash3.valuesIn=valuesIn2;lodash3.without=without2;lodash3.words=words2;lodash3.wrap=wrap4;lodash3.xor=xor2;lodash3.xorBy=xorBy2;lodash3.xorWith=xorWith2;lodash3.zip=zip2;lodash3.zipObject=zipObject2;lodash3.zipObjectDeep=zipObjectDeep2;lodash3.zipWith=zipWith2;lodash3.entries=toPairs2;lodash3.entriesIn=toPairsIn2;lodash3.extend=assignIn2;lodash3.extendWith=assignInWith2;mixin3(lodash3,lodash3);lodash3.add=add2;lodash3.attempt=attempt2;lodash3.camelCase=camelCase3;lodash3.capitalize=capitalize2;lodash3.ceil=ceil2;lodash3.clamp=clamp2;lodash3.clone=clone2;lodash3.cloneDeep=cloneDeep3;lodash3.cloneDeepWith=cloneDeepWith2;lodash3.cloneWith=cloneWith2;lodash3.conformsTo=conformsTo2;lodash3.deburr=deburr2;lodash3.defaultTo=defaultTo2;lodash3.divide=divide2;lodash3.endsWith=endsWith2;lodash3.eq=eq2;lodash3.escape=escape3;lodash3.escapeRegExp=escapeRegExp2;lodash3.every=every2;lodash3.find=find2;lodash3.findIndex=findIndex2;lodash3.findKey=findKey2;lodash3.findLast=findLast2;lodash3.findLastIndex=findLastIndex2;lodash3.findLastKey=findLastKey2;lodash3.floor=floor2;lodash3.forEach=forEach2;lodash3.forEachRight=forEachRight2;lodash3.forIn=forIn2;lodash3.forInRight=forInRight2;lodash3.forOwn=forOwn2;lodash3.forOwnRight=forOwnRight2;lodash3.get=get4;lodash3.gt=gt2;lodash3.gte=gte2;lodash3.has=has3;lodash3.hasIn=hasIn2;lodash3.head=head2;lodash3.identity=identity2;lodash3.includes=includes2;lodash3.indexOf=indexOf2;lodash3.inRange=inRange2;lodash3.invoke=invoke2;lodash3.isArguments=isArguments2;lodash3.isArray=isArray3;lodash3.isArrayBuffer=isArrayBuffer2;lodash3.isArrayLike=isArrayLike2;lodash3.isArrayLikeObject=isArrayLikeObject2;lodash3.isBoolean=isBoolean4;lodash3.isBuffer=isBuffer2;lodash3.isDate=isDate2;lodash3.isElement=isElement2;lodash3.isEmpty=isEmpty2;lodash3.isEqual=isEqual2;lodash3.isEqualWith=isEqualWith2;lodash3.isError=isError2;lodash3.isFinite=isFinite3;lodash3.isFunction=isFunction3;lodash3.isInteger=isInteger3;lodash3.isLength=isLength2;lodash3.isMap=isMap2;lodash3.isMatch=isMatch2;lodash3.isMatchWith=isMatchWith2;lodash3.isNaN=isNaN3;lodash3.isNative=isNative2;lodash3.isNil=isNil2;lodash3.isNull=isNull3;lodash3.isNumber=isNumber4;lodash3.isObject=isObject4;lodash3.isObjectLike=isObjectLike3;lodash3.isPlainObject=isPlainObject3;lodash3.isRegExp=isRegExp2;lodash3.isSafeInteger=isSafeInteger2;lodash3.isSet=isSet2;lodash3.isString=isString4;lodash3.isSymbol=isSymbol2;lodash3.isTypedArray=isTypedArray2;lodash3.isUndefined=isUndefined7;lodash3.isWeakMap=isWeakMap2;lodash3.isWeakSet=isWeakSet2;lodash3.join=join4;lodash3.kebabCase=kebabCase2;lodash3.last=last2;lodash3.lastIndexOf=lastIndexOf2;lodash3.lowerCase=lowerCase2;lodash3.lowerFirst=lowerFirst2;lodash3.lt=lt2;lodash3.lte=lte2;lodash3.max=max3;lodash3.maxBy=maxBy2;lodash3.mean=mean2;lodash3.meanBy=meanBy2;lodash3.min=min3;lodash3.minBy=minBy2;lodash3.stubArray=stubArray2;lodash3.stubFalse=stubFalse2;lodash3.stubObject=stubObject2;lodash3.stubString=stubString2;lodash3.stubTrue=stubTrue2;lodash3.multiply=multiply2;lodash3.nth=nth2;lodash3.noConflict=noConflict;lodash3.noop=noop4;lodash3.now=now3;lodash3.pad=pad4;lodash3.padEnd=padEnd2;lodash3.padStart=padStart3;lodash3.parseInt=parseInt3;lodash3.random=random3;lodash3.reduce=reduce2;lodash3.reduceRight=reduceRight2;lodash3.repeat=repeat3;lodash3.replace=replace2;lodash3.result=result2;lodash3.round=round2;lodash3.runInContext=runInContext2;lodash3.sample=sample2;lodash3.size=size2;lodash3.snakeCase=snakeCase2;lodash3.some=some2;lodash3.sortedIndex=sortedIndex2;lodash3.sortedIndexBy=sortedIndexBy2;lodash3.sortedIndexOf=sortedIndexOf2;lodash3.sortedLastIndex=sortedLastIndex2;lodash3.sortedLastIndexBy=sortedLastIndexBy2;lodash3.sortedLastIndexOf=sortedLastIndexOf2;lodash3.startCase=startCase2;lodash3.startsWith=startsWith2;lodash3.subtract=subtract2;lodash3.sum=sum2;lodash3.sumBy=sumBy2;lodash3.template=template2;lodash3.times=times2;lodash3.toFinite=toFinite2;lodash3.toInteger=toInteger2;lodash3.toLength=toLength2;lodash3.toLower=toLower2;lodash3.toNumber=toNumber2;lodash3.toSafeInteger=toSafeInteger2;lodash3.toString=toString5;lodash3.toUpper=toUpper2;lodash3.trim=trim2;lodash3.trimEnd=trimEnd2;lodash3.trimStart=trimStart2;lodash3.truncate=truncate2;lodash3.unescape=unescape3;lodash3.uniqueId=uniqueId2;lodash3.upperCase=upperCase2;lodash3.upperFirst=upperFirst2;lodash3.each=forEach2;lodash3.eachRight=forEachRight2;lodash3.first=head2;mixin3(lodash3,function(){var source={};baseForOwn2(lodash3,function(func,methodName){if(!hasOwnProperty26.call(lodash3.prototype,methodName)){source[methodName]=func}});return source}(),{"chain":false});lodash3.VERSION=VERSION2;arrayEach2(["bind","bindKey","curry","curryRight","partial","partialRight"],function(methodName){lodash3[methodName].placeholder=lodash3});arrayEach2(["drop","take"],function(methodName,index){LazyWrapper2.prototype[methodName]=function(n){n=n===undefined2?1:nativeMax18(toInteger2(n),0);var result3=this.__filtered__&&!index?new LazyWrapper2(this):this.clone();if(result3.__filtered__){result3.__takeCount__=nativeMin16(n,result3.__takeCount__)}else{result3.__views__.push({"size":nativeMin16(n,MAX_ARRAY_LENGTH8),"type":methodName+(result3.__dir__<0?"Right":"")})}return result3};LazyWrapper2.prototype[methodName+"Right"]=function(n){return this.reverse()[methodName](n).reverse()}});arrayEach2(["filter","map","takeWhile"],function(methodName,index){var type2=index+1,isFilter=type2==LAZY_FILTER_FLAG3||type2==LAZY_WHILE_FLAG2;LazyWrapper2.prototype[methodName]=function(iteratee3){var result3=this.clone();result3.__iteratees__.push({"iteratee":getIteratee(iteratee3,3),"type":type2});result3.__filtered__=result3.__filtered__||isFilter;return result3}});arrayEach2(["head","last"],function(methodName,index){var takeName="take"+(index?"Right":"");LazyWrapper2.prototype[methodName]=function(){return this[takeName](1).value()[0]}});arrayEach2(["initial","tail"],function(methodName,index){var dropName="drop"+(index?"":"Right");LazyWrapper2.prototype[methodName]=function(){return this.__filtered__?new LazyWrapper2(this):this[dropName](1)}});LazyWrapper2.prototype.compact=function(){return this.filter(identity2)};LazyWrapper2.prototype.find=function(predicate){return this.filter(predicate).head()};LazyWrapper2.prototype.findLast=function(predicate){return this.reverse().find(predicate)};LazyWrapper2.prototype.invokeMap=baseRest2(function(path27,args2){if(typeof path27=="function"){return new LazyWrapper2(this)}return this.map(function(value){return baseInvoke2(value,path27,args2)})});LazyWrapper2.prototype.reject=function(predicate){return this.filter(negate2(getIteratee(predicate)))};LazyWrapper2.prototype.slice=function(start,end){start=toInteger2(start);var result3=this;if(result3.__filtered__&&(start>0||end<0)){return new LazyWrapper2(result3)}if(start<0){result3=result3.takeRight(-start)}else if(start){result3=result3.drop(start)}if(end!==undefined2){end=toInteger2(end);result3=end<0?result3.dropRight(-end):result3.take(end-start)}return result3};LazyWrapper2.prototype.takeRightWhile=function(predicate){return this.reverse().takeWhile(predicate).reverse()};LazyWrapper2.prototype.toArray=function(){return this.take(MAX_ARRAY_LENGTH8)};baseForOwn2(LazyWrapper2.prototype,function(func,methodName){var checkIteratee=/^(?:filter|find|map|reject)|While$/.test(methodName),isTaker=/^(?:head|last)$/.test(methodName),lodashFunc=lodash3[isTaker?"take"+(methodName=="last"?"Right":""):methodName],retUnwrapped=isTaker||/^find/.test(methodName);if(!lodashFunc){return}lodash3.prototype[methodName]=function(){var value=this.__wrapped__,args2=isTaker?[1]:arguments,isLazy=value instanceof LazyWrapper2,iteratee3=args2[0],useLazy=isLazy||isArray3(value);var interceptor=function(value2){var result4=lodashFunc.apply(lodash3,arrayPush2([value2],args2));return isTaker&&chainAll?result4[0]:result4};if(useLazy&&checkIteratee&&typeof iteratee3=="function"&&iteratee3.length!=1){isLazy=useLazy=false}var chainAll=this.__chain__,isHybrid=!!this.__actions__.length,isUnwrapped=retUnwrapped&&!chainAll,onlyLazy=isLazy&&!isHybrid;if(!retUnwrapped&&useLazy){value=onlyLazy?value:new LazyWrapper2(this);var result3=func.apply(value,args2);result3.__actions__.push({"func":thru2,"args":[interceptor],"thisArg":undefined2});return new LodashWrapper2(result3,chainAll)}if(isUnwrapped&&onlyLazy){return func.apply(this,args2)}result3=this.thru(interceptor);return isUnwrapped?isTaker?result3.value()[0]:result3.value():result3}});arrayEach2(["pop","push","shift","sort","splice","unshift"],function(methodName){var func=arrayProto7[methodName],chainName=/^(?:push|sort|unshift)$/.test(methodName)?"tap":"thru",retUnwrapped=/^(?:pop|shift)$/.test(methodName);lodash3.prototype[methodName]=function(){var args2=arguments;if(retUnwrapped&&!this.__chain__){var value=this.value();return func.apply(isArray3(value)?value:[],args2)}return this[chainName](function(value2){return func.apply(isArray3(value2)?value2:[],args2)})}});baseForOwn2(LazyWrapper2.prototype,function(func,methodName){var lodashFunc=lodash3[methodName];if(lodashFunc){var key=lodashFunc.name+"";if(!hasOwnProperty26.call(realNames2,key)){realNames2[key]=[]}realNames2[key].push({"name":methodName,"func":lodashFunc})}});realNames2[createHybrid2(undefined2,WRAP_BIND_KEY_FLAG8).name]=[{"name":"wrapper","func":undefined2}];LazyWrapper2.prototype.clone=lazyClone2;LazyWrapper2.prototype.reverse=lazyReverse2;LazyWrapper2.prototype.value=lazyValue2;lodash3.prototype.at=wrapperAt2;lodash3.prototype.chain=wrapperChain2;lodash3.prototype.commit=wrapperCommit2;lodash3.prototype.next=wrapperNext2;lodash3.prototype.plant=wrapperPlant2;lodash3.prototype.reverse=wrapperReverse2;lodash3.prototype.toJSON=lodash3.prototype.valueOf=lodash3.prototype.value=wrapperValue2;lodash3.prototype.first=lodash3.prototype.head;if(symIterator3){lodash3.prototype[symIterator3]=wrapperToIterator2}return lodash3};var _=runInContext();if(typeof define=="function"&&typeof define.amd=="object"&&define.amd){root2._=_;define(function(){return _})}else if(freeModule4){(freeModule4.exports=_)._=_;freeExports4._=_}else{root2._=_}}).call(exports2)}});var require_source=__commonJS({"node_modules/defer-to-connect/dist/source/index.js"(exports2,module2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});function isTLSSocket(socket){return socket.encrypted}var deferToConnect2=(socket,fn2)=>{let listeners;if(typeof fn2==="function"){const connect=fn2;listeners={connect}}else{listeners=fn2}const hasConnectListener=typeof listeners.connect==="function";const hasSecureConnectListener=typeof listeners.secureConnect==="function";const hasCloseListener=typeof listeners.close==="function";const onConnect=()=>{if(hasConnectListener){listeners.connect()}if(isTLSSocket(socket)&&hasSecureConnectListener){if(socket.authorized){listeners.secureConnect()}else if(!socket.authorizationError){socket.once("secureConnect",listeners.secureConnect)}}if(hasCloseListener){socket.once("close",listeners.close)}};if(socket.writable&&!socket.connecting){onConnect()}else if(socket.connecting){socket.once("connect",onConnect)}else if(socket.destroyed&&hasCloseListener){listeners.close(socket._hadError)}};exports2.default=deferToConnect2;module2.exports=deferToConnect2;module2.exports.default=deferToConnect2}});var require_buffer_stream=__commonJS({"node_modules/get-stream/buffer-stream.js"(exports2,module2){"use strict";var{PassThrough:PassThroughStream2}=require("stream");module2.exports=options=>{options={...options};const{array}=options;let{encoding}=options;const isBuffer2=encoding==="buffer";let objectMode=false;if(array){objectMode=!(encoding||isBuffer2)}else{encoding=encoding||"utf8"}if(isBuffer2){encoding=null}const stream3=new PassThroughStream2({objectMode});if(encoding){stream3.setEncoding(encoding)}let length=0;const chunks=[];stream3.on("data",chunk2=>{chunks.push(chunk2);if(objectMode){length=chunks.length}else{length+=chunk2.length}});stream3.getBufferedValue=()=>{if(array){return chunks}return isBuffer2?Buffer.concat(chunks,length):chunks.join("")};stream3.getBufferedLength=()=>length;return stream3}}});var require_get_stream=__commonJS({"node_modules/get-stream/index.js"(exports2,module2){"use strict";var{constants:BufferConstants}=require("buffer");var stream3=require("stream");var{promisify:promisify9}=require("util");var bufferStream=require_buffer_stream();var streamPipelinePromisified=promisify9(stream3.pipeline);var MaxBufferError=class extends Error{constructor(){super("maxBuffer exceeded");this.name="MaxBufferError"}};async function getStream3(inputStream,options){if(!inputStream){throw new Error("Expected a stream")}options={maxBuffer:Infinity,...options};const{maxBuffer}=options;const stream4=bufferStream(options);await new Promise((resolve,reject2)=>{const rejectPromise=error=>{if(error&&stream4.getBufferedLength()<=BufferConstants.MAX_LENGTH){error.bufferedData=stream4.getBufferedValue()}reject2(error)};(async()=>{try{await streamPipelinePromisified(inputStream,stream4);resolve()}catch(error){rejectPromise(error)}})();stream4.on("data",()=>{if(stream4.getBufferedLength()>maxBuffer){rejectPromise(new MaxBufferError)}})});return stream4.getBufferedValue()}module2.exports=getStream3;module2.exports.buffer=(stream4,options)=>getStream3(stream4,{...options,encoding:"buffer"});module2.exports.array=(stream4,options)=>getStream3(stream4,{...options,array:true});module2.exports.MaxBufferError=MaxBufferError}});var require_http_cache_semantics=__commonJS({"node_modules/http-cache-semantics/index.js"(exports2,module2){"use strict";var statusCodeCacheableByDefault=new Set([200,203,204,206,300,301,308,404,405,410,414,501]);var understoodStatuses=new Set([200,203,204,300,301,302,303,307,308,404,405,410,414,501]);var errorStatusCodes=new Set([500,502,503,504]);var hopByHopHeaders={date:true,connection:true,"keep-alive":true,"proxy-authenticate":true,"proxy-authorization":true,te:true,trailer:true,"transfer-encoding":true,upgrade:true};var excludedFromRevalidationUpdate={"content-length":true,"content-encoding":true,"transfer-encoding":true,"content-range":true};function toNumberOrZero(s){const n=parseInt(s,10);return isFinite(n)?n:0}function isErrorResponse(response){if(!response){return true}return errorStatusCodes.has(response.status)}function parseCacheControl(header2){const cc={};if(!header2)return cc;const parts=header2.trim().split(/,/);for(const part of parts){const[k,v]=part.split(/=/,2);cc[k.trim()]=v===void 0?true:v.trim().replace(/^"|"$/g,"")}return cc}function formatCacheControl(cc){let parts=[];for(const k in cc){const v=cc[k];parts.push(v===true?k:k+"="+v)}if(!parts.length){return void 0}return parts.join(", ")}module2.exports=class CachePolicy{constructor(req,res,{shared,cacheHeuristic,immutableMinTimeToLive,ignoreCargoCult,_fromObject}={}){if(_fromObject){this._fromObject(_fromObject);return}if(!res||!res.headers){throw Error("Response headers missing")}this._assertRequestHasHeaders(req);this._responseTime=this.now();this._isShared=shared!==false;this._cacheHeuristic=void 0!==cacheHeuristic?cacheHeuristic:.1;this._immutableMinTtl=void 0!==immutableMinTimeToLive?immutableMinTimeToLive:24*3600*1e3;this._status="status"in res?res.status:200;this._resHeaders=res.headers;this._rescc=parseCacheControl(res.headers["cache-control"]);this._method="method"in req?req.method:"GET";this._url=req.url;this._host=req.headers.host;this._noAuthorization=!req.headers.authorization;this._reqHeaders=res.headers.vary?req.headers:null;this._reqcc=parseCacheControl(req.headers["cache-control"]);if(ignoreCargoCult&&"pre-check"in this._rescc&&"post-check"in this._rescc){delete this._rescc["pre-check"];delete this._rescc["post-check"];delete this._rescc["no-cache"];delete this._rescc["no-store"];delete this._rescc["must-revalidate"];this._resHeaders=Object.assign({},this._resHeaders,{"cache-control":formatCacheControl(this._rescc)});delete this._resHeaders.expires;delete this._resHeaders.pragma}if(res.headers["cache-control"]==null&&/no-cache/.test(res.headers.pragma)){this._rescc["no-cache"]=true}}now(){return Date.now()}storable(){return!!(!this._reqcc["no-store"]&&("GET"===this._method||"HEAD"===this._method||"POST"===this._method&&this._hasExplicitExpiration())&&understoodStatuses.has(this._status)&&!this._rescc["no-store"]&&(!this._isShared||!this._rescc.private)&&(!this._isShared||this._noAuthorization||this._allowsStoringAuthenticated())&&(this._resHeaders.expires||this._rescc["max-age"]||this._isShared&&this._rescc["s-maxage"]||this._rescc.public||statusCodeCacheableByDefault.has(this._status)))}_hasExplicitExpiration(){return this._isShared&&this._rescc["s-maxage"]||this._rescc["max-age"]||this._resHeaders.expires}_assertRequestHasHeaders(req){if(!req||!req.headers){throw Error("Request headers missing")}}satisfiesWithoutRevalidation(req){this._assertRequestHasHeaders(req);const requestCC=parseCacheControl(req.headers["cache-control"]);if(requestCC["no-cache"]||/no-cache/.test(req.headers.pragma)){return false}if(requestCC["max-age"]&&this.age()>requestCC["max-age"]){return false}if(requestCC["min-fresh"]&&this.timeToLive()<1e3*requestCC["min-fresh"]){return false}if(this.stale()){const allowsStale=requestCC["max-stale"]&&!this._rescc["must-revalidate"]&&(true===requestCC["max-stale"]||requestCC["max-stale"]>this.age()-this.maxAge());if(!allowsStale){return false}}return this._requestMatches(req,false)}_requestMatches(req,allowHeadMethod){return(!this._url||this._url===req.url)&&this._host===req.headers.host&&(!req.method||this._method===req.method||allowHeadMethod&&"HEAD"===req.method)&&this._varyMatches(req)}_allowsStoringAuthenticated(){return this._rescc["must-revalidate"]||this._rescc.public||this._rescc["s-maxage"]}_varyMatches(req){if(!this._resHeaders.vary){return true}if(this._resHeaders.vary==="*"){return false}const fields=this._resHeaders.vary.trim().toLowerCase().split(/\s*,\s*/);for(const name of fields){if(req.headers[name]!==this._reqHeaders[name])return false}return true}_copyWithoutHopByHopHeaders(inHeaders){const headers={};for(const name in inHeaders){if(hopByHopHeaders[name])continue;headers[name]=inHeaders[name]}if(inHeaders.connection){const tokens=inHeaders.connection.trim().split(/\s*,\s*/);for(const name of tokens){delete headers[name]}}if(headers.warning){const warnings=headers.warning.split(/,/).filter(warning=>{return!/^\s*1[0-9][0-9]/.test(warning)});if(!warnings.length){delete headers.warning}else{headers.warning=warnings.join(",").trim()}}return headers}responseHeaders(){const headers=this._copyWithoutHopByHopHeaders(this._resHeaders);const age=this.age();if(age>3600*24&&!this._hasExplicitExpiration()&&this.maxAge()>3600*24){headers.warning=(headers.warning?`${headers.warning}, `:"")+'113 - "rfc7234 5.5.4"'}headers.age=`${Math.round(age)}`;headers.date=new Date(this.now()).toUTCString();return headers}date(){const serverDate=Date.parse(this._resHeaders.date);if(isFinite(serverDate)){return serverDate}return this._responseTime}age(){let age=this._ageValue();const residentTime=(this.now()-this._responseTime)/1e3;return age+residentTime}_ageValue(){return toNumberOrZero(this._resHeaders.age)}maxAge(){if(!this.storable()||this._rescc["no-cache"]){return 0}if(this._isShared&&(this._resHeaders["set-cookie"]&&!this._rescc.public&&!this._rescc.immutable)){return 0}if(this._resHeaders.vary==="*"){return 0}if(this._isShared){if(this._rescc["proxy-revalidate"]){return 0}if(this._rescc["s-maxage"]){return toNumberOrZero(this._rescc["s-maxage"])}}if(this._rescc["max-age"]){return toNumberOrZero(this._rescc["max-age"])}const defaultMinTtl=this._rescc.immutable?this._immutableMinTtl:0;const serverDate=this.date();if(this._resHeaders.expires){const expires=Date.parse(this._resHeaders.expires);if(Number.isNaN(expires)||expires<serverDate){return 0}return Math.max(defaultMinTtl,(expires-serverDate)/1e3)}if(this._resHeaders["last-modified"]){const lastModified=Date.parse(this._resHeaders["last-modified"]);if(isFinite(lastModified)&&serverDate>lastModified){return Math.max(defaultMinTtl,(serverDate-lastModified)/1e3*this._cacheHeuristic)}}return defaultMinTtl}timeToLive(){const age=this.maxAge()-this.age();const staleIfErrorAge=age+toNumberOrZero(this._rescc["stale-if-error"]);const staleWhileRevalidateAge=age+toNumberOrZero(this._rescc["stale-while-revalidate"]);return Math.max(0,age,staleIfErrorAge,staleWhileRevalidateAge)*1e3}stale(){return this.maxAge()<=this.age()}_useStaleIfError(){return this.maxAge()+toNumberOrZero(this._rescc["stale-if-error"])>this.age()}useStaleWhileRevalidate(){return this.maxAge()+toNumberOrZero(this._rescc["stale-while-revalidate"])>this.age()}static fromObject(obj){return new this(void 0,void 0,{_fromObject:obj})}_fromObject(obj){if(this._responseTime)throw Error("Reinitialized");if(!obj||obj.v!==1)throw Error("Invalid serialization");this._responseTime=obj.t;this._isShared=obj.sh;this._cacheHeuristic=obj.ch;this._immutableMinTtl=obj.imm!==void 0?obj.imm:24*3600*1e3;this._status=obj.st;this._resHeaders=obj.resh;this._rescc=obj.rescc;this._method=obj.m;this._url=obj.u;this._host=obj.h;this._noAuthorization=obj.a;this._reqHeaders=obj.reqh;this._reqcc=obj.reqcc}toObject(){return{v:1,t:this._responseTime,sh:this._isShared,ch:this._cacheHeuristic,imm:this._immutableMinTtl,st:this._status,resh:this._resHeaders,rescc:this._rescc,m:this._method,u:this._url,h:this._host,a:this._noAuthorization,reqh:this._reqHeaders,reqcc:this._reqcc}}revalidationHeaders(incomingReq){this._assertRequestHasHeaders(incomingReq);const headers=this._copyWithoutHopByHopHeaders(incomingReq.headers);delete headers["if-range"];if(!this._requestMatches(incomingReq,true)||!this.storable()){delete headers["if-none-match"];delete headers["if-modified-since"];return headers}if(this._resHeaders.etag){headers["if-none-match"]=headers["if-none-match"]?`${headers["if-none-match"]}, ${this._resHeaders.etag}`:this._resHeaders.etag}const forbidsWeakValidators=headers["accept-ranges"]||headers["if-match"]||headers["if-unmodified-since"]||this._method&&this._method!="GET";if(forbidsWeakValidators){delete headers["if-modified-since"];if(headers["if-none-match"]){const etags=headers["if-none-match"].split(/,/).filter(etag=>{return!/^\s*W\//.test(etag)});if(!etags.length){delete headers["if-none-match"]}else{headers["if-none-match"]=etags.join(",").trim()}}}else if(this._resHeaders["last-modified"]&&!headers["if-modified-since"]){headers["if-modified-since"]=this._resHeaders["last-modified"]}return headers}revalidatedPolicy(request,response){this._assertRequestHasHeaders(request);if(this._useStaleIfError()&&isErrorResponse(response)){return{modified:false,matches:false,policy:this}}if(!response||!response.headers){throw Error("Response headers missing")}let matches2=false;if(response.status!==void 0&&response.status!=304){matches2=false}else if(response.headers.etag&&!/^\s*W\//.test(response.headers.etag)){matches2=this._resHeaders.etag&&this._resHeaders.etag.replace(/^\s*W\//,"")===response.headers.etag}else if(this._resHeaders.etag&&response.headers.etag){matches2=this._resHeaders.etag.replace(/^\s*W\//,"")===response.headers.etag.replace(/^\s*W\//,"")}else if(this._resHeaders["last-modified"]){matches2=this._resHeaders["last-modified"]===response.headers["last-modified"]}else{if(!this._resHeaders.etag&&!this._resHeaders["last-modified"]&&!response.headers.etag&&!response.headers["last-modified"]){matches2=true}}if(!matches2){return{policy:new this.constructor(request,response),modified:response.status!=304,matches:false}}const headers={};for(const k in this._resHeaders){headers[k]=k in response.headers&&!excludedFromRevalidationUpdate[k]?response.headers[k]:this._resHeaders[k]}const newResponse=Object.assign({},response,{status:this._status,method:this._method,headers});return{policy:new this.constructor(request,newResponse,{shared:this._isShared,cacheHeuristic:this._cacheHeuristic,immutableMinTimeToLive:this._immutableMinTtl}),modified:false,matches:true}}}}});var require_json_buffer=__commonJS({"node_modules/json-buffer/index.js"(exports2){exports2.stringify=function stringify(o){if("undefined"==typeof o)return o;if(o&&Buffer.isBuffer(o))return JSON.stringify(":base64:"+o.toString("base64"));if(o&&o.toJSON)o=o.toJSON();if(o&&"object"===typeof o){var s="";var array=Array.isArray(o);s=array?"[":"{";var first=true;for(var k in o){var ignore="function"==typeof o[k]||!array&&"undefined"===typeof o[k];if(Object.hasOwnProperty.call(o,k)&&!ignore){if(!first)s+=",";first=false;if(array){if(o[k]==void 0)s+="null";else s+=stringify(o[k])}else if(o[k]!==void 0){s+=stringify(k)+":"+stringify(o[k])}}}s+=array?"]":"}";return s}else if("string"===typeof o){return JSON.stringify(/^:/.test(o)?":"+o:o)}else if("undefined"===typeof o){return"null"}else return JSON.stringify(o)};exports2.parse=function(s){return JSON.parse(s,function(key,value){if("string"===typeof value){if(/^:base64:/.test(value))return Buffer.from(value.substring(8),"base64");else return/^:/.test(value)?value.substring(1):value}return value})}}});var require_src=__commonJS({"node_modules/keyv/src/index.js"(exports2,module2){"use strict";var EventEmitter3=require("events");var JSONB=require_json_buffer();var loadStore=options=>{const adapters={redis:"@keyv/redis",rediss:"@keyv/redis",mongodb:"@keyv/mongo",mongo:"@keyv/mongo",sqlite:"@keyv/sqlite",postgresql:"@keyv/postgres",postgres:"@keyv/postgres",mysql:"@keyv/mysql",etcd:"@keyv/etcd",offline:"@keyv/offline",tiered:"@keyv/tiered"};if(options.adapter||options.uri){const adapter=options.adapter||/^[^:+]*/.exec(options.uri)[0];return new(require(adapters[adapter]))(options)}return new Map};var iterableAdapters=["sqlite","postgres","mysql","mongo","redis","tiered"];var Keyv2=class extends EventEmitter3{constructor(uri,{emitErrors=true,...options}={}){super();this.opts={namespace:"keyv",serialize:JSONB.stringify,deserialize:JSONB.parse,...typeof uri==="string"?{uri}:uri,...options};if(!this.opts.store){const adapterOptions={...this.opts};this.opts.store=loadStore(adapterOptions)}if(this.opts.compression){const compression=this.opts.compression;this.opts.serialize=compression.serialize.bind(compression);this.opts.deserialize=compression.deserialize.bind(compression)}if(typeof this.opts.store.on==="function"&&emitErrors){this.opts.store.on("error",error=>this.emit("error",error))}this.opts.store.namespace=this.opts.namespace;const generateIterator=iterator=>async function*(){for await(const[key,raw]of typeof iterator==="function"?iterator(this.opts.store.namespace):iterator){const data=await this.opts.deserialize(raw);if(this.opts.store.namespace&&!key.includes(this.opts.store.namespace)){continue}if(typeof data.expires==="number"&&Date.now()>data.expires){this.delete(key);continue}yield[this._getKeyUnprefix(key),data.value]}};if(typeof this.opts.store[Symbol.iterator]==="function"&&this.opts.store instanceof Map){this.iterator=generateIterator(this.opts.store)}else if(typeof this.opts.store.iterator==="function"&&this.opts.store.opts&&this._checkIterableAdaptar()){this.iterator=generateIterator(this.opts.store.iterator.bind(this.opts.store))}}_checkIterableAdaptar(){return iterableAdapters.includes(this.opts.store.opts.dialect)||iterableAdapters.findIndex(element=>this.opts.store.opts.url.includes(element))>=0}_getKeyPrefix(key){return`${this.opts.namespace}:${key}`}_getKeyPrefixArray(keys2){return keys2.map(key=>`${this.opts.namespace}:${key}`)}_getKeyUnprefix(key){return key.split(":").splice(1).join(":")}get(key,options){const{store}=this.opts;const isArray3=Array.isArray(key);const keyPrefixed=isArray3?this._getKeyPrefixArray(key):this._getKeyPrefix(key);if(isArray3&&store.getMany===void 0){const promises=[];for(const key2 of keyPrefixed){promises.push(Promise.resolve().then(()=>store.get(key2)).then(data=>typeof data==="string"?this.opts.deserialize(data):this.opts.compression?this.opts.deserialize(data):data).then(data=>{if(data===void 0||data===null){return void 0}if(typeof data.expires==="number"&&Date.now()>data.expires){return this.delete(key2).then(()=>void 0)}return options&&options.raw?data:data.value}))}return Promise.allSettled(promises).then(values2=>{const data=[];for(const value of values2){data.push(value.value)}return data})}return Promise.resolve().then(()=>isArray3?store.getMany(keyPrefixed):store.get(keyPrefixed)).then(data=>typeof data==="string"?this.opts.deserialize(data):this.opts.compression?this.opts.deserialize(data):data).then(data=>{if(data===void 0||data===null){return void 0}if(isArray3){return data.map((row,index)=>{if(typeof row==="string"){row=this.opts.deserialize(row)}if(row===void 0||row===null){return void 0}if(typeof row.expires==="number"&&Date.now()>row.expires){this.delete(key[index]).then(()=>void 0);return void 0}return options&&options.raw?row:row.value})}if(typeof data.expires==="number"&&Date.now()>data.expires){return this.delete(key).then(()=>void 0)}return options&&options.raw?data:data.value})}set(key,value,ttl2){const keyPrefixed=this._getKeyPrefix(key);if(typeof ttl2==="undefined"){ttl2=this.opts.ttl}if(ttl2===0){ttl2=void 0}const{store}=this.opts;return Promise.resolve().then(()=>{const expires=typeof ttl2==="number"?Date.now()+ttl2:null;if(typeof value==="symbol"){this.emit("error","symbol cannot be serialized")}value={value,expires};return this.opts.serialize(value)}).then(value2=>store.set(keyPrefixed,value2,ttl2)).then(()=>true)}delete(key){const{store}=this.opts;if(Array.isArray(key)){const keyPrefixed2=this._getKeyPrefixArray(key);if(store.deleteMany===void 0){const promises=[];for(const key2 of keyPrefixed2){promises.push(store.delete(key2))}return Promise.allSettled(promises).then(values2=>values2.every(x=>x.value===true))}return Promise.resolve().then(()=>store.deleteMany(keyPrefixed2))}const keyPrefixed=this._getKeyPrefix(key);return Promise.resolve().then(()=>store.delete(keyPrefixed))}clear(){const{store}=this.opts;return Promise.resolve().then(()=>store.clear())}has(key){const keyPrefixed=this._getKeyPrefix(key);const{store}=this.opts;return Promise.resolve().then(async()=>{if(typeof store.has==="function"){return store.has(keyPrefixed)}const value=await store.get(keyPrefixed);return value!==void 0})}disconnect(){const{store}=this.opts;if(typeof store.disconnect==="function"){return store.disconnect()}}};module2.exports=Keyv2}});var require_mimic_response=__commonJS({"node_modules/decompress-response/node_modules/mimic-response/index.js"(exports2,module2){"use strict";var knownProperties2=["aborted","complete","headers","httpVersion","httpVersionMinor","httpVersionMajor","method","rawHeaders","rawTrailers","setTimeout","socket","statusCode","statusMessage","trailers","url"];module2.exports=(fromStream2,toStream)=>{if(toStream._readableState.autoDestroy){throw new Error("The second stream must have the `autoDestroy` option set to `false`")}const fromProperties=new Set(Object.keys(fromStream2).concat(knownProperties2));const properties={};for(const property2 of fromProperties){if(property2 in toStream){continue}properties[property2]={get(){const value=fromStream2[property2];const isFunction3=typeof value==="function";return isFunction3?value.bind(fromStream2):value},set(value){fromStream2[property2]=value},enumerable:true,configurable:false}}Object.defineProperties(toStream,properties);fromStream2.once("aborted",()=>{toStream.destroy();toStream.emit("aborted")});fromStream2.once("close",()=>{if(fromStream2.complete){if(toStream.readable){toStream.once("end",()=>{toStream.emit("close")})}else{toStream.emit("close")}}else{toStream.emit("close")}});return toStream}}});var require_decompress_response=__commonJS({"node_modules/decompress-response/index.js"(exports2,module2){"use strict";var{Transform,PassThrough}=require("stream");var zlib2=require("zlib");var mimicResponse2=require_mimic_response();module2.exports=response=>{const contentEncoding=(response.headers["content-encoding"]||"").toLowerCase();if(!["gzip","deflate","br"].includes(contentEncoding)){return response}const isBrotli=contentEncoding==="br";if(isBrotli&&typeof zlib2.createBrotliDecompress!=="function"){response.destroy(new Error("Brotli is not supported on Node.js < 12"));return response}let isEmpty2=true;const checker=new Transform({transform(data,_encoding,callback){isEmpty2=false;callback(null,data)},flush(callback){callback()}});const finalStream=new PassThrough({autoDestroy:false,destroy(error,callback){response.destroy();callback(error)}});const decompressStream=isBrotli?zlib2.createBrotliDecompress():zlib2.createUnzip();decompressStream.once("error",error=>{if(isEmpty2&&!response.readable){finalStream.end();return}finalStream.destroy(error)});mimicResponse2(response,finalStream);response.pipe(checker).pipe(decompressStream).pipe(finalStream);return finalStream}}});var require_quick_lru=__commonJS({"node_modules/quick-lru/index.js"(exports2,module2){"use strict";var QuickLRU=class{constructor(options={}){if(!(options.maxSize&&options.maxSize>0)){throw new TypeError("`maxSize` must be a number greater than 0")}this.maxSize=options.maxSize;this.onEviction=options.onEviction;this.cache=new Map;this.oldCache=new Map;this._size=0}_set(key,value){this.cache.set(key,value);this._size++;if(this._size>=this.maxSize){this._size=0;if(typeof this.onEviction==="function"){for(const[key2,value2]of this.oldCache.entries()){this.onEviction(key2,value2)}}this.oldCache=this.cache;this.cache=new Map}}get(key){if(this.cache.has(key)){return this.cache.get(key)}if(this.oldCache.has(key)){const value=this.oldCache.get(key);this.oldCache.delete(key);this._set(key,value);return value}}set(key,value){if(this.cache.has(key)){this.cache.set(key,value)}else{this._set(key,value)}return this}has(key){return this.cache.has(key)||this.oldCache.has(key)}peek(key){if(this.cache.has(key)){return this.cache.get(key)}if(this.oldCache.has(key)){return this.oldCache.get(key)}}delete(key){const deleted=this.cache.delete(key);if(deleted){this._size--}return this.oldCache.delete(key)||deleted}clear(){this.cache.clear();this.oldCache.clear();this._size=0}*keys(){for(const[key]of this){yield key}}*values(){for(const[,value]of this){yield value}}*[Symbol.iterator](){for(const item of this.cache){yield item}for(const item of this.oldCache){const[key]=item;if(!this.cache.has(key)){yield item}}}get size(){let oldCacheSize=0;for(const key of this.oldCache.keys()){if(!this.cache.has(key)){oldCacheSize++}}return Math.min(this._size+oldCacheSize,this.maxSize)}};module2.exports=QuickLRU}});var require_delay_async_destroy=__commonJS({"node_modules/http2-wrapper/source/utils/delay-async-destroy.js"(exports2,module2){"use strict";module2.exports=stream3=>{if(stream3.listenerCount("error")!==0){return stream3}stream3.__destroy=stream3._destroy;stream3._destroy=(...args2)=>{const callback=args2.pop();stream3.__destroy(...args2,async error=>{await Promise.resolve();callback(error)})};const onError=error=>{Promise.resolve().then(()=>{stream3.emit("error",error)})};stream3.once("error",onError);Promise.resolve().then(()=>{stream3.off("error",onError)});return stream3}}});var require_agent=__commonJS({"node_modules/http2-wrapper/source/agent.js"(exports2,module2){"use strict";var{URL:URL3}=require("url");var EventEmitter3=require("events");var tls=require("tls");var http22=require("http2");var QuickLRU=require_quick_lru();var delayAsyncDestroy=require_delay_async_destroy();var kCurrentStreamCount=Symbol("currentStreamCount");var kRequest=Symbol("request");var kOriginSet=Symbol("cachedOriginSet");var kGracefullyClosing=Symbol("gracefullyClosing");var kLength=Symbol("length");var nameKeys=["createConnection","maxDeflateDynamicTableSize","maxSettings","maxSessionMemory","maxHeaderListPairs","maxOutstandingPings","maxReservedRemoteStreams","maxSendHeaderBlockLength","paddingStrategy","peerMaxConcurrentStreams","settings","family","localAddress","rejectUnauthorized","pskCallback","minDHSize","path","socket","ca","cert","sigalgs","ciphers","clientCertEngine","crl","dhparam","ecdhCurve","honorCipherOrder","key","privateKeyEngine","privateKeyIdentifier","maxVersion","minVersion","pfx","secureOptions","secureProtocol","sessionIdContext","ticketKeys"];var getSortedIndex=(array,value,compare)=>{let low=0;let high=array.length;while(low<high){const mid=low+high>>>1;if(compare(array[mid],value)){low=mid+1}else{high=mid}}return low};var compareSessions=(a,b)=>a.remoteSettings.maxConcurrentStreams>b.remoteSettings.maxConcurrentStreams;var closeCoveredSessions=(where,session)=>{for(let index=0;index<where.length;index++){const coveredSession=where[index];if(coveredSession[kOriginSet].length>0&&coveredSession[kOriginSet].length<session[kOriginSet].length&&coveredSession[kOriginSet].every(origin=>session[kOriginSet].includes(origin))&&coveredSession[kCurrentStreamCount]+session[kCurrentStreamCount]<=session.remoteSettings.maxConcurrentStreams){gracefullyClose(coveredSession)}}};var closeSessionIfCovered=(where,coveredSession)=>{for(let index=0;index<where.length;index++){const session=where[index];if(coveredSession[kOriginSet].length>0&&coveredSession[kOriginSet].length<session[kOriginSet].length&&coveredSession[kOriginSet].every(origin=>session[kOriginSet].includes(origin))&&coveredSession[kCurrentStreamCount]+session[kCurrentStreamCount]<=session.remoteSettings.maxConcurrentStreams){gracefullyClose(coveredSession);return true}}return false};var gracefullyClose=session=>{session[kGracefullyClosing]=true;if(session[kCurrentStreamCount]===0){session.close()}};var Agent=class _Agent extends EventEmitter3{constructor({timeout=0,maxSessions=Number.POSITIVE_INFINITY,maxEmptySessions=10,maxCachedTlsSessions=100}={}){super();this.sessions={};this.queue={};this.timeout=timeout;this.maxSessions=maxSessions;this.maxEmptySessions=maxEmptySessions;this._emptySessionCount=0;this._sessionCount=0;this.settings={enablePush:false,initialWindowSize:1024*1024*32};this.tlsSessionCache=new QuickLRU({maxSize:maxCachedTlsSessions})}get protocol(){return"https:"}normalizeOptions(options){let normalized="";for(let index=0;index<nameKeys.length;index++){const key=nameKeys[index];normalized+=":";if(options&&options[key]!==void 0){normalized+=options[key]}}return normalized}_processQueue(){if(this._sessionCount>=this.maxSessions){this.closeEmptySessions(this.maxSessions-this._sessionCount+1);return}for(const normalizedOptions in this.queue){for(const normalizedOrigin in this.queue[normalizedOptions]){const item=this.queue[normalizedOptions][normalizedOrigin];if(!item.completed){item.completed=true;item()}}}}_isBetterSession(thisStreamCount,thatStreamCount){return thisStreamCount>thatStreamCount}_accept(session,listeners,normalizedOrigin,options){let index=0;while(index<listeners.length&&session[kCurrentStreamCount]<session.remoteSettings.maxConcurrentStreams){listeners[index].resolve(session);index++}listeners.splice(0,index);if(listeners.length>0){this.getSession(normalizedOrigin,options,listeners);listeners.length=0}}getSession(origin,options,listeners){return new Promise((resolve,reject2)=>{if(Array.isArray(listeners)&&listeners.length>0){listeners=[...listeners];resolve()}else{listeners=[{resolve,reject:reject2}]}try{if(typeof origin==="string"){origin=new URL3(origin)}else if(!(origin instanceof URL3)){throw new TypeError("The `origin` argument needs to be a string or an URL object")}if(options){const{servername}=options;const{hostname}=origin;if(servername&&hostname!==servername){throw new Error(`Origin ${hostname} differs from servername ${servername}`)}}}catch(error){for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}return}const normalizedOptions=this.normalizeOptions(options);const normalizedOrigin=origin.origin;if(normalizedOptions in this.sessions){const sessions=this.sessions[normalizedOptions];let maxConcurrentStreams=-1;let currentStreamsCount=-1;let optimalSession;for(let index=0;index<sessions.length;index++){const session=sessions[index];const sessionMaxConcurrentStreams=session.remoteSettings.maxConcurrentStreams;if(sessionMaxConcurrentStreams<maxConcurrentStreams){break}if(!session[kOriginSet].includes(normalizedOrigin)){continue}const sessionCurrentStreamsCount=session[kCurrentStreamCount];if(sessionCurrentStreamsCount>=sessionMaxConcurrentStreams||session[kGracefullyClosing]||session.destroyed){continue}if(!optimalSession){maxConcurrentStreams=sessionMaxConcurrentStreams}if(this._isBetterSession(sessionCurrentStreamsCount,currentStreamsCount)){optimalSession=session;currentStreamsCount=sessionCurrentStreamsCount}}if(optimalSession){this._accept(optimalSession,listeners,normalizedOrigin,options);return}}if(normalizedOptions in this.queue){if(normalizedOrigin in this.queue[normalizedOptions]){this.queue[normalizedOptions][normalizedOrigin].listeners.push(...listeners);return}}else{this.queue[normalizedOptions]={[kLength]:0}}const removeFromQueue=()=>{if(normalizedOptions in this.queue&&this.queue[normalizedOptions][normalizedOrigin]===entry){delete this.queue[normalizedOptions][normalizedOrigin];if(--this.queue[normalizedOptions][kLength]===0){delete this.queue[normalizedOptions]}}};const entry=async()=>{this._sessionCount++;const name=`${normalizedOrigin}:${normalizedOptions}`;let receivedSettings=false;let socket;try{const computedOptions={...options};if(computedOptions.settings===void 0){computedOptions.settings=this.settings}if(computedOptions.session===void 0){computedOptions.session=this.tlsSessionCache.get(name)}const createConnection=computedOptions.createConnection||this.createConnection;socket=await createConnection.call(this,origin,computedOptions);computedOptions.createConnection=()=>socket;const session=http22.connect(origin,computedOptions);session[kCurrentStreamCount]=0;session[kGracefullyClosing]=false;const getOriginSet=()=>{const{socket:socket2}=session;let originSet;if(socket2.servername===false){socket2.servername=socket2.remoteAddress;originSet=session.originSet;socket2.servername=false}else{originSet=session.originSet}return originSet};const isFree=()=>session[kCurrentStreamCount]<session.remoteSettings.maxConcurrentStreams;session.socket.once("session",tlsSession=>{this.tlsSessionCache.set(name,tlsSession)});session.once("error",error=>{for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}this.tlsSessionCache.delete(name)});session.setTimeout(this.timeout,()=>{session.destroy()});session.once("close",()=>{this._sessionCount--;if(receivedSettings){this._emptySessionCount--;const where=this.sessions[normalizedOptions];if(where.length===1){delete this.sessions[normalizedOptions]}else{where.splice(where.indexOf(session),1)}}else{removeFromQueue();const error=new Error("Session closed without receiving a SETTINGS frame");error.code="HTTP2WRAPPER_NOSETTINGS";for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}}this._processQueue()});const processListeners=()=>{const queue=this.queue[normalizedOptions];if(!queue){return}const originSet=session[kOriginSet];for(let index=0;index<originSet.length;index++){const origin2=originSet[index];if(origin2 in queue){const{listeners:listeners2,completed}=queue[origin2];let index2=0;while(index2<listeners2.length&&isFree()){listeners2[index2].resolve(session);index2++}queue[origin2].listeners.splice(0,index2);if(queue[origin2].listeners.length===0&&!completed){delete queue[origin2];if(--queue[kLength]===0){delete this.queue[normalizedOptions];break}}if(!isFree()){break}}}};session.on("origin",()=>{session[kOriginSet]=getOriginSet()||[];session[kGracefullyClosing]=false;closeSessionIfCovered(this.sessions[normalizedOptions],session);if(session[kGracefullyClosing]||!isFree()){return}processListeners();if(!isFree()){return}closeCoveredSessions(this.sessions[normalizedOptions],session)});session.once("remoteSettings",()=>{if(entry.destroyed){const error=new Error("Agent has been destroyed");for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}session.destroy();return}if(session.setLocalWindowSize){session.setLocalWindowSize(1024*1024*4)}session[kOriginSet]=getOriginSet()||[];if(session.socket.encrypted){const mainOrigin=session[kOriginSet][0];if(mainOrigin!==normalizedOrigin){const error=new Error(`Requested origin ${normalizedOrigin} does not match server ${mainOrigin}`);for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}session.destroy();return}}removeFromQueue();{const where=this.sessions;if(normalizedOptions in where){const sessions=where[normalizedOptions];sessions.splice(getSortedIndex(sessions,session,compareSessions),0,session)}else{where[normalizedOptions]=[session]}}receivedSettings=true;this._emptySessionCount++;this.emit("session",session);this._accept(session,listeners,normalizedOrigin,options);if(session[kCurrentStreamCount]===0&&this._emptySessionCount>this.maxEmptySessions){this.closeEmptySessions(this._emptySessionCount-this.maxEmptySessions)}session.on("remoteSettings",()=>{if(!isFree()){return}processListeners();if(!isFree()){return}closeCoveredSessions(this.sessions[normalizedOptions],session)})});session[kRequest]=session.request;session.request=(headers,streamOptions)=>{if(session[kGracefullyClosing]){throw new Error("The session is gracefully closing. No new streams are allowed.")}const stream3=session[kRequest](headers,streamOptions);session.ref();if(session[kCurrentStreamCount]++===0){this._emptySessionCount--}stream3.once("close",()=>{if(--session[kCurrentStreamCount]===0){this._emptySessionCount++;session.unref();if(this._emptySessionCount>this.maxEmptySessions||session[kGracefullyClosing]){session.close();return}}if(session.destroyed||session.closed){return}if(isFree()&&!closeSessionIfCovered(this.sessions[normalizedOptions],session)){closeCoveredSessions(this.sessions[normalizedOptions],session);processListeners();if(session[kCurrentStreamCount]===0){this._processQueue()}}});return stream3}}catch(error){removeFromQueue();this._sessionCount--;for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}}};entry.listeners=listeners;entry.completed=false;entry.destroyed=false;this.queue[normalizedOptions][normalizedOrigin]=entry;this.queue[normalizedOptions][kLength]++;this._processQueue()})}request(origin,options,headers,streamOptions){return new Promise((resolve,reject2)=>{this.getSession(origin,options,[{reject:reject2,resolve:session=>{try{const stream3=session.request(headers,streamOptions);delayAsyncDestroy(stream3);resolve(stream3)}catch(error){reject2(error)}}}])})}async createConnection(origin,options){return _Agent.connect(origin,options)}static connect(origin,options){options.ALPNProtocols=["h2"];const port=origin.port||443;const host=origin.hostname;if(typeof options.servername==="undefined"){options.servername=host}const socket=tls.connect(port,host,options);if(options.socket){socket._peername={family:void 0,address:void 0,port}}return socket}closeEmptySessions(maxCount=Number.POSITIVE_INFINITY){let closedCount=0;const{sessions}=this;for(const key in sessions){const thisSessions=sessions[key];for(let index=0;index<thisSessions.length;index++){const session=thisSessions[index];if(session[kCurrentStreamCount]===0){closedCount++;session.close();if(closedCount>=maxCount){return closedCount}}}}return closedCount}destroy(reason){const{sessions,queue}=this;for(const key in sessions){const thisSessions=sessions[key];for(let index=0;index<thisSessions.length;index++){thisSessions[index].destroy(reason)}}for(const normalizedOptions in queue){const entries2=queue[normalizedOptions];for(const normalizedOrigin in entries2){entries2[normalizedOrigin].destroyed=true}}this.queue={};this.tlsSessionCache.clear()}get emptySessionCount(){return this._emptySessionCount}get pendingSessionCount(){return this._sessionCount-this._emptySessionCount}get sessionCount(){return this._sessionCount}};Agent.kCurrentStreamCount=kCurrentStreamCount;Agent.kGracefullyClosing=kGracefullyClosing;module2.exports={Agent,globalAgent:new Agent}}});var require_incoming_message=__commonJS({"node_modules/http2-wrapper/source/incoming-message.js"(exports2,module2){"use strict";var{Readable:Readable2}=require("stream");var IncomingMessage=class extends Readable2{constructor(socket,highWaterMark){super({emitClose:false,autoDestroy:true,highWaterMark});this.statusCode=null;this.statusMessage="";this.httpVersion="2.0";this.httpVersionMajor=2;this.httpVersionMinor=0;this.headers={};this.trailers={};this.req=null;this.aborted=false;this.complete=false;this.upgrade=null;this.rawHeaders=[];this.rawTrailers=[];this.socket=socket;this._dumped=false}get connection(){return this.socket}set connection(value){this.socket=value}_destroy(error,callback){if(!this.readableEnded){this.aborted=true}callback();this.req._request.destroy(error)}setTimeout(ms,callback){this.req.setTimeout(ms,callback);return this}_dump(){if(!this._dumped){this._dumped=true;this.removeAllListeners("data");this.resume()}}_read(){if(this.req){this.req._request.resume()}}};module2.exports=IncomingMessage}});var require_proxy_events=__commonJS({"node_modules/http2-wrapper/source/utils/proxy-events.js"(exports2,module2){"use strict";module2.exports=(from,to,events)=>{for(const event of events){from.on(event,(...args2)=>to.emit(event,...args2))}}}});var require_errors=__commonJS({"node_modules/http2-wrapper/source/utils/errors.js"(exports2,module2){"use strict";var makeError=(Base,key,getMessage)=>{module2.exports[key]=class NodeError extends Base{constructor(...args2){super(typeof getMessage==="string"?getMessage:getMessage(args2));this.name=`${super.name} [${key}]`;this.code=key}}};makeError(TypeError,"ERR_INVALID_ARG_TYPE",args2=>{const type2=args2[0].includes(".")?"property":"argument";let valid=args2[1];const isManyTypes=Array.isArray(valid);if(isManyTypes){valid=`${valid.slice(0,-1).join(", ")} or ${valid.slice(-1)}`}return`The "${args2[0]}" ${type2} must be ${isManyTypes?"one of":"of"} type ${valid}. Received ${typeof args2[2]}`});makeError(TypeError,"ERR_INVALID_PROTOCOL",args2=>`Protocol "${args2[0]}" not supported. Expected "${args2[1]}"`);makeError(Error,"ERR_HTTP_HEADERS_SENT",args2=>`Cannot ${args2[0]} headers after they are sent to the client`);makeError(TypeError,"ERR_INVALID_HTTP_TOKEN",args2=>`${args2[0]} must be a valid HTTP token [${args2[1]}]`);makeError(TypeError,"ERR_HTTP_INVALID_HEADER_VALUE",args2=>`Invalid value "${args2[0]} for header "${args2[1]}"`);makeError(TypeError,"ERR_INVALID_CHAR",args2=>`Invalid character in ${args2[0]} [${args2[1]}]`);makeError(Error,"ERR_HTTP2_NO_SOCKET_MANIPULATION","HTTP/2 sockets should not be directly manipulated (e.g. read and written)")}});var require_is_request_pseudo_header=__commonJS({"node_modules/http2-wrapper/source/utils/is-request-pseudo-header.js"(exports2,module2){"use strict";module2.exports=header2=>{switch(header2){case":method":case":scheme":case":authority":case":path":return true;default:return false}}}});var require_validate_header_name=__commonJS({"node_modules/http2-wrapper/source/utils/validate-header-name.js"(exports2,module2){"use strict";var{ERR_INVALID_HTTP_TOKEN}=require_errors();var isRequestPseudoHeader=require_is_request_pseudo_header();var isValidHttpToken=/^[\^`\-\w!#$%&*+.|~]+$/;module2.exports=name=>{if(typeof name!=="string"||!isValidHttpToken.test(name)&&!isRequestPseudoHeader(name)){throw new ERR_INVALID_HTTP_TOKEN("Header name",name)}}}});var require_validate_header_value=__commonJS({"node_modules/http2-wrapper/source/utils/validate-header-value.js"(exports2,module2){"use strict";var{ERR_HTTP_INVALID_HEADER_VALUE,ERR_INVALID_CHAR}=require_errors();var isInvalidHeaderValue=/[^\t\u0020-\u007E\u0080-\u00FF]/;module2.exports=(name,value)=>{if(typeof value==="undefined"){throw new ERR_HTTP_INVALID_HEADER_VALUE(value,name)}if(isInvalidHeaderValue.test(value)){throw new ERR_INVALID_CHAR("header content",name)}}}});var require_proxy_socket_handler=__commonJS({"node_modules/http2-wrapper/source/utils/proxy-socket-handler.js"(exports2,module2){"use strict";var{ERR_HTTP2_NO_SOCKET_MANIPULATION}=require_errors();var proxySocketHandler={has(stream3,property2){const reference=stream3.session===void 0?stream3:stream3.session.socket;return property2 in stream3||property2 in reference},get(stream3,property2){switch(property2){case"on":case"once":case"end":case"emit":case"destroy":return stream3[property2].bind(stream3);case"writable":case"destroyed":return stream3[property2];case"readable":if(stream3.destroyed){return false}return stream3.readable;case"setTimeout":{const{session}=stream3;if(session!==void 0){return session.setTimeout.bind(session)}return stream3.setTimeout.bind(stream3)}case"write":case"read":case"pause":case"resume":throw new ERR_HTTP2_NO_SOCKET_MANIPULATION;default:{const reference=stream3.session===void 0?stream3:stream3.session.socket;const value=reference[property2];return typeof value==="function"?value.bind(reference):value}}},getPrototypeOf(stream3){if(stream3.session!==void 0){return Reflect.getPrototypeOf(stream3.session.socket)}return Reflect.getPrototypeOf(stream3)},set(stream3,property2,value){switch(property2){case"writable":case"readable":case"destroyed":case"on":case"once":case"end":case"emit":case"destroy":stream3[property2]=value;return true;case"setTimeout":{const{session}=stream3;if(session===void 0){stream3.setTimeout=value}else{session.setTimeout=value}return true}case"write":case"read":case"pause":case"resume":throw new ERR_HTTP2_NO_SOCKET_MANIPULATION;default:{const reference=stream3.session===void 0?stream3:stream3.session.socket;reference[property2]=value;return true}}}};module2.exports=proxySocketHandler}});var require_client_request=__commonJS({"node_modules/http2-wrapper/source/client-request.js"(exports2,module2){"use strict";var{URL:URL3,urlToHttpOptions}=require("url");var http22=require("http2");var{Writable:Writable4}=require("stream");var{Agent,globalAgent}=require_agent();var IncomingMessage=require_incoming_message();var proxyEvents2=require_proxy_events();var{ERR_INVALID_ARG_TYPE,ERR_INVALID_PROTOCOL,ERR_HTTP_HEADERS_SENT}=require_errors();var validateHeaderName=require_validate_header_name();var validateHeaderValue=require_validate_header_value();var proxySocketHandler=require_proxy_socket_handler();var{HTTP2_HEADER_STATUS,HTTP2_HEADER_METHOD,HTTP2_HEADER_PATH,HTTP2_HEADER_AUTHORITY,HTTP2_METHOD_CONNECT}=http22.constants;var kHeaders=Symbol("headers");var kOrigin=Symbol("origin");var kSession=Symbol("session");var kOptions=Symbol("options");var kFlushedHeaders=Symbol("flushedHeaders");var kJobs=Symbol("jobs");var kPendingAgentPromise=Symbol("pendingAgentPromise");var ClientRequest=class extends Writable4{constructor(input,options,callback){super({autoDestroy:false,emitClose:false});if(typeof input==="string"){input=urlToHttpOptions(new URL3(input))}else if(input instanceof URL3){input=urlToHttpOptions(input)}else{input={...input}}if(typeof options==="function"||options===void 0){callback=options;options=input}else{options=Object.assign(input,options)}if(options.h2session){this[kSession]=options.h2session;if(this[kSession].destroyed){throw new Error("The session has been closed already")}this.protocol=this[kSession].socket.encrypted?"https:":"http:"}else if(options.agent===false){this.agent=new Agent({maxEmptySessions:0})}else if(typeof options.agent==="undefined"||options.agent===null){this.agent=globalAgent}else if(typeof options.agent.request==="function"){this.agent=options.agent}else{throw new ERR_INVALID_ARG_TYPE("options.agent",["http2wrapper.Agent-like Object","undefined","false"],options.agent)}if(this.agent){this.protocol=this.agent.protocol}if(options.protocol&&options.protocol!==this.protocol){throw new ERR_INVALID_PROTOCOL(options.protocol,this.protocol)}if(!options.port){options.port=options.defaultPort||this.agent&&this.agent.defaultPort||443}options.host=options.hostname||options.host||"localhost";delete options.hostname;const{timeout}=options;options.timeout=void 0;this[kHeaders]=Object.create(null);this[kJobs]=[];this[kPendingAgentPromise]=void 0;this.socket=null;this.connection=null;this.method=options.method||"GET";if(!(this.method==="CONNECT"&&(options.path==="/"||options.path===void 0))){this.path=options.path}this.res=null;this.aborted=false;this.reusedSocket=false;const{headers}=options;if(headers){for(const header2 in headers){this.setHeader(header2,headers[header2])}}if(options.auth&&!("authorization"in this[kHeaders])){this[kHeaders].authorization="Basic "+Buffer.from(options.auth).toString("base64")}options.session=options.tlsSession;options.path=options.socketPath;this[kOptions]=options;this[kOrigin]=new URL3(`${this.protocol}//${options.servername||options.host}:${options.port}`);const reuseSocket=options._reuseSocket;if(reuseSocket){options.createConnection=(...args2)=>{if(reuseSocket.destroyed){return this.agent.createConnection(...args2)}return reuseSocket};this.agent.getSession(this[kOrigin],this[kOptions]).catch(()=>{})}if(timeout){this.setTimeout(timeout)}if(callback){this.once("response",callback)}this[kFlushedHeaders]=false}get method(){return this[kHeaders][HTTP2_HEADER_METHOD]}set method(value){if(value){this[kHeaders][HTTP2_HEADER_METHOD]=value.toUpperCase()}}get path(){const header2=this.method==="CONNECT"?HTTP2_HEADER_AUTHORITY:HTTP2_HEADER_PATH;return this[kHeaders][header2]}set path(value){if(value){const header2=this.method==="CONNECT"?HTTP2_HEADER_AUTHORITY:HTTP2_HEADER_PATH;this[kHeaders][header2]=value}}get host(){return this[kOrigin].hostname}set host(_value){}get _mustNotHaveABody(){return this.method==="GET"||this.method==="HEAD"||this.method==="DELETE"}_write(chunk2,encoding,callback){if(this._mustNotHaveABody){callback(new Error("The GET, HEAD and DELETE methods must NOT have a body"));return}this.flushHeaders();const callWrite=()=>this._request.write(chunk2,encoding,callback);if(this._request){callWrite()}else{this[kJobs].push(callWrite)}}_final(callback){this.flushHeaders();const callEnd=()=>{if(this._mustNotHaveABody||this.method==="CONNECT"){callback();return}this._request.end(callback)};if(this._request){callEnd()}else{this[kJobs].push(callEnd)}}abort(){if(this.res&&this.res.complete){return}if(!this.aborted){process.nextTick(()=>this.emit("abort"))}this.aborted=true;this.destroy()}async _destroy(error,callback){if(this.res){this.res._dump()}if(this._request){this._request.destroy()}else{process.nextTick(()=>{this.emit("close")})}try{await this[kPendingAgentPromise]}catch(internalError){if(this.aborted){error=internalError}}callback(error)}async flushHeaders(){if(this[kFlushedHeaders]||this.destroyed){return}this[kFlushedHeaders]=true;const isConnectMethod=this.method===HTTP2_METHOD_CONNECT;const onStream=stream3=>{this._request=stream3;if(this.destroyed){stream3.destroy();return}if(!isConnectMethod){proxyEvents2(stream3,this,["timeout","continue"])}stream3.once("error",error=>{this.destroy(error)});stream3.once("aborted",()=>{const{res}=this;if(res){res.aborted=true;res.emit("aborted");res.destroy()}else{this.destroy(new Error("The server aborted the HTTP/2 stream"))}});const onResponse=(headers,flags,rawHeaders)=>{const response=new IncomingMessage(this.socket,stream3.readableHighWaterMark);this.res=response;response.url=`${this[kOrigin].origin}${this.path}`;response.req=this;response.statusCode=headers[HTTP2_HEADER_STATUS];response.headers=headers;response.rawHeaders=rawHeaders;response.once("end",()=>{response.complete=true;response.socket=null;response.connection=null});if(isConnectMethod){response.upgrade=true;if(this.emit("connect",response,stream3,Buffer.alloc(0))){this.emit("close")}else{stream3.destroy()}}else{stream3.on("data",chunk2=>{if(!response._dumped&&!response.push(chunk2)){stream3.pause()}});stream3.once("end",()=>{if(!this.aborted){response.push(null)}});if(!this.emit("response",response)){response._dump()}}};stream3.once("response",onResponse);stream3.once("headers",headers=>this.emit("information",{statusCode:headers[HTTP2_HEADER_STATUS]}));stream3.once("trailers",(trailers,flags,rawTrailers)=>{const{res}=this;if(res===null){onResponse(trailers,flags,rawTrailers);return}res.trailers=trailers;res.rawTrailers=rawTrailers});stream3.once("close",()=>{const{aborted,res}=this;if(res){if(aborted){res.aborted=true;res.emit("aborted");res.destroy()}const finish=()=>{res.emit("close");this.destroy();this.emit("close")};if(res.readable){res.once("end",finish)}else{finish()}return}if(!this.destroyed){this.destroy(new Error("The HTTP/2 stream has been early terminated"));this.emit("close");return}this.destroy();this.emit("close")});this.socket=new Proxy(stream3,proxySocketHandler);for(const job of this[kJobs]){job()}this[kJobs].length=0;this.emit("socket",this.socket)};if(!(HTTP2_HEADER_AUTHORITY in this[kHeaders])&&!isConnectMethod){this[kHeaders][HTTP2_HEADER_AUTHORITY]=this[kOrigin].host}if(this[kSession]){try{onStream(this[kSession].request(this[kHeaders]))}catch(error){this.destroy(error)}}else{this.reusedSocket=true;try{const promise=this.agent.request(this[kOrigin],this[kOptions],this[kHeaders]);this[kPendingAgentPromise]=promise;onStream(await promise);this[kPendingAgentPromise]=false}catch(error){this[kPendingAgentPromise]=false;this.destroy(error)}}}get connection(){return this.socket}set connection(value){this.socket=value}getHeaderNames(){return Object.keys(this[kHeaders])}hasHeader(name){if(typeof name!=="string"){throw new ERR_INVALID_ARG_TYPE("name","string",name)}return Boolean(this[kHeaders][name.toLowerCase()])}getHeader(name){if(typeof name!=="string"){throw new ERR_INVALID_ARG_TYPE("name","string",name)}return this[kHeaders][name.toLowerCase()]}get headersSent(){return this[kFlushedHeaders]}removeHeader(name){if(typeof name!=="string"){throw new ERR_INVALID_ARG_TYPE("name","string",name)}if(this.headersSent){throw new ERR_HTTP_HEADERS_SENT("remove")}delete this[kHeaders][name.toLowerCase()]}setHeader(name,value){if(this.headersSent){throw new ERR_HTTP_HEADERS_SENT("set")}validateHeaderName(name);validateHeaderValue(name,value);const lowercased=name.toLowerCase();if(lowercased==="connection"){if(value.toLowerCase()==="keep-alive"){return}throw new Error(`Invalid 'connection' header: ${value}`)}if(lowercased==="host"&&this.method==="CONNECT"){this[kHeaders][HTTP2_HEADER_AUTHORITY]=value}else{this[kHeaders][lowercased]=value}}setNoDelay(){}setSocketKeepAlive(){}setTimeout(ms,callback){const applyTimeout=()=>this._request.setTimeout(ms,callback);if(this._request){applyTimeout()}else{this[kJobs].push(applyTimeout)}return this}get maxHeadersCount(){if(!this.destroyed&&this._request){return this._request.session.localSettings.maxHeaderListSize}return void 0}set maxHeadersCount(_value){}};module2.exports=ClientRequest}});var require_resolve_alpn=__commonJS({"node_modules/resolve-alpn/index.js"(exports2,module2){"use strict";var tls=require("tls");module2.exports=(options={},connect=tls.connect)=>new Promise((resolve,reject2)=>{let timeout=false;let socket;const callback=async()=>{await socketPromise;socket.off("timeout",onTimeout);socket.off("error",reject2);if(options.resolveSocket){resolve({alpnProtocol:socket.alpnProtocol,socket,timeout});if(timeout){await Promise.resolve();socket.emit("timeout")}}else{socket.destroy();resolve({alpnProtocol:socket.alpnProtocol,timeout})}};const onTimeout=async()=>{timeout=true;callback()};const socketPromise=(async()=>{try{socket=await connect(options,callback);socket.on("error",reject2);socket.once("timeout",onTimeout)}catch(error){reject2(error)}})()})}});var require_calculate_server_name=__commonJS({"node_modules/http2-wrapper/source/utils/calculate-server-name.js"(exports2,module2){"use strict";var{isIP}=require("net");var assert2=require("assert");var getHost=host=>{if(host[0]==="["){const idx2=host.indexOf("]");assert2(idx2!==-1);return host.slice(1,idx2)}const idx=host.indexOf(":");if(idx===-1){return host}return host.slice(0,idx)};module2.exports=host=>{const servername=getHost(host);if(isIP(servername)){return""}return servername}}});var require_auto=__commonJS({"node_modules/http2-wrapper/source/auto.js"(exports2,module2){"use strict";var{URL:URL3,urlToHttpOptions}=require("url");var http3=require("http");var https2=require("https");var resolveALPN=require_resolve_alpn();var QuickLRU=require_quick_lru();var{Agent,globalAgent}=require_agent();var Http2ClientRequest=require_client_request();var calculateServerName=require_calculate_server_name();var delayAsyncDestroy=require_delay_async_destroy();var cache2=new QuickLRU({maxSize:100});var queue=new Map;var installSocket=(agent,socket,options)=>{socket._httpMessage={shouldKeepAlive:true};const onFree=()=>{agent.emit("free",socket,options)};socket.on("free",onFree);const onClose=()=>{agent.removeSocket(socket,options)};socket.on("close",onClose);const onTimeout=()=>{const{freeSockets}=agent;for(const sockets of Object.values(freeSockets)){if(sockets.includes(socket)){socket.destroy();return}}};socket.on("timeout",onTimeout);const onRemove=()=>{agent.removeSocket(socket,options);socket.off("close",onClose);socket.off("free",onFree);socket.off("timeout",onTimeout);socket.off("agentRemove",onRemove)};socket.on("agentRemove",onRemove);agent.emit("free",socket,options)};var createResolveProtocol=(cache3,queue2=new Map,connect=void 0)=>{return async options=>{const name=`${options.host}:${options.port}:${options.ALPNProtocols.sort()}`;if(!cache3.has(name)){if(queue2.has(name)){const result2=await queue2.get(name);return{alpnProtocol:result2.alpnProtocol}}const{path:path27}=options;options.path=options.socketPath;const resultPromise=resolveALPN(options,connect);queue2.set(name,resultPromise);try{const result2=await resultPromise;cache3.set(name,result2.alpnProtocol);queue2.delete(name);options.path=path27;return result2}catch(error){queue2.delete(name);options.path=path27;throw error}}return{alpnProtocol:cache3.get(name)}}};var defaultResolveProtocol=createResolveProtocol(cache2,queue);module2.exports=async(input,options,callback)=>{if(typeof input==="string"){input=urlToHttpOptions(new URL3(input))}else if(input instanceof URL3){input=urlToHttpOptions(input)}else{input={...input}}if(typeof options==="function"||options===void 0){callback=options;options=input}else{options=Object.assign(input,options)}options.ALPNProtocols=options.ALPNProtocols||["h2","http/1.1"];if(!Array.isArray(options.ALPNProtocols)||options.ALPNProtocols.length===0){throw new Error("The `ALPNProtocols` option must be an Array with at least one entry")}options.protocol=options.protocol||"https:";const isHttps=options.protocol==="https:";options.host=options.hostname||options.host||"localhost";options.session=options.tlsSession;options.servername=options.servername||calculateServerName(options.headers&&options.headers.host||options.host);options.port=options.port||(isHttps?443:80);options._defaultAgent=isHttps?https2.globalAgent:http3.globalAgent;const resolveProtocol=options.resolveProtocol||defaultResolveProtocol;let{agent}=options;if(agent!==void 0&&agent!==false&&agent.constructor.name!=="Object"){throw new Error("The `options.agent` can be only an object `http`, `https` or `http2` properties")}if(isHttps){options.resolveSocket=true;let{socket,alpnProtocol,timeout}=await resolveProtocol(options);if(timeout){if(socket){socket.destroy()}const error=new Error(`Timed out resolving ALPN: ${options.timeout} ms`);error.code="ETIMEDOUT";error.ms=options.timeout;throw error}if(socket&&options.createConnection){socket.destroy();socket=void 0}delete options.resolveSocket;const isHttp2=alpnProtocol==="h2";if(agent){agent=isHttp2?agent.http2:agent.https;options.agent=agent}if(agent===void 0){agent=isHttp2?globalAgent:https2.globalAgent}if(socket){if(agent===false){socket.destroy()}else{const defaultCreateConnection=(isHttp2?Agent:https2.Agent).prototype.createConnection;if(agent.createConnection===defaultCreateConnection){if(isHttp2){options._reuseSocket=socket}else{installSocket(agent,socket,options)}}else{socket.destroy()}}}if(isHttp2){return delayAsyncDestroy(new Http2ClientRequest(options,callback))}}else if(agent){options.agent=agent.http}if(options.headers){options.headers={...options.headers};if(options.headers[":authority"]){if(!options.headers.host){options.headers.host=options.headers[":authority"]}delete options.headers[":authority"]}delete options.headers[":method"];delete options.headers[":scheme"];delete options.headers[":path"]}return delayAsyncDestroy(http3.request(options,callback))};module2.exports.protocolCache=cache2;module2.exports.resolveProtocol=defaultResolveProtocol;module2.exports.createResolveProtocol=createResolveProtocol}});var require_js_stream_socket=__commonJS({"node_modules/http2-wrapper/source/utils/js-stream-socket.js"(exports2,module2){"use strict";var stream3=require("stream");var tls=require("tls");var JSStreamSocket=new tls.TLSSocket(new stream3.PassThrough)._handle._parentWrap.constructor;module2.exports=JSStreamSocket}});var require_unexpected_status_code_error=__commonJS({"node_modules/http2-wrapper/source/proxies/unexpected-status-code-error.js"(exports2,module2){"use strict";var UnexpectedStatusCodeError=class extends Error{constructor(statusCode,statusMessage=""){super(`The proxy server rejected the request with status code ${statusCode} (${statusMessage||"empty status message"})`);this.statusCode=statusCode;this.statusMessage=statusMessage}};module2.exports=UnexpectedStatusCodeError}});var require_check_type=__commonJS({"node_modules/http2-wrapper/source/utils/check-type.js"(exports2,module2){"use strict";var checkType=(name,value,types6)=>{const valid=types6.some(type2=>{const typeofType=typeof type2;if(typeofType==="string"){return typeof value===type2}return value instanceof type2});if(!valid){const names2=types6.map(type2=>typeof type2==="string"?type2:type2.name);throw new TypeError(`Expected '${name}' to be a type of ${names2.join(" or ")}, got ${typeof value}`)}};module2.exports=checkType}});var require_initialize=__commonJS({"node_modules/http2-wrapper/source/proxies/initialize.js"(exports2,module2){"use strict";var{URL:URL3}=require("url");var checkType=require_check_type();module2.exports=(self2,proxyOptions)=>{checkType("proxyOptions",proxyOptions,["object"]);checkType("proxyOptions.headers",proxyOptions.headers,["object","undefined"]);checkType("proxyOptions.raw",proxyOptions.raw,["boolean","undefined"]);checkType("proxyOptions.url",proxyOptions.url,[URL3,"string"]);const url=new URL3(proxyOptions.url);self2.proxyOptions={raw:true,...proxyOptions,headers:{...proxyOptions.headers},url}}}});var require_get_auth_headers=__commonJS({"node_modules/http2-wrapper/source/proxies/get-auth-headers.js"(exports2,module2){"use strict";module2.exports=self2=>{const{username,password}=self2.proxyOptions.url;if(username||password){const data=`${username}:${password}`;const authorization=`Basic ${Buffer.from(data).toString("base64")}`;return{"proxy-authorization":authorization,authorization}}return{}}}});var require_h1_over_h2=__commonJS({"node_modules/http2-wrapper/source/proxies/h1-over-h2.js"(exports2,module2){"use strict";var tls=require("tls");var http3=require("http");var https2=require("https");var JSStreamSocket=require_js_stream_socket();var{globalAgent}=require_agent();var UnexpectedStatusCodeError=require_unexpected_status_code_error();var initialize=require_initialize();var getAuthorizationHeaders=require_get_auth_headers();var createConnection=(self2,options,callback)=>{(async()=>{try{const{proxyOptions}=self2;const{url,headers,raw}=proxyOptions;const stream3=await globalAgent.request(url,proxyOptions,{...getAuthorizationHeaders(self2),...headers,":method":"CONNECT",":authority":`${options.host}:${options.port}`});stream3.once("error",callback);stream3.once("response",headers2=>{const statusCode=headers2[":status"];if(statusCode!==200){callback(new UnexpectedStatusCodeError(statusCode,""));return}const encrypted=self2 instanceof https2.Agent;if(raw&&encrypted){options.socket=stream3;const secureStream=tls.connect(options);secureStream.once("close",()=>{stream3.destroy()});callback(null,secureStream);return}const socket=new JSStreamSocket(stream3);socket.encrypted=false;socket._handle.getpeername=out=>{out.family=void 0;out.address=void 0;out.port=void 0};callback(null,socket)})}catch(error){callback(error)}})()};var HttpOverHttp2=class extends http3.Agent{constructor(options){super(options);initialize(this,options.proxyOptions)}createConnection(options,callback){createConnection(this,options,callback)}};var HttpsOverHttp2=class extends https2.Agent{constructor(options){super(options);initialize(this,options.proxyOptions)}createConnection(options,callback){createConnection(this,options,callback)}};module2.exports={HttpOverHttp2,HttpsOverHttp2}}});var require_h2_over_hx=__commonJS({"node_modules/http2-wrapper/source/proxies/h2-over-hx.js"(exports2,module2){"use strict";var{Agent}=require_agent();var JSStreamSocket=require_js_stream_socket();var UnexpectedStatusCodeError=require_unexpected_status_code_error();var initialize=require_initialize();var Http2OverHttpX=class extends Agent{constructor(options){super(options);initialize(this,options.proxyOptions)}async createConnection(origin,options){const authority=`${origin.hostname}:${origin.port||443}`;const[stream3,statusCode,statusMessage]=await this._getProxyStream(authority);if(statusCode!==200){throw new UnexpectedStatusCodeError(statusCode,statusMessage)}if(this.proxyOptions.raw){options.socket=stream3}else{const socket=new JSStreamSocket(stream3);socket.encrypted=false;socket._handle.getpeername=out=>{out.family=void 0;out.address=void 0;out.port=void 0};return socket}return super.createConnection(origin,options)}};module2.exports=Http2OverHttpX}});var require_h2_over_h2=__commonJS({"node_modules/http2-wrapper/source/proxies/h2-over-h2.js"(exports2,module2){"use strict";var{globalAgent}=require_agent();var Http2OverHttpX=require_h2_over_hx();var getAuthorizationHeaders=require_get_auth_headers();var getStatusCode=stream3=>new Promise((resolve,reject2)=>{stream3.once("error",reject2);stream3.once("response",headers=>{stream3.off("error",reject2);resolve(headers[":status"])})});var Http2OverHttp2=class extends Http2OverHttpX{async _getProxyStream(authority){const{proxyOptions}=this;const headers={...getAuthorizationHeaders(this),...proxyOptions.headers,":method":"CONNECT",":authority":authority};const stream3=await globalAgent.request(proxyOptions.url,proxyOptions,headers);const statusCode=await getStatusCode(stream3);return[stream3,statusCode,""]}};module2.exports=Http2OverHttp2}});var require_h2_over_h1=__commonJS({"node_modules/http2-wrapper/source/proxies/h2-over-h1.js"(exports2,module2){"use strict";var http3=require("http");var https2=require("https");var Http2OverHttpX=require_h2_over_hx();var getAuthorizationHeaders=require_get_auth_headers();var getStream3=request=>new Promise((resolve,reject2)=>{const onConnect=(response,socket,head2)=>{socket.unshift(head2);request.off("error",reject2);resolve([socket,response.statusCode,response.statusMessage])};request.once("error",reject2);request.once("connect",onConnect)});var Http2OverHttp=class extends Http2OverHttpX{async _getProxyStream(authority){const{proxyOptions}=this;const{url,headers}=this.proxyOptions;const network=url.protocol==="https:"?https2:http3;const request=network.request({...proxyOptions,hostname:url.hostname,port:url.port,path:authority,headers:{...getAuthorizationHeaders(this),...headers,host:authority},method:"CONNECT"}).end();return getStream3(request)}};module2.exports={Http2OverHttp,Http2OverHttps:Http2OverHttp}}});var require_source2=__commonJS({"node_modules/http2-wrapper/source/index.js"(exports2,module2){"use strict";var http22=require("http2");var{Agent,globalAgent}=require_agent();var ClientRequest=require_client_request();var IncomingMessage=require_incoming_message();var auto=require_auto();var{HttpOverHttp2,HttpsOverHttp2}=require_h1_over_h2();var Http2OverHttp2=require_h2_over_h2();var{Http2OverHttp,Http2OverHttps}=require_h2_over_h1();var validateHeaderName=require_validate_header_name();var validateHeaderValue=require_validate_header_value();var request=(url,options,callback)=>new ClientRequest(url,options,callback);var get4=(url,options,callback)=>{const req=new ClientRequest(url,options,callback);req.end();return req};module2.exports={...http22,ClientRequest,IncomingMessage,Agent,globalAgent,request,get:get4,auto,proxies:{HttpOverHttp2,HttpsOverHttp2,Http2OverHttp2,Http2OverHttp,Http2OverHttps},validateHeaderName,validateHeaderValue}}});var require_windows=__commonJS({"node_modules/isexe/windows.js"(exports2,module2){module2.exports=isexe;isexe.sync=sync;var fs14=require("fs");function checkPathExt(path27,options){var pathext=options.pathExt!==void 0?options.pathExt:process.env.PATHEXT;if(!pathext){return true}pathext=pathext.split(";");if(pathext.indexOf("")!==-1){return true}for(var i=0;i<pathext.length;i++){var p=pathext[i].toLowerCase();if(p&&path27.substr(-p.length).toLowerCase()===p){return true}}return false}function checkStat(stat3,path27,options){if(!stat3.isSymbolicLink()&&!stat3.isFile()){return false}return checkPathExt(path27,options)}function isexe(path27,options,cb){fs14.stat(path27,function(er,stat3){cb(er,er?false:checkStat(stat3,path27,options))})}function sync(path27,options){return checkStat(fs14.statSync(path27),path27,options)}}});var require_mode=__commonJS({"node_modules/isexe/mode.js"(exports2,module2){module2.exports=isexe;isexe.sync=sync;var fs14=require("fs");function isexe(path27,options,cb){fs14.stat(path27,function(er,stat3){cb(er,er?false:checkStat(stat3,options))})}function sync(path27,options){return checkStat(fs14.statSync(path27),options)}function checkStat(stat3,options){return stat3.isFile()&&checkMode(stat3,options)}function checkMode(stat3,options){var mod3=stat3.mode;var uid=stat3.uid;var gid=stat3.gid;var myUid=options.uid!==void 0?options.uid:process.getuid&&process.getuid();var myGid=options.gid!==void 0?options.gid:process.getgid&&process.getgid();var u=parseInt("100",8);var g=parseInt("010",8);var o=parseInt("001",8);var ug=u|g;var ret=mod3&o||mod3&g&&gid===myGid||mod3&u&&uid===myUid||mod3&ug&&myUid===0;return ret}}});var require_isexe=__commonJS({"node_modules/isexe/index.js"(exports2,module2){var fs14=require("fs");var core2;if(process.platform==="win32"||global.TESTING_WINDOWS){core2=require_windows()}else{core2=require_mode()}module2.exports=isexe;isexe.sync=sync;function isexe(path27,options,cb){if(typeof options==="function"){cb=options;options={}}if(!cb){if(typeof Promise!=="function"){throw new TypeError("callback not provided")}return new Promise(function(resolve,reject2){isexe(path27,options||{},function(er,is2){if(er){reject2(er)}else{resolve(is2)}})})}core2(path27,options||{},function(er,is2){if(er){if(er.code==="EACCES"||options&&options.ignoreErrors){er=null;is2=false}}cb(er,is2)})}function sync(path27,options){try{return core2.sync(path27,options||{})}catch(er){if(options&&options.ignoreErrors||er.code==="EACCES"){return false}else{throw er}}}}});var require_which=__commonJS({"node_modules/which/which.js"(exports2,module2){var isWindows2=process.platform==="win32"||process.env.OSTYPE==="cygwin"||process.env.OSTYPE==="msys";var path27=require("path");var COLON=isWindows2?";":":";var isexe=require_isexe();var getNotFoundError=cmd=>Object.assign(new Error(`not found: ${cmd}`),{code:"ENOENT"});var getPathInfo=(cmd,opt)=>{const colon=opt.colon||COLON;const pathEnv=cmd.match(/\//)||isWindows2&&cmd.match(/\\/)?[""]:[...isWindows2?[process.cwd()]:[],...(opt.path||process.env.PATH||"").split(colon)];const pathExtExe=isWindows2?opt.pathExt||process.env.PATHEXT||".EXE;.CMD;.BAT;.COM":"";const pathExt=isWindows2?pathExtExe.split(colon):[""];if(isWindows2){if(cmd.indexOf(".")!==-1&&pathExt[0]!=="")pathExt.unshift("")}return{pathEnv,pathExt,pathExtExe}};var which=(cmd,opt,cb)=>{if(typeof opt==="function"){cb=opt;opt={}}if(!opt)opt={};const{pathEnv,pathExt,pathExtExe}=getPathInfo(cmd,opt);const found=[];const step=i=>new Promise((resolve,reject2)=>{if(i===pathEnv.length)return opt.all&&found.length?resolve(found):reject2(getNotFoundError(cmd));const ppRaw=pathEnv[i];const pathPart=/^".*"$/.test(ppRaw)?ppRaw.slice(1,-1):ppRaw;const pCmd=path27.join(pathPart,cmd);const p=!pathPart&&/^\.[\\\/]/.test(cmd)?cmd.slice(0,2)+pCmd:pCmd;resolve(subStep(p,i,0))});const subStep=(p,i,ii)=>new Promise((resolve,reject2)=>{if(ii===pathExt.length)return resolve(step(i+1));const ext=pathExt[ii];isexe(p+ext,{pathExt:pathExtExe},(er,is2)=>{if(!er&&is2){if(opt.all)found.push(p+ext);else return resolve(p+ext)}return resolve(subStep(p,i,ii+1))})});return cb?step(0).then(res=>cb(null,res),cb):step(0)};var whichSync=(cmd,opt)=>{opt=opt||{};const{pathEnv,pathExt,pathExtExe}=getPathInfo(cmd,opt);const found=[];for(let i=0;i<pathEnv.length;i++){const ppRaw=pathEnv[i];const pathPart=/^".*"$/.test(ppRaw)?ppRaw.slice(1,-1):ppRaw;const pCmd=path27.join(pathPart,cmd);const p=!pathPart&&/^\.[\\\/]/.test(cmd)?cmd.slice(0,2)+pCmd:pCmd;for(let j=0;j<pathExt.length;j++){const cur=p+pathExt[j];try{const is2=isexe.sync(cur,{pathExt:pathExtExe});if(is2){if(opt.all)found.push(cur);else return cur}}catch(ex){}}}if(opt.all&&found.length)return found;if(opt.nothrow)return null;throw getNotFoundError(cmd)};module2.exports=which;which.sync=whichSync}});var require_path_key=__commonJS({"node_modules/path-key/index.js"(exports2,module2){"use strict";var pathKey=(options={})=>{const environment=options.env||process.env;const platform=options.platform||process.platform;if(platform!=="win32"){return"PATH"}return Object.keys(environment).reverse().find(key=>key.toUpperCase()==="PATH")||"Path"};module2.exports=pathKey;module2.exports.default=pathKey}});var require_resolveCommand=__commonJS({"node_modules/cross-spawn/lib/util/resolveCommand.js"(exports2,module2){"use strict";var path27=require("path");var which=require_which();var getPathKey=require_path_key();function resolveCommandAttempt(parsed,withoutPathExt){const env2=parsed.options.env||process.env;const cwd=process.cwd();const hasCustomCwd=parsed.options.cwd!=null;const shouldSwitchCwd=hasCustomCwd&&process.chdir!==void 0&&!process.chdir.disabled;if(shouldSwitchCwd){try{process.chdir(parsed.options.cwd)}catch(err){}}let resolved;try{resolved=which.sync(parsed.command,{path:env2[getPathKey({env:env2})],pathExt:withoutPathExt?path27.delimiter:void 0})}catch(e){}finally{if(shouldSwitchCwd){process.chdir(cwd)}}if(resolved){resolved=path27.resolve(hasCustomCwd?parsed.options.cwd:"",resolved)}return resolved}function resolveCommand(parsed){return resolveCommandAttempt(parsed)||resolveCommandAttempt(parsed,true)}module2.exports=resolveCommand}});var require_escape=__commonJS({"node_modules/cross-spawn/lib/util/escape.js"(exports2,module2){"use strict";var metaCharsRegExp=/([()\][%!^"`<>&|;, *?])/g;function escapeCommand(arg){arg=arg.replace(metaCharsRegExp,"^$1");return arg}function escapeArgument(arg,doubleEscapeMetaChars){arg=`${arg}`;arg=arg.replace(/(?=(\\+?)?)\1"/g,'$1$1\\"');arg=arg.replace(/(?=(\\+?)?)\1$/,"$1$1");arg=`"${arg}"`;arg=arg.replace(metaCharsRegExp,"^$1");if(doubleEscapeMetaChars){arg=arg.replace(metaCharsRegExp,"^$1")}return arg}module2.exports.command=escapeCommand;module2.exports.argument=escapeArgument}});var require_shebang_regex=__commonJS({"node_modules/shebang-regex/index.js"(exports2,module2){"use strict";module2.exports=/^#!(.*)/}});var require_shebang_command=__commonJS({"node_modules/shebang-command/index.js"(exports2,module2){"use strict";var shebangRegex=require_shebang_regex();module2.exports=(string="")=>{const match=string.match(shebangRegex);if(!match){return null}const[path27,argument]=match[0].replace(/#! ?/,"").split(" ");const binary2=path27.split("/").pop();if(binary2==="env"){return argument}return argument?`${binary2} ${argument}`:binary2}}});var require_readShebang=__commonJS({"node_modules/cross-spawn/lib/util/readShebang.js"(exports2,module2){"use strict";var fs14=require("fs");var shebangCommand=require_shebang_command();function readShebang(command){const size2=150;const buffer=Buffer.alloc(size2);let fd;try{fd=fs14.openSync(command,"r");fs14.readSync(fd,buffer,0,size2,0);fs14.closeSync(fd)}catch(e){}return shebangCommand(buffer.toString())}module2.exports=readShebang}});var require_parse=__commonJS({"node_modules/cross-spawn/lib/parse.js"(exports2,module2){"use strict";var path27=require("path");var resolveCommand=require_resolveCommand();var escape3=require_escape();var readShebang=require_readShebang();var isWin=process.platform==="win32";var isExecutableRegExp=/\.(?:com|exe)$/i;var isCmdShimRegExp=/node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;function detectShebang(parsed){parsed.file=resolveCommand(parsed);const shebang=parsed.file&&readShebang(parsed.file);if(shebang){parsed.args.unshift(parsed.file);parsed.command=shebang;return resolveCommand(parsed)}return parsed.file}function parseNonShell(parsed){if(!isWin){return parsed}const commandFile=detectShebang(parsed);const needsShell=!isExecutableRegExp.test(commandFile);if(parsed.options.forceShell||needsShell){const needsDoubleEscapeMetaChars=isCmdShimRegExp.test(commandFile);parsed.command=path27.normalize(parsed.command);parsed.command=escape3.command(parsed.command);parsed.args=parsed.args.map(arg=>escape3.argument(arg,needsDoubleEscapeMetaChars));const shellCommand=[parsed.command].concat(parsed.args).join(" ");parsed.args=["/d","/s","/c",`"${shellCommand}"`];parsed.command=process.env.comspec||"cmd.exe";parsed.options.windowsVerbatimArguments=true}return parsed}function parse3(command,args2,options){if(args2&&!Array.isArray(args2)){options=args2;args2=null}args2=args2?args2.slice(0):[];options=Object.assign({},options);const parsed={command,args:args2,options,file:void 0,original:{command,args:args2}};return options.shell?parsed:parseNonShell(parsed)}module2.exports=parse3}});var require_enoent=__commonJS({"node_modules/cross-spawn/lib/enoent.js"(exports2,module2){"use strict";var isWin=process.platform==="win32";function notFoundError(original,syscall){return Object.assign(new Error(`${syscall} ${original.command} ENOENT`),{code:"ENOENT",errno:"ENOENT",syscall:`${syscall} ${original.command}`,path:original.command,spawnargs:original.args})}function hookChildProcess(cp,parsed){if(!isWin){return}const originalEmit=cp.emit;cp.emit=function(name,arg1){if(name==="exit"){const err=verifyENOENT(arg1,parsed);if(err){return originalEmit.call(cp,"error",err)}}return originalEmit.apply(cp,arguments)}}function verifyENOENT(status,parsed){if(isWin&&status===1&&!parsed.file){return notFoundError(parsed.original,"spawn")}return null}function verifyENOENTSync(status,parsed){if(isWin&&status===1&&!parsed.file){return notFoundError(parsed.original,"spawnSync")}return null}module2.exports={hookChildProcess,verifyENOENT,verifyENOENTSync,notFoundError}}});var require_cross_spawn=__commonJS({"node_modules/cross-spawn/index.js"(exports2,module2){"use strict";var cp=require("child_process");var parse3=require_parse();var enoent=require_enoent();function spawn2(command,args2,options){const parsed=parse3(command,args2,options);const spawned=cp.spawn(parsed.command,parsed.args,parsed.options);enoent.hookChildProcess(spawned,parsed);return spawned}function spawnSync(command,args2,options){const parsed=parse3(command,args2,options);const result2=cp.spawnSync(parsed.command,parsed.args,parsed.options);result2.error=result2.error||enoent.verifyENOENTSync(result2.status,parsed);return result2}module2.exports=spawn2;module2.exports.spawn=spawn2;module2.exports.sync=spawnSync;module2.exports._parse=parse3;module2.exports._enoent=enoent}});var require_strip_final_newline=__commonJS({"node_modules/strip-final-newline/index.js"(exports2,module2){"use strict";module2.exports=input=>{const LF=typeof input==="string"?"\n":"\n".charCodeAt();const CR=typeof input==="string"?"\r":"\r".charCodeAt();if(input[input.length-1]===LF){input=input.slice(0,input.length-1)}if(input[input.length-1]===CR){input=input.slice(0,input.length-1)}return input}}});var require_npm_run_path=__commonJS({"node_modules/npm-run-path/index.js"(exports2,module2){"use strict";var path27=require("path");var pathKey=require_path_key();var npmRunPath=options=>{options={cwd:process.cwd(),path:process.env[pathKey()],execPath:process.execPath,...options};let previous;let cwdPath=path27.resolve(options.cwd);const result2=[];while(previous!==cwdPath){result2.push(path27.join(cwdPath,"node_modules/.bin"));previous=cwdPath;cwdPath=path27.resolve(cwdPath,"..")}const execPathDir=path27.resolve(options.cwd,options.execPath,"..");result2.push(execPathDir);return result2.concat(options.path).join(path27.delimiter)};module2.exports=npmRunPath;module2.exports.default=npmRunPath;module2.exports.env=options=>{options={env:process.env,...options};const env2={...options.env};const path28=pathKey({env:env2});options.path=env2[path28];env2[path28]=module2.exports(options);return env2}}});var require_mimic_fn=__commonJS({"node_modules/mimic-fn/index.js"(exports2,module2){"use strict";var mimicFn=(to,from)=>{for(const prop of Reflect.ownKeys(from)){Object.defineProperty(to,prop,Object.getOwnPropertyDescriptor(from,prop))}return to};module2.exports=mimicFn;module2.exports.default=mimicFn}});var require_onetime=__commonJS({"node_modules/onetime/index.js"(exports2,module2){"use strict";var mimicFn=require_mimic_fn();var calledFunctions=new WeakMap;var onetime=(function_,options={})=>{if(typeof function_!=="function"){throw new TypeError("Expected a function")}let returnValue;let callCount=0;const functionName=function_.displayName||function_.name||"<anonymous>";const onetime2=function(...arguments_){calledFunctions.set(onetime2,++callCount);if(callCount===1){returnValue=function_.apply(this,arguments_);function_=null}else if(options.throw===true){throw new Error(`Function \`${functionName}\` can only be called once`)}return returnValue};mimicFn(onetime2,function_);calledFunctions.set(onetime2,callCount);return onetime2};module2.exports=onetime;module2.exports.default=onetime;module2.exports.callCount=function_=>{if(!calledFunctions.has(function_)){throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`)}return calledFunctions.get(function_)}}});var require_core=__commonJS({"node_modules/human-signals/build/src/core.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SIGNALS=void 0;var SIGNALS=[{name:"SIGHUP",number:1,action:"terminate",description:"Terminal closed",standard:"posix"},{name:"SIGINT",number:2,action:"terminate",description:"User interruption with CTRL-C",standard:"ansi"},{name:"SIGQUIT",number:3,action:"core",description:"User interruption with CTRL-\\",standard:"posix"},{name:"SIGILL",number:4,action:"core",description:"Invalid machine instruction",standard:"ansi"},{name:"SIGTRAP",number:5,action:"core",description:"Debugger breakpoint",standard:"posix"},{name:"SIGABRT",number:6,action:"core",description:"Aborted",standard:"ansi"},{name:"SIGIOT",number:6,action:"core",description:"Aborted",standard:"bsd"},{name:"SIGBUS",number:7,action:"core",description:"Bus error due to misaligned, non-existing address or paging error",standard:"bsd"},{name:"SIGEMT",number:7,action:"terminate",description:"Command should be emulated but is not implemented",standard:"other"},{name:"SIGFPE",number:8,action:"core",description:"Floating point arithmetic error",standard:"ansi"},{name:"SIGKILL",number:9,action:"terminate",description:"Forced termination",standard:"posix",forced:true},{name:"SIGUSR1",number:10,action:"terminate",description:"Application-specific signal",standard:"posix"},{name:"SIGSEGV",number:11,action:"core",description:"Segmentation fault",standard:"ansi"},{name:"SIGUSR2",number:12,action:"terminate",description:"Application-specific signal",standard:"posix"},{name:"SIGPIPE",number:13,action:"terminate",description:"Broken pipe or socket",standard:"posix"},{name:"SIGALRM",number:14,action:"terminate",description:"Timeout or timer",standard:"posix"},{name:"SIGTERM",number:15,action:"terminate",description:"Termination",standard:"ansi"},{name:"SIGSTKFLT",number:16,action:"terminate",description:"Stack is empty or overflowed",standard:"other"},{name:"SIGCHLD",number:17,action:"ignore",description:"Child process terminated, paused or unpaused",standard:"posix"},{name:"SIGCLD",number:17,action:"ignore",description:"Child process terminated, paused or unpaused",standard:"other"},{name:"SIGCONT",number:18,action:"unpause",description:"Unpaused",standard:"posix",forced:true},{name:"SIGSTOP",number:19,action:"pause",description:"Paused",standard:"posix",forced:true},{name:"SIGTSTP",number:20,action:"pause",description:'Paused using CTRL-Z or "suspend"',standard:"posix"},{name:"SIGTTIN",number:21,action:"pause",description:"Background process cannot read terminal input",standard:"posix"},{name:"SIGBREAK",number:21,action:"terminate",description:"User interruption with CTRL-BREAK",standard:"other"},{name:"SIGTTOU",number:22,action:"pause",description:"Background process cannot write to terminal output",standard:"posix"},{name:"SIGURG",number:23,action:"ignore",description:"Socket received out-of-band data",standard:"bsd"},{name:"SIGXCPU",number:24,action:"core",description:"Process timed out",standard:"bsd"},{name:"SIGXFSZ",number:25,action:"core",description:"File too big",standard:"bsd"},{name:"SIGVTALRM",number:26,action:"terminate",description:"Timeout or timer",standard:"bsd"},{name:"SIGPROF",number:27,action:"terminate",description:"Timeout or timer",standard:"bsd"},{name:"SIGWINCH",number:28,action:"ignore",description:"Terminal window size changed",standard:"bsd"},{name:"SIGIO",number:29,action:"terminate",description:"I/O is available",standard:"other"},{name:"SIGPOLL",number:29,action:"terminate",description:"Watched event",standard:"other"},{name:"SIGINFO",number:29,action:"ignore",description:"Request for process information",standard:"other"},{name:"SIGPWR",number:30,action:"terminate",description:"Device running out of power",standard:"systemv"},{name:"SIGSYS",number:31,action:"core",description:"Invalid system call",standard:"other"},{name:"SIGUNUSED",number:31,action:"terminate",description:"Invalid system call",standard:"other"}];exports2.SIGNALS=SIGNALS}});var require_realtime=__commonJS({"node_modules/human-signals/build/src/realtime.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SIGRTMAX=exports2.getRealtimeSignals=void 0;var getRealtimeSignals=function(){const length=SIGRTMAX-SIGRTMIN+1;return Array.from({length},getRealtimeSignal)};exports2.getRealtimeSignals=getRealtimeSignals;var getRealtimeSignal=function(value,index){return{name:`SIGRT${index+1}`,number:SIGRTMIN+index,action:"terminate",description:"Application-specific signal (realtime)",standard:"posix"}};var SIGRTMIN=34;var SIGRTMAX=64;exports2.SIGRTMAX=SIGRTMAX}});var require_signals=__commonJS({"node_modules/human-signals/build/src/signals.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.getSignals=void 0;var _os=require("os");var _core=require_core();var _realtime=require_realtime();var getSignals=function(){const realtimeSignals=(0,_realtime.getRealtimeSignals)();const signals=[..._core.SIGNALS,...realtimeSignals].map(normalizeSignal);return signals};exports2.getSignals=getSignals;var normalizeSignal=function({name,number:defaultNumber,description,action,forced=false,standard}){const{signals:{[name]:constantSignal}}=_os.constants;const supported=constantSignal!==void 0;const number2=supported?constantSignal:defaultNumber;return{name,number:number2,description,supported,action,forced,standard}}}});var require_main=__commonJS({"node_modules/human-signals/build/src/main.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.signalsByNumber=exports2.signalsByName=void 0;var _os=require("os");var _signals=require_signals();var _realtime=require_realtime();var getSignalsByName=function(){const signals=(0,_signals.getSignals)();return signals.reduce(getSignalByName,{})};var getSignalByName=function(signalByNameMemo,{name,number:number2,description,supported,action,forced,standard}){return{...signalByNameMemo,[name]:{name,number:number2,description,supported,action,forced,standard}}};var signalsByName=getSignalsByName();exports2.signalsByName=signalsByName;var getSignalsByNumber=function(){const signals=(0,_signals.getSignals)();const length=_realtime.SIGRTMAX+1;const signalsA=Array.from({length},(value,number2)=>getSignalByNumber(number2,signals));return Object.assign({},...signalsA)};var getSignalByNumber=function(number2,signals){const signal=findSignalByNumber(number2,signals);if(signal===void 0){return{}}const{name,description,supported,action,forced,standard}=signal;return{[number2]:{name,number:number2,description,supported,action,forced,standard}}};var findSignalByNumber=function(number2,signals){const signal=signals.find(({name})=>_os.constants.signals[name]===number2);if(signal!==void 0){return signal}return signals.find(signalA=>signalA.number===number2)};var signalsByNumber=getSignalsByNumber();exports2.signalsByNumber=signalsByNumber}});var require_error=__commonJS({"node_modules/execa/lib/error.js"(exports2,module2){"use strict";var{signalsByName}=require_main();var getErrorPrefix=({timedOut:timedOut2,timeout,errorCode,signal,signalDescription,exitCode,isCanceled})=>{if(timedOut2){return`timed out after ${timeout} milliseconds`}if(isCanceled){return"was canceled"}if(errorCode!==void 0){return`failed with ${errorCode}`}if(signal!==void 0){return`was killed with ${signal} (${signalDescription})`}if(exitCode!==void 0){return`failed with exit code ${exitCode}`}return"failed"};var makeError=({stdout,stderr,all:all2,error,signal,exitCode,command,escapedCommand,timedOut:timedOut2,isCanceled,killed,parsed:{options:{timeout}}})=>{exitCode=exitCode===null?void 0:exitCode;signal=signal===null?void 0:signal;const signalDescription=signal===void 0?void 0:signalsByName[signal].description;const errorCode=error&&error.code;const prefix=getErrorPrefix({timedOut:timedOut2,timeout,errorCode,signal,signalDescription,exitCode,isCanceled});const execaMessage=`Command ${prefix}: ${command}`;const isError2=Object.prototype.toString.call(error)==="[object Error]";const shortMessage=isError2?`${execaMessage}
${error.message}`:execaMessage;const message3=[shortMessage,stderr,stdout].filter(Boolean).join("\n");if(isError2){error.originalMessage=error.message;error.message=message3}else{error=new Error(message3)}error.shortMessage=shortMessage;error.command=command;error.escapedCommand=escapedCommand;error.exitCode=exitCode;error.signal=signal;error.signalDescription=signalDescription;error.stdout=stdout;error.stderr=stderr;if(all2!==void 0){error.all=all2}if("bufferedData"in error){delete error.bufferedData}error.failed=true;error.timedOut=Boolean(timedOut2);error.isCanceled=isCanceled;error.killed=killed&&!timedOut2;return error};module2.exports=makeError}});var require_stdio=__commonJS({"node_modules/execa/lib/stdio.js"(exports2,module2){"use strict";var aliases2=["stdin","stdout","stderr"];var hasAlias=options=>aliases2.some(alias=>options[alias]!==void 0);var normalizeStdio=options=>{if(!options){return}const{stdio}=options;if(stdio===void 0){return aliases2.map(alias=>options[alias])}if(hasAlias(options)){throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases2.map(alias=>`\`${alias}\``).join(", ")}`)}if(typeof stdio==="string"){return stdio}if(!Array.isArray(stdio)){throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``)}const length=Math.max(stdio.length,aliases2.length);return Array.from({length},(value,index)=>stdio[index])};module2.exports=normalizeStdio;module2.exports.node=options=>{const stdio=normalizeStdio(options);if(stdio==="ipc"){return"ipc"}if(stdio===void 0||typeof stdio==="string"){return[stdio,stdio,stdio,"ipc"]}if(stdio.includes("ipc")){return stdio}return[...stdio,"ipc"]}}});var require_signals2=__commonJS({"node_modules/execa/node_modules/signal-exit/signals.js"(exports2,module2){module2.exports=["SIGABRT","SIGALRM","SIGHUP","SIGINT","SIGTERM"];if(process.platform!=="win32"){module2.exports.push("SIGVTALRM","SIGXCPU","SIGXFSZ","SIGUSR2","SIGTRAP","SIGSYS","SIGQUIT","SIGIOT")}if(process.platform==="linux"){module2.exports.push("SIGIO","SIGPOLL","SIGPWR","SIGSTKFLT","SIGUNUSED")}}});var require_signal_exit=__commonJS({"node_modules/execa/node_modules/signal-exit/index.js"(exports2,module2){var process6=global.process;var processOk=function(process7){return process7&&typeof process7==="object"&&typeof process7.removeListener==="function"&&typeof process7.emit==="function"&&typeof process7.reallyExit==="function"&&typeof process7.listeners==="function"&&typeof process7.kill==="function"&&typeof process7.pid==="number"&&typeof process7.on==="function"};if(!processOk(process6)){module2.exports=function(){return function(){}}}else{assert2=require("assert");signals=require_signals2();isWin=/^win/i.test(process6.platform);EE=require("events");if(typeof EE!=="function"){EE=EE.EventEmitter}if(process6.__signal_exit_emitter__){emitter=process6.__signal_exit_emitter__}else{emitter=process6.__signal_exit_emitter__=new EE;emitter.count=0;emitter.emitted={}}if(!emitter.infinite){emitter.setMaxListeners(Infinity);emitter.infinite=true}module2.exports=function(cb,opts){if(!processOk(global.process)){return function(){}}assert2.equal(typeof cb,"function","a callback must be provided for exit handler");if(loaded===false){load2()}var ev="exit";if(opts&&opts.alwaysLast){ev="afterexit"}var remove2=function(){emitter.removeListener(ev,cb);if(emitter.listeners("exit").length===0&&emitter.listeners("afterexit").length===0){unload()}};emitter.on(ev,cb);return remove2};unload=function unload2(){if(!loaded||!processOk(global.process)){return}loaded=false;signals.forEach(function(sig){try{process6.removeListener(sig,sigListeners[sig])}catch(er){}});process6.emit=originalProcessEmit;process6.reallyExit=originalProcessReallyExit;emitter.count-=1};module2.exports.unload=unload;emit=function emit2(event,code,signal){if(emitter.emitted[event]){return}emitter.emitted[event]=true;emitter.emit(event,code,signal)};sigListeners={};signals.forEach(function(sig){sigListeners[sig]=function listener(){if(!processOk(global.process)){return}var listeners=process6.listeners(sig);if(listeners.length===emitter.count){unload();emit("exit",null,sig);emit("afterexit",null,sig);if(isWin&&sig==="SIGHUP"){sig="SIGINT"}process6.kill(process6.pid,sig)}}});module2.exports.signals=function(){return signals};loaded=false;load2=function load3(){if(loaded||!processOk(global.process)){return}loaded=true;emitter.count+=1;signals=signals.filter(function(sig){try{process6.on(sig,sigListeners[sig]);return true}catch(er){return false}});process6.emit=processEmit;process6.reallyExit=processReallyExit};module2.exports.load=load2;originalProcessReallyExit=process6.reallyExit;processReallyExit=function processReallyExit2(code){if(!processOk(global.process)){return}process6.exitCode=code||0;emit("exit",process6.exitCode,null);emit("afterexit",process6.exitCode,null);originalProcessReallyExit.call(process6,process6.exitCode)};originalProcessEmit=process6.emit;processEmit=function processEmit2(ev,arg){if(ev==="exit"&&processOk(global.process)){if(arg!==void 0){process6.exitCode=arg}var ret=originalProcessEmit.apply(this,arguments);emit("exit",process6.exitCode,null);emit("afterexit",process6.exitCode,null);return ret}else{return originalProcessEmit.apply(this,arguments)}}}var assert2;var signals;var isWin;var EE;var emitter;var unload;var emit;var sigListeners;var loaded;var load2;var originalProcessReallyExit;var processReallyExit;var originalProcessEmit;var processEmit}});var require_kill=__commonJS({"node_modules/execa/lib/kill.js"(exports2,module2){"use strict";var os7=require("os");var onExit=require_signal_exit();var DEFAULT_FORCE_KILL_TIMEOUT=1e3*5;var spawnedKill=(kill,signal="SIGTERM",options={})=>{const killResult=kill(signal);setKillTimeout(kill,signal,options,killResult);return killResult};var setKillTimeout=(kill,signal,options,killResult)=>{if(!shouldForceKill(signal,options,killResult)){return}const timeout=getForceKillAfterTimeout(options);const t=setTimeout(()=>{kill("SIGKILL")},timeout);if(t.unref){t.unref()}};var shouldForceKill=(signal,{forceKillAfterTimeout},killResult)=>{return isSigterm(signal)&&forceKillAfterTimeout!==false&&killResult};var isSigterm=signal=>{return signal===os7.constants.signals.SIGTERM||typeof signal==="string"&&signal.toUpperCase()==="SIGTERM"};var getForceKillAfterTimeout=({forceKillAfterTimeout=true})=>{if(forceKillAfterTimeout===true){return DEFAULT_FORCE_KILL_TIMEOUT}if(!Number.isFinite(forceKillAfterTimeout)||forceKillAfterTimeout<0){throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`)}return forceKillAfterTimeout};var spawnedCancel=(spawned,context)=>{const killResult=spawned.kill();if(killResult){context.isCanceled=true}};var timeoutKill=(spawned,signal,reject2)=>{spawned.kill(signal);reject2(Object.assign(new Error("Timed out"),{timedOut:true,signal}))};var setupTimeout=(spawned,{timeout,killSignal="SIGTERM"},spawnedPromise)=>{if(timeout===0||timeout===void 0){return spawnedPromise}let timeoutId;const timeoutPromise=new Promise((resolve,reject2)=>{timeoutId=setTimeout(()=>{timeoutKill(spawned,killSignal,reject2)},timeout)});const safeSpawnedPromise=spawnedPromise.finally(()=>{clearTimeout(timeoutId)});return Promise.race([timeoutPromise,safeSpawnedPromise])};var validateTimeout=({timeout})=>{if(timeout!==void 0&&(!Number.isFinite(timeout)||timeout<0)){throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout}\` (${typeof timeout})`)}};var setExitHandler=async(spawned,{cleanup,detached},timedPromise)=>{if(!cleanup||detached){return timedPromise}const removeExitHandler=onExit(()=>{spawned.kill()});return timedPromise.finally(()=>{removeExitHandler()})};module2.exports={spawnedKill,spawnedCancel,setupTimeout,validateTimeout,setExitHandler}}});var require_is_stream=__commonJS({"node_modules/is-stream/index.js"(exports2,module2){"use strict";var isStream=stream3=>stream3!==null&&typeof stream3==="object"&&typeof stream3.pipe==="function";isStream.writable=stream3=>isStream(stream3)&&stream3.writable!==false&&typeof stream3._write==="function"&&typeof stream3._writableState==="object";isStream.readable=stream3=>isStream(stream3)&&stream3.readable!==false&&typeof stream3._read==="function"&&typeof stream3._readableState==="object";isStream.duplex=stream3=>isStream.writable(stream3)&&isStream.readable(stream3);isStream.transform=stream3=>isStream.duplex(stream3)&&typeof stream3._transform==="function";module2.exports=isStream}});var require_merge_stream=__commonJS({"node_modules/merge-stream/index.js"(exports2,module2){"use strict";var{PassThrough}=require("stream");module2.exports=function(){var sources=[];var output=new PassThrough({objectMode:true});output.setMaxListeners(0);output.add=add2;output.isEmpty=isEmpty2;output.on("unpipe",remove2);Array.prototype.slice.call(arguments).forEach(add2);return output;function add2(source){if(Array.isArray(source)){source.forEach(add2);return this}sources.push(source);source.once("end",remove2.bind(null,source));source.once("error",output.emit.bind(output,"error"));source.pipe(output,{end:false});return this}function isEmpty2(){return sources.length==0}function remove2(source){sources=sources.filter(function(it){return it!==source});if(!sources.length&&output.readable){output.end()}}}}});var require_stream=__commonJS({"node_modules/execa/lib/stream.js"(exports2,module2){"use strict";var isStream=require_is_stream();var getStream3=require_get_stream();var mergeStream=require_merge_stream();var handleInput=(spawned,input)=>{if(input===void 0||spawned.stdin===void 0){return}if(isStream(input)){input.pipe(spawned.stdin)}else{spawned.stdin.end(input)}};var makeAllStream=(spawned,{all:all2})=>{if(!all2||!spawned.stdout&&!spawned.stderr){return}const mixed=mergeStream();if(spawned.stdout){mixed.add(spawned.stdout)}if(spawned.stderr){mixed.add(spawned.stderr)}return mixed};var getBufferedData=async(stream3,streamPromise)=>{if(!stream3){return}stream3.destroy();try{return await streamPromise}catch(error){return error.bufferedData}};var getStreamPromise=(stream3,{encoding,buffer,maxBuffer})=>{if(!stream3||!buffer){return}if(encoding){return getStream3(stream3,{encoding,maxBuffer})}return getStream3.buffer(stream3,{maxBuffer})};var getSpawnedResult=async({stdout,stderr,all:all2},{encoding,buffer,maxBuffer},processDone)=>{const stdoutPromise=getStreamPromise(stdout,{encoding,buffer,maxBuffer});const stderrPromise=getStreamPromise(stderr,{encoding,buffer,maxBuffer});const allPromise=getStreamPromise(all2,{encoding,buffer,maxBuffer:maxBuffer*2});try{return await Promise.all([processDone,stdoutPromise,stderrPromise,allPromise])}catch(error){return Promise.all([{error,signal:error.signal,timedOut:error.timedOut},getBufferedData(stdout,stdoutPromise),getBufferedData(stderr,stderrPromise),getBufferedData(all2,allPromise)])}};var validateInputSync=({input})=>{if(isStream(input)){throw new TypeError("The `input` option cannot be a stream in sync mode")}};module2.exports={handleInput,makeAllStream,getSpawnedResult,validateInputSync}}});var require_promise=__commonJS({"node_modules/execa/lib/promise.js"(exports2,module2){"use strict";var nativePromisePrototype=(async()=>{})().constructor.prototype;var descriptors=["then","catch","finally"].map(property2=>[property2,Reflect.getOwnPropertyDescriptor(nativePromisePrototype,property2)]);var mergePromise=(spawned,promise)=>{for(const[property2,descriptor]of descriptors){const value=typeof promise==="function"?(...args2)=>Reflect.apply(descriptor.value,promise(),args2):descriptor.value.bind(promise);Reflect.defineProperty(spawned,property2,{...descriptor,value})}return spawned};var getSpawnedPromise=spawned=>{return new Promise((resolve,reject2)=>{spawned.on("exit",(exitCode,signal)=>{resolve({exitCode,signal})});spawned.on("error",error=>{reject2(error)});if(spawned.stdin){spawned.stdin.on("error",error=>{reject2(error)})}})};module2.exports={mergePromise,getSpawnedPromise}}});var require_command=__commonJS({"node_modules/execa/lib/command.js"(exports2,module2){"use strict";var normalizeArgs=(file,args2=[])=>{if(!Array.isArray(args2)){return[file]}return[file,...args2]};var NO_ESCAPE_REGEXP=/^[\w.-]+$/;var DOUBLE_QUOTES_REGEXP=/"/g;var escapeArg=arg=>{if(typeof arg!=="string"||NO_ESCAPE_REGEXP.test(arg)){return arg}return`"${arg.replace(DOUBLE_QUOTES_REGEXP,'\\"')}"`};var joinCommand=(file,args2)=>{return normalizeArgs(file,args2).join(" ")};var getEscapedCommand=(file,args2)=>{return normalizeArgs(file,args2).map(arg=>escapeArg(arg)).join(" ")};var SPACES_REGEXP=/ +/g;var parseCommand=command=>{const tokens=[];for(const token3 of command.trim().split(SPACES_REGEXP)){const previousToken=tokens[tokens.length-1];if(previousToken&&previousToken.endsWith("\\")){tokens[tokens.length-1]=`${previousToken.slice(0,-1)} ${token3}`}else{tokens.push(token3)}}return tokens};module2.exports={joinCommand,getEscapedCommand,parseCommand}}});var require_execa=__commonJS({"node_modules/execa/index.js"(exports2,module2){"use strict";var path27=require("path");var childProcess=require("child_process");var crossSpawn=require_cross_spawn();var stripFinalNewline=require_strip_final_newline();var npmRunPath=require_npm_run_path();var onetime=require_onetime();var makeError=require_error();var normalizeStdio=require_stdio();var{spawnedKill,spawnedCancel,setupTimeout,validateTimeout,setExitHandler}=require_kill();var{handleInput,getSpawnedResult,makeAllStream,validateInputSync}=require_stream();var{mergePromise,getSpawnedPromise}=require_promise();var{joinCommand,parseCommand,getEscapedCommand}=require_command();var DEFAULT_MAX_BUFFER=1e3*1e3*100;var getEnv=({env:envOption,extendEnv,preferLocal,localDir,execPath})=>{const env2=extendEnv?{...process.env,...envOption}:envOption;if(preferLocal){return npmRunPath.env({env:env2,cwd:localDir,execPath})}return env2};var handleArguments=(file,args2,options={})=>{const parsed=crossSpawn._parse(file,args2,options);file=parsed.command;args2=parsed.args;options=parsed.options;options={maxBuffer:DEFAULT_MAX_BUFFER,buffer:true,stripFinalNewline:true,extendEnv:true,preferLocal:false,localDir:options.cwd||process.cwd(),execPath:process.execPath,encoding:"utf8",reject:true,cleanup:true,all:false,windowsHide:true,...options};options.env=getEnv(options);options.stdio=normalizeStdio(options);if(process.platform==="win32"&&path27.basename(file,".exe")==="cmd"){args2.unshift("/q")}return{file,args:args2,options,parsed}};var handleOutput=(options,value,error)=>{if(typeof value!=="string"&&!Buffer.isBuffer(value)){return error===void 0?void 0:""}if(options.stripFinalNewline){return stripFinalNewline(value)}return value};var execa2=(file,args2,options)=>{const parsed=handleArguments(file,args2,options);const command=joinCommand(file,args2);const escapedCommand=getEscapedCommand(file,args2);validateTimeout(parsed.options);let spawned;try{spawned=childProcess.spawn(parsed.file,parsed.args,parsed.options)}catch(error){const dummySpawned=new childProcess.ChildProcess;const errorPromise=Promise.reject(makeError({error,stdout:"",stderr:"",all:"",command,escapedCommand,parsed,timedOut:false,isCanceled:false,killed:false}));return mergePromise(dummySpawned,errorPromise)}const spawnedPromise=getSpawnedPromise(spawned);const timedPromise=setupTimeout(spawned,parsed.options,spawnedPromise);const processDone=setExitHandler(spawned,parsed.options,timedPromise);const context={isCanceled:false};spawned.kill=spawnedKill.bind(null,spawned.kill.bind(spawned));spawned.cancel=spawnedCancel.bind(null,spawned,context);const handlePromise=async()=>{const[{error,exitCode,signal,timedOut:timedOut2},stdoutResult,stderrResult,allResult]=await getSpawnedResult(spawned,parsed.options,processDone);const stdout=handleOutput(parsed.options,stdoutResult);const stderr=handleOutput(parsed.options,stderrResult);const all2=handleOutput(parsed.options,allResult);if(error||exitCode!==0||signal!==null){const returnedError=makeError({error,exitCode,signal,stdout,stderr,all:all2,command,escapedCommand,parsed,timedOut:timedOut2,isCanceled:context.isCanceled,killed:spawned.killed});if(!parsed.options.reject){return returnedError}throw returnedError}return{command,escapedCommand,exitCode:0,stdout,stderr,all:all2,failed:false,timedOut:false,isCanceled:false,killed:false}};const handlePromiseOnce=onetime(handlePromise);handleInput(spawned,parsed.options.input);spawned.all=makeAllStream(spawned,parsed.options);return mergePromise(spawned,handlePromiseOnce)};module2.exports=execa2;module2.exports.sync=(file,args2,options)=>{const parsed=handleArguments(file,args2,options);const command=joinCommand(file,args2);const escapedCommand=getEscapedCommand(file,args2);validateInputSync(parsed.options);let result2;try{result2=childProcess.spawnSync(parsed.file,parsed.args,parsed.options)}catch(error){throw makeError({error,stdout:"",stderr:"",all:"",command,escapedCommand,parsed,timedOut:false,isCanceled:false,killed:false})}const stdout=handleOutput(parsed.options,result2.stdout,result2.error);const stderr=handleOutput(parsed.options,result2.stderr,result2.error);if(result2.error||result2.status!==0||result2.signal!==null){const error=makeError({stdout,stderr,error:result2.error,signal:result2.signal,exitCode:result2.status,command,escapedCommand,parsed,timedOut:result2.error&&result2.error.code==="ETIMEDOUT",isCanceled:false,killed:result2.signal!==null});if(!parsed.options.reject){return error}throw error}return{command,escapedCommand,exitCode:0,stdout,stderr,failed:false,timedOut:false,isCanceled:false,killed:false}};module2.exports.command=(command,options)=>{const[file,...args2]=parseCommand(command);return execa2(file,args2,options)};module2.exports.commandSync=(command,options)=>{const[file,...args2]=parseCommand(command);return execa2.sync(file,args2,options)};module2.exports.node=(scriptPath,args2,options={})=>{if(args2&&!Array.isArray(args2)&&typeof args2==="object"){options=args2;args2=[]}const stdio=normalizeStdio.node(options);const defaultExecArgv=process.execArgv.filter(arg=>!arg.startsWith("--inspect"));const{nodePath=process.execPath,nodeOptions=defaultExecArgv}=options;return execa2(nodePath,[...nodeOptions,scriptPath,...Array.isArray(args2)?args2:[]],{...options,stdin:void 0,stdout:void 0,stderr:void 0,stdio,shell:false})}}});var require_package=__commonJS({"node_modules/systeminformation/package.json"(exports2,module2){module2.exports={name:"systeminformation",version:"5.25.3",description:"Advanced, lightweight system and OS information library",license:"MIT",author:"Sebastian Hildebrandt <hildebrandt@plus-innovations.com> (https://plus-innovations.com)",homepage:"https://systeminformation.io",main:"./lib/index.js",type:"commonjs",bin:{systeminformation:"lib/cli.js"},types:"./lib/index.d.ts",scripts:{test:"node ./test/test.js",testDeno:"deno run -A ./test/test.js"},files:["lib/"],keywords:["system information","sysinfo","monitor","monitoring","os","linux","osx","windows","freebsd","openbsd","netbsd","cpu","cpuload","physical cores","logical cores","processor","cores","threads","socket type","memory","file system","fsstats","diskio","block devices","netstats","network","network interfaces","network connections","network stats","iface","printer","processes","users","internet","battery","docker","docker stats","docker processes","graphics","graphic card","graphic controller","gpu","display","smart","disk layout","usb","audio","bluetooth","wifi","wifinetworks","virtual box","virtualbox","vm","backend","hardware","BIOS","chassis"],repository:{type:"git",url:"https://github.com/sebhildebrandt/systeminformation.git"},funding:{type:"Buy me a coffee",url:"https://www.buymeacoffee.com/systeminfo"},os:["darwin","linux","win32","freebsd","openbsd","netbsd","sunos","android"],engines:{node:">=8.0.0"}}}});var require_util2=__commonJS({"node_modules/systeminformation/lib/util.js"(exports2){"use strict";var os7=require("os");var fs14=require("fs");var path27=require("path");var spawn2=require("child_process").spawn;var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var util4=require("util");var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _cores=0;var wmicPath="";var codepage="";var _smartMonToolsInstalled=null;var _rpi_cpuinfo=null;var WINDIR=process.env.WINDIR||"C:\\Windows";var _psChild;var _psResult="";var _psCmds=[];var _psPersistent=false;var _powerShell="";var _psToUTF8="$OutputEncoding = [System.Console]::OutputEncoding = [System.Console]::InputEncoding = [System.Text.Encoding]::UTF8 ; ";var _psCmdStart="--###START###--";var _psError="--ERROR--";var _psCmdSeperator="--###ENDCMD###--";var _psIdSeperator="--##ID##--";var execOptsWin={windowsHide:true,maxBuffer:1024*2e4,encoding:"UTF-8",env:Object.assign({},process.env,{LANG:"en_US.UTF-8"})};var execOptsLinux={maxBuffer:1024*2e4,encoding:"UTF-8",stdio:["pipe","pipe","ignore"]};function toInt(value){let result2=parseInt(value,10);if(isNaN(result2)){result2=0}return result2}function splitByNumber(str2){let numberStarted=false;let num="";let cpart="";for(const c of str2){if(c>="0"&&c<="9"||numberStarted){numberStarted=true;num+=c}else{cpart+=c}}return[cpart,num]}var stringObj=new String;var stringReplace=new String().replace;var stringToLower=new String().toLowerCase;var stringToString=new String().toString;var stringSubstr=new String().substr;var stringSubstring=new String().substring;var stringTrim=new String().trim;var stringStartWith=new String().startsWith;var mathMin=Math.min;function isFunction3(functionToCheck){let getType2={};return functionToCheck&&getType2.toString.call(functionToCheck)==="[object Function]"}function unique(obj){let uniques=[];let stringify={};for(let i=0;i<obj.length;i++){let keys2=Object.keys(obj[i]);keys2.sort(function(a,b){return a-b});let str2="";for(let j=0;j<keys2.length;j++){str2+=JSON.stringify(keys2[j]);str2+=JSON.stringify(obj[i][keys2[j]])}if(!{}.hasOwnProperty.call(stringify,str2)){uniques.push(obj[i]);stringify[str2]=true}}return uniques}function sortByKey(array,keys2){return array.sort(function(a,b){let x="";let y="";keys2.forEach(function(key){x=x+a[key];y=y+b[key]});return x<y?-1:x>y?1:0})}function cores(){if(_cores===0){_cores=os7.cpus().length}return _cores}function getValue2(lines,property2,separator,trimmed,lineMatch){separator=separator||":";property2=property2.toLowerCase();trimmed=trimmed||false;lineMatch=lineMatch||false;let result2="";lines.some(line=>{let lineLower=line.toLowerCase().replace(/\t/g,"");if(trimmed){lineLower=lineLower.trim()}if(lineLower.startsWith(property2)&&(lineMatch?lineLower.match(property2+separator)||lineLower.match(property2+" "+separator):true)){const parts=trimmed?line.trim().split(separator):line.split(separator);if(parts.length>=2){parts.shift();result2=parts.join(separator).trim();return true}}});return result2}function decodeEscapeSequence(str2,base){base=base||16;return str2.replace(/\\x([0-9A-Fa-f]{2})/g,function(){return String.fromCharCode(parseInt(arguments[1],base))})}function detectSplit(str2){let seperator="";let part=0;str2.split("").forEach(element=>{if(element>="0"&&element<="9"){if(part===1){part++}}else{if(part===0){part++}if(part===1){seperator+=element}}});return seperator}function parseTime(t,pmDesignator){pmDesignator=pmDesignator||"";t=t.toUpperCase();let hour=0;let min3=0;let splitter=detectSplit(t);let parts=t.split(splitter);if(parts.length>=2){if(parts[2]){parts[1]+=parts[2]}let isPM=parts[1]&&parts[1].toLowerCase().indexOf("pm")>-1||parts[1].toLowerCase().indexOf("p.m.")>-1||parts[1].toLowerCase().indexOf("p. m.")>-1||parts[1].toLowerCase().indexOf("n")>-1||parts[1].toLowerCase().indexOf("ch")>-1||parts[1].toLowerCase().indexOf("ös")>-1||pmDesignator&&parts[1].toLowerCase().indexOf(pmDesignator)>-1;hour=parseInt(parts[0],10);min3=parseInt(parts[1],10);hour=isPM&&hour<12?hour+12:hour;return("0"+hour).substr(-2)+":"+("0"+min3).substr(-2)}}function parseDateTime(dt,culture){const result2={date:"",time:""};culture=culture||{};let dateFormat2=(culture.dateFormat||"").toLowerCase();let pmDesignator=culture.pmDesignator||"";const parts=dt.split(" ");if(parts[0]){if(parts[0].indexOf("/")>=0){const dtparts=parts[0].split("/");if(dtparts.length===3){if(dtparts[0].length===4){result2.date=dtparts[0]+"-"+("0"+dtparts[1]).substr(-2)+"-"+("0"+dtparts[2]).substr(-2)}else if(dtparts[2].length===2){if(dateFormat2.indexOf("/d/")>-1||dateFormat2.indexOf("/dd/")>-1){result2.date="20"+dtparts[2]+"-"+("0"+dtparts[1]).substr(-2)+"-"+("0"+dtparts[0]).substr(-2)}else{result2.date="20"+dtparts[2]+"-"+("0"+dtparts[1]).substr(-2)+"-"+("0"+dtparts[0]).substr(-2)}}else{const isEN=dt.toLowerCase().indexOf("pm")>-1||dt.toLowerCase().indexOf("p.m.")>-1||dt.toLowerCase().indexOf("p. m.")>-1||dt.toLowerCase().indexOf("am")>-1||dt.toLowerCase().indexOf("a.m.")>-1||dt.toLowerCase().indexOf("a. m.")>-1;if((isEN||dateFormat2.indexOf("/d/")>-1||dateFormat2.indexOf("/dd/")>-1)&&dateFormat2.indexOf("dd/")!==0){result2.date=dtparts[2]+"-"+("0"+dtparts[0]).substr(-2)+"-"+("0"+dtparts[1]).substr(-2)}else{result2.date=dtparts[2]+"-"+("0"+dtparts[1]).substr(-2)+"-"+("0"+dtparts[0]).substr(-2)}}}}if(parts[0].indexOf(".")>=0){const dtparts=parts[0].split(".");if(dtparts.length===3){if(dateFormat2.indexOf(".d.")>-1||dateFormat2.indexOf(".dd.")>-1){result2.date=dtparts[2]+"-"+("0"+dtparts[0]).substr(-2)+"-"+("0"+dtparts[1]).substr(-2)}else{result2.date=dtparts[2]+"-"+("0"+dtparts[1]).substr(-2)+"-"+("0"+dtparts[0]).substr(-2)}}}if(parts[0].indexOf("-")>=0){const dtparts=parts[0].split("-");if(dtparts.length===3){result2.date=dtparts[0]+"-"+("0"+dtparts[1]).substr(-2)+"-"+("0"+dtparts[2]).substr(-2)}}}if(parts[1]){parts.shift();let time=parts.join(" ");result2.time=parseTime(time,pmDesignator)}return result2}function parseHead(head2,rights){let space=rights>0;let count=1;let from=0;let to=0;let result2=[];for(let i=0;i<head2.length;i++){if(count<=rights){if(/\s/.test(head2[i])&&!space){to=i-1;result2.push({from,to:to+1,cap:head2.substring(from,to+1)});from=to+2;count++}space=head2[i]===" "}else{if(!/\s/.test(head2[i])&&space){to=i-1;if(from<to){result2.push({from,to,cap:head2.substring(from,to)})}from=to+1;count++}space=head2[i]===" "}}to=5e3;result2.push({from,to,cap:head2.substring(from,to)});let len=result2.length;for(let i=0;i<len;i++){if(result2[i].cap.replace(/\s/g,"").length===0){if(i+1<len){result2[i].to=result2[i+1].to;result2[i].cap=result2[i].cap+result2[i+1].cap;result2.splice(i+1,1);len=len-1}}}return result2}function findObjectByKey(array,key,value){for(let i=0;i<array.length;i++){if(array[i][key]===value){return i}}return-1}function getPowershell(){_powerShell="powershell.exe";if(_windows){const defaultPath=`${WINDIR}\\system32\\WindowsPowerShell\\v1.0\\powershell.exe`;if(fs14.existsSync(defaultPath)){_powerShell=defaultPath}}}function getWmic(){if(os7.type()==="Windows_NT"&&!wmicPath){wmicPath=WINDIR+"\\system32\\wbem\\wmic.exe";if(!fs14.existsSync(wmicPath)){try{const wmicPathArray=execSync("WHERE WMIC",execOptsWin).toString().split("\r\n");if(wmicPathArray&&wmicPathArray.length){wmicPath=wmicPathArray[0]}else{wmicPath="wmic"}}catch(e){wmicPath="wmic"}}}return wmicPath}function wmic(command){return new Promise(resolve=>{process.nextTick(()=>{try{powerShell(getWmic()+" "+command).then(stdout=>{resolve(stdout,"")})}catch(e){resolve("",e)}})})}function getVboxmanage(){return _windows?`"${process.env.VBOX_INSTALL_PATH||process.env.VBOX_MSI_INSTALL_PATH}\\VBoxManage.exe"`:"vboxmanage"}function powerShellProceedResults(data){let id="";let parts;let res="";if(data.indexOf(_psCmdStart)>=0){parts=data.split(_psCmdStart);const parts2=parts[1].split(_psIdSeperator);id=parts2[0];if(parts2.length>1){data=parts2.slice(1).join(_psIdSeperator)}}if(data.indexOf(_psCmdSeperator)>=0){parts=data.split(_psCmdSeperator);res=parts[0]}let remove2=-1;for(let i=0;i<_psCmds.length;i++){if(_psCmds[i].id===id){remove2=i;_psCmds[i].callback(res)}}if(remove2>=0){_psCmds.splice(remove2,1)}}function powerShellStart(){if(!_psChild){_psChild=spawn2(_powerShell,["-NoProfile","-NoLogo","-InputFormat","Text","-NoExit","-Command","-"],{stdio:"pipe",windowsHide:true,maxBuffer:1024*2e4,encoding:"UTF-8",env:Object.assign({},process.env,{LANG:"en_US.UTF-8"})});if(_psChild&&_psChild.pid){_psPersistent=true;_psChild.stdout.on("data",function(data){_psResult=_psResult+data.toString("utf8");if(data.indexOf(_psCmdSeperator)>=0){powerShellProceedResults(_psResult);_psResult=""}});_psChild.stderr.on("data",function(){powerShellProceedResults(_psResult+_psError)});_psChild.on("error",function(){powerShellProceedResults(_psResult+_psError)});_psChild.on("close",function(){if(_psChild){_psChild.kill()}})}}}function powerShellRelease(){try{if(_psChild){_psChild.stdin.write("exit"+os7.EOL);_psChild.stdin.end();_psPersistent=false}}catch(e){if(_psChild){_psChild.kill()}}_psChild=null}function powerShell(cmd){if(_psPersistent){const id=Math.random().toString(36).substring(2,12);return new Promise(resolve=>{process.nextTick(()=>{function callback(data){resolve(data)}_psCmds.push({id,cmd,callback,start:new Date});try{if(_psChild&&_psChild.pid){_psChild.stdin.write(_psToUTF8+"echo "+_psCmdStart+id+_psIdSeperator+"; "+os7.EOL+cmd+os7.EOL+"echo "+_psCmdSeperator+os7.EOL)}}catch(e){resolve("")}})})}else{let result2="";return new Promise(resolve=>{process.nextTick(()=>{try{const child=spawn2(_powerShell,["-NoProfile","-NoLogo","-InputFormat","Text","-NoExit","-ExecutionPolicy","Unrestricted","-Command","-"],{stdio:"pipe",windowsHide:true,maxBuffer:1024*2e4,encoding:"UTF-8",env:Object.assign({},process.env,{LANG:"en_US.UTF-8"})});if(child&&!child.pid){child.on("error",function(){resolve(result2)})}if(child&&child.pid){child.stdout.on("data",function(data){result2=result2+data.toString("utf8")});child.stderr.on("data",function(){child.kill();resolve(result2)});child.on("close",function(){child.kill();resolve(result2)});child.on("error",function(){child.kill();resolve(result2)});try{child.stdin.write(_psToUTF8+cmd+os7.EOL);child.stdin.write("exit"+os7.EOL);child.stdin.end()}catch(e){child.kill();resolve(result2)}}else{resolve(result2)}}catch(e){resolve(result2)}})})}}function execSafe(cmd,args2,options){let result2="";options=options||{};return new Promise(resolve=>{process.nextTick(()=>{try{const child=spawn2(cmd,args2,options);if(child&&!child.pid){child.on("error",function(){resolve(result2)})}if(child&&child.pid){child.stdout.on("data",function(data){result2+=data.toString()});child.on("close",function(){child.kill();resolve(result2)});child.on("error",function(){child.kill();resolve(result2)})}else{resolve(result2)}}catch(e){resolve(result2)}})})}function getCodepage(){if(_windows){if(!codepage){try{const stdout=execSync("chcp",execOptsWin);const lines=stdout.toString().split("\r\n");const parts=lines[0].split(":");codepage=parts.length>1?parts[1].replace(".","").trim():""}catch(err){codepage="437"}}return codepage}if(_linux||_darwin||_freebsd||_openbsd||_netbsd){if(!codepage){try{const stdout=execSync("echo $LANG",execOptsLinux);const lines=stdout.toString().split("\r\n");const parts=lines[0].split(".");codepage=parts.length>1?parts[1].trim():"";if(!codepage){codepage="UTF-8"}}catch(err){codepage="UTF-8"}}return codepage}}function smartMonToolsInstalled(){if(_smartMonToolsInstalled!==null){return _smartMonToolsInstalled}_smartMonToolsInstalled=false;if(_windows){try{const pathArray=execSync("WHERE smartctl 2>nul",execOptsWin).toString().split("\r\n");if(pathArray&&pathArray.length){_smartMonToolsInstalled=pathArray[0].indexOf(":\\")>=0}else{_smartMonToolsInstalled=false}}catch(e){_smartMonToolsInstalled=false}}if(_linux||_darwin||_freebsd||_openbsd||_netbsd){try{const pathArray=execSync("which smartctl 2>/dev/null",execOptsLinux).toString().split("\r\n");_smartMonToolsInstalled=pathArray.length>0}catch(e){util4.noop()}}return _smartMonToolsInstalled}function isRaspberry(){const PI_MODEL_NO=["BCM2708","BCM2709","BCM2710","BCM2711","BCM2712","BCM2835","BCM2836","BCM2837","BCM2837B0"];let cpuinfo=[];if(_rpi_cpuinfo!==null){cpuinfo=_rpi_cpuinfo}else{try{cpuinfo=fs14.readFileSync("/proc/cpuinfo",{encoding:"utf8"}).toString().split("\n");_rpi_cpuinfo=cpuinfo}catch(e){return false}}const hardware=getValue2(cpuinfo,"hardware");return hardware&&PI_MODEL_NO.indexOf(hardware)>-1}function isRaspbian(){let osrelease=[];try{osrelease=fs14.readFileSync("/etc/os-release",{encoding:"utf8"}).toString().split("\n")}catch(e){return false}const id=getValue2(osrelease,"id","=");return id&&id.indexOf("raspbian")>-1}function execWin(cmd,opts,callback){if(!callback){callback=opts;opts=execOptsWin}let newCmd="chcp 65001 > nul && cmd /C "+cmd+" && chcp "+codepage+" > nul";exec3(newCmd,opts,function(error,stdout){callback(error,stdout)})}function darwinXcodeExists(){const cmdLineToolsExists=fs14.existsSync("/Library/Developer/CommandLineTools/usr/bin/");const xcodeAppExists=fs14.existsSync("/Applications/Xcode.app/Contents/Developer/Tools");const xcodeExists=fs14.existsSync("/Library/Developer/Xcode/");return cmdLineToolsExists||xcodeExists||xcodeAppExists}function nanoSeconds(){const time=process.hrtime();if(!Array.isArray(time)||time.length!==2){return 0}return+time[0]*1e9+ +time[1]}function countUniqueLines(lines,startingWith){startingWith=startingWith||"";const uniqueLines=[];lines.forEach(line=>{if(line.startsWith(startingWith)){if(uniqueLines.indexOf(line)===-1){uniqueLines.push(line)}}});return uniqueLines.length}function countLines(lines,startingWith){startingWith=startingWith||"";const uniqueLines=[];lines.forEach(line=>{if(line.startsWith(startingWith)){uniqueLines.push(line)}});return uniqueLines.length}function sanitizeShellString(str2,strict){if(typeof strict==="undefined"){strict=false}const s=str2||"";let result2="";const l=mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(!(s[i]===void 0||s[i]===">"||s[i]==="<"||s[i]==="*"||s[i]==="?"||s[i]==="["||s[i]==="]"||s[i]==="|"||s[i]==="˚"||s[i]==="$"||s[i]===";"||s[i]==="&"||s[i]==="]"||s[i]==="#"||s[i]==="\\"||s[i]==="	"||s[i]==="\n"||s[i]==="\r"||s[i]==="'"||s[i]==="`"||s[i]==='"'||s[i].length>1||strict&&s[i]==="("||strict&&s[i]===")"||strict&&s[i]==="@"||strict&&s[i]===" "||strict&&s[i]=="{"||strict&&s[i]==";"||strict&&s[i]=="}")){result2=result2+s[i]}}return result2}function isPrototypePolluted(){const s="1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";let notPolluted=true;let st="";try{st.__proto__.replace=stringReplace;st.__proto__.toLowerCase=stringToLower;st.__proto__.toString=stringToString;st.__proto__.substr=stringSubstr;st.__proto__.substring=stringSubstring;st.__proto__.trim=stringTrim;st.__proto__.startsWith=stringStartWith}catch(e){Object.setPrototypeOf(st,stringObj)}notPolluted=notPolluted||s.length!==62;const ms=Date.now();if(typeof ms==="number"&&ms>16e11){const l=ms%100+15;for(let i=0;i<l;i++){const r=Math.random()*61.99999999+1;const rs=parseInt(Math.floor(r).toString(),10);const rs2=parseInt(r.toString().split(".")[0],10);const q=Math.random()*61.99999999+1;const qs=parseInt(Math.floor(q).toString(),10);const qs2=parseInt(q.toString().split(".")[0],10);notPolluted=notPolluted&&r!==q;notPolluted=notPolluted&&rs===rs2&&qs===qs2;st+=s[rs-1]}notPolluted=notPolluted&&st.length===l;let p=Math.random()*l*.9999999999;let stm=st.substr(0,p)+" "+st.substr(p,2e3);try{stm.__proto__.replace=stringReplace}catch(e){Object.setPrototypeOf(stm,stringObj)}let sto=stm.replace(/ /g,"");notPolluted=notPolluted&&st===sto;p=Math.random()*l*.9999999999;stm=st.substr(0,p)+"{"+st.substr(p,2e3);sto=stm.replace(/{/g,"");notPolluted=notPolluted&&st===sto;p=Math.random()*l*.9999999999;stm=st.substr(0,p)+"*"+st.substr(p,2e3);sto=stm.replace(/\*/g,"");notPolluted=notPolluted&&st===sto;p=Math.random()*l*.9999999999;stm=st.substr(0,p)+"$"+st.substr(p,2e3);sto=stm.replace(/\$/g,"");notPolluted=notPolluted&&st===sto;const stl=st.toLowerCase();notPolluted=notPolluted&&stl.length===l&&stl[l-1]&&!stl[l];for(let i=0;i<l;i++){const s1=st[i];try{s1.__proto__.toLowerCase=stringToLower}catch(e){Object.setPrototypeOf(st,stringObj)}const s2=stl?stl[i]:"";const s1l=s1.toLowerCase();notPolluted=notPolluted&&s1l[0]===s2&&s1l[0]&&!s1l[1]}}return!notPolluted}function hex2bin(hex){return("00000000"+parseInt(hex,16).toString(2)).substr(-8)}function getFilesInPath(source){const lstatSync=fs14.lstatSync;const readdirSync=fs14.readdirSync;const join4=path27.join;function isDirectory(source2){return lstatSync(source2).isDirectory()}function isFile2(source2){return lstatSync(source2).isFile()}function getDirectories2(source2){return readdirSync(source2).map(function(name){return join4(source2,name)}).filter(isDirectory)}function getFiles(source2){return readdirSync(source2).map(function(name){return join4(source2,name)}).filter(isFile2)}function getFilesRecursively(source2){try{let dirs=getDirectories2(source2);let files=dirs.map(function(dir){return getFilesRecursively(dir)}).reduce(function(a,b){return a.concat(b)},[]);return files.concat(getFiles(source2))}catch(e){return[]}}if(fs14.existsSync(source)){return getFilesRecursively(source)}else{return[]}}function decodePiCpuinfo(lines){if(_rpi_cpuinfo===null){_rpi_cpuinfo=lines}const oldRevisionCodes={"0002":{type:"B",revision:"1.0",memory:256,manufacturer:"Egoman",processor:"BCM2835"},"0003":{type:"B",revision:"1.0",memory:256,manufacturer:"Egoman",processor:"BCM2835"},"0004":{type:"B",revision:"2.0",memory:256,manufacturer:"Sony UK",processor:"BCM2835"},"0005":{type:"B",revision:"2.0",memory:256,manufacturer:"Qisda",processor:"BCM2835"},"0006":{type:"B",revision:"2.0",memory:256,manufacturer:"Egoman",processor:"BCM2835"},"0007":{type:"A",revision:"2.0",memory:256,manufacturer:"Egoman",processor:"BCM2835"},"0008":{type:"A",revision:"2.0",memory:256,manufacturer:"Sony UK",processor:"BCM2835"},"0009":{type:"A",revision:"2.0",memory:256,manufacturer:"Qisda",processor:"BCM2835"},"000d":{type:"B",revision:"2.0",memory:512,manufacturer:"Egoman",processor:"BCM2835"},"000e":{type:"B",revision:"2.0",memory:512,manufacturer:"Sony UK",processor:"BCM2835"},"000f":{type:"B",revision:"2.0",memory:512,manufacturer:"Egoman",processor:"BCM2835"},"0010":{type:"B+",revision:"1.2",memory:512,manufacturer:"Sony UK",processor:"BCM2835"},"0011":{type:"CM1",revision:"1.0",memory:512,manufacturer:"Sony UK",processor:"BCM2835"},"0012":{type:"A+",revision:"1.1",memory:256,manufacturer:"Sony UK",processor:"BCM2835"},"0013":{type:"B+",revision:"1.2",memory:512,manufacturer:"Embest",processor:"BCM2835"},"0014":{type:"CM1",revision:"1.0",memory:512,manufacturer:"Embest",processor:"BCM2835"},"0015":{type:"A+",revision:"1.1",memory:256,manufacturer:"512MB	Embest",processor:"BCM2835"}};const processorList=["BCM2835","BCM2836","BCM2837","BCM2711","BCM2712"];const manufacturerList=["Sony UK","Egoman","Embest","Sony Japan","Embest","Stadium"];const typeList={"00":"A","01":"B","02":"A+","03":"B+","04":"2B","05":"Alpha (early prototype)","06":"CM1","08":"3B","09":"Zero","0a":"CM3","0c":"Zero W","0d":"3B+","0e":"3A+","0f":"Internal use only","10":"CM3+","11":"4B","12":"Zero 2 W","13":"400","14":"CM4","15":"CM4S","16":"Internal use only","17":"5","18":"CM5","19":"500","1a":"CM5 Lite"};const revisionCode=getValue2(lines,"revision",":",true);const model=getValue2(lines,"model:",":",true);const serial=getValue2(lines,"serial",":",true);let result2={};if({}.hasOwnProperty.call(oldRevisionCodes,revisionCode)){result2={model,serial,revisionCode,memory:oldRevisionCodes[revisionCode].memory,manufacturer:oldRevisionCodes[revisionCode].manufacturer,processor:oldRevisionCodes[revisionCode].processor,type:oldRevisionCodes[revisionCode].type,revision:oldRevisionCodes[revisionCode].revision}}else{const revision=("00000000"+getValue2(lines,"revision",":",true).toLowerCase()).substr(-8);const memSizeCode=parseInt(hex2bin(revision.substr(2,1)).substr(5,3),2)||0;const manufacturer=manufacturerList[parseInt(revision.substr(3,1),10)];const processor=processorList[parseInt(revision.substr(4,1),10)];const typeCode=revision.substr(5,2);result2={model,serial,revisionCode,memory:256*Math.pow(2,memSizeCode),manufacturer,processor,type:{}.hasOwnProperty.call(typeList,typeCode)?typeList[typeCode]:"",revision:"1."+revision.substr(7,1)}}return result2}function getRpiGpu(){let cpuinfo=null;if(_rpi_cpuinfo!==null){cpuinfo=_rpi_cpuinfo}else{try{cpuinfo=fs14.readFileSync("/proc/cpuinfo",{encoding:"utf8"}).toString().split("\n");_rpi_cpuinfo=cpuinfo}catch(e){return false}}const rpi=decodePiCpuinfo(cpuinfo);if(rpi.type==="4B"||rpi.type==="CM4"||rpi.type==="CM4S"||rpi.type==="400"){return"VideoCore VI"}if(rpi.type==="5"){return"VideoCore VII"}return"VideoCore IV"}function promiseAll(promises){const resolvingPromises=promises.map(function(promise){return new Promise(function(resolve){let payload=new Array(2);promise.then(function(result2){payload[0]=result2}).catch(function(error){payload[1]=error}).then(function(){resolve(payload)})})});const errors2=[];const results=[];return Promise.all(resolvingPromises).then(function(items){items.forEach(function(payload){if(payload[1]){errors2.push(payload[1]);results.push(null)}else{errors2.push(null);results.push(payload[0])}});return{errors:errors2,results}})}function promisify9(nodeStyleFunction){return function(){const args2=Array.prototype.slice.call(arguments);return new Promise(function(resolve,reject2){args2.push(function(err,data){if(err){reject2(err)}else{resolve(data)}});nodeStyleFunction.apply(null,args2)})}}function promisifySave(nodeStyleFunction){return function(){const args2=Array.prototype.slice.call(arguments);return new Promise(function(resolve){args2.push(function(err,data){resolve(data)});nodeStyleFunction.apply(null,args2)})}}function linuxVersion(){let result2="";if(_linux){try{result2=execSync("uname -v",execOptsLinux).toString()}catch(e){result2=""}}return result2}function plistParser(xmlStr){const tags=["array","dict","key","string","integer","date","real","data","boolean","arrayEmpty"];const startStr="<plist version";let pos=xmlStr.indexOf(startStr);let len=xmlStr.length;while(xmlStr[pos]!==">"&&pos<len){pos++}let depth=0;let inTagStart=false;let inTagContent=false;let inTagEnd=false;let metaData=[{tagStart:"",tagEnd:"",tagContent:"",key:"",data:null}];let c="";let cn=xmlStr[pos];while(pos<len){c=cn;if(pos+1<len){cn=xmlStr[pos+1]}if(c==="<"){inTagContent=false;if(cn==="/"){inTagEnd=true}else if(metaData[depth].tagStart){metaData[depth].tagContent="";if(!metaData[depth].data){metaData[depth].data=metaData[depth].tagStart==="array"?[]:{}}depth++;metaData.push({tagStart:"",tagEnd:"",tagContent:"",key:null,data:null});inTagStart=true;inTagContent=false}else if(!inTagStart){inTagStart=true}}else if(c===">"){if(metaData[depth].tagStart==="true/"){inTagStart=false;inTagEnd=true;metaData[depth].tagStart="";metaData[depth].tagEnd="/boolean";metaData[depth].data=true}if(metaData[depth].tagStart==="false/"){inTagStart=false;inTagEnd=true;metaData[depth].tagStart="";metaData[depth].tagEnd="/boolean";metaData[depth].data=false}if(metaData[depth].tagStart==="array/"){inTagStart=false;inTagEnd=true;metaData[depth].tagStart="";metaData[depth].tagEnd="/arrayEmpty";metaData[depth].data=[]}if(inTagContent){inTagContent=false}if(inTagStart){inTagStart=false;inTagContent=true;if(metaData[depth].tagStart==="array"){metaData[depth].data=[]}if(metaData[depth].tagStart==="dict"){metaData[depth].data={}}}if(inTagEnd){inTagEnd=false;if(metaData[depth].tagEnd&&tags.indexOf(metaData[depth].tagEnd.substr(1))>=0){if(metaData[depth].tagEnd==="/dict"||metaData[depth].tagEnd==="/array"){if(depth>1&&metaData[depth-2].tagStart==="array"){metaData[depth-2].data.push(metaData[depth-1].data)}if(depth>1&&metaData[depth-2].tagStart==="dict"){metaData[depth-2].data[metaData[depth-1].key]=metaData[depth-1].data}depth--;metaData.pop();metaData[depth].tagContent="";metaData[depth].tagStart="";metaData[depth].tagEnd=""}else{if(metaData[depth].tagEnd==="/key"&&metaData[depth].tagContent){metaData[depth].key=metaData[depth].tagContent}else{if(metaData[depth].tagEnd==="/real"&&metaData[depth].tagContent){metaData[depth].data=parseFloat(metaData[depth].tagContent)||0}if(metaData[depth].tagEnd==="/integer"&&metaData[depth].tagContent){metaData[depth].data=parseInt(metaData[depth].tagContent)||0}if(metaData[depth].tagEnd==="/string"&&metaData[depth].tagContent){metaData[depth].data=metaData[depth].tagContent||""}if(metaData[depth].tagEnd==="/boolean"){metaData[depth].data=metaData[depth].tagContent||false}if(metaData[depth].tagEnd==="/arrayEmpty"){metaData[depth].data=metaData[depth].tagContent||[]}if(depth>0&&metaData[depth-1].tagStart==="array"){metaData[depth-1].data.push(metaData[depth].data)}if(depth>0&&metaData[depth-1].tagStart==="dict"){metaData[depth-1].data[metaData[depth].key]=metaData[depth].data}}metaData[depth].tagContent="";metaData[depth].tagStart="";metaData[depth].tagEnd=""}}metaData[depth].tagEnd="";inTagStart=false;inTagContent=false}}else{if(inTagStart){metaData[depth].tagStart+=c}if(inTagEnd){metaData[depth].tagEnd+=c}if(inTagContent){metaData[depth].tagContent+=c}}pos++}return metaData[0].data}function strIsNumeric(str2){return typeof str2==="string"&&!isNaN(str2)&&!isNaN(parseFloat(str2))}function plistReader(output){const lines=output.split("\n");for(let i=0;i<lines.length;i++){if(lines[i].indexOf(" = ")>=0){const lineParts=lines[i].split(" = ");lineParts[0]=lineParts[0].trim();if(!lineParts[0].startsWith('"')){lineParts[0]='"'+lineParts[0]+'"'}lineParts[1]=lineParts[1].trim();if(lineParts[1].indexOf('"')===-1&&lineParts[1].endsWith(";")){const valueString=lineParts[1].substring(0,lineParts[1].length-1);if(!strIsNumeric(valueString)){lineParts[1]=`"${valueString}";`}}if(lineParts[1].indexOf('"')>=0&&lineParts[1].endsWith(";")){const valueString=lineParts[1].substring(0,lineParts[1].length-1).replace(/"/g,"");if(strIsNumeric(valueString)){lineParts[1]=`${valueString};`}}lines[i]=lineParts.join(" : ")}lines[i]=lines[i].replace(/\(/g,"[").replace(/\)/g,"]").replace(/;/g,",").trim();if(lines[i].startsWith("}")&&lines[i-1]&&lines[i-1].endsWith(",")){lines[i-1]=lines[i-1].substring(0,lines[i-1].length-1)}}output=lines.join("");let obj={};try{obj=JSON.parse(output)}catch(e){noop4()}return obj}function semverCompare(v1,v2){let res=0;const parts1=v1.split(".");const parts2=v2.split(".");if(parts1[0]<parts2[0]){res=1}else if(parts1[0]>parts2[0]){res=-1}else if(parts1[0]===parts2[0]&&parts1.length>=2&&parts2.length>=2){if(parts1[1]<parts2[1]){res=1}else if(parts1[1]>parts2[1]){res=-1}else if(parts1[1]===parts2[1]){if(parts1.length>=3&&parts2.length>=3){if(parts1[2]<parts2[2]){res=1}else if(parts1[2]>parts2[2]){res=-1}}else if(parts2.length>=3){res=1}}}return res}function getAppleModel(key){const appleModelIds=[{key:"Mac15,12",name:"MacBook Air",size:"13-inch",processor:"M3",year:"2024",additional:""},{key:"Mac14,15",name:"MacBook Air",size:"15-inch",processor:"M2",year:"2024",additional:""},{key:"Mac14,2",name:"MacBook Air",size:"13-inch",processor:"M2",year:"2022",additional:""},{key:"MacBookAir10,1",name:"MacBook Air",size:"13-inch",processor:"M1",year:"2020",additional:""},{key:"MacBookAir9,1",name:"MacBook Air",size:"13-inch",processor:"",year:"2020",additional:""},{key:"MacBookAir8,2",name:"MacBook Air",size:"13-inch",processor:"",year:"2019",additional:""},{key:"MacBookAir8,1",name:"MacBook Air",size:"13-inch",processor:"",year:"2018",additional:""},{key:"MacBookAir7,2",name:"MacBook Air",size:"13-inch",processor:"",year:"2017",additional:""},{key:"MacBookAir7,2",name:"MacBook Air",size:"13-inch",processor:"",year:"Early 2015",additional:""},{key:"MacBookAir7,1",name:"MacBook Air",size:"11-inch",processor:"",year:"Early 2015",additional:""},{key:"MacBookAir6,2",name:"MacBook Air",size:"13-inch",processor:"",year:"Early 2014",additional:""},{key:"MacBookAir6,1",name:"MacBook Air",size:"11-inch",processor:"",year:"Early 2014",additional:""},{key:"MacBookAir6,2",name:"MacBook Air",size:"13-inch",processor:"",year:"Mid 2013",additional:""},{key:"MacBookAir6,1",name:"MacBook Air",size:"11-inch",processor:"",year:"Mid 2013",additional:""},{key:"MacBookAir5,2",name:"MacBook Air",size:"13-inch",processor:"",year:"Mid 2012",additional:""},{key:"MacBookAir5,1",name:"MacBook Air",size:"11-inch",processor:"",year:"Mid 2012",additional:""},{key:"MacBookAir4,2",name:"MacBook Air",size:"13-inch",processor:"",year:"Mid 2011",additional:""},{key:"MacBookAir4,1",name:"MacBook Air",size:"11-inch",processor:"",year:"Mid 2011",additional:""},{key:"MacBookAir3,2",name:"MacBook Air",size:"13-inch",processor:"",year:"Late 2010",additional:""},{key:"MacBookAir3,1",name:"MacBook Air",size:"11-inch",processor:"",year:"Late 2010",additional:""},{key:"MacBookAir2,1",name:"MacBook Air",size:"13-inch",processor:"",year:"Mid 2009",additional:""},{key:"Mac16,1",name:"MacBook Pro",size:"14-inch",processor:"M4",year:"2024",additional:""},{key:"Mac16,6",name:"MacBook Pro",size:"14-inch",processor:"M4 Pro",year:"2024",additional:""},{key:"Mac16,8",name:"MacBook Pro",size:"14-inch",processor:"M4 Max",year:"2024",additional:""},{key:"Mac16,5",name:"MacBook Pro",size:"16-inch",processor:"M4 Pro",year:"2024",additional:""},{key:"Mac16,6",name:"MacBook Pro",size:"16-inch",processor:"M4 Max",year:"2024",additional:""},{key:"Mac15,3",name:"MacBook Pro",size:"14-inch",processor:"M3",year:"Nov 2023",additional:""},{key:"Mac15,6",name:"MacBook Pro",size:"14-inch",processor:"M3 Pro",year:"Nov 2023",additional:""},{key:"Mac15,8",name:"MacBook Pro",size:"14-inch",processor:"M3 Pro",year:"Nov 2023",additional:""},{key:"Mac15,10",name:"MacBook Pro",size:"14-inch",processor:"M3 Max",year:"Nov 2023",additional:""},{key:"Mac15,7",name:"MacBook Pro",size:"16-inch",processor:"M3 Pro",year:"Nov 2023",additional:""},{key:"Mac15,9",name:"MacBook Pro",size:"16-inch",processor:"M3 Pro",year:"Nov 2023",additional:""},{key:"Mac15,11",name:"MacBook Pro",size:"16-inch",processor:"M3 Max",year:"Nov 2023",additional:""},{key:"Mac14,5",name:"MacBook Pro",size:"14-inch",processor:"M2 Max",year:"2023",additional:""},{key:"Mac14,9",name:"MacBook Pro",size:"14-inch",processor:"M2 Max",year:"2023",additional:""},{key:"Mac14,6",name:"MacBook Pro",size:"16-inch",processor:"M2 Max",year:"2023",additional:""},{key:"Mac14,10",name:"MacBook Pro",size:"16-inch",processor:"M2 Max",year:"2023",additional:""},{key:"Mac14,7",name:"MacBook Pro",size:"13-inch",processor:"M2",year:"2022",additional:""},{key:"MacBookPro18,3",name:"MacBook Pro",size:"14-inch",processor:"M1 Pro",year:"2021",additional:""},{key:"MacBookPro18,4",name:"MacBook Pro",size:"14-inch",processor:"M1 Max",year:"2021",additional:""},{key:"MacBookPro18,1",name:"MacBook Pro",size:"16-inch",processor:"M1 Pro",year:"2021",additional:""},{key:"MacBookPro18,2",name:"MacBook Pro",size:"16-inch",processor:"M1 Max",year:"2021",additional:""},{key:"MacBookPro17,1",name:"MacBook Pro",size:"13-inch",processor:"M1",year:"2020",additional:""},{key:"MacBookPro16,3",name:"MacBook Pro",size:"13-inch",processor:"",year:"2020",additional:"Two Thunderbolt 3 ports"},{key:"MacBookPro16,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"2020",additional:"Four Thunderbolt 3 ports"},{key:"MacBookPro16,1",name:"MacBook Pro",size:"16-inch",processor:"",year:"2019",additional:""},{key:"MacBookPro16,4",name:"MacBook Pro",size:"16-inch",processor:"",year:"2019",additional:""},{key:"MacBookPro15,3",name:"MacBook Pro",size:"15-inch",processor:"",year:"2019",additional:""},{key:"MacBookPro15,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"2019",additional:""},{key:"MacBookPro15,1",name:"MacBook Pro",size:"15-inch",processor:"",year:"2019",additional:""},{key:"MacBookPro15,4",name:"MacBook Pro",size:"13-inch",processor:"",year:"2019",additional:"Two Thunderbolt 3 ports"},{key:"MacBookPro15,1",name:"MacBook Pro",size:"15-inch",processor:"",year:"2018",additional:""},{key:"MacBookPro15,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"2018",additional:"Four Thunderbolt 3 ports"},{key:"MacBookPro14,1",name:"MacBook Pro",size:"13-inch",processor:"",year:"2017",additional:"Two Thunderbolt 3 ports"},{key:"MacBookPro14,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"2017",additional:"Four Thunderbolt 3 ports"},{key:"MacBookPro14,3",name:"MacBook Pro",size:"15-inch",processor:"",year:"2017",additional:""},{key:"MacBookPro13,1",name:"MacBook Pro",size:"13-inch",processor:"",year:"2016",additional:"Two Thunderbolt 3 ports"},{key:"MacBookPro13,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"2016",additional:"Four Thunderbolt 3 ports"},{key:"MacBookPro13,3",name:"MacBook Pro",size:"15-inch",processor:"",year:"2016",additional:""},{key:"MacBookPro11,4",name:"MacBook Pro",size:"15-inch",processor:"",year:"Mid 2015",additional:""},{key:"MacBookPro11,5",name:"MacBook Pro",size:"15-inch",processor:"",year:"Mid 2015",additional:""},{key:"MacBookPro12,1",name:"MacBook Pro",size:"13-inch",processor:"",year:"Early 2015",additional:""},{key:"MacBookPro11,2",name:"MacBook Pro",size:"15-inch",processor:"",year:"Late 2013",additional:""},{key:"MacBookPro11,3",name:"MacBook Pro",size:"15-inch",processor:"",year:"Late 2013",additional:""},{key:"MacBookPro11,1",name:"MacBook Pro",size:"13-inch",processor:"",year:"Late 2013",additional:""},{key:"MacBookPro10,1",name:"MacBook Pro",size:"15-inch",processor:"",year:"Mid 2012",additional:""},{key:"MacBookPro10,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"Late 2012",additional:""},{key:"MacBookPro9,1",name:"MacBook Pro",size:"15-inch",processor:"",year:"Mid 2012",additional:""},{key:"MacBookPro9,2",name:"MacBook Pro",size:"13-inch",processor:"",year:"Mid 2012",additional:""},{key:"MacBookPro8,3",name:"MacBook Pro",size:"17-inch",processor:"",year:"Early 2011",additional:""},{key:"MacBookPro8,2",name:"MacBook Pro",size:"15-inch",processor:"",year:"Early 2011",additional:""},{key:"MacBookPro8,1",name:"MacBook Pro",size:"13-inch",processor:"",year:"Early 2011",additional:""},{key:"MacBookPro6,1",name:"MacBook Pro",size:"17-inch",processor:"",year:"Mid 2010",additional:""},{key:"MacBookPro6,2",name:"MacBook Pro",size:"15-inch",processor:"",year:"Mid 2010",additional:""},{key:"MacBookPro7,1",name:"MacBook Pro",size:"13-inch",processor:"",year:"Mid 2010",additional:""},{key:"MacBookPro5,2",name:"MacBook Pro",size:"17-inch",processor:"",year:"Early 2009",additional:""},{key:"MacBookPro5,3",name:"MacBook Pro",size:"15-inch",processor:"",year:"Mid 2009",additional:""},{key:"MacBookPro5,5",name:"MacBook Pro",size:"13-inch",processor:"",year:"Mid 2009",additional:""},{key:"MacBookPro5,1",name:"MacBook Pro",size:"15-inch",processor:"",year:"Late 2008",additional:""},{key:"MacBookPro4,1",name:"MacBook Pro",size:"15-inch",processor:"",year:"Early 2008",additional:""},{key:"MacBook10,1",name:"MacBook",size:"12-inch",processor:"",year:"2017",additional:""},{key:"MacBook9,1",name:"MacBook",size:"12-inch",processor:"",year:"Early 2016",additional:""},{key:"MacBook8,1",name:"MacBook",size:"12-inch",processor:"",year:"Early 2015",additional:""},{key:"MacBook7,1",name:"MacBook",size:"13-inch",processor:"",year:"Mid 2010",additional:""},{key:"MacBook6,1",name:"MacBook",size:"13-inch",processor:"",year:"Late 2009",additional:""},{key:"MacBook5,2",name:"MacBook",size:"13-inch",processor:"",year:"Early 2009",additional:""},{key:"Mac14,13",name:"Mac Studio",size:"",processor:"",year:"2023",additional:""},{key:"Mac14,14",name:"Mac Studio",size:"",processor:"",year:"2023",additional:""},{key:"Mac13,1",name:"Mac Studio",size:"",processor:"",year:"2022",additional:""},{key:"Mac13,2",name:"Mac Studio",size:"",processor:"",year:"2022",additional:""},{key:"Mac16,11",name:"Mac mini",size:"",processor:"M4 Pro",year:"2024",additional:""},{key:"Mac16,10",name:"Mac mini",size:"",processor:"M4",year:"2024",additional:""},{key:"Mac14,3",name:"Mac mini",size:"",processor:"M2",year:"2023",additional:""},{key:"Mac14,12",name:"Mac mini",size:"",processor:"M2 Pro",year:"2023",additional:""},{key:"Macmini9,1",name:"Mac mini",size:"",processor:"M1",year:"2020",additional:""},{key:"Macmini8,1",name:"Mac mini",size:"",processor:"",year:"Late 2018",additional:""},{key:"Macmini7,1",name:"Mac mini",size:"",processor:"",year:"Late 2014",additional:""},{key:"Macmini6,1",name:"Mac mini",size:"",processor:"",year:"Late 2012",additional:""},{key:"Macmini6,2",name:"Mac mini",size:"",processor:"",year:"Late 2012",additional:""},{key:"Macmini5,1",name:"Mac mini",size:"",processor:"",year:"Mid 2011",additional:""},{key:"Macmini5,2",name:"Mac mini",size:"",processor:"",year:"Mid 2011",additional:""},{key:"Macmini4,1",name:"Mac mini",size:"",processor:"",year:"Mid 2010",additional:""},{key:"Macmini3,1",name:"Mac mini",size:"",processor:"",year:"Early 2009",additional:""},{key:"Mac16,3",name:"iMac",size:"24-inch",processor:"M4",year:"2024",additional:"Four ports"},{key:"Mac16,2",name:"iMac",size:"24-inch",processor:"M4",year:"2024",additional:"Two ports"},{key:"Mac15,5",name:"iMac",size:"24-inch",processor:"M3",year:"2023",additional:"Four ports"},{key:"Mac15,4",name:"iMac",size:"24-inch",processor:"M3",year:"2023",additional:"Two ports"},{key:"iMac21,1",name:"iMac",size:"24-inch",processor:"M1",year:"2021",additional:""},{key:"iMac21,2",name:"iMac",size:"24-inch",processor:"M1",year:"2021",additional:""},{key:"iMac20,1",name:"iMac",size:"27-inch",processor:"",year:"2020",additional:"Retina 5K"},{key:"iMac20,2",name:"iMac",size:"27-inch",processor:"",year:"2020",additional:"Retina 5K"},{key:"iMac19,1",name:"iMac",size:"27-inch",processor:"",year:"2019",additional:"Retina 5K"},{key:"iMac19,2",name:"iMac",size:"21.5-inch",processor:"",year:"2019",additional:"Retina 4K"},{key:"iMacPro1,1",name:"iMac Pro",size:"",processor:"",year:"2017",additional:""},{key:"iMac18,3",name:"iMac",size:"27-inch",processor:"",year:"2017",additional:"Retina 5K"},{key:"iMac18,2",name:"iMac",size:"21.5-inch",processor:"",year:"2017",additional:"Retina 4K"},{key:"iMac18,1",name:"iMac",size:"21.5-inch",processor:"",year:"2017",additional:""},{key:"iMac17,1",name:"iMac",size:"27-inch",processor:"",year:"Late 2015",additional:"Retina 5K"},{key:"iMac16,2",name:"iMac",size:"21.5-inch",processor:"",year:"Late 2015",additional:"Retina 4K"},{key:"iMac16,1",name:"iMac",size:"21.5-inch",processor:"",year:"Late 2015",additional:""},{key:"iMac15,1",name:"iMac",size:"27-inch",processor:"",year:"Late 2014",additional:"Retina 5K"},{key:"iMac14,4",name:"iMac",size:"21.5-inch",processor:"",year:"Mid 2014",additional:""},{key:"iMac14,2",name:"iMac",size:"27-inch",processor:"",year:"Late 2013",additional:""},{key:"iMac14,1",name:"iMac",size:"21.5-inch",processor:"",year:"Late 2013",additional:""},{key:"iMac13,2",name:"iMac",size:"27-inch",processor:"",year:"Late 2012",additional:""},{key:"iMac13,1",name:"iMac",size:"21.5-inch",processor:"",year:"Late 2012",additional:""},{key:"iMac12,2",name:"iMac",size:"27-inch",processor:"",year:"Mid 2011",additional:""},{key:"iMac12,1",name:"iMac",size:"21.5-inch",processor:"",year:"Mid 2011",additional:""},{key:"iMac11,3",name:"iMac",size:"27-inch",processor:"",year:"Mid 2010",additional:""},{key:"iMac11,2",name:"iMac",size:"21.5-inch",processor:"",year:"Mid 2010",additional:""},{key:"iMac10,1",name:"iMac",size:"21.5-inch",processor:"",year:"Late 2009",additional:""},{key:"iMac9,1",name:"iMac",size:"20-inch",processor:"",year:"Early 2009",additional:""},{key:"Mac14,8",name:"Mac Pro",size:"",processor:"",year:"2023",additional:""},{key:"Mac14,8",name:"Mac Pro",size:"",processor:"",year:"2023",additional:"Rack"},{key:"MacPro7,1",name:"Mac Pro",size:"",processor:"",year:"2019",additional:""},{key:"MacPro7,1",name:"Mac Pro",size:"",processor:"",year:"2019",additional:"Rack"},{key:"MacPro6,1",name:"Mac Pro",size:"",processor:"",year:"Late 2013",additional:""},{key:"MacPro5,1",name:"Mac Pro",size:"",processor:"",year:"Mid 2012",additional:""},{key:"MacPro5,1",name:"Mac Pro Server",size:"",processor:"",year:"Mid 2012",additional:"Server"},{key:"MacPro5,1",name:"Mac Pro",size:"",processor:"",year:"Mid 2010",additional:""},{key:"MacPro5,1",name:"Mac Pro Server",size:"",processor:"",year:"Mid 2010",additional:"Server"},{key:"MacPro4,1",name:"Mac Pro",size:"",processor:"",year:"Early 2009",additional:""}];const list=appleModelIds.filter(model=>model.key===key);if(list.length===0){return{key,model:"Apple",version:"Unknown"}}const features=[];if(list[0].size){features.push(list[0].size)}if(list[0].processor){features.push(list[0].processor)}if(list[0].year){features.push(list[0].year)}if(list[0].additional){features.push(list[0].additional)}return{key,model:list[0].name,version:list[0].name+" ("+features.join(", ")+")"}}function checkWebsite(url,timeout=5e3){const http3=url.startsWith("https:")||url.indexOf(":443/")>0||url.indexOf(":8443/")>0?require("https"):require("http");const t=Date.now();return new Promise(resolve=>{const request=http3.get(url,function(res){res.on("data",()=>{});res.on("end",()=>{resolve({url,statusCode:res.statusCode,message:res.statusMessage,time:Date.now()-t})})}).on("error",function(e){resolve({url,statusCode:404,message:e.message,time:Date.now()-t})}).setTimeout(timeout,()=>{request.close();resolve({url,statusCode:408,message:"Request Timeout",time:Date.now()-t})})})}function cleanString(str2){return str2.replace(/To Be Filled By O.E.M./g,"")}function noop4(){}exports2.toInt=toInt;exports2.splitByNumber=splitByNumber;exports2.execOptsWin=execOptsWin;exports2.execOptsLinux=execOptsLinux;exports2.getCodepage=getCodepage;exports2.execWin=execWin;exports2.isFunction=isFunction3;exports2.unique=unique;exports2.sortByKey=sortByKey;exports2.cores=cores;exports2.getValue=getValue2;exports2.decodeEscapeSequence=decodeEscapeSequence;exports2.parseDateTime=parseDateTime;exports2.parseHead=parseHead;exports2.findObjectByKey=findObjectByKey;exports2.getWmic=getWmic;exports2.wmic=wmic;exports2.darwinXcodeExists=darwinXcodeExists;exports2.getVboxmanage=getVboxmanage;exports2.powerShell=powerShell;exports2.powerShellStart=powerShellStart;exports2.powerShellRelease=powerShellRelease;exports2.execSafe=execSafe;exports2.nanoSeconds=nanoSeconds;exports2.countUniqueLines=countUniqueLines;exports2.countLines=countLines;exports2.noop=noop4;exports2.isRaspberry=isRaspberry;exports2.isRaspbian=isRaspbian;exports2.sanitizeShellString=sanitizeShellString;exports2.isPrototypePolluted=isPrototypePolluted;exports2.decodePiCpuinfo=decodePiCpuinfo;exports2.getRpiGpu=getRpiGpu;exports2.promiseAll=promiseAll;exports2.promisify=promisify9;exports2.promisifySave=promisifySave;exports2.smartMonToolsInstalled=smartMonToolsInstalled;exports2.linuxVersion=linuxVersion;exports2.plistParser=plistParser;exports2.plistReader=plistReader;exports2.stringObj=stringObj;exports2.stringReplace=stringReplace;exports2.stringToLower=stringToLower;exports2.stringToString=stringToString;exports2.stringSubstr=stringSubstr;exports2.stringSubstring=stringSubstring;exports2.stringTrim=stringTrim;exports2.stringStartWith=stringStartWith;exports2.mathMin=mathMin;exports2.WINDIR=WINDIR;exports2.getFilesInPath=getFilesInPath;exports2.semverCompare=semverCompare;exports2.getAppleModel=getAppleModel;exports2.checkWebsite=checkWebsite;exports2.cleanString=cleanString;exports2.getPowershell=getPowershell}});var require_system=__commonJS({"node_modules/systeminformation/lib/system.js"(exports2){"use strict";var fs14=require("fs");var os7=require("os");var util4=require_util2();var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var execPromise=util4.promisify(require("child_process").exec);var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function system(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={manufacturer:"",model:"Computer",version:"",serial:"-",uuid:"-",sku:"-",virtual:false};if(_linux||_freebsd||_openbsd||_netbsd){exec3("export LC_ALL=C; dmidecode -t system 2>/dev/null; unset LC_ALL",function(error,stdout){let lines=stdout.toString().split("\n");result2.manufacturer=cleanDefaults(util4.getValue(lines,"manufacturer"));result2.model=cleanDefaults(util4.getValue(lines,"product name"));result2.version=cleanDefaults(util4.getValue(lines,"version"));result2.serial=cleanDefaults(util4.getValue(lines,"serial number"));result2.uuid=cleanDefaults(util4.getValue(lines,"uuid")).toLowerCase();result2.sku=cleanDefaults(util4.getValue(lines,"sku number"));const cmd=`echo -n "product_name: "; cat /sys/devices/virtual/dmi/id/product_name 2>/dev/null; echo;
            echo -n "product_serial: "; cat /sys/devices/virtual/dmi/id/product_serial 2>/dev/null; echo;
            echo -n "product_uuid: "; cat /sys/devices/virtual/dmi/id/product_uuid 2>/dev/null; echo;
            echo -n "product_version: "; cat /sys/devices/virtual/dmi/id/product_version 2>/dev/null; echo;
            echo -n "sys_vendor: "; cat /sys/devices/virtual/dmi/id/sys_vendor 2>/dev/null; echo;`;try{lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");result2.manufacturer=cleanDefaults(result2.manufacturer===""?util4.getValue(lines,"sys_vendor"):result2.manufacturer);result2.model=cleanDefaults(result2.model===""?util4.getValue(lines,"product_name"):result2.model);result2.version=cleanDefaults(result2.version===""?util4.getValue(lines,"product_version"):result2.version);result2.serial=cleanDefaults(result2.serial===""?util4.getValue(lines,"product_serial"):result2.serial);result2.uuid=cleanDefaults(result2.uuid===""?util4.getValue(lines,"product_uuid").toLowerCase():result2.uuid)}catch(e){util4.noop()}if(!result2.serial){result2.serial="-"}if(!result2.manufacturer){result2.manufacturer=""}if(!result2.model){result2.model="Computer"}if(!result2.version){result2.version=""}if(!result2.sku){result2.sku="-"}if(result2.model.toLowerCase()==="virtualbox"||result2.model.toLowerCase()==="kvm"||result2.model.toLowerCase()==="virtual machine"||result2.model.toLowerCase()==="bochs"||result2.model.toLowerCase().startsWith("vmware")||result2.model.toLowerCase().startsWith("droplet")){result2.virtual=true;switch(result2.model.toLowerCase()){case"virtualbox":result2.virtualHost="VirtualBox";break;case"vmware":result2.virtualHost="VMware";break;case"kvm":result2.virtualHost="KVM";break;case"bochs":result2.virtualHost="bochs";break}}if(result2.manufacturer.toLowerCase().startsWith("vmware")||result2.manufacturer.toLowerCase()==="xen"){result2.virtual=true;switch(result2.manufacturer.toLowerCase()){case"vmware":result2.virtualHost="VMware";break;case"xen":result2.virtualHost="Xen";break}}if(!result2.virtual){try{const disksById=execSync("ls -1 /dev/disk/by-id/ 2>/dev/null",util4.execOptsLinux).toString();if(disksById.indexOf("_QEMU_")>=0){result2.virtual=true;result2.virtualHost="QEMU"}if(disksById.indexOf("_VBOX_")>=0){result2.virtual=true;result2.virtualHost="VirtualBox"}}catch(e){util4.noop()}}if(!result2.virtual&&(os7.release().toLowerCase().indexOf("microsoft")>=0||os7.release().toLowerCase().endsWith("wsl2"))){const kernelVersion=parseFloat(os7.release().toLowerCase());result2.virtual=true;result2.manufacturer="Microsoft";result2.model="WSL";result2.version=kernelVersion<4.19?"1":"2"}if((_freebsd||_openbsd||_netbsd)&&!result2.virtualHost){try{const procInfo=execSync("dmidecode -t 4",util4.execOptsLinux);const procLines=procInfo.toString().split("\n");const procManufacturer=util4.getValue(procLines,"manufacturer",":",true);switch(procManufacturer.toLowerCase()){case"virtualbox":result2.virtualHost="VirtualBox";break;case"vmware":result2.virtualHost="VMware";break;case"kvm":result2.virtualHost="KVM";break;case"bochs":result2.virtualHost="bochs";break}}catch(e){util4.noop()}}if(fs14.existsSync("/.dockerenv")||fs14.existsSync("/.dockerinit")){result2.model="Docker Container"}try{const stdout2=execSync('dmesg 2>/dev/null | grep -iE "virtual|hypervisor" | grep -iE "vmware|qemu|kvm|xen" | grep -viE "Nested Virtualization|/virtual/"');let lines2=stdout2.toString().split("\n");if(lines2.length>0){if(result2.model==="Computer"){result2.model="Virtual machine"}result2.virtual=true;if(stdout2.toString().toLowerCase().indexOf("vmware")>=0&&!result2.virtualHost){result2.virtualHost="VMware"}if(stdout2.toString().toLowerCase().indexOf("qemu")>=0&&!result2.virtualHost){result2.virtualHost="QEMU"}if(stdout2.toString().toLowerCase().indexOf("xen")>=0&&!result2.virtualHost){result2.virtualHost="Xen"}if(stdout2.toString().toLowerCase().indexOf("kvm")>=0&&!result2.virtualHost){result2.virtualHost="KVM"}}}catch(e){util4.noop()}if(result2.manufacturer===""&&result2.model==="Computer"&&result2.version===""){fs14.readFile("/proc/cpuinfo",function(error2,stdout2){if(!error2){let lines2=stdout2.toString().split("\n");result2.model=util4.getValue(lines2,"hardware",":",true).toUpperCase();result2.version=util4.getValue(lines2,"revision",":",true).toLowerCase();result2.serial=util4.getValue(lines2,"serial",":",true);const model=util4.getValue(lines2,"model:",":",true);if((result2.model==="BCM2835"||result2.model==="BCM2708"||result2.model==="BCM2709"||result2.model==="BCM2710"||result2.model==="BCM2711"||result2.model==="BCM2836"||result2.model==="BCM2837")&&model.toLowerCase().indexOf("raspberry")>=0){const rPIRevision=util4.decodePiCpuinfo(lines2);result2.model=rPIRevision.model;result2.version=rPIRevision.revisionCode;result2.manufacturer="Raspberry Pi Foundation";result2.raspberry={manufacturer:rPIRevision.manufacturer,processor:rPIRevision.processor,type:rPIRevision.type,revision:rPIRevision.revision}}}if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})}if(_darwin){exec3("ioreg -c IOPlatformExpertDevice -d 2",function(error,stdout){if(!error){let lines=stdout.toString().replace(/[<>"]/g,"").split("\n");const model=util4.getAppleModel(util4.getValue(lines,"model","=",true));result2.manufacturer=util4.getValue(lines,"manufacturer","=",true);result2.model=model.key;result2.type=macOsChassisType(model.version);result2.version=model.version;result2.serial=util4.getValue(lines,"ioplatformserialnumber","=",true);result2.uuid=util4.getValue(lines,"ioplatformuuid","=",true).toLowerCase();result2.sku=util4.getValue(lines,"board-id","=",true)||util4.getValue(lines,"target-sub-type","=",true)}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){try{util4.powerShell("Get-CimInstance Win32_ComputerSystemProduct | select Name,Vendor,Version,IdentifyingNumber,UUID | fl").then((stdout,error)=>{if(!error){let lines=stdout.split("\r\n");result2.manufacturer=util4.getValue(lines,"vendor",":");result2.model=util4.getValue(lines,"name",":");result2.version=util4.getValue(lines,"version",":");result2.serial=util4.getValue(lines,"identifyingnumber",":");result2.uuid=util4.getValue(lines,"uuid",":").toLowerCase();const model=result2.model.toLowerCase();if(model==="virtualbox"||model==="kvm"||model==="virtual machine"||model==="bochs"||model.startsWith("vmware")||model.startsWith("qemu")||model.startsWith("parallels")){result2.virtual=true;if(model.startsWith("virtualbox")){result2.virtualHost="VirtualBox"}if(model.startsWith("vmware")){result2.virtualHost="VMware"}if(model.startsWith("kvm")){result2.virtualHost="KVM"}if(model.startsWith("bochs")){result2.virtualHost="bochs"}if(model.startsWith("qemu")){result2.virtualHost="KVM"}if(model.startsWith("parallels")){result2.virtualHost="Parallels"}}const manufacturer=result2.manufacturer.toLowerCase();if(manufacturer.startsWith("vmware")||manufacturer.startsWith("qemu")||manufacturer==="xen"||manufacturer.startsWith("parallels")){result2.virtual=true;if(manufacturer.startsWith("vmware")){result2.virtualHost="VMware"}if(manufacturer.startsWith("xen")){result2.virtualHost="Xen"}if(manufacturer.startsWith("qemu")){result2.virtualHost="KVM"}if(manufacturer.startsWith("parallels")){result2.virtualHost="Parallels"}}util4.powerShell('Get-CimInstance MS_Systeminformation -Namespace "root/wmi" | select systemsku | fl ').then((stdout2,error2)=>{if(!error2){let lines2=stdout2.split("\r\n");result2.sku=util4.getValue(lines2,"systemsku",":")}if(!result2.virtual){util4.powerShell("Get-CimInstance Win32_bios | select Version, SerialNumber, SMBIOSBIOSVersion").then((stdout3,error3)=>{if(!error3){let lines2=stdout3.toString();if(lines2.indexOf("VRTUAL")>=0||lines2.indexOf("A M I ")>=0||lines2.indexOf("VirtualBox")>=0||lines2.indexOf("VMWare")>=0||lines2.indexOf("Xen")>=0||lines2.indexOf("Parallels")>=0){result2.virtual=true;if(lines2.indexOf("VirtualBox")>=0&&!result2.virtualHost){result2.virtualHost="VirtualBox"}if(lines2.indexOf("VMware")>=0&&!result2.virtualHost){result2.virtualHost="VMware"}if(lines2.indexOf("Xen")>=0&&!result2.virtualHost){result2.virtualHost="Xen"}if(lines2.indexOf("VRTUAL")>=0&&!result2.virtualHost){result2.virtualHost="Hyper-V"}if(lines2.indexOf("A M I")>=0&&!result2.virtualHost){result2.virtualHost="Virtual PC"}if(lines2.indexOf("Parallels")>=0&&!result2.virtualHost){result2.virtualHost="Parallels"}}if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}})}else{if(callback){callback(result2)}resolve(result2)}})}else{if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.system=system;function cleanDefaults(s){const cmpStr=s.toLowerCase();if(cmpStr.indexOf("o.e.m.")===-1&&cmpStr.indexOf("default string")===-1&&cmpStr!=="default"){return s||""}return""}function bios(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={vendor:"",version:"",releaseDate:"",revision:""};let cmd="";if(_linux||_freebsd||_openbsd||_netbsd){if(process.arch==="arm"){cmd="cat /proc/cpuinfo | grep Serial"}else{cmd="export LC_ALL=C; dmidecode -t bios 2>/dev/null; unset LC_ALL"}exec3(cmd,function(error,stdout){let lines=stdout.toString().split("\n");result2.vendor=util4.getValue(lines,"Vendor");result2.version=util4.getValue(lines,"Version");let datetime=util4.getValue(lines,"Release Date");result2.releaseDate=util4.parseDateTime(datetime).date;result2.revision=util4.getValue(lines,"BIOS Revision");result2.serial=util4.getValue(lines,"SerialNumber");let language2=util4.getValue(lines,"Currently Installed Language").split("|")[0];if(language2){result2.language=language2}if(lines.length&&stdout.toString().indexOf("Characteristics:")>=0){const features=[];lines.forEach(line=>{if(line.indexOf(" is supported")>=0){const feature=line.split(" is supported")[0].trim();features.push(feature)}});result2.features=features}const cmd2=`echo -n "bios_date: "; cat /sys/devices/virtual/dmi/id/bios_date 2>/dev/null; echo;
            echo -n "bios_vendor: "; cat /sys/devices/virtual/dmi/id/bios_vendor 2>/dev/null; echo;
            echo -n "bios_version: "; cat /sys/devices/virtual/dmi/id/bios_version 2>/dev/null; echo;`;try{lines=execSync(cmd2,util4.execOptsLinux).toString().split("\n");result2.vendor=!result2.vendor?util4.getValue(lines,"bios_vendor"):result2.vendor;result2.version=!result2.version?util4.getValue(lines,"bios_version"):result2.version;datetime=util4.getValue(lines,"bios_date");result2.releaseDate=!result2.releaseDate?util4.parseDateTime(datetime).date:result2.releaseDate}catch(e){util4.noop()}if(callback){callback(result2)}resolve(result2)})}if(_darwin){result2.vendor="Apple Inc.";exec3("system_profiler SPHardwareDataType -json",function(error,stdout){try{const hardwareData=JSON.parse(stdout.toString());if(hardwareData&&hardwareData.SPHardwareDataType&&hardwareData.SPHardwareDataType.length){let bootRomVersion=hardwareData.SPHardwareDataType[0].boot_rom_version;bootRomVersion=bootRomVersion?bootRomVersion.split("(")[0].trim():null;result2.version=bootRomVersion}}catch(e){util4.noop()}if(callback){callback(result2)}resolve(result2)})}if(_sunos){result2.vendor="Sun Microsystems";if(callback){callback(result2)}resolve(result2)}if(_windows){try{util4.powerShell('Get-CimInstance Win32_bios | select Description,Version,Manufacturer,@{n="ReleaseDate";e={$_.ReleaseDate.ToString("yyyy-MM-dd")}},BuildNumber,SerialNumber,SMBIOSBIOSVersion | fl').then((stdout,error)=>{if(!error){let lines=stdout.toString().split("\r\n");const description=util4.getValue(lines,"description",":");const version=util4.getValue(lines,"SMBIOSBIOSVersion",":");if(description.indexOf(" Version ")!==-1){result2.vendor=description.split(" Version ")[0].trim();result2.version=description.split(" Version ")[1].trim()}else if(description.indexOf(" Ver: ")!==-1){result2.vendor=util4.getValue(lines,"manufacturer",":");result2.version=description.split(" Ver: ")[1].trim()}else{result2.vendor=util4.getValue(lines,"manufacturer",":");result2.version=version||util4.getValue(lines,"version",":")}result2.releaseDate=util4.getValue(lines,"releasedate",":");result2.revision=util4.getValue(lines,"buildnumber",":");result2.serial=cleanDefaults(util4.getValue(lines,"serialnumber",":"))}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.bios=bios;function baseboard(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={manufacturer:"",model:"",version:"",serial:"-",assetTag:"-",memMax:null,memSlots:null};let cmd="";if(_linux||_freebsd||_openbsd||_netbsd){if(process.arch==="arm"){cmd="cat /proc/cpuinfo | grep Serial"}else{cmd="export LC_ALL=C; dmidecode -t 2 2>/dev/null; unset LC_ALL"}const workload=[];workload.push(execPromise(cmd));workload.push(execPromise("export LC_ALL=C; dmidecode -t memory 2>/dev/null"));util4.promiseAll(workload).then(data=>{let lines=data.results[0]?data.results[0].toString().split("\n"):[""];result2.manufacturer=cleanDefaults(util4.getValue(lines,"Manufacturer"));result2.model=cleanDefaults(util4.getValue(lines,"Product Name"));result2.version=cleanDefaults(util4.getValue(lines,"Version"));result2.serial=cleanDefaults(util4.getValue(lines,"Serial Number"));result2.assetTag=cleanDefaults(util4.getValue(lines,"Asset Tag"));const cmd2=`echo -n "board_asset_tag: "; cat /sys/devices/virtual/dmi/id/board_asset_tag 2>/dev/null; echo;
            echo -n "board_name: "; cat /sys/devices/virtual/dmi/id/board_name 2>/dev/null; echo;
            echo -n "board_serial: "; cat /sys/devices/virtual/dmi/id/board_serial 2>/dev/null; echo;
            echo -n "board_vendor: "; cat /sys/devices/virtual/dmi/id/board_vendor 2>/dev/null; echo;
            echo -n "board_version: "; cat /sys/devices/virtual/dmi/id/board_version 2>/dev/null; echo;`;try{lines=execSync(cmd2,util4.execOptsLinux).toString().split("\n");result2.manufacturer=cleanDefaults(!result2.manufacturer?util4.getValue(lines,"board_vendor"):result2.manufacturer);result2.model=cleanDefaults(!result2.model?util4.getValue(lines,"board_name"):result2.model);result2.version=cleanDefaults(!result2.version?util4.getValue(lines,"board_version"):result2.version);result2.serial=cleanDefaults(!result2.serial?util4.getValue(lines,"board_serial"):result2.serial);result2.assetTag=cleanDefaults(!result2.assetTag?util4.getValue(lines,"board_asset_tag"):result2.assetTag)}catch(e){util4.noop()}lines=data.results[1]?data.results[1].toString().split("\n"):[""];result2.memMax=util4.toInt(util4.getValue(lines,"Maximum Capacity"))*1024*1024*1024||null;result2.memSlots=util4.toInt(util4.getValue(lines,"Number Of Devices"))||null;let linesRpi="";try{linesRpi=fs14.readFileSync("/proc/cpuinfo").toString().split("\n")}catch(e){util4.noop()}if(linesRpi){const hardware=util4.getValue(linesRpi,"hardware");if(hardware.startsWith("BCM")){const rpi=util4.decodePiCpuinfo(linesRpi);result2.manufacturer=rpi.manufacturer;result2.model="Raspberry Pi";result2.serial=rpi.serial;result2.version=rpi.type+" - "+rpi.revision;result2.memMax=os7.totalmem();result2.memSlots=0}}if(callback){callback(result2)}resolve(result2)})}if(_darwin){const workload=[];workload.push(execPromise("ioreg -c IOPlatformExpertDevice -d 2"));workload.push(execPromise("system_profiler SPMemoryDataType"));util4.promiseAll(workload).then(data=>{let lines=data.results[0]?data.results[0].toString().replace(/[<>"]/g,"").split("\n"):[""];result2.manufacturer=util4.getValue(lines,"manufacturer","=",true);result2.model=util4.getValue(lines,"model","=",true);result2.version=util4.getValue(lines,"version","=",true);result2.serial=util4.getValue(lines,"ioplatformserialnumber","=",true);result2.assetTag=util4.getValue(lines,"board-id","=",true);let devices=data.results[1]?data.results[1].toString().split("        BANK "):[""];if(devices.length===1){devices=data.results[1]?data.results[1].toString().split("        DIMM"):[""]}devices.shift();result2.memSlots=devices.length;if(os7.arch()==="arm64"){result2.memSlots=0;result2.memMax=os7.totalmem()}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){try{const workload=[];const win10plus=parseInt(os7.release())>=10;const maxCapacityAttribute=win10plus?"MaxCapacityEx":"MaxCapacity";workload.push(util4.powerShell("Get-CimInstance Win32_baseboard | select Model,Manufacturer,Product,Version,SerialNumber,PartNumber,SKU | fl"));workload.push(util4.powerShell(`Get-CimInstance Win32_physicalmemoryarray | select ${maxCapacityAttribute}, MemoryDevices | fl`));util4.promiseAll(workload).then(data=>{let lines=data.results[0]?data.results[0].toString().split("\r\n"):[""];result2.manufacturer=cleanDefaults(util4.getValue(lines,"manufacturer",":"));result2.model=cleanDefaults(util4.getValue(lines,"model",":"));if(!result2.model){result2.model=cleanDefaults(util4.getValue(lines,"product",":"))}result2.version=cleanDefaults(util4.getValue(lines,"version",":"));result2.serial=cleanDefaults(util4.getValue(lines,"serialnumber",":"));result2.assetTag=cleanDefaults(util4.getValue(lines,"partnumber",":"));if(!result2.assetTag){result2.assetTag=cleanDefaults(util4.getValue(lines,"sku",":"))}lines=data.results[1]?data.results[1].toString().split("\r\n"):[""];result2.memMax=util4.toInt(util4.getValue(lines,maxCapacityAttribute,":"))*(win10plus?1024:1)||null;result2.memSlots=util4.toInt(util4.getValue(lines,"MemoryDevices",":"))||null;if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.baseboard=baseboard;function macOsChassisType(model){model=model.toLowerCase();if(model.indexOf("macbookair")>=0||model.indexOf("macbook air")>=0){return"Notebook"}if(model.indexOf("macbookpro")>=0||model.indexOf("macbook pro")>=0){return"Notebook"}if(model.indexOf("macbook")>=0){return"Notebook"}if(model.indexOf("macmini")>=0||model.indexOf("mac mini")>=0){return"Desktop"}if(model.indexOf("imac")>=0){return"Desktop"}if(model.indexOf("macstudio")>=0||model.indexOf("mac studio")>=0){return"Desktop"}if(model.indexOf("macpro")>=0||model.indexOf("mac pro")>=0){return"Tower"}return"Other"}function chassis(callback){const chassisTypes=["Other","Unknown","Desktop","Low Profile Desktop","Pizza Box","Mini Tower","Tower","Portable","Laptop","Notebook","Hand Held","Docking Station","All in One","Sub Notebook","Space-Saving","Lunch Box","Main System Chassis","Expansion Chassis","SubChassis","Bus Expansion Chassis","Peripheral Chassis","Storage Chassis","Rack Mount Chassis","Sealed-Case PC","Multi-System Chassis","Compact PCI","Advanced TCA","Blade","Blade Enclosure","Tablet","Convertible","Detachable","IoT Gateway ","Embedded PC","Mini PC","Stick PC"];return new Promise(resolve=>{process.nextTick(()=>{let result2={manufacturer:"",model:"",type:"",version:"",serial:"-",assetTag:"-",sku:""};if(_linux||_freebsd||_openbsd||_netbsd){const cmd=`echo -n "chassis_asset_tag: "; cat /sys/devices/virtual/dmi/id/chassis_asset_tag 2>/dev/null; echo;
            echo -n "chassis_serial: "; cat /sys/devices/virtual/dmi/id/chassis_serial 2>/dev/null; echo;
            echo -n "chassis_type: "; cat /sys/devices/virtual/dmi/id/chassis_type 2>/dev/null; echo;
            echo -n "chassis_vendor: "; cat /sys/devices/virtual/dmi/id/chassis_vendor 2>/dev/null; echo;
            echo -n "chassis_version: "; cat /sys/devices/virtual/dmi/id/chassis_version 2>/dev/null; echo;`;exec3(cmd,function(error,stdout){let lines=stdout.toString().split("\n");result2.manufacturer=cleanDefaults(util4.getValue(lines,"chassis_vendor"));const ctype=parseInt(util4.getValue(lines,"chassis_type").replace(/\D/g,""));result2.type=cleanDefaults(ctype&&!isNaN(ctype)&&ctype<chassisTypes.length?chassisTypes[ctype-1]:"");result2.version=cleanDefaults(util4.getValue(lines,"chassis_version"));result2.serial=cleanDefaults(util4.getValue(lines,"chassis_serial"));result2.assetTag=cleanDefaults(util4.getValue(lines,"chassis_asset_tag"));if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3("ioreg -c IOPlatformExpertDevice -d 2",function(error,stdout){if(!error){let lines=stdout.toString().replace(/[<>"]/g,"").split("\n");const model=util4.getAppleModel(util4.getValue(lines,"model","=",true));result2.manufacturer=util4.getValue(lines,"manufacturer","=",true);result2.model=model.key;result2.type=macOsChassisType(model.model);result2.version=model.version;result2.serial=util4.getValue(lines,"ioplatformserialnumber","=",true);result2.assetTag=util4.getValue(lines,"board-id","=",true)||util4.getValue(lines,"target-type","=",true);result2.sku=util4.getValue(lines,"target-sub-type","=",true)}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){try{util4.powerShell("Get-CimInstance Win32_SystemEnclosure | select Model,Manufacturer,ChassisTypes,Version,SerialNumber,PartNumber,SKU,SMBIOSAssetTag | fl").then((stdout,error)=>{if(!error){let lines=stdout.toString().split("\r\n");result2.manufacturer=cleanDefaults(util4.getValue(lines,"manufacturer",":"));result2.model=cleanDefaults(util4.getValue(lines,"model",":"));const ctype=parseInt(util4.getValue(lines,"ChassisTypes",":").replace(/\D/g,""));result2.type=ctype&&!isNaN(ctype)&&ctype<chassisTypes.length?chassisTypes[ctype-1]:"";result2.version=cleanDefaults(util4.getValue(lines,"version",":"));result2.serial=cleanDefaults(util4.getValue(lines,"serialnumber",":"));result2.assetTag=cleanDefaults(util4.getValue(lines,"partnumber",":"));if(!result2.assetTag){result2.assetTag=cleanDefaults(util4.getValue(lines,"SMBIOSAssetTag",":"))}result2.sku=cleanDefaults(util4.getValue(lines,"sku",":"))}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.chassis=chassis}});var require_osinfo=__commonJS({"node_modules/systeminformation/lib/osinfo.js"(exports2){"use strict";var os7=require("os");var fs14=require("fs");var util4=require_util2();var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function time(){let t=new Date().toString().split(" ");const result2={current:Date.now(),uptime:os7.uptime(),timezone:t.length>=7?t[5]:"",timezoneName:Intl?Intl.DateTimeFormat().resolvedOptions().timeZone:t.length>=7?t.slice(6).join(" ").replace(/\(/g,"").replace(/\)/g,""):""};if(_darwin||_linux){try{const stdout=execSync("date +%Z && date +%z && ls -l /etc/localtime 2>/dev/null",util4.execOptsLinux);const lines=stdout.toString().split(os7.EOL);if(lines.length>3&&!lines[0]){lines.shift()}let timezone2=lines[0]||"";if(timezone2.startsWith("+")||timezone2.startsWith("-")){timezone2="GMT"}return{current:Date.now(),uptime:os7.uptime(),timezone:lines[1]?timezone2+lines[1]:timezone2,timezoneName:lines[2]&&lines[2].indexOf("/zoneinfo/")>0?lines[2].split("/zoneinfo/")[1]||"":""}}catch(e){util4.noop()}}return result2}exports2.time=time;function getLogoFile(distro){distro=distro||"";distro=distro.toLowerCase();let result2=_platform;if(_windows){result2="windows"}else if(distro.indexOf("mac os")!==-1||distro.indexOf("macos")!==-1){result2="apple"}else if(distro.indexOf("arch")!==-1){result2="arch"}else if(distro.indexOf("cachy")!==-1){result2="cachy"}else if(distro.indexOf("centos")!==-1){result2="centos"}else if(distro.indexOf("coreos")!==-1){result2="coreos"}else if(distro.indexOf("debian")!==-1){result2="debian"}else if(distro.indexOf("deepin")!==-1){result2="deepin"}else if(distro.indexOf("elementary")!==-1){result2="elementary"}else if(distro.indexOf("endeavour")!==-1){result2="endeavour"}else if(distro.indexOf("fedora")!==-1){result2="fedora"}else if(distro.indexOf("gentoo")!==-1){result2="gentoo"}else if(distro.indexOf("mageia")!==-1){result2="mageia"}else if(distro.indexOf("mandriva")!==-1){result2="mandriva"}else if(distro.indexOf("manjaro")!==-1){result2="manjaro"}else if(distro.indexOf("mint")!==-1){result2="mint"}else if(distro.indexOf("mx")!==-1){result2="mx"}else if(distro.indexOf("openbsd")!==-1){result2="openbsd"}else if(distro.indexOf("freebsd")!==-1){result2="freebsd"}else if(distro.indexOf("opensuse")!==-1){result2="opensuse"}else if(distro.indexOf("pclinuxos")!==-1){result2="pclinuxos"}else if(distro.indexOf("puppy")!==-1){result2="puppy"}else if(distro.indexOf("popos")!==-1){result2="popos"}else if(distro.indexOf("raspbian")!==-1){result2="raspbian"}else if(distro.indexOf("reactos")!==-1){result2="reactos"}else if(distro.indexOf("redhat")!==-1){result2="redhat"}else if(distro.indexOf("slackware")!==-1){result2="slackware"}else if(distro.indexOf("sugar")!==-1){result2="sugar"}else if(distro.indexOf("steam")!==-1){result2="steam"}else if(distro.indexOf("suse")!==-1){result2="suse"}else if(distro.indexOf("mate")!==-1){result2="ubuntu-mate"}else if(distro.indexOf("lubuntu")!==-1){result2="lubuntu"}else if(distro.indexOf("xubuntu")!==-1){result2="xubuntu"}else if(distro.indexOf("ubuntu")!==-1){result2="ubuntu"}else if(distro.indexOf("solaris")!==-1){result2="solaris"}else if(distro.indexOf("tails")!==-1){result2="tails"}else if(distro.indexOf("feren")!==-1){result2="ferenos"}else if(distro.indexOf("robolinux")!==-1){result2="robolinux"}else if(_linux&&distro){result2=distro.toLowerCase().trim().replace(/\s+/g,"-")}return result2}function getFQDN(){let fqdn=os7.hostname;if(_linux||_darwin){try{const stdout=execSync("hostname -f 2>/dev/null",util4.execOptsLinux);fqdn=stdout.toString().split(os7.EOL)[0]}catch(e){util4.noop()}}if(_freebsd||_openbsd||_netbsd){try{const stdout=execSync("hostname 2>/dev/null");fqdn=stdout.toString().split(os7.EOL)[0]}catch(e){util4.noop()}}if(_windows){try{const stdout=execSync("echo %COMPUTERNAME%.%USERDNSDOMAIN%",util4.execOptsWin);fqdn=stdout.toString().replace(".%USERDNSDOMAIN%","").split(os7.EOL)[0]}catch(e){util4.noop()}}return fqdn}function osInfo(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={platform:_platform==="win32"?"Windows":_platform,distro:"unknown",release:"unknown",codename:"",kernel:os7.release(),arch:os7.arch(),hostname:os7.hostname(),fqdn:getFQDN(),codepage:"",logofile:"",serial:"",build:"",servicepack:"",uefi:false};if(_linux){exec3("cat /etc/*-release; cat /usr/lib/os-release; cat /etc/openwrt_release",function(error,stdout){let release={};let lines=stdout.toString().split("\n");lines.forEach(function(line){if(line.indexOf("=")!==-1){release[line.split("=")[0].trim().toUpperCase()]=line.split("=")[1].trim()}});result2.distro=(release.DISTRIB_ID||release.NAME||"unknown").replace(/"/g,"");result2.logofile=getLogoFile(result2.distro);let releaseVersion=(release.VERSION||"").replace(/"/g,"");let codename=(release.DISTRIB_CODENAME||release.VERSION_CODENAME||"").replace(/"/g,"");const prettyName=(release.PRETTY_NAME||"").replace(/"/g,"");if(prettyName.indexOf(result2.distro+" ")===0){releaseVersion=prettyName.replace(result2.distro+" ","").trim()}if(releaseVersion.indexOf("(")>=0){codename=releaseVersion.split("(")[1].replace(/[()]/g,"").trim();releaseVersion=releaseVersion.split("(")[0].trim()}result2.release=(releaseVersion||release.DISTRIB_RELEASE||release.VERSION_ID||"unknown").replace(/"/g,"");result2.codename=codename;result2.codepage=util4.getCodepage();result2.build=(release.BUILD_ID||"").replace(/"/g,"").trim();isUefiLinux().then(uefi=>{result2.uefi=uefi;uuid().then(data=>{result2.serial=data.os;if(callback){callback(result2)}resolve(result2)})})})}if(_freebsd||_openbsd||_netbsd){exec3("sysctl kern.ostype kern.osrelease kern.osrevision kern.hostuuid machdep.bootmethod kern.geom.confxml",function(error,stdout){let lines=stdout.toString().split("\n");const distro=util4.getValue(lines,"kern.ostype");const logofile=getLogoFile(distro);const release=util4.getValue(lines,"kern.osrelease").split("-")[0];const serial=util4.getValue(lines,"kern.uuid");const bootmethod=util4.getValue(lines,"machdep.bootmethod");const uefiConf=stdout.toString().indexOf("<type>efi</type>")>=0;const uefi=bootmethod?bootmethod.toLowerCase().indexOf("uefi")>=0:uefiConf?uefiConf:null;result2.distro=distro||result2.distro;result2.logofile=logofile||result2.logofile;result2.release=release||result2.release;result2.serial=serial||result2.serial;result2.codename="";result2.codepage=util4.getCodepage();result2.uefi=uefi||null;if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3("sw_vers; sysctl kern.ostype kern.osrelease kern.osrevision kern.uuid",function(error,stdout){let lines=stdout.toString().split("\n");result2.serial=util4.getValue(lines,"kern.uuid");result2.distro=util4.getValue(lines,"ProductName");result2.release=(util4.getValue(lines,"ProductVersion",":",true,true)+" "+util4.getValue(lines,"ProductVersionExtra",":",true,true)).trim();result2.build=util4.getValue(lines,"BuildVersion");result2.logofile=getLogoFile(result2.distro);result2.codename="macOS";result2.codename=result2.release.indexOf("10.4")>-1?"OS X Tiger":result2.codename;result2.codename=result2.release.indexOf("10.5")>-1?"OS X Leopard":result2.codename;result2.codename=result2.release.indexOf("10.6")>-1?"OS X Snow Leopard":result2.codename;result2.codename=result2.release.indexOf("10.7")>-1?"OS X Lion":result2.codename;result2.codename=result2.release.indexOf("10.8")>-1?"OS X Mountain Lion":result2.codename;result2.codename=result2.release.indexOf("10.9")>-1?"OS X Mavericks":result2.codename;result2.codename=result2.release.indexOf("10.10")>-1?"OS X Yosemite":result2.codename;result2.codename=result2.release.indexOf("10.11")>-1?"OS X El Capitan":result2.codename;result2.codename=result2.release.indexOf("10.12")>-1?"Sierra":result2.codename;result2.codename=result2.release.indexOf("10.13")>-1?"High Sierra":result2.codename;result2.codename=result2.release.indexOf("10.14")>-1?"Mojave":result2.codename;result2.codename=result2.release.indexOf("10.15")>-1?"Catalina":result2.codename;result2.codename=result2.release.startsWith("11.")?"Big Sur":result2.codename;result2.codename=result2.release.startsWith("12.")?"Monterey":result2.codename;result2.codename=result2.release.startsWith("13.")?"Ventura":result2.codename;result2.codename=result2.release.startsWith("14.")?"Sonoma":result2.codename;result2.codename=result2.release.startsWith("15.")?"Sequoia":result2.codename;result2.uefi=true;result2.codepage=util4.getCodepage();if(callback){callback(result2)}resolve(result2)})}if(_sunos){result2.release=result2.kernel;exec3("uname -o",function(error,stdout){let lines=stdout.toString().split("\n");result2.distro=lines[0];result2.logofile=getLogoFile(result2.distro);if(callback){callback(result2)}resolve(result2)})}if(_windows){result2.logofile=getLogoFile();result2.release=result2.kernel;try{const workload=[];workload.push(util4.powerShell("Get-CimInstance Win32_OperatingSystem | select Caption,SerialNumber,BuildNumber,ServicePackMajorVersion,ServicePackMinorVersion | fl"));workload.push(util4.powerShell("(Get-CimInstance Win32_ComputerSystem).HypervisorPresent"));workload.push(util4.powerShell("Add-Type -AssemblyName System.Windows.Forms; [System.Windows.Forms.SystemInformation]::TerminalServerSession"));util4.promiseAll(workload).then(data=>{let lines=data.results[0]?data.results[0].toString().split("\r\n"):[""];result2.distro=util4.getValue(lines,"Caption",":").trim();result2.serial=util4.getValue(lines,"SerialNumber",":").trim();result2.build=util4.getValue(lines,"BuildNumber",":").trim();result2.servicepack=util4.getValue(lines,"ServicePackMajorVersion",":").trim()+"."+util4.getValue(lines,"ServicePackMinorVersion",":").trim();result2.codepage=util4.getCodepage();const hyperv=data.results[1]?data.results[1].toString().toLowerCase():"";result2.hypervisor=hyperv.indexOf("true")!==-1;const term=data.results[2]?data.results[2].toString():"";result2.remoteSession=term.toString().toLowerCase().indexOf("true")>=0;isUefiWindows().then(uefi=>{result2.uefi=uefi;if(callback){callback(result2)}resolve(result2)})})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.osInfo=osInfo;function isUefiLinux(){return new Promise(resolve=>{process.nextTick(()=>{fs14.stat("/sys/firmware/efi",function(err){if(!err){return resolve(true)}else{exec3('dmesg | grep -E "EFI v"',function(error,stdout){if(!error){const lines=stdout.toString().split("\n");return resolve(lines.length>0)}return resolve(false)})}})})})}function isUefiWindows(){return new Promise(resolve=>{process.nextTick(()=>{try{exec3('findstr /C:"Detected boot environment" "%windir%\\Panther\\setupact.log"',util4.execOptsWin,function(error,stdout){if(!error){const line=stdout.toString().split("\n\r")[0];return resolve(line.toLowerCase().indexOf("efi")>=0)}else{exec3("echo %firmware_type%",util4.execOptsWin,function(error2,stdout2){if(!error2){const line=stdout2.toString()||"";return resolve(line.toLowerCase().indexOf("efi")>=0)}else{return resolve(false)}})}})}catch(e){return resolve(false)}})})}function versions(apps,callback){let versionObject={kernel:os7.release(),apache:"",bash:"",bun:"",deno:"",docker:"",dotnet:"",fish:"",gcc:"",git:"",grunt:"",gulp:"",homebrew:"",java:"",mongodb:"",mysql:"",nginx:"",node:"",npm:"",openssl:"",perl:"",php:"",pip3:"",pip:"",pm2:"",postfix:"",postgresql:"",powershell:"",python3:"",python:"",redis:"",systemOpenssl:"",systemOpensslLib:"",tsc:"",v8:process.versions.v8,virtualbox:"",yarn:"",zsh:""};function checkVersionParam(apps2){if(apps2==="*"){return{versions:versionObject,counter:34}}if(!Array.isArray(apps2)){apps2=apps2.trim().toLowerCase().replace(/,+/g,"|").replace(/ /g,"|");apps2=apps2.split("|");const result2={versions:{},counter:0};apps2.forEach(el=>{if(el){for(let key in versionObject){if({}.hasOwnProperty.call(versionObject,key)){if(key.toLowerCase()===el.toLowerCase()&&!{}.hasOwnProperty.call(result2.versions,key)){result2.versions[key]=versionObject[key];if(key==="openssl"){result2.versions.systemOpenssl="";result2.versions.systemOpensslLib=""}if(!result2.versions[key]){result2.counter++}}}}}});return result2}}return new Promise(resolve=>{process.nextTick(()=>{if(util4.isFunction(apps)&&!callback){callback=apps;apps="*"}else{apps=apps||"*";if(typeof apps!=="string"){if(callback){callback({})}return resolve({})}}const appsObj=checkVersionParam(apps);let totalFunctions=appsObj.counter;let functionProcessed=function(){return function(){if(--totalFunctions===0){if(callback){callback(appsObj.versions)}resolve(appsObj.versions)}}}();let cmd="";try{if({}.hasOwnProperty.call(appsObj.versions,"openssl")){appsObj.versions.openssl=process.versions.openssl;exec3("openssl version",function(error,stdout){if(!error){let openssl_string=stdout.toString().split("\n")[0].trim();let openssl=openssl_string.split(" ");appsObj.versions.systemOpenssl=openssl.length>0?openssl[1]:openssl[0];appsObj.versions.systemOpensslLib=openssl.length>0?openssl[0]:"openssl"}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"npm")){exec3("npm -v",function(error,stdout){if(!error){appsObj.versions.npm=stdout.toString().split("\n")[0]}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"pm2")){cmd="pm2";if(_windows){cmd+=".cmd"}exec3(`${cmd} -v`,function(error,stdout){if(!error){let pm2=stdout.toString().split("\n")[0].trim();if(!pm2.startsWith("[PM2]")){appsObj.versions.pm2=pm2}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"yarn")){exec3("yarn --version",function(error,stdout){if(!error){appsObj.versions.yarn=stdout.toString().split("\n")[0]}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"gulp")){cmd="gulp";if(_windows){cmd+=".cmd"}exec3(`${cmd} --version`,function(error,stdout){if(!error){const gulp=stdout.toString().split("\n")[0]||"";appsObj.versions.gulp=(gulp.toLowerCase().split("version")[1]||"").trim()}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"homebrew")){cmd="brew";exec3(`${cmd} --version`,function(error,stdout){if(!error){const brew=stdout.toString().split("\n")[0]||"";appsObj.versions.homebrew=(brew.toLowerCase().split(" ")[1]||"").trim()}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"tsc")){cmd="tsc";if(_windows){cmd+=".cmd"}exec3(`${cmd} --version`,function(error,stdout){if(!error){const tsc=stdout.toString().split("\n")[0]||"";appsObj.versions.tsc=(tsc.toLowerCase().split("version")[1]||"").trim()}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"grunt")){cmd="grunt";if(_windows){cmd+=".cmd"}exec3(`${cmd} --version`,function(error,stdout){if(!error){const grunt=stdout.toString().split("\n")[0]||"";appsObj.versions.grunt=(grunt.toLowerCase().split("cli v")[1]||"").trim()}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"git")){if(_darwin){const gitHomebrewExists=fs14.existsSync("/usr/local/Cellar/git")||fs14.existsSync("/opt/homebrew/bin/git");if(util4.darwinXcodeExists()||gitHomebrewExists){exec3("git --version",function(error,stdout){if(!error){let git=stdout.toString().split("\n")[0]||"";git=(git.toLowerCase().split("version")[1]||"").trim();appsObj.versions.git=(git.split(" ")[0]||"").trim()}functionProcessed()})}else{functionProcessed()}}else{exec3("git --version",function(error,stdout){if(!error){let git=stdout.toString().split("\n")[0]||"";git=(git.toLowerCase().split("version")[1]||"").trim();appsObj.versions.git=(git.split(" ")[0]||"").trim()}functionProcessed()})}}if({}.hasOwnProperty.call(appsObj.versions,"apache")){exec3("apachectl -v 2>&1",function(error,stdout){if(!error){const apache=(stdout.toString().split("\n")[0]||"").split(":");appsObj.versions.apache=apache.length>1?apache[1].replace("Apache","").replace("/","").split("(")[0].trim():""}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"nginx")){exec3("nginx -v 2>&1",function(error,stdout){if(!error){const nginx=stdout.toString().split("\n")[0]||"";appsObj.versions.nginx=(nginx.toLowerCase().split("/")[1]||"").trim()}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"mysql")){exec3("mysql -V",function(error,stdout){if(!error){let mysql3=stdout.toString().split("\n")[0]||"";mysql3=mysql3.toLowerCase();if(mysql3.indexOf(",")>-1){mysql3=(mysql3.split(",")[0]||"").trim();const parts=mysql3.split(" ");appsObj.versions.mysql=(parts[parts.length-1]||"").trim()}else{if(mysql3.indexOf(" ver ")>-1){mysql3=mysql3.split(" ver ")[1];appsObj.versions.mysql=mysql3.split(" ")[0]}}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"php")){exec3("php -v",function(error,stdout){if(!error){const php=stdout.toString().split("\n")[0]||"";let parts=php.split("(");if(parts[0].indexOf("-")){parts=parts[0].split("-")}appsObj.versions.php=parts[0].replace(/[^0-9.]/g,"")}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"redis")){exec3("redis-server --version",function(error,stdout){if(!error){const redis=stdout.toString().split("\n")[0]||"";const parts=redis.split(" ");appsObj.versions.redis=util4.getValue(parts,"v","=",true)}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"docker")){exec3("docker --version",function(error,stdout){if(!error){const docker=stdout.toString().split("\n")[0]||"";const parts=docker.split(" ");appsObj.versions.docker=parts.length>2&&parts[2].endsWith(",")?parts[2].slice(0,-1):""}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"postfix")){exec3("postconf -d | grep mail_version",function(error,stdout){if(!error){const postfix=stdout.toString().split("\n")||[];appsObj.versions.postfix=util4.getValue(postfix,"mail_version","=",true)}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"mongodb")){exec3("mongod --version",function(error,stdout){if(!error){const mongodb=stdout.toString().split("\n")[0]||"";appsObj.versions.mongodb=(mongodb.toLowerCase().split(",")[0]||"").replace(/[^0-9.]/g,"")}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"postgresql")){if(_linux){exec3("locate bin/postgres",function(error,stdout){if(!error){const postgresqlBin=stdout.toString().split("\n").sort();if(postgresqlBin.length){exec3(postgresqlBin[postgresqlBin.length-1]+" -V",function(error2,stdout2){if(!error2){const postgresql=stdout2.toString().split("\n")[0].split(" ")||[];appsObj.versions.postgresql=postgresql.length?postgresql[postgresql.length-1]:""}functionProcessed()})}else{functionProcessed()}}else{exec3("psql -V",function(error2,stdout2){if(!error2){const postgresql=stdout2.toString().split("\n")[0].split(" ")||[];appsObj.versions.postgresql=postgresql.length?postgresql[postgresql.length-1]:"";appsObj.versions.postgresql=appsObj.versions.postgresql.split("-")[0]}functionProcessed()})}})}else{if(_windows){util4.powerShell("Get-CimInstance Win32_Service | select caption | fl").then(stdout=>{let serviceSections=stdout.split(/\n\s*\n/);serviceSections.forEach(item=>{if(item.trim()!==""){let lines=item.trim().split("\r\n");let srvCaption=util4.getValue(lines,"caption",":",true).toLowerCase();if(srvCaption.indexOf("postgresql")>-1){const parts=srvCaption.split(" server ");if(parts.length>1){appsObj.versions.postgresql=parts[1]}}}});functionProcessed()})}else{exec3("postgres -V",function(error,stdout){if(!error){const postgresql=stdout.toString().split("\n")[0].split(" ")||[];appsObj.versions.postgresql=postgresql.length?postgresql[postgresql.length-1]:""}else{exec3("pg_config --version",function(error2,stdout2){if(!error2){const postgresql=stdout2.toString().split("\n")[0].split(" ")||[];appsObj.versions.postgresql=postgresql.length?postgresql[postgresql.length-1]:""}})}functionProcessed()})}}}if({}.hasOwnProperty.call(appsObj.versions,"perl")){exec3("perl -v",function(error,stdout){if(!error){const perl=stdout.toString().split("\n")||"";while(perl.length>0&&perl[0].trim()===""){perl.shift()}if(perl.length>0){appsObj.versions.perl=perl[0].split("(").pop().split(")")[0].replace("v","")}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"python")){if(_darwin){try{const stdout=execSync("sw_vers");const lines=stdout.toString().split("\n");const osVersion=util4.getValue(lines,"ProductVersion",":");const gitHomebrewExists1=fs14.existsSync("/usr/local/Cellar/python");const gitHomebrewExists2=fs14.existsSync("/opt/homebrew/bin/python");if(util4.darwinXcodeExists()&&util4.semverCompare("12.0.1",osVersion)<0||gitHomebrewExists1||gitHomebrewExists2){const cmd2=gitHomebrewExists1?"/usr/local/Cellar/python -V 2>&1":gitHomebrewExists2?"/opt/homebrew/bin/python -V 2>&1":"python -V 2>&1";exec3(cmd2,function(error,stdout2){if(!error){const python=stdout2.toString().split("\n")[0]||"";appsObj.versions.python=python.toLowerCase().replace("python","").trim()}functionProcessed()})}else{functionProcessed()}}catch(e){functionProcessed()}}else{exec3("python -V 2>&1",function(error,stdout){if(!error){const python=stdout.toString().split("\n")[0]||"";appsObj.versions.python=python.toLowerCase().replace("python","").trim()}functionProcessed()})}}if({}.hasOwnProperty.call(appsObj.versions,"python3")){if(_darwin){const gitHomebrewExists=fs14.existsSync("/usr/local/Cellar/python3")||fs14.existsSync("/opt/homebrew/bin/python3");if(util4.darwinXcodeExists()||gitHomebrewExists){exec3("python3 -V 2>&1",function(error,stdout){if(!error){const python=stdout.toString().split("\n")[0]||"";appsObj.versions.python3=python.toLowerCase().replace("python","").trim()}functionProcessed()})}else{functionProcessed()}}else{exec3("python3 -V 2>&1",function(error,stdout){if(!error){const python=stdout.toString().split("\n")[0]||"";appsObj.versions.python3=python.toLowerCase().replace("python","").trim()}functionProcessed()})}}if({}.hasOwnProperty.call(appsObj.versions,"pip")){if(_darwin){const gitHomebrewExists=fs14.existsSync("/usr/local/Cellar/pip")||fs14.existsSync("/opt/homebrew/bin/pip");if(util4.darwinXcodeExists()||gitHomebrewExists){exec3("pip -V 2>&1",function(error,stdout){if(!error){const pip=stdout.toString().split("\n")[0]||"";const parts=pip.split(" ");appsObj.versions.pip=parts.length>=2?parts[1]:""}functionProcessed()})}else{functionProcessed()}}else{exec3("pip -V 2>&1",function(error,stdout){if(!error){const pip=stdout.toString().split("\n")[0]||"";const parts=pip.split(" ");appsObj.versions.pip=parts.length>=2?parts[1]:""}functionProcessed()})}}if({}.hasOwnProperty.call(appsObj.versions,"pip3")){if(_darwin){const gitHomebrewExists=fs14.existsSync("/usr/local/Cellar/pip3")||fs14.existsSync("/opt/homebrew/bin/pip3");if(util4.darwinXcodeExists()||gitHomebrewExists){exec3("pip3 -V 2>&1",function(error,stdout){if(!error){const pip=stdout.toString().split("\n")[0]||"";const parts=pip.split(" ");appsObj.versions.pip3=parts.length>=2?parts[1]:""}functionProcessed()})}else{functionProcessed()}}else{exec3("pip3 -V 2>&1",function(error,stdout){if(!error){const pip=stdout.toString().split("\n")[0]||"";const parts=pip.split(" ");appsObj.versions.pip3=parts.length>=2?parts[1]:""}functionProcessed()})}}if({}.hasOwnProperty.call(appsObj.versions,"java")){if(_darwin){exec3("/usr/libexec/java_home -V 2>&1",function(error,stdout){if(!error&&stdout.toString().toLowerCase().indexOf("no java runtime")===-1){exec3("java -version 2>&1",function(error2,stdout2){if(!error2){const java=stdout2.toString().split("\n")[0]||"";const parts=java.split('"');appsObj.versions.java=parts.length===3?parts[1].trim():""}functionProcessed()})}else{functionProcessed()}})}else{exec3("java -version 2>&1",function(error,stdout){if(!error){const java=stdout.toString().split("\n")[0]||"";const parts=java.split('"');appsObj.versions.java=parts.length===3?parts[1].trim():""}functionProcessed()})}}if({}.hasOwnProperty.call(appsObj.versions,"gcc")){if(_darwin&&util4.darwinXcodeExists()||!_darwin){exec3("gcc -dumpversion",function(error,stdout){if(!error){appsObj.versions.gcc=stdout.toString().split("\n")[0].trim()||""}if(appsObj.versions.gcc.indexOf(".")>-1){functionProcessed()}else{exec3("gcc --version",function(error2,stdout2){if(!error2){const gcc=stdout2.toString().split("\n")[0].trim();if(gcc.indexOf("gcc")>-1&&gcc.indexOf(")")>-1){const parts=gcc.split(")");appsObj.versions.gcc=parts[1].trim()||appsObj.versions.gcc}}functionProcessed()})}})}else{functionProcessed()}}if({}.hasOwnProperty.call(appsObj.versions,"virtualbox")){exec3(util4.getVboxmanage()+" -v 2>&1",function(error,stdout){if(!error){const vbox=stdout.toString().split("\n")[0]||"";const parts=vbox.split("r");appsObj.versions.virtualbox=parts[0]}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"bash")){exec3("bash --version",function(error,stdout){if(!error){const line=stdout.toString().split("\n")[0];const parts=line.split(" version ");if(parts.length>1){appsObj.versions.bash=parts[1].split(" ")[0].split("(")[0]}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"zsh")){exec3("zsh --version",function(error,stdout){if(!error){const line=stdout.toString().split("\n")[0];const parts=line.split("zsh ");if(parts.length>1){appsObj.versions.zsh=parts[1].split(" ")[0]}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"fish")){exec3("fish --version",function(error,stdout){if(!error){const line=stdout.toString().split("\n")[0];const parts=line.split(" version ");if(parts.length>1){appsObj.versions.fish=parts[1].split(" ")[0]}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"bun")){exec3("bun -v",function(error,stdout){if(!error){const line=stdout.toString().split("\n")[0].trim();appsObj.versions.bun=line}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"deno")){exec3("deno -v",function(error,stdout){if(!error){const line=stdout.toString().split("\n")[0].trim();const parts=line.split(" ");if(parts.length>1){appsObj.versions.deno=parts[1]}}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"node")){exec3("node -v",function(error,stdout){if(!error){let line=stdout.toString().split("\n")[0].trim();if(line.startsWith("v")){line=line.slice(1)}appsObj.versions.node=line}functionProcessed()})}if({}.hasOwnProperty.call(appsObj.versions,"powershell")){if(_windows){util4.powerShell("$PSVersionTable").then(stdout=>{const lines=stdout.toString().split("\n").map(line=>line.replace(/ +/g," ").replace(/ +/g,":"));appsObj.versions.powershell=util4.getValue(lines,"psversion");functionProcessed()})}else{functionProcessed()}}if({}.hasOwnProperty.call(appsObj.versions,"dotnet")){if(_windows){util4.powerShell('gci "HKLM:\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP" -recurse | gp -name Version,Release -EA 0 | where { $_.PSChildName -match "^(?!S)\\p{L}"} | select PSChildName, Version, Release').then(stdout=>{const lines=stdout.toString().split("\r\n");let dotnet="";lines.forEach(line=>{line=line.replace(/ +/g," ");const parts=line.split(" ");dotnet=dotnet||(parts[0].toLowerCase().startsWith("client")&&parts.length>2?parts[1].trim():parts[0].toLowerCase().startsWith("full")&&parts.length>2?parts[1].trim():"")});appsObj.versions.dotnet=dotnet.trim();functionProcessed()})}else{functionProcessed()}}}catch(e){if(callback){callback(appsObj.versions)}resolve(appsObj.versions)}})})}exports2.versions=versions;function shell(callback){return new Promise(resolve=>{process.nextTick(()=>{if(_windows){resolve("cmd")}else{let result2="";exec3("echo $SHELL",function(error,stdout){if(!error){result2=stdout.toString().split("\n")[0]}if(callback){callback(result2)}resolve(result2)})}})})}exports2.shell=shell;function getUniqueMacAdresses(){let macs=[];try{const ifaces=os7.networkInterfaces();for(let dev in ifaces){if({}.hasOwnProperty.call(ifaces,dev)){ifaces[dev].forEach(function(details){if(details&&details.mac&&details.mac!=="00:00:00:00:00:00"){const mac=details.mac.toLowerCase();if(macs.indexOf(mac)===-1){macs.push(mac)}}})}}macs=macs.sort(function(a,b){if(a<b){return-1}if(a>b){return 1}return 0})}catch(e){macs.push("00:00:00:00:00:00")}return macs}function uuid(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={os:"",hardware:"",macs:getUniqueMacAdresses()};let parts;if(_darwin){exec3("system_profiler SPHardwareDataType -json",function(error,stdout){if(!error){try{const jsonObj=JSON.parse(stdout.toString());if(jsonObj.SPHardwareDataType&&jsonObj.SPHardwareDataType.length>0){const spHardware=jsonObj.SPHardwareDataType[0];result2.os=spHardware.platform_UUID.toLowerCase();result2.hardware=spHardware.serial_number}}catch(e){util4.noop()}}if(callback){callback(result2)}resolve(result2)})}if(_linux){const cmd=`echo -n "os: "; cat /var/lib/dbus/machine-id 2> /dev/null ||
cat /etc/machine-id 2> /dev/null; echo;
echo -n "hardware: "; cat /sys/class/dmi/id/product_uuid 2> /dev/null; echo;`;exec3(cmd,function(error,stdout){const lines=stdout.toString().split("\n");result2.os=util4.getValue(lines,"os").toLowerCase();result2.hardware=util4.getValue(lines,"hardware").toLowerCase();if(!result2.hardware){const lines2=fs14.readFileSync("/proc/cpuinfo",{encoding:"utf8"}).toString().split("\n");const serial=util4.getValue(lines2,"serial");result2.hardware=serial||""}if(callback){callback(result2)}resolve(result2)})}if(_freebsd||_openbsd||_netbsd){exec3("sysctl -i kern.hostid kern.hostuuid",function(error,stdout){const lines=stdout.toString().split("\n");result2.os=util4.getValue(lines,"kern.hostid",":").toLowerCase();result2.hardware=util4.getValue(lines,"kern.hostuuid",":").toLowerCase();if(result2.os.indexOf("unknown")>=0){result2.os=""}if(result2.hardware.indexOf("unknown")>=0){result2.hardware=""}if(callback){callback(result2)}resolve(result2)})}if(_windows){let sysdir="%windir%\\System32";if(process.arch==="ia32"&&Object.prototype.hasOwnProperty.call(process.env,"PROCESSOR_ARCHITEW6432")){sysdir="%windir%\\sysnative\\cmd.exe /c %windir%\\System32"}util4.powerShell("Get-CimInstance Win32_ComputerSystemProduct | select UUID | fl").then(stdout=>{let lines=stdout.split("\r\n");result2.hardware=util4.getValue(lines,"uuid",":").toLowerCase();exec3(`${sysdir}\\reg query "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography" /v MachineGuid`,util4.execOptsWin,function(error,stdout2){parts=stdout2.toString().split("\n\r")[0].split("REG_SZ");result2.os=parts.length>1?parts[1].replace(/\r+|\n+|\s+/ig,"").toLowerCase():"";if(callback){callback(result2)}resolve(result2)})})}})})}exports2.uuid=uuid}});var require_cpu=__commonJS({"node_modules/systeminformation/lib/cpu.js"(exports2){"use strict";var os7=require("os");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var fs14=require("fs");var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var _cpu_speed=0;var _current_cpu={user:0,nice:0,system:0,idle:0,irq:0,steal:0,guest:0,load:0,tick:0,ms:0,currentLoad:0,currentLoadUser:0,currentLoadSystem:0,currentLoadNice:0,currentLoadIdle:0,currentLoadIrq:0,currentLoadSteal:0,currentLoadGuest:0,rawCurrentLoad:0,rawCurrentLoadUser:0,rawCurrentLoadSystem:0,rawCurrentLoadNice:0,rawCurrentLoadIdle:0,rawCurrentLoadIrq:0,rawCurrentLoadSteal:0,rawCurrentLoadGuest:0};var _cpus=[];var _corecount=0;var AMDBaseFrequencies={"8346":"1.8","8347":"1.9","8350":"2.0","8354":"2.2","8356|SE":"2.4","8356":"2.3","8360":"2.5","2372":"2.1","2373":"2.1","2374":"2.2","2376":"2.3","2377":"2.3","2378":"2.4","2379":"2.4","2380":"2.5","2381":"2.5","2382":"2.6","2384":"2.7","2386":"2.8","2387":"2.8","2389":"2.9","2393":"3.1","8374":"2.2","8376":"2.3","8378":"2.4","8379":"2.4","8380":"2.5","8381":"2.5","8382":"2.6","8384":"2.7","8386":"2.8","8387":"2.8","8389":"2.9","8393":"3.1","2419EE":"1.8","2423HE":"2.0","2425HE":"2.1","2427":"2.2","2431":"2.4","2435":"2.6","2439SE":"2.8","8425HE":"2.1","8431":"2.4","8435":"2.6","8439SE":"2.8","4122":"2.2","4130":"2.6","4162EE":"1.7","4164EE":"1.8","4170HE":"2.1","4174HE":"2.3","4176HE":"2.4","4180":"2.6","4184":"2.8","6124HE":"1.8","6128HE":"2.0","6132HE":"2.2","6128":"2.0","6134":"2.3","6136":"2.4","6140":"2.6","6164HE":"1.7","6166HE":"1.8","6168":"1.9","6172":"2.1","6174":"2.2","6176":"2.3","6176SE":"2.3","6180SE":"2.5","3250":"2.5","3260":"2.7","3280":"2.4","4226":"2.7","4228":"2.8","4230":"2.9","4234":"3.1","4238":"3.3","4240":"3.4","4256":"1.6","4274":"2.5","4276":"2.6","4280":"2.8","4284":"3.0","6204":"3.3","6212":"2.6","6220":"3.0","6234":"2.4","6238":"2.6","6262HE":"1.6","6272":"2.1","6274":"2.2","6276":"2.3","6278":"2.4","6282SE":"2.6","6284SE":"2.7","6308":"3.5","6320":"2.8","6328":"3.2","6338P":"2.3","6344":"2.6","6348":"2.8","6366":"1.8","6370P":"2.0","6376":"2.3","6378":"2.4","6380":"2.5","6386":"2.8","FX|4100":"3.6","FX|4120":"3.9","FX|4130":"3.8","FX|4150":"3.8","FX|4170":"4.2","FX|6100":"3.3","FX|6120":"3.6","FX|6130":"3.6","FX|6200":"3.8","FX|8100":"2.8","FX|8120":"3.1","FX|8140":"3.2","FX|8150":"3.6","FX|8170":"3.9","FX|4300":"3.8","FX|4320":"4.0","FX|4350":"4.2","FX|6300":"3.5","FX|6350":"3.9","FX|8300":"3.3","FX|8310":"3.4","FX|8320":"3.5","FX|8350":"4.0","FX|8370":"4.0","FX|9370":"4.4","FX|9590":"4.7","FX|8320E":"3.2","FX|8370E":"3.3","1200":"3.1","Pro 1200":"3.1","1300X":"3.5","Pro 1300":"3.5","1400":"3.2","1500X":"3.5","Pro 1500":"3.5","1600":"3.2","1600X":"3.6","Pro 1600":"3.2","1700":"3.0","Pro 1700":"3.0","1700X":"3.4","Pro 1700X":"3.4","1800X":"3.6","1900X":"3.8","1920":"3.2","1920X":"3.5","1950X":"3.4","200GE":"3.2","Pro 200GE":"3.2","220GE":"3.4","240GE":"3.5","3000G":"3.5","300GE":"3.4","3050GE":"3.4","2200G":"3.5","Pro 2200G":"3.5","2200GE":"3.2","Pro 2200GE":"3.2","2400G":"3.6","Pro 2400G":"3.6","2400GE":"3.2","Pro 2400GE":"3.2","Pro 200U":"2.3","300U":"2.4","2200U":"2.5","3200U":"2.6","2300U":"2.0","Pro 2300U":"2.0","2500U":"2.0","Pro 2500U":"2.2","2600H":"3.2","2700U":"2.0","Pro 2700U":"2.2","2800H":"3.3","7351":"2.4","7351P":"2.4","7401":"2.0","7401P":"2.0","7551P":"2.0","7551":"2.0","7251":"2.1","7261":"2.5","7281":"2.1","7301":"2.2","7371":"3.1","7451":"2.3","7501":"2.0","7571":"2.2","7601":"2.2","V1500B":"2.2","V1780B":"3.35","V1202B":"2.3","V1404I":"2.0","V1605B":"2.0","V1756B":"3.25","V1807B":"3.35","3101":"2.1","3151":"2.7","3201":"1.5","3251":"2.5","3255":"2.5","3301":"2.0","3351":"1.9","3401":"1.85","3451":"2.15","1200|AF":"3.1","2300X":"3.5","2500X":"3.6","2600":"3.4","2600E":"3.1","1600|AF":"3.2","2600X":"3.6","2700":"3.2","2700E":"2.8","Pro 2700":"3.2","2700X":"3.7","Pro 2700X":"3.6","2920X":"3.5","2950X":"3.5","2970WX":"3.0","2990WX":"3.0","Pro 300GE":"3.4","Pro 3125GE":"3.4","3150G":"3.5","Pro 3150G":"3.5","3150GE":"3.3","Pro 3150GE":"3.3","3200G":"3.6","Pro 3200G":"3.6","3200GE":"3.3","Pro 3200GE":"3.3","3350G":"3.6","Pro 3350G":"3.6","3350GE":"3.3","Pro 3350GE":"3.3","3400G":"3.7","Pro 3400G":"3.7","3400GE":"3.3","Pro 3400GE":"3.3","3300U":"2.1","PRO 3300U":"2.1","3450U":"2.1","3500U":"2.1","PRO 3500U":"2.1","3500C":"2.1","3550H":"2.1","3580U":"2.1","3700U":"2.3","PRO 3700U":"2.3","3700C":"2.3","3750H":"2.3","3780U":"2.3","3100":"3.6","3300X":"3.8","3500":"3.6","3500X":"3.6","3600":"3.6","Pro 3600":"3.6","3600X":"3.8","3600XT":"3.8","Pro 3700":"3.6","3700X":"3.6","3800X":"3.9","3800XT":"3.9","3900":"3.1","Pro 3900":"3.1","3900X":"3.8","3900XT":"3.8","3950X":"3.5","3960X":"3.8","3970X":"3.7","3990X":"2.9","3945WX":"4.0","3955WX":"3.9","3975WX":"3.5","3995WX":"2.7","4300GE":"3.5","Pro 4300GE":"3.5","4300G":"3.8","Pro 4300G":"3.8","4600GE":"3.3","Pro 4650GE":"3.3","4600G":"3.7","Pro 4650G":"3.7","4700GE":"3.1","Pro 4750GE":"3.1","4700G":"3.6","Pro 4750G":"3.6","4300U":"2.7","4450U":"2.5","Pro 4450U":"2.5","4500U":"2.3","4600U":"2.1","PRO 4650U":"2.1","4680U":"2.1","4600HS":"3.0","4600H":"3.0","4700U":"2.0","PRO 4750U":"1.7","4800U":"1.8","4800HS":"2.9","4800H":"2.9","4900HS":"3.0","4900H":"3.3","5300U":"2.6","5500U":"2.1","5700U":"1.8","7232P":"3.1","7302P":"3.0","7402P":"2.8","7502P":"2.5","7702P":"2.0","7252":"3.1","7262":"3.2","7272":"2.9","7282":"2.8","7302":"3.0","7352":"2.3","7402":"2.8","7452":"2.35","7502":"2.5","7532":"2.4","7542":"2.9","7552":"2.2","7642":"2.3","7662":"2.0","7702":"2.0","7742":"2.25","7H12":"2.6","7F32":"3.7","7F52":"3.5","7F72":"3.2","7773X":"2.2","7763":"2.45","7713":"2.0","7713P":"2.0","7663":"2.0","7643":"2.3","7573X":"2.8","75F3":"2.95","7543":"2.8","7543P":"2.8","7513":"2.6","7473X":"2.8","7453":"2.75","74F3":"3.2","7443":"2.85","7443P":"2.85","7413":"2.65","7373X":"3.05","73F3":"3.5","7343":"3.2","7313":"3.0","7313P":"3.0","72F3":"3.7","5600X":"3.7","5800X":"3.8","5900X":"3.7","5950X":"3.4","5945WX":"4.1","5955WX":"4.0","5965WX":"3.8","5975WX":"3.6","5995WX":"2.7","7960X":"4.2","7970X":"4.0","7980X":"3.2","7965WX":"4.2","7975WX":"4.0","7985WX":"3.2","7995WX":"2.5","9754":"2.25","9754S":"2.25","9734":"2.2","9684X":"2.55","9384X":"3.1","9184X":"3.55","9654P":"2.4","9654":"2.4","9634":"2.25","9554P":"3.1","9554":"3.1","9534":"2.45","9474F":"3.6","9454P":"2.75","9454":"2.75","9374F":"3.85","9354P":"3.25","9354":"3.25","9334":"2.7","9274F":"4.05","9254":"2.9","9224":"2.5","9174F":"4.1","9124":"3.0"};var socketTypes={1:"Other",2:"Unknown",3:"Daughter Board",4:"ZIF Socket",5:"Replacement/Piggy Back",6:"None",7:"LIF Socket",8:"Slot 1",9:"Slot 2",10:"370 Pin Socket",11:"Slot A",12:"Slot M",13:"423",14:"A (Socket 462)",15:"478",16:"754",17:"940",18:"939",19:"mPGA604",20:"LGA771",21:"LGA775",22:"S1",23:"AM2",24:"F (1207)",25:"LGA1366",26:"G34",27:"AM3",28:"C32",29:"LGA1156",30:"LGA1567",31:"PGA988A",32:"BGA1288",33:"rPGA988B",34:"BGA1023",35:"BGA1224",36:"LGA1155",37:"LGA1356",38:"LGA2011",39:"FS1",40:"FS2",41:"FM1",42:"FM2",43:"LGA2011-3",44:"LGA1356-3",45:"LGA1150",46:"BGA1168",47:"BGA1234",48:"BGA1364",49:"AM4",50:"LGA1151",51:"BGA1356",52:"BGA1440",53:"BGA1515",54:"LGA3647-1",55:"SP3",56:"SP3r2",57:"LGA2066",58:"BGA1392",59:"BGA1510",60:"BGA1528",61:"LGA4189",62:"LGA1200",63:"LGA4677",64:"LGA1700",65:"BGA1744",66:"BGA1781",67:"BGA1211",68:"BGA2422",69:"LGA1211",70:"LGA2422",71:"LGA5773",72:"BGA5773"};var socketTypesByName={"LGA1150":"i7-5775C i3-4340 i3-4170 G3250 i3-4160T i3-4160 E3-1231 G3258 G3240 i7-4790S i7-4790K i7-4790 i5-4690K i5-4690 i5-4590T i5-4590S i5-4590 i5-4460 i3-4360 i3-4150 G1820 G3420 G3220 i7-4771 i5-4440 i3-4330 i3-4130T i3-4130 E3-1230 i7-4770S i7-4770K i7-4770 i5-4670K i5-4670 i5-4570T i5-4570S i5-4570 i5-4430","LGA1151":"i9-9900KS E-2288G E-2224 G5420 i9-9900T i9-9900 i7-9700T i7-9700F i7-9700E i7-9700 i5-9600 i5-9500T i5-9500F i5-9500 i5-9400T i3-9350K i3-9300 i3-9100T i3-9100F i3-9100 G4930 i9-9900KF i7-9700KF i5-9600KF i5-9400F i5-9400 i3-9350KF i9-9900K i7-9700K i5-9600K G5500 G5400 i7-8700T i7-8086K i5-8600 i5-8500T i5-8500 i5-8400T i3-8300 i3-8100T G4900 i7-8700K i7-8700 i5-8600K i5-8400 i3-8350K i3-8100 E3-1270 G4600 G4560 i7-7700T i7-7700K i7-7700 i5-7600K i5-7600 i5-7500T i5-7500 i5-7400 i3-7350K i3-7300 i3-7100T i3-7100 G3930 G3900 G4400 i7-6700T i7-6700K i7-6700 i5-6600K i5-6600 i5-6500T i5-6500 i5-6400T i5-6400 i3-6300 i3-6100T i3-6100 E3-1270 E3-1270 T4500 T4400","1155":"G440 G460 G465 G470 G530T G540T G550T G1610T G1620T G530 G540 G1610 G550 G1620 G555 G1630 i3-2100T i3-2120T i3-3220T i3-3240T i3-3250T i3-2100 i3-2105 i3-2102 i3-3210 i3-3220 i3-2125 i3-2120 i3-3225 i3-2130 i3-3245 i3-3240 i3-3250 i5-3570T i5-2500T i5-2400S i5-2405S i5-2390T i5-3330S i5-2500S i5-3335S i5-2300 i5-3450S i5-3340S i5-3470S i5-3475S i5-3470T i5-2310 i5-3550S i5-2320 i5-3330 i5-3350P i5-3450 i5-2400 i5-3340 i5-3570S i5-2380P i5-2450P i5-3470 i5-2500K i5-3550 i5-2500 i5-3570 i5-3570K i5-2550K i7-3770T i7-2600S i7-3770S i7-2600K i7-2600 i7-3770 i7-3770K i7-2700K G620T G630T G640T G2020T G645T G2100T G2030T G622 G860T G620 G632 G2120T G630 G640 G2010 G840 G2020 G850 G645 G2030 G860 G2120 G870 G2130 G2140 E3-1220L E3-1220L E3-1260L E3-1265L E3-1220 E3-1225 E3-1220 E3-1235 E3-1225 E3-1230 E3-1230 E3-1240 E3-1245 E3-1270 E3-1275 E3-1240 E3-1245 E3-1270 E3-1280 E3-1275 E3-1290 E3-1280 E3-1290"};function getSocketTypesByName(str2){let result2="";for(const key in socketTypesByName){const names2=socketTypesByName[key].split(" ");names2.forEach(element=>{if(str2.indexOf(element)>=0){result2=key}})}return result2}function cpuManufacturer(str2){let result2=str2;str2=str2.toLowerCase();if(str2.indexOf("intel")>=0){result2="Intel"}if(str2.indexOf("amd")>=0){result2="AMD"}if(str2.indexOf("qemu")>=0){result2="QEMU"}if(str2.indexOf("hygon")>=0){result2="Hygon"}if(str2.indexOf("centaur")>=0){result2="WinChip/Via"}if(str2.indexOf("vmware")>=0){result2="VMware"}if(str2.indexOf("Xen")>=0){result2="Xen Hypervisor"}if(str2.indexOf("tcg")>=0){result2="QEMU"}if(str2.indexOf("apple")>=0){result2="Apple"}if(str2.indexOf("sifive")>=0){result2="SiFive"}if(str2.indexOf("thead")>=0){result2="T-Head"}if(str2.indexOf("andestech")>=0){result2="Andes Technology"}return result2}function cpuBrandManufacturer(res){res.brand=res.brand.replace(/\(R\)+/g,"®").replace(/\s+/g," ").trim();res.brand=res.brand.replace(/\(TM\)+/g,"™").replace(/\s+/g," ").trim();res.brand=res.brand.replace(/\(C\)+/g,"©").replace(/\s+/g," ").trim();res.brand=res.brand.replace(/CPU+/g,"").replace(/\s+/g," ").trim();res.manufacturer=cpuManufacturer(res.brand);let parts=res.brand.split(" ");parts.shift();res.brand=parts.join(" ");return res}function getAMDSpeed(brand){let result2="0";for(let key in AMDBaseFrequencies){if({}.hasOwnProperty.call(AMDBaseFrequencies,key)){let parts=key.split("|");let found=0;parts.forEach(item=>{if(brand.indexOf(item)>-1){found++}});if(found===parts.length){result2=AMDBaseFrequencies[key]}}}return parseFloat(result2)}function getCpu(){return new Promise(resolve=>{process.nextTick(()=>{const UNKNOWN="unknown";let result2={manufacturer:UNKNOWN,brand:UNKNOWN,vendor:"",family:"",model:"",stepping:"",revision:"",voltage:"",speed:0,speedMin:0,speedMax:0,governor:"",cores:util4.cores(),physicalCores:util4.cores(),performanceCores:util4.cores(),efficiencyCores:0,processors:1,socket:"",flags:"",virtualization:false,cache:{}};cpuFlags().then(flags=>{result2.flags=flags;result2.virtualization=flags.indexOf("vmx")>-1||flags.indexOf("svm")>-1;if(_darwin){exec3("sysctl machdep.cpu hw.cpufrequency_max hw.cpufrequency_min hw.packages hw.physicalcpu_max hw.ncpu hw.tbfrequency hw.cpufamily hw.cpusubfamily",function(error,stdout){let lines=stdout.toString().split("\n");const modelline=util4.getValue(lines,"machdep.cpu.brand_string");const modellineParts=modelline.split("@");result2.brand=modellineParts[0].trim();const speed=modellineParts[1]?modellineParts[1].trim():"0";result2.speed=parseFloat(speed.replace(/GHz+/g,""));let tbFrequency=util4.getValue(lines,"hw.tbfrequency")/1e9;tbFrequency=tbFrequency<.1?tbFrequency*100:tbFrequency;result2.speed=result2.speed===0?tbFrequency:result2.speed;_cpu_speed=result2.speed;result2=cpuBrandManufacturer(result2);result2.speedMin=util4.getValue(lines,"hw.cpufrequency_min")?util4.getValue(lines,"hw.cpufrequency_min")/1e9:result2.speed;result2.speedMax=util4.getValue(lines,"hw.cpufrequency_max")?util4.getValue(lines,"hw.cpufrequency_max")/1e9:result2.speed;result2.vendor=util4.getValue(lines,"machdep.cpu.vendor")||"Apple";result2.family=util4.getValue(lines,"machdep.cpu.family")||util4.getValue(lines,"hw.cpufamily");result2.model=util4.getValue(lines,"machdep.cpu.model");result2.stepping=util4.getValue(lines,"machdep.cpu.stepping")||util4.getValue(lines,"hw.cpusubfamily");result2.virtualization=true;const countProcessors=util4.getValue(lines,"hw.packages");const countCores=util4.getValue(lines,"hw.physicalcpu_max");const countThreads=util4.getValue(lines,"hw.ncpu");if(os7.arch()==="arm64"){result2.socket="SOC";try{const clusters=execSync("ioreg -c IOPlatformDevice -d 3 -r | grep cluster-type").toString().split("\n");const efficiencyCores=clusters.filter(line=>line.indexOf('"E"')>=0).length;const performanceCores=clusters.filter(line=>line.indexOf('"P"')>=0).length;result2.efficiencyCores=efficiencyCores;result2.performanceCores=performanceCores}catch(e){util4.noop()}}if(countProcessors){result2.processors=parseInt(countProcessors)||1}if(countCores&&countThreads){result2.cores=parseInt(countThreads)||util4.cores();result2.physicalCores=parseInt(countCores)||util4.cores()}cpuCache().then(res=>{result2.cache=res;resolve(result2)})})}if(_linux){let modelline="";let lines=[];if(os7.cpus()[0]&&os7.cpus()[0].model){modelline=os7.cpus()[0].model}exec3('export LC_ALL=C; lscpu; echo -n "Governor: "; cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor 2>/dev/null; echo; unset LC_ALL',function(error,stdout){if(!error){lines=stdout.toString().split("\n")}modelline=util4.getValue(lines,"model name")||modelline;modelline=util4.getValue(lines,"bios model name")||modelline;modelline=util4.cleanString(modelline);const modellineParts=modelline.split("@");result2.brand=modellineParts[0].trim();result2.speed=modellineParts[1]?parseFloat(modellineParts[1].trim()):0;if(result2.speed===0&&(result2.brand.indexOf("AMD")>-1||result2.brand.toLowerCase().indexOf("ryzen")>-1)){result2.speed=getAMDSpeed(result2.brand)}if(result2.speed===0){const current=getCpuCurrentSpeedSync();if(current.avg!==0){result2.speed=current.avg}}_cpu_speed=result2.speed;result2.speedMin=Math.round(parseFloat(util4.getValue(lines,"cpu min mhz").replace(/,/g,"."))/10)/100;result2.speedMax=Math.round(parseFloat(util4.getValue(lines,"cpu max mhz").replace(/,/g,"."))/10)/100;result2=cpuBrandManufacturer(result2);result2.vendor=cpuManufacturer(util4.getValue(lines,"vendor id"));result2.family=util4.getValue(lines,"cpu family");result2.model=util4.getValue(lines,"model:");result2.stepping=util4.getValue(lines,"stepping");result2.revision=util4.getValue(lines,"cpu revision");result2.cache.l1d=util4.getValue(lines,"l1d cache");if(result2.cache.l1d){result2.cache.l1d=parseInt(result2.cache.l1d)*(result2.cache.l1d.indexOf("M")!==-1?1024*1024:result2.cache.l1d.indexOf("K")!==-1?1024:1)}result2.cache.l1i=util4.getValue(lines,"l1i cache");if(result2.cache.l1i){result2.cache.l1i=parseInt(result2.cache.l1i)*(result2.cache.l1i.indexOf("M")!==-1?1024*1024:result2.cache.l1i.indexOf("K")!==-1?1024:1)}result2.cache.l2=util4.getValue(lines,"l2 cache");if(result2.cache.l2){result2.cache.l2=parseInt(result2.cache.l2)*(result2.cache.l2.indexOf("M")!==-1?1024*1024:result2.cache.l2.indexOf("K")!==-1?1024:1)}result2.cache.l3=util4.getValue(lines,"l3 cache");if(result2.cache.l3){result2.cache.l3=parseInt(result2.cache.l3)*(result2.cache.l3.indexOf("M")!==-1?1024*1024:result2.cache.l3.indexOf("K")!==-1?1024:1)}const threadsPerCore=util4.getValue(lines,"thread(s) per core")||"1";const processors=util4.getValue(lines,"socket(s)")||"1";const threadsPerCoreInt=parseInt(threadsPerCore,10);const processorsInt=parseInt(processors,10)||1;const coresPerSocket=parseInt(util4.getValue(lines,"core(s) per socket"),10);result2.physicalCores=coresPerSocket?coresPerSocket*processorsInt:result2.cores/threadsPerCoreInt;result2.performanceCores=threadsPerCoreInt>1?result2.cores-result2.physicalCores:result2.cores;result2.efficiencyCores=threadsPerCoreInt>1?result2.cores-threadsPerCoreInt*result2.performanceCores:0;result2.processors=processorsInt;result2.governor=util4.getValue(lines,"governor")||"";if(result2.vendor==="ARM"){const linesRpi=fs14.readFileSync("/proc/cpuinfo").toString().split("\n");const rPIRevision=util4.decodePiCpuinfo(linesRpi);if(rPIRevision.model.toLowerCase().indexOf("raspberry")>=0){result2.family=result2.manufacturer;result2.manufacturer=rPIRevision.manufacturer;result2.brand=rPIRevision.processor;result2.revision=rPIRevision.revisionCode;result2.socket="SOC"}}if(util4.getValue(lines,"architecture")==="riscv64"){const linesRiscV=fs14.readFileSync("/proc/cpuinfo").toString().split("\n");const uarch=util4.getValue(linesRiscV,"uarch")||"";if(uarch.indexOf(",")>-1){const split2=uarch.split(",");result2.manufacturer=cpuManufacturer(split2[0]);result2.brand=split2[1]}}let lines2=[];exec3('export LC_ALL=C; dmidecode –t 4 2>/dev/null | grep "Upgrade: Socket"; unset LC_ALL',function(error2,stdout2){lines2=stdout2.toString().split("\n");if(lines2&&lines2.length){result2.socket=util4.getValue(lines2,"Upgrade").replace("Socket","").trim()||result2.socket}resolve(result2)})})}if(_freebsd||_openbsd||_netbsd){let modelline="";let lines=[];if(os7.cpus()[0]&&os7.cpus()[0].model){modelline=os7.cpus()[0].model}exec3("export LC_ALL=C; dmidecode -t 4; dmidecode -t 7 unset LC_ALL",function(error,stdout){let cache2=[];if(!error){const data=stdout.toString().split("# dmidecode");const processor=data.length>1?data[1]:"";cache2=data.length>2?data[2].split("Cache Information"):[];lines=processor.split("\n")}result2.brand=modelline.split("@")[0].trim();result2.speed=modelline.split("@")[1]?parseFloat(modelline.split("@")[1].trim()):0;if(result2.speed===0&&(result2.brand.indexOf("AMD")>-1||result2.brand.toLowerCase().indexOf("ryzen")>-1)){result2.speed=getAMDSpeed(result2.brand)}if(result2.speed===0){const current=getCpuCurrentSpeedSync();if(current.avg!==0){result2.speed=current.avg}}_cpu_speed=result2.speed;result2.speedMin=result2.speed;result2.speedMax=Math.round(parseFloat(util4.getValue(lines,"max speed").replace(/Mhz/g,""))/10)/100;result2=cpuBrandManufacturer(result2);result2.vendor=cpuManufacturer(util4.getValue(lines,"manufacturer"));let sig=util4.getValue(lines,"signature");sig=sig.split(",");for(let i=0;i<sig.length;i++){sig[i]=sig[i].trim()}result2.family=util4.getValue(sig,"Family"," ",true);result2.model=util4.getValue(sig,"Model"," ",true);result2.stepping=util4.getValue(sig,"Stepping"," ",true);result2.revision="";const voltage=parseFloat(util4.getValue(lines,"voltage"));result2.voltage=isNaN(voltage)?"":voltage.toFixed(2);for(let i=0;i<cache2.length;i++){lines=cache2[i].split("\n");let cacheType=util4.getValue(lines,"Socket Designation").toLowerCase().replace(" ","-").split("-");cacheType=cacheType.length?cacheType[0]:"";const sizeParts=util4.getValue(lines,"Installed Size").split(" ");let size2=parseInt(sizeParts[0],10);const unit=sizeParts.length>1?sizeParts[1]:"kb";size2=size2*(unit==="kb"?1024:unit==="mb"?1024*1024:unit==="gb"?1024*1024*1024:1);if(cacheType){if(cacheType==="l1"){result2.cache[cacheType+"d"]=size2/2;result2.cache[cacheType+"i"]=size2/2}else{result2.cache[cacheType]=size2}}}result2.socket=util4.getValue(lines,"Upgrade").replace("Socket","").trim();const threadCount=util4.getValue(lines,"thread count").trim();const coreCount=util4.getValue(lines,"core count").trim();if(coreCount&&threadCount){result2.cores=parseInt(threadCount,10);result2.physicalCores=parseInt(coreCount,10)}resolve(result2)})}if(_sunos){resolve(result2)}if(_windows){try{const workload=[];workload.push(util4.powerShell("Get-CimInstance Win32_processor | select Name, Revision, L2CacheSize, L3CacheSize, Manufacturer, MaxClockSpeed, Description, UpgradeMethod, Caption, NumberOfLogicalProcessors, NumberOfCores | fl"));workload.push(util4.powerShell("Get-CimInstance Win32_CacheMemory | select CacheType,InstalledSize,Level | fl"));workload.push(util4.powerShell("(Get-CimInstance Win32_ComputerSystem).HypervisorPresent"));Promise.all(workload).then(data=>{let lines=data[0].split("\r\n");let name=util4.getValue(lines,"name",":")||"";if(name.indexOf("@")>=0){result2.brand=name.split("@")[0].trim();result2.speed=name.split("@")[1]?parseFloat(name.split("@")[1].trim()):0;_cpu_speed=result2.speed}else{result2.brand=name.trim();result2.speed=0}result2=cpuBrandManufacturer(result2);result2.revision=util4.getValue(lines,"revision",":");result2.vendor=util4.getValue(lines,"manufacturer",":");result2.speedMax=Math.round(parseFloat(util4.getValue(lines,"maxclockspeed",":").replace(/,/g,"."))/10)/100;if(result2.speed===0&&(result2.brand.indexOf("AMD")>-1||result2.brand.toLowerCase().indexOf("ryzen")>-1)){result2.speed=getAMDSpeed(result2.brand)}if(result2.speed===0){result2.speed=result2.speedMax}result2.speedMin=result2.speed;let description=util4.getValue(lines,"description",":").split(" ");for(let i=0;i<description.length;i++){if(description[i].toLowerCase().startsWith("family")&&i+1<description.length&&description[i+1]){result2.family=description[i+1]}if(description[i].toLowerCase().startsWith("model")&&i+1<description.length&&description[i+1]){result2.model=description[i+1]}if(description[i].toLowerCase().startsWith("stepping")&&i+1<description.length&&description[i+1]){result2.stepping=description[i+1]}}const socketId=util4.getValue(lines,"UpgradeMethod",":");if(socketTypes[socketId]){result2.socket=socketTypes[socketId]}const socketByName=getSocketTypesByName(name);if(socketByName){result2.socket=socketByName}const countProcessors=util4.countLines(lines,"Caption");const countThreads=util4.getValue(lines,"NumberOfLogicalProcessors",":");const countCores=util4.getValue(lines,"NumberOfCores",":");if(countProcessors){result2.processors=parseInt(countProcessors)||1}if(countCores&&countThreads){result2.cores=parseInt(countThreads)||util4.cores();result2.physicalCores=parseInt(countCores)||util4.cores()}if(countProcessors>1){result2.cores=result2.cores*countProcessors;result2.physicalCores=result2.physicalCores*countProcessors}result2.cache=parseWinCache(data[0],data[1]);const hyperv=data[2]?data[2].toString().toLowerCase():"";result2.virtualization=hyperv.indexOf("true")!==-1;resolve(result2)})}catch(e){resolve(result2)}}})})})}function cpu(callback){return new Promise(resolve=>{process.nextTick(()=>{getCpu().then(result2=>{if(callback){callback(result2)}resolve(result2)})})})}exports2.cpu=cpu;function getCpuCurrentSpeedSync(){let cpus2=os7.cpus();let minFreq=999999999;let maxFreq=0;let avgFreq=0;let cores=[];let speeds=[];if(cpus2&&cpus2.length&&cpus2[0].speed){for(let i in cpus2){speeds.push(cpus2[i].speed>100?(cpus2[i].speed+1)/1e3:cpus2[i].speed/10)}}else if(_linux){try{const speedStrings=execSync('cat /proc/cpuinfo | grep "cpu MHz" | cut -d " " -f 3',util4.execOptsLinux).toString().split("\n").filter(line=>line.length>0);for(let i in speedStrings){speeds.push(Math.floor(parseInt(speedStrings[i],10)/10)/100)}}catch{util4.noop()}}if(speeds&&speeds.length){for(let i in speeds){avgFreq=avgFreq+speeds[i];if(speeds[i]>maxFreq){maxFreq=speeds[i]}if(speeds[i]<minFreq){minFreq=speeds[i]}cores.push(parseFloat(speeds[i].toFixed(2)))}avgFreq=avgFreq/speeds.length;return{min:parseFloat(minFreq.toFixed(2)),max:parseFloat(maxFreq.toFixed(2)),avg:parseFloat(avgFreq.toFixed(2)),cores}}else{return{min:0,max:0,avg:0,cores}}}function cpuCurrentSpeed(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=getCpuCurrentSpeedSync();if(result2.avg===0&&_cpu_speed!==0){const currCpuSpeed=parseFloat(_cpu_speed);result2={min:currCpuSpeed,max:currCpuSpeed,avg:currCpuSpeed,cores:[]}}if(callback){callback(result2)}resolve(result2)})})}exports2.cpuCurrentSpeed=cpuCurrentSpeed;function cpuTemperature(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={main:null,cores:[],max:null,socket:[],chipset:null};if(_linux){try{const cmd2='cat /sys/class/thermal/thermal_zone*/type  2>/dev/null; echo "-----"; cat /sys/class/thermal/thermal_zone*/temp 2>/dev/null;';const parts=execSync(cmd2,util4.execOptsLinux).toString().split("-----\n");if(parts.length===2){const lines=parts[0].split("\n");const lines2=parts[1].split("\n");for(let i=0;i<lines.length;i++){const line=lines[i].trim();if(line.startsWith("acpi")&&lines2[i]){result2.socket.push(Math.round(parseInt(lines2[i],10)/100)/10)}if(line.startsWith("pch")&&lines2[i]){result2.chipset=Math.round(parseInt(lines2[i],10)/100)/10}}}}catch(e){util4.noop()}const cmd='for mon in /sys/class/hwmon/hwmon*; do for label in "$mon"/temp*_label; do if [ -f $label ]; then value=${label%_*}_input; echo $(cat "$label")___$(cat "$value"); fi; done; done;';try{exec3(cmd,function(error,stdout){stdout=stdout.toString();const tdiePos=stdout.toLowerCase().indexOf("tdie");if(tdiePos!==-1){stdout=stdout.substring(tdiePos)}let lines=stdout.split("\n");let tctl=0;lines.forEach(line=>{const parts=line.split("___");const label=parts[0];const value=parts.length>1&&parts[1]?parts[1]:"0";if(value&&label&&label.toLowerCase()==="tctl"){tctl=result2.main=Math.round(parseInt(value,10)/100)/10}if(value&&(label===void 0||label&&label.toLowerCase().startsWith("core"))){result2.cores.push(Math.round(parseInt(value,10)/100)/10)}else if(value&&label&&result2.main===null&&(label.toLowerCase().indexOf("package")>=0||label.toLowerCase().indexOf("physical")>=0||label.toLowerCase()==="tccd1")){result2.main=Math.round(parseInt(value,10)/100)/10}});if(tctl&&result2.main===null){result2.main=tctl}if(result2.cores.length>0){if(result2.main===null){result2.main=Math.round(result2.cores.reduce((a,b)=>a+b,0)/result2.cores.length)}let maxtmp=Math.max.apply(Math,result2.cores);result2.max=maxtmp>result2.main?maxtmp:result2.main}if(result2.main!==null){if(result2.max===null){result2.max=result2.main}if(callback){callback(result2)}resolve(result2);return}exec3("sensors",function(error2,stdout2){if(!error2){let lines2=stdout2.toString().split("\n");let tdieTemp=null;let newSectionStarts=true;let section="";lines2.forEach(function(line){if(line.trim()===""){newSectionStarts=true}else if(newSectionStarts){if(line.trim().toLowerCase().startsWith("acpi")){section="acpi"}if(line.trim().toLowerCase().startsWith("pch")){section="pch"}if(line.trim().toLowerCase().startsWith("core")){section="core"}newSectionStarts=false}let regex3=/[+-]([^°]*)/g;let temps=line.match(regex3);let firstPart=line.split(":")[0].toUpperCase();if(section==="acpi"){if(firstPart.indexOf("TEMP")!==-1){result2.socket.push(parseFloat(temps))}}else if(section==="pch"){if(firstPart.indexOf("TEMP")!==-1&&!result2.chipset){result2.chipset=parseFloat(temps)}}if(firstPart.indexOf("PHYSICAL")!==-1||firstPart.indexOf("PACKAGE")!==-1){result2.main=parseFloat(temps)}if(firstPart.indexOf("CORE ")!==-1){result2.cores.push(parseFloat(temps))}if(firstPart.indexOf("TDIE")!==-1&&tdieTemp===null){tdieTemp=parseFloat(temps)}});if(result2.cores.length>0){result2.main=Math.round(result2.cores.reduce((a,b)=>a+b,0)/result2.cores.length);let maxtmp=Math.max.apply(Math,result2.cores);result2.max=maxtmp>result2.main?maxtmp:result2.main}else{if(result2.main===null&&tdieTemp!==null){result2.main=tdieTemp;result2.max=tdieTemp}}if(result2.main!==null||result2.max!==null){if(callback){callback(result2)}resolve(result2);return}}fs14.stat("/sys/class/thermal/thermal_zone0/temp",function(err){if(err===null){fs14.readFile("/sys/class/thermal/thermal_zone0/temp",function(error3,stdout3){if(!error3){let lines2=stdout3.toString().split("\n");if(lines2.length>0){result2.main=parseFloat(lines2[0])/1e3;result2.max=result2.main}}if(callback){callback(result2)}resolve(result2)})}else{exec3("/opt/vc/bin/vcgencmd measure_temp",function(error3,stdout3){if(!error3){let lines2=stdout3.toString().split("\n");if(lines2.length>0&&lines2[0].indexOf("=")){result2.main=parseFloat(lines2[0].split("=")[1]);result2.max=result2.main}}if(callback){callback(result2)}resolve(result2)})}})})})}catch(er){if(callback){callback(result2)}resolve(result2)}}if(_freebsd||_openbsd||_netbsd){exec3("sysctl dev.cpu | grep temp",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");let sum2=0;lines.forEach(function(line){const parts=line.split(":");if(parts.length>1){const temp=parseFloat(parts[1].replace(",","."));if(temp>result2.max){result2.max=temp}sum2=sum2+temp;result2.cores.push(temp)}});if(result2.cores.length){result2.main=Math.round(sum2/result2.cores.length*100)/100}}if(callback){callback(result2)}resolve(result2)})}if(_darwin){let osxTemp=null;try{osxTemp=require("osx-temperature-sensor")}catch(er){osxTemp=null}if(osxTemp){result2=osxTemp.cpuTemperature();if(result2.main){result2.main=Math.round(result2.main*100)/100}if(result2.max){result2.max=Math.round(result2.max*100)/100}if(result2.cores&&result2.cores.length){for(let i=0;i<result2.cores.length;i++){result2.cores[i]=Math.round(result2.cores[i]*100)/100}}}if(callback){callback(result2)}resolve(result2)}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){try{util4.powerShell('Get-CimInstance MSAcpi_ThermalZoneTemperature -Namespace "root/wmi" | Select CurrentTemperature').then((stdout,error)=>{if(!error){let sum2=0;let lines=stdout.split("\r\n").filter(line=>line.trim()!=="").filter((line,idx)=>idx>0);lines.forEach(function(line){let value=(parseInt(line,10)-2732)/10;if(!isNaN(value)){sum2=sum2+value;if(value>result2.max){result2.max=value}result2.cores.push(value)}});if(result2.cores.length){result2.main=sum2/result2.cores.length}}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.cpuTemperature=cpuTemperature;function cpuFlags(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2="";if(_windows){try{exec3('reg query "HKEY_LOCAL_MACHINE\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0" /v FeatureSet',util4.execOptsWin,function(error,stdout){if(!error){let flag_hex=stdout.split("0x").pop().trim();let flag_bin_unpadded=parseInt(flag_hex,16).toString(2);let flag_bin="0".repeat(32-flag_bin_unpadded.length)+flag_bin_unpadded;let all_flags=["fpu","vme","de","pse","tsc","msr","pae","mce","cx8","apic","","sep","mtrr","pge","mca","cmov","pat","pse-36","psn","clfsh","","ds","acpi","mmx","fxsr","sse","sse2","ss","htt","tm","ia64","pbe"];for(let f=0;f<all_flags.length;f++){if(flag_bin[f]==="1"&&all_flags[f]!==""){result2+=" "+all_flags[f]}}result2=result2.trim().toLowerCase()}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_linux){try{exec3("export LC_ALL=C; lscpu; unset LC_ALL",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");lines.forEach(function(line){if(line.split(":")[0].toUpperCase().indexOf("FLAGS")!==-1){result2=line.split(":")[1].trim().toLowerCase()}})}if(!result2){fs14.readFile("/proc/cpuinfo",function(error2,stdout2){if(!error2){let lines=stdout2.toString().split("\n");result2=util4.getValue(lines,"features",":",true).toLowerCase()}if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_freebsd||_openbsd||_netbsd){exec3("export LC_ALL=C; dmidecode -t 4 2>/dev/null; unset LC_ALL",function(error,stdout){let flags=[];if(!error){let parts=stdout.toString().split("	Flags:");const lines=parts.length>1?parts[1].split("	Version:")[0].split("\n"):[];lines.forEach(function(line){let flag=(line.indexOf("(")?line.split("(")[0].toLowerCase():"").trim().replace(/\t/g,"");if(flag){flags.push(flag)}})}result2=flags.join(" ").trim().toLowerCase();if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3("sysctl machdep.cpu.features",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");if(lines.length>0&&lines[0].indexOf("machdep.cpu.features:")!==-1){result2=lines[0].split(":")[1].trim().toLowerCase()}}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}})})}exports2.cpuFlags=cpuFlags;function cpuCache(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={l1d:null,l1i:null,l2:null,l3:null};if(_linux){try{exec3("export LC_ALL=C; lscpu; unset LC_ALL",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");lines.forEach(function(line){let parts=line.split(":");if(parts[0].toUpperCase().indexOf("L1D CACHE")!==-1){result2.l1d=parseInt(parts[1].trim())*(parts[1].indexOf("M")!==-1?1024*1024:parts[1].indexOf("K")!==-1?1024:1)}if(parts[0].toUpperCase().indexOf("L1I CACHE")!==-1){result2.l1i=parseInt(parts[1].trim())*(parts[1].indexOf("M")!==-1?1024*1024:parts[1].indexOf("K")!==-1?1024:1)}if(parts[0].toUpperCase().indexOf("L2 CACHE")!==-1){result2.l2=parseInt(parts[1].trim())*(parts[1].indexOf("M")!==-1?1024*1024:parts[1].indexOf("K")!==-1?1024:1)}if(parts[0].toUpperCase().indexOf("L3 CACHE")!==-1){result2.l3=parseInt(parts[1].trim())*(parts[1].indexOf("M")!==-1?1024*1024:parts[1].indexOf("K")!==-1?1024:1)}})}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_freebsd||_openbsd||_netbsd){exec3("export LC_ALL=C; dmidecode -t 7 2>/dev/null; unset LC_ALL",function(error,stdout){let cache2=[];if(!error){const data=stdout.toString();cache2=data.split("Cache Information");cache2.shift()}for(let i=0;i<cache2.length;i++){const lines=cache2[i].split("\n");let cacheType=util4.getValue(lines,"Socket Designation").toLowerCase().replace(" ","-").split("-");cacheType=cacheType.length?cacheType[0]:"";const sizeParts=util4.getValue(lines,"Installed Size").split(" ");let size2=parseInt(sizeParts[0],10);const unit=sizeParts.length>1?sizeParts[1]:"kb";size2=size2*(unit==="kb"?1024:unit==="mb"?1024*1024:unit==="gb"?1024*1024*1024:1);if(cacheType){if(cacheType==="l1"){result2.cache[cacheType+"d"]=size2/2;result2.cache[cacheType+"i"]=size2/2}else{result2.cache[cacheType]=size2}}}if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3("sysctl hw.l1icachesize hw.l1dcachesize hw.l2cachesize hw.l3cachesize",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");lines.forEach(function(line){let parts=line.split(":");if(parts[0].toLowerCase().indexOf("hw.l1icachesize")!==-1){result2.l1d=parseInt(parts[1].trim())*(parts[1].indexOf("K")!==-1?1024:1)}if(parts[0].toLowerCase().indexOf("hw.l1dcachesize")!==-1){result2.l1i=parseInt(parts[1].trim())*(parts[1].indexOf("K")!==-1?1024:1)}if(parts[0].toLowerCase().indexOf("hw.l2cachesize")!==-1){result2.l2=parseInt(parts[1].trim())*(parts[1].indexOf("K")!==-1?1024:1)}if(parts[0].toLowerCase().indexOf("hw.l3cachesize")!==-1){result2.l3=parseInt(parts[1].trim())*(parts[1].indexOf("K")!==-1?1024:1)}})}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){try{const workload=[];workload.push(util4.powerShell("Get-CimInstance Win32_processor | select L2CacheSize, L3CacheSize | fl"));workload.push(util4.powerShell("Get-CimInstance Win32_CacheMemory | select CacheType,InstalledSize,Level | fl"));Promise.all(workload).then(data=>{result2=parseWinCache(data[0],data[1]);if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}function parseWinCache(linesProc,linesCache){let result2={l1d:null,l1i:null,l2:null,l3:null};let lines=linesProc.split("\r\n");result2.l1d=0;result2.l1i=0;result2.l2=util4.getValue(lines,"l2cachesize",":");result2.l3=util4.getValue(lines,"l3cachesize",":");if(result2.l2){result2.l2=parseInt(result2.l2,10)*1024}else{result2.l2=0}if(result2.l3){result2.l3=parseInt(result2.l3,10)*1024}else{result2.l3=0}const parts=linesCache.split(/\n\s*\n/);let l1i=0;let l1d=0;let l2=0;parts.forEach(function(part){const lines2=part.split("\r\n");const cacheType=util4.getValue(lines2,"CacheType");const level=util4.getValue(lines2,"Level");const installedSize=util4.getValue(lines2,"InstalledSize");if(level==="3"&&cacheType==="3"){result2.l1i=result2.l1i+parseInt(installedSize,10)*1024}if(level==="3"&&cacheType==="4"){result2.l1d=result2.l1d+parseInt(installedSize,10)*1024}if(level==="3"&&cacheType==="5"){l1i=parseInt(installedSize,10)/2;l1d=parseInt(installedSize,10)/2}if(level==="4"&&cacheType==="5"){l2=l2+parseInt(installedSize,10)*1024}});if(!result2.l1i&&!result2.l1d){result2.l1i=l1i;result2.l1d=l1d}if(l2){result2.l2=l2}return result2}exports2.cpuCache=cpuCache;function getLoad(){return new Promise(resolve=>{process.nextTick(()=>{let loads=os7.loadavg().map(function(x){return x/util4.cores()});let avgLoad=parseFloat(Math.max.apply(Math,loads).toFixed(2));let result2={};let now3=Date.now()-_current_cpu.ms;if(now3>=200){_current_cpu.ms=Date.now();const cpus2=os7.cpus().map(function(cpu2){cpu2.times.steal=0;cpu2.times.guest=0;return cpu2});let totalUser=0;let totalSystem=0;let totalNice=0;let totalIrq=0;let totalIdle=0;let totalSteal=0;let totalGuest=0;let cores=[];_corecount=cpus2&&cpus2.length?cpus2.length:0;if(_linux){try{const lines=execSync("cat /proc/stat 2>/dev/null | grep cpu",util4.execOptsLinux).toString().split("\n");if(lines.length>1){lines.shift();if(lines.length===cpus2.length){for(let i=0;i<lines.length;i++){let parts=lines[i].split(" ");if(parts.length>=10){const steal=parseFloat(parts[8])||0;const guest=parseFloat(parts[9])||0;cpus2[i].times.steal=steal;cpus2[i].times.guest=guest}}}}}catch(e){util4.noop()}}for(let i=0;i<_corecount;i++){const cpu2=cpus2[i].times;totalUser+=cpu2.user;totalSystem+=cpu2.sys;totalNice+=cpu2.nice;totalIdle+=cpu2.idle;totalIrq+=cpu2.irq;totalSteal+=cpu2.steal||0;totalGuest+=cpu2.guest||0;let tmpTick=_cpus&&_cpus[i]&&_cpus[i].totalTick?_cpus[i].totalTick:0;let tmpLoad=_cpus&&_cpus[i]&&_cpus[i].totalLoad?_cpus[i].totalLoad:0;let tmpUser=_cpus&&_cpus[i]&&_cpus[i].user?_cpus[i].user:0;let tmpSystem=_cpus&&_cpus[i]&&_cpus[i].sys?_cpus[i].sys:0;let tmpNice=_cpus&&_cpus[i]&&_cpus[i].nice?_cpus[i].nice:0;let tmpIdle=_cpus&&_cpus[i]&&_cpus[i].idle?_cpus[i].idle:0;let tmpIrq=_cpus&&_cpus[i]&&_cpus[i].irq?_cpus[i].irq:0;let tmpSteal=_cpus&&_cpus[i]&&_cpus[i].steal?_cpus[i].steal:0;let tmpGuest=_cpus&&_cpus[i]&&_cpus[i].guest?_cpus[i].guest:0;_cpus[i]=cpu2;_cpus[i].totalTick=_cpus[i].user+_cpus[i].sys+_cpus[i].nice+_cpus[i].irq+_cpus[i].steal+_cpus[i].guest+_cpus[i].idle;_cpus[i].totalLoad=_cpus[i].user+_cpus[i].sys+_cpus[i].nice+_cpus[i].irq+_cpus[i].steal+_cpus[i].guest;_cpus[i].currentTick=_cpus[i].totalTick-tmpTick;_cpus[i].load=_cpus[i].totalLoad-tmpLoad;_cpus[i].loadUser=_cpus[i].user-tmpUser;_cpus[i].loadSystem=_cpus[i].sys-tmpSystem;_cpus[i].loadNice=_cpus[i].nice-tmpNice;_cpus[i].loadIdle=_cpus[i].idle-tmpIdle;_cpus[i].loadIrq=_cpus[i].irq-tmpIrq;_cpus[i].loadSteal=_cpus[i].steal-tmpSteal;_cpus[i].loadGuest=_cpus[i].guest-tmpGuest;cores[i]={};cores[i].load=_cpus[i].load/_cpus[i].currentTick*100;cores[i].loadUser=_cpus[i].loadUser/_cpus[i].currentTick*100;cores[i].loadSystem=_cpus[i].loadSystem/_cpus[i].currentTick*100;cores[i].loadNice=_cpus[i].loadNice/_cpus[i].currentTick*100;cores[i].loadIdle=_cpus[i].loadIdle/_cpus[i].currentTick*100;cores[i].loadIrq=_cpus[i].loadIrq/_cpus[i].currentTick*100;cores[i].loadSteal=_cpus[i].loadSteal/_cpus[i].currentTick*100;cores[i].loadGuest=_cpus[i].loadGuest/_cpus[i].currentTick*100;cores[i].rawLoad=_cpus[i].load;cores[i].rawLoadUser=_cpus[i].loadUser;cores[i].rawLoadSystem=_cpus[i].loadSystem;cores[i].rawLoadNice=_cpus[i].loadNice;cores[i].rawLoadIdle=_cpus[i].loadIdle;cores[i].rawLoadIrq=_cpus[i].loadIrq;cores[i].rawLoadSteal=_cpus[i].loadSteal;cores[i].rawLoadGuest=_cpus[i].loadGuest}let totalTick=totalUser+totalSystem+totalNice+totalIrq+totalSteal+totalGuest+totalIdle;let totalLoad=totalUser+totalSystem+totalNice+totalIrq+totalSteal+totalGuest;let currentTick=totalTick-_current_cpu.tick;result2={avgLoad,currentLoad:(totalLoad-_current_cpu.load)/currentTick*100,currentLoadUser:(totalUser-_current_cpu.user)/currentTick*100,currentLoadSystem:(totalSystem-_current_cpu.system)/currentTick*100,currentLoadNice:(totalNice-_current_cpu.nice)/currentTick*100,currentLoadIdle:(totalIdle-_current_cpu.idle)/currentTick*100,currentLoadIrq:(totalIrq-_current_cpu.irq)/currentTick*100,currentLoadSteal:(totalSteal-_current_cpu.steal)/currentTick*100,currentLoadGuest:(totalGuest-_current_cpu.guest)/currentTick*100,rawCurrentLoad:totalLoad-_current_cpu.load,rawCurrentLoadUser:totalUser-_current_cpu.user,rawCurrentLoadSystem:totalSystem-_current_cpu.system,rawCurrentLoadNice:totalNice-_current_cpu.nice,rawCurrentLoadIdle:totalIdle-_current_cpu.idle,rawCurrentLoadIrq:totalIrq-_current_cpu.irq,rawCurrentLoadSteal:totalSteal-_current_cpu.steal,rawCurrentLoadGuest:totalGuest-_current_cpu.guest,cpus:cores};_current_cpu={user:totalUser,nice:totalNice,system:totalSystem,idle:totalIdle,irq:totalIrq,steal:totalSteal,guest:totalGuest,tick:totalTick,load:totalLoad,ms:_current_cpu.ms,currentLoad:result2.currentLoad,currentLoadUser:result2.currentLoadUser,currentLoadSystem:result2.currentLoadSystem,currentLoadNice:result2.currentLoadNice,currentLoadIdle:result2.currentLoadIdle,currentLoadIrq:result2.currentLoadIrq,currentLoadSteal:result2.currentLoadSteal,currentLoadGuest:result2.currentLoadGuest,rawCurrentLoad:result2.rawCurrentLoad,rawCurrentLoadUser:result2.rawCurrentLoadUser,rawCurrentLoadSystem:result2.rawCurrentLoadSystem,rawCurrentLoadNice:result2.rawCurrentLoadNice,rawCurrentLoadIdle:result2.rawCurrentLoadIdle,rawCurrentLoadIrq:result2.rawCurrentLoadIrq,rawCurrentLoadSteal:result2.rawCurrentLoadSteal,rawCurrentLoadGuest:result2.rawCurrentLoadGuest}}else{let cores=[];for(let i=0;i<_corecount;i++){cores[i]={};cores[i].load=_cpus[i].load/_cpus[i].currentTick*100;cores[i].loadUser=_cpus[i].loadUser/_cpus[i].currentTick*100;cores[i].loadSystem=_cpus[i].loadSystem/_cpus[i].currentTick*100;cores[i].loadNice=_cpus[i].loadNice/_cpus[i].currentTick*100;cores[i].loadIdle=_cpus[i].loadIdle/_cpus[i].currentTick*100;cores[i].loadIrq=_cpus[i].loadIrq/_cpus[i].currentTick*100;cores[i].rawLoad=_cpus[i].load;cores[i].rawLoadUser=_cpus[i].loadUser;cores[i].rawLoadSystem=_cpus[i].loadSystem;cores[i].rawLoadNice=_cpus[i].loadNice;cores[i].rawLoadIdle=_cpus[i].loadIdle;cores[i].rawLoadIrq=_cpus[i].loadIrq;cores[i].rawLoadSteal=_cpus[i].loadSteal;cores[i].rawLoadGuest=_cpus[i].loadGuest}result2={avgLoad,currentLoad:_current_cpu.currentLoad,currentLoadUser:_current_cpu.currentLoadUser,currentLoadSystem:_current_cpu.currentLoadSystem,currentLoadNice:_current_cpu.currentLoadNice,currentLoadIdle:_current_cpu.currentLoadIdle,currentLoadIrq:_current_cpu.currentLoadIrq,currentLoadSteal:_current_cpu.currentLoadSteal,currentLoadGuest:_current_cpu.currentLoadGuest,rawCurrentLoad:_current_cpu.rawCurrentLoad,rawCurrentLoadUser:_current_cpu.rawCurrentLoadUser,rawCurrentLoadSystem:_current_cpu.rawCurrentLoadSystem,rawCurrentLoadNice:_current_cpu.rawCurrentLoadNice,rawCurrentLoadIdle:_current_cpu.rawCurrentLoadIdle,rawCurrentLoadIrq:_current_cpu.rawCurrentLoadIrq,rawCurrentLoadSteal:_current_cpu.rawCurrentLoadSteal,rawCurrentLoadGuest:_current_cpu.rawCurrentLoadGuest,cpus:cores}}resolve(result2)})})}function currentLoad(callback){return new Promise(resolve=>{process.nextTick(()=>{getLoad().then(result2=>{if(callback){callback(result2)}resolve(result2)})})})}exports2.currentLoad=currentLoad;function getFullLoad(){return new Promise(resolve=>{process.nextTick(()=>{const cpus2=os7.cpus();let totalUser=0;let totalSystem=0;let totalNice=0;let totalIrq=0;let totalIdle=0;let result2=0;if(cpus2&&cpus2.length){for(let i=0,len=cpus2.length;i<len;i++){const cpu2=cpus2[i].times;totalUser+=cpu2.user;totalSystem+=cpu2.sys;totalNice+=cpu2.nice;totalIrq+=cpu2.irq;totalIdle+=cpu2.idle}let totalTicks=totalIdle+totalIrq+totalNice+totalSystem+totalUser;result2=(totalTicks-totalIdle)/totalTicks*100}resolve(result2)})})}function fullLoad(callback){return new Promise(resolve=>{process.nextTick(()=>{getFullLoad().then(result2=>{if(callback){callback(result2)}resolve(result2)})})})}exports2.fullLoad=fullLoad}});var require_memory=__commonJS({"node_modules/systeminformation/lib/memory.js"(exports2){"use strict";var os7=require("os");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var util4=require_util2();var fs14=require("fs");var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var OSX_RAM_manufacturers={"0x014F":"Transcend Information","0x2C00":"Micron Technology Inc.","0x802C":"Micron Technology Inc.","0x80AD":"Hynix Semiconductor Inc.","0x80CE":"Samsung Electronics Inc.","0xAD00":"Hynix Semiconductor Inc.","0xCE00":"Samsung Electronics Inc.","0x02FE":"Elpida","0x5105":"Qimonda AG i. In.","0x8551":"Qimonda AG i. In.","0x859B":"Crucial","0x04CD":"G-Skill"};var LINUX_RAM_manufacturers={"017A":"Apacer","0198":"HyperX","029E":"Corsair","04CB":"A-DATA","04CD":"G-Skill","059B":"Crucial","00CE":"Samsung","1315":"Crucial","014F":"Transcend Information","2C00":"Micron Technology Inc.","802C":"Micron Technology Inc.","80AD":"Hynix Semiconductor Inc.","80CE":"Samsung Electronics Inc.","AD00":"Hynix Semiconductor Inc.","CE00":"Samsung Electronics Inc.","02FE":"Elpida","5105":"Qimonda AG i. In.","8551":"Qimonda AG i. In.","859B":"Crucial"};function mem(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={total:os7.totalmem(),free:os7.freemem(),used:os7.totalmem()-os7.freemem(),active:os7.totalmem()-os7.freemem(),available:os7.freemem(),buffers:0,cached:0,slab:0,buffcache:0,swaptotal:0,swapused:0,swapfree:0,writeback:null,dirty:null};if(_linux){try{fs14.readFile("/proc/meminfo",function(error,stdout){if(!error){const lines=stdout.toString().split("\n");result2.total=parseInt(util4.getValue(lines,"memtotal"),10);result2.total=result2.total?result2.total*1024:os7.totalmem();result2.free=parseInt(util4.getValue(lines,"memfree"),10);result2.free=result2.free?result2.free*1024:os7.freemem();result2.used=result2.total-result2.free;result2.buffers=parseInt(util4.getValue(lines,"buffers"),10);result2.buffers=result2.buffers?result2.buffers*1024:0;result2.cached=parseInt(util4.getValue(lines,"cached"),10);result2.cached=result2.cached?result2.cached*1024:0;result2.slab=parseInt(util4.getValue(lines,"slab"),10);result2.slab=result2.slab?result2.slab*1024:0;result2.buffcache=result2.buffers+result2.cached+result2.slab;let available=parseInt(util4.getValue(lines,"memavailable"),10);result2.available=available?available*1024:result2.free+result2.buffcache;result2.active=result2.total-result2.available;result2.swaptotal=parseInt(util4.getValue(lines,"swaptotal"),10);result2.swaptotal=result2.swaptotal?result2.swaptotal*1024:0;result2.swapfree=parseInt(util4.getValue(lines,"swapfree"),10);result2.swapfree=result2.swapfree?result2.swapfree*1024:0;result2.swapused=result2.swaptotal-result2.swapfree;result2.writeback=parseInt(util4.getValue(lines,"writeback"),10);result2.writeback=result2.writeback?result2.writeback*1024:0;result2.dirty=parseInt(util4.getValue(lines,"dirty"),10);result2.dirty=result2.dirty?result2.dirty*1024:0}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_freebsd||_openbsd||_netbsd){try{exec3("/sbin/sysctl hw.realmem hw.physmem vm.stats.vm.v_page_count vm.stats.vm.v_wire_count vm.stats.vm.v_active_count vm.stats.vm.v_inactive_count vm.stats.vm.v_cache_count vm.stats.vm.v_free_count vm.stats.vm.v_page_size",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");const pagesize=parseInt(util4.getValue(lines,"vm.stats.vm.v_page_size"),10);const inactive=parseInt(util4.getValue(lines,"vm.stats.vm.v_inactive_count"),10)*pagesize;const cache2=parseInt(util4.getValue(lines,"vm.stats.vm.v_cache_count"),10)*pagesize;result2.total=parseInt(util4.getValue(lines,"hw.realmem"),10);if(isNaN(result2.total)){result2.total=parseInt(util4.getValue(lines,"hw.physmem"),10)}result2.free=parseInt(util4.getValue(lines,"vm.stats.vm.v_free_count"),10)*pagesize;result2.buffcache=inactive+cache2;result2.available=result2.buffcache+result2.free;result2.active=result2.total-result2.free-result2.buffcache;result2.swaptotal=0;result2.swapfree=0;result2.swapused=0}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_darwin){let pageSize=4096;try{let sysPpageSize=util4.toInt(execSync("sysctl -n vm.pagesize").toString());pageSize=sysPpageSize||pageSize}catch(e){util4.noop()}try{exec3('vm_stat 2>/dev/null | grep "Pages active"',function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2.active=parseInt(lines[0].split(":")[1],10)*pageSize;result2.buffcache=result2.used-result2.active;result2.available=result2.free+result2.buffcache}exec3("sysctl -n vm.swapusage 2>/dev/null",function(error2,stdout2){if(!error2){let lines=stdout2.toString().split("\n");if(lines.length>0){let firstline=lines[0].replace(/,/g,".").replace(/M/g,"");let lineArray=firstline.trim().split("  ");lineArray.forEach(line=>{if(line.toLowerCase().indexOf("total")!==-1){result2.swaptotal=parseFloat(line.split("=")[1].trim())*1024*1024}if(line.toLowerCase().indexOf("used")!==-1){result2.swapused=parseFloat(line.split("=")[1].trim())*1024*1024}if(line.toLowerCase().indexOf("free")!==-1){result2.swapfree=parseFloat(line.split("=")[1].trim())*1024*1024}})}}if(callback){callback(result2)}resolve(result2)})})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_windows){let swaptotal=0;let swapused=0;try{util4.powerShell("Get-CimInstance Win32_PageFileUsage | Select AllocatedBaseSize, CurrentUsage").then((stdout,error)=>{if(!error){let lines=stdout.split("\r\n").filter(line=>line.trim()!=="").filter((line,idx)=>idx>0);lines.forEach(function(line){if(line!==""){line=line.trim().split(/\s\s+/);swaptotal=swaptotal+(parseInt(line[0],10)||0);swapused=swapused+(parseInt(line[1],10)||0)}})}result2.swaptotal=swaptotal*1024*1024;result2.swapused=swapused*1024*1024;result2.swapfree=result2.swaptotal-result2.swapused;if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.mem=mem;function memLayout(callback){function getManufacturerDarwin(manId){if({}.hasOwnProperty.call(OSX_RAM_manufacturers,manId)){return OSX_RAM_manufacturers[manId]}return manId}function getManufacturerLinux(manId){const manIdSearch=manId.replace("0x","").toUpperCase();if(manIdSearch.length===4&&{}.hasOwnProperty.call(LINUX_RAM_manufacturers,manIdSearch)){return LINUX_RAM_manufacturers[manIdSearch]}return manId}return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux||_freebsd||_openbsd||_netbsd){exec3('export LC_ALL=C; dmidecode -t memory 2>/dev/null | grep -iE "Size:|Type|Speed|Manufacturer|Form Factor|Locator|Memory Device|Serial Number|Voltage|Part Number"; unset LC_ALL',function(error,stdout){if(!error){let devices=stdout.toString().split("Memory Device");devices.shift();devices.forEach(function(device){let lines=device.split("\n");const sizeString=util4.getValue(lines,"Size");const size2=sizeString.indexOf("GB")>=0?parseInt(sizeString,10)*1024*1024*1024:parseInt(sizeString,10)*1024*1024;let bank=util4.getValue(lines,"Bank Locator");if(bank.toLowerCase().indexOf("bad")>=0){bank=""}if(parseInt(util4.getValue(lines,"Size"),10)>0){const totalWidth=util4.toInt(util4.getValue(lines,"Total Width"));const dataWidth=util4.toInt(util4.getValue(lines,"Data Width"));result2.push({size:size2,bank,type:util4.getValue(lines,"Type:"),ecc:dataWidth&&totalWidth?totalWidth>dataWidth:false,clockSpeed:util4.getValue(lines,"Configured Clock Speed:")?parseInt(util4.getValue(lines,"Configured Clock Speed:"),10):util4.getValue(lines,"Speed:")?parseInt(util4.getValue(lines,"Speed:"),10):null,formFactor:util4.getValue(lines,"Form Factor:"),manufacturer:getManufacturerLinux(util4.getValue(lines,"Manufacturer:")),partNum:util4.getValue(lines,"Part Number:"),serialNum:util4.getValue(lines,"Serial Number:"),voltageConfigured:parseFloat(util4.getValue(lines,"Configured Voltage:"))||null,voltageMin:parseFloat(util4.getValue(lines,"Minimum Voltage:"))||null,voltageMax:parseFloat(util4.getValue(lines,"Maximum Voltage:"))||null})}else{result2.push({size:0,bank,type:"Empty",ecc:null,clockSpeed:0,formFactor:util4.getValue(lines,"Form Factor:"),partNum:"",serialNum:"",voltageConfigured:null,voltageMin:null,voltageMax:null})}})}if(!result2.length){result2.push({size:os7.totalmem(),bank:"",type:"",ecc:null,clockSpeed:0,formFactor:"",partNum:"",serialNum:"",voltageConfigured:null,voltageMin:null,voltageMax:null});try{let stdout2=execSync("cat /proc/cpuinfo 2>/dev/null",util4.execOptsLinux);let lines=stdout2.toString().split("\n");let model=util4.getValue(lines,"hardware",":",true).toUpperCase();let version=util4.getValue(lines,"revision",":",true).toLowerCase();if(model==="BCM2835"||model==="BCM2708"||model==="BCM2709"||model==="BCM2835"||model==="BCM2837"){const clockSpeed={"0":400,"1":450,"2":450,"3":3200};result2[0].type="LPDDR2";result2[0].type=version&&version[2]&&version[2]==="3"?"LPDDR4":result2[0].type;result2[0].ecc=false;result2[0].clockSpeed=version&&version[2]&&clockSpeed[version[2]]||400;result2[0].clockSpeed=version&&version[4]&&version[4]==="d"?500:result2[0].clockSpeed;result2[0].formFactor="SoC";stdout2=execSync("vcgencmd get_config sdram_freq 2>/dev/null",util4.execOptsLinux);lines=stdout2.toString().split("\n");let freq=parseInt(util4.getValue(lines,"sdram_freq","=",true),10)||0;if(freq){result2[0].clockSpeed=freq}stdout2=execSync("vcgencmd measure_volts sdram_p 2>/dev/null",util4.execOptsLinux);lines=stdout2.toString().split("\n");let voltage=parseFloat(util4.getValue(lines,"volt","=",true))||0;if(voltage){result2[0].voltageConfigured=voltage;result2[0].voltageMin=voltage;result2[0].voltageMax=voltage}}}catch(e){util4.noop()}}if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3("system_profiler SPMemoryDataType",function(error,stdout){if(!error){const allLines=stdout.toString().split("\n");const eccStatus=util4.getValue(allLines,"ecc",":",true).toLowerCase();let devices=stdout.toString().split("        BANK ");let hasBank=true;if(devices.length===1){devices=stdout.toString().split("        DIMM");hasBank=false}devices.shift();devices.forEach(function(device){let lines=device.split("\n");const bank=(hasBank?"BANK ":"DIMM")+lines[0].trim().split("/")[0];const size2=parseInt(util4.getValue(lines,"          Size"));if(size2){result2.push({size:size2*1024*1024*1024,bank,type:util4.getValue(lines,"          Type:"),ecc:eccStatus?eccStatus==="enabled":null,clockSpeed:parseInt(util4.getValue(lines,"          Speed:"),10),formFactor:"",manufacturer:getManufacturerDarwin(util4.getValue(lines,"          Manufacturer:")),partNum:util4.getValue(lines,"          Part Number:"),serialNum:util4.getValue(lines,"          Serial Number:"),voltageConfigured:null,voltageMin:null,voltageMax:null})}else{result2.push({size:0,bank,type:"Empty",ecc:null,clockSpeed:0,formFactor:"",manufacturer:"",partNum:"",serialNum:"",voltageConfigured:null,voltageMin:null,voltageMax:null})}})}if(!result2.length){const lines=stdout.toString().split("\n");const size2=parseInt(util4.getValue(lines,"      Memory:"));const type2=util4.getValue(lines,"      Type:");const manufacturerId=util4.getValue(lines,"      Manufacturer:");if(size2&&type2){result2.push({size:size2*1024*1024*1024,bank:"0",type:type2,ecc:false,clockSpeed:null,formFactor:"SOC",manufacturer:getManufacturerDarwin(manufacturerId),partNum:"",serialNum:"",voltageConfigured:null,voltageMin:null,voltageMax:null})}}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){const memoryTypes="Unknown|Other|DRAM|Synchronous DRAM|Cache DRAM|EDO|EDRAM|VRAM|SRAM|RAM|ROM|FLASH|EEPROM|FEPROM|EPROM|CDRAM|3DRAM|SDRAM|SGRAM|RDRAM|DDR|DDR2|DDR2 FB-DIMM|Reserved|DDR3|FBD2|DDR4|LPDDR|LPDDR2|LPDDR3|LPDDR4|Logical non-volatile device|HBM|HBM2|DDR5|LPDDR5".split("|");const FormFactors="Unknown|Other|SIP|DIP|ZIP|SOJ|Proprietary|SIMM|DIMM|TSOP|PGA|RIMM|SODIMM|SRIMM|SMD|SSMP|QFP|TQFP|SOIC|LCC|PLCC|BGA|FPBGA|LGA".split("|");try{util4.powerShell("Get-CimInstance Win32_PhysicalMemory | select DataWidth,TotalWidth,Capacity,BankLabel,MemoryType,SMBIOSMemoryType,ConfiguredClockSpeed,Speed,FormFactor,Manufacturer,PartNumber,SerialNumber,ConfiguredVoltage,MinVoltage,MaxVoltage,Tag | fl").then((stdout,error)=>{if(!error){let devices=stdout.toString().split(/\n\s*\n/);devices.shift();devices.forEach(function(device){let lines=device.split("\r\n");const dataWidth=util4.toInt(util4.getValue(lines,"DataWidth",":"));const totalWidth=util4.toInt(util4.getValue(lines,"TotalWidth",":"));const size2=parseInt(util4.getValue(lines,"Capacity",":"),10)||0;const tag=util4.getValue(lines,"Tag",":");const tagInt=util4.splitByNumber(tag);if(size2){result2.push({size:size2,bank:util4.getValue(lines,"BankLabel",":")+(tagInt[1]?"/"+tagInt[1]:""),type:memoryTypes[parseInt(util4.getValue(lines,"MemoryType",":"),10)||parseInt(util4.getValue(lines,"SMBIOSMemoryType",":"),10)],ecc:dataWidth&&totalWidth?totalWidth>dataWidth:false,clockSpeed:parseInt(util4.getValue(lines,"ConfiguredClockSpeed",":"),10)||parseInt(util4.getValue(lines,"Speed",":"),10)||0,formFactor:FormFactors[parseInt(util4.getValue(lines,"FormFactor",":"),10)||0],manufacturer:util4.getValue(lines,"Manufacturer",":"),partNum:util4.getValue(lines,"PartNumber",":"),serialNum:util4.getValue(lines,"SerialNumber",":"),voltageConfigured:(parseInt(util4.getValue(lines,"ConfiguredVoltage",":"),10)||0)/1e3,voltageMin:(parseInt(util4.getValue(lines,"MinVoltage",":"),10)||0)/1e3,voltageMax:(parseInt(util4.getValue(lines,"MaxVoltage",":"),10)||0)/1e3})}})}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.memLayout=memLayout}});var require_battery=__commonJS({"node_modules/systeminformation/lib/battery.js"(exports2,module2){"use strict";var exec3=require("child_process").exec;var fs14=require("fs");var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function parseWinBatteryPart(lines,designedCapacity,fullChargeCapacity){const result2={};let status=util4.getValue(lines,"BatteryStatus",":").trim();if(status>=0){const statusValue=status?parseInt(status):0;result2.status=statusValue;result2.hasBattery=true;result2.maxCapacity=fullChargeCapacity||parseInt(util4.getValue(lines,"DesignCapacity",":")||0);result2.designedCapacity=parseInt(util4.getValue(lines,"DesignCapacity",":")||designedCapacity);result2.voltage=parseInt(util4.getValue(lines,"DesignVoltage",":")||0)/1e3;result2.capacityUnit="mWh";result2.percent=parseInt(util4.getValue(lines,"EstimatedChargeRemaining",":")||0);result2.currentCapacity=parseInt(result2.maxCapacity*result2.percent/100);result2.isCharging=statusValue>=6&&statusValue<=9||statusValue===11||statusValue!==3&&statusValue!==1&&result2.percent<100;result2.acConnected=result2.isCharging||statusValue===2;result2.model=util4.getValue(lines,"DeviceID",":")}else{result2.status=-1}return result2}module2.exports=function(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={hasBattery:false,cycleCount:0,isCharging:false,designedCapacity:0,maxCapacity:0,currentCapacity:0,voltage:0,capacityUnit:"",percent:0,timeRemaining:null,acConnected:true,type:"",model:"",manufacturer:"",serial:""};if(_linux){let battery_path="";if(fs14.existsSync("/sys/class/power_supply/BAT1/uevent")){battery_path="/sys/class/power_supply/BAT1/"}else if(fs14.existsSync("/sys/class/power_supply/BAT0/uevent")){battery_path="/sys/class/power_supply/BAT0/"}let acConnected=false;let acPath="";if(fs14.existsSync("/sys/class/power_supply/AC/online")){acPath="/sys/class/power_supply/AC/online"}else if(fs14.existsSync("/sys/class/power_supply/AC0/online")){acPath="/sys/class/power_supply/AC0/online"}if(acPath){const file=fs14.readFileSync(acPath);acConnected=file.toString().trim()==="1"}if(battery_path){fs14.readFile(battery_path+"uevent",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2.isCharging=util4.getValue(lines,"POWER_SUPPLY_STATUS","=").toLowerCase()==="charging";result2.acConnected=acConnected||result2.isCharging;result2.voltage=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_VOLTAGE_NOW","="),10)/1e6;result2.capacityUnit=result2.voltage?"mWh":"mAh";result2.cycleCount=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_CYCLE_COUNT","="),10);result2.maxCapacity=Math.round(parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_CHARGE_FULL","=",true,true),10)/1e3*(result2.voltage||1));const desingedMinVoltage=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_VOLTAGE_MIN_DESIGN","="),10)/1e6;result2.designedCapacity=Math.round(parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_CHARGE_FULL_DESIGN","=",true,true),10)/1e3*(desingedMinVoltage||result2.voltage||1));result2.currentCapacity=Math.round(parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_CHARGE_NOW","="),10)/1e3*(result2.voltage||1));if(!result2.maxCapacity){result2.maxCapacity=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_ENERGY_FULL","=",true,true),10)/1e3;result2.designedCapacity=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_ENERGY_FULL_DESIGN","=",true,true),10)/1e3|result2.maxCapacity;result2.currentCapacity=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_ENERGY_NOW","="),10)/1e3}const percent=util4.getValue(lines,"POWER_SUPPLY_CAPACITY","=");const energy=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_ENERGY_NOW","="),10);const power=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_POWER_NOW","="),10);const current=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_CURRENT_NOW","="),10);const charge=parseInt("0"+util4.getValue(lines,"POWER_SUPPLY_CHARGE_NOW","="),10);result2.percent=parseInt("0"+percent,10);if(result2.maxCapacity&&result2.currentCapacity){result2.hasBattery=true;if(!percent){result2.percent=100*result2.currentCapacity/result2.maxCapacity}}if(result2.isCharging){result2.hasBattery=true}if(energy&&power){result2.timeRemaining=Math.floor(energy/power*60)}else if(current&&charge){result2.timeRemaining=Math.floor(charge/current*60)}else if(current&&result2.currentCapacity){result2.timeRemaining=Math.floor(result2.currentCapacity/current*60)}result2.type=util4.getValue(lines,"POWER_SUPPLY_TECHNOLOGY","=");result2.model=util4.getValue(lines,"POWER_SUPPLY_MODEL_NAME","=");result2.manufacturer=util4.getValue(lines,"POWER_SUPPLY_MANUFACTURER","=");result2.serial=util4.getValue(lines,"POWER_SUPPLY_SERIAL_NUMBER","=");if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}})}else{if(callback){callback(result2)}resolve(result2)}}if(_freebsd||_openbsd||_netbsd){exec3("sysctl -i hw.acpi.battery hw.acpi.acline",function(error,stdout){let lines=stdout.toString().split("\n");const batteries=parseInt("0"+util4.getValue(lines,"hw.acpi.battery.units"),10);const percent=parseInt("0"+util4.getValue(lines,"hw.acpi.battery.life"),10);result2.hasBattery=batteries>0;result2.cycleCount=null;result2.isCharging=util4.getValue(lines,"hw.acpi.acline")!=="1";result2.acConnected=result2.isCharging;result2.maxCapacity=null;result2.currentCapacity=null;result2.capacityUnit="unknown";result2.percent=batteries?percent:null;if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3('ioreg -n AppleSmartBattery -r | egrep "CycleCount|IsCharging|DesignCapacity|MaxCapacity|CurrentCapacity|DeviceName|BatterySerialNumber|Serial|TimeRemaining|Voltage"; pmset -g batt | grep %',function(error,stdout){if(stdout){let lines=stdout.toString().replace(/ +/g,"").replace(/"+/g,"").replace(/-/g,"").split("\n");result2.cycleCount=parseInt("0"+util4.getValue(lines,"cyclecount","="),10);result2.voltage=parseInt("0"+util4.getValue(lines,"voltage","="),10)/1e3;result2.capacityUnit=result2.voltage?"mWh":"mAh";result2.maxCapacity=Math.round(parseInt("0"+util4.getValue(lines,"applerawmaxcapacity","="),10)*(result2.voltage||1));result2.currentCapacity=Math.round(parseInt("0"+util4.getValue(lines,"applerawcurrentcapacity","="),10)*(result2.voltage||1));result2.designedCapacity=Math.round(parseInt("0"+util4.getValue(lines,"DesignCapacity","="),10)*(result2.voltage||1));result2.manufacturer="Apple";result2.serial=util4.getValue(lines,"BatterySerialNumber","=")||util4.getValue(lines,"Serial","=");result2.model=util4.getValue(lines,"DeviceName","=");let percent=null;const line=util4.getValue(lines,"internal","Battery");let parts=line.split(";");if(parts&&parts[0]){let parts2=parts[0].split("	");if(parts2&&parts2[1]){percent=parseFloat(parts2[1].trim().replace(/%/g,""))}}if(parts&&parts[1]){result2.isCharging=parts[1].trim()==="charging";result2.acConnected=parts[1].trim()!=="discharging"}else{result2.isCharging=util4.getValue(lines,"ischarging","=").toLowerCase()==="yes";result2.acConnected=result2.isCharging}if(result2.maxCapacity&&result2.currentCapacity){result2.hasBattery=true;result2.type="Li-ion";result2.percent=percent!==null?percent:Math.round(100*result2.currentCapacity/result2.maxCapacity);if(!result2.isCharging){result2.timeRemaining=parseInt("0"+util4.getValue(lines,"TimeRemaining","="),10)}}}if(callback){callback(result2)}resolve(result2)})}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_windows){try{const workload=[];workload.push(util4.powerShell("Get-CimInstance Win32_Battery | select BatteryStatus, DesignCapacity, DesignVoltage, EstimatedChargeRemaining, DeviceID | fl"));workload.push(util4.powerShell("(Get-WmiObject -Class BatteryStaticData -Namespace ROOT/WMI).DesignedCapacity"));workload.push(util4.powerShell("(Get-CimInstance -Class BatteryFullChargedCapacity -Namespace ROOT/WMI).FullChargedCapacity"));util4.promiseAll(workload).then(data=>{if(data){let parts=data.results[0].split(/\n\s*\n/);let batteries=[];const hasValue=value=>/\S/.test(value);for(let i=0;i<parts.length;i++){if(hasValue(parts[i])&&(!batteries.length||!hasValue(parts[i-1]))){batteries.push([])}if(hasValue(parts[i])){batteries[batteries.length-1].push(parts[i])}}let designCapacities=data.results[1].split("\r\n").filter(e=>e);let fullChargeCapacities=data.results[2].split("\r\n").filter(e=>e);if(batteries.length){let first=false;let additionalBatteries=[];for(let i=0;i<batteries.length;i++){let lines=batteries[i][0].split("\r\n");const designedCapacity=designCapacities&&designCapacities.length>=i+1&&designCapacities[i]?util4.toInt(designCapacities[i]):0;const fullChargeCapacity=fullChargeCapacities&&fullChargeCapacities.length>=i+1&&fullChargeCapacities[i]?util4.toInt(fullChargeCapacities[i]):0;const parsed=parseWinBatteryPart(lines,designedCapacity,fullChargeCapacity);if(!first&&parsed.status>0&&parsed.status!==10){result2.hasBattery=parsed.hasBattery;result2.maxCapacity=parsed.maxCapacity;result2.designedCapacity=parsed.designedCapacity;result2.voltage=parsed.voltage;result2.capacityUnit=parsed.capacityUnit;result2.percent=parsed.percent;result2.currentCapacity=parsed.currentCapacity;result2.isCharging=parsed.isCharging;result2.acConnected=parsed.acConnected;result2.model=parsed.model;first=true}else if(parsed.status!==-1){additionalBatteries.push({hasBattery:parsed.hasBattery,maxCapacity:parsed.maxCapacity,designedCapacity:parsed.designedCapacity,voltage:parsed.voltage,capacityUnit:parsed.capacityUnit,percent:parsed.percent,currentCapacity:parsed.currentCapacity,isCharging:parsed.isCharging,timeRemaining:null,acConnected:parsed.acConnected,model:parsed.model,type:"",manufacturer:"",serial:""})}}if(!first&&additionalBatteries.length){result2=additionalBatteries[0];additionalBatteries.shift()}if(additionalBatteries.length){result2.additionalBatteries=additionalBatteries}}}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}}});var require_graphics=__commonJS({"node_modules/systeminformation/lib/graphics.js"(exports2){"use strict";var fs14=require("fs");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var util4=require_util2();var _platform=process.platform;var _nvidiaSmiPath="";var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var _resolutionX=0;var _resolutionY=0;var _pixelDepth=0;var _refreshRate=0;var videoTypes={"-2":"UNINITIALIZED","-1":"OTHER","0":"HD15","1":"SVIDEO","2":"Composite video","3":"Component video","4":"DVI","5":"HDMI","6":"LVDS","8":"D_JPN","9":"SDI","10":"DP","11":"DP embedded","12":"UDI","13":"UDI embedded","14":"SDTVDONGLE","15":"MIRACAST","2147483648":"INTERNAL"};function getVendorFromModel(model){const manufacturers=[{pattern:"^LG.+",manufacturer:"LG"},{pattern:"^BENQ.+",manufacturer:"BenQ"},{pattern:"^ASUS.+",manufacturer:"Asus"},{pattern:"^DELL.+",manufacturer:"Dell"},{pattern:"^SAMSUNG.+",manufacturer:"Samsung"},{pattern:"^VIEWSON.+",manufacturer:"ViewSonic"},{pattern:"^SONY.+",manufacturer:"Sony"},{pattern:"^ACER.+",manufacturer:"Acer"},{pattern:"^AOC.+",manufacturer:"AOC Monitors"},{pattern:"^HP.+",manufacturer:"HP"},{pattern:"^EIZO.?",manufacturer:"Eizo"},{pattern:"^PHILIPS.?",manufacturer:"Philips"},{pattern:"^IIYAMA.?",manufacturer:"Iiyama"},{pattern:"^SHARP.?",manufacturer:"Sharp"},{pattern:"^NEC.?",manufacturer:"NEC"},{pattern:"^LENOVO.?",manufacturer:"Lenovo"},{pattern:"COMPAQ.?",manufacturer:"Compaq"},{pattern:"APPLE.?",manufacturer:"Apple"},{pattern:"INTEL.?",manufacturer:"Intel"},{pattern:"AMD.?",manufacturer:"AMD"},{pattern:"NVIDIA.?",manufacturer:"NVDIA"}];let result2="";if(model){model=model.toUpperCase();manufacturers.forEach(manufacturer=>{const re=RegExp(manufacturer.pattern);if(re.test(model)){result2=manufacturer.manufacturer}})}return result2}function getVendorFromId(id){const vendors={"610":"Apple","1e6d":"LG","10ac":"DELL","4dd9":"Sony","38a3":"NEC"};return vendors[id]||""}function vendorToId(str2){let result2="";str2=(str2||"").toLowerCase();if(str2.indexOf("apple")>=0){result2="0x05ac"}else if(str2.indexOf("nvidia")>=0){result2="0x10de"}else if(str2.indexOf("intel")>=0){result2="0x8086"}else if(str2.indexOf("ati")>=0||str2.indexOf("amd")>=0){result2="0x1002"}return result2}function getMetalVersion(id){const families={"spdisplays_mtlgpufamilymac1":"mac1","spdisplays_mtlgpufamilymac2":"mac2","spdisplays_mtlgpufamilyapple1":"apple1","spdisplays_mtlgpufamilyapple2":"apple2","spdisplays_mtlgpufamilyapple3":"apple3","spdisplays_mtlgpufamilyapple4":"apple4","spdisplays_mtlgpufamilyapple5":"apple5","spdisplays_mtlgpufamilyapple6":"apple6","spdisplays_mtlgpufamilyapple7":"apple7","spdisplays_metalfeaturesetfamily11":"family1_v1","spdisplays_metalfeaturesetfamily12":"family1_v2","spdisplays_metalfeaturesetfamily13":"family1_v3","spdisplays_metalfeaturesetfamily14":"family1_v4","spdisplays_metalfeaturesetfamily21":"family2_v1"};return families[id]||""}function graphics(callback){function parseLinesDarwin(graphicsArr){const res={controllers:[],displays:[]};try{graphicsArr.forEach(function(item){const bus=(item.sppci_bus||"").indexOf("builtin")>-1?"Built-In":(item.sppci_bus||"").indexOf("pcie")>-1?"PCIe":"";const vram=(parseInt(item.spdisplays_vram||"",10)||0)*((item.spdisplays_vram||"").indexOf("GB")>-1?1024:1);const vramDyn=(parseInt(item.spdisplays_vram_shared||"",10)||0)*((item.spdisplays_vram_shared||"").indexOf("GB")>-1?1024:1);let metalVersion=getMetalVersion(item.spdisplays_metal||item.spdisplays_metalfamily||"");res.controllers.push({vendor:getVendorFromModel(item.spdisplays_vendor||"")||item.spdisplays_vendor||"",model:item.sppci_model||"",bus,vramDynamic:bus==="Built-In",vram:vram||vramDyn||null,deviceId:item["spdisplays_device-id"]||"",vendorId:item["spdisplays_vendor-id"]||vendorToId((item["spdisplays_vendor"]||"")+(item.sppci_model||"")),external:item.sppci_device_type==="spdisplays_egpu",cores:item["sppci_cores"]||null,metalVersion});if(item.spdisplays_ndrvs&&item.spdisplays_ndrvs.length){item.spdisplays_ndrvs.forEach(function(displayItem){const connectionType=displayItem["spdisplays_connection_type"]||"";const currentResolutionParts=(displayItem["_spdisplays_resolution"]||"").split("@");const currentResolution=currentResolutionParts[0].split("x");const pixelParts=(displayItem["_spdisplays_pixels"]||"").split("x");const pixelDepthString=displayItem["spdisplays_depth"]||"";const serial=displayItem["_spdisplays_display-serial-number"]||displayItem["_spdisplays_display-serial-number2"]||null;res.displays.push({vendor:getVendorFromId(displayItem["_spdisplays_display-vendor-id"]||"")||getVendorFromModel(displayItem["_name"]||""),vendorId:displayItem["_spdisplays_display-vendor-id"]||"",model:displayItem["_name"]||"",productionYear:displayItem["_spdisplays_display-year"]||null,serial:serial!=="0"?serial:null,displayId:displayItem["_spdisplays_displayID"]||null,main:displayItem["spdisplays_main"]?displayItem["spdisplays_main"]==="spdisplays_yes":false,builtin:(displayItem["spdisplays_display_type"]||"").indexOf("built-in")>-1,connection:connectionType.indexOf("_internal")>-1?"Internal":connectionType.indexOf("_displayport")>-1?"Display Port":connectionType.indexOf("_hdmi")>-1?"HDMI":null,sizeX:null,sizeY:null,pixelDepth:pixelDepthString==="CGSThirtyBitColor"?30:pixelDepthString==="CGSThirtytwoBitColor"?32:pixelDepthString==="CGSTwentyfourBitColor"?24:null,resolutionX:pixelParts.length>1?parseInt(pixelParts[0],10):null,resolutionY:pixelParts.length>1?parseInt(pixelParts[1],10):null,currentResX:currentResolution.length>1?parseInt(currentResolution[0],10):null,currentResY:currentResolution.length>1?parseInt(currentResolution[1],10):null,positionX:0,positionY:0,currentRefreshRate:currentResolutionParts.length>1?parseInt(currentResolutionParts[1],10):null})})}});return res}catch(e){return res}}function parseLinesLinuxControllers(lines){let controllers=[];let currentController={vendor:"",subVendor:"",model:"",bus:"",busAddress:"",vram:null,vramDynamic:false,pciID:""};let isGraphicsController=false;let pciIDs=[];try{pciIDs=execSync('export LC_ALL=C; dmidecode -t 9 2>/dev/null; unset LC_ALL | grep "Bus Address: "',util4.execOptsLinux).toString().split("\n");for(let i2=0;i2<pciIDs.length;i2++){pciIDs[i2]=pciIDs[i2].replace("Bus Address:","").replace("0000:","").trim()}pciIDs=pciIDs.filter(function(el){return el!=null&&el})}catch(e){util4.noop()}let i=1;lines.forEach(line=>{let subsystem="";if(i<lines.length&&lines[i]){subsystem=lines[i];if(subsystem.indexOf(":")>0){subsystem=subsystem.split(":")[1]}}if(""!==line.trim()){if(" "!==line[0]&&"	"!==line[0]){let isExternal=pciIDs.indexOf(line.split(" ")[0])>=0;let vgapos=line.toLowerCase().indexOf(" vga ");let _3dcontrollerpos=line.toLowerCase().indexOf("3d controller");if(vgapos!==-1||_3dcontrollerpos!==-1){if(_3dcontrollerpos!==-1&&vgapos===-1){vgapos=_3dcontrollerpos}if(currentController.vendor||currentController.model||currentController.bus||currentController.vram!==null||currentController.vramDynamic){controllers.push(currentController);currentController={vendor:"",model:"",bus:"",busAddress:"",vram:null,vramDynamic:false}}const pciIDCandidate=line.split(" ")[0];if(/[\da-fA-F]{2}:[\da-fA-F]{2}\.[\da-fA-F]/.test(pciIDCandidate)){currentController.busAddress=pciIDCandidate}isGraphicsController=true;let endpos=line.search(/\[[0-9a-f]{4}:[0-9a-f]{4}]|$/);let parts=line.substr(vgapos,endpos-vgapos).split(":");currentController.busAddress=line.substr(0,vgapos).trim();if(parts.length>1){parts[1]=parts[1].trim();if(parts[1].toLowerCase().indexOf("corporation")>=0){currentController.vendor=parts[1].substr(0,parts[1].toLowerCase().indexOf("corporation")+11).trim();currentController.model=parts[1].substr(parts[1].toLowerCase().indexOf("corporation")+11,200).split("(")[0].trim();currentController.bus=pciIDs.length>0&&isExternal?"PCIe":"Onboard";currentController.vram=null;currentController.vramDynamic=false}else if(parts[1].toLowerCase().indexOf(" inc.")>=0){if((parts[1].match(/]/g)||[]).length>1){currentController.vendor=parts[1].substr(0,parts[1].toLowerCase().indexOf("]")+1).trim();currentController.model=parts[1].substr(parts[1].toLowerCase().indexOf("]")+1,200).trim().split("(")[0].trim()}else{currentController.vendor=parts[1].substr(0,parts[1].toLowerCase().indexOf(" inc.")+5).trim();currentController.model=parts[1].substr(parts[1].toLowerCase().indexOf(" inc.")+5,200).trim().split("(")[0].trim()}currentController.bus=pciIDs.length>0&&isExternal?"PCIe":"Onboard";currentController.vram=null;currentController.vramDynamic=false}else if(parts[1].toLowerCase().indexOf(" ltd.")>=0){if((parts[1].match(/]/g)||[]).length>1){currentController.vendor=parts[1].substr(0,parts[1].toLowerCase().indexOf("]")+1).trim();currentController.model=parts[1].substr(parts[1].toLowerCase().indexOf("]")+1,200).trim().split("(")[0].trim()}else{currentController.vendor=parts[1].substr(0,parts[1].toLowerCase().indexOf(" ltd.")+5).trim();currentController.model=parts[1].substr(parts[1].toLowerCase().indexOf(" ltd.")+5,200).trim().split("(")[0].trim()}}if(currentController.model&&subsystem.indexOf(currentController.model)!==-1){const subVendor=subsystem.split(currentController.model)[0].trim();if(subVendor){currentController.subVendor=subVendor}}}}else{isGraphicsController=false}}if(isGraphicsController){let parts=line.split(":");if(parts.length>1&&parts[0].replace(/ +/g,"").toLowerCase().indexOf("devicename")!==-1&&parts[1].toLowerCase().indexOf("onboard")!==-1){currentController.bus="Onboard"}if(parts.length>1&&parts[0].replace(/ +/g,"").toLowerCase().indexOf("region")!==-1&&parts[1].toLowerCase().indexOf("memory")!==-1){let memparts=parts[1].split("=");if(memparts.length>1){currentController.vram=parseInt(memparts[1])}}}}i++});if(currentController.vendor||currentController.model||currentController.bus||currentController.busAddress||currentController.vram!==null||currentController.vramDynamic){controllers.push(currentController)}return controllers}function parseLinesLinuxClinfo(controllers,lines){const fieldPattern=/\[([^\]]+)\]\s+(\w+)\s+(.*)/;const devices=lines.reduce((devices2,line)=>{const field=fieldPattern.exec(line.trim());if(field){if(!devices2[field[1]]){devices2[field[1]]={}}devices2[field[1]][field[2]]=field[3]}return devices2},{});for(let deviceId in devices){const device=devices[deviceId];if(device["CL_DEVICE_TYPE"]==="CL_DEVICE_TYPE_GPU"){let busAddress;if(device["CL_DEVICE_TOPOLOGY_AMD"]){const bdf=device["CL_DEVICE_TOPOLOGY_AMD"].match(/[a-zA-Z0-9]+:\d+\.\d+/);if(bdf){busAddress=bdf[0]}}else if(device["CL_DEVICE_PCI_BUS_ID_NV"]&&device["CL_DEVICE_PCI_SLOT_ID_NV"]){const bus=parseInt(device["CL_DEVICE_PCI_BUS_ID_NV"]);const slot=parseInt(device["CL_DEVICE_PCI_SLOT_ID_NV"]);if(!isNaN(bus)&&!isNaN(slot)){const b=bus&255;const d=slot>>3&255;const f=slot&7;busAddress=`${b.toString().padStart(2,"0")}:${d.toString().padStart(2,"0")}.${f}`}}if(busAddress){let controller=controllers.find(controller2=>controller2.busAddress===busAddress);if(!controller){controller={vendor:"",model:"",bus:"",busAddress,vram:null,vramDynamic:false};controllers.push(controller)}controller.vendor=device["CL_DEVICE_VENDOR"];if(device["CL_DEVICE_BOARD_NAME_AMD"]){controller.model=device["CL_DEVICE_BOARD_NAME_AMD"]}else{controller.model=device["CL_DEVICE_NAME"]}const memory=parseInt(device["CL_DEVICE_GLOBAL_MEM_SIZE"]);if(!isNaN(memory)){controller.vram=Math.round(memory/1024/1024)}}}}return controllers}function getNvidiaSmi(){if(_nvidiaSmiPath){return _nvidiaSmiPath}if(_windows){try{const basePath2=util4.WINDIR+"\\System32\\DriverStore\\FileRepository";const candidateDirs=fs14.readdirSync(basePath2).filter(dir=>{return fs14.readdirSync([basePath2,dir].join("/")).includes("nvidia-smi.exe")});const targetDir=candidateDirs.reduce((prevDir,currentDir)=>{const previousNvidiaSmi=fs14.statSync([basePath2,prevDir,"nvidia-smi.exe"].join("/"));const currentNvidiaSmi=fs14.statSync([basePath2,currentDir,"nvidia-smi.exe"].join("/"));return previousNvidiaSmi.ctimeMs>currentNvidiaSmi.ctimeMs?prevDir:currentDir});if(targetDir){_nvidiaSmiPath=[basePath2,targetDir,"nvidia-smi.exe"].join("/")}}catch(e){util4.noop()}}else if(_linux){_nvidiaSmiPath="nvidia-smi"}return _nvidiaSmiPath}function nvidiaSmi(options){const nvidiaSmiExe=getNvidiaSmi();options=options||util4.execOptsWin;if(nvidiaSmiExe){const nvidiaSmiOpts="--query-gpu=driver_version,pci.sub_device_id,name,pci.bus_id,fan.speed,memory.total,memory.used,memory.free,utilization.gpu,utilization.memory,temperature.gpu,temperature.memory,power.draw,power.limit,clocks.gr,clocks.mem --format=csv,noheader,nounits";const cmd=nvidiaSmiExe+" "+nvidiaSmiOpts+(_linux?"  2>/dev/null":"");if(_linux){options.stdio=["pipe","pipe","ignore"]}try{const res=execSync(cmd,options).toString();return res}catch(e){util4.noop()}}return""}function nvidiaDevices(){function safeParseNumber(value){if([null,void 0].includes(value)){return value}return parseFloat(value)}const stdout=nvidiaSmi();if(!stdout){return[]}const gpus=stdout.split("\n").filter(Boolean);let results=gpus.map(gpu=>{const splittedData=gpu.split(", ").map(value=>value.includes("N/A")?void 0:value);if(splittedData.length===16){return{driverVersion:splittedData[0],subDeviceId:splittedData[1],name:splittedData[2],pciBus:splittedData[3],fanSpeed:safeParseNumber(splittedData[4]),memoryTotal:safeParseNumber(splittedData[5]),memoryUsed:safeParseNumber(splittedData[6]),memoryFree:safeParseNumber(splittedData[7]),utilizationGpu:safeParseNumber(splittedData[8]),utilizationMemory:safeParseNumber(splittedData[9]),temperatureGpu:safeParseNumber(splittedData[10]),temperatureMemory:safeParseNumber(splittedData[11]),powerDraw:safeParseNumber(splittedData[12]),powerLimit:safeParseNumber(splittedData[13]),clockCore:safeParseNumber(splittedData[14]),clockMemory:safeParseNumber(splittedData[15])}}else{return{}}});results=results.filter(item=>{return"pciBus"in item});return results}function mergeControllerNvidia(controller,nvidia){if(nvidia.driverVersion){controller.driverVersion=nvidia.driverVersion}if(nvidia.subDeviceId){controller.subDeviceId=nvidia.subDeviceId}if(nvidia.name){controller.name=nvidia.name}if(nvidia.pciBus){controller.pciBus=nvidia.pciBus}if(nvidia.fanSpeed){controller.fanSpeed=nvidia.fanSpeed}if(nvidia.memoryTotal){controller.memoryTotal=nvidia.memoryTotal;controller.vram=nvidia.memoryTotal;controller.vramDynamic=false}if(nvidia.memoryUsed){controller.memoryUsed=nvidia.memoryUsed}if(nvidia.memoryFree){controller.memoryFree=nvidia.memoryFree}if(nvidia.utilizationGpu){controller.utilizationGpu=nvidia.utilizationGpu}if(nvidia.utilizationMemory){controller.utilizationMemory=nvidia.utilizationMemory}if(nvidia.temperatureGpu){controller.temperatureGpu=nvidia.temperatureGpu}if(nvidia.temperatureMemory){controller.temperatureMemory=nvidia.temperatureMemory}if(nvidia.powerDraw){controller.powerDraw=nvidia.powerDraw}if(nvidia.powerLimit){controller.powerLimit=nvidia.powerLimit}if(nvidia.clockCore){controller.clockCore=nvidia.clockCore}if(nvidia.clockMemory){controller.clockMemory=nvidia.clockMemory}return controller}function parseLinesLinuxEdid(edid){let result2={vendor:"",model:"",deviceName:"",main:false,builtin:false,connection:"",sizeX:null,sizeY:null,pixelDepth:null,resolutionX:null,resolutionY:null,currentResX:null,currentResY:null,positionX:0,positionY:0,currentRefreshRate:null};let start=108;if(edid.substr(start,6)==="000000"){start+=36}if(edid.substr(start,6)==="000000"){start+=36}if(edid.substr(start,6)==="000000"){start+=36}if(edid.substr(start,6)==="000000"){start+=36}result2.resolutionX=parseInt("0x0"+edid.substr(start+8,1)+edid.substr(start+4,2));result2.resolutionY=parseInt("0x0"+edid.substr(start+14,1)+edid.substr(start+10,2));result2.sizeX=parseInt("0x0"+edid.substr(start+28,1)+edid.substr(start+24,2));result2.sizeY=parseInt("0x0"+edid.substr(start+29,1)+edid.substr(start+26,2));start=edid.indexOf("000000fc00");if(start>=0){let model_raw=edid.substr(start+10,26);if(model_raw.indexOf("0a")!==-1){model_raw=model_raw.substr(0,model_raw.indexOf("0a"))}try{if(model_raw.length>2){result2.model=model_raw.match(/.{1,2}/g).map(function(v){return String.fromCharCode(parseInt(v,16))}).join("")}}catch(e){util4.noop()}}else{result2.model=""}return result2}function parseLinesLinuxDisplays(lines,depth){let displays=[];let currentDisplay={vendor:"",model:"",deviceName:"",main:false,builtin:false,connection:"",sizeX:null,sizeY:null,pixelDepth:null,resolutionX:null,resolutionY:null,currentResX:null,currentResY:null,positionX:0,positionY:0,currentRefreshRate:null};let is_edid=false;let is_current=false;let edid_raw="";let start=0;for(let i=1;i<lines.length;i++){if(""!==lines[i].trim()){if(" "!==lines[i][0]&&"	"!==lines[i][0]&&lines[i].toLowerCase().indexOf(" connected ")!==-1){if(currentDisplay.model||currentDisplay.main||currentDisplay.builtin||currentDisplay.connection||currentDisplay.sizeX!==null||currentDisplay.pixelDepth!==null||currentDisplay.resolutionX!==null){displays.push(currentDisplay);currentDisplay={vendor:"",model:"",main:false,builtin:false,connection:"",sizeX:null,sizeY:null,pixelDepth:null,resolutionX:null,resolutionY:null,currentResX:null,currentResY:null,positionX:0,positionY:0,currentRefreshRate:null}}let parts=lines[i].split(" ");currentDisplay.connection=parts[0];currentDisplay.main=lines[i].toLowerCase().indexOf(" primary ")>=0;currentDisplay.builtin=parts[0].toLowerCase().indexOf("edp")>=0}if(is_edid){if(lines[i].search(/\S|$/)>start){edid_raw+=lines[i].toLowerCase().trim()}else{let edid_decoded=parseLinesLinuxEdid(edid_raw);currentDisplay.vendor=edid_decoded.vendor;currentDisplay.model=edid_decoded.model;currentDisplay.resolutionX=edid_decoded.resolutionX;currentDisplay.resolutionY=edid_decoded.resolutionY;currentDisplay.sizeX=edid_decoded.sizeX;currentDisplay.sizeY=edid_decoded.sizeY;currentDisplay.pixelDepth=depth;is_edid=false}}if(lines[i].toLowerCase().indexOf("edid:")>=0){is_edid=true;start=lines[i].search(/\S|$/)}if(lines[i].toLowerCase().indexOf("*current")>=0){const parts1=lines[i].split("(");if(parts1&&parts1.length>1&&parts1[0].indexOf("x")>=0){const resParts=parts1[0].trim().split("x");currentDisplay.currentResX=util4.toInt(resParts[0]);currentDisplay.currentResY=util4.toInt(resParts[1])}is_current=true}if(is_current&&lines[i].toLowerCase().indexOf("clock")>=0&&lines[i].toLowerCase().indexOf("hz")>=0&&lines[i].toLowerCase().indexOf("v: height")>=0){const parts1=lines[i].split("clock");if(parts1&&parts1.length>1&&parts1[1].toLowerCase().indexOf("hz")>=0){currentDisplay.currentRefreshRate=util4.toInt(parts1[1])}is_current=false}}}if(currentDisplay.model||currentDisplay.main||currentDisplay.builtin||currentDisplay.connection||currentDisplay.sizeX!==null||currentDisplay.pixelDepth!==null||currentDisplay.resolutionX!==null){displays.push(currentDisplay)}return displays}return new Promise(resolve=>{process.nextTick(()=>{let result2={controllers:[],displays:[]};if(_darwin){let cmd="system_profiler -xml -detailLevel full SPDisplaysDataType";exec3(cmd,function(error,stdout){if(!error){try{const output=stdout.toString();result2=parseLinesDarwin(util4.plistParser(output)[0]._items)}catch(e){util4.noop()}try{stdout=execSync('defaults read /Library/Preferences/com.apple.windowserver.plist 2>/dev/null;defaults read /Library/Preferences/com.apple.windowserver.displays.plist 2>/dev/null; echo ""',{maxBuffer:1024*2e4});const output=(stdout||"").toString();const obj=util4.plistReader(output);if(obj["DisplayAnyUserSets"]&&obj["DisplayAnyUserSets"]["Configs"]&&obj["DisplayAnyUserSets"]["Configs"][0]&&obj["DisplayAnyUserSets"]["Configs"][0]["DisplayConfig"]){const current=obj["DisplayAnyUserSets"]["Configs"][0]["DisplayConfig"];let i=0;current.forEach(o=>{if(o["CurrentInfo"]&&o["CurrentInfo"]["OriginX"]!==void 0&&result2.displays&&result2.displays[i]){result2.displays[i].positionX=o["CurrentInfo"]["OriginX"]}if(o["CurrentInfo"]&&o["CurrentInfo"]["OriginY"]!==void 0&&result2.displays&&result2.displays[i]){result2.displays[i].positionY=o["CurrentInfo"]["OriginY"]}i++})}if(obj["DisplayAnyUserSets"]&&obj["DisplayAnyUserSets"].length>0&&obj["DisplayAnyUserSets"][0].length>0&&obj["DisplayAnyUserSets"][0][0]["DisplayID"]){const current=obj["DisplayAnyUserSets"][0];let i=0;current.forEach(o=>{if("OriginX"in o&&result2.displays&&result2.displays[i]){result2.displays[i].positionX=o["OriginX"]}if("OriginY"in o&&result2.displays&&result2.displays[i]){result2.displays[i].positionY=o["OriginY"]}if(o["Mode"]&&o["Mode"]["BitsPerPixel"]!==void 0&&result2.displays&&result2.displays[i]){result2.displays[i].pixelDepth=o["Mode"]["BitsPerPixel"]}i++})}}catch(e){util4.noop()}}if(callback){callback(result2)}resolve(result2)})}if(_linux){if(util4.isRaspberry()&&util4.isRaspbian()){let cmd=`fbset -s | grep 'mode "'; vcgencmd get_mem gpu; tvservice -s; tvservice -n;`;exec3(cmd,function(error,stdout){let lines=stdout.toString().split("\n");if(lines.length>3&&lines[0].indexOf('mode "')>=-1&&lines[2].indexOf("0x12000a")>-1){const parts=lines[0].replace("mode","").replace(/"/g,"").trim().split("x");if(parts.length===2){result2.displays.push({vendor:"",model:util4.getValue(lines,"device_name","="),main:true,builtin:false,connection:"HDMI",sizeX:null,sizeY:null,pixelDepth:null,resolutionX:parseInt(parts[0],10),resolutionY:parseInt(parts[1],10),currentResX:null,currentResY:null,positionX:0,positionY:0,currentRefreshRate:null})}}if(lines.length>1&&stdout.toString().indexOf("gpu=")>=-1){result2.controllers.push({vendor:"Broadcom",model:util4.getRpiGpu(),bus:"",vram:util4.getValue(lines,"gpu","=").replace("M",""),vramDynamic:true})}if(callback){callback(result2)}resolve(result2)})}else{let cmd="lspci -vvv  2>/dev/null";exec3(cmd,function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2.controllers=parseLinesLinuxControllers(lines);const nvidiaData=nvidiaDevices();result2.controllers=result2.controllers.map(controller=>{return mergeControllerNvidia(controller,nvidiaData.find(contr=>contr.pciBus.toLowerCase().endsWith(controller.busAddress.toLowerCase()))||{})})}let cmd2="clinfo --raw";exec3(cmd2,function(error2,stdout2){if(!error2){let lines=stdout2.toString().split("\n");result2.controllers=parseLinesLinuxClinfo(result2.controllers,lines)}let cmd3="xdpyinfo 2>/dev/null | grep 'depth of root window' | awk '{ print $5 }'";exec3(cmd3,function(error3,stdout3){let depth=0;if(!error3){let lines=stdout3.toString().split("\n");depth=parseInt(lines[0])||0}let cmd4="xrandr --verbose 2>/dev/null";exec3(cmd4,function(error4,stdout4){if(!error4){let lines=stdout4.toString().split("\n");result2.displays=parseLinesLinuxDisplays(lines,depth)}if(callback){callback(result2)}resolve(result2)})})})})}}if(_freebsd||_openbsd||_netbsd){if(callback){callback(null)}resolve(null)}if(_sunos){if(callback){callback(null)}resolve(null)}if(_windows){try{const workload=[];workload.push(util4.powerShell("Get-CimInstance win32_VideoController | fl *"));workload.push(util4.powerShell('gp "HKLM:\\SYSTEM\\ControlSet001\\Control\\Class\\{4d36e968-e325-11ce-bfc1-08002be10318}\\*" -ErrorAction SilentlyContinue | where MatchingDeviceId $null -NE | select MatchingDeviceId,HardwareInformation.qwMemorySize | fl'));workload.push(util4.powerShell("Get-CimInstance win32_desktopmonitor | fl *"));workload.push(util4.powerShell("Get-CimInstance -Namespace root\\wmi -ClassName WmiMonitorBasicDisplayParams | fl"));workload.push(util4.powerShell("Add-Type -AssemblyName System.Windows.Forms; [System.Windows.Forms.Screen]::AllScreens"));workload.push(util4.powerShell("Get-CimInstance -Namespace root\\wmi -ClassName WmiMonitorConnectionParams | fl"));workload.push(util4.powerShell('gwmi WmiMonitorID -Namespace root\\wmi | ForEach-Object {(($_.ManufacturerName -notmatch 0 | foreach {[char]$_}) -join "") + "|" + (($_.ProductCodeID -notmatch 0 | foreach {[char]$_}) -join "") + "|" + (($_.UserFriendlyName -notmatch 0 | foreach {[char]$_}) -join "") + "|" + (($_.SerialNumberID -notmatch 0 | foreach {[char]$_}) -join "") + "|" + $_.InstanceName}'));const nvidiaData=nvidiaDevices();Promise.all(workload).then(data=>{let csections=data[0].replace(/\r/g,"").split(/\n\s*\n/);let vsections=data[1].replace(/\r/g,"").split(/\n\s*\n/);result2.controllers=parseLinesWindowsControllers(csections,vsections);result2.controllers=result2.controllers.map(controller=>{if(controller.vendor.toLowerCase()==="nvidia"){return mergeControllerNvidia(controller,nvidiaData.find(device=>{let windowsSubDeviceId=(controller.subDeviceId||"").toLowerCase();const nvidiaSubDeviceIdParts=device.subDeviceId.split("x");let nvidiaSubDeviceId=nvidiaSubDeviceIdParts.length>1?nvidiaSubDeviceIdParts[1].toLowerCase():nvidiaSubDeviceIdParts[0].toLowerCase();const lengthDifference=Math.abs(windowsSubDeviceId.length-nvidiaSubDeviceId.length);if(windowsSubDeviceId.length>nvidiaSubDeviceId.length){for(let i=0;i<lengthDifference;i++){nvidiaSubDeviceId="0"+nvidiaSubDeviceId}}else if(windowsSubDeviceId.length<nvidiaSubDeviceId.length){for(let i=0;i<lengthDifference;i++){windowsSubDeviceId="0"+windowsSubDeviceId}}return windowsSubDeviceId===nvidiaSubDeviceId})||{})}else{return controller}});let dsections=data[2].replace(/\r/g,"").split(/\n\s*\n/);if(dsections[0].trim()===""){dsections.shift()}if(dsections.length&&dsections[dsections.length-1].trim()===""){dsections.pop()}let msections=data[3].replace(/\r/g,"").split("Active ");msections.shift();let ssections=data[4].replace(/\r/g,"").split("BitsPerPixel ");ssections.shift();let tsections=data[5].replace(/\r/g,"").split(/\n\s*\n/);tsections.shift();const res=data[6].replace(/\r/g,"").split(/\n/);let isections=[];res.forEach(element=>{const parts=element.split("|");if(parts.length===5){isections.push({vendor:parts[0],code:parts[1],model:parts[2],serial:parts[3],instanceId:parts[4]})}});result2.displays=parseLinesWindowsDisplaysPowershell(ssections,msections,dsections,tsections,isections);if(result2.displays.length===1){if(_resolutionX){result2.displays[0].resolutionX=_resolutionX;if(!result2.displays[0].currentResX){result2.displays[0].currentResX=_resolutionX}}if(_resolutionY){result2.displays[0].resolutionY=_resolutionY;if(result2.displays[0].currentResY===0){result2.displays[0].currentResY=_resolutionY}}if(_pixelDepth){result2.displays[0].pixelDepth=_pixelDepth}}result2.displays=result2.displays.map(element=>{if(_refreshRate&&!element.currentRefreshRate){element.currentRefreshRate=_refreshRate}return element});if(callback){callback(result2)}resolve(result2)}).catch(()=>{if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})});function parseLinesWindowsControllers(sections,vections){const memorySizes={};for(const i in vections){if({}.hasOwnProperty.call(vections,i)){if(vections[i].trim()!==""){const lines=vections[i].trim().split("\n");const matchingDeviceId=util4.getValue(lines,"MatchingDeviceId").match(/PCI\\(VEN_[0-9A-F]{4})&(DEV_[0-9A-F]{4})(?:&(SUBSYS_[0-9A-F]{8}))?(?:&(REV_[0-9A-F]{2}))?/i);if(matchingDeviceId){const quadWordmemorySize=parseInt(util4.getValue(lines,"HardwareInformation.qwMemorySize"));if(!isNaN(quadWordmemorySize)){let deviceId=matchingDeviceId[1].toUpperCase()+"&"+matchingDeviceId[2].toUpperCase();if(matchingDeviceId[3]){deviceId+="&"+matchingDeviceId[3].toUpperCase()}if(matchingDeviceId[4]){deviceId+="&"+matchingDeviceId[4].toUpperCase()}memorySizes[deviceId]=quadWordmemorySize}}}}}let controllers=[];for(let i in sections){if({}.hasOwnProperty.call(sections,i)){if(sections[i].trim()!==""){let lines=sections[i].trim().split("\n");let pnpDeviceId=util4.getValue(lines,"PNPDeviceID",":").match(/PCI\\(VEN_[0-9A-F]{4})&(DEV_[0-9A-F]{4})(?:&(SUBSYS_[0-9A-F]{8}))?(?:&(REV_[0-9A-F]{2}))?/i);let subDeviceId=null;let memorySize=null;if(pnpDeviceId){subDeviceId=pnpDeviceId[3]||"";if(subDeviceId){subDeviceId=subDeviceId.split("_")[1]}if(memorySize==null&&pnpDeviceId[3]&&pnpDeviceId[4]){const deviceId=pnpDeviceId[1].toUpperCase()+"&"+pnpDeviceId[2].toUpperCase()+"&"+pnpDeviceId[3].toUpperCase()+"&"+pnpDeviceId[4].toUpperCase();if({}.hasOwnProperty.call(memorySizes,deviceId)){memorySize=memorySizes[deviceId]}}if(memorySize==null&&pnpDeviceId[3]){const deviceId=pnpDeviceId[1].toUpperCase()+"&"+pnpDeviceId[2].toUpperCase()+"&"+pnpDeviceId[3].toUpperCase();if({}.hasOwnProperty.call(memorySizes,deviceId)){memorySize=memorySizes[deviceId]}}if(memorySize==null&&pnpDeviceId[4]){const deviceId=pnpDeviceId[1].toUpperCase()+"&"+pnpDeviceId[2].toUpperCase()+"&"+pnpDeviceId[4].toUpperCase();if({}.hasOwnProperty.call(memorySizes,deviceId)){memorySize=memorySizes[deviceId]}}if(memorySize==null){const deviceId=pnpDeviceId[1].toUpperCase()+"&"+pnpDeviceId[2].toUpperCase();if({}.hasOwnProperty.call(memorySizes,deviceId)){memorySize=memorySizes[deviceId]}}}controllers.push({vendor:util4.getValue(lines,"AdapterCompatibility",":"),model:util4.getValue(lines,"name",":"),bus:util4.getValue(lines,"PNPDeviceID",":").startsWith("PCI")?"PCI":"",vram:(memorySize==null?util4.toInt(util4.getValue(lines,"AdapterRAM",":")):memorySize)/1024/1024,vramDynamic:util4.getValue(lines,"VideoMemoryType",":")==="2",subDeviceId});_resolutionX=util4.toInt(util4.getValue(lines,"CurrentHorizontalResolution",":"))||_resolutionX;_resolutionY=util4.toInt(util4.getValue(lines,"CurrentVerticalResolution",":"))||_resolutionY;_refreshRate=util4.toInt(util4.getValue(lines,"CurrentRefreshRate",":"))||_refreshRate;_pixelDepth=util4.toInt(util4.getValue(lines,"CurrentBitsPerPixel",":"))||_pixelDepth}}}return controllers}function parseLinesWindowsDisplaysPowershell(ssections,msections,dsections,tsections,isections){let displays=[];let vendor="";let model="";let deviceID="";let resolutionX=0;let resolutionY=0;if(dsections&&dsections.length){let linesDisplay=dsections[0].split("\n");vendor=util4.getValue(linesDisplay,"MonitorManufacturer",":");model=util4.getValue(linesDisplay,"Name",":");deviceID=util4.getValue(linesDisplay,"PNPDeviceID",":").replace(/&amp;/g,"&").toLowerCase();resolutionX=util4.toInt(util4.getValue(linesDisplay,"ScreenWidth",":"));resolutionY=util4.toInt(util4.getValue(linesDisplay,"ScreenHeight",":"))}for(let i=0;i<ssections.length;i++){if(ssections[i].trim()!==""){ssections[i]="BitsPerPixel "+ssections[i];msections[i]="Active "+msections[i];if(tsections.length===0||tsections[i]===void 0){tsections[i]="Unknown"}let linesScreen=ssections[i].split("\n");let linesMonitor=msections[i].split("\n");let linesConnection=tsections[i].split("\n");const bitsPerPixel=util4.getValue(linesScreen,"BitsPerPixel");const bounds=util4.getValue(linesScreen,"Bounds").replace("{","").replace("}","").replace(/=/g,":").split(",");const primary=util4.getValue(linesScreen,"Primary");const sizeX=util4.getValue(linesMonitor,"MaxHorizontalImageSize");const sizeY=util4.getValue(linesMonitor,"MaxVerticalImageSize");const instanceName=util4.getValue(linesMonitor,"InstanceName").toLowerCase();const videoOutputTechnology=util4.getValue(linesConnection,"VideoOutputTechnology");const deviceName=util4.getValue(linesScreen,"DeviceName");let displayVendor="";let displayModel="";isections.forEach(element=>{if(element.instanceId.toLowerCase().startsWith(instanceName)&&vendor.startsWith("(")&&model.startsWith("PnP")){displayVendor=element.vendor;displayModel=element.model}});displays.push({vendor:instanceName.startsWith(deviceID)&&displayVendor===""?vendor:displayVendor,model:instanceName.startsWith(deviceID)&&displayModel===""?model:displayModel,deviceName,main:primary.toLowerCase()==="true",builtin:videoOutputTechnology==="2147483648",connection:videoOutputTechnology&&videoTypes[videoOutputTechnology]?videoTypes[videoOutputTechnology]:"",resolutionX:util4.toInt(util4.getValue(bounds,"Width",":")),resolutionY:util4.toInt(util4.getValue(bounds,"Height",":")),sizeX:sizeX?parseInt(sizeX,10):null,sizeY:sizeY?parseInt(sizeY,10):null,pixelDepth:bitsPerPixel,currentResX:util4.toInt(util4.getValue(bounds,"Width",":")),currentResY:util4.toInt(util4.getValue(bounds,"Height",":")),positionX:util4.toInt(util4.getValue(bounds,"X",":")),positionY:util4.toInt(util4.getValue(bounds,"Y",":"))})}}if(ssections.length===0){displays.push({vendor,model,main:true,sizeX:null,sizeY:null,resolutionX,resolutionY,pixelDepth:null,currentResX:resolutionX,currentResY:resolutionY,positionX:0,positionY:0})}return displays}}exports2.graphics=graphics}});var require_filesystem=__commonJS({"node_modules/systeminformation/lib/filesystem.js"(exports2){"use strict";var util4=require_util2();var fs14=require("fs");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var execPromiseSave=util4.promisifySave(require("child_process").exec);var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var _fs_speed={};var _disk_io={};function fsSize(drive,callback){if(util4.isFunction(drive)){callback=drive;drive=""}let macOsDisks=[];let osMounts=[];function getmacOsFsType(fs15){if(!fs15.startsWith("/")){return"NFS"}const parts=fs15.split("/");const fsShort=parts[parts.length-1];const macOsDisksSingle=macOsDisks.filter(item=>item.indexOf(fsShort)>=0);if(macOsDisksSingle.length===1&&macOsDisksSingle[0].indexOf("APFS")>=0){return"APFS"}return"HFS"}function isLinuxTmpFs(fs15){const linuxTmpFileSystems=["rootfs","unionfs","squashfs","cramfs","initrd","initramfs","devtmpfs","tmpfs","udev","devfs","specfs","type","appimaged"];let result2=false;linuxTmpFileSystems.forEach(linuxFs=>{if(fs15.toLowerCase().indexOf(linuxFs)>=0){result2=true}});return result2}function filterLines(stdout){let lines=stdout.toString().split("\n");lines.shift();if(stdout.toString().toLowerCase().indexOf("filesystem")){let removeLines=0;for(let i=0;i<lines.length;i++){if(lines[i]&&lines[i].toLowerCase().startsWith("filesystem")){removeLines=i}}for(let i=0;i<removeLines;i++){lines.shift()}}return lines}function parseDf(lines){let data=[];lines.forEach(function(line){if(line!==""){line=line.replace(/ +/g," ").split(" ");if(line&&(line[0].startsWith("/")||line[6]&&line[6]==="/"||line[0].indexOf("/")>0||line[0].indexOf(":")===1||!_darwin&&!isLinuxTmpFs(line[1]))){const fs15=line[0];const fsType=_linux||_freebsd||_openbsd||_netbsd?line[1]:getmacOsFsType(line[0]);const size2=parseInt(_linux||_freebsd||_openbsd||_netbsd?line[2]:line[1])*1024;const used=parseInt(_linux||_freebsd||_openbsd||_netbsd?line[3]:line[2])*1024;const available=parseInt(_linux||_freebsd||_openbsd||_netbsd?line[4]:line[3])*1024;const use=parseFloat((100*(used/(used+available))).toFixed(2));let rw=osMounts&&Object.keys(osMounts).length>0?osMounts[fs15]||false:null;line.splice(0,_linux||_freebsd||_openbsd||_netbsd?6:5);const mount=line.join(" ");if(!data.find(el=>el.fs===fs15&&el.type===fsType)){data.push({fs:fs15,type:fsType,size:size2,used,available,use,mount,rw})}}}});return data}return new Promise(resolve=>{process.nextTick(()=>{let data=[];if(_linux||_freebsd||_openbsd||_netbsd||_darwin){let cmd="";macOsDisks=[];osMounts={};if(_darwin){cmd="df -kP";try{macOsDisks=execSync("diskutil list").toString().split("\n").filter(line=>{return!line.startsWith("/")&&line.indexOf(":")>0});execSync("mount").toString().split("\n").filter(line=>{return line.startsWith("/")}).forEach(line=>{osMounts[line.split(" ")[0]]=line.toLowerCase().indexOf("read-only")===-1})}catch(e){util4.noop()}}if(_linux){try{cmd="export LC_ALL=C; df -lkPTx squashfs; unset LC_ALL";execSync("cat /proc/mounts 2>/dev/null",util4.execOptsLinux).toString().split("\n").filter(line=>{return line.startsWith("/")}).forEach(line=>{osMounts[line.split(" ")[0]]=osMounts[line.split(" ")[0]]||false;if(line.toLowerCase().indexOf("/snap/")===-1){osMounts[line.split(" ")[0]]=line.toLowerCase().indexOf("rw,")>=0||line.toLowerCase().indexOf(" rw ")>=0}})}catch(e){util4.noop()}}if(_freebsd||_openbsd||_netbsd){try{cmd="df -lkPT";execSync("mount").toString().split("\n").forEach(line=>{osMounts[line.split(" ")[0]]=line.toLowerCase().indexOf("read-only")===-1})}catch(e){util4.noop()}}exec3(cmd,{maxBuffer:1024*1024},function(error,stdout){let lines=filterLines(stdout);data=parseDf(lines);if(drive){data=data.filter(item=>{return item.fs.toLowerCase().indexOf(drive.toLowerCase())>=0||item.mount.toLowerCase().indexOf(drive.toLowerCase())>=0})}if((!error||data.length)&&stdout.toString().trim()!==""){if(callback){callback(data)}resolve(data)}else{exec3("df -kPT",{maxBuffer:1024*1024},function(error2,stdout2){if(!error2){let lines2=filterLines(stdout2);data=parseDf(lines2)}if(callback){callback(data)}resolve(data)})}})}if(_sunos){if(callback){callback(data)}resolve(data)}if(_windows){try{const cmd=`Get-WmiObject Win32_logicaldisk | select Access,Caption,FileSystem,FreeSpace,Size ${drive?"| where -property Caption -eq "+drive:""} | fl`;util4.powerShell(cmd).then((stdout,error)=>{if(!error){let devices=stdout.toString().split(/\n\s*\n/);devices.forEach(function(device){let lines=device.split("\r\n");const size2=util4.toInt(util4.getValue(lines,"size",":"));const free=util4.toInt(util4.getValue(lines,"freespace",":"));const caption=util4.getValue(lines,"caption",":");const rwValue=util4.getValue(lines,"access",":");const rw=rwValue?util4.toInt(rwValue)!==1:null;if(size2){data.push({fs:caption,type:util4.getValue(lines,"filesystem",":"),size:size2,used:size2-free,available:free,use:parseFloat((100*(size2-free)/size2).toFixed(2)),mount:caption,rw})}})}if(callback){callback(data)}resolve(data)})}catch(e){if(callback){callback(data)}resolve(data)}}})})}exports2.fsSize=fsSize;function fsOpenFiles(callback){return new Promise(resolve=>{process.nextTick(()=>{const result2={max:null,allocated:null,available:null};if(_freebsd||_openbsd||_netbsd||_darwin){let cmd="sysctl -i kern.maxfiles kern.num_files kern.open_files";exec3(cmd,{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2.max=parseInt(util4.getValue(lines,"kern.maxfiles",":"),10);result2.allocated=parseInt(util4.getValue(lines,"kern.num_files",":"),10)||parseInt(util4.getValue(lines,"kern.open_files",":"),10);result2.available=result2.max-result2.allocated}if(callback){callback(result2)}resolve(result2)})}if(_linux){fs14.readFile("/proc/sys/fs/file-nr",function(error,stdout){if(!error){let lines=stdout.toString().split("\n");if(lines[0]){const parts=lines[0].replace(/\s+/g," ").split(" ");if(parts.length===3){result2.allocated=parseInt(parts[0],10);result2.available=parseInt(parts[1],10);result2.max=parseInt(parts[2],10);if(!result2.available){result2.available=result2.max-result2.allocated}}}if(callback){callback(result2)}resolve(result2)}else{fs14.readFile("/proc/sys/fs/file-max",function(error2,stdout2){if(!error2){let lines=stdout2.toString().split("\n");if(lines[0]){result2.max=parseInt(lines[0],10)}}if(callback){callback(result2)}resolve(result2)})}})}if(_sunos){if(callback){callback(null)}resolve(null)}if(_windows){if(callback){callback(null)}resolve(null)}})})}exports2.fsOpenFiles=fsOpenFiles;function parseBytes(s){return parseInt(s.substr(s.indexOf(" (")+2,s.indexOf(" Bytes)")-10))}function parseDevices(lines){let devices=[];let i=0;lines.forEach(line=>{if(line.length>0){if(line[0]==="*"){i++}else{let parts=line.split(":");if(parts.length>1){if(!devices[i]){devices[i]={name:"",identifier:"",type:"disk",fsType:"",mount:"",size:0,physical:"HDD",uuid:"",label:"",model:"",serial:"",removable:false,protocol:"",group:"",device:""}}parts[0]=parts[0].trim().toUpperCase().replace(/ +/g,"");parts[1]=parts[1].trim();if("DEVICEIDENTIFIER"===parts[0]){devices[i].identifier=parts[1]}if("DEVICENODE"===parts[0]){devices[i].name=parts[1]}if("VOLUMENAME"===parts[0]){if(parts[1].indexOf("Not applicable")===-1){devices[i].label=parts[1]}}if("PROTOCOL"===parts[0]){devices[i].protocol=parts[1]}if("DISKSIZE"===parts[0]){devices[i].size=parseBytes(parts[1])}if("FILESYSTEMPERSONALITY"===parts[0]){devices[i].fsType=parts[1]}if("MOUNTPOINT"===parts[0]){devices[i].mount=parts[1]}if("VOLUMEUUID"===parts[0]){devices[i].uuid=parts[1]}if("READ-ONLYMEDIA"===parts[0]&&parts[1]==="Yes"){devices[i].physical="CD/DVD"}if("SOLIDSTATE"===parts[0]&&parts[1]==="Yes"){devices[i].physical="SSD"}if("VIRTUAL"===parts[0]){devices[i].type="virtual"}if("REMOVABLEMEDIA"===parts[0]){devices[i].removable=parts[1]==="Removable"}if("PARTITIONTYPE"===parts[0]){devices[i].type="part"}if("DEVICE/MEDIANAME"===parts[0]){devices[i].model=parts[1]}}}}});return devices}function parseBlk(lines){let data=[];lines.filter(line=>line!=="").forEach(line=>{try{line=decodeURIComponent(line.replace(/\\x/g,"%"));line=line.replace(/\\/g,"\\\\");let disk=JSON.parse(line);data.push({"name":disk.name,"type":disk.type,"fsType":disk.fsType,"mount":disk.mountpoint,"size":parseInt(disk.size),"physical":disk.type==="disk"?disk.rota==="0"?"SSD":"HDD":disk.type==="rom"?"CD/DVD":"","uuid":disk.uuid,"label":disk.label,"model":(disk.model||"").trim(),"serial":disk.serial,"removable":disk.rm==="1","protocol":disk.tran,"group":disk.group||""})}catch(e){util4.noop()}});data=util4.unique(data);data=util4.sortByKey(data,["type","name"]);return data}function decodeMdabmData(lines){const raid=util4.getValue(lines,"md_level","=");const label=util4.getValue(lines,"md_name","=");const uuid=util4.getValue(lines,"md_uuid","=");const members=[];lines.forEach(line=>{if(line.toLowerCase().startsWith("md_device_dev")&&line.toLowerCase().indexOf("/dev/")>0){members.push(line.split("/dev/")[1])}});return{raid,label,uuid,members}}function raidMatchLinux(data){let result2=data;try{data.forEach(element=>{if(element.type.startsWith("raid")){const lines=execSync(`mdadm --export --detail /dev/${element.name}`,util4.execOptsLinux).toString().split("\n");const mdData=decodeMdabmData(lines);element.label=mdData.label;element.uuid=mdData.uuid;if(mdData.members&&mdData.members.length&&mdData.raid===element.type){result2=result2.map(blockdevice=>{if(blockdevice.fsType==="linux_raid_member"&&mdData.members.indexOf(blockdevice.name)>=0){blockdevice.group=element.name}return blockdevice})}}})}catch(e){util4.noop()}return result2}function getDevicesLinux(data){const result2=[];data.forEach(element=>{if(element.type.startsWith("disk")){result2.push(element.name)}});return result2}function matchDevicesLinux(data){let result2=data;try{const devices=getDevicesLinux(data);result2=result2.map(blockdevice=>{if(blockdevice.type.startsWith("part")||blockdevice.type.startsWith("disk")){devices.forEach(element=>{if(blockdevice.name.startsWith(element)){blockdevice.device="/dev/"+element}})}return blockdevice})}catch(e){util4.noop()}return result2}function getDevicesMac(data){const result2=[];data.forEach(element=>{if(element.type.startsWith("disk")){result2.push({name:element.name,model:element.model,device:element.name})}if(element.type.startsWith("virtual")){let device="";result2.forEach(e=>{if(e.model===element.model){device=e.device}});if(device){result2.push({name:element.name,model:element.model,device})}}});return result2}function matchDevicesMac(data){let result2=data;try{const devices=getDevicesMac(data);result2=result2.map(blockdevice=>{if(blockdevice.type.startsWith("part")||blockdevice.type.startsWith("disk")||blockdevice.type.startsWith("virtual")){devices.forEach(element=>{if(blockdevice.name.startsWith(element.name)){blockdevice.device=element.device}})}return blockdevice})}catch(e){util4.noop()}return result2}function getDevicesWin(diskDrives){const result2=[];diskDrives.forEach(element=>{const lines=element.split("\r\n");const device=util4.getValue(lines,"DeviceID",":");let partitions=element.split("@{DeviceID=");if(partitions.length>1){partitions=partitions.slice(1);partitions.forEach(partition2=>{result2.push({name:partition2.split(";")[0].toUpperCase(),device})})}});return result2}function matchDevicesWin(data,diskDrives){const devices=getDevicesWin(diskDrives);data.map(element=>{const filteresDevices=devices.filter(e=>{return e.name===element.name.toUpperCase()});if(filteresDevices.length>0){element.device=filteresDevices[0].device}return element});return data}function blkStdoutToObject(stdout){return stdout.toString().replace(/NAME=/g,'{"name":').replace(/FSTYPE=/g,',"fsType":').replace(/TYPE=/g,',"type":').replace(/SIZE=/g,',"size":').replace(/MOUNTPOINT=/g,',"mountpoint":').replace(/UUID=/g,',"uuid":').replace(/ROTA=/g,',"rota":').replace(/RO=/g,',"ro":').replace(/RM=/g,',"rm":').replace(/TRAN=/g,',"tran":').replace(/SERIAL=/g,',"serial":').replace(/LABEL=/g,',"label":').replace(/MODEL=/g,',"model":').replace(/OWNER=/g,',"owner":').replace(/GROUP=/g,',"group":').replace(/\n/g,"}\n")}function blockDevices(callback){return new Promise(resolve=>{process.nextTick(()=>{let data=[];if(_linux){exec3("lsblk -bPo NAME,TYPE,SIZE,FSTYPE,MOUNTPOINT,UUID,ROTA,RO,RM,TRAN,SERIAL,LABEL,MODEL,OWNER 2>/dev/null",{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=blkStdoutToObject(stdout).split("\n");data=parseBlk(lines);data=raidMatchLinux(data);data=matchDevicesLinux(data);if(callback){callback(data)}resolve(data)}else{exec3("lsblk -bPo NAME,TYPE,SIZE,FSTYPE,MOUNTPOINT,UUID,ROTA,RO,RM,LABEL,MODEL,OWNER 2>/dev/null",{maxBuffer:1024*1024},function(error2,stdout2){if(!error2){let lines=blkStdoutToObject(stdout2).split("\n");data=parseBlk(lines);data=raidMatchLinux(data)}if(callback){callback(data)}resolve(data)})}})}if(_darwin){exec3("diskutil info -all",{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");data=parseDevices(lines);data=matchDevicesMac(data)}if(callback){callback(data)}resolve(data)})}if(_sunos){if(callback){callback(data)}resolve(data)}if(_windows){let drivetypes=["Unknown","NoRoot","Removable","Local","Network","CD/DVD","RAM"];try{const workload=[];workload.push(util4.powerShell("Get-CimInstance -ClassName Win32_LogicalDisk | select Caption,DriveType,Name,FileSystem,Size,VolumeSerialNumber,VolumeName | fl"));workload.push(util4.powerShell("Get-WmiObject -Class Win32_diskdrive | Select-Object -Property PNPDeviceId,DeviceID, Model, Size, @{L='Partitions'; E={$_.GetRelated('Win32_DiskPartition').GetRelated('Win32_LogicalDisk') | Select-Object -Property DeviceID, VolumeName, Size, FreeSpace}} | fl"));util4.promiseAll(workload).then(res=>{let logicalDisks=res.results[0].toString().split(/\n\s*\n/);let diskDrives=res.results[1].toString().split(/\n\s*\n/);logicalDisks.forEach(function(device){let lines=device.split("\r\n");let drivetype=util4.getValue(lines,"drivetype",":");if(drivetype){data.push({name:util4.getValue(lines,"name",":"),identifier:util4.getValue(lines,"caption",":"),type:"disk",fsType:util4.getValue(lines,"filesystem",":").toLowerCase(),mount:util4.getValue(lines,"caption",":"),size:util4.getValue(lines,"size",":"),physical:drivetype>=0&&drivetype<=6?drivetypes[drivetype]:drivetypes[0],uuid:util4.getValue(lines,"volumeserialnumber",":"),label:util4.getValue(lines,"volumename",":"),model:"",serial:util4.getValue(lines,"volumeserialnumber",":"),removable:drivetype==="2",protocol:"",group:"",device:""})}});data=matchDevicesWin(data,diskDrives);if(callback){callback(data)}resolve(data)})}catch(e){if(callback){callback(data)}resolve(data)}}if(_freebsd||_openbsd||_netbsd){if(callback){callback(null)}resolve(null)}})})}exports2.blockDevices=blockDevices;function calcFsSpeed(rx,wx){let result2={rx:0,wx:0,tx:0,rx_sec:null,wx_sec:null,tx_sec:null,ms:0};if(_fs_speed&&_fs_speed.ms){result2.rx=rx;result2.wx=wx;result2.tx=result2.rx+result2.wx;result2.ms=Date.now()-_fs_speed.ms;result2.rx_sec=(result2.rx-_fs_speed.bytes_read)/(result2.ms/1e3);result2.wx_sec=(result2.wx-_fs_speed.bytes_write)/(result2.ms/1e3);result2.tx_sec=result2.rx_sec+result2.wx_sec;_fs_speed.rx_sec=result2.rx_sec;_fs_speed.wx_sec=result2.wx_sec;_fs_speed.tx_sec=result2.tx_sec;_fs_speed.bytes_read=result2.rx;_fs_speed.bytes_write=result2.wx;_fs_speed.bytes_overall=result2.rx+result2.wx;_fs_speed.ms=Date.now();_fs_speed.last_ms=result2.ms}else{result2.rx=rx;result2.wx=wx;result2.tx=result2.rx+result2.wx;_fs_speed.rx_sec=null;_fs_speed.wx_sec=null;_fs_speed.tx_sec=null;_fs_speed.bytes_read=result2.rx;_fs_speed.bytes_write=result2.wx;_fs_speed.bytes_overall=result2.rx+result2.wx;_fs_speed.ms=Date.now();_fs_speed.last_ms=0}return result2}function fsStats(callback){return new Promise(resolve=>{process.nextTick(()=>{if(_windows||_freebsd||_openbsd||_netbsd||_sunos){return resolve(null)}let result2={rx:0,wx:0,tx:0,rx_sec:null,wx_sec:null,tx_sec:null,ms:0};let rx=0;let wx=0;if(_fs_speed&&!_fs_speed.ms||_fs_speed&&_fs_speed.ms&&Date.now()-_fs_speed.ms>=500){if(_linux){exec3("lsblk -r 2>/dev/null | grep /",{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");let fs_filter=[];lines.forEach(function(line){if(line!==""){line=line.trim().split(" ");if(fs_filter.indexOf(line[0])===-1){fs_filter.push(line[0])}}});let output=fs_filter.join("|");exec3('cat /proc/diskstats | egrep "'+output+'"',{maxBuffer:1024*1024},function(error2,stdout2){if(!error2){let lines2=stdout2.toString().split("\n");lines2.forEach(function(line){line=line.trim();if(line!==""){line=line.replace(/ +/g," ").split(" ");rx+=parseInt(line[5])*512;wx+=parseInt(line[9])*512}});result2=calcFsSpeed(rx,wx)}if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})}if(_darwin){exec3('ioreg -c IOBlockStorageDriver -k Statistics -r -w0 | sed -n "/IOBlockStorageDriver/,/Statistics/p" | grep "Statistics" | tr -cd "01234567890,\n"',{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");lines.forEach(function(line){line=line.trim();if(line!==""){line=line.split(",");rx+=parseInt(line[2]);wx+=parseInt(line[9])}});result2=calcFsSpeed(rx,wx)}if(callback){callback(result2)}resolve(result2)})}}else{result2.ms=_fs_speed.last_ms;result2.rx=_fs_speed.bytes_read;result2.wx=_fs_speed.bytes_write;result2.tx=_fs_speed.bytes_read+_fs_speed.bytes_write;result2.rx_sec=_fs_speed.rx_sec;result2.wx_sec=_fs_speed.wx_sec;result2.tx_sec=_fs_speed.tx_sec;if(callback){callback(result2)}resolve(result2)}})})}exports2.fsStats=fsStats;function calcDiskIO(rIO,wIO,rWaitTime,wWaitTime,tWaitTime){let result2={rIO:0,wIO:0,tIO:0,rIO_sec:null,wIO_sec:null,tIO_sec:null,rWaitTime:0,wWaitTime:0,tWaitTime:0,rWaitPercent:null,wWaitPercent:null,tWaitPercent:null,ms:0};if(_disk_io&&_disk_io.ms){result2.rIO=rIO;result2.wIO=wIO;result2.tIO=rIO+wIO;result2.ms=Date.now()-_disk_io.ms;result2.rIO_sec=(result2.rIO-_disk_io.rIO)/(result2.ms/1e3);result2.wIO_sec=(result2.wIO-_disk_io.wIO)/(result2.ms/1e3);result2.tIO_sec=result2.rIO_sec+result2.wIO_sec;result2.rWaitTime=rWaitTime;result2.wWaitTime=wWaitTime;result2.tWaitTime=tWaitTime;result2.rWaitPercent=(result2.rWaitTime-_disk_io.rWaitTime)*100/result2.ms;result2.wWaitPercent=(result2.wWaitTime-_disk_io.wWaitTime)*100/result2.ms;result2.tWaitPercent=(result2.tWaitTime-_disk_io.tWaitTime)*100/result2.ms;_disk_io.rIO=rIO;_disk_io.wIO=wIO;_disk_io.rIO_sec=result2.rIO_sec;_disk_io.wIO_sec=result2.wIO_sec;_disk_io.tIO_sec=result2.tIO_sec;_disk_io.rWaitTime=rWaitTime;_disk_io.wWaitTime=wWaitTime;_disk_io.tWaitTime=tWaitTime;_disk_io.rWaitPercent=result2.rWaitPercent;_disk_io.wWaitPercent=result2.wWaitPercent;_disk_io.tWaitPercent=result2.tWaitPercent;_disk_io.last_ms=result2.ms;_disk_io.ms=Date.now()}else{result2.rIO=rIO;result2.wIO=wIO;result2.tIO=rIO+wIO;result2.rWaitTime=rWaitTime;result2.wWaitTime=wWaitTime;result2.tWaitTime=tWaitTime;_disk_io.rIO=rIO;_disk_io.wIO=wIO;_disk_io.rIO_sec=null;_disk_io.wIO_sec=null;_disk_io.tIO_sec=null;_disk_io.rWaitTime=rWaitTime;_disk_io.wWaitTime=wWaitTime;_disk_io.tWaitTime=tWaitTime;_disk_io.rWaitPercent=null;_disk_io.wWaitPercent=null;_disk_io.tWaitPercent=null;_disk_io.last_ms=0;_disk_io.ms=Date.now()}return result2}function disksIO(callback){return new Promise(resolve=>{process.nextTick(()=>{if(_windows){return resolve(null)}if(_sunos){return resolve(null)}let result2={rIO:0,wIO:0,tIO:0,rIO_sec:null,wIO_sec:null,tIO_sec:null,rWaitTime:0,wWaitTime:0,tWaitTime:0,rWaitPercent:null,wWaitPercent:null,tWaitPercent:null,ms:0};let rIO=0;let wIO=0;let rWaitTime=0;let wWaitTime=0;let tWaitTime=0;if(_disk_io&&!_disk_io.ms||_disk_io&&_disk_io.ms&&Date.now()-_disk_io.ms>=500){if(_linux||_freebsd||_openbsd||_netbsd){let cmd='for mount in `lsblk 2>/dev/null | grep " disk " | sed "s/[│└─├]//g" | awk \'{$1=$1};1\' | cut -d " " -f 1 | sort -u`; do cat /sys/block/$mount/stat | sed -r "s/ +/;/g" | sed -r "s/^;//"; done';exec3(cmd,{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.split("\n");lines.forEach(function(line){if(!line){return}let stats=line.split(";");rIO+=parseInt(stats[0]);wIO+=parseInt(stats[4]);rWaitTime+=parseInt(stats[3]);wWaitTime+=parseInt(stats[7]);tWaitTime+=parseInt(stats[10])});result2=calcDiskIO(rIO,wIO,rWaitTime,wWaitTime,tWaitTime);if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}})}if(_darwin){exec3('ioreg -c IOBlockStorageDriver -k Statistics -r -w0 | sed -n "/IOBlockStorageDriver/,/Statistics/p" | grep "Statistics" | tr -cd "01234567890,\n"',{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");lines.forEach(function(line){line=line.trim();if(line!==""){line=line.split(",");rIO+=parseInt(line[10]);wIO+=parseInt(line[0])}});result2=calcDiskIO(rIO,wIO,rWaitTime,wWaitTime,tWaitTime)}if(callback){callback(result2)}resolve(result2)})}}else{result2.rIO=_disk_io.rIO;result2.wIO=_disk_io.wIO;result2.tIO=_disk_io.rIO+_disk_io.wIO;result2.ms=_disk_io.last_ms;result2.rIO_sec=_disk_io.rIO_sec;result2.wIO_sec=_disk_io.wIO_sec;result2.tIO_sec=_disk_io.tIO_sec;result2.rWaitTime=_disk_io.rWaitTime;result2.wWaitTime=_disk_io.wWaitTime;result2.tWaitTime=_disk_io.tWaitTime;result2.rWaitPercent=_disk_io.rWaitPercent;result2.wWaitPercent=_disk_io.wWaitPercent;result2.tWaitPercent=_disk_io.tWaitPercent;if(callback){callback(result2)}resolve(result2)}})})}exports2.disksIO=disksIO;function diskLayout(callback){function getVendorFromModel(model){const diskManufacturers=[{pattern:"WESTERN.*",manufacturer:"Western Digital"},{pattern:"^WDC.*",manufacturer:"Western Digital"},{pattern:"WD.*",manufacturer:"Western Digital"},{pattern:"TOSHIBA.*",manufacturer:"Toshiba"},{pattern:"HITACHI.*",manufacturer:"Hitachi"},{pattern:"^IC.*",manufacturer:"Hitachi"},{pattern:"^HTS.*",manufacturer:"Hitachi"},{pattern:"SANDISK.*",manufacturer:"SanDisk"},{pattern:"KINGSTON.*",manufacturer:"Kingston Technology"},{pattern:"^SONY.*",manufacturer:"Sony"},{pattern:"TRANSCEND.*",manufacturer:"Transcend"},{pattern:"SAMSUNG.*",manufacturer:"Samsung"},{pattern:"^ST(?!I\\ ).*",manufacturer:"Seagate"},{pattern:"^STI\\ .*",manufacturer:"SimpleTech"},{pattern:"^D...-.*",manufacturer:"IBM"},{pattern:"^IBM.*",manufacturer:"IBM"},{pattern:"^FUJITSU.*",manufacturer:"Fujitsu"},{pattern:"^MP.*",manufacturer:"Fujitsu"},{pattern:"^MK.*",manufacturer:"Toshiba"},{pattern:"MAXTO.*",manufacturer:"Maxtor"},{pattern:"PIONEER.*",manufacturer:"Pioneer"},{pattern:"PHILIPS.*",manufacturer:"Philips"},{pattern:"QUANTUM.*",manufacturer:"Quantum Technology"},{pattern:"FIREBALL.*",manufacturer:"Quantum Technology"},{pattern:"^VBOX.*",manufacturer:"VirtualBox"},{pattern:"CORSAIR.*",manufacturer:"Corsair Components"},{pattern:"CRUCIAL.*",manufacturer:"Crucial"},{pattern:"ECM.*",manufacturer:"ECM"},{pattern:"INTEL.*",manufacturer:"INTEL"},{pattern:"EVO.*",manufacturer:"Samsung"},{pattern:"APPLE.*",manufacturer:"Apple"}];let result2="";if(model){model=model.toUpperCase();diskManufacturers.forEach(manufacturer=>{const re=RegExp(manufacturer.pattern);if(re.test(model)){result2=manufacturer.manufacturer}})}return result2}return new Promise(resolve=>{process.nextTick(()=>{const commitResult=res=>{for(let i=0;i<res.length;i++){delete res[i].BSDName}if(callback){callback(res)}resolve(res)};let result2=[];let cmd="";if(_linux){let cmdFullSmart="";exec3("export LC_ALL=C; lsblk -ablJO 2>/dev/null; unset LC_ALL",{maxBuffer:1024*1024},function(error,stdout){if(!error){try{const out=stdout.toString().trim();let devices=[];try{const outJSON=JSON.parse(out);if(outJSON&&{}.hasOwnProperty.call(outJSON,"blockdevices")){devices=outJSON.blockdevices.filter(item=>{return item.type==="disk"&&item.size>0&&(item.model!==null||item.mountpoint===null&&item.label===null&&item.fstype===null&&item.parttype===null&&item.path&&item.path.indexOf("/ram")!==0&&item.path.indexOf("/loop")!==0&&item["disc-max"]&&item["disc-max"]!==0)})}}catch(e){try{const out2=execSync("export LC_ALL=C; lsblk -bPo NAME,TYPE,SIZE,FSTYPE,MOUNTPOINT,UUID,ROTA,RO,RM,LABEL,MODEL,OWNER,GROUP 2>/dev/null; unset LC_ALL",util4.execOptsLinux).toString();let lines=blkStdoutToObject(out2).split("\n");const data=parseBlk(lines);devices=data.filter(item=>{return item.type==="disk"&&item.size>0&&(item.model!==null&&item.model!==""||item.mount===""&&item.label===""&&item.fsType==="")})}catch(e2){util4.noop()}}devices.forEach(device=>{let mediumType="";const BSDName="/dev/"+device.name;const logical=device.name;try{mediumType=execSync("cat /sys/block/"+logical+"/queue/rotational 2>/dev/null",util4.execOptsLinux).toString().split("\n")[0]}catch(e){util4.noop()}let interfaceType=device.tran?device.tran.toUpperCase().trim():"";if(interfaceType==="NVME"){mediumType="2";interfaceType="PCIe"}result2.push({device:BSDName,type:mediumType==="0"?"SSD":mediumType==="1"?"HD":mediumType==="2"?"NVMe":device.model&&device.model.indexOf("SSD")>-1?"SSD":device.model&&device.model.indexOf("NVM")>-1?"NVMe":"HD",name:device.model||"",vendor:getVendorFromModel(device.model)||(device.vendor?device.vendor.trim():""),size:device.size||0,bytesPerSector:null,totalCylinders:null,totalHeads:null,totalSectors:null,totalTracks:null,tracksPerCylinder:null,sectorsPerTrack:null,firmwareRevision:device.rev?device.rev.trim():"",serialNum:device.serial?device.serial.trim():"",interfaceType,smartStatus:"unknown",temperature:null,BSDName});cmd+=`printf "
${BSDName}|"; smartctl -H ${BSDName} | grep overall;`;cmdFullSmart+=`${cmdFullSmart?'printf ",";':""}smartctl -a -j ${BSDName};`})}catch(e){util4.noop()}}if(cmdFullSmart){exec3(cmdFullSmart,{maxBuffer:1024*1024},function(error2,stdout2){try{const data=JSON.parse(`[${stdout2}]`);data.forEach(disk=>{const diskBSDName=disk.smartctl.argv[disk.smartctl.argv.length-1];for(let i=0;i<result2.length;i++){if(result2[i].BSDName===diskBSDName){result2[i].smartStatus=disk.smart_status.passed?"Ok":disk.smart_status.passed===false?"Predicted Failure":"unknown";if(disk.temperature&&disk.temperature.current){result2[i].temperature=disk.temperature.current}result2[i].smartData=disk}}});commitResult(result2)}catch(e){if(cmd){cmd=cmd+'printf "\n"';exec3(cmd,{maxBuffer:1024*1024},function(error3,stdout3){let lines=stdout3.toString().split("\n");lines.forEach(line=>{if(line){let parts=line.split("|");if(parts.length===2){let BSDName=parts[0];parts[1]=parts[1].trim();let parts2=parts[1].split(":");if(parts2.length===2){parts2[1]=parts2[1].trim();let status=parts2[1].toLowerCase();for(let i=0;i<result2.length;i++){if(result2[i].BSDName===BSDName){result2[i].smartStatus=status==="passed"?"Ok":status==="failed!"?"Predicted Failure":"unknown"}}}}}});commitResult(result2)})}else{commitResult(result2)}}})}else{commitResult(result2)}})}if(_freebsd||_openbsd||_netbsd){if(callback){callback(result2)}resolve(result2)}if(_sunos){if(callback){callback(result2)}resolve(result2)}if(_darwin){exec3("system_profiler SPSerialATADataType SPNVMeDataType SPUSBDataType",{maxBuffer:1024*1024},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");let linesSATA=[];let linesNVMe=[];let linesUSB=[];let dataType="SATA";lines.forEach(line=>{if(line==="NVMExpress:"){dataType="NVMe"}else if(line==="USB:"){dataType="USB"}else if(line==="SATA/SATA Express:"){dataType="SATA"}else if(dataType==="SATA"){linesSATA.push(line)}else if(dataType==="NVMe"){linesNVMe.push(line)}else if(dataType==="USB"){linesUSB.push(line)}});try{let devices=linesSATA.join("\n").split(" Physical Interconnect: ");devices.shift();devices.forEach(function(device){device="InterfaceType: "+device;let lines2=device.split("\n");const mediumType=util4.getValue(lines2,"Medium Type",":",true).trim();const sizeStr=util4.getValue(lines2,"capacity",":",true).trim();const BSDName=util4.getValue(lines2,"BSD Name",":",true).trim();if(sizeStr){let sizeValue=0;if(sizeStr.indexOf("(")>=0){sizeValue=parseInt(sizeStr.match(/\(([^)]+)\)/)[1].replace(/\./g,"").replace(/,/g,"").replace(/\s/g,""))}if(!sizeValue){sizeValue=parseInt(sizeStr)}if(sizeValue){const smartStatusString=util4.getValue(lines2,"S.M.A.R.T. status",":",true).trim().toLowerCase();result2.push({device:BSDName,type:mediumType.startsWith("Solid")?"SSD":"HD",name:util4.getValue(lines2,"Model",":",true).trim(),vendor:getVendorFromModel(util4.getValue(lines2,"Model",":",true).trim())||util4.getValue(lines2,"Manufacturer",":",true),size:sizeValue,bytesPerSector:null,totalCylinders:null,totalHeads:null,totalSectors:null,totalTracks:null,tracksPerCylinder:null,sectorsPerTrack:null,firmwareRevision:util4.getValue(lines2,"Revision",":",true).trim(),serialNum:util4.getValue(lines2,"Serial Number",":",true).trim(),interfaceType:util4.getValue(lines2,"InterfaceType",":",true).trim(),smartStatus:smartStatusString==="verified"?"OK":smartStatusString||"unknown",temperature:null,BSDName});cmd=cmd+'printf "\n'+BSDName+'|"; diskutil info /dev/'+BSDName+" | grep SMART;"}}})}catch(e){util4.noop()}try{let devices=linesNVMe.join("\n").split("\n\n          Capacity:");devices.shift();devices.forEach(function(device){device="!Capacity: "+device;let lines2=device.split("\n");const linkWidth=util4.getValue(lines2,"link width",":",true).trim();const sizeStr=util4.getValue(lines2,"!capacity",":",true).trim();const BSDName=util4.getValue(lines2,"BSD Name",":",true).trim();if(sizeStr){let sizeValue=0;if(sizeStr.indexOf("(")>=0){sizeValue=parseInt(sizeStr.match(/\(([^)]+)\)/)[1].replace(/\./g,"").replace(/,/g,"").replace(/\s/g,""))}if(!sizeValue){sizeValue=parseInt(sizeStr)}if(sizeValue){const smartStatusString=util4.getValue(lines2,"S.M.A.R.T. status",":",true).trim().toLowerCase();result2.push({device:BSDName,type:"NVMe",name:util4.getValue(lines2,"Model",":",true).trim(),vendor:getVendorFromModel(util4.getValue(lines2,"Model",":",true).trim()),size:sizeValue,bytesPerSector:null,totalCylinders:null,totalHeads:null,totalSectors:null,totalTracks:null,tracksPerCylinder:null,sectorsPerTrack:null,firmwareRevision:util4.getValue(lines2,"Revision",":",true).trim(),serialNum:util4.getValue(lines2,"Serial Number",":",true).trim(),interfaceType:("PCIe "+linkWidth).trim(),smartStatus:smartStatusString==="verified"?"OK":smartStatusString||"unknown",temperature:null,BSDName});cmd=cmd+'printf "\n'+BSDName+'|"; diskutil info /dev/'+BSDName+" | grep SMART;"}}})}catch(e){util4.noop()}try{let devices=linesUSB.join("\n").replaceAll("Media:\n ","Model:").split("\n\n          Product ID:");devices.shift();devices.forEach(function(device){let lines2=device.split("\n");const sizeStr=util4.getValue(lines2,"Capacity",":",true).trim();const BSDName=util4.getValue(lines2,"BSD Name",":",true).trim();if(sizeStr){let sizeValue=0;if(sizeStr.indexOf("(")>=0){sizeValue=parseInt(sizeStr.match(/\(([^)]+)\)/)[1].replace(/\./g,"").replace(/,/g,"").replace(/\s/g,""))}if(!sizeValue){sizeValue=parseInt(sizeStr)}if(sizeValue){const smartStatusString=util4.getValue(lines2,"S.M.A.R.T. status",":",true).trim().toLowerCase();result2.push({device:BSDName,type:"USB",name:util4.getValue(lines2,"Model",":",true).trim().replaceAll(":",""),vendor:getVendorFromModel(util4.getValue(lines2,"Model",":",true).trim()),size:sizeValue,bytesPerSector:null,totalCylinders:null,totalHeads:null,totalSectors:null,totalTracks:null,tracksPerCylinder:null,sectorsPerTrack:null,firmwareRevision:util4.getValue(lines2,"Revision",":",true).trim(),serialNum:util4.getValue(lines2,"Serial Number",":",true).trim(),interfaceType:"USB",smartStatus:smartStatusString==="verified"?"OK":smartStatusString||"unknown",temperature:null,BSDName});cmd=cmd+'printf "\n'+BSDName+'|"; diskutil info /dev/'+BSDName+" | grep SMART;"}}})}catch(e){util4.noop()}if(cmd){cmd=cmd+'printf "\n"';exec3(cmd,{maxBuffer:1024*1024},function(error2,stdout2){let lines2=stdout2.toString().split("\n");lines2.forEach(line=>{if(line){let parts=line.split("|");if(parts.length===2){let BSDName=parts[0];parts[1]=parts[1].trim();let parts2=parts[1].split(":");if(parts2.length===2){parts2[1]=parts2[1].trim();let status=parts2[1].toLowerCase();for(let i=0;i<result2.length;i++){if(result2[i].BSDName===BSDName){result2[i].smartStatus=status==="not supported"?"not supported":status==="verified"?"Ok":status==="failing"?"Predicted Failure":"unknown"}}}}}});for(let i=0;i<result2.length;i++){delete result2[i].BSDName}if(callback){callback(result2)}resolve(result2)})}else{for(let i=0;i<result2.length;i++){delete result2[i].BSDName}if(callback){callback(result2)}resolve(result2)}}})}if(_windows){try{const workload=[];workload.push(util4.powerShell("Get-CimInstance Win32_DiskDrive | select Caption,Size,Status,PNPDeviceId,DeviceId,BytesPerSector,TotalCylinders,TotalHeads,TotalSectors,TotalTracks,TracksPerCylinder,SectorsPerTrack,FirmwareRevision,SerialNumber,InterfaceType | fl"));workload.push(util4.powerShell("Get-PhysicalDisk | select BusType,MediaType,FriendlyName,Model,SerialNumber,Size | fl"));if(util4.smartMonToolsInstalled()){try{const smartDev=JSON.parse(execSync("smartctl --scan -j").toString());if(smartDev&&smartDev.devices&&smartDev.devices.length>0){smartDev.devices.forEach(dev=>{workload.push(execPromiseSave(`smartctl -j -a ${dev.name}`,util4.execOptsWin))})}}catch(e){util4.noop()}}util4.promiseAll(workload).then(data=>{let devices=data.results[0].toString().split(/\n\s*\n/);devices.forEach(function(device){let lines=device.split("\r\n");const size2=util4.getValue(lines,"Size",":").trim();const status=util4.getValue(lines,"Status",":").trim().toLowerCase();if(size2){result2.push({device:util4.getValue(lines,"DeviceId",":"),type:device.indexOf("SSD")>-1?"SSD":"HD",name:util4.getValue(lines,"Caption",":"),vendor:getVendorFromModel(util4.getValue(lines,"Caption",":",true).trim()),size:parseInt(size2),bytesPerSector:parseInt(util4.getValue(lines,"BytesPerSector",":")),totalCylinders:parseInt(util4.getValue(lines,"TotalCylinders",":")),totalHeads:parseInt(util4.getValue(lines,"TotalHeads",":")),totalSectors:parseInt(util4.getValue(lines,"TotalSectors",":")),totalTracks:parseInt(util4.getValue(lines,"TotalTracks",":")),tracksPerCylinder:parseInt(util4.getValue(lines,"TracksPerCylinder",":")),sectorsPerTrack:parseInt(util4.getValue(lines,"SectorsPerTrack",":")),firmwareRevision:util4.getValue(lines,"FirmwareRevision",":").trim(),serialNum:util4.getValue(lines,"SerialNumber",":").trim(),interfaceType:util4.getValue(lines,"InterfaceType",":").trim(),smartStatus:status==="ok"?"Ok":status==="degraded"?"Degraded":status==="pred fail"?"Predicted Failure":"Unknown",temperature:null})}});devices=data.results[1].split(/\n\s*\n/);devices.forEach(function(device){let lines=device.split("\r\n");const serialNum=util4.getValue(lines,"SerialNumber",":").trim();const name=util4.getValue(lines,"FriendlyName",":").trim().replace("Msft ","Microsoft");const size2=util4.getValue(lines,"Size",":").trim();const model=util4.getValue(lines,"Model",":").trim();const interfaceType=util4.getValue(lines,"BusType",":").trim();let mediaType=util4.getValue(lines,"MediaType",":").trim();if(mediaType==="3"||mediaType==="HDD"){mediaType="HD"}if(mediaType==="4"){mediaType="SSD"}if(mediaType==="5"){mediaType="SCM"}if(mediaType==="Unspecified"&&(model.toLowerCase().indexOf("virtual")>-1||model.toLowerCase().indexOf("vbox")>-1)){mediaType="Virtual"}if(size2){let i=util4.findObjectByKey(result2,"serialNum",serialNum);if(i===-1||serialNum===""){i=util4.findObjectByKey(result2,"name",name)}if(i!=-1){result2[i].type=mediaType;result2[i].interfaceType=interfaceType}}});data.results.shift();data.results.shift();if(data.results.length){data.results.forEach(smartStr=>{try{const smartData=JSON.parse(smartStr);if(smartData.serial_number){const serialNum=smartData.serial_number;let i=util4.findObjectByKey(result2,"serialNum",serialNum);if(i!=-1){result2[i].smartStatus=smartData.smart_status&&smartData.smart_status.passed?"Ok":smartData.smart_status&&smartData.smart_status.passed===false?"Predicted Failure":"unknown";if(smartData.temperature&&smartData.temperature.current){result2[i].temperature=smartData.temperature.current}result2[i].smartData=smartData}}}catch(e){util4.noop()}})}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.diskLayout=diskLayout}});var require_network=__commonJS({"node_modules/systeminformation/lib/network.js"(exports2){"use strict";var os7=require("os");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var fs14=require("fs");var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var _network={};var _default_iface="";var _ifaces={};var _dhcpNics=[];var _networkInterfaces=[];var _mac={};var pathToIp;function getDefaultNetworkInterface(){let ifacename="";let ifacenameFirst="";try{let ifaces=os7.networkInterfaces();let scopeid=9999;for(let dev in ifaces){if({}.hasOwnProperty.call(ifaces,dev)){ifaces[dev].forEach(function(details){if(details&&details.internal===false){ifacenameFirst=ifacenameFirst||dev;if(details.scopeid&&details.scopeid<scopeid){ifacename=dev;scopeid=details.scopeid}}})}}ifacename=ifacename||ifacenameFirst||"";if(_windows){let defaultIp="";const cmd="netstat -r";const result2=execSync(cmd,util4.execOptsWin);const lines=result2.toString().split(os7.EOL);lines.forEach(line=>{line=line.replace(/\s+/g," ").trim();if(line.indexOf("0.0.0.0 0.0.0.0")>-1&&!/[a-zA-Z]/.test(line)){const parts=line.split(" ");if(parts.length>=5){defaultIp=parts[parts.length-2]}}});if(defaultIp){for(let dev in ifaces){if({}.hasOwnProperty.call(ifaces,dev)){ifaces[dev].forEach(function(details){if(details&&details.address&&details.address===defaultIp){ifacename=dev}})}}}}if(_linux){let cmd="ip route 2> /dev/null | grep default";let result2=execSync(cmd,util4.execOptsLinux);let parts=result2.toString().split("\n")[0].split(/\s+/);if(parts[0]==="none"&&parts[5]){ifacename=parts[5]}else if(parts[4]){ifacename=parts[4]}if(ifacename.indexOf(":")>-1){ifacename=ifacename.split(":")[1].trim()}}if(_darwin||_freebsd||_openbsd||_netbsd||_sunos){let cmd="";if(_linux){cmd="ip route 2> /dev/null | grep default | awk '{print $5}'"}if(_darwin){cmd="route -n get default 2>/dev/null | grep interface: | awk '{print $2}'"}if(_freebsd||_openbsd||_netbsd||_sunos){cmd="route get 0.0.0.0 | grep interface:"}let result2=execSync(cmd);ifacename=result2.toString().split("\n")[0];if(ifacename.indexOf(":")>-1){ifacename=ifacename.split(":")[1].trim()}}}catch(e){util4.noop()}if(ifacename){_default_iface=ifacename}return _default_iface}exports2.getDefaultNetworkInterface=getDefaultNetworkInterface;function getMacAddresses(){let iface="";let mac="";let result2={};if(_linux||_freebsd||_openbsd||_netbsd){if(typeof pathToIp==="undefined"){try{const lines=execSync("which ip",util4.execOptsLinux).toString().split("\n");if(lines.length&&lines[0].indexOf(":")===-1&&lines[0].indexOf("/")===0){pathToIp=lines[0]}else{pathToIp=""}}catch(e){pathToIp=""}}try{const cmd="export LC_ALL=C; "+(pathToIp?pathToIp+" link show up":"/sbin/ifconfig")+"; unset LC_ALL";let res=execSync(cmd,util4.execOptsLinux);const lines=res.toString().split("\n");for(let i=0;i<lines.length;i++){if(lines[i]&&lines[i][0]!==" "){if(pathToIp){let nextline=lines[i+1].trim().split(" ");if(nextline[0]==="link/ether"){iface=lines[i].split(" ")[1];iface=iface.slice(0,iface.length-1);mac=nextline[1]}}else{iface=lines[i].split(" ")[0];mac=lines[i].split("HWaddr ")[1]}if(iface&&mac){result2[iface]=mac.trim();iface="";mac=""}}}}catch(e){util4.noop()}}if(_darwin){try{const cmd="/sbin/ifconfig";let res=execSync(cmd);const lines=res.toString().split("\n");for(let i=0;i<lines.length;i++){if(lines[i]&&lines[i][0]!=="	"&&lines[i].indexOf(":")>0){iface=lines[i].split(":")[0]}else if(lines[i].indexOf("	ether ")===0){mac=lines[i].split("	ether ")[1];if(iface&&mac){result2[iface]=mac.trim();iface="";mac=""}}}}catch(e){util4.noop()}}return result2}function networkInterfaceDefault(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=getDefaultNetworkInterface();if(callback){callback(result2)}resolve(result2)})})}exports2.networkInterfaceDefault=networkInterfaceDefault;function parseLinesWindowsNics(sections,nconfigsections){let nics=[];for(let i in sections){try{if({}.hasOwnProperty.call(sections,i)){if(sections[i].trim()!==""){let lines=sections[i].trim().split("\r\n");let linesNicConfig=null;try{linesNicConfig=nconfigsections&&nconfigsections[i]?nconfigsections[i].trim().split("\r\n"):[]}catch(e){util4.noop()}let netEnabled=util4.getValue(lines,"NetEnabled",":");let adapterType=util4.getValue(lines,"AdapterTypeID",":")==="9"?"wireless":"wired";let ifacename=util4.getValue(lines,"Name",":").replace(/\]/g,")").replace(/\[/g,"(");let iface=util4.getValue(lines,"NetConnectionID",":").replace(/\]/g,")").replace(/\[/g,"(");if(ifacename.toLowerCase().indexOf("wi-fi")>=0||ifacename.toLowerCase().indexOf("wireless")>=0){adapterType="wireless"}if(netEnabled!==""){const speed=parseInt(util4.getValue(lines,"speed",":").trim(),10)/1e6;nics.push({mac:util4.getValue(lines,"MACAddress",":").toLowerCase(),dhcp:util4.getValue(linesNicConfig,"dhcpEnabled",":").toLowerCase()==="true",name:ifacename,iface,netEnabled:netEnabled==="TRUE",speed:isNaN(speed)?null:speed,operstate:util4.getValue(lines,"NetConnectionStatus",":")==="2"?"up":"down",type:adapterType})}}}}catch(e){util4.noop()}}return nics}function getWindowsNics(){return new Promise(resolve=>{process.nextTick(()=>{let cmd="Get-CimInstance Win32_NetworkAdapter | fl *; echo '#-#-#-#';";cmd+="Get-CimInstance Win32_NetworkAdapterConfiguration | fl DHCPEnabled";try{util4.powerShell(cmd).then(data=>{data=data.split("#-#-#-#");const nsections=(data[0]||"").split(/\n\s*\n/);const nconfigsections=(data[1]||"").split(/\n\s*\n/);resolve(parseLinesWindowsNics(nsections,nconfigsections))})}catch(e){resolve([])}})})}function getWindowsDNSsuffixes(){let iface={};let dnsSuffixes={primaryDNS:"",exitCode:0,ifaces:[]};try{const ipconfig=execSync("ipconfig /all",util4.execOptsWin);const ipconfigArray=ipconfig.split("\r\n\r\n");ipconfigArray.forEach((element,index)=>{if(index==1){const longPrimaryDNS=element.split("\r\n").filter(element2=>{return element2.toUpperCase().includes("DNS")});const primaryDNS=longPrimaryDNS[0].substring(longPrimaryDNS[0].lastIndexOf(":")+1);dnsSuffixes.primaryDNS=primaryDNS.trim();if(!dnsSuffixes.primaryDNS){dnsSuffixes.primaryDNS="Not defined"}}if(index>1){if(index%2==0){const name=element.substring(element.lastIndexOf(" ")+1).replace(":","");iface.name=name}else{const connectionSpecificDNS=element.split("\r\n").filter(element2=>{return element2.toUpperCase().includes("DNS")});const dnsSuffix=connectionSpecificDNS[0].substring(connectionSpecificDNS[0].lastIndexOf(":")+1);iface.dnsSuffix=dnsSuffix.trim();dnsSuffixes.ifaces.push(iface);iface={}}}});return dnsSuffixes}catch(error){return{primaryDNS:"",exitCode:0,ifaces:[]}}}function getWindowsIfaceDNSsuffix(ifaces,ifacename){let dnsSuffix="";const interfaceName=ifacename+".";try{const connectionDnsSuffix=ifaces.filter(iface=>{return interfaceName.includes(iface.name+".")}).map(iface=>iface.dnsSuffix);if(connectionDnsSuffix[0]){dnsSuffix=connectionDnsSuffix[0]}if(!dnsSuffix){dnsSuffix=""}return dnsSuffix}catch(error){return"Unknown"}}function getWindowsWiredProfilesInformation(){try{const result2=execSync("netsh lan show profiles",util4.execOptsWin);const profileList=result2.split("\r\nProfile on interface");return profileList}catch(error){if(error.status===1&&error.stdout.includes("AutoConfig")){return"Disabled"}return[]}}function getWindowsWirelessIfaceSSID(interfaceName){try{const result2=execSync(`netsh wlan show  interface name="${interfaceName}" | findstr "SSID"`,util4.execOptsWin);const SSID=result2.split("\r\n").shift();const parseSSID=SSID.split(":").pop().trim();return parseSSID}catch(error){return"Unknown"}}function getWindowsIEEE8021x(connectionType,iface,ifaces){let i8021x={state:"Unknown",protocol:"Unknown"};if(ifaces==="Disabled"){i8021x.state="Disabled";i8021x.protocol="Not defined";return i8021x}if(connectionType=="wired"&&ifaces.length>0){try{const iface8021xInfo=ifaces.find(element=>{return element.includes(iface+"\r\n")});const arrayIface8021xInfo=iface8021xInfo.split("\r\n");const state8021x=arrayIface8021xInfo.find(element=>{return element.includes("802.1x")});if(state8021x.includes("Disabled")){i8021x.state="Disabled";i8021x.protocol="Not defined"}else if(state8021x.includes("Enabled")){const protocol8021x=arrayIface8021xInfo.find(element=>{return element.includes("EAP")});i8021x.protocol=protocol8021x.split(":").pop();i8021x.state="Enabled"}}catch(error){return i8021x}}else if(connectionType=="wireless"){let i8021xState="";let i8021xProtocol="";try{const SSID=getWindowsWirelessIfaceSSID(iface);if(SSID!=="Unknown"){let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(SSID);const l=util4.mathMin(s.length,32);for(let i=0;i<=l;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}i8021xState=execSync(`netsh wlan show profiles "${ifaceSanitized}" | findstr "802.1X"`,util4.execOptsWin);i8021xProtocol=execSync(`netsh wlan show profiles "${ifaceSanitized}" | findstr "EAP"`,util4.execOptsWin)}if(i8021xState.includes(":")&&i8021xProtocol.includes(":")){i8021x.state=i8021xState.split(":").pop();i8021x.protocol=i8021xProtocol.split(":").pop()}}catch(error){if(error.status===1&&error.stdout.includes("AutoConfig")){i8021x.state="Disabled";i8021x.protocol="Not defined"}return i8021x}}return i8021x}function splitSectionsNics(lines){const result2=[];let section=[];lines.forEach(function(line){if(!line.startsWith("	")&&!line.startsWith(" ")){if(section.length){result2.push(section);section=[]}}section.push(line)});if(section.length){result2.push(section)}return result2}function parseLinesDarwinNics(sections){let nics=[];sections.forEach(section=>{let nic={iface:"",mtu:null,mac:"",ip6:"",ip4:"",speed:null,type:"",operstate:"",duplex:"",internal:false};const first=section[0];nic.iface=first.split(":")[0].trim();let parts=first.split("> mtu");nic.mtu=parts.length>1?parseInt(parts[1],10):null;if(isNaN(nic.mtu)){nic.mtu=null}nic.internal=parts[0].toLowerCase().indexOf("loopback")>-1;section.forEach(line=>{if(line.trim().startsWith("ether ")){nic.mac=line.split("ether ")[1].toLowerCase().trim()}if(line.trim().startsWith("inet6 ")&&!nic.ip6){nic.ip6=line.split("inet6 ")[1].toLowerCase().split("%")[0].split(" ")[0]}if(line.trim().startsWith("inet ")&&!nic.ip4){nic.ip4=line.split("inet ")[1].toLowerCase().split(" ")[0]}});let speed=util4.getValue(section,"link rate");nic.speed=speed?parseFloat(speed):null;if(nic.speed===null){speed=util4.getValue(section,"uplink rate");nic.speed=speed?parseFloat(speed):null;if(nic.speed!==null&&speed.toLowerCase().indexOf("gbps")>=0){nic.speed=nic.speed*1e3}}else{if(speed.toLowerCase().indexOf("gbps")>=0){nic.speed=nic.speed*1e3}}nic.type=util4.getValue(section,"type").toLowerCase().indexOf("wi-fi")>-1?"wireless":"wired";const operstate=util4.getValue(section,"status").toLowerCase();nic.operstate=operstate==="active"?"up":operstate==="inactive"?"down":"unknown";nic.duplex=util4.getValue(section,"media").toLowerCase().indexOf("half-duplex")>-1?"half":"full";if(nic.ip6||nic.ip4||nic.mac){nics.push(nic)}});return nics}function getDarwinNics(){const cmd="/sbin/ifconfig -v";try{const lines=execSync(cmd,{maxBuffer:1024*2e4}).toString().split("\n");const nsections=splitSectionsNics(lines);return parseLinesDarwinNics(nsections)}catch(e){return[]}}function getLinuxIfaceConnectionName(interfaceName){const cmd=`nmcli device status 2>/dev/null | grep ${interfaceName}`;try{const result2=execSync(cmd,util4.execOptsLinux).toString();const resultFormat=result2.replace(/\s+/g," ").trim();const connectionNameLines=resultFormat.split(" ").slice(3);const connectionName=connectionNameLines.join(" ");return connectionName!="--"?connectionName:""}catch(e){return""}}function checkLinuxDCHPInterfaces(file){let result2=[];try{let cmd=`cat ${file} 2> /dev/null | grep 'iface\\|source'`;const lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");lines.forEach(line=>{const parts=line.replace(/\s+/g," ").trim().split(" ");if(parts.length>=4){if(line.toLowerCase().indexOf(" inet ")>=0&&line.toLowerCase().indexOf("dhcp")>=0){result2.push(parts[1])}}if(line.toLowerCase().includes("source")){let file2=line.split(" ")[1];result2=result2.concat(checkLinuxDCHPInterfaces(file2))}})}catch(e){util4.noop()}return result2}function getLinuxDHCPNics(){let cmd="ip a 2> /dev/null";let result2=[];try{const lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");const nsections=splitSectionsNics(lines);result2=parseLinuxDHCPNics(nsections)}catch(e){util4.noop()}try{result2=checkLinuxDCHPInterfaces("/etc/network/interfaces")}catch(e){util4.noop()}return result2}function parseLinuxDHCPNics(sections){const result2=[];if(sections&&sections.length){sections.forEach(lines=>{if(lines&&lines.length){const parts=lines[0].split(":");if(parts.length>2){for(let line of lines){if(line.indexOf(" inet ")>=0&&line.indexOf(" dynamic ")>=0){const parts2=line.split(" ");const nic=parts2[parts2.length-1].trim();result2.push(nic);break}}}}})}return result2}function getLinuxIfaceDHCPstatus(iface,connectionName,DHCPNics){let result2=false;if(connectionName){const cmd=`nmcli connection show "${connectionName}" 2>/dev/null | grep ipv4.method;`;try{const lines=execSync(cmd,util4.execOptsLinux).toString();const resultFormat=lines.replace(/\s+/g," ").trim();let dhcStatus=resultFormat.split(" ").slice(1).toString();switch(dhcStatus){case"auto":result2=true;break;default:result2=false;break}return result2}catch(e){return DHCPNics.indexOf(iface)>=0}}else{return DHCPNics.indexOf(iface)>=0}}function getDarwinIfaceDHCPstatus(iface){let result2=false;const cmd=`ipconfig getpacket "${iface}" 2>/dev/null | grep lease_time;`;try{const lines=execSync(cmd).toString().split("\n");if(lines.length&&lines[0].startsWith("lease_time")){result2=true}}catch(e){util4.noop()}return result2}function getLinuxIfaceDNSsuffix(connectionName){if(connectionName){const cmd=`nmcli connection show "${connectionName}" 2>/dev/null | grep ipv4.dns-search;`;try{const result2=execSync(cmd,util4.execOptsLinux).toString();const resultFormat=result2.replace(/\s+/g," ").trim();const dnsSuffix=resultFormat.split(" ").slice(1).toString();return dnsSuffix=="--"?"Not defined":dnsSuffix}catch(e){return"Unknown"}}else{return"Unknown"}}function getLinuxIfaceIEEE8021xAuth(connectionName){if(connectionName){const cmd=`nmcli connection show "${connectionName}" 2>/dev/null | grep 802-1x.eap;`;try{const result2=execSync(cmd,util4.execOptsLinux).toString();const resultFormat=result2.replace(/\s+/g," ").trim();const authenticationProtocol=resultFormat.split(" ").slice(1).toString();return authenticationProtocol=="--"?"":authenticationProtocol}catch(e){return"Not defined"}}else{return"Not defined"}}function getLinuxIfaceIEEE8021xState(authenticationProtocol){if(authenticationProtocol){if(authenticationProtocol=="Not defined"){return"Disabled"}return"Enabled"}else{return"Unknown"}}function testVirtualNic(iface,ifaceName,mac){const virtualMacs=["00:00:00:00:00:00","00:03:FF","00:05:69","00:0C:29","00:0F:4B","00:13:07","00:13:BE","00:15:5d","00:16:3E","00:1C:42","00:21:F6","00:24:0B","00:50:56","00:A0:B1","00:E0:C8","08:00:27","0A:00:27","18:92:2C","16:DF:49","3C:F3:92","54:52:00","FC:15:97"];if(mac){return virtualMacs.filter(item=>{return mac.toUpperCase().toUpperCase().startsWith(item.substring(0,mac.length))}).length>0||iface.toLowerCase().indexOf(" virtual ")>-1||ifaceName.toLowerCase().indexOf(" virtual ")>-1||iface.toLowerCase().indexOf("vethernet ")>-1||ifaceName.toLowerCase().indexOf("vethernet ")>-1||iface.toLowerCase().startsWith("veth")||ifaceName.toLowerCase().startsWith("veth")||iface.toLowerCase().startsWith("vboxnet")||ifaceName.toLowerCase().startsWith("vboxnet")}else{return false}}function networkInterfaces(callback,rescan,defaultString){if(typeof callback==="string"){defaultString=callback;rescan=true;callback=null}if(typeof callback==="boolean"){rescan=callback;callback=null;defaultString=""}if(typeof rescan==="undefined"){rescan=true}defaultString=defaultString||"";defaultString=""+defaultString;return new Promise(resolve=>{process.nextTick(()=>{let ifaces=os7.networkInterfaces();let result2=[];let nics=[];let dnsSuffixes=[];let nics8021xInfo=[];if(_darwin||_freebsd||_openbsd||_netbsd){if(JSON.stringify(ifaces)===JSON.stringify(_ifaces)&&!rescan){result2=_networkInterfaces;if(callback){callback(result2)}resolve(result2)}else{const defaultInterface=getDefaultNetworkInterface();_ifaces=JSON.parse(JSON.stringify(ifaces));nics=getDarwinNics();nics.forEach(nic=>{if({}.hasOwnProperty.call(ifaces,nic.iface)){ifaces[nic.iface].forEach(function(details){if(details.family==="IPv4"||details.family===4){nic.ip4subnet=details.netmask}if(details.family==="IPv6"||details.family===6){nic.ip6subnet=details.netmask}})}let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(nic.iface);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}result2.push({iface:nic.iface,ifaceName:nic.iface,default:nic.iface===defaultInterface,ip4:nic.ip4,ip4subnet:nic.ip4subnet||"",ip6:nic.ip6,ip6subnet:nic.ip6subnet||"",mac:nic.mac,internal:nic.internal,virtual:nic.internal?false:testVirtualNic(nic.iface,nic.iface,nic.mac),operstate:nic.operstate,type:nic.type,duplex:nic.duplex,mtu:nic.mtu,speed:nic.speed,dhcp:getDarwinIfaceDHCPstatus(ifaceSanitized),dnsSuffix:"",ieee8021xAuth:"",ieee8021xState:"",carrierChanges:0})});_networkInterfaces=result2;if(defaultString.toLowerCase().indexOf("default")>=0){result2=result2.filter(item=>item.default);if(result2.length>0){result2=result2[0]}else{result2=[]}}if(callback){callback(result2)}resolve(result2)}}if(_linux){if(JSON.stringify(ifaces)===JSON.stringify(_ifaces)&&!rescan){result2=_networkInterfaces;if(callback){callback(result2)}resolve(result2)}else{_ifaces=JSON.parse(JSON.stringify(ifaces));_dhcpNics=getLinuxDHCPNics();const defaultInterface=getDefaultNetworkInterface();for(let dev in ifaces){let ip4="";let ip4subnet="";let ip6="";let ip6subnet="";let mac="";let duplex="";let mtu="";let speed=null;let carrierChanges=0;let dhcp=false;let dnsSuffix="";let ieee8021xAuth="";let ieee8021xState="";let type2="";if({}.hasOwnProperty.call(ifaces,dev)){let ifaceName=dev;ifaces[dev].forEach(function(details){if(details.family==="IPv4"||details.family===4){ip4=details.address;ip4subnet=details.netmask}if(details.family==="IPv6"||details.family===6){if(!ip6||ip6.match(/^fe80::/i)){ip6=details.address;ip6subnet=details.netmask}}mac=details.mac;const nodeMainVersion=parseInt(process.versions.node.split("."),10);if(mac.indexOf("00:00:0")>-1&&(_linux||_darwin)&&!details.internal&&nodeMainVersion>=8&&nodeMainVersion<=11){if(Object.keys(_mac).length===0){_mac=getMacAddresses()}mac=_mac[dev]||""}});let iface=dev.split(":")[0].trim().toLowerCase();let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(iface);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}const cmd=`echo -n "addr_assign_type: "; cat /sys/class/net/${ifaceSanitized}/addr_assign_type 2>/dev/null; echo;
            echo -n "address: "; cat /sys/class/net/${ifaceSanitized}/address 2>/dev/null; echo;
            echo -n "addr_len: "; cat /sys/class/net/${ifaceSanitized}/addr_len 2>/dev/null; echo;
            echo -n "broadcast: "; cat /sys/class/net/${ifaceSanitized}/broadcast 2>/dev/null; echo;
            echo -n "carrier: "; cat /sys/class/net/${ifaceSanitized}/carrier 2>/dev/null; echo;
            echo -n "carrier_changes: "; cat /sys/class/net/${ifaceSanitized}/carrier_changes 2>/dev/null; echo;
            echo -n "dev_id: "; cat /sys/class/net/${ifaceSanitized}/dev_id 2>/dev/null; echo;
            echo -n "dev_port: "; cat /sys/class/net/${ifaceSanitized}/dev_port 2>/dev/null; echo;
            echo -n "dormant: "; cat /sys/class/net/${ifaceSanitized}/dormant 2>/dev/null; echo;
            echo -n "duplex: "; cat /sys/class/net/${ifaceSanitized}/duplex 2>/dev/null; echo;
            echo -n "flags: "; cat /sys/class/net/${ifaceSanitized}/flags 2>/dev/null; echo;
            echo -n "gro_flush_timeout: "; cat /sys/class/net/${ifaceSanitized}/gro_flush_timeout 2>/dev/null; echo;
            echo -n "ifalias: "; cat /sys/class/net/${ifaceSanitized}/ifalias 2>/dev/null; echo;
            echo -n "ifindex: "; cat /sys/class/net/${ifaceSanitized}/ifindex 2>/dev/null; echo;
            echo -n "iflink: "; cat /sys/class/net/${ifaceSanitized}/iflink 2>/dev/null; echo;
            echo -n "link_mode: "; cat /sys/class/net/${ifaceSanitized}/link_mode 2>/dev/null; echo;
            echo -n "mtu: "; cat /sys/class/net/${ifaceSanitized}/mtu 2>/dev/null; echo;
            echo -n "netdev_group: "; cat /sys/class/net/${ifaceSanitized}/netdev_group 2>/dev/null; echo;
            echo -n "operstate: "; cat /sys/class/net/${ifaceSanitized}/operstate 2>/dev/null; echo;
            echo -n "proto_down: "; cat /sys/class/net/${ifaceSanitized}/proto_down 2>/dev/null; echo;
            echo -n "speed: "; cat /sys/class/net/${ifaceSanitized}/speed 2>/dev/null; echo;
            echo -n "tx_queue_len: "; cat /sys/class/net/${ifaceSanitized}/tx_queue_len 2>/dev/null; echo;
            echo -n "type: "; cat /sys/class/net/${ifaceSanitized}/type 2>/dev/null; echo;
            echo -n "wireless: "; cat /proc/net/wireless 2>/dev/null | grep ${ifaceSanitized}; echo;
            echo -n "wirelessspeed: "; iw dev ${ifaceSanitized} link 2>&1 | grep bitrate; echo;`;let lines=[];try{lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");const connectionName=getLinuxIfaceConnectionName(ifaceSanitized);dhcp=getLinuxIfaceDHCPstatus(ifaceSanitized,connectionName,_dhcpNics);dnsSuffix=getLinuxIfaceDNSsuffix(connectionName);ieee8021xAuth=getLinuxIfaceIEEE8021xAuth(connectionName);ieee8021xState=getLinuxIfaceIEEE8021xState(ieee8021xAuth)}catch(e){util4.noop()}duplex=util4.getValue(lines,"duplex");duplex=duplex.startsWith("cat")?"":duplex;mtu=parseInt(util4.getValue(lines,"mtu"),10);let myspeed=parseInt(util4.getValue(lines,"speed"),10);speed=isNaN(myspeed)?null:myspeed;let wirelessspeed=util4.getValue(lines,"wirelessspeed").split("tx bitrate: ");if(speed===null&&wirelessspeed.length===2){myspeed=parseFloat(wirelessspeed[1]);speed=isNaN(myspeed)?null:myspeed}carrierChanges=parseInt(util4.getValue(lines,"carrier_changes"),10);const operstate=util4.getValue(lines,"operstate");type2=operstate==="up"?util4.getValue(lines,"wireless").trim()?"wireless":"wired":"unknown";if(ifaceSanitized==="lo"||ifaceSanitized.startsWith("bond")){type2="virtual"}let internal=ifaces[dev]&&ifaces[dev][0]?ifaces[dev][0].internal:false;if(dev.toLowerCase().indexOf("loopback")>-1||ifaceName.toLowerCase().indexOf("loopback")>-1){internal=true}const virtual=internal?false:testVirtualNic(dev,ifaceName,mac);result2.push({iface:ifaceSanitized,ifaceName,default:iface===defaultInterface,ip4,ip4subnet,ip6,ip6subnet,mac,internal,virtual,operstate,type:type2,duplex,mtu,speed,dhcp,dnsSuffix,ieee8021xAuth,ieee8021xState,carrierChanges})}}_networkInterfaces=result2;if(defaultString.toLowerCase().indexOf("default")>=0){result2=result2.filter(item=>item.default);if(result2.length>0){result2=result2[0]}else{result2=[]}}if(callback){callback(result2)}resolve(result2)}}if(_windows){if(JSON.stringify(ifaces)===JSON.stringify(_ifaces)&&!rescan){result2=_networkInterfaces;if(callback){callback(result2)}resolve(result2)}else{_ifaces=JSON.parse(JSON.stringify(ifaces));const defaultInterface=getDefaultNetworkInterface();getWindowsNics().then(function(nics2){nics2.forEach(nic=>{let found=false;Object.keys(ifaces).forEach(key=>{if(!found){ifaces[key].forEach(value=>{if(Object.keys(value).indexOf("mac")>=0){found=value["mac"]===nic.mac}})}});if(!found){ifaces[nic.name]=[{mac:nic.mac}]}});nics8021xInfo=getWindowsWiredProfilesInformation();dnsSuffixes=getWindowsDNSsuffixes();for(let dev in ifaces){let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(dev);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}let iface=dev;let ip4="";let ip4subnet="";let ip6="";let ip6subnet="";let mac="";let duplex="";let mtu="";let speed=null;let carrierChanges=0;let operstate="down";let dhcp=false;let dnsSuffix="";let ieee8021xAuth="";let ieee8021xState="";let type2="";if({}.hasOwnProperty.call(ifaces,dev)){let ifaceName=dev;ifaces[dev].forEach(function(details){if(details.family==="IPv4"||details.family===4){ip4=details.address;ip4subnet=details.netmask}if(details.family==="IPv6"||details.family===6){if(!ip6||ip6.match(/^fe80::/i)){ip6=details.address;ip6subnet=details.netmask}}mac=details.mac;const nodeMainVersion=parseInt(process.versions.node.split("."),10);if(mac.indexOf("00:00:0")>-1&&(_linux||_darwin)&&!details.internal&&nodeMainVersion>=8&&nodeMainVersion<=11){if(Object.keys(_mac).length===0){_mac=getMacAddresses()}mac=_mac[dev]||""}});dnsSuffix=getWindowsIfaceDNSsuffix(dnsSuffixes.ifaces,ifaceSanitized);let foundFirst=false;nics2.forEach(detail=>{if(detail.mac===mac&&!foundFirst){iface=detail.iface||iface;ifaceName=detail.name;dhcp=detail.dhcp;operstate=detail.operstate;speed=operstate==="up"?detail.speed:0;type2=detail.type;foundFirst=true}});if(dev.toLowerCase().indexOf("wlan")>=0||ifaceName.toLowerCase().indexOf("wlan")>=0||ifaceName.toLowerCase().indexOf("802.11n")>=0||ifaceName.toLowerCase().indexOf("wireless")>=0||ifaceName.toLowerCase().indexOf("wi-fi")>=0||ifaceName.toLowerCase().indexOf("wifi")>=0){type2="wireless"}const IEEE8021x=getWindowsIEEE8021x(type2,ifaceSanitized,nics8021xInfo);ieee8021xAuth=IEEE8021x.protocol;ieee8021xState=IEEE8021x.state;let internal=ifaces[dev]&&ifaces[dev][0]?ifaces[dev][0].internal:false;if(dev.toLowerCase().indexOf("loopback")>-1||ifaceName.toLowerCase().indexOf("loopback")>-1){internal=true}const virtual=internal?false:testVirtualNic(dev,ifaceName,mac);result2.push({iface,ifaceName,default:iface===defaultInterface,ip4,ip4subnet,ip6,ip6subnet,mac,internal,virtual,operstate,type:type2,duplex,mtu,speed,dhcp,dnsSuffix,ieee8021xAuth,ieee8021xState,carrierChanges})}}_networkInterfaces=result2;if(defaultString.toLowerCase().indexOf("default")>=0){result2=result2.filter(item=>item.default);if(result2.length>0){result2=result2[0]}else{result2=[]}}if(callback){callback(result2)}resolve(result2)})}}})})}exports2.networkInterfaces=networkInterfaces;function calcNetworkSpeed(iface,rx_bytes,tx_bytes,operstate,rx_dropped,rx_errors,tx_dropped,tx_errors){let result2={iface,operstate,rx_bytes,rx_dropped,rx_errors,tx_bytes,tx_dropped,tx_errors,rx_sec:null,tx_sec:null,ms:0};if(_network[iface]&&_network[iface].ms){result2.ms=Date.now()-_network[iface].ms;result2.rx_sec=rx_bytes-_network[iface].rx_bytes>=0?(rx_bytes-_network[iface].rx_bytes)/(result2.ms/1e3):0;result2.tx_sec=tx_bytes-_network[iface].tx_bytes>=0?(tx_bytes-_network[iface].tx_bytes)/(result2.ms/1e3):0;_network[iface].rx_bytes=rx_bytes;_network[iface].tx_bytes=tx_bytes;_network[iface].rx_sec=result2.rx_sec;_network[iface].tx_sec=result2.tx_sec;_network[iface].ms=Date.now();_network[iface].last_ms=result2.ms;_network[iface].operstate=operstate}else{if(!_network[iface]){_network[iface]={}}_network[iface].rx_bytes=rx_bytes;_network[iface].tx_bytes=tx_bytes;_network[iface].rx_sec=null;_network[iface].tx_sec=null;_network[iface].ms=Date.now();_network[iface].last_ms=0;_network[iface].operstate=operstate}return result2}function networkStats(ifaces,callback){let ifacesArray=[];return new Promise(resolve=>{process.nextTick(()=>{if(util4.isFunction(ifaces)&&!callback){callback=ifaces;ifacesArray=[getDefaultNetworkInterface()]}else{if(typeof ifaces!=="string"&&ifaces!==void 0){if(callback){callback([])}return resolve([])}ifaces=ifaces||getDefaultNetworkInterface();try{ifaces.__proto__.toLowerCase=util4.stringToLower;ifaces.__proto__.replace=util4.stringReplace;ifaces.__proto__.toString=util4.stringToString;ifaces.__proto__.substr=util4.stringSubstr;ifaces.__proto__.substring=util4.stringSubstring;ifaces.__proto__.trim=util4.stringTrim;ifaces.__proto__.startsWith=util4.stringStartWith}catch(e){Object.setPrototypeOf(ifaces,util4.stringObj)}ifaces=ifaces.trim().toLowerCase().replace(/,+/g,"|");ifacesArray=ifaces.split("|")}const result2=[];const workload=[];if(ifacesArray.length&&ifacesArray[0].trim()==="*"){ifacesArray=[];networkInterfaces(false).then(allIFaces=>{for(let iface of allIFaces){ifacesArray.push(iface.iface)}networkStats(ifacesArray.join(",")).then(result3=>{if(callback){callback(result3)}resolve(result3)})})}else{for(let iface of ifacesArray){workload.push(networkStatsSingle(iface.trim()))}if(workload.length){Promise.all(workload).then(data=>{if(callback){callback(data)}resolve(data)})}else{if(callback){callback(result2)}resolve(result2)}}})})}function networkStatsSingle(iface){function parseLinesWindowsPerfData(sections){let perfData=[];for(let i in sections){if({}.hasOwnProperty.call(sections,i)){if(sections[i].trim()!==""){let lines=sections[i].trim().split("\r\n");perfData.push({name:util4.getValue(lines,"Name",":").replace(/[()[\] ]+/g,"").replace(/#|\//g,"_").toLowerCase(),rx_bytes:parseInt(util4.getValue(lines,"BytesReceivedPersec",":"),10),rx_errors:parseInt(util4.getValue(lines,"PacketsReceivedErrors",":"),10),rx_dropped:parseInt(util4.getValue(lines,"PacketsReceivedDiscarded",":"),10),tx_bytes:parseInt(util4.getValue(lines,"BytesSentPersec",":"),10),tx_errors:parseInt(util4.getValue(lines,"PacketsOutboundErrors",":"),10),tx_dropped:parseInt(util4.getValue(lines,"PacketsOutboundDiscarded",":"),10)})}}}return perfData}return new Promise(resolve=>{process.nextTick(()=>{let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(iface);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}let result2={iface:ifaceSanitized,operstate:"unknown",rx_bytes:0,rx_dropped:0,rx_errors:0,tx_bytes:0,tx_dropped:0,tx_errors:0,rx_sec:null,tx_sec:null,ms:0};let operstate="unknown";let rx_bytes=0;let tx_bytes=0;let rx_dropped=0;let rx_errors=0;let tx_dropped=0;let tx_errors=0;let cmd,lines,stats;if(!_network[ifaceSanitized]||_network[ifaceSanitized]&&!_network[ifaceSanitized].ms||_network[ifaceSanitized]&&_network[ifaceSanitized].ms&&Date.now()-_network[ifaceSanitized].ms>=500){if(_linux){if(fs14.existsSync("/sys/class/net/"+ifaceSanitized)){cmd="cat /sys/class/net/"+ifaceSanitized+"/operstate; cat /sys/class/net/"+ifaceSanitized+"/statistics/rx_bytes; cat /sys/class/net/"+ifaceSanitized+"/statistics/tx_bytes; cat /sys/class/net/"+ifaceSanitized+"/statistics/rx_dropped; cat /sys/class/net/"+ifaceSanitized+"/statistics/rx_errors; cat /sys/class/net/"+ifaceSanitized+"/statistics/tx_dropped; cat /sys/class/net/"+ifaceSanitized+"/statistics/tx_errors; ";exec3(cmd,function(error,stdout){if(!error){lines=stdout.toString().split("\n");operstate=lines[0].trim();rx_bytes=parseInt(lines[1],10);tx_bytes=parseInt(lines[2],10);rx_dropped=parseInt(lines[3],10);rx_errors=parseInt(lines[4],10);tx_dropped=parseInt(lines[5],10);tx_errors=parseInt(lines[6],10);result2=calcNetworkSpeed(ifaceSanitized,rx_bytes,tx_bytes,operstate,rx_dropped,rx_errors,tx_dropped,tx_errors)}resolve(result2)})}else{resolve(result2)}}if(_freebsd||_openbsd||_netbsd){cmd="netstat -ibndI "+ifaceSanitized;exec3(cmd,function(error,stdout){if(!error){lines=stdout.toString().split("\n");for(let i=1;i<lines.length;i++){const line=lines[i].replace(/ +/g," ").split(" ");if(line&&line[0]&&line[7]&&line[10]){rx_bytes=rx_bytes+parseInt(line[7]);if(line[6].trim()!=="-"){rx_dropped=rx_dropped+parseInt(line[6])}if(line[5].trim()!=="-"){rx_errors=rx_errors+parseInt(line[5])}tx_bytes=tx_bytes+parseInt(line[10]);if(line[12].trim()!=="-"){tx_dropped=tx_dropped+parseInt(line[12])}if(line[9].trim()!=="-"){tx_errors=tx_errors+parseInt(line[9])}operstate="up"}}result2=calcNetworkSpeed(ifaceSanitized,rx_bytes,tx_bytes,operstate,rx_dropped,rx_errors,tx_dropped,tx_errors)}resolve(result2)})}if(_darwin){cmd="ifconfig "+ifaceSanitized+' | grep "status"';exec3(cmd,function(error,stdout){result2.operstate=(stdout.toString().split(":")[1]||"").trim();result2.operstate=(result2.operstate||"").toLowerCase();result2.operstate=result2.operstate==="active"?"up":result2.operstate==="inactive"?"down":"unknown";cmd="netstat -bdI "+ifaceSanitized;exec3(cmd,function(error2,stdout2){if(!error2){lines=stdout2.toString().split("\n");if(lines.length>1&&lines[1].trim()!==""){stats=lines[1].replace(/ +/g," ").split(" ");const offset=stats.length>11?1:0;rx_bytes=parseInt(stats[offset+5]);rx_dropped=parseInt(stats[offset+10]);rx_errors=parseInt(stats[offset+4]);tx_bytes=parseInt(stats[offset+8]);tx_dropped=parseInt(stats[offset+10]);tx_errors=parseInt(stats[offset+7]);result2=calcNetworkSpeed(ifaceSanitized,rx_bytes,tx_bytes,result2.operstate,rx_dropped,rx_errors,tx_dropped,tx_errors)}}resolve(result2)})})}if(_windows){let perfData=[];let ifaceName=ifaceSanitized;util4.powerShell("Get-CimInstance Win32_PerfRawData_Tcpip_NetworkInterface | select Name,BytesReceivedPersec,PacketsReceivedErrors,PacketsReceivedDiscarded,BytesSentPersec,PacketsOutboundErrors,PacketsOutboundDiscarded | fl").then((stdout,error)=>{if(!error){const psections=stdout.toString().split(/\n\s*\n/);perfData=parseLinesWindowsPerfData(psections)}networkInterfaces(false).then(interfaces=>{rx_bytes=0;tx_bytes=0;perfData.forEach(detail=>{interfaces.forEach(det=>{if((det.iface.toLowerCase()===ifaceSanitized.toLowerCase()||det.mac.toLowerCase()===ifaceSanitized.toLowerCase()||det.ip4.toLowerCase()===ifaceSanitized.toLowerCase()||det.ip6.toLowerCase()===ifaceSanitized.toLowerCase()||det.ifaceName.replace(/[()[\] ]+/g,"").replace(/#|\//g,"_").toLowerCase()===ifaceSanitized.replace(/[()[\] ]+/g,"").replace("#","_").toLowerCase())&&det.ifaceName.replace(/[()[\] ]+/g,"").replace(/#|\//g,"_").toLowerCase()===detail.name){ifaceName=det.iface;rx_bytes=detail.rx_bytes;rx_dropped=detail.rx_dropped;rx_errors=detail.rx_errors;tx_bytes=detail.tx_bytes;tx_dropped=detail.tx_dropped;tx_errors=detail.tx_errors;operstate=det.operstate}})});if(rx_bytes&&tx_bytes){result2=calcNetworkSpeed(ifaceName,parseInt(rx_bytes),parseInt(tx_bytes),operstate,rx_dropped,rx_errors,tx_dropped,tx_errors)}resolve(result2)})})}}else{result2.rx_bytes=_network[ifaceSanitized].rx_bytes;result2.tx_bytes=_network[ifaceSanitized].tx_bytes;result2.rx_sec=_network[ifaceSanitized].rx_sec;result2.tx_sec=_network[ifaceSanitized].tx_sec;result2.ms=_network[ifaceSanitized].last_ms;result2.operstate=_network[ifaceSanitized].operstate;resolve(result2)}})})}exports2.networkStats=networkStats;function getProcessName(processes,pid){let cmd="";processes.forEach(line=>{const parts=line.split(" ");const id=parseInt(parts[0],10)||-1;if(id===pid){parts.shift();cmd=parts.join(" ").split(":")[0]}});cmd=cmd.split(" -")[0];cmd=cmd.split(" /")[0];return cmd}function networkConnections(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux||_freebsd||_openbsd||_netbsd){let cmd='export LC_ALL=C; netstat -tunap | grep "ESTABLISHED\\|SYN_SENT\\|SYN_RECV\\|FIN_WAIT1\\|FIN_WAIT2\\|TIME_WAIT\\|CLOSE\\|CLOSE_WAIT\\|LAST_ACK\\|LISTEN\\|CLOSING\\|UNKNOWN"; unset LC_ALL';if(_freebsd||_openbsd||_netbsd){cmd='export LC_ALL=C; netstat -na | grep "ESTABLISHED\\|SYN_SENT\\|SYN_RECV\\|FIN_WAIT1\\|FIN_WAIT2\\|TIME_WAIT\\|CLOSE\\|CLOSE_WAIT\\|LAST_ACK\\|LISTEN\\|CLOSING\\|UNKNOWN"; unset LC_ALL'}exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout){let lines=stdout.toString().split("\n");if(!error&&(lines.length>1||lines[0]!="")){lines.forEach(function(line){line=line.replace(/ +/g," ").split(" ");if(line.length>=7){let localip=line[3];let localport="";let localaddress=line[3].split(":");if(localaddress.length>1){localport=localaddress[localaddress.length-1];localaddress.pop();localip=localaddress.join(":")}let peerip=line[4];let peerport="";let peeraddress=line[4].split(":");if(peeraddress.length>1){peerport=peeraddress[peeraddress.length-1];peeraddress.pop();peerip=peeraddress.join(":")}let connstate=line[5];let proc=line[6].split("/");if(connstate){result2.push({protocol:line[0],localAddress:localip,localPort:localport,peerAddress:peerip,peerPort:peerport,state:connstate,pid:proc[0]&&proc[0]!=="-"?parseInt(proc[0],10):null,process:proc[1]?proc[1].split(" ")[0].split(":")[0]:""})}}});if(callback){callback(result2)}resolve(result2)}else{cmd='ss -tunap | grep "ESTAB\\|SYN-SENT\\|SYN-RECV\\|FIN-WAIT1\\|FIN-WAIT2\\|TIME-WAIT\\|CLOSE\\|CLOSE-WAIT\\|LAST-ACK\\|LISTEN\\|CLOSING"';exec3(cmd,{maxBuffer:1024*2e4},function(error2,stdout2){if(!error2){let lines2=stdout2.toString().split("\n");lines2.forEach(function(line){line=line.replace(/ +/g," ").split(" ");if(line.length>=6){let localip=line[4];let localport="";let localaddress=line[4].split(":");if(localaddress.length>1){localport=localaddress[localaddress.length-1];localaddress.pop();localip=localaddress.join(":")}let peerip=line[5];let peerport="";let peeraddress=line[5].split(":");if(peeraddress.length>1){peerport=peeraddress[peeraddress.length-1];peeraddress.pop();peerip=peeraddress.join(":")}let connstate=line[1];if(connstate==="ESTAB"){connstate="ESTABLISHED"}if(connstate==="TIME-WAIT"){connstate="TIME_WAIT"}let pid=null;let process6="";if(line.length>=7&&line[6].indexOf("users:")>-1){let proc=line[6].replace('users:(("',"").replace(/"/g,"").split(",");if(proc.length>2){process6=proc[0].split(" ")[0].split(":")[0];pid=parseInt(proc[1],10)}}if(connstate){result2.push({protocol:line[0],localAddress:localip,localPort:localport,peerAddress:peerip,peerPort:peerport,state:connstate,pid,process:process6})}}})}if(callback){callback(result2)}resolve(result2)})}})}if(_darwin){let cmd='netstat -natvln | head -n2; netstat -natvln | grep "tcp4\\|tcp6\\|udp4\\|udp6"';const states="ESTABLISHED|SYN_SENT|SYN_RECV|FIN_WAIT1|FIN_WAIT_1|FIN_WAIT2|FIN_WAIT_2|TIME_WAIT|CLOSE|CLOSE_WAIT|LAST_ACK|LISTEN|CLOSING|UNKNOWN".split("|");exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout){if(!error){exec3("ps -axo pid,command",{maxBuffer:1024*2e4},function(err2,stdout2){let processes=stdout2.toString().split("\n");processes=processes.map(line=>{return line.trim().replace(/ +/g," ")});let lines=stdout.toString().split("\n");lines.shift();let pidPos=8;if(lines.length>1&&lines[0].indexOf("pid")>0){const header2=(lines.shift()||"").replace(/ Address/g,"_Address").replace(/ +/g," ").split(" ");pidPos=header2.indexOf("pid")}lines.forEach(function(line){line=line.replace(/ +/g," ").split(" ");if(line.length>=8){let localip=line[3];let localport="";let localaddress=line[3].split(".");if(localaddress.length>1){localport=localaddress[localaddress.length-1];localaddress.pop();localip=localaddress.join(".")}let peerip=line[4];let peerport="";let peeraddress=line[4].split(".");if(peeraddress.length>1){peerport=peeraddress[peeraddress.length-1];peeraddress.pop();peerip=peeraddress.join(".")}const hasState=states.indexOf(line[5])>=0;let connstate=hasState?line[5]:"UNKNOWN";let pid=parseInt(line[pidPos+(hasState?0:-1)],10);if(connstate){result2.push({protocol:line[0],localAddress:localip,localPort:localport,peerAddress:peerip,peerPort:peerport,state:connstate,pid,process:getProcessName(processes,pid)})}}});if(callback){callback(result2)}resolve(result2)})}})}if(_windows){let cmd="netstat -nao";try{exec3(cmd,util4.execOptsWin,function(error,stdout){if(!error){let lines=stdout.toString().split("\r\n");lines.forEach(function(line){line=line.trim().replace(/ +/g," ").split(" ");if(line.length>=4){let localip=line[1];let localport="";let localaddress=line[1].split(":");if(localaddress.length>1){localport=localaddress[localaddress.length-1];localaddress.pop();localip=localaddress.join(":")}localip=localip.replace(/\[/g,"").replace(/\]/g,"");let peerip=line[2];let peerport="";let peeraddress=line[2].split(":");if(peeraddress.length>1){peerport=peeraddress[peeraddress.length-1];peeraddress.pop();peerip=peeraddress.join(":")}peerip=peerip.replace(/\[/g,"").replace(/\]/g,"");let pid=util4.toInt(line[4]);let connstate=line[3];if(connstate==="HERGESTELLT"){connstate="ESTABLISHED"}if(connstate.startsWith("ABH")){connstate="LISTEN"}if(connstate==="SCHLIESSEN_WARTEN"){connstate="CLOSE_WAIT"}if(connstate==="WARTEND"){connstate="TIME_WAIT"}if(connstate==="SYN_GESENDET"){connstate="SYN_SENT"}if(connstate==="LISTENING"){connstate="LISTEN"}if(connstate==="SYN_RECEIVED"){connstate="SYN_RECV"}if(connstate==="FIN_WAIT_1"){connstate="FIN_WAIT1"}if(connstate==="FIN_WAIT_2"){connstate="FIN_WAIT2"}if(line[0].toLowerCase()!=="udp"&&connstate){result2.push({protocol:line[0].toLowerCase(),localAddress:localip,localPort:localport,peerAddress:peerip,peerPort:peerport,state:connstate,pid,process:""})}else if(line[0].toLowerCase()==="udp"){result2.push({protocol:line[0].toLowerCase(),localAddress:localip,localPort:localport,peerAddress:peerip,peerPort:peerport,state:"",pid:parseInt(line[3],10),process:""})}}});if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.networkConnections=networkConnections;function networkGatewayDefault(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2="";if(_linux||_freebsd||_openbsd||_netbsd){let cmd="ip route get 1";try{exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout){if(!error){let lines=stdout.toString().split("\n");const line=lines&&lines[0]?lines[0]:"";let parts=line.split(" via ");if(parts&&parts[1]){parts=parts[1].split(" ");result2=parts[0]}if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_darwin){let cmd="route -n get default";try{exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout){if(!error){const lines=stdout.toString().split("\n").map(line=>line.trim());result2=util4.getValue(lines,"gateway")}if(!result2){cmd="netstat -rn | awk '/default/ {print $2}'";exec3(cmd,{maxBuffer:1024*2e4},function(error2,stdout2){const lines=stdout2.toString().split("\n").map(line=>line.trim());result2=lines.find(line=>/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/.test(line));if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_windows){try{exec3("netstat -r",util4.execOptsWin,function(error,stdout){const lines=stdout.toString().split(os7.EOL);lines.forEach(line=>{line=line.replace(/\s+/g," ").trim();if(line.indexOf("0.0.0.0 0.0.0.0")>-1&&!/[a-zA-Z]/.test(line)){const parts=line.split(" ");if(parts.length>=5&&parts[parts.length-3].indexOf(".")>-1){result2=parts[parts.length-3]}}});if(!result2){util4.powerShell("Get-CimInstance -ClassName Win32_IP4RouteTable | Where-Object { $_.Destination -eq '0.0.0.0' -and $_.Mask -eq '0.0.0.0' }").then(data=>{let lines2=data.toString().split("\r\n");if(lines2.length>1&&!result2){result2=util4.getValue(lines2,"NextHop");if(callback){callback(result2)}resolve(result2)}})}else{if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.networkGatewayDefault=networkGatewayDefault}});var require_wifi=__commonJS({"node_modules/systeminformation/lib/wifi.js"(exports2){"use strict";var os7=require("os");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";function wifiDBFromQuality(quality){const qual=parseFloat(quality);if(qual<0){return 0}if(qual>=100){return-50}return qual/2-100}function wifiQualityFromDB(db){const result2=2*(parseFloat(db)+100);return result2<=100?result2:100}var _wifi_frequencies={1:2412,2:2417,3:2422,4:2427,5:2432,6:2437,7:2442,8:2447,9:2452,10:2457,11:2462,12:2467,13:2472,14:2484,32:5160,34:5170,36:5180,38:5190,40:5200,42:5210,44:5220,46:5230,48:5240,50:5250,52:5260,54:5270,56:5280,58:5290,60:5300,62:5310,64:5320,68:5340,96:5480,100:5500,102:5510,104:5520,106:5530,108:5540,110:5550,112:5560,114:5570,116:5580,118:5590,120:5600,122:5610,124:5620,126:5630,128:5640,132:5660,134:5670,136:5680,138:5690,140:5700,142:5710,144:5720,149:5745,151:5755,153:5765,155:5775,157:5785,159:5795,161:5805,165:5825,169:5845,173:5865,183:4915,184:4920,185:4925,187:4935,188:4940,189:4945,192:4960,196:4980};function wifiFrequencyFromChannel(channel){return{}.hasOwnProperty.call(_wifi_frequencies,channel)?_wifi_frequencies[channel]:null}function wifiChannelFromFrequencs(frequency){let channel=0;for(let key in _wifi_frequencies){if({}.hasOwnProperty.call(_wifi_frequencies,key)){if(_wifi_frequencies[key]===frequency){channel=util4.toInt(key)}}}return channel}function ifaceListLinux(){const result2=[];const cmd="iw dev 2>/dev/null";try{const all2=execSync(cmd,util4.execOptsLinux).toString().split("\n").map(line=>line.trim()).join("\n");const parts=all2.split("\nInterface ");parts.shift();parts.forEach(ifaceDetails=>{const lines=ifaceDetails.split("\n");const iface=lines[0];const id=util4.toInt(util4.getValue(lines,"ifindex"," "));const mac=util4.getValue(lines,"addr"," ");const channel=util4.toInt(util4.getValue(lines,"channel"," "));result2.push({id,iface,mac,channel})});return result2}catch(e){try{const all2=execSync("nmcli -t -f general,wifi-properties,wired-properties,interface-flags,capabilities,nsp device show 2>/dev/null",util4.execOptsLinux).toString();const parts=all2.split("\n\n");let i=1;parts.forEach(ifaceDetails=>{const lines=ifaceDetails.split("\n");const iface=util4.getValue(lines,"GENERAL.DEVICE");const type2=util4.getValue(lines,"GENERAL.TYPE");const id=i++;const mac=util4.getValue(lines,"GENERAL.HWADDR");const channel="";if(type2.toLowerCase()==="wifi"){result2.push({id,iface,mac,channel})}});return result2}catch(e2){return[]}}}function nmiDeviceLinux(iface){const cmd=`nmcli -t -f general,wifi-properties,capabilities,ip4,ip6 device show ${iface} 2> /dev/null`;try{const lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");const ssid=util4.getValue(lines,"GENERAL.CONNECTION");return{iface,type:util4.getValue(lines,"GENERAL.TYPE"),vendor:util4.getValue(lines,"GENERAL.VENDOR"),product:util4.getValue(lines,"GENERAL.PRODUCT"),mac:util4.getValue(lines,"GENERAL.HWADDR").toLowerCase(),ssid:ssid!=="--"?ssid:null}}catch(e){return{}}}function nmiConnectionLinux(ssid){const cmd=`nmcli -t --show-secrets connection show ${ssid} 2>/dev/null`;try{const lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");const bssid=util4.getValue(lines,"802-11-wireless.seen-bssids").toLowerCase();return{ssid:ssid!=="--"?ssid:null,uuid:util4.getValue(lines,"connection.uuid"),type:util4.getValue(lines,"connection.type"),autoconnect:util4.getValue(lines,"connection.autoconnect")==="yes",security:util4.getValue(lines,"802-11-wireless-security.key-mgmt"),bssid:bssid!=="--"?bssid:null}}catch(e){return{}}}function wpaConnectionLinux(iface){if(!iface){return{}}const cmd=`wpa_cli -i ${iface} status 2>&1`;try{const lines=execSync(cmd,util4.execOptsLinux).toString().split("\n");const freq=util4.toInt(util4.getValue(lines,"freq","="));return{ssid:util4.getValue(lines,"ssid","="),uuid:util4.getValue(lines,"uuid","="),security:util4.getValue(lines,"key_mgmt","="),freq,channel:wifiChannelFromFrequencs(freq),bssid:util4.getValue(lines,"bssid","=").toLowerCase()}}catch(e){return{}}}function getWifiNetworkListNmi(){const result2=[];const cmd="nmcli -t -m multiline --fields active,ssid,bssid,mode,chan,freq,signal,security,wpa-flags,rsn-flags device wifi list 2>/dev/null";try{const stdout=execSync(cmd,util4.execOptsLinux);const parts=stdout.toString().split("ACTIVE:");parts.shift();parts.forEach(part=>{part="ACTIVE:"+part;const lines=part.split(os7.EOL);const channel=util4.getValue(lines,"CHAN");const frequency=util4.getValue(lines,"FREQ").toLowerCase().replace("mhz","").trim();const security=util4.getValue(lines,"SECURITY").replace("(","").replace(")","");const wpaFlags=util4.getValue(lines,"WPA-FLAGS").replace("(","").replace(")","");const rsnFlags=util4.getValue(lines,"RSN-FLAGS").replace("(","").replace(")","");const quality=util4.getValue(lines,"SIGNAL");result2.push({ssid:util4.getValue(lines,"SSID"),bssid:util4.getValue(lines,"BSSID").toLowerCase(),mode:util4.getValue(lines,"MODE"),channel:channel?parseInt(channel,10):null,frequency:frequency?parseInt(frequency,10):null,signalLevel:wifiDBFromQuality(quality),quality:quality?parseInt(quality,10):null,security:security&&security!=="none"?security.split(" "):[],wpaFlags:wpaFlags&&wpaFlags!=="none"?wpaFlags.split(" "):[],rsnFlags:rsnFlags&&rsnFlags!=="none"?rsnFlags.split(" "):[]})});return result2}catch(e){return[]}}function getWifiNetworkListIw(iface){const result2=[];try{let iwlistParts=execSync(`export LC_ALL=C; iwlist ${iface} scan 2>&1; unset LC_ALL`,util4.execOptsLinux).toString().split("        Cell ");if(iwlistParts[0].indexOf("resource busy")>=0){return-1}if(iwlistParts.length>1){iwlistParts.shift();iwlistParts.forEach(element=>{const lines=element.split("\n");const channel=util4.getValue(lines,"channel",":",true);const address=lines&&lines.length&&lines[0].indexOf("Address:")>=0?lines[0].split("Address:")[1].trim().toLowerCase():"";const mode2=util4.getValue(lines,"mode",":",true);const frequency=util4.getValue(lines,"frequency",":",true);const qualityString=util4.getValue(lines,"Quality","=",true);const dbParts=qualityString.toLowerCase().split("signal level=");const db=dbParts.length>1?util4.toInt(dbParts[1]):0;const quality=db?wifiQualityFromDB(db):0;const ssid=util4.getValue(lines,"essid",":",true);const isWpa=element.indexOf(" WPA ")>=0;const isWpa2=element.indexOf("WPA2 ")>=0;const security=[];if(isWpa){security.push("WPA")}if(isWpa2){security.push("WPA2")}const wpaFlags=[];let wpaFlag="";lines.forEach(function(line){const l=line.trim().toLowerCase();if(l.indexOf("group cipher")>=0){if(wpaFlag){wpaFlags.push(wpaFlag)}const parts=l.split(":");if(parts.length>1){wpaFlag=parts[1].trim().toUpperCase()}}if(l.indexOf("pairwise cipher")>=0){const parts=l.split(":");if(parts.length>1){if(parts[1].indexOf("tkip")){wpaFlag=wpaFlag?"TKIP/"+wpaFlag:"TKIP"}else if(parts[1].indexOf("ccmp")){wpaFlag=wpaFlag?"CCMP/"+wpaFlag:"CCMP"}else if(parts[1].indexOf("proprietary")){wpaFlag=wpaFlag?"PROP/"+wpaFlag:"PROP"}}}if(l.indexOf("authentication suites")>=0){const parts=l.split(":");if(parts.length>1){if(parts[1].indexOf("802.1x")){wpaFlag=wpaFlag?"802.1x/"+wpaFlag:"802.1x"}else if(parts[1].indexOf("psk")){wpaFlag=wpaFlag?"PSK/"+wpaFlag:"PSK"}}}});if(wpaFlag){wpaFlags.push(wpaFlag)}result2.push({ssid,bssid:address,mode:mode2,channel:channel?util4.toInt(channel):null,frequency:frequency?util4.toInt(frequency.replace(".","")):null,signalLevel:db,quality,security,wpaFlags,rsnFlags:[]})})}return result2}catch(e){return-1}}function parseWifiDarwin(wifiStr){const result2=[];try{let wifiObj=JSON.parse(wifiStr);wifiObj=wifiObj.SPAirPortDataType[0].spairport_airport_interfaces[0].spairport_airport_other_local_wireless_networks;wifiObj.forEach(function(wifiItem){let security=[];const sm=wifiItem.spairport_security_mode;if(sm==="spairport_security_mode_wep"){security.push("WEP")}else if(sm==="spairport_security_mode_wpa2_personal"){security.push("WPA2")}else if(sm.startsWith("spairport_security_mode_wpa2_enterprise")){security.push("WPA2 EAP")}else if(sm.startsWith("pairport_security_mode_wpa3_transition")){security.push("WPA2/WPA3")}else if(sm.startsWith("pairport_security_mode_wpa3")){security.push("WPA3")}const channel=parseInt((""+wifiItem.spairport_network_channel).split(" ")[0])||0;const signalLevel=wifiItem.spairport_signal_noise||null;result2.push({ssid:wifiItem._name||"",bssid:wifiItem.spairport_network_bssid||null,mode:wifiItem.spairport_network_phymode,channel,frequency:wifiFrequencyFromChannel(channel),signalLevel:signalLevel?parseInt(signalLevel,10):null,quality:wifiQualityFromDB(signalLevel),security,wpaFlags:[],rsnFlags:[]})});return result2}catch(e){return result2}}function wifiNetworks(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux){result2=getWifiNetworkListNmi();if(result2.length===0){try{const iwconfigParts=execSync("export LC_ALL=C; iwconfig 2>/dev/null; unset LC_ALL",util4.execOptsLinux).toString().split("\n\n");let iface="";iwconfigParts.forEach(element=>{if(element.indexOf("no wireless")===-1&&element.trim()!==""){iface=element.split(" ")[0]}});if(iface){let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(iface,true);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}const res=getWifiNetworkListIw(ifaceSanitized);if(res===-1){setTimeout(function(iface2){const res2=getWifiNetworkListIw(iface2);if(res2!=-1){result2=res2}if(callback){callback(result2)}resolve(result2)},4e3)}else{result2=res;if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}}catch(e){if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}}else if(_darwin){let cmd="system_profiler SPAirPortDataType -json 2>/dev/null";exec3(cmd,{maxBuffer:1024*4e4},function(error,stdout){result2=parseWifiDarwin(stdout.toString());if(callback){callback(result2)}resolve(result2)})}else if(_windows){let cmd="netsh wlan show networks mode=Bssid";util4.powerShell(cmd).then(stdout=>{const ssidParts=stdout.toString("utf8").split(os7.EOL+os7.EOL+"SSID ");ssidParts.shift();ssidParts.forEach(ssidPart=>{const ssidLines=ssidPart.split(os7.EOL);if(ssidLines&&ssidLines.length>=8&&ssidLines[0].indexOf(":")>=0){const bssidsParts=ssidPart.split(" BSSID");bssidsParts.shift();bssidsParts.forEach(bssidPart=>{const bssidLines=bssidPart.split(os7.EOL);const bssidLine=bssidLines[0].split(":");bssidLine.shift();const bssid=bssidLine.join(":").trim().toLowerCase();const channel=bssidLines[3].split(":").pop().trim();const quality=bssidLines[1].split(":").pop().trim();result2.push({ssid:ssidLines[0].split(":").pop().trim(),bssid,mode:"",channel:channel?parseInt(channel,10):null,frequency:wifiFrequencyFromChannel(channel),signalLevel:wifiDBFromQuality(quality),quality:quality?parseInt(quality,10):null,security:[ssidLines[2].split(":").pop().trim()],wpaFlags:[ssidLines[3].split(":").pop().trim()],rsnFlags:[]})})}});if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})})}exports2.wifiNetworks=wifiNetworks;function getVendor(model){model=model.toLowerCase();let result2="";if(model.indexOf("intel")>=0){result2="Intel"}else if(model.indexOf("realtek")>=0){result2="Realtek"}else if(model.indexOf("qualcom")>=0){result2="Qualcom"}else if(model.indexOf("broadcom")>=0){result2="Broadcom"}else if(model.indexOf("cavium")>=0){result2="Cavium"}else if(model.indexOf("cisco")>=0){result2="Cisco"}else if(model.indexOf("marvel")>=0){result2="Marvel"}else if(model.indexOf("zyxel")>=0){result2="Zyxel"}else if(model.indexOf("melanox")>=0){result2="Melanox"}else if(model.indexOf("d-link")>=0){result2="D-Link"}else if(model.indexOf("tp-link")>=0){result2="TP-Link"}else if(model.indexOf("asus")>=0){result2="Asus"}else if(model.indexOf("linksys")>=0){result2="Linksys"}return result2}function wifiConnections(callback){return new Promise(resolve=>{process.nextTick(()=>{const result2=[];if(_linux){const ifaces=ifaceListLinux();const networkList=getWifiNetworkListNmi();ifaces.forEach(ifaceDetail=>{let ifaceSanitized="";const s=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(ifaceDetail.iface,true);const ll=util4.mathMin(s.length,2e3);for(let i=0;i<=ll;i++){if(s[i]!==void 0){ifaceSanitized=ifaceSanitized+s[i]}}const nmiDetails=nmiDeviceLinux(ifaceSanitized);const wpaDetails=wpaConnectionLinux(ifaceSanitized);const ssid=nmiDetails.ssid||wpaDetails.ssid;const network=networkList.filter(nw=>nw.ssid===ssid);let ssidSanitized="";const t=util4.isPrototypePolluted()?"---":util4.sanitizeShellString(ssid,true);const l=util4.mathMin(t.length,32);for(let i=0;i<=l;i++){if(t[i]!==void 0){ssidSanitized=ssidSanitized+t[i]}}const nmiConnection=nmiConnectionLinux(ssidSanitized);const channel=network&&network.length&&network[0].channel?network[0].channel:wpaDetails.channel?wpaDetails.channel:null;const bssid=network&&network.length&&network[0].bssid?network[0].bssid:wpaDetails.bssid?wpaDetails.bssid:null;const signalLevel=network&&network.length&&network[0].signalLevel?network[0].signalLevel:null;if(ssid&&bssid){result2.push({id:ifaceDetail.id,iface:ifaceDetail.iface,model:nmiDetails.product,ssid,bssid:network&&network.length&&network[0].bssid?network[0].bssid:wpaDetails.bssid?wpaDetails.bssid:null,channel,frequency:channel?wifiFrequencyFromChannel(channel):null,type:nmiConnection.type?nmiConnection.type:"802.11",security:nmiConnection.security?nmiConnection.security:wpaDetails.security?wpaDetails.security:null,signalLevel,quality:wifiQualityFromDB(signalLevel),txRate:null})}});if(callback){callback(result2)}resolve(result2)}else if(_darwin){let cmd='system_profiler SPNetworkDataType SPAirPortDataType -xml 2>/dev/null; echo "######" ; ioreg -n AppleBCMWLANSkywalkInterface -r 2>/dev/null';exec3(cmd,function(error,stdout){try{const parts=stdout.toString().split("######");const profilerObj=util4.plistParser(parts[0]);const networkObj=profilerObj[0]._SPCommandLineArguments.indexOf("SPNetworkDataType")>=0?profilerObj[0]._items:profilerObj[1]._items;const airportObj=profilerObj[0]._SPCommandLineArguments.indexOf("SPAirPortDataType")>=0?profilerObj[0]._items[0].spairport_airport_interfaces:profilerObj[1]._items[0].spairport_airport_interfaces;let lines3=[];if(parts[1].indexOf("  | {")>0&&parts[1].indexOf("  | }")>parts[1].indexOf("  | {")){lines3=parts[1].split("  | {")[1].split("  | }")[0].replace(/ \| /g,"").replace(/"/g,"").split("\n")}const networkWifiObj=networkObj.find(item=>{return item._name==="Wi-Fi"});const airportWifiObj=airportObj[0].spairport_current_network_information;const channel=parseInt((""+airportWifiObj.spairport_network_channel).split(" ")[0])||0;const signalLevel=airportWifiObj.spairport_signal_noise||null;let security=[];const sm=airportWifiObj.spairport_security_mode;if(sm==="spairport_security_mode_wep"){security.push("WEP")}else if(sm==="spairport_security_mode_wpa2_personal"){security.push("WPA2")}else if(sm.startsWith("spairport_security_mode_wpa2_enterprise")){security.push("WPA2 EAP")}else if(sm.startsWith("pairport_security_mode_wpa3_transition")){security.push("WPA2/WPA3")}else if(sm.startsWith("pairport_security_mode_wpa3")){security.push("WPA3")}result2.push({id:networkWifiObj._name||"Wi-Fi",iface:networkWifiObj.interface||"",model:networkWifiObj.hardware||"",ssid:airportWifiObj._name||"",bssid:airportWifiObj.spairport_network_bssid||"",channel,frequency:channel?wifiFrequencyFromChannel(channel):null,type:airportWifiObj.spairport_network_phymode||"802.11",security,signalLevel:signalLevel?parseInt(signalLevel,10):null,quality:wifiQualityFromDB(signalLevel),txRate:airportWifiObj.spairport_network_rate||null})}catch(e){util4.noop()}if(callback){callback(result2)}resolve(result2)})}else if(_windows){let cmd="netsh wlan show interfaces";util4.powerShell(cmd).then(function(stdout){const allLines=stdout.toString().split("\r\n");for(let i=0;i<allLines.length;i++){allLines[i]=allLines[i].trim()}const parts=allLines.join("\r\n").split(":\r\n\r\n");parts.shift();parts.forEach(part=>{const lines=part.split("\r\n");if(lines.length>=5){const iface=lines[0].indexOf(":")>=0?lines[0].split(":")[1].trim():"";const model=lines[1].indexOf(":")>=0?lines[1].split(":")[1].trim():"";const id=lines[2].indexOf(":")>=0?lines[2].split(":")[1].trim():"";const ssid=util4.getValue(lines,"SSID",":",true);const bssid=util4.getValue(lines,"BSSID",":",true)||util4.getValue(lines,"AP BSSID",":",true);const quality=util4.getValue(lines,"Signal",":",true);const signalLevel=wifiDBFromQuality(quality);const type2=util4.getValue(lines,"Radio type",":",true)||util4.getValue(lines,"Type de radio",":",true)||util4.getValue(lines,"Funktyp",":",true)||null;const security=util4.getValue(lines,"authentication",":",true)||util4.getValue(lines,"Authentification",":",true)||util4.getValue(lines,"Authentifizierung",":",true)||null;const channel=util4.getValue(lines,"Channel",":",true)||util4.getValue(lines,"Canal",":",true)||util4.getValue(lines,"Kanal",":",true)||null;const txRate=util4.getValue(lines,"Transmit rate (mbps)",":",true)||util4.getValue(lines,"Transmission (mbit/s)",":",true)||util4.getValue(lines,"Empfangsrate (MBit/s)",":",true)||null;if(model&&id&&ssid&&bssid){result2.push({id,iface,model,ssid,bssid,channel:util4.toInt(channel),frequency:channel?wifiFrequencyFromChannel(channel):null,type:type2,security,signalLevel,quality:quality?parseInt(quality,10):null,txRate:util4.toInt(txRate)||null})}}});if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})})}exports2.wifiConnections=wifiConnections;function wifiInterfaces(callback){return new Promise(resolve=>{process.nextTick(()=>{const result2=[];if(_linux){const ifaces=ifaceListLinux();ifaces.forEach(ifaceDetail=>{const nmiDetails=nmiDeviceLinux(ifaceDetail.iface);result2.push({id:ifaceDetail.id,iface:ifaceDetail.iface,model:nmiDetails.product?nmiDetails.product:null,vendor:nmiDetails.vendor?nmiDetails.vendor:null,mac:ifaceDetail.mac})});if(callback){callback(result2)}resolve(result2)}else if(_darwin){let cmd="system_profiler SPNetworkDataType";exec3(cmd,function(error,stdout){const parts1=stdout.toString().split("\n\n    Wi-Fi:\n\n");if(parts1.length>1){const lines=parts1[1].split("\n\n")[0].split("\n");const iface=util4.getValue(lines,"BSD Device Name",":",true);const mac=util4.getValue(lines,"MAC Address",":",true);const model=util4.getValue(lines,"hardware",":",true);result2.push({id:"Wi-Fi",iface,model,vendor:"",mac})}if(callback){callback(result2)}resolve(result2)})}else if(_windows){let cmd="netsh wlan show interfaces";util4.powerShell(cmd).then(function(stdout){const allLines=stdout.toString().split("\r\n");for(let i=0;i<allLines.length;i++){allLines[i]=allLines[i].trim()}const parts=allLines.join("\r\n").split(":\r\n\r\n");parts.shift();parts.forEach(part=>{const lines=part.split("\r\n");if(lines.length>=5){const iface=lines[0].indexOf(":")>=0?lines[0].split(":")[1].trim():"";const model=lines[1].indexOf(":")>=0?lines[1].split(":")[1].trim():"";const id=lines[2].indexOf(":")>=0?lines[2].split(":")[1].trim():"";const macParts=lines[3].indexOf(":")>=0?lines[3].split(":"):[];macParts.shift();const mac=macParts.join(":").trim();const vendor=getVendor(model);if(iface&&model&&id&&mac){result2.push({id,iface,model,vendor,mac})}}});if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})})}exports2.wifiInterfaces=wifiInterfaces}});var require_processes=__commonJS({"node_modules/systeminformation/lib/processes.js"(exports2){"use strict";var os7=require("os");var fs14=require("fs");var path27=require("path");var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var _processes_cpu={all:0,all_utime:0,all_stime:0,list:{},ms:0,result:{}};var _services_cpu={all:0,all_utime:0,all_stime:0,list:{},ms:0,result:{}};var _process_cpu={all:0,all_utime:0,all_stime:0,list:{},ms:0,result:{}};var _winStatusValues={"0":"unknown","1":"other","2":"ready","3":"running","4":"blocked","5":"suspended blocked","6":"suspended ready","7":"terminated","8":"stopped","9":"growing"};function parseTimeUnix(time){let result2=time;let parts=time.replace(/ +/g," ").split(" ");if(parts.length===5){result2=parts[4]+"-"+("0"+("JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC".indexOf(parts[1].toUpperCase())/3+1)).slice(-2)+"-"+("0"+parts[2]).slice(-2)+" "+parts[3]}return result2}function parseElapsedTime(etime){let current=new Date;current=new Date(current.getTime()-current.getTimezoneOffset()*6e4);const elapsed=etime.split("-");const timeIndex=elapsed.length-1;const days=timeIndex>0?parseInt(elapsed[timeIndex-1]):0;const timeStr=elapsed[timeIndex].split(":");const hours=timeStr.length===3?parseInt(timeStr[0]||0):0;const mins=parseInt(timeStr[timeStr.length===3?1:0]||0);const secs=parseInt(timeStr[timeStr.length===3?2:1]||0);const ms=(((days*24+hours)*60+mins)*60+secs)*1e3;let res=new Date(current.getTime());let result2=res.toISOString().substring(0,10)+" "+res.toISOString().substring(11,19);try{res=new Date(current.getTime()-ms);result2=res.toISOString().substring(0,10)+" "+res.toISOString().substring(11,19)}catch(e){util4.noop()}return result2}function services(srv,callback){if(util4.isFunction(srv)&&!callback){callback=srv;srv=""}return new Promise(resolve=>{process.nextTick(()=>{if(typeof srv!=="string"){if(callback){callback([])}return resolve([])}if(srv){let srvString="";try{srvString.__proto__.toLowerCase=util4.stringToLower;srvString.__proto__.replace=util4.stringReplace;srvString.__proto__.toString=util4.stringToString;srvString.__proto__.substr=util4.stringSubstr;srvString.__proto__.substring=util4.stringSubstring;srvString.__proto__.trim=util4.stringTrim;srvString.__proto__.startsWith=util4.stringStartWith}catch(e){Object.setPrototypeOf(srvString,util4.stringObj)}const s=util4.sanitizeShellString(srv);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){srvString=srvString+s[i]}}srvString=srvString.trim().toLowerCase().replace(/, /g,"|").replace(/,+/g,"|");if(srvString===""){srvString="*"}if(util4.isPrototypePolluted()&&srvString!=="*"){srvString="------"}let srvs=srvString.split("|");let result2=[];let dataSrv=[];if(_linux||_freebsd||_openbsd||_netbsd||_darwin){if((_linux||_freebsd||_openbsd||_netbsd)&&srvString==="*"){try{const tmpsrv=execSync("systemctl --all --type=service --no-legend 2> /dev/null",util4.execOptsLinux).toString().split("\n");srvs=[];for(const s2 of tmpsrv){const name=s2.split(".service")[0];if(name&&s2.indexOf(" not-found ")===-1){srvs.push(name.trim())}}srvString=srvs.join("|")}catch(d){try{srvString="";const tmpsrv=execSync("service --status-all 2> /dev/null",util4.execOptsLinux).toString().split("\n");for(const s2 of tmpsrv){const parts=s2.split("]");if(parts.length===2){srvString+=(srvString!==""?"|":"")+parts[1].trim()}}srvs=srvString.split("|")}catch(e){try{const srvStr=execSync("ls /etc/init.d/ -m 2> /dev/null",util4.execOptsLinux).toString().split("\n").join("");srvString="";if(srvStr){const tmpsrv=srvStr.split(",");for(const s2 of tmpsrv){const name=s2.trim();if(name){srvString+=(srvString!==""?"|":"")+name}}srvs=srvString.split("|")}}catch(f){srvString="";srvs=[]}}}}if(_darwin&&srvString==="*"){if(callback){callback(result2)}resolve(result2)}let args2=_darwin?["-caxo","pcpu,pmem,pid,command"]:["-axo","pcpu,pmem,pid,command"];if(srvString!==""&&srvs.length>0){util4.execSafe("ps",args2).then(stdout=>{if(stdout){let lines=stdout.replace(/ +/g," ").replace(/,+/g,".").split("\n");srvs.forEach(function(srv2){let ps;if(_darwin){ps=lines.filter(function(e){return e.toLowerCase().indexOf(srv2)!==-1})}else{ps=lines.filter(function(e){return e.toLowerCase().indexOf(" "+srv2.toLowerCase()+":")!==-1||e.toLowerCase().indexOf("/"+srv2.toLowerCase())!==-1})}const pids=[];for(const p of ps){const pid=p.trim().split(" ")[2];if(pid){pids.push(parseInt(pid,10))}}result2.push({name:srv2,running:ps.length>0,startmode:"",pids,cpu:parseFloat(ps.reduce(function(pv,cv){return pv+parseFloat(cv.trim().split(" ")[0])},0).toFixed(2)),mem:parseFloat(ps.reduce(function(pv,cv){return pv+parseFloat(cv.trim().split(" ")[1])},0).toFixed(2))})});if(_linux){let cmd='cat /proc/stat | grep "cpu "';for(let i in result2){for(let j in result2[i].pids){cmd+=";cat /proc/"+result2[i].pids[j]+"/stat"}}exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout2){let curr_processes=stdout2.toString().split("\n");let all2=parseProcStat(curr_processes.shift());let list_new={};let resultProcess={};curr_processes.forEach(element=>{resultProcess=calcProcStatLinux(element,all2,_services_cpu);if(resultProcess.pid){let listPos=-1;for(let i in result2){for(let j in result2[i].pids){if(parseInt(result2[i].pids[j])===parseInt(resultProcess.pid)){listPos=i}}}if(listPos>=0){result2[listPos].cpu+=resultProcess.cpuu+resultProcess.cpus}list_new[resultProcess.pid]={cpuu:resultProcess.cpuu,cpus:resultProcess.cpus,utime:resultProcess.utime,stime:resultProcess.stime,cutime:resultProcess.cutime,cstime:resultProcess.cstime}}});_services_cpu.all=all2;_services_cpu.list=Object.assign({},list_new);_services_cpu.ms=Date.now()-_services_cpu.ms;_services_cpu.result=Object.assign({},result2);if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}}else{args2=["-o","comm"];util4.execSafe("ps",args2).then(stdout2=>{if(stdout2){let lines=stdout2.replace(/ +/g," ").replace(/,+/g,".").split("\n");srvs.forEach(function(srv2){let ps=lines.filter(function(e){return e.indexOf(srv2)!==-1});result2.push({name:srv2,running:ps.length>0,startmode:"",cpu:0,mem:0})});if(callback){callback(result2)}resolve(result2)}else{srvs.forEach(function(srv2){result2.push({name:srv2,running:false,startmode:"",cpu:0,mem:0})});if(callback){callback(result2)}resolve(result2)}})}})}else{if(callback){callback(result2)}resolve(result2)}}if(_windows){try{let wincommand="Get-CimInstance Win32_Service";if(srvs[0]!=="*"){wincommand+=' -Filter "';srvs.forEach(srv2=>{wincommand+=`Name='${srv2}' or `});wincommand=`${wincommand.slice(0,-4)}"`}wincommand+=" | select Name,Caption,Started,StartMode,ProcessId | fl";util4.powerShell(wincommand).then((stdout,error)=>{if(!error){let serviceSections=stdout.split(/\n\s*\n/);serviceSections.forEach(element=>{if(element.trim()!==""){let lines=element.trim().split("\r\n");let srvName=util4.getValue(lines,"Name",":",true).toLowerCase();let srvCaption=util4.getValue(lines,"Caption",":",true).toLowerCase();let started=util4.getValue(lines,"Started",":",true);let startMode=util4.getValue(lines,"StartMode",":",true);let pid=util4.getValue(lines,"ProcessId",":",true);if(srvString==="*"||srvs.indexOf(srvName)>=0||srvs.indexOf(srvCaption)>=0){result2.push({name:srvName,running:started.toLowerCase()==="true",startmode:startMode,pids:[pid],cpu:0,mem:0});dataSrv.push(srvName);dataSrv.push(srvCaption)}}});if(srvString!=="*"){let srvsMissing=srvs.filter(function(e){return dataSrv.indexOf(e)===-1});srvsMissing.forEach(function(srvName){result2.push({name:srvName,running:false,startmode:"",pids:[],cpu:0,mem:0})})}if(callback){callback(result2)}resolve(result2)}else{srvs.forEach(function(srvName){result2.push({name:srvName,running:false,startmode:"",cpu:0,mem:0})});if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}}else{if(callback){callback([])}resolve([])}})})}exports2.services=services;function parseProcStat(line){let parts=line.replace(/ +/g," ").split(" ");let user=parts.length>=2?parseInt(parts[1]):0;let nice=parts.length>=3?parseInt(parts[2]):0;let system=parts.length>=4?parseInt(parts[3]):0;let idle=parts.length>=5?parseInt(parts[4]):0;let iowait=parts.length>=6?parseInt(parts[5]):0;let irq=parts.length>=7?parseInt(parts[6]):0;let softirq=parts.length>=8?parseInt(parts[7]):0;let steal=parts.length>=9?parseInt(parts[8]):0;let guest=parts.length>=10?parseInt(parts[9]):0;let guest_nice=parts.length>=11?parseInt(parts[10]):0;return user+nice+system+idle+iowait+irq+softirq+steal+guest+guest_nice}function calcProcStatLinux(line,all2,_cpu_old){let statparts=line.replace(/ +/g," ").split(")");if(statparts.length>=2){let parts=statparts[1].split(" ");if(parts.length>=16){let pid=parseInt(statparts[0].split(" ")[0]);let utime=parseInt(parts[12]);let stime=parseInt(parts[13]);let cutime=parseInt(parts[14]);let cstime=parseInt(parts[15]);let cpuu=0;let cpus2=0;if(_cpu_old.all>0&&_cpu_old.list[pid]){cpuu=(utime+cutime-_cpu_old.list[pid].utime-_cpu_old.list[pid].cutime)/(all2-_cpu_old.all)*100;cpus2=(stime+cstime-_cpu_old.list[pid].stime-_cpu_old.list[pid].cstime)/(all2-_cpu_old.all)*100}else{cpuu=(utime+cutime)/all2*100;cpus2=(stime+cstime)/all2*100}return{pid,utime,stime,cutime,cstime,cpuu,cpus:cpus2}}else{return{pid:0,utime:0,stime:0,cutime:0,cstime:0,cpuu:0,cpus:0}}}else{return{pid:0,utime:0,stime:0,cutime:0,cstime:0,cpuu:0,cpus:0}}}function calcProcStatWin(procStat,all2,_cpu_old){let cpuu=0;let cpus2=0;if(_cpu_old.all>0&&_cpu_old.list[procStat.pid]){cpuu=(procStat.utime-_cpu_old.list[procStat.pid].utime)/(all2-_cpu_old.all)*100;cpus2=(procStat.stime-_cpu_old.list[procStat.pid].stime)/(all2-_cpu_old.all)*100}else{cpuu=procStat.utime/all2*100;cpus2=procStat.stime/all2*100}return{pid:procStat.pid,utime:procStat.utime,stime:procStat.stime,cpuu:cpuu>0?cpuu:0,cpus:cpus2>0?cpus2:0}}function processes(callback){let parsedhead=[];function getName(command){command=command||"";let result2=command.split(" ")[0];if(result2.substr(-1)===":"){result2=result2.substr(0,result2.length-1)}if(result2.substr(0,1)!=="["){let parts=result2.split("/");if(isNaN(parseInt(parts[parts.length-1]))){result2=parts[parts.length-1]}else{result2=parts[0]}}return result2}function parseLine(line){let offset=0;let offset2=0;function checkColumn(i){offset=offset2;if(parsedhead[i]){offset2=line.substring(parsedhead[i].to+offset,1e4).indexOf(" ")}else{offset2=1e4}}checkColumn(0);const pid=parseInt(line.substring(parsedhead[0].from+offset,parsedhead[0].to+offset2));checkColumn(1);const ppid=parseInt(line.substring(parsedhead[1].from+offset,parsedhead[1].to+offset2));checkColumn(2);const cpu=parseFloat(line.substring(parsedhead[2].from+offset,parsedhead[2].to+offset2).replace(/,/g,"."));checkColumn(3);const mem=parseFloat(line.substring(parsedhead[3].from+offset,parsedhead[3].to+offset2).replace(/,/g,"."));checkColumn(4);const priority=parseInt(line.substring(parsedhead[4].from+offset,parsedhead[4].to+offset2));checkColumn(5);const vsz=parseInt(line.substring(parsedhead[5].from+offset,parsedhead[5].to+offset2));checkColumn(6);const rss=parseInt(line.substring(parsedhead[6].from+offset,parsedhead[6].to+offset2));checkColumn(7);const nice=parseInt(line.substring(parsedhead[7].from+offset,parsedhead[7].to+offset2))||0;checkColumn(8);const started=!_sunos?parseElapsedTime(line.substring(parsedhead[8].from+offset,parsedhead[8].to+offset2).trim()):parseTimeUnix(line.substring(parsedhead[8].from+offset,parsedhead[8].to+offset2).trim());checkColumn(9);let state=line.substring(parsedhead[9].from+offset,parsedhead[9].to+offset2).trim();state=state[0]==="R"?"running":state[0]==="S"?"sleeping":state[0]==="T"?"stopped":state[0]==="W"?"paging":state[0]==="X"?"dead":state[0]==="Z"?"zombie":state[0]==="D"||state[0]==="U"?"blocked":"unknown";checkColumn(10);let tty2=line.substring(parsedhead[10].from+offset,parsedhead[10].to+offset2).trim();if(tty2==="?"||tty2==="??"){tty2=""}checkColumn(11);const user=line.substring(parsedhead[11].from+offset,parsedhead[11].to+offset2).trim();checkColumn(12);let cmdPath="";let command="";let params="";let fullcommand=line.substring(parsedhead[12].from+offset,parsedhead[12].to+offset2).trim();if(fullcommand.substr(fullcommand.length-1)==="]"){fullcommand=fullcommand.slice(0,-1)}if(fullcommand.substr(0,1)==="["){command=fullcommand.substring(1)}else{const p1=fullcommand.indexOf("(");const p2=fullcommand.indexOf(")");const p3=fullcommand.indexOf("/");const p4=fullcommand.indexOf(":");if(p1<p2&&p1<p3&&p3<p2){command=fullcommand.split(" ")[0];command=command.replace(/:/g,"")}else{if(p4>0&&(p3===-1||p3>3)){command=fullcommand.split(" ")[0];command=command.replace(/:/g,"")}else{let firstParamPos=fullcommand.indexOf(" -");let firstParamPathPos=fullcommand.indexOf(" /");firstParamPos=firstParamPos>=0?firstParamPos:1e4;firstParamPathPos=firstParamPathPos>=0?firstParamPathPos:1e4;const firstPos=Math.min(firstParamPos,firstParamPathPos);let tmpCommand=fullcommand.substr(0,firstPos);const tmpParams=fullcommand.substr(firstPos);const lastSlashPos=tmpCommand.lastIndexOf("/");if(lastSlashPos>=0){cmdPath=tmpCommand.substr(0,lastSlashPos);tmpCommand=tmpCommand.substr(lastSlashPos+1)}if(firstPos===1e4&&tmpCommand.indexOf(" ")>-1){const parts=tmpCommand.split(" ");if(fs14.existsSync(path27.join(cmdPath,parts[0]))){command=parts.shift();params=(parts.join(" ")+" "+tmpParams).trim()}else{command=tmpCommand.trim();params=tmpParams.trim()}}else{command=tmpCommand.trim();params=tmpParams.trim()}}}}return{pid,parentPid:ppid,name:_linux?getName(command):command,cpu,cpuu:0,cpus:0,mem,priority,memVsz:vsz,memRss:rss,nice,started,state,tty:tty2,user,command,params,path:cmdPath}}function parseProcesses(lines){let result2=[];if(lines.length>1){let head2=lines[0];parsedhead=util4.parseHead(head2,8);lines.shift();lines.forEach(function(line){if(line.trim()!==""){result2.push(parseLine(line))}})}return result2}function parseProcesses2(lines){function formatDateTime(time){const month=("0"+(time.getMonth()+1).toString()).slice(-2);const year=time.getFullYear().toString();const day=("0"+time.getDate().toString()).slice(-2);const hours=("0"+time.getHours().toString()).slice(-2);const mins=("0"+time.getMinutes().toString()).slice(-2);const secs=("0"+time.getSeconds().toString()).slice(-2);return year+"-"+month+"-"+day+" "+hours+":"+mins+":"+secs}function parseElapsed(etime){let started="";if(etime.indexOf("d")>=0){const elapsed_parts=etime.split("d");started=formatDateTime(new Date(Date.now()-(elapsed_parts[0]*24+elapsed_parts[1]*1)*60*60*1e3))}else if(etime.indexOf("h")>=0){const elapsed_parts=etime.split("h");started=formatDateTime(new Date(Date.now()-(elapsed_parts[0]*60+elapsed_parts[1]*1)*60*1e3))}else if(etime.indexOf(":")>=0){const elapsed_parts=etime.split(":");started=formatDateTime(new Date(Date.now()-(elapsed_parts.length>1?(elapsed_parts[0]*60+elapsed_parts[1])*1e3:elapsed_parts[0]*1e3)))}return started}let result2=[];lines.forEach(function(line){if(line.trim()!==""){line=line.trim().replace(/ +/g," ").replace(/,+/g,".");const parts=line.split(" ");const command=parts.slice(9).join(" ");const pmem=parseFloat((1*parseInt(parts[3])*1024/os7.totalmem()).toFixed(1));const started=parseElapsed(parts[5]);result2.push({pid:parseInt(parts[0]),parentPid:parseInt(parts[1]),name:getName(command),cpu:0,cpuu:0,cpus:0,mem:pmem,priority:0,memVsz:parseInt(parts[2]),memRss:parseInt(parts[3]),nice:parseInt(parts[4]),started,state:parts[6]==="R"?"running":parts[6]==="S"?"sleeping":parts[6]==="T"?"stopped":parts[6]==="W"?"paging":parts[6]==="X"?"dead":parts[6]==="Z"?"zombie":parts[6]==="D"||parts[6]==="U"?"blocked":"unknown",tty:parts[7],user:parts[8],command})}});return result2}return new Promise(resolve=>{process.nextTick(()=>{let result2={all:0,running:0,blocked:0,sleeping:0,unknown:0,list:[]};let cmd="";if(_processes_cpu.ms&&Date.now()-_processes_cpu.ms>=500||_processes_cpu.ms===0){if(_linux||_freebsd||_openbsd||_netbsd||_darwin||_sunos){if(_linux){cmd="export LC_ALL=C; ps -axo pid:11,ppid:11,pcpu:6,pmem:6,pri:5,vsz:11,rss:11,ni:5,etime:30,state:5,tty:15,user:20,command; unset LC_ALL"}if(_freebsd||_openbsd||_netbsd){cmd="export LC_ALL=C; ps -axo pid,ppid,pcpu,pmem,pri,vsz,rss,ni,etime,state,tty,user,command; unset LC_ALL"}if(_darwin){cmd="ps -axo pid,ppid,pcpu,pmem,pri,vsz=temp_title_1,rss=temp_title_2,nice,etime=temp_title_3,state,tty,user,command -r"}if(_sunos){cmd="ps -Ao pid,ppid,pcpu,pmem,pri,vsz,rss,nice,stime,s,tty,user,comm"}exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout){if(!error&&stdout.toString().trim()){result2.list=parseProcesses(stdout.toString().split("\n")).slice();result2.all=result2.list.length;result2.running=result2.list.filter(function(e){return e.state==="running"}).length;result2.blocked=result2.list.filter(function(e){return e.state==="blocked"}).length;result2.sleeping=result2.list.filter(function(e){return e.state==="sleeping"}).length;if(_linux){cmd='cat /proc/stat | grep "cpu "';result2.list.forEach(element=>{cmd+=";cat /proc/"+element.pid+"/stat"});exec3(cmd,{maxBuffer:1024*2e4},function(error2,stdout2){let curr_processes=stdout2.toString().split("\n");let all2=parseProcStat(curr_processes.shift());let list_new={};let resultProcess={};curr_processes.forEach(element=>{resultProcess=calcProcStatLinux(element,all2,_processes_cpu);if(resultProcess.pid){let listPos=result2.list.map(function(e){return e.pid}).indexOf(resultProcess.pid);if(listPos>=0){result2.list[listPos].cpu=resultProcess.cpuu+resultProcess.cpus;result2.list[listPos].cpuu=resultProcess.cpuu;result2.list[listPos].cpus=resultProcess.cpus}list_new[resultProcess.pid]={cpuu:resultProcess.cpuu,cpus:resultProcess.cpus,utime:resultProcess.utime,stime:resultProcess.stime,cutime:resultProcess.cutime,cstime:resultProcess.cstime}}});_processes_cpu.all=all2;_processes_cpu.list=Object.assign({},list_new);_processes_cpu.ms=Date.now()-_processes_cpu.ms;_processes_cpu.result=Object.assign({},result2);if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}}else{cmd="ps -o pid,ppid,vsz,rss,nice,etime,stat,tty,user,comm";if(_sunos){cmd="ps -o pid,ppid,vsz,rss,nice,etime,s,tty,user,comm"}exec3(cmd,{maxBuffer:1024*2e4},function(error2,stdout2){if(!error2){let lines=stdout2.toString().split("\n");lines.shift();result2.list=parseProcesses2(lines).slice();result2.all=result2.list.length;result2.running=result2.list.filter(function(e){return e.state==="running"}).length;result2.blocked=result2.list.filter(function(e){return e.state==="blocked"}).length;result2.sleeping=result2.list.filter(function(e){return e.state==="sleeping"}).length;if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}})}})}else if(_windows){try{util4.powerShell('Get-CimInstance Win32_Process | select-Object ProcessId,ParentProcessId,ExecutionState,Caption,CommandLine,ExecutablePath,UserModeTime,KernelModeTime,WorkingSetSize,Priority,PageFileUsage, @{n="CreationDate";e={$_.CreationDate.ToString("yyyy-MM-dd HH:mm:ss")}} | fl').then((stdout,error)=>{if(!error){let processSections=stdout.split(/\n\s*\n/);let procs=[];let procStats=[];let list_new={};let allcpuu=0;let allcpus=0;processSections.forEach(element=>{if(element.trim()!==""){let lines=element.trim().split("\r\n");let pid=parseInt(util4.getValue(lines,"ProcessId",":",true),10);let parentPid=parseInt(util4.getValue(lines,"ParentProcessId",":",true),10);let statusValue=util4.getValue(lines,"ExecutionState",":");let name=util4.getValue(lines,"Caption",":",true);let commandLine=util4.getValue(lines,"CommandLine",":",true);let additionalCommand=false;lines.forEach(line=>{if(additionalCommand&&line.toLowerCase().startsWith(" ")){commandLine+=" "+line.trim()}else{additionalCommand=false}if(line.toLowerCase().startsWith("commandline")){additionalCommand=true}});let commandPath=util4.getValue(lines,"ExecutablePath",":",true);let utime=parseInt(util4.getValue(lines,"UserModeTime",":",true),10);let stime=parseInt(util4.getValue(lines,"KernelModeTime",":",true),10);let memw=parseInt(util4.getValue(lines,"WorkingSetSize",":",true),10);allcpuu=allcpuu+utime;allcpus=allcpus+stime;result2.all++;if(!statusValue){result2.unknown++}if(statusValue==="3"){result2.running++}if(statusValue==="4"||statusValue==="5"){result2.blocked++}procStats.push({pid,utime,stime,cpu:0,cpuu:0,cpus:0});procs.push({pid,parentPid,name,cpu:0,cpuu:0,cpus:0,mem:memw/os7.totalmem()*100,priority:parseInt(util4.getValue(lines,"Priority",":",true),10),memVsz:parseInt(util4.getValue(lines,"PageFileUsage",":",true),10),memRss:Math.floor(parseInt(util4.getValue(lines,"WorkingSetSize",":",true),10)/1024),nice:0,started:util4.getValue(lines,"CreationDate",":",true),state:!statusValue?_winStatusValues[0]:_winStatusValues[statusValue],tty:"",user:"",command:commandLine||name,path:commandPath,params:""})}});result2.sleeping=result2.all-result2.running-result2.blocked-result2.unknown;result2.list=procs;procStats.forEach(element=>{let resultProcess=calcProcStatWin(element,allcpuu+allcpus,_processes_cpu);let listPos=result2.list.map(function(e){return e.pid}).indexOf(resultProcess.pid);if(listPos>=0){result2.list[listPos].cpu=resultProcess.cpuu+resultProcess.cpus;result2.list[listPos].cpuu=resultProcess.cpuu;result2.list[listPos].cpus=resultProcess.cpus}list_new[resultProcess.pid]={cpuu:resultProcess.cpuu,cpus:resultProcess.cpus,utime:resultProcess.utime,stime:resultProcess.stime}});_processes_cpu.all=allcpuu+allcpus;_processes_cpu.all_utime=allcpuu;_processes_cpu.all_stime=allcpus;_processes_cpu.list=Object.assign({},list_new);_processes_cpu.ms=Date.now()-_processes_cpu.ms;_processes_cpu.result=Object.assign({},result2)}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(_processes_cpu.result)}resolve(_processes_cpu.result)}})})}exports2.processes=processes;function processLoad(proc,callback){if(util4.isFunction(proc)&&!callback){callback=proc;proc=""}return new Promise(resolve=>{process.nextTick(()=>{proc=proc||"";if(typeof proc!=="string"){if(callback){callback([])}return resolve([])}let processesString="";try{processesString.__proto__.toLowerCase=util4.stringToLower;processesString.__proto__.replace=util4.stringReplace;processesString.__proto__.toString=util4.stringToString;processesString.__proto__.substr=util4.stringSubstr;processesString.__proto__.substring=util4.stringSubstring;processesString.__proto__.trim=util4.stringTrim;processesString.__proto__.startsWith=util4.stringStartWith}catch(e){Object.setPrototypeOf(processesString,util4.stringObj)}const s=util4.sanitizeShellString(proc);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){processesString=processesString+s[i]}}processesString=processesString.trim().toLowerCase().replace(/, /g,"|").replace(/,+/g,"|");if(processesString===""){processesString="*"}if(util4.isPrototypePolluted()&&processesString!=="*"){processesString="------"}let processes2=processesString.split("|");let result2=[];const procSanitized=util4.isPrototypePolluted()?"":util4.sanitizeShellString(proc)||"*";if(procSanitized&&processes2.length&&processes2[0]!=="------"){if(_windows){try{util4.powerShell("Get-CimInstance Win32_Process | select ProcessId,Caption,UserModeTime,KernelModeTime,WorkingSetSize | fl").then((stdout,error)=>{if(!error){let processSections=stdout.split(/\n\s*\n/);let procStats=[];let list_new={};let allcpuu=0;let allcpus=0;processSections.forEach(element=>{if(element.trim()!==""){let lines=element.trim().split("\r\n");let pid=parseInt(util4.getValue(lines,"ProcessId",":",true),10);let name=util4.getValue(lines,"Caption",":",true);let utime=parseInt(util4.getValue(lines,"UserModeTime",":",true),10);let stime=parseInt(util4.getValue(lines,"KernelModeTime",":",true),10);let mem=parseInt(util4.getValue(lines,"WorkingSetSize",":",true),10);allcpuu=allcpuu+utime;allcpus=allcpus+stime;procStats.push({pid,name,utime,stime,cpu:0,cpuu:0,cpus:0,mem});let pname="";let inList=false;processes2.forEach(function(proc2){if(name.toLowerCase().indexOf(proc2.toLowerCase())>=0&&!inList){inList=true;pname=proc2}});if(processesString==="*"||inList){let processFound=false;result2.forEach(function(item){if(item.proc.toLowerCase()===pname.toLowerCase()){item.pids.push(pid);item.mem+=mem/os7.totalmem()*100;processFound=true}});if(!processFound){result2.push({proc:pname,pid,pids:[pid],cpu:0,mem:mem/os7.totalmem()*100})}}}});if(processesString!=="*"){let processesMissing=processes2.filter(function(name){return procStats.filter(function(item){return item.name.toLowerCase().indexOf(name)>=0}).length===0});processesMissing.forEach(function(procName){result2.push({proc:procName,pid:null,pids:[],cpu:0,mem:0})})}procStats.forEach(element=>{let resultProcess=calcProcStatWin(element,allcpuu+allcpus,_process_cpu);let listPos=-1;for(let j=0;j<result2.length;j++){if(result2[j].pid===resultProcess.pid||result2[j].pids.indexOf(resultProcess.pid)>=0){listPos=j}}if(listPos>=0){result2[listPos].cpu+=resultProcess.cpuu+resultProcess.cpus}list_new[resultProcess.pid]={cpuu:resultProcess.cpuu,cpus:resultProcess.cpus,utime:resultProcess.utime,stime:resultProcess.stime}});_process_cpu.all=allcpuu+allcpus;_process_cpu.all_utime=allcpuu;_process_cpu.all_stime=allcpus;_process_cpu.list=Object.assign({},list_new);_process_cpu.ms=Date.now()-_process_cpu.ms;_process_cpu.result=JSON.parse(JSON.stringify(result2));if(callback){callback(result2)}resolve(result2)}})}catch(e){if(callback){callback(result2)}resolve(result2)}}if(_darwin||_linux||_freebsd||_openbsd||_netbsd){const params=["-axo","pid,ppid,pcpu,pmem,comm"];util4.execSafe("ps",params).then(stdout=>{if(stdout){let procStats=[];let lines=stdout.toString().split("\n").filter(function(line){if(processesString==="*"){return true}if(line.toLowerCase().indexOf("grep")!==-1){return false}let found=false;processes2.forEach(function(item){found=found||line.toLowerCase().indexOf(item.toLowerCase())>=0});return found});lines.shift();lines.forEach(function(line){let data=line.trim().replace(/ +/g," ").split(" ");if(data.length>4){const linuxName=data[4].indexOf("/")>=0?data[4].substring(0,data[4].indexOf("/")):data[4];const name=_linux?linuxName:data[4].substring(data[4].lastIndexOf("/")+1);procStats.push({name,pid:parseInt(data[0])||0,ppid:parseInt(data[1])||0,cpu:parseFloat(data[2].replace(",",".")),mem:parseFloat(data[3].replace(",","."))})}});procStats.forEach(function(item){let listPos=-1;let inList=false;let name=item.name;for(let j=0;j<result2.length;j++){if(item.name.toLowerCase().indexOf(result2[j].proc.toLowerCase())>=0){listPos=j}}processes2.forEach(function(proc2){if(item.name.toLowerCase().indexOf(proc2.toLowerCase())>=0&&!inList){inList=true;name=proc2}});if(processesString==="*"||inList){if(listPos<0){if(name){result2.push({proc:name,pid:item.pid,pids:[item.pid],cpu:item.cpu,mem:item.mem})}}else{if(item.ppid<10){result2[listPos].pid=item.pid}result2[listPos].pids.push(item.pid);result2[listPos].cpu+=item.cpu;result2[listPos].mem+=item.mem}}});if(processesString!=="*"){let processesMissing=processes2.filter(function(name){return procStats.filter(function(item){return item.name.toLowerCase().indexOf(name)>=0}).length===0});processesMissing.forEach(function(procName){result2.push({proc:procName,pid:null,pids:[],cpu:0,mem:0})})}if(_linux){result2.forEach(function(item){item.cpu=0});let cmd='cat /proc/stat | grep "cpu "';for(let i in result2){for(let j in result2[i].pids){cmd+=";cat /proc/"+result2[i].pids[j]+"/stat"}}exec3(cmd,{maxBuffer:1024*2e4},function(error,stdout2){let curr_processes=stdout2.toString().split("\n");let all2=parseProcStat(curr_processes.shift());let list_new={};let resultProcess={};curr_processes.forEach(element=>{resultProcess=calcProcStatLinux(element,all2,_process_cpu);if(resultProcess.pid){let resultItemId=-1;for(let i in result2){if(result2[i].pids.indexOf(resultProcess.pid)>=0){resultItemId=i}}if(resultItemId>=0){result2[resultItemId].cpu+=resultProcess.cpuu+resultProcess.cpus}list_new[resultProcess.pid]={cpuu:resultProcess.cpuu,cpus:resultProcess.cpus,utime:resultProcess.utime,stime:resultProcess.stime,cutime:resultProcess.cutime,cstime:resultProcess.cstime}}});result2.forEach(function(item){item.cpu=Math.round(item.cpu*100)/100});_process_cpu.all=all2;_process_cpu.list=Object.assign({},list_new);_process_cpu.ms=Date.now()-_process_cpu.ms;_process_cpu.result=Object.assign({},result2);if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}})}}})})}exports2.processLoad=processLoad}});var require_users=__commonJS({"node_modules/systeminformation/lib/users.js"(exports2){"use strict";var exec3=require("child_process").exec;var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function parseUsersLinux(lines,phase){let result2=[];let result_who=[];let result_w={};let w_first=true;let w_header=[];let w_pos=[];let who_line={};let is_whopart=true;lines.forEach(function(line){if(line==="---"){is_whopart=false}else{let l=line.replace(/ +/g," ").split(" ");if(is_whopart){result_who.push({user:l[0],tty:l[1],date:l[2],time:l[3],ip:l&&l.length>4?l[4].replace(/\(/g,"").replace(/\)/g,""):""})}else{if(w_first){w_header=l;w_header.forEach(function(item){w_pos.push(line.indexOf(item))});w_first=false}else{result_w.user=line.substring(w_pos[0],w_pos[1]-1).trim();result_w.tty=line.substring(w_pos[1],w_pos[2]-1).trim();result_w.ip=line.substring(w_pos[2],w_pos[3]-1).replace(/\(/g,"").replace(/\)/g,"").trim();result_w.command=line.substring(w_pos[7],1e3).trim();who_line=result_who.filter(function(obj){return obj.user.substring(0,8).trim()===result_w.user&&obj.tty===result_w.tty});if(who_line.length===1){result2.push({user:who_line[0].user,tty:who_line[0].tty,date:who_line[0].date,time:who_line[0].time,ip:who_line[0].ip,command:result_w.command})}}}}});if(result2.length===0&&phase===2){return result_who}else{return result2}}function parseUsersDarwin(lines){let result2=[];let result_who=[];let result_w={};let who_line={};let is_whopart=true;lines.forEach(function(line){if(line==="---"){is_whopart=false}else{let l=line.replace(/ +/g," ").split(" ");if(is_whopart){let dt=""+new Date().getFullYear()+"-"+("0"+("JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC".indexOf(l[2].toUpperCase())/3+1)).slice(-2)+"-"+("0"+l[3]).slice(-2);try{if(new Date(dt)>new Date){dt=""+(new Date().getFullYear()-1)+"-"+("0"+("JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC".indexOf(l[2].toUpperCase())/3+1)).slice(-2)+"-"+("0"+l[3]).slice(-2)}}catch{util4.noop()}result_who.push({user:l[0],tty:l[1],date:dt,time:l[4]})}else{result_w.user=l[0];result_w.tty=l[1];result_w.ip=l[2]!=="-"?l[2]:"";result_w.command=l.slice(5,1e3).join(" ");who_line=result_who.filter(function(obj){return obj.user.substring(0,10)===result_w.user.substring(0,10)&&(obj.tty.substring(3,1e3)===result_w.tty||obj.tty===result_w.tty)});if(who_line.length===1){result2.push({user:who_line[0].user,tty:who_line[0].tty,date:who_line[0].date,time:who_line[0].time,ip:result_w.ip,command:result_w.command})}}}});return result2}function users(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux){exec3('export LC_ALL=C; who --ips; echo "---"; w; unset LC_ALL | tail -n +2',function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2=parseUsersLinux(lines,1);if(result2.length===0){exec3('who; echo "---"; w | tail -n +2',function(error2,stdout2){if(!error2){lines=stdout2.toString().split("\n");result2=parseUsersLinux(lines,2)}if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}})}if(_freebsd||_openbsd||_netbsd){exec3('who; echo "---"; w -ih',function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2=parseUsersDarwin(lines)}if(callback){callback(result2)}resolve(result2)})}if(_sunos){exec3('who; echo "---"; w -h',function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2=parseUsersDarwin(lines)}if(callback){callback(result2)}resolve(result2)})}if(_darwin){exec3('export LC_ALL=C; who; echo "---"; w -ih; unset LC_ALL',function(error,stdout){if(!error){let lines=stdout.toString().split("\n");result2=parseUsersDarwin(lines)}if(callback){callback(result2)}resolve(result2)})}if(_windows){try{let cmd=`Get-CimInstance Win32_LogonSession | select LogonId,@{n="StartTime";e={$_.StartTime.ToString("yyyy-MM-dd HH:mm:ss")}} | fl; echo '#-#-#-#';`;cmd+="Get-CimInstance Win32_LoggedOnUser | select antecedent,dependent | fl ; echo '#-#-#-#';";cmd+=`$process = (Get-CimInstance Win32_Process -Filter "name = 'explorer.exe'"); Invoke-CimMethod -InputObject $process[0] -MethodName GetOwner | select user, domain | fl; get-process -name explorer | select-object sessionid | fl; echo '#-#-#-#';`;cmd+="query user";util4.powerShell(cmd).then(data=>{if(data){data=data.split("#-#-#-#");let sessions=parseWinSessions((data[0]||"").split(/\n\s*\n/));let loggedons=parseWinLoggedOn((data[1]||"").split(/\n\s*\n/));let queryUser=parseWinUsersQuery((data[3]||"").split("\r\n"));let users2=parseWinUsers((data[2]||"").split(/\n\s*\n/),queryUser);for(let id in loggedons){if({}.hasOwnProperty.call(loggedons,id)){loggedons[id].dateTime={}.hasOwnProperty.call(sessions,id)?sessions[id]:""}}users2.forEach(user=>{let dateTime="";for(let id in loggedons){if({}.hasOwnProperty.call(loggedons,id)){if(loggedons[id].user===user.user&&(!dateTime||dateTime<loggedons[id].dateTime)){dateTime=loggedons[id].dateTime}}}result2.push({user:user.user,tty:user.tty,date:`${dateTime.substring(0,10)}`,time:`${dateTime.substring(11,19)}`,ip:"",command:""})})}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}function parseWinSessions(sessionParts){const sessions={};sessionParts.forEach(session=>{const lines=session.split("\r\n");const id=util4.getValue(lines,"LogonId");const starttime=util4.getValue(lines,"starttime");if(id){sessions[id]=starttime}});return sessions}function fuzzyMatch(name1,name2){name1=name1.toLowerCase();name2=name2.toLowerCase();let eq2=0;let len=name1.length;if(name2.length>len){len=name2.length}for(let i=0;i<len;i++){const c1=name1[i]||"";const c2=name2[i]||"";if(c1===c2){eq2++}}return len>10?eq2/len>.9:len>0?eq2/len>.8:false}function parseWinUsers(userParts,userQuery){const users2=[];userParts.forEach(user=>{const lines=user.split("\r\n");const domain=util4.getValue(lines,"domain",":",true);const username=util4.getValue(lines,"user",":",true);const sessionid=util4.getValue(lines,"sessionid",":",true);if(username){const quser=userQuery.filter(item=>fuzzyMatch(item.user,username));users2.push({domain,user:username,tty:quser&&quser[0]&&quser[0].tty?quser[0].tty:sessionid})}});return users2}function parseWinLoggedOn(loggedonParts){const loggedons={};loggedonParts.forEach(loggedon=>{const lines=loggedon.split("\r\n");const antecendent=util4.getValue(lines,"antecedent",":",true);let parts=antecendent.split("=");const name=parts.length>2?parts[1].split(",")[0].replace(/"/g,"").trim():"";const domain=parts.length>2?parts[2].replace(/"/g,"").replace(/\)/g,"").trim():"";const dependent=util4.getValue(lines,"dependent",":",true);parts=dependent.split("=");const id=parts.length>1?parts[1].replace(/"/g,"").replace(/\)/g,"").trim():"";if(id){loggedons[id]={domain,user:name}}});return loggedons}function parseWinUsersQuery(lines){lines=lines.filter(item=>item);let result2=[];const header2=lines[0];const headerDelimiter=[];if(header2){const start=header2[0]===" "?1:0;headerDelimiter.push(start-1);let nextSpace=0;for(let i=start+1;i<header2.length;i++){if(header2[i]===" "&&(header2[i-1]===" "||header2[i-1]===".")){nextSpace=i}else{if(nextSpace){headerDelimiter.push(nextSpace);nextSpace=0}}}for(let i=1;i<lines.length;i++){if(lines[i].trim()){const user=lines[i].substring(headerDelimiter[0]+1,headerDelimiter[1]).trim()||"";const tty2=lines[i].substring(headerDelimiter[1]+1,headerDelimiter[2]-2).trim()||"";result2.push({user,tty:tty2})}}}return result2}exports2.users=users}});var require_internet=__commonJS({"node_modules/systeminformation/lib/internet.js"(exports2){"use strict";var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function inetChecksite(url,callback){return new Promise(resolve=>{process.nextTick(()=>{let result2={url,ok:false,status:404,ms:null};if(typeof url!=="string"){if(callback){callback(result2)}return resolve(result2)}let urlSanitized="";const s=util4.sanitizeShellString(url,true);const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){try{s[i].__proto__.toLowerCase=util4.stringToLower}catch(e){Object.setPrototypeOf(s[i],util4.stringObj)}const sl=s[i].toLowerCase();if(sl&&sl[0]&&!sl[1]&&sl[0].length===1){urlSanitized=urlSanitized+sl[0]}}}result2.url=urlSanitized;try{if(urlSanitized&&!util4.isPrototypePolluted()){try{urlSanitized.__proto__.startsWith=util4.stringStartWith}catch(e){Object.setPrototypeOf(urlSanitized,util4.stringObj)}if(urlSanitized.startsWith("file:")||urlSanitized.startsWith("gopher:")||urlSanitized.startsWith("telnet:")||urlSanitized.startsWith("mailto:")||urlSanitized.startsWith("news:")||urlSanitized.startsWith("nntp:")){if(callback){callback(result2)}return resolve(result2)}util4.checkWebsite(urlSanitized).then(res=>{result2.status=res.statusCode;result2.ok=res.statusCode>=200&&res.statusCode<=399;;result2.ms=result2.ok?res.time:null;if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}}catch(err){if(callback){callback(result2)}resolve(result2)}})})}exports2.inetChecksite=inetChecksite;function inetLatency(host,callback){if(util4.isFunction(host)&&!callback){callback=host;host=""}host=host||"8.8.8.8";return new Promise(resolve=>{process.nextTick(()=>{if(typeof host!=="string"){if(callback){callback(null)}return resolve(null)}let hostSanitized="";const s=(util4.isPrototypePolluted()?"8.8.8.8":util4.sanitizeShellString(host,true)).trim();const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(!(s[i]===void 0)){try{s[i].__proto__.toLowerCase=util4.stringToLower}catch(e){Object.setPrototypeOf(s[i],util4.stringObj)}const sl=s[i].toLowerCase();if(sl&&sl[0]&&!sl[1]){hostSanitized=hostSanitized+sl[0]}}}try{hostSanitized.__proto__.startsWith=util4.stringStartWith}catch(e){Object.setPrototypeOf(hostSanitized,util4.stringObj)}if(hostSanitized.startsWith("file:")||hostSanitized.startsWith("gopher:")||hostSanitized.startsWith("telnet:")||hostSanitized.startsWith("mailto:")||hostSanitized.startsWith("news:")||hostSanitized.startsWith("nntp:")){if(callback){callback(null)}return resolve(null)}let params;if(_linux||_freebsd||_openbsd||_netbsd||_darwin){if(_linux){params=["-c","2","-w","3",hostSanitized]}if(_freebsd||_openbsd||_netbsd){params=["-c","2","-t","3",hostSanitized]}if(_darwin){params=["-c2","-t3",hostSanitized]}util4.execSafe("ping",params).then(stdout=>{let result2=null;if(stdout){const lines=stdout.split("\n").filter(line2=>line2.indexOf("rtt")>=0||line2.indexOf("round-trip")>=0||line2.indexOf("avg")>=0).join("\n");const line=lines.split("=");if(line.length>1){const parts=line[1].split("/");if(parts.length>1){result2=parseFloat(parts[1])}}}if(callback){callback(result2)}resolve(result2)})}if(_sunos){const params2=["-s","-a",hostSanitized,"56","2"];const filt="avg";util4.execSafe("ping",params2,{timeout:3e3}).then(stdout=>{let result2=null;if(stdout){const lines=stdout.split("\n").filter(line2=>line2.indexOf(filt)>=0).join("\n");const line=lines.split("=");if(line.length>1){const parts=line[1].split("/");if(parts.length>1){result2=parseFloat(parts[1].replace(",","."))}}}if(callback){callback(result2)}resolve(result2)})}if(_windows){let result2=null;try{const params2=[hostSanitized,"-n","1"];util4.execSafe("ping",params2,util4.execOptsWin).then(stdout=>{if(stdout){let lines=stdout.split("\r\n");lines.shift();lines.forEach(function(line){if((line.toLowerCase().match(/ms/g)||[]).length===3){let l2=line.replace(/ +/g," ").split(" ");if(l2.length>6){result2=parseFloat(l2[l2.length-1])}}})}if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}}})})}exports2.inetLatency=inetLatency}});var require_dockerSocket=__commonJS({"node_modules/systeminformation/lib/dockerSocket.js"(exports2,module2){"use strict";var net2=require("net");var isWin=require("os").type()==="Windows_NT";var socketPath=isWin?"//./pipe/docker_engine":"/var/run/docker.sock";var DockerSocket=class{getInfo(callback){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/info HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}listImages(all2,callback){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/images/json"+(all2?"?all=1":"")+" HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}inspectImage(id,callback){id=id||"";if(id){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/images/"+id+"/json?stream=0 HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}else{callback({})}}listContainers(all2,callback){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/containers/json"+(all2?"?all=1":"")+" HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}getStats(id,callback){id=id||"";if(id){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/containers/"+id+"/stats?stream=0 HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}else{callback({})}}getInspect(id,callback){id=id||"";if(id){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/containers/"+id+"/json?stream=0 HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}else{callback({})}}getProcesses(id,callback){id=id||"";if(id){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/containers/"+id+"/top?ps_args=-opid,ppid,pgid,vsz,time,etime,nice,ruser,user,rgroup,group,stat,rss,args HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}else{callback({})}}listVolumes(callback){try{let socket=net2.createConnection({path:socketPath});let alldata="";let data;socket.on("connect",()=>{socket.write("GET http:/volumes HTTP/1.0\r\n\r\n")});socket.on("data",data2=>{alldata=alldata+data2.toString()});socket.on("error",()=>{socket=false;callback({})});socket.on("end",()=>{let startbody=alldata.indexOf("\r\n\r\n");alldata=alldata.substring(startbody+4);socket=false;try{data=JSON.parse(alldata);callback(data)}catch(err){callback({})}})}catch(err){callback({})}}};module2.exports=DockerSocket}});var require_docker=__commonJS({"node_modules/systeminformation/lib/docker.js"(exports2){"use strict";var util4=require_util2();var DockerSocket=require_dockerSocket();var _platform=process.platform;var _windows=_platform==="win32";var _docker_container_stats={};var _docker_socket;var _docker_last_read=0;function dockerInfo(callback){return new Promise(resolve=>{process.nextTick(()=>{if(!_docker_socket){_docker_socket=new DockerSocket}const result2={};_docker_socket.getInfo(data=>{result2.id=data.ID;result2.containers=data.Containers;result2.containersRunning=data.ContainersRunning;result2.containersPaused=data.ContainersPaused;result2.containersStopped=data.ContainersStopped;result2.images=data.Images;result2.driver=data.Driver;result2.memoryLimit=data.MemoryLimit;result2.swapLimit=data.SwapLimit;result2.kernelMemory=data.KernelMemory;result2.cpuCfsPeriod=data.CpuCfsPeriod;result2.cpuCfsQuota=data.CpuCfsQuota;result2.cpuShares=data.CPUShares;result2.cpuSet=data.CPUSet;result2.ipv4Forwarding=data.IPv4Forwarding;result2.bridgeNfIptables=data.BridgeNfIptables;result2.bridgeNfIp6tables=data.BridgeNfIp6tables;result2.debug=data.Debug;result2.nfd=data.NFd;result2.oomKillDisable=data.OomKillDisable;result2.ngoroutines=data.NGoroutines;result2.systemTime=data.SystemTime;result2.loggingDriver=data.LoggingDriver;result2.cgroupDriver=data.CgroupDriver;result2.nEventsListener=data.NEventsListener;result2.kernelVersion=data.KernelVersion;result2.operatingSystem=data.OperatingSystem;result2.osType=data.OSType;result2.architecture=data.Architecture;result2.ncpu=data.NCPU;result2.memTotal=data.MemTotal;result2.dockerRootDir=data.DockerRootDir;result2.httpProxy=data.HttpProxy;result2.httpsProxy=data.HttpsProxy;result2.noProxy=data.NoProxy;result2.name=data.Name;result2.labels=data.Labels;result2.experimentalBuild=data.ExperimentalBuild;result2.serverVersion=data.ServerVersion;result2.clusterStore=data.ClusterStore;result2.clusterAdvertise=data.ClusterAdvertise;result2.defaultRuntime=data.DefaultRuntime;result2.liveRestoreEnabled=data.LiveRestoreEnabled;result2.isolation=data.Isolation;result2.initBinary=data.InitBinary;result2.productLicense=data.ProductLicense;if(callback){callback(result2)}resolve(result2)})})})}exports2.dockerInfo=dockerInfo;function dockerImages(all2,callback){if(util4.isFunction(all2)&&!callback){callback=all2;all2=false}if(typeof all2==="string"&&all2==="true"){all2=true}if(typeof all2!=="boolean"&&all2!==void 0){all2=false}all2=all2||false;let result2=[];return new Promise(resolve=>{process.nextTick(()=>{if(!_docker_socket){_docker_socket=new DockerSocket}const workload=[];_docker_socket.listImages(all2,data=>{let dockerImages2={};try{dockerImages2=data;if(dockerImages2&&Object.prototype.toString.call(dockerImages2)==="[object Array]"&&dockerImages2.length>0){dockerImages2.forEach(function(element){if(element.Names&&Object.prototype.toString.call(element.Names)==="[object Array]"&&element.Names.length>0){element.Name=element.Names[0].replace(/^\/|\/$/g,"")}workload.push(dockerImagesInspect(element.Id.trim(),element))});if(workload.length){Promise.all(workload).then(data2=>{if(callback){callback(data2)}resolve(data2)})}else{if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}}catch(err){if(callback){callback(result2)}resolve(result2)}})})})}function dockerImagesInspect(imageID,payload){return new Promise(resolve=>{process.nextTick(()=>{imageID=imageID||"";if(typeof imageID!=="string"){return resolve()}const imageIDSanitized=(util4.isPrototypePolluted()?"":util4.sanitizeShellString(imageID,true)).trim();if(imageIDSanitized){if(!_docker_socket){_docker_socket=new DockerSocket}_docker_socket.inspectImage(imageIDSanitized.trim(),data=>{try{resolve({id:payload.Id,container:data.Container,comment:data.Comment,os:data.Os,architecture:data.Architecture,parent:data.Parent,dockerVersion:data.DockerVersion,size:data.Size,sharedSize:payload.SharedSize,virtualSize:data.VirtualSize,author:data.Author,created:data.Created?Math.round(new Date(data.Created).getTime()/1e3):0,containerConfig:data.ContainerConfig?data.ContainerConfig:{},graphDriver:data.GraphDriver?data.GraphDriver:{},repoDigests:data.RepoDigests?data.RepoDigests:{},repoTags:data.RepoTags?data.RepoTags:{},config:data.Config?data.Config:{},rootFS:data.RootFS?data.RootFS:{}})}catch(err){resolve()}})}else{resolve()}})})}exports2.dockerImages=dockerImages;function dockerContainers(all2,callback){function inContainers(containers,id){let filtered=containers.filter(obj=>{return obj.Id&&obj.Id===id});return filtered.length>0}if(util4.isFunction(all2)&&!callback){callback=all2;all2=false}if(typeof all2==="string"&&all2==="true"){all2=true}if(typeof all2!=="boolean"&&all2!==void 0){all2=false}all2=all2||false;let result2=[];return new Promise(resolve=>{process.nextTick(()=>{if(!_docker_socket){_docker_socket=new DockerSocket}const workload=[];_docker_socket.listContainers(all2,data=>{let docker_containers={};try{docker_containers=data;if(docker_containers&&Object.prototype.toString.call(docker_containers)==="[object Array]"&&docker_containers.length>0){for(let key in _docker_container_stats){if({}.hasOwnProperty.call(_docker_container_stats,key)){if(!inContainers(docker_containers,key)){delete _docker_container_stats[key]}}}docker_containers.forEach(function(element){if(element.Names&&Object.prototype.toString.call(element.Names)==="[object Array]"&&element.Names.length>0){element.Name=element.Names[0].replace(/^\/|\/$/g,"")}workload.push(dockerContainerInspect(element.Id.trim(),element))});if(workload.length){Promise.all(workload).then(data2=>{if(callback){callback(data2)}resolve(data2)})}else{if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}}catch(err){for(let key in _docker_container_stats){if({}.hasOwnProperty.call(_docker_container_stats,key)){if(!inContainers(docker_containers,key)){delete _docker_container_stats[key]}}}if(callback){callback(result2)}resolve(result2)}})})})}function dockerContainerInspect(containerID,payload){return new Promise(resolve=>{process.nextTick(()=>{containerID=containerID||"";if(typeof containerID!=="string"){return resolve()}const containerIdSanitized=(util4.isPrototypePolluted()?"":util4.sanitizeShellString(containerID,true)).trim();if(containerIdSanitized){if(!_docker_socket){_docker_socket=new DockerSocket}_docker_socket.getInspect(containerIdSanitized.trim(),data=>{try{resolve({id:payload.Id,name:payload.Name,image:payload.Image,imageID:payload.ImageID,command:payload.Command,created:payload.Created,started:data.State&&data.State.StartedAt?Math.round(new Date(data.State.StartedAt).getTime()/1e3):0,finished:data.State&&data.State.FinishedAt&&!data.State.FinishedAt.startsWith("0001-01-01")?Math.round(new Date(data.State.FinishedAt).getTime()/1e3):0,createdAt:data.Created?data.Created:"",startedAt:data.State&&data.State.StartedAt?data.State.StartedAt:"",finishedAt:data.State&&data.State.FinishedAt&&!data.State.FinishedAt.startsWith("0001-01-01")?data.State.FinishedAt:"",state:payload.State,restartCount:data.RestartCount||0,platform:data.Platform||"",driver:data.Driver||"",ports:payload.Ports,mounts:payload.Mounts})}catch(err){resolve()}})}else{resolve()}})})}exports2.dockerContainers=dockerContainers;function docker_calcCPUPercent(cpu_stats,precpu_stats){if(!_windows){let cpuPercent=0;let cpuDelta=cpu_stats.cpu_usage.total_usage-precpu_stats.cpu_usage.total_usage;let systemDelta=cpu_stats.system_cpu_usage-precpu_stats.system_cpu_usage;if(systemDelta>0&&cpuDelta>0){if(precpu_stats.online_cpus){cpuPercent=cpuDelta/systemDelta*precpu_stats.online_cpus*100}else{cpuPercent=cpuDelta/systemDelta*cpu_stats.cpu_usage.percpu_usage.length*100}}return cpuPercent}else{let nanoSecNow=util4.nanoSeconds();let cpuPercent=0;if(_docker_last_read>0){let possIntervals=nanoSecNow-_docker_last_read;let intervalsUsed=cpu_stats.cpu_usage.total_usage-precpu_stats.cpu_usage.total_usage;if(possIntervals>0){cpuPercent=100*intervalsUsed/possIntervals}}_docker_last_read=nanoSecNow;return cpuPercent}}function docker_calcNetworkIO(networks){let rx;let wx;for(let key in networks){if(!{}.hasOwnProperty.call(networks,key)){continue}let obj=networks[key];rx=+obj.rx_bytes;wx=+obj.tx_bytes}return{rx,wx}}function docker_calcBlockIO(blkio_stats){let result2={r:0,w:0};if(blkio_stats&&blkio_stats.io_service_bytes_recursive&&Object.prototype.toString.call(blkio_stats.io_service_bytes_recursive)==="[object Array]"&&blkio_stats.io_service_bytes_recursive.length>0){blkio_stats.io_service_bytes_recursive.forEach(function(element){if(element.op&&element.op.toLowerCase()==="read"&&element.value){result2.r+=element.value}if(element.op&&element.op.toLowerCase()==="write"&&element.value){result2.w+=element.value}})}return result2}function dockerContainerStats(containerIDs,callback){let containerArray=[];return new Promise(resolve=>{process.nextTick(()=>{if(util4.isFunction(containerIDs)&&!callback){callback=containerIDs;containerArray=["*"]}else{containerIDs=containerIDs||"*";if(typeof containerIDs!=="string"){if(callback){callback([])}return resolve([])}let containerIDsSanitized="";try{containerIDsSanitized.__proto__.toLowerCase=util4.stringToLower;containerIDsSanitized.__proto__.replace=util4.stringReplace;containerIDsSanitized.__proto__.toString=util4.stringToString;containerIDsSanitized.__proto__.substr=util4.stringSubstr;containerIDsSanitized.__proto__.substring=util4.stringSubstring;containerIDsSanitized.__proto__.trim=util4.stringTrim;containerIDsSanitized.__proto__.startsWith=util4.stringStartWith}catch(e){Object.setPrototypeOf(containerIDsSanitized,util4.stringObj)}containerIDsSanitized=containerIDs;containerIDsSanitized=containerIDsSanitized.trim();if(containerIDsSanitized!=="*"){containerIDsSanitized="";const s=(util4.isPrototypePolluted()?"":util4.sanitizeShellString(containerIDs,true)).trim();const l=util4.mathMin(s.length,2e3);for(let i=0;i<=l;i++){if(s[i]!==void 0){s[i].__proto__.toLowerCase=util4.stringToLower;const sl=s[i].toLowerCase();if(sl&&sl[0]&&!sl[1]){containerIDsSanitized=containerIDsSanitized+sl[0]}}}}containerIDsSanitized=containerIDsSanitized.trim().toLowerCase().replace(/,+/g,"|");containerArray=containerIDsSanitized.split("|")}const result2=[];const workload=[];if(containerArray.length&&containerArray[0].trim()==="*"){containerArray=[];dockerContainers().then(allContainers=>{for(let container of allContainers){containerArray.push(container.id.substring(0,12))}if(containerArray.length){dockerContainerStats(containerArray.join(",")).then(result3=>{if(callback){callback(result3)}resolve(result3)})}else{if(callback){callback(result2)}resolve(result2)}})}else{for(let containerID of containerArray){workload.push(dockerContainerStatsSingle(containerID.trim()))}if(workload.length){Promise.all(workload).then(data=>{if(callback){callback(data)}resolve(data)})}else{if(callback){callback(result2)}resolve(result2)}}})})}function dockerContainerStatsSingle(containerID){containerID=containerID||"";let result2={id:containerID,memUsage:0,memLimit:0,memPercent:0,cpuPercent:0,pids:0,netIO:{rx:0,wx:0},blockIO:{r:0,w:0},restartCount:0,cpuStats:{},precpuStats:{},memoryStats:{},networks:{}};return new Promise(resolve=>{process.nextTick(()=>{if(containerID){if(!_docker_socket){_docker_socket=new DockerSocket}_docker_socket.getInspect(containerID,dataInspect=>{try{_docker_socket.getStats(containerID,data=>{try{let stats=data;if(!stats.message){if(data.id){result2.id=data.id}result2.memUsage=stats.memory_stats&&stats.memory_stats.usage?stats.memory_stats.usage:0;result2.memLimit=stats.memory_stats&&stats.memory_stats.limit?stats.memory_stats.limit:0;result2.memPercent=stats.memory_stats&&stats.memory_stats.usage&&stats.memory_stats.limit?stats.memory_stats.usage/stats.memory_stats.limit*100:0;result2.cpuPercent=stats.cpu_stats&&stats.precpu_stats?docker_calcCPUPercent(stats.cpu_stats,stats.precpu_stats):0;result2.pids=stats.pids_stats&&stats.pids_stats.current?stats.pids_stats.current:0;result2.restartCount=dataInspect.RestartCount?dataInspect.RestartCount:0;if(stats.networks){result2.netIO=docker_calcNetworkIO(stats.networks)}if(stats.blkio_stats){result2.blockIO=docker_calcBlockIO(stats.blkio_stats)}result2.cpuStats=stats.cpu_stats?stats.cpu_stats:{};result2.precpuStats=stats.precpu_stats?stats.precpu_stats:{};result2.memoryStats=stats.memory_stats?stats.memory_stats:{};result2.networks=stats.networks?stats.networks:{}}}catch(err){util4.noop()}resolve(result2)})}catch(err){util4.noop()}})}else{resolve(result2)}})})}exports2.dockerContainerStats=dockerContainerStats;function dockerContainerProcesses(containerID,callback){let result2=[];return new Promise(resolve=>{process.nextTick(()=>{containerID=containerID||"";if(typeof containerID!=="string"){return resolve(result2)}const containerIdSanitized=(util4.isPrototypePolluted()?"":util4.sanitizeShellString(containerID,true)).trim();if(containerIdSanitized){if(!_docker_socket){_docker_socket=new DockerSocket}_docker_socket.getProcesses(containerIdSanitized,data=>{try{if(data&&data.Titles&&data.Processes){let titles=data.Titles.map(function(value){return value.toUpperCase()});let pos_pid=titles.indexOf("PID");let pos_ppid=titles.indexOf("PPID");let pos_pgid=titles.indexOf("PGID");let pos_vsz=titles.indexOf("VSZ");let pos_time=titles.indexOf("TIME");let pos_elapsed=titles.indexOf("ELAPSED");let pos_ni=titles.indexOf("NI");let pos_ruser=titles.indexOf("RUSER");let pos_user=titles.indexOf("USER");let pos_rgroup=titles.indexOf("RGROUP");let pos_group=titles.indexOf("GROUP");let pos_stat=titles.indexOf("STAT");let pos_rss=titles.indexOf("RSS");let pos_command=titles.indexOf("COMMAND");data.Processes.forEach(process6=>{result2.push({pidHost:pos_pid>=0?process6[pos_pid]:"",ppid:pos_ppid>=0?process6[pos_ppid]:"",pgid:pos_pgid>=0?process6[pos_pgid]:"",user:pos_user>=0?process6[pos_user]:"",ruser:pos_ruser>=0?process6[pos_ruser]:"",group:pos_group>=0?process6[pos_group]:"",rgroup:pos_rgroup>=0?process6[pos_rgroup]:"",stat:pos_stat>=0?process6[pos_stat]:"",time:pos_time>=0?process6[pos_time]:"",elapsed:pos_elapsed>=0?process6[pos_elapsed]:"",nice:pos_ni>=0?process6[pos_ni]:"",rss:pos_rss>=0?process6[pos_rss]:"",vsz:pos_vsz>=0?process6[pos_vsz]:"",command:pos_command>=0?process6[pos_command]:""})})}}catch(err){util4.noop()}if(callback){callback(result2)}resolve(result2)})}else{if(callback){callback(result2)}resolve(result2)}})})}exports2.dockerContainerProcesses=dockerContainerProcesses;function dockerVolumes(callback){let result2=[];return new Promise(resolve=>{process.nextTick(()=>{if(!_docker_socket){_docker_socket=new DockerSocket}_docker_socket.listVolumes(data=>{let dockerVolumes2={};try{dockerVolumes2=data;if(dockerVolumes2&&dockerVolumes2.Volumes&&Object.prototype.toString.call(dockerVolumes2.Volumes)==="[object Array]"&&dockerVolumes2.Volumes.length>0){dockerVolumes2.Volumes.forEach(function(element){result2.push({name:element.Name,driver:element.Driver,labels:element.Labels,mountpoint:element.Mountpoint,options:element.Options,scope:element.Scope,created:element.CreatedAt?Math.round(new Date(element.CreatedAt).getTime()/1e3):0})});if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}}catch(err){if(callback){callback(result2)}resolve(result2)}})})})}exports2.dockerVolumes=dockerVolumes;function dockerAll(callback){return new Promise(resolve=>{process.nextTick(()=>{dockerContainers(true).then(result2=>{if(result2&&Object.prototype.toString.call(result2)==="[object Array]"&&result2.length>0){let l=result2.length;result2.forEach(function(element){dockerContainerStats(element.id).then(res=>{element.memUsage=res[0].memUsage;element.memLimit=res[0].memLimit;element.memPercent=res[0].memPercent;element.cpuPercent=res[0].cpuPercent;element.pids=res[0].pids;element.netIO=res[0].netIO;element.blockIO=res[0].blockIO;element.cpuStats=res[0].cpuStats;element.precpuStats=res[0].precpuStats;element.memoryStats=res[0].memoryStats;element.networks=res[0].networks;dockerContainerProcesses(element.id).then(processes=>{element.processes=processes;l-=1;if(l===0){if(callback){callback(result2)}resolve(result2)}})})})}else{if(callback){callback(result2)}resolve(result2)}})})})}exports2.dockerAll=dockerAll}});var require_virtualbox=__commonJS({"node_modules/systeminformation/lib/virtualbox.js"(exports2){"use strict";var os7=require("os");var exec3=require("child_process").exec;var util4=require_util2();function vboxInfo(callback){let result2=[];return new Promise(resolve=>{process.nextTick(()=>{try{exec3(util4.getVboxmanage()+" list vms --long",function(error,stdout){let parts=(os7.EOL+stdout.toString()).split(os7.EOL+"Name:");parts.shift();parts.forEach(part=>{const lines=("Name:"+part).split(os7.EOL);const state=util4.getValue(lines,"State");const running=state.startsWith("running");const runningSinceString=running?state.replace("running (since ","").replace(")","").trim():"";let runningSince=0;try{if(running){const sinceDateObj=new Date(runningSinceString);const offset=sinceDateObj.getTimezoneOffset();runningSince=Math.round((Date.now()-Date.parse(sinceDateObj))/1e3)+offset*60}}catch(e){util4.noop()}const stoppedSinceString=!running?state.replace("powered off (since","").replace(")","").trim():"";let stoppedSince=0;try{if(!running){const sinceDateObj=new Date(stoppedSinceString);const offset=sinceDateObj.getTimezoneOffset();stoppedSince=Math.round((Date.now()-Date.parse(sinceDateObj))/1e3)+offset*60}}catch(e){util4.noop()}result2.push({id:util4.getValue(lines,"UUID"),name:util4.getValue(lines,"Name"),running,started:runningSinceString,runningSince,stopped:stoppedSinceString,stoppedSince,guestOS:util4.getValue(lines,"Guest OS"),hardwareUUID:util4.getValue(lines,"Hardware UUID"),memory:parseInt(util4.getValue(lines,"Memory size","     "),10),vram:parseInt(util4.getValue(lines,"VRAM size"),10),cpus:parseInt(util4.getValue(lines,"Number of CPUs"),10),cpuExepCap:util4.getValue(lines,"CPU exec cap"),cpuProfile:util4.getValue(lines,"CPUProfile"),chipset:util4.getValue(lines,"Chipset"),firmware:util4.getValue(lines,"Firmware"),pageFusion:util4.getValue(lines,"Page Fusion")==="enabled",configFile:util4.getValue(lines,"Config file"),snapshotFolder:util4.getValue(lines,"Snapshot folder"),logFolder:util4.getValue(lines,"Log folder"),hpet:util4.getValue(lines,"HPET")==="enabled",pae:util4.getValue(lines,"PAE")==="enabled",longMode:util4.getValue(lines,"Long Mode")==="enabled",tripleFaultReset:util4.getValue(lines,"Triple Fault Reset")==="enabled",apic:util4.getValue(lines,"APIC")==="enabled",x2Apic:util4.getValue(lines,"X2APIC")==="enabled",acpi:util4.getValue(lines,"ACPI")==="enabled",ioApic:util4.getValue(lines,"IOAPIC")==="enabled",biosApicMode:util4.getValue(lines,"BIOS APIC mode"),bootMenuMode:util4.getValue(lines,"Boot menu mode"),bootDevice1:util4.getValue(lines,"Boot Device 1"),bootDevice2:util4.getValue(lines,"Boot Device 2"),bootDevice3:util4.getValue(lines,"Boot Device 3"),bootDevice4:util4.getValue(lines,"Boot Device 4"),timeOffset:util4.getValue(lines,"Time offset"),rtc:util4.getValue(lines,"RTC")})});if(callback){callback(result2)}resolve(result2)})}catch(e){if(callback){callback(result2)}resolve(result2)}})})}exports2.vboxInfo=vboxInfo}});var require_printer=__commonJS({"node_modules/systeminformation/lib/printer.js"(exports2){"use strict";var exec3=require("child_process").exec;var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";var winPrinterStatus={1:"Other",2:"Unknown",3:"Idle",4:"Printing",5:"Warmup",6:"Stopped Printing",7:"Offline"};function parseLinuxCupsHeader(lines){const result2={};if(lines&&lines.length){if(lines[0].indexOf(" CUPS v")>0){const parts=lines[0].split(" CUPS v");result2.cupsVersion=parts[1]}}return result2}function parseLinuxCupsPrinter(lines){const result2={};const printerId=util4.getValue(lines,"PrinterId"," ");result2.id=printerId?parseInt(printerId,10):null;result2.name=util4.getValue(lines,"Info"," ");result2.model=lines.length>0&&lines[0]?lines[0].split(" ")[0]:"";result2.uri=util4.getValue(lines,"DeviceURI"," ");result2.uuid=util4.getValue(lines,"UUID"," ");result2.status=util4.getValue(lines,"State"," ");result2.local=util4.getValue(lines,"Location"," ").toLowerCase().startsWith("local");result2.default=null;result2.shared=util4.getValue(lines,"Shared"," ").toLowerCase().startsWith("yes");return result2}function parseLinuxLpstatPrinter(lines,id){const result2={};result2.id=id;result2.name=util4.getValue(lines,"Description",":",true);result2.model=lines.length>0&&lines[0]?lines[0].split(" ")[0]:"";result2.uri=null;result2.uuid=null;result2.status=lines.length>0&&lines[0]?lines[0].indexOf(" idle")>0?"idle":lines[0].indexOf(" printing")>0?"printing":"unknown":null;result2.local=util4.getValue(lines,"Location",":",true).toLowerCase().startsWith("local");result2.default=null;result2.shared=util4.getValue(lines,"Shared"," ").toLowerCase().startsWith("yes");return result2}function parseDarwinPrinters(printerObject,id){const result2={};const uriParts=printerObject.uri.split("/");result2.id=id;result2.name=printerObject._name;result2.model=uriParts.length?uriParts[uriParts.length-1]:"";result2.uri=printerObject.uri;result2.uuid=null;result2.status=printerObject.status;result2.local=printerObject.printserver==="local";result2.default=printerObject.default==="yes";result2.shared=printerObject.shared==="yes";return result2}function parseWindowsPrinters(lines,id){const result2={};const status=parseInt(util4.getValue(lines,"PrinterStatus",":"),10);result2.id=id;result2.name=util4.getValue(lines,"name",":");result2.model=util4.getValue(lines,"DriverName",":");result2.uri=null;result2.uuid=null;result2.status=winPrinterStatus[status]?winPrinterStatus[status]:null;result2.local=util4.getValue(lines,"Local",":").toUpperCase()==="TRUE";result2.default=util4.getValue(lines,"Default",":").toUpperCase()==="TRUE";result2.shared=util4.getValue(lines,"Shared",":").toUpperCase()==="TRUE";return result2}function printer(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux||_freebsd||_openbsd||_netbsd){let cmd="cat /etc/cups/printers.conf 2>/dev/null";exec3(cmd,function(error,stdout){if(!error){const parts=stdout.toString().split("<Printer ");const printerHeader=parseLinuxCupsHeader(parts[0]);for(let i=1;i<parts.length;i++){const printers=parseLinuxCupsPrinter(parts[i].split("\n"));if(printers.name){printers.engine="CUPS";printers.engineVersion=printerHeader.cupsVersion;result2.push(printers)}}}if(result2.length===0){if(_linux){cmd="export LC_ALL=C; lpstat -lp 2>/dev/null; unset LC_ALL";exec3(cmd,function(error2,stdout2){const parts=("\n"+stdout2.toString()).split("\nprinter ");for(let i=1;i<parts.length;i++){const printers=parseLinuxLpstatPrinter(parts[i].split("\n"),i);result2.push(printers)}});if(callback){callback(result2)}resolve(result2)}else{if(callback){callback(result2)}resolve(result2)}}else{if(callback){callback(result2)}resolve(result2)}})}if(_darwin){let cmd="system_profiler SPPrintersDataType -json";exec3(cmd,function(error,stdout){if(!error){try{const outObj=JSON.parse(stdout.toString());if(outObj.SPPrintersDataType&&outObj.SPPrintersDataType.length){for(let i=0;i<outObj.SPPrintersDataType.length;i++){const printer2=parseDarwinPrinters(outObj.SPPrintersDataType[i],i);result2.push(printer2)}}}catch(e){util4.noop()}}if(callback){callback(result2)}resolve(result2)})}if(_windows){util4.powerShell("Get-CimInstance Win32_Printer | select PrinterStatus,Name,DriverName,Local,Default,Shared | fl").then((stdout,error)=>{if(!error){const parts=stdout.toString().split(/\n\s*\n/);for(let i=0;i<parts.length;i++){const printer2=parseWindowsPrinters(parts[i].split("\n"),i);if(printer2.name||printer2.model){result2.push(printer2)}}}if(callback){callback(result2)}resolve(result2)})}if(_sunos){resolve(null)}})})}exports2.printer=printer}});var require_usb=__commonJS({"node_modules/systeminformation/lib/usb.js"(exports2){"use strict";var exec3=require("child_process").exec;var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function getLinuxUsbType(type2,name){let result2=type2;const str2=(name+" "+type2).toLowerCase();if(str2.indexOf("camera")>=0){result2="Camera"}else if(str2.indexOf("hub")>=0){result2="Hub"}else if(str2.indexOf("keybrd")>=0){result2="Keyboard"}else if(str2.indexOf("keyboard")>=0){result2="Keyboard"}else if(str2.indexOf("mouse")>=0){result2="Mouse"}else if(str2.indexOf("stora")>=0){result2="Storage"}else if(str2.indexOf("microp")>=0){result2="Microphone"}else if(str2.indexOf("headset")>=0){result2="Audio"}else if(str2.indexOf("audio")>=0){result2="Audio"}return result2}function parseLinuxUsb(usb2){const result2={};const lines=usb2.split("\n");if(lines&&lines.length&&lines[0].indexOf("Device")>=0){const parts=lines[0].split(" ");result2.bus=parseInt(parts[0],10);if(parts[2]){result2.deviceId=parseInt(parts[2],10)}else{result2.deviceId=null}}else{result2.bus=null;result2.deviceId=null}const idVendor=util4.getValue(lines,"idVendor"," ",true).trim();let vendorParts=idVendor.split(" ");vendorParts.shift();const vendor=vendorParts.join(" ");const idProduct=util4.getValue(lines,"idProduct"," ",true).trim();let productParts=idProduct.split(" ");productParts.shift();const product=productParts.join(" ");const interfaceClass=util4.getValue(lines,"bInterfaceClass"," ",true).trim();let interfaceClassParts=interfaceClass.split(" ");interfaceClassParts.shift();const usbType=interfaceClassParts.join(" ");const iManufacturer=util4.getValue(lines,"iManufacturer"," ",true).trim();let iManufacturerParts=iManufacturer.split(" ");iManufacturerParts.shift();const manufacturer=iManufacturerParts.join(" ");const iSerial=util4.getValue(lines,"iSerial"," ",true).trim();let iSerialParts=iSerial.split(" ");iSerialParts.shift();const serial=iSerialParts.join(" ");result2.id=(idVendor.startsWith("0x")?idVendor.split(" ")[0].substr(2,10):"")+":"+(idProduct.startsWith("0x")?idProduct.split(" ")[0].substr(2,10):"");result2.name=product;result2.type=getLinuxUsbType(usbType,product);result2.removable=null;result2.vendor=vendor;result2.manufacturer=manufacturer;result2.maxPower=util4.getValue(lines,"MaxPower"," ",true);result2.serialNumber=serial;return result2}function getDarwinUsbType(name){let result2="";if(name.indexOf("camera")>=0){result2="Camera"}else if(name.indexOf("touch bar")>=0){result2="Touch Bar"}else if(name.indexOf("controller")>=0){result2="Controller"}else if(name.indexOf("headset")>=0){result2="Audio"}else if(name.indexOf("keyboard")>=0){result2="Keyboard"}else if(name.indexOf("trackpad")>=0){result2="Trackpad"}else if(name.indexOf("sensor")>=0){result2="Sensor"}else if(name.indexOf("bthusb")>=0){result2="Bluetooth"}else if(name.indexOf("bth")>=0){result2="Bluetooth"}else if(name.indexOf("rfcomm")>=0){result2="Bluetooth"}else if(name.indexOf("usbhub")>=0){result2="Hub"}else if(name.indexOf(" hub")>=0){result2="Hub"}else if(name.indexOf("mouse")>=0){result2="Mouse"}else if(name.indexOf("microp")>=0){result2="Microphone"}else if(name.indexOf("removable")>=0){result2="Storage"}return result2}function parseDarwinUsb(usb2,id){const result2={};result2.id=id;usb2=usb2.replace(/ \|/g,"");usb2=usb2.trim();let lines=usb2.split("\n");lines.shift();try{for(let i=0;i<lines.length;i++){lines[i]=lines[i].trim();lines[i]=lines[i].replace(/=/g,":");if(lines[i]!=="{"&&lines[i]!=="}"&&lines[i+1]&&lines[i+1].trim()!=="}"){lines[i]=lines[i]+","}lines[i]=lines[i].replace(":Yes,",':"Yes",');lines[i]=lines[i].replace(": Yes,",': "Yes",');lines[i]=lines[i].replace(": Yes",': "Yes"');lines[i]=lines[i].replace(":No,",':"No",');lines[i]=lines[i].replace(": No,",': "No",');lines[i]=lines[i].replace(": No",': "No"');lines[i]=lines[i].replace("((","").replace("))","");const match=/<(\w+)>/.exec(lines[i]);if(match){const number2=match[0];lines[i]=lines[i].replace(number2,`"${number2}"`)}}const usbObj=JSON.parse(lines.join("\n"));const removableDrive=(usbObj["Built-In"]?usbObj["Built-In"].toLowerCase()!=="yes":true)&&(usbObj["non-removable"]?usbObj["non-removable"].toLowerCase()==="no":true);result2.bus=null;result2.deviceId=null;result2.id=usbObj["USB Address"]||null;result2.name=usbObj["kUSBProductString"]||usbObj["USB Product Name"]||null;result2.type=getDarwinUsbType((usbObj["kUSBProductString"]||usbObj["USB Product Name"]||"").toLowerCase()+(removableDrive?" removable":""));result2.removable=usbObj["non-removable"]?usbObj["non-removable"].toLowerCase()||false:true;result2.vendor=usbObj["kUSBVendorString"]||usbObj["USB Vendor Name"]||null;result2.manufacturer=usbObj["kUSBVendorString"]||usbObj["USB Vendor Name"]||null;result2.maxPower=null;result2.serialNumber=usbObj["kUSBSerialNumberString"]||null;if(result2.name){return result2}else{return null}}catch(e){return null}}function getWindowsUsbTypeCreation(creationclass,name){let result2="";if(name.indexOf("storage")>=0){result2="Storage"}else if(name.indexOf("speicher")>=0){result2="Storage"}else if(creationclass.indexOf("usbhub")>=0){result2="Hub"}else if(creationclass.indexOf("storage")>=0){result2="Storage"}else if(creationclass.indexOf("usbcontroller")>=0){result2="Controller"}else if(creationclass.indexOf("keyboard")>=0){result2="Keyboard"}else if(creationclass.indexOf("pointing")>=0){result2="Mouse"}else if(creationclass.indexOf("microp")>=0){result2="Microphone"}else if(creationclass.indexOf("disk")>=0){result2="Storage"}return result2}function parseWindowsUsb(lines,id){const usbType=getWindowsUsbTypeCreation(util4.getValue(lines,"CreationClassName",":").toLowerCase(),util4.getValue(lines,"name",":").toLowerCase());if(usbType){const result2={};result2.bus=null;result2.deviceId=util4.getValue(lines,"deviceid",":");result2.id=id;result2.name=util4.getValue(lines,"name",":");result2.type=usbType;result2.removable=null;result2.vendor=null;result2.manufacturer=util4.getValue(lines,"Manufacturer",":");result2.maxPower=null;result2.serialNumber=null;return result2}else{return null}}function usb(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux){const cmd="export LC_ALL=C; lsusb -v 2>/dev/null; unset LC_ALL";exec3(cmd,{maxBuffer:1024*1024*128},function(error,stdout){if(!error){const parts=("\n\n"+stdout.toString()).split("\n\nBus ");for(let i=1;i<parts.length;i++){const usb2=parseLinuxUsb(parts[i]);result2.push(usb2)}}if(callback){callback(result2)}resolve(result2)})}if(_darwin){let cmd="ioreg -p IOUSB -c AppleUSBRootHubDevice -w0 -l";exec3(cmd,{maxBuffer:1024*1024*128},function(error,stdout){if(!error){const parts=stdout.toString().split(" +-o ");for(let i=1;i<parts.length;i++){const usb2=parseDarwinUsb(parts[i]);if(usb2){result2.push(usb2)}}if(callback){callback(result2)}resolve(result2)}if(callback){callback(result2)}resolve(result2)})}if(_windows){util4.powerShell('Get-CimInstance CIM_LogicalDevice | where { $_.Description -match "USB"} | select Name,CreationClassName,DeviceId,Manufacturer | fl').then((stdout,error)=>{if(!error){const parts=stdout.toString().split(/\n\s*\n/);for(let i=0;i<parts.length;i++){const usb2=parseWindowsUsb(parts[i].split("\n"),i);if(usb2&&result2.filter(x=>x.deviceId===usb2.deviceId).length===0){result2.push(usb2)}}}if(callback){callback(result2)}resolve(result2)})}if(_sunos||_freebsd||_openbsd||_netbsd){resolve(null)}})})}exports2.usb=usb}});var require_audio=__commonJS({"node_modules/systeminformation/lib/audio.js"(exports2){"use strict";var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var util4=require_util2();var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function parseAudioType(str2,input,output){str2=str2.toLowerCase();let result2="";if(str2.indexOf("input")>=0){result2="Microphone"}if(str2.indexOf("display audio")>=0){result2="Speaker"}if(str2.indexOf("speak")>=0){result2="Speaker"}if(str2.indexOf("laut")>=0){result2="Speaker"}if(str2.indexOf("loud")>=0){result2="Speaker"}if(str2.indexOf("head")>=0){result2="Headset"}if(str2.indexOf("mic")>=0){result2="Microphone"}if(str2.indexOf("mikr")>=0){result2="Microphone"}if(str2.indexOf("phone")>=0){result2="Phone"}if(str2.indexOf("controll")>=0){result2="Controller"}if(str2.indexOf("line o")>=0){result2="Line Out"}if(str2.indexOf("digital o")>=0){result2="Digital Out"}if(str2.indexOf("smart sound technology")>=0){result2="Digital Signal Processor"}if(str2.indexOf("high definition audio")>=0){result2="Sound Driver"}if(!result2&&output){result2="Speaker"}else if(!result2&&input){result2="Microphone"}return result2}function getLinuxAudioPci(){let cmd="lspci -v 2>/dev/null";let result2=[];try{const parts=execSync(cmd,util4.execOptsLinux).toString().split("\n\n");parts.forEach(element=>{const lines=element.split("\n");if(lines&&lines.length&&lines[0].toLowerCase().indexOf("audio")>=0){const audio2={};audio2.slotId=lines[0].split(" ")[0];audio2.driver=util4.getValue(lines,"Kernel driver in use",":",true)||util4.getValue(lines,"Kernel modules",":",true);result2.push(audio2)}});return result2}catch(e){return result2}}function parseLinuxAudioPciMM(lines,audioPCI){const result2={};const slotId=util4.getValue(lines,"Slot");const pciMatch=audioPCI.filter(function(item){return item.slotId===slotId});result2.id=slotId;result2.name=util4.getValue(lines,"SDevice");result2.manufacturer=util4.getValue(lines,"SVendor");result2.revision=util4.getValue(lines,"Rev");result2.driver=pciMatch&&pciMatch.length===1&&pciMatch[0].driver?pciMatch[0].driver:"";result2.default=null;result2.channel="PCIe";result2.type=parseAudioType(result2.name,null,null);result2.in=null;result2.out=null;result2.status="online";return result2}function parseDarwinChannel(str2){let result2="";if(str2.indexOf("builtin")>=0){result2="Built-In"}if(str2.indexOf("extern")>=0){result2="Audio-Jack"}if(str2.indexOf("hdmi")>=0){result2="HDMI"}if(str2.indexOf("displayport")>=0){result2="Display-Port"}if(str2.indexOf("usb")>=0){result2="USB"}if(str2.indexOf("pci")>=0){result2="PCIe"}return result2}function parseDarwinAudio(audioObject,id){const result2={};const channelStr=((audioObject.coreaudio_device_transport||"")+" "+(audioObject._name||"")).toLowerCase();result2.id=id;result2.name=audioObject._name;result2.manufacturer=audioObject.coreaudio_device_manufacturer;result2.revision=null;result2.driver=null;result2.default=!!(audioObject.coreaudio_default_audio_input_device||"")||!!(audioObject.coreaudio_default_audio_output_device||"");result2.channel=parseDarwinChannel(channelStr);result2.type=parseAudioType(result2.name,!!(audioObject.coreaudio_device_input||""),!!(audioObject.coreaudio_device_output||""));result2.in=!!(audioObject.coreaudio_device_input||"");result2.out=!!(audioObject.coreaudio_device_output||"");result2.status="online";return result2}function parseWindowsAudio(lines){const result2={};const status=util4.getValue(lines,"StatusInfo",":");result2.id=util4.getValue(lines,"DeviceID",":");result2.name=util4.getValue(lines,"name",":");result2.manufacturer=util4.getValue(lines,"manufacturer",":");result2.revision=null;result2.driver=null;result2.default=null;result2.channel=null;result2.type=parseAudioType(result2.name,null,null);result2.in=null;result2.out=null;result2.status=status;return result2}function audio(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux||_freebsd||_openbsd||_netbsd){let cmd="lspci -vmm 2>/dev/null";exec3(cmd,function(error,stdout){if(!error){const audioPCI=getLinuxAudioPci();const parts=stdout.toString().split("\n\n");parts.forEach(element=>{const lines=element.split("\n");if(util4.getValue(lines,"class",":",true).toLowerCase().indexOf("audio")>=0){const audio2=parseLinuxAudioPciMM(lines,audioPCI);result2.push(audio2)}})}if(callback){callback(result2)}resolve(result2)})}if(_darwin){let cmd="system_profiler SPAudioDataType -json";exec3(cmd,function(error,stdout){if(!error){try{const outObj=JSON.parse(stdout.toString());if(outObj.SPAudioDataType&&outObj.SPAudioDataType.length&&outObj.SPAudioDataType[0]&&outObj.SPAudioDataType[0]["_items"]&&outObj.SPAudioDataType[0]["_items"].length){for(let i=0;i<outObj.SPAudioDataType[0]["_items"].length;i++){const audio2=parseDarwinAudio(outObj.SPAudioDataType[0]["_items"][i],i);result2.push(audio2)}}}catch(e){util4.noop()}}if(callback){callback(result2)}resolve(result2)})}if(_windows){util4.powerShell("Get-CimInstance Win32_SoundDevice | select DeviceID,StatusInfo,Name,Manufacturer | fl").then((stdout,error)=>{if(!error){const parts=stdout.toString().split(/\n\s*\n/);parts.forEach(element=>{const lines=element.split("\n");if(util4.getValue(lines,"name",":")){result2.push(parseWindowsAudio(lines))}})}if(callback){callback(result2)}resolve(result2)})}if(_sunos){resolve(null)}})})}exports2.audio=audio}});var require_bluetoothVendors=__commonJS({"node_modules/systeminformation/lib/bluetoothVendors.js"(exports2,module2){"use strict";module2.exports={0:"Ericsson Technology Licensing",1:"Nokia Mobile Phones",2:"Intel Corp.",3:"IBM Corp.",4:"Toshiba Corp.",5:"3Com",6:"Microsoft",7:"Lucent",8:"Motorola",9:"Infineon Technologies AG",10:"Cambridge Silicon Radio",11:"Silicon Wave",12:"Digianswer A/S",13:"Texas Instruments Inc.",14:"Ceva, Inc. (formerly Parthus Technologies, Inc.)",15:"Broadcom Corporation",16:"Mitel Semiconductor",17:"Widcomm, Inc",18:"Zeevo, Inc.",19:"Atmel Corporation",20:"Mitsubishi Electric Corporation",21:"RTX Telecom A/S",22:"KC Technology Inc.",23:"NewLogic",24:"Transilica, Inc.",25:"Rohde & Schwarz GmbH & Co. KG",26:"TTPCom Limited",27:"Signia Technologies, Inc.",28:"Conexant Systems Inc.",29:"Qualcomm",30:"Inventel",31:"AVM Berlin",32:"BandSpeed, Inc.",33:"Mansella Ltd",34:"NEC Corporation",35:"WavePlus Technology Co., Ltd.",36:"Alcatel",37:"NXP Semiconductors (formerly Philips Semiconductors)",38:"C Technologies",39:"Open Interface",40:"R F Micro Devices",41:"Hitachi Ltd",42:"Symbol Technologies, Inc.",43:"Tenovis",44:"Macronix International Co. Ltd.",45:"GCT Semiconductor",46:"Norwood Systems",47:"MewTel Technology Inc.",48:"ST Microelectronics",49:"Synopsis",50:"Red-M (Communications) Ltd",51:"Commil Ltd",52:"Computer Access Technology Corporation (CATC)",53:"Eclipse (HQ Espana) S.L.",54:"Renesas Electronics Corporation",55:"Mobilian Corporation",56:"Terax",57:"Integrated System Solution Corp.",58:"Matsushita Electric Industrial Co., Ltd.",59:"Gennum Corporation",60:"BlackBerry Limited (formerly Research In Motion)",61:"IPextreme, Inc.",62:"Systems and Chips, Inc.",63:"Bluetooth SIG, Inc.",64:"Seiko Epson Corporation",65:"Integrated Silicon Solution Taiwan, Inc.",66:"CONWISE Technology Corporation Ltd",67:"PARROT SA",68:"Socket Mobile",69:"Atheros Communications, Inc.",70:"MediaTek, Inc.",71:"Bluegiga",72:"Marvell Technology Group Ltd.",73:"3DSP Corporation",74:"Accel Semiconductor Ltd.",75:"Continental Automotive Systems",76:"Apple, Inc.",77:"Staccato Communications, Inc.",78:"Avago Technologies",79:"APT Licensing Ltd.",80:"SiRF Technology",81:"Tzero Technologies, Inc.",82:"J&M Corporation",83:"Free2move AB",84:"3DiJoy Corporation",85:"Plantronics, Inc.",86:"Sony Ericsson Mobile Communications",87:"Harman International Industries, Inc.",88:"Vizio, Inc.",89:"Nordic Semiconductor ASA",90:"EM Microelectronic-Marin SA",91:"Ralink Technology Corporation",92:"Belkin International, Inc.",93:"Realtek Semiconductor Corporation",94:"Stonestreet One, LLC",95:"Wicentric, Inc.",96:"RivieraWaves S.A.S",97:"RDA Microelectronics",98:"Gibson Guitars",99:"MiCommand Inc.",100:"Band XI International, LLC",101:"Hewlett-Packard Company",102:"9Solutions Oy",103:"GN Netcom A/S",104:"General Motors",105:"A&D Engineering, Inc.",106:"MindTree Ltd.",107:"Polar Electro OY",108:"Beautiful Enterprise Co., Ltd.",109:"BriarTek, Inc.",110:"Summit Data Communications, Inc.",111:"Sound ID",112:"Monster, LLC",113:"connectBlue AB",114:"ShangHai Super Smart Electronics Co. Ltd.",115:"Group Sense Ltd.",116:"Zomm, LLC",117:"Samsung Electronics Co. Ltd.",118:"Creative Technology Ltd.",119:"Laird Technologies",120:"Nike, Inc.",121:"lesswire AG",122:"MStar Semiconductor, Inc.",123:"Hanlynn Technologies",124:"A & R Cambridge",125:"Seers Technology Co. Ltd",126:"Sports Tracking Technologies Ltd.",127:"Autonet Mobile",128:"DeLorme Publishing Company, Inc.",129:"WuXi Vimicro",130:"Sennheiser Communications A/S",131:"TimeKeeping Systems, Inc.",132:"Ludus Helsinki Ltd.",133:"BlueRadios, Inc.",134:"equinox AG",135:"Garmin International, Inc.",136:"Ecotest",137:"GN ReSound A/S",138:"Jawbone",139:"Topcorn Positioning Systems, LLC",140:"Gimbal Inc. (formerly Qualcomm Labs, Inc. and Qualcomm Retail Solutions, Inc.)",141:"Zscan Software",142:"Quintic Corp.",143:"Stollman E+V GmbH",144:"Funai Electric Co., Ltd.",145:"Advanced PANMOBIL Systems GmbH & Co. KG",146:"ThinkOptics, Inc.",147:"Universal Electronics, Inc.",148:"Airoha Technology Corp.",149:"NEC Lighting, Ltd.",150:"ODM Technology, Inc.",151:"ConnecteDevice Ltd.",152:"zer01.tv GmbH",153:"i.Tech Dynamic Global Distribution Ltd.",154:"Alpwise",155:"Jiangsu Toppower Automotive Electronics Co., Ltd.",156:"Colorfy, Inc.",157:"Geoforce Inc.",158:"Bose Corporation",159:"Suunto Oy",160:"Kensington Computer Products Group",161:"SR-Medizinelektronik",162:"Vertu Corporation Limited",163:"Meta Watch Ltd.",164:"LINAK A/S",165:"OTL Dynamics LLC",166:"Panda Ocean Inc.",167:"Visteon Corporation",168:"ARP Devices Limited",169:"Magneti Marelli S.p.A",170:"CAEN RFID srl",171:"Ingenieur-Systemgruppe Zahn GmbH",172:"Green Throttle Games",173:"Peter Systemtechnik GmbH",174:"Omegawave Oy",175:"Cinetix",176:"Passif Semiconductor Corp",177:"Saris Cycling Group, Inc",178:"Bekey A/S",179:"Clarinox Technologies Pty. Ltd.",180:"BDE Technology Co., Ltd.",181:"Swirl Networks",182:"Meso international",183:"TreLab Ltd",184:"Qualcomm Innovation Center, Inc. (QuIC)",185:"Johnson Controls, Inc.",186:"Starkey Laboratories Inc.",187:"S-Power Electronics Limited",188:"Ace Sensor Inc",189:"Aplix Corporation",190:"AAMP of America",191:"Stalmart Technology Limited",192:"AMICCOM Electronics Corporation",193:"Shenzhen Excelsecu Data Technology Co.,Ltd",194:"Geneq Inc.",195:"adidas AG",196:"LG Electronics",197:"Onset Computer Corporation",198:"Selfly BV",199:"Quuppa Oy.",200:"GeLo Inc",201:"Evluma",202:"MC10",203:"Binauric SE",204:"Beats Electronics",205:"Microchip Technology Inc.",206:"Elgato Systems GmbH",207:"ARCHOS SA",208:"Dexcom, Inc.",209:"Polar Electro Europe B.V.",210:"Dialog Semiconductor B.V.",211:"Taixingbang Technology (HK) Co,. LTD.",212:"Kawantech",213:"Austco Communication Systems",214:"Timex Group USA, Inc.",215:"Qualcomm Technologies, Inc.",216:"Qualcomm Connected Experiences, Inc.",217:"Voyetra Turtle Beach",218:"txtr GmbH",219:"Biosentronics",220:"Procter & Gamble",221:"Hosiden Corporation",222:"Muzik LLC",223:"Misfit Wearables Corp",224:"Google",225:"Danlers Ltd",226:"Semilink Inc",227:"inMusic Brands, Inc",228:"L.S. Research Inc.",229:"Eden Software Consultants Ltd.",230:"Freshtemp",231:"KS Technologies",232:"ACTS Technologies",233:"Vtrack Systems",234:"Nielsen-Kellerman Company",235:"Server Technology, Inc.",236:"BioResearch Associates",237:"Jolly Logic, LLC",238:"Above Average Outcomes, Inc.",239:"Bitsplitters GmbH",240:"PayPal, Inc.",241:"Witron Technology Limited",242:"Aether Things Inc. (formerly Morse Project Inc.)",243:"Kent Displays Inc.",244:"Nautilus Inc.",245:"Smartifier Oy",246:"Elcometer Limited",247:"VSN Technologies Inc.",248:"AceUni Corp., Ltd.",249:"StickNFind",250:"Crystal Code AB",251:"KOUKAAM a.s.",252:"Delphi Corporation",253:"ValenceTech Limited",254:"Reserved",255:"Typo Products, LLC",256:"TomTom International BV",257:"Fugoo, Inc",258:"Keiser Corporation",259:"Bang & Olufsen A/S",260:"PLUS Locations Systems Pty Ltd",261:"Ubiquitous Computing Technology Corporation",262:"Innovative Yachtter Solutions",263:"William Demant Holding A/S",264:"Chicony Electronics Co., Ltd.",265:"Atus BV",266:"Codegate Ltd.",267:"ERi, Inc.",268:"Transducers Direct, LLC",269:"Fujitsu Ten Limited",270:"Audi AG",271:"HiSilicon Technologies Co., Ltd.",272:"Nippon Seiki Co., Ltd.",273:"Steelseries ApS",274:"vyzybl Inc.",275:"Openbrain Technologies, Co., Ltd.",276:"Xensr",277:"e.solutions",278:"1OAK Technologies",279:"Wimoto Technologies Inc",280:"Radius Networks, Inc.",281:"Wize Technology Co., Ltd.",282:"Qualcomm Labs, Inc.",283:"Aruba Networks",284:"Baidu",285:"Arendi AG",286:"Skoda Auto a.s.",287:"Volkswagon AG",288:"Porsche AG",289:"Sino Wealth Electronic Ltd.",290:"AirTurn, Inc.",291:"Kinsa, Inc.",292:"HID Global",293:"SEAT es",294:"Promethean Ltd.",295:"Salutica Allied Solutions",296:"GPSI Group Pty Ltd",297:"Nimble Devices Oy",298:"Changzhou Yongse Infotech Co., Ltd",299:"SportIQ",300:"TEMEC Instruments B.V.",301:"Sony Corporation",302:"ASSA ABLOY",303:"Clarion Co., Ltd.",304:"Warehouse Innovations",305:"Cypress Semiconductor Corporation",306:"MADS Inc",307:"Blue Maestro Limited",308:"Resolution Products, Inc.",309:"Airewear LLC",310:"Seed Labs, Inc. (formerly ETC sp. z.o.o.)",311:"Prestigio Plaza Ltd.",312:"NTEO Inc.",313:"Focus Systems Corporation",314:"Tencent Holdings Limited",315:"Allegion",316:"Murata Manufacuring Co., Ltd.",318:"Nod, Inc.",319:"B&B Manufacturing Company",320:"Alpine Electronics (China) Co., Ltd",321:"FedEx Services",322:"Grape Systems Inc.",323:"Bkon Connect",324:"Lintech GmbH",325:"Novatel Wireless",326:"Ciright",327:"Mighty Cast, Inc.",328:"Ambimat Electronics",329:"Perytons Ltd.",330:"Tivoli Audio, LLC",331:"Master Lock",332:"Mesh-Net Ltd",333:"Huizhou Desay SV Automotive CO., LTD.",334:"Tangerine, Inc.",335:"B&W Group Ltd.",336:"Pioneer Corporation",337:"OnBeep",338:"Vernier Software & Technology",339:"ROL Ergo",340:"Pebble Technology",341:"NETATMO",342:"Accumulate AB",343:"Anhui Huami Information Technology Co., Ltd.",344:"Inmite s.r.o.",345:"ChefSteps, Inc.",346:"micas AG",347:"Biomedical Research Ltd.",348:"Pitius Tec S.L.",349:"Estimote, Inc.",350:"Unikey Technologies, Inc.",351:"Timer Cap Co.",352:"AwoX",353:"yikes",354:"MADSGlobal NZ Ltd.",355:"PCH International",356:"Qingdao Yeelink Information Technology Co., Ltd.",357:"Milwaukee Tool (formerly Milwaukee Electric Tools)",358:"MISHIK Pte Ltd",359:"Bayer HealthCare",360:"Spicebox LLC",361:"emberlight",362:"Cooper-Atkins Corporation",363:"Qblinks",364:"MYSPHERA",365:"LifeScan Inc",366:"Volantic AB",367:"Podo Labs, Inc",368:"Roche Diabetes Care AG",369:"Amazon Fulfillment Service",370:"Connovate Technology Private Limited",371:"Kocomojo, LLC",372:"Everykey LLC",373:"Dynamic Controls",374:"SentriLock",375:"I-SYST inc.",376:"CASIO COMPUTER CO., LTD.",377:"LAPIS Semiconductor Co., Ltd.",378:"Telemonitor, Inc.",379:"taskit GmbH",380:"Daimler AG",381:"BatAndCat",382:"BluDotz Ltd",383:"XTel ApS",384:"Gigaset Communications GmbH",385:"Gecko Health Innovations, Inc.",386:"HOP Ubiquitous",387:"To Be Assigned",388:"Nectar",389:"bel’apps LLC",390:"CORE Lighting Ltd",391:"Seraphim Sense Ltd",392:"Unico RBC",393:"Physical Enterprises Inc.",394:"Able Trend Technology Limited",395:"Konica Minolta, Inc.",396:"Wilo SE",397:"Extron Design Services",398:"Fitbit, Inc.",399:"Fireflies Systems",400:"Intelletto Technologies Inc.",401:"FDK CORPORATION",402:"Cloudleaf, Inc",403:"Maveric Automation LLC",404:"Acoustic Stream Corporation",405:"Zuli",406:"Paxton Access Ltd",407:"WiSilica Inc",408:"Vengit Limited",409:"SALTO SYSTEMS S.L.",410:"TRON Forum (formerly T-Engine Forum)",411:"CUBETECH s.r.o.",412:"Cokiya Incorporated",413:"CVS Health",414:"Ceruus",415:"Strainstall Ltd",416:"Channel Enterprises (HK) Ltd.",417:"FIAMM",418:"GIGALANE.CO.,LTD",419:"EROAD",420:"Mine Safety Appliances",421:"Icon Health and Fitness",422:"Asandoo GmbH",423:"ENERGOUS CORPORATION",424:"Taobao",425:"Canon Inc.",426:"Geophysical Technology Inc.",427:"Facebook, Inc.",428:"Nipro Diagnostics, Inc.",429:"FlightSafety International",430:"Earlens Corporation",431:"Sunrise Micro Devices, Inc.",432:"Star Micronics Co., Ltd.",433:"Netizens Sp. z o.o.",434:"Nymi Inc.",435:"Nytec, Inc.",436:"Trineo Sp. z o.o.",437:"Nest Labs Inc.",438:"LM Technologies Ltd",439:"General Electric Company",440:"i+D3 S.L.",441:"HANA Micron",442:"Stages Cycling LLC",443:"Cochlear Bone Anchored Solutions AB",444:"SenionLab AB",445:"Syszone Co., Ltd",446:"Pulsate Mobile Ltd.",447:"Hong Kong HunterSun Electronic Limited",448:"pironex GmbH",449:"BRADATECH Corp.",450:"Transenergooil AG",451:"Bunch",452:"DME Microelectronics",453:"Bitcraze AB",454:"HASWARE Inc.",455:"Abiogenix Inc.",456:"Poly-Control ApS",457:"Avi-on",458:"Laerdal Medical AS",459:"Fetch My Pet",460:"Sam Labs Ltd.",461:"Chengdu Synwing Technology Ltd",462:"HOUWA SYSTEM DESIGN, k.k.",463:"BSH",464:"Primus Inter Pares Ltd",465:"August",466:"Gill Electronics",467:"Sky Wave Design",468:"Newlab S.r.l.",469:"ELAD srl",470:"G-wearables inc.",471:"Squadrone Systems Inc.",472:"Code Corporation",473:"Savant Systems LLC",474:"Logitech International SA",475:"Innblue Consulting",476:"iParking Ltd.",477:"Koninklijke Philips Electronics N.V.",478:"Minelab Electronics Pty Limited",479:"Bison Group Ltd.",480:"Widex A/S",481:"Jolla Ltd",482:"Lectronix, Inc.",483:"Caterpillar Inc",484:"Freedom Innovations",485:"Dynamic Devices Ltd",486:"Technology Solutions (UK) Ltd",487:"IPS Group Inc.",488:"STIR",489:"Sano, Inc",490:"Advanced Application Design, Inc.",491:"AutoMap LLC",492:"Spreadtrum Communications Shanghai Ltd",493:"CuteCircuit LTD",494:"Valeo Service",495:"Fullpower Technologies, Inc.",496:"KloudNation",497:"Zebra Technologies Corporation",498:"Itron, Inc.",499:"The University of Tokyo",500:"UTC Fire and Security",501:"Cool Webthings Limited",502:"DJO Global",503:"Gelliner Limited",504:"Anyka (Guangzhou) Microelectronics Technology Co, LTD",505:"Medtronic, Inc.",506:"Gozio, Inc.",507:"Form Lifting, LLC",508:"Wahoo Fitness, LLC",509:"Kontakt Micro-Location Sp. z o.o.",510:"Radio System Corporation",511:"Freescale Semiconductor, Inc.",512:"Verifone Systems PTe Ltd. Taiwan Branch",513:"AR Timing",514:"Rigado LLC",515:"Kemppi Oy",516:"Tapcentive Inc.",517:"Smartbotics Inc.",518:"Otter Products, LLC",519:"STEMP Inc.",520:"LumiGeek LLC",521:"InvisionHeart Inc.",522:"Macnica Inc. ",523:"Jaguar Land Rover Limited",524:"CoroWare Technologies, Inc",525:"Simplo Technology Co., LTD",526:"Omron Healthcare Co., LTD",527:"Comodule GMBH",528:"ikeGPS",529:"Telink Semiconductor Co. Ltd",530:"Interplan Co., Ltd",531:"Wyler AG",532:"IK Multimedia Production srl",533:"Lukoton Experience Oy",534:"MTI Ltd",535:"Tech4home, Lda",536:"Hiotech AB",537:"DOTT Limited",538:"Blue Speck Labs, LLC",539:"Cisco Systems, Inc",540:"Mobicomm Inc",541:"Edamic",542:"Goodnet, Ltd",543:"Luster Leaf Products Inc",544:"Manus Machina BV",545:"Mobiquity Networks Inc",546:"Praxis Dynamics",547:"Philip Morris Products S.A.",548:"Comarch SA",549:"Nestl Nespresso S.A.",550:"Merlinia A/S",551:"LifeBEAM Technologies",552:"Twocanoes Labs, LLC",553:"Muoverti Limited",554:"Stamer Musikanlagen GMBH",555:"Tesla Motors",556:"Pharynks Corporation",557:"Lupine",558:"Siemens AG",559:"Huami (Shanghai) Culture Communication CO., LTD",560:"Foster Electric Company, Ltd",561:"ETA SA",562:"x-Senso Solutions Kft",563:"Shenzhen SuLong Communication Ltd",564:"FengFan (BeiJing) Technology Co, Ltd",565:"Qrio Inc",566:"Pitpatpet Ltd",567:"MSHeli s.r.l.",568:"Trakm8 Ltd",569:"JIN CO, Ltd",570:"Alatech Tehnology",571:"Beijing CarePulse Electronic Technology Co, Ltd",572:"Awarepoint",573:"ViCentra B.V.",574:"Raven Industries",575:"WaveWare Technologies Inc.",576:"Argenox Technologies",577:"Bragi GmbH",578:"16Lab Inc",579:"Masimo Corp",580:"Iotera Inc",581:"Endress+Hauser",582:"ACKme Networks, Inc.",583:"FiftyThree Inc.",584:"Parker Hannifin Corp",585:"Transcranial Ltd",586:"Uwatec AG",587:"Orlan LLC",588:"Blue Clover Devices",589:"M-Way Solutions GmbH",590:"Microtronics Engineering GmbH",591:"Schneider Schreibgerte GmbH",592:"Sapphire Circuits LLC",593:"Lumo Bodytech Inc.",594:"UKC Technosolution",595:"Xicato Inc.",596:"Playbrush",597:"Dai Nippon Printing Co., Ltd.",598:"G24 Power Limited",599:"AdBabble Local Commerce Inc.",600:"Devialet SA",601:"ALTYOR",602:"University of Applied Sciences Valais/Haute Ecole Valaisanne",603:"Five Interactive, LLC dba Zendo",604:"NetEaseHangzhouNetwork co.Ltd.",605:"Lexmark International Inc.",606:"Fluke Corporation",607:"Yardarm Technologies",608:"SensaRx",609:"SECVRE GmbH",610:"Glacial Ridge Technologies",611:"Identiv, Inc.",612:"DDS, Inc.",613:"SMK Corporation",614:"Schawbel Technologies LLC",615:"XMI Systems SA",616:"Cerevo",617:"Torrox GmbH & Co KG",618:"Gemalto",619:"DEKA Research & Development Corp.",620:"Domster Tadeusz Szydlowski",621:"Technogym SPA",622:"FLEURBAEY BVBA",623:"Aptcode Solutions",624:"LSI ADL Technology",625:"Animas Corp",626:"Alps Electric Co., Ltd.",627:"OCEASOFT",628:"Motsai Research",629:"Geotab",630:"E.G.O. Elektro-Gertebau GmbH",631:"bewhere inc",632:"Johnson Outdoors Inc",633:"steute Schaltgerate GmbH & Co. KG",634:"Ekomini inc.",635:"DEFA AS",636:"Aseptika Ltd",637:"HUAWEI Technologies Co., Ltd. ( )",638:"HabitAware, LLC",639:"ruwido austria gmbh",640:"ITEC corporation",641:"StoneL",642:"Sonova AG",643:"Maven Machines, Inc.",644:"Synapse Electronics",645:"Standard Innovation Inc.",646:"RF Code, Inc.",647:"Wally Ventures S.L.",648:"Willowbank Electronics Ltd",649:"SK Telecom",650:"Jetro AS",651:"Code Gears LTD",652:"NANOLINK APS",653:"IF, LLC",654:"RF Digital Corp",655:"Church & Dwight Co., Inc",656:"Multibit Oy",657:"CliniCloud Inc",658:"SwiftSensors",659:"Blue Bite",660:"ELIAS GmbH",661:"Sivantos GmbH",662:"Petzl",663:"storm power ltd",664:"EISST Ltd",665:"Inexess Technology Simma KG",666:"Currant, Inc.",667:"C2 Development, Inc.",668:"Blue Sky Scientific, LLC",669:"ALOTTAZS LABS, LLC",670:"Kupson spol. s r.o.",671:"Areus Engineering GmbH",672:"Impossible Camera GmbH",673:"InventureTrack Systems",674:"LockedUp",675:"Itude",676:"Pacific Lock Company",677:"Tendyron Corporation ( )",678:"Robert Bosch GmbH",679:"Illuxtron international B.V.",680:"miSport Ltd.",681:"Chargelib",682:"Doppler Lab",683:"BBPOS Limited",684:"RTB Elektronik GmbH & Co. KG",685:"Rx Networks, Inc.",686:"WeatherFlow, Inc.",687:"Technicolor USA Inc.",688:"Bestechnic(Shanghai),Ltd",689:"Raden Inc",690:"JouZen Oy",691:"CLABER S.P.A.",692:"Hyginex, Inc.",693:"HANSHIN ELECTRIC RAILWAY CO.,LTD.",694:"Schneider Electric",695:"Oort Technologies LLC",696:"Chrono Therapeutics",697:"Rinnai Corporation",698:"Swissprime Technologies AG",699:"Koha.,Co.Ltd",700:"Genevac Ltd",701:"Chemtronics",702:"Seguro Technology Sp. z o.o.",703:"Redbird Flight Simulations",704:"Dash Robotics",705:"LINE Corporation",706:"Guillemot Corporation",707:"Techtronic Power Tools Technology Limited",708:"Wilson Sporting Goods",709:"Lenovo (Singapore) Pte Ltd. ( )",710:"Ayatan Sensors",711:"Electronics Tomorrow Limited",712:"VASCO Data Security International, Inc.",713:"PayRange Inc.",714:"ABOV Semiconductor",715:"AINA-Wireless Inc.",716:"Eijkelkamp Soil & Water",717:"BMA ergonomics b.v.",718:"Teva Branded Pharmaceutical Products R&D, Inc.",719:"Anima",720:"3M",721:"Empatica Srl",722:"Afero, Inc.",723:"Powercast Corporation",724:"Secuyou ApS",725:"OMRON Corporation",726:"Send Solutions",727:"NIPPON SYSTEMWARE CO.,LTD.",728:"Neosfar",729:"Fliegl Agrartechnik GmbH",730:"Gilvader",731:"Digi International Inc (R)",732:"DeWalch Technologies, Inc.",733:"Flint Rehabilitation Devices, LLC",734:"Samsung SDS Co., Ltd.",735:"Blur Product Development",736:"University of Michigan",737:"Victron Energy BV",738:"NTT docomo",739:"Carmanah Technologies Corp.",740:"Bytestorm Ltd.",741:"Espressif Incorporated ( () )",742:"Unwire",743:"Connected Yard, Inc.",744:"American Music Environments",745:"Sensogram Technologies, Inc.",746:"Fujitsu Limited",747:"Ardic Technology",748:"Delta Systems, Inc",749:"HTC Corporation",750:"Citizen Holdings Co., Ltd.",751:"SMART-INNOVATION.inc",752:"Blackrat Software",753:"The Idea Cave, LLC",754:"GoPro, Inc.",755:"AuthAir, Inc",756:"Vensi, Inc.",757:"Indagem Tech LLC",758:"Intemo Technologies",759:"DreamVisions co., Ltd.",760:"Runteq Oy Ltd",761:"IMAGINATION TECHNOLOGIES LTD",762:"CoSTAR TEchnologies",763:"Clarius Mobile Health Corp.",764:"Shanghai Frequen Microelectronics Co., Ltd.",765:"Uwanna, Inc.",766:"Lierda Science & Technology Group Co., Ltd.",767:"Silicon Laboratories",768:"World Moto Inc.",769:"Giatec Scientific Inc.",770:"Loop Devices, Inc",771:"IACA electronique",772:"Martians Inc",773:"Swipp ApS",774:"Life Laboratory Inc.",775:"FUJI INDUSTRIAL CO.,LTD.",776:"Surefire, LLC",777:"Dolby Labs",778:"Ellisys",779:"Magnitude Lighting Converters",780:"Hilti AG",781:"Devdata S.r.l.",782:"Deviceworx",783:"Shortcut Labs",784:"SGL Italia S.r.l.",785:"PEEQ DATA",786:"Ducere Technologies Pvt Ltd",787:"DiveNav, Inc.",788:"RIIG AI Sp. z o.o.",789:"Thermo Fisher Scientific",790:"AG Measurematics Pvt. Ltd.",791:"CHUO Electronics CO., LTD.",792:"Aspenta International",793:"Eugster Frismag AG",794:"Amber wireless GmbH",795:"HQ Inc",796:"Lab Sensor Solutions",797:"Enterlab ApS",798:"Eyefi, Inc.",799:"MetaSystem S.p.A.",800:"SONO ELECTRONICS. CO., LTD",801:"Jewelbots",802:"Compumedics Limited",803:"Rotor Bike Components",804:"Astro, Inc.",805:"Amotus Solutions",806:"Healthwear Technologies (Changzhou)Ltd",807:"Essex Electronics",808:"Grundfos A/S",809:"Eargo, Inc.",810:"Electronic Design Lab",811:"ESYLUX",812:"NIPPON SMT.CO.,Ltd",813:"BM innovations GmbH",814:"indoormap",815:"OttoQ Inc",816:"North Pole Engineering",817:"3flares Technologies Inc.",818:"Electrocompaniet A.S.",819:"Mul-T-Lock",820:"Corentium AS",821:"Enlighted Inc",822:"GISTIC",823:"AJP2 Holdings, LLC",824:"COBI GmbH",825:"Blue Sky Scientific, LLC",826:"Appception, Inc.",827:"Courtney Thorne Limited",828:"Virtuosys",829:"TPV Technology Limited",830:"Monitra SA",831:"Automation Components, Inc.",832:"Letsense s.r.l.",833:"Etesian Technologies LLC",834:"GERTEC BRASIL LTDA.",835:"Drekker Development Pty. Ltd.",836:"Whirl Inc",837:"Locus Positioning",838:"Acuity Brands Lighting, Inc",839:"Prevent Biometrics",840:"Arioneo",841:"VersaMe",842:"Vaddio",843:"Libratone A/S",844:"HM Electronics, Inc.",845:"TASER International, Inc.",846:"SafeTrust Inc.",847:"Heartland Payment Systems",848:"Bitstrata Systems Inc.",849:"Pieps GmbH",850:"iRiding(Xiamen)Technology Co.,Ltd.",851:"Alpha Audiotronics, Inc.",852:"TOPPAN FORMS CO.,LTD.",853:"Sigma Designs, Inc.",854:"Spectrum Brands, Inc.",855:"Polymap Wireless",856:"MagniWare Ltd.",857:"Novotec Medical GmbH",858:"Medicom Innovation Partner a/s",859:"Matrix Inc.",860:"Eaton Corporation",861:"KYS",862:"Naya Health, Inc.",863:"Acromag",864:"Insulet Corporation",865:"Wellinks Inc.",866:"ON Semiconductor",867:"FREELAP SA",868:"Favero Electronics Srl",869:"BioMech Sensor LLC",870:"BOLTT Sports technologies Private limited",871:"Saphe International",872:"Metormote AB",873:"littleBits",874:"SetPoint Medical",875:"BRControls Products BV",876:"Zipcar",877:"AirBolt Pty Ltd",878:"KeepTruckin Inc",879:"Motiv, Inc.",880:"Wazombi Labs O",881:"ORBCOMM",882:"Nixie Labs, Inc.",883:"AppNearMe Ltd",884:"Holman Industries",885:"Expain AS",886:"Electronic Temperature Instruments Ltd",887:"Plejd AB",888:"Propeller Health",889:"Shenzhen iMCO Electronic Technology Co.,Ltd",890:"Algoria",891:"Apption Labs Inc.",892:"Cronologics Corporation",893:"MICRODIA Ltd.",894:"lulabytes S.L.",895:"Nestec S.A.",896:"LLC MEGA - F service",897:"Sharp Corporation",898:"Precision Outcomes Ltd",899:"Kronos Incorporated",900:"OCOSMOS Co., Ltd.",901:"Embedded Electronic Solutions Ltd. dba e2Solutions",902:"Aterica Inc.",903:"BluStor PMC, Inc.",904:"Kapsch TrafficCom AB",905:"ActiveBlu Corporation",906:"Kohler Mira Limited",907:"Noke",908:"Appion Inc.",909:"Resmed Ltd",910:"Crownstone B.V.",911:"Xiaomi Inc.",912:"INFOTECH s.r.o.",913:"Thingsquare AB",914:"T&D",915:"LAVAZZA S.p.A.",916:"Netclearance Systems, Inc.",917:"SDATAWAY",918:"BLOKS GmbH",919:"LEGO System A/S",920:"Thetatronics Ltd",921:"Nikon Corporation",922:"NeST",923:"South Silicon Valley Microelectronics",924:"ALE International",925:"CareView Communications, Inc.",926:"SchoolBoard Limited",927:"Molex Corporation",928:"IVT Wireless Limited",929:"Alpine Labs LLC",930:"Candura Instruments",931:"SmartMovt Technology Co., Ltd",932:"Token Zero Ltd",933:"ACE CAD Enterprise Co., Ltd. (ACECAD)",934:"Medela, Inc",935:"AeroScout",936:"Esrille Inc.",937:"THINKERLY SRL",938:"Exon Sp. z o.o.",939:"Meizu Technology Co., Ltd.",940:"Smablo LTD",941:"XiQ",942:"Allswell Inc.",943:"Comm-N-Sense Corp DBA Verigo",944:"VIBRADORM GmbH",945:"Otodata Wireless Network Inc.",946:"Propagation Systems Limited",947:"Midwest Instruments & Controls",948:"Alpha Nodus, inc.",949:"petPOMM, Inc",950:"Mattel",951:"Airbly Inc.",952:"A-Safe Limited",953:"FREDERIQUE CONSTANT SA",954:"Maxscend Microelectronics Company Limited",955:"Abbott Diabetes Care",956:"ASB Bank Ltd",957:"amadas",958:"Applied Science, Inc.",959:"iLumi Solutions Inc.",960:"Arch Systems Inc.",961:"Ember Technologies, Inc.",962:"Snapchat Inc",963:"Casambi Technologies Oy",964:"Pico Technology Inc.",965:"St. Jude Medical, Inc.",966:"Intricon",967:"Structural Health Systems, Inc.",968:"Avvel International",969:"Gallagher Group",970:"In2things Automation Pvt. Ltd.",971:"SYSDEV Srl",972:"Vonkil Technologies Ltd",973:"Wynd Technologies, Inc.",974:"CONTRINEX S.A.",975:"MIRA, Inc.",976:"Watteam Ltd",977:"Density Inc.",978:"IOT Pot India Private Limited",979:"Sigma Connectivity AB",980:"PEG PEREGO SPA",981:"Wyzelink Systems Inc.",982:"Yota Devices LTD",983:"FINSECUR",984:"Zen-Me Labs Ltd",985:"3IWare Co., Ltd.",986:"EnOcean GmbH",987:"Instabeat, Inc",988:"Nima Labs",989:"Andreas Stihl AG & Co. KG",990:"Nathan Rhoades LLC",991:"Grob Technologies, LLC",992:"Actions (Zhuhai) Technology Co., Limited",993:"SPD Development Company Ltd",994:"Sensoan Oy",995:"Qualcomm Life Inc",996:"Chip-ing AG",997:"ffly4u",998:"IoT Instruments Oy",999:"TRUE Fitness Technology",1e3:"Reiner Kartengeraete GmbH & Co. KG.",1001:"SHENZHEN LEMONJOY TECHNOLOGY CO., LTD.",1002:"Hello Inc.",1003:"Evollve Inc.",1004:"Jigowatts Inc.",1005:"BASIC MICRO.COM,INC.",1006:"CUBE TECHNOLOGIES",1007:"foolography GmbH",1008:"CLINK",1009:"Hestan Smart Cooking Inc.",1010:"WindowMaster A/S",1011:"Flowscape AB",1012:"PAL Technologies Ltd",1013:"WHERE, Inc.",1014:"Iton Technology Corp.",1015:"Owl Labs Inc.",1016:"Rockford Corp.",1017:"Becon Technologies Co.,Ltd.",1018:"Vyassoft Technologies Inc",1019:"Nox Medical",1020:"Kimberly-Clark",1021:"Trimble Navigation Ltd.",1022:"Littelfuse",1023:"Withings",1024:"i-developer IT Beratung UG",1026:"Sears Holdings Corporation",1027:"Gantner Electronic GmbH",1028:"Authomate Inc",1029:"Vertex International, Inc.",1030:"Airtago",1031:"Swiss Audio SA",1032:"ToGetHome Inc.",1033:"AXIS",1034:"Openmatics",1035:"Jana Care Inc.",1036:"Senix Corporation",1037:"NorthStar Battery Company, LLC",1038:"SKF (U.K.) Limited",1039:"CO-AX Technology, Inc.",1040:"Fender Musical Instruments",1041:"Luidia Inc",1042:"SEFAM",1043:"Wireless Cables Inc",1044:"Lightning Protection International Pty Ltd",1045:"Uber Technologies Inc",1046:"SODA GmbH",1047:"Fatigue Science",1048:"Alpine Electronics Inc.",1049:"Novalogy LTD",1050:"Friday Labs Limited",1051:"OrthoAccel Technologies",1052:"WaterGuru, Inc.",1053:"Benning Elektrotechnik und Elektronik GmbH & Co. KG",1054:"Dell Computer Corporation",1055:"Kopin Corporation",1056:"TecBakery GmbH",1057:"Backbone Labs, Inc.",1058:"DELSEY SA",1059:"Chargifi Limited",1060:"Trainesense Ltd.",1061:"Unify Software and Solutions GmbH & Co. KG",1062:"Husqvarna AB",1063:"Focus fleet and fuel management inc",1064:"SmallLoop, LLC",1065:"Prolon Inc.",1066:"BD Medical",1067:"iMicroMed Incorporated",1068:"Ticto N.V.",1069:"Meshtech AS",1070:"MemCachier Inc.",1071:"Danfoss A/S",1072:"SnapStyk Inc.",1073:"Amyway Corporation",1074:"Silk Labs, Inc.",1075:"Pillsy Inc.",1076:"Hatch Baby, Inc.",1077:"Blocks Wearables Ltd.",1078:"Drayson Technologies (Europe) Limited",1079:"eBest IOT Inc.",1080:"Helvar Ltd",1081:"Radiance Technologies",1082:"Nuheara Limited",1083:"Appside co., ltd.",1084:"DeLaval",1085:"Coiler Corporation",1086:"Thermomedics, Inc.",1087:"Tentacle Sync GmbH",1088:"Valencell, Inc.",1089:"iProtoXi Oy",1090:"SECOM CO., LTD.",1091:"Tucker International LLC",1092:"Metanate Limited",1093:"Kobian Canada Inc.",1094:"NETGEAR, Inc.",1095:"Fabtronics Australia Pty Ltd",1096:"Grand Centrix GmbH",1097:"1UP USA.com llc",1098:"SHIMANO INC.",1099:"Nain Inc.",1100:"LifeStyle Lock, LLC",1101:"VEGA Grieshaber KG",1102:"Xtrava Inc.",1103:"TTS Tooltechnic Systems AG & Co. KG",1104:"Teenage Engineering AB",1105:"Tunstall Nordic AB",1106:"Svep Design Center AB",1107:"GreenPeak Technologies BV",1108:"Sphinx Electronics GmbH & Co KG",1109:"Atomation",1110:"Nemik Consulting Inc",1111:"RF INNOVATION",1112:"Mini Solution Co., Ltd.",1113:"Lumenetix, Inc",1114:"2048450 Ontario Inc",1115:"SPACEEK LTD",1116:"Delta T Corporation",1117:"Boston Scientific Corporation",1118:"Nuviz, Inc.",1119:"Real Time Automation, Inc.",1120:"Kolibree",1121:"vhf elektronik GmbH",1122:"Bonsai Systems GmbH",1123:"Fathom Systems Inc.",1124:"Bellman & Symfon",1125:"International Forte Group LLC",1126:"CycleLabs Solutions inc.",1127:"Codenex Oy",1128:"Kynesim Ltd",1129:"Palago AB",1130:"INSIGMA INC.",1131:"PMD Solutions",1132:"Qingdao Realtime Technology Co., Ltd.",1133:"BEGA Gantenbrink-Leuchten KG",1134:"Pambor Ltd.",65535:"SPECIAL USE/DEFAULT"}}});var require_bluetooth=__commonJS({"node_modules/systeminformation/lib/bluetooth.js"(exports2){"use strict";var exec3=require("child_process").exec;var execSync=require("child_process").execSync;var path27=require("path");var util4=require_util2();var bluetoothVendors=require_bluetoothVendors();var fs14=require("fs");var _platform=process.platform;var _linux=_platform==="linux"||_platform==="android";var _darwin=_platform==="darwin";var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";function parseBluetoothType(str2){let result2="";if(str2.indexOf("keyboard")>=0){result2="Keyboard"}if(str2.indexOf("mouse")>=0){result2="Mouse"}if(str2.indexOf("trackpad")>=0){result2="Trackpad"}if(str2.indexOf("speaker")>=0){result2="Speaker"}if(str2.indexOf("headset")>=0){result2="Headset"}if(str2.indexOf("phone")>=0){result2="Phone"}if(str2.indexOf("macbook")>=0){result2="Computer"}if(str2.indexOf("imac")>=0){result2="Computer"}if(str2.indexOf("ipad")>=0){result2="Tablet"}if(str2.indexOf("watch")>=0){result2="Watch"}if(str2.indexOf("headphone")>=0){result2="Headset"}return result2}function parseBluetoothManufacturer(str2){let result2=str2.split(" ")[0];str2=str2.toLowerCase();if(str2.indexOf("apple")>=0){result2="Apple"}if(str2.indexOf("ipad")>=0){result2="Apple"}if(str2.indexOf("imac")>=0){result2="Apple"}if(str2.indexOf("iphone")>=0){result2="Apple"}if(str2.indexOf("magic mouse")>=0){result2="Apple"}if(str2.indexOf("magic track")>=0){result2="Apple"}if(str2.indexOf("macbook")>=0){result2="Apple"}return result2}function parseBluetoothVendor(str2){const id=parseInt(str2);if(!isNaN(id))return bluetoothVendors[id]}function parseLinuxBluetoothInfo(lines,macAddr1,macAddr2){const result2={};result2.device=null;result2.name=util4.getValue(lines,"name","=");result2.manufacturer=null;result2.macDevice=macAddr1;result2.macHost=macAddr2;result2.batteryPercent=null;result2.type=parseBluetoothType(result2.name.toLowerCase());result2.connected=false;return result2}function parseDarwinBluetoothDevices(bluetoothObject,macAddr2){const result2={};const typeStr=((bluetoothObject.device_minorClassOfDevice_string||bluetoothObject.device_majorClassOfDevice_string||bluetoothObject.device_minorType||"")+(bluetoothObject.device_name||"")).toLowerCase();result2.device=bluetoothObject.device_services||"";result2.name=bluetoothObject.device_name||"";result2.manufacturer=bluetoothObject.device_manufacturer||parseBluetoothVendor(bluetoothObject.device_vendorID)||parseBluetoothManufacturer(bluetoothObject.device_name||"")||"";result2.macDevice=(bluetoothObject.device_addr||bluetoothObject.device_address||"").toLowerCase().replace(/-/g,":");result2.macHost=macAddr2;result2.batteryPercent=bluetoothObject.device_batteryPercent||null;result2.type=parseBluetoothType(typeStr);result2.connected=bluetoothObject.device_isconnected==="attrib_Yes"||false;return result2}function parseWindowsBluetooth(lines){const result2={};result2.device=null;result2.name=util4.getValue(lines,"name",":");result2.manufacturer=util4.getValue(lines,"manufacturer",":");result2.macDevice=null;result2.macHost=null;result2.batteryPercent=null;result2.type=parseBluetoothType(result2.name.toLowerCase());result2.connected=null;return result2}function bluetoothDevices(callback){return new Promise(resolve=>{process.nextTick(()=>{let result2=[];if(_linux){const btFiles=util4.getFilesInPath("/var/lib/bluetooth/");btFiles.forEach(element=>{const filename=path27.basename(element);const pathParts=element.split("/");const macAddr1=pathParts.length>=6?pathParts[pathParts.length-2]:null;const macAddr2=pathParts.length>=7?pathParts[pathParts.length-3]:null;if(filename==="info"){const infoFile=fs14.readFileSync(element,{encoding:"utf8"}).split("\n");result2.push(parseLinuxBluetoothInfo(infoFile,macAddr1,macAddr2))}});try{const hdicon=execSync("hcitool con",util4.execOptsLinux).toString().toLowerCase();for(let i=0;i<result2.length;i++){if(result2[i].macDevice&&result2[i].macDevice.length>10&&hdicon.indexOf(result2[i].macDevice.toLowerCase())>=0){result2[i].connected=true}}}catch(e){util4.noop()}if(callback){callback(result2)}resolve(result2)}if(_darwin){let cmd="system_profiler SPBluetoothDataType -json";exec3(cmd,function(error,stdout){if(!error){try{const outObj=JSON.parse(stdout.toString());if(outObj.SPBluetoothDataType&&outObj.SPBluetoothDataType.length&&outObj.SPBluetoothDataType[0]&&outObj.SPBluetoothDataType[0]["device_title"]&&outObj.SPBluetoothDataType[0]["device_title"].length){let macAddr2=null;if(outObj.SPBluetoothDataType[0]["local_device_title"]&&outObj.SPBluetoothDataType[0].local_device_title.general_address){macAddr2=outObj.SPBluetoothDataType[0].local_device_title.general_address.toLowerCase().replace(/-/g,":")}outObj.SPBluetoothDataType[0]["device_title"].forEach(element=>{const obj=element;const objKey=Object.keys(obj);if(objKey&&objKey.length===1){const innerObject=obj[objKey[0]];innerObject.device_name=objKey[0];const bluetoothDevice=parseDarwinBluetoothDevices(innerObject,macAddr2);result2.push(bluetoothDevice)}})}if(outObj.SPBluetoothDataType&&outObj.SPBluetoothDataType.length&&outObj.SPBluetoothDataType[0]&&outObj.SPBluetoothDataType[0]["device_connected"]&&outObj.SPBluetoothDataType[0]["device_connected"].length){const macAddr2=outObj.SPBluetoothDataType[0].controller_properties&&outObj.SPBluetoothDataType[0].controller_properties.controller_address?outObj.SPBluetoothDataType[0].controller_properties.controller_address.toLowerCase().replace(/-/g,":"):null;outObj.SPBluetoothDataType[0]["device_connected"].forEach(element=>{const obj=element;const objKey=Object.keys(obj);if(objKey&&objKey.length===1){const innerObject=obj[objKey[0]];innerObject.device_name=objKey[0];innerObject.device_isconnected="attrib_Yes";const bluetoothDevice=parseDarwinBluetoothDevices(innerObject,macAddr2);result2.push(bluetoothDevice)}})}if(outObj.SPBluetoothDataType&&outObj.SPBluetoothDataType.length&&outObj.SPBluetoothDataType[0]&&outObj.SPBluetoothDataType[0]["device_not_connected"]&&outObj.SPBluetoothDataType[0]["device_not_connected"].length){const macAddr2=outObj.SPBluetoothDataType[0].controller_properties&&outObj.SPBluetoothDataType[0].controller_properties.controller_address?outObj.SPBluetoothDataType[0].controller_properties.controller_address.toLowerCase().replace(/-/g,":"):null;outObj.SPBluetoothDataType[0]["device_not_connected"].forEach(element=>{const obj=element;const objKey=Object.keys(obj);if(objKey&&objKey.length===1){const innerObject=obj[objKey[0]];innerObject.device_name=objKey[0];innerObject.device_isconnected="attrib_No";const bluetoothDevice=parseDarwinBluetoothDevices(innerObject,macAddr2);result2.push(bluetoothDevice)}})}}catch(e){util4.noop()}}if(callback){callback(result2)}resolve(result2)})}if(_windows){util4.powerShell("Get-CimInstance Win32_PNPEntity | select PNPClass, Name, Manufacturer | fl").then((stdout,error)=>{if(!error){const parts=stdout.toString().split(/\n\s*\n/);parts.forEach(part=>{if(util4.getValue(part.split("\n"),"PNPClass",":")==="Bluetooth"){result2.push(parseWindowsBluetooth(part.split("\n")))}})}if(callback){callback(result2)}resolve(result2)})}if(_freebsd||_netbsd||_openbsd||_sunos){resolve(null)}})})}exports2.bluetoothDevices=bluetoothDevices}});var require_lib=__commonJS({"node_modules/systeminformation/lib/index.js"(exports2){"use strict";var lib_version=require_package().version;var util4=require_util2();var system=require_system();var osInfo=require_osinfo();var cpu=require_cpu();var memory=require_memory();var battery=require_battery();var graphics=require_graphics();var filesystem=require_filesystem();var network=require_network();var wifi=require_wifi();var processes=require_processes();var users=require_users();var internet=require_internet();var docker=require_docker();var vbox=require_virtualbox();var printer=require_printer();var usb=require_usb();var audio=require_audio();var bluetooth=require_bluetooth();var _platform=process.platform;var _windows=_platform==="win32";var _freebsd=_platform==="freebsd";var _openbsd=_platform==="openbsd";var _netbsd=_platform==="netbsd";var _sunos=_platform==="sunos";if(_windows){util4.getCodepage();util4.getPowershell()}function version(){return lib_version}function getStaticData(callback){return new Promise(resolve=>{process.nextTick(()=>{let data={};data.version=version();Promise.all([system.system(),system.bios(),system.baseboard(),system.chassis(),osInfo.osInfo(),osInfo.uuid(),osInfo.versions(),cpu.cpu(),cpu.cpuFlags(),graphics.graphics(),network.networkInterfaces(),memory.memLayout(),filesystem.diskLayout()]).then(res=>{data.system=res[0];data.bios=res[1];data.baseboard=res[2];data.chassis=res[3];data.os=res[4];data.uuid=res[5];data.versions=res[6];data.cpu=res[7];data.cpu.flags=res[8];data.graphics=res[9];data.net=res[10];data.memLayout=res[11];data.diskLayout=res[12];if(callback){callback(data)}resolve(data)})})})}function getDynamicData(srv,iface,callback){if(util4.isFunction(iface)){callback=iface;iface=""}if(util4.isFunction(srv)){callback=srv;srv=""}return new Promise(resolve=>{process.nextTick(()=>{iface=iface||network.getDefaultNetworkInterface();srv=srv||"";let functionProcessed=function(){let totalFunctions=15;if(_windows){totalFunctions=13}if(_freebsd||_openbsd||_netbsd){totalFunctions=11}if(_sunos){totalFunctions=6}return function(){if(--totalFunctions===0){if(callback){callback(data)}resolve(data)}}}();let data={};data.time=osInfo.time();data.node=process.versions.node;data.v8=process.versions.v8;cpu.cpuCurrentSpeed().then(res=>{data.cpuCurrentSpeed=res;functionProcessed()});users.users().then(res=>{data.users=res;functionProcessed()});processes.processes().then(res=>{data.processes=res;functionProcessed()});cpu.currentLoad().then(res=>{data.currentLoad=res;functionProcessed()});if(!_sunos){cpu.cpuTemperature().then(res=>{data.temp=res;functionProcessed()})}if(!_openbsd&&!_freebsd&&!_netbsd&&!_sunos){network.networkStats(iface).then(res=>{data.networkStats=res;functionProcessed()})}if(!_sunos){network.networkConnections().then(res=>{data.networkConnections=res;functionProcessed()})}memory.mem().then(res=>{data.mem=res;functionProcessed()});if(!_sunos){battery().then(res=>{data.battery=res;functionProcessed()})}if(!_sunos){processes.services(srv).then(res=>{data.services=res;functionProcessed()})}if(!_sunos){filesystem.fsSize().then(res=>{data.fsSize=res;functionProcessed()})}if(!_windows&&!_openbsd&&!_freebsd&&!_netbsd&&!_sunos){filesystem.fsStats().then(res=>{data.fsStats=res;functionProcessed()})}if(!_windows&&!_openbsd&&!_freebsd&&!_netbsd&&!_sunos){filesystem.disksIO().then(res=>{data.disksIO=res;functionProcessed()})}if(!_openbsd&&!_freebsd&&!_netbsd&&!_sunos){wifi.wifiNetworks().then(res=>{data.wifiNetworks=res;functionProcessed()})}internet.inetLatency().then(res=>{data.inetLatency=res;functionProcessed()})})})}function getAllData(srv,iface,callback){return new Promise(resolve=>{process.nextTick(()=>{let data={};if(iface&&util4.isFunction(iface)&&!callback){callback=iface;iface=""}if(srv&&util4.isFunction(srv)&&!iface&&!callback){callback=srv;srv="";iface=""}getStaticData().then(res=>{data=res;getDynamicData(srv,iface).then(res2=>{for(let key in res2){if({}.hasOwnProperty.call(res2,key)){data[key]=res2[key]}}if(callback){callback(data)}resolve(data)})})})})}function get4(valueObject,callback){return new Promise(resolve=>{process.nextTick(()=>{const allPromises=Object.keys(valueObject).filter(func=>({}).hasOwnProperty.call(exports2,func)).map(func=>{const params=valueObject[func].substring(valueObject[func].lastIndexOf("(")+1,valueObject[func].lastIndexOf(")"));let funcWithoutParams=func.indexOf(")")>=0?func.split(")")[1].trim():func;funcWithoutParams=func.indexOf("|")>=0?func.split("|")[0].trim():funcWithoutParams;if(params){return exports2[funcWithoutParams](params)}else{return exports2[funcWithoutParams]("")}});Promise.all(allPromises).then(data=>{const result2={};let i=0;for(let key in valueObject){if({}.hasOwnProperty.call(valueObject,key)&&{}.hasOwnProperty.call(exports2,key)&&data.length>i){if(valueObject[key]==="*"||valueObject[key]==="all"){result2[key]=data[i]}else{let keys2=valueObject[key];let filter2="";let filterParts=[];if(keys2.indexOf(")")>=0){keys2=keys2.split(")")[1].trim()}if(keys2.indexOf("|")>=0){filter2=keys2.split("|")[1].trim();filterParts=filter2.split(":");keys2=keys2.split("|")[0].trim()}keys2=keys2.replace(/,/g," ").replace(/ +/g," ").split(" ");if(data[i]){if(Array.isArray(data[i])){const partialArray=[];data[i].forEach(element=>{let partialRes={};if(keys2.length===1&&(keys2[0]==="*"||keys2[0]==="all")){partialRes=element}else{keys2.forEach(k=>{if({}.hasOwnProperty.call(element,k)){partialRes[k]=element[k]}})}if(filter2&&filterParts.length===2){if({}.hasOwnProperty.call(partialRes,filterParts[0].trim())){const val=partialRes[filterParts[0].trim()];if(typeof val=="number"){if(val===parseFloat(filterParts[1].trim())){partialArray.push(partialRes)}}else if(typeof val=="string"){if(val.toLowerCase()===filterParts[1].trim().toLowerCase()){partialArray.push(partialRes)}}}}else{partialArray.push(partialRes)}});result2[key]=partialArray}else{const partialRes={};keys2.forEach(k=>{if({}.hasOwnProperty.call(data[i],k)){partialRes[k]=data[i][k]}});result2[key]=partialRes}}else{result2[key]={}}}i++}}if(callback){callback(result2)}resolve(result2)})})})}function observe(valueObject,interval,callback){let _data=null;const result2=setInterval(()=>{get4(valueObject).then(data=>{if(JSON.stringify(_data)!==JSON.stringify(data)){_data=Object.assign({},data);callback(data)}})},interval);return result2}exports2.version=version;exports2.system=system.system;exports2.bios=system.bios;exports2.baseboard=system.baseboard;exports2.chassis=system.chassis;exports2.time=osInfo.time;exports2.osInfo=osInfo.osInfo;exports2.versions=osInfo.versions;exports2.shell=osInfo.shell;exports2.uuid=osInfo.uuid;exports2.cpu=cpu.cpu;exports2.cpuFlags=cpu.cpuFlags;exports2.cpuCache=cpu.cpuCache;exports2.cpuCurrentSpeed=cpu.cpuCurrentSpeed;exports2.cpuTemperature=cpu.cpuTemperature;exports2.currentLoad=cpu.currentLoad;exports2.fullLoad=cpu.fullLoad;exports2.mem=memory.mem;exports2.memLayout=memory.memLayout;exports2.battery=battery;exports2.graphics=graphics.graphics;exports2.fsSize=filesystem.fsSize;exports2.fsOpenFiles=filesystem.fsOpenFiles;exports2.blockDevices=filesystem.blockDevices;exports2.fsStats=filesystem.fsStats;exports2.disksIO=filesystem.disksIO;exports2.diskLayout=filesystem.diskLayout;exports2.networkInterfaceDefault=network.networkInterfaceDefault;exports2.networkGatewayDefault=network.networkGatewayDefault;exports2.networkInterfaces=network.networkInterfaces;exports2.networkStats=network.networkStats;exports2.networkConnections=network.networkConnections;exports2.wifiNetworks=wifi.wifiNetworks;exports2.wifiInterfaces=wifi.wifiInterfaces;exports2.wifiConnections=wifi.wifiConnections;exports2.services=processes.services;exports2.processes=processes.processes;exports2.processLoad=processes.processLoad;exports2.users=users.users;exports2.inetChecksite=internet.inetChecksite;exports2.inetLatency=internet.inetLatency;exports2.dockerInfo=docker.dockerInfo;exports2.dockerImages=docker.dockerImages;exports2.dockerContainers=docker.dockerContainers;exports2.dockerContainerStats=docker.dockerContainerStats;exports2.dockerContainerProcesses=docker.dockerContainerProcesses;exports2.dockerVolumes=docker.dockerVolumes;exports2.dockerAll=docker.dockerAll;exports2.vboxInfo=vbox.vboxInfo;exports2.printer=printer.printer;exports2.usb=usb.usb;exports2.audio=audio.audio;exports2.bluetoothDevices=bluetooth.bluetoothDevices;exports2.getStaticData=getStaticData;exports2.getDynamicData=getDynamicData;exports2.getAllData=getAllData;exports2.get=get4;exports2.observe=observe;exports2.powerShellStart=util4.powerShellStart;exports2.powerShellRelease=util4.powerShellRelease}});var require_bin=__commonJS({"node_modules/pidtree/lib/bin.js"(exports2,module2){"use strict";var spawn2=require("child_process").spawn;function stripStderr(stderr){if(!stderr)return;stderr=stderr.trim();var regex3=/your \d+x\d+ screen size is bogus\. expect trouble/gi;stderr=stderr.replace(regex3,"");return stderr.trim()}function run(cmd,args2,options,done){if(typeof options==="function"){done=options;options=void 0}var executed=false;var ch=spawn2(cmd,args2,options);var stdout="";var stderr="";ch.stdout.on("data",function(d){stdout+=d.toString()});ch.stderr.on("data",function(d){stderr+=d.toString()});ch.on("error",function(err){if(executed)return;executed=true;done(new Error(err))});ch.on("close",function(code){if(executed)return;executed=true;stderr=stripStderr(stderr);if(stderr){return done(new Error(stderr))}done(null,stdout,code)})}module2.exports=run}});var require_ps=__commonJS({"node_modules/pidtree/lib/ps.js"(exports2,module2){"use strict";var os7=require("os");var bin=require_bin();function ps(callback){var args2=["-A","-o","ppid,pid"];bin("ps",args2,function(err,stdout,code){if(err)return callback(err);if(code!==0){return callback(new Error("pidtree ps command exited with code "+code))}try{stdout=stdout.split(os7.EOL);var list=[];for(var i=1;i<stdout.length;i++){stdout[i]=stdout[i].trim();if(!stdout[i])continue;stdout[i]=stdout[i].split(/\s+/);stdout[i][0]=parseInt(stdout[i][0],10);stdout[i][1]=parseInt(stdout[i][1],10);list.push(stdout[i])}callback(null,list)}catch(error){callback(error)}})}module2.exports=ps}});var require_wmic=__commonJS({"node_modules/pidtree/lib/wmic.js"(exports2,module2){"use strict";var os7=require("os");var bin=require_bin();function wmic(callback){var args2=["PROCESS","get","ParentProcessId,ProcessId"];var options={windowsHide:true,windowsVerbatimArguments:true};bin("wmic",args2,options,function(err,stdout,code){if(err){callback(err);return}if(code!==0){callback(new Error("pidtree wmic command exited with code "+code));return}try{stdout=stdout.split(os7.EOL);var list=[];for(var i=1;i<stdout.length;i++){stdout[i]=stdout[i].trim();if(!stdout[i])continue;stdout[i]=stdout[i].split(/\s+/);stdout[i][0]=parseInt(stdout[i][0],10);stdout[i][1]=parseInt(stdout[i][1],10);list.push(stdout[i])}callback(null,list)}catch(error){callback(error)}})}module2.exports=wmic}});var require_get=__commonJS({"node_modules/pidtree/lib/get.js"(exports2,module2){"use strict";var os7=require("os");var platformToMethod={darwin:"ps",sunos:"ps",freebsd:"ps",netbsd:"ps",win:"wmic",linux:"ps",aix:"ps"};var methodToRequireFn={ps:()=>require_ps(),wmic:()=>require_wmic()};var platform=os7.platform();if(platform.startsWith("win")){platform="win"}var method2=platformToMethod[platform];function get4(callback){if(method2===void 0){callback(new Error(os7.platform()+" is not supported yet, please open an issue (https://github.com/simonepri/pidtree)"))}var list=methodToRequireFn[method2]();list(callback)}module2.exports=get4}});var require_pidtree=__commonJS({"node_modules/pidtree/lib/pidtree.js"(exports2,module2){"use strict";var getAll=require_get();function list(PID,options,callback){if(typeof options==="function"){callback=options;options={}}if(typeof options!=="object"){options={}}PID=parseInt(PID,10);if(isNaN(PID)||PID<-1){callback(new TypeError("The pid provided is invalid"));return}getAll(function(err,list2){if(err){callback(err);return}if(PID===-1){for(var i=0;i<list2.length;i++){list2[i]=options.advanced?{ppid:list2[i][0],pid:list2[i][1]}:list2[i]=list2[i][1]}callback(null,list2);return}var root2;for(var l=0;l<list2.length;l++){if(list2[l][1]===PID){root2=options.advanced?{ppid:list2[l][0],pid:PID}:PID;break}if(list2[l][0]===PID){root2=options.advanced?{pid:PID}:PID}}if(!root2){callback(new Error("No matching pid found"));return}var tree={};while(list2.length>0){var element=list2.pop();if(tree[element[0]]){tree[element[0]].push(element[1])}else{tree[element[0]]=[element[1]]}}var idx=0;var pids=[root2];while(idx<pids.length){var curpid=options.advanced?pids[idx++].pid:pids[idx++];if(!tree[curpid])continue;var length=tree[curpid].length;for(var j=0;j<length;j++){pids.push(options.advanced?{ppid:curpid,pid:tree[curpid][j]}:tree[curpid][j])}delete tree[curpid]}if(!options.root){pids.shift()}callback(null,pids)})}module2.exports=list}});var require_pidtree2=__commonJS({"node_modules/pidtree/index.js"(exports2,module2){"use strict";function pify(fn2,arg1,arg2){return new Promise(function(resolve,reject2){fn2(arg1,arg2,function(err,data){if(err)return reject2(err);resolve(data)})})}if(!String.prototype.startsWith){String.prototype.startsWith=function(suffix){return this.substring(0,suffix.length)===suffix}}var pidtree2=require_pidtree();function list(pid,options,callback){if(typeof options==="function"){callback=options;options=void 0}if(typeof callback==="function"){pidtree2(pid,options,callback);return}return pify(pidtree2,pid,options)}module2.exports=list}});var require_bin2=__commonJS({"node_modules/pidusage/lib/bin.js"(exports2,module2){"use strict";var spawn2=require("child_process").spawn;function run(cmd,args2,options,done){if(typeof options==="function"){done=options;options=void 0}let executed=false;const ch=spawn2(cmd,args2,options);let stdout="";let stderr="";ch.stdout.on("data",function(d){stdout+=d.toString()});ch.stderr.on("data",function(d){stderr+=d.toString()});ch.on("error",function(err){if(executed)return;executed=true;done(new Error(err))});ch.on("close",function(code,signal){if(executed)return;executed=true;if(stderr){return done(new Error(stderr))}done(null,stdout,code)})}module2.exports=run}});var require_history=__commonJS({"node_modules/pidusage/lib/history.js"(exports2,module2){"use strict";var DEFAULT_MAXAGE=6e4;var expiration={};var history={};var expireListeners={};var size2=0;var interval=null;function get4(pid,maxage){if(maxage<=0){return}if(history[pid]!==void 0){expiration[pid]=Date.now()+(maxage||DEFAULT_MAXAGE)}return history[pid]}function set3(pid,object,maxage,onExpire){if(object===void 0||maxage<=0)return;expiration[pid]=Date.now()+(maxage||DEFAULT_MAXAGE);if(history[pid]===void 0){size2++;sheduleInvalidator(maxage)}history[pid]=object;if(onExpire){expireListeners[pid]=onExpire}}function sheduleInvalidator(maxage){if(size2>0){if(interval===null){interval=setInterval(runInvalidator,(maxage||DEFAULT_MAXAGE)/2);if(typeof interval.unref==="function"){interval.unref()}}return}if(interval!==null){clearInterval(interval);interval=null}}function runInvalidator(){const now3=Date.now();const pids=Object.keys(expiration);for(let i=0;i<pids.length;i++){const pid=pids[i];if(expiration[pid]<now3){size2--;if(expireListeners[pid]){expireListeners[pid](history[pid])}delete history[pid];delete expiration[pid];delete expireListeners[pid]}}sheduleInvalidator()}function deleteLoop(obj){for(const i in obj){delete obj[i]}}function clear(){if(interval!==null){clearInterval(interval);interval=null}deleteLoop(history);deleteLoop(expiration);deleteLoop(expireListeners)}module2.exports={get:get4,set:set3,clear}}});var require_ps2=__commonJS({"node_modules/pidusage/lib/ps.js"(exports2,module2){"use strict";var os7=require("os");var bin=require_bin2();var history=require_history();var PLATFORM=os7.platform();function parseTime(timestr,centisec){let time=0;const tpart=timestr.split(/-|:|\./);let i=tpart.length-1;if(i>=0&&centisec&&PLATFORM==="darwin"){time+=parseInt(tpart[i--],10)*10}if(i>=0){time+=parseInt(tpart[i--],10)*1e3}if(i>=0){time+=parseInt(tpart[i--],10)*6e4}if(i>=0){time+=parseInt(tpart[i--],10)*36e5}if(i>=0){time+=parseInt(tpart[i--],10)*864e5}return time}function ps(pids,options,done){const pArg=pids.join(",");let args2=["-o","etime,pid,ppid,pcpu,rss,time","-p",pArg];if(PLATFORM==="aix"||PLATFORM==="os400"){args2=["-o","etime,pid,ppid,pcpu,rssize,time","-p",pArg]}bin("ps",args2,function(err,stdout,code){if(err){if(PLATFORM==="os390"&&/no matching processes found/.test(err)){err=new Error("No matching pid found");err.code="ENOENT"}return done(err)}if(code===1){const error=new Error("No matching pid found");error.code="ENOENT";return done(error)}if(code!==0){return done(new Error("pidusage ps command exited with code "+code))}const date=Date.now();stdout=stdout.split(os7.EOL);const statistics={};for(let i=1;i<stdout.length;i++){const line=stdout[i].trim().split(/\s+/);if(!line||line.length!==6){continue}const pid=parseInt(line[1],10);let hst=history.get(pid,options.maxage);if(hst===void 0)hst={};const ppid=parseInt(line[2],10);const memory=parseInt(line[4],10)*1024;const etime=parseTime(line[0]);const ctime=parseTime(line[5],true);const total=ctime-(hst.ctime||0);const seconds=Math.abs(hst.elapsed!==void 0?etime-hst.elapsed:etime);const cpu=seconds>0?total/seconds*100:0;statistics[pid]={cpu,memory,ppid,pid,ctime,elapsed:etime,timestamp:date};history.set(pid,statistics[pid],options.maxage)}done(null,statistics)})}module2.exports=ps}});var require_parallel=__commonJS({"node_modules/pidusage/lib/helpers/parallel.js"(exports2,module2){function parallel(fns,options,done){if(typeof options==="function"){done=options;options={}}let keys2;if(!Array.isArray(fns)){keys2=Object.keys(fns)}const length=keys2?keys2.length:fns.length;let pending=length;const results=keys2?{}:[];function each(i,err,result2){results[i]=result2;if(--pending===0||err&&!options.graceful){if(options.graceful&&err&&length>1){err=null}done&&done(err,results);done=null}}if(keys2){keys2.forEach(function(key){fns[key](function(err,res){each(key,err,res)})})}else{fns.forEach(function(fn2,i){fn2(function(err,res){each(i,err,res)})})}}module2.exports=parallel}});var require_cpu2=__commonJS({"node_modules/pidusage/lib/helpers/cpu.js"(exports2,module2){var os7=require("os");var fs14=require("fs");var exec3=require("child_process").exec;var parallel=require_parallel();function updateCpu(cpu,next){if(cpu!==null){getRealUptime(function(err,uptime){if(err)return next(err);cpu.uptime=uptime;next(null,cpu)});return}parallel([getClockAndPageSize,getRealUptime],function(err,data){if(err)return next(err);cpu={clockTick:data[0].clockTick,pageSize:data[0].pageSize,uptime:data[1]};next(null,cpu)})}module2.exports=updateCpu;function getRealUptime(next){fs14.readFile("/proc/uptime","utf8",function(err,uptime){if(err||uptime===void 0){if(!process.env.PIDUSAGE_SILENT){console.warn("[pidusage] We couldn't find uptime from /proc/uptime, using os.uptime() value")}return next(null,os7.uptime()||new Date/1e3)}return next(null,parseFloat(uptime.split(" ")[0]))})}function getClockAndPageSize(next){parallel([function getClockTick(cb){getconf("CLK_TCK",{default:100},cb)},function getPageSize(cb){getconf("PAGESIZE",{default:4096},cb)}],function(err,data){if(err)return next(err);next(null,{clockTick:data[0],pageSize:data[1]})})}function getconf(keyword,options,next){if(typeof options==="function"){next=options;options={default:""}}exec3("getconf "+keyword,function(error,stdout,stderr){if(error!==null){if(!process.env.PIDUSAGE_SILENT){console.error('Error while calling "getconf '+keyword+'"',error)}return next(null,options.default)}stdout=parseInt(stdout);if(!isNaN(stdout)){return next(null,stdout)}return next(null,options.default)})}}});var require_safe_buffer=__commonJS({"node_modules/safe-buffer/index.js"(exports2,module2){var buffer=require("buffer");var Buffer12=buffer.Buffer;function copyProps(src,dst){for(var key in src){dst[key]=src[key]}}if(Buffer12.from&&Buffer12.alloc&&Buffer12.allocUnsafe&&Buffer12.allocUnsafeSlow){module2.exports=buffer}else{copyProps(buffer,exports2);exports2.Buffer=SafeBuffer}function SafeBuffer(arg,encodingOrOffset,length){return Buffer12(arg,encodingOrOffset,length)}SafeBuffer.prototype=Object.create(Buffer12.prototype);copyProps(Buffer12,SafeBuffer);SafeBuffer.from=function(arg,encodingOrOffset,length){if(typeof arg==="number"){throw new TypeError("Argument must not be a number")}return Buffer12(arg,encodingOrOffset,length)};SafeBuffer.alloc=function(size2,fill2,encoding){if(typeof size2!=="number"){throw new TypeError("Argument must be a number")}var buf=Buffer12(size2);if(fill2!==void 0){if(typeof encoding==="string"){buf.fill(fill2,encoding)}else{buf.fill(fill2)}}else{buf.fill(0)}return buf};SafeBuffer.allocUnsafe=function(size2){if(typeof size2!=="number"){throw new TypeError("Argument must be a number")}return Buffer12(size2)};SafeBuffer.allocUnsafeSlow=function(size2){if(typeof size2!=="number"){throw new TypeError("Argument must be a number")}return buffer.SlowBuffer(size2)}}});var require_procfile=__commonJS({"node_modules/pidusage/lib/procfile.js"(exports2,module2){var fs14=require("fs");var path27=require("path");var updateCpu=require_cpu2();var parallel=require_parallel();var history=require_history();var cpuInfo=null;var Buffer12=require_safe_buffer().Buffer;var SIZE=1024;function noop4(){}function open4(path28,history2,cb){if(history2.fd){return cb(null,history2.fd)}fs14.open(path28,"r",cb)}function close(history2){if(history2.fd){fs14.close(history2.fd,noop4)}}function readUntilEnd(fd,buf,cb){let firstRead=false;if(typeof buf==="function"){cb=buf;buf=Buffer12.alloc(SIZE);firstRead=true}fs14.read(fd,buf,0,SIZE,0,function(err,bytesRead,buffer){if(err){cb(err);return}const data=Buffer12.concat([buf,buffer],firstRead?bytesRead:buf.length+bytesRead);if(bytesRead===SIZE){readUntilEnd(fd,data,cb);return}cb(null,buf)})}function readProcFile(pid,options,done){let hst=history.get(pid,options.maxage);let again=false;if(hst===void 0){again=true;hst={}}open4(path27.join("/proc",""+pid,"stat"),hst,function(err,fd){if(err){if(err.code==="ENOENT"){err.message="No matching pid found"}return done(err,null)}if(err){return done(err)}readUntilEnd(fd,function(err2,buffer){if(err2){return done(err2)}let infos=buffer.toString("utf8");const date=Date.now();const index=infos.lastIndexOf(")");infos=infos.substr(index+2).split(" ");const stat3={ppid:parseInt(infos[1]),utime:parseFloat(infos[11])*1e3/cpuInfo.clockTick,stime:parseFloat(infos[12])*1e3/cpuInfo.clockTick,cutime:parseFloat(infos[13])*1e3/cpuInfo.clockTick,cstime:parseFloat(infos[14])*1e3/cpuInfo.clockTick,start:parseFloat(infos[19])*1e3/cpuInfo.clockTick,rss:parseFloat(infos[21]),uptime:cpuInfo.uptime*1e3,fd};const memory=stat3.rss*cpuInfo.pageSize;const childrens=options.childrens?stat3.cutime+stat3.cstime:0;const total=stat3.stime-(hst.stime||0)+stat3.utime-(hst.utime||0)+childrens;const seconds=Math.abs(hst.uptime!==void 0?stat3.uptime-hst.uptime:stat3.start-stat3.uptime);const cpu=seconds>0?total/seconds*100:0;history.set(pid,stat3,options.maxage,close);if(again){return readProcFile(pid,options,done)}return done(null,{cpu,memory,ctime:stat3.utime+stat3.stime,elapsed:stat3.uptime-stat3.start,timestamp:date,pid,ppid:stat3.ppid})})})}function procfile(pids,options,done){updateCpu(cpuInfo,function(err,result2){if(err)return done(err);cpuInfo=result2;const fns={};pids.forEach(function(pid,i){fns[pid]=function(cb){readProcFile(pid,options,cb)}});parallel(fns,{graceful:true},done)})}module2.exports=procfile}});var require_wmic2=__commonJS({"node_modules/pidusage/lib/wmic.js"(exports2,module2){"use strict";var os7=require("os");var bin=require_bin2();var history=require_history();function parseDate(datestr){const year=datestr.substring(0,4);const month=datestr.substring(4,6);const day=datestr.substring(6,8);const hour=datestr.substring(8,10);const minutes=datestr.substring(10,12);const seconds=datestr.substring(12,14);const useconds=datestr.substring(15,21);const sign=datestr.substring(21,22);const tmz=parseInt(datestr.substring(22,25),10);const tmzh=Math.floor(tmz/60);const tmzm=tmz%60;return new Date(year+"-"+month+"-"+day+"T"+hour+":"+minutes+":"+seconds+"."+useconds+sign+(tmzh>9?tmzh:"0"+tmzh)+(tmzm>9?tmzm:"0"+tmzm))}function wmic(pids,options,done){let whereClause="ProcessId="+pids[0];for(let i=1;i<pids.length;i++){whereClause+=" or ProcessId="+pids[i]}const args2=["PROCESS","where",'"'+whereClause+'"',"get","CreationDate,KernelModeTime,ParentProcessId,ProcessId,UserModeTime,WorkingSetSize"];bin("wmic",args2,{windowsHide:true,windowsVerbatimArguments:true},function(err,stdout,code){if(err){if(err.message.indexOf("No Instance(s) Available.")!==-1){const error=new Error("No matching pid found");error.code="ENOENT";return done(error)}return done(err)}if(code!==0){return done(new Error("pidusage wmic command exited with code "+code))}const date=Date.now();const uptime=Math.floor(os7.uptime()||date/1e3);stdout=stdout.split(os7.EOL);let again=false;const statistics={};for(let i=1;i<stdout.length;i++){const line=stdout[i].trim().split(/\s+/);if(!line||line.length!==6){continue}const creation=parseDate(line[0]);const ppid=parseInt(line[2],10);const pid=parseInt(line[3],10);const kerneltime=Math.round(parseInt(line[1],10)/1e4);const usertime=Math.round(parseInt(line[4],10)/1e4);const memory=parseInt(line[5],10);let hst=history.get(pid,options.maxage);if(hst===void 0){again=true;hst={ctime:kerneltime+usertime,uptime}}const total=(kerneltime+usertime-hst.ctime)/1e3;const seconds=uptime-hst.uptime;const cpu=seconds>0?total/seconds*100:0;history.set(pid,{ctime:usertime+kerneltime,uptime},options.maxage);statistics[pid]={cpu,memory,ppid,pid,ctime:usertime+kerneltime,elapsed:date-creation.getTime(),timestamp:date}}if(again){return wmic(pids,options,function(err2,stats){if(err2)return done(err2);done(null,Object.assign(statistics,stats))})}done(null,statistics)})}module2.exports=wmic}});var require_stats=__commonJS({"node_modules/pidusage/lib/stats.js"(exports2,module2){"use strict";var fs14=require("fs");var os7=require("os");var requireMap={ps:()=>require_ps2(),procfile:()=>require_procfile(),wmic:()=>require_wmic2()};var platformToMethod={aix:"ps",os400:"ps",android:"procfile",alpine:"procfile",darwin:"ps",freebsd:"ps",os390:"ps",linux:"procfile",netbsd:"procfile",openbsd:"ps",sunos:"ps",win:"wmic"};var platform=os7.platform();if(fs14.existsSync("/etc/alpine-release")){platform="alpine"}if(platform.match(/^win/)){platform="win"}var stat3;try{stat3=requireMap[platformToMethod[platform]]()}catch(err){}function get4(pids,options,callback){let fn2=stat3;if(platform!=="win"&&options.usePs===true){fn2=requireMap.ps()}if(fn2===void 0){return callback(new Error(os7.platform()+" is not supported yet, please open an issue (https://github.com/soyuka/pidusage)"))}let single=false;if(!Array.isArray(pids)){single=true;pids=[pids]}if(pids.length===0){return callback(new TypeError("You must provide at least one pid"))}for(let i=0;i<pids.length;i++){pids[i]=parseInt(pids[i],10);if(isNaN(pids[i])||pids[i]<0){return callback(new TypeError("One of the pids provided is invalid"))}}fn2(pids,options,function(err,stats){if(err){return callback(err)}if(single){callback(null,stats[pids[0]])}else{callback(null,stats)}})}module2.exports=get4}});var require_pidusage=__commonJS({"node_modules/pidusage/index.js"(exports2,module2){"use strict";var stats=require_stats();function pidusage3(pids,options,callback){if(typeof options==="function"){callback=options;options={}}if(options===void 0){options={}}options=Object.assign({usePs:/^true$/i.test(process.env.PIDUSAGE_USE_PS),maxage:process.env.PIDUSAGE_MAXAGE},options);if(typeof callback==="function"){stats(pids,options,callback);return}return new Promise(function(resolve,reject2){stats(pids,options,function(err,data){if(err)return reject2(err);resolve(data)})})}module2.exports=pidusage3;module2.exports.clear=require_history().clear}});var require_bytes=__commonJS({"node_modules/bytes/index.js"(exports2,module2){"use strict";module2.exports=bytes9;module2.exports.format=format2;module2.exports.parse=parse3;var formatThousandsRegExp=/\B(?=(\d{3})+(?!\d))/g;var formatDecimalsRegExp=/(?:\.0*|(\.[^0]+)0+)$/;var map3={b:1,kb:1<<10,mb:1<<20,gb:1<<30,tb:Math.pow(1024,4),pb:Math.pow(1024,5)};var parseRegExp=/^((-|\+)?(\d+(?:\.\d+)?)) *(kb|mb|gb|tb|pb)$/i;function bytes9(value,options){if(typeof value==="string"){return parse3(value)}if(typeof value==="number"){return format2(value,options)}return null}function format2(value,options){if(!Number.isFinite(value)){return null}var mag=Math.abs(value);var thousandsSeparator=options&&options.thousandsSeparator||"";var unitSeparator=options&&options.unitSeparator||"";var decimalPlaces=options&&options.decimalPlaces!==void 0?options.decimalPlaces:2;var fixedDecimals=Boolean(options&&options.fixedDecimals);var unit=options&&options.unit||"";if(!unit||!map3[unit.toLowerCase()]){if(mag>=map3.pb){unit="PB"}else if(mag>=map3.tb){unit="TB"}else if(mag>=map3.gb){unit="GB"}else if(mag>=map3.mb){unit="MB"}else if(mag>=map3.kb){unit="KB"}else{unit="B"}}var val=value/map3[unit.toLowerCase()];var str2=val.toFixed(decimalPlaces);if(!fixedDecimals){str2=str2.replace(formatDecimalsRegExp,"$1")}if(thousandsSeparator){str2=str2.split(".").map(function(s,i){return i===0?s.replace(formatThousandsRegExp,thousandsSeparator):s}).join(".")}return str2+unitSeparator+unit}function parse3(val){if(typeof val==="number"&&!isNaN(val)){return val}if(typeof val!=="string"){return null}var results=parseRegExp.exec(val);var floatValue;var unit="b";if(!results){floatValue=parseInt(val,10);unit="b"}else{floatValue=parseFloat(results[1]);unit=results[4].toLowerCase()}if(isNaN(floatValue)){return null}return Math.floor(map3[unit]*floatValue)}}});var require_eastasianwidth=__commonJS({"node_modules/eastasianwidth/eastasianwidth.js"(exports2,module2){var eaw={};if("undefined"==typeof module2){window.eastasianwidth=eaw}else{module2.exports=eaw}eaw.eastAsianWidth=function(character){var x=character.charCodeAt(0);var y=character.length==2?character.charCodeAt(1):0;var codePoint=x;if(55296<=x&&x<=56319&&(56320<=y&&y<=57343)){x&=1023;y&=1023;codePoint=x<<10|y;codePoint+=65536}if(12288==codePoint||65281<=codePoint&&codePoint<=65376||65504<=codePoint&&codePoint<=65510){return"F"}if(8361==codePoint||65377<=codePoint&&codePoint<=65470||65474<=codePoint&&codePoint<=65479||65482<=codePoint&&codePoint<=65487||65490<=codePoint&&codePoint<=65495||65498<=codePoint&&codePoint<=65500||65512<=codePoint&&codePoint<=65518){return"H"}if(4352<=codePoint&&codePoint<=4447||4515<=codePoint&&codePoint<=4519||4602<=codePoint&&codePoint<=4607||9001<=codePoint&&codePoint<=9002||11904<=codePoint&&codePoint<=11929||11931<=codePoint&&codePoint<=12019||12032<=codePoint&&codePoint<=12245||12272<=codePoint&&codePoint<=12283||12289<=codePoint&&codePoint<=12350||12353<=codePoint&&codePoint<=12438||12441<=codePoint&&codePoint<=12543||12549<=codePoint&&codePoint<=12589||12593<=codePoint&&codePoint<=12686||12688<=codePoint&&codePoint<=12730||12736<=codePoint&&codePoint<=12771||12784<=codePoint&&codePoint<=12830||12832<=codePoint&&codePoint<=12871||12880<=codePoint&&codePoint<=13054||13056<=codePoint&&codePoint<=19903||19968<=codePoint&&codePoint<=42124||42128<=codePoint&&codePoint<=42182||43360<=codePoint&&codePoint<=43388||44032<=codePoint&&codePoint<=55203||55216<=codePoint&&codePoint<=55238||55243<=codePoint&&codePoint<=55291||63744<=codePoint&&codePoint<=64255||65040<=codePoint&&codePoint<=65049||65072<=codePoint&&codePoint<=65106||65108<=codePoint&&codePoint<=65126||65128<=codePoint&&codePoint<=65131||110592<=codePoint&&codePoint<=110593||127488<=codePoint&&codePoint<=127490||127504<=codePoint&&codePoint<=127546||127552<=codePoint&&codePoint<=127560||127568<=codePoint&&codePoint<=127569||131072<=codePoint&&codePoint<=194367||177984<=codePoint&&codePoint<=196605||196608<=codePoint&&codePoint<=262141){return"W"}if(32<=codePoint&&codePoint<=126||162<=codePoint&&codePoint<=163||165<=codePoint&&codePoint<=166||172==codePoint||175==codePoint||10214<=codePoint&&codePoint<=10221||10629<=codePoint&&codePoint<=10630){return"Na"}if(161==codePoint||164==codePoint||167<=codePoint&&codePoint<=168||170==codePoint||173<=codePoint&&codePoint<=174||176<=codePoint&&codePoint<=180||182<=codePoint&&codePoint<=186||188<=codePoint&&codePoint<=191||198==codePoint||208==codePoint||215<=codePoint&&codePoint<=216||222<=codePoint&&codePoint<=225||230==codePoint||232<=codePoint&&codePoint<=234||236<=codePoint&&codePoint<=237||240==codePoint||242<=codePoint&&codePoint<=243||247<=codePoint&&codePoint<=250||252==codePoint||254==codePoint||257==codePoint||273==codePoint||275==codePoint||283==codePoint||294<=codePoint&&codePoint<=295||299==codePoint||305<=codePoint&&codePoint<=307||312==codePoint||319<=codePoint&&codePoint<=322||324==codePoint||328<=codePoint&&codePoint<=331||333==codePoint||338<=codePoint&&codePoint<=339||358<=codePoint&&codePoint<=359||363==codePoint||462==codePoint||464==codePoint||466==codePoint||468==codePoint||470==codePoint||472==codePoint||474==codePoint||476==codePoint||593==codePoint||609==codePoint||708==codePoint||711==codePoint||713<=codePoint&&codePoint<=715||717==codePoint||720==codePoint||728<=codePoint&&codePoint<=731||733==codePoint||735==codePoint||768<=codePoint&&codePoint<=879||913<=codePoint&&codePoint<=929||931<=codePoint&&codePoint<=937||945<=codePoint&&codePoint<=961||963<=codePoint&&codePoint<=969||1025==codePoint||1040<=codePoint&&codePoint<=1103||1105==codePoint||8208==codePoint||8211<=codePoint&&codePoint<=8214||8216<=codePoint&&codePoint<=8217||8220<=codePoint&&codePoint<=8221||8224<=codePoint&&codePoint<=8226||8228<=codePoint&&codePoint<=8231||8240==codePoint||8242<=codePoint&&codePoint<=8243||8245==codePoint||8251==codePoint||8254==codePoint||8308==codePoint||8319==codePoint||8321<=codePoint&&codePoint<=8324||8364==codePoint||8451==codePoint||8453==codePoint||8457==codePoint||8467==codePoint||8470==codePoint||8481<=codePoint&&codePoint<=8482||8486==codePoint||8491==codePoint||8531<=codePoint&&codePoint<=8532||8539<=codePoint&&codePoint<=8542||8544<=codePoint&&codePoint<=8555||8560<=codePoint&&codePoint<=8569||8585==codePoint||8592<=codePoint&&codePoint<=8601||8632<=codePoint&&codePoint<=8633||8658==codePoint||8660==codePoint||8679==codePoint||8704==codePoint||8706<=codePoint&&codePoint<=8707||8711<=codePoint&&codePoint<=8712||8715==codePoint||8719==codePoint||8721==codePoint||8725==codePoint||8730==codePoint||8733<=codePoint&&codePoint<=8736||8739==codePoint||8741==codePoint||8743<=codePoint&&codePoint<=8748||8750==codePoint||8756<=codePoint&&codePoint<=8759||8764<=codePoint&&codePoint<=8765||8776==codePoint||8780==codePoint||8786==codePoint||8800<=codePoint&&codePoint<=8801||8804<=codePoint&&codePoint<=8807||8810<=codePoint&&codePoint<=8811||8814<=codePoint&&codePoint<=8815||8834<=codePoint&&codePoint<=8835||8838<=codePoint&&codePoint<=8839||8853==codePoint||8857==codePoint||8869==codePoint||8895==codePoint||8978==codePoint||9312<=codePoint&&codePoint<=9449||9451<=codePoint&&codePoint<=9547||9552<=codePoint&&codePoint<=9587||9600<=codePoint&&codePoint<=9615||9618<=codePoint&&codePoint<=9621||9632<=codePoint&&codePoint<=9633||9635<=codePoint&&codePoint<=9641||9650<=codePoint&&codePoint<=9651||9654<=codePoint&&codePoint<=9655||9660<=codePoint&&codePoint<=9661||9664<=codePoint&&codePoint<=9665||9670<=codePoint&&codePoint<=9672||9675==codePoint||9678<=codePoint&&codePoint<=9681||9698<=codePoint&&codePoint<=9701||9711==codePoint||9733<=codePoint&&codePoint<=9734||9737==codePoint||9742<=codePoint&&codePoint<=9743||9748<=codePoint&&codePoint<=9749||9756==codePoint||9758==codePoint||9792==codePoint||9794==codePoint||9824<=codePoint&&codePoint<=9825||9827<=codePoint&&codePoint<=9829||9831<=codePoint&&codePoint<=9834||9836<=codePoint&&codePoint<=9837||9839==codePoint||9886<=codePoint&&codePoint<=9887||9918<=codePoint&&codePoint<=9919||9924<=codePoint&&codePoint<=9933||9935<=codePoint&&codePoint<=9953||9955==codePoint||9960<=codePoint&&codePoint<=9983||10045==codePoint||10071==codePoint||10102<=codePoint&&codePoint<=10111||11093<=codePoint&&codePoint<=11097||12872<=codePoint&&codePoint<=12879||57344<=codePoint&&codePoint<=63743||65024<=codePoint&&codePoint<=65039||65533==codePoint||127232<=codePoint&&codePoint<=127242||127248<=codePoint&&codePoint<=127277||127280<=codePoint&&codePoint<=127337||127344<=codePoint&&codePoint<=127386||917760<=codePoint&&codePoint<=917999||983040<=codePoint&&codePoint<=1048573||1048576<=codePoint&&codePoint<=1114109){return"A"}return"N"};eaw.characterLength=function(character){var code=this.eastAsianWidth(character);if(code=="F"||code=="W"||code=="A"){return 2}else{return 1}};function stringToArray2(string){return string.match(/[\uD800-\uDBFF][\uDC00-\uDFFF]|[^\uD800-\uDFFF]/g)||[]}eaw.length=function(string){var characters=stringToArray2(string);var len=0;for(var i=0;i<characters.length;i++){len=len+this.characterLength(characters[i])}return len};eaw.slice=function(text,start,end){textLen=eaw.length(text);start=start?start:0;end=end?end:1;if(start<0){start=textLen+start}if(end<0){end=textLen+end}var result2="";var eawLen=0;var chars=stringToArray2(text);for(var i=0;i<chars.length;i++){var char=chars[i];var charLen=eaw.length(char);if(eawLen>=start-(charLen==2?1:0)){if(eawLen+charLen<=end){result2+=char}else{break}}eawLen+=charLen}return result2}}});var require_emoji_regex=__commonJS({"node_modules/emoji-regex/index.js"(exports2,module2){"use strict";module2.exports=function(){return/\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67)\uDB40\uDC7F|(?:\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFC-\uDFFF])|\uD83D\uDC68(?:\uD83C\uDFFB(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|[\u2695\u2696\u2708]\uFE0F|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))?|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])\uFE0F|\u200D(?:(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D[\uDC66\uDC67])|\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC)?|(?:\uD83D\uDC69(?:\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69]))|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC69(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83E\uDDD1(?:\u200D(?:\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDE36\u200D\uD83C\uDF2B|\uD83C\uDFF3\uFE0F\u200D\u26A7|\uD83D\uDC3B\u200D\u2744|(?:(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\uD83C\uDFF4\u200D\u2620|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])\u200D[\u2640\u2642]|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u2600-\u2604\u260E\u2611\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26B0\u26B1\u26C8\u26CF\u26D1\u26D3\u26E9\u26F0\u26F1\u26F4\u26F7\u26F8\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u3030\u303D\u3297\u3299]|\uD83C[\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]|\uD83D[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3])\uFE0F|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDE35\u200D\uD83D\uDCAB|\uD83D\uDE2E\u200D\uD83D\uDCA8|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83E\uDDD1(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83D\uDC69(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF6\uD83C\uDDE6|\uD83C\uDDF4\uD83C\uDDF2|\uD83D\uDC08\u200D\u2B1B|\u2764\uFE0F\u200D(?:\uD83D\uDD25|\uD83E\uDE79)|\uD83D\uDC41\uFE0F|\uD83C\uDFF3\uFE0F|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|[#\*0-9]\uFE0F\u20E3|\u2764\uFE0F|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|\uD83C\uDFF4|(?:[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270C\u270D]|\uD83D[\uDD74\uDD90])(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC08\uDC15\uDC3B\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE2E\uDE35\uDE36\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5]|\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD]|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF]|[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0D\uDD0E\uDD10-\uDD17\uDD1D\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78\uDD7A-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCB\uDDD0\uDDE0-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6]|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26A7\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5-\uDED7\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDD77\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g}}});var require_boxes=__commonJS({"node_modules/cli-boxes/boxes.json"(exports2,module2){module2.exports={single:{topLeft:"┌",top:"─",topRight:"┐",right:"│",bottomRight:"┘",bottom:"─",bottomLeft:"└",left:"│"},double:{topLeft:"╔",top:"═",topRight:"╗",right:"║",bottomRight:"╝",bottom:"═",bottomLeft:"╚",left:"║"},round:{topLeft:"╭",top:"─",topRight:"╮",right:"│",bottomRight:"╯",bottom:"─",bottomLeft:"╰",left:"│"},bold:{topLeft:"┏",top:"━",topRight:"┓",right:"┃",bottomRight:"┛",bottom:"━",bottomLeft:"┗",left:"┃"},singleDouble:{topLeft:"╓",top:"─",topRight:"╖",right:"║",bottomRight:"╜",bottom:"─",bottomLeft:"╙",left:"║"},doubleSingle:{topLeft:"╒",top:"═",topRight:"╕",right:"│",bottomRight:"╛",bottom:"═",bottomLeft:"╘",left:"│"},classic:{topLeft:"+",top:"-",topRight:"+",right:"|",bottomRight:"+",bottom:"-",bottomLeft:"+",left:"|"},arrow:{topLeft:"↘",top:"↓",topRight:"↙",right:"←",bottomRight:"↖",bottom:"↑",bottomLeft:"↗",left:"→"}}}});var require_cli_boxes=__commonJS({"node_modules/cli-boxes/index.js"(exports2,module2){"use strict";var cliBoxes2=require_boxes();module2.exports=cliBoxes2;module2.exports.default=cliBoxes2}});var require_ansi_regex=__commonJS({"node_modules/ansi-regex/index.js"(exports2,module2){"use strict";module2.exports=({onlyFirst=false}={})=>{const pattern=["[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)","(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"].join("|");return new RegExp(pattern,onlyFirst?void 0:"g")}}});var require_strip_ansi=__commonJS({"node_modules/strip-ansi/index.js"(exports2,module2){"use strict";var ansiRegex3=require_ansi_regex();module2.exports=string=>typeof string==="string"?string.replace(ansiRegex3(),""):string}});var require_is_fullwidth_code_point=__commonJS({"node_modules/is-fullwidth-code-point/index.js"(exports2,module2){"use strict";var isFullwidthCodePoint=codePoint=>{if(Number.isNaN(codePoint)){return false}if(codePoint>=4352&&(codePoint<=4447||codePoint===9001||codePoint===9002||11904<=codePoint&&codePoint<=12871&&codePoint!==12351||12880<=codePoint&&codePoint<=19903||19968<=codePoint&&codePoint<=42182||43360<=codePoint&&codePoint<=43388||44032<=codePoint&&codePoint<=55203||63744<=codePoint&&codePoint<=64255||65040<=codePoint&&codePoint<=65049||65072<=codePoint&&codePoint<=65131||65281<=codePoint&&codePoint<=65376||65504<=codePoint&&codePoint<=65510||110592<=codePoint&&codePoint<=110593||127488<=codePoint&&codePoint<=127569||131072<=codePoint&&codePoint<=262141)){return true}return false};module2.exports=isFullwidthCodePoint;module2.exports.default=isFullwidthCodePoint}});var require_emoji_regex2=__commonJS({"node_modules/ansi-align/node_modules/emoji-regex/index.js"(exports2,module2){"use strict";module2.exports=function(){return/\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F|\uD83D\uDC68(?:\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|[\u2695\u2696\u2708]\uFE0F|\uD83D[\uDC66\uDC67]|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708])\uFE0F|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C[\uDFFB-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)\uD83C\uDFFB|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])|\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)(?:\uD83C[\uDFFB\uDFFC])|\uD83D\uDC69(?:\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)(?:\uD83C[\uDFFB-\uDFFD])|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|(?:(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)\uFE0F|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD6-\uDDDD])(?:(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\u200D[\u2640\u2642])|\uD83C\uDFF4\u200D\u2620)\uFE0F|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF4\uD83C\uDDF2|\uD83C\uDDF6\uD83C\uDDE6|[#\*0-9]\uFE0F\u20E3|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83D\uDC69(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270A-\u270D]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC70\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDCAA\uDD74\uDD7A\uDD90\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD36\uDDB5\uDDB6\uDDBB\uDDD2-\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5\uDEEB\uDEEC\uDEF4-\uDEFA\uDFE0-\uDFEB]|\uD83E[\uDD0D-\uDD3A\uDD3C-\uDD45\uDD47-\uDD71\uDD73-\uDD76\uDD7A-\uDDA2\uDDA5-\uDDAA\uDDAE-\uDDCA\uDDCD-\uDDFF\uDE70-\uDE73\uDE78-\uDE7A\uDE80-\uDE82\uDE90-\uDE95])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFA\uDFE0-\uDFEB]|\uD83E[\uDD0D-\uDD3A\uDD3C-\uDD45\uDD47-\uDD71\uDD73-\uDD76\uDD7A-\uDDA2\uDDA5-\uDDAA\uDDAE-\uDDCA\uDDCD-\uDDFF\uDE70-\uDE73\uDE78-\uDE7A\uDE80-\uDE82\uDE90-\uDE95])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g}}});var require_string_width=__commonJS({"node_modules/ansi-align/node_modules/string-width/index.js"(exports2,module2){"use strict";var stripAnsi3=require_strip_ansi();var isFullwidthCodePoint=require_is_fullwidth_code_point();var emojiRegex3=require_emoji_regex2();var stringWidth2=string=>{if(typeof string!=="string"||string.length===0){return 0}string=stripAnsi3(string);if(string.length===0){return 0}string=string.replace(emojiRegex3(),"  ");let width=0;for(let i=0;i<string.length;i++){const code=string.codePointAt(i);if(code<=31||code>=127&&code<=159){continue}if(code>=768&&code<=879){continue}if(code>65535){i++}width+=isFullwidthCodePoint(code)?2:1}return width};module2.exports=stringWidth2;module2.exports.default=stringWidth2}});var require_ansi_align=__commonJS({"node_modules/ansi-align/index.js"(exports2,module2){"use strict";var stringWidth2=require_string_width();function ansiAlign2(text,opts){if(!text)return text;opts=opts||{};const align=opts.align||"center";if(align==="left")return text;const split2=opts.split||"\n";const pad4=opts.pad||" ";const widthDiffFn=align!=="right"?halfDiff:fullDiff;let returnString=false;if(!Array.isArray(text)){returnString=true;text=String(text).split(split2)}let width;let maxWidth=0;text=text.map(function(str2){str2=String(str2);width=stringWidth2(str2);maxWidth=Math.max(width,maxWidth);return{str:str2,width}}).map(function(obj){return new Array(widthDiffFn(maxWidth,obj.width)+1).join(pad4)+obj.str});return returnString?text.join(split2):text}ansiAlign2.left=function left(text){return ansiAlign2(text,{align:"left"})};ansiAlign2.center=function center(text){return ansiAlign2(text,{align:"center"})};ansiAlign2.right=function right(text){return ansiAlign2(text,{align:"right"})};module2.exports=ansiAlign2;function halfDiff(maxWidth,curWidth){return Math.floor((maxWidth-curWidth)/2)}function fullDiff(maxWidth,curWidth){return maxWidth-curWidth}}});var require_is_docker=__commonJS({"node_modules/is-docker/index.js"(exports2,module2){"use strict";var fs14=require("fs");var isDocker;function hasDockerEnv(){try{fs14.statSync("/.dockerenv");return true}catch(_){return false}}function hasDockerCGroup(){try{return fs14.readFileSync("/proc/self/cgroup","utf8").includes("docker")}catch(_){return false}}module2.exports=()=>{if(isDocker===void 0){isDocker=hasDockerEnv()||hasDockerCGroup()}return isDocker}}});var require_is_wsl=__commonJS({"node_modules/is-wsl/index.js"(exports2,module2){"use strict";var os7=require("os");var fs14=require("fs");var isDocker=require_is_docker();var isWsl=()=>{if(process.platform!=="linux"){return false}if(os7.release().toLowerCase().includes("microsoft")){if(isDocker()){return false}return true}try{return fs14.readFileSync("/proc/version","utf8").toLowerCase().includes("microsoft")?!isDocker():false}catch(_){return false}};if(process.env.__IS_WSL_TEST__){module2.exports=isWsl}else{module2.exports=isWsl()}}});var require_open=__commonJS({"core/node_modules/open/index.js"(exports2,module2){"use strict";var{promisify:promisify9}=require("util");var path27=require("path");var childProcess=require("child_process");var fs14=require("fs");var url=require("url");var isWsl=require_is_wsl();var isDocker=require_is_docker();var pAccess=promisify9(fs14.access);var pExecFile=promisify9(childProcess.execFile);var localXdgOpenPath=path27.join(__dirname,"xdg-open");var wslToWindowsPath=async path28=>{const{stdout}=await pExecFile("wslpath",["-w",path28]);return stdout.trim()};module2.exports=async(target,options)=>{if(typeof target!=="string"){throw new TypeError("Expected a `target`")}options={wait:false,background:false,url:false,allowNonzeroExitCode:false,...options};let command;let appArguments=[];const cliArguments=[];const childProcessOptions={};if(Array.isArray(options.app)){appArguments=options.app.slice(1);options.app=options.app[0]}if(options.url){target=new url.URL(target).href;if(isWsl){target=target.replace(/&/g,"^&")}}if(process.platform==="darwin"){command="open";if(options.wait){cliArguments.push("--wait-apps")}if(options.background){cliArguments.push("--background")}if(options.app){cliArguments.push("-a",options.app)}}else if(process.platform==="win32"||isWsl&&!isDocker()){command="cmd"+(isWsl?".exe":"");cliArguments.push("/s","/c","start",'""',"/b");if(!isWsl){target=`"${target}"`;childProcessOptions.windowsVerbatimArguments=true;if(options.app){options.app=`"${options.app}"`}}if(options.wait){cliArguments.push("/wait")}if(options.app){if(isWsl&&options.app.startsWith("/mnt/")){const windowsPath=await wslToWindowsPath(options.app);options.app=windowsPath}cliArguments.push(options.app)}if(appArguments.length>0){cliArguments.push(...appArguments)}}else{if(options.app){command=options.app}else{const isBundled=!__dirname||__dirname==="/";let exeLocalXdgOpen=false;try{await pAccess(localXdgOpenPath,fs14.constants.X_OK);exeLocalXdgOpen=true}catch(_){}const useSystemXdgOpen=process.versions.electron||process.platform==="android"||isBundled||!exeLocalXdgOpen;command=useSystemXdgOpen?"xdg-open":localXdgOpenPath}if(appArguments.length>0){cliArguments.push(...appArguments)}if(!options.wait){childProcessOptions.stdio="ignore";childProcessOptions.detached=true}}cliArguments.push(target);if(process.platform==="darwin"&&appArguments.length>0){cliArguments.push("--args",...appArguments)}const subprocess=childProcess.spawn(command,cliArguments,childProcessOptions);if(options.wait){return new Promise((resolve,reject2)=>{subprocess.once("error",reject2);subprocess.once("close",exitCode=>{if(options.allowNonzeroExitCode&&exitCode>0){reject2(new Error(`Exited with code ${exitCode}`));return}resolve(subprocess)})})}subprocess.unref();return subprocess}}});var require_universalify=__commonJS({"node_modules/universalify/index.js"(exports2){"use strict";exports2.fromCallback=function(fn2){return Object.defineProperty(function(...args2){if(typeof args2[args2.length-1]==="function")fn2.apply(this,args2);else{return new Promise((resolve,reject2)=>{args2.push((err,res)=>err!=null?reject2(err):resolve(res));fn2.apply(this,args2)})}},"name",{value:fn2.name})};exports2.fromPromise=function(fn2){return Object.defineProperty(function(...args2){const cb=args2[args2.length-1];if(typeof cb!=="function")return fn2.apply(this,args2);else{args2.pop();fn2.apply(this,args2).then(r=>cb(null,r),cb)}},"name",{value:fn2.name})}}});var require_polyfills=__commonJS({"node_modules/graceful-fs/polyfills.js"(exports2,module2){var constants3=require("constants");var origCwd=process.cwd;var cwd=null;var platform=process.env.GRACEFUL_FS_PLATFORM||process.platform;process.cwd=function(){if(!cwd)cwd=origCwd.call(process);return cwd};try{process.cwd()}catch(er){}if(typeof process.chdir==="function"){chdir=process.chdir;process.chdir=function(d){cwd=null;chdir.call(process,d)};if(Object.setPrototypeOf)Object.setPrototypeOf(process.chdir,chdir)}var chdir;module2.exports=patch;function patch(fs14){if(constants3.hasOwnProperty("O_SYMLINK")&&process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)){patchLchmod(fs14)}if(!fs14.lutimes){patchLutimes(fs14)}fs14.chown=chownFix(fs14.chown);fs14.fchown=chownFix(fs14.fchown);fs14.lchown=chownFix(fs14.lchown);fs14.chmod=chmodFix(fs14.chmod);fs14.fchmod=chmodFix(fs14.fchmod);fs14.lchmod=chmodFix(fs14.lchmod);fs14.chownSync=chownFixSync(fs14.chownSync);fs14.fchownSync=chownFixSync(fs14.fchownSync);fs14.lchownSync=chownFixSync(fs14.lchownSync);fs14.chmodSync=chmodFixSync(fs14.chmodSync);fs14.fchmodSync=chmodFixSync(fs14.fchmodSync);fs14.lchmodSync=chmodFixSync(fs14.lchmodSync);fs14.stat=statFix(fs14.stat);fs14.fstat=statFix(fs14.fstat);fs14.lstat=statFix(fs14.lstat);fs14.statSync=statFixSync(fs14.statSync);fs14.fstatSync=statFixSync(fs14.fstatSync);fs14.lstatSync=statFixSync(fs14.lstatSync);if(fs14.chmod&&!fs14.lchmod){fs14.lchmod=function(path27,mode2,cb){if(cb)process.nextTick(cb)};fs14.lchmodSync=function(){}}if(fs14.chown&&!fs14.lchown){fs14.lchown=function(path27,uid,gid,cb){if(cb)process.nextTick(cb)};fs14.lchownSync=function(){}}if(platform==="win32"){fs14.rename=typeof fs14.rename!=="function"?fs14.rename:function(fs$rename){function rename3(from,to,cb){var start=Date.now();var backoff=0;fs$rename(from,to,function CB(er){if(er&&(er.code==="EACCES"||er.code==="EPERM"||er.code==="EBUSY")&&Date.now()-start<6e4){setTimeout(function(){fs14.stat(to,function(stater,st){if(stater&&stater.code==="ENOENT")fs$rename(from,to,CB);else cb(er)})},backoff);if(backoff<100)backoff+=10;return}if(cb)cb(er)})}if(Object.setPrototypeOf)Object.setPrototypeOf(rename3,fs$rename);return rename3}(fs14.rename)}fs14.read=typeof fs14.read!=="function"?fs14.read:function(fs$read){function read2(fd,buffer,offset,length,position,callback_){var callback;if(callback_&&typeof callback_==="function"){var eagCounter=0;callback=function(er,_,__){if(er&&er.code==="EAGAIN"&&eagCounter<10){eagCounter++;return fs$read.call(fs14,fd,buffer,offset,length,position,callback)}callback_.apply(this,arguments)}}return fs$read.call(fs14,fd,buffer,offset,length,position,callback)}if(Object.setPrototypeOf)Object.setPrototypeOf(read2,fs$read);return read2}(fs14.read);fs14.readSync=typeof fs14.readSync!=="function"?fs14.readSync:function(fs$readSync){return function(fd,buffer,offset,length,position){var eagCounter=0;while(true){try{return fs$readSync.call(fs14,fd,buffer,offset,length,position)}catch(er){if(er.code==="EAGAIN"&&eagCounter<10){eagCounter++;continue}throw er}}}}(fs14.readSync);function patchLchmod(fs15){fs15.lchmod=function(path27,mode2,callback){fs15.open(path27,constants3.O_WRONLY|constants3.O_SYMLINK,mode2,function(err,fd){if(err){if(callback)callback(err);return}fs15.fchmod(fd,mode2,function(err2){fs15.close(fd,function(err22){if(callback)callback(err2||err22)})})})};fs15.lchmodSync=function(path27,mode2){var fd=fs15.openSync(path27,constants3.O_WRONLY|constants3.O_SYMLINK,mode2);var threw=true;var ret;try{ret=fs15.fchmodSync(fd,mode2);threw=false}finally{if(threw){try{fs15.closeSync(fd)}catch(er){}}else{fs15.closeSync(fd)}}return ret}}function patchLutimes(fs15){if(constants3.hasOwnProperty("O_SYMLINK")&&fs15.futimes){fs15.lutimes=function(path27,at2,mt,cb){fs15.open(path27,constants3.O_SYMLINK,function(er,fd){if(er){if(cb)cb(er);return}fs15.futimes(fd,at2,mt,function(er2){fs15.close(fd,function(er22){if(cb)cb(er2||er22)})})})};fs15.lutimesSync=function(path27,at2,mt){var fd=fs15.openSync(path27,constants3.O_SYMLINK);var ret;var threw=true;try{ret=fs15.futimesSync(fd,at2,mt);threw=false}finally{if(threw){try{fs15.closeSync(fd)}catch(er){}}else{fs15.closeSync(fd)}}return ret}}else if(fs15.futimes){fs15.lutimes=function(_a13,_b2,_c,cb){if(cb)process.nextTick(cb)};fs15.lutimesSync=function(){}}}function chmodFix(orig){if(!orig)return orig;return function(target,mode2,cb){return orig.call(fs14,target,mode2,function(er){if(chownErOk(er))er=null;if(cb)cb.apply(this,arguments)})}}function chmodFixSync(orig){if(!orig)return orig;return function(target,mode2){try{return orig.call(fs14,target,mode2)}catch(er){if(!chownErOk(er))throw er}}}function chownFix(orig){if(!orig)return orig;return function(target,uid,gid,cb){return orig.call(fs14,target,uid,gid,function(er){if(chownErOk(er))er=null;if(cb)cb.apply(this,arguments)})}}function chownFixSync(orig){if(!orig)return orig;return function(target,uid,gid){try{return orig.call(fs14,target,uid,gid)}catch(er){if(!chownErOk(er))throw er}}}function statFix(orig){if(!orig)return orig;return function(target,options,cb){if(typeof options==="function"){cb=options;options=null}function callback(er,stats){if(stats){if(stats.uid<0)stats.uid+=4294967296;if(stats.gid<0)stats.gid+=4294967296}if(cb)cb.apply(this,arguments)}return options?orig.call(fs14,target,options,callback):orig.call(fs14,target,callback)}}function statFixSync(orig){if(!orig)return orig;return function(target,options){var stats=options?orig.call(fs14,target,options):orig.call(fs14,target);if(stats){if(stats.uid<0)stats.uid+=4294967296;if(stats.gid<0)stats.gid+=4294967296}return stats}}function chownErOk(er){if(!er)return true;if(er.code==="ENOSYS")return true;var nonroot=!process.getuid||process.getuid()!==0;if(nonroot){if(er.code==="EINVAL"||er.code==="EPERM")return true}return false}}}});var require_legacy_streams=__commonJS({"node_modules/graceful-fs/legacy-streams.js"(exports2,module2){var Stream=require("stream").Stream;module2.exports=legacy;function legacy(fs14){return{ReadStream,WriteStream};function ReadStream(path27,options){if(!(this instanceof ReadStream))return new ReadStream(path27,options);Stream.call(this);var self2=this;this.path=path27;this.fd=null;this.readable=true;this.paused=false;this.flags="r";this.mode=438;this.bufferSize=64*1024;options=options||{};var keys2=Object.keys(options);for(var index=0,length=keys2.length;index<length;index++){var key=keys2[index];this[key]=options[key]}if(this.encoding)this.setEncoding(this.encoding);if(this.start!==void 0){if("number"!==typeof this.start){throw TypeError("start must be a Number")}if(this.end===void 0){this.end=Infinity}else if("number"!==typeof this.end){throw TypeError("end must be a Number")}if(this.start>this.end){throw new Error("start must be <= end")}this.pos=this.start}if(this.fd!==null){process.nextTick(function(){self2._read()});return}fs14.open(this.path,this.flags,this.mode,function(err,fd){if(err){self2.emit("error",err);self2.readable=false;return}self2.fd=fd;self2.emit("open",fd);self2._read()})}function WriteStream(path27,options){if(!(this instanceof WriteStream))return new WriteStream(path27,options);Stream.call(this);this.path=path27;this.fd=null;this.writable=true;this.flags="w";this.encoding="binary";this.mode=438;this.bytesWritten=0;options=options||{};var keys2=Object.keys(options);for(var index=0,length=keys2.length;index<length;index++){var key=keys2[index];this[key]=options[key]}if(this.start!==void 0){if("number"!==typeof this.start){throw TypeError("start must be a Number")}if(this.start<0){throw new Error("start must be >= zero")}this.pos=this.start}this.busy=false;this._queue=[];if(this.fd===null){this._open=fs14.open;this._queue.push([this._open,this.path,this.flags,this.mode,void 0]);this.flush()}}}}});var require_clone=__commonJS({"node_modules/graceful-fs/clone.js"(exports2,module2){"use strict";module2.exports=clone2;var getPrototypeOf=Object.getPrototypeOf||function(obj){return obj.__proto__};function clone2(obj){if(obj===null||typeof obj!=="object")return obj;if(obj instanceof Object)var copy={__proto__:getPrototypeOf(obj)};else var copy=Object.create(null);Object.getOwnPropertyNames(obj).forEach(function(key){Object.defineProperty(copy,key,Object.getOwnPropertyDescriptor(obj,key))});return copy}}});var require_graceful_fs=__commonJS({"node_modules/graceful-fs/graceful-fs.js"(exports2,module2){var fs14=require("fs");var polyfills=require_polyfills();var legacy=require_legacy_streams();var clone2=require_clone();var util4=require("util");var gracefulQueue;var previousSymbol;if(typeof Symbol==="function"&&typeof Symbol.for==="function"){gracefulQueue=Symbol.for("graceful-fs.queue");previousSymbol=Symbol.for("graceful-fs.previous")}else{gracefulQueue="___graceful-fs.queue";previousSymbol="___graceful-fs.previous"}function noop4(){}function publishQueue(context,queue2){Object.defineProperty(context,gracefulQueue,{get:function(){return queue2}})}var debug=noop4;if(util4.debuglog)debug=util4.debuglog("gfs4");else if(/\bgfs4\b/i.test(process.env.NODE_DEBUG||""))debug=function(){var m=util4.format.apply(util4,arguments);m="GFS4: "+m.split(/\n/).join("\nGFS4: ");console.error(m)};if(!fs14[gracefulQueue]){queue=global[gracefulQueue]||[];publishQueue(fs14,queue);fs14.close=function(fs$close){function close(fd,cb){return fs$close.call(fs14,fd,function(err){if(!err){resetQueue()}if(typeof cb==="function")cb.apply(this,arguments)})}Object.defineProperty(close,previousSymbol,{value:fs$close});return close}(fs14.close);fs14.closeSync=function(fs$closeSync){function closeSync(fd){fs$closeSync.apply(fs14,arguments);resetQueue()}Object.defineProperty(closeSync,previousSymbol,{value:fs$closeSync});return closeSync}(fs14.closeSync);if(/\bgfs4\b/i.test(process.env.NODE_DEBUG||"")){process.on("exit",function(){debug(fs14[gracefulQueue]);require("assert").equal(fs14[gracefulQueue].length,0)})}}var queue;if(!global[gracefulQueue]){publishQueue(global,fs14[gracefulQueue])}module2.exports=patch(clone2(fs14));if(process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH&&!fs14.__patched){module2.exports=patch(fs14);fs14.__patched=true}function patch(fs15){polyfills(fs15);fs15.gracefulify=patch;fs15.createReadStream=createReadStream2;fs15.createWriteStream=createWriteStream2;var fs$readFile=fs15.readFile;fs15.readFile=readFile4;function readFile4(path27,options,cb){if(typeof options==="function")cb=options,options=null;return go$readFile(path27,options,cb);function go$readFile(path28,options2,cb2,startTime){return fs$readFile(path28,options2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$readFile,[path28,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$writeFile=fs15.writeFile;fs15.writeFile=writeFile3;function writeFile3(path27,data,options,cb){if(typeof options==="function")cb=options,options=null;return go$writeFile(path27,data,options,cb);function go$writeFile(path28,data2,options2,cb2,startTime){return fs$writeFile(path28,data2,options2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$writeFile,[path28,data2,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$appendFile=fs15.appendFile;if(fs$appendFile)fs15.appendFile=appendFile;function appendFile(path27,data,options,cb){if(typeof options==="function")cb=options,options=null;return go$appendFile(path27,data,options,cb);function go$appendFile(path28,data2,options2,cb2,startTime){return fs$appendFile(path28,data2,options2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$appendFile,[path28,data2,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$copyFile=fs15.copyFile;if(fs$copyFile)fs15.copyFile=copyFile;function copyFile(src,dest,flags,cb){if(typeof flags==="function"){cb=flags;flags=0}return go$copyFile(src,dest,flags,cb);function go$copyFile(src2,dest2,flags2,cb2,startTime){return fs$copyFile(src2,dest2,flags2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$copyFile,[src2,dest2,flags2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$readdir=fs15.readdir;fs15.readdir=readdir2;var noReaddirOptionVersions=/^v[0-5]\./;function readdir2(path27,options,cb){if(typeof options==="function")cb=options,options=null;var go$readdir=noReaddirOptionVersions.test(process.version)?function go$readdir2(path28,options2,cb2,startTime){return fs$readdir(path28,fs$readdirCallback(path28,options2,cb2,startTime))}:function go$readdir2(path28,options2,cb2,startTime){return fs$readdir(path28,options2,fs$readdirCallback(path28,options2,cb2,startTime))};return go$readdir(path27,options,cb);function fs$readdirCallback(path28,options2,cb2,startTime){return function(err,files){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$readdir,[path28,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(files&&files.sort)files.sort();if(typeof cb2==="function")cb2.call(this,err,files)}}}}if(process.version.substr(0,4)==="v0.8"){var legStreams=legacy(fs15);ReadStream=legStreams.ReadStream;WriteStream=legStreams.WriteStream}var fs$ReadStream=fs15.ReadStream;if(fs$ReadStream){ReadStream.prototype=Object.create(fs$ReadStream.prototype);ReadStream.prototype.open=ReadStream$open}var fs$WriteStream=fs15.WriteStream;if(fs$WriteStream){WriteStream.prototype=Object.create(fs$WriteStream.prototype);WriteStream.prototype.open=WriteStream$open}Object.defineProperty(fs15,"ReadStream",{get:function(){return ReadStream},set:function(val){ReadStream=val},enumerable:true,configurable:true});Object.defineProperty(fs15,"WriteStream",{get:function(){return WriteStream},set:function(val){WriteStream=val},enumerable:true,configurable:true});var FileReadStream=ReadStream;Object.defineProperty(fs15,"FileReadStream",{get:function(){return FileReadStream},set:function(val){FileReadStream=val},enumerable:true,configurable:true});var FileWriteStream=WriteStream;Object.defineProperty(fs15,"FileWriteStream",{get:function(){return FileWriteStream},set:function(val){FileWriteStream=val},enumerable:true,configurable:true});function ReadStream(path27,options){if(this instanceof ReadStream)return fs$ReadStream.apply(this,arguments),this;else return ReadStream.apply(Object.create(ReadStream.prototype),arguments)}function ReadStream$open(){var that=this;open4(that.path,that.flags,that.mode,function(err,fd){if(err){if(that.autoClose)that.destroy();that.emit("error",err)}else{that.fd=fd;that.emit("open",fd);that.read()}})}function WriteStream(path27,options){if(this instanceof WriteStream)return fs$WriteStream.apply(this,arguments),this;else return WriteStream.apply(Object.create(WriteStream.prototype),arguments)}function WriteStream$open(){var that=this;open4(that.path,that.flags,that.mode,function(err,fd){if(err){that.destroy();that.emit("error",err)}else{that.fd=fd;that.emit("open",fd)}})}function createReadStream2(path27,options){return new fs15.ReadStream(path27,options)}function createWriteStream2(path27,options){return new fs15.WriteStream(path27,options)}var fs$open=fs15.open;fs15.open=open4;function open4(path27,flags,mode2,cb){if(typeof mode2==="function")cb=mode2,mode2=null;return go$open(path27,flags,mode2,cb);function go$open(path28,flags2,mode3,cb2,startTime){return fs$open(path28,flags2,mode3,function(err,fd){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$open,[path28,flags2,mode3,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}return fs15}function enqueue(elem){debug("ENQUEUE",elem[0].name,elem[1]);fs14[gracefulQueue].push(elem);retry()}var retryTimer;function resetQueue(){var now3=Date.now();for(var i=0;i<fs14[gracefulQueue].length;++i){if(fs14[gracefulQueue][i].length>2){fs14[gracefulQueue][i][3]=now3;fs14[gracefulQueue][i][4]=now3}}retry()}function retry(){clearTimeout(retryTimer);retryTimer=void 0;if(fs14[gracefulQueue].length===0)return;var elem=fs14[gracefulQueue].shift();var fn2=elem[0];var args2=elem[1];var err=elem[2];var startTime=elem[3];var lastTime=elem[4];if(startTime===void 0){debug("RETRY",fn2.name,args2);fn2.apply(null,args2)}else if(Date.now()-startTime>=6e4){debug("TIMEOUT",fn2.name,args2);var cb=args2.pop();if(typeof cb==="function")cb.call(null,err)}else{var sinceAttempt=Date.now()-lastTime;var sinceStart=Math.max(lastTime-startTime,1);var desiredDelay=Math.min(sinceStart*1.2,100);if(sinceAttempt>=desiredDelay){debug("RETRY",fn2.name,args2);fn2.apply(null,args2.concat([startTime]))}else{fs14[gracefulQueue].push(elem)}}if(retryTimer===void 0){retryTimer=setTimeout(retry,0)}}}});var require_fs=__commonJS({"node_modules/fs-extra/lib/fs/index.js"(exports2){"use strict";var u=require_universalify().fromCallback;var fs14=require_graceful_fs();var api=["access","appendFile","chmod","chown","close","copyFile","fchmod","fchown","fdatasync","fstat","fsync","ftruncate","futimes","lchmod","lchown","link","lstat","mkdir","mkdtemp","open","opendir","readdir","readFile","readlink","realpath","rename","rm","rmdir","stat","symlink","truncate","unlink","utimes","writeFile"].filter(key=>{return typeof fs14[key]==="function"});Object.keys(fs14).forEach(key=>{if(key==="promises"){return}exports2[key]=fs14[key]});api.forEach(method2=>{exports2[method2]=u(fs14[method2])});exports2.exists=function(filename,callback){if(typeof callback==="function"){return fs14.exists(filename,callback)}return new Promise(resolve=>{return fs14.exists(filename,resolve)})};exports2.read=function(fd,buffer,offset,length,position,callback){if(typeof callback==="function"){return fs14.read(fd,buffer,offset,length,position,callback)}return new Promise((resolve,reject2)=>{fs14.read(fd,buffer,offset,length,position,(err,bytesRead,buffer2)=>{if(err)return reject2(err);resolve({bytesRead,buffer:buffer2})})})};exports2.write=function(fd,buffer,...args2){if(typeof args2[args2.length-1]==="function"){return fs14.write(fd,buffer,...args2)}return new Promise((resolve,reject2)=>{fs14.write(fd,buffer,...args2,(err,bytesWritten,buffer2)=>{if(err)return reject2(err);resolve({bytesWritten,buffer:buffer2})})})};if(typeof fs14.writev==="function"){exports2.writev=function(fd,buffers,...args2){if(typeof args2[args2.length-1]==="function"){return fs14.writev(fd,buffers,...args2)}return new Promise((resolve,reject2)=>{fs14.writev(fd,buffers,...args2,(err,bytesWritten,buffers2)=>{if(err)return reject2(err);resolve({bytesWritten,buffers:buffers2})})})}}if(typeof fs14.realpath.native==="function"){exports2.realpath.native=u(fs14.realpath.native)}}});var require_at_least_node=__commonJS({"node_modules/at-least-node/index.js"(exports2,module2){module2.exports=r=>{const n=process.versions.node.split(".").map(x=>parseInt(x,10));r=r.split(".").map(x=>parseInt(x,10));return n[0]>r[0]||n[0]===r[0]&&(n[1]>r[1]||n[1]===r[1]&&n[2]>=r[2])}}});var require_make_dir=__commonJS({"node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports2,module2){"use strict";var fs14=require_fs();var path27=require("path");var atLeastNode=require_at_least_node();var useNativeRecursiveOption=atLeastNode("10.12.0");var checkPath=pth=>{if(process.platform==="win32"){const pathHasInvalidWinCharacters=/[<>:"|?*]/.test(pth.replace(path27.parse(pth).root,""));if(pathHasInvalidWinCharacters){const error=new Error(`Path contains invalid characters: ${pth}`);error.code="EINVAL";throw error}}};var processOptions=options=>{const defaults3={mode:511};if(typeof options==="number")options={mode:options};return{...defaults3,...options}};var permissionError=pth=>{const error=new Error(`operation not permitted, mkdir '${pth}'`);error.code="EPERM";error.errno=-4048;error.path=pth;error.syscall="mkdir";return error};module2.exports.makeDir=async(input,options)=>{checkPath(input);options=processOptions(options);if(useNativeRecursiveOption){const pth=path27.resolve(input);return fs14.mkdir(pth,{mode:options.mode,recursive:true})}const make=async pth=>{try{await fs14.mkdir(pth,options.mode)}catch(error){if(error.code==="EPERM"){throw error}if(error.code==="ENOENT"){if(path27.dirname(pth)===pth){throw permissionError(pth)}if(error.message.includes("null bytes")){throw error}await make(path27.dirname(pth));return make(pth)}try{const stats=await fs14.stat(pth);if(!stats.isDirectory()){throw new Error("The path is not a directory")}}catch{throw error}}};return make(path27.resolve(input))};module2.exports.makeDirSync=(input,options)=>{checkPath(input);options=processOptions(options);if(useNativeRecursiveOption){const pth=path27.resolve(input);return fs14.mkdirSync(pth,{mode:options.mode,recursive:true})}const make=pth=>{try{fs14.mkdirSync(pth,options.mode)}catch(error){if(error.code==="EPERM"){throw error}if(error.code==="ENOENT"){if(path27.dirname(pth)===pth){throw permissionError(pth)}if(error.message.includes("null bytes")){throw error}make(path27.dirname(pth));return make(pth)}try{if(!fs14.statSync(pth).isDirectory()){throw new Error("The path is not a directory")}}catch{throw error}}};return make(path27.resolve(input))}}});var require_mkdirs=__commonJS({"node_modules/fs-extra/lib/mkdirs/index.js"(exports2,module2){"use strict";var u=require_universalify().fromPromise;var{makeDir:_makeDir,makeDirSync}=require_make_dir();var makeDir=u(_makeDir);module2.exports={mkdirs:makeDir,mkdirsSync:makeDirSync,mkdirp:makeDir,mkdirpSync:makeDirSync,ensureDir:makeDir,ensureDirSync:makeDirSync}}});var require_utimes=__commonJS({"node_modules/fs-extra/lib/util/utimes.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();function utimesMillis(path27,atime,mtime,callback){fs14.open(path27,"r+",(err,fd)=>{if(err)return callback(err);fs14.futimes(fd,atime,mtime,futimesErr=>{fs14.close(fd,closeErr=>{if(callback)callback(futimesErr||closeErr)})})})}function utimesMillisSync(path27,atime,mtime){const fd=fs14.openSync(path27,"r+");fs14.futimesSync(fd,atime,mtime);return fs14.closeSync(fd)}module2.exports={utimesMillis,utimesMillisSync}}});var require_stat=__commonJS({"node_modules/fs-extra/lib/util/stat.js"(exports2,module2){"use strict";var fs14=require_fs();var path27=require("path");var util4=require("util");var atLeastNode=require_at_least_node();var nodeSupportsBigInt=atLeastNode("10.5.0");var stat3=file=>nodeSupportsBigInt?fs14.stat(file,{bigint:true}):fs14.stat(file);var statSync=file=>nodeSupportsBigInt?fs14.statSync(file,{bigint:true}):fs14.statSync(file);function getStats(src,dest){return Promise.all([stat3(src),stat3(dest).catch(err=>{if(err.code==="ENOENT")return null;throw err})]).then(([srcStat,destStat])=>({srcStat,destStat}))}function getStatsSync(src,dest){let destStat;const srcStat=statSync(src);try{destStat=statSync(dest)}catch(err){if(err.code==="ENOENT")return{srcStat,destStat:null};throw err}return{srcStat,destStat}}function checkPaths(src,dest,funcName,cb){util4.callbackify(getStats)(src,dest,(err,stats)=>{if(err)return cb(err);const{srcStat,destStat}=stats;if(destStat&&areIdentical(srcStat,destStat)){return cb(new Error("Source and destination must not be the same."))}if(srcStat.isDirectory()&&isSrcSubdir(src,dest)){return cb(new Error(errMsg(src,dest,funcName)))}return cb(null,{srcStat,destStat})})}function checkPathsSync(src,dest,funcName){const{srcStat,destStat}=getStatsSync(src,dest);if(destStat&&areIdentical(srcStat,destStat)){throw new Error("Source and destination must not be the same.")}if(srcStat.isDirectory()&&isSrcSubdir(src,dest)){throw new Error(errMsg(src,dest,funcName))}return{srcStat,destStat}}function checkParentPaths(src,srcStat,dest,funcName,cb){const srcParent=path27.resolve(path27.dirname(src));const destParent=path27.resolve(path27.dirname(dest));if(destParent===srcParent||destParent===path27.parse(destParent).root)return cb();const callback=(err,destStat)=>{if(err){if(err.code==="ENOENT")return cb();return cb(err)}if(areIdentical(srcStat,destStat)){return cb(new Error(errMsg(src,dest,funcName)))}return checkParentPaths(src,srcStat,destParent,funcName,cb)};if(nodeSupportsBigInt)fs14.stat(destParent,{bigint:true},callback);else fs14.stat(destParent,callback)}function checkParentPathsSync(src,srcStat,dest,funcName){const srcParent=path27.resolve(path27.dirname(src));const destParent=path27.resolve(path27.dirname(dest));if(destParent===srcParent||destParent===path27.parse(destParent).root)return;let destStat;try{destStat=statSync(destParent)}catch(err){if(err.code==="ENOENT")return;throw err}if(areIdentical(srcStat,destStat)){throw new Error(errMsg(src,dest,funcName))}return checkParentPathsSync(src,srcStat,destParent,funcName)}function areIdentical(srcStat,destStat){if(destStat.ino&&destStat.dev&&destStat.ino===srcStat.ino&&destStat.dev===srcStat.dev){if(nodeSupportsBigInt||destStat.ino<Number.MAX_SAFE_INTEGER){return true}if(destStat.size===srcStat.size&&destStat.mode===srcStat.mode&&destStat.nlink===srcStat.nlink&&destStat.atimeMs===srcStat.atimeMs&&destStat.mtimeMs===srcStat.mtimeMs&&destStat.ctimeMs===srcStat.ctimeMs&&destStat.birthtimeMs===srcStat.birthtimeMs){return true}}return false}function isSrcSubdir(src,dest){const srcArr=path27.resolve(src).split(path27.sep).filter(i=>i);const destArr=path27.resolve(dest).split(path27.sep).filter(i=>i);return srcArr.reduce((acc,cur,i)=>acc&&destArr[i]===cur,true)}function errMsg(src,dest,funcName){return`Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`}module2.exports={checkPaths,checkPathsSync,checkParentPaths,checkParentPathsSync,isSrcSubdir}}});var require_copy_sync=__commonJS({"node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();var path27=require("path");var mkdirsSync=require_mkdirs().mkdirsSync;var utimesMillisSync=require_utimes().utimesMillisSync;var stat3=require_stat();function copySync(src,dest,opts){if(typeof opts==="function"){opts={filter:opts}}opts=opts||{};opts.clobber="clobber"in opts?!!opts.clobber:true;opts.overwrite="overwrite"in opts?!!opts.overwrite:opts.clobber;if(opts.preserveTimestamps&&process.arch==="ia32"){console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`)}const{srcStat,destStat}=stat3.checkPathsSync(src,dest,"copy");stat3.checkParentPathsSync(src,srcStat,dest,"copy");return handleFilterAndCopy(destStat,src,dest,opts)}function handleFilterAndCopy(destStat,src,dest,opts){if(opts.filter&&!opts.filter(src,dest))return;const destParent=path27.dirname(dest);if(!fs14.existsSync(destParent))mkdirsSync(destParent);return startCopy(destStat,src,dest,opts)}function startCopy(destStat,src,dest,opts){if(opts.filter&&!opts.filter(src,dest))return;return getStats(destStat,src,dest,opts)}function getStats(destStat,src,dest,opts){const statSync=opts.dereference?fs14.statSync:fs14.lstatSync;const srcStat=statSync(src);if(srcStat.isDirectory())return onDir(srcStat,destStat,src,dest,opts);else if(srcStat.isFile()||srcStat.isCharacterDevice()||srcStat.isBlockDevice())return onFile(srcStat,destStat,src,dest,opts);else if(srcStat.isSymbolicLink())return onLink(destStat,src,dest,opts)}function onFile(srcStat,destStat,src,dest,opts){if(!destStat)return copyFile(srcStat,src,dest,opts);return mayCopyFile(srcStat,src,dest,opts)}function mayCopyFile(srcStat,src,dest,opts){if(opts.overwrite){fs14.unlinkSync(dest);return copyFile(srcStat,src,dest,opts)}else if(opts.errorOnExist){throw new Error(`'${dest}' already exists`)}}function copyFile(srcStat,src,dest,opts){fs14.copyFileSync(src,dest);if(opts.preserveTimestamps)handleTimestamps(srcStat.mode,src,dest);return setDestMode(dest,srcStat.mode)}function handleTimestamps(srcMode,src,dest){if(fileIsNotWritable(srcMode))makeFileWritable(dest,srcMode);return setDestTimestamps(src,dest)}function fileIsNotWritable(srcMode){return(srcMode&128)===0}function makeFileWritable(dest,srcMode){return setDestMode(dest,srcMode|128)}function setDestMode(dest,srcMode){return fs14.chmodSync(dest,srcMode)}function setDestTimestamps(src,dest){const updatedSrcStat=fs14.statSync(src);return utimesMillisSync(dest,updatedSrcStat.atime,updatedSrcStat.mtime)}function onDir(srcStat,destStat,src,dest,opts){if(!destStat)return mkDirAndCopy(srcStat.mode,src,dest,opts);if(destStat&&!destStat.isDirectory()){throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`)}return copyDir(src,dest,opts)}function mkDirAndCopy(srcMode,src,dest,opts){fs14.mkdirSync(dest);copyDir(src,dest,opts);return setDestMode(dest,srcMode)}function copyDir(src,dest,opts){fs14.readdirSync(src).forEach(item=>copyDirItem(item,src,dest,opts))}function copyDirItem(item,src,dest,opts){const srcItem=path27.join(src,item);const destItem=path27.join(dest,item);const{destStat}=stat3.checkPathsSync(srcItem,destItem,"copy");return startCopy(destStat,srcItem,destItem,opts)}function onLink(destStat,src,dest,opts){let resolvedSrc=fs14.readlinkSync(src);if(opts.dereference){resolvedSrc=path27.resolve(process.cwd(),resolvedSrc)}if(!destStat){return fs14.symlinkSync(resolvedSrc,dest)}else{let resolvedDest;try{resolvedDest=fs14.readlinkSync(dest)}catch(err){if(err.code==="EINVAL"||err.code==="UNKNOWN")return fs14.symlinkSync(resolvedSrc,dest);throw err}if(opts.dereference){resolvedDest=path27.resolve(process.cwd(),resolvedDest)}if(stat3.isSrcSubdir(resolvedSrc,resolvedDest)){throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`)}if(fs14.statSync(dest).isDirectory()&&stat3.isSrcSubdir(resolvedDest,resolvedSrc)){throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`)}return copyLink(resolvedSrc,dest)}}function copyLink(resolvedSrc,dest){fs14.unlinkSync(dest);return fs14.symlinkSync(resolvedSrc,dest)}module2.exports=copySync}});var require_copy_sync2=__commonJS({"node_modules/fs-extra/lib/copy-sync/index.js"(exports2,module2){"use strict";module2.exports={copySync:require_copy_sync()}}});var require_path_exists=__commonJS({"node_modules/fs-extra/lib/path-exists/index.js"(exports2,module2){"use strict";var u=require_universalify().fromPromise;var fs14=require_fs();function pathExists(path27){return fs14.access(path27).then(()=>true).catch(()=>false)}module2.exports={pathExists:u(pathExists),pathExistsSync:fs14.existsSync}}});var require_copy=__commonJS({"node_modules/fs-extra/lib/copy/copy.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();var path27=require("path");var mkdirs=require_mkdirs().mkdirs;var pathExists=require_path_exists().pathExists;var utimesMillis=require_utimes().utimesMillis;var stat3=require_stat();function copy(src,dest,opts,cb){if(typeof opts==="function"&&!cb){cb=opts;opts={}}else if(typeof opts==="function"){opts={filter:opts}}cb=cb||function(){};opts=opts||{};opts.clobber="clobber"in opts?!!opts.clobber:true;opts.overwrite="overwrite"in opts?!!opts.overwrite:opts.clobber;if(opts.preserveTimestamps&&process.arch==="ia32"){console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`)}stat3.checkPaths(src,dest,"copy",(err,stats)=>{if(err)return cb(err);const{srcStat,destStat}=stats;stat3.checkParentPaths(src,srcStat,dest,"copy",err2=>{if(err2)return cb(err2);if(opts.filter)return handleFilter(checkParentDir,destStat,src,dest,opts,cb);return checkParentDir(destStat,src,dest,opts,cb)})})}function checkParentDir(destStat,src,dest,opts,cb){const destParent=path27.dirname(dest);pathExists(destParent,(err,dirExists)=>{if(err)return cb(err);if(dirExists)return startCopy(destStat,src,dest,opts,cb);mkdirs(destParent,err2=>{if(err2)return cb(err2);return startCopy(destStat,src,dest,opts,cb)})})}function handleFilter(onInclude,destStat,src,dest,opts,cb){Promise.resolve(opts.filter(src,dest)).then(include=>{if(include)return onInclude(destStat,src,dest,opts,cb);return cb()},error=>cb(error))}function startCopy(destStat,src,dest,opts,cb){if(opts.filter)return handleFilter(getStats,destStat,src,dest,opts,cb);return getStats(destStat,src,dest,opts,cb)}function getStats(destStat,src,dest,opts,cb){const stat4=opts.dereference?fs14.stat:fs14.lstat;stat4(src,(err,srcStat)=>{if(err)return cb(err);if(srcStat.isDirectory())return onDir(srcStat,destStat,src,dest,opts,cb);else if(srcStat.isFile()||srcStat.isCharacterDevice()||srcStat.isBlockDevice())return onFile(srcStat,destStat,src,dest,opts,cb);else if(srcStat.isSymbolicLink())return onLink(destStat,src,dest,opts,cb)})}function onFile(srcStat,destStat,src,dest,opts,cb){if(!destStat)return copyFile(srcStat,src,dest,opts,cb);return mayCopyFile(srcStat,src,dest,opts,cb)}function mayCopyFile(srcStat,src,dest,opts,cb){if(opts.overwrite){fs14.unlink(dest,err=>{if(err)return cb(err);return copyFile(srcStat,src,dest,opts,cb)})}else if(opts.errorOnExist){return cb(new Error(`'${dest}' already exists`))}else return cb()}function copyFile(srcStat,src,dest,opts,cb){fs14.copyFile(src,dest,err=>{if(err)return cb(err);if(opts.preserveTimestamps)return handleTimestampsAndMode(srcStat.mode,src,dest,cb);return setDestMode(dest,srcStat.mode,cb)})}function handleTimestampsAndMode(srcMode,src,dest,cb){if(fileIsNotWritable(srcMode)){return makeFileWritable(dest,srcMode,err=>{if(err)return cb(err);return setDestTimestampsAndMode(srcMode,src,dest,cb)})}return setDestTimestampsAndMode(srcMode,src,dest,cb)}function fileIsNotWritable(srcMode){return(srcMode&128)===0}function makeFileWritable(dest,srcMode,cb){return setDestMode(dest,srcMode|128,cb)}function setDestTimestampsAndMode(srcMode,src,dest,cb){setDestTimestamps(src,dest,err=>{if(err)return cb(err);return setDestMode(dest,srcMode,cb)})}function setDestMode(dest,srcMode,cb){return fs14.chmod(dest,srcMode,cb)}function setDestTimestamps(src,dest,cb){fs14.stat(src,(err,updatedSrcStat)=>{if(err)return cb(err);return utimesMillis(dest,updatedSrcStat.atime,updatedSrcStat.mtime,cb)})}function onDir(srcStat,destStat,src,dest,opts,cb){if(!destStat)return mkDirAndCopy(srcStat.mode,src,dest,opts,cb);if(destStat&&!destStat.isDirectory()){return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`))}return copyDir(src,dest,opts,cb)}function mkDirAndCopy(srcMode,src,dest,opts,cb){fs14.mkdir(dest,err=>{if(err)return cb(err);copyDir(src,dest,opts,err2=>{if(err2)return cb(err2);return setDestMode(dest,srcMode,cb)})})}function copyDir(src,dest,opts,cb){fs14.readdir(src,(err,items)=>{if(err)return cb(err);return copyDirItems(items,src,dest,opts,cb)})}function copyDirItems(items,src,dest,opts,cb){const item=items.pop();if(!item)return cb();return copyDirItem(items,item,src,dest,opts,cb)}function copyDirItem(items,item,src,dest,opts,cb){const srcItem=path27.join(src,item);const destItem=path27.join(dest,item);stat3.checkPaths(srcItem,destItem,"copy",(err,stats)=>{if(err)return cb(err);const{destStat}=stats;startCopy(destStat,srcItem,destItem,opts,err2=>{if(err2)return cb(err2);return copyDirItems(items,src,dest,opts,cb)})})}function onLink(destStat,src,dest,opts,cb){fs14.readlink(src,(err,resolvedSrc)=>{if(err)return cb(err);if(opts.dereference){resolvedSrc=path27.resolve(process.cwd(),resolvedSrc)}if(!destStat){return fs14.symlink(resolvedSrc,dest,cb)}else{fs14.readlink(dest,(err2,resolvedDest)=>{if(err2){if(err2.code==="EINVAL"||err2.code==="UNKNOWN")return fs14.symlink(resolvedSrc,dest,cb);return cb(err2)}if(opts.dereference){resolvedDest=path27.resolve(process.cwd(),resolvedDest)}if(stat3.isSrcSubdir(resolvedSrc,resolvedDest)){return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`))}if(destStat.isDirectory()&&stat3.isSrcSubdir(resolvedDest,resolvedSrc)){return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`))}return copyLink(resolvedSrc,dest,cb)})}})}function copyLink(resolvedSrc,dest,cb){fs14.unlink(dest,err=>{if(err)return cb(err);return fs14.symlink(resolvedSrc,dest,cb)})}module2.exports=copy}});var require_copy2=__commonJS({"node_modules/fs-extra/lib/copy/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;module2.exports={copy:u(require_copy())}}});var require_rimraf=__commonJS({"node_modules/fs-extra/lib/remove/rimraf.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();var path27=require("path");var assert2=require("assert");var isWindows2=process.platform==="win32";function defaults3(options){const methods=["unlink","chmod","stat","lstat","rmdir","readdir"];methods.forEach(m=>{options[m]=options[m]||fs14[m];m=m+"Sync";options[m]=options[m]||fs14[m]});options.maxBusyTries=options.maxBusyTries||3}function rimraf(p,options,cb){let busyTries=0;if(typeof options==="function"){cb=options;options={}}assert2(p,"rimraf: missing path");assert2.strictEqual(typeof p,"string","rimraf: path should be a string");assert2.strictEqual(typeof cb,"function","rimraf: callback function required");assert2(options,"rimraf: invalid options argument provided");assert2.strictEqual(typeof options,"object","rimraf: options should be object");defaults3(options);rimraf_(p,options,function CB(er){if(er){if((er.code==="EBUSY"||er.code==="ENOTEMPTY"||er.code==="EPERM")&&busyTries<options.maxBusyTries){busyTries++;const time=busyTries*100;return setTimeout(()=>rimraf_(p,options,CB),time)}if(er.code==="ENOENT")er=null}cb(er)})}function rimraf_(p,options,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.lstat(p,(er,st)=>{if(er&&er.code==="ENOENT"){return cb(null)}if(er&&er.code==="EPERM"&&isWindows2){return fixWinEPERM(p,options,er,cb)}if(st&&st.isDirectory()){return rmdir(p,options,er,cb)}options.unlink(p,er2=>{if(er2){if(er2.code==="ENOENT"){return cb(null)}if(er2.code==="EPERM"){return isWindows2?fixWinEPERM(p,options,er2,cb):rmdir(p,options,er2,cb)}if(er2.code==="EISDIR"){return rmdir(p,options,er2,cb)}}return cb(er2)})})}function fixWinEPERM(p,options,er,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.chmod(p,438,er2=>{if(er2){cb(er2.code==="ENOENT"?null:er)}else{options.stat(p,(er3,stats)=>{if(er3){cb(er3.code==="ENOENT"?null:er)}else if(stats.isDirectory()){rmdir(p,options,er,cb)}else{options.unlink(p,cb)}})}})}function fixWinEPERMSync(p,options,er){let stats;assert2(p);assert2(options);try{options.chmodSync(p,438)}catch(er2){if(er2.code==="ENOENT"){return}else{throw er}}try{stats=options.statSync(p)}catch(er3){if(er3.code==="ENOENT"){return}else{throw er}}if(stats.isDirectory()){rmdirSync(p,options,er)}else{options.unlinkSync(p)}}function rmdir(p,options,originalEr,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.rmdir(p,er=>{if(er&&(er.code==="ENOTEMPTY"||er.code==="EEXIST"||er.code==="EPERM")){rmkids(p,options,cb)}else if(er&&er.code==="ENOTDIR"){cb(originalEr)}else{cb(er)}})}function rmkids(p,options,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.readdir(p,(er,files)=>{if(er)return cb(er);let n=files.length;let errState;if(n===0)return options.rmdir(p,cb);files.forEach(f=>{rimraf(path27.join(p,f),options,er2=>{if(errState){return}if(er2)return cb(errState=er2);if(--n===0){options.rmdir(p,cb)}})})})}function rimrafSync(p,options){let st;options=options||{};defaults3(options);assert2(p,"rimraf: missing path");assert2.strictEqual(typeof p,"string","rimraf: path should be a string");assert2(options,"rimraf: missing options");assert2.strictEqual(typeof options,"object","rimraf: options should be object");try{st=options.lstatSync(p)}catch(er){if(er.code==="ENOENT"){return}if(er.code==="EPERM"&&isWindows2){fixWinEPERMSync(p,options,er)}}try{if(st&&st.isDirectory()){rmdirSync(p,options,null)}else{options.unlinkSync(p)}}catch(er){if(er.code==="ENOENT"){return}else if(er.code==="EPERM"){return isWindows2?fixWinEPERMSync(p,options,er):rmdirSync(p,options,er)}else if(er.code!=="EISDIR"){throw er}rmdirSync(p,options,er)}}function rmdirSync(p,options,originalEr){assert2(p);assert2(options);try{options.rmdirSync(p)}catch(er){if(er.code==="ENOTDIR"){throw originalEr}else if(er.code==="ENOTEMPTY"||er.code==="EEXIST"||er.code==="EPERM"){rmkidsSync(p,options)}else if(er.code!=="ENOENT"){throw er}}}function rmkidsSync(p,options){assert2(p);assert2(options);options.readdirSync(p).forEach(f=>rimrafSync(path27.join(p,f),options));if(isWindows2){const startTime=Date.now();do{try{const ret=options.rmdirSync(p,options);return ret}catch{}}while(Date.now()-startTime<500)}else{const ret=options.rmdirSync(p,options);return ret}}module2.exports=rimraf;rimraf.sync=rimrafSync}});var require_remove=__commonJS({"node_modules/fs-extra/lib/remove/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var rimraf=require_rimraf();module2.exports={remove:u(rimraf),removeSync:rimraf.sync}}});var require_empty=__commonJS({"node_modules/fs-extra/lib/empty/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var fs14=require_graceful_fs();var path27=require("path");var mkdir2=require_mkdirs();var remove2=require_remove();var emptyDir=u(function emptyDir2(dir,callback){callback=callback||function(){};fs14.readdir(dir,(err,items)=>{if(err)return mkdir2.mkdirs(dir,callback);items=items.map(item=>path27.join(dir,item));deleteItem();function deleteItem(){const item=items.pop();if(!item)return callback();remove2.remove(item,err2=>{if(err2)return callback(err2);deleteItem()})}})});function emptyDirSync(dir){let items;try{items=fs14.readdirSync(dir)}catch{return mkdir2.mkdirsSync(dir)}items.forEach(item=>{item=path27.join(dir,item);remove2.removeSync(item)})}module2.exports={emptyDirSync,emptydirSync:emptyDirSync,emptyDir,emptydir:emptyDir}}});var require_file=__commonJS({"node_modules/fs-extra/lib/ensure/file.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var path27=require("path");var fs14=require_graceful_fs();var mkdir2=require_mkdirs();function createFile(file,callback){function makeFile(){fs14.writeFile(file,"",err=>{if(err)return callback(err);callback()})}fs14.stat(file,(err,stats)=>{if(!err&&stats.isFile())return callback();const dir=path27.dirname(file);fs14.stat(dir,(err2,stats2)=>{if(err2){if(err2.code==="ENOENT"){return mkdir2.mkdirs(dir,err3=>{if(err3)return callback(err3);makeFile()})}return callback(err2)}if(stats2.isDirectory())makeFile();else{fs14.readdir(dir,err3=>{if(err3)return callback(err3)})}})})}function createFileSync(file){let stats;try{stats=fs14.statSync(file)}catch{}if(stats&&stats.isFile())return;const dir=path27.dirname(file);try{if(!fs14.statSync(dir).isDirectory()){fs14.readdirSync(dir)}}catch(err){if(err&&err.code==="ENOENT")mkdir2.mkdirsSync(dir);else throw err}fs14.writeFileSync(file,"")}module2.exports={createFile:u(createFile),createFileSync}}});var require_link=__commonJS({"node_modules/fs-extra/lib/ensure/link.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var path27=require("path");var fs14=require_graceful_fs();var mkdir2=require_mkdirs();var pathExists=require_path_exists().pathExists;function createLink(srcpath,dstpath,callback){function makeLink(srcpath2,dstpath2){fs14.link(srcpath2,dstpath2,err=>{if(err)return callback(err);callback(null)})}pathExists(dstpath,(err,destinationExists)=>{if(err)return callback(err);if(destinationExists)return callback(null);fs14.lstat(srcpath,err2=>{if(err2){err2.message=err2.message.replace("lstat","ensureLink");return callback(err2)}const dir=path27.dirname(dstpath);pathExists(dir,(err3,dirExists)=>{if(err3)return callback(err3);if(dirExists)return makeLink(srcpath,dstpath);mkdir2.mkdirs(dir,err4=>{if(err4)return callback(err4);makeLink(srcpath,dstpath)})})})})}function createLinkSync(srcpath,dstpath){const destinationExists=fs14.existsSync(dstpath);if(destinationExists)return void 0;try{fs14.lstatSync(srcpath)}catch(err){err.message=err.message.replace("lstat","ensureLink");throw err}const dir=path27.dirname(dstpath);const dirExists=fs14.existsSync(dir);if(dirExists)return fs14.linkSync(srcpath,dstpath);mkdir2.mkdirsSync(dir);return fs14.linkSync(srcpath,dstpath)}module2.exports={createLink:u(createLink),createLinkSync}}});var require_symlink_paths=__commonJS({"node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports2,module2){"use strict";var path27=require("path");var fs14=require_graceful_fs();var pathExists=require_path_exists().pathExists;function symlinkPaths(srcpath,dstpath,callback){if(path27.isAbsolute(srcpath)){return fs14.lstat(srcpath,err=>{if(err){err.message=err.message.replace("lstat","ensureSymlink");return callback(err)}return callback(null,{toCwd:srcpath,toDst:srcpath})})}else{const dstdir=path27.dirname(dstpath);const relativeToDst=path27.join(dstdir,srcpath);return pathExists(relativeToDst,(err,exists2)=>{if(err)return callback(err);if(exists2){return callback(null,{toCwd:relativeToDst,toDst:srcpath})}else{return fs14.lstat(srcpath,err2=>{if(err2){err2.message=err2.message.replace("lstat","ensureSymlink");return callback(err2)}return callback(null,{toCwd:srcpath,toDst:path27.relative(dstdir,srcpath)})})}})}}function symlinkPathsSync(srcpath,dstpath){let exists2;if(path27.isAbsolute(srcpath)){exists2=fs14.existsSync(srcpath);if(!exists2)throw new Error("absolute srcpath does not exist");return{toCwd:srcpath,toDst:srcpath}}else{const dstdir=path27.dirname(dstpath);const relativeToDst=path27.join(dstdir,srcpath);exists2=fs14.existsSync(relativeToDst);if(exists2){return{toCwd:relativeToDst,toDst:srcpath}}else{exists2=fs14.existsSync(srcpath);if(!exists2)throw new Error("relative srcpath does not exist");return{toCwd:srcpath,toDst:path27.relative(dstdir,srcpath)}}}}module2.exports={symlinkPaths,symlinkPathsSync}}});var require_symlink_type=__commonJS({"node_modules/fs-extra/lib/ensure/symlink-type.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();function symlinkType(srcpath,type2,callback){callback=typeof type2==="function"?type2:callback;type2=typeof type2==="function"?false:type2;if(type2)return callback(null,type2);fs14.lstat(srcpath,(err,stats)=>{if(err)return callback(null,"file");type2=stats&&stats.isDirectory()?"dir":"file";callback(null,type2)})}function symlinkTypeSync(srcpath,type2){let stats;if(type2)return type2;try{stats=fs14.lstatSync(srcpath)}catch{return"file"}return stats&&stats.isDirectory()?"dir":"file"}module2.exports={symlinkType,symlinkTypeSync}}});var require_symlink=__commonJS({"node_modules/fs-extra/lib/ensure/symlink.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var path27=require("path");var fs14=require_graceful_fs();var _mkdirs=require_mkdirs();var mkdirs=_mkdirs.mkdirs;var mkdirsSync=_mkdirs.mkdirsSync;var _symlinkPaths=require_symlink_paths();var symlinkPaths=_symlinkPaths.symlinkPaths;var symlinkPathsSync=_symlinkPaths.symlinkPathsSync;var _symlinkType=require_symlink_type();var symlinkType=_symlinkType.symlinkType;var symlinkTypeSync=_symlinkType.symlinkTypeSync;var pathExists=require_path_exists().pathExists;function createSymlink(srcpath,dstpath,type2,callback){callback=typeof type2==="function"?type2:callback;type2=typeof type2==="function"?false:type2;pathExists(dstpath,(err,destinationExists)=>{if(err)return callback(err);if(destinationExists)return callback(null);symlinkPaths(srcpath,dstpath,(err2,relative3)=>{if(err2)return callback(err2);srcpath=relative3.toDst;symlinkType(relative3.toCwd,type2,(err3,type3)=>{if(err3)return callback(err3);const dir=path27.dirname(dstpath);pathExists(dir,(err4,dirExists)=>{if(err4)return callback(err4);if(dirExists)return fs14.symlink(srcpath,dstpath,type3,callback);mkdirs(dir,err5=>{if(err5)return callback(err5);fs14.symlink(srcpath,dstpath,type3,callback)})})})})})}function createSymlinkSync(srcpath,dstpath,type2){const destinationExists=fs14.existsSync(dstpath);if(destinationExists)return void 0;const relative3=symlinkPathsSync(srcpath,dstpath);srcpath=relative3.toDst;type2=symlinkTypeSync(relative3.toCwd,type2);const dir=path27.dirname(dstpath);const exists2=fs14.existsSync(dir);if(exists2)return fs14.symlinkSync(srcpath,dstpath,type2);mkdirsSync(dir);return fs14.symlinkSync(srcpath,dstpath,type2)}module2.exports={createSymlink:u(createSymlink),createSymlinkSync}}});var require_ensure=__commonJS({"node_modules/fs-extra/lib/ensure/index.js"(exports2,module2){"use strict";var file=require_file();var link=require_link();var symlink=require_symlink();module2.exports={createFile:file.createFile,createFileSync:file.createFileSync,ensureFile:file.createFile,ensureFileSync:file.createFileSync,createLink:link.createLink,createLinkSync:link.createLinkSync,ensureLink:link.createLink,ensureLinkSync:link.createLinkSync,createSymlink:symlink.createSymlink,createSymlinkSync:symlink.createSymlinkSync,ensureSymlink:symlink.createSymlink,ensureSymlinkSync:symlink.createSymlinkSync}}});var require_utils=__commonJS({"node_modules/jsonfile/utils.js"(exports2,module2){function stringify(obj,{EOL="\n",finalEOL=true,replacer=null,spaces}={}){const EOF=finalEOL?EOL:"";const str2=JSON.stringify(obj,replacer,spaces);return str2.replace(/\n/g,EOL)+EOF}function stripBom(content){if(Buffer.isBuffer(content))content=content.toString("utf8");return content.replace(/^\uFEFF/,"")}module2.exports={stringify,stripBom}}});var require_jsonfile=__commonJS({"node_modules/jsonfile/index.js"(exports2,module2){var _fs;try{_fs=require_graceful_fs()}catch(_){_fs=require("fs")}var universalify=require_universalify();var{stringify,stripBom}=require_utils();async function _readFile(file,options={}){if(typeof options==="string"){options={encoding:options}}const fs14=options.fs||_fs;const shouldThrow="throws"in options?options.throws:true;let data=await universalify.fromCallback(fs14.readFile)(file,options);data=stripBom(data);let obj;try{obj=JSON.parse(data,options?options.reviver:null)}catch(err){if(shouldThrow){err.message=`${file}: ${err.message}`;throw err}else{return null}}return obj}var readFile4=universalify.fromPromise(_readFile);function readFileSync(file,options={}){if(typeof options==="string"){options={encoding:options}}const fs14=options.fs||_fs;const shouldThrow="throws"in options?options.throws:true;try{let content=fs14.readFileSync(file,options);content=stripBom(content);return JSON.parse(content,options.reviver)}catch(err){if(shouldThrow){err.message=`${file}: ${err.message}`;throw err}else{return null}}}async function _writeFile(file,obj,options={}){const fs14=options.fs||_fs;const str2=stringify(obj,options);await universalify.fromCallback(fs14.writeFile)(file,str2,options)}var writeFile3=universalify.fromPromise(_writeFile);function writeFileSync(file,obj,options={}){const fs14=options.fs||_fs;const str2=stringify(obj,options);return fs14.writeFileSync(file,str2,options)}var jsonfile={readFile:readFile4,readFileSync,writeFile:writeFile3,writeFileSync};module2.exports=jsonfile}});var require_jsonfile2=__commonJS({"node_modules/fs-extra/lib/json/jsonfile.js"(exports2,module2){"use strict";var jsonFile=require_jsonfile();module2.exports={readJson:jsonFile.readFile,readJsonSync:jsonFile.readFileSync,writeJson:jsonFile.writeFile,writeJsonSync:jsonFile.writeFileSync}}});var require_output=__commonJS({"node_modules/fs-extra/lib/output/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var fs14=require_graceful_fs();var path27=require("path");var mkdir2=require_mkdirs();var pathExists=require_path_exists().pathExists;function outputFile(file,data,encoding,callback){if(typeof encoding==="function"){callback=encoding;encoding="utf8"}const dir=path27.dirname(file);pathExists(dir,(err,itDoes)=>{if(err)return callback(err);if(itDoes)return fs14.writeFile(file,data,encoding,callback);mkdir2.mkdirs(dir,err2=>{if(err2)return callback(err2);fs14.writeFile(file,data,encoding,callback)})})}function outputFileSync(file,...args2){const dir=path27.dirname(file);if(fs14.existsSync(dir)){return fs14.writeFileSync(file,...args2)}mkdir2.mkdirsSync(dir);fs14.writeFileSync(file,...args2)}module2.exports={outputFile:u(outputFile),outputFileSync}}});var require_output_json=__commonJS({"node_modules/fs-extra/lib/json/output-json.js"(exports2,module2){"use strict";var{stringify}=require_utils();var{outputFile}=require_output();async function outputJson(file,data,options={}){const str2=stringify(data,options);await outputFile(file,str2,options)}module2.exports=outputJson}});var require_output_json_sync=__commonJS({"node_modules/fs-extra/lib/json/output-json-sync.js"(exports2,module2){"use strict";var{stringify}=require_utils();var{outputFileSync}=require_output();function outputJsonSync(file,data,options){const str2=stringify(data,options);outputFileSync(file,str2,options)}module2.exports=outputJsonSync}});var require_json=__commonJS({"node_modules/fs-extra/lib/json/index.js"(exports2,module2){"use strict";var u=require_universalify().fromPromise;var jsonFile=require_jsonfile2();jsonFile.outputJson=u(require_output_json());jsonFile.outputJsonSync=require_output_json_sync();jsonFile.outputJSON=jsonFile.outputJson;jsonFile.outputJSONSync=jsonFile.outputJsonSync;jsonFile.writeJSON=jsonFile.writeJson;jsonFile.writeJSONSync=jsonFile.writeJsonSync;jsonFile.readJSON=jsonFile.readJson;jsonFile.readJSONSync=jsonFile.readJsonSync;module2.exports=jsonFile}});var require_move_sync=__commonJS({"node_modules/fs-extra/lib/move-sync/move-sync.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();var path27=require("path");var copySync=require_copy_sync2().copySync;var removeSync=require_remove().removeSync;var mkdirpSync=require_mkdirs().mkdirpSync;var stat3=require_stat();function moveSync(src,dest,opts){opts=opts||{};const overwrite=opts.overwrite||opts.clobber||false;const{srcStat}=stat3.checkPathsSync(src,dest,"move");stat3.checkParentPathsSync(src,srcStat,dest,"move");mkdirpSync(path27.dirname(dest));return doRename(src,dest,overwrite)}function doRename(src,dest,overwrite){if(overwrite){removeSync(dest);return rename3(src,dest,overwrite)}if(fs14.existsSync(dest))throw new Error("dest already exists.");return rename3(src,dest,overwrite)}function rename3(src,dest,overwrite){try{fs14.renameSync(src,dest)}catch(err){if(err.code!=="EXDEV")throw err;return moveAcrossDevice(src,dest,overwrite)}}function moveAcrossDevice(src,dest,overwrite){const opts={overwrite,errorOnExist:true};copySync(src,dest,opts);return removeSync(src)}module2.exports=moveSync}});var require_move_sync2=__commonJS({"node_modules/fs-extra/lib/move-sync/index.js"(exports2,module2){"use strict";module2.exports={moveSync:require_move_sync()}}});var require_move=__commonJS({"node_modules/fs-extra/lib/move/move.js"(exports2,module2){"use strict";var fs14=require_graceful_fs();var path27=require("path");var copy=require_copy2().copy;var remove2=require_remove().remove;var mkdirp=require_mkdirs().mkdirp;var pathExists=require_path_exists().pathExists;var stat3=require_stat();function move(src,dest,opts,cb){if(typeof opts==="function"){cb=opts;opts={}}const overwrite=opts.overwrite||opts.clobber||false;stat3.checkPaths(src,dest,"move",(err,stats)=>{if(err)return cb(err);const{srcStat}=stats;stat3.checkParentPaths(src,srcStat,dest,"move",err2=>{if(err2)return cb(err2);mkdirp(path27.dirname(dest),err3=>{if(err3)return cb(err3);return doRename(src,dest,overwrite,cb)})})})}function doRename(src,dest,overwrite,cb){if(overwrite){return remove2(dest,err=>{if(err)return cb(err);return rename3(src,dest,overwrite,cb)})}pathExists(dest,(err,destExists)=>{if(err)return cb(err);if(destExists)return cb(new Error("dest already exists."));return rename3(src,dest,overwrite,cb)})}function rename3(src,dest,overwrite,cb){fs14.rename(src,dest,err=>{if(!err)return cb();if(err.code!=="EXDEV")return cb(err);return moveAcrossDevice(src,dest,overwrite,cb)})}function moveAcrossDevice(src,dest,overwrite,cb){const opts={overwrite,errorOnExist:true};copy(src,dest,opts,err=>{if(err)return cb(err);return remove2(src,cb)})}module2.exports=move}});var require_move2=__commonJS({"node_modules/fs-extra/lib/move/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;module2.exports={move:u(require_move())}}});var require_lib2=__commonJS({"node_modules/fs-extra/lib/index.js"(exports2,module2){"use strict";module2.exports={...require_fs(),...require_copy_sync2(),...require_copy2(),...require_empty(),...require_ensure(),...require_json(),...require_mkdirs(),...require_move_sync2(),...require_move2(),...require_output(),...require_path_exists(),...require_remove()};var fs14=require("fs");if(Object.getOwnPropertyDescriptor(fs14,"promises")){Object.defineProperty(module2.exports,"promises",{get(){return fs14.promises}})}}});var require_node_stream_zip=__commonJS({"node_modules/node-stream-zip/node_stream_zip.js"(exports2,module2){var fs14=require("fs");var util4=require("util");var path27=require("path");var events=require("events");var zlib2=require("zlib");var stream3=require("stream");var consts={LOCHDR:30,LOCSIG:67324752,LOCVER:4,LOCFLG:6,LOCHOW:8,LOCTIM:10,LOCCRC:14,LOCSIZ:18,LOCLEN:22,LOCNAM:26,LOCEXT:28,EXTSIG:134695760,EXTHDR:16,EXTCRC:4,EXTSIZ:8,EXTLEN:12,CENHDR:46,CENSIG:33639248,CENVEM:4,CENVER:6,CENFLG:8,CENHOW:10,CENTIM:12,CENCRC:16,CENSIZ:20,CENLEN:24,CENNAM:28,CENEXT:30,CENCOM:32,CENDSK:34,CENATT:36,CENATX:38,CENOFF:42,ENDHDR:22,ENDSIG:101010256,ENDSIGFIRST:80,ENDSUB:8,ENDTOT:10,ENDSIZ:12,ENDOFF:16,ENDCOM:20,MAXFILECOMMENT:65535,ENDL64HDR:20,ENDL64SIG:117853008,ENDL64SIGFIRST:80,ENDL64OFS:8,END64HDR:56,END64SIG:101075792,END64SIGFIRST:80,END64SUB:24,END64TOT:32,END64SIZ:40,END64OFF:48,STORED:0,SHRUNK:1,REDUCED1:2,REDUCED2:3,REDUCED3:4,REDUCED4:5,IMPLODED:6,DEFLATED:8,ENHANCED_DEFLATED:9,PKWARE:10,BZIP2:12,LZMA:14,IBM_TERSE:18,IBM_LZ77:19,FLG_ENC:0,FLG_COMP1:1,FLG_COMP2:2,FLG_DESC:4,FLG_ENH:8,FLG_STR:16,FLG_LNG:1024,FLG_MSK:4096,FLG_ENTRY_ENC:1,EF_ID:0,EF_SIZE:2,ID_ZIP64:1,ID_AVINFO:7,ID_PFS:8,ID_OS2:9,ID_NTFS:10,ID_OPENVMS:12,ID_UNIX:13,ID_FORK:14,ID_PATCH:15,ID_X509_PKCS7:20,ID_X509_CERTID_F:21,ID_X509_CERTID_C:22,ID_STRONGENC:23,ID_RECORD_MGT:24,ID_X509_PKCS7_RL:25,ID_IBM1:101,ID_IBM2:102,ID_POSZIP:18064,EF_ZIP64_OR_32:4294967295,EF_ZIP64_OR_16:65535};var StreamZip2=function(config){let fd,fileSize,chunkSize,op,centralDirectory,closed;const ready=false,that=this,entries2=config.storeEntries!==false?{}:null,fileName=config.file,textDecoder=config.nameEncoding?new TextDecoder(config.nameEncoding):null;open4();function open4(){if(config.fd){fd=config.fd;readFile4()}else{fs14.open(fileName,"r",(err,f)=>{if(err){return that.emit("error",err)}fd=f;readFile4()})}}function readFile4(){fs14.fstat(fd,(err,stat3)=>{if(err){return that.emit("error",err)}fileSize=stat3.size;chunkSize=config.chunkSize||Math.round(fileSize/1e3);chunkSize=Math.max(Math.min(chunkSize,Math.min(128*1024,fileSize)),Math.min(1024,fileSize));readCentralDirectory()})}function readUntilFoundCallback(err,bytesRead){if(err||!bytesRead){return that.emit("error",err||new Error("Archive read error"))}let pos=op.lastPos;let bufferPosition=pos-op.win.position;const buffer=op.win.buffer;const minPos=op.minPos;while(--pos>=minPos&&--bufferPosition>=0){if(buffer.length-bufferPosition>=4&&buffer[bufferPosition]===op.firstByte){if(buffer.readUInt32LE(bufferPosition)===op.sig){op.lastBufferPosition=bufferPosition;op.lastBytesRead=bytesRead;op.complete();return}}}if(pos===minPos){return that.emit("error",new Error("Bad archive"))}op.lastPos=pos+1;op.chunkSize*=2;if(pos<=minPos){return that.emit("error",new Error("Bad archive"))}const expandLength=Math.min(op.chunkSize,pos-minPos);op.win.expandLeft(expandLength,readUntilFoundCallback)}function readCentralDirectory(){const totalReadLength=Math.min(consts.ENDHDR+consts.MAXFILECOMMENT,fileSize);op={win:new FileWindowBuffer(fd),totalReadLength,minPos:fileSize-totalReadLength,lastPos:fileSize,chunkSize:Math.min(1024,chunkSize),firstByte:consts.ENDSIGFIRST,sig:consts.ENDSIG,complete:readCentralDirectoryComplete};op.win.read(fileSize-op.chunkSize,op.chunkSize,readUntilFoundCallback)}function readCentralDirectoryComplete(){const buffer=op.win.buffer;const pos=op.lastBufferPosition;try{centralDirectory=new CentralDirectoryHeader;centralDirectory.read(buffer.slice(pos,pos+consts.ENDHDR));centralDirectory.headerOffset=op.win.position+pos;if(centralDirectory.commentLength){that.comment=buffer.slice(pos+consts.ENDHDR,pos+consts.ENDHDR+centralDirectory.commentLength).toString()}else{that.comment=null}that.entriesCount=centralDirectory.volumeEntries;that.centralDirectory=centralDirectory;if(centralDirectory.volumeEntries===consts.EF_ZIP64_OR_16&&centralDirectory.totalEntries===consts.EF_ZIP64_OR_16||centralDirectory.size===consts.EF_ZIP64_OR_32||centralDirectory.offset===consts.EF_ZIP64_OR_32){readZip64CentralDirectoryLocator()}else{op={};readEntries()}}catch(err){that.emit("error",err)}}function readZip64CentralDirectoryLocator(){const length=consts.ENDL64HDR;if(op.lastBufferPosition>length){op.lastBufferPosition-=length;readZip64CentralDirectoryLocatorComplete()}else{op={win:op.win,totalReadLength:length,minPos:op.win.position-length,lastPos:op.win.position,chunkSize:op.chunkSize,firstByte:consts.ENDL64SIGFIRST,sig:consts.ENDL64SIG,complete:readZip64CentralDirectoryLocatorComplete};op.win.read(op.lastPos-op.chunkSize,op.chunkSize,readUntilFoundCallback)}}function readZip64CentralDirectoryLocatorComplete(){const buffer=op.win.buffer;const locHeader=new CentralDirectoryLoc64Header;locHeader.read(buffer.slice(op.lastBufferPosition,op.lastBufferPosition+consts.ENDL64HDR));const readLength=fileSize-locHeader.headerOffset;op={win:op.win,totalReadLength:readLength,minPos:locHeader.headerOffset,lastPos:op.lastPos,chunkSize:op.chunkSize,firstByte:consts.END64SIGFIRST,sig:consts.END64SIG,complete:readZip64CentralDirectoryComplete};op.win.read(fileSize-op.chunkSize,op.chunkSize,readUntilFoundCallback)}function readZip64CentralDirectoryComplete(){const buffer=op.win.buffer;const zip64cd=new CentralDirectoryZip64Header;zip64cd.read(buffer.slice(op.lastBufferPosition,op.lastBufferPosition+consts.END64HDR));that.centralDirectory.volumeEntries=zip64cd.volumeEntries;that.centralDirectory.totalEntries=zip64cd.totalEntries;that.centralDirectory.size=zip64cd.size;that.centralDirectory.offset=zip64cd.offset;that.entriesCount=zip64cd.volumeEntries;op={};readEntries()}function readEntries(){op={win:new FileWindowBuffer(fd),pos:centralDirectory.offset,chunkSize,entriesLeft:centralDirectory.volumeEntries};op.win.read(op.pos,Math.min(chunkSize,fileSize-op.pos),readEntriesCallback)}function readEntriesCallback(err,bytesRead){if(err||!bytesRead){return that.emit("error",err||new Error("Entries read error"))}let bufferPos=op.pos-op.win.position;let entry=op.entry;const buffer=op.win.buffer;const bufferLength=buffer.length;try{while(op.entriesLeft>0){if(!entry){entry=new ZipEntry;entry.readHeader(buffer,bufferPos);entry.headerOffset=op.win.position+bufferPos;op.entry=entry;op.pos+=consts.CENHDR;bufferPos+=consts.CENHDR}const entryHeaderSize=entry.fnameLen+entry.extraLen+entry.comLen;const advanceBytes=entryHeaderSize+(op.entriesLeft>1?consts.CENHDR:0);if(bufferLength-bufferPos<advanceBytes){op.win.moveRight(chunkSize,readEntriesCallback,bufferPos);op.move=true;return}entry.read(buffer,bufferPos,textDecoder);if(!config.skipEntryNameValidation){entry.validateName()}if(entries2){entries2[entry.name]=entry}that.emit("entry",entry);op.entry=entry=null;op.entriesLeft--;op.pos+=entryHeaderSize;bufferPos+=entryHeaderSize}that.emit("ready")}catch(err2){that.emit("error",err2)}}function checkEntriesExist(){if(!entries2){throw new Error("storeEntries disabled")}}Object.defineProperty(this,"ready",{get(){return ready}});this.entry=function(name){checkEntriesExist();return entries2[name]};this.entries=function(){checkEntriesExist();return entries2};this.stream=function(entry,callback){return this.openEntry(entry,(err,entry2)=>{if(err){return callback(err)}const offset=dataOffset(entry2);let entryStream=new EntryDataReaderStream(fd,offset,entry2.compressedSize);if(entry2.method===consts.STORED){}else if(entry2.method===consts.DEFLATED){entryStream=entryStream.pipe(zlib2.createInflateRaw())}else{return callback(new Error("Unknown compression method: "+entry2.method))}if(canVerifyCrc(entry2)){entryStream=entryStream.pipe(new EntryVerifyStream(entryStream,entry2.crc,entry2.size))}callback(null,entryStream)},false)};this.entryDataSync=function(entry){let err=null;this.openEntry(entry,(e,en)=>{err=e;entry=en},true);if(err){throw err}let data=Buffer.alloc(entry.compressedSize);new FsRead(fd,data,0,entry.compressedSize,dataOffset(entry),e=>{err=e}).read(true);if(err){throw err}if(entry.method===consts.STORED){}else if(entry.method===consts.DEFLATED||entry.method===consts.ENHANCED_DEFLATED){data=zlib2.inflateRawSync(data)}else{throw new Error("Unknown compression method: "+entry.method)}if(data.length!==entry.size){throw new Error("Invalid size")}if(canVerifyCrc(entry)){const verify=new CrcVerify(entry.crc,entry.size);verify.data(data)}return data};this.openEntry=function(entry,callback,sync){if(typeof entry==="string"){checkEntriesExist();entry=entries2[entry];if(!entry){return callback(new Error("Entry not found"))}}if(!entry.isFile){return callback(new Error("Entry is not file"))}if(!fd){return callback(new Error("Archive closed"))}const buffer=Buffer.alloc(consts.LOCHDR);new FsRead(fd,buffer,0,buffer.length,entry.offset,err=>{if(err){return callback(err)}let readEx;try{entry.readDataHeader(buffer);if(entry.encrypted){readEx=new Error("Entry encrypted")}}catch(ex){readEx=ex}callback(readEx,entry)}).read(sync)};function dataOffset(entry){return entry.offset+consts.LOCHDR+entry.fnameLen+entry.extraLen}function canVerifyCrc(entry){return(entry.flags&8)!==8}function extract(entry,outPath,callback){that.stream(entry,(err,stm)=>{if(err){callback(err)}else{let fsStm,errThrown;stm.on("error",err2=>{errThrown=err2;if(fsStm){stm.unpipe(fsStm);fsStm.close(()=>{callback(err2)})}});fs14.open(outPath,"w",(err2,fdFile)=>{if(err2){return callback(err2)}if(errThrown){fs14.close(fd,()=>{callback(errThrown)});return}fsStm=fs14.createWriteStream(outPath,{fd:fdFile});fsStm.on("finish",()=>{that.emit("extract",entry,outPath);if(!errThrown){callback()}});stm.pipe(fsStm)})}})}function createDirectories(baseDir,dirs,callback){if(!dirs.length){return callback()}let dir=dirs.shift();dir=path27.join(baseDir,path27.join(...dir));fs14.mkdir(dir,{recursive:true},err=>{if(err&&err.code!=="EEXIST"){return callback(err)}createDirectories(baseDir,dirs,callback)})}function extractFiles(baseDir,baseRelPath,files,callback,extractedCount){if(!files.length){return callback(null,extractedCount)}const file=files.shift();const targetPath=path27.join(baseDir,file.name.replace(baseRelPath,""));extract(file,targetPath,err=>{if(err){return callback(err,extractedCount)}extractFiles(baseDir,baseRelPath,files,callback,extractedCount+1)})}this.extract=function(entry,outPath,callback){let entryName=entry||"";if(typeof entry==="string"){entry=this.entry(entry);if(entry){entryName=entry.name}else{if(entryName.length&&entryName[entryName.length-1]!=="/"){entryName+="/"}}}if(!entry||entry.isDirectory){const files=[],dirs=[],allDirs={};for(const e in entries2){if(Object.prototype.hasOwnProperty.call(entries2,e)&&e.lastIndexOf(entryName,0)===0){let relPath=e.replace(entryName,"");const childEntry=entries2[e];if(childEntry.isFile){files.push(childEntry);relPath=path27.dirname(relPath)}if(relPath&&!allDirs[relPath]&&relPath!=="."){allDirs[relPath]=true;let parts=relPath.split("/").filter(f=>{return f});if(parts.length){dirs.push(parts)}while(parts.length>1){parts=parts.slice(0,parts.length-1);const partsPath=parts.join("/");if(allDirs[partsPath]||partsPath==="."){break}allDirs[partsPath]=true;dirs.push(parts)}}}}dirs.sort((x,y)=>{return x.length-y.length});if(dirs.length){createDirectories(outPath,dirs,err=>{if(err){callback(err)}else{extractFiles(outPath,entryName,files,callback,0)}})}else{extractFiles(outPath,entryName,files,callback,0)}}else{fs14.stat(outPath,(err,stat3)=>{if(stat3&&stat3.isDirectory()){extract(entry,path27.join(outPath,path27.basename(entry.name)),callback)}else{extract(entry,outPath,callback)}})}};this.close=function(callback){if(closed||!fd){closed=true;if(callback){callback()}}else{closed=true;fs14.close(fd,err=>{fd=null;if(callback){callback(err)}})}};const originalEmit=events.EventEmitter.prototype.emit;this.emit=function(...args2){if(!closed){return originalEmit.call(this,...args2)}}};StreamZip2.setFs=function(customFs){fs14=customFs};StreamZip2.debugLog=(...args2)=>{if(StreamZip2.debug){console.log(...args2)}};util4.inherits(StreamZip2,events.EventEmitter);var propZip=Symbol("zip");StreamZip2.async=class StreamZipAsync extends events.EventEmitter{constructor(config){super();const zip2=new StreamZip2(config);zip2.on("entry",entry=>this.emit("entry",entry));zip2.on("extract",(entry,outPath)=>this.emit("extract",entry,outPath));this[propZip]=new Promise((resolve,reject2)=>{zip2.on("ready",()=>{zip2.removeListener("error",reject2);resolve(zip2)});zip2.on("error",reject2)})}get entriesCount(){return this[propZip].then(zip2=>zip2.entriesCount)}get comment(){return this[propZip].then(zip2=>zip2.comment)}async entry(name){const zip2=await this[propZip];return zip2.entry(name)}async entries(){const zip2=await this[propZip];return zip2.entries()}async stream(entry){const zip2=await this[propZip];return new Promise((resolve,reject2)=>{zip2.stream(entry,(err,stm)=>{if(err){reject2(err)}else{resolve(stm)}})})}async entryData(entry){const stm=await this.stream(entry);return new Promise((resolve,reject2)=>{const data=[];stm.on("data",chunk2=>data.push(chunk2));stm.on("end",()=>{resolve(Buffer.concat(data))});stm.on("error",err=>{stm.removeAllListeners("end");reject2(err)})})}async extract(entry,outPath){const zip2=await this[propZip];return new Promise((resolve,reject2)=>{zip2.extract(entry,outPath,(err,res)=>{if(err){reject2(err)}else{resolve(res)}})})}async close(){const zip2=await this[propZip];return new Promise((resolve,reject2)=>{zip2.close(err=>{if(err){reject2(err)}else{resolve()}})})}};var CentralDirectoryHeader=class{read(data){if(data.length!==consts.ENDHDR||data.readUInt32LE(0)!==consts.ENDSIG){throw new Error("Invalid central directory")}this.volumeEntries=data.readUInt16LE(consts.ENDSUB);this.totalEntries=data.readUInt16LE(consts.ENDTOT);this.size=data.readUInt32LE(consts.ENDSIZ);this.offset=data.readUInt32LE(consts.ENDOFF);this.commentLength=data.readUInt16LE(consts.ENDCOM)}};var CentralDirectoryLoc64Header=class{read(data){if(data.length!==consts.ENDL64HDR||data.readUInt32LE(0)!==consts.ENDL64SIG){throw new Error("Invalid zip64 central directory locator")}this.headerOffset=readUInt64LE(data,consts.ENDSUB)}};var CentralDirectoryZip64Header=class{read(data){if(data.length!==consts.END64HDR||data.readUInt32LE(0)!==consts.END64SIG){throw new Error("Invalid central directory")}this.volumeEntries=readUInt64LE(data,consts.END64SUB);this.totalEntries=readUInt64LE(data,consts.END64TOT);this.size=readUInt64LE(data,consts.END64SIZ);this.offset=readUInt64LE(data,consts.END64OFF)}};var ZipEntry=class{readHeader(data,offset){if(data.length<offset+consts.CENHDR||data.readUInt32LE(offset)!==consts.CENSIG){throw new Error("Invalid entry header")}this.verMade=data.readUInt16LE(offset+consts.CENVEM);this.version=data.readUInt16LE(offset+consts.CENVER);this.flags=data.readUInt16LE(offset+consts.CENFLG);this.method=data.readUInt16LE(offset+consts.CENHOW);const timebytes=data.readUInt16LE(offset+consts.CENTIM);const datebytes=data.readUInt16LE(offset+consts.CENTIM+2);this.time=parseZipTime(timebytes,datebytes);this.crc=data.readUInt32LE(offset+consts.CENCRC);this.compressedSize=data.readUInt32LE(offset+consts.CENSIZ);this.size=data.readUInt32LE(offset+consts.CENLEN);this.fnameLen=data.readUInt16LE(offset+consts.CENNAM);this.extraLen=data.readUInt16LE(offset+consts.CENEXT);this.comLen=data.readUInt16LE(offset+consts.CENCOM);this.diskStart=data.readUInt16LE(offset+consts.CENDSK);this.inattr=data.readUInt16LE(offset+consts.CENATT);this.attr=data.readUInt32LE(offset+consts.CENATX);this.offset=data.readUInt32LE(offset+consts.CENOFF)}readDataHeader(data){if(data.readUInt32LE(0)!==consts.LOCSIG){throw new Error("Invalid local header")}this.version=data.readUInt16LE(consts.LOCVER);this.flags=data.readUInt16LE(consts.LOCFLG);this.method=data.readUInt16LE(consts.LOCHOW);const timebytes=data.readUInt16LE(consts.LOCTIM);const datebytes=data.readUInt16LE(consts.LOCTIM+2);this.time=parseZipTime(timebytes,datebytes);this.crc=data.readUInt32LE(consts.LOCCRC)||this.crc;const compressedSize=data.readUInt32LE(consts.LOCSIZ);if(compressedSize&&compressedSize!==consts.EF_ZIP64_OR_32){this.compressedSize=compressedSize}const size2=data.readUInt32LE(consts.LOCLEN);if(size2&&size2!==consts.EF_ZIP64_OR_32){this.size=size2}this.fnameLen=data.readUInt16LE(consts.LOCNAM);this.extraLen=data.readUInt16LE(consts.LOCEXT)}read(data,offset,textDecoder){const nameData=data.slice(offset,offset+=this.fnameLen);this.name=textDecoder?textDecoder.decode(new Uint8Array(nameData)):nameData.toString("utf8");const lastChar=data[offset-1];this.isDirectory=lastChar===47||lastChar===92;if(this.extraLen){this.readExtra(data,offset);offset+=this.extraLen}this.comment=this.comLen?data.slice(offset,offset+this.comLen).toString():null}validateName(){if(/\\|^\w+:|^\/|(^|\/)\.\.(\/|$)/.test(this.name)){throw new Error("Malicious entry: "+this.name)}}readExtra(data,offset){let signature,size2;const maxPos=offset+this.extraLen;while(offset<maxPos){signature=data.readUInt16LE(offset);offset+=2;size2=data.readUInt16LE(offset);offset+=2;if(consts.ID_ZIP64===signature){this.parseZip64Extra(data,offset,size2)}offset+=size2}}parseZip64Extra(data,offset,length){if(length>=8&&this.size===consts.EF_ZIP64_OR_32){this.size=readUInt64LE(data,offset);offset+=8;length-=8}if(length>=8&&this.compressedSize===consts.EF_ZIP64_OR_32){this.compressedSize=readUInt64LE(data,offset);offset+=8;length-=8}if(length>=8&&this.offset===consts.EF_ZIP64_OR_32){this.offset=readUInt64LE(data,offset);offset+=8;length-=8}if(length>=4&&this.diskStart===consts.EF_ZIP64_OR_16){this.diskStart=data.readUInt32LE(offset)}}get encrypted(){return(this.flags&consts.FLG_ENTRY_ENC)===consts.FLG_ENTRY_ENC}get isFile(){return!this.isDirectory}};var FsRead=class{constructor(fd,buffer,offset,length,position,callback){this.fd=fd;this.buffer=buffer;this.offset=offset;this.length=length;this.position=position;this.callback=callback;this.bytesRead=0;this.waiting=false}read(sync){StreamZip2.debugLog("read",this.position,this.bytesRead,this.length,this.offset);this.waiting=true;let err;if(sync){let bytesRead=0;try{bytesRead=fs14.readSync(this.fd,this.buffer,this.offset+this.bytesRead,this.length-this.bytesRead,this.position+this.bytesRead)}catch(e){err=e}this.readCallback(sync,err,err?bytesRead:null)}else{fs14.read(this.fd,this.buffer,this.offset+this.bytesRead,this.length-this.bytesRead,this.position+this.bytesRead,this.readCallback.bind(this,sync))}}readCallback(sync,err,bytesRead){if(typeof bytesRead==="number"){this.bytesRead+=bytesRead}if(err||!bytesRead||this.bytesRead===this.length){this.waiting=false;return this.callback(err,this.bytesRead)}else{this.read(sync)}}};var FileWindowBuffer=class{constructor(fd){this.position=0;this.buffer=Buffer.alloc(0);this.fd=fd;this.fsOp=null}checkOp(){if(this.fsOp&&this.fsOp.waiting){throw new Error("Operation in progress")}}read(pos,length,callback){this.checkOp();if(this.buffer.length<length){this.buffer=Buffer.alloc(length)}this.position=pos;this.fsOp=new FsRead(this.fd,this.buffer,0,length,this.position,callback).read()}expandLeft(length,callback){this.checkOp();this.buffer=Buffer.concat([Buffer.alloc(length),this.buffer]);this.position-=length;if(this.position<0){this.position=0}this.fsOp=new FsRead(this.fd,this.buffer,0,length,this.position,callback).read()}expandRight(length,callback){this.checkOp();const offset=this.buffer.length;this.buffer=Buffer.concat([this.buffer,Buffer.alloc(length)]);this.fsOp=new FsRead(this.fd,this.buffer,offset,length,this.position+offset,callback).read()}moveRight(length,callback,shift){this.checkOp();if(shift){this.buffer.copy(this.buffer,0,shift)}else{shift=0}this.position+=shift;this.fsOp=new FsRead(this.fd,this.buffer,this.buffer.length-shift,shift,this.position+this.buffer.length-shift,callback).read()}};var EntryDataReaderStream=class extends stream3.Readable{constructor(fd,offset,length){super();this.fd=fd;this.offset=offset;this.length=length;this.pos=0;this.readCallback=this.readCallback.bind(this)}_read(n){const buffer=Buffer.alloc(Math.min(n,this.length-this.pos));if(buffer.length){fs14.read(this.fd,buffer,0,buffer.length,this.offset+this.pos,this.readCallback)}else{this.push(null)}}readCallback(err,bytesRead,buffer){this.pos+=bytesRead;if(err){this.emit("error",err);this.push(null)}else if(!bytesRead){this.push(null)}else{if(bytesRead!==buffer.length){buffer=buffer.slice(0,bytesRead)}this.push(buffer)}}};var EntryVerifyStream=class extends stream3.Transform{constructor(baseStm,crc,size2){super();this.verify=new CrcVerify(crc,size2);baseStm.on("error",e=>{this.emit("error",e)})}_transform(data,encoding,callback){let err;try{this.verify.data(data)}catch(e){err=e}callback(err,data)}};var CrcVerify=class _CrcVerify{constructor(crc,size2){this.crc=crc;this.size=size2;this.state={crc:~0,size:0}}data(data){const crcTable=_CrcVerify.getCrcTable();let crc=this.state.crc;let off=0;let len=data.length;while(--len>=0){crc=crcTable[(crc^data[off++])&255]^crc>>>8}this.state.crc=crc;this.state.size+=data.length;if(this.state.size>=this.size){const buf=Buffer.alloc(4);buf.writeInt32LE(~this.state.crc&4294967295,0);crc=buf.readUInt32LE(0);if(crc!==this.crc){throw new Error("Invalid CRC")}if(this.state.size!==this.size){throw new Error("Invalid size")}}}static getCrcTable(){let crcTable=_CrcVerify.crcTable;if(!crcTable){_CrcVerify.crcTable=crcTable=[];const b=Buffer.alloc(4);for(let n=0;n<256;n++){let c=n;for(let k=8;--k>=0;){if((c&1)!==0){c=3988292384^c>>>1}else{c=c>>>1}}if(c<0){b.writeInt32LE(c,0);c=b.readUInt32LE(0)}crcTable[n]=c}}return crcTable}};function parseZipTime(timebytes,datebytes){const timebits=toBits(timebytes,16);const datebits=toBits(datebytes,16);const mt={h:parseInt(timebits.slice(0,5).join(""),2),m:parseInt(timebits.slice(5,11).join(""),2),s:parseInt(timebits.slice(11,16).join(""),2)*2,Y:parseInt(datebits.slice(0,7).join(""),2)+1980,M:parseInt(datebits.slice(7,11).join(""),2),D:parseInt(datebits.slice(11,16).join(""),2)};const dt_str=[mt.Y,mt.M,mt.D].join("-")+" "+[mt.h,mt.m,mt.s].join(":")+" GMT+0";return new Date(dt_str).getTime()}function toBits(dec,size2){let b=(dec>>>0).toString(2);while(b.length<size2){b="0"+b}return b.split("")}function readUInt64LE(buffer,offset){return buffer.readUInt32LE(offset+4)*4294967296+buffer.readUInt32LE(offset)}module2.exports=StreamZip2}});var require_SqlString=__commonJS({"node_modules/sqlstring/lib/SqlString.js"(exports2){var SqlString=exports2;var ID_GLOBAL_REGEXP=/`/g;var QUAL_GLOBAL_REGEXP=/\./g;var CHARS_GLOBAL_REGEXP=/[\0\b\t\n\r\x1a\"\'\\]/g;var CHARS_ESCAPE_MAP={"\0":"\\0","\b":"\\b","	":"\\t","\n":"\\n","\r":"\\r","":"\\Z",'"':'\\"',"'":"\\'","\\":"\\\\"};SqlString.escapeId=function escapeId(val,forbidQualified){if(Array.isArray(val)){var sql="";for(var i=0;i<val.length;i++){sql+=(i===0?"":", ")+SqlString.escapeId(val[i],forbidQualified)}return sql}else if(forbidQualified){return"`"+String(val).replace(ID_GLOBAL_REGEXP,"``")+"`"}else{return"`"+String(val).replace(ID_GLOBAL_REGEXP,"``").replace(QUAL_GLOBAL_REGEXP,"`.`")+"`"}};SqlString.escape=function escape3(val,stringifyObjects,timeZone){if(val===void 0||val===null){return"NULL"}switch(typeof val){case"boolean":return val?"true":"false";case"number":return val+"";case"object":if(Object.prototype.toString.call(val)==="[object Date]"){return SqlString.dateToString(val,timeZone||"local")}else if(Array.isArray(val)){return SqlString.arrayToList(val,timeZone)}else if(Buffer.isBuffer(val)){return SqlString.bufferToString(val)}else if(typeof val.toSqlString==="function"){return String(val.toSqlString())}else if(stringifyObjects){return escapeString2(val.toString())}else{return SqlString.objectToValues(val,timeZone)}default:return escapeString2(val)}};SqlString.arrayToList=function arrayToList(array,timeZone){var sql="";for(var i=0;i<array.length;i++){var val=array[i];if(Array.isArray(val)){sql+=(i===0?"":", ")+"("+SqlString.arrayToList(val,timeZone)+")"}else{sql+=(i===0?"":", ")+SqlString.escape(val,true,timeZone)}}return sql};SqlString.format=function format2(sql,values2,stringifyObjects,timeZone){if(values2==null){return sql}if(!Array.isArray(values2)){values2=[values2]}var chunkIndex=0;var placeholdersRegex=/\?+/g;var result2="";var valuesIndex=0;var match;while(valuesIndex<values2.length&&(match=placeholdersRegex.exec(sql))){var len=match[0].length;if(len>2){continue}var value=len===2?SqlString.escapeId(values2[valuesIndex]):SqlString.escape(values2[valuesIndex],stringifyObjects,timeZone);result2+=sql.slice(chunkIndex,match.index)+value;chunkIndex=placeholdersRegex.lastIndex;valuesIndex++}if(chunkIndex===0){return sql}if(chunkIndex<sql.length){return result2+sql.slice(chunkIndex)}return result2};SqlString.dateToString=function dateToString(date,timeZone){var dt=new Date(date);if(isNaN(dt.getTime())){return"NULL"}var year;var month;var day;var hour;var minute;var second;var millisecond;if(timeZone==="local"){year=dt.getFullYear();month=dt.getMonth()+1;day=dt.getDate();hour=dt.getHours();minute=dt.getMinutes();second=dt.getSeconds();millisecond=dt.getMilliseconds()}else{var tz=convertTimezone(timeZone);if(tz!==false&&tz!==0){dt.setTime(dt.getTime()+tz*6e4)}year=dt.getUTCFullYear();month=dt.getUTCMonth()+1;day=dt.getUTCDate();hour=dt.getUTCHours();minute=dt.getUTCMinutes();second=dt.getUTCSeconds();millisecond=dt.getUTCMilliseconds()}var str2=zeroPad(year,4)+"-"+zeroPad(month,2)+"-"+zeroPad(day,2)+" "+zeroPad(hour,2)+":"+zeroPad(minute,2)+":"+zeroPad(second,2)+"."+zeroPad(millisecond,3);return escapeString2(str2)};SqlString.bufferToString=function bufferToString(buffer){return"X"+escapeString2(buffer.toString("hex"))};SqlString.objectToValues=function objectToValues(object,timeZone){var sql="";for(var key in object){var val=object[key];if(typeof val==="function"){continue}sql+=(sql.length===0?"":", ")+SqlString.escapeId(key)+" = "+SqlString.escape(val,true,timeZone)}return sql};SqlString.raw=function raw(sql){if(typeof sql!=="string"){throw new TypeError("argument sql must be a string")}return{toSqlString:function toSqlString(){return sql}}};function escapeString2(val){var chunkIndex=CHARS_GLOBAL_REGEXP.lastIndex=0;var escapedVal="";var match;while(match=CHARS_GLOBAL_REGEXP.exec(val)){escapedVal+=val.slice(chunkIndex,match.index)+CHARS_ESCAPE_MAP[match[0]];chunkIndex=CHARS_GLOBAL_REGEXP.lastIndex}if(chunkIndex===0){return"'"+val+"'"}if(chunkIndex<val.length){return"'"+escapedVal+val.slice(chunkIndex)+"'"}return"'"+escapedVal+"'"}function zeroPad(number2,length){number2=number2.toString();while(number2.length<length){number2="0"+number2}return number2}function convertTimezone(tz){if(tz==="Z"){return 0}var m=tz.match(/([\+\-\s])(\d\d):?(\d\d)?/);if(m){return(m[1]==="-"?-1:1)*(parseInt(m[2],10)+(m[3]?parseInt(m[3],10):0)/60)*60}return false}}});var require_sqlstring=__commonJS({"node_modules/sqlstring/index.js"(exports2,module2){module2.exports=require_SqlString()}});var require_lib3=__commonJS({"node_modules/lru.min/lib/index.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.createLRU=void 0;var createLRU=options=>{let{max:max3,onEviction}=options;if(!(Number.isInteger(max3)&&max3>0))throw new TypeError("`max` must be a positive integer");let size2=0;let head2=0;let tail2=0;let free=[];const keyMap=new Map;const keyList=new Array(max3).fill(void 0);const valList=new Array(max3).fill(void 0);const next=new Array(max3).fill(0);const prev=new Array(max3).fill(0);const setTail=(index,type2)=>{if(index===tail2)return;const nextIndex=next[index];const prevIndex=prev[index];if(index===head2)head2=nextIndex;else if(type2==="get"||prevIndex!==0)next[prevIndex]=nextIndex;if(nextIndex!==0)prev[nextIndex]=prevIndex;next[tail2]=index;prev[index]=tail2;next[index]=0;tail2=index};const _evict=()=>{const evictHead=head2;const key=keyList[evictHead];onEviction===null||onEviction===void 0?void 0:onEviction(key,valList[evictHead]);keyMap.delete(key);keyList[evictHead]=void 0;valList[evictHead]=void 0;head2=next[evictHead];if(head2!==0)prev[head2]=0;size2--;if(size2===0)head2=tail2=0;free.push(evictHead);return evictHead};return{set(key,value){if(key===void 0)return;let index=keyMap.get(key);if(index===void 0){index=size2===max3?_evict():free.length>0?free.pop():size2;keyMap.set(key,index);keyList[index]=key;size2++}else onEviction===null||onEviction===void 0?void 0:onEviction(key,valList[index]);valList[index]=value;if(size2===1)head2=tail2=index;else setTail(index,"set")},get(key){const index=keyMap.get(key);if(index===void 0)return;if(index!==tail2)setTail(index,"get");return valList[index]},peek:key=>{const index=keyMap.get(key);return index!==void 0?valList[index]:void 0},has:key=>keyMap.has(key),*keys(){let current=tail2;for(let i=0;i<size2;i++){yield keyList[current];current=prev[current]}},*values(){let current=tail2;for(let i=0;i<size2;i++){yield valList[current];current=prev[current]}},*entries(){let current=tail2;for(let i=0;i<size2;i++){yield[keyList[current],valList[current]];current=prev[current]}},forEach:callback=>{let current=tail2;for(let i=0;i<size2;i++){const key=keyList[current];const value=valList[current];callback(value,key);current=prev[current]}},delete(key){const index=keyMap.get(key);if(index===void 0)return false;onEviction===null||onEviction===void 0?void 0:onEviction(key,valList[index]);keyMap.delete(key);free.push(index);keyList[index]=void 0;valList[index]=void 0;const prevIndex=prev[index];const nextIndex=next[index];if(prevIndex!==0)next[prevIndex]=nextIndex;if(nextIndex!==0)prev[nextIndex]=prevIndex;if(index===head2)head2=nextIndex;if(index===tail2)tail2=prevIndex;size2--;return true},evict:number2=>{let toPrune=Math.min(number2,size2);while(toPrune>0){_evict();toPrune--}},clear(){if(typeof onEviction==="function"){const iterator=keyMap.values();for(let result2=iterator.next();!result2.done;result2=iterator.next())onEviction(keyList[result2.value],valList[result2.value])}keyMap.clear();keyList.fill(void 0);valList.fill(void 0);free=[];size2=0;head2=tail2=0},resize:newMax=>{if(!(Number.isInteger(newMax)&&newMax>0))throw new TypeError("`max` must be a positive integer");if(newMax===max3)return;if(newMax<max3){let current=tail2;const preserve=Math.min(size2,newMax);const remove2=size2-preserve;const newKeyList=new Array(newMax);const newValList=new Array(newMax);const newNext=new Array(newMax);const newPrev=new Array(newMax);for(let i=1;i<=remove2;i++)onEviction===null||onEviction===void 0?void 0:onEviction(keyList[i],valList[i]);for(let i=preserve-1;i>=0;i--){newKeyList[i]=keyList[current];newValList[i]=valList[current];newNext[i]=i+1;newPrev[i]=i-1;keyMap.set(newKeyList[i],i);current=prev[current]}head2=0;tail2=preserve-1;size2=preserve;keyList.length=newMax;valList.length=newMax;next.length=newMax;prev.length=newMax;for(let i=0;i<preserve;i++){keyList[i]=newKeyList[i];valList[i]=newValList[i];next[i]=newNext[i];prev[i]=newPrev[i]}free=[];for(let i=preserve;i<newMax;i++)free.push(i)}else{const fill2=newMax-max3;keyList.push(...new Array(fill2).fill(void 0));valList.push(...new Array(fill2).fill(void 0));next.push(...new Array(fill2).fill(0));prev.push(...new Array(fill2).fill(0))}max3=newMax},get max(){return max3},get size(){return size2},get available(){return max3-size2}}};exports2.createLRU=createLRU}});var require_parser_cache=__commonJS({"node_modules/mysql2/lib/parsers/parser_cache.js"(exports2,module2){"use strict";var{createLRU}=require_lib3();var parserCache=createLRU({max:15e3});function keyFromFields(type2,fields,options,config){const res=[type2,typeof options.nestTables,options.nestTables,Boolean(options.rowsAsArray),Boolean(options.supportBigNumbers||config.supportBigNumbers),Boolean(options.bigNumberStrings||config.bigNumberStrings),typeof options.typeCast,options.timezone||config.timezone,Boolean(options.decimalNumbers),options.dateStrings];for(let i=0;i<fields.length;++i){const field=fields[i];res.push([field.name,field.columnType,field.length,field.schema,field.table,field.flags,field.characterSet])}return JSON.stringify(res,null,0)}function getParser(type2,fields,options,config,compiler){const key=keyFromFields(type2,fields,options,config);let parser=parserCache.get(key);if(parser){return parser}parser=compiler(fields,options,config);parserCache.set(key,parser);return parser}function setMaxCache(max3){parserCache.resize(max3)}function clearCache(){parserCache.clear()}module2.exports={getParser,setMaxCache,clearCache,_keyFromFields:keyFromFields}}});var require_denque=__commonJS({"node_modules/denque/index.js"(exports2,module2){"use strict";function Denque(array,options){var options=options||{};this._capacity=options.capacity;this._head=0;this._tail=0;if(Array.isArray(array)){this._fromArray(array)}else{this._capacityMask=3;this._list=new Array(4)}}Denque.prototype.peekAt=function peekAt(index){var i=index;if(i!==(i|0)){return void 0}var len=this.size();if(i>=len||i<-len)return void 0;if(i<0)i+=len;i=this._head+i&this._capacityMask;return this._list[i]};Denque.prototype.get=function get4(i){return this.peekAt(i)};Denque.prototype.peek=function peek(){if(this._head===this._tail)return void 0;return this._list[this._head]};Denque.prototype.peekFront=function peekFront(){return this.peek()};Denque.prototype.peekBack=function peekBack(){return this.peekAt(-1)};Object.defineProperty(Denque.prototype,"length",{get:function length(){return this.size()}});Denque.prototype.size=function size2(){if(this._head===this._tail)return 0;if(this._head<this._tail)return this._tail-this._head;else return this._capacityMask+1-(this._head-this._tail)};Denque.prototype.unshift=function unshift(item){if(arguments.length===0)return this.size();var len=this._list.length;this._head=this._head-1+len&this._capacityMask;this._list[this._head]=item;if(this._tail===this._head)this._growArray();if(this._capacity&&this.size()>this._capacity)this.pop();if(this._head<this._tail)return this._tail-this._head;else return this._capacityMask+1-(this._head-this._tail)};Denque.prototype.shift=function shift(){var head2=this._head;if(head2===this._tail)return void 0;var item=this._list[head2];this._list[head2]=void 0;this._head=head2+1&this._capacityMask;if(head2<2&&this._tail>1e4&&this._tail<=this._list.length>>>2)this._shrinkArray();return item};Denque.prototype.push=function push(item){if(arguments.length===0)return this.size();var tail2=this._tail;this._list[tail2]=item;this._tail=tail2+1&this._capacityMask;if(this._tail===this._head){this._growArray()}if(this._capacity&&this.size()>this._capacity){this.shift()}if(this._head<this._tail)return this._tail-this._head;else return this._capacityMask+1-(this._head-this._tail)};Denque.prototype.pop=function pop(){var tail2=this._tail;if(tail2===this._head)return void 0;var len=this._list.length;this._tail=tail2-1+len&this._capacityMask;var item=this._list[this._tail];this._list[this._tail]=void 0;if(this._head<2&&tail2>1e4&&tail2<=len>>>2)this._shrinkArray();return item};Denque.prototype.removeOne=function removeOne(index){var i=index;if(i!==(i|0)){return void 0}if(this._head===this._tail)return void 0;var size2=this.size();var len=this._list.length;if(i>=size2||i<-size2)return void 0;if(i<0)i+=size2;i=this._head+i&this._capacityMask;var item=this._list[i];var k;if(index<size2/2){for(k=index;k>0;k--){this._list[i]=this._list[i=i-1+len&this._capacityMask]}this._list[i]=void 0;this._head=this._head+1+len&this._capacityMask}else{for(k=size2-1-index;k>0;k--){this._list[i]=this._list[i=i+1+len&this._capacityMask]}this._list[i]=void 0;this._tail=this._tail-1+len&this._capacityMask}return item};Denque.prototype.remove=function remove2(index,count){var i=index;var removed;var del_count=count;if(i!==(i|0)){return void 0}if(this._head===this._tail)return void 0;var size2=this.size();var len=this._list.length;if(i>=size2||i<-size2||count<1)return void 0;if(i<0)i+=size2;if(count===1||!count){removed=new Array(1);removed[0]=this.removeOne(i);return removed}if(i===0&&i+count>=size2){removed=this.toArray();this.clear();return removed}if(i+count>size2)count=size2-i;var k;removed=new Array(count);for(k=0;k<count;k++){removed[k]=this._list[this._head+i+k&this._capacityMask]}i=this._head+i&this._capacityMask;if(index+count===size2){this._tail=this._tail-count+len&this._capacityMask;for(k=count;k>0;k--){this._list[i=i+1+len&this._capacityMask]=void 0}return removed}if(index===0){this._head=this._head+count+len&this._capacityMask;for(k=count-1;k>0;k--){this._list[i=i+1+len&this._capacityMask]=void 0}return removed}if(i<size2/2){this._head=this._head+index+count+len&this._capacityMask;for(k=index;k>0;k--){this.unshift(this._list[i=i-1+len&this._capacityMask])}i=this._head-1+len&this._capacityMask;while(del_count>0){this._list[i=i-1+len&this._capacityMask]=void 0;del_count--}if(index<0)this._tail=i}else{this._tail=i;i=i+count+len&this._capacityMask;for(k=size2-(count+index);k>0;k--){this.push(this._list[i++])}i=this._tail;while(del_count>0){this._list[i=i+1+len&this._capacityMask]=void 0;del_count--}}if(this._head<2&&this._tail>1e4&&this._tail<=len>>>2)this._shrinkArray();return removed};Denque.prototype.splice=function splice4(index,count){var i=index;if(i!==(i|0)){return void 0}var size2=this.size();if(i<0)i+=size2;if(i>size2)return void 0;if(arguments.length>2){var k;var temp;var removed;var arg_len=arguments.length;var len=this._list.length;var arguments_index=2;if(!size2||i<size2/2){temp=new Array(i);for(k=0;k<i;k++){temp[k]=this._list[this._head+k&this._capacityMask]}if(count===0){removed=[];if(i>0){this._head=this._head+i+len&this._capacityMask}}else{removed=this.remove(i,count);this._head=this._head+i+len&this._capacityMask}while(arg_len>arguments_index){this.unshift(arguments[--arg_len])}for(k=i;k>0;k--){this.unshift(temp[k-1])}}else{temp=new Array(size2-(i+count));var leng=temp.length;for(k=0;k<leng;k++){temp[k]=this._list[this._head+i+count+k&this._capacityMask]}if(count===0){removed=[];if(i!=size2){this._tail=this._head+i+len&this._capacityMask}}else{removed=this.remove(i,count);this._tail=this._tail-leng+len&this._capacityMask}while(arguments_index<arg_len){this.push(arguments[arguments_index++])}for(k=0;k<leng;k++){this.push(temp[k])}}return removed}else{return this.remove(i,count)}};Denque.prototype.clear=function clear(){this._list=new Array(this._list.length);this._head=0;this._tail=0};Denque.prototype.isEmpty=function isEmpty2(){return this._head===this._tail};Denque.prototype.toArray=function toArray3(){return this._copyArray(false)};Denque.prototype._fromArray=function _fromArray(array){var length=array.length;var capacity=this._nextPowerOf2(length);this._list=new Array(capacity);this._capacityMask=capacity-1;this._tail=length;for(var i=0;i<length;i++)this._list[i]=array[i]};Denque.prototype._copyArray=function _copyArray(fullCopy,size2){var src=this._list;var capacity=src.length;var length=this.length;size2=size2|length;if(size2==length&&this._head<this._tail){return this._list.slice(this._head,this._tail)}var dest=new Array(size2);var k=0;var i;if(fullCopy||this._head>this._tail){for(i=this._head;i<capacity;i++)dest[k++]=src[i];for(i=0;i<this._tail;i++)dest[k++]=src[i]}else{for(i=this._head;i<this._tail;i++)dest[k++]=src[i]}return dest};Denque.prototype._growArray=function _growArray(){if(this._head!=0){var newList=this._copyArray(true,this._list.length<<1);this._tail=this._list.length;this._head=0;this._list=newList}else{this._tail=this._list.length;this._list.length<<=1}this._capacityMask=this._capacityMask<<1|1};Denque.prototype._shrinkArray=function _shrinkArray(){this._list.length>>>=1;this._capacityMask>>>=1};Denque.prototype._nextPowerOf2=function _nextPowerOf2(num){var log2=Math.log(num)/Math.log(2);var nextPow2=1<<log2+1;return Math.max(nextPow2,4)};module2.exports=Denque}});var require_errors2=__commonJS({"node_modules/mysql2/lib/constants/errors.js"(exports2){"use strict";exports2.EE_CANTCREATEFILE=1;exports2.EE_READ=2;exports2.EE_WRITE=3;exports2.EE_BADCLOSE=4;exports2.EE_OUTOFMEMORY=5;exports2.EE_DELETE=6;exports2.EE_LINK=7;exports2.EE_EOFERR=9;exports2.EE_CANTLOCK=10;exports2.EE_CANTUNLOCK=11;exports2.EE_DIR=12;exports2.EE_STAT=13;exports2.EE_CANT_CHSIZE=14;exports2.EE_CANT_OPEN_STREAM=15;exports2.EE_GETWD=16;exports2.EE_SETWD=17;exports2.EE_LINK_WARNING=18;exports2.EE_OPEN_WARNING=19;exports2.EE_DISK_FULL=20;exports2.EE_CANT_MKDIR=21;exports2.EE_UNKNOWN_CHARSET=22;exports2.EE_OUT_OF_FILERESOURCES=23;exports2.EE_CANT_READLINK=24;exports2.EE_CANT_SYMLINK=25;exports2.EE_REALPATH=26;exports2.EE_SYNC=27;exports2.EE_UNKNOWN_COLLATION=28;exports2.EE_FILENOTFOUND=29;exports2.EE_FILE_NOT_CLOSED=30;exports2.EE_CHANGE_OWNERSHIP=31;exports2.EE_CHANGE_PERMISSIONS=32;exports2.EE_CANT_SEEK=33;exports2.EE_CAPACITY_EXCEEDED=34;exports2.EE_DISK_FULL_WITH_RETRY_MSG=35;exports2.EE_FAILED_TO_CREATE_TIMER=36;exports2.EE_FAILED_TO_DELETE_TIMER=37;exports2.EE_FAILED_TO_CREATE_TIMER_QUEUE=38;exports2.EE_FAILED_TO_START_TIMER_NOTIFY_THREAD=39;exports2.EE_FAILED_TO_CREATE_TIMER_NOTIFY_THREAD_INTERRUPT_EVENT=40;exports2.EE_EXITING_TIMER_NOTIFY_THREAD=41;exports2.EE_WIN_LIBRARY_LOAD_FAILED=42;exports2.EE_WIN_RUN_TIME_ERROR_CHECK=43;exports2.EE_FAILED_TO_DETERMINE_LARGE_PAGE_SIZE=44;exports2.EE_FAILED_TO_KILL_ALL_THREADS=45;exports2.EE_FAILED_TO_CREATE_IO_COMPLETION_PORT=46;exports2.EE_FAILED_TO_OPEN_DEFAULTS_FILE=47;exports2.EE_FAILED_TO_HANDLE_DEFAULTS_FILE=48;exports2.EE_WRONG_DIRECTIVE_IN_CONFIG_FILE=49;exports2.EE_SKIPPING_DIRECTIVE_DUE_TO_MAX_INCLUDE_RECURSION=50;exports2.EE_INCORRECT_GRP_DEFINITION_IN_CONFIG_FILE=51;exports2.EE_OPTION_WITHOUT_GRP_IN_CONFIG_FILE=52;exports2.EE_CONFIG_FILE_PERMISSION_ERROR=53;exports2.EE_IGNORE_WORLD_WRITABLE_CONFIG_FILE=54;exports2.EE_USING_DISABLED_OPTION=55;exports2.EE_USING_DISABLED_SHORT_OPTION=56;exports2.EE_USING_PASSWORD_ON_CLI_IS_INSECURE=57;exports2.EE_UNKNOWN_SUFFIX_FOR_VARIABLE=58;exports2.EE_SSL_ERROR_FROM_FILE=59;exports2.EE_SSL_ERROR=60;exports2.EE_NET_SEND_ERROR_IN_BOOTSTRAP=61;exports2.EE_PACKETS_OUT_OF_ORDER=62;exports2.EE_UNKNOWN_PROTOCOL_OPTION=63;exports2.EE_FAILED_TO_LOCATE_SERVER_PUBLIC_KEY=64;exports2.EE_PUBLIC_KEY_NOT_IN_PEM_FORMAT=65;exports2.EE_DEBUG_INFO=66;exports2.EE_UNKNOWN_VARIABLE=67;exports2.EE_UNKNOWN_OPTION=68;exports2.EE_UNKNOWN_SHORT_OPTION=69;exports2.EE_OPTION_WITHOUT_ARGUMENT=70;exports2.EE_OPTION_REQUIRES_ARGUMENT=71;exports2.EE_SHORT_OPTION_REQUIRES_ARGUMENT=72;exports2.EE_OPTION_IGNORED_DUE_TO_INVALID_VALUE=73;exports2.EE_OPTION_WITH_EMPTY_VALUE=74;exports2.EE_FAILED_TO_ASSIGN_MAX_VALUE_TO_OPTION=75;exports2.EE_INCORRECT_BOOLEAN_VALUE_FOR_OPTION=76;exports2.EE_FAILED_TO_SET_OPTION_VALUE=77;exports2.EE_INCORRECT_INT_VALUE_FOR_OPTION=78;exports2.EE_INCORRECT_UINT_VALUE_FOR_OPTION=79;exports2.EE_ADJUSTED_SIGNED_VALUE_FOR_OPTION=80;exports2.EE_ADJUSTED_UNSIGNED_VALUE_FOR_OPTION=81;exports2.EE_ADJUSTED_ULONGLONG_VALUE_FOR_OPTION=82;exports2.EE_ADJUSTED_DOUBLE_VALUE_FOR_OPTION=83;exports2.EE_INVALID_DECIMAL_VALUE_FOR_OPTION=84;exports2.EE_COLLATION_PARSER_ERROR=85;exports2.EE_FAILED_TO_RESET_BEFORE_PRIMARY_IGNORABLE_CHAR=86;exports2.EE_FAILED_TO_RESET_BEFORE_TERTIARY_IGNORABLE_CHAR=87;exports2.EE_SHIFT_CHAR_OUT_OF_RANGE=88;exports2.EE_RESET_CHAR_OUT_OF_RANGE=89;exports2.EE_UNKNOWN_LDML_TAG=90;exports2.EE_FAILED_TO_RESET_BEFORE_SECONDARY_IGNORABLE_CHAR=91;exports2.EE_FAILED_PROCESSING_DIRECTIVE=92;exports2.EE_PTHREAD_KILL_FAILED=93;exports2.HA_ERR_KEY_NOT_FOUND=120;exports2.HA_ERR_FOUND_DUPP_KEY=121;exports2.HA_ERR_INTERNAL_ERROR=122;exports2.HA_ERR_RECORD_CHANGED=123;exports2.HA_ERR_WRONG_INDEX=124;exports2.HA_ERR_ROLLED_BACK=125;exports2.HA_ERR_CRASHED=126;exports2.HA_ERR_WRONG_IN_RECORD=127;exports2.HA_ERR_OUT_OF_MEM=128;exports2.HA_ERR_NOT_A_TABLE=130;exports2.HA_ERR_WRONG_COMMAND=131;exports2.HA_ERR_OLD_FILE=132;exports2.HA_ERR_NO_ACTIVE_RECORD=133;exports2.HA_ERR_RECORD_DELETED=134;exports2.HA_ERR_RECORD_FILE_FULL=135;exports2.HA_ERR_INDEX_FILE_FULL=136;exports2.HA_ERR_END_OF_FILE=137;exports2.HA_ERR_UNSUPPORTED=138;exports2.HA_ERR_TOO_BIG_ROW=139;exports2.HA_WRONG_CREATE_OPTION=140;exports2.HA_ERR_FOUND_DUPP_UNIQUE=141;exports2.HA_ERR_UNKNOWN_CHARSET=142;exports2.HA_ERR_WRONG_MRG_TABLE_DEF=143;exports2.HA_ERR_CRASHED_ON_REPAIR=144;exports2.HA_ERR_CRASHED_ON_USAGE=145;exports2.HA_ERR_LOCK_WAIT_TIMEOUT=146;exports2.HA_ERR_LOCK_TABLE_FULL=147;exports2.HA_ERR_READ_ONLY_TRANSACTION=148;exports2.HA_ERR_LOCK_DEADLOCK=149;exports2.HA_ERR_CANNOT_ADD_FOREIGN=150;exports2.HA_ERR_NO_REFERENCED_ROW=151;exports2.HA_ERR_ROW_IS_REFERENCED=152;exports2.HA_ERR_NO_SAVEPOINT=153;exports2.HA_ERR_NON_UNIQUE_BLOCK_SIZE=154;exports2.HA_ERR_NO_SUCH_TABLE=155;exports2.HA_ERR_TABLE_EXIST=156;exports2.HA_ERR_NO_CONNECTION=157;exports2.HA_ERR_NULL_IN_SPATIAL=158;exports2.HA_ERR_TABLE_DEF_CHANGED=159;exports2.HA_ERR_NO_PARTITION_FOUND=160;exports2.HA_ERR_RBR_LOGGING_FAILED=161;exports2.HA_ERR_DROP_INDEX_FK=162;exports2.HA_ERR_FOREIGN_DUPLICATE_KEY=163;exports2.HA_ERR_TABLE_NEEDS_UPGRADE=164;exports2.HA_ERR_TABLE_READONLY=165;exports2.HA_ERR_AUTOINC_READ_FAILED=166;exports2.HA_ERR_AUTOINC_ERANGE=167;exports2.HA_ERR_GENERIC=168;exports2.HA_ERR_RECORD_IS_THE_SAME=169;exports2.HA_ERR_LOGGING_IMPOSSIBLE=170;exports2.HA_ERR_CORRUPT_EVENT=171;exports2.HA_ERR_NEW_FILE=172;exports2.HA_ERR_ROWS_EVENT_APPLY=173;exports2.HA_ERR_INITIALIZATION=174;exports2.HA_ERR_FILE_TOO_SHORT=175;exports2.HA_ERR_WRONG_CRC=176;exports2.HA_ERR_TOO_MANY_CONCURRENT_TRXS=177;exports2.HA_ERR_NOT_IN_LOCK_PARTITIONS=178;exports2.HA_ERR_INDEX_COL_TOO_LONG=179;exports2.HA_ERR_INDEX_CORRUPT=180;exports2.HA_ERR_UNDO_REC_TOO_BIG=181;exports2.HA_FTS_INVALID_DOCID=182;exports2.HA_ERR_TABLE_IN_FK_CHECK=183;exports2.HA_ERR_TABLESPACE_EXISTS=184;exports2.HA_ERR_TOO_MANY_FIELDS=185;exports2.HA_ERR_ROW_IN_WRONG_PARTITION=186;exports2.HA_ERR_INNODB_READ_ONLY=187;exports2.HA_ERR_FTS_EXCEED_RESULT_CACHE_LIMIT=188;exports2.HA_ERR_TEMP_FILE_WRITE_FAILURE=189;exports2.HA_ERR_INNODB_FORCED_RECOVERY=190;exports2.HA_ERR_FTS_TOO_MANY_WORDS_IN_PHRASE=191;exports2.HA_ERR_FK_DEPTH_EXCEEDED=192;exports2.HA_MISSING_CREATE_OPTION=193;exports2.HA_ERR_SE_OUT_OF_MEMORY=194;exports2.HA_ERR_TABLE_CORRUPT=195;exports2.HA_ERR_QUERY_INTERRUPTED=196;exports2.HA_ERR_TABLESPACE_MISSING=197;exports2.HA_ERR_TABLESPACE_IS_NOT_EMPTY=198;exports2.HA_ERR_WRONG_FILE_NAME=199;exports2.HA_ERR_NOT_ALLOWED_COMMAND=200;exports2.HA_ERR_COMPUTE_FAILED=201;exports2.HA_ERR_ROW_FORMAT_CHANGED=202;exports2.HA_ERR_NO_WAIT_LOCK=203;exports2.HA_ERR_DISK_FULL_NOWAIT=204;exports2.HA_ERR_NO_SESSION_TEMP=205;exports2.HA_ERR_WRONG_TABLE_NAME=206;exports2.HA_ERR_TOO_LONG_PATH=207;exports2.HA_ERR_SAMPLING_INIT_FAILED=208;exports2.HA_ERR_FTS_TOO_MANY_NESTED_EXP=209;exports2.ER_HASHCHK=1e3;exports2.ER_NISAMCHK=1001;exports2.ER_NO=1002;exports2.ER_YES=1003;exports2.ER_CANT_CREATE_FILE=1004;exports2.ER_CANT_CREATE_TABLE=1005;exports2.ER_CANT_CREATE_DB=1006;exports2.ER_DB_CREATE_EXISTS=1007;exports2.ER_DB_DROP_EXISTS=1008;exports2.ER_DB_DROP_DELETE=1009;exports2.ER_DB_DROP_RMDIR=1010;exports2.ER_CANT_DELETE_FILE=1011;exports2.ER_CANT_FIND_SYSTEM_REC=1012;exports2.ER_CANT_GET_STAT=1013;exports2.ER_CANT_GET_WD=1014;exports2.ER_CANT_LOCK=1015;exports2.ER_CANT_OPEN_FILE=1016;exports2.ER_FILE_NOT_FOUND=1017;exports2.ER_CANT_READ_DIR=1018;exports2.ER_CANT_SET_WD=1019;exports2.ER_CHECKREAD=1020;exports2.ER_DISK_FULL=1021;exports2.ER_DUP_KEY=1022;exports2.ER_ERROR_ON_CLOSE=1023;exports2.ER_ERROR_ON_READ=1024;exports2.ER_ERROR_ON_RENAME=1025;exports2.ER_ERROR_ON_WRITE=1026;exports2.ER_FILE_USED=1027;exports2.ER_FILSORT_ABORT=1028;exports2.ER_FORM_NOT_FOUND=1029;exports2.ER_GET_ERRNO=1030;exports2.ER_ILLEGAL_HA=1031;exports2.ER_KEY_NOT_FOUND=1032;exports2.ER_NOT_FORM_FILE=1033;exports2.ER_NOT_KEYFILE=1034;exports2.ER_OLD_KEYFILE=1035;exports2.ER_OPEN_AS_READONLY=1036;exports2.ER_OUTOFMEMORY=1037;exports2.ER_OUT_OF_SORTMEMORY=1038;exports2.ER_UNEXPECTED_EOF=1039;exports2.ER_CON_COUNT_ERROR=1040;exports2.ER_OUT_OF_RESOURCES=1041;exports2.ER_BAD_HOST_ERROR=1042;exports2.ER_HANDSHAKE_ERROR=1043;exports2.ER_DBACCESS_DENIED_ERROR=1044;exports2.ER_ACCESS_DENIED_ERROR=1045;exports2.ER_NO_DB_ERROR=1046;exports2.ER_UNKNOWN_COM_ERROR=1047;exports2.ER_BAD_NULL_ERROR=1048;exports2.ER_BAD_DB_ERROR=1049;exports2.ER_TABLE_EXISTS_ERROR=1050;exports2.ER_BAD_TABLE_ERROR=1051;exports2.ER_NON_UNIQ_ERROR=1052;exports2.ER_SERVER_SHUTDOWN=1053;exports2.ER_BAD_FIELD_ERROR=1054;exports2.ER_WRONG_FIELD_WITH_GROUP=1055;exports2.ER_WRONG_GROUP_FIELD=1056;exports2.ER_WRONG_SUM_SELECT=1057;exports2.ER_WRONG_VALUE_COUNT=1058;exports2.ER_TOO_LONG_IDENT=1059;exports2.ER_DUP_FIELDNAME=1060;exports2.ER_DUP_KEYNAME=1061;exports2.ER_DUP_ENTRY=1062;exports2.ER_WRONG_FIELD_SPEC=1063;exports2.ER_PARSE_ERROR=1064;exports2.ER_EMPTY_QUERY=1065;exports2.ER_NONUNIQ_TABLE=1066;exports2.ER_INVALID_DEFAULT=1067;exports2.ER_MULTIPLE_PRI_KEY=1068;exports2.ER_TOO_MANY_KEYS=1069;exports2.ER_TOO_MANY_KEY_PARTS=1070;exports2.ER_TOO_LONG_KEY=1071;exports2.ER_KEY_COLUMN_DOES_NOT_EXITS=1072;exports2.ER_BLOB_USED_AS_KEY=1073;exports2.ER_TOO_BIG_FIELDLENGTH=1074;exports2.ER_WRONG_AUTO_KEY=1075;exports2.ER_READY=1076;exports2.ER_NORMAL_SHUTDOWN=1077;exports2.ER_GOT_SIGNAL=1078;exports2.ER_SHUTDOWN_COMPLETE=1079;exports2.ER_FORCING_CLOSE=1080;exports2.ER_IPSOCK_ERROR=1081;exports2.ER_NO_SUCH_INDEX=1082;exports2.ER_WRONG_FIELD_TERMINATORS=1083;exports2.ER_BLOBS_AND_NO_TERMINATED=1084;exports2.ER_TEXTFILE_NOT_READABLE=1085;exports2.ER_FILE_EXISTS_ERROR=1086;exports2.ER_LOAD_INFO=1087;exports2.ER_ALTER_INFO=1088;exports2.ER_WRONG_SUB_KEY=1089;exports2.ER_CANT_REMOVE_ALL_FIELDS=1090;exports2.ER_CANT_DROP_FIELD_OR_KEY=1091;exports2.ER_INSERT_INFO=1092;exports2.ER_UPDATE_TABLE_USED=1093;exports2.ER_NO_SUCH_THREAD=1094;exports2.ER_KILL_DENIED_ERROR=1095;exports2.ER_NO_TABLES_USED=1096;exports2.ER_TOO_BIG_SET=1097;exports2.ER_NO_UNIQUE_LOGFILE=1098;exports2.ER_TABLE_NOT_LOCKED_FOR_WRITE=1099;exports2.ER_TABLE_NOT_LOCKED=1100;exports2.ER_BLOB_CANT_HAVE_DEFAULT=1101;exports2.ER_WRONG_DB_NAME=1102;exports2.ER_WRONG_TABLE_NAME=1103;exports2.ER_TOO_BIG_SELECT=1104;exports2.ER_UNKNOWN_ERROR=1105;exports2.ER_UNKNOWN_PROCEDURE=1106;exports2.ER_WRONG_PARAMCOUNT_TO_PROCEDURE=1107;exports2.ER_WRONG_PARAMETERS_TO_PROCEDURE=1108;exports2.ER_UNKNOWN_TABLE=1109;exports2.ER_FIELD_SPECIFIED_TWICE=1110;exports2.ER_INVALID_GROUP_FUNC_USE=1111;exports2.ER_UNSUPPORTED_EXTENSION=1112;exports2.ER_TABLE_MUST_HAVE_COLUMNS=1113;exports2.ER_RECORD_FILE_FULL=1114;exports2.ER_UNKNOWN_CHARACTER_SET=1115;exports2.ER_TOO_MANY_TABLES=1116;exports2.ER_TOO_MANY_FIELDS=1117;exports2.ER_TOO_BIG_ROWSIZE=1118;exports2.ER_STACK_OVERRUN=1119;exports2.ER_WRONG_OUTER_JOIN=1120;exports2.ER_NULL_COLUMN_IN_INDEX=1121;exports2.ER_CANT_FIND_UDF=1122;exports2.ER_CANT_INITIALIZE_UDF=1123;exports2.ER_UDF_NO_PATHS=1124;exports2.ER_UDF_EXISTS=1125;exports2.ER_CANT_OPEN_LIBRARY=1126;exports2.ER_CANT_FIND_DL_ENTRY=1127;exports2.ER_FUNCTION_NOT_DEFINED=1128;exports2.ER_HOST_IS_BLOCKED=1129;exports2.ER_HOST_NOT_PRIVILEGED=1130;exports2.ER_PASSWORD_ANONYMOUS_USER=1131;exports2.ER_PASSWORD_NOT_ALLOWED=1132;exports2.ER_PASSWORD_NO_MATCH=1133;exports2.ER_UPDATE_INFO=1134;exports2.ER_CANT_CREATE_THREAD=1135;exports2.ER_WRONG_VALUE_COUNT_ON_ROW=1136;exports2.ER_CANT_REOPEN_TABLE=1137;exports2.ER_INVALID_USE_OF_NULL=1138;exports2.ER_REGEXP_ERROR=1139;exports2.ER_MIX_OF_GROUP_FUNC_AND_FIELDS=1140;exports2.ER_NONEXISTING_GRANT=1141;exports2.ER_TABLEACCESS_DENIED_ERROR=1142;exports2.ER_COLUMNACCESS_DENIED_ERROR=1143;exports2.ER_ILLEGAL_GRANT_FOR_TABLE=1144;exports2.ER_GRANT_WRONG_HOST_OR_USER=1145;exports2.ER_NO_SUCH_TABLE=1146;exports2.ER_NONEXISTING_TABLE_GRANT=1147;exports2.ER_NOT_ALLOWED_COMMAND=1148;exports2.ER_SYNTAX_ERROR=1149;exports2.ER_UNUSED1=1150;exports2.ER_UNUSED2=1151;exports2.ER_ABORTING_CONNECTION=1152;exports2.ER_NET_PACKET_TOO_LARGE=1153;exports2.ER_NET_READ_ERROR_FROM_PIPE=1154;exports2.ER_NET_FCNTL_ERROR=1155;exports2.ER_NET_PACKETS_OUT_OF_ORDER=1156;exports2.ER_NET_UNCOMPRESS_ERROR=1157;exports2.ER_NET_READ_ERROR=1158;exports2.ER_NET_READ_INTERRUPTED=1159;exports2.ER_NET_ERROR_ON_WRITE=1160;exports2.ER_NET_WRITE_INTERRUPTED=1161;exports2.ER_TOO_LONG_STRING=1162;exports2.ER_TABLE_CANT_HANDLE_BLOB=1163;exports2.ER_TABLE_CANT_HANDLE_AUTO_INCREMENT=1164;exports2.ER_UNUSED3=1165;exports2.ER_WRONG_COLUMN_NAME=1166;exports2.ER_WRONG_KEY_COLUMN=1167;exports2.ER_WRONG_MRG_TABLE=1168;exports2.ER_DUP_UNIQUE=1169;exports2.ER_BLOB_KEY_WITHOUT_LENGTH=1170;exports2.ER_PRIMARY_CANT_HAVE_NULL=1171;exports2.ER_TOO_MANY_ROWS=1172;exports2.ER_REQUIRES_PRIMARY_KEY=1173;exports2.ER_NO_RAID_COMPILED=1174;exports2.ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE=1175;exports2.ER_KEY_DOES_NOT_EXITS=1176;exports2.ER_CHECK_NO_SUCH_TABLE=1177;exports2.ER_CHECK_NOT_IMPLEMENTED=1178;exports2.ER_CANT_DO_THIS_DURING_AN_TRANSACTION=1179;exports2.ER_ERROR_DURING_COMMIT=1180;exports2.ER_ERROR_DURING_ROLLBACK=1181;exports2.ER_ERROR_DURING_FLUSH_LOGS=1182;exports2.ER_ERROR_DURING_CHECKPOINT=1183;exports2.ER_NEW_ABORTING_CONNECTION=1184;exports2.ER_DUMP_NOT_IMPLEMENTED=1185;exports2.ER_FLUSH_MASTER_BINLOG_CLOSED=1186;exports2.ER_INDEX_REBUILD=1187;exports2.ER_SOURCE=1188;exports2.ER_SOURCE_NET_READ=1189;exports2.ER_SOURCE_NET_WRITE=1190;exports2.ER_FT_MATCHING_KEY_NOT_FOUND=1191;exports2.ER_LOCK_OR_ACTIVE_TRANSACTION=1192;exports2.ER_UNKNOWN_SYSTEM_VARIABLE=1193;exports2.ER_CRASHED_ON_USAGE=1194;exports2.ER_CRASHED_ON_REPAIR=1195;exports2.ER_WARNING_NOT_COMPLETE_ROLLBACK=1196;exports2.ER_TRANS_CACHE_FULL=1197;exports2.ER_SLAVE_MUST_STOP=1198;exports2.ER_REPLICA_NOT_RUNNING=1199;exports2.ER_BAD_REPLICA=1200;exports2.ER_CONNECTION_METADATA=1201;exports2.ER_REPLICA_THREAD=1202;exports2.ER_TOO_MANY_USER_CONNECTIONS=1203;exports2.ER_SET_CONSTANTS_ONLY=1204;exports2.ER_LOCK_WAIT_TIMEOUT=1205;exports2.ER_LOCK_TABLE_FULL=1206;exports2.ER_READ_ONLY_TRANSACTION=1207;exports2.ER_DROP_DB_WITH_READ_LOCK=1208;exports2.ER_CREATE_DB_WITH_READ_LOCK=1209;exports2.ER_WRONG_ARGUMENTS=1210;exports2.ER_NO_PERMISSION_TO_CREATE_USER=1211;exports2.ER_UNION_TABLES_IN_DIFFERENT_DIR=1212;exports2.ER_LOCK_DEADLOCK=1213;exports2.ER_TABLE_CANT_HANDLE_FT=1214;exports2.ER_CANNOT_ADD_FOREIGN=1215;exports2.ER_NO_REFERENCED_ROW=1216;exports2.ER_ROW_IS_REFERENCED=1217;exports2.ER_CONNECT_TO_SOURCE=1218;exports2.ER_QUERY_ON_MASTER=1219;exports2.ER_ERROR_WHEN_EXECUTING_COMMAND=1220;exports2.ER_WRONG_USAGE=1221;exports2.ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT=1222;exports2.ER_CANT_UPDATE_WITH_READLOCK=1223;exports2.ER_MIXING_NOT_ALLOWED=1224;exports2.ER_DUP_ARGUMENT=1225;exports2.ER_USER_LIMIT_REACHED=1226;exports2.ER_SPECIFIC_ACCESS_DENIED_ERROR=1227;exports2.ER_LOCAL_VARIABLE=1228;exports2.ER_GLOBAL_VARIABLE=1229;exports2.ER_NO_DEFAULT=1230;exports2.ER_WRONG_VALUE_FOR_VAR=1231;exports2.ER_WRONG_TYPE_FOR_VAR=1232;exports2.ER_VAR_CANT_BE_READ=1233;exports2.ER_CANT_USE_OPTION_HERE=1234;exports2.ER_NOT_SUPPORTED_YET=1235;exports2.ER_SOURCE_FATAL_ERROR_READING_BINLOG=1236;exports2.ER_REPLICA_IGNORED_TABLE=1237;exports2.ER_INCORRECT_GLOBAL_LOCAL_VAR=1238;exports2.ER_WRONG_FK_DEF=1239;exports2.ER_KEY_REF_DO_NOT_MATCH_TABLE_REF=1240;exports2.ER_OPERAND_COLUMNS=1241;exports2.ER_SUBQUERY_NO_1_ROW=1242;exports2.ER_UNKNOWN_STMT_HANDLER=1243;exports2.ER_CORRUPT_HELP_DB=1244;exports2.ER_CYCLIC_REFERENCE=1245;exports2.ER_AUTO_CONVERT=1246;exports2.ER_ILLEGAL_REFERENCE=1247;exports2.ER_DERIVED_MUST_HAVE_ALIAS=1248;exports2.ER_SELECT_REDUCED=1249;exports2.ER_TABLENAME_NOT_ALLOWED_HERE=1250;exports2.ER_NOT_SUPPORTED_AUTH_MODE=1251;exports2.ER_SPATIAL_CANT_HAVE_NULL=1252;exports2.ER_COLLATION_CHARSET_MISMATCH=1253;exports2.ER_SLAVE_WAS_RUNNING=1254;exports2.ER_SLAVE_WAS_NOT_RUNNING=1255;exports2.ER_TOO_BIG_FOR_UNCOMPRESS=1256;exports2.ER_ZLIB_Z_MEM_ERROR=1257;exports2.ER_ZLIB_Z_BUF_ERROR=1258;exports2.ER_ZLIB_Z_DATA_ERROR=1259;exports2.ER_CUT_VALUE_GROUP_CONCAT=1260;exports2.ER_WARN_TOO_FEW_RECORDS=1261;exports2.ER_WARN_TOO_MANY_RECORDS=1262;exports2.ER_WARN_NULL_TO_NOTNULL=1263;exports2.ER_WARN_DATA_OUT_OF_RANGE=1264;exports2.WARN_DATA_TRUNCATED=1265;exports2.ER_WARN_USING_OTHER_HANDLER=1266;exports2.ER_CANT_AGGREGATE_2COLLATIONS=1267;exports2.ER_DROP_USER=1268;exports2.ER_REVOKE_GRANTS=1269;exports2.ER_CANT_AGGREGATE_3COLLATIONS=1270;exports2.ER_CANT_AGGREGATE_NCOLLATIONS=1271;exports2.ER_VARIABLE_IS_NOT_STRUCT=1272;exports2.ER_UNKNOWN_COLLATION=1273;exports2.ER_REPLICA_IGNORED_SSL_PARAMS=1274;exports2.ER_SERVER_IS_IN_SECURE_AUTH_MODE=1275;exports2.ER_WARN_FIELD_RESOLVED=1276;exports2.ER_BAD_REPLICA_UNTIL_COND=1277;exports2.ER_MISSING_SKIP_REPLICA=1278;exports2.ER_UNTIL_COND_IGNORED=1279;exports2.ER_WRONG_NAME_FOR_INDEX=1280;exports2.ER_WRONG_NAME_FOR_CATALOG=1281;exports2.ER_WARN_QC_RESIZE=1282;exports2.ER_BAD_FT_COLUMN=1283;exports2.ER_UNKNOWN_KEY_CACHE=1284;exports2.ER_WARN_HOSTNAME_WONT_WORK=1285;exports2.ER_UNKNOWN_STORAGE_ENGINE=1286;exports2.ER_WARN_DEPRECATED_SYNTAX=1287;exports2.ER_NON_UPDATABLE_TABLE=1288;exports2.ER_FEATURE_DISABLED=1289;exports2.ER_OPTION_PREVENTS_STATEMENT=1290;exports2.ER_DUPLICATED_VALUE_IN_TYPE=1291;exports2.ER_TRUNCATED_WRONG_VALUE=1292;exports2.ER_TOO_MUCH_AUTO_TIMESTAMP_COLS=1293;exports2.ER_INVALID_ON_UPDATE=1294;exports2.ER_UNSUPPORTED_PS=1295;exports2.ER_GET_ERRMSG=1296;exports2.ER_GET_TEMPORARY_ERRMSG=1297;exports2.ER_UNKNOWN_TIME_ZONE=1298;exports2.ER_WARN_INVALID_TIMESTAMP=1299;exports2.ER_INVALID_CHARACTER_STRING=1300;exports2.ER_WARN_ALLOWED_PACKET_OVERFLOWED=1301;exports2.ER_CONFLICTING_DECLARATIONS=1302;exports2.ER_SP_NO_RECURSIVE_CREATE=1303;exports2.ER_SP_ALREADY_EXISTS=1304;exports2.ER_SP_DOES_NOT_EXIST=1305;exports2.ER_SP_DROP_FAILED=1306;exports2.ER_SP_STORE_FAILED=1307;exports2.ER_SP_LILABEL_MISMATCH=1308;exports2.ER_SP_LABEL_REDEFINE=1309;exports2.ER_SP_LABEL_MISMATCH=1310;exports2.ER_SP_UNINIT_VAR=1311;exports2.ER_SP_BADSELECT=1312;exports2.ER_SP_BADRETURN=1313;exports2.ER_SP_BADSTATEMENT=1314;exports2.ER_UPDATE_LOG_DEPRECATED_IGNORED=1315;exports2.ER_UPDATE_LOG_DEPRECATED_TRANSLATED=1316;exports2.ER_QUERY_INTERRUPTED=1317;exports2.ER_SP_WRONG_NO_OF_ARGS=1318;exports2.ER_SP_COND_MISMATCH=1319;exports2.ER_SP_NORETURN=1320;exports2.ER_SP_NORETURNEND=1321;exports2.ER_SP_BAD_CURSOR_QUERY=1322;exports2.ER_SP_BAD_CURSOR_SELECT=1323;exports2.ER_SP_CURSOR_MISMATCH=1324;exports2.ER_SP_CURSOR_ALREADY_OPEN=1325;exports2.ER_SP_CURSOR_NOT_OPEN=1326;exports2.ER_SP_UNDECLARED_VAR=1327;exports2.ER_SP_WRONG_NO_OF_FETCH_ARGS=1328;exports2.ER_SP_FETCH_NO_DATA=1329;exports2.ER_SP_DUP_PARAM=1330;exports2.ER_SP_DUP_VAR=1331;exports2.ER_SP_DUP_COND=1332;exports2.ER_SP_DUP_CURS=1333;exports2.ER_SP_CANT_ALTER=1334;exports2.ER_SP_SUBSELECT_NYI=1335;exports2.ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG=1336;exports2.ER_SP_VARCOND_AFTER_CURSHNDLR=1337;exports2.ER_SP_CURSOR_AFTER_HANDLER=1338;exports2.ER_SP_CASE_NOT_FOUND=1339;exports2.ER_FPARSER_TOO_BIG_FILE=1340;exports2.ER_FPARSER_BAD_HEADER=1341;exports2.ER_FPARSER_EOF_IN_COMMENT=1342;exports2.ER_FPARSER_ERROR_IN_PARAMETER=1343;exports2.ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER=1344;exports2.ER_VIEW_NO_EXPLAIN=1345;exports2.ER_FRM_UNKNOWN_TYPE=1346;exports2.ER_WRONG_OBJECT=1347;exports2.ER_NONUPDATEABLE_COLUMN=1348;exports2.ER_VIEW_SELECT_DERIVED=1349;exports2.ER_VIEW_SELECT_CLAUSE=1350;exports2.ER_VIEW_SELECT_VARIABLE=1351;exports2.ER_VIEW_SELECT_TMPTABLE=1352;exports2.ER_VIEW_WRONG_LIST=1353;exports2.ER_WARN_VIEW_MERGE=1354;exports2.ER_WARN_VIEW_WITHOUT_KEY=1355;exports2.ER_VIEW_INVALID=1356;exports2.ER_SP_NO_DROP_SP=1357;exports2.ER_SP_GOTO_IN_HNDLR=1358;exports2.ER_TRG_ALREADY_EXISTS=1359;exports2.ER_TRG_DOES_NOT_EXIST=1360;exports2.ER_TRG_ON_VIEW_OR_TEMP_TABLE=1361;exports2.ER_TRG_CANT_CHANGE_ROW=1362;exports2.ER_TRG_NO_SUCH_ROW_IN_TRG=1363;exports2.ER_NO_DEFAULT_FOR_FIELD=1364;exports2.ER_DIVISION_BY_ZERO=1365;exports2.ER_TRUNCATED_WRONG_VALUE_FOR_FIELD=1366;exports2.ER_ILLEGAL_VALUE_FOR_TYPE=1367;exports2.ER_VIEW_NONUPD_CHECK=1368;exports2.ER_VIEW_CHECK_FAILED=1369;exports2.ER_PROCACCESS_DENIED_ERROR=1370;exports2.ER_RELAY_LOG_FAIL=1371;exports2.ER_PASSWD_LENGTH=1372;exports2.ER_UNKNOWN_TARGET_BINLOG=1373;exports2.ER_IO_ERR_LOG_INDEX_READ=1374;exports2.ER_BINLOG_PURGE_PROHIBITED=1375;exports2.ER_FSEEK_FAIL=1376;exports2.ER_BINLOG_PURGE_FATAL_ERR=1377;exports2.ER_LOG_IN_USE=1378;exports2.ER_LOG_PURGE_UNKNOWN_ERR=1379;exports2.ER_RELAY_LOG_INIT=1380;exports2.ER_NO_BINARY_LOGGING=1381;exports2.ER_RESERVED_SYNTAX=1382;exports2.ER_WSAS_FAILED=1383;exports2.ER_DIFF_GROUPS_PROC=1384;exports2.ER_NO_GROUP_FOR_PROC=1385;exports2.ER_ORDER_WITH_PROC=1386;exports2.ER_LOGGING_PROHIBIT_CHANGING_OF=1387;exports2.ER_NO_FILE_MAPPING=1388;exports2.ER_WRONG_MAGIC=1389;exports2.ER_PS_MANY_PARAM=1390;exports2.ER_KEY_PART_0=1391;exports2.ER_VIEW_CHECKSUM=1392;exports2.ER_VIEW_MULTIUPDATE=1393;exports2.ER_VIEW_NO_INSERT_FIELD_LIST=1394;exports2.ER_VIEW_DELETE_MERGE_VIEW=1395;exports2.ER_CANNOT_USER=1396;exports2.ER_XAER_NOTA=1397;exports2.ER_XAER_INVAL=1398;exports2.ER_XAER_RMFAIL=1399;exports2.ER_XAER_OUTSIDE=1400;exports2.ER_XAER_RMERR=1401;exports2.ER_XA_RBROLLBACK=1402;exports2.ER_NONEXISTING_PROC_GRANT=1403;exports2.ER_PROC_AUTO_GRANT_FAIL=1404;exports2.ER_PROC_AUTO_REVOKE_FAIL=1405;exports2.ER_DATA_TOO_LONG=1406;exports2.ER_SP_BAD_SQLSTATE=1407;exports2.ER_STARTUP=1408;exports2.ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR=1409;exports2.ER_CANT_CREATE_USER_WITH_GRANT=1410;exports2.ER_WRONG_VALUE_FOR_TYPE=1411;exports2.ER_TABLE_DEF_CHANGED=1412;exports2.ER_SP_DUP_HANDLER=1413;exports2.ER_SP_NOT_VAR_ARG=1414;exports2.ER_SP_NO_RETSET=1415;exports2.ER_CANT_CREATE_GEOMETRY_OBJECT=1416;exports2.ER_FAILED_ROUTINE_BREAK_BINLOG=1417;exports2.ER_BINLOG_UNSAFE_ROUTINE=1418;exports2.ER_BINLOG_CREATE_ROUTINE_NEED_SUPER=1419;exports2.ER_EXEC_STMT_WITH_OPEN_CURSOR=1420;exports2.ER_STMT_HAS_NO_OPEN_CURSOR=1421;exports2.ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG=1422;exports2.ER_NO_DEFAULT_FOR_VIEW_FIELD=1423;exports2.ER_SP_NO_RECURSION=1424;exports2.ER_TOO_BIG_SCALE=1425;exports2.ER_TOO_BIG_PRECISION=1426;exports2.ER_M_BIGGER_THAN_D=1427;exports2.ER_WRONG_LOCK_OF_SYSTEM_TABLE=1428;exports2.ER_CONNECT_TO_FOREIGN_DATA_SOURCE=1429;exports2.ER_QUERY_ON_FOREIGN_DATA_SOURCE=1430;exports2.ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST=1431;exports2.ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE=1432;exports2.ER_FOREIGN_DATA_STRING_INVALID=1433;exports2.ER_CANT_CREATE_FEDERATED_TABLE=1434;exports2.ER_TRG_IN_WRONG_SCHEMA=1435;exports2.ER_STACK_OVERRUN_NEED_MORE=1436;exports2.ER_TOO_LONG_BODY=1437;exports2.ER_WARN_CANT_DROP_DEFAULT_KEYCACHE=1438;exports2.ER_TOO_BIG_DISPLAYWIDTH=1439;exports2.ER_XAER_DUPID=1440;exports2.ER_DATETIME_FUNCTION_OVERFLOW=1441;exports2.ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG=1442;exports2.ER_VIEW_PREVENT_UPDATE=1443;exports2.ER_PS_NO_RECURSION=1444;exports2.ER_SP_CANT_SET_AUTOCOMMIT=1445;exports2.ER_MALFORMED_DEFINER=1446;exports2.ER_VIEW_FRM_NO_USER=1447;exports2.ER_VIEW_OTHER_USER=1448;exports2.ER_NO_SUCH_USER=1449;exports2.ER_FORBID_SCHEMA_CHANGE=1450;exports2.ER_ROW_IS_REFERENCED_2=1451;exports2.ER_NO_REFERENCED_ROW_2=1452;exports2.ER_SP_BAD_VAR_SHADOW=1453;exports2.ER_TRG_NO_DEFINER=1454;exports2.ER_OLD_FILE_FORMAT=1455;exports2.ER_SP_RECURSION_LIMIT=1456;exports2.ER_SP_PROC_TABLE_CORRUPT=1457;exports2.ER_SP_WRONG_NAME=1458;exports2.ER_TABLE_NEEDS_UPGRADE=1459;exports2.ER_SP_NO_AGGREGATE=1460;exports2.ER_MAX_PREPARED_STMT_COUNT_REACHED=1461;exports2.ER_VIEW_RECURSIVE=1462;exports2.ER_NON_GROUPING_FIELD_USED=1463;exports2.ER_TABLE_CANT_HANDLE_SPKEYS=1464;exports2.ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA=1465;exports2.ER_REMOVED_SPACES=1466;exports2.ER_AUTOINC_READ_FAILED=1467;exports2.ER_USERNAME=1468;exports2.ER_HOSTNAME=1469;exports2.ER_WRONG_STRING_LENGTH=1470;exports2.ER_NON_INSERTABLE_TABLE=1471;exports2.ER_ADMIN_WRONG_MRG_TABLE=1472;exports2.ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT=1473;exports2.ER_NAME_BECOMES_EMPTY=1474;exports2.ER_AMBIGUOUS_FIELD_TERM=1475;exports2.ER_FOREIGN_SERVER_EXISTS=1476;exports2.ER_FOREIGN_SERVER_DOESNT_EXIST=1477;exports2.ER_ILLEGAL_HA_CREATE_OPTION=1478;exports2.ER_PARTITION_REQUIRES_VALUES_ERROR=1479;exports2.ER_PARTITION_WRONG_VALUES_ERROR=1480;exports2.ER_PARTITION_MAXVALUE_ERROR=1481;exports2.ER_PARTITION_SUBPARTITION_ERROR=1482;exports2.ER_PARTITION_SUBPART_MIX_ERROR=1483;exports2.ER_PARTITION_WRONG_NO_PART_ERROR=1484;exports2.ER_PARTITION_WRONG_NO_SUBPART_ERROR=1485;exports2.ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR=1486;exports2.ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR=1487;exports2.ER_FIELD_NOT_FOUND_PART_ERROR=1488;exports2.ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR=1489;exports2.ER_INCONSISTENT_PARTITION_INFO_ERROR=1490;exports2.ER_PARTITION_FUNC_NOT_ALLOWED_ERROR=1491;exports2.ER_PARTITIONS_MUST_BE_DEFINED_ERROR=1492;exports2.ER_RANGE_NOT_INCREASING_ERROR=1493;exports2.ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR=1494;exports2.ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR=1495;exports2.ER_PARTITION_ENTRY_ERROR=1496;exports2.ER_MIX_HANDLER_ERROR=1497;exports2.ER_PARTITION_NOT_DEFINED_ERROR=1498;exports2.ER_TOO_MANY_PARTITIONS_ERROR=1499;exports2.ER_SUBPARTITION_ERROR=1500;exports2.ER_CANT_CREATE_HANDLER_FILE=1501;exports2.ER_BLOB_FIELD_IN_PART_FUNC_ERROR=1502;exports2.ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF=1503;exports2.ER_NO_PARTS_ERROR=1504;exports2.ER_PARTITION_MGMT_ON_NONPARTITIONED=1505;exports2.ER_FOREIGN_KEY_ON_PARTITIONED=1506;exports2.ER_DROP_PARTITION_NON_EXISTENT=1507;exports2.ER_DROP_LAST_PARTITION=1508;exports2.ER_COALESCE_ONLY_ON_HASH_PARTITION=1509;exports2.ER_REORG_HASH_ONLY_ON_SAME_NO=1510;exports2.ER_REORG_NO_PARAM_ERROR=1511;exports2.ER_ONLY_ON_RANGE_LIST_PARTITION=1512;exports2.ER_ADD_PARTITION_SUBPART_ERROR=1513;exports2.ER_ADD_PARTITION_NO_NEW_PARTITION=1514;exports2.ER_COALESCE_PARTITION_NO_PARTITION=1515;exports2.ER_REORG_PARTITION_NOT_EXIST=1516;exports2.ER_SAME_NAME_PARTITION=1517;exports2.ER_NO_BINLOG_ERROR=1518;exports2.ER_CONSECUTIVE_REORG_PARTITIONS=1519;exports2.ER_REORG_OUTSIDE_RANGE=1520;exports2.ER_PARTITION_FUNCTION_FAILURE=1521;exports2.ER_PART_STATE_ERROR=1522;exports2.ER_LIMITED_PART_RANGE=1523;exports2.ER_PLUGIN_IS_NOT_LOADED=1524;exports2.ER_WRONG_VALUE=1525;exports2.ER_NO_PARTITION_FOR_GIVEN_VALUE=1526;exports2.ER_FILEGROUP_OPTION_ONLY_ONCE=1527;exports2.ER_CREATE_FILEGROUP_FAILED=1528;exports2.ER_DROP_FILEGROUP_FAILED=1529;exports2.ER_TABLESPACE_AUTO_EXTEND_ERROR=1530;exports2.ER_WRONG_SIZE_NUMBER=1531;exports2.ER_SIZE_OVERFLOW_ERROR=1532;exports2.ER_ALTER_FILEGROUP_FAILED=1533;exports2.ER_BINLOG_ROW_LOGGING_FAILED=1534;exports2.ER_BINLOG_ROW_WRONG_TABLE_DEF=1535;exports2.ER_BINLOG_ROW_RBR_TO_SBR=1536;exports2.ER_EVENT_ALREADY_EXISTS=1537;exports2.ER_EVENT_STORE_FAILED=1538;exports2.ER_EVENT_DOES_NOT_EXIST=1539;exports2.ER_EVENT_CANT_ALTER=1540;exports2.ER_EVENT_DROP_FAILED=1541;exports2.ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG=1542;exports2.ER_EVENT_ENDS_BEFORE_STARTS=1543;exports2.ER_EVENT_EXEC_TIME_IN_THE_PAST=1544;exports2.ER_EVENT_OPEN_TABLE_FAILED=1545;exports2.ER_EVENT_NEITHER_M_EXPR_NOR_M_AT=1546;exports2.ER_COL_COUNT_DOESNT_MATCH_CORRUPTED=1547;exports2.ER_CANNOT_LOAD_FROM_TABLE=1548;exports2.ER_EVENT_CANNOT_DELETE=1549;exports2.ER_EVENT_COMPILE_ERROR=1550;exports2.ER_EVENT_SAME_NAME=1551;exports2.ER_EVENT_DATA_TOO_LONG=1552;exports2.ER_DROP_INDEX_FK=1553;exports2.ER_WARN_DEPRECATED_SYNTAX_WITH_VER=1554;exports2.ER_CANT_WRITE_LOCK_LOG_TABLE=1555;exports2.ER_CANT_LOCK_LOG_TABLE=1556;exports2.ER_FOREIGN_DUPLICATE_KEY=1557;exports2.ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE=1558;exports2.ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR=1559;exports2.ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT=1560;exports2.ER_NDB_CANT_SWITCH_BINLOG_FORMAT=1561;exports2.ER_PARTITION_NO_TEMPORARY=1562;exports2.ER_PARTITION_CONST_DOMAIN_ERROR=1563;exports2.ER_PARTITION_FUNCTION_IS_NOT_ALLOWED=1564;exports2.ER_DDL_LOG_ERROR=1565;exports2.ER_NULL_IN_VALUES_LESS_THAN=1566;exports2.ER_WRONG_PARTITION_NAME=1567;exports2.ER_CANT_CHANGE_TX_CHARACTERISTICS=1568;exports2.ER_DUP_ENTRY_AUTOINCREMENT_CASE=1569;exports2.ER_EVENT_MODIFY_QUEUE_ERROR=1570;exports2.ER_EVENT_SET_VAR_ERROR=1571;exports2.ER_PARTITION_MERGE_ERROR=1572;exports2.ER_CANT_ACTIVATE_LOG=1573;exports2.ER_RBR_NOT_AVAILABLE=1574;exports2.ER_BASE64_DECODE_ERROR=1575;exports2.ER_EVENT_RECURSION_FORBIDDEN=1576;exports2.ER_EVENTS_DB_ERROR=1577;exports2.ER_ONLY_INTEGERS_ALLOWED=1578;exports2.ER_UNSUPORTED_LOG_ENGINE=1579;exports2.ER_BAD_LOG_STATEMENT=1580;exports2.ER_CANT_RENAME_LOG_TABLE=1581;exports2.ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT=1582;exports2.ER_WRONG_PARAMETERS_TO_NATIVE_FCT=1583;exports2.ER_WRONG_PARAMETERS_TO_STORED_FCT=1584;exports2.ER_NATIVE_FCT_NAME_COLLISION=1585;exports2.ER_DUP_ENTRY_WITH_KEY_NAME=1586;exports2.ER_BINLOG_PURGE_EMFILE=1587;exports2.ER_EVENT_CANNOT_CREATE_IN_THE_PAST=1588;exports2.ER_EVENT_CANNOT_ALTER_IN_THE_PAST=1589;exports2.ER_SLAVE_INCIDENT=1590;exports2.ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT=1591;exports2.ER_BINLOG_UNSAFE_STATEMENT=1592;exports2.ER_BINLOG_FATAL_ERROR=1593;exports2.ER_SLAVE_RELAY_LOG_READ_FAILURE=1594;exports2.ER_SLAVE_RELAY_LOG_WRITE_FAILURE=1595;exports2.ER_SLAVE_CREATE_EVENT_FAILURE=1596;exports2.ER_SLAVE_MASTER_COM_FAILURE=1597;exports2.ER_BINLOG_LOGGING_IMPOSSIBLE=1598;exports2.ER_VIEW_NO_CREATION_CTX=1599;exports2.ER_VIEW_INVALID_CREATION_CTX=1600;exports2.ER_SR_INVALID_CREATION_CTX=1601;exports2.ER_TRG_CORRUPTED_FILE=1602;exports2.ER_TRG_NO_CREATION_CTX=1603;exports2.ER_TRG_INVALID_CREATION_CTX=1604;exports2.ER_EVENT_INVALID_CREATION_CTX=1605;exports2.ER_TRG_CANT_OPEN_TABLE=1606;exports2.ER_CANT_CREATE_SROUTINE=1607;exports2.ER_NEVER_USED=1608;exports2.ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT=1609;exports2.ER_REPLICA_CORRUPT_EVENT=1610;exports2.ER_LOAD_DATA_INVALID_COLUMN=1611;exports2.ER_LOG_PURGE_NO_FILE=1612;exports2.ER_XA_RBTIMEOUT=1613;exports2.ER_XA_RBDEADLOCK=1614;exports2.ER_NEED_REPREPARE=1615;exports2.ER_DELAYED_NOT_SUPPORTED=1616;exports2.WARN_NO_CONNECTION_METADATA=1617;exports2.WARN_OPTION_IGNORED=1618;exports2.ER_PLUGIN_DELETE_BUILTIN=1619;exports2.WARN_PLUGIN_BUSY=1620;exports2.ER_VARIABLE_IS_READONLY=1621;exports2.ER_WARN_ENGINE_TRANSACTION_ROLLBACK=1622;exports2.ER_SLAVE_HEARTBEAT_FAILURE=1623;exports2.ER_REPLICA_HEARTBEAT_VALUE_OUT_OF_RANGE=1624;exports2.ER_NDB_REPLICATION_SCHEMA_ERROR=1625;exports2.ER_CONFLICT_FN_PARSE_ERROR=1626;exports2.ER_EXCEPTIONS_WRITE_ERROR=1627;exports2.ER_TOO_LONG_TABLE_COMMENT=1628;exports2.ER_TOO_LONG_FIELD_COMMENT=1629;exports2.ER_FUNC_INEXISTENT_NAME_COLLISION=1630;exports2.ER_DATABASE_NAME=1631;exports2.ER_TABLE_NAME=1632;exports2.ER_PARTITION_NAME=1633;exports2.ER_SUBPARTITION_NAME=1634;exports2.ER_TEMPORARY_NAME=1635;exports2.ER_RENAMED_NAME=1636;exports2.ER_TOO_MANY_CONCURRENT_TRXS=1637;exports2.WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED=1638;exports2.ER_DEBUG_SYNC_TIMEOUT=1639;exports2.ER_DEBUG_SYNC_HIT_LIMIT=1640;exports2.ER_DUP_SIGNAL_SET=1641;exports2.ER_SIGNAL_WARN=1642;exports2.ER_SIGNAL_NOT_FOUND=1643;exports2.ER_SIGNAL_EXCEPTION=1644;exports2.ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER=1645;exports2.ER_SIGNAL_BAD_CONDITION_TYPE=1646;exports2.WARN_COND_ITEM_TRUNCATED=1647;exports2.ER_COND_ITEM_TOO_LONG=1648;exports2.ER_UNKNOWN_LOCALE=1649;exports2.ER_REPLICA_IGNORE_SERVER_IDS=1650;exports2.ER_QUERY_CACHE_DISABLED=1651;exports2.ER_SAME_NAME_PARTITION_FIELD=1652;exports2.ER_PARTITION_COLUMN_LIST_ERROR=1653;exports2.ER_WRONG_TYPE_COLUMN_VALUE_ERROR=1654;exports2.ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR=1655;exports2.ER_MAXVALUE_IN_VALUES_IN=1656;exports2.ER_TOO_MANY_VALUES_ERROR=1657;exports2.ER_ROW_SINGLE_PARTITION_FIELD_ERROR=1658;exports2.ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD=1659;exports2.ER_PARTITION_FIELDS_TOO_LONG=1660;exports2.ER_BINLOG_ROW_ENGINE_AND_STMT_ENGINE=1661;exports2.ER_BINLOG_ROW_MODE_AND_STMT_ENGINE=1662;exports2.ER_BINLOG_UNSAFE_AND_STMT_ENGINE=1663;exports2.ER_BINLOG_ROW_INJECTION_AND_STMT_ENGINE=1664;exports2.ER_BINLOG_STMT_MODE_AND_ROW_ENGINE=1665;exports2.ER_BINLOG_ROW_INJECTION_AND_STMT_MODE=1666;exports2.ER_BINLOG_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE=1667;exports2.ER_BINLOG_UNSAFE_LIMIT=1668;exports2.ER_UNUSED4=1669;exports2.ER_BINLOG_UNSAFE_SYSTEM_TABLE=1670;exports2.ER_BINLOG_UNSAFE_AUTOINC_COLUMNS=1671;exports2.ER_BINLOG_UNSAFE_UDF=1672;exports2.ER_BINLOG_UNSAFE_SYSTEM_VARIABLE=1673;exports2.ER_BINLOG_UNSAFE_SYSTEM_FUNCTION=1674;exports2.ER_BINLOG_UNSAFE_NONTRANS_AFTER_TRANS=1675;exports2.ER_MESSAGE_AND_STATEMENT=1676;exports2.ER_SLAVE_CONVERSION_FAILED=1677;exports2.ER_REPLICA_CANT_CREATE_CONVERSION=1678;exports2.ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_FORMAT=1679;exports2.ER_PATH_LENGTH=1680;exports2.ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT=1681;exports2.ER_WRONG_NATIVE_TABLE_STRUCTURE=1682;exports2.ER_WRONG_PERFSCHEMA_USAGE=1683;exports2.ER_WARN_I_S_SKIPPED_TABLE=1684;exports2.ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_DIRECT=1685;exports2.ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_DIRECT=1686;exports2.ER_SPATIAL_MUST_HAVE_GEOM_COL=1687;exports2.ER_TOO_LONG_INDEX_COMMENT=1688;exports2.ER_LOCK_ABORTED=1689;exports2.ER_DATA_OUT_OF_RANGE=1690;exports2.ER_WRONG_SPVAR_TYPE_IN_LIMIT=1691;exports2.ER_BINLOG_UNSAFE_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE=1692;exports2.ER_BINLOG_UNSAFE_MIXED_STATEMENT=1693;exports2.ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_SQL_LOG_BIN=1694;exports2.ER_STORED_FUNCTION_PREVENTS_SWITCH_SQL_LOG_BIN=1695;exports2.ER_FAILED_READ_FROM_PAR_FILE=1696;exports2.ER_VALUES_IS_NOT_INT_TYPE_ERROR=1697;exports2.ER_ACCESS_DENIED_NO_PASSWORD_ERROR=1698;exports2.ER_SET_PASSWORD_AUTH_PLUGIN=1699;exports2.ER_GRANT_PLUGIN_USER_EXISTS=1700;exports2.ER_TRUNCATE_ILLEGAL_FK=1701;exports2.ER_PLUGIN_IS_PERMANENT=1702;exports2.ER_REPLICA_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN=1703;exports2.ER_REPLICA_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX=1704;exports2.ER_STMT_CACHE_FULL=1705;exports2.ER_MULTI_UPDATE_KEY_CONFLICT=1706;exports2.ER_TABLE_NEEDS_REBUILD=1707;exports2.WARN_OPTION_BELOW_LIMIT=1708;exports2.ER_INDEX_COLUMN_TOO_LONG=1709;exports2.ER_ERROR_IN_TRIGGER_BODY=1710;exports2.ER_ERROR_IN_UNKNOWN_TRIGGER_BODY=1711;exports2.ER_INDEX_CORRUPT=1712;exports2.ER_UNDO_RECORD_TOO_BIG=1713;exports2.ER_BINLOG_UNSAFE_INSERT_IGNORE_SELECT=1714;exports2.ER_BINLOG_UNSAFE_INSERT_SELECT_UPDATE=1715;exports2.ER_BINLOG_UNSAFE_REPLACE_SELECT=1716;exports2.ER_BINLOG_UNSAFE_CREATE_IGNORE_SELECT=1717;exports2.ER_BINLOG_UNSAFE_CREATE_REPLACE_SELECT=1718;exports2.ER_BINLOG_UNSAFE_UPDATE_IGNORE=1719;exports2.ER_PLUGIN_NO_UNINSTALL=1720;exports2.ER_PLUGIN_NO_INSTALL=1721;exports2.ER_BINLOG_UNSAFE_WRITE_AUTOINC_SELECT=1722;exports2.ER_BINLOG_UNSAFE_CREATE_SELECT_AUTOINC=1723;exports2.ER_BINLOG_UNSAFE_INSERT_TWO_KEYS=1724;exports2.ER_TABLE_IN_FK_CHECK=1725;exports2.ER_UNSUPPORTED_ENGINE=1726;exports2.ER_BINLOG_UNSAFE_AUTOINC_NOT_FIRST=1727;exports2.ER_CANNOT_LOAD_FROM_TABLE_V2=1728;exports2.ER_SOURCE_DELAY_VALUE_OUT_OF_RANGE=1729;exports2.ER_ONLY_FD_AND_RBR_EVENTS_ALLOWED_IN_BINLOG_STATEMENT=1730;exports2.ER_PARTITION_EXCHANGE_DIFFERENT_OPTION=1731;exports2.ER_PARTITION_EXCHANGE_PART_TABLE=1732;exports2.ER_PARTITION_EXCHANGE_TEMP_TABLE=1733;exports2.ER_PARTITION_INSTEAD_OF_SUBPARTITION=1734;exports2.ER_UNKNOWN_PARTITION=1735;exports2.ER_TABLES_DIFFERENT_METADATA=1736;exports2.ER_ROW_DOES_NOT_MATCH_PARTITION=1737;exports2.ER_BINLOG_CACHE_SIZE_GREATER_THAN_MAX=1738;exports2.ER_WARN_INDEX_NOT_APPLICABLE=1739;exports2.ER_PARTITION_EXCHANGE_FOREIGN_KEY=1740;exports2.ER_NO_SUCH_KEY_VALUE=1741;exports2.ER_RPL_INFO_DATA_TOO_LONG=1742;exports2.ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE=1743;exports2.ER_BINLOG_READ_EVENT_CHECKSUM_FAILURE=1744;exports2.ER_BINLOG_STMT_CACHE_SIZE_GREATER_THAN_MAX=1745;exports2.ER_CANT_UPDATE_TABLE_IN_CREATE_TABLE_SELECT=1746;exports2.ER_PARTITION_CLAUSE_ON_NONPARTITIONED=1747;exports2.ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET=1748;exports2.ER_NO_SUCH_PARTITION=1749;exports2.ER_CHANGE_RPL_INFO_REPOSITORY_FAILURE=1750;exports2.ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_CREATED_TEMP_TABLE=1751;exports2.ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_DROPPED_TEMP_TABLE=1752;exports2.ER_MTA_FEATURE_IS_NOT_SUPPORTED=1753;exports2.ER_MTA_UPDATED_DBS_GREATER_MAX=1754;exports2.ER_MTA_CANT_PARALLEL=1755;exports2.ER_MTA_INCONSISTENT_DATA=1756;exports2.ER_FULLTEXT_NOT_SUPPORTED_WITH_PARTITIONING=1757;exports2.ER_DA_INVALID_CONDITION_NUMBER=1758;exports2.ER_INSECURE_PLAIN_TEXT=1759;exports2.ER_INSECURE_CHANGE_SOURCE=1760;exports2.ER_FOREIGN_DUPLICATE_KEY_WITH_CHILD_INFO=1761;exports2.ER_FOREIGN_DUPLICATE_KEY_WITHOUT_CHILD_INFO=1762;exports2.ER_SQLTHREAD_WITH_SECURE_REPLICA=1763;exports2.ER_TABLE_HAS_NO_FT=1764;exports2.ER_VARIABLE_NOT_SETTABLE_IN_SF_OR_TRIGGER=1765;exports2.ER_VARIABLE_NOT_SETTABLE_IN_TRANSACTION=1766;exports2.ER_GTID_NEXT_IS_NOT_IN_GTID_NEXT_LIST=1767;exports2.ER_CANT_CHANGE_GTID_NEXT_IN_TRANSACTION=1768;exports2.ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION=1769;exports2.ER_GTID_NEXT_CANT_BE_AUTOMATIC_IF_GTID_NEXT_LIST_IS_NON_NULL=1770;exports2.ER_SKIPPING_LOGGED_TRANSACTION=1771;exports2.ER_MALFORMED_GTID_SET_SPECIFICATION=1772;exports2.ER_MALFORMED_GTID_SET_ENCODING=1773;exports2.ER_MALFORMED_GTID_SPECIFICATION=1774;exports2.ER_GNO_EXHAUSTED=1775;exports2.ER_BAD_REPLICA_AUTO_POSITION=1776;exports2.ER_AUTO_POSITION_REQUIRES_GTID_MODE_NOT_OFF=1777;exports2.ER_CANT_DO_IMPLICIT_COMMIT_IN_TRX_WHEN_GTID_NEXT_IS_SET=1778;exports2.ER_GTID_MODE_ON_REQUIRES_ENFORCE_GTID_CONSISTENCY_ON=1779;exports2.ER_GTID_MODE_REQUIRES_BINLOG=1780;exports2.ER_CANT_SET_GTID_NEXT_TO_GTID_WHEN_GTID_MODE_IS_OFF=1781;exports2.ER_CANT_SET_GTID_NEXT_TO_ANONYMOUS_WHEN_GTID_MODE_IS_ON=1782;exports2.ER_CANT_SET_GTID_NEXT_LIST_TO_NON_NULL_WHEN_GTID_MODE_IS_OFF=1783;exports2.ER_FOUND_GTID_EVENT_WHEN_GTID_MODE_IS_OFF=1784;exports2.ER_GTID_UNSAFE_NON_TRANSACTIONAL_TABLE=1785;exports2.ER_GTID_UNSAFE_CREATE_SELECT=1786;exports2.ER_GTID_UNSAFE_CREATE_DROP_TEMP_TABLE_IN_TRANSACTION=1787;exports2.ER_GTID_MODE_CAN_ONLY_CHANGE_ONE_STEP_AT_A_TIME=1788;exports2.ER_SOURCE_HAS_PURGED_REQUIRED_GTIDS=1789;exports2.ER_CANT_SET_GTID_NEXT_WHEN_OWNING_GTID=1790;exports2.ER_UNKNOWN_EXPLAIN_FORMAT=1791;exports2.ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION=1792;exports2.ER_TOO_LONG_TABLE_PARTITION_COMMENT=1793;exports2.ER_REPLICA_CONFIGURATION=1794;exports2.ER_INNODB_FT_LIMIT=1795;exports2.ER_INNODB_NO_FT_TEMP_TABLE=1796;exports2.ER_INNODB_FT_WRONG_DOCID_COLUMN=1797;exports2.ER_INNODB_FT_WRONG_DOCID_INDEX=1798;exports2.ER_INNODB_ONLINE_LOG_TOO_BIG=1799;exports2.ER_UNKNOWN_ALTER_ALGORITHM=1800;exports2.ER_UNKNOWN_ALTER_LOCK=1801;exports2.ER_MTA_CHANGE_SOURCE_CANT_RUN_WITH_GAPS=1802;exports2.ER_MTA_RECOVERY_FAILURE=1803;exports2.ER_MTA_RESET_WORKERS=1804;exports2.ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2=1805;exports2.ER_REPLICA_SILENT_RETRY_TRANSACTION=1806;exports2.ER_DISCARD_FK_CHECKS_RUNNING=1807;exports2.ER_TABLE_SCHEMA_MISMATCH=1808;exports2.ER_TABLE_IN_SYSTEM_TABLESPACE=1809;exports2.ER_IO_READ_ERROR=1810;exports2.ER_IO_WRITE_ERROR=1811;exports2.ER_TABLESPACE_MISSING=1812;exports2.ER_TABLESPACE_EXISTS=1813;exports2.ER_TABLESPACE_DISCARDED=1814;exports2.ER_INTERNAL_ERROR=1815;exports2.ER_INNODB_IMPORT_ERROR=1816;exports2.ER_INNODB_INDEX_CORRUPT=1817;exports2.ER_INVALID_YEAR_COLUMN_LENGTH=1818;exports2.ER_NOT_VALID_PASSWORD=1819;exports2.ER_MUST_CHANGE_PASSWORD=1820;exports2.ER_FK_NO_INDEX_CHILD=1821;exports2.ER_FK_NO_INDEX_PARENT=1822;exports2.ER_FK_FAIL_ADD_SYSTEM=1823;exports2.ER_FK_CANNOT_OPEN_PARENT=1824;exports2.ER_FK_INCORRECT_OPTION=1825;exports2.ER_FK_DUP_NAME=1826;exports2.ER_PASSWORD_FORMAT=1827;exports2.ER_FK_COLUMN_CANNOT_DROP=1828;exports2.ER_FK_COLUMN_CANNOT_DROP_CHILD=1829;exports2.ER_FK_COLUMN_NOT_NULL=1830;exports2.ER_DUP_INDEX=1831;exports2.ER_FK_COLUMN_CANNOT_CHANGE=1832;exports2.ER_FK_COLUMN_CANNOT_CHANGE_CHILD=1833;exports2.ER_UNUSED5=1834;exports2.ER_MALFORMED_PACKET=1835;exports2.ER_READ_ONLY_MODE=1836;exports2.ER_GTID_NEXT_TYPE_UNDEFINED_GTID=1837;exports2.ER_VARIABLE_NOT_SETTABLE_IN_SP=1838;exports2.ER_CANT_SET_GTID_PURGED_WHEN_GTID_MODE_IS_OFF=1839;exports2.ER_CANT_SET_GTID_PURGED_WHEN_GTID_EXECUTED_IS_NOT_EMPTY=1840;exports2.ER_CANT_SET_GTID_PURGED_WHEN_OWNED_GTIDS_IS_NOT_EMPTY=1841;exports2.ER_GTID_PURGED_WAS_CHANGED=1842;exports2.ER_GTID_EXECUTED_WAS_CHANGED=1843;exports2.ER_BINLOG_STMT_MODE_AND_NO_REPL_TABLES=1844;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED=1845;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON=1846;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COPY=1847;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_PARTITION=1848;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_RENAME=1849;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE=1850;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_CHECK=1851;exports2.ER_UNUSED6=1852;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOPK=1853;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_AUTOINC=1854;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_HIDDEN_FTS=1855;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_CHANGE_FTS=1856;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FTS=1857;exports2.ER_SQL_REPLICA_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE=1858;exports2.ER_DUP_UNKNOWN_IN_INDEX=1859;exports2.ER_IDENT_CAUSES_TOO_LONG_PATH=1860;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOT_NULL=1861;exports2.ER_MUST_CHANGE_PASSWORD_LOGIN=1862;exports2.ER_ROW_IN_WRONG_PARTITION=1863;exports2.ER_MTA_EVENT_BIGGER_PENDING_JOBS_SIZE_MAX=1864;exports2.ER_INNODB_NO_FT_USES_PARSER=1865;exports2.ER_BINLOG_LOGICAL_CORRUPTION=1866;exports2.ER_WARN_PURGE_LOG_IN_USE=1867;exports2.ER_WARN_PURGE_LOG_IS_ACTIVE=1868;exports2.ER_AUTO_INCREMENT_CONFLICT=1869;exports2.WARN_ON_BLOCKHOLE_IN_RBR=1870;exports2.ER_REPLICA_CM_INIT_REPOSITORY=1871;exports2.ER_REPLICA_AM_INIT_REPOSITORY=1872;exports2.ER_ACCESS_DENIED_CHANGE_USER_ERROR=1873;exports2.ER_INNODB_READ_ONLY=1874;exports2.ER_STOP_REPLICA_SQL_THREAD_TIMEOUT=1875;exports2.ER_STOP_REPLICA_IO_THREAD_TIMEOUT=1876;exports2.ER_TABLE_CORRUPT=1877;exports2.ER_TEMP_FILE_WRITE_FAILURE=1878;exports2.ER_INNODB_FT_AUX_NOT_HEX_ID=1879;exports2.ER_OLD_TEMPORALS_UPGRADED=1880;exports2.ER_INNODB_FORCED_RECOVERY=1881;exports2.ER_AES_INVALID_IV=1882;exports2.ER_PLUGIN_CANNOT_BE_UNINSTALLED=1883;exports2.ER_GTID_UNSAFE_BINLOG_SPLITTABLE_STATEMENT_AND_ASSIGNED_GTID=1884;exports2.ER_REPLICA_HAS_MORE_GTIDS_THAN_SOURCE=1885;exports2.ER_MISSING_KEY=1886;exports2.WARN_NAMED_PIPE_ACCESS_EVERYONE=1887;exports2.ER_FILE_CORRUPT=3e3;exports2.ER_ERROR_ON_SOURCE=3001;exports2.ER_INCONSISTENT_ERROR=3002;exports2.ER_STORAGE_ENGINE_NOT_LOADED=3003;exports2.ER_GET_STACKED_DA_WITHOUT_ACTIVE_HANDLER=3004;exports2.ER_WARN_LEGACY_SYNTAX_CONVERTED=3005;exports2.ER_BINLOG_UNSAFE_FULLTEXT_PLUGIN=3006;exports2.ER_CANNOT_DISCARD_TEMPORARY_TABLE=3007;exports2.ER_FK_DEPTH_EXCEEDED=3008;exports2.ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE_V2=3009;exports2.ER_WARN_TRIGGER_DOESNT_HAVE_CREATED=3010;exports2.ER_REFERENCED_TRG_DOES_NOT_EXIST=3011;exports2.ER_EXPLAIN_NOT_SUPPORTED=3012;exports2.ER_INVALID_FIELD_SIZE=3013;exports2.ER_MISSING_HA_CREATE_OPTION=3014;exports2.ER_ENGINE_OUT_OF_MEMORY=3015;exports2.ER_PASSWORD_EXPIRE_ANONYMOUS_USER=3016;exports2.ER_REPLICA_SQL_THREAD_MUST_STOP=3017;exports2.ER_NO_FT_MATERIALIZED_SUBQUERY=3018;exports2.ER_INNODB_UNDO_LOG_FULL=3019;exports2.ER_INVALID_ARGUMENT_FOR_LOGARITHM=3020;exports2.ER_REPLICA_CHANNEL_IO_THREAD_MUST_STOP=3021;exports2.ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO=3022;exports2.ER_WARN_ONLY_SOURCE_LOG_FILE_NO_POS=3023;exports2.ER_QUERY_TIMEOUT=3024;exports2.ER_NON_RO_SELECT_DISABLE_TIMER=3025;exports2.ER_DUP_LIST_ENTRY=3026;exports2.ER_SQL_MODE_NO_EFFECT=3027;exports2.ER_AGGREGATE_ORDER_FOR_UNION=3028;exports2.ER_AGGREGATE_ORDER_NON_AGG_QUERY=3029;exports2.ER_REPLICA_WORKER_STOPPED_PREVIOUS_THD_ERROR=3030;exports2.ER_DONT_SUPPORT_REPLICA_PRESERVE_COMMIT_ORDER=3031;exports2.ER_SERVER_OFFLINE_MODE=3032;exports2.ER_GIS_DIFFERENT_SRIDS=3033;exports2.ER_GIS_UNSUPPORTED_ARGUMENT=3034;exports2.ER_GIS_UNKNOWN_ERROR=3035;exports2.ER_GIS_UNKNOWN_EXCEPTION=3036;exports2.ER_GIS_INVALID_DATA=3037;exports2.ER_BOOST_GEOMETRY_EMPTY_INPUT_EXCEPTION=3038;exports2.ER_BOOST_GEOMETRY_CENTROID_EXCEPTION=3039;exports2.ER_BOOST_GEOMETRY_OVERLAY_INVALID_INPUT_EXCEPTION=3040;exports2.ER_BOOST_GEOMETRY_TURN_INFO_EXCEPTION=3041;exports2.ER_BOOST_GEOMETRY_SELF_INTERSECTION_POINT_EXCEPTION=3042;exports2.ER_BOOST_GEOMETRY_UNKNOWN_EXCEPTION=3043;exports2.ER_STD_BAD_ALLOC_ERROR=3044;exports2.ER_STD_DOMAIN_ERROR=3045;exports2.ER_STD_LENGTH_ERROR=3046;exports2.ER_STD_INVALID_ARGUMENT=3047;exports2.ER_STD_OUT_OF_RANGE_ERROR=3048;exports2.ER_STD_OVERFLOW_ERROR=3049;exports2.ER_STD_RANGE_ERROR=3050;exports2.ER_STD_UNDERFLOW_ERROR=3051;exports2.ER_STD_LOGIC_ERROR=3052;exports2.ER_STD_RUNTIME_ERROR=3053;exports2.ER_STD_UNKNOWN_EXCEPTION=3054;exports2.ER_GIS_DATA_WRONG_ENDIANESS=3055;exports2.ER_CHANGE_SOURCE_PASSWORD_LENGTH=3056;exports2.ER_USER_LOCK_WRONG_NAME=3057;exports2.ER_USER_LOCK_DEADLOCK=3058;exports2.ER_REPLACE_INACCESSIBLE_ROWS=3059;exports2.ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_GIS=3060;exports2.ER_ILLEGAL_USER_VAR=3061;exports2.ER_GTID_MODE_OFF=3062;exports2.ER_UNSUPPORTED_BY_REPLICATION_THREAD=3063;exports2.ER_INCORRECT_TYPE=3064;exports2.ER_FIELD_IN_ORDER_NOT_SELECT=3065;exports2.ER_AGGREGATE_IN_ORDER_NOT_SELECT=3066;exports2.ER_INVALID_RPL_WILD_TABLE_FILTER_PATTERN=3067;exports2.ER_NET_OK_PACKET_TOO_LARGE=3068;exports2.ER_INVALID_JSON_DATA=3069;exports2.ER_INVALID_GEOJSON_MISSING_MEMBER=3070;exports2.ER_INVALID_GEOJSON_WRONG_TYPE=3071;exports2.ER_INVALID_GEOJSON_UNSPECIFIED=3072;exports2.ER_DIMENSION_UNSUPPORTED=3073;exports2.ER_REPLICA_CHANNEL_DOES_NOT_EXIST=3074;exports2.ER_SLAVE_MULTIPLE_CHANNELS_HOST_PORT=3075;exports2.ER_REPLICA_CHANNEL_NAME_INVALID_OR_TOO_LONG=3076;exports2.ER_REPLICA_NEW_CHANNEL_WRONG_REPOSITORY=3077;exports2.ER_SLAVE_CHANNEL_DELETE=3078;exports2.ER_REPLICA_MULTIPLE_CHANNELS_CMD=3079;exports2.ER_REPLICA_MAX_CHANNELS_EXCEEDED=3080;exports2.ER_REPLICA_CHANNEL_MUST_STOP=3081;exports2.ER_REPLICA_CHANNEL_NOT_RUNNING=3082;exports2.ER_REPLICA_CHANNEL_WAS_RUNNING=3083;exports2.ER_REPLICA_CHANNEL_WAS_NOT_RUNNING=3084;exports2.ER_REPLICA_CHANNEL_SQL_THREAD_MUST_STOP=3085;exports2.ER_REPLICA_CHANNEL_SQL_SKIP_COUNTER=3086;exports2.ER_WRONG_FIELD_WITH_GROUP_V2=3087;exports2.ER_MIX_OF_GROUP_FUNC_AND_FIELDS_V2=3088;exports2.ER_WARN_DEPRECATED_SYSVAR_UPDATE=3089;exports2.ER_WARN_DEPRECATED_SQLMODE=3090;exports2.ER_CANNOT_LOG_PARTIAL_DROP_DATABASE_WITH_GTID=3091;exports2.ER_GROUP_REPLICATION_CONFIGURATION=3092;exports2.ER_GROUP_REPLICATION_RUNNING=3093;exports2.ER_GROUP_REPLICATION_APPLIER_INIT_ERROR=3094;exports2.ER_GROUP_REPLICATION_STOP_APPLIER_THREAD_TIMEOUT=3095;exports2.ER_GROUP_REPLICATION_COMMUNICATION_LAYER_SESSION_ERROR=3096;exports2.ER_GROUP_REPLICATION_COMMUNICATION_LAYER_JOIN_ERROR=3097;exports2.ER_BEFORE_DML_VALIDATION_ERROR=3098;exports2.ER_PREVENTS_VARIABLE_WITHOUT_RBR=3099;exports2.ER_RUN_HOOK_ERROR=3100;exports2.ER_TRANSACTION_ROLLBACK_DURING_COMMIT=3101;exports2.ER_GENERATED_COLUMN_FUNCTION_IS_NOT_ALLOWED=3102;exports2.ER_UNSUPPORTED_ALTER_INPLACE_ON_VIRTUAL_COLUMN=3103;exports2.ER_WRONG_FK_OPTION_FOR_GENERATED_COLUMN=3104;exports2.ER_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN=3105;exports2.ER_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN=3106;exports2.ER_GENERATED_COLUMN_NON_PRIOR=3107;exports2.ER_DEPENDENT_BY_GENERATED_COLUMN=3108;exports2.ER_GENERATED_COLUMN_REF_AUTO_INC=3109;exports2.ER_FEATURE_NOT_AVAILABLE=3110;exports2.ER_CANT_SET_GTID_MODE=3111;exports2.ER_CANT_USE_AUTO_POSITION_WITH_GTID_MODE_OFF=3112;exports2.ER_CANT_REPLICATE_ANONYMOUS_WITH_AUTO_POSITION=3113;exports2.ER_CANT_REPLICATE_ANONYMOUS_WITH_GTID_MODE_ON=3114;exports2.ER_CANT_REPLICATE_GTID_WITH_GTID_MODE_OFF=3115;exports2.ER_CANT_ENFORCE_GTID_CONSISTENCY_WITH_ONGOING_GTID_VIOLATING_TX=3116;exports2.ER_ENFORCE_GTID_CONSISTENCY_WARN_WITH_ONGOING_GTID_VIOLATING_TX=3117;exports2.ER_ACCOUNT_HAS_BEEN_LOCKED=3118;exports2.ER_WRONG_TABLESPACE_NAME=3119;exports2.ER_TABLESPACE_IS_NOT_EMPTY=3120;exports2.ER_WRONG_FILE_NAME=3121;exports2.ER_BOOST_GEOMETRY_INCONSISTENT_TURNS_EXCEPTION=3122;exports2.ER_WARN_OPTIMIZER_HINT_SYNTAX_ERROR=3123;exports2.ER_WARN_BAD_MAX_EXECUTION_TIME=3124;exports2.ER_WARN_UNSUPPORTED_MAX_EXECUTION_TIME=3125;exports2.ER_WARN_CONFLICTING_HINT=3126;exports2.ER_WARN_UNKNOWN_QB_NAME=3127;exports2.ER_UNRESOLVED_HINT_NAME=3128;exports2.ER_WARN_ON_MODIFYING_GTID_EXECUTED_TABLE=3129;exports2.ER_PLUGGABLE_PROTOCOL_COMMAND_NOT_SUPPORTED=3130;exports2.ER_LOCKING_SERVICE_WRONG_NAME=3131;exports2.ER_LOCKING_SERVICE_DEADLOCK=3132;exports2.ER_LOCKING_SERVICE_TIMEOUT=3133;exports2.ER_GIS_MAX_POINTS_IN_GEOMETRY_OVERFLOWED=3134;exports2.ER_SQL_MODE_MERGED=3135;exports2.ER_VTOKEN_PLUGIN_TOKEN_MISMATCH=3136;exports2.ER_VTOKEN_PLUGIN_TOKEN_NOT_FOUND=3137;exports2.ER_CANT_SET_VARIABLE_WHEN_OWNING_GTID=3138;exports2.ER_REPLICA_CHANNEL_OPERATION_NOT_ALLOWED=3139;exports2.ER_INVALID_JSON_TEXT=3140;exports2.ER_INVALID_JSON_TEXT_IN_PARAM=3141;exports2.ER_INVALID_JSON_BINARY_DATA=3142;exports2.ER_INVALID_JSON_PATH=3143;exports2.ER_INVALID_JSON_CHARSET=3144;exports2.ER_INVALID_JSON_CHARSET_IN_FUNCTION=3145;exports2.ER_INVALID_TYPE_FOR_JSON=3146;exports2.ER_INVALID_CAST_TO_JSON=3147;exports2.ER_INVALID_JSON_PATH_CHARSET=3148;exports2.ER_INVALID_JSON_PATH_WILDCARD=3149;exports2.ER_JSON_VALUE_TOO_BIG=3150;exports2.ER_JSON_KEY_TOO_BIG=3151;exports2.ER_JSON_USED_AS_KEY=3152;exports2.ER_JSON_VACUOUS_PATH=3153;exports2.ER_JSON_BAD_ONE_OR_ALL_ARG=3154;exports2.ER_NUMERIC_JSON_VALUE_OUT_OF_RANGE=3155;exports2.ER_INVALID_JSON_VALUE_FOR_CAST=3156;exports2.ER_JSON_DOCUMENT_TOO_DEEP=3157;exports2.ER_JSON_DOCUMENT_NULL_KEY=3158;exports2.ER_SECURE_TRANSPORT_REQUIRED=3159;exports2.ER_NO_SECURE_TRANSPORTS_CONFIGURED=3160;exports2.ER_DISABLED_STORAGE_ENGINE=3161;exports2.ER_USER_DOES_NOT_EXIST=3162;exports2.ER_USER_ALREADY_EXISTS=3163;exports2.ER_AUDIT_API_ABORT=3164;exports2.ER_INVALID_JSON_PATH_ARRAY_CELL=3165;exports2.ER_BUFPOOL_RESIZE_INPROGRESS=3166;exports2.ER_FEATURE_DISABLED_SEE_DOC=3167;exports2.ER_SERVER_ISNT_AVAILABLE=3168;exports2.ER_SESSION_WAS_KILLED=3169;exports2.ER_CAPACITY_EXCEEDED=3170;exports2.ER_CAPACITY_EXCEEDED_IN_RANGE_OPTIMIZER=3171;exports2.ER_TABLE_NEEDS_UPG_PART=3172;exports2.ER_CANT_WAIT_FOR_EXECUTED_GTID_SET_WHILE_OWNING_A_GTID=3173;exports2.ER_CANNOT_ADD_FOREIGN_BASE_COL_VIRTUAL=3174;exports2.ER_CANNOT_CREATE_VIRTUAL_INDEX_CONSTRAINT=3175;exports2.ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE=3176;exports2.ER_LOCK_REFUSED_BY_ENGINE=3177;exports2.ER_UNSUPPORTED_ALTER_ONLINE_ON_VIRTUAL_COLUMN=3178;exports2.ER_MASTER_KEY_ROTATION_NOT_SUPPORTED_BY_SE=3179;exports2.ER_MASTER_KEY_ROTATION_ERROR_BY_SE=3180;exports2.ER_MASTER_KEY_ROTATION_BINLOG_FAILED=3181;exports2.ER_MASTER_KEY_ROTATION_SE_UNAVAILABLE=3182;exports2.ER_TABLESPACE_CANNOT_ENCRYPT=3183;exports2.ER_INVALID_ENCRYPTION_OPTION=3184;exports2.ER_CANNOT_FIND_KEY_IN_KEYRING=3185;exports2.ER_CAPACITY_EXCEEDED_IN_PARSER=3186;exports2.ER_UNSUPPORTED_ALTER_ENCRYPTION_INPLACE=3187;exports2.ER_KEYRING_UDF_KEYRING_SERVICE_ERROR=3188;exports2.ER_USER_COLUMN_OLD_LENGTH=3189;exports2.ER_CANT_RESET_SOURCE=3190;exports2.ER_GROUP_REPLICATION_MAX_GROUP_SIZE=3191;exports2.ER_CANNOT_ADD_FOREIGN_BASE_COL_STORED=3192;exports2.ER_TABLE_REFERENCED=3193;exports2.ER_PARTITION_ENGINE_DEPRECATED_FOR_TABLE=3194;exports2.ER_WARN_USING_GEOMFROMWKB_TO_SET_SRID_ZERO=3195;exports2.ER_WARN_USING_GEOMFROMWKB_TO_SET_SRID=3196;exports2.ER_XA_RETRY=3197;exports2.ER_KEYRING_AWS_UDF_AWS_KMS_ERROR=3198;exports2.ER_BINLOG_UNSAFE_XA=3199;exports2.ER_UDF_ERROR=3200;exports2.ER_KEYRING_MIGRATION_FAILURE=3201;exports2.ER_KEYRING_ACCESS_DENIED_ERROR=3202;exports2.ER_KEYRING_MIGRATION_STATUS=3203;exports2.ER_PLUGIN_FAILED_TO_OPEN_TABLES=3204;exports2.ER_PLUGIN_FAILED_TO_OPEN_TABLE=3205;exports2.ER_AUDIT_LOG_NO_KEYRING_PLUGIN_INSTALLED=3206;exports2.ER_AUDIT_LOG_ENCRYPTION_PASSWORD_HAS_NOT_BEEN_SET=3207;exports2.ER_AUDIT_LOG_COULD_NOT_CREATE_AES_KEY=3208;exports2.ER_AUDIT_LOG_ENCRYPTION_PASSWORD_CANNOT_BE_FETCHED=3209;exports2.ER_AUDIT_LOG_JSON_FILTERING_NOT_ENABLED=3210;exports2.ER_AUDIT_LOG_UDF_INSUFFICIENT_PRIVILEGE=3211;exports2.ER_AUDIT_LOG_SUPER_PRIVILEGE_REQUIRED=3212;exports2.ER_COULD_NOT_REINITIALIZE_AUDIT_LOG_FILTERS=3213;exports2.ER_AUDIT_LOG_UDF_INVALID_ARGUMENT_TYPE=3214;exports2.ER_AUDIT_LOG_UDF_INVALID_ARGUMENT_COUNT=3215;exports2.ER_AUDIT_LOG_HAS_NOT_BEEN_INSTALLED=3216;exports2.ER_AUDIT_LOG_UDF_READ_INVALID_MAX_ARRAY_LENGTH_ARG_TYPE=3217;exports2.ER_AUDIT_LOG_UDF_READ_INVALID_MAX_ARRAY_LENGTH_ARG_VALUE=3218;exports2.ER_AUDIT_LOG_JSON_FILTER_PARSING_ERROR=3219;exports2.ER_AUDIT_LOG_JSON_FILTER_NAME_CANNOT_BE_EMPTY=3220;exports2.ER_AUDIT_LOG_JSON_USER_NAME_CANNOT_BE_EMPTY=3221;exports2.ER_AUDIT_LOG_JSON_FILTER_DOES_NOT_EXISTS=3222;exports2.ER_AUDIT_LOG_USER_FIRST_CHARACTER_MUST_BE_ALPHANUMERIC=3223;exports2.ER_AUDIT_LOG_USER_NAME_INVALID_CHARACTER=3224;exports2.ER_AUDIT_LOG_HOST_NAME_INVALID_CHARACTER=3225;exports2.WARN_DEPRECATED_MAXDB_SQL_MODE_FOR_TIMESTAMP=3226;exports2.ER_XA_REPLICATION_FILTERS=3227;exports2.ER_CANT_OPEN_ERROR_LOG=3228;exports2.ER_GROUPING_ON_TIMESTAMP_IN_DST=3229;exports2.ER_CANT_START_SERVER_NAMED_PIPE=3230;exports2.ER_WRITE_SET_EXCEEDS_LIMIT=3231;exports2.ER_DEPRECATED_TLS_VERSION_SESSION_57=3232;exports2.ER_WARN_DEPRECATED_TLS_VERSION_57=3233;exports2.ER_WARN_WRONG_NATIVE_TABLE_STRUCTURE=3234;exports2.ER_AES_INVALID_KDF_NAME=3235;exports2.ER_AES_INVALID_KDF_ITERATIONS=3236;exports2.WARN_AES_KEY_SIZE=3237;exports2.ER_AES_INVALID_KDF_OPTION_SIZE=3238;exports2.ER_UNSUPPORT_COMPRESSED_TEMPORARY_TABLE=3500;exports2.ER_ACL_OPERATION_FAILED=3501;exports2.ER_UNSUPPORTED_INDEX_ALGORITHM=3502;exports2.ER_NO_SUCH_DB=3503;exports2.ER_TOO_BIG_ENUM=3504;exports2.ER_TOO_LONG_SET_ENUM_VALUE=3505;exports2.ER_INVALID_DD_OBJECT=3506;exports2.ER_UPDATING_DD_TABLE=3507;exports2.ER_INVALID_DD_OBJECT_ID=3508;exports2.ER_INVALID_DD_OBJECT_NAME=3509;exports2.ER_TABLESPACE_MISSING_WITH_NAME=3510;exports2.ER_TOO_LONG_ROUTINE_COMMENT=3511;exports2.ER_SP_LOAD_FAILED=3512;exports2.ER_INVALID_BITWISE_OPERANDS_SIZE=3513;exports2.ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE=3514;exports2.ER_WARN_UNSUPPORTED_HINT=3515;exports2.ER_UNEXPECTED_GEOMETRY_TYPE=3516;exports2.ER_SRS_PARSE_ERROR=3517;exports2.ER_SRS_PROJ_PARAMETER_MISSING=3518;exports2.ER_WARN_SRS_NOT_FOUND=3519;exports2.ER_SRS_NOT_CARTESIAN=3520;exports2.ER_SRS_NOT_CARTESIAN_UNDEFINED=3521;exports2.ER_PK_INDEX_CANT_BE_INVISIBLE=3522;exports2.ER_UNKNOWN_AUTHID=3523;exports2.ER_FAILED_ROLE_GRANT=3524;exports2.ER_OPEN_ROLE_TABLES=3525;exports2.ER_FAILED_DEFAULT_ROLES=3526;exports2.ER_COMPONENTS_NO_SCHEME=3527;exports2.ER_COMPONENTS_NO_SCHEME_SERVICE=3528;exports2.ER_COMPONENTS_CANT_LOAD=3529;exports2.ER_ROLE_NOT_GRANTED=3530;exports2.ER_FAILED_REVOKE_ROLE=3531;exports2.ER_RENAME_R